/*
 * Decompiled with CFR 0.152.
 */
package DMXDevicePackage;

import DMXDevicePackage.DMXDevice;
import DMXDevicePackage.DMXDeviceFilter;
import DMXMixer.DMXControlComponent;
import DMXMixer.DMXControlDescription;
import DMXVirtualPackage.DMXFadeDescription;
import FileToolPackage.FileTools;
import GUID.LiveGUID;
import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LanguageTools.LiveLanguagePackage.LiveLanguageString;
import LiveShowControlModels.ControlFunctionModel;
import LiveShowObjectPackage.LiveShowProjectDescription;
import LiveShowObjectPackage.SinglePropertyChangeSupport;
import StartPackage.LiveShowDMXSystem;
import SwingFramePackage.JOptionDialog;
import ToolsGraphics.ImagesTools;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.beans.IndexedPropertyChangeEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Externalizable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DMXDeviceType
implements PropertyChangeListener,
Externalizable,
DMXDeviceFilter.FilterInterface {
    public static final int SOFTWAREVERSION = 6;
    public static Icon s_Icon = new ImageIcon(DMXDeviceType.class.getResource("/IconsPackage/Device_Type.png"));
    public static final String FILESUFFIX = ".dvd";
    public static final String LIST_FILESUFFIX = ".lsd";
    public static final String PROP_DMXDEVICETYPE_ID = "dmxdeviceTypeID";
    public static final String PROP_DMXDEVICETYPE_SECTORCOUNT = "dmxdeviceTypeSectorCount";
    public static final String PROP_DMXDEVICETYP_INDEXED_DEVICESECTOR = "dmxdeviceTypeSector";
    public static final String PROP_DMXDEVICETYPE_DEVICECONTROLLINK = "dmxdeviceTypeDeviceControlLink";
    public static final String PROP_DMXDEVICETYPE_INDEXED_CHANNELCONTROLLINK = "dmxdevicechanneltypeChannelControlLink";
    public static final String PROP_DMXDEVICETYPE_MANUFACTUREERNAME = "dmxdeviceTypeManufactureerName";
    public static final String PROP_DMXDEVICETYPE_NAME = "dmxdeviceTypeName";
    public static final String PROP_DMXDEVICETYPE_REMARK = "dmxdeviceTypeRemark";
    public static final String PROP_DMXDEVICETYPE_IMAGE = "dmxdeviceTypeImage";
    public static final String PROP_DMXDEVICETYPE_CHANNELCOUNT = "dmxdeviceTypeChannelCount";
    public static final String PROP_DMXDEVICETYPE_INDEXED_DEVICECHANNELTYPE = "dmxdeviceTypeDeviceChannelType";
    public static final String PROP_DMXDEVICETYPE_INDEXED_WATTAGE = "dmxdeviceTypeSectorWattage";
    public static final String PROP_DMXDEVICETYPE_DMXCONTROLTYPE = "dmxdeviceTypeDMXControlType";
    public static final String PROP_DMXCONTROLNAME = "dmxcontrolName";
    public static final String PROP_CONTROLNAME = "controlName";
    public static final String PROP_CONTROLDIMENSIONNAME = "controlDimensionName";
    protected static DMXDeviceTypeTreeModel s_DMXDeviceTypeTreeModel = new DMXDeviceTypeTreeModel();
    protected static DMXDeviceTypeTreeCellRenderer s_DMXDeviceTypeTreeCellRenderer = new DMXDeviceTypeTreeCellRenderer();
    @LiveLanguageString
    public static String DEVICETYPE_NAME = "Device Type";
    @LiveLanguageString
    public static String DEVICETYPE_IMPORT = "Import Device Type";
    @LiveLanguageString
    public static String SECTORNAME = "DMX";
    @LiveLanguageString
    protected static String STRINGDMXDEVICEEXISTS_TITEL = "DMXDevice already exists";
    @LiveLanguageString
    protected static String STRINGDMXDEVICEEXISTS_EXISTS = "The DMXDevice already exists:";
    @LiveLanguageString
    protected static String STRINGDMXDEVICEEXISTS_OVERWRITE = "Do you want to replace it with the import:";
    @LiveLanguageString
    protected static String LAMP_ON = "Lamp On";
    @LiveLanguageString
    protected static String LAMP_OFF = "Lamp Off";
    @LiveLanguageString
    protected static String SHUTTER_OPEN = "Shutter Open";
    @LiveLanguageString
    protected static String COLOR_WHITE = "Color White";
    @LiveLanguageString
    protected static String COLOR_BLACK = "Color Black";
    @LiveLanguageString
    protected static String COLOR_RED = "Color Red";
    @LiveLanguageString
    protected static String COLOR_BLUE = "Color Blue";
    @LiveLanguageString
    protected static String COLOR_GREEN = "Color Green";
    @LiveLanguageString
    protected static String COLOR_CYAN = "Color Cyan";
    @LiveLanguageString
    protected static String COLOR_MAGENTA = "Color Magenta";
    @LiveLanguageString
    protected static String COLOR_YELLOW = "Color Yellow";
    private static DMXDeviceType s_LanguageInstance = new DMXDeviceType(true);
    public static final String FUNCTIONID_SETNULL = "SetNull";
    public static ControlFunctionModel.ControlFunctionType s_ControlFunctionType_Null = new ControlFunctionModel.ControlFunctionType("SetNull");
    public static final String FUNCTIONID_SETDEFAULT = "SetDefault";
    public static ControlFunctionModel.ControlFunctionType s_ControlFunctionType_Default = new ControlFunctionModel.ControlFunctionType("SetDefault");
    public static ControlFunctionModel.ControlFunctionType s_FunctionLampOn = new ControlFunctionModel.ControlFunctionType("Lamp_On", LAMP_ON, new ImageIcon(DMXDeviceType.class.getResource("/IconsPackage/Device_BulbOn.png")));
    public static ControlFunctionModel.ControlFunctionType s_FunctionLampOff = new ControlFunctionModel.ControlFunctionType("Lamp_Off", LAMP_OFF, new ImageIcon(DMXDeviceType.class.getResource("/IconsPackage/Device_BulbOff.png")));
    public static ControlFunctionModel.ControlFunctionType s_FunctionShutterOpen = new ControlFunctionModel.ControlFunctionType("Shutter_Open", SHUTTER_OPEN, new ImageIcon(DMXDeviceType.class.getResource("/IconsPackage/Device_ShutterOpen.png")));
    public static ControlFunctionModel.ControlFunctionType s_FunctionColorWhite = new ControlFunctionModel.ControlFunctionType("Color_White", COLOR_WHITE, new ImageIcon(DMXDeviceType.class.getResource("/IconsPackage/Color_White.png")));
    public static ControlFunctionModel.ControlFunctionType s_FunctionColorBlack = new ControlFunctionModel.ControlFunctionType("Color_Black", COLOR_BLACK, new ImageIcon(DMXDeviceType.class.getResource("/IconsPackage/Color_Black.png")));
    public static ControlFunctionModel.ControlFunctionType s_FunctionColorRed = new ControlFunctionModel.ControlFunctionType("Color_Red", COLOR_RED, new ImageIcon(DMXDeviceType.class.getResource("/IconsPackage/Color_Red.png")));
    public static ControlFunctionModel.ControlFunctionType s_FunctionColorGreen = new ControlFunctionModel.ControlFunctionType("Color_Green", COLOR_GREEN, new ImageIcon(DMXDeviceType.class.getResource("/IconsPackage/Color_Green.png")));
    public static ControlFunctionModel.ControlFunctionType s_FunctionColorBlue = new ControlFunctionModel.ControlFunctionType("Color_Blue", COLOR_BLUE, new ImageIcon(DMXDeviceType.class.getResource("/IconsPackage/Color_Blue.png")));
    public static ControlFunctionModel.ControlFunctionType s_FunctionColorCyan = new ControlFunctionModel.ControlFunctionType("Color_Cyan", COLOR_CYAN, new ImageIcon(DMXDeviceType.class.getResource("/IconsPackage/Color_Cyan.png")));
    public static ControlFunctionModel.ControlFunctionType s_FunctionColorMagenta = new ControlFunctionModel.ControlFunctionType("Color_Magenta", COLOR_MAGENTA, new ImageIcon(DMXDeviceType.class.getResource("/IconsPackage/Color_Magenta.png")));
    public static ControlFunctionModel.ControlFunctionType s_FunctionColorYellow = new ControlFunctionModel.ControlFunctionType("Color_Yellow", COLOR_YELLOW, new ImageIcon(DMXDeviceType.class.getResource("/IconsPackage/Color_Yellow.png")));
    public static Dimension MAXDEVICEIMAGESIZE = new Dimension(250, 250);
    public static int DEFAULT_IMAGELENGTH = 68;
    public static int MIN_IMAGELENGTH = 34;
    protected String m_ID;
    protected String m_ManufacturerName;
    protected String m_DeviceTypeName;
    protected String m_DMXModeName;
    protected StringBuilder m_StringBuilderName;
    protected final Object m_SyncStringBuilder = new Object();
    protected String m_Remark;
    protected String m_FileName;
    protected BufferedImage m_DeviceImage;
    protected ImageIcon m_DeviceImageIcon;
    protected Dimension m_DeviceIconDimension;
    protected int m_SoftwareVersionRead;
    protected ArrayList<DMXDeviceSector> m_DMXDeviceSectors;
    protected double m_PanMaxGrad;
    protected double m_TiltMaxGrad;
    protected ArrayList<DMXControlComponent.DMXControlType> m_DMXControlTypes;
    protected HashMap<String, ArrayList<DMXControlComponent.DMXControlType>> m_HashMapDMXControlTypes;
    protected SinglePropertyChangeSupport m_PropertyChangeSupport;
    protected DMXFadeDescription.DMXDeviceFadeDescription m_DefaultDMXDeviceFadeDescription;

    public static DMXDeviceType load(String p_SimpleFileName) {
        if (p_SimpleFileName == null) {
            return null;
        }
        if (p_SimpleFileName.length() <= 0) {
            return null;
        }
        DMXDeviceType o_DMXDeviceType = null;
        FileInputStream o_FileInputStream = null;
        ObjectInput o_ObjectInput = null;
        try {
            o_FileInputStream = new FileInputStream(LiveShowDMXSystem.getPathDeviceTypes() + "/" + p_SimpleFileName);
            o_ObjectInput = new ObjectInputStream(o_FileInputStream);
            o_DMXDeviceType = new DMXDeviceType();
            o_DMXDeviceType.readExternal(o_ObjectInput);
            o_DMXDeviceType.setFileName(p_SimpleFileName);
        }
        catch (Exception e) {
            o_DMXDeviceType = null;
        }
        try {
            if (o_ObjectInput != null) {
                o_ObjectInput.close();
            }
            if (o_FileInputStream != null) {
                o_FileInputStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return o_DMXDeviceType;
    }

    public static boolean save(DMXDeviceType p_DMXDeviceType, String p_SimpleFileName) {
        if (p_SimpleFileName == null) {
            return false;
        }
        if (p_SimpleFileName.length() <= 0) {
            return false;
        }
        if (p_DMXDeviceType == null) {
            return false;
        }
        p_DMXDeviceType.checkDMXChannelTypeHasDisabledDMXControls();
        FileOutputStream o_FileInputStream = null;
        ObjectOutputStream o_ObjectOutput = null;
        try {
            o_FileInputStream = new FileOutputStream(LiveShowDMXSystem.getPathDeviceTypes() + "/" + p_SimpleFileName);
            o_ObjectOutput = new ObjectOutputStream(o_FileInputStream);
            p_DMXDeviceType.writeExternal(o_ObjectOutput);
            p_DMXDeviceType.setFileName(p_SimpleFileName);
        }
        catch (Exception e) {
            return false;
        }
        try {
            if (o_ObjectOutput != null) {
                o_ObjectOutput.close();
            }
            if (o_FileInputStream != null) {
                o_FileInputStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public static void deleteFile(String p_DeviceTypeFileName) {
        if (p_DeviceTypeFileName == null) {
            return;
        }
        File o_File = new File(LiveShowDMXSystem.getPathDeviceTypes() + "/" + p_DeviceTypeFileName);
        if (o_File.exists()) {
            o_File.delete();
        }
    }

    public static boolean saveProjectDMXDeviceTypes(LiveShowProjectDescription p_LiveShowProjectDescription, ArrayList<DMXDevice> p_DMXDevices) {
        DMXDeviceType o_DMXDeviceType;
        DMXDevice o_DMXDevice;
        int intDevice;
        int intDeviceCount;
        if (p_LiveShowProjectDescription == null) {
            return false;
        }
        ArrayList<DMXDeviceType> o_DMXDeviceTypes = new ArrayList<DMXDeviceType>();
        if (p_DMXDevices == null) {
            intDeviceCount = DMXDevice.getDMXDeviceCount();
            for (intDevice = 0; intDevice < intDeviceCount; ++intDevice) {
                o_DMXDevice = DMXDevice.getDMXDevice(intDevice);
                if (o_DMXDevice == null || (o_DMXDeviceType = o_DMXDevice.getDMXDeviceType()) == null || o_DMXDeviceTypes.contains(o_DMXDeviceType)) continue;
                o_DMXDeviceTypes.add(o_DMXDeviceType);
            }
        } else {
            intDeviceCount = p_DMXDevices.size();
            for (intDevice = 0; intDevice < intDeviceCount; ++intDevice) {
                o_DMXDevice = p_DMXDevices.get(intDevice);
                if (o_DMXDevice == null || (o_DMXDeviceType = o_DMXDevice.getDMXDeviceType()) == null || o_DMXDeviceTypes.contains(o_DMXDeviceType)) continue;
                o_DMXDeviceTypes.add(o_DMXDeviceType);
            }
        }
        String stringFileName = p_LiveShowProjectDescription.getProjectPathName() + LIST_FILESUFFIX;
        try {
            File o_File = new File(stringFileName);
            if (o_File.exists()) {
                try {
                    o_File.delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            o_File.createNewFile();
            FileOutputStream o_FileOutputStream = new FileOutputStream(o_File);
            ObjectOutputStream o_ObjectOutput = new ObjectOutputStream(o_FileOutputStream);
            o_ObjectOutput.writeInt(6);
            int intDMXDeviceTypeCount = o_DMXDeviceTypes.size();
            o_ObjectOutput.writeInt(intDMXDeviceTypeCount);
            for (int intDeviceType = 0; intDeviceType < intDMXDeviceTypeCount; ++intDeviceType) {
                o_DMXDeviceType = (DMXDeviceType)o_DMXDeviceTypes.get(intDeviceType);
                if (o_DMXDeviceType == null) continue;
                o_DMXDeviceType.writeExternal(o_ObjectOutput);
            }
            o_ObjectOutput.close();
            o_FileOutputStream.close();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean deleteProjectDMXDeviceTypes(LiveShowProjectDescription p_LiveShowProjectDescription) {
        boolean boolSuccess = false;
        String stringFileName = p_LiveShowProjectDescription.getProjectPathName() + LIST_FILESUFFIX;
        File o_File = new File(stringFileName);
        if (o_File.exists()) {
            try {
                boolSuccess = o_File.delete();
            }
            catch (Exception e) {
                boolSuccess = false;
            }
        }
        return boolSuccess;
    }

    public static boolean loadProjectDMXDeviceTypes(LiveShowProjectDescription p_LiveShowProjectDescription) {
        if (p_LiveShowProjectDescription == null) {
            return false;
        }
        String stringFileName = p_LiveShowProjectDescription.getProjectPathName() + LIST_FILESUFFIX;
        return DMXDeviceType.importDMXDeviceTypes(stringFileName, false);
    }

    public static boolean importDMXDeviceTypes(String p_FileName, boolean p_Save) {
        File o_File;
        String stringPostfix;
        if (p_FileName == null) {
            return false;
        }
        try {
            stringPostfix = p_FileName.substring(p_FileName.length() - 4, p_FileName.length());
        }
        catch (Exception e) {
            return false;
        }
        if (stringPostfix.equals(".lsp") ? !(o_File = new File(p_FileName = p_FileName.substring(0, p_FileName.length() - 4) + LIST_FILESUFFIX)).exists() : !stringPostfix.equals(LIST_FILESUFFIX) && !stringPostfix.equals(FILESUFFIX)) {
            return false;
        }
        FileInputStream o_FileInputStream = null;
        ObjectInput o_ObjectInput = null;
        boolean boolSave = false;
        boolean boolImported = true;
        try {
            o_File = new File(p_FileName);
            if (!o_File.exists()) {
                return false;
            }
            o_FileInputStream = new FileInputStream(o_File);
            o_ObjectInput = new ObjectInputStream(o_FileInputStream);
            if (stringPostfix.equals(LIST_FILESUFFIX)) {
                int intSoftwareVersion = o_ObjectInput.readInt();
                int intDeviceTypeCount = o_ObjectInput.readInt();
                for (int intDeviceType = 0; intDeviceType < intDeviceTypeCount; ++intDeviceType) {
                    String stringDeviceTypeFileName_New;
                    boolSave = false;
                    DMXDeviceType o_DMXDeviceTypeNew = new DMXDeviceType();
                    o_DMXDeviceTypeNew.readExternal(o_ObjectInput);
                    DMXDeviceType o_DMXDeviceTypeExists = DMXDeviceType.getDMXDeviceTypeByID(o_DMXDeviceTypeNew.getID());
                    if (o_DMXDeviceTypeExists == null) {
                        o_DMXDeviceTypeExists = DMXDeviceType.getDMXDeviceTypeByName(o_DMXDeviceTypeNew.getManufactureerName(), o_DMXDeviceTypeNew.getTypeName());
                    }
                    if (o_DMXDeviceTypeExists != null) {
                        if (p_Save) {
                            boolSave = DMXDeviceType.checkOverwrite(o_DMXDeviceTypeExists, o_DMXDeviceTypeNew);
                        }
                        if (!boolSave) {
                            o_DMXDeviceTypeNew.close();
                            continue;
                        }
                        o_DMXDeviceTypeNew.setID(o_DMXDeviceTypeExists.getID());
                        DMXDeviceType.addDeviceType(o_DMXDeviceTypeNew);
                        String stringDeviceTypeFileName_Exists = o_DMXDeviceTypeExists.getFileName();
                        DMXDeviceType.deleteFile(stringDeviceTypeFileName_Exists);
                        stringDeviceTypeFileName_New = DMXDeviceType.calculateDeviceTypeFileName(o_DMXDeviceTypeNew);
                        if (stringDeviceTypeFileName_New == null) continue;
                        DMXDeviceType.save(o_DMXDeviceTypeNew, stringDeviceTypeFileName_New);
                        continue;
                    }
                    DMXDeviceType.addDeviceType(o_DMXDeviceTypeNew);
                    if (!p_Save || (stringDeviceTypeFileName_New = DMXDeviceType.calculateDeviceTypeFileName(o_DMXDeviceTypeNew)) == null) continue;
                    DMXDeviceType.save(o_DMXDeviceTypeNew, stringDeviceTypeFileName_New);
                }
            } else if (stringPostfix.equals(FILESUFFIX)) {
                DMXDeviceType o_DMXDeviceTypeNew = new DMXDeviceType();
                o_DMXDeviceTypeNew.readExternal(o_ObjectInput);
                DMXDeviceType o_DMXDeviceTypeExists = DMXDeviceType.getDMXDeviceTypeByID(o_DMXDeviceTypeNew.getID());
                if (o_DMXDeviceTypeExists == null) {
                    o_DMXDeviceTypeExists = DMXDeviceType.getDMXDeviceTypeByName(o_DMXDeviceTypeNew.getManufactureerName(), o_DMXDeviceTypeNew.getTypeName());
                }
                if (o_DMXDeviceTypeExists != null) {
                    if (p_Save) {
                        boolSave = DMXDeviceType.checkOverwrite(o_DMXDeviceTypeExists, o_DMXDeviceTypeNew);
                    }
                    if (!boolSave) {
                        o_DMXDeviceTypeNew.close();
                        boolImported = false;
                    } else {
                        o_DMXDeviceTypeNew.setID(o_DMXDeviceTypeExists.getID());
                        DMXDeviceType.addDeviceType(o_DMXDeviceTypeNew);
                        String stringDeviceTypeFileName_Exists = o_DMXDeviceTypeExists.getFileName();
                        DMXDeviceType.deleteFile(stringDeviceTypeFileName_Exists);
                        String stringDeviceTypeFileName_New = DMXDeviceType.calculateDeviceTypeFileName(o_DMXDeviceTypeNew);
                        if (stringDeviceTypeFileName_New != null) {
                            DMXDeviceType.save(o_DMXDeviceTypeNew, stringDeviceTypeFileName_New);
                        }
                    }
                } else {
                    String stringDeviceTypeFileName_New;
                    DMXDeviceType.addDeviceType(o_DMXDeviceTypeNew);
                    if (p_Save && (stringDeviceTypeFileName_New = DMXDeviceType.calculateDeviceTypeFileName(o_DMXDeviceTypeNew)) != null) {
                        DMXDeviceType.save(o_DMXDeviceTypeNew, stringDeviceTypeFileName_New);
                    }
                }
            }
            o_ObjectInput.close();
            o_FileInputStream.close();
        }
        catch (Exception e) {
            try {
                if (o_ObjectInput != null) {
                    o_ObjectInput.close();
                }
                if (o_FileInputStream != null) {
                    o_FileInputStream.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
        return boolImported;
    }

    public static boolean checkOverwrite(DMXDeviceType p_DMXDeviceTypeExists, DMXDeviceType p_DMXDeviceTypeNew) {
        boolean boolOverwrite = false;
        StringBuilder stringReplace = new StringBuilder();
        stringReplace.append("<html>");
        stringReplace.append(STRINGDMXDEVICEEXISTS_EXISTS);
        stringReplace.append("<br>");
        stringReplace.append("<b>");
        stringReplace.append(p_DMXDeviceTypeExists.getManufactureerName() + " " + p_DMXDeviceTypeExists.getTypeName());
        stringReplace.append("<br>");
        stringReplace.append(p_DMXDeviceTypeExists.getRemark());
        stringReplace.append("</b>");
        stringReplace.append("<br>");
        stringReplace.append(STRINGDMXDEVICEEXISTS_OVERWRITE);
        stringReplace.append("<br>");
        stringReplace.append("<b>");
        stringReplace.append(p_DMXDeviceTypeNew.getManufactureerName() + " " + p_DMXDeviceTypeNew.getTypeName());
        stringReplace.append("<br>");
        stringReplace.append(p_DMXDeviceTypeNew.getRemark());
        stringReplace.append("</b>");
        stringReplace.append("</html>");
        int intAnswer = JOptionDialog.showConfirmDialog(null, stringReplace.toString(), STRINGDMXDEVICEEXISTS_TITEL, 0, 1);
        if (intAnswer == 0) {
            boolOverwrite = true;
        }
        return boolOverwrite;
    }

    public static String calculateDeviceTypeName(DMXDeviceType p_DMXDeviceType) {
        if (p_DMXDeviceType == null) {
            return "";
        }
        StringBuilder o_StringBuilder = new StringBuilder();
        o_StringBuilder.append(FileTools.validateFileName(p_DMXDeviceType.getManufactureerName()));
        o_StringBuilder.append("_");
        o_StringBuilder.append(FileTools.validateFileName(p_DMXDeviceType.getTypeName()));
        if (p_DMXDeviceType.getDMXModeName() == null || p_DMXDeviceType.getDMXModeName().length() <= 0) {
            p_DMXDeviceType.setDMXModeName(String.valueOf(p_DMXDeviceType.getChannelCountAll()) + "CH");
        }
        o_StringBuilder.append("_");
        o_StringBuilder.append(FileTools.validateFileName(p_DMXDeviceType.getDMXModeName()));
        return o_StringBuilder.toString();
    }

    public static String calculateDeviceTypeFileName(DMXDeviceType p_DMXDeviceType) {
        if (p_DMXDeviceType == null) {
            return null;
        }
        StringBuilder o_StringBuilder = new StringBuilder();
        o_StringBuilder.append(DMXDeviceType.calculateDeviceTypeName(p_DMXDeviceType));
        if (o_StringBuilder.length() <= 0) {
            return null;
        }
        o_StringBuilder.append(FILESUFFIX);
        return o_StringBuilder.toString();
    }

    public DMXDeviceType(boolean p_OnlyLanguageLoad) {
        LiveLanguage.addLanguageListener((Object)this, null);
    }

    public DMXDeviceType() {
        this.initMembers();
    }

    private void initMembers() {
        this.m_ID = LiveGUID.getUID();
        this.m_DeviceTypeName = "";
        this.m_ManufacturerName = "";
        this.m_DMXModeName = "";
        this.m_Remark = "";
        this.m_FileName = "";
        this.m_StringBuilderName = new StringBuilder();
        this.m_PanMaxGrad = 0.0;
        this.m_TiltMaxGrad = 0.0;
        this.m_PropertyChangeSupport = new SinglePropertyChangeSupport(this);
        this.m_SoftwareVersionRead = 0;
        this.m_DMXDeviceSectors = new ArrayList();
        DMXDeviceSector o_DMXDeviceSector = new DMXDeviceSector(this, 0);
        this.addDMXDeviceSector(o_DMXDeviceSector);
        this.m_DMXControlTypes = new ArrayList();
        this.m_HashMapDMXControlTypes = new HashMap();
        this.m_DefaultDMXDeviceFadeDescription = new DMXFadeDescription.DMXDeviceFadeDescription(this);
        this.m_DeviceIconDimension = new Dimension(DEFAULT_IMAGELENGTH, DEFAULT_IMAGELENGTH);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(6);
        out.writeUTF(this.m_ID);
        out.writeUTF(this.m_ManufacturerName);
        out.writeUTF(this.m_DeviceTypeName);
        out.writeDouble(this.m_PanMaxGrad);
        out.writeDouble(this.m_TiltMaxGrad);
        out.writeInt(this.m_DMXDeviceSectors.size());
        for (int intSector = 0; intSector < this.m_DMXDeviceSectors.size(); ++intSector) {
            DMXDeviceSector o_DMXDeviceSector = this.getDMXDeviceSector(intSector);
            o_DMXDeviceSector.writeExternal(out);
        }
        out.writeInt(this.getDMXControlTypeCount());
        for (int intControl = 0; intControl < this.m_DMXControlTypes.size(); ++intControl) {
            DMXControlComponent.DMXControlType o_DMXControlType = this.m_DMXControlTypes.get(intControl);
            o_DMXControlType.writeExternal(out);
        }
        this.m_DefaultDMXDeviceFadeDescription.writeExternal(out);
        ImagesTools.writeImage(out, this.m_DeviceImage);
        out.writeInt(this.m_DeviceIconDimension.width);
        out.writeInt(this.m_DeviceIconDimension.height);
        out.writeBoolean(false);
        out.writeUTF(this.m_Remark);
        out.writeUTF(this.m_DMXModeName);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.m_SoftwareVersionRead = in.readInt();
        this.m_ID = in.readUTF();
        this.m_ManufacturerName = in.readUTF();
        this.m_DeviceTypeName = in.readUTF();
        if (this.m_SoftwareVersionRead >= 4) {
            this.m_PanMaxGrad = in.readDouble();
            this.m_TiltMaxGrad = in.readDouble();
        }
        int intSectorCount = in.readInt();
        DMXDeviceSector o_DMXDeviceSector = this.getDMXDeviceSector(0);
        this.removeDMXDeviceSector(o_DMXDeviceSector);
        for (int intSector = 0; intSector < intSectorCount; ++intSector) {
            o_DMXDeviceSector = new DMXDeviceSector(this, intSector);
            o_DMXDeviceSector.readExternal(in);
            this.addDMXDeviceSector(o_DMXDeviceSector);
        }
        int intDMXControlsCount = in.readInt();
        for (int intDMXControl = 0; intDMXControl < intDMXControlsCount; ++intDMXControl) {
            DMXControlComponent.DMXControlType o_DMXControlType = new DMXControlComponent.DMXControlType();
            o_DMXControlType.readExternal(in);
            this.addDMXControlType(o_DMXControlType);
        }
        this.m_DefaultDMXDeviceFadeDescription.setDMXDeviceType(this);
        this.m_DefaultDMXDeviceFadeDescription.readExternal(in);
        BufferedImage o_BufferedImage = ImagesTools.readBufferedImage(in);
        this.setDeviceImage(o_BufferedImage);
        if (this.m_SoftwareVersionRead >= 3) {
            int intWidth = in.readInt();
            int intHeight = in.readInt();
            this.setDeviceIconDimension(intWidth, intHeight);
        }
        this.checkDMXChannelTypeHasDisabledDMXControls();
        boolean boolExistsExtendedProperties = in.readBoolean();
        if (this.m_SoftwareVersionRead >= 5) {
            this.m_Remark = in.readUTF();
        }
        if (this.m_SoftwareVersionRead >= 6) {
            this.m_DMXModeName = in.readUTF();
        }
        if (this.m_DMXModeName.length() <= 0) {
            this.calculateDMXModeNameFromOldDeviceName();
        }
    }

    public long getDiskSpaceEstimated() {
        long longBytesCount = 0L;
        longBytesCount += 4L;
        longBytesCount += (long)(this.m_ID.length() * 2);
        longBytesCount += (long)(this.m_ManufacturerName.length() * 2);
        longBytesCount += (long)(this.m_DeviceTypeName.length() * 2);
        longBytesCount += 8L;
        longBytesCount += 8L;
        longBytesCount += 4L;
        for (int intSector = 0; intSector < this.m_DMXDeviceSectors.size(); ++intSector) {
            DMXDeviceSector o_DMXDeviceSector = this.getDMXDeviceSector(intSector);
            longBytesCount += o_DMXDeviceSector.getDiskSpaceEstimated();
        }
        longBytesCount += 4L;
        for (int intControl = 0; intControl < this.m_DMXControlTypes.size(); ++intControl) {
            DMXControlComponent.DMXControlType o_DMXControlType = this.m_DMXControlTypes.get(intControl);
            longBytesCount += o_DMXControlType.getDiskSpaceEstimated();
        }
        longBytesCount += this.m_DefaultDMXDeviceFadeDescription.getDiskSpaceEstimated();
        longBytesCount += 4L;
        longBytesCount += 4L;
        longBytesCount += ImagesTools.getDiskSpaceEstimated(this.m_DeviceImage);
        return ++longBytesCount;
    }

    public void close() {
        if (this.m_DMXControlTypes != null) {
            for (int intType = this.m_DMXControlTypes.size() - 1; intType >= 0; --intType) {
                DMXControlComponent.DMXControlType o_DMXControlType = this.m_DMXControlTypes.get(intType);
                this.removeDMXControlType(o_DMXControlType);
            }
        }
        if (this.m_PropertyChangeSupport != null) {
            this.m_PropertyChangeSupport.clear();
        }
        LiveLanguage.removeLanguageListener((Object)this);
    }

    public void clear() {
        if (this.m_DMXControlTypes != null) {
            for (int intType = this.m_DMXControlTypes.size() - 1; intType >= 0; --intType) {
                DMXControlComponent.DMXControlType o_DMXControlType = this.m_DMXControlTypes.get(intType);
                this.removeDMXControlType(o_DMXControlType);
            }
        }
    }

    public void finalize() throws Throwable {
        super.finalize();
        this.m_PropertyChangeSupport = null;
    }

    public int getSoftwareVersionRead() {
        return this.m_SoftwareVersionRead;
    }

    public boolean addDMXControlType(DMXControlComponent.DMXControlType p_DMXControlType) {
        if (p_DMXControlType == null) {
            return false;
        }
        if (this.containsDMXControlType(p_DMXControlType)) {
            return true;
        }
        boolean boolAdded = false;
        boolAdded = this.m_DMXControlTypes.add(p_DMXControlType);
        if (boolAdded) {
            this.checkDMXControlTypeDescription(p_DMXControlType, null, p_DMXControlType.getDMXControlDescription());
            p_DMXControlType.addPropertyChangeListener(this);
            for (int intControl = 0; intControl < p_DMXControlType.getControlTypeCount(); ++intControl) {
                DMXControlComponent.ControlType o_ControlType = p_DMXControlType.getControlType(intControl);
                if (o_ControlType == null) continue;
                o_ControlType.addPropertyChangeListener(this);
                for (int intDimension = 0; intDimension < o_ControlType.getControlDimensionTypeCount(); ++intDimension) {
                    DMXControlComponent.ControlDimensionType o_ControlDimensionType = o_ControlType.getControlDimensionType(intDimension);
                    if (o_ControlDimensionType == null) continue;
                    o_ControlDimensionType.addPropertyChangeListener(this);
                    for (int intLink = 0; intLink < o_ControlDimensionType.getDeviceControlLinkCount(); ++intLink) {
                        DMXControlComponent.DeviceControlLink o_DeviceControlLink = o_ControlDimensionType.getDeviceControlLink(intLink);
                        this.addDeviceControlLink(o_DeviceControlLink);
                    }
                }
            }
            this.m_DefaultDMXDeviceFadeDescription.addDMXControlTypeFadeDescription(p_DMXControlType);
            this.checkDMXChannelTypeHasDisabledDMXControls();
            this.m_PropertyChangeSupport.fireIndexedPropertyChange(PROP_DMXDEVICETYPE_DMXCONTROLTYPE, this.m_DMXControlTypes.indexOf(p_DMXControlType), null, p_DMXControlType);
        }
        return boolAdded;
    }

    public void checkDMXChannelTypeHasDisabledDMXControls() {
        for (int intDMXControlType = 0; intDMXControlType < this.m_DMXControlTypes.size(); ++intDMXControlType) {
            DMXControlComponent.DMXControlType o_DMXControlType = this.m_DMXControlTypes.get(intDMXControlType);
            if (o_DMXControlType == null) continue;
            ArrayList<DMXControlComponent.DeviceControlLink> o_DeviceControlLinks = o_DMXControlType.getDeviceControlLinks();
            for (int intLink = 0; intLink < o_DeviceControlLinks.size(); ++intLink) {
                int intSectorIndex;
                DMXDeviceSector o_DMXDeviceSector;
                DMXControlComponent.DeviceControlLink o_DeviceControlLink = o_DeviceControlLinks.get(intLink);
                if (o_DeviceControlLink == null || (o_DMXDeviceSector = this.m_DMXDeviceSectors.get(intSectorIndex = o_DeviceControlLink.getDMXDeviceSectorIndex())) == null) continue;
                int intByteResolution = o_DeviceControlLink.getByteResolution();
                for (int intByte = 0; intByte < intByteResolution; ++intByte) {
                    DMXDeviceChannelType o_DMXDeviceChannelType;
                    int intInternalChannel = o_DeviceControlLink.getDeviceInternalChannel(intByte);
                    if (intInternalChannel < 0 || intInternalChannel >= o_DMXDeviceSector.getChannelCount() || (o_DMXDeviceChannelType = o_DMXDeviceSector.getDMXDeviceChannelType(intInternalChannel)) == null) continue;
                    o_DMXDeviceChannelType.checkDisabledDMXControl();
                }
            }
        }
    }

    public void checkDMXChannelTypeHasLinkedDimmerSubstitutes() {
        for (int intDMXControlType = 0; intDMXControlType < this.m_DMXControlTypes.size(); ++intDMXControlType) {
            DMXControlComponent.DMXControlType o_DMXControlType = this.m_DMXControlTypes.get(intDMXControlType);
            if (o_DMXControlType == null) continue;
            ArrayList<DMXControlComponent.DeviceControlLink> o_DeviceControlLinks = o_DMXControlType.getDeviceControlLinks();
            for (int intLink = 0; intLink < o_DeviceControlLinks.size(); ++intLink) {
                int intSectorIndex;
                DMXDeviceSector o_DMXDeviceSector;
                DMXControlComponent.DeviceControlLink o_DeviceControlLink = o_DeviceControlLinks.get(intLink);
                if (o_DeviceControlLink == null || (o_DMXDeviceSector = this.m_DMXDeviceSectors.get(intSectorIndex = o_DeviceControlLink.getDMXDeviceSectorIndex())) == null) continue;
                int intByteResolution = o_DeviceControlLink.getByteResolution();
                for (int intByte = 0; intByte < intByteResolution; ++intByte) {
                    DMXDeviceChannelType o_DMXDeviceChannelType;
                    int intInternalChannel = o_DeviceControlLink.getDeviceInternalChannel(intByte);
                    if (intInternalChannel < 0 || intInternalChannel >= o_DMXDeviceSector.getChannelCount() || (o_DMXDeviceChannelType = o_DMXDeviceSector.getDMXDeviceChannelType(intInternalChannel)) == null) continue;
                    o_DMXDeviceChannelType.checkDimmerSubstitute();
                }
            }
        }
    }

    public boolean removeDMXControlType(DMXControlComponent.DMXControlType p_DMXControlType) {
        if (p_DMXControlType == null) {
            return false;
        }
        if (!this.m_DMXControlTypes.contains(p_DMXControlType)) {
            return false;
        }
        int intIndex = this.m_DMXControlTypes.indexOf(p_DMXControlType);
        boolean boolRemoved = false;
        boolRemoved = this.m_DMXControlTypes.remove(p_DMXControlType);
        if (boolRemoved) {
            this.checkDMXControlTypeDescription(p_DMXControlType, p_DMXControlType.getDMXControlDescription(), null);
            p_DMXControlType.removePropertyChangeListener(this);
            for (int intControl = p_DMXControlType.getControlTypeCount() - 1; intControl >= 0; --intControl) {
                DMXControlComponent.ControlType o_ControlType = p_DMXControlType.getControlType(intControl);
                if (o_ControlType == null) continue;
                o_ControlType.removePropertyChangeListener(this);
                for (int intDimension = o_ControlType.getControlDimensionTypeCount() - 1; intDimension >= 0; --intDimension) {
                    DMXControlComponent.ControlDimensionType o_ControlDimensionType = o_ControlType.getControlDimensionType(intDimension);
                    if (o_ControlDimensionType == null) continue;
                    o_ControlDimensionType.removePropertyChangeListener(this);
                    for (int intLink = o_ControlDimensionType.getDeviceControlLinkCount() - 1; intLink >= 0; --intLink) {
                        DMXControlComponent.DeviceControlLink o_DeviceControlLink = o_ControlDimensionType.getDeviceControlLink(intLink);
                        if (o_DeviceControlLink == null) continue;
                        this.removeDeviceControlLink(o_DeviceControlLink);
                        o_DeviceControlLink.close();
                    }
                }
            }
            this.m_DefaultDMXDeviceFadeDescription.removeDMXControlTypeFadeDescription(p_DMXControlType);
            p_DMXControlType.close();
            this.m_PropertyChangeSupport.fireIndexedPropertyChange(PROP_DMXDEVICETYPE_DMXCONTROLTYPE, intIndex, p_DMXControlType, null);
        }
        return boolRemoved;
    }

    private void checkDMXControlTypeDescription(DMXControlComponent.DMXControlType p_DMXControlType, DMXControlDescription p_OldDescription, DMXControlDescription p_NewDescription) {
        ArrayList<DMXControlComponent.DMXControlType> o_DMXControlTypes;
        if (p_OldDescription != null && (o_DMXControlTypes = this.m_HashMapDMXControlTypes.get(p_OldDescription.getID())) != null) {
            o_DMXControlTypes.remove(p_DMXControlType);
            if (o_DMXControlTypes.size() <= 0) {
                this.m_HashMapDMXControlTypes.remove(p_OldDescription.getID());
            }
        }
        if (p_NewDescription != null) {
            o_DMXControlTypes = this.m_HashMapDMXControlTypes.get(p_NewDescription.getID());
            if (o_DMXControlTypes == null) {
                o_DMXControlTypes = new ArrayList();
                this.m_HashMapDMXControlTypes.put(p_NewDescription.getID(), o_DMXControlTypes);
            }
            if (!this.containsDMXControlType(p_DMXControlType, o_DMXControlTypes)) {
                o_DMXControlTypes.add(p_DMXControlType);
            }
        }
    }

    public boolean containsFunction(ControlFunctionModel.ControlFunctionType p_ControlFunctionType) {
        if (p_ControlFunctionType == null) {
            return false;
        }
        return this.containsFunction(p_ControlFunctionType.getID());
    }

    public boolean containsFunction(String p_ControlFunctionTypeID) {
        if (p_ControlFunctionTypeID == null) {
            return false;
        }
        boolean boolContains = false;
        for (int intDMXControlType = 0; intDMXControlType < this.m_DMXControlTypes.size(); ++intDMXControlType) {
            DMXControlComponent.DMXControlType o_DMXControlType = this.m_DMXControlTypes.get(intDMXControlType);
            if (o_DMXControlType == null) continue;
            for (int intControlType = 0; intControlType < o_DMXControlType.getControlTypeCount(); ++intControlType) {
                DMXControlComponent.ControlType o_ControlType = o_DMXControlType.getControlType(intControlType);
                if (o_ControlType == null) continue;
                for (int intDimension = 0; intDimension < o_ControlType.getControlDimensionTypeCount(); ++intDimension) {
                    ControlFunctionModel.ControlFunctionDescription o_ControlFunctionDescription;
                    DMXControlComponent.ControlDimensionType o_ControlDimensionType = o_ControlType.getControlDimensionType(intDimension);
                    if (o_ControlDimensionType == null || (o_ControlFunctionDescription = o_ControlDimensionType.getControlFunctionDescription(p_ControlFunctionTypeID)) == null) continue;
                    boolContains = true;
                    return boolContains;
                }
            }
        }
        return boolContains;
    }

    public DMXFadeDescription.DMXDeviceFadeDescription getDefaultDMXDeviceFadeDescription() {
        return this.m_DefaultDMXDeviceFadeDescription;
    }

    public DMXFadeDescription.DMXControlTypeFadeDescription getDefaultDMXControlTypeFadeDescription(DMXControlComponent.DMXControlType p_DMXControlType) {
        if (p_DMXControlType == null) {
            return null;
        }
        DMXFadeDescription.DMXDeviceFadeDescription o_DefaultDMXDeviceFadeDescription = this.m_DefaultDMXDeviceFadeDescription;
        if (o_DefaultDMXDeviceFadeDescription == null) {
            return null;
        }
        return o_DefaultDMXDeviceFadeDescription.getDMXControlTypeFadeDescription(p_DMXControlType.getID());
    }

    public void moveDMXControlType(int p_NewPosition, DMXControlComponent.DMXControlType p_DMXControlType) {
        if (p_DMXControlType == null) {
            return;
        }
        if (!this.m_DMXControlTypes.contains(p_DMXControlType)) {
            return;
        }
        int intOldPosition = this.m_DMXControlTypes.indexOf(p_DMXControlType);
        if (intOldPosition < 0) {
            return;
        }
        if (p_NewPosition < 0) {
            p_NewPosition = 0;
        }
        if (p_NewPosition >= this.m_DMXControlTypes.size()) {
            p_NewPosition = this.m_DMXControlTypes.size() - 1;
        }
        if (intOldPosition == p_NewPosition) {
            return;
        }
        this.m_DMXControlTypes.remove(p_DMXControlType);
        this.m_DMXControlTypes.add(p_NewPosition, p_DMXControlType);
    }

    public boolean containsDMXControlType(DMXControlComponent.DMXControlType p_DMXControlType) {
        return this.containsDMXControlType(p_DMXControlType, this.m_DMXControlTypes);
    }

    public boolean containsDMXControlType(DMXControlComponent.DMXControlType p_DMXControlType, ArrayList<DMXControlComponent.DMXControlType> p_DMXControlTypes) {
        if (p_DMXControlType == null) {
            return false;
        }
        for (int intControlType = 0; intControlType < p_DMXControlTypes.size(); ++intControlType) {
            DMXControlComponent.DMXControlType o_DMXControlType = p_DMXControlTypes.get(intControlType);
            if (o_DMXControlType == null || !o_DMXControlType.getID().equals(p_DMXControlType.getID())) continue;
            return true;
        }
        return false;
    }

    public int getDMXControlTypeCount() {
        return this.m_DMXControlTypes.size();
    }

    public DMXControlComponent.DMXControlType getDMXControlType(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        if (p_Index >= this.m_DMXControlTypes.size()) {
            return null;
        }
        return this.m_DMXControlTypes.get(p_Index);
    }

    public DMXControlComponent.DMXControlType getDMXControlType(String p_ID) {
        if (p_ID == null) {
            return null;
        }
        for (int intType = 0; intType < this.m_DMXControlTypes.size(); ++intType) {
            DMXControlComponent.DMXControlType o_DMXControlType = this.m_DMXControlTypes.get(intType);
            if (o_DMXControlType == null || !p_ID.equals(o_DMXControlType.getID())) continue;
            return o_DMXControlType;
        }
        return null;
    }

    public ArrayList<DMXControlComponent.DMXControlType> getDMXControlTypes(String p_DMXControlDescriptionID) {
        if (p_DMXControlDescriptionID == null) {
            return null;
        }
        return this.m_HashMapDMXControlTypes.get(p_DMXControlDescriptionID);
    }

    public void setDMXDeviceSectorCount(int p_SectorCount) {
        if (p_SectorCount < 0) {
            return;
        }
        if (p_SectorCount == this.m_DMXDeviceSectors.size()) {
            return;
        }
        int oldValue = this.m_DMXDeviceSectors.size();
        if (oldValue < p_SectorCount) {
            for (int intSector = oldValue; intSector < p_SectorCount; ++intSector) {
                DMXDeviceSector o_DMXDeviceSector = new DMXDeviceSector(this, intSector);
                this.addDMXDeviceSector(o_DMXDeviceSector);
            }
        } else if (this.m_DMXDeviceSectors.size() > p_SectorCount) {
            for (int intSector = this.m_DMXDeviceSectors.size() - 1; intSector > p_SectorCount - 1; --intSector) {
                DMXDeviceSector o_DMXDeviceSector = this.m_DMXDeviceSectors.get(intSector);
                this.removeDMXDeviceSector(o_DMXDeviceSector);
            }
        }
        this.m_PropertyChangeSupport.firePropertyChange(PROP_DMXDEVICETYPE_SECTORCOUNT, oldValue, p_SectorCount);
    }

    public int getDMXDeviceSectorCount() {
        return this.m_DMXDeviceSectors.size();
    }

    public boolean addDMXDeviceSector(DMXDeviceSector p_DMXDeviceSector) {
        if (p_DMXDeviceSector == null) {
            return false;
        }
        if (this.m_DMXDeviceSectors.contains(p_DMXDeviceSector)) {
            return true;
        }
        boolean boolAdded = false;
        boolAdded = this.m_DMXDeviceSectors.add(p_DMXDeviceSector);
        int intIndex = this.m_DMXDeviceSectors.indexOf(p_DMXDeviceSector);
        if (boolAdded) {
            p_DMXDeviceSector.addPropertyChangeListener(this);
            this.m_PropertyChangeSupport.fireIndexedPropertyChange(PROP_DMXDEVICETYP_INDEXED_DEVICESECTOR, intIndex, null, p_DMXDeviceSector);
        }
        return boolAdded;
    }

    public boolean removeDMXDeviceSector(DMXDeviceSector p_DMXDeviceSector) {
        if (p_DMXDeviceSector == null) {
            return false;
        }
        if (!this.m_DMXDeviceSectors.contains(p_DMXDeviceSector)) {
            return false;
        }
        boolean boolRemoved = false;
        int intIndex = this.m_DMXDeviceSectors.indexOf(p_DMXDeviceSector);
        boolRemoved = this.m_DMXDeviceSectors.remove(p_DMXDeviceSector);
        if (boolRemoved) {
            p_DMXDeviceSector.removePropertyChangeListener(this);
            this.m_PropertyChangeSupport.fireIndexedPropertyChange(PROP_DMXDEVICETYP_INDEXED_DEVICESECTOR, intIndex, p_DMXDeviceSector, null);
            p_DMXDeviceSector.close();
        }
        return boolRemoved;
    }

    public DMXDeviceSector getDMXDeviceSector(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        if (p_Index >= this.m_DMXDeviceSectors.size()) {
            return null;
        }
        return this.m_DMXDeviceSectors.get(p_Index);
    }

    public void setChannelCount(int p_DMXDeviceSectorIndex, int p_ChannelCount) {
        if (p_DMXDeviceSectorIndex < 0 || p_DMXDeviceSectorIndex >= this.getDMXDeviceSectorCount()) {
            return;
        }
        if (p_ChannelCount < 1 || p_ChannelCount > 512) {
            return;
        }
        DMXDeviceSector o_DMXDeviceSector = this.getDMXDeviceSector(p_DMXDeviceSectorIndex);
        if (o_DMXDeviceSector.getChannelCount() == p_ChannelCount) {
            return;
        }
        o_DMXDeviceSector.setChannelCount(p_ChannelCount);
    }

    public int getChannelCount(int p_DMXDeviceSectorIndex) {
        if (p_DMXDeviceSectorIndex < 0 || p_DMXDeviceSectorIndex >= this.getDMXDeviceSectorCount()) {
            return 0;
        }
        DMXDeviceSector o_DMXDeviceSector = this.getDMXDeviceSector(p_DMXDeviceSectorIndex);
        return o_DMXDeviceSector.getChannelCount();
    }

    public int getChannelCountAll() {
        int intChannelCountAll = 0;
        for (int intSector = 0; intSector < this.getDMXDeviceSectorCount(); ++intSector) {
            intChannelCountAll += this.getChannelCount(intSector);
        }
        return intChannelCountAll;
    }

    public void setWattage(int p_DMXDeviceSectorIndex, int p_Wattage) {
        if (p_DMXDeviceSectorIndex < 0 || p_DMXDeviceSectorIndex >= this.getDMXDeviceSectorCount()) {
            return;
        }
        DMXDeviceSector o_DMXDeviceSector = this.getDMXDeviceSector(p_DMXDeviceSectorIndex);
        o_DMXDeviceSector.setWattage(p_Wattage);
    }

    public boolean addDeviceControlLink(DMXControlComponent.DeviceControlLink p_DeviceControlLink) {
        if (p_DeviceControlLink == null) {
            return false;
        }
        boolean boolAdded = false;
        int intByteResolution = p_DeviceControlLink.getByteResolution();
        for (int intByte = 0; intByte < intByteResolution; ++intByte) {
            boolAdded = this.addDeviceControlLink(p_DeviceControlLink, intByte);
        }
        if (boolAdded) {
            this.m_PropertyChangeSupport.firePropertyChange(PROP_DMXDEVICETYPE_DEVICECONTROLLINK, null, p_DeviceControlLink);
        }
        return boolAdded;
    }

    public boolean addDeviceControlLink(DMXControlComponent.DeviceControlLink p_DeviceControlLink, int p_Byte) {
        if (p_DeviceControlLink == null) {
            return false;
        }
        boolean boolAdded = false;
        int intSectorIndex = p_DeviceControlLink.getDMXDeviceSectorIndex();
        if (intSectorIndex < 0 || intSectorIndex >= this.m_DMXDeviceSectors.size()) {
            p_DeviceControlLink.close();
            return false;
        }
        DMXDeviceSector o_DMXDeviceSector = this.m_DMXDeviceSectors.get(intSectorIndex);
        int intInternalChannel = p_DeviceControlLink.getDeviceInternalChannel(p_Byte);
        if (intInternalChannel < 0) {
            return false;
        }
        if (intInternalChannel >= o_DMXDeviceSector.getChannelCount()) {
            p_DeviceControlLink.close();
            boolAdded = false;
            return false;
        }
        DMXDeviceChannelType o_DMXDeviceChannelType = o_DMXDeviceSector.getDMXDeviceChannelType(intInternalChannel);
        if (o_DMXDeviceChannelType != null) {
            boolAdded = o_DMXDeviceChannelType.addDeviceControlLink(p_DeviceControlLink, p_Byte);
        }
        return boolAdded;
    }

    public boolean removeDeviceControlLink(DMXControlComponent.DeviceControlLink p_DeviceControlLink) {
        if (p_DeviceControlLink == null) {
            return false;
        }
        boolean boolRemoved = false;
        int intByteResolution = p_DeviceControlLink.getByteResolution();
        for (int intByte = intByteResolution - 1; intByte >= 0; --intByte) {
            if (!this.removeDeviceControlLink(p_DeviceControlLink, intByte)) continue;
            boolRemoved = true;
        }
        if (boolRemoved) {
            this.m_PropertyChangeSupport.firePropertyChange(PROP_DMXDEVICETYPE_DEVICECONTROLLINK, p_DeviceControlLink, null);
        }
        return boolRemoved;
    }

    public boolean removeDeviceControlLink(DMXControlComponent.DeviceControlLink p_DeviceControlLink, int p_Byte) {
        if (p_DeviceControlLink == null) {
            return false;
        }
        boolean boolRemoved = false;
        int intSectorIndex = p_DeviceControlLink.getDMXDeviceSectorIndex();
        DMXDeviceSector o_DMXDeviceSector = this.getDMXDeviceSector(intSectorIndex);
        if (o_DMXDeviceSector != null) {
            int intInternalChannel = p_DeviceControlLink.getDeviceInternalChannel(p_Byte);
            if (intInternalChannel < 0) {
                return false;
            }
            DMXDeviceChannelType o_DMXDeviceChannelType = o_DMXDeviceSector.getDMXDeviceChannelType(intInternalChannel);
            if (o_DMXDeviceChannelType != null) {
                boolRemoved = o_DMXDeviceChannelType.removeDeviceControlLink(p_DeviceControlLink, p_Byte);
            }
        }
        return boolRemoved;
    }

    public String getID() {
        return this.m_ID;
    }

    public void setID(String p_ID) {
        if (p_ID == null) {
            return;
        }
        if (p_ID.equals(this.m_ID)) {
            return;
        }
        String oldValue = this.m_ID;
        this.m_ID = p_ID;
        this.m_PropertyChangeSupport.firePropertyChange(PROP_DMXDEVICETYPE_ID, oldValue, this.m_ID);
    }

    public String getManufactureerName() {
        return this.m_ManufacturerName;
    }

    public void setManufacturerName(String p_ManufacturerName) {
        if (p_ManufacturerName == null) {
            return;
        }
        if ((p_ManufacturerName = p_ManufacturerName.trim()).equals(this.m_ManufacturerName)) {
            return;
        }
        String oldValue = this.m_ManufacturerName;
        this.m_ManufacturerName = p_ManufacturerName;
        this.m_PropertyChangeSupport.firePropertyChange(PROP_DMXDEVICETYPE_MANUFACTUREERNAME, oldValue, this.m_ManufacturerName);
    }

    public String getTypeName() {
        return this.m_DeviceTypeName;
    }

    public void setTypeName(String p_DeviceName) {
        if (p_DeviceName == null) {
            return;
        }
        if ((p_DeviceName = p_DeviceName.trim()).equals(this.m_DeviceTypeName)) {
            return;
        }
        String oldValue = this.m_DeviceTypeName;
        this.m_DeviceTypeName = p_DeviceName;
        this.m_PropertyChangeSupport.firePropertyChange(PROP_DMXDEVICETYPE_NAME, oldValue, this.m_DeviceTypeName);
    }

    @Override
    public String getName() {
        return DMXDeviceType.calculateDeviceTypeName(this);
    }

    public void setDMXModeName(String p_DMXModeName) {
        if (p_DMXModeName == null) {
            p_DMXModeName = "";
        }
        this.m_DMXModeName = p_DMXModeName;
    }

    public String getDMXModeName() {
        return this.m_DMXModeName;
    }

    public void calculateDMXModeNameFromOldDeviceName() {
        if (this.m_DeviceTypeName == null) {
            return;
        }
        int intIndex = this.m_DeviceTypeName.lastIndexOf("_");
        if (intIndex < 0) {
            return;
        }
        String stringDMXModeName = this.m_DeviceTypeName.substring(intIndex, this.m_DeviceTypeName.length());
        if (stringDMXModeName.toLowerCase().endsWith("ch")) {
            this.m_DeviceTypeName = this.m_DeviceTypeName.substring(0, intIndex);
            this.m_DMXModeName = stringDMXModeName.substring(1, stringDMXModeName.length());
        }
        if (this.m_DMXModeName.length() <= 0) {
            this.m_DMXModeName = String.valueOf(this.getChannelCountAll() + "CH");
        }
    }

    public String calculateDMXModeNameFromDMXChannelCount(int p_DMXChannelCount) {
        if (p_DMXChannelCount <= 0) {
            return "";
        }
        StringBuilder o_StringBuilder = new StringBuilder();
        o_StringBuilder.append(p_DMXChannelCount);
        o_StringBuilder.append("CH");
        return o_StringBuilder.toString();
    }

    @Override
    public String getRemark() {
        return this.m_Remark;
    }

    public void setRemark(String p_Remark) {
        if (p_Remark == null) {
            return;
        }
        if (p_Remark.equals(this.m_Remark)) {
            return;
        }
        String oldValue = this.m_Remark;
        this.m_Remark = p_Remark;
        this.m_PropertyChangeSupport.firePropertyChange(PROP_DMXDEVICETYPE_REMARK, oldValue, this.m_Remark);
    }

    @Override
    public Icon getIcon() {
        return s_Icon;
    }

    @Override
    public boolean useDMXDevice(DMXDevice p_DMXDevice) {
        if (p_DMXDevice == null) {
            return false;
        }
        return p_DMXDevice.getDMXDeviceType() == this;
    }

    public String getFileName() {
        return this.m_FileName;
    }

    public void setFileName(String p_FileName) {
        this.m_FileName = p_FileName;
    }

    public void setPanMaxGrad(double p_PanMaxGrad) {
        if (p_PanMaxGrad < 0.0) {
            p_PanMaxGrad = 0.0;
        }
        this.m_PanMaxGrad = p_PanMaxGrad;
    }

    public double getPanMaxGrad() {
        return this.m_PanMaxGrad;
    }

    public void setTiltMaxGrad(double p_TiltMaxGrad) {
        if (p_TiltMaxGrad < 0.0) {
            p_TiltMaxGrad = 0.0;
        }
        this.m_TiltMaxGrad = p_TiltMaxGrad;
    }

    public double getTiltMaxGrad() {
        return this.m_TiltMaxGrad;
    }

    public String getChannelName(int p_Sector, int p_InternalChannel) {
        String stringChannelName = "";
        if (p_Sector < 0 || p_Sector >= this.m_DMXDeviceSectors.size()) {
            return stringChannelName;
        }
        DMXDeviceSector o_DMXDeviceSector = this.m_DMXDeviceSectors.get(p_Sector);
        if (this.m_DMXDeviceSectors.size() > 1) {
            stringChannelName = o_DMXDeviceSector.getSectorName() + " ";
        }
        stringChannelName = stringChannelName + o_DMXDeviceSector.getChannelName(p_InternalChannel);
        return stringChannelName;
    }

    public void setDeviceImage(BufferedImage p_Image) {
        if (this.m_DeviceImage == p_Image) {
            return;
        }
        BufferedImage oldValue = this.m_DeviceImage;
        this.m_DeviceImage = p_Image;
        if (this.m_DeviceImage != null) {
            if (this.m_DeviceImage.getWidth(null) > DMXDeviceType.MAXDEVICEIMAGESIZE.width || this.m_DeviceImage.getHeight(null) > DMXDeviceType.MAXDEVICEIMAGESIZE.height) {
                this.m_DeviceImage = ImagesTools.resizeImage(this.m_DeviceImage, DMXDeviceType.MAXDEVICEIMAGESIZE.width, DMXDeviceType.MAXDEVICEIMAGESIZE.height);
            }
            if (this.m_DeviceImageIcon != null) {
                // empty if block
            }
            this.m_DeviceImageIcon = new ImageIcon(this.m_DeviceImage);
        } else {
            this.m_DeviceImageIcon = null;
            this.m_DeviceIconDimension.width = DEFAULT_IMAGELENGTH;
            this.m_DeviceIconDimension.height = DEFAULT_IMAGELENGTH;
        }
        this.m_PropertyChangeSupport.firePropertyChange(PROP_DMXDEVICETYPE_IMAGE, oldValue, this.m_DeviceImage);
        if (oldValue != null) {
            oldValue.flush();
        }
    }

    public BufferedImage getDeviceImage() {
        return this.m_DeviceImage;
    }

    public Icon getDeviceIcon() {
        return this.m_DeviceImageIcon;
    }

    public double getDeviceImageRatio() {
        if (this.m_DeviceImage == null) {
            return 1.0;
        }
        int intWidth = this.m_DeviceImage.getWidth();
        int intHeight = this.m_DeviceImage.getHeight();
        if (intHeight <= 0 || intWidth <= 0) {
            return 1.0;
        }
        return (double)intWidth / (double)intHeight;
    }

    public void setDeviceIconDimension(int p_Width, int p_Height) {
        if (this.m_DeviceIconDimension.width == p_Width && this.m_DeviceIconDimension.height == p_Height) {
            return;
        }
        if (p_Width < MIN_IMAGELENGTH) {
            p_Width = MIN_IMAGELENGTH;
        }
        if (p_Height < MIN_IMAGELENGTH) {
            p_Height = MIN_IMAGELENGTH;
        }
        this.m_DeviceIconDimension.width = p_Width;
        this.m_DeviceIconDimension.height = p_Height;
        this.m_PropertyChangeSupport.firePropertyChange(PROP_DMXDEVICETYPE_IMAGE, null, this.m_DeviceImage);
    }

    public Dimension getDeviceIconDimension() {
        if (this.m_DeviceIconDimension == null) {
            this.m_DeviceIconDimension = new Dimension(DEFAULT_IMAGELENGTH, DEFAULT_IMAGELENGTH);
        }
        return (Dimension)this.m_DeviceIconDimension.clone();
    }

    public int getDeviceIconWidth() {
        if (this.m_DeviceIconDimension == null) {
            this.m_DeviceIconDimension = new Dimension(DEFAULT_IMAGELENGTH, DEFAULT_IMAGELENGTH);
        }
        return this.m_DeviceIconDimension.width;
    }

    public int getDeviceIconHeight() {
        if (this.m_DeviceIconDimension == null) {
            this.m_DeviceIconDimension = new Dimension(DEFAULT_IMAGELENGTH, DEFAULT_IMAGELENGTH);
        }
        return this.m_DeviceIconDimension.height;
    }

    public void addPropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
        if (p_PropertyChangeListener == null) {
            return;
        }
        this.m_PropertyChangeSupport.addPropertyChangeListener(p_PropertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
        this.m_PropertyChangeSupport.removePropertyChangeListener(p_PropertyChangeListener);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        IndexedPropertyChangeEvent o_IndexedPropertyChangeEvent;
        if (evt.getSource() instanceof DMXDeviceSector && PROP_DMXDEVICETYPE_INDEXED_DEVICECHANNELTYPE.equals(evt.getPropertyName())) {
            o_IndexedPropertyChangeEvent = (IndexedPropertyChangeEvent)evt;
            this.m_PropertyChangeSupport.fireIndexedPropertyChange(PROP_DMXDEVICETYPE_INDEXED_DEVICECHANNELTYPE, o_IndexedPropertyChangeEvent.getIndex(), evt.getOldValue(), evt.getNewValue());
        }
        if (evt.getSource() instanceof DMXControlComponent.DMXControlType) {
            DMXControlComponent.DMXControlType o_DMXControlType;
            if ("dmxcontroltypeName".equals(evt.getPropertyName())) {
                this.m_PropertyChangeSupport.firePropertyChange(PROP_DMXCONTROLNAME, null, evt.getSource());
            } else if ("dmxcontroltypeDMXControlDescription".equals(evt.getPropertyName())) {
                o_DMXControlType = (DMXControlComponent.DMXControlType)evt.getSource();
                this.checkDMXControlTypeDescription(o_DMXControlType, (DMXControlDescription)evt.getOldValue(), (DMXControlDescription)evt.getNewValue());
            } else if ("dmxcontroltypeDimmerSubstitute".equals(evt.getPropertyName())) {
                o_DMXControlType = (DMXControlComponent.DMXControlType)evt.getSource();
                this.checkDMXChannelTypeHasLinkedDimmerSubstitutes();
            } else if ("dmxcontroltypeDisabledInFunctions".equals(evt.getPropertyName())) {
                o_DMXControlType = (DMXControlComponent.DMXControlType)evt.getSource();
                this.checkDMXChannelTypeHasDisabledDMXControls();
            }
        } else if (evt.getSource() instanceof DMXControlComponent.ControlType) {
            if ("dmxcontroltypeName".equals(evt.getPropertyName())) {
                this.m_PropertyChangeSupport.firePropertyChange(PROP_CONTROLNAME, null, evt.getSource());
            }
        } else if (evt.getSource() instanceof DMXControlComponent.ControlDimensionType) {
            if ("controldimensiontypeName".equals(evt.getPropertyName())) {
                this.m_PropertyChangeSupport.firePropertyChange(PROP_CONTROLDIMENSIONNAME, null, evt.getSource());
            } else if ("controldimensiontypeDeviceControlLink".equals(evt.getPropertyName())) {
                if (evt.getOldValue() == null) {
                    this.addDeviceControlLink((DMXControlComponent.DeviceControlLink)evt.getNewValue());
                } else {
                    this.removeDeviceControlLink((DMXControlComponent.DeviceControlLink)evt.getOldValue());
                }
            } else if ("controldimensiontypeDeviceControlLinkByte".equals(evt.getPropertyName())) {
                o_IndexedPropertyChangeEvent = (IndexedPropertyChangeEvent)evt;
                int intByteIndex = o_IndexedPropertyChangeEvent.getIndex();
                if (evt.getOldValue() == null) {
                    this.addDeviceControlLink((DMXControlComponent.DeviceControlLink)evt.getNewValue(), intByteIndex);
                }
            }
        } else if (evt.getSource() instanceof DMXDeviceChannelType && PROP_DMXDEVICETYPE_INDEXED_CHANNELCONTROLLINK.equals(evt.getPropertyName())) {
            int intIndex = ((IndexedPropertyChangeEvent)evt).getIndex();
            this.m_PropertyChangeSupport.fireIndexedPropertyChange(PROP_DMXDEVICETYPE_INDEXED_CHANNELCONTROLLINK, intIndex, evt.getOldValue(), evt.getNewValue());
        }
    }

    public static DMXDeviceTypeTreeModel getTreeModel() {
        return s_DMXDeviceTypeTreeModel;
    }

    public static DMXDeviceTypeTreeCellRenderer getTreeCellRenderer() {
        return s_DMXDeviceTypeTreeCellRenderer;
    }

    public static ArrayList<DMXDeviceType> loadAllDMXDeviceTypes() {
        DMXDeviceType.copyOriginalDeviceTypesAtStartUp();
        ArrayList<DMXDeviceType> o_ArrayListDMXDeviceTypes = new ArrayList<DMXDeviceType>();
        File o_DeviceDirectory = new File(LiveShowDMXSystem.getPathDeviceTypes());
        if (!o_DeviceDirectory.exists()) {
            return null;
        }
        if (!o_DeviceDirectory.isDirectory()) {
            return null;
        }
        File[] o_DeviceFiles = o_DeviceDirectory.listFiles();
        for (int intFile = 0; intFile < o_DeviceFiles.length; ++intFile) {
            DMXDeviceType o_DMXDeviceType;
            String stringDeviceFileName;
            File o_DeviceFile = o_DeviceFiles[intFile];
            if (o_DeviceFile == null || o_DeviceFile.isDirectory() || !(stringDeviceFileName = o_DeviceFile.getName()).endsWith(FILESUFFIX)) continue;
            try {
                o_DMXDeviceType = DMXDeviceType.load(stringDeviceFileName);
            }
            catch (Exception e) {
                continue;
            }
            o_ArrayListDMXDeviceTypes.add(o_DMXDeviceType);
            DMXDeviceType.addDeviceType(o_DMXDeviceType);
        }
        return o_ArrayListDMXDeviceTypes;
    }

    private static boolean copyOriginalDeviceTypesAtStartUp() {
        File o_OriginalDeviceDirectory = new File(LiveShowDMXSystem.getPathOriginalDeviceTypes());
        if (!o_OriginalDeviceDirectory.exists()) {
            return false;
        }
        if (!o_OriginalDeviceDirectory.isDirectory()) {
            return false;
        }
        int intOriginalDeviceDirectoryLength = o_OriginalDeviceDirectory.getAbsolutePath().length();
        ArrayList<File> o_SourceDirectories = new ArrayList<File>();
        o_SourceDirectories.add(o_OriginalDeviceDirectory);
        while (o_SourceDirectories.size() > 0) {
            File o_DestDirectory;
            File o_SourceDirectory = (File)o_SourceDirectories.get(o_SourceDirectories.size() - 1);
            o_SourceDirectories.remove(o_SourceDirectories.size() - 1);
            if (o_SourceDirectory.getName().equals(LiveShowDMXSystem.getDirOriginalDeviceTypes().getName())) {
                o_DestDirectory = LiveShowDMXSystem.getDirDeviceTypes();
            } else {
                String stringSubPath = o_SourceDirectory.getAbsolutePath();
                stringSubPath = stringSubPath.substring(intOriginalDeviceDirectoryLength, stringSubPath.length());
                o_DestDirectory = new File(LiveShowDMXSystem.getPathDeviceTypes() + "/" + stringSubPath);
            }
            if (!o_DestDirectory.exists() && !o_DestDirectory.mkdir()) continue;
            File[] o_DeviceFiles = o_SourceDirectory.listFiles();
            for (int intFile = 0; intFile < o_DeviceFiles.length; ++intFile) {
                File o_SourceDeviceFile = o_DeviceFiles[intFile];
                if (o_SourceDeviceFile == null) continue;
                if (o_SourceDeviceFile.isDirectory()) {
                    o_SourceDirectories.add(o_SourceDeviceFile);
                    continue;
                }
                File o_File = FileTools.copyFileTo(o_SourceDeviceFile, o_DestDirectory, o_SourceDeviceFile.getName(), false);
                if (o_File != null) continue;
            }
        }
        return true;
    }

    public static boolean addDeviceType(DMXDeviceType p_DMXDeviceType) {
        if (p_DMXDeviceType == null) {
            return false;
        }
        DMXDeviceTypeTreeNode<DMXDeviceType> o_DeviceTypeNode = null;
        DMXDeviceTypeTreeNode<Object> o_ManufactureerTreeNode = null;
        boolean boolRemoved = false;
        DMXDeviceTypeTreeNode o_Root = (DMXDeviceTypeTreeNode)s_DMXDeviceTypeTreeModel.getRoot();
        ArrayList<DMXDeviceTypeTreeNode<?>> o_ManufactureerNodes = o_Root.getChildren();
        for (int intManufactureer = 0; intManufactureer < o_ManufactureerNodes.size(); ++intManufactureer) {
            ArrayList<DMXDeviceTypeTreeNode<?>> o_DeviceTypeNodes;
            o_ManufactureerTreeNode = o_ManufactureerNodes.get(intManufactureer);
            if (o_ManufactureerTreeNode == null || (o_DeviceTypeNodes = o_ManufactureerTreeNode.getChildren()) == null) continue;
            for (int intType = 0; intType < o_DeviceTypeNodes.size(); ++intType) {
                DMXDeviceType o_DMXDeviceType;
                o_DeviceTypeNode = o_DeviceTypeNodes.get(intType);
                if (o_DeviceTypeNode == null || (o_DMXDeviceType = o_DeviceTypeNode.getSourceObject()) == null) continue;
                if (o_DMXDeviceType.getID().equals(p_DMXDeviceType.getID())) {
                    for (int intDevice = 0; intDevice < DMXDevice.getDMXDeviceCount(); ++intDevice) {
                        DMXDeviceType o_Device_DMXDeviceType;
                        DMXDevice o_DMXDevice = DMXDevice.getDMXDevice(intDevice);
                        if (o_DMXDevice == null || (o_Device_DMXDeviceType = o_DMXDevice.getDMXDeviceType()) == null || !o_Device_DMXDeviceType.getID().equals(p_DMXDeviceType.getID())) continue;
                        o_DMXDevice.setDMXDeviceType(p_DMXDeviceType);
                    }
                    boolRemoved = false;
                    if (!o_DMXDeviceType.equals(p_DMXDeviceType)) {
                        s_DMXDeviceTypeTreeModel.removeChild(o_ManufactureerTreeNode, o_DeviceTypeNode);
                        o_DMXDeviceType.close();
                        o_DeviceTypeNode = null;
                        boolRemoved = true;
                    } else if (!o_DMXDeviceType.getManufactureerName().equals(p_DMXDeviceType.getManufactureerName())) {
                        s_DMXDeviceTypeTreeModel.removeChild(o_ManufactureerTreeNode, o_DeviceTypeNode);
                        o_DMXDeviceType = null;
                        boolRemoved = true;
                    }
                    if (!boolRemoved) {
                        return true;
                    }
                    if (o_ManufactureerTreeNode.getChildCount() != 0) break;
                    s_DMXDeviceTypeTreeModel.removeChild(o_Root, o_ManufactureerTreeNode);
                    break;
                }
                o_DeviceTypeNode = null;
            }
            if (boolRemoved) break;
        }
        if ((o_ManufactureerTreeNode = o_Root.getChildByManufactureer(p_DMXDeviceType.getManufactureerName())) == null) {
            o_ManufactureerTreeNode = new DMXDeviceTypeTreeNode<String>(p_DMXDeviceType.getManufactureerName());
            s_DMXDeviceTypeTreeModel.addChild(o_Root, o_ManufactureerTreeNode);
        }
        if (o_DeviceTypeNode == null) {
            o_DeviceTypeNode = new DMXDeviceTypeTreeNode<DMXDeviceType>(p_DMXDeviceType);
        }
        s_DMXDeviceTypeTreeModel.addChild(o_ManufactureerTreeNode, o_DeviceTypeNode);
        return true;
    }

    public static boolean removeDeviceType(DMXDeviceType p_DMXDeviceType) {
        if (p_DMXDeviceType == null) {
            return false;
        }
        DMXDeviceTypeTreeNode<?> o_DeviceTypeNode = null;
        DMXDeviceTypeTreeNode<?> o_ManufactureerTreeNode = null;
        boolean boolRemoved = false;
        DMXDeviceTypeTreeNode o_Root = (DMXDeviceTypeTreeNode)s_DMXDeviceTypeTreeModel.getRoot();
        ArrayList<DMXDeviceTypeTreeNode<?>> o_ManufactureerNodes = o_Root.getChildren();
        for (int intManufactureer = 0; intManufactureer < o_ManufactureerNodes.size(); ++intManufactureer) {
            ArrayList<DMXDeviceTypeTreeNode<?>> o_DeviceTypeNodes;
            o_ManufactureerTreeNode = o_ManufactureerNodes.get(intManufactureer);
            if (o_ManufactureerNodes == null || (o_DeviceTypeNodes = o_ManufactureerTreeNode.getChildren()) == null) continue;
            for (int intType = 0; intType < o_DeviceTypeNodes.size(); ++intType) {
                DMXDeviceType o_DMXDeviceType;
                o_DeviceTypeNode = o_DeviceTypeNodes.get(intType);
                if (o_DeviceTypeNode == null || (o_DMXDeviceType = (DMXDeviceType)o_DeviceTypeNode.getSourceObject()) == null) continue;
                if (o_DMXDeviceType.getID().equals(p_DMXDeviceType.getID())) {
                    for (int intDevice = DMXDevice.getDMXDeviceCount() - 1; intDevice >= 0; --intDevice) {
                        DMXDeviceType o_Device_DMXDeviceType;
                        DMXDevice o_DMXDevice = DMXDevice.getDMXDevice(intDevice);
                        if (o_DMXDevice == null || (o_Device_DMXDeviceType = o_DMXDevice.getDMXDeviceType()) == null || !o_Device_DMXDeviceType.getID().equals(p_DMXDeviceType.getID())) continue;
                        o_DMXDevice.close();
                    }
                    boolRemoved = false;
                    if (!o_DMXDeviceType.getManufactureerName().equals(p_DMXDeviceType.getManufactureerName())) {
                        s_DMXDeviceTypeTreeModel.removeChild(o_ManufactureerTreeNode, o_DeviceTypeNode);
                        o_DMXDeviceType = null;
                        boolRemoved = true;
                    } else if (!o_DMXDeviceType.equals(p_DMXDeviceType)) {
                        s_DMXDeviceTypeTreeModel.removeChild(o_ManufactureerTreeNode, o_DeviceTypeNode);
                        o_DeviceTypeNode = null;
                        boolRemoved = true;
                    }
                    if (!boolRemoved) {
                        return true;
                    }
                    if (o_ManufactureerTreeNode.getChildCount() != 0) break;
                    s_DMXDeviceTypeTreeModel.removeChild(o_Root, o_ManufactureerTreeNode);
                    break;
                }
                o_DeviceTypeNode = null;
            }
            if (boolRemoved) break;
        }
        return boolRemoved;
    }

    public static DMXDeviceType getDMXDeviceTypeByID(String p_ID) {
        if (p_ID == null || p_ID.length() <= 0) {
            return null;
        }
        DMXDeviceTypeTreeNode<?> o_DeviceTypeNode = null;
        DMXDeviceTypeTreeNode<?> o_ManufactureerTreeNode = null;
        DMXDeviceTypeTreeNode o_Root = (DMXDeviceTypeTreeNode)s_DMXDeviceTypeTreeModel.getRoot();
        ArrayList<DMXDeviceTypeTreeNode<?>> o_ManufactureerNodes = o_Root.getChildren();
        for (int intManufactureer = 0; intManufactureer < o_ManufactureerNodes.size(); ++intManufactureer) {
            ArrayList<DMXDeviceTypeTreeNode<?>> o_DeviceTypeNodes;
            o_ManufactureerTreeNode = o_ManufactureerNodes.get(intManufactureer);
            if (o_ManufactureerTreeNode == null || (o_DeviceTypeNodes = o_ManufactureerTreeNode.getChildren()) == null) continue;
            for (int intType = 0; intType < o_DeviceTypeNodes.size(); ++intType) {
                DMXDeviceType o_DMXDeviceType;
                o_DeviceTypeNode = o_DeviceTypeNodes.get(intType);
                if (o_DeviceTypeNode == null || !(o_DMXDeviceType = (DMXDeviceType)o_DeviceTypeNode.getSourceObject()).getID().equals(p_ID)) continue;
                return o_DMXDeviceType;
            }
        }
        return null;
    }

    public static DMXDeviceType getDMXDeviceTypeByName(String p_Manufactureer, String p_TypeName) {
        if (p_Manufactureer == null || p_Manufactureer.length() <= 0) {
            return null;
        }
        if (p_TypeName == null || p_TypeName.length() <= 0) {
            return null;
        }
        DMXDeviceTypeTreeNode<?> o_DeviceTypeNode = null;
        DMXDeviceTypeTreeNode<?> o_ManufactureerTreeNode = null;
        p_Manufactureer = FileTools.validateFileName(p_Manufactureer);
        p_Manufactureer = p_Manufactureer.toLowerCase();
        p_TypeName = FileTools.validateFileName(p_TypeName);
        p_TypeName = p_TypeName.toLowerCase();
        DMXDeviceTypeTreeNode o_Root = (DMXDeviceTypeTreeNode)s_DMXDeviceTypeTreeModel.getRoot();
        ArrayList<DMXDeviceTypeTreeNode<?>> o_ManufactureerNodes = o_Root.getChildren();
        for (int intManufactureer = 0; intManufactureer < o_ManufactureerNodes.size(); ++intManufactureer) {
            ArrayList<DMXDeviceTypeTreeNode<?>> o_DeviceTypeNodes;
            o_ManufactureerTreeNode = o_ManufactureerNodes.get(intManufactureer);
            if (o_ManufactureerTreeNode == null || (o_DeviceTypeNodes = o_ManufactureerTreeNode.getChildren()) == null) continue;
            for (int intType = 0; intType < o_DeviceTypeNodes.size(); ++intType) {
                o_DeviceTypeNode = o_DeviceTypeNodes.get(intType);
                if (o_DeviceTypeNode == null) continue;
                DMXDeviceType o_DMXDeviceType = (DMXDeviceType)o_DeviceTypeNode.getSourceObject();
                String stringManufactureer = o_DMXDeviceType.getManufactureerName();
                stringManufactureer = FileTools.validateFileName(stringManufactureer);
                if (!p_Manufactureer.equals(stringManufactureer = stringManufactureer.toLowerCase())) continue;
                String stringTypeName = o_DMXDeviceType.getTypeName();
                stringTypeName = FileTools.validateFileName(stringTypeName);
                if (!p_TypeName.equals(stringTypeName = stringTypeName.toLowerCase())) continue;
                return o_DMXDeviceType;
            }
        }
        return null;
    }

    public static class DMXDeviceTypeTreeCellRenderer
    extends JLabel
    implements TreeCellRenderer {
        Border m_SelectionBorder;

        public DMXDeviceTypeTreeCellRenderer() {
            this.initComponents();
        }

        private void initComponents() {
            this.setOpaque(false);
            this.setPreferredSize(new Dimension(300, 25));
            this.m_SelectionBorder = new LineBorder(Color.BLUE);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Object o_SourceObject = null;
            Color o_Background = tree.getBackground();
            Color o_Foreground = UIManager.getColor("Tree.textForeground");
            if (selected) {
                if (tree.hasFocus()) {
                    o_Foreground = UIManager.getColor("Tree.selectionForeground");
                    o_Background = UIManager.getColor("Tree.selectionBackground");
                } else {
                    o_Foreground = UIManager.getColor("Tree.selectionInactiveForeground");
                    o_Background = UIManager.getColor("Tree.selectionInactiveBackground");
                }
            }
            this.setForeground(o_Foreground);
            this.setBackground(o_Background);
            if (!(value instanceof DMXDeviceTypeTreeNode)) {
                return this;
            }
            o_SourceObject = ((DMXDeviceTypeTreeNode)value).getSourceObject();
            StringBuilder stringNodeText = new StringBuilder();
            if (o_SourceObject instanceof String) {
                stringNodeText.append("<html><b>");
                stringNodeText.append((String)o_SourceObject);
                stringNodeText.append("</b></html>");
            } else if (o_SourceObject instanceof DMXDeviceType) {
                DMXDeviceType o_DMXDeviceType = o_SourceObject;
                stringNodeText.append(o_DMXDeviceType.getTypeName());
                stringNodeText.append(" (");
                if (o_DMXDeviceType.getDMXModeName().length() > 0) {
                    stringNodeText.append(o_DMXDeviceType.getDMXModeName());
                } else {
                    stringNodeText.append(o_DMXDeviceType.getChannelCountAll());
                    stringNodeText.append("CH");
                }
                stringNodeText.append(")");
            }
            this.setText(stringNodeText.toString());
            if (selected && o_SourceObject instanceof DMXDeviceType) {
                this.setBorder(this.m_SelectionBorder);
            } else {
                this.setBorder(null);
            }
            return this;
        }
    }

    public static class DMXDeviceTypeTreeModel<TNode extends DMXDeviceTypeTreeNode<?>>
    implements TreeModel {
        private TreeNode m_Root;
        private ArrayList<TreeModelListener> m_TreeModelListeners;
        private final Object m_SyncListeners = new Object();

        public DMXDeviceTypeTreeModel() {
            this.m_Root = new DMXDeviceTypeTreeNode<Object>(null);
            this.m_TreeModelListeners = new ArrayList();
        }

        @Override
        public Object getRoot() {
            return this.m_Root;
        }

        public void addChild(TNode parent, TNode p_Child) {
            if (parent == null) {
                return;
            }
            if (p_Child == null) {
                return;
            }
            ((DMXDeviceTypeTreeNode)parent).addChild((DMXDeviceTypeTreeNode<?>)p_Child);
            Object[] o_ParentPathToRoot = (DMXDeviceTypeTreeNode[])this.getPathToRoot(parent);
            int[] o_Indexs = new int[1];
            Object[] o_Childs = new Object[1];
            o_Indexs[0] = ((DMXDeviceTypeTreeNode)parent).getIndex((TreeNode)p_Child);
            o_Childs[0] = p_Child;
            if (o_Indexs[0] != -1) {
                this.fireTreeNodesInserted(this, o_ParentPathToRoot, o_Indexs, o_Childs);
            }
        }

        public void removeChild(TNode p_ParentTreeNode, TNode p_ChildTreeNode) {
            if (p_ParentTreeNode == null) {
                return;
            }
            if (p_ChildTreeNode == null) {
                return;
            }
            int[] o_Indexs = new int[1];
            Object[] o_Childs = new Object[1];
            o_Indexs[0] = ((DMXDeviceTypeTreeNode)p_ParentTreeNode).getIndex((TreeNode)p_ChildTreeNode);
            o_Childs[0] = p_ChildTreeNode;
            if (o_Indexs[0] != -1) {
                Object[] o_ParentPathToRoot = (DMXDeviceTypeTreeNode[])this.getPathToRoot(p_ParentTreeNode);
                ((DMXDeviceTypeTreeNode)p_ParentTreeNode).removeChild((DMXDeviceTypeTreeNode<?>)p_ChildTreeNode);
                this.fireTreeNodesRemoved(this, o_ParentPathToRoot, o_Indexs, o_Childs);
                this.invokeTreeNodeChanged(p_ParentTreeNode);
            }
        }

        public TNode getChild(Object parent, int index) {
            if (parent instanceof DMXDeviceTypeTreeNode) {
                return (TNode)((DMXDeviceTypeTreeNode)parent).getChildAt(index);
            }
            return null;
        }

        @Override
        public int getChildCount(Object parent) {
            if (parent instanceof DMXDeviceTypeTreeNode) {
                return ((DMXDeviceTypeTreeNode)parent).getChildCount();
            }
            return 0;
        }

        @Override
        public boolean isLeaf(Object node) {
            if (node instanceof DMXDeviceTypeTreeNode) {
                return ((DMXDeviceTypeTreeNode)node).isLeaf();
            }
            return true;
        }

        @Override
        public void valueForPathChanged(TreePath path, Object newValue) {
        }

        @Override
        public int getIndexOfChild(Object parent, Object child) {
            if (parent instanceof DMXDeviceTypeTreeNode) {
                return ((DMXDeviceTypeTreeNode)parent).getIndex((DMXDeviceTypeTreeNode)child);
            }
            return 0;
        }

        public ArrayList<TNode> getArrayListPathToRoot(TNode p_DeviceTypeNode) {
            ArrayList<TNode> o_ArrayListPathToRoot = new ArrayList<TNode>();
            for (Object o_TreeNode = p_DeviceTypeNode; o_TreeNode != null; o_TreeNode = ((DMXDeviceTypeTreeNode)o_TreeNode).getParent()) {
                o_ArrayListPathToRoot.add(0, o_TreeNode);
            }
            return o_ArrayListPathToRoot;
        }

        public Object[] getPathToRoot(TNode p_DeviceTypeNode) {
            ArrayList<TNode> o_ArrayListPathToRoot = this.getArrayListPathToRoot(p_DeviceTypeNode);
            Object[] o_PathToRoot = new DMXDeviceTypeTreeNode[o_ArrayListPathToRoot.size()];
            for (int intNode = 0; intNode < o_ArrayListPathToRoot.size(); ++intNode) {
                o_PathToRoot[intNode] = (DMXDeviceTypeTreeNode)o_ArrayListPathToRoot.get(intNode);
            }
            return o_PathToRoot;
        }

        public TreePath getTreePathToRoot(TNode p_DeviceTypeNode) {
            if (p_DeviceTypeNode == null) {
                return null;
            }
            return new TreePath(this.getPathToRoot(p_DeviceTypeNode));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addTreeModelListener(TreeModelListener p_TreeModelListener) {
            if (p_TreeModelListener == null) {
                return;
            }
            Object object = this.m_SyncListeners;
            synchronized (object) {
                if (this.m_TreeModelListeners.contains(p_TreeModelListener)) {
                    return;
                }
                this.m_TreeModelListeners.add(p_TreeModelListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeTreeModelListener(TreeModelListener p_TreeModelListener) {
            Object object = this.m_SyncListeners;
            synchronized (object) {
                if (p_TreeModelListener == null) {
                    return;
                }
                this.m_TreeModelListeners.remove(p_TreeModelListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void fireTreeNodesInserted(Object source, Object[] path, int[] childIndices, Object[] children) {
            ArrayList<TreeModelListener> o_Listeners;
            Object object = this.m_SyncListeners;
            synchronized (object) {
                o_Listeners = new ArrayList<TreeModelListener>(this.m_TreeModelListeners.size());
                o_Listeners.addAll(this.m_TreeModelListeners);
            }
            TreeModelEvent e = null;
            for (int i = 0; i < o_Listeners.size(); ++i) {
                if (e == null) {
                    e = new TreeModelEvent(source, path, childIndices, children);
                }
                ((TreeModelListener)o_Listeners.get(i)).treeNodesInserted(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void fireTreeNodesRemoved(Object source, Object[] path, int[] childIndices, Object[] children) {
            ArrayList<TreeModelListener> o_Listeners;
            Object object = this.m_SyncListeners;
            synchronized (object) {
                o_Listeners = new ArrayList<TreeModelListener>(this.m_TreeModelListeners.size());
                o_Listeners.addAll(this.m_TreeModelListeners);
            }
            TreeModelEvent e = null;
            for (int i = 0; i < o_Listeners.size(); ++i) {
                if (e == null) {
                    e = new TreeModelEvent(source, path, childIndices, children);
                }
                ((TreeModelListener)o_Listeners.get(i)).treeNodesRemoved(e);
            }
        }

        private void invokeTreeNodeChanged(TNode p_ChangedTreeNode) {
            if (p_ChangedTreeNode == null) {
                return;
            }
            TreeNode o_ParentNode = ((DMXDeviceTypeTreeNode)p_ChangedTreeNode).getParent();
            if (o_ParentNode == null) {
                if (p_ChangedTreeNode == this.getRoot()) {
                    this.fireTreeNodesChanged(this, this.getPathToRoot(p_ChangedTreeNode), null, null);
                }
            } else {
                int[] o_Indexs = new int[]{((DMXDeviceTypeTreeNode)o_ParentNode).getIndex((TreeNode)p_ChangedTreeNode)};
                if (o_Indexs[0] != -1) {
                    Object[] o_Childs = new Object[]{p_ChangedTreeNode};
                    this.fireTreeNodesChanged(this, this.getPathToRoot(o_ParentNode), o_Indexs, o_Childs);
                }
            }
        }

        public void fireTreeNodeChanged(TreeNode p_ChangedTreeNode) {
            if (p_ChangedTreeNode == null) {
                return;
            }
            this.invokeTreeNodeChanged((DMXDeviceTypeTreeNode)p_ChangedTreeNode);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireTreeNodesChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
            ArrayList<TreeModelListener> o_Listeners;
            Object object = this.m_SyncListeners;
            synchronized (object) {
                o_Listeners = new ArrayList<TreeModelListener>(this.m_TreeModelListeners.size());
                o_Listeners.addAll(this.m_TreeModelListeners);
            }
            TreeModelEvent e = null;
            for (int i = 0; i < o_Listeners.size(); ++i) {
                if (e == null) {
                    e = new TreeModelEvent(source, path, childIndices, children);
                }
                ((TreeModelListener)o_Listeners.get(i)).treeNodesChanged(e);
            }
        }

        public void fireTreeStructureChanged() {
            if (this.m_Root == null) {
                return;
            }
            int[] o_Indexs = new int[1];
            Object[] o_Childs = new Object[1];
            o_Indexs[0] = 0;
            o_Childs[0] = this.m_Root;
            this.fireTreeStructureChanged(this, this.getPathToRoot((DMXDeviceTypeTreeNode)this.m_Root), o_Indexs, o_Childs);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireTreeStructureChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
            ArrayList<TreeModelListener> o_Listeners;
            Object object = this.m_SyncListeners;
            synchronized (object) {
                o_Listeners = new ArrayList<TreeModelListener>(this.m_TreeModelListeners.size());
                o_Listeners.addAll(this.m_TreeModelListeners);
            }
            TreeModelEvent e = null;
            for (int i = 0; i < o_Listeners.size(); ++i) {
                if (e == null) {
                    e = new TreeModelEvent(source, path, childIndices, children);
                }
                ((TreeModelListener)o_Listeners.get(i)).treeStructureChanged(e);
            }
        }
    }

    public static class DMXDeviceTypeTreeNode<T>
    implements TreeNode {
        private DMXDeviceTypeTreeNode<?> m_Parent;
        private ArrayList<DMXDeviceTypeTreeNode<?>> m_ArrayListChildren = new ArrayList();
        private T m_SourceObject;

        public DMXDeviceTypeTreeNode(T p_SourceObject) {
            this.m_SourceObject = p_SourceObject;
        }

        public void addChild(DMXDeviceTypeTreeNode<?> p_Child) {
            if (p_Child == null) {
                return;
            }
            if (this.m_ArrayListChildren.contains(p_Child)) {
                return;
            }
            this.m_ArrayListChildren.add(p_Child);
            p_Child.setParent(this);
        }

        public void removeChild(DMXDeviceTypeTreeNode<?> p_Child) {
            if (p_Child == null) {
                return;
            }
            if (this.m_ArrayListChildren.remove(p_Child)) {
                p_Child.setParent(null);
            }
        }

        @Override
        public DMXDeviceTypeTreeNode<?> getChildAt(int childIndex) {
            if (this.m_ArrayListChildren == null) {
                return null;
            }
            if (childIndex < 0) {
                return null;
            }
            if (childIndex >= this.m_ArrayListChildren.size()) {
                return null;
            }
            return this.m_ArrayListChildren.get(childIndex);
        }

        @Override
        public int getChildCount() {
            if (this.m_ArrayListChildren == null) {
                return 0;
            }
            return this.m_ArrayListChildren.size();
        }

        @Override
        public DMXDeviceTypeTreeNode<?> getParent() {
            return this.m_Parent;
        }

        public void setParent(DMXDeviceTypeTreeNode<?> p_Parent) {
            this.m_Parent = p_Parent;
        }

        @Override
        public int getIndex(TreeNode node) {
            if (node == null) {
                return -1;
            }
            return this.m_ArrayListChildren.indexOf(node);
        }

        @Override
        public boolean getAllowsChildren() {
            return true;
        }

        @Override
        public boolean isLeaf() {
            if (this.m_ArrayListChildren == null) {
                return true;
            }
            return this.m_ArrayListChildren.size() <= 0;
        }

        public Enumeration<DMXDeviceTypeTreeNode<?>> children() {
            return Collections.enumeration(this.m_ArrayListChildren);
        }

        public ArrayList<DMXDeviceTypeTreeNode<?>> getChildren() {
            return this.m_ArrayListChildren;
        }

        public DMXDeviceTypeTreeNode<?> getChildByManufactureer(String p_String) {
            if (p_String == null) {
                return null;
            }
            ArrayList<DMXDeviceTypeTreeNode<?>> o_Children = this.getChildren();
            for (int intChild = 0; intChild < o_Children.size(); ++intChild) {
                String stringToCompare;
                DMXDeviceTypeTreeNode<?> o_TreeNode = o_Children.get(intChild);
                if (o_TreeNode == null) continue;
                Object o_SourceObject = o_TreeNode.getSourceObject();
                if (o_SourceObject instanceof String) {
                    stringToCompare = (String)o_SourceObject;
                } else {
                    if (!(this.m_SourceObject instanceof DMXDeviceType)) continue;
                    stringToCompare = ((DMXDeviceType)o_SourceObject).getManufactureerName();
                }
                if (!p_String.equals(stringToCompare)) continue;
                return o_TreeNode;
            }
            return null;
        }

        public T getSourceObject() {
            return this.m_SourceObject;
        }

        public void setSourceObject(T p_SourceObject) {
            this.m_SourceObject = p_SourceObject;
        }
    }

    public static class DMXDeviceChannelType
    implements PropertyChangeListener {
        public static final String PROP_DMXDEVICECHANNELTYPE_CHANNELNAME = "dmxdevicechanneltypeChannelName";
        public static final String PROP_DMXDEVICECHANNELTYPE_INDEXED_CHANNELCONTROLLINK = "dmxdevicechanneltypeChannelControlLink";
        private DMXDeviceSector m_DMXDeviceSectorType;
        private int m_InternalChannelIndex;
        private ArrayList<ChannelControlLink> m_ChannelControlLinks;
        private ArrayList<DMXControlComponent.DeviceControlLink> m_DimmerLinks;
        private ArrayList<DMXControlComponent.DeviceControlLink> m_DimmerSubstituteLinks;
        private boolean m_HasDisabledInFunctions;
        private boolean m_HasDisabledDMXControl;
        private boolean m_HasDisabledDMXControlAdjustment;
        private SinglePropertyChangeSupport m_PropertyChangeSupport;

        public DMXDeviceChannelType(DMXDeviceSector p_DMXDeviceType, int p_InternalChannel) {
            this.initMembers();
            this.m_DMXDeviceSectorType = p_DMXDeviceType;
            this.m_InternalChannelIndex = p_InternalChannel;
        }

        private void initMembers() {
            this.m_DMXDeviceSectorType = null;
            this.m_ChannelControlLinks = new ArrayList();
            this.m_InternalChannelIndex = -1;
            this.m_PropertyChangeSupport = new SinglePropertyChangeSupport(this);
            this.m_DimmerLinks = new ArrayList();
            this.m_DimmerSubstituteLinks = new ArrayList();
            this.m_HasDisabledInFunctions = false;
            this.m_HasDisabledDMXControl = false;
            this.m_HasDisabledDMXControlAdjustment = false;
        }

        public void close() {
            if (this.m_ChannelControlLinks != null) {
                for (int intLink = this.m_ChannelControlLinks.size() - 1; intLink >= 0; --intLink) {
                    ChannelControlLink o_ChannelControlLink = this.m_ChannelControlLinks.get(intLink);
                    if (o_ChannelControlLink == null) continue;
                    o_ChannelControlLink.close();
                }
                this.m_ChannelControlLinks.clear();
                this.m_DimmerLinks.clear();
                this.m_DimmerSubstituteLinks.clear();
            }
            this.m_DMXDeviceSectorType = null;
            this.m_InternalChannelIndex = -1;
            this.clearPropertyChangeListener();
        }

        public void finalize() throws Throwable {
            super.finalize();
            this.m_PropertyChangeSupport = null;
        }

        public boolean addDeviceControlLink(DMXControlComponent.DeviceControlLink p_DeviceControlLink, int p_ByteIndex) {
            if (p_DeviceControlLink == null) {
                return false;
            }
            if (p_ByteIndex < 0) {
                return false;
            }
            ChannelControlLink o_ChannelControlLink = this.findChannelControlLink(p_DeviceControlLink, p_ByteIndex);
            if (o_ChannelControlLink != null) {
                return true;
            }
            o_ChannelControlLink = new ChannelControlLink(this, p_DeviceControlLink, p_ByteIndex);
            p_DeviceControlLink.getControlDimensionType().addPropertyChangeListener(this);
            p_DeviceControlLink.getControlType().addPropertyChangeListener(this);
            boolean boolAdded = false;
            boolAdded = this.addChannelControlLink(o_ChannelControlLink);
            if (boolAdded) {
                this.m_PropertyChangeSupport.firePropertyChange(PROP_DMXDEVICECHANNELTYPE_CHANNELNAME, null, this.getChannelName());
            }
            return boolAdded;
        }

        public boolean removeDeviceControlLink(DMXControlComponent.DeviceControlLink p_DeviceControlLink, int p_ByteIndex) {
            if (p_DeviceControlLink == null) {
                return false;
            }
            if (p_ByteIndex < 0) {
                return false;
            }
            ChannelControlLink o_ChannelControlLink = this.findChannelControlLink(p_DeviceControlLink, p_ByteIndex);
            if (o_ChannelControlLink == null) {
                return false;
            }
            p_DeviceControlLink.getControlDimensionType().removePropertyChangeListener(this);
            p_DeviceControlLink.getControlType().removePropertyChangeListener(this);
            boolean boolRemoved = false;
            boolRemoved = this.removeChannelControlLink(o_ChannelControlLink);
            if (boolRemoved) {
                this.m_PropertyChangeSupport.firePropertyChange(PROP_DMXDEVICECHANNELTYPE_CHANNELNAME, this.getChannelName(), null);
            }
            return boolRemoved;
        }

        public DMXControlComponent.DMXControlType getDMXControlType() {
            if (this.m_ChannelControlLinks.size() <= 0) {
                return null;
            }
            if (this.m_ChannelControlLinks.size() == 1) {
                ChannelControlLink o_ChannelControlLink = this.m_ChannelControlLinks.get(0);
                o_ChannelControlLink.getDeviceControlLink();
                if (o_ChannelControlLink == null) {
                    return null;
                }
                DMXControlComponent.DeviceControlLink o_DeviceControlLink = o_ChannelControlLink.getDeviceControlLink();
                if (o_DeviceControlLink == null) {
                    return null;
                }
                return o_DeviceControlLink.getDMXControlType();
            }
            return null;
        }

        public DMXControlComponent.ControlDimensionType getControlDimensionType() {
            if (this.m_ChannelControlLinks.size() <= 0) {
                return null;
            }
            if (this.m_ChannelControlLinks.size() == 1) {
                ChannelControlLink o_ChannelControlLink = this.m_ChannelControlLinks.get(0);
                o_ChannelControlLink.getDeviceControlLink();
                if (o_ChannelControlLink == null) {
                    return null;
                }
                DMXControlComponent.DeviceControlLink o_DeviceControlLink = o_ChannelControlLink.getDeviceControlLink();
                if (o_DeviceControlLink == null) {
                    return null;
                }
                return o_DeviceControlLink.getControlDimensionType();
            }
            return null;
        }

        public boolean addChannelControlLink(ChannelControlLink p_ChannelControlLink) {
            if (p_ChannelControlLink == null) {
                return false;
            }
            if (this.m_ChannelControlLinks.contains(p_ChannelControlLink)) {
                return true;
            }
            boolean boolAdded = false;
            boolAdded = this.m_ChannelControlLinks.add(p_ChannelControlLink);
            if (boolAdded) {
                DMXControlComponent.DeviceControlLink o_DeviceControlLink = p_ChannelControlLink.getDeviceControlLink();
                if ("dimmer".equals(o_DeviceControlLink.getDMXControlType().getDMXControlDescription().getID()) && !this.m_DimmerLinks.contains(o_DeviceControlLink)) {
                    this.m_DimmerLinks.add(o_DeviceControlLink);
                }
                if (o_DeviceControlLink.getDMXControlType().getIsDimmerSubstitute() && !this.m_DimmerSubstituteLinks.contains(o_DeviceControlLink)) {
                    this.m_DimmerSubstituteLinks.add(o_DeviceControlLink);
                }
                this.checkDisabledDMXControl();
                this.m_PropertyChangeSupport.fireIndexedPropertyChange("dmxdevicechanneltypeChannelControlLink", this.m_InternalChannelIndex, null, p_ChannelControlLink);
            }
            return boolAdded;
        }

        public boolean removeChannelControlLink(ChannelControlLink p_ChannelControlLink) {
            boolean boolRemoved = false;
            boolRemoved = this.m_ChannelControlLinks.remove(p_ChannelControlLink);
            if (boolRemoved) {
                DMXControlComponent.DeviceControlLink o_DeviceControlLink = p_ChannelControlLink.getDeviceControlLink();
                if (this.m_DimmerLinks.contains(o_DeviceControlLink)) {
                    this.m_DimmerLinks.remove(o_DeviceControlLink);
                }
                if (this.m_DimmerSubstituteLinks.contains(o_DeviceControlLink)) {
                    this.m_DimmerSubstituteLinks.remove(o_DeviceControlLink);
                }
                p_ChannelControlLink.close();
                this.checkDisabledDMXControl();
                this.m_PropertyChangeSupport.fireIndexedPropertyChange("dmxdevicechanneltypeChannelControlLink", this.m_InternalChannelIndex, p_ChannelControlLink, null);
            }
            return boolRemoved;
        }

        ChannelControlLink findChannelControlLink(DMXControlComponent.DeviceControlLink p_DeviceControlLink, int p_ByteIndex) {
            for (int intLink = 0; intLink < this.m_ChannelControlLinks.size(); ++intLink) {
                ChannelControlLink o_ChannelControlLink = this.m_ChannelControlLinks.get(intLink);
                if (o_ChannelControlLink == null || o_ChannelControlLink.getDeviceControlLink() != p_DeviceControlLink || o_ChannelControlLink.getByteIndex() != p_ByteIndex) continue;
                return o_ChannelControlLink;
            }
            return null;
        }

        public DMXDeviceType getDMXDeviceType() {
            return this.m_DMXDeviceSectorType.getDMXDeviceType();
        }

        public DMXDeviceSector getDMXDeviceSectorType() {
            return this.m_DMXDeviceSectorType;
        }

        public int getChannelIndex() {
            return this.m_InternalChannelIndex;
        }

        public int getChannelControlLinkCount() {
            return this.m_ChannelControlLinks.size();
        }

        public ChannelControlLink getChannelControlLink(int p_Index) {
            if (p_Index < 0) {
                return null;
            }
            if (p_Index >= this.m_ChannelControlLinks.size()) {
                return null;
            }
            return this.m_ChannelControlLinks.get(p_Index);
        }

        public boolean getIsDimmerChannel() {
            return this.m_DimmerLinks.size() > 0;
        }

        public ArrayList<DMXControlComponent.DeviceControlLink> getDimmerDeviceControlLinks() {
            return this.m_DimmerLinks;
        }

        public boolean getIsDimmerSubstituteChannel() {
            return this.m_DimmerSubstituteLinks.size() > 0;
        }

        public ArrayList<DMXControlComponent.DeviceControlLink> getDimmerSubstituteDeviceControlLinks() {
            return this.m_DimmerSubstituteLinks;
        }

        public void checkDisabledDMXControl() {
            boolean boolFoundDisabledInFunctions = false;
            boolean boolFoundDisabled = false;
            boolean boolFoundDisabledAdjustment = false;
            for (int intChannelControlLink = 0; intChannelControlLink < this.m_ChannelControlLinks.size(); ++intChannelControlLink) {
                DMXFadeDescription.DMXControlTypeFadeDescription o_DMXControlTypeFadeDescription;
                DMXControlComponent.DMXControlType o_DMXControlType;
                DMXControlComponent.DeviceControlLink o_DeviceControlLink;
                ChannelControlLink o_ChannelControlLink = this.m_ChannelControlLinks.get(intChannelControlLink);
                if (o_ChannelControlLink == null || (o_DeviceControlLink = o_ChannelControlLink.getDeviceControlLink()) == null || (o_DMXControlType = o_DeviceControlLink.getDMXControlType()) == null) continue;
                if (o_DMXControlType.getIsDisabledInFunctions()) {
                    boolFoundDisabledInFunctions = true;
                }
                if ((o_DMXControlTypeFadeDescription = this.m_DMXDeviceSectorType.getDMXDeviceType().getDefaultDMXDeviceFadeDescription().getDMXControlTypeFadeDescription(o_DMXControlType.getID())) == null) continue;
                if (o_DMXControlTypeFadeDescription.getDisabled()) {
                    boolFoundDisabled = true;
                }
                if (o_DMXControlTypeFadeDescription.getDisabledAdjustment()) {
                    boolFoundDisabledAdjustment = true;
                }
                if (boolFoundDisabled && boolFoundDisabledAdjustment) break;
            }
            this.m_HasDisabledInFunctions = boolFoundDisabledInFunctions;
            this.m_HasDisabledDMXControl = boolFoundDisabled;
            this.m_HasDisabledDMXControlAdjustment = boolFoundDisabledAdjustment;
        }

        public boolean hasDisabledInFunctionsDMXControl() {
            return this.m_HasDisabledInFunctions;
        }

        public boolean hasDisabledDMXControl() {
            return this.m_HasDisabledDMXControl;
        }

        public boolean hasDisabledAdjustmentDMXControl() {
            return this.m_HasDisabledDMXControlAdjustment;
        }

        public void checkDimmerSubstitute() {
            for (int intChannelControlLink = 0; intChannelControlLink < this.m_ChannelControlLinks.size(); ++intChannelControlLink) {
                DMXControlComponent.DMXControlType o_DMXControlType;
                DMXControlComponent.DeviceControlLink o_DeviceControlLink;
                ChannelControlLink o_ChannelControlLink = this.m_ChannelControlLinks.get(intChannelControlLink);
                if (o_ChannelControlLink == null || (o_DeviceControlLink = o_ChannelControlLink.getDeviceControlLink()) == null || (o_DMXControlType = o_DeviceControlLink.getDMXControlType()) == null) continue;
                if (o_DMXControlType.getIsDimmerSubstitute()) {
                    if (this.m_DimmerSubstituteLinks.contains(o_DeviceControlLink)) continue;
                    this.m_DimmerSubstituteLinks.add(o_DeviceControlLink);
                    continue;
                }
                if (!this.m_DimmerSubstituteLinks.contains(o_DeviceControlLink)) continue;
                this.m_DimmerSubstituteLinks.remove(o_DeviceControlLink);
            }
        }

        public String getChannelName() {
            String stringChannelName = "";
            int intChannelControlLinkCount = this.m_ChannelControlLinks.size();
            if (intChannelControlLinkCount <= 0) {
                return stringChannelName;
            }
            stringChannelName = "";
            for (int intChannelLink = 0; intChannelLink < intChannelControlLinkCount; ++intChannelLink) {
                ChannelControlLink o_ChannelControlLink;
                if (intChannelLink > 0) {
                    stringChannelName = stringChannelName + ", ";
                }
                if ((o_ChannelControlLink = this.m_ChannelControlLinks.get(intChannelLink)) == null) continue;
                stringChannelName = stringChannelName + o_ChannelControlLink.getChannelName();
            }
            return stringChannelName;
        }

        public void addPropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
            if (p_PropertyChangeListener == null) {
                return;
            }
            this.m_PropertyChangeSupport.addPropertyChangeListener(p_PropertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
            this.m_PropertyChangeSupport.removePropertyChangeListener(p_PropertyChangeListener);
        }

        public void clearPropertyChangeListener() {
            if (this.m_PropertyChangeSupport != null) {
                this.m_PropertyChangeSupport.clear();
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() instanceof DMXControlComponent.ControlType && "controltypeName".equals(evt.getPropertyName())) {
                this.m_PropertyChangeSupport.firePropertyChange(PROP_DMXDEVICECHANNELTYPE_CHANNELNAME, evt.getOldValue(), evt.getNewValue());
            }
            if (evt.getSource() instanceof DMXControlComponent.ControlDimensionType && "controldimensiontypeName".equals(evt.getPropertyName())) {
                this.m_PropertyChangeSupport.firePropertyChange(PROP_DMXDEVICECHANNELTYPE_CHANNELNAME, evt.getOldValue(), evt.getNewValue());
            }
        }

        public static class ChannelControlLink
        implements PropertyChangeListener {
            private DMXDeviceChannelType m_DMXDeviceChannelType;
            private DMXControlComponent.DeviceControlLink m_DeviceControlLink;
            private int m_ByteIndex;
            private StringBuilder m_StringBuilder;
            private final Object m_SyncStringBuilder = new Object();

            public ChannelControlLink(DMXDeviceChannelType p_DMXDeviceChannelType, DMXControlComponent.DeviceControlLink p_DeviceControlLink, int p_ByteIndex) {
                this.initMembers();
                this.m_DMXDeviceChannelType = p_DMXDeviceChannelType;
                this.m_DeviceControlLink = p_DeviceControlLink;
                this.m_ByteIndex = p_ByteIndex;
                this.m_DeviceControlLink.addPropertyChangeListener(this);
            }

            private void initMembers() {
                this.m_StringBuilder = new StringBuilder();
            }

            public void close() {
                if (this.m_DeviceControlLink != null) {
                    this.m_DeviceControlLink.removePropertyChangeListener(this);
                }
                this.m_DeviceControlLink = null;
                this.m_ByteIndex = -1;
                this.m_DMXDeviceChannelType = null;
            }

            public DMXDeviceChannelType getDMXDeviceChannelType() {
                return this.m_DMXDeviceChannelType;
            }

            public DMXControlComponent.DeviceControlLink getDeviceControlLink() {
                return this.m_DeviceControlLink;
            }

            public int getByteIndex() {
                return this.m_ByteIndex;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public String getChannelName() {
                if (this.m_DeviceControlLink == null) {
                    return "-";
                }
                Object object = this.m_SyncStringBuilder;
                synchronized (object) {
                    DMXControlComponent.ControlDimensionType o_ControlDimensionType;
                    DMXControlComponent.ControlType o_ControlType;
                    boolean boolAddNext = true;
                    DMXControlComponent.DMXControlType o_DMXControlType = this.m_DeviceControlLink.getDMXControlType();
                    if (o_DMXControlType == null) {
                        return "-";
                    }
                    this.m_StringBuilder.delete(0, this.m_StringBuilder.length());
                    this.m_StringBuilder.append(o_DMXControlType.getName());
                    if (o_DMXControlType.getControlTypeCount() <= 1) {
                        boolAddNext = false;
                    }
                    if ((o_ControlType = this.m_DeviceControlLink.getControlType()) == null) {
                        return this.m_StringBuilder.toString();
                    }
                    if (boolAddNext) {
                        this.m_StringBuilder.append(" ");
                        this.m_StringBuilder.append(o_ControlType.getName());
                    }
                    boolAddNext = true;
                    if (o_ControlType.getControlDimensionTypeCount() <= 1) {
                        boolAddNext = false;
                    }
                    if ((o_ControlDimensionType = this.m_DeviceControlLink.getControlDimensionType()) == null) {
                        return this.m_StringBuilder.toString();
                    }
                    if (boolAddNext) {
                        this.m_StringBuilder.append(" ");
                        this.m_StringBuilder.append(o_ControlDimensionType.getName());
                    }
                    if (o_ControlDimensionType.getByteResolution() > 1) {
                        if (this.m_ByteIndex == 0) {
                            this.m_StringBuilder.append(" ");
                            this.m_StringBuilder.append(LiveShowDMXSystem.BYTE_0_HIGHBYTE);
                        } else if (this.m_ByteIndex == 1) {
                            this.m_StringBuilder.append(" ");
                            this.m_StringBuilder.append(LiveShowDMXSystem.BYTE_1_LOWHBYTE);
                        } else {
                            this.m_StringBuilder.append(" ");
                            this.m_StringBuilder.append(this.m_ByteIndex);
                        }
                    }
                    return this.m_StringBuilder.toString();
                }
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getSource() instanceof DMXControlComponent.DeviceControlLink && "deviceInternalChannel".equals(evt.getPropertyName())) {
                    int intOldInternalChannel = (Integer)evt.getOldValue();
                    int intNewInternalChannel = (Integer)evt.getNewValue();
                    if (intNewInternalChannel < 0 && intOldInternalChannel == this.m_DMXDeviceChannelType.getChannelIndex()) {
                        this.m_DMXDeviceChannelType.removeDeviceControlLink(this.m_DeviceControlLink, this.m_ByteIndex);
                    }
                }
            }
        }
    }

    public static class DMXDeviceSector
    implements Externalizable,
    PropertyChangeListener {
        protected DMXDeviceType m_DMXDeviceType;
        protected int m_SectorIndex;
        protected String m_SectorName;
        protected ArrayList<DMXDeviceChannelType> m_DeviceChannelTypes;
        protected int m_Wattage;
        protected SinglePropertyChangeSupport m_PropertyChangeSupport;

        public DMXDeviceSector(DMXDeviceType p_DMXDeviceType, int p_SectorIndex) {
            this.initMembers();
            this.m_DMXDeviceType = p_DMXDeviceType;
            this.m_SectorIndex = p_SectorIndex;
            this.m_SectorName = SECTORNAME + " " + String.valueOf(this.m_SectorIndex + 1);
        }

        private void initMembers() {
            this.m_PropertyChangeSupport = new SinglePropertyChangeSupport(this);
            this.m_DeviceChannelTypes = new ArrayList();
            DMXDeviceChannelType o_DMXDeviceChannelType = new DMXDeviceChannelType(this, 0);
            this.addDMXDeviceChannelType(o_DMXDeviceChannelType);
            this.m_Wattage = 100;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.m_DeviceChannelTypes.size());
            out.writeInt(this.m_Wattage);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int intChannelTypeCount = in.readInt();
            if (this.m_DMXDeviceType.getSoftwareVersionRead() >= 2) {
                this.m_Wattage = in.readInt();
            }
            DMXDeviceChannelType o_DMXDeviceChannelType = this.m_DeviceChannelTypes.get(0);
            this.removeDeviceChannelType(o_DMXDeviceChannelType);
            for (int intChannel = 0; intChannel < intChannelTypeCount; ++intChannel) {
                o_DMXDeviceChannelType = new DMXDeviceChannelType(this, intChannel);
                this.addDMXDeviceChannelType(o_DMXDeviceChannelType);
            }
        }

        public long getDiskSpaceEstimated() {
            long longBytesCount = 0L;
            longBytesCount += 4L;
            return longBytesCount += 4L;
        }

        public void close() {
            if (this.m_DeviceChannelTypes != null) {
                for (int intChannel = this.m_DeviceChannelTypes.size() - 1; intChannel >= 0; --intChannel) {
                    DMXDeviceChannelType o_DMXDeviceChannelType = this.m_DeviceChannelTypes.get(intChannel);
                    if (o_DMXDeviceChannelType == null) continue;
                    o_DMXDeviceChannelType.removePropertyChangeListener(this);
                    this.m_DeviceChannelTypes.remove(o_DMXDeviceChannelType);
                    o_DMXDeviceChannelType.close();
                }
            }
            this.clearPropertyChangeListener();
        }

        public void finalize() throws Throwable {
            super.finalize();
            this.m_PropertyChangeSupport = null;
        }

        public DMXDeviceType getDMXDeviceType() {
            return this.m_DMXDeviceType;
        }

        public int getSectorIndex() {
            return this.m_SectorIndex;
        }

        public String getSectorName() {
            return this.m_SectorName;
        }

        public boolean addDMXDeviceChannelType(DMXDeviceChannelType p_DMXDeviceChannelType) {
            if (p_DMXDeviceChannelType == null) {
                return false;
            }
            if (this.m_DeviceChannelTypes.contains(p_DMXDeviceChannelType)) {
                return true;
            }
            boolean boolAdded = false;
            boolAdded = this.m_DeviceChannelTypes.add(p_DMXDeviceChannelType);
            if (boolAdded) {
                p_DMXDeviceChannelType.addPropertyChangeListener(this);
                this.m_PropertyChangeSupport.fireIndexedPropertyChange(DMXDeviceType.PROP_DMXDEVICETYPE_INDEXED_DEVICECHANNELTYPE, this.m_DeviceChannelTypes.indexOf(p_DMXDeviceChannelType), null, p_DMXDeviceChannelType);
            }
            return boolAdded;
        }

        private void removeDeviceChannelType(int p_Index) {
            if (p_Index < 0) {
                return;
            }
            if (p_Index >= this.m_DeviceChannelTypes.size()) {
                return;
            }
            DMXDeviceChannelType o_DMXDeviceChannelType = this.m_DeviceChannelTypes.get(p_Index);
            this.removeDeviceChannelType(o_DMXDeviceChannelType);
        }

        public boolean removeDeviceChannelType(DMXDeviceChannelType p_DMXDeviceChannelType) {
            if (p_DMXDeviceChannelType == null) {
                return false;
            }
            if (!this.m_DeviceChannelTypes.contains(p_DMXDeviceChannelType)) {
                return false;
            }
            boolean boolRemoved = false;
            int intIndex = this.m_DeviceChannelTypes.indexOf(p_DMXDeviceChannelType);
            boolRemoved = this.m_DeviceChannelTypes.remove(p_DMXDeviceChannelType);
            if (boolRemoved) {
                p_DMXDeviceChannelType.removePropertyChangeListener(this);
                this.m_PropertyChangeSupport.fireIndexedPropertyChange(DMXDeviceType.PROP_DMXDEVICETYPE_INDEXED_DEVICECHANNELTYPE, intIndex, p_DMXDeviceChannelType, null);
                p_DMXDeviceChannelType.close();
            }
            return boolRemoved;
        }

        public DMXDeviceChannelType getDMXDeviceChannelType(int p_InternalChannel) {
            if (p_InternalChannel < 0) {
                return null;
            }
            if (p_InternalChannel >= this.m_DeviceChannelTypes.size()) {
                return null;
            }
            return this.m_DeviceChannelTypes.get(p_InternalChannel);
        }

        public int getChannelCount() {
            return this.m_DeviceChannelTypes.size();
        }

        public void setChannelCount(int p_ChannelCount) {
            if (p_ChannelCount < 0) {
                return;
            }
            if (p_ChannelCount == this.m_DeviceChannelTypes.size()) {
                return;
            }
            int oldValue = this.m_DeviceChannelTypes.size();
            if (oldValue < p_ChannelCount) {
                for (int intChannel = oldValue; intChannel < p_ChannelCount; ++intChannel) {
                    DMXDeviceChannelType o_DeviceChannelType = new DMXDeviceChannelType(this, intChannel);
                    this.addDMXDeviceChannelType(o_DeviceChannelType);
                }
            } else if (this.m_DeviceChannelTypes.size() > p_ChannelCount) {
                for (int intChannel = this.m_DeviceChannelTypes.size() - 1; intChannel > p_ChannelCount - 1; --intChannel) {
                    DMXDeviceChannelType o_DeviceChannelType = this.m_DeviceChannelTypes.get(intChannel);
                    this.removeDeviceChannelType(o_DeviceChannelType);
                }
            }
            this.m_PropertyChangeSupport.firePropertyChange(DMXDeviceType.PROP_DMXDEVICETYPE_CHANNELCOUNT, oldValue, p_ChannelCount);
        }

        public String getChannelName(int p_InternalChannel) {
            String stringChannelName = "";
            if (p_InternalChannel < 0) {
                return stringChannelName;
            }
            if (p_InternalChannel >= this.m_DeviceChannelTypes.size()) {
                return stringChannelName;
            }
            DMXDeviceChannelType o_DeviceChannelType = this.m_DeviceChannelTypes.get(p_InternalChannel);
            return o_DeviceChannelType.getChannelName();
        }

        public void setWattage(int p_Wattage) {
            if (p_Wattage < 0) {
                return;
            }
            if (this.m_Wattage == p_Wattage) {
                return;
            }
            int oldValue = this.m_Wattage;
            this.m_Wattage = p_Wattage;
            this.m_PropertyChangeSupport.firePropertyChange(DMXDeviceType.PROP_DMXDEVICETYPE_INDEXED_WATTAGE, oldValue, this.m_Wattage);
        }

        public int getWattage() {
            return this.m_Wattage;
        }

        public void addPropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
            if (p_PropertyChangeListener == null) {
                return;
            }
            this.m_PropertyChangeSupport.addPropertyChangeListener(p_PropertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
            this.m_PropertyChangeSupport.removePropertyChangeListener(p_PropertyChangeListener);
        }

        public void clearPropertyChangeListener() {
            if (this.m_PropertyChangeSupport != null) {
                this.m_PropertyChangeSupport.clear();
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
        }
    }
}

