/*
 * Decompiled with CFR 0.152.
 */
package DMXDevicePackage;

import DMXDevicePackage.DMXDevice;
import DMXEffectsPackage.DMXEffect;
import DMXGraphics.LiveShowDMXCrossTable_DMXDeviceDMXObject;
import DMXGraphics.LiveShowDMXCrossTable_DMXDeviceDMXScene;
import DMXMixer.DMXControlComponent;
import DMXMixer.DMXControl_GridPanTilt;
import DMXScenePackage.DMXScene;
import DMXScenePackage.DMXSceneCopyInterface;
import DMXVirtualPackage.DMXFadeDescription;
import DMXVirtualPackage.LiveShowDMXObject;
import DMXVirtualPackage.LiveShowDMXObjectCopyInterface;
import DMXVirtualPackage.LiveShowDMXVIP;
import DMXVirtualPackage.LiveShowDMXVIPAdjustment;
import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LanguageTools.LiveLanguagePackage.LiveLanguageString;
import LiveShowObjectPackage.LiveShowObject;
import LiveShowObjectPackage.LiveShowObjectInterface;
import StartPackage.LiveShowDMXSystem;
import SwingModelPackage.TableAndListModel;
import SwingToolTipPackage.PopUpToolTip;
import ToolsGraphics.JLabelBackground;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class DMXDeviceReplacePanel
extends JPanel
implements DMXSceneCopyInterface,
LiveShowDMXObjectCopyInterface {
    @LiveLanguageString
    public static String TAB_SCENES_HEADER = "Scenes";
    @LiveLanguageString
    public static String TAB_OBJECTS_HEADER = "Objects";
    @LiveLanguageString
    public static String TEXT_AFFECTED_SCENES = "Amount of affected scenes:";
    private DMXDevice m_DMXDevice;
    private DMXDevice m_DMXDeviceReplacer;
    private int m_CopyAnswerFlag;
    private JButton jButton_Replace;
    private JComboBox jComboBox_DMXDeviceReplacerSelect;
    private JLabelBackground jLabel_DMXDeviceImage;
    private JLabel jLabel_DMXDeviceName;
    private JLabelBackground jLabel_DMXDeviceReplacerImage;
    private JLabel jLabel_ReplaceStatistic;
    private JLabel jLabel_ReplaceText;
    private JLabel jLabel_ReplaceWarning;
    private JPanel jPanel_Replace;
    private JTabbedPane jTabbedPane_CrossTables;
    private JTextField jTextField_FindFilter;
    private LiveShowDMXCrossTable_DMXDeviceDMXObject liveShowDMXCrossTable_DMXDeviceDMXObject1;
    private LiveShowDMXCrossTable_DMXDeviceDMXScene liveShowDMXCrossTable_DMXDeviceDMXScene1;

    public DMXDeviceReplacePanel() {
        this.initComponents();
        LiveLanguage.addLanguageListener((Object)this, null);
        this.initComponentsFurther();
    }

    private void initComponents() {
        this.jLabel_DMXDeviceReplacerImage = new JLabelBackground();
        this.jLabel_DMXDeviceImage = new JLabelBackground();
        this.jLabel_DMXDeviceName = new JLabel();
        this.jComboBox_DMXDeviceReplacerSelect = new JComboBox();
        this.jLabel_ReplaceText = new JLabel();
        this.jPanel_Replace = new JPanel();
        this.jButton_Replace = new JButton();
        this.jLabel_ReplaceWarning = new JLabel();
        this.jTabbedPane_CrossTables = new JTabbedPane();
        this.liveShowDMXCrossTable_DMXDeviceDMXScene1 = new LiveShowDMXCrossTable_DMXDeviceDMXScene();
        this.liveShowDMXCrossTable_DMXDeviceDMXObject1 = new LiveShowDMXCrossTable_DMXDeviceDMXObject();
        this.jTextField_FindFilter = new JTextField();
        this.jLabel_ReplaceStatistic = new JLabel();
        this.setLayout(new GridBagLayout());
        this.jLabel_DMXDeviceReplacerImage.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.jLabel_DMXDeviceReplacerImage.setMinimumSize(new Dimension(64, 64));
        this.jLabel_DMXDeviceReplacerImage.setPreferredSize(new Dimension(100, 100));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jLabel_DMXDeviceReplacerImage, gridBagConstraints);
        this.jLabel_DMXDeviceImage.setToolTipText("");
        this.jLabel_DMXDeviceImage.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.jLabel_DMXDeviceImage.setMinimumSize(new Dimension(64, 64));
        this.jLabel_DMXDeviceImage.setName("");
        this.jLabel_DMXDeviceImage.setPreferredSize(new Dimension(100, 100));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jLabel_DMXDeviceImage, gridBagConstraints);
        this.jLabel_DMXDeviceName.setHorizontalAlignment(0);
        this.jLabel_DMXDeviceName.setText("jLabel1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 3, 3, 3);
        this.add((Component)this.jLabel_DMXDeviceName, gridBagConstraints);
        this.jComboBox_DMXDeviceReplacerSelect.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBox_DMXDeviceReplacerSelect.setMinimumSize(new Dimension(56, 28));
        this.jComboBox_DMXDeviceReplacerSelect.setPreferredSize(new Dimension(56, 28));
        this.jComboBox_DMXDeviceReplacerSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DMXDeviceReplacePanel.this.jComboBox_DMXDeviceReplacerSelectActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 3, 3, 3);
        this.add((Component)this.jComboBox_DMXDeviceReplacerSelect, gridBagConstraints);
        this.jLabel_ReplaceText.setHorizontalAlignment(0);
        this.jLabel_ReplaceText.setText("Replace with ->");
        this.jLabel_ReplaceText.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 10, 3, 10);
        this.add((Component)this.jLabel_ReplaceText, gridBagConstraints);
        this.jPanel_Replace.setMinimumSize(new Dimension(100, 80));
        this.jPanel_Replace.setPreferredSize(new Dimension(100, 80));
        this.jPanel_Replace.setLayout(new GridBagLayout());
        this.jButton_Replace.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Device_Replace.png")));
        this.jButton_Replace.setToolTipText("replace the device");
        this.jButton_Replace.setMargin(new Insets(-1, -1, -1, -1));
        this.jButton_Replace.setMaximumSize(new Dimension(36, 36));
        this.jButton_Replace.setMinimumSize(new Dimension(36, 36));
        this.jButton_Replace.setPreferredSize(new Dimension(36, 36));
        this.jButton_Replace.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_Replace.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DMXDeviceReplacePanel.this.jButton_ReplaceActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(3, 10, 3, 3);
        this.jPanel_Replace.add((Component)this.jButton_Replace, gridBagConstraints);
        this.jLabel_ReplaceWarning.setForeground(new Color(255, 150, 50));
        this.jLabel_ReplaceWarning.setText("<html>CAUTION:<br>The replacemant is not reverseble</html>");
        this.jLabel_ReplaceWarning.setToolTipText("");
        this.jLabel_ReplaceWarning.setMinimumSize(new Dimension(300, 40));
        this.jLabel_ReplaceWarning.setPreferredSize(new Dimension(300, 40));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 20, 3, 3);
        this.jPanel_Replace.add((Component)this.jLabel_ReplaceWarning, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jPanel_Replace, gridBagConstraints);
        this.jTabbedPane_CrossTables.addTab("tab1", this.liveShowDMXCrossTable_DMXDeviceDMXScene1);
        this.jTabbedPane_CrossTables.addTab("tab2", this.liveShowDMXCrossTable_DMXDeviceDMXObject1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jTabbedPane_CrossTables, gridBagConstraints);
        this.jTextField_FindFilter.setHorizontalAlignment(0);
        this.jTextField_FindFilter.setToolTipText("");
        this.jTextField_FindFilter.setMinimumSize(new Dimension(70, 28));
        this.jTextField_FindFilter.setPreferredSize(new Dimension(100, 28));
        this.jTextField_FindFilter.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                DMXDeviceReplacePanel.this.jTextField_FindFilterKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jTextField_FindFilter, gridBagConstraints);
        this.jLabel_ReplaceStatistic.setHorizontalAlignment(0);
        this.jLabel_ReplaceStatistic.setMaximumSize(new Dimension(0, 24));
        this.jLabel_ReplaceStatistic.setMinimumSize(new Dimension(0, 24));
        this.jLabel_ReplaceStatistic.setPreferredSize(new Dimension(0, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jLabel_ReplaceStatistic, gridBagConstraints);
    }

    private void initComponentsFurther() {
        this.jLabel_DMXDeviceImage.setBackgroundStyle(3);
        this.jLabel_DMXDeviceImage.setBackgroundOpaque(true);
        this.jLabel_DMXDeviceImage.setVisible(true);
        this.jLabel_DMXDeviceName.setVisible(true);
        this.jLabel_DMXDeviceReplacerImage.setBackgroundStyle(3);
        this.jLabel_DMXDeviceReplacerImage.setBackgroundOpaque(true);
        this.jLabel_DMXDeviceReplacerImage.setVisible(true);
        this.jComboBox_DMXDeviceReplacerSelect.setModel(DMXDevice.getDMXDeviceListModel().createListModelWrapper());
        this.jComboBox_DMXDeviceReplacerSelect.setRenderer(DMXDevice.getDMXDeviceListRenderer());
        this.jTabbedPane_CrossTables.setTitleAt(0, TAB_SCENES_HEADER);
        this.jTabbedPane_CrossTables.setTitleAt(1, TAB_OBJECTS_HEADER);
        this.jTextField_FindFilter.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                DMXDeviceReplacePanel.this.jTextField_FindFilter_DocumentChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                DMXDeviceReplacePanel.this.jTextField_FindFilter_DocumentChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                DMXDeviceReplacePanel.this.jTextField_FindFilter_DocumentChanged();
            }
        });
        this.jTextField_FindFilter.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_Replace.setComponentPopupMenu(PopUpToolTip.getSelfReference());
    }

    private void jTextField_FindFilter_DocumentChanged() {
        String stringFilter = this.jTextField_FindFilter.getText();
        TableAndListModel.ListModelWrapper o_LiveShowListModel_DMXDevice = (TableAndListModel.ListModelWrapper)this.jComboBox_DMXDeviceReplacerSelect.getModel();
        o_LiveShowListModel_DMXDevice.filterByName(stringFilter);
        DMXDevice o_DMXDevice = o_LiveShowListModel_DMXDevice.size() == 1 ? (DMXDevice)o_LiveShowListModel_DMXDevice.get(0) : (stringFilter.length() <= 0 ? null : null);
        if (o_DMXDevice != null) {
            this.jComboBox_DMXDeviceReplacerSelect.setSelectedItem(o_DMXDevice);
        }
        this.jComboBox_DMXDeviceReplacerSelect.repaint();
    }

    public void setLiveShowDMXVIP(LiveShowDMXVIP p_LiveShowDMXVIP) {
        this.liveShowDMXCrossTable_DMXDeviceDMXScene1.setLiveShowDMXVIP(p_LiveShowDMXVIP);
        this.liveShowDMXCrossTable_DMXDeviceDMXObject1.setLiveShowDMXVIP(p_LiveShowDMXVIP);
    }

    public LiveShowDMXVIP getLiveShowDMXVIP() {
        return this.liveShowDMXCrossTable_DMXDeviceDMXObject1.getLiveShowDMXVIP();
    }

    private void jComboBox_DMXDeviceReplacerSelectActionPerformed(ActionEvent evt) {
        if (this.jComboBox_DMXDeviceReplacerSelect.getSelectedItem() != null) {
            DMXDevice o_DMXDevice = (DMXDevice)this.jComboBox_DMXDeviceReplacerSelect.getSelectedItem();
            this.setDMXDeviceReplacer(o_DMXDevice);
        } else {
            this.setDMXDeviceReplacer(null);
        }
    }

    private void jButton_ReplaceActionPerformed(ActionEvent evt) {
        this.replace();
    }

    private void jTextField_FindFilterKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            String stringFilterSubString = this.jTextField_FindFilter.getText();
            TableAndListModel.ListModelWrapper o_LiveShowListModel_DMXDevice = (TableAndListModel.ListModelWrapper)this.jComboBox_DMXDeviceReplacerSelect.getModel();
            DMXDevice o_DMXDevice = stringFilterSubString == null || stringFilterSubString.length() <= 0 ? null : (DMXDevice)o_LiveShowListModel_DMXDevice.findByName(this.jTextField_FindFilter.getText());
            if (o_DMXDevice != null) {
                this.jComboBox_DMXDeviceReplacerSelect.setSelectedItem(o_DMXDevice);
                this.jComboBox_DMXDeviceReplacerSelect.repaint();
            }
        }
    }

    public void refreshGUI() {
        if (this.m_DMXDevice == null) {
            this.jLabel_DMXDeviceImage.setIcon(null);
            this.jLabel_DMXDeviceImage.setBackgroundImage(null);
            this.jLabel_DMXDeviceImage.setToolTipText(null);
            this.jLabel_DMXDeviceName.setText("");
            this.jLabel_DMXDeviceName.setIcon(null);
        } else {
            this.jLabel_DMXDeviceImage.setBackgroundImage(this.m_DMXDevice.getDeviceImage());
            this.jLabel_DMXDeviceImage.setToolTipText(this.m_DMXDevice.getToolTipText());
            this.jLabel_DMXDeviceName.setText(this.m_DMXDevice.getName());
            this.jLabel_DMXDeviceName.setIcon(DMXDevice.s_Icon);
        }
        if (this.m_DMXDeviceReplacer == null) {
            this.jLabel_DMXDeviceReplacerImage.setIcon(null);
            this.jLabel_DMXDeviceReplacerImage.setBackgroundImage(null);
            this.jLabel_DMXDeviceReplacerImage.setToolTipText(null);
        } else {
            this.jLabel_DMXDeviceReplacerImage.setBackgroundImage(this.m_DMXDeviceReplacer.getDeviceImage());
            this.jLabel_DMXDeviceReplacerImage.setToolTipText(this.m_DMXDeviceReplacer.getToolTipText());
        }
        if (this.m_DMXDevice != null && this.m_DMXDeviceReplacer != null) {
            int intSceneCount = this.getReplaceSceneCount();
            if (intSceneCount <= 0) {
                this.jButton_Replace.setEnabled(false);
            } else {
                this.jButton_Replace.setEnabled(true);
            }
            this.jLabel_ReplaceStatistic.setText(TEXT_AFFECTED_SCENES + " " + intSceneCount);
        } else {
            this.jButton_Replace.setEnabled(false);
            this.jLabel_ReplaceStatistic.setText("-");
        }
    }

    public void setDMXDevice(DMXDevice p_DMXDevice) {
        if (this.m_DMXDevice == p_DMXDevice) {
            return;
        }
        int intColumn_CrossScene = 1;
        int intColumn_CrossObject = 2;
        if (this.m_DMXDevice != null) {
            this.liveShowDMXCrossTable_DMXDeviceDMXScene1.removeDMXDevice(this.m_DMXDevice);
            this.liveShowDMXCrossTable_DMXDeviceDMXObject1.removeDMXDevice(this.m_DMXDevice);
        }
        this.liveShowDMXCrossTable_DMXDeviceDMXScene1.removeDMXDevice(this.m_DMXDeviceReplacer);
        this.liveShowDMXCrossTable_DMXDeviceDMXObject1.removeDMXDevice(this.m_DMXDeviceReplacer);
        this.m_DMXDeviceReplacer = null;
        this.m_DMXDevice = p_DMXDevice;
        if (this.m_DMXDevice != null) {
            this.liveShowDMXCrossTable_DMXDeviceDMXScene1.addDMXDevice(intColumn_CrossScene, p_DMXDevice);
            this.liveShowDMXCrossTable_DMXDeviceDMXObject1.addDMXDevice(intColumn_CrossObject, p_DMXDevice);
            if (this.m_DMXDeviceReplacer != this.m_DMXDevice) {
                this.setDMXDeviceReplacer(this.m_DMXDeviceReplacer);
            }
        } else {
            this.setDMXDeviceReplacer(null);
        }
        this.refreshGUI();
    }

    public void setDMXDeviceReplacer(DMXDevice p_DMXDevice) {
        if (this.m_DMXDevice == null || this.m_DMXDevice == p_DMXDevice) {
            this.jComboBox_DMXDeviceReplacerSelect.setSelectedItem(null);
            p_DMXDevice = null;
        }
        if (this.m_DMXDeviceReplacer == p_DMXDevice) {
            return;
        }
        int intColumn_CrossScene = 2;
        int intColumn_CrossObject = 3;
        if (this.m_DMXDeviceReplacer != null) {
            this.liveShowDMXCrossTable_DMXDeviceDMXScene1.removeDMXDevice(this.m_DMXDeviceReplacer);
            this.liveShowDMXCrossTable_DMXDeviceDMXObject1.removeDMXDevice(this.m_DMXDeviceReplacer);
        }
        this.m_DMXDeviceReplacer = p_DMXDevice;
        if (this.m_DMXDeviceReplacer != null) {
            this.liveShowDMXCrossTable_DMXDeviceDMXScene1.addDMXDevice(intColumn_CrossScene, this.m_DMXDeviceReplacer);
            this.liveShowDMXCrossTable_DMXDeviceDMXObject1.addDMXDevice(intColumn_CrossObject, this.m_DMXDeviceReplacer);
        }
        this.refreshGUI();
    }

    public int getReplaceSceneCount() {
        if (this.m_DMXDevice == null || this.m_DMXDeviceReplacer == null) {
            return 0;
        }
        int intSceneCount = 0;
        LiveShowDMXVIP o_LiveShowDMXVIP = LiveShowDMXSystem.getLiveShowDMXVIP();
        if (o_LiveShowDMXVIP == null) {
            return 0;
        }
        this.m_CopyAnswerFlag = 0;
        for (int intDMXScene = 0; intDMXScene < DMXScene.getDMXSceneCount(); ++intDMXScene) {
            DMXScene o_DMXScene = DMXScene.getDMXScene(intDMXScene);
            if (o_DMXScene == null || !o_DMXScene.isDimmerOn(this.m_DMXDevice) || o_DMXScene.isDimmerOn(this.m_DMXDeviceReplacer)) continue;
            ++intSceneCount;
        }
        return intSceneCount;
    }

    public void replace() {
        if (this.m_DMXDevice == null || this.m_DMXDeviceReplacer == null) {
            return;
        }
        LiveShowDMXVIP o_LiveShowDMXVIP = LiveShowDMXSystem.getLiveShowDMXVIP();
        if (o_LiveShowDMXVIP == null) {
            return;
        }
        boolean boolReplaceAll = false;
        this.m_CopyAnswerFlag = 0;
        for (int intDMXScene = 0; intDMXScene < DMXScene.getDMXSceneCount(); ++intDMXScene) {
            LiveShowDMXObject o_LiveShowDMXObject;
            DMXScene o_DMXScene = DMXScene.getDMXScene(intDMXScene);
            if (o_DMXScene == null || !o_DMXScene.isDimmerOn(this.m_DMXDevice) && !boolReplaceAll || o_DMXScene.isDimmerOn(this.m_DMXDeviceReplacer) && !boolReplaceAll) continue;
            this.m_CopyAnswerFlag = 0;
            DMXScene.copyFrom(this, this.m_DMXDeviceReplacer, o_DMXScene, this.m_DMXDevice, o_DMXScene);
            if (this.m_CopyAnswerFlag != 1 && this.m_CopyAnswerFlag != 2) continue;
            o_DMXScene.externalChanged();
            o_LiveShowDMXVIP.getLiveShowObjectInterfaceCount();
            for (int intObject = 0; intObject < o_LiveShowDMXVIP.getLiveShowObjectInterfaceCount(); ++intObject) {
                LiveShowObjectInterface o_LiveShowObjectInterface = o_LiveShowDMXVIP.getLiveShowObjectInterface(intObject);
                o_LiveShowDMXObject = null;
                if (o_LiveShowObjectInterface instanceof LiveShowDMXObject) {
                    o_LiveShowDMXObject = (LiveShowDMXObject)o_LiveShowObjectInterface;
                }
                if (o_LiveShowDMXObject == null || o_LiveShowDMXObject.getDMXScene() != o_DMXScene) continue;
                LiveShowDMXObject.copyFrom(this, o_LiveShowDMXObject, this.m_DMXDeviceReplacer, o_LiveShowDMXObject, this.m_DMXDevice);
            }
            for (int intJingleObject = 0; intJingleObject < LiveShowDMXSystem.getJingleObjectCount(); ++intJingleObject) {
                o_LiveShowDMXObject = LiveShowDMXSystem.getJingleObject(intJingleObject);
                if (o_LiveShowDMXObject == null || o_LiveShowDMXObject.getDMXScene() != o_DMXScene) continue;
                LiveShowDMXObject.copyFrom(this, o_LiveShowDMXObject, this.m_DMXDeviceReplacer, o_LiveShowDMXObject, this.m_DMXDevice);
            }
            for (int intDMXEffect = 0; intDMXEffect < DMXEffect.getDMXEffectCount(); ++intDMXEffect) {
                DMXEffect o_DMXEffect = DMXEffect.getDMXEffect(intDMXEffect);
                if (o_DMXEffect == null) continue;
                o_DMXEffect.replaceDMXDevice(this.m_DMXDevice, this.m_DMXDeviceReplacer);
            }
        }
        this.m_DMXDevice.setActive(false);
        LiveShowDMXVIPAdjustment.calculateAdjustmentAll();
    }

    @Override
    public double getValueCopyDMXScene(DMXDevice p_DMXDevice, DMXScene p_DMXScene, DMXControlComponent.DMXControlType p_DMXControlType, int p_ControlIndex, int p_DimensionIndex) {
        if (p_DMXDevice == null) {
            return -2.147483648E9;
        }
        if (p_DMXScene == null) {
            return -2.147483648E9;
        }
        if (p_DMXControlType == null) {
            return -2.147483648E9;
        }
        return p_DMXScene.getValue(p_DMXDevice, p_DMXControlType, p_ControlIndex, p_DimensionIndex);
    }

    @Override
    public double setValueCopyDMXScene(double p_Value, DMXDevice p_DMXDevice, DMXScene p_DMXScene, DMXControlComponent.DMXControlType p_DMXControlType, int p_ControlIndex, int p_DimensionIndex) {
        if (p_DMXDevice == null) {
            return -2.147483648E9;
        }
        if (p_DMXScene == null) {
            return -2.147483648E9;
        }
        if (p_DMXControlType == null) {
            return -2.147483648E9;
        }
        p_DMXScene.setValue(p_Value, p_DMXDevice, p_DMXControlType, p_ControlIndex, p_DimensionIndex);
        return p_DMXScene.getValue(p_DMXDevice, p_DMXControlType, p_ControlIndex, p_DimensionIndex);
    }

    @Override
    public void setCopyDMXSceneDone(int p_CopyFlag, DMXDevice p_DMXDevice, DMXScene p_DMXScene, DMXControlComponent p_DMXControlComponent) {
        if (p_DMXDevice != this.m_DMXDeviceReplacer) {
            return;
        }
        if (p_CopyFlag > this.m_CopyAnswerFlag) {
            this.m_CopyAnswerFlag = p_CopyFlag;
        }
        if (p_DMXControlComponent instanceof DMXControl_GridPanTilt) {
            DMXScene.setPanTilt_VirtualPointFromAngles(p_DMXScene, p_DMXDevice);
        }
    }

    @Override
    public DMXFadeDescription.DMXControlTypeFadeDescription getValue(LiveShowObject p_LiveShowObject, DMXDevice p_DMXDevice, DMXScene p_DMXScene, DMXControlComponent.DMXControlType p_DMXControlType, int p_ControlIndex, int p_DimensionIndex) {
        if (p_LiveShowObject instanceof LiveShowDMXObject) {
            LiveShowDMXObject o_LiveShowDMXObject = (LiveShowDMXObject)p_LiveShowObject;
            DMXFadeDescription o_DMXFadeDescription = o_LiveShowDMXObject.getDMXFadeDescription();
            if (o_DMXFadeDescription == null) {
                return null;
            }
            DMXFadeDescription.DMXControlTypeFadeDescription o_DMXControlTypeFadeDescription = o_DMXFadeDescription.getDMXControlTypeFadeDescription(p_DMXDevice.getID(), p_DMXControlType.getID());
            return o_DMXControlTypeFadeDescription;
        }
        return null;
    }

    @Override
    public DMXFadeDescription.DMXControlTypeFadeDescription setValue(DMXFadeDescription.DMXControlTypeFadeDescription p_DMXControlTypeFadeDescription, LiveShowObject p_LiveShowObject, DMXDevice p_DMXDevice, DMXScene p_DMXScene, DMXControlComponent.DMXControlType p_DMXControlType) {
        if (p_DMXControlTypeFadeDescription == null) {
            return null;
        }
        if (p_LiveShowObject instanceof LiveShowDMXObject) {
            LiveShowDMXObject o_LiveShowDMXObject = (LiveShowDMXObject)p_LiveShowObject;
            DMXFadeDescription o_DMXFadeDescription = o_LiveShowDMXObject.getDMXFadeDescription();
            if (o_DMXFadeDescription == null) {
                return null;
            }
            DMXFadeDescription.DMXControlTypeFadeDescription o_DMXControlTypeFadeDescription = o_DMXFadeDescription.getDMXControlTypeFadeDescription(p_DMXDevice.getID(), p_DMXControlType.getID());
            p_DMXControlTypeFadeDescription.copyTo(o_DMXControlTypeFadeDescription);
            return o_DMXControlTypeFadeDescription;
        }
        return null;
    }

    @Override
    public void setCopyDone(int p_CopyFlag, DMXDevice p_DMXDevice, DMXScene p_DMXScene, DMXControlComponent p_DMXControlComponent) {
        if (this.m_DMXDeviceReplacer != p_DMXDevice) {
            return;
        }
        if (p_CopyFlag > this.m_CopyAnswerFlag) {
            this.m_CopyAnswerFlag = p_CopyFlag;
        }
    }
}

