/*
 * Decompiled with CFR 0.152.
 */
package DMXDevicePackage;

import DMX512.DMXUniverse;
import DMXDevicePackage.DMXDevice;
import DMXDevicePackage.DMXDeviceGroup;
import DMXDevicePackage.DMXDeviceGroupPanel;
import DMXDevicePackage.DMXDeviceType;
import DMXDevicePackage.DMXPresets;
import DMXEffectsPackage.DMXEffect;
import DMXHardwarePackage.DMXPowerSource;
import DMXScenePackage.DMXScene;
import DMXVirtualPackage.LiveShowDMXObject;
import DMXVirtualPackage.LiveShowDMXVIP;
import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LanguageTools.LiveLanguagePackage.LiveLanguageString;
import LiveShowObjectPackage.LiveShowJingle;
import LiveShowObjectPackage.LiveShowObject;
import LiveShowObjectPackage.LiveShowObjectGroup;
import LiveShowObjectPackage.LiveShowObjectGroupPanel;
import LiveShowObjectPackage.LiveShowObjectInterface;
import StartPackage.LiveShowDMXSystem;
import SwingModelPackage.TableAndListModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JList;
import javax.swing.RowFilter;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

public class DMXDeviceFilter
implements PropertyChangeListener {
    public static final int SOFTWAREVERSION = 1;
    public static boolean s_InvertFilter = false;
    @LiveLanguageString
    public static String DMXDEVICEFILTER_ALL_NAME = "All";
    @LiveLanguageString
    public static String DMXDEVICEFILTER_ALL_REMARK = "show all devices";
    @LiveLanguageString
    public static String DMXDEVICEFILTER_TIMELINE_NAME = "selected timeline-objects";
    @LiveLanguageString
    public static String DMXDEVICEFILTER_TIMELINE_REMARK = "show all devices of the selected objects in the timeline";
    @LiveLanguageString
    public static String DMXDEVICEFILTER_JINGLE_NAME = "selected jingle-objects";
    @LiveLanguageString
    public static String DMXDEVICEFILTER_JINGLE_REMARK = "show all devices of the selected jingles";
    @LiveLanguageString
    public static String DMXDEVICEFILTER_USED_NAME = "used devices";
    @LiveLanguageString
    public static String DMXDEVICEFILTER_USED_REMARK = "show all devices which are either used in timeline or in jingles";
    @LiveLanguageString
    public static String DMXDEVICEFILTER_UNUSED_NAME = "unused devices";
    @LiveLanguageString
    public static String DMXDEVICEFILTER_UNUSED_REMARK = "show all devices which are neither used in timeline nor in jingles";
    @LiveLanguageString
    public static String DMXDEVICEFILTER_NODMXUNIVERSE = "---";
    @LiveLanguageString
    public static String DMXDEVICEFILTER_NODMXUNIVERSE_REMARK = "shows all devices where the universe is not set";
    @LiveLanguageString
    public static String DMXDEVICEFILTER_NODMXPOWERSOURCE = "---";
    @LiveLanguageString
    public static String DMXDEVICEFILTER_NODMXPOWERSOURCE_REMARK = "shows all devices where the powersource is not set";
    @LiveLanguageString
    public static String DMXDEVICEFILTER_SELECTEDDMXDEVICEGROUP_NAME = "Selected lamp groups";
    @LiveLanguageString
    public static String DMXDEVICEFILTER_SELECTEDDMXDEVICEGROUP_REMARK = "shows all devices used in selected lamp groups";
    @LiveLanguageString
    public static String DMXDEVICEFILTER_SELECTEDOBJECTGROUP_NAME = "Selected object groups";
    @LiveLanguageString
    public static String DMXDEVICEFILTER_SELECTEDOBJECTGROUP_REMARK = "shows all devices used in selected object groups";
    @LiveLanguageString
    public static String DMXDEVICEFILTER_DMXUNIVERSE_REMARK = "show all devices connected to this universe";
    @LiveLanguageString
    public static String DMXDEVICEFILTER_DMXPOWERSOURCE_REMARK = "show all devices plugged in this power source";
    @LiveLanguageString
    public static String DMXDEVICEFILTER_DMXSCENE_REMARK = "show all devices used in this light ambience";
    @LiveLanguageString
    public static String DMXDEVICEFILTER_DMXEFFECT_REMARK = "show all devices used in this DMX effect";
    @LiveLanguageString
    public static String DMXDEVICEFILTER_DMXDEVICEGROUP_REMARK = "show all devices used in this lamp group";
    @LiveLanguageString
    public static String DMXDEVICEFILTER_DMXPRESETS_REMARK = "show all devices affected by this preset";
    public static final TableAndListModel.ListModel<DMXDeviceFilter> s_DMXDeviceFilterListModel = new TableAndListModel.ListModel(false);
    public static final DMXDeviceFilterRenderer s_DMXDeviceFilterRenderer;
    public static final DMXDeviceFilterAll s_DMXDeviceFilterAll;
    public static final DMXDeviceFilterTimeline s_DMXDeviceFilterTimeline;
    public static final DMXDeviceFilterJingle s_DMXDeviceFilterJingle;
    public static final DMXDeviceFilterUsed s_DMXDeviceFilterUsed;
    public static final DMXDeviceFilterNoDMXUniverse s_DMXDeviceFilterNoDMXUniverse;
    public static final DMXDeviceFilterNoDMXPowerSource s_DMXDeviceFilterNoDMXPowerSource;
    public static final DMXDeviceFilterSelectedDMXDeviceGroups s_DMXDeviceFilterDeviceGroup;
    public static final DMXDeviceFilterSelectedObjectGroups s_DMXDeviceFilterObjectGroup;
    protected FilterInterface m_FilterInterface;
    protected boolean m_Closed;

    public static TableAndListModel.ListModel<DMXDeviceFilter> getListModel() {
        return s_DMXDeviceFilterListModel;
    }

    public static DefaultListCellRenderer getListCellRenderer() {
        return s_DMXDeviceFilterRenderer;
    }

    public static DMXDeviceFilter createDMXDeviceFilter(FilterInterface p_FilterInterface) {
        DMXDeviceFilter o_DMXDeviceFilter = DMXDeviceFilter.getDMXDeviceFilter(p_FilterInterface);
        if (o_DMXDeviceFilter != null) {
            return o_DMXDeviceFilter;
        }
        o_DMXDeviceFilter = new DMXDeviceFilter(p_FilterInterface);
        return o_DMXDeviceFilter;
    }

    public static void addDMXDeviceFilter(DMXDeviceFilter p_DMXDeviceFilter) {
        if (p_DMXDeviceFilter == null) {
            return;
        }
        s_DMXDeviceFilterListModel.add(p_DMXDeviceFilter);
    }

    public static void removeDMXDeviceFilter(DMXDeviceFilter p_DMXDeviceFilter) {
        if (p_DMXDeviceFilter == null) {
            return;
        }
        if (s_DMXDeviceFilterListModel.remove(p_DMXDeviceFilter)) {
            p_DMXDeviceFilter.close();
        }
    }

    public static void removeDMXDeviceFilter(FilterInterface p_FilterInterface) {
        DMXDeviceFilter o_DMXDeviceFilter = DMXDeviceFilter.getDMXDeviceFilter(p_FilterInterface);
        DMXDeviceFilter.removeDMXDeviceFilter(o_DMXDeviceFilter);
    }

    public static DMXDeviceFilter getDMXDeviceFilter(FilterInterface p_FilterInterface) {
        FilterInterface o_FilterInterface;
        DMXDeviceFilter o_DMXDeviceFilter;
        int intIndex;
        if (p_FilterInterface == null) {
            return null;
        }
        for (intIndex = 0; intIndex < s_DMXDeviceFilterListModel.size(); ++intIndex) {
            o_DMXDeviceFilter = s_DMXDeviceFilterListModel.get(intIndex);
            if (o_DMXDeviceFilter == null || (o_FilterInterface = o_DMXDeviceFilter.getFilterInterface()) != p_FilterInterface) continue;
            return o_DMXDeviceFilter;
        }
        for (intIndex = 0; intIndex < s_DMXDeviceFilterListModel.size_FilteredNot(); ++intIndex) {
            o_DMXDeviceFilter = s_DMXDeviceFilterListModel.get_FilteredNot(intIndex);
            if (o_DMXDeviceFilter == null || (o_FilterInterface = o_DMXDeviceFilter.getFilterInterface()) != p_FilterInterface) continue;
            return o_DMXDeviceFilter;
        }
        return null;
    }

    public static boolean getInvertFilter() {
        return s_InvertFilter;
    }

    public static void setInvertFilter(boolean p_InvertFilter) {
        s_InvertFilter = p_InvertFilter;
    }

    public DMXDeviceFilter(FilterInterface p_FilterInterface) {
        this.initMembers();
        this.setFilterInterface(p_FilterInterface);
        DMXDeviceFilter.addDMXDeviceFilter(this);
    }

    protected void initMembers() {
        LiveLanguage.addLanguageListener((Object)this, null);
        this.m_FilterInterface = null;
        this.m_Closed = false;
    }

    public void close() {
        if (this.m_Closed) {
            return;
        }
        this.m_Closed = true;
        LiveLanguage.removeLanguageListener((Object)this);
        if (this.m_FilterInterface != null) {
            this.setFilterInterface(null);
        }
    }

    public void setFilterInterface(FilterInterface p_FilterInterface) {
        Method o_Method;
        if (p_FilterInterface == this.m_FilterInterface) {
            return;
        }
        FilterInterface oldValue = this.m_FilterInterface;
        if (this.m_FilterInterface != null) {
            o_Method = null;
            try {
                o_Method = this.m_FilterInterface.getClass().getDeclaredMethod("removePropertyChangeListener", PropertyChangeListener.class);
                if (o_Method != null) {
                    o_Method.invoke((Object)this.m_FilterInterface, this);
                }
            }
            catch (Exception e) {
                o_Method = null;
            }
        }
        this.m_FilterInterface = p_FilterInterface;
        if (this.m_FilterInterface != null) {
            o_Method = null;
            try {
                o_Method = this.m_FilterInterface.getClass().getDeclaredMethod("addPropertyChangeListener", PropertyChangeListener.class);
                if (o_Method != null) {
                    o_Method.invoke((Object)this.m_FilterInterface, this);
                }
            }
            catch (Exception e) {
                Object var3_3 = null;
            }
        }
    }

    public FilterInterface getFilterInterface() {
        return this.m_FilterInterface;
    }

    public String getName() {
        if (this.m_FilterInterface == null) {
            return "";
        }
        return this.m_FilterInterface.getName();
    }

    public String getListSortPreFix() {
        if (this instanceof DMXDeviceFilterAll) {
            return "A";
        }
        if (this instanceof DMXDeviceFilterUsed) {
            return "B";
        }
        if (this instanceof DMXDeviceFilterNoDMXUniverse) {
            return "C";
        }
        if (this instanceof DMXDeviceFilterNoDMXPowerSource) {
            return "D";
        }
        if (this instanceof DMXDeviceFilterTimeline) {
            return "E";
        }
        if (this instanceof DMXDeviceFilterJingle) {
            return "F";
        }
        if (this instanceof DMXDeviceFilterSelectedDMXDeviceGroups) {
            return "G";
        }
        if (this instanceof DMXDeviceFilterSelectedObjectGroups) {
            return "H";
        }
        if (this.m_FilterInterface == null) {
            return "";
        }
        if (this.m_FilterInterface instanceof DMXPresets) {
            return "K";
        }
        if (this.m_FilterInterface instanceof DMXDevice) {
            return "L";
        }
        if (this.m_FilterInterface instanceof DMXDeviceGroup) {
            return "M";
        }
        if (this.m_FilterInterface instanceof DMXScene) {
            return "N";
        }
        if (this.m_FilterInterface instanceof DMXEffect) {
            return "O";
        }
        if (this.m_FilterInterface instanceof DMXUniverse) {
            return "P";
        }
        if (this.m_FilterInterface instanceof DMXPowerSource) {
            return "O";
        }
        if (this.m_FilterInterface instanceof DMXDeviceType) {
            return "R";
        }
        return "";
    }

    public String getSortName() {
        StringBuilder o_StringBuilder = new StringBuilder();
        o_StringBuilder.append(this.getListSortPreFix());
        o_StringBuilder.append(this.getClass().getSimpleName());
        o_StringBuilder.append(this.getName());
        return o_StringBuilder.toString();
    }

    public String getRemark() {
        if (this.m_FilterInterface == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        if (this.m_FilterInterface instanceof DMXUniverse) {
            stringBuilder.append(DMXDEVICEFILTER_DMXUNIVERSE_REMARK);
        } else if (this.m_FilterInterface instanceof DMXPowerSource) {
            stringBuilder.append(DMXDEVICEFILTER_DMXPOWERSOURCE_REMARK);
        } else if (this.m_FilterInterface instanceof DMXScene) {
            stringBuilder.append(DMXDEVICEFILTER_DMXSCENE_REMARK);
        } else if (this.m_FilterInterface instanceof DMXEffect) {
            stringBuilder.append(DMXDEVICEFILTER_DMXEFFECT_REMARK);
        } else if (this.m_FilterInterface instanceof DMXDeviceGroup) {
            stringBuilder.append(DMXDEVICEFILTER_DMXDEVICEGROUP_REMARK);
        } else if (this.m_FilterInterface instanceof DMXPresets) {
            stringBuilder.append(DMXDEVICEFILTER_DMXPRESETS_REMARK);
        }
        String stringFilterRemark = this.m_FilterInterface.getRemark();
        if (stringFilterRemark != null && stringFilterRemark.length() > 0) {
            stringBuilder.append("<br>");
            stringBuilder.append(this.m_FilterInterface.getRemark());
        }
        stringBuilder.append("</html>");
        return stringBuilder.toString();
    }

    public Icon getIcon() {
        if (this.m_FilterInterface == null) {
            return null;
        }
        return this.m_FilterInterface.getIcon();
    }

    public boolean containsDMXDevice(DMXDevice p_DMXDevice) {
        if (this.m_FilterInterface == null) {
            return false;
        }
        return this.m_FilterInterface.useDMXDevice(p_DMXDevice);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof FilterInterface) {
            FilterInterface o_FilterInterface = (FilterInterface)evt.getSource();
            ArrayList<DMXDeviceFilter> o_DMXDeviceFilters = s_DMXDeviceFilterListModel.getElementArrayList_Safe();
            for (int intDMXDeviceFilter = 0; intDMXDeviceFilter < o_DMXDeviceFilters.size(); ++intDMXDeviceFilter) {
                DMXDeviceFilter o_DMXDeviceFilter = o_DMXDeviceFilters.get(intDMXDeviceFilter);
                if (o_DMXDeviceFilter.getFilterInterface() != o_FilterInterface) continue;
                s_DMXDeviceFilterListModel.changedElement(o_DMXDeviceFilter);
            }
        }
    }

    static {
        s_DMXDeviceFilterListModel.setGetSortStringMethod(DMXDeviceFilter.class, "getSortName", true);
        s_DMXDeviceFilterListModel.setGetNameMethod(DMXDeviceFilter.class, "getName");
        s_DMXDeviceFilterRenderer = new DMXDeviceFilterRenderer();
        s_DMXDeviceFilterAll = new DMXDeviceFilterAll();
        s_DMXDeviceFilterTimeline = new DMXDeviceFilterTimeline();
        s_DMXDeviceFilterJingle = new DMXDeviceFilterJingle();
        s_DMXDeviceFilterUsed = new DMXDeviceFilterUsed();
        s_DMXDeviceFilterNoDMXUniverse = new DMXDeviceFilterNoDMXUniverse();
        s_DMXDeviceFilterNoDMXPowerSource = new DMXDeviceFilterNoDMXPowerSource();
        s_DMXDeviceFilterDeviceGroup = new DMXDeviceFilterSelectedDMXDeviceGroups();
        s_DMXDeviceFilterObjectGroup = new DMXDeviceFilterSelectedObjectGroups();
    }

    public static class DMXDeviceFilterRenderer
    extends DefaultListCellRenderer {
        protected static final Border SAFE_NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);
        protected static final Border DEFAULT_NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);
        protected static final Border SELECTED_BORDER = new LineBorder(Color.BLUE, 2, true);
        protected Dimension m_PreferredDimension = new Dimension(20, 28);

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setComponentOrientation(list.getComponentOrientation());
            Color o_Background = null;
            Color o_Foreground = null;
            o_Background = list.getBackground();
            o_Foreground = list.getForeground();
            if (isSelected) {
                if (list.hasFocus()) {
                    o_Background = UIManager.getColor("List.selectionBackground");
                    o_Foreground = UIManager.getColor("List.selectionForeground");
                } else {
                    o_Background = UIManager.getColor("List.selectionInactiveBackground");
                    o_Foreground = UIManager.getColor("List.selectionInactiveForeground");
                }
            }
            this.setForeground(o_Foreground);
            this.setBackground(o_Background);
            this.setHorizontalAlignment(0);
            if (value instanceof Icon) {
                this.setIcon((Icon)value);
                this.setText("");
            } else {
                String stringFilterRemark;
                String stringFilterName;
                this.setIcon(null);
                if (value == null) {
                    stringFilterName = "---";
                    stringFilterRemark = null;
                } else {
                    DMXPowerSource o_DMXPowerSource;
                    DMXDeviceFilter o_DMXDeviceFilter = (DMXDeviceFilter)value;
                    stringFilterName = o_DMXDeviceFilter.getName();
                    stringFilterRemark = o_DMXDeviceFilter.getRemark();
                    Icon o_Icon = o_DMXDeviceFilter.getIcon();
                    if (o_Icon == null) {
                        this.setPreferredSize(this.m_PreferredDimension);
                    }
                    this.setIcon(o_Icon);
                    FilterInterface o_FilterInterface = o_DMXDeviceFilter.getFilterInterface();
                    if (o_FilterInterface != null && o_FilterInterface instanceof DMXPowerSource && (o_DMXPowerSource = (DMXPowerSource)o_FilterInterface) != null && o_DMXPowerSource.getOverload()) {
                        this.setBackground(Color.RED);
                    }
                }
                this.setText(stringFilterName);
                this.setToolTipText(stringFilterRemark);
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            Border border = null;
            if (isSelected) {
                border = SELECTED_BORDER;
            }
            if (border == null) {
                border = this.getNoFocusBorder();
            }
            return this;
        }

        private Border getNoFocusBorder() {
            Border border = null;
            if (System.getSecurityManager() != null) {
                if (border != null) {
                    return border;
                }
                return SAFE_NO_FOCUS_BORDER;
            }
            if (border != null && (noFocusBorder == null || noFocusBorder == DEFAULT_NO_FOCUS_BORDER)) {
                return border;
            }
            return noFocusBorder;
        }
    }

    public static class DMXDeviceRowFilter
    extends RowFilter<DMXDevice.DMXDeviceTableModel, Integer> {
        private DMXDevice.DMXDeviceTableModel m_DMXDeviceTableModel;
        private DMXDeviceFilter m_DMXDeviceFilter;

        public DMXDeviceRowFilter(DMXDevice.DMXDeviceTableModel p_DMXDeviceTableModel) {
            this.initMembers();
            this.m_DMXDeviceTableModel = p_DMXDeviceTableModel;
        }

        private void initMembers() {
            this.m_DMXDeviceFilter = null;
        }

        public void setDMXDeviceFilter(DMXDeviceFilter p_DMXDeviceFilter) {
            this.m_DMXDeviceFilter = p_DMXDeviceFilter;
            if (this.m_DMXDeviceTableModel != null) {
                this.m_DMXDeviceTableModel.fireTableDataChanged();
            }
        }

        @Override
        public boolean include(RowFilter.Entry entry) {
            if (this.m_DMXDeviceTableModel == null) {
                return false;
            }
            if (this.m_DMXDeviceFilter == null) {
                return true;
            }
            int intRow = (Integer)entry.getIdentifier();
            DMXDevice o_DMXDevice = this.m_DMXDeviceTableModel.getDMXDevice(intRow);
            if (o_DMXDevice == null) {
                return false;
            }
            if (!DMXDeviceFilter.getInvertFilter()) {
                return this.m_DMXDeviceFilter.containsDMXDevice(o_DMXDevice);
            }
            return !this.m_DMXDeviceFilter.containsDMXDevice(o_DMXDevice);
        }
    }

    public static interface FilterInterface {
        public String getName();

        public String getRemark();

        public Icon getIcon();

        public boolean useDMXDevice(DMXDevice var1);
    }

    public static class DMXDeviceFilterSelectedObjectGroups
    extends DMXDeviceFilter {
        public static Icon s_Icon = new ImageIcon(DMXDeviceFilter.class.getResource("/IconsPackage/Timeline_ObjectGroup.png"));

        public DMXDeviceFilterSelectedObjectGroups() {
            super(null);
            this.initMembers();
        }

        @Override
        public String getName() {
            return DMXDEVICEFILTER_SELECTEDOBJECTGROUP_NAME;
        }

        @Override
        public String getRemark() {
            return DMXDEVICEFILTER_SELECTEDOBJECTGROUP_REMARK;
        }

        @Override
        public Icon getIcon() {
            return s_Icon;
        }

        @Override
        public boolean containsDMXDevice(DMXDevice p_DMXDevice) {
            if (p_DMXDevice == null) {
                return false;
            }
            int intSelectedGroupCount = LiveShowObjectGroupPanel.getSelectedGroupCount();
            for (int intGroup = 0; intGroup < intSelectedGroupCount; ++intGroup) {
                LiveShowObjectGroup o_LiveShowObjectGroup = LiveShowObjectGroupPanel.getSelectedGroup(intGroup);
                if (o_LiveShowObjectGroup == null) continue;
                int intObjectCount = o_LiveShowObjectGroup.getObjectCount();
                for (int intObject = 0; intObject < intObjectCount; ++intObject) {
                    LiveShowDMXObject o_LiveShowDMXObject;
                    DMXScene o_DMXScene;
                    LiveShowObjectInterface o_LiveShowObjectInterface = o_LiveShowObjectGroup.getObject(intObject);
                    if (o_LiveShowObjectInterface == null || !(o_LiveShowObjectInterface instanceof LiveShowDMXObject) || (o_DMXScene = (o_LiveShowDMXObject = (LiveShowDMXObject)o_LiveShowObjectInterface).getDMXScene()) == null || !o_DMXScene.isDimmerOn(p_DMXDevice)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    public static class DMXDeviceFilterSelectedDMXDeviceGroups
    extends DMXDeviceFilter {
        public static Icon s_Icon = DMXDeviceGroup.s_Icon;

        public DMXDeviceFilterSelectedDMXDeviceGroups() {
            super(null);
        }

        @Override
        public String getName() {
            return DMXDEVICEFILTER_SELECTEDDMXDEVICEGROUP_NAME;
        }

        @Override
        public String getRemark() {
            return DMXDEVICEFILTER_SELECTEDDMXDEVICEGROUP_REMARK;
        }

        @Override
        public boolean containsDMXDevice(DMXDevice p_DMXDevice) {
            if (p_DMXDevice == null) {
                return false;
            }
            int intSelectedGroupCount = DMXDeviceGroupPanel.getSelectedGroupCount();
            for (int intGroup = 0; intGroup < intSelectedGroupCount; ++intGroup) {
                DMXDeviceGroup o_DMXDeviceGroup = DMXDeviceGroupPanel.getSelectedGroup(intGroup);
                if (o_DMXDeviceGroup == null || !o_DMXDeviceGroup.useDMXDevice(p_DMXDevice)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Icon getIcon() {
            return s_Icon;
        }
    }

    public static class DMXDeviceFilterNoDMXPowerSource
    extends DMXDeviceFilter {
        public static Icon s_Icon = DMXPowerSource.s_Icon;

        public DMXDeviceFilterNoDMXPowerSource() {
            super(null);
        }

        @Override
        public String getName() {
            return DMXDEVICEFILTER_NODMXPOWERSOURCE;
        }

        @Override
        public String getRemark() {
            return DMXDEVICEFILTER_NODMXPOWERSOURCE_REMARK;
        }

        @Override
        public boolean containsDMXDevice(DMXDevice p_DMXDevice) {
            if (p_DMXDevice == null) {
                return false;
            }
            for (int intSector = 0; intSector < p_DMXDevice.getInternalSectorCount(); ++intSector) {
                DMXDevice.InternalSector o_InternalSector = p_DMXDevice.getInternalSector(intSector);
                if (o_InternalSector == null || o_InternalSector.getDMXPowerSource() != null) continue;
                return true;
            }
            return false;
        }

        @Override
        public Icon getIcon() {
            return s_Icon;
        }
    }

    public static class DMXDeviceFilterNoDMXUniverse
    extends DMXDeviceFilter {
        public static Icon s_Icon = DMXUniverse.s_Icon;

        public DMXDeviceFilterNoDMXUniverse() {
            super(null);
        }

        @Override
        public String getName() {
            return DMXDEVICEFILTER_NODMXUNIVERSE;
        }

        @Override
        public String getRemark() {
            return DMXDEVICEFILTER_NODMXUNIVERSE_REMARK;
        }

        @Override
        public boolean containsDMXDevice(DMXDevice p_DMXDevice) {
            if (p_DMXDevice == null) {
                return false;
            }
            for (int intSector = 0; intSector < p_DMXDevice.getInternalSectorCount(); ++intSector) {
                DMXDevice.InternalSector o_InternalSector = p_DMXDevice.getInternalSector(intSector);
                if (o_InternalSector == null || o_InternalSector.getDMXUniverse() != null) continue;
                return true;
            }
            return false;
        }

        @Override
        public Icon getIcon() {
            return s_Icon;
        }
    }

    public static class DMXDeviceFilterUsed
    extends DMXDeviceFilter {
        public static Icon s_Icon = new ImageIcon(DMXDeviceFilter.class.getResource("/IconsPackage/Object.png"));

        public DMXDeviceFilterUsed() {
            super(null);
        }

        @Override
        public String getName() {
            return DMXDEVICEFILTER_USED_NAME;
        }

        @Override
        public String getRemark() {
            return DMXDEVICEFILTER_USED_REMARK;
        }

        @Override
        public boolean containsDMXDevice(DMXDevice p_DMXDevice) {
            for (int intDMXScene = 0; intDMXScene < DMXScene.getDMXSceneCount(); ++intDMXScene) {
                DMXScene o_DMXScene = DMXScene.getDMXScene(intDMXScene);
                if (o_DMXScene == null || o_DMXScene.getLiveShowDMXObjectCount() <= 0 || !o_DMXScene.isDimmerOn(p_DMXDevice)) continue;
                return true;
            }
            int intDMXEffectCount = DMXEffect.getDMXEffectCount();
            for (int intEffect = 0; intEffect < intDMXEffectCount; ++intEffect) {
                DMXEffect o_DMXEffect = DMXEffect.getDMXEffect(intEffect);
                if (o_DMXEffect == null || o_DMXEffect.getLiveShowDMXObjectCount() <= 0 || !o_DMXEffect.useDMXDevice(p_DMXDevice)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Icon getIcon() {
            return s_Icon;
        }
    }

    public static class DMXDeviceFilterJingle
    extends DMXDeviceFilter {
        public static Icon s_Icon = new ImageIcon(DMXDeviceFilter.class.getResource("/IconsPackage/Object_Select.png"));

        public DMXDeviceFilterJingle() {
            super(null);
        }

        @Override
        public String getName() {
            return DMXDEVICEFILTER_JINGLE_NAME;
        }

        @Override
        public String getRemark() {
            return DMXDEVICEFILTER_JINGLE_REMARK;
        }

        @Override
        public boolean containsDMXDevice(DMXDevice p_DMXDevice) {
            LiveShowJingle.JingleContainerInterface o_JingleContainerInterface = LiveShowDMXSystem.getJingleContainerInterface();
            int intJingleCount = o_JingleContainerInterface.getSelectedJingleViewCount();
            for (int intJingle = 0; intJingle < intJingleCount; ++intJingle) {
                LiveShowObject o_LiveShowObjectInterface;
                LiveShowJingle.JingleInterface o_JingleInterface = o_JingleContainerInterface.getSelectedJingleView(intJingle);
                if (o_JingleInterface == null || (o_LiveShowObjectInterface = o_JingleInterface.getLiveShowObject()) == null || !(o_LiveShowObjectInterface instanceof LiveShowDMXObject)) continue;
                LiveShowDMXObject o_LiveShowDMXObject = (LiveShowDMXObject)o_LiveShowObjectInterface;
                DMXScene o_DMXScene = o_LiveShowDMXObject.getDMXScene();
                if (o_DMXScene != null && o_DMXScene.isDimmerOn(p_DMXDevice)) {
                    return true;
                }
                DMXEffect o_DMXEffect = o_LiveShowDMXObject.getDMXEffect();
                if (o_DMXEffect == null || !o_DMXEffect.useDMXDevice(p_DMXDevice)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Icon getIcon() {
            return s_Icon;
        }
    }

    public static class DMXDeviceFilterTimeline
    extends DMXDeviceFilter {
        public static Icon s_Icon = new ImageIcon(DMXDeviceFilter.class.getResource("/IconsPackage/Object_Select.png"));

        public DMXDeviceFilterTimeline() {
            super(null);
        }

        @Override
        public String getName() {
            return DMXDEVICEFILTER_TIMELINE_NAME;
        }

        @Override
        public String getRemark() {
            return DMXDEVICEFILTER_TIMELINE_REMARK;
        }

        @Override
        public boolean containsDMXDevice(DMXDevice p_DMXDevice) {
            LiveShowDMXVIP o_LiveShowDMXVIP = LiveShowDMXSystem.getLiveShowDMXVIP();
            if (o_LiveShowDMXVIP == null) {
                return false;
            }
            for (int intObject = 0; intObject < o_LiveShowDMXVIP.getSelectedObjectsCount(); ++intObject) {
                LiveShowObjectInterface o_LiveShowObjectInterface = o_LiveShowDMXVIP.getSelectedObjectInterface(intObject);
                if (o_LiveShowObjectInterface == null || !(o_LiveShowObjectInterface instanceof LiveShowDMXObject)) continue;
                LiveShowDMXObject o_LiveShowDMXObject = (LiveShowDMXObject)o_LiveShowObjectInterface;
                DMXScene o_DMXScene = o_LiveShowDMXObject.getDMXScene();
                if (o_DMXScene != null && o_DMXScene.isDimmerOn(p_DMXDevice)) {
                    return true;
                }
                DMXEffect o_DMXEffect = o_LiveShowDMXObject.getDMXEffect();
                if (o_DMXEffect == null || !o_DMXEffect.useDMXDevice(p_DMXDevice)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Icon getIcon() {
            return s_Icon;
        }
    }

    public static class DMXDeviceFilterAll
    extends DMXDeviceFilter {
        public DMXDeviceFilterAll() {
            super(null);
        }

        @Override
        public String getName() {
            return DMXDEVICEFILTER_ALL_NAME;
        }

        @Override
        public String getRemark() {
            return DMXDEVICEFILTER_ALL_REMARK;
        }

        @Override
        public boolean containsDMXDevice(DMXDevice p_DMXDevice) {
            return p_DMXDevice != null;
        }
    }
}

