/*
 * Decompiled with CFR 0.152.
 */
package DMXDeviceEditorPackage;

import DMXDeviceEditorPackage.GDTF_Parser;
import DMXDeviceEditorPackage.LiveShowDMXDeviceEditor;
import FileToolPackage.FileSelection;
import LanguageTools.LiveLanguagePackage.LiveLanguage;
import OS.OSChecker;
import SwingModelPackage.TableAndListModel;
import SwingToolTipPackage.PopUpToolTip;
import ToolsGraphics.ImagesTools;
import ToolsGraphics.JLabel_ResizeFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.URI;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.filechooser.FileNameExtensionFilter;

public class JDialog_GDTFImport
extends JDialog {
    public static final String FILETYPE = "GDTF";
    public static final String FILESUFFIX = ".gdtf";
    public static String s_LastDirectory = null;
    private LiveShowDMXDeviceEditor m_LiveShowDMXDeviceEditor;
    private GDTF_Parser.GDTFDescription m_GDTFDescription;
    private BufferedImage m_DeviceImage;
    private TableAndListModel.ListModel<GDTF_Parser.GDTFDescription.DMXMode> m_ListModel_DMXModes;
    private JButton jButton_Cancel;
    private JButton jButton_Load;
    private JButton jButton_Save;
    private JComboBox<GDTF_Parser.GDTFDescription.DMXMode> jComboBox_DMXModes;
    private JLabel jLabel_DeviceImage;
    private JLabel jLabel_DeviceName;
    private JLabel jLabel_Explanation1;
    private JLabel jLabel_Explanation2;
    private JLabel jLabel_Explanation3;
    private JLabel jLabel_GDTFDataVersion;
    private JLabel jLabel_GDTFLink;
    private JLabel jLabel_HeaderDMXModes;
    private JLabel jLabel_Manufacturer;
    private JLabel jLabel_Note;
    private JLabel_ResizeFrame jLabel_ResizeFrame1;
    private JLabel jLabel_Step1;
    private JLabel jLabel_Step2;
    private JLabel jLabel_Step3;
    private JPanel jPanel1;
    private JPanel jPanel_Buttons;
    private JPanel jPanel_DMXMode;
    private JPanel jPanel_Device;
    private JPanel jPanel_GDTF;
    private JPanel jPanel_GDTFLoad;
    private JPanel jPanel_Note;

    public JDialog_GDTFImport(Frame parent, boolean modal, LiveShowDMXDeviceEditor p_LiveShowDMXDeviceEditor) {
        super(parent, modal);
        this.setTitle("GDTF Import");
        this.initMembers();
        this.m_LiveShowDMXDeviceEditor = p_LiveShowDMXDeviceEditor;
        this.initComponents();
        this.initComponentsFurther();
        LiveLanguage.addLanguageListener((Object)this, null);
        this.setIconImage(new ImageIcon(JDialog_GDTFImport.class.getResource("/IconsPackage/Menu_DMXDeviceEditor.png")).getImage());
        this.refreshGUI();
    }

    private void initMembers() {
        this.m_GDTFDescription = null;
        this.m_ListModel_DMXModes = new TableAndListModel.ListModel(false);
    }

    private void initComponentsFurther() {
        this.jLabel_ResizeFrame1.setContainer(this);
        this.jComboBox_DMXModes.setModel(this.m_ListModel_DMXModes);
        TableAndListModel.ListRenderer o_ListRenderer_DMXMode = new TableAndListModel.ListRenderer("getDisplayText", null);
        this.jComboBox_DMXModes.setRenderer(o_ListRenderer_DMXMode);
        this.jLabel_GDTFLink.setCursor(new Cursor(12));
        this.jButton_Load.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_Save.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_Cancel.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jComboBox_DMXModes.setComponentPopupMenu(PopUpToolTip.getSelfReference());
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jPanel_GDTF = new JPanel();
        this.jLabel_Step1 = new JLabel();
        this.jLabel_Explanation1 = new JLabel();
        this.jLabel_GDTFLink = new JLabel();
        this.jPanel_GDTFLoad = new JPanel();
        this.jButton_Load = new JButton();
        this.jLabel_Step2 = new JLabel();
        this.jLabel_Explanation2 = new JLabel();
        this.jLabel_GDTFDataVersion = new JLabel();
        this.jPanel_Device = new JPanel();
        this.jLabel_Manufacturer = new JLabel();
        this.jLabel_DeviceName = new JLabel();
        this.jLabel_DeviceImage = new JLabel();
        this.jPanel_DMXMode = new JPanel();
        this.jLabel_HeaderDMXModes = new JLabel();
        this.jComboBox_DMXModes = new JComboBox();
        this.jLabel_Step3 = new JLabel();
        this.jLabel_Explanation3 = new JLabel();
        this.jPanel_Note = new JPanel();
        this.jLabel_Note = new JLabel();
        this.jPanel_Buttons = new JPanel();
        this.jButton_Save = new JButton();
        this.jButton_Cancel = new JButton();
        this.jLabel_ResizeFrame1 = new JLabel_ResizeFrame();
        this.setPreferredSize(new Dimension(450, 550));
        this.getContentPane().setLayout(new GridBagLayout());
        this.jPanel1.setBorder(BorderFactory.createLineBorder(Color.gray));
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel_GDTF.setLayout(new GridBagLayout());
        this.jLabel_Step1.setFont(new Font("Tahoma", 1, 11));
        this.jLabel_Step1.setText("Step 1");
        this.jLabel_Step1.setToolTipText("");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_GDTF.add((Component)this.jLabel_Step1, gridBagConstraints);
        this.jLabel_Explanation1.setText("<html>Download File of your device type from GDTF Hompage</html>");
        this.jLabel_Explanation1.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_GDTF.add((Component)this.jLabel_Explanation1, gridBagConstraints);
        this.jLabel_GDTFLink.setFont(new Font("Tahoma", 1, 12));
        this.jLabel_GDTFLink.setForeground(new Color(102, 102, 255));
        this.jLabel_GDTFLink.setText("www.GDTF-Share.com");
        this.jLabel_GDTFLink.setToolTipText("");
        this.jLabel_GDTFLink.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JDialog_GDTFImport.this.jLabel_GDTFLinkMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.jPanel_GDTF.add((Component)this.jLabel_GDTFLink, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.jPanel_GDTF, gridBagConstraints);
        this.jPanel_GDTFLoad.setLayout(new GridBagLayout());
        this.jButton_Load.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/File_Load.png")));
        this.jButton_Load.setToolTipText("Load GDTF file");
        this.jButton_Load.setContentAreaFilled(false);
        this.jButton_Load.setMargin(new Insets(-1, -1, -1, -1));
        this.jButton_Load.setMaximumSize(new Dimension(32, 32));
        this.jButton_Load.setMinimumSize(new Dimension(32, 32));
        this.jButton_Load.setPreferredSize(new Dimension(32, 32));
        this.jButton_Load.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_Load.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDialog_GDTFImport.this.jButton_LoadActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_GDTFLoad.add((Component)this.jButton_Load, gridBagConstraints);
        this.jLabel_Step2.setFont(new Font("Tahoma", 1, 11));
        this.jLabel_Step2.setText("Step 2");
        this.jLabel_Step2.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_GDTFLoad.add((Component)this.jLabel_Step2, gridBagConstraints);
        this.jLabel_Explanation2.setText("<html>Open the downloaded GDTF-File</html>");
        this.jLabel_Explanation2.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_GDTFLoad.add((Component)this.jLabel_Explanation2, gridBagConstraints);
        this.jLabel_GDTFDataVersion.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        this.jPanel_GDTFLoad.add((Component)this.jLabel_GDTFDataVersion, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.jPanel_GDTFLoad, gridBagConstraints);
        this.jPanel_Device.setLayout(new GridBagLayout());
        this.jLabel_Manufacturer.setFont(new Font("Tahoma", 1, 12));
        this.jLabel_Manufacturer.setHorizontalAlignment(0);
        this.jLabel_Manufacturer.setText("manufacturer");
        this.jLabel_Manufacturer.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Device.add((Component)this.jLabel_Manufacturer, gridBagConstraints);
        this.jLabel_DeviceName.setFont(new Font("Tahoma", 1, 12));
        this.jLabel_DeviceName.setHorizontalAlignment(0);
        this.jLabel_DeviceName.setText("device");
        this.jLabel_DeviceName.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Device.add((Component)this.jLabel_DeviceName, gridBagConstraints);
        this.jLabel_DeviceImage.setHorizontalAlignment(0);
        this.jLabel_DeviceImage.setToolTipText("");
        this.jLabel_DeviceImage.setMaximumSize(new Dimension(128, 128));
        this.jLabel_DeviceImage.setMinimumSize(new Dimension(128, 128));
        this.jLabel_DeviceImage.setPreferredSize(new Dimension(128, 128));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Device.add((Component)this.jLabel_DeviceImage, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.jPanel_Device, gridBagConstraints);
        this.jPanel_DMXMode.setLayout(new GridBagLayout());
        this.jLabel_HeaderDMXModes.setHorizontalAlignment(4);
        this.jLabel_HeaderDMXModes.setText("DMXModes:");
        this.jLabel_HeaderDMXModes.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_DMXMode.add((Component)this.jLabel_HeaderDMXModes, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_DMXMode.add(this.jComboBox_DMXModes, gridBagConstraints);
        this.jLabel_Step3.setFont(new Font("Tahoma", 1, 11));
        this.jLabel_Step3.setText("Step 3");
        this.jLabel_Step3.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_DMXMode.add((Component)this.jLabel_Step3, gridBagConstraints);
        this.jLabel_Explanation3.setText("<html>Select the device DMXMode</html>");
        this.jLabel_Explanation3.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_DMXMode.add((Component)this.jLabel_Explanation3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.jPanel_DMXMode, gridBagConstraints);
        this.jPanel_Note.setLayout(new GridBagLayout());
        this.jLabel_Note.setHorizontalAlignment(0);
        this.jLabel_Note.setText("<html><center>Finally, please check the device type in the lamp editor.</center></html>");
        this.jLabel_Note.setToolTipText("");
        this.jLabel_Note.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JDialog_GDTFImport.this.jLabel_NoteMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Note.add((Component)this.jLabel_Note, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.jPanel_Note, gridBagConstraints);
        this.jPanel_Buttons.setLayout(new GridBagLayout());
        this.jButton_Save.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Edit_OK.png")));
        this.jButton_Save.setToolTipText("Apply device type");
        this.jButton_Save.setContentAreaFilled(false);
        this.jButton_Save.setMargin(new Insets(-1, -1, -1, -1));
        this.jButton_Save.setMaximumSize(new Dimension(32, 32));
        this.jButton_Save.setMinimumSize(new Dimension(32, 32));
        this.jButton_Save.setPreferredSize(new Dimension(32, 32));
        this.jButton_Save.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_Save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDialog_GDTFImport.this.jButton_SaveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Buttons.add((Component)this.jButton_Save, gridBagConstraints);
        this.jButton_Cancel.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Edit_Cancel.png")));
        this.jButton_Cancel.setToolTipText("Cancel");
        this.jButton_Cancel.setContentAreaFilled(false);
        this.jButton_Cancel.setMargin(new Insets(-1, -1, -1, -1));
        this.jButton_Cancel.setMaximumSize(new Dimension(32, 32));
        this.jButton_Cancel.setMinimumSize(new Dimension(32, 32));
        this.jButton_Cancel.setPreferredSize(new Dimension(32, 32));
        this.jButton_Cancel.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_Cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDialog_GDTFImport.this.jButton_CancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.insets = new Insets(3, 3, 3, 40);
        this.jPanel_Buttons.add((Component)this.jButton_Cancel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 14;
        this.jPanel_Buttons.add((Component)this.jLabel_ResizeFrame1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jPanel_Buttons, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.pack();
    }

    private void jButton_LoadActionPerformed(ActionEvent evt) {
        FileNameExtensionFilter o_FileNameExtensionFilter;
        File o_File;
        if (s_LastDirectory == null) {
            s_LastDirectory = OSChecker.getPathUserHomeDirectory();
        }
        if ((o_File = FileSelection.showOpen(this, FILETYPE, new File(s_LastDirectory), o_FileNameExtensionFilter = FileSelection.createFileNameExtensionFilter("GDTF (.gdtf)", FILESUFFIX), true, false)) == null) {
            return;
        }
        if (!o_File.exists()) {
            o_File = null;
            return;
        }
        GDTF_Parser o_GDTF_Parser = new GDTF_Parser();
        GDTF_Parser.GDTFDescription o_GDTFDescription = o_GDTF_Parser.interpreteGTDFFile(o_File);
        if (o_GDTFDescription == null) {
            return;
        }
        s_LastDirectory = o_File.getParent();
        this.m_ListModel_DMXModes.clear();
        for (int intDMXMode = 0; intDMXMode < o_GDTFDescription.getDMXModeCount(); ++intDMXMode) {
            GDTF_Parser.GDTFDescription.DMXMode o_DMXMode = o_GDTFDescription.getDMXMode(intDMXMode);
            if (o_DMXMode.getDMXUniverseMaxChannelBytes() > 2) continue;
            this.m_ListModel_DMXModes.add(o_DMXMode);
        }
        this.m_GDTFDescription = o_GDTFDescription;
        this.refreshGUI();
        boolean intTest = false;
    }

    private void jButton_SaveActionPerformed(ActionEvent evt) {
        GDTF_Parser.GDTFDescription.DMXMode o_DMXMode = (GDTF_Parser.GDTFDescription.DMXMode)this.jComboBox_DMXModes.getSelectedItem();
        if (this.m_LiveShowDMXDeviceEditor != null && o_DMXMode != null) {
            this.m_LiveShowDMXDeviceEditor.gdtfCreateDMXDeviceType(o_DMXMode);
        }
        this.setVisible(false);
    }

    private void jButton_CancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void jLabel_GDTFLinkMouseClicked(MouseEvent evt) {
        if (OSChecker.getIsWindows()) {
            Desktop o_Desktop = Desktop.getDesktop();
            try {
                o_Desktop.browse(new URI(this.jLabel_GDTFLink.getText()));
            }
            catch (Exception exception) {}
        } else {
            String stringCommand = "open https://gdtf-share.com";
            try {
                Process o_Process = Runtime.getRuntime().exec(stringCommand);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void jLabel_NoteMouseClicked(MouseEvent evt) {
    }

    private void refreshGUI() {
        if (this.m_GDTFDescription == null) {
            this.jLabel_GDTFDataVersion.setText("");
            this.jLabel_Manufacturer.setText("");
            this.jLabel_DeviceName.setText("");
            this.jLabel_DeviceImage.setIcon(null);
            return;
        }
        this.jLabel_GDTFDataVersion.setText("GDTFVersion: " + this.m_GDTFDescription.getGDTFDataVersion());
        this.jLabel_Manufacturer.setText(this.m_GDTFDescription.getDeviceManufacturer());
        this.jLabel_DeviceName.setText(this.m_GDTFDescription.getDeviceName());
        this.m_DeviceImage = ImagesTools.resizeImage(this.m_GDTFDescription.getDeviceImage(), 128, 128);
        if (this.m_DeviceImage != null) {
            this.jLabel_DeviceImage.setIcon(new ImageIcon(this.m_DeviceImage));
        } else {
            this.jLabel_DeviceImage.setIcon(null);
        }
    }
}

