/*
 * Decompiled with CFR 0.152.
 */
package DMXDeviceEditorPackage;

import FileToolPackage.FileTools;
import ToolsGraphics.ImagesTools;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GDTF_Parser {
    private DocumentBuilderFactory m_DocumentBuilderFactory;

    public GDTF_Parser() {
        this.initMembers();
    }

    private void initMembers() {
        this.m_DocumentBuilderFactory = DocumentBuilderFactory.newInstance();
    }

    public void close() {
    }

    public GDTFDescription interpreteGTDFFile(File p_GDTFFile) {
        if (p_GDTFFile == null) {
            return null;
        }
        if (!".gdtf".equals(FileTools.getFileNameExtension(p_GDTFFile).toLowerCase())) {
            return null;
        }
        boolean boolSuccess = true;
        GDTFDescription o_GDTFDescription = null;
        String stringTempDirectory = System.getProperty("java.io.tmpdir");
        File o_DestDirectory = new File(stringTempDirectory + File.separator + FileTools.getFileNameBase(p_GDTFFile));
        File o_GDTFDirectory = FileTools.unzipFile(o_DestDirectory, p_GDTFFile);
        if (o_GDTFDirectory == null) {
            boolSuccess = false;
        }
        if (boolSuccess) {
            o_GDTFDescription = new GDTFDescription();
            o_GDTFDescription.parse(o_GDTFDirectory);
        }
        FileTools.deleteDirectory(o_GDTFDirectory);
        if (!boolSuccess) {
            return null;
        }
        return o_GDTFDescription;
    }

    public static Color convertCIE_To_sRGB(String p_CIE_String) {
        double doubleY;
        double doubley;
        double doublex;
        if (p_CIE_String == null) {
            return null;
        }
        String[] arrayString = p_CIE_String.split("\\,");
        if (arrayString.length < 3) {
            return null;
        }
        try {
            doublex = Double.valueOf(arrayString[0]);
            doubley = Double.valueOf(arrayString[1]);
            doubleY = Double.valueOf(arrayString[2]);
        }
        catch (Exception e) {
            return null;
        }
        return GDTF_Parser.convertCIE_To_sRGB(doublex, doubley, doubleY);
    }

    public static Color convertCIE_To_sRGB(double x, double y, double bri) {
        double z = 1.0 - x - y;
        double Y = bri / 100.0;
        double X = x * Y / y;
        double Z = (1.0 - x - y) * Y / y;
        double r = X * 3.2404542 + Y * -1.5371385 + Z * -0.4985314;
        double g = X * -0.969266 + Y * 1.8760108 + Z * 0.041556;
        double b = X * 0.0556434 + Y * -0.2040259 + Z * 1.0572252;
        r = GDTF_Parser.getReversedGammaCorrectedValue(r);
        g = GDTF_Parser.getReversedGammaCorrectedValue(g);
        b = GDTF_Parser.getReversedGammaCorrectedValue(b);
        r = Math.max(r, 0.0);
        g = Math.max(g, 0.0);
        b = Math.max(b, 0.0);
        double max = Math.max(Math.max(r, g), b);
        if (max > 1.0) {
            r /= max;
            g /= max;
            b /= max;
        }
        Color o_Color = new Color((int)Math.floor(r * 255.0), (int)Math.floor(g * 255.0), (int)Math.floor(b * 255.0));
        return o_Color;
    }

    private static double getReversedGammaCorrectedValue(double value) {
        value = value <= 0.0031308 ? 12.92 * value : 1.055 * Math.pow(value, 0.4166666666666667) - 0.055;
        return value;
    }

    public static BufferedImage loadBufferedImage(String p_FileName) {
        if (p_FileName == null) {
            return null;
        }
        File o_File = new File(p_FileName);
        return ImagesTools.loadImage(o_File);
    }

    public static double findPhysicalRange(Element p_ElementDMXChannel) {
        if (p_ElementDMXChannel == null) {
            return 0.0;
        }
        if (!"DMXChannel".equals(p_ElementDMXChannel.getTagName())) {
            return 0.0;
        }
        NodeList o_NodeList_LogicalChannel = p_ElementDMXChannel.getElementsByTagName("LogicalChannel");
        if (o_NodeList_LogicalChannel.getLength() <= 0) {
            return 0.0;
        }
        for (int intNode = 0; intNode < o_NodeList_LogicalChannel.getLength(); ++intNode) {
            Node o_Node_LogicalChannel = o_NodeList_LogicalChannel.item(intNode);
            if (o_Node_LogicalChannel == null || o_Node_LogicalChannel.getNodeType() != 1) continue;
            Element o_Element_LogicalChannel = (Element)o_Node_LogicalChannel;
            NodeList o_NodeList_ChannelFunction = o_Element_LogicalChannel.getElementsByTagName("ChannelFunction");
            if (o_NodeList_ChannelFunction.getLength() <= 0) {
                return 0.0;
            }
            for (int intNodeFunction = 0; intNodeFunction < o_NodeList_ChannelFunction.getLength(); ++intNodeFunction) {
                double doublePhysicalTo;
                double doublePhysicalFrom;
                String stringPhysicalTo;
                Element o_Element_ChannelFunction;
                String stringPhysicalFrom;
                Node o_Node_ChannelFunction = o_NodeList_ChannelFunction.item(intNodeFunction);
                if (o_Node_ChannelFunction == null || o_Node_ChannelFunction.getNodeType() != 1 || (stringPhysicalFrom = (o_Element_ChannelFunction = (Element)o_Node_ChannelFunction).getAttribute("PhysicalFrom")) == null || stringPhysicalFrom.length() <= 0 || (stringPhysicalTo = o_Element_ChannelFunction.getAttribute("PhysicalTo")) == null || stringPhysicalTo.length() <= 0) continue;
                try {
                    doublePhysicalFrom = Double.valueOf(stringPhysicalFrom);
                    doublePhysicalTo = Double.valueOf(stringPhysicalTo);
                }
                catch (Exception e) {
                    continue;
                }
                return Math.max(doublePhysicalFrom, doublePhysicalTo) - Math.min(doublePhysicalFrom, doublePhysicalTo);
            }
        }
        return 0.0;
    }

    public static int findElectricalPayLoad(GDTFDescription p_GDTFDescription) {
        if (p_GDTFDescription == null) {
            return 0;
        }
        double doubleValue = 0.0;
        double doublePowerConsumption = 0.0;
        double doubleElectricalPayLoad = 0.0;
        double doubleGDTFDataVersion = p_GDTFDescription.getGDTFDataVersion_Double();
        ArrayList<Element> o_ElementsToDo = new ArrayList<Element>();
        o_ElementsToDo.add(p_GDTFDescription.getElement_Root());
        while (o_ElementsToDo.size() > 0) {
            Element o_Element = (Element)o_ElementsToDo.get(o_ElementsToDo.size() - 1);
            o_ElementsToDo.remove(o_ElementsToDo.size() - 1);
            String stringValue = o_Element.getAttribute("PowerConsumption");
            if (stringValue.length() > 0) {
                try {
                    doubleValue = Double.valueOf(stringValue);
                    doublePowerConsumption += doubleValue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (doubleGDTFDataVersion >= 1.2 && (stringValue = o_Element.getAttribute("ElectricalPayLoad")).length() > 0) {
                try {
                    doubleValue = Double.valueOf(stringValue);
                    doubleElectricalPayLoad += doubleValue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            NodeList o_NodeList = o_Element.getChildNodes();
            for (int intNode = 0; intNode < o_NodeList.getLength(); ++intNode) {
                Node o_Node = o_NodeList.item(intNode);
                if (!(o_Node instanceof Element)) continue;
                o_ElementsToDo.add((Element)o_Node);
            }
        }
        doubleValue = 0.0;
        doubleValue = doublePowerConsumption > doubleElectricalPayLoad ? doublePowerConsumption : doubleElectricalPayLoad;
        return (int)doubleValue;
    }

    public static String findEmitterID(Element p_ElementDMXChannel) {
        if (p_ElementDMXChannel == null) {
            return null;
        }
        if (!"DMXChannel".equals(p_ElementDMXChannel.getTagName())) {
            return null;
        }
        NodeList o_NodeList_LogicalChannel = p_ElementDMXChannel.getElementsByTagName("LogicalChannel");
        if (o_NodeList_LogicalChannel.getLength() <= 0) {
            return null;
        }
        for (int intNode = 0; intNode < o_NodeList_LogicalChannel.getLength(); ++intNode) {
            Node o_Node_LogicalChannel = o_NodeList_LogicalChannel.item(intNode);
            if (o_NodeList_LogicalChannel == null || o_Node_LogicalChannel.getNodeType() != 1) continue;
            Element o_Element_LogicalChannel = (Element)o_Node_LogicalChannel;
            NodeList o_NodeList_ChannelFunction = o_Element_LogicalChannel.getElementsByTagName("ChannelFunction");
            if (o_NodeList_ChannelFunction.getLength() <= 0) {
                return null;
            }
            for (int intNodeFunction = 0; intNodeFunction < o_NodeList_ChannelFunction.getLength(); ++intNodeFunction) {
                Element o_Element_ChannelFunction;
                String stringEmitter;
                Node o_Node_ChannelFunction = o_NodeList_ChannelFunction.item(intNodeFunction);
                if (o_Node_ChannelFunction == null || o_Node_ChannelFunction.getNodeType() != 1 || (stringEmitter = (o_Element_ChannelFunction = (Element)o_Node_ChannelFunction).getAttribute("Emitter")).length() <= 0) continue;
                return stringEmitter;
            }
        }
        return null;
    }

    public static int getDMXValue(String p_DMXValue) {
        if (p_DMXValue == null) {
            return 0;
        }
        int intDMXValue = 0;
        String[] arrayString = p_DMXValue.split("\\/");
        if (arrayString.length != 2) {
            return 0;
        }
        try {
            intDMXValue = Integer.valueOf(arrayString[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return intDMXValue;
    }

    public static class GDTFDescription {
        private File m_GDTFDirectory;
        private String m_GDTFDataVersion;
        private double m_GDTFDataVersion_Double;
        private File m_FileDecription;
        private Element m_ElementRoot;
        private Element m_ElementFixtureType;
        private String m_DeviceID;
        private String m_DeviceManufacturer;
        private String m_DeviceName;
        private String m_DeviceShortName;
        private String m_DeviceLongName;
        private String m_DeviceDescription;
        private BufferedImage m_DeviceImage;
        private int m_DevicePowerConsumption;
        private HashMap<String, Wheel> m_Wheels;
        private HashMap<String, Emitter> m_Emitters;
        private HashMap<String, Filter> m_Filters;
        private ArrayList<DMXMode> m_DMXModes;

        public GDTFDescription() {
            this.initMembers();
        }

        private void initMembers() {
            this.m_FileDecription = null;
            this.m_GDTFDataVersion = "";
            this.m_GDTFDataVersion_Double = 0.0;
            this.m_DeviceID = "";
            this.m_DeviceName = "";
            this.m_DeviceShortName = "";
            this.m_DeviceLongName = "";
            this.m_DeviceDescription = "";
            this.m_DeviceImage = null;
            this.m_DevicePowerConsumption = 0;
            this.m_Wheels = new HashMap();
            this.m_Emitters = new HashMap();
            this.m_Filters = new HashMap();
            this.m_DMXModes = new ArrayList();
        }

        public boolean parse(File p_GDTDirectory) {
            File[] o_GDTFiles;
            if (p_GDTDirectory == null) {
                return false;
            }
            if (!p_GDTDirectory.exists()) {
                return false;
            }
            if (!p_GDTDirectory.isDirectory()) {
                return false;
            }
            this.m_GDTFDirectory = p_GDTDirectory;
            try {
                o_GDTFiles = p_GDTDirectory.listFiles();
            }
            catch (Exception e) {
                return false;
            }
            if (o_GDTFiles.length <= 0) {
                return false;
            }
            for (int intFile = 0; intFile < o_GDTFiles.length; ++intFile) {
                File o_GDTFFile = o_GDTFiles[intFile];
                if (o_GDTFFile == null) continue;
                if (o_GDTFFile.getName().endsWith(".png")) {
                    this.m_DeviceImage = GDTF_Parser.loadBufferedImage(o_GDTFFile.getAbsolutePath());
                    continue;
                }
                if (!"description.xml".equals(o_GDTFFile.getName().toLowerCase())) continue;
                this.m_FileDecription = o_GDTFFile;
            }
            if (this.m_FileDecription == null) {
                return false;
            }
            return this.parseDescriptionXML();
        }

        private boolean parseDescriptionXML() {
            if (this.m_FileDecription == null) {
                return false;
            }
            boolean boolSuccess = true;
            DocumentBuilderFactory o_DocumentBuilderFactory = null;
            DocumentBuilder o_DocumentBuilder = null;
            Document o_Document = null;
            try {
                o_DocumentBuilderFactory = DocumentBuilderFactory.newInstance();
                o_DocumentBuilder = o_DocumentBuilderFactory.newDocumentBuilder();
                o_Document = o_DocumentBuilder.parse(this.m_FileDecription);
            }
            catch (Exception e) {
                boolSuccess = false;
            }
            if (!boolSuccess) {
                return false;
            }
            this.m_ElementRoot = this.getElement_Root(o_Document);
            if (this.m_ElementRoot == null) {
                return false;
            }
            if (!"gdtf".equals(this.m_ElementRoot.getNodeName().toLowerCase())) {
                return false;
            }
            this.m_GDTFDataVersion = this.m_ElementRoot.getAttribute("DataVersion");
            try {
                this.m_GDTFDataVersion_Double = Double.valueOf(this.m_GDTFDataVersion);
            }
            catch (Exception e) {
                this.m_GDTFDataVersion_Double = 0.0;
            }
            this.m_ElementFixtureType = this.getElement_FixtureType(this.m_ElementRoot);
            if (this.m_ElementFixtureType == null) {
                return false;
            }
            this.m_DeviceID = this.m_ElementFixtureType.getAttribute("FixtureTypeID");
            this.m_DeviceManufacturer = this.m_ElementFixtureType.getAttribute("Manufacturer");
            this.m_DeviceName = this.m_ElementFixtureType.getAttribute("Name");
            this.m_DeviceLongName = this.m_ElementFixtureType.getAttribute("LongName");
            this.m_DeviceShortName = this.m_ElementFixtureType.getAttribute("ShortName");
            this.m_DeviceDescription = this.m_ElementFixtureType.getAttribute("Description");
            this.parseWheels(this.m_ElementFixtureType);
            this.parseEmitterFilters(this.m_ElementFixtureType);
            if (!this.parseDMXModes(this.m_ElementFixtureType)) {
                return false;
            }
            this.m_DevicePowerConsumption = GDTF_Parser.findElectricalPayLoad(this);
            return true;
        }

        public String getGDTFDataVersion() {
            return this.m_GDTFDataVersion;
        }

        public double getGDTFDataVersion_Double() {
            return this.m_GDTFDataVersion_Double;
        }

        public String getDeviceID() {
            return this.m_DeviceID;
        }

        public String getDeviceManufacturer() {
            return this.m_DeviceManufacturer;
        }

        public String getDeviceName() {
            return this.m_DeviceName;
        }

        public String getDeviceLongName() {
            return this.m_DeviceLongName;
        }

        public String getDeviceShortName() {
            return this.m_DeviceShortName;
        }

        public String getDeviceDescription() {
            return this.m_DeviceDescription;
        }

        public BufferedImage getDeviceImage() {
            return this.m_DeviceImage;
        }

        public int getDevicePowerConsumtion() {
            return this.m_DevicePowerConsumption;
        }

        public void report() {
            System.out.println("Device Manufacturer: " + this.m_DeviceManufacturer + " Name: " + this.m_DeviceName);
            System.out.println("ID: " + this.m_DeviceID);
            for (int intMode = 0; intMode < this.getDMXModeCount(); ++intMode) {
                DMXMode o_DMXMode = this.getDMXMode(intMode);
                if (o_DMXMode == null) continue;
                System.out.println("    DMXMode: " + o_DMXMode.getName() + " DMXUniverseChannelCount: " + o_DMXMode.getDMXUniverseChannelCount() + " MaxBytes: " + o_DMXMode.m_DMXUniverseMaxChannelBytes);
                System.out.println("    DMXFaderCount: " + o_DMXMode.getDMXFaderCount());
                for (int intFader = 0; intFader < o_DMXMode.getDMXFaderCount(); ++intFader) {
                    DMXChannel o_DMXChannel;
                    DMXFader o_DMXFader = o_DMXMode.getDMXFader(intFader);
                    if (o_DMXFader == null) continue;
                    System.out.println("        DMXFader: " + o_DMXFader.getName() + " MaxBytes: " + o_DMXFader.getDMXUniverseMaxBytes() + " DMXChannelCount: " + o_DMXFader.getDMXChannelCount());
                    if (!(o_DMXFader instanceof DMXChannel)) {
                        if (!(o_DMXFader instanceof DMXExtraColor)) continue;
                        DMXExtraColor o_DMXExtraColor = (DMXExtraColor)o_DMXFader;
                        o_DMXChannel = o_DMXExtraColor.getDMXChannel(null);
                    } else {
                        o_DMXChannel = (DMXChannel)o_DMXFader;
                    }
                    for (int intFunctionList = 0; intFunctionList < o_DMXChannel.getFunctionListCount(); ++intFunctionList) {
                        DMXChannel.FunctionList o_FunctionList = o_DMXChannel.getFunctionList(intFunctionList);
                        if (o_FunctionList == null) continue;
                        System.out.print("            Functionlist: " + o_FunctionList.getName());
                        DMXChannel o_DependDMXChannel = o_FunctionList.getDependingDMXChannel();
                        if (o_DependDMXChannel != null) {
                            System.out.println(" depends on DMXChannel: " + o_DependDMXChannel.getName() + "(" + o_FunctionList.getModeFrom() + "-" + o_FunctionList.getModeTo() + ")");
                        } else {
                            System.out.println();
                        }
                        for (int intChannelFunction = 0; intChannelFunction < o_FunctionList.getChannelFunctionCount(); ++intChannelFunction) {
                            DMXChannel.ChannelFunction o_ChannelFunction = o_FunctionList.getChannelFunction(intChannelFunction);
                            o_ChannelFunction = o_FunctionList.getChannelFunction(intChannelFunction);
                            if (o_ChannelFunction == null) continue;
                            System.out.println("                ChannelFunction: " + o_ChannelFunction.getName() + " (" + o_ChannelFunction.getDMXFrom() + "-" + o_ChannelFunction.getDMXTo() + ")");
                            for (int intChannelSet = 0; intChannelSet < o_ChannelFunction.getChannelSetCount(); ++intChannelSet) {
                                DMXChannel.ChannelSet o_ChannelSet = o_ChannelFunction.getChannelSet(intChannelSet);
                                if (o_ChannelSet == null) continue;
                                System.out.println("                    ChannelSet: " + o_ChannelSet.getName() + " (" + o_ChannelSet.getDMXFrom() + "-" + o_ChannelSet.getDMXTo() + ") Color: " + o_ChannelSet.getColor() + " Image: " + o_ChannelSet.getBufferedImage());
                            }
                        }
                    }
                }
            }
        }

        public Element getElement_Root() {
            return this.m_ElementRoot;
        }

        private Element getElement_Root(Document p_Document) {
            Element o_Element_Root = null;
            if (p_Document == null) {
                return null;
            }
            o_Element_Root = p_Document.getDocumentElement();
            if (o_Element_Root == null) {
                return null;
            }
            o_Element_Root.normalize();
            return o_Element_Root;
        }

        private Element getElement_FixtureType(Element p_ElementRoot) {
            if (p_ElementRoot == null) {
                return null;
            }
            Element o_Element_FixtureType = null;
            NodeList o_NodeList_FixtureType = p_ElementRoot.getElementsByTagName("FixtureType");
            if (o_NodeList_FixtureType.getLength() <= 0) {
                return null;
            }
            for (int intNode = 0; intNode < o_NodeList_FixtureType.getLength(); ++intNode) {
                Node o_Node = o_NodeList_FixtureType.item(intNode);
                if (o_Node == null || o_Node.getNodeType() != 1) continue;
                o_Element_FixtureType = (Element)o_Node;
                break;
            }
            return o_Element_FixtureType;
        }

        private boolean parseEmitterFilters(Element p_Element_FixtureType) {
            NodeList o_NodeList_Emitters;
            String stringColorString;
            String stringName;
            Node o_Node_Filters;
            if (p_Element_FixtureType == null) {
                return false;
            }
            Element o_Element_PhysicalDescriptions = null;
            Element o_Element_Filters = null;
            Element o_Element_Filter = null;
            Element o_Element_Emitters = null;
            Element o_Element_Emitter = null;
            NodeList o_NodeList_PhysicalDescriptions = p_Element_FixtureType.getElementsByTagName("PhysicalDescriptions");
            if (o_NodeList_PhysicalDescriptions.getLength() <= 0) {
                return false;
            }
            Node o_Node_PhysicalDescriptions = o_NodeList_PhysicalDescriptions.item(0);
            if (o_Node_PhysicalDescriptions != null && o_Node_PhysicalDescriptions.getNodeType() == 1) {
                o_Element_PhysicalDescriptions = (Element)o_Node_PhysicalDescriptions;
            }
            if (o_Element_PhysicalDescriptions == null) {
                return false;
            }
            NodeList o_NodeList_Filters = o_Element_PhysicalDescriptions.getElementsByTagName("Filters");
            if (o_NodeList_Filters.getLength() > 0 && (o_Node_Filters = o_NodeList_Filters.item(0)) != null && o_Node_Filters.getNodeType() == 1) {
                o_Element_Filters = (Element)o_Node_Filters;
            }
            if (o_Element_Filters != null) {
                NodeList o_NodeList_Filter = o_Element_Filters.getElementsByTagName("Filter");
                for (int intNodeFilter = 0; intNodeFilter < o_NodeList_Filter.getLength(); ++intNodeFilter) {
                    Node o_Node_Filter = o_NodeList_Filter.item(intNodeFilter);
                    if (o_Node_Filter == null || o_Node_Filter.getNodeType() != 1) continue;
                    o_Element_Filter = (Element)o_Node_Filter;
                    stringName = o_Element_Filter.getAttribute("Name");
                    stringColorString = o_Element_Filter.getAttribute("Color");
                    Filter o_Filter = new Filter(this, stringName, stringColorString);
                    this.m_Filters.put(stringName, o_Filter);
                }
            }
            if ((o_NodeList_Emitters = o_Element_PhysicalDescriptions.getElementsByTagName("Emitters")).getLength() > 0) {
                Node o_Node_Emitters = o_NodeList_Emitters.item(0);
                if (o_NodeList_Emitters != null && o_Node_Emitters.getNodeType() == 1) {
                    o_Element_Emitters = (Element)o_Node_Emitters;
                }
            }
            if (o_Element_Emitters != null) {
                NodeList o_NodeList_Emitter = o_Element_Emitters.getElementsByTagName("Emitter");
                for (int intNodeEmitter = 0; intNodeEmitter < o_NodeList_Emitter.getLength(); ++intNodeEmitter) {
                    Node o_Node_Emitter = o_NodeList_Emitter.item(intNodeEmitter);
                    if (o_Node_Emitter == null || o_Node_Emitter.getNodeType() != 1) continue;
                    o_Element_Emitter = (Element)o_Node_Emitter;
                    stringName = o_Element_Emitter.getAttribute("Name");
                    stringColorString = o_Element_Emitter.getAttribute("Color");
                    Emitter o_Emitter = new Emitter(this, stringName, stringColorString);
                    this.m_Emitters.put(stringName, o_Emitter);
                }
            }
            return true;
        }

        public Emitter getEmitter(String p_EmitterName) {
            if (p_EmitterName == null) {
                return null;
            }
            return this.m_Emitters.get(p_EmitterName);
        }

        private boolean parseWheels(Element p_Element_FixtureType) {
            if (p_Element_FixtureType == null) {
                return false;
            }
            NodeList o_NodeList_Wheels = p_Element_FixtureType.getElementsByTagName("Wheels");
            if (o_NodeList_Wheels.getLength() <= 0) {
                return false;
            }
            Node o_Node_Wheels = o_NodeList_Wheels.item(0);
            if (o_Node_Wheels == null || o_Node_Wheels.getNodeType() != 1) {
                return false;
            }
            Element o_Element_Wheels = (Element)o_Node_Wheels;
            NodeList o_NodeList_Wheel = o_Element_Wheels.getElementsByTagName("Wheel");
            for (int intNodeWhhel = 0; intNodeWhhel < o_NodeList_Wheel.getLength(); ++intNodeWhhel) {
                Node o_Node_Wheel = o_NodeList_Wheel.item(intNodeWhhel);
                if (o_Node_Wheel == null || o_Node_Wheel.getNodeType() != 1) continue;
                Element o_Element_Wheel = (Element)o_Node_Wheel;
                String stringWheelName = o_Element_Wheel.getAttribute("Name");
                Wheel o_Wheel = this.m_Wheels.get(stringWheelName);
                if (o_Wheel == null) {
                    o_Wheel = new Wheel(this, stringWheelName);
                    this.m_Wheels.put(stringWheelName, o_Wheel);
                }
                NodeList o_NodeList_Slot = o_Element_Wheel.getElementsByTagName("Slot");
                for (int intNodeSlot = 0; intNodeSlot < o_NodeList_Slot.getLength(); ++intNodeSlot) {
                    Node o_Node_Slot = o_NodeList_Slot.item(intNodeSlot);
                    if (o_Node_Slot == null || o_Node_Slot.getNodeType() != 1) continue;
                    Element o_Element_Slot = (Element)o_Node_Slot;
                    String stringSlotName = o_Element_Slot.getAttribute("Name");
                    String stringSlotColor = o_Element_Slot.getAttribute("Color");
                    String stringSlotFilter = o_Element_Slot.getAttribute("Filter");
                    String stringSlotMediaFileName = o_Element_Slot.getAttribute("MediaFileName");
                    o_Wheel.addSlot(stringWheelName, stringSlotColor, stringSlotFilter, stringSlotMediaFileName);
                }
            }
            return true;
        }

        public int getWheelCount() {
            return this.m_Wheels.size();
        }

        public Wheel getWheel(String p_WheelName) {
            if (p_WheelName == null) {
                return null;
            }
            return this.m_Wheels.get(p_WheelName);
        }

        private boolean parseDMXModes(Element p_Element_FixtureType) {
            if (p_Element_FixtureType == null) {
                return false;
            }
            boolean boolDMXModeFound = false;
            NodeList o_NodeList_DMXModes = p_Element_FixtureType.getElementsByTagName("DMXModes");
            if (o_NodeList_DMXModes.getLength() <= 0) {
                return false;
            }
            Node o_Node = o_NodeList_DMXModes.item(0);
            if (o_Node == null || o_Node.getNodeType() != 1) {
                return false;
            }
            Element o_Element_DMXModes = (Element)o_Node;
            NodeList o_NodeList_DMXMode = o_Element_DMXModes.getElementsByTagName("DMXMode");
            for (int intNode = 0; intNode < o_NodeList_DMXMode.getLength(); ++intNode) {
                Element o_Element_DMXMode;
                DMXMode o_DMXMode;
                o_Node = o_NodeList_DMXMode.item(intNode);
                if (o_Node == null || o_Node.getNodeType() != 1 || !(o_DMXMode = new DMXMode(this)).parseElement_DMXMode(o_Element_DMXMode = (Element)o_Node)) continue;
                this.addDMXMode(o_DMXMode);
                boolDMXModeFound = true;
            }
            return boolDMXModeFound;
        }

        public void addDMXMode(DMXMode p_DMXMode) {
            if (p_DMXMode == null) {
                return;
            }
            this.m_DMXModes.add(p_DMXMode);
        }

        public int getDMXModeCount() {
            return this.m_DMXModes.size();
        }

        public DMXMode getDMXMode(int p_Index) {
            if (p_Index < 0) {
                return null;
            }
            if (p_Index >= this.m_DMXModes.size()) {
                return null;
            }
            return this.m_DMXModes.get(p_Index);
        }

        public File getGDTFDirectory() {
            return this.m_GDTFDirectory;
        }

        public File getFileDescription() {
            return this.m_FileDecription;
        }

        public static class DMXChannel
        extends DMXFader {
            private String m_InitialFunction_ID;
            private String m_InitialFunction_Name;
            private ArrayList<Integer> m_DMXOffsets;
            private int m_DefaultValue;
            private ArrayList<FunctionList> m_FunctionLists;

            public DMXChannel(DMXMode p_DMXMode) {
                super(p_DMXMode);
                this.initMembers();
                this.m_DMXMode = p_DMXMode;
            }

            private void initMembers() {
                this.m_DMXMode = null;
                this.m_InitialFunction_ID = "";
                this.m_InitialFunction_Type = "";
                this.m_InitialFunction_Name = "";
                this.m_DMXOffsets = new ArrayList();
                this.m_FunctionLists = new ArrayList();
            }

            public boolean parseElement_DMXChannel(Element p_ElementDMXChannel) {
                Node o_Node__LogicalChannel;
                if (p_ElementDMXChannel == null) {
                    return false;
                }
                if (!"DMXChannel".equals(p_ElementDMXChannel.getTagName())) {
                    return false;
                }
                this.setDMXOffset(p_ElementDMXChannel.getAttribute("Offset"));
                if (this.m_DMXOffsets.size() <= 0) {
                    return false;
                }
                String stringDMXBreak = p_ElementDMXChannel.getAttribute("DMXBreak");
                try {
                    this.m_DMXBreak = Integer.valueOf(stringDMXBreak);
                }
                catch (Exception e) {
                    this.m_DMXBreak = 1;
                }
                this.m_Geometry = p_ElementDMXChannel.getAttribute("Geometry");
                this.setInitialFunction(p_ElementDMXChannel.getAttribute("InitialFunction"));
                this.checkDMXChannel(p_ElementDMXChannel, this.m_Geometry, this.m_InitialFunction_Type);
                NodeList o_NodeList_LogicalChannel = p_ElementDMXChannel.getElementsByTagName("LogicalChannel");
                if (o_NodeList_LogicalChannel.getLength() > 0 && (o_Node__LogicalChannel = o_NodeList_LogicalChannel.item(0)) != null && o_Node__LogicalChannel.getNodeType() == 1) {
                    Element o_Element_LogicalChannel = (Element)o_Node__LogicalChannel;
                    this.checkFunctionLists(o_Element_LogicalChannel);
                }
                return true;
            }

            public void setInitialFunction(String p_InitialFunction) {
                if (p_InitialFunction == null) {
                    return;
                }
                String[] arrayString = p_InitialFunction.split("\\.");
                if (arrayString.length == 3) {
                    this.m_InitialFunction_Name = arrayString[2];
                    this.m_InitialFunction_Type = arrayString[1];
                    this.m_InitialFunction_ID = arrayString[0];
                }
            }

            public String getInitialFunction_ID() {
                return this.m_InitialFunction_ID;
            }

            public String getInitialFunctionName() {
                return this.m_InitialFunction_Name;
            }

            public void setDMXOffset(String p_DMXOffset) {
                if (p_DMXOffset == null) {
                    return;
                }
                this.m_DMXOffsets.clear();
                String[] arrayDMXOffsets = p_DMXOffset.split(",");
                for (int countOffset = 0; countOffset < arrayDMXOffsets.length; ++countOffset) {
                    int intOffset;
                    try {
                        intOffset = Integer.valueOf(arrayDMXOffsets[countOffset]);
                    }
                    catch (Exception e) {
                        continue;
                    }
                    this.m_DMXOffsets.add(intOffset);
                }
            }

            public int getDMXOffsetCount() {
                return this.m_DMXOffsets.size();
            }

            public int getDMXOffset(int p_Index) {
                if (p_Index < 0) {
                    return -1;
                }
                if (p_Index >= this.m_DMXOffsets.size()) {
                    return -1;
                }
                return this.m_DMXOffsets.get(p_Index);
            }

            private void checkDMXChannel(Element p_ElementDMXChannel, String p_Geometry, String p_FunctionType) {
                if (p_ElementDMXChannel == null) {
                    return;
                }
                if (p_Geometry == null) {
                    return;
                }
                if (p_FunctionType == null) {
                    return;
                }
                if (this.m_DMXMode == null) {
                    return;
                }
                String stringColorType = null;
                if ("ColorAdd_R".equals(p_FunctionType)) {
                    stringColorType = DMXRGB.COLOR_R;
                } else if ("ColorAdd_G".equals(p_FunctionType)) {
                    stringColorType = DMXRGB.COLOR_G;
                } else if ("ColorAdd_B".equals(p_FunctionType)) {
                    stringColorType = DMXRGB.COLOR_B;
                } else if ("ColorSub_C".equals(p_FunctionType)) {
                    stringColorType = DMXRGB.COLOR_C;
                } else if ("ColorSub_M".equals(p_FunctionType)) {
                    stringColorType = DMXRGB.COLOR_M;
                } else if ("ColorSub_Y".equals(p_FunctionType)) {
                    stringColorType = DMXRGB.COLOR_Y;
                }
                if (stringColorType != null) {
                    this.m_IsRGB = true;
                    DMXRGB o_DMXRGB = this.m_DMXMode.getDMXRGB(p_Geometry);
                    if (o_DMXRGB == null) {
                        o_DMXRGB = new DMXRGB(this.m_DMXMode);
                        this.m_DMXMode.addDMXRGB(o_DMXRGB);
                        this.m_DMXMode.addDMXFader(o_DMXRGB);
                    }
                    o_DMXRGB.addDMXChannel(this, stringColorType);
                    return;
                }
                String stringPanTilt_Type = null;
                if ("Pan".equals(p_FunctionType)) {
                    stringPanTilt_Type = DMXPanTilt.PAN;
                    this.m_DMXMode.setDMXPanTilt_PanAngleRange(GDTF_Parser.findPhysicalRange(p_ElementDMXChannel));
                } else if ("Tilt".equals(p_FunctionType)) {
                    stringPanTilt_Type = DMXPanTilt.TILT;
                    this.m_DMXMode.setDMXPanTilt_TiltAngleRange(GDTF_Parser.findPhysicalRange(p_ElementDMXChannel));
                }
                if (stringPanTilt_Type != null) {
                    this.m_IsPanTilt = true;
                    DMXPanTilt o_DMXPanTilt = this.m_DMXMode.getDMXPanTilt(DMXPanTilt.GEOMETRY_PANTILT);
                    if (o_DMXPanTilt == null) {
                        o_DMXPanTilt = new DMXPanTilt(this.m_DMXMode);
                        this.m_DMXMode.addDMXPanTilt(o_DMXPanTilt);
                        this.m_DMXMode.addDMXFader(o_DMXPanTilt);
                    }
                    o_DMXPanTilt.addDMXChannel(this, stringPanTilt_Type);
                    return;
                }
                if (p_FunctionType.contains("Dimmer")) {
                    this.m_isDimmer = true;
                    this.m_DMXMode.addDMXFader(this);
                    this.m_DMXMode.setDimmerMainExists(true);
                    return;
                }
                String stringExtraColorID = null;
                if (p_FunctionType.contains("ColorAdd_") || p_FunctionType.contains("ColorSub_")) {
                    if (p_FunctionType.contains("ColorAdd_")) {
                        stringExtraColorID = p_FunctionType.substring("ColorAdd_".length(), p_FunctionType.length());
                    } else if (p_FunctionType.contains("ColorSub_")) {
                        stringExtraColorID = p_FunctionType.substring("ColorSub_".length(), p_FunctionType.length());
                    }
                }
                if (stringExtraColorID != null) {
                    Emitter o_Emitter = null;
                    DMXExtraColor o_DMXExtraColor = new DMXExtraColor(this);
                    String stringEmitterID = GDTF_Parser.findEmitterID(p_ElementDMXChannel);
                    if (stringEmitterID != null) {
                        o_Emitter = this.m_DMXMode.getGDTFDescription().getEmitter(stringEmitterID);
                    }
                    if (o_Emitter != null) {
                        o_DMXExtraColor.setColorName(o_Emitter.getName());
                        o_DMXExtraColor.setColor(o_Emitter.getColor());
                    } else {
                        o_DMXExtraColor.setExtraColorID(stringExtraColorID);
                    }
                    this.m_DMXMode.addDMXFader(o_DMXExtraColor);
                    return;
                }
                if (p_FunctionType.contains("Fog")) {
                    this.m_DMXMode.setDimmerMainExists(false);
                    this.m_DMXMode.setOutputEffectExists(true);
                }
                this.m_DMXMode.addDMXFader(this);
            }

            private void checkFunctionLists(Element p_ElementLogicalChannel) {
                if (p_ElementLogicalChannel == null) {
                    return;
                }
                if (!"LogicalChannel".equals(p_ElementLogicalChannel.getTagName())) {
                    return;
                }
                NodeList o_NodeList_ChannelFunction = p_ElementLogicalChannel.getElementsByTagName("ChannelFunction");
                for (int intChannelFunction = 0; intChannelFunction < o_NodeList_ChannelFunction.getLength(); ++intChannelFunction) {
                    Node o_Node_ChannelFunction = o_NodeList_ChannelFunction.item(intChannelFunction);
                    if (o_Node_ChannelFunction == null || o_Node_ChannelFunction.getNodeType() != 1) continue;
                    Element o_Element_ChannelFunction = (Element)o_Node_ChannelFunction;
                    ChannelFunction o_ChannelFunction = new ChannelFunction(this);
                    o_ChannelFunction.parseElementChannelFunction(o_Element_ChannelFunction);
                    if (this.m_FunctionLists.size() <= 0) {
                        this.m_DefaultValue = o_ChannelFunction.getDefaultValue();
                    }
                    FunctionList o_FunctionList = this.createFunctionList(o_ChannelFunction);
                    o_FunctionList.addChannelFunction(o_ChannelFunction);
                }
            }

            public FunctionList createFunctionList(ChannelFunction p_ChannelFunction) {
                FunctionList o_FunctionList;
                if (p_ChannelFunction == null) {
                    return null;
                }
                if (p_ChannelFunction.getModeMaster() == null || p_ChannelFunction.getModeMaster().length() <= 0) {
                    if (this.m_FunctionLists.size() <= 0) {
                        FunctionList o_FunctionList2 = new FunctionList(this);
                        this.m_FunctionLists.add(o_FunctionList2);
                        return o_FunctionList2;
                    }
                    return this.m_FunctionLists.get(0);
                }
                for (int intList = 0; intList < this.m_FunctionLists.size(); ++intList) {
                    o_FunctionList = this.m_FunctionLists.get(intList);
                    if (!p_ChannelFunction.getModeMaster().equals(o_FunctionList.getModeMaster()) || p_ChannelFunction.getModeFrom() != o_FunctionList.getModeFrom() || p_ChannelFunction.getModeTo() != o_FunctionList.getModeTo()) continue;
                    return o_FunctionList;
                }
                o_FunctionList = new FunctionList(this);
                o_FunctionList.setDependsOn(p_ChannelFunction.getModeMaster(), p_ChannelFunction.getModeFrom(), p_ChannelFunction.getModeTo());
                o_FunctionList.setName(p_ChannelFunction.getName());
                this.m_FunctionLists.add(o_FunctionList);
                return o_FunctionList;
            }

            public int getFunctionListCount() {
                return this.m_FunctionLists.size();
            }

            public FunctionList getFunctionList(int p_Index) {
                if (p_Index < 0) {
                    return null;
                }
                if (p_Index >= this.m_FunctionLists.size()) {
                    return null;
                }
                return this.m_FunctionLists.get(p_Index);
            }

            public ChannelFunction getChannelFunction(int p_DMXFrom, int p_DMXTo) {
                for (int intFunctionList = 0; intFunctionList < this.m_FunctionLists.size(); ++intFunctionList) {
                    FunctionList o_FunctionList = this.m_FunctionLists.get(intFunctionList);
                    for (int intChannelFunction = 0; intChannelFunction < o_FunctionList.getChannelFunctionCount(); ++intChannelFunction) {
                        ChannelFunction o_ChannelFunction = o_FunctionList.getChannelFunction(intChannelFunction);
                        if (p_DMXTo < o_ChannelFunction.getDMXFrom() || p_DMXFrom > o_ChannelFunction.getDMXTo()) continue;
                        return o_ChannelFunction;
                    }
                }
                return null;
            }

            @Override
            public int getDMXUniverseMaxBytes() {
                return this.m_DMXOffsets.size();
            }

            @Override
            public int getDMXChannelCount() {
                return 1;
            }

            @Override
            public DMXChannel getDMXChannel(String p_ChannelKey) {
                return this;
            }

            public int getDefaultValue() {
                return this.m_DefaultValue;
            }

            public static class ChannelSet {
                private ChannelFunction m_ChannelFunction;
                private int m_DMXFrom;
                private int m_DMXTo;
                private String m_Name;
                private Color m_Color;
                private BufferedImage m_BufferedImage;

                public ChannelSet(ChannelFunction p_ChannelFunction) {
                    this.initMembers();
                    this.m_ChannelFunction = p_ChannelFunction;
                    int intUniversChannelCount = this.m_ChannelFunction.getDMXChannel().getDMXOffsetCount();
                    this.m_DMXTo = (int)Math.pow(256.0, intUniversChannelCount) - 1;
                }

                private void initMembers() {
                    this.m_DMXFrom = -1;
                    this.m_DMXTo = -1;
                    this.m_Name = "";
                    this.m_Color = null;
                    this.m_BufferedImage = null;
                }

                public boolean parseElementChannelSet(Element p_ElementChannelSet) {
                    String stringColor;
                    Color o_Color;
                    int intWheelSlotIndex;
                    if (p_ElementChannelSet == null) {
                        return false;
                    }
                    if (!"ChannelSet".equals(p_ElementChannelSet.getTagName())) {
                        return false;
                    }
                    Wheel o_Wheel = null;
                    Wheel.Slot o_WheelSlot = null;
                    String stringDMXFrom = p_ElementChannelSet.getAttribute("DMXFrom");
                    StringBuilder o_StrinBuilder = new StringBuilder();
                    o_StrinBuilder.append(this.m_ChannelFunction.getName());
                    o_StrinBuilder.append(" ");
                    o_StrinBuilder.append(p_ElementChannelSet.getAttribute("Name"));
                    this.m_Name = o_StrinBuilder.toString();
                    this.m_DMXFrom = GDTF_Parser.getDMXValue(stringDMXFrom);
                    String stringWheelSlotIndex = p_ElementChannelSet.getAttribute("WheelSlotIndex");
                    if (stringWheelSlotIndex.length() <= 0) {
                        intWheelSlotIndex = 0;
                    } else {
                        try {
                            intWheelSlotIndex = Integer.valueOf(stringWheelSlotIndex);
                        }
                        catch (Exception e) {
                            intWheelSlotIndex = 0;
                        }
                    }
                    o_Wheel = this.m_ChannelFunction.getWheel();
                    if (o_Wheel != null && intWheelSlotIndex > 0) {
                        o_WheelSlot = o_Wheel.getSlot(intWheelSlotIndex);
                    }
                    if (o_WheelSlot != null) {
                        this.m_Color = o_WheelSlot.getColor();
                        this.m_BufferedImage = o_WheelSlot.getBufferedImage();
                    }
                    if ((o_Color = GDTF_Parser.convertCIE_To_sRGB(stringColor = p_ElementChannelSet.getAttribute("Color"))) != null) {
                        this.m_Color = o_Color;
                    }
                    return true;
                }

                public String getName() {
                    return this.m_Name;
                }

                public Color getColor() {
                    return this.m_Color;
                }

                public BufferedImage getBufferedImage() {
                    return this.m_BufferedImage;
                }

                public void setDMXFrom(int p_DMXFrom) {
                    this.m_DMXFrom = p_DMXFrom;
                }

                public int getDMXFrom() {
                    return this.m_DMXFrom;
                }

                public void setDMXTo(int p_DMXTo) {
                    this.m_DMXTo = p_DMXTo;
                }

                public int getDMXTo() {
                    return this.m_DMXTo;
                }
            }

            public static class ChannelFunction {
                private DMXChannel m_DMXChannel;
                private String m_Name;
                private int m_DMXFrom;
                private int m_DMXTo;
                private String m_ModeMaster;
                private int m_ModeFrom;
                private int m_ModeTo;
                private Wheel m_Wheel;
                private int m_DefaultValue;
                private ArrayList<ChannelSet> m_ChannelSets;

                public ChannelFunction(DMXChannel p_DMXChannel) {
                    this.initMembers();
                    this.m_DMXChannel = p_DMXChannel;
                    int intUniversChannelCount = this.m_DMXChannel.getDMXOffsetCount();
                    this.m_DMXTo = (int)Math.pow(256.0, intUniversChannelCount) - 1;
                }

                private void initMembers() {
                    this.m_DMXChannel = null;
                    this.m_Name = "";
                    this.m_DMXFrom = 0;
                    this.m_DMXTo = 255;
                    this.m_ChannelSets = new ArrayList();
                    this.m_ModeMaster = "";
                    this.m_ModeFrom = -1;
                    this.m_ModeTo = -1;
                    this.m_Wheel = null;
                    this.m_DefaultValue = 0;
                }

                public boolean parseElementChannelFunction(Element p_ElementChannelFunction) {
                    if (p_ElementChannelFunction == null) {
                        return false;
                    }
                    if (!"ChannelFunction".equals(p_ElementChannelFunction.getTagName())) {
                        return false;
                    }
                    String stringDefaultValue = "0";
                    this.m_Name = p_ElementChannelFunction.getAttribute("Name");
                    stringDefaultValue = p_ElementChannelFunction.getAttribute("Default");
                    this.m_DefaultValue = GDTF_Parser.getDMXValue(stringDefaultValue);
                    String stringWheelID = p_ElementChannelFunction.getAttribute("Wheel");
                    if (this.m_DMXChannel == null) {
                        return false;
                    }
                    DMXMode o_DMXMode = this.m_DMXChannel.getDMXMode();
                    if (o_DMXMode == null) {
                        return false;
                    }
                    GDTFDescription o_GDTFDescription = o_DMXMode.getGDTFDescription();
                    this.m_Wheel = o_GDTFDescription.getWheel(stringWheelID);
                    String stringModeMaster = p_ElementChannelFunction.getAttribute("ModeMaster");
                    if (stringModeMaster.length() > 0) {
                        String[] arrayString = stringModeMaster.split("\\.");
                        this.m_ModeMaster = arrayString[0];
                        String stringModeFrom = p_ElementChannelFunction.getAttribute("ModeFrom");
                        String stringModeTo = p_ElementChannelFunction.getAttribute("ModeTo");
                        this.m_ModeFrom = GDTF_Parser.getDMXValue(stringModeFrom);
                        this.m_ModeTo = GDTF_Parser.getDMXValue(stringModeTo);
                    }
                    String stringDMXFrom = p_ElementChannelFunction.getAttribute("DMXFrom");
                    this.m_DMXFrom = GDTF_Parser.getDMXValue(stringDMXFrom);
                    NodeList o_NodeList_ChannelSet = p_ElementChannelFunction.getElementsByTagName("ChannelSet");
                    for (int intNode = 0; intNode < o_NodeList_ChannelSet.getLength(); ++intNode) {
                        Element o_Element_ChannelSet;
                        ChannelSet o_ChannelSet;
                        Node o_Node_ChannelSet = o_NodeList_ChannelSet.item(intNode);
                        if (o_Node_ChannelSet == null || o_Node_ChannelSet.getNodeType() != 1 || !(o_ChannelSet = new ChannelSet(this)).parseElementChannelSet(o_Element_ChannelSet = (Element)o_Node_ChannelSet)) continue;
                        this.addChannelSet(o_ChannelSet);
                    }
                    return true;
                }

                public DMXChannel getDMXChannel() {
                    return this.m_DMXChannel;
                }

                public String getName() {
                    return this.m_Name;
                }

                public int getDefaultValue() {
                    return this.m_DefaultValue;
                }

                public String getModeMaster() {
                    return this.m_ModeMaster;
                }

                public int getModeFrom() {
                    return this.m_ModeFrom;
                }

                public int getModeTo() {
                    return this.m_ModeTo;
                }

                public void setDMXFrom(int p_DMXFrom) {
                    this.m_DMXFrom = p_DMXFrom;
                }

                public int getDMXFrom() {
                    return this.m_DMXFrom;
                }

                public void setDMXTo(int p_DMXTo) {
                    this.m_DMXTo = p_DMXTo;
                    if (this.m_ChannelSets.size() > 0) {
                        ChannelSet o_ChannelSet_Last = this.m_ChannelSets.get(this.m_ChannelSets.size() - 1);
                        o_ChannelSet_Last.setDMXTo(p_DMXTo);
                    }
                }

                public int getDMXTo() {
                    return this.m_DMXTo;
                }

                public Wheel getWheel() {
                    return this.m_Wheel;
                }

                public void addChannelSet(ChannelSet p_ChannelSet) {
                    if (p_ChannelSet == null) {
                        return;
                    }
                    if (this.m_ChannelSets.size() > 0) {
                        ChannelSet o_ChannelSet_Previous = this.m_ChannelSets.get(this.m_ChannelSets.size() - 1);
                        o_ChannelSet_Previous.setDMXTo(p_ChannelSet.getDMXFrom() - 1);
                    }
                    this.m_ChannelSets.add(p_ChannelSet);
                }

                public int getChannelSetCount() {
                    return this.m_ChannelSets.size();
                }

                public ChannelSet getChannelSet(int p_Index) {
                    if (p_Index < 0) {
                        return null;
                    }
                    if (p_Index >= this.m_ChannelSets.size()) {
                        return null;
                    }
                    return this.m_ChannelSets.get(p_Index);
                }

                public ChannelSet getChannelSet(int p_DMXFrom, int p_DMXTo) {
                    for (int intChannelSet = 0; intChannelSet < this.m_ChannelSets.size(); ++intChannelSet) {
                        ChannelSet o_ChannelSet = this.m_ChannelSets.get(intChannelSet);
                        if (p_DMXTo < o_ChannelSet.getDMXFrom() || p_DMXFrom > o_ChannelSet.getDMXTo()) continue;
                        return o_ChannelSet;
                    }
                    return null;
                }
            }

            public static class FunctionList {
                private DMXChannel m_DMXChannel;
                private String m_ModeMaster;
                private int m_ModeFrom;
                private int m_ModeTo;
                private String m_Name;
                private ArrayList<ChannelFunction> m_ChannelFunctions;

                public FunctionList(DMXChannel p_DMXChannel) {
                    this.initMembers();
                    this.m_DMXChannel = p_DMXChannel;
                }

                private void initMembers() {
                    this.m_DMXChannel = null;
                    this.m_ModeMaster = "";
                    this.m_ModeFrom = -1;
                    this.m_ModeTo = -1;
                    this.m_Name = "Standard";
                    this.m_ChannelFunctions = new ArrayList();
                }

                public void setDependsOn(String p_DMXChannelID, int p_From, int p_To) {
                    if (p_DMXChannelID == null) {
                        p_DMXChannelID = "";
                    }
                    this.m_ModeMaster = p_DMXChannelID;
                    this.m_ModeFrom = p_From;
                    this.m_ModeTo = p_To;
                }

                public DMXChannel getDependingDMXChannel() {
                    DMXMode o_DMXMode = this.m_DMXChannel.getDMXMode();
                    if (o_DMXMode != null) {
                        return o_DMXMode.getDMXChannel(this.m_ModeMaster);
                    }
                    return null;
                }

                public void setName(String p_Name) {
                    if (p_Name == null || p_Name.length() <= 0) {
                        return;
                    }
                    this.m_Name = p_Name;
                }

                public String getName() {
                    ChannelFunction o_ChannelFunction;
                    DMXChannel o_DMXChannel;
                    DMXMode o_DMXMode = this.m_DMXChannel.getDMXMode();
                    if (o_DMXMode != null && this.m_ModeMaster.contains(".") && (o_DMXChannel = o_DMXMode.getDMXChannel(this.m_ModeMaster)) != null && (o_ChannelFunction = o_DMXChannel.getChannelFunction(this.m_ModeFrom, this.m_ModeTo)) != null) {
                        ChannelSet o_ChannelSet = o_ChannelFunction.getChannelSet(this.m_ModeFrom, this.m_ModeTo);
                        this.m_Name = o_ChannelSet != null ? o_ChannelSet.getName() : o_ChannelFunction.getName();
                    }
                    return this.m_Name;
                }

                public String getModeMaster() {
                    return this.m_ModeMaster;
                }

                public int getModeFrom() {
                    return this.m_ModeFrom;
                }

                public int getModeTo() {
                    return this.m_ModeTo;
                }

                public void addChannelFunction(ChannelFunction p_ChannelFunction) {
                    if (p_ChannelFunction == null) {
                        return;
                    }
                    if (this.m_ChannelFunctions.size() > 0) {
                        ChannelFunction o_PreviousChannelFunction = this.m_ChannelFunctions.get(this.m_ChannelFunctions.size() - 1);
                        o_PreviousChannelFunction.setDMXTo(p_ChannelFunction.getDMXFrom() - 1);
                    }
                    if (p_ChannelFunction.getChannelSetCount() == 0) {
                        ChannelSet o_ChannelSet = new ChannelSet(p_ChannelFunction);
                        o_ChannelSet.setDMXFrom(0);
                    }
                    this.m_ChannelFunctions.add(p_ChannelFunction);
                }

                public int getChannelFunctionCount() {
                    return this.m_ChannelFunctions.size();
                }

                public ChannelFunction getChannelFunction(int p_Index) {
                    if (p_Index < 0) {
                        return null;
                    }
                    if (p_Index >= this.m_ChannelFunctions.size()) {
                        return null;
                    }
                    return this.m_ChannelFunctions.get(p_Index);
                }
            }
        }

        public static class DMXMode {
            private GDTFDescription m_GDTFDescription;
            private String m_DMXModeID;
            private String m_Name;
            private ArrayList<DMXChannel> m_DMXChannels;
            private ArrayList<DMXFader> m_DMXFaders;
            private ArrayList<DMXRGB> m_DMXRGBs;
            private ArrayList<DMXPanTilt> m_DMXPanTilts;
            private double m_DMXPanTilt_PanAngleRange;
            private double m_DMXPanTilt_TiltAngleRange;
            private boolean m_DimmerMainExists;
            private boolean m_OutputEffectExists;
            private int m_DMXUniverseChannelCount;
            private int m_DMXUniverseMaxChannelBytes;

            public DMXMode(GDTFDescription p_GDTFDescription) {
                this.initMembers();
                this.m_GDTFDescription = p_GDTFDescription;
            }

            private void initMembers() {
                this.m_Name = "";
                this.m_DMXChannels = new ArrayList();
                this.m_DMXFaders = new ArrayList();
                this.m_DMXRGBs = new ArrayList();
                this.m_DMXPanTilts = new ArrayList();
                this.m_DMXPanTilt_PanAngleRange = 0.0;
                this.m_DMXPanTilt_TiltAngleRange = 0.0;
                this.m_DMXUniverseChannelCount = 0;
                this.m_DMXUniverseMaxChannelBytes = 1;
                this.m_DimmerMainExists = false;
                this.m_OutputEffectExists = false;
            }

            public GDTFDescription getGDTFDescription() {
                return this.m_GDTFDescription;
            }

            public boolean parseElement_DMXMode(Element p_DMXModeElement) {
                if (p_DMXModeElement == null) {
                    return false;
                }
                if (!"DMXMode".equals(p_DMXModeElement.getTagName())) {
                    return false;
                }
                boolean boolDMXChannelFound = false;
                this.m_Name = p_DMXModeElement.getAttribute("Name");
                this.m_Name = FileTools.validateName(this.m_Name);
                NodeList o_NodeList_DMXChannels = p_DMXModeElement.getElementsByTagName("DMXChannels");
                if (o_NodeList_DMXChannels.getLength() <= 0) {
                    return false;
                }
                Node o_Node = o_NodeList_DMXChannels.item(0);
                if (o_Node != null && o_Node.getNodeType() == 1) {
                    Element o_Element_DMXChannels = (Element)o_Node;
                    NodeList o_NodeList_DMXChannel = o_Element_DMXChannels.getElementsByTagName("DMXChannel");
                    for (int intNode = 0; intNode < o_NodeList_DMXChannel.getLength(); ++intNode) {
                        Element o_Element_DMXChannel;
                        DMXChannel o_DMXChannel;
                        o_Node = o_NodeList_DMXChannel.item(intNode);
                        if (o_Node == null || o_Node.getNodeType() != 1 || !(o_DMXChannel = new DMXChannel(this)).parseElement_DMXChannel(o_Element_DMXChannel = (Element)o_Node)) continue;
                        this.addDMXChannel(o_DMXChannel);
                        boolDMXChannelFound = true;
                    }
                }
                this.m_DMXModeID = this.m_Name.length() > 0 ? this.m_GDTFDescription.getDeviceID() + "_" + this.m_Name : this.m_GDTFDescription.getDeviceID() + "_" + String.valueOf(this.getDMXUniverseChannelCount()) + "CH";
                return boolDMXChannelFound;
            }

            public String getID() {
                return this.m_DMXModeID;
            }

            public String getDisplayText() {
                StringBuilder o_StringBuilder = new StringBuilder();
                o_StringBuilder.append(this.m_Name);
                o_StringBuilder.append("  ");
                o_StringBuilder.append("(");
                o_StringBuilder.append(this.getDMXUniverseChannelCount());
                o_StringBuilder.append("CH)");
                o_StringBuilder.append("  ");
                for (int intFader = 0; intFader < this.getDMXFaderCount(); ++intFader) {
                    DMXFader o_DMXFader = this.getDMXFader(intFader);
                    if (!o_DMXFader.isDimmer()) continue;
                    o_StringBuilder.append("  ");
                    o_StringBuilder.append("Dimmer");
                    break;
                }
                return o_StringBuilder.toString();
            }

            public String getName() {
                if (this.m_Name.length() <= 0) {
                    this.m_Name = String.valueOf(this.m_DMXUniverseChannelCount) + "CH";
                }
                return this.m_Name;
            }

            public void addDMXChannel(DMXChannel p_DMXChannel) {
                if (p_DMXChannel == null) {
                    return;
                }
                this.m_DMXChannels.add(p_DMXChannel);
                int intChannelCount = p_DMXChannel.getDMXOffsetCount();
                this.m_DMXUniverseChannelCount += intChannelCount;
                if (intChannelCount > this.m_DMXUniverseMaxChannelBytes) {
                    this.m_DMXUniverseMaxChannelBytes = intChannelCount;
                }
            }

            public int getDMXChannelCount() {
                return this.m_DMXChannels.size();
            }

            public DMXChannel getDMXChannel(int p_Index) {
                if (p_Index < 0) {
                    return null;
                }
                if (p_Index >= this.m_DMXChannels.size()) {
                    return null;
                }
                return this.m_DMXChannels.get(p_Index);
            }

            public DMXChannel getDMXChannel(String p_InitialFunctionID) {
                if (p_InitialFunctionID == null) {
                    return null;
                }
                for (int intDMXChannel = 0; intDMXChannel < this.m_DMXChannels.size(); ++intDMXChannel) {
                    DMXChannel o_DMXChannel = this.m_DMXChannels.get(intDMXChannel);
                    if (!p_InitialFunctionID.equals(o_DMXChannel.getInitialFunction_ID())) continue;
                    return o_DMXChannel;
                }
                return null;
            }

            public int getDMXUniverseChannelCount() {
                return this.m_DMXUniverseChannelCount;
            }

            public int getDMXUniverseMaxChannelBytes() {
                return this.m_DMXUniverseMaxChannelBytes;
            }

            public void addDMXFader(DMXFader p_DMXFader) {
                if (p_DMXFader == null) {
                    return;
                }
                if (this.m_DMXFaders.contains(p_DMXFader)) {
                    return;
                }
                this.m_DMXFaders.add(p_DMXFader);
            }

            public int getDMXFaderCount() {
                return this.m_DMXFaders.size();
            }

            public DMXFader getDMXFader(int p_Index) {
                if (p_Index < 0) {
                    return null;
                }
                if (p_Index >= this.m_DMXFaders.size()) {
                    return null;
                }
                return this.m_DMXFaders.get(p_Index);
            }

            public void addDMXRGB(DMXRGB p_DMXRGB) {
                if (p_DMXRGB == null) {
                    return;
                }
                this.m_DMXRGBs.add(p_DMXRGB);
            }

            public DMXRGB getDMXRGB(String p_Geometry) {
                if (p_Geometry == null) {
                    return null;
                }
                for (int intFader = 0; intFader < this.m_DMXRGBs.size(); ++intFader) {
                    DMXFader o_DMXFader = this.m_DMXRGBs.get(intFader);
                    if (!p_Geometry.equals(o_DMXFader.getGeometry())) continue;
                    return (DMXRGB)o_DMXFader;
                }
                return null;
            }

            public void addDMXPanTilt(DMXPanTilt p_DMXPanTilt) {
                if (p_DMXPanTilt == null) {
                    return;
                }
                this.m_DMXPanTilts.add(p_DMXPanTilt);
            }

            public DMXPanTilt getDMXPanTilt(String p_Geometry) {
                if (p_Geometry == null) {
                    return null;
                }
                for (int intFader = 0; intFader < this.m_DMXPanTilts.size(); ++intFader) {
                    DMXFader o_DMXFader = this.m_DMXPanTilts.get(intFader);
                    if (!p_Geometry.equals(o_DMXFader.getGeometry())) continue;
                    return (DMXPanTilt)o_DMXFader;
                }
                return null;
            }

            public void setDMXPanTilt_PanAngleRange(double p_PanAngle) {
                this.m_DMXPanTilt_PanAngleRange = p_PanAngle;
            }

            public double getDMXPanTilt_PanAngleRange() {
                return this.m_DMXPanTilt_PanAngleRange;
            }

            public void setDMXPanTilt_TiltAngleRange(double p_TiltAngle) {
                this.m_DMXPanTilt_TiltAngleRange = p_TiltAngle;
            }

            public double getDMXPanTilt_TiltAngleRange() {
                return this.m_DMXPanTilt_TiltAngleRange;
            }

            public void setDimmerMainExists(boolean p_DimmerExists) {
                if (!this.m_OutputEffectExists) {
                    this.m_DimmerMainExists = p_DimmerExists;
                }
            }

            public boolean getDimmerMainExists() {
                return this.m_DimmerMainExists;
            }

            public void setOutputEffectExists(boolean p_OutputEffectExists) {
                this.m_OutputEffectExists = p_OutputEffectExists;
            }

            public boolean getOutputEffectExists() {
                return this.m_OutputEffectExists;
            }
        }

        public static class DMXExtraColor
        extends DMXFader {
            public static final String COLORID_WHITE = "W";
            public static final String COLORID_WARMWHITE = "WW";
            public static final String COLORID_COLDWHITE = "CW";
            public static final String COLORID_AMBER = "RY";
            public static final String COLORID_LIME = "GY";
            public static final String COLORID_LIGHTBLUE = "BC";
            public static final String COLORID_PURPLE = "BM";
            public static final String COLORID_PINK = "RM";
            public static final String COLORID_CYAN_ADD = "C";
            public static final String COLORID_MAGENTA_ADD = "M";
            public static final String COLORID_YELLOW_ADD = "Y";
            public static final String COLORID_UV = "UV";
            public static final String COLORID_RED_SUB = "R";
            public static final String COLORID_GREEN_SUB = "G";
            public static final String COLORID_BLUE_SUB = "B";
            private DMXChannel m_DMXChannel;
            private String m_ExtraColorID;
            private String m_ExtraColorName;
            private Color m_ExtraColor;

            public DMXExtraColor(DMXChannel p_DMXChannel) {
                super(p_DMXChannel.getDMXMode());
                this.initMembers();
                this.m_IsExtraColor = true;
                this.m_DMXChannel = p_DMXChannel;
            }

            private void initMembers() {
                this.m_DMXChannel = null;
                this.m_ExtraColorID = "";
                this.m_ExtraColorName = "";
                this.m_ExtraColor = null;
            }

            public void setExtraColorID(String p_ExtraColorID) {
                this.m_ExtraColorID = p_ExtraColorID;
                switch (p_ExtraColorID) {
                    case "W": {
                        this.m_ExtraColorName = "White";
                        this.m_ExtraColor = new Color(255, 255, 255);
                        break;
                    }
                    case "WW": {
                        this.m_ExtraColorName = "WarmWhite";
                        this.m_ExtraColor = new Color(255, 230, 230);
                        break;
                    }
                    case "CW": {
                        this.m_ExtraColorName = "ColdWhite";
                        this.m_ExtraColor = new Color(230, 230, 255);
                        break;
                    }
                    case "RY": {
                        this.m_ExtraColorName = "Amber";
                        this.m_ExtraColor = new Color(255, 191, 0);
                        break;
                    }
                    case "GY": {
                        this.m_ExtraColorName = "Lime";
                        this.m_ExtraColor = new Color(50, 255, 50);
                        break;
                    }
                    case "BC": {
                        this.m_ExtraColorName = "LightBlue";
                        this.m_ExtraColor = new Color(173, 216, 230);
                        break;
                    }
                    case "BM": {
                        this.m_ExtraColorName = "Purple";
                        this.m_ExtraColor = new Color(130, 0, 255);
                        break;
                    }
                    case "RM": {
                        this.m_ExtraColorName = "Pink";
                        this.m_ExtraColor = new Color(255, 192, 203);
                        break;
                    }
                    case "C": {
                        this.m_ExtraColorName = "Cyan";
                        this.m_ExtraColor = new Color(0, 255, 255);
                        break;
                    }
                    case "M": {
                        this.m_ExtraColorName = "Magenta";
                        this.m_ExtraColor = new Color(255, 0, 255);
                        break;
                    }
                    case "Y": {
                        this.m_ExtraColorName = "Yellow";
                        this.m_ExtraColor = new Color(255, 255, 0);
                        break;
                    }
                    case "UV": {
                        this.m_ExtraColorName = COLORID_UV;
                        this.m_ExtraColor = new Color(0, 0, 200);
                        break;
                    }
                    case "R": {
                        this.m_ExtraColorName = "Red";
                        this.m_ExtraColor = new Color(255, 0, 0);
                        break;
                    }
                    case "G": {
                        this.m_ExtraColorName = "Green";
                        this.m_ExtraColor = new Color(0, 255, 0);
                        break;
                    }
                    case "B": {
                        this.m_ExtraColorName = "Blue";
                        this.m_ExtraColor = new Color(0, 0, 255);
                        break;
                    }
                    default: {
                        this.m_ExtraColorName = "";
                        this.m_ExtraColor = new Color(0, 0, 0);
                    }
                }
            }

            public String getColorID() {
                return this.m_ExtraColorID;
            }

            public void setColorName(String p_ColorName) {
                this.m_ExtraColorName = p_ColorName;
            }

            public String getColorName() {
                return this.m_ExtraColorName;
            }

            public void setColor(Color p_Color) {
                this.m_ExtraColor = p_Color;
            }

            public Color getColor() {
                return this.m_ExtraColor;
            }

            @Override
            public int getDMXUniverseMaxBytes() {
                return this.m_DMXChannel.getDMXUniverseMaxBytes();
            }

            @Override
            public int getDMXChannelCount() {
                return 1;
            }

            @Override
            public DMXChannel getDMXChannel(String p_ChannelKey) {
                return this.m_DMXChannel;
            }
        }

        public static class DMXPanTilt
        extends DMXFader {
            public static String FUNCTIONTYPE = "PanTilt";
            public static String PAN = "pan";
            public static String TILT = "Tilt";
            public static String GEOMETRY_PANTILT = "yokehead";
            private HashMap<String, DMXChannel> m_DMXChannels;
            private int m_DMXUniverseMaxBytes;

            public DMXPanTilt(DMXMode p_DMXMode) {
                super(p_DMXMode);
                this.initMembers();
                this.m_IsPanTilt = true;
                this.m_Geometry = GEOMETRY_PANTILT;
                this.m_InitialFunction_Type = FUNCTIONTYPE;
            }

            private void initMembers() {
                this.m_DMXChannels = new HashMap();
                this.m_DMXChannels.put(PAN, null);
                this.m_DMXChannels.put(TILT, null);
                this.m_DMXUniverseMaxBytes = 1;
            }

            public void addDMXChannel(DMXChannel p_DMXChannel, String p_PanTiltType) {
                if (p_DMXChannel == null) {
                    return;
                }
                if (p_PanTiltType == null) {
                    return;
                }
                if (!this.m_DMXChannels.keySet().contains(p_PanTiltType)) {
                    return;
                }
                if (this.m_Geometry.length() > 0) {
                    if (!this.m_Geometry.contains(p_DMXChannel.getGeometry().toLowerCase())) {
                        return;
                    }
                    DMXChannel o_DMXChannel = this.getDMXChannel(p_PanTiltType);
                    if (o_DMXChannel != null) {
                        // empty if block
                    }
                    this.m_DMXChannels.put(p_PanTiltType, p_DMXChannel);
                    if (p_DMXChannel.getDMXOffsetCount() > this.m_DMXUniverseMaxBytes) {
                        this.m_DMXUniverseMaxBytes = p_DMXChannel.getDMXOffsetCount();
                    }
                }
            }

            public boolean hasAllChannels() {
                if (this.m_DMXChannels.get(PAN) == null) {
                    return false;
                }
                return this.m_DMXChannels.get(TILT) != null;
            }

            @Override
            public int getDMXUniverseMaxBytes() {
                return this.m_DMXUniverseMaxBytes;
            }

            @Override
            public int getDMXChannelCount() {
                int intDMXChannelCount = 0;
                for (String stringKey : this.m_DMXChannels.keySet()) {
                    if (this.m_DMXChannels.get(stringKey) == null) continue;
                    ++intDMXChannelCount;
                }
                return intDMXChannelCount;
            }

            @Override
            public DMXChannel getDMXChannel(String p_ChannelKey) {
                return this.m_DMXChannels.get(p_ChannelKey);
            }
        }

        public static class DMXRGB
        extends DMXFader {
            public static String FUNCTIONTYPE = "RGB";
            public static String COLOR_R = "r";
            public static String COLOR_G = "g";
            public static String COLOR_B = "b";
            public static String COLOR_C = "c";
            public static String COLOR_M = "m";
            public static String COLOR_Y = "y";
            public static String COLOR_CMY = "cmy";
            private HashMap<String, DMXChannel> m_DMXChannels;
            private int m_DMXUniverseMaxBytes;

            public DMXRGB(DMXMode p_DMXMode) {
                super(p_DMXMode);
                this.initMembers();
                this.m_InitialFunction_Type = FUNCTIONTYPE;
                this.m_IsRGB = true;
            }

            private void initMembers() {
                this.m_DMXChannels = new HashMap();
                this.m_DMXChannels.put(COLOR_R, null);
                this.m_DMXChannels.put(COLOR_G, null);
                this.m_DMXChannels.put(COLOR_B, null);
                this.m_DMXChannels.put(COLOR_C, null);
                this.m_DMXChannels.put(COLOR_M, null);
                this.m_DMXChannels.put(COLOR_Y, null);
                this.m_DMXUniverseMaxBytes = 1;
            }

            public void addDMXChannel(DMXChannel p_DMXChannel, String p_ColorType) {
                DMXChannel o_DMXChannel;
                if (p_DMXChannel == null) {
                    return;
                }
                if (p_ColorType == null) {
                    return;
                }
                if (!this.m_DMXChannels.keySet().contains(p_ColorType)) {
                    return;
                }
                if (this.m_Geometry.length() > 0 && !this.m_Geometry.equals(p_DMXChannel.getGeometry())) {
                    return;
                }
                if (this.m_Geometry.length() <= 0) {
                    this.m_Geometry = p_DMXChannel.getGeometry();
                }
                if ((o_DMXChannel = this.getDMXChannel(p_ColorType)) != null) {
                    boolean bl = false;
                }
                this.m_DMXChannels.put(p_ColorType, p_DMXChannel);
                if (p_DMXChannel.getDMXOffsetCount() > this.m_DMXUniverseMaxBytes) {
                    this.m_DMXUniverseMaxBytes = p_DMXChannel.getDMXOffsetCount();
                }
            }

            public boolean hasAllDMXChannels() {
                if (this.isRGB()) {
                    if (this.m_DMXChannels.get(COLOR_R) == null) {
                        return false;
                    }
                    if (this.m_DMXChannels.get(COLOR_G) == null) {
                        return false;
                    }
                    if (this.m_DMXChannels.get(COLOR_B) == null) {
                        return false;
                    }
                } else {
                    if (this.m_DMXChannels.get(COLOR_C) == null) {
                        return false;
                    }
                    if (this.m_DMXChannels.get(COLOR_M) == null) {
                        return false;
                    }
                    if (this.m_DMXChannels.get(COLOR_Y) == null) {
                        return false;
                    }
                }
                return true;
            }

            public boolean isColorModelRGB() {
                return this.m_DMXChannels.get(COLOR_R) != null;
            }

            public boolean isColorModelCMY() {
                return this.m_DMXChannels.get(COLOR_C) != null;
            }

            @Override
            public int getDMXUniverseMaxBytes() {
                return this.m_DMXUniverseMaxBytes;
            }

            @Override
            public int getDMXChannelCount() {
                int intDMXChannelCount = 0;
                for (String stringKey : this.m_DMXChannels.keySet()) {
                    if (this.m_DMXChannels.get(stringKey) == null) continue;
                    ++intDMXChannelCount;
                }
                return intDMXChannelCount;
            }

            @Override
            public DMXChannel getDMXChannel(String p_ChannelKey) {
                return this.m_DMXChannels.get(p_ChannelKey);
            }
        }

        public static abstract class DMXFader {
            protected DMXMode m_DMXMode;
            protected int m_DMXBreak;
            protected String m_Geometry;
            protected String m_InitialFunction_Type;
            protected boolean m_IsRGB;
            protected boolean m_IsPanTilt;
            protected boolean m_IsExtraColor;
            protected boolean m_isDimmer;

            public DMXFader(DMXMode p_DMXMode) {
                this.initMembers();
                this.m_DMXMode = p_DMXMode;
            }

            private void initMembers() {
                this.m_DMXMode = null;
                this.m_DMXBreak = 1;
                this.m_Geometry = "";
                this.m_InitialFunction_Type = "";
                this.m_isDimmer = false;
                this.m_IsPanTilt = false;
                this.m_IsRGB = false;
                this.m_IsExtraColor = false;
            }

            public DMXMode getDMXMode() {
                return this.m_DMXMode;
            }

            public GDTFDescription getGDTFDescription() {
                if (this.m_DMXMode == null) {
                    return null;
                }
                return this.m_DMXMode.getGDTFDescription();
            }

            public int getDMXBreak() {
                return this.m_DMXBreak;
            }

            public String getGeometry() {
                return this.m_Geometry;
            }

            public String getInitialFunctionType() {
                return this.m_InitialFunction_Type;
            }

            public boolean isDimmer() {
                return this.m_isDimmer;
            }

            public boolean isRGB() {
                return this.m_IsRGB;
            }

            public boolean isPanTilt() {
                return this.m_IsPanTilt;
            }

            public boolean isExtraColor() {
                return this.m_IsExtraColor;
            }

            public String getName() {
                String stringFaderName = "";
                stringFaderName = this.m_IsRGB ? this.m_Geometry : (this.m_IsPanTilt ? "PanTilt" : (this instanceof DMXExtraColor ? ((DMXExtraColor)this).getColorName() : this.getInitialFunctionType()));
                if (stringFaderName == null || stringFaderName.length() <= 0) {
                    stringFaderName = "???";
                }
                return stringFaderName;
            }

            public abstract int getDMXUniverseMaxBytes();

            public abstract int getDMXChannelCount();

            public abstract DMXChannel getDMXChannel(String var1);
        }

        public static class Filter {
            GDTFDescription m_GDTFDescription;
            private String m_Name;
            private Color m_Color;

            public Filter(GDTFDescription p_GDTFDescription, String p_Name, String p_ColorString) {
                this.m_GDTFDescription = p_GDTFDescription;
                if (p_Name == null) {
                    p_Name = "";
                }
                this.m_Name = p_Name;
                if (p_ColorString == null) {
                    p_ColorString = "";
                }
                this.m_Color = GDTF_Parser.convertCIE_To_sRGB(p_ColorString);
            }

            public GDTFDescription getGDTFDescription() {
                return this.m_GDTFDescription;
            }

            public String getName() {
                return this.m_Name;
            }

            public Color getColor() {
                return this.m_Color;
            }
        }

        public static class Emitter {
            GDTFDescription m_GDTFDescription;
            private String m_Name;
            private Color m_Color;

            public Emitter(GDTFDescription p_GDTFDescription, String p_Name, String p_ColorString) {
                this.m_GDTFDescription = p_GDTFDescription;
                if (p_Name == null) {
                    p_Name = "";
                }
                this.m_Name = p_Name;
                if (p_ColorString == null) {
                    p_ColorString = "";
                }
                this.m_Color = GDTF_Parser.convertCIE_To_sRGB(p_ColorString);
            }

            public GDTFDescription getGDTFDescription() {
                return this.m_GDTFDescription;
            }

            public String getName() {
                return this.m_Name;
            }

            public Color getColor() {
                return this.m_Color;
            }
        }

        public static class Wheel {
            private GDTFDescription m_GDTFDescription;
            private String m_Name;
            private ArrayList<Slot> m_Slots;

            public Wheel(GDTFDescription p_GDTFDescription, String p_Name) {
                this.initMembers();
                this.m_GDTFDescription = p_GDTFDescription;
                this.m_Name = p_Name;
            }

            private void initMembers() {
                this.m_GDTFDescription = null;
                this.m_Name = "";
                this.m_Slots = new ArrayList();
            }

            public void addSlot(String p_SlotName, String p_SlotColorString, String p_SlotFilterString, String p_SlotMediaFileName) {
                Slot o_Slot = null;
                if (o_Slot == null) {
                    o_Slot = new Slot(this);
                    o_Slot.setParams(p_SlotName, p_SlotColorString, p_SlotFilterString, p_SlotMediaFileName);
                    this.m_Slots.add(o_Slot);
                }
            }

            public Slot getSlot(int p_WheelSlotIndex) {
                int intWheelSlotIndex = p_WheelSlotIndex - 1;
                if (intWheelSlotIndex < 0) {
                    return null;
                }
                if (intWheelSlotIndex >= this.m_Slots.size()) {
                    return null;
                }
                return this.m_Slots.get(intWheelSlotIndex);
            }

            public GDTFDescription getGDTFDescription() {
                return this.m_GDTFDescription;
            }

            public static class Slot {
                private Wheel m_Wheel;
                private String m_Name;
                private String m_ColoString;
                private String m_FilterString;
                private String m_MediaFilename;
                private Color m_Color;
                private BufferedImage m_BufferedImage;

                public Slot(Wheel p_Wheel) {
                    this.m_Wheel = p_Wheel;
                }

                public void setParams(String p_Name, String p_Color, String p_Filter, String p_MediaFilename) {
                    if (this.m_Wheel == null) {
                        return;
                    }
                    if (p_Name == null) {
                        p_Name = "";
                    }
                    this.m_Name = p_Name;
                    if (p_Color == null) {
                        p_Color = "";
                    }
                    this.m_ColoString = p_Color;
                    if (p_Filter == null) {
                        this.m_FilterString = "";
                    }
                    this.m_FilterString = p_Filter;
                    if (p_MediaFilename == null) {
                        p_MediaFilename = "";
                    }
                    this.m_MediaFilename = p_MediaFilename;
                    this.m_Color = GDTF_Parser.convertCIE_To_sRGB(this.m_ColoString);
                    this.m_BufferedImage = this.findBufferedImage();
                }

                public String getName() {
                    return this.m_Name;
                }

                public Color getColor() {
                    return this.m_Color;
                }

                public String getFilterName() {
                    return this.m_FilterString;
                }

                private BufferedImage findBufferedImage() {
                    if (this.m_MediaFilename.length() <= 0) {
                        return null;
                    }
                    if (this.m_Wheel == null) {
                        return null;
                    }
                    GDTFDescription o_GDTFDescription = this.m_Wheel.getGDTFDescription();
                    if (o_GDTFDescription == null) {
                        return null;
                    }
                    File o_File = o_GDTFDescription.getGDTFDirectory();
                    if (o_File == null) {
                        return null;
                    }
                    o_File = new File(o_File.getAbsolutePath() + File.separator + "wheels" + File.separator + this.m_MediaFilename + ".png");
                    return GDTF_Parser.loadBufferedImage(o_File.getAbsolutePath());
                }

                public BufferedImage getBufferedImage() {
                    return this.m_BufferedImage;
                }
            }
        }
    }
}

