/*
 * Decompiled with CFR 0.152.
 */
package DMXHardwarePackage;

import DMXHardwarePackage.DMX4All_StageProfiUSBDMXInterface_Configuration;
import DMXHardwarePackage.DMXHardwareFeedbackInterface;
import DMXHardwarePackage.DMXHardwareInterface;
import DMXHardwarePackage.DMXHardwarePluginFeedbackInterface;
import DMXHardwarePackage.DMXHardwarePluginInterface;
import GUIDPackage.HardwareGUID;
import LiveCommSerial.CommSerialPortConnection;
import LiveCommSerial.CommSerialPortEvent;
import LiveCommSerial.CommSerialPortEventListener;
import LiveCommSerial.CommSerialPortException;
import java.awt.Frame;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.charset.Charset;
import java.util.ArrayList;
import javax.swing.ImageIcon;

public class DMX4All_StageProfiUSBDMXInterface
implements DMXHardwareInterface,
DMXHardwarePluginInterface,
CommSerialPortEventListener {
    public static int s_OSFlag = -1;
    public static int s_OSARchitectureFlag = -1;
    public static final int CONNECTION_TYPE = 1;
    public static final int ADDRESS_FIRST = 0;
    public static final int ADDRESS_LAST = 511;
    public static final int DMXPLUGIN_COUNT = 1;
    private static final String PARAM_DIVIDER = ";";
    private String m_ID;
    private boolean m_DebugOn;
    private boolean m_DebugFailureOn;
    private ImageIcon m_IconInterface;
    private ImageIcon m_IconLogo;
    private DMX4All_StageProfiUSBDMXInterface_Configuration m_DMX4All_Configuration;
    private static ArrayList<String> s_CommPorts = new ArrayList();
    private CommSerialPortConnection m_CommSerialPortConnection;
    private int m_ConnectionStatus;
    private String m_CommPortName;
    private int m_CommBaudrate;
    private static final int ANSWER_UNREADY = 0;
    private static final int ANSWER_OK = 1;
    private static final int ANSWER_WRONG = 2;
    private static final int ANSWER_UNEXPECTED = 3;
    private static Charset s_Charset = Charset.forName("ISO-8859-15");
    private ArrayList<ExpectedAnswer> m_ExpectedAnswers;
    private ExpectedAnswer m_ActualAnswer;
    private int[] m_ArrayPluginValues;
    private int[] m_ArrayAllNewValues;
    private ArrayList<DMXHardwareFeedbackInterface> m_DMXHardwareFeedbackInterfaces;
    private DMXHardwarePluginFeedbackInterface m_PluggedUniverse;
    public static final int REQUESTTIMEOUT = 10000;
    private final Object m_SyncRequest = new Object();
    private final Object m_SyncAnswerMessage = new Object();
    private final Object m_RequestWait = new Object();
    private final Object m_SyncHardwareFeedbackInterface = new Object();
    private final Object m_SyncDMXPlugins = new Object();
    private static byte[] s_Bytes_CheckHardware = "C?".getBytes(s_Charset);
    private static byte[] s_Bytes_HardwareInfo = "I".getBytes(s_Charset);
    public static ArrayList<RequestTimeOut> s_RequestTimeOuts = new ArrayList();
    public static final Object s_SyncRequestTimeOuts = new Object();

    public DMX4All_StageProfiUSBDMXInterface() {
        this.initMembers();
    }

    private void initMembers() {
        this.m_ID = HardwareGUID.getUID();
        this.m_ExpectedAnswers = new ArrayList();
        this.m_PluggedUniverse = null;
        this.m_ActualAnswer = null;
        this.m_ArrayPluginValues = new int[512];
        this.m_ArrayAllNewValues = new int[512];
        this.m_DMXHardwareFeedbackInterfaces = new ArrayList();
        this.m_DebugOn = false;
        this.m_DebugFailureOn = false;
        this.m_CommBaudrate = 230400;
        this.m_ConnectionStatus = 2;
        if (s_OSFlag <= 0) {
            DMX4All_StageProfiUSBDMXInterface.checkOS();
        }
        this.m_IconInterface = new ImageIcon(this.getClass().getResource("/Image/Interface.png"));
        this.m_IconLogo = new ImageIcon(this.getClass().getResource("/Image/Logo.gif"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.m_DebugOn) {
            System.out.println(this.getClass().getSimpleName() + " close");
        }
        this.disconnect();
        CommSerialPortConnection o_CommSerialPortConnection = this.m_CommSerialPortConnection;
        if (o_CommSerialPortConnection != null) {
            o_CommSerialPortConnection.close();
        }
        Object object = this.m_SyncDMXPlugins;
        synchronized (object) {
        }
        for (int intOutput = 0; intOutput < 1; ++intOutput) {
            this.requestDMXPlugConnection(this, null);
        }
        Object object2 = this.m_SyncHardwareFeedbackInterface;
        synchronized (object2) {
            if (this.m_DMX4All_Configuration != null) {
                this.m_DMX4All_Configuration.close();
            }
            if (this.m_DMXHardwareFeedbackInterfaces != null) {
                this.m_DMXHardwareFeedbackInterfaces.clear();
            }
        }
        this.m_IconInterface = null;
        this.m_IconLogo = null;
    }

    public String getID() {
        return this.m_ID;
    }

    public void setID(String p_ID) {
        this.m_ID = p_ID == null ? HardwareGUID.getUID() : p_ID;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }

    public ImageIcon getIconInterface() {
        return this.m_IconInterface;
    }

    public ImageIcon getIconLogo() {
        return this.m_IconLogo;
    }

    public void showConfigurationDialog(Frame p_Frame) {
        if (this.m_DMX4All_Configuration == null) {
            this.m_DMX4All_Configuration = new DMX4All_StageProfiUSBDMXInterface_Configuration(p_Frame, false, this, this.m_DebugOn);
        }
        this.m_DMX4All_Configuration.setVisible(true);
        if (this.m_ConnectionStatus != 5) {
            this.m_DMX4All_Configuration.refreshCommPorts();
        }
    }

    public DMX4All_StageProfiUSBDMXInterface_Configuration getConfigurationDMX4All_StageProfiUSBDMXInterface() {
        return this.m_DMX4All_Configuration;
    }

    public void closeConfigurationDialog() {
        if (this.m_DMX4All_Configuration != null) {
            this.m_DMX4All_Configuration.setVisible(false);
        }
    }

    public static String staticInterfaceName() {
        return "<html><b>Stage-Profi MK2 USB-DMX-INTERFACE</b></html>";
    }

    public String getInterfaceName() {
        return DMX4All_StageProfiUSBDMXInterface.staticInterfaceName();
    }

    public String getInterfaceDescription() {
        return "<html>DMX USBPlugin via virtual CommPort<br>512 DMX addresses</html>";
    }

    public int getInterfaceVersionGroup() {
        return 1;
    }

    public static String staticManufacturerName() {
        return "DMX4All";
    }

    public String getManufacturerName() {
        return DMX4All_StageProfiUSBDMXInterface.staticManufacturerName();
    }

    public String getManufacturerAddress() {
        return "<html><b>DMX4All</b><br>Sophienstr. 8<br>D-44791 Bochum<br>Germany<br></html>";
    }

    public String getManufacturerHomepage() {
        return "<html>www.DMX4ALL.eu</html>";
    }

    public int getConnectionType() {
        return 1;
    }

    public void setComm_Port(String p_CommPortName) {
        this.m_CommPortName = p_CommPortName;
    }

    public String getComm_Port() {
        return this.m_CommPortName;
    }

    public void setComm_BaudRate(int p_BaudRate) {
        if (p_BaudRate != 19200 && p_BaudRate != 38400 && p_BaudRate != 230400) {
            return;
        }
        this.m_CommBaudrate = p_BaudRate;
    }

    public int getComm_BaudRate() {
        return this.m_CommBaudrate;
    }

    public int getComm_DataBits() {
        return 8;
    }

    public int getComm_StopBits() {
        return 1;
    }

    public int getComm_Parity() {
        return 0;
    }

    public int getAddressCount() {
        return 512;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDMXHardwareFeedbackInterface(DMXHardwareFeedbackInterface p_DMXHardwareFeedbackInterface) {
        if (p_DMXHardwareFeedbackInterface == null) {
            return;
        }
        Object object = this.m_SyncHardwareFeedbackInterface;
        synchronized (object) {
            if (this.m_DMXHardwareFeedbackInterfaces == null) {
                return;
            }
            if (this.m_DMXHardwareFeedbackInterfaces.contains(p_DMXHardwareFeedbackInterface)) {
                return;
            }
            this.m_DMXHardwareFeedbackInterfaces.add(p_DMXHardwareFeedbackInterface);
        }
        if (p_DMXHardwareFeedbackInterface != null) {
            p_DMXHardwareFeedbackInterface.eventHardwareConnectionStatus((DMXHardwareInterface)this, (DMXHardwarePluginInterface)this, this.m_ConnectionStatus, this.getClass().getName() + " addDMXHardwareFeedbackInterface()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDMXHardwareFeedbackInterface(DMXHardwareFeedbackInterface p_DMXHardwareFeedbackInterface) {
        if (p_DMXHardwareFeedbackInterface == null) {
            return;
        }
        boolean boolRemoved = false;
        Object object = this.m_SyncHardwareFeedbackInterface;
        synchronized (object) {
            if (this.m_DMXHardwareFeedbackInterfaces == null) {
                return;
            }
            boolRemoved = this.m_DMXHardwareFeedbackInterfaces.remove(p_DMXHardwareFeedbackInterface);
        }
    }

    public int getDMXPluginCount() {
        return 1;
    }

    public String getDMXPluginInfo(DMXHardwarePluginInterface p_DMXHardwarePluginInterface) {
        if (p_DMXHardwarePluginInterface == null) {
            return "";
        }
        return this.getDMXPluginInfo();
    }

    public int getDMXPluginType(DMXHardwarePluginInterface p_DMXHardwarePluginInterface) {
        return 0;
    }

    public boolean changeDMXPluginType(DMXHardwarePluginInterface p_DMXHardwarePluginInterface, int p_DMXPlugInType) {
        return false;
    }

    public DMXHardwarePluginFeedbackInterface getDMXPluggedInUniverse(DMXHardwarePluginInterface p_DMXHardwarePluginInterface) {
        if (p_DMXHardwarePluginInterface == null) {
            return null;
        }
        DMXHardwarePluginFeedbackInterface o_DMXUniverseFeedbackInterface = p_DMXHardwarePluginInterface.getDMXPluggedInUniverse();
        return o_DMXUniverseFeedbackInterface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requestDMXPlugConnection(DMXHardwarePluginInterface p_DMXHardwarePluginInterface, DMXHardwarePluginFeedbackInterface p_DMXUniverseFeedbackInterface) {
        if (p_DMXHardwarePluginInterface == null) {
            return false;
        }
        DMXHardwarePluginFeedbackInterface o_DMXUniverseFeedbackInterface = p_DMXHardwarePluginInterface.getDMXPluggedInUniverse();
        if (o_DMXUniverseFeedbackInterface == p_DMXUniverseFeedbackInterface) {
            return true;
        }
        if (o_DMXUniverseFeedbackInterface != null) {
            o_DMXUniverseFeedbackInterface.eventPlugin((DMXHardwareInterface)this, p_DMXHardwarePluginInterface, null);
        }
        Object object = this.m_SyncRequest;
        synchronized (object) {
            Object object2 = this.m_SyncDMXPlugins;
            synchronized (object2) {
                this.m_PluggedUniverse = p_DMXUniverseFeedbackInterface;
            }
        }
        if (p_DMXUniverseFeedbackInterface != null) {
            p_DMXUniverseFeedbackInterface.eventPlugin((DMXHardwareInterface)this, p_DMXHardwarePluginInterface, p_DMXUniverseFeedbackInterface);
        }
        this.firePlugStatus(p_DMXHardwarePluginInterface, o_DMXUniverseFeedbackInterface, p_DMXUniverseFeedbackInterface);
        return true;
    }

    public int[] getDMXPluginValues(DMXHardwarePluginInterface p_DMXHardwarePluginInterface) {
        return this.m_ArrayPluginValues;
    }

    public void setDebugOn(boolean p_DebugOn) {
        this.m_DebugOn = p_DebugOn;
    }

    public void setDebugFailureOn(boolean p_DebugOn) {
        this.m_DebugFailureOn = p_DebugOn;
    }

    public boolean connect(String p_ConnectionParam) {
        CommSerialPortConnection o_CommSerialPortConnection;
        if (this.m_CommSerialPortConnection == null) {
            this.m_CommSerialPortConnection = new CommSerialPortConnection();
            this.m_CommSerialPortConnection.addCommSerialPortEventListener(this);
        }
        if ((o_CommSerialPortConnection = this.m_CommSerialPortConnection) == null) {
            return false;
        }
        String[] arrayParams = p_ConnectionParam.split(PARAM_DIVIDER);
        if (arrayParams.length < 2) {
            return false;
        }
        this.m_CommPortName = arrayParams[0];
        this.m_CommBaudrate = Integer.valueOf(arrayParams[1]);
        if (this.m_DebugOn) {
            System.out.println("DMX44All_StageProfiUSBDMXInterface connect() Param: Port " + this.m_CommPortName + "Baud " + this.m_CommBaudrate);
        }
        return o_CommSerialPortConnection.connect(this.m_CommPortName, this.m_CommBaudrate, this.getComm_DataBits(), this.getComm_StopBits(), this.getComm_Parity());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean disconnect() {
        Object object = this.m_SyncRequest;
        synchronized (object) {
            CommSerialPortConnection o_CommSerialPortConnection = this.m_CommSerialPortConnection;
            if (o_CommSerialPortConnection == null) {
                return true;
            }
            if (this.m_DebugOn) {
                System.out.println(this.getClass().getSimpleName() + " disconnect");
            }
            o_CommSerialPortConnection.disconnect();
            Object object2 = this.m_SyncAnswerMessage;
            synchronized (object2) {
                this.m_ExpectedAnswers.clear();
                this.m_ActualAnswer = null;
            }
        }
        this.setConnectionStatus(2, this.getClass().getName() + " eventCommSerialPortConnection()");
        return true;
    }

    public boolean getIsConnected() {
        return this.m_ConnectionStatus == 5;
    }

    public int getConnectionStatus() {
        return this.m_ConnectionStatus;
    }

    public int getConnectionStatus(DMXHardwarePluginInterface p_DMXHardwarePluginInterface) {
        return this.m_ConnectionStatus;
    }

    private void setConnectionStatus(int p_ConnectionStatus, String p_Remark) {
        this.m_ConnectionStatus = p_ConnectionStatus;
        for (int intValue = 0; intValue < this.m_ArrayPluginValues.length; ++intValue) {
            this.m_ArrayPluginValues[intValue] = 0;
        }
        this.fireConnectionStatus(p_ConnectionStatus, p_Remark);
        if (this.m_ConnectionStatus == 5) {
            // empty if block
        }
    }

    public String getConnectionParameters() {
        String stringParams = this.m_CommPortName + PARAM_DIVIDER + String.valueOf(this.m_CommBaudrate);
        return stringParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requestCheckHardware() {
        long longTimeUsed;
        ExpectedAnswer o_ExpectedAnswer;
        CommSerialPortConnection.ByteArray_Write o_SendBytes;
        CommSerialPortConnection o_CommSerialPortConnection;
        RequestTimeOut o_RequestTimeOut;
        boolean boolError = false;
        Object object = this.m_SyncRequest;
        synchronized (object) {
            o_RequestTimeOut = DMX4All_StageProfiUSBDMXInterface.getPool_RequestTimeOut();
            o_CommSerialPortConnection = this.m_CommSerialPortConnection;
            if (o_CommSerialPortConnection == null) {
                return false;
            }
            if (this.m_DebugOn) {
                System.out.println("DMX4All_StageProfiUSBDMXInterface requestCheckHardware");
            }
            if ((o_SendBytes = this.getByteCode_CheckHardware()) == null) {
                return false;
            }
        }
        object = this.m_SyncAnswerMessage;
        synchronized (object) {
            o_ExpectedAnswer = new ExpectedAnswer(20, 1, 71, 1);
            this.m_ExpectedAnswers.add(o_ExpectedAnswer);
        }
        try {
            object = this.m_RequestWait;
            synchronized (object) {
                o_CommSerialPortConnection.write(o_SendBytes);
                o_RequestTimeOut.start();
                while (o_ExpectedAnswer.getAnswerStatus() == 0) {
                    long longWaitStart;
                    for (long longWaitTime = 10000L; longWaitTime > 0L && o_ExpectedAnswer.getAnswerStatus() == 0; longWaitTime -= System.nanoTime() / 1000000L - longWaitStart) {
                        longWaitStart = System.nanoTime() / 1000000L;
                        this.m_RequestWait.wait(longWaitTime);
                    }
                    if (!o_RequestTimeOut.isTimedOut(10000L)) continue;
                }
                longTimeUsed = o_RequestTimeOut.stop();
                o_RequestTimeOut.close();
            }
        }
        catch (InterruptedException e_InterruptedException) {
            if (this.m_DebugOn) {
                System.out.println("DMX4All_StageProfiUSBDMXInterface requestCheckHardware InterruptedException");
            }
            return false;
        }
        if (longTimeUsed >= 10000L) {
            if (this.m_DebugOn || this.m_DebugFailureOn) {
                System.out.println("DMX4All_StageProfiUSBDMXInterface requestCheckHardware TimedOut");
            }
            boolError = true;
        }
        if (boolError) {
            object = this.m_SyncAnswerMessage;
            synchronized (object) {
                this.m_ExpectedAnswers.remove(o_ExpectedAnswer);
            }
            this.fireCheckConnectionFailed(910, "Request Check Connection TimeOut");
            return false;
        }
        return this.parseAnswer_CheckHardware(o_ExpectedAnswer);
    }

    private CommSerialPortConnection.ByteArray_Write getByteCode_CheckHardware() {
        CommSerialPortConnection.ByteArray_Write o_ByteArray_Write = CommSerialPortConnection.getByteArrayWrite(2);
        byte[] o_ByteCode = o_ByteArray_Write.getByteArray();
        try {
            System.arraycopy(s_Bytes_CheckHardware, 0, o_ByteCode, 0, 2);
            o_ByteCode = "C?".getBytes(s_Charset);
        }
        catch (Exception e) {
            return null;
        }
        return o_ByteArray_Write;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean parseAnswer_CheckHardware(ExpectedAnswer p_ExpectedAnswer) {
        Object object = this.m_SyncAnswerMessage;
        synchronized (object) {
        }
        if (p_ExpectedAnswer != null && p_ExpectedAnswer.getAnswerStatus() == 1) {
            this.fireCheckConnectionSuccess();
            return true;
        }
        this.fireCheckConnectionFailed(951, "<html>Wrong Hardware Answer<br> (request Check Hardware) -> <br></html>");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireCheckConnectionFailed(int p_ExceptionType, String p_Remark) {
        ArrayList<DMXHardwareFeedbackInterface> o_DMXHardwareFeedbackInterfaces;
        if (this.m_DebugOn || this.m_DebugFailureOn) {
            System.out.println(this.getClass().getSimpleName() + " fireCheckConnectionFailed -> disconnect");
        }
        Object object = this.m_SyncHardwareFeedbackInterface;
        synchronized (object) {
            if (this.m_DMXHardwareFeedbackInterfaces == null) {
                return;
            }
            if (this.m_DMXHardwareFeedbackInterfaces.size() <= 0) {
                return;
            }
            o_DMXHardwareFeedbackInterfaces = new ArrayList<DMXHardwareFeedbackInterface>(this.m_DMXHardwareFeedbackInterfaces.size());
            o_DMXHardwareFeedbackInterfaces.addAll(this.m_DMXHardwareFeedbackInterfaces);
        }
        for (int intInterface = 0; intInterface < o_DMXHardwareFeedbackInterfaces.size(); ++intInterface) {
            DMXHardwareFeedbackInterface o_DMXHardwareFeedbackInterface = (DMXHardwareFeedbackInterface)o_DMXHardwareFeedbackInterfaces.get(intInterface);
            o_DMXHardwareFeedbackInterface.eventHardwareCheck((DMXHardwareInterface)this, false, p_Remark);
            o_DMXHardwareFeedbackInterface.eventHardwareException((DMXHardwareInterface)this, 910, p_Remark);
        }
        o_DMXHardwareFeedbackInterfaces.clear();
        this.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireCheckConnectionSuccess() {
        ArrayList<DMXHardwareFeedbackInterface> o_DMXHardwareFeedbackInterfaces;
        if (this.m_DebugOn) {
            System.out.println(this.getClass().getSimpleName() + " fireCheckConnectionSuccess");
        }
        this.setConnectionStatus(5, this.getClass().getName() + " fireCheckConnectionSuccess()");
        Object object = this.m_SyncHardwareFeedbackInterface;
        synchronized (object) {
            if (this.m_DMXHardwareFeedbackInterfaces == null) {
                return;
            }
            if (this.m_DMXHardwareFeedbackInterfaces.size() <= 0) {
                return;
            }
            o_DMXHardwareFeedbackInterfaces = new ArrayList<DMXHardwareFeedbackInterface>(this.m_DMXHardwareFeedbackInterfaces.size());
            o_DMXHardwareFeedbackInterfaces.addAll(this.m_DMXHardwareFeedbackInterfaces);
        }
        for (int intInterface = 0; intInterface < o_DMXHardwareFeedbackInterfaces.size(); ++intInterface) {
            DMXHardwareFeedbackInterface o_DMXHardwareFeedbackInterface = (DMXHardwareFeedbackInterface)o_DMXHardwareFeedbackInterfaces.get(intInterface);
            o_DMXHardwareFeedbackInterface.eventHardwareCheck((DMXHardwareInterface)this, true, "");
        }
        o_DMXHardwareFeedbackInterfaces.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requestHardwareInfo() {
        long longTimeUsed;
        ExpectedAnswer o_ExpectedAnswer;
        byte[] lastChars;
        CommSerialPortConnection.ByteArray_Write o_SendBytes;
        CommSerialPortConnection o_CommSerialPortConnection;
        boolean boolError = false;
        RequestTimeOut o_RequestTimeOut = DMX4All_StageProfiUSBDMXInterface.getPool_RequestTimeOut();
        Object object = this.m_SyncRequest;
        synchronized (object) {
            o_CommSerialPortConnection = this.m_CommSerialPortConnection;
            if (o_CommSerialPortConnection == null) {
                return false;
            }
            if (this.m_DebugOn) {
                System.out.println("DMX4All_StageProfiUSBDMXInterface requestHardwareInfo");
            }
            if ((o_SendBytes = this.getByteCode_HardwareInfo()) == null) {
                return false;
            }
            lastChars = "\n".getBytes(s_Charset);
        }
        object = this.m_SyncAnswerMessage;
        synchronized (object) {
            o_ExpectedAnswer = new ExpectedAnswer(10, -1, lastChars[0], 7);
            this.m_ExpectedAnswers.add(o_ExpectedAnswer);
        }
        try {
            object = this.m_RequestWait;
            synchronized (object) {
                o_CommSerialPortConnection.write(o_SendBytes);
                o_RequestTimeOut.start();
                while (o_ExpectedAnswer.getAnswerStatus() == 0) {
                    long longWaitStart;
                    for (long longWaitTime = 10000L; longWaitTime > 0L && o_ExpectedAnswer.getAnswerStatus() == 0; longWaitTime -= System.nanoTime() / 1000000L - longWaitStart) {
                        longWaitStart = System.nanoTime() / 1000000L;
                        this.m_RequestWait.wait(longWaitTime);
                    }
                    if (!o_RequestTimeOut.isTimedOut(10000L)) continue;
                }
                longTimeUsed = o_RequestTimeOut.stop();
                o_RequestTimeOut.close();
            }
        }
        catch (InterruptedException e) {
            return false;
        }
        if (longTimeUsed >= 10000L) {
            boolError = true;
        }
        if (boolError) {
            object = this.m_SyncAnswerMessage;
            synchronized (object) {
                this.m_ExpectedAnswers.remove(o_ExpectedAnswer);
            }
            this.fireHardwareInfoFailed(952, "HardwareInfo request timeout");
            return false;
        }
        return this.parseAnswer_HardwareInfo(o_ExpectedAnswer);
    }

    private CommSerialPortConnection.ByteArray_Write getByteCode_HardwareInfo() {
        CommSerialPortConnection.ByteArray_Write o_ByteArray_Write = CommSerialPortConnection.getByteArrayWrite(1);
        byte[] o_ByteCode = o_ByteArray_Write.getByteArray();
        try {
            System.arraycopy(s_Bytes_HardwareInfo, 0, o_ByteCode, 0, 1);
        }
        catch (Exception e) {
            return null;
        }
        return o_ByteArray_Write;
    }

    private boolean parseAnswer_HardwareInfo(ExpectedAnswer p_ExpectedAnswer) {
        if (p_ExpectedAnswer != null && p_ExpectedAnswer.getAnswerStatus() == 1) {
            String stringHardwareInfo = p_ExpectedAnswer.getAnswerStringHTML();
            if (!stringHardwareInfo.toLowerCase().contains("stage")) {
                this.fireHardwareInfoFailed(951, "<html>Wrong Hardware Answer<br> (request HardwareInfo) -> <br></html>");
                return false;
            }
            this.fireHardwareInfoSuccess(p_ExpectedAnswer.getAnswerStringHTML());
            return true;
        }
        this.fireHardwareInfoFailed(951, "<html>Wrong Hardware Answer<br> (request HardwareInfo) -> <br></html>");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireHardwareInfoFailed(int p_ExceptionType, String p_Remark) {
        ArrayList<DMXHardwareFeedbackInterface> o_DMXHardwareFeedbackInterfaces;
        if (this.m_DebugOn || this.m_DebugFailureOn) {
            System.out.println(this.getClass().getSimpleName() + " fireHardwareInfoFailed -> disconnect");
        }
        Object object = this.m_SyncHardwareFeedbackInterface;
        synchronized (object) {
            if (this.m_DMXHardwareFeedbackInterfaces == null) {
                return;
            }
            if (this.m_DMXHardwareFeedbackInterfaces.size() <= 0) {
                return;
            }
            o_DMXHardwareFeedbackInterfaces = new ArrayList<DMXHardwareFeedbackInterface>(this.m_DMXHardwareFeedbackInterfaces.size());
            o_DMXHardwareFeedbackInterfaces.addAll(this.m_DMXHardwareFeedbackInterfaces);
        }
        for (int intInterface = 0; intInterface < o_DMXHardwareFeedbackInterfaces.size(); ++intInterface) {
            DMXHardwareFeedbackInterface o_DMXHardwareFeedbackInterface = (DMXHardwareFeedbackInterface)o_DMXHardwareFeedbackInterfaces.get(intInterface);
            o_DMXHardwareFeedbackInterface.eventHardwareException((DMXHardwareInterface)this, p_ExceptionType, p_Remark);
        }
        o_DMXHardwareFeedbackInterfaces.clear();
        this.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireHardwareInfoSuccess(String p_Info) {
        ArrayList<DMXHardwareFeedbackInterface> o_DMXHardwareFeedbackInterfaces;
        Object object = this.m_SyncHardwareFeedbackInterface;
        synchronized (object) {
            if (this.m_DMXHardwareFeedbackInterfaces == null) {
                return;
            }
            if (this.m_DMXHardwareFeedbackInterfaces.size() <= 0) {
                return;
            }
            o_DMXHardwareFeedbackInterfaces = new ArrayList<DMXHardwareFeedbackInterface>(this.m_DMXHardwareFeedbackInterfaces.size());
            o_DMXHardwareFeedbackInterfaces.addAll(this.m_DMXHardwareFeedbackInterfaces);
        }
        for (int intInterface = 0; intInterface < o_DMXHardwareFeedbackInterfaces.size(); ++intInterface) {
            DMXHardwareFeedbackInterface o_DMXHardwareFeedbackInterface = (DMXHardwareFeedbackInterface)o_DMXHardwareFeedbackInterfaces.get(intInterface);
            o_DMXHardwareFeedbackInterface.eventHardwareInfo((DMXHardwareInterface)this, p_Info);
        }
        o_DMXHardwareFeedbackInterfaces.clear();
    }

    public boolean requestWriteValues(DMXHardwarePluginInterface p_DMXHardwarePluginInterface, ArrayList<Integer> p_ChangedAddresses, int[] p_AllValues) {
        int intEndAddress;
        int intStartAddress;
        if (p_AllValues == null) {
            return false;
        }
        if (p_DMXHardwarePluginInterface == null) {
            return false;
        }
        int intChangedAddressCount = p_ChangedAddresses.size();
        if (intChangedAddressCount <= 0) {
            return true;
        }
        if (this.m_CommSerialPortConnection == null) {
            return false;
        }
        if (this.m_ArrayAllNewValues == null) {
            this.m_ArrayAllNewValues = new int[p_AllValues.length];
        }
        System.arraycopy(p_AllValues, 0, this.m_ArrayAllNewValues, 0, p_AllValues.length);
        if (this.getDMXPluggedInUniverse(p_DMXHardwarePluginInterface) == null) {
            return false;
        }
        if (intChangedAddressCount < 0) {
            if (this.m_DebugOn) {
                System.out.println("DMX4All_StageProfiUSBDMXInterface requestWriteValues single value changed");
            }
            return this.requestWriteValueSingle(p_DMXHardwarePluginInterface, p_ChangedAddresses.get(0), this.m_ArrayAllNewValues);
        }
        if (this.m_DebugOn) {
            System.out.println("DMX4All_StageProfiUSBDMXInterface requestWriteValues multiple values changed");
        }
        int intCommandCount = 0;
        int intHighestAddress = p_ChangedAddresses.get(p_ChangedAddresses.size() - 1);
        int intLowestAddress = p_ChangedAddresses.get(0);
        if (intLowestAddress < 0) {
            intLowestAddress = 0;
        }
        if (intLowestAddress > 511) {
            intLowestAddress = 511;
        }
        if (intHighestAddress < 0) {
            intHighestAddress = 0;
        }
        if (intHighestAddress > 511) {
            intHighestAddress = 511;
        }
        if (intHighestAddress < intLowestAddress) {
            int intTemp = intLowestAddress;
            intHighestAddress = intLowestAddress = intHighestAddress;
        }
        if ((intChangedAddressCount = intHighestAddress - intLowestAddress + 1) > 502) {
            intCommandCount = 3;
            intStartAddress = intLowestAddress;
            intEndAddress = intLowestAddress + 251;
        } else if (intChangedAddressCount > 251) {
            intCommandCount = 2;
            intStartAddress = intLowestAddress;
            intEndAddress = intLowestAddress + 251;
        } else {
            intCommandCount = 1;
            intStartAddress = intLowestAddress;
            intEndAddress = intHighestAddress;
        }
        for (int intTelegram = 0; intTelegram < intCommandCount; ++intTelegram) {
            if (intEndAddress > intHighestAddress) {
                intEndAddress = intHighestAddress;
            }
            if (!this.requestWriteValuesMultiple(p_DMXHardwarePluginInterface, intStartAddress, intEndAddress, this.m_ArrayAllNewValues)) {
                return false;
            }
            intStartAddress = intEndAddress + 1;
            intEndAddress = intStartAddress + 251;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requestWriteValueSingle(DMXHardwarePluginInterface p_DMXHardwarePluginInterface, int p_ChangedAddress, int[] p_AllValues) {
        long longTimeUsed;
        ExpectedAnswer o_ExpectedAnswer;
        CommSerialPortConnection.ByteArray_Write o_SendBytes;
        CommSerialPortConnection o_CommSerialPortConnection;
        if (p_DMXHardwarePluginInterface == null) {
            return false;
        }
        boolean boolError = false;
        RequestTimeOut o_RequestTimeOut = DMX4All_StageProfiUSBDMXInterface.getPool_RequestTimeOut();
        Object object = this.m_SyncRequest;
        synchronized (object) {
            o_CommSerialPortConnection = this.m_CommSerialPortConnection;
            if (o_CommSerialPortConnection == null) {
                return false;
            }
            if (this.getDMXPluggedInUniverse(p_DMXHardwarePluginInterface) == null) {
                return false;
            }
            o_SendBytes = this.getByteCode_WriteValueSingle(p_ChangedAddress, p_AllValues);
            if (o_SendBytes == null) {
                return false;
            }
        }
        object = this.m_SyncAnswerMessage;
        synchronized (object) {
            o_ExpectedAnswer = new ExpectedAnswer(2, 1, 71, 1);
            this.m_ExpectedAnswers.add(o_ExpectedAnswer);
        }
        try {
            object = this.m_RequestWait;
            synchronized (object) {
                o_CommSerialPortConnection.write(o_SendBytes);
                o_RequestTimeOut.start();
                while (o_ExpectedAnswer.getAnswerStatus() == 0) {
                    long longWaitStart;
                    for (long longWaitTime = 10000L; longWaitTime > 0L && o_ExpectedAnswer.getAnswerStatus() == 0; longWaitTime -= System.nanoTime() / 1000000L - longWaitStart) {
                        longWaitStart = System.nanoTime() / 1000000L;
                        this.m_RequestWait.wait(longWaitTime);
                    }
                    if (!o_RequestTimeOut.isTimedOut(10000L)) continue;
                }
                longTimeUsed = o_RequestTimeOut.stop();
                o_RequestTimeOut.close();
            }
        }
        catch (InterruptedException e) {
            return false;
        }
        if (longTimeUsed >= 10000L) {
            boolError = true;
        }
        if (boolError) {
            object = this.m_SyncAnswerMessage;
            synchronized (object) {
                this.m_ExpectedAnswers.remove(o_ExpectedAnswer);
            }
            this.fireWriteValuesFailed(this, 952, "Write Values timeout");
            return false;
        }
        return this.parseAnswer_WriteValueSingle(o_ExpectedAnswer, p_DMXHardwarePluginInterface, p_ChangedAddress, p_AllValues);
    }

    private CommSerialPortConnection.ByteArray_Write getByteCode_WriteValueSingle(int p_Address, int[] p_AllValuesWrite) {
        if (p_Address < 0) {
            return null;
        }
        if (p_Address > 511) {
            return null;
        }
        CommSerialPortConnection.ByteArray_Write o_ByteArray_Write = CommSerialPortConnection.getByteArrayWrite(5);
        byte[] o_ByteCode = o_ByteArray_Write.getByteArray();
        String stringAddress = "000" + String.valueOf(p_Address);
        stringAddress = stringAddress.substring(stringAddress.length() - 3, stringAddress.length());
        String stringValue = "000" + String.valueOf(p_AllValuesWrite[p_Address]);
        stringValue = stringValue.substring(stringValue.length() - 3, stringValue.length());
        String stringWrite = "C" + stringAddress + "L" + stringValue;
        try {
            System.arraycopy(stringWrite.getBytes(s_Charset), 0, o_ByteCode, 0, 5);
        }
        catch (Exception e) {
            return null;
        }
        return o_ByteArray_Write;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean parseAnswer_WriteValueSingle(ExpectedAnswer p_ExpectedAnswer, DMXHardwarePluginInterface p_DMXHardwarePluginInterface, int p_Address, int[] p_AllValues) {
        ExpectedAnswer o_ExpectedAnswer;
        Object object = this.m_SyncAnswerMessage;
        synchronized (object) {
            o_ExpectedAnswer = p_ExpectedAnswer;
        }
        if (o_ExpectedAnswer != null && o_ExpectedAnswer.getAnswerStatus() == 1) {
            this.m_ArrayPluginValues[p_Address] = p_AllValues[p_Address];
            this.fireWriteValuesSuccess(p_DMXHardwarePluginInterface, this.m_ArrayPluginValues);
            return true;
        }
        this.fireWriteValuesFailed(p_DMXHardwarePluginInterface, 951, "<html>Wrong Hardware Answer<br> (request WriteValues) -> <br></html>");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requestWriteValuesMultiple(DMXHardwarePluginInterface p_DMXHardwarePluginInterface, int p_StartAddress, int p_EndAddress, int[] p_AllValues) {
        long longTimeUsed;
        ExpectedAnswer o_ExpectedAnswer;
        CommSerialPortConnection.ByteArray_Write o_SendBytes;
        CommSerialPortConnection o_CommSerialPortConnection;
        if (p_DMXHardwarePluginInterface == null) {
            return false;
        }
        if (p_EndAddress - p_StartAddress > 255) {
            return false;
        }
        boolean boolError = false;
        RequestTimeOut o_RequestTimeOut = DMX4All_StageProfiUSBDMXInterface.getPool_RequestTimeOut();
        Object object = this.m_SyncRequest;
        synchronized (object) {
            o_CommSerialPortConnection = this.m_CommSerialPortConnection;
            if (o_CommSerialPortConnection == null) {
                return false;
            }
            if (this.getDMXPluggedInUniverse(p_DMXHardwarePluginInterface) == null) {
                return false;
            }
            o_SendBytes = this.getByteCode_WriteValuesMultiple(p_StartAddress, p_EndAddress, p_AllValues);
            if (o_SendBytes == null) {
                return false;
            }
        }
        object = this.m_SyncAnswerMessage;
        synchronized (object) {
            o_ExpectedAnswer = new ExpectedAnswer(6, 1, 71, 1);
            this.m_ExpectedAnswers.add(o_ExpectedAnswer);
        }
        try {
            object = this.m_RequestWait;
            synchronized (object) {
                o_CommSerialPortConnection.write(o_SendBytes);
                o_RequestTimeOut.start();
                while (o_ExpectedAnswer.getAnswerStatus() == 0) {
                    long longWaitStart;
                    for (long longWaitTime = 10000L; longWaitTime > 0L && o_ExpectedAnswer.getAnswerStatus() == 0; longWaitTime -= System.nanoTime() / 1000000L - longWaitStart) {
                        longWaitStart = System.nanoTime() / 1000000L;
                        this.m_RequestWait.wait(longWaitTime);
                    }
                    if (!o_RequestTimeOut.isTimedOut(10000L)) continue;
                }
                longTimeUsed = o_RequestTimeOut.stop();
                o_RequestTimeOut.close();
            }
        }
        catch (InterruptedException e) {
            return false;
        }
        if (longTimeUsed >= 10000L) {
            boolError = true;
        }
        if (longTimeUsed < 6L) {
            try {
                Thread.sleep(6L - longTimeUsed);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (boolError) {
            object = this.m_SyncAnswerMessage;
            synchronized (object) {
                this.m_ExpectedAnswers.remove(o_ExpectedAnswer);
            }
            this.fireWriteValuesFailed(this, 952, "Write Values multiple timeout");
            return false;
        }
        return this.parseAnswer_WriteValuesMultiple(o_ExpectedAnswer, p_DMXHardwarePluginInterface, p_StartAddress, p_EndAddress, p_AllValues);
    }

    private CommSerialPortConnection.ByteArray_Write getByteCode_WriteValuesMultiple(int p_StartAddresses, int p_EndAddresses, int[] p_AllValuesWrite) {
        int intAddressCount = p_EndAddresses - p_StartAddresses + 1;
        CommSerialPortConnection.ByteArray_Write o_ByteArray_Write = CommSerialPortConnection.getByteArrayWrite(4 + intAddressCount);
        byte[] o_ByteCode = o_ByteArray_Write.getByteArray();
        o_ByteCode[0] = -1;
        o_ByteCode[1] = (byte)(p_StartAddresses & 0xFF);
        o_ByteCode[2] = (byte)(p_StartAddresses >> 8 & 0xFF);
        o_ByteCode[3] = (byte)(intAddressCount & 0xFF);
        for (int intAddress = 0; intAddress < intAddressCount; ++intAddress) {
            int intValue = p_AllValuesWrite[p_StartAddresses + intAddress];
            if (intValue < 0) {
                intValue = 0;
            }
            if (intValue > 255) {
                intValue = 255;
            }
            o_ByteCode[4 + intAddress] = (byte)(intValue & 0xFF);
        }
        return o_ByteArray_Write;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean parseAnswer_WriteValuesMultiple(ExpectedAnswer p_ExpectedAnswer, DMXHardwarePluginInterface p_DMXHardwarePluginInterface, int p_StartAddress, int p_EndAddress, int[] p_AllValues) {
        ExpectedAnswer o_ExpectedAnswer;
        Object object = this.m_SyncAnswerMessage;
        synchronized (object) {
            o_ExpectedAnswer = p_ExpectedAnswer;
        }
        if (o_ExpectedAnswer != null && o_ExpectedAnswer.getAnswerStatus() == 1) {
            int intAddressCount = p_EndAddress - p_StartAddress + 1;
            System.arraycopy(p_AllValues, p_StartAddress, this.m_ArrayPluginValues, p_StartAddress, intAddressCount);
            this.fireWriteValuesSuccess(p_DMXHardwarePluginInterface, this.m_ArrayPluginValues);
            return true;
        }
        this.fireWriteValuesFailed(p_DMXHardwarePluginInterface, 951, "<html>Wrong Hardware Answer<br> (request WriteValues) -> <br></html>");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireWriteValuesFailed(DMXHardwarePluginInterface p_DMXHardwarePluginInterface, int p_ExceptionType, String p_Remark) {
        DMXHardwarePluginFeedbackInterface o_DMXUniverseFeedbackInterface;
        if (p_DMXHardwarePluginInterface == null) {
            return;
        }
        if (this.m_DebugOn || this.m_DebugFailureOn) {
            System.out.println(this.getClass().getSimpleName() + " DMXOutput: " + p_DMXHardwarePluginInterface.getDMXPluginInfo() + " fireWriteValuesFailed");
        }
        Object object = this.m_SyncDMXPlugins;
        synchronized (object) {
            o_DMXUniverseFeedbackInterface = p_DMXHardwarePluginInterface.getDMXPluggedInUniverse();
        }
        if (o_DMXUniverseFeedbackInterface == null) {
            return;
        }
        o_DMXUniverseFeedbackInterface.eventPluginException((DMXHardwareInterface)this, p_DMXHardwarePluginInterface, p_ExceptionType, p_Remark);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireWriteValuesSuccess(DMXHardwarePluginInterface p_DMXHardwarePluginInterface, int[] p_AllInterfaceValues) {
        DMXHardwarePluginFeedbackInterface o_DMXUniverseFeedbackInterface;
        if (p_DMXHardwarePluginInterface == null) {
            return;
        }
        Object object = this.m_SyncDMXPlugins;
        synchronized (object) {
            o_DMXUniverseFeedbackInterface = p_DMXHardwarePluginInterface.getDMXPluggedInUniverse();
        }
        if (o_DMXUniverseFeedbackInterface == null) {
            return;
        }
        o_DMXUniverseFeedbackInterface.eventPluginWriteValues((DMXHardwareInterface)this, p_DMXHardwarePluginInterface, p_AllInterfaceValues);
        if (this.m_DebugOn) {
            System.out.println(this.getClass().getSimpleName() + " DMXOutput: " + p_DMXHardwarePluginInterface.getDMXPluginInfo() + " fireWriteValuesSuccess");
        }
    }

    public boolean requestReadValues(DMXHardwarePluginInterface p_DMXHardwarePluginInterface, ArrayList<Integer> p_ChangedAddresses) {
        int intEndAddress;
        int intStartAddress;
        if (p_DMXHardwarePluginInterface == null) {
            return false;
        }
        int intAddressCount = p_ChangedAddresses.size();
        if (intAddressCount <= 0) {
            return true;
        }
        if (this.m_CommSerialPortConnection == null) {
            return false;
        }
        if (this.getDMXPluggedInUniverse(p_DMXHardwarePluginInterface) == null) {
            return false;
        }
        if (intAddressCount == 1) {
            if (this.m_DebugOn) {
                System.out.println("DMX4All_StageProfiUSBDMXInterface requestReadValues single value");
            }
            return this.requestReadValueSingle(p_DMXHardwarePluginInterface, p_ChangedAddresses.get(0));
        }
        if (this.m_DebugOn) {
            System.out.println("DMX4All_StageProfiUSBDMXInterface requestReadValues multiple values");
        }
        int intCommandCount = 0;
        int intHighestAddress = p_ChangedAddresses.get(p_ChangedAddresses.size() - 1);
        int intLowestAddress = p_ChangedAddresses.get(0);
        if (intLowestAddress < 0) {
            intLowestAddress = 0;
        }
        if (intLowestAddress > 511) {
            intLowestAddress = 511;
        }
        if (intHighestAddress < 0) {
            intHighestAddress = 0;
        }
        if (intHighestAddress > 511) {
            intHighestAddress = 511;
        }
        if (intHighestAddress < intLowestAddress) {
            int intTemp = intLowestAddress;
            intHighestAddress = intLowestAddress = intHighestAddress;
        }
        if ((intAddressCount = intHighestAddress - intLowestAddress + 1) > 508) {
            intCommandCount = 3;
            intStartAddress = intLowestAddress;
            intEndAddress = intLowestAddress + 254 - 4;
        } else if (intAddressCount > 252) {
            intCommandCount = 2;
            intStartAddress = intLowestAddress;
            intEndAddress = intLowestAddress + 254 - 4;
        } else {
            intCommandCount = 1;
            intStartAddress = intLowestAddress;
            intEndAddress = intHighestAddress;
        }
        for (int intTelegram = 0; intTelegram < intCommandCount; ++intTelegram) {
            if (intEndAddress > intHighestAddress) {
                intEndAddress = intHighestAddress;
            }
            if (!this.requestReadValuesMultiple(p_DMXHardwarePluginInterface, intStartAddress, intEndAddress)) {
                return false;
            }
            intStartAddress = intEndAddress + 1;
            intEndAddress = intStartAddress + 254 - 4;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requestReadValueSingle(DMXHardwarePluginInterface p_DMXHardwarePluginInterface, int p_Address) {
        long longTimeUsed;
        ExpectedAnswer o_ExpectedAnswer;
        CommSerialPortConnection.ByteArray_Write o_SendBytes;
        CommSerialPortConnection o_CommSerialPortConnection;
        if (p_DMXHardwarePluginInterface == null) {
            return false;
        }
        boolean boolError = false;
        RequestTimeOut o_RequestTimeOut = DMX4All_StageProfiUSBDMXInterface.getPool_RequestTimeOut();
        Object object = this.m_SyncRequest;
        synchronized (object) {
            o_CommSerialPortConnection = this.m_CommSerialPortConnection;
            if (o_CommSerialPortConnection == null) {
                return false;
            }
            if (this.getDMXPluggedInUniverse(p_DMXHardwarePluginInterface) == null) {
                return false;
            }
            if (this.getDMXPluggedInUniverse(p_DMXHardwarePluginInterface) == null) {
                return false;
            }
            o_SendBytes = this.getByteCode_ReadValueSingle(p_Address);
            if (o_SendBytes == null) {
                return false;
            }
        }
        object = this.m_SyncAnswerMessage;
        synchronized (object) {
            o_ExpectedAnswer = new ExpectedAnswer(1, 4, 71, 1);
            this.m_ExpectedAnswers.add(o_ExpectedAnswer);
        }
        try {
            object = this.m_RequestWait;
            synchronized (object) {
                o_CommSerialPortConnection.write(o_SendBytes);
                o_RequestTimeOut.start();
                while (o_ExpectedAnswer.getAnswerStatus() == 0) {
                    long longWaitStart;
                    for (long longWaitTime = 10000L; longWaitTime > 0L && o_ExpectedAnswer.getAnswerStatus() == 0; longWaitTime -= System.nanoTime() / 1000000L - longWaitStart) {
                        longWaitStart = System.nanoTime() / 1000000L;
                        this.m_RequestWait.wait(longWaitTime);
                    }
                    if (!o_RequestTimeOut.isTimedOut(10000L)) continue;
                }
                longTimeUsed = o_RequestTimeOut.stop();
                o_RequestTimeOut.close();
            }
        }
        catch (InterruptedException e) {
            return false;
        }
        if (longTimeUsed >= 10000L) {
            boolError = true;
        }
        if (boolError) {
            object = this.m_SyncAnswerMessage;
            synchronized (object) {
                this.m_ExpectedAnswers.remove(o_ExpectedAnswer);
            }
            this.fireWriteValuesFailed(this, 952, "Write Values timeout");
            return false;
        }
        return this.parseAnswer_ReadSingle(o_ExpectedAnswer, p_DMXHardwarePluginInterface, p_Address);
    }

    private CommSerialPortConnection.ByteArray_Write getByteCode_ReadValueSingle(int p_Address) {
        CommSerialPortConnection.ByteArray_Write o_ByteArray_Write = CommSerialPortConnection.getByteArrayWrite(5);
        byte[] o_ByteCode = o_ByteArray_Write.getByteArray();
        String stringAddress = "000" + String.valueOf(p_Address);
        stringAddress = stringAddress.substring(stringAddress.length() - 3, stringAddress.length());
        String stringWrite = "C" + stringAddress + "?";
        try {
            System.arraycopy(stringWrite.getBytes(s_Charset), 0, o_ByteCode, 0, 5);
        }
        catch (Exception e) {
            return null;
        }
        return o_ByteArray_Write;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean parseAnswer_ReadSingle(ExpectedAnswer p_ExpectedAnswer, DMXHardwarePluginInterface p_DMXHardwarePluginInterface, int p_Address) {
        ExpectedAnswer o_ExpectedAnswer;
        Object object = this.m_SyncAnswerMessage;
        synchronized (object) {
            o_ExpectedAnswer = p_ExpectedAnswer;
        }
        if (o_ExpectedAnswer != null) {
            String stringAnswer = o_ExpectedAnswer.getAnswerString();
            try {
                this.m_ArrayPluginValues[p_Address] = Integer.valueOf(stringAnswer.substring(0, 3));
            }
            catch (Exception e) {
                this.fireReadValuesFailed(p_DMXHardwarePluginInterface, 951, "<html>Wrong Value in parseAnswer_ReadSingle<br> (requestReadValueSingle)<br></html>");
                return false;
            }
            this.fireReadValuesSucces(this, this.m_ArrayPluginValues);
            return true;
        }
        this.fireReadValuesFailed(p_DMXHardwarePluginInterface, 951, "<html>Wrong Hardware Answer<br> (request ReadValues)<br></html>");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requestReadValuesMultiple(DMXHardwarePluginInterface p_DMXHardwarePluginInterface, int p_StartAddress, int p_EndAddress) {
        long longTimeUsed;
        ExpectedAnswer o_ExpectedAnswer;
        CommSerialPortConnection.ByteArray_Write o_SendBytes;
        CommSerialPortConnection o_CommSerialPortConnection;
        if (p_DMXHardwarePluginInterface == null) {
            return false;
        }
        int intAddressesCount = p_EndAddress - p_StartAddress + 1;
        if (intAddressesCount > 252) {
            return false;
        }
        boolean boolError = false;
        RequestTimeOut o_RequestTimeOut = DMX4All_StageProfiUSBDMXInterface.getPool_RequestTimeOut();
        Object object = this.m_SyncRequest;
        synchronized (object) {
            o_CommSerialPortConnection = this.m_CommSerialPortConnection;
            if (o_CommSerialPortConnection == null) {
                return false;
            }
            o_SendBytes = this.getByteCode_ReadValuesMultiple(p_StartAddress, p_EndAddress);
            if (o_SendBytes == null) {
                return false;
            }
        }
        object = this.m_SyncAnswerMessage;
        synchronized (object) {
            o_ExpectedAnswer = new ExpectedAnswer(3, intAddressesCount + 1, 71, 1);
            this.m_ExpectedAnswers.add(o_ExpectedAnswer);
        }
        try {
            object = this.m_RequestWait;
            synchronized (object) {
                o_CommSerialPortConnection.write(o_SendBytes);
                o_RequestTimeOut.start();
                while (o_ExpectedAnswer.getAnswerStatus() == 0) {
                    long longWaitStart;
                    for (long longWaitTime = 10000L; longWaitTime > 0L && o_ExpectedAnswer.getAnswerStatus() == 0; longWaitTime -= System.nanoTime() / 1000000L - longWaitStart) {
                        longWaitStart = System.nanoTime() / 1000000L;
                        this.m_RequestWait.wait(longWaitTime);
                    }
                    if (!o_RequestTimeOut.isTimedOut(10000L)) continue;
                }
                longTimeUsed = o_RequestTimeOut.stop();
                o_RequestTimeOut.close();
            }
        }
        catch (InterruptedException e) {
            return false;
        }
        if (longTimeUsed >= 10000L) {
            boolError = true;
        }
        if (boolError) {
            object = this.m_SyncAnswerMessage;
            synchronized (object) {
                this.m_ExpectedAnswers.remove(o_ExpectedAnswer);
            }
            this.fireWriteValuesFailed(this, 952, "Write Values timeout");
            return false;
        }
        return this.parseAnswer_ReadValuesMultiple(o_ExpectedAnswer, p_DMXHardwarePluginInterface, p_StartAddress, p_EndAddress);
    }

    private CommSerialPortConnection.ByteArray_Write getByteCode_ReadValuesMultiple(int p_StartAddresses, int p_EndAddresses) {
        CommSerialPortConnection.ByteArray_Write o_ByteArray_Write = CommSerialPortConnection.getByteArrayWrite(4);
        byte[] o_ByteCode = o_ByteArray_Write.getByteArray();
        o_ByteCode[0] = -2;
        o_ByteCode[1] = (byte)(p_StartAddresses & 0xFF);
        o_ByteCode[2] = (byte)(p_StartAddresses >> 8 & 0xFF);
        int intAddressCount = p_EndAddresses - p_StartAddresses + 1;
        o_ByteCode[3] = (byte)(intAddressCount & 0xFF);
        return o_ByteArray_Write;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean parseAnswer_ReadValuesMultiple(ExpectedAnswer p_ExpectedAnswer, DMXHardwarePluginInterface p_DMXHardwarePluginInterface, int p_StartAddresses, int p_EndAddress) {
        ExpectedAnswer o_ExpectedAnswer;
        Object object = this.m_SyncAnswerMessage;
        synchronized (object) {
            o_ExpectedAnswer = p_ExpectedAnswer;
        }
        if (o_ExpectedAnswer != null) {
            ArrayList<Byte> o_ArrayListData = o_ExpectedAnswer.getAnswerArrayListBytes();
            for (int intValue = 0; intValue < o_ArrayListData.size() - 1; ++intValue) {
                int intValueInterface = o_ArrayListData.get(intValue) != null ? o_ArrayListData.get(intValue) & 0xFF : 0;
                this.m_ArrayPluginValues[p_StartAddresses + intValue] = intValueInterface;
            }
            this.fireReadValuesSucces(this, this.m_ArrayPluginValues);
            return true;
        }
        this.fireReadValuesFailed(p_DMXHardwarePluginInterface, 951, "<html>Wrong Hardware Answer<br> (request ReadValues) -> <br></html>");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireReadValuesFailed(DMXHardwarePluginInterface p_DMXHardwarePluginInterface, int p_ExceptionType, String p_Remark) {
        DMXHardwarePluginFeedbackInterface o_DMXUniverseFeedbackInterface;
        if (p_DMXHardwarePluginInterface == null) {
            return;
        }
        if (this.m_DebugOn || this.m_DebugFailureOn) {
            System.out.println(this.getClass().getSimpleName() + " DMXPlugin: " + p_DMXHardwarePluginInterface.getDMXPluginInfo() + " fireReadValuesFailed -> disconnect");
        }
        Object object = this.m_SyncDMXPlugins;
        synchronized (object) {
            o_DMXUniverseFeedbackInterface = p_DMXHardwarePluginInterface.getDMXPluggedInUniverse();
        }
        if (o_DMXUniverseFeedbackInterface == null) {
            return;
        }
        o_DMXUniverseFeedbackInterface.eventPluginException((DMXHardwareInterface)this, p_DMXHardwarePluginInterface, p_ExceptionType, p_Remark);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireReadValuesSucces(DMXHardwarePluginInterface p_DMXHardwarePluginInterface, int[] p_ArrayValues) {
        DMXHardwarePluginFeedbackInterface o_DMXUniverseFeedbackInterface;
        if (p_DMXHardwarePluginInterface == null) {
            return;
        }
        Object object = this.m_SyncDMXPlugins;
        synchronized (object) {
            o_DMXUniverseFeedbackInterface = p_DMXHardwarePluginInterface.getDMXPluggedInUniverse();
        }
        if (o_DMXUniverseFeedbackInterface == null) {
            return;
        }
        o_DMXUniverseFeedbackInterface.eventPluginReadValues((DMXHardwareInterface)this, p_DMXHardwarePluginInterface, p_ArrayValues);
        if (this.m_DebugOn) {
            System.out.println(this.getClass().getSimpleName() + " DMXPlugin: " + p_DMXHardwarePluginInterface.getDMXPluginInfo() + " fireReadValuesSuccess");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireConnectionStatus(int p_ConnectionStatus, String p_Remark) {
        DMXHardwarePluginFeedbackInterface o_DMXUniverseFeedbackInterface;
        ArrayList<DMXHardwareFeedbackInterface> o_DMXHardwareFeedbackInterfaces;
        Object object = this.m_SyncHardwareFeedbackInterface;
        synchronized (object) {
            if (this.m_DMXHardwareFeedbackInterfaces == null) {
                return;
            }
            if (this.m_DMXHardwareFeedbackInterfaces.size() <= 0) {
                return;
            }
            o_DMXHardwareFeedbackInterfaces = new ArrayList<DMXHardwareFeedbackInterface>(this.m_DMXHardwareFeedbackInterfaces.size());
            o_DMXHardwareFeedbackInterfaces.addAll(this.m_DMXHardwareFeedbackInterfaces);
        }
        for (int intInterface = 0; intInterface < o_DMXHardwareFeedbackInterfaces.size(); ++intInterface) {
            DMXHardwareFeedbackInterface o_DMXHardwareFeedbackInterface = (DMXHardwareFeedbackInterface)o_DMXHardwareFeedbackInterfaces.get(intInterface);
            o_DMXHardwareFeedbackInterface.eventHardwareConnectionStatus((DMXHardwareInterface)this, (DMXHardwarePluginInterface)this, p_ConnectionStatus, p_Remark);
        }
        o_DMXHardwareFeedbackInterfaces.clear();
        Object object2 = this.m_SyncDMXPlugins;
        synchronized (object2) {
            o_DMXUniverseFeedbackInterface = this.getDMXPluggedInUniverse(this);
        }
        if (o_DMXUniverseFeedbackInterface != null) {
            o_DMXUniverseFeedbackInterface.eventPluginConnectionStatus((DMXHardwareInterface)this, (DMXHardwarePluginInterface)this, p_ConnectionStatus, p_Remark);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePlugStatus(DMXHardwarePluginInterface p_DMXHardwarePluginInterface, DMXHardwarePluginFeedbackInterface p_OldDMXUniverseFeedbackInterface, DMXHardwarePluginFeedbackInterface p_NewDMXUniverseFeedbackInterface) {
        ArrayList<DMXHardwareFeedbackInterface> o_DMXHardwareFeedbackInterfaces;
        Object object = this.m_SyncHardwareFeedbackInterface;
        synchronized (object) {
            if (this.m_DMXHardwareFeedbackInterfaces == null) {
                return;
            }
            if (this.m_DMXHardwareFeedbackInterfaces.size() <= 0) {
                return;
            }
            o_DMXHardwareFeedbackInterfaces = new ArrayList<DMXHardwareFeedbackInterface>(this.m_DMXHardwareFeedbackInterfaces.size());
            o_DMXHardwareFeedbackInterfaces.addAll(this.m_DMXHardwareFeedbackInterfaces);
        }
        for (int intInterface = 0; intInterface < o_DMXHardwareFeedbackInterfaces.size(); ++intInterface) {
            DMXHardwareFeedbackInterface o_DMXHardwareFeedbackInterface = (DMXHardwareFeedbackInterface)o_DMXHardwareFeedbackInterfaces.get(intInterface);
            o_DMXHardwareFeedbackInterface.eventHardwarePlugin((DMXHardwareInterface)this, p_DMXHardwarePluginInterface, p_OldDMXUniverseFeedbackInterface, p_NewDMXUniverseFeedbackInterface);
        }
        o_DMXHardwareFeedbackInterfaces.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireHardwareInterfacePluginChanged(DMXHardwarePluginInterface p_DMXHardwarePluginInterface) {
        ArrayList<DMXHardwareFeedbackInterface> o_DMXHardwareFeedbackInterfaces;
        Object object = this.m_SyncHardwareFeedbackInterface;
        synchronized (object) {
            if (this.m_DMXHardwareFeedbackInterfaces == null) {
                return;
            }
            if (this.m_DMXHardwareFeedbackInterfaces.size() <= 0) {
                return;
            }
            o_DMXHardwareFeedbackInterfaces = new ArrayList<DMXHardwareFeedbackInterface>(this.m_DMXHardwareFeedbackInterfaces.size());
            o_DMXHardwareFeedbackInterfaces.addAll(this.m_DMXHardwareFeedbackInterfaces);
        }
        for (int intInterface = 0; intInterface < o_DMXHardwareFeedbackInterfaces.size(); ++intInterface) {
            DMXHardwareFeedbackInterface o_DMXHardwareFeedbackInterface = (DMXHardwareFeedbackInterface)o_DMXHardwareFeedbackInterfaces.get(intInterface);
            o_DMXHardwareFeedbackInterface.eventHardwarePluginChanged((DMXHardwareInterface)this, p_DMXHardwarePluginInterface);
        }
        o_DMXHardwareFeedbackInterfaces.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireException(int p_ExceptionType, String p_Remark) {
        DMXHardwarePluginFeedbackInterface o_DMXUniverseFeedbackInterface;
        ArrayList<DMXHardwareFeedbackInterface> o_DMXHardwareFeedbackInterfaces;
        Object object = this.m_SyncHardwareFeedbackInterface;
        synchronized (object) {
            if (this.m_DMXHardwareFeedbackInterfaces == null) {
                return;
            }
            if (this.m_DMXHardwareFeedbackInterfaces.size() <= 0) {
                return;
            }
            o_DMXHardwareFeedbackInterfaces = new ArrayList<DMXHardwareFeedbackInterface>(this.m_DMXHardwareFeedbackInterfaces.size());
            o_DMXHardwareFeedbackInterfaces.addAll(this.m_DMXHardwareFeedbackInterfaces);
        }
        for (int intInterface = 0; intInterface < o_DMXHardwareFeedbackInterfaces.size(); ++intInterface) {
            DMXHardwareFeedbackInterface o_DMXHardwareFeedbackInterface = (DMXHardwareFeedbackInterface)o_DMXHardwareFeedbackInterfaces.get(intInterface);
            o_DMXHardwareFeedbackInterface.eventHardwareException((DMXHardwareInterface)this, p_ExceptionType, p_Remark);
        }
        o_DMXHardwareFeedbackInterfaces.clear();
        Object object2 = this.m_SyncDMXPlugins;
        synchronized (object2) {
            o_DMXUniverseFeedbackInterface = this.getDMXPluggedInUniverse(this);
        }
        if (o_DMXUniverseFeedbackInterface != null) {
            o_DMXUniverseFeedbackInterface.eventPluginException((DMXHardwareInterface)this, null, p_ExceptionType, p_Remark);
        }
    }

    @Override
    public void eventCommSerialPortConnection(int p_ConnectionStatus) {
        if (this.m_DebugOn) {
            System.out.println("DMX4All_StageProfiUSBDMXInterface Comm Connection: " + p_ConnectionStatus);
        }
        switch (p_ConnectionStatus) {
            case 0: {
                this.setConnectionStatus(2, this.getClass().getName() + " eventCommSerialPortConnection()");
                DMXHardwareInterface.s_ConnectedHardwareInterfaces.remove(this);
                break;
            }
            case 1: {
                DMXHardwareInterface.s_ConnectedHardwareInterfaces.add(this);
                this.setConnectionStatus(4, this.getClass().getName() + " eventCommSerialPortConnection()");
            }
        }
    }

    @Override
    public void eventCommSerialPortComm(CommSerialPortEvent p_CommSerialPortEvent) {
        if (this.m_DebugOn) {
            // empty if block
        }
    }

    @Override
    public void eventCommSerialPortException(Exception p_Exception) {
        System.out.println("Comm Exception: " + p_Exception.toString());
        if (this.m_DebugOn) {
            System.out.println("Comm Exception: " + p_Exception.toString());
        }
        CommSerialPortException o_CommSerialPortException = (CommSerialPortException)p_Exception;
        switch (o_CommSerialPortException.getExceptionType()) {
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 64: {
                this.fireException(900, "<html>CommPort Exception<br>" + o_CommSerialPortException.getMessage() + "</html>");
                this.disconnect();
                break;
            }
            case 256: {
                this.fireException(910, "<html>CommPort Exception<br>" + o_CommSerialPortException.getMessage() + "</html>");
                this.disconnect();
                break;
            }
            case 32: {
                this.fireException(900, "<html>CommPort Exception<br>" + o_CommSerialPortException.getMessage() + "</html>");
                this.disconnect();
            }
        }
    }

    @Override
    public void eventCommSerialPortDataReceived(byte[] p_InputBytes, int p_InputLength) {
        if (p_InputBytes == null) {
            return;
        }
        if (p_InputLength <= 0) {
            return;
        }
        this.parseReceivedBytes(p_InputBytes, p_InputLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseReceivedBytes(byte[] p_BytesReadenAll, int p_DataLenght) {
        if (p_BytesReadenAll == null) {
            return;
        }
        if (p_DataLenght <= 0) {
            return;
        }
        Object object = this.m_RequestWait;
        synchronized (object) {
            int intAnswerStatus = 0;
            int intByteOffset = 0;
            while (intByteOffset < p_DataLenght) {
                Object object2 = this.m_SyncAnswerMessage;
                synchronized (object2) {
                    if (this.m_ActualAnswer == null) {
                        if (this.m_ExpectedAnswers.size() <= 0) {
                            return;
                        }
                        this.m_ActualAnswer = this.m_ExpectedAnswers.get(0);
                    }
                    intByteOffset = this.m_ActualAnswer.parseBytes(p_BytesReadenAll, intByteOffset, p_DataLenght);
                    intAnswerStatus = this.m_ActualAnswer.getAnswerStatus();
                }
                if (intAnswerStatus == 0) continue;
                if (intAnswerStatus == 2) {
                    this.m_ExpectedAnswers.remove(this.m_ActualAnswer);
                } else if (intAnswerStatus == 1) {
                    this.m_ExpectedAnswers.remove(this.m_ActualAnswer);
                }
                this.m_ActualAnswer = null;
                this.m_RequestWait.notifyAll();
            }
        }
    }

    public DMXHardwareInterface getDMXHardwareInterface() {
        return this;
    }

    public String getDMXPluginInfo() {
        StringBuilder stringInfo = new StringBuilder();
        stringInfo.append(this.getPluginIndex() + 1);
        stringInfo.append(") ");
        stringInfo.append("Output");
        return stringInfo.toString();
    }

    public int getDMXPluginType() {
        return 0;
    }

    public boolean changeDMXPluginType(int p_DMXPlugInType) {
        return true;
    }

    public boolean requestDMXPlugConnection(DMXHardwarePluginFeedbackInterface p_DMXUniverseFeedbackInterface) {
        return this.requestDMXPlugConnection(this, p_DMXUniverseFeedbackInterface);
    }

    public DMXHardwarePluginFeedbackInterface getDMXPluggedInUniverse() {
        return this.m_PluggedUniverse;
    }

    public int[] getDMXPluginValues() {
        return this.getDMXPluginValues(this);
    }

    public boolean requestWriteValues(ArrayList<Integer> p_ChangedAddresses, int[] p_AllValues) {
        return this.requestWriteValues(this, p_ChangedAddresses, p_AllValues);
    }

    public boolean requestReadValues(ArrayList<Integer> p_Addresses) {
        return this.requestReadValues(this, p_Addresses);
    }

    public DMXHardwarePluginInterface getDMXHardwarePlugin(int p_Index) {
        return this;
    }

    public DMXHardwarePluginInterface getDMXHardwarePlugin_Output(int p_Index) {
        DMXHardwarePluginInterface o_DMXHardwarePluginInterface = this.getDMXHardwarePlugin(p_Index);
        if (o_DMXHardwarePluginInterface == null) {
            return null;
        }
        if (o_DMXHardwarePluginInterface.getDMXPluginType() == 0) {
            return o_DMXHardwarePluginInterface;
        }
        return null;
    }

    public DMXHardwarePluginInterface getDMXHardwarePlugin_Input(int p_Index) {
        DMXHardwarePluginInterface o_DMXHardwarePluginInterface = this.getDMXHardwarePlugin(p_Index);
        if (o_DMXHardwarePluginInterface == null) {
            return null;
        }
        if (o_DMXHardwarePluginInterface.getDMXPluginType() == 1) {
            return o_DMXHardwarePluginInterface;
        }
        return null;
    }

    public int getPluginIndex() {
        return 0;
    }

    public void propertyChanged(DMXHardwarePluginFeedbackInterface p_DMXHardwarePluginFeedbackInterface) {
        this.fireHardwareInterfacePluginChanged(this);
    }

    public boolean requestWriteMIDIMessage(byte[] p_MIDIBytes) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RequestTimeOut getPool_RequestTimeOut() {
        Object object = s_SyncRequestTimeOuts;
        synchronized (object) {
            if (s_RequestTimeOuts.size() <= 0) {
                RequestTimeOut o_RequestTimeOut = new RequestTimeOut();
                return o_RequestTimeOut;
            }
            RequestTimeOut o_RequestTimeOut = s_RequestTimeOuts.get(s_RequestTimeOuts.size() - 1);
            s_RequestTimeOuts.remove(s_RequestTimeOuts.size() - 1);
            o_RequestTimeOut.initMembers();
            return o_RequestTimeOut;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addPool_RequestTimeOut(RequestTimeOut p_RequestTimeOut) {
        if (p_RequestTimeOut == null) {
            return;
        }
        Object object = s_SyncRequestTimeOuts;
        synchronized (object) {
            s_RequestTimeOuts.add(p_RequestTimeOut);
        }
    }

    public static int checkOS() {
        String stringOS = System.getProperty("os.name").toLowerCase();
        s_OSFlag = stringOS.indexOf("win") >= 0 ? (stringOS.indexOf("10") >= 0 ? 5 : (stringOS.indexOf("8") >= 0 ? 4 : (stringOS.indexOf("7") >= 0 ? 3 : (stringOS.indexOf("vista") >= 0 ? 2 : (stringOS.indexOf("xp") >= 0 ? 1 : 0))))) : (stringOS.indexOf("mac") >= 0 ? 1000 : (stringOS.indexOf("nix") >= 0 || stringOS.indexOf("nux") >= 0 ? 100 : (stringOS.indexOf("sunos") >= 0 ? 10000 : -1)));
        return s_OSFlag;
    }

    public static class RequestTimeOut {
        Long m_DateStart;
        Long m_DateEnd;
        boolean m_Closed;
        final Object m_SyncObject = new Object();

        public RequestTimeOut() {
            this.initMembers();
        }

        public void initMembers() {
            this.m_DateStart = System.nanoTime() / 1000000L;
            this.m_DateEnd = null;
            this.m_Closed = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (this.m_Closed) {
                    return;
                }
                this.m_Closed = true;
                DMX4All_StageProfiUSBDMXInterface.addPool_RequestTimeOut(this);
            }
        }

        public void start() {
            this.m_DateStart = System.nanoTime() / 1000000L;
            this.m_DateEnd = null;
        }

        public long stop() {
            this.m_DateEnd = System.nanoTime() / 1000000L;
            return this.getTimeUsed();
        }

        public boolean isTimedOut(long p_MillisecondsOfAllowedDuration) {
            return this.m_DateEnd != null ? this.m_DateEnd - this.m_DateStart >= p_MillisecondsOfAllowedDuration : System.nanoTime() / 1000000L - this.m_DateStart >= p_MillisecondsOfAllowedDuration;
        }

        public long getTimeUsed() {
            if (this.m_DateEnd != null) {
                return this.m_DateEnd - this.m_DateStart;
            }
            return System.nanoTime() / 1000000L - this.m_DateStart;
        }
    }

    private class ExpectedAnswer {
        private int m_RequestType;
        private int m_ExpectedAnswerLength;
        private Byte m_LastByte;
        private int m_CountLastByte;
        private int m_LastByteOccured;
        private int m_AnswerStatus;
        private ArrayList<Byte> m_AnswerBytes;

        public ExpectedAnswer(int p_RequestType, int p_ExpectedAnswerLength, byte p_LastByte, int p_CountLastByte) {
            this.m_RequestType = p_RequestType;
            this.m_ExpectedAnswerLength = p_ExpectedAnswerLength;
            this.m_LastByte = p_LastByte;
            this.m_CountLastByte = p_CountLastByte;
            this.m_AnswerStatus = 0;
            this.m_LastByteOccured = 0;
            this.m_AnswerBytes = new ArrayList();
        }

        public void close() {
            if (this.m_AnswerBytes != null) {
                this.m_AnswerBytes.clear();
            }
        }

        public int parseBytes(byte[] p_BytesReadenAll, int p_Offset, int p_DataLenght) {
            int intBytesOffset = p_Offset;
            if (this.m_ExpectedAnswerLength == 0) {
                this.m_AnswerStatus = 1;
                return intBytesOffset;
            }
            if (this.m_ExpectedAnswerLength > 0) {
                Byte o_Byte = null;
                if (p_DataLenght - p_Offset < this.m_ExpectedAnswerLength - this.m_AnswerBytes.size()) {
                    for (int intByte = p_Offset; intByte < p_DataLenght; ++intByte) {
                        o_Byte = p_BytesReadenAll[intByte];
                        this.m_AnswerBytes.add(o_Byte);
                        ++intBytesOffset;
                    }
                    this.m_AnswerStatus = 0;
                    return intBytesOffset;
                }
                for (int intByte = 0; intByte < this.m_ExpectedAnswerLength - this.m_AnswerBytes.size(); ++intByte) {
                    o_Byte = p_BytesReadenAll[p_Offset + intByte];
                    this.m_AnswerBytes.add(o_Byte);
                    ++intBytesOffset;
                }
                this.m_AnswerStatus = this.m_LastByte != null ? (o_Byte.byteValue() == this.m_LastByte.byteValue() ? 1 : 2) : 1;
                return intBytesOffset;
            }
            for (int intByte = p_Offset; intByte < p_DataLenght; ++intByte) {
                byte o_Byte = p_BytesReadenAll[intByte];
                this.m_AnswerBytes.add(o_Byte);
                ++intBytesOffset;
                if (o_Byte != this.m_LastByte) continue;
                ++this.m_LastByteOccured;
                if (this.m_LastByteOccured != this.m_CountLastByte) continue;
                this.m_AnswerStatus = 1;
                return intBytesOffset;
            }
            this.m_AnswerStatus = 0;
            return intBytesOffset;
        }

        public int getAnswerStatus() {
            return this.m_AnswerStatus;
        }

        public int getRequestType() {
            return this.m_RequestType;
        }

        public String getAnswerString() {
            byte[] byteArray = new byte[this.m_AnswerBytes.size()];
            for (int intByte = 0; intByte < this.m_AnswerBytes.size(); ++intByte) {
                byteArray[intByte] = this.m_AnswerBytes.get(intByte);
            }
            String stringAnswer = new String(byteArray, s_Charset);
            return stringAnswer;
        }

        public String getAnswerStringHTML() {
            String stringAnswer = this.getAnswerString();
            stringAnswer = stringAnswer.replaceAll("\n", "<br>");
            return "<html><center>" + stringAnswer + "</center></html>";
        }

        public ArrayList<Byte> getAnswerArrayListBytes() {
            return this.m_AnswerBytes;
        }
    }
}

