/*
 * Decompiled with CFR 0.152.
 */
package DMXVirtualPackage;

import DMXDevicePackage.DMXDevice;
import DMXDevicePackage.DMXDeviceType;
import DMXEffectsPackage.DMXEffect;
import DMXMixer.DMXControlComponent;
import DMXScenePackage.DMXScene;
import DMXVirtualPackage.DMXFadeDescription;
import DMXVirtualPackage.LiveShowDMXObject;
import DMXVirtualPackage.LiveShowDMXObjectDescription;
import DMXVirtualPackage.LiveShowDMXSceneBridge;
import DMXVirtualPackage.LiveShowDMXVIP;
import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LanguageTools.LiveLanguagePackage.LiveLanguageString;
import LiveShowNotificationPackage.LiveShowNotification;
import LiveShowObjectPackage.LiveShowObject;
import LiveShowObjectPackage.LiveShowObjectInterface;
import LiveShowPlayPackage.Play;
import LiveShowPlayPackage.Playable;
import LiveShowVirtualPackage.LiveShowSceneBridge;
import LiveShowVirtualPackage.LiveShowVIP;
import LiveShowVirtualPackage.LiveShowVIPListener;
import LiveShowVirtualPackage.LiveShowVIPTrack;
import PlayDMXPackage.PlayDMX;
import SynchronizationPackage.JobHandler;
import SynchronizationPackage.LiveCloseSemaphore;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class LiveShowDMXVIPAdjustment
implements LiveShowVIPListener,
PropertyChangeListener {
    public static long TIMEFORADKUSTMENT = 10000L;
    public static long CROSSOVERCORRECTIONFRAMES = 0L;
    public static long ADJUSTMENTDELAY = 0L;
    @LiveLanguageString
    public static String Notification_CalculateAdjustment = "Timeline Precalculation";
    public static boolean s_ProjectJustLoading = false;
    private LiveShowDMXVIP m_LiveShowDMXVIP;
    private HashMap<DMXDevice, DMXDeviceAdjustment> m_DMXDeviceAdjustments;
    private ArrayList<DMXDeviceAdjustment> m_DMXDeviceAdjustments_SceneBridgeStarted;
    private ArrayList<DMXScene> m_DMXScenes;
    private LiveCloseSemaphore m_LiveCloseSemaphore;
    private final Object m_SyncPlay = new Object();
    private Runnable m_Runnable_CalculateAdjustment;
    private static LiveShowDMXVIPAdjustment s_SelfReference;

    public static LiveShowDMXVIPAdjustment getSelfReference() {
        return s_SelfReference;
    }

    public static long getAdjustmentLength() {
        return TIMEFORADKUSTMENT;
    }

    public static void setAdjustmentTime(long p_Milliseconds) {
        if (p_Milliseconds < 0L) {
            return;
        }
        TIMEFORADKUSTMENT = p_Milliseconds;
        CROSSOVERCORRECTIONFRAMES = LiveShowDMXVIPAdjustment.getAdjustmentCrossoverCorrectionFrames();
        if (s_SelfReference != null) {
            s_SelfReference.calculateAdjustment();
        }
    }

    public static long getAdjustmentCrossoverCorrectionFrames() {
        return (long)((double)PlayDMX.BUFFER_MILLISECONDS / LiveShowVIP.FRAMETIME + 0.5);
    }

    public static long getAdjustmentCrossoverCorrection() {
        return PlayDMX.BUFFER_MILLISECONDS;
    }

    public static void setAdjustmentCrossoverCorrectionFrames(long p_Frames) {
        long longCorrectionFrames = p_Frames;
        if (CROSSOVERCORRECTIONFRAMES != longCorrectionFrames) {
            CROSSOVERCORRECTIONFRAMES = longCorrectionFrames;
            if (s_SelfReference != null) {
                s_SelfReference.calculateAdjustment();
            }
        }
    }

    public static long getAdjustmentDelayFrames() {
        return ADJUSTMENTDELAY;
    }

    public static long getAdjustmentDelay() {
        return (long)((double)ADJUSTMENTDELAY * LiveShowVIP.FRAMETIME + 0.5);
    }

    public static void setAdjustmentDelay(long p_Milliseconds) {
        long longDelayFrames = (long)((double)p_Milliseconds / LiveShowVIP.FRAMETIME + 0.5);
        if (ADJUSTMENTDELAY != longDelayFrames) {
            ADJUSTMENTDELAY = longDelayFrames;
            if (s_SelfReference != null) {
                s_SelfReference.calculateAdjustment();
            }
        }
    }

    public static void calculateAdjustmentAll() {
        if (s_SelfReference != null) {
            s_SelfReference.calculateAdjustment();
        }
    }

    public static DMXDeviceAdjustment getDMXDeviceAdjustment(DMXDevice p_DMXDevice) {
        if (s_SelfReference == null) {
            return null;
        }
        return s_SelfReference.findDMXDeviceAdjustment(p_DMXDevice);
    }

    public LiveShowDMXVIPAdjustment(LiveShowDMXVIP p_LiveShowDMXVIP) {
        s_SelfReference = this;
        this.m_LiveShowDMXVIP = p_LiveShowDMXVIP;
        this.m_LiveShowDMXVIP.addLiveShowVIPListener(this);
        this.initMembers();
        LiveLanguage.addLanguageListener((Object)this, null);
        DMXDevice.getTreeModel_Device_Channels().addPropertyChangeListener(this);
        this.loadAllDMXDevices();
    }

    private void initMembers() {
        this.m_LiveCloseSemaphore = new LiveCloseSemaphore(this.getClass().getSimpleName());
        this.m_DMXDeviceAdjustments = new HashMap();
        this.m_DMXDeviceAdjustments_SceneBridgeStarted = new ArrayList(100);
        this.m_DMXScenes = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (!this.m_LiveCloseSemaphore.enterCloseSection()) {
            return;
        }
        this.m_LiveShowDMXVIP.removeLiveShowVIPListener(this);
        DMXDevice.getTreeModel_Device_Channels().removePropertyChangeListener(this);
        this.clearDMXSceneToListen();
        Object object = this.m_SyncPlay;
        synchronized (object) {
            Iterator<DMXDevice> o_IteratorDMXDevice = this.m_DMXDeviceAdjustments.keySet().iterator();
            while (o_IteratorDMXDevice.hasNext()) {
                DMXDevice o_DMXDevice = o_IteratorDMXDevice.next();
                o_DMXDevice.removePropertyChangeListener(this);
                DMXDeviceAdjustment o_DMXDeviceAdjustment = this.m_DMXDeviceAdjustments.get(o_DMXDevice);
                o_IteratorDMXDevice.remove();
                if (o_DMXDeviceAdjustment == null) continue;
                o_DMXDeviceAdjustment.close();
            }
        }
        DMXDeviceAdjustGroupSceneBridge.poolClear();
        DMXDeviceAdjustObjectSceneBridge.poolClear();
        DMXDeviceAdjustGroup.poolClear();
        DMXDeviceAdjustObject.poolClear();
        s_SelfReference = null;
        this.m_LiveCloseSemaphore.leaveCloseSection();
    }

    public LiveShowDMXVIP getLiveShowDMXVIP() {
        return this.m_LiveShowDMXVIP;
    }

    public void addDMXSceneToListen(DMXScene p_DMXScene) {
        if (p_DMXScene == null) {
            return;
        }
        if (this.m_DMXScenes.contains(p_DMXScene)) {
            return;
        }
        this.m_DMXScenes.add(p_DMXScene);
        p_DMXScene.addPropertyChangeListener(this);
    }

    public void clearDMXSceneToListen() {
        for (int intScene = this.m_DMXScenes.size() - 1; intScene >= 0; --intScene) {
            DMXScene o_DMXScene = this.m_DMXScenes.get(intScene);
            if (o_DMXScene == null) continue;
            o_DMXScene.removePropertyChangeListener(this);
            this.m_DMXScenes.remove(intScene);
        }
    }

    public void calculateAdjustment() {
        if (this.m_Runnable_CalculateAdjustment == null) {
            this.m_Runnable_CalculateAdjustment = new Runnable(){

                @Override
                public void run() {
                    LiveShowNotification o_LiveShowNotification = null;
                    if (s_ProjectJustLoading) {
                        o_LiveShowNotification = new LiveShowNotification(Notification_CalculateAdjustment, DMXDevice.getDMXDeviceCount(), 0L, false);
                    }
                    LiveShowDMXVIPAdjustment.this.doCalculateAdjustment(o_LiveShowNotification);
                    if (s_ProjectJustLoading) {
                        System.gc();
                        s_ProjectJustLoading = false;
                    }
                    if (o_LiveShowNotification != null) {
                        o_LiveShowNotification.close();
                    }
                }
            };
        }
        JobHandler.addJob(this.m_Runnable_CalculateAdjustment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCalculateAdjustment(LiveShowNotification p_LiveShowNotification) {
        ArrayList<DMXDeviceAdjustment> o_DMXDeviceAdjustments;
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return;
        }
        Object object = this.m_SyncPlay;
        synchronized (object) {
            if (this.m_DMXDeviceAdjustments == null) {
                this.m_LiveCloseSemaphore.leaveWorkerSection();
                return;
            }
            o_DMXDeviceAdjustments = new ArrayList<DMXDeviceAdjustment>(this.m_DMXDeviceAdjustments.size());
            o_DMXDeviceAdjustments.addAll(this.m_DMXDeviceAdjustments.values());
        }
        for (int intDMXDeviceAdjustment = 0; intDMXDeviceAdjustment < o_DMXDeviceAdjustments.size(); ++intDMXDeviceAdjustment) {
            DMXDeviceAdjustment o_DMXDeviceAdjustment = (DMXDeviceAdjustment)o_DMXDeviceAdjustments.get(intDMXDeviceAdjustment);
            if (o_DMXDeviceAdjustment != null) {
                o_DMXDeviceAdjustment.calculateAdjustment();
            }
            if (p_LiveShowNotification == null) continue;
            p_LiveShowNotification.setProgress(intDMXDeviceAdjustment + 1);
        }
        o_DMXDeviceAdjustments.clear();
        this.m_LiveCloseSemaphore.leaveWorkerSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void calculateAdjustmentSceneBridgeStarted(LiveShowDMXSceneBridge p_LiveShowDMXSceneBridge, ArrayList<LiveShowDMXObject> p_LiveShowDMXObjectsLastRead) {
        if (p_LiveShowDMXSceneBridge == null) {
            return;
        }
        DMXScene.DMXSceneValueContainer o_DMXSceneValueContainer = p_LiveShowDMXSceneBridge.getPreDMXSceneValueContainer();
        if (o_DMXSceneValueContainer == null) {
            return;
        }
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return;
        }
        Object object = this.m_SyncPlay;
        synchronized (object) {
            if (this.m_DMXDeviceAdjustments == null) {
                this.m_LiveCloseSemaphore.leaveWorkerSection();
                return;
            }
            this.m_DMXDeviceAdjustments_SceneBridgeStarted.clear();
            this.m_DMXDeviceAdjustments_SceneBridgeStarted.addAll(this.m_DMXDeviceAdjustments.values());
        }
        for (int intAdjustment = 0; intAdjustment < this.m_DMXDeviceAdjustments_SceneBridgeStarted.size(); ++intAdjustment) {
            DMXDevice o_DMXDevice;
            DMXDeviceAdjustment o_DMXDeviceAdjustment = this.m_DMXDeviceAdjustments_SceneBridgeStarted.get(intAdjustment);
            if (o_DMXDeviceAdjustment == null || (o_DMXDevice = o_DMXDeviceAdjustment.getDMXDevice()) == null) continue;
            DMXFadeDescription.DMXDeviceFadeDescription o_DMXDeviceFadeDescription = o_DMXDevice.getDMXDeviceType().getDefaultDMXDeviceFadeDescription();
            for (int intDMXObject = 0; intDMXObject < p_LiveShowDMXObjectsLastRead.size(); ++intDMXObject) {
                DMXFadeDescription o_DMXFadeDescription;
                DMXScene o_DMXScene;
                LiveShowDMXObject o_LiveShowDMXObject = p_LiveShowDMXObjectsLastRead.get(intDMXObject);
                if (o_LiveShowDMXObject == null || (o_DMXScene = o_LiveShowDMXObject.getDMXScene()) == null || !o_DMXScene.isDimmerOn(o_DMXDevice) || (o_DMXFadeDescription = o_LiveShowDMXObject.getDMXFadeDescription()) == null) continue;
                o_DMXDeviceFadeDescription = o_DMXFadeDescription.getDMXDeviceFadeDescription(o_DMXDevice.getID());
                break;
            }
            o_DMXDeviceAdjustment.calculateAdjustmentSceneBridgeStarted(p_LiveShowDMXSceneBridge, o_DMXSceneValueContainer.getDMXSceneDeviceValues(o_DMXDevice.getID()), o_DMXDeviceFadeDescription);
        }
        this.m_DMXDeviceAdjustments_SceneBridgeStarted.clear();
        this.m_LiveCloseSemaphore.leaveWorkerSection();
    }

    private void loadAllDMXDevices() {
        for (int intDMXDevice = 0; intDMXDevice < DMXDevice.getDMXDeviceCount(); ++intDMXDevice) {
            DMXDevice o_DMXDevice = DMXDevice.getDMXDevice(intDMXDevice);
            this.addDMXDevice(o_DMXDevice);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDMXDevice(DMXDevice p_DMXDevice) {
        DMXDeviceAdjustment o_DMXDeviceAdjustment;
        if (p_DMXDevice == null) {
            return;
        }
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return;
        }
        Object object = this.m_SyncPlay;
        synchronized (object) {
            if (this.m_DMXDeviceAdjustments.containsKey(p_DMXDevice)) {
                this.m_LiveCloseSemaphore.leaveWorkerSection();
                return;
            }
            p_DMXDevice.addPropertyChangeListener("dmxdeviceDMXDeviceType", this);
            o_DMXDeviceAdjustment = new DMXDeviceAdjustment(this, p_DMXDevice);
            this.m_DMXDeviceAdjustments.put(p_DMXDevice, o_DMXDeviceAdjustment);
        }
        if (!s_ProjectJustLoading) {
            Runnable o_Runnable = o_DMXDeviceAdjustment.getRunnableCalculateAdjustment();
            JobHandler.addJob(o_Runnable);
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDMXDevice(DMXDevice p_DMXDevice) {
        DMXDeviceAdjustment o_DMXDeviceAdjustment;
        if (p_DMXDevice == null) {
            return;
        }
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return;
        }
        Object object = this.m_SyncPlay;
        synchronized (object) {
            if (this.m_DMXDeviceAdjustments == null) {
                this.m_LiveCloseSemaphore.leaveWorkerSection();
                return;
            }
            o_DMXDeviceAdjustment = this.m_DMXDeviceAdjustments.remove(p_DMXDevice);
        }
        if (o_DMXDeviceAdjustment != null) {
            p_DMXDevice.removePropertyChangeListener("dmxdeviceDMXDeviceType", this);
            o_DMXDeviceAdjustment.close();
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshDMXDevice(DMXDevice p_DMXDevice) {
        if (p_DMXDevice == null) {
            return;
        }
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return;
        }
        Object object = this.m_SyncPlay;
        synchronized (object) {
            if (this.m_DMXDeviceAdjustments == null) {
                this.m_LiveCloseSemaphore.leaveWorkerSection();
                return;
            }
            DMXDeviceAdjustment o_DMXDeviceAdjustment = this.m_DMXDeviceAdjustments.get(p_DMXDevice);
            if (o_DMXDeviceAdjustment != null) {
                JobHandler.addJob(o_DMXDeviceAdjustment.getRunnableCalculateAdjustment());
            } else {
                System.out.println("LiveSHowDMXAdjustment has no Adjustment for DMXDevice" + p_DMXDevice.getName());
            }
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
    }

    public DMXDeviceAdjustment findDMXDeviceAdjustment(DMXDevice p_DMXDevice) {
        if (p_DMXDevice == null) {
            return null;
        }
        if (this.m_DMXDeviceAdjustments == null) {
            return null;
        }
        return this.m_DMXDeviceAdjustments.get(p_DMXDevice);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eventLiveShowDMXObectRemoved(LiveShowDMXObject p_LiveShowDMXObject) {
        ArrayList<DMXDeviceAdjustment> o_DMXDeviceAdjustments;
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return;
        }
        Object object = this.m_SyncPlay;
        synchronized (object) {
            if (this.m_DMXDeviceAdjustments == null) {
                this.m_LiveCloseSemaphore.leaveWorkerSection();
                return;
            }
            o_DMXDeviceAdjustments = new ArrayList<DMXDeviceAdjustment>(this.m_DMXDeviceAdjustments.size());
            o_DMXDeviceAdjustments.addAll(this.m_DMXDeviceAdjustments.values());
        }
        for (int intAjustment = 0; intAjustment < o_DMXDeviceAdjustments.size(); ++intAjustment) {
            DMXDeviceAdjustment o_DMXDeviceAdjustment = (DMXDeviceAdjustment)o_DMXDeviceAdjustments.get(intAjustment);
            if (o_DMXDeviceAdjustment == null) continue;
            o_DMXDeviceAdjustment.eventLiveShowDMXObectRemoved(p_LiveShowDMXObject);
        }
        o_DMXDeviceAdjustments.clear();
        this.m_LiveCloseSemaphore.leaveWorkerSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eventLiveShowDMXSceneBridgeRemoved(LiveShowDMXSceneBridge p_LiveShowDMXSceneBridge) {
        ArrayList<DMXDeviceAdjustment> o_DMXDeviceAdjustments;
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return;
        }
        Object object = this.m_SyncPlay;
        synchronized (object) {
            if (this.m_DMXDeviceAdjustments == null) {
                this.m_LiveCloseSemaphore.leaveWorkerSection();
                return;
            }
            o_DMXDeviceAdjustments = new ArrayList<DMXDeviceAdjustment>(this.m_DMXDeviceAdjustments.size());
            o_DMXDeviceAdjustments.addAll(this.m_DMXDeviceAdjustments.values());
        }
        for (int intAjustment = 0; intAjustment < o_DMXDeviceAdjustments.size(); ++intAjustment) {
            DMXDeviceAdjustment o_DMXDeviceAdjustment = (DMXDeviceAdjustment)o_DMXDeviceAdjustments.get(intAjustment);
            o_DMXDeviceAdjustment.eventLiveShowDMXSceneBridgeRemoved(p_LiveShowDMXSceneBridge);
        }
        o_DMXDeviceAdjustments.clear();
        this.m_LiveCloseSemaphore.leaveWorkerSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Playable.PlayObject readInternal(Play p_Play, Playable.PlayObject p_PlayObject, LiveShowSceneBridge p_LiveShowSceneBridge, long p_SceneBridgeFrameInside, double p_SceneBridgeFadeProgress, boolean p_IsPreObject) {
        if (p_PlayObject == null) {
            return null;
        }
        if (p_PlayObject.getFramePosition() < 0L) {
            return null;
        }
        if (p_PlayObject.getData() == null) {
            return null;
        }
        if (!(p_PlayObject instanceof PlayDMX.DMXPlayObject)) {
            return null;
        }
        PlayDMX.DMXPlayObject o_DMXPlayObject = (PlayDMX.DMXPlayObject)p_PlayObject;
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return null;
        }
        Object object = this.m_SyncPlay;
        synchronized (object) {
            LiveShowDMXSceneBridge o_LiveShowSceneBridgeNextNext;
            LiveShowDMXSceneBridge o_LiveShowSceneBridgeNext = (LiveShowDMXSceneBridge)this.m_LiveShowDMXVIP.getLiveShowSceneBridge_NextToPlay(p_PlayObject.getFramePosition(), false);
            if (o_LiveShowSceneBridgeNext != null) {
                int intindex = this.m_LiveShowDMXVIP.getLiveShowSceneBridgeNumber(o_LiveShowSceneBridgeNext, false);
                o_LiveShowSceneBridgeNextNext = (LiveShowDMXSceneBridge)this.m_LiveShowDMXVIP.getLiveShowSceneBridge(intindex + 1);
            } else {
                o_LiveShowSceneBridgeNextNext = null;
            }
            for (DMXDeviceAdjustment o_DMXDeviceAdjustment : this.m_DMXDeviceAdjustments.values()) {
                if (o_DMXDeviceAdjustment == null) continue;
                o_DMXDeviceAdjustment.read(p_Play, p_PlayObject, p_LiveShowSceneBridge, p_SceneBridgeFrameInside, p_SceneBridgeFadeProgress, p_IsPreObject, o_LiveShowSceneBridgeNext, o_LiveShowSceneBridgeNextNext);
            }
        }
        PlayDMX.DMXPlayObject o_Result = o_DMXPlayObject;
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        return o_Result;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof DMXDevice) {
            if ("dmxdeviceDMXDeviceType".equals(evt.getPropertyName())) {
                DMXDevice o_DMXDevice = (DMXDevice)evt.getSource();
                this.refreshDMXDevice(o_DMXDevice);
            }
        } else if (evt.getSource() instanceof DMXDevice.TreeModel_Device_Channels) {
            if ("dmxdevicetreemodelDMXDeviceRemoved".equals(evt.getPropertyName())) {
                DMXDevice o_DMXDevice = (DMXDevice)evt.getOldValue();
                this.removeDMXDevice(o_DMXDevice);
            } else if ("dmxdevicetreemodelDMXDeviceAdded".equals(evt.getPropertyName())) {
                DMXDevice o_DMXDevice = (DMXDevice)evt.getNewValue();
                this.addDMXDevice(o_DMXDevice);
            }
        } else if (evt.getSource() instanceof DMXScene && "dmxsceneChanged".equals(evt.getPropertyName())) {
            this.calculateAdjustment();
        }
    }

    @Override
    public void eventVIPEndOfAction(LiveShowVIP p_LiveShowVIP, LiveShowVIP p_ActorLiveShowVIP, boolean p_Success, int p_Action) {
        if (p_LiveShowVIP != this.m_LiveShowDMXVIP) {
            return;
        }
        if (p_Action == 110) {
            return;
        }
        if (p_Action == 112) {
            return;
        }
        this.clearDMXSceneToListen();
        this.calculateAdjustment();
    }

    @Override
    public void eventVIPActive(LiveShowVIP p_LiveShowVIP, boolean p_Active) {
    }

    @Override
    public void eventVIPToFront(LiveShowVIP p_LiveShowVIP) {
    }

    @Override
    public void eventVIPClosing(LiveShowVIP p_LiveShowSoundVIP) {
    }

    @Override
    public void eventVIPFrameTime(LiveShowVIP p_LiveShowVIP, double p_FrameTime) {
    }

    @Override
    public void eventVIPFrameMaxObjects(LiveShowVIP p_LiveShowVIP, long p_FrameMaxObjects) {
    }

    @Override
    public void eventVIPMaxFrame(LiveShowVIP p_LiveShowVIP, long p_FrameMax) {
    }

    @Override
    public void eventVIPSceneBridgeAdded(LiveShowVIP p_LiveShowSoundVIP, LiveShowSceneBridge p_LiveShowSceneBridge) {
    }

    @Override
    public void eventVIPSceneBridgeRemoved(LiveShowVIP p_LiveShowSoundVIP, LiveShowSceneBridge p_LiveShowSceneBridge) {
        if (p_LiveShowSceneBridge instanceof LiveShowDMXSceneBridge) {
            this.eventLiveShowDMXSceneBridgeRemoved((LiveShowDMXSceneBridge)p_LiveShowSceneBridge);
        }
    }

    @Override
    public void eventVIPSceneBridgesResorted(LiveShowVIP p_LiveShowSoundVIP, LiveShowSceneBridge p_LiveShowSceneBridge, ArrayList<LiveShowSceneBridge> p_LiveShowSceneBridges) {
    }

    @Override
    public void eventVIPSceneBridgeCursorChanged(LiveShowVIP p_LiveShowSoundVIP, boolean p_ActualPlaying, boolean p_ActualStopAtStart) {
    }

    @Override
    public void eventVIPSceneBridgeEditCursorChanged(LiveShowVIP p_LiveShowSoundVIP) {
    }

    @Override
    public void eventVIPSceneBridgeStart(LiveShowVIP p_LiveShowVIP, LiveShowSceneBridge p_LiveShowSceneBridge, boolean p_WillPlay) {
    }

    @Override
    public void eventVIPSceneBridgeEnd(LiveShowVIP p_LiveShowVIP, LiveShowSceneBridge p_LiveShowSceneBridge) {
    }

    @Override
    public void eventVIPObjectAdded(LiveShowVIP p_LiveShowSoundVIP, LiveShowObjectInterface p_LiveShowObjectInterface) {
    }

    @Override
    public void eventVIPObjectRemoved(LiveShowVIP p_LiveShowSoundVIP, LiveShowObjectInterface p_LiveShowObjectInterface) {
        if (p_LiveShowObjectInterface instanceof LiveShowDMXObject) {
            this.eventLiveShowDMXObectRemoved((LiveShowDMXObject)p_LiveShowObjectInterface);
        }
    }

    @Override
    public void eventVIPObjectParamChanged(LiveShowVIP p_LiveShowSoundVIP, LiveShowObjectInterface p_LiveShowObjectInterface) {
    }

    @Override
    public void eventVIPEditModeOn(LiveShowVIP p_LiveShowVIP, boolean p_EditModeOn) {
    }

    @Override
    public void eventVIPCursorMode(LiveShowVIP p_LiveShowSoundVIP, int p_EditMode) {
    }

    @Override
    public void eventVIPObjectShowSettings(LiveShowVIP p_LiveShowSoundVIP, LiveShowObjectInterface p_LiveShowObjectInterface) {
    }

    @Override
    public void eventVIPObjectSelection(LiveShowVIP p_LiveShowSoundVIP, LiveShowObjectInterface p_LiveShowObjectInterface) {
    }

    @Override
    public void eventVIPTrackAdded(LiveShowVIP p_LiveShowSoundVIP, LiveShowVIPTrack p_LiveShowVIPTrack) {
    }

    @Override
    public void eventVIPTrackRemoved(LiveShowVIP p_LiveShowSoundVIP, LiveShowVIPTrack p_LiveShowVIPTrack) {
    }

    public static class DMXDeviceAdjustObjectSceneBridge
    extends DMXDeviceAdjustObject {
        public static ArrayList<DMXDeviceAdjustObjectSceneBridge> s_DMXDeviceAdjustObjectSceneBridgePool = new ArrayList();
        public static Object s_SyncDMXDeviceAdjustObjects = new Object();
        private DMXDeviceAdjustGroupSceneBridge m_DMXDeviceAdjustGroupSceneBridge;
        private boolean m_Closed;
        private final Object m_SyncObject = new Object();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static DMXDeviceAdjustObjectSceneBridge poolGet(DMXDeviceAdjustGroupSceneBridge p_DMXDeviceAdjustGroup, LiveShowDMXSceneBridge p_LiveShowDMXSceneBridge, boolean p_IsStartAjustment) {
            DMXDeviceAdjustObjectSceneBridge o_DMXDeviceAdjustObjectSceneBridge;
            String stringDMXDeviceID = "";
            Object object = s_SyncDMXDeviceAdjustObjects;
            synchronized (object) {
                DMXDevice o_DMXDevice;
                if (p_DMXDeviceAdjustGroup != null && (o_DMXDevice = p_DMXDeviceAdjustGroup.getDMXDevice()) != null) {
                    stringDMXDeviceID = o_DMXDevice.getID();
                }
                s_StandardLiveShowDMXObjectDescription.setDMXDeviceID(stringDMXDeviceID);
                s_StandardLiveShowDMXObjectDescription.reactivate(true);
                if (s_DMXDeviceAdjustObjectSceneBridgePool.size() > 0) {
                    int intIndex = s_DMXDeviceAdjustObjectSceneBridgePool.size() - 1;
                    o_DMXDeviceAdjustObjectSceneBridge = s_DMXDeviceAdjustObjectSceneBridgePool.get(intIndex);
                    o_DMXDeviceAdjustObjectSceneBridge.reactivate(DMXDeviceAdjustObject.s_StandardLiveShowDMXObjectDescription);
                    o_DMXDeviceAdjustObjectSceneBridge.setParams(p_DMXDeviceAdjustGroup, p_LiveShowDMXSceneBridge, p_IsStartAjustment);
                    s_DMXDeviceAdjustObjectSceneBridgePool.remove(intIndex);
                } else {
                    o_DMXDeviceAdjustObjectSceneBridge = new DMXDeviceAdjustObjectSceneBridge(p_DMXDeviceAdjustGroup, p_LiveShowDMXSceneBridge, p_IsStartAjustment);
                }
            }
            return o_DMXDeviceAdjustObjectSceneBridge;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void poolAddEmpty(DMXDeviceAdjustObjectSceneBridge p_DMXDeviceAdjustObjectSceneBridge) {
            if (p_DMXDeviceAdjustObjectSceneBridge == null) {
                return;
            }
            Object object = s_SyncDMXDeviceAdjustObjects;
            synchronized (object) {
                if (s_DMXDeviceAdjustObjectSceneBridgePool.size() < 5000) {
                    s_DMXDeviceAdjustObjectSceneBridgePool.add(p_DMXDeviceAdjustObjectSceneBridge);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void poolClear() {
            Object object = s_SyncDMXDeviceAdjustObjects;
            synchronized (object) {
                s_DMXDeviceAdjustObjectSceneBridgePool.clear();
            }
        }

        public DMXDeviceAdjustObjectSceneBridge(DMXDeviceAdjustGroupSceneBridge p_DMXDeviceAdjustGroup, LiveShowDMXSceneBridge p_LiveShowDMXSceneBridge, boolean p_IsStartAjustment) {
            super(p_DMXDeviceAdjustGroup, null, p_LiveShowDMXSceneBridge, p_IsStartAjustment);
            this.initMembers();
            this.setParams(p_DMXDeviceAdjustGroup, p_LiveShowDMXSceneBridge, p_IsStartAjustment);
        }

        private void initMembers() {
            this.m_Closed = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close(boolean p_Finish) {
            super.close(true);
            this.m_LiveShowDMXSceneBridge = null;
            this.m_DMXDeviceAdjustGroupSceneBridge = null;
            if (p_Finish) {
                Object object = this.m_SyncObject;
                synchronized (object) {
                    if (this.m_Closed) {
                        return;
                    }
                    this.m_Closed = true;
                    DMXDeviceAdjustObjectSceneBridge.poolAddEmpty(this);
                }
            }
        }

        public void setParams(DMXDeviceAdjustGroupSceneBridge p_DMXDeviceAdjustGroup, LiveShowDMXSceneBridge p_LiveShowDMXSceneBridge, boolean p_IsStartAjustment) {
            super.setParams(p_DMXDeviceAdjustGroup, null, p_LiveShowDMXSceneBridge, p_IsStartAjustment);
            this.m_DMXDeviceAdjustGroupSceneBridge = p_DMXDeviceAdjustGroup;
            if (this.m_DMXDeviceAdjustGroupSceneBridge != null) {
                this.m_DMXDevice = this.m_DMXDeviceAdjustGroupSceneBridge.getDMXDevice();
            }
            this.m_LiveShowDMXSceneBridge = p_LiveShowDMXSceneBridge;
            this.m_IsStartAdjustment = p_IsStartAjustment;
            this.m_DMXSceneDeviceValues = null;
            this.m_Description.setName("AjustmentSceneBridge");
        }

        @Override
        public void reactivate(LiveShowDMXObjectDescription p_LiveShowDMXObjectDescription) {
            super.reactivate(p_LiveShowDMXObjectDescription);
            this.m_Closed = false;
        }

        public void calculateAdjustmentSceneBridgeStarted(DMXScene.DMXSceneDeviceValues p_DMXSceneDeviceValues, DMXFadeDescription.DMXDeviceFadeDescription p_DMXDeviceFadeDescription) {
            if (this.m_DMXDeviceAdjustGroupSceneBridge == null) {
                return;
            }
            if (this.m_LiveShowDMXSceneBridge == null) {
                return;
            }
            long longNextStartFrame = this.m_DMXDeviceAdjustGroupSceneBridge.getNextStartFrame();
            long longSceneBridgeFadeOutEnd = this.m_LiveShowDMXSceneBridge.getFrameStart() + this.m_LiveShowDMXSceneBridge.getFrameFadeOutLength();
            long longSceneBridgeFadeInStart = this.m_LiveShowDMXSceneBridge.getFrameStart() + this.m_LiveShowDMXSceneBridge.getFrameLength() - this.m_LiveShowDMXSceneBridge.getFrameFadeInLength();
            if (longSceneBridgeFadeInStart >= longSceneBridgeFadeOutEnd) {
                this.m_AdjustmentIsActive = true;
            } else if (longNextStartFrame >= this.m_LiveShowDMXSceneBridge.getFrameStart() + this.m_LiveShowDMXSceneBridge.getFrameFadeOutLength()) {
                this.m_AdjustmentIsActive = true;
            } else {
                this.m_AdjustmentIsActive = false;
                return;
            }
            this.m_DMXSceneDeviceValues = p_DMXSceneDeviceValues;
            long longStart = this.m_LiveShowDMXSceneBridge.getFrameStart() + this.m_LiveShowDMXSceneBridge.getFrameFadeOutOffset();
            long longCrossover = longNextStartFrame - (this.m_LiveShowDMXSceneBridge.getFrameStart() + this.m_LiveShowDMXSceneBridge.getFrameFadeOutLength());
            longCrossover = this.correctCrossover(longCrossover);
            if (longCrossover < 0L) {
                this.m_AdjustmentIsActive = false;
                return;
            }
            long longLength = this.m_LiveShowDMXSceneBridge.getFrameFadeOutLength() - this.m_LiveShowDMXSceneBridge.getFrameFadeOutOffset() + longCrossover;
            long longFadeInLength = this.m_LiveShowDMXSceneBridge.getFrameFadeOutLength() - this.m_LiveShowDMXSceneBridge.getFrameFadeOutOffset();
            long longFadeOutLength = longCrossover;
            long longDistanceFadeRest = longNextStartFrame - longStart - longFadeInLength - longFadeOutLength;
            long longDelay = this.correctDelay(longDistanceFadeRest);
            longLength += longDelay;
            if (longCrossover > 2L * CROSSOVERCORRECTIONFRAMES) {
                longLength -= CROSSOVERCORRECTIONFRAMES;
                longFadeOutLength -= 2L * CROSSOVERCORRECTIONFRAMES;
            }
            this.m_Description.setFrameStart(longStart);
            this.m_Description.setFrameLength(longLength);
            this.m_Description.setFrameFadeInLength(longFadeInLength);
            this.m_Description.setFrameFadeOutLength(longFadeOutLength);
            this.calculateFadeDescription(p_DMXDeviceFadeDescription);
        }

        private void calculateFadeDescription(DMXFadeDescription.DMXDeviceFadeDescription p_DMXDeviceFadeDescription) {
            if (p_DMXDeviceFadeDescription == null) {
                return;
            }
            DMXDevice o_DMXDevice = this.m_DMXDevice;
            if (o_DMXDevice == null) {
                return;
            }
            DMXFadeDescription o_DMXFadeDescription = this.getDMXFadeDescription();
            if (o_DMXFadeDescription == null) {
                return;
            }
            DMXFadeDescription.DMXDeviceFadeDescription o_DMXDeviceFadeDescription = p_DMXDeviceFadeDescription;
            if (o_DMXDeviceFadeDescription == null) {
                return;
            }
            DMXFadeDescription.DMXDeviceFadeDescription o_DMXDeviceFadeDescriptionSelf = o_DMXFadeDescription.getDMXDeviceFadeDescription(o_DMXDevice.getID());
            if (o_DMXDeviceFadeDescriptionSelf == null) {
                return;
            }
            for (int intDMXControlType = 0; intDMXControlType < o_DMXDevice.getDMXControlComponentCount(); ++intDMXControlType) {
                DMXFadeDescription.DMXControlTypeFadeDescription o_DMXControlTypeFadeDescriptionSelf;
                DMXFadeDescription.DMXControlTypeFadeDescription o_DMXControlTypeFadeDescription;
                DMXControlComponent.DMXControlType o_DMXControlType;
                boolean boolChecked = false;
                DMXDeviceType o_DMXDeviceType = o_DMXDevice.getDMXDeviceType();
                if (o_DMXDeviceType == null || (o_DMXControlType = o_DMXDeviceType.getDMXControlType(intDMXControlType)) == null || (o_DMXControlTypeFadeDescription = o_DMXDeviceFadeDescription.getDMXControlTypeFadeDescription(o_DMXControlType.getID())) == null || (o_DMXControlTypeFadeDescriptionSelf = o_DMXDeviceFadeDescriptionSelf.getDMXControlTypeFadeDescription(o_DMXControlType.getID())) == null) continue;
                if (o_DMXDevice.isDimmer_DMXControlTypeID(o_DMXControlType.getID())) {
                    o_DMXControlTypeFadeDescriptionSelf.setDisabled(true);
                    boolChecked = true;
                }
                if (!boolChecked && o_DMXDevice.isDimmerSubstitute_DMXControlTypeID(o_DMXControlType.getID())) {
                    o_DMXControlTypeFadeDescriptionSelf.setDisabled(true);
                    boolChecked = true;
                }
                if (!boolChecked) {
                    o_DMXControlTypeFadeDescriptionSelf.setDisabled(o_DMXControlTypeFadeDescription.getDisabled());
                    if (o_DMXControlTypeFadeDescription.getDisabledAdjustment()) {
                        o_DMXControlTypeFadeDescriptionSelf.setDisabled(true);
                        o_DMXControlTypeFadeDescriptionSelf.setDisabledAdjustment(true);
                        boolChecked = true;
                    } else {
                        o_DMXControlTypeFadeDescriptionSelf.setDisabledAdjustment(false);
                    }
                }
                o_DMXControlTypeFadeDescriptionSelf.setFadeIn_Start(o_DMXControlTypeFadeDescription.getFadeOut_Start());
                o_DMXControlTypeFadeDescriptionSelf.setFadeIn_End(o_DMXControlTypeFadeDescription.getFadeOut_End());
                o_DMXControlTypeFadeDescriptionSelf.setFadeOut_Start(0.0f);
                o_DMXControlTypeFadeDescriptionSelf.setFadeOut_End(1.0f);
                for (int intControlType = 0; intControlType < o_DMXControlType.getControlTypeCount(); ++intControlType) {
                    DMXControlComponent.ControlType o_ControlType = o_DMXControlType.getControlType(intControlType);
                    if (o_ControlType == null) continue;
                    for (int intDimension = 0; intDimension < o_ControlType.getControlDimensionTypeCount(); ++intDimension) {
                        int intFadeValueMax = o_DMXControlTypeFadeDescription.getFadeValue(1, 0, intControlType, intDimension);
                        int intFadeValueMin = o_DMXControlTypeFadeDescription.getFadeValue(1, 1, intControlType, intDimension);
                        double doubleSceneValue = this.m_DMXSceneDeviceValues.getValueDMXDevice(o_DMXControlType, intControlType, intDimension);
                        if (doubleSceneValue < (double)intFadeValueMax) {
                            intFadeValueMax = (int)doubleSceneValue;
                        }
                        o_DMXControlTypeFadeDescriptionSelf.setFadeValue(intFadeValueMax, 1, 0, intControlType, intDimension);
                        o_DMXControlTypeFadeDescriptionSelf.setFadeValue(intFadeValueMin, 1, 1, intControlType, intDimension);
                        intFadeValueMin = o_DMXControlTypeFadeDescription.getFadeValue(0, 0, intControlType, intDimension);
                        intFadeValueMax = o_DMXControlTypeFadeDescription.getFadeValue(0, 1, intControlType, intDimension);
                        if (doubleSceneValue < (double)intFadeValueMax) {
                            intFadeValueMax = (int)doubleSceneValue;
                        }
                        o_DMXControlTypeFadeDescriptionSelf.setFadeValue(intFadeValueMin, 0, 0, intControlType, intDimension);
                        o_DMXControlTypeFadeDescriptionSelf.setFadeValue(intFadeValueMax, 0, 1, intControlType, intDimension);
                    }
                }
            }
        }
    }

    public static class DMXDeviceAdjustObject
    extends LiveShowDMXObject {
        public static ArrayList<DMXDeviceAdjustObject> s_DMXDeviceAdjustObjectsPool = new ArrayList();
        public static Object s_SyncDMXDeviceAdjustObjects = new Object();
        protected DMXDeviceAdjustGroup m_DMXDeviceAdjustGroup;
        protected DMXDeviceAdjustment m_DMXDeviceAdjustment;
        protected LiveShowDMXVIP m_LiveShowDMXVIP;
        protected LiveShowDMXObject m_LiveShowDMXObject;
        protected LiveShowDMXSceneBridge m_LiveShowDMXSceneBridge;
        protected DMXScene.DMXSceneDeviceValues m_DMXSceneDeviceValues;
        protected DMXDevice m_DMXDevice;
        protected boolean m_IsStartAdjustment;
        protected boolean m_AdjustmentIsActive;
        protected LiveShowDMXSceneBridge m_BelongingToSceneBridge;
        protected LiveCloseSemaphore m_LiveCloseSemaphore;
        protected static LiveShowDMXObjectDescription s_StandardLiveShowDMXObjectDescription = new LiveShowDMXObjectDescription(null);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static DMXDeviceAdjustObject poolGet(DMXDeviceAdjustGroup p_DMXDeviceAdjustGroup, LiveShowDMXObject p_LiveShowDMXObject, LiveShowDMXSceneBridge p_LiveShowDMXSceneBridge, boolean p_IsStartAjustment) {
            DMXDeviceAdjustObject o_DMXDeviceAdjustObject;
            String stringDMXDeviceID = "";
            Object object = s_SyncDMXDeviceAdjustObjects;
            synchronized (object) {
                DMXDevice o_DMXDevice;
                if (p_DMXDeviceAdjustGroup != null && (o_DMXDevice = p_DMXDeviceAdjustGroup.getDMXDevice()) != null) {
                    stringDMXDeviceID = o_DMXDevice.getID();
                }
                s_StandardLiveShowDMXObjectDescription.setDMXDeviceID(stringDMXDeviceID);
                s_StandardLiveShowDMXObjectDescription.reactivate(true);
                if (s_DMXDeviceAdjustObjectsPool.size() > 0) {
                    int intIndex = s_DMXDeviceAdjustObjectsPool.size() - 1;
                    o_DMXDeviceAdjustObject = s_DMXDeviceAdjustObjectsPool.get(intIndex);
                    o_DMXDeviceAdjustObject.reactivate(s_StandardLiveShowDMXObjectDescription);
                    o_DMXDeviceAdjustObject.setParams(p_DMXDeviceAdjustGroup, p_LiveShowDMXObject, p_LiveShowDMXSceneBridge, p_IsStartAjustment);
                    s_DMXDeviceAdjustObjectsPool.remove(intIndex);
                } else {
                    o_DMXDeviceAdjustObject = new DMXDeviceAdjustObject(p_DMXDeviceAdjustGroup, p_LiveShowDMXObject, p_LiveShowDMXSceneBridge, p_IsStartAjustment);
                }
            }
            return o_DMXDeviceAdjustObject;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void poolAddEmpty(DMXDeviceAdjustObject p_DMXDeviceAdjustObject) {
            if (p_DMXDeviceAdjustObject == null) {
                return;
            }
            Object object = s_SyncDMXDeviceAdjustObjects;
            synchronized (object) {
                if (s_DMXDeviceAdjustObjectsPool.size() < 5000) {
                    s_DMXDeviceAdjustObjectsPool.add(p_DMXDeviceAdjustObject);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void poolClear() {
            Object object = s_SyncDMXDeviceAdjustObjects;
            synchronized (object) {
                s_DMXDeviceAdjustObjectsPool.clear();
            }
        }

        public DMXDeviceAdjustObject(DMXDeviceAdjustGroup p_DMXDeviceAdjustGroup, LiveShowDMXObject p_LiveShowDMXObject, LiveShowDMXSceneBridge p_LiveShowDMXSceneBridge, boolean p_IsStartAjustment) {
            super(s_StandardLiveShowDMXObjectDescription);
            this.initMembers();
            this.setParams(p_DMXDeviceAdjustGroup, p_LiveShowDMXObject, p_LiveShowDMXSceneBridge, p_IsStartAjustment);
        }

        @Override
        public DMXDevice getOnlyForDMXDevice() {
            return this.m_DMXDevice;
        }

        public void setParams(DMXDeviceAdjustGroup p_DMXDeviceAdjustGroup, LiveShowDMXObject p_LiveShowDMXObject, LiveShowDMXSceneBridge p_LiveShowDMXSceneBridge, boolean p_IsStartAjustment) {
            super.setDescription(s_StandardLiveShowDMXObjectDescription);
            this.m_AdjustmentIsActive = false;
            this.m_DMXDeviceAdjustGroup = p_DMXDeviceAdjustGroup;
            if (this.m_DMXDeviceAdjustGroup != null) {
                this.m_DMXDeviceAdjustment = this.m_DMXDeviceAdjustGroup.getDMXDeviceAdjustment();
                if (this.m_DMXDeviceAdjustment != null) {
                    this.m_LiveShowDMXVIP = this.m_DMXDeviceAdjustment.getLiveShowDMXVIP();
                }
                this.m_DMXDevice = this.m_DMXDeviceAdjustGroup.getDMXDevice();
            } else {
                this.m_DMXDevice = null;
            }
            this.m_LiveShowDMXObject = p_LiveShowDMXObject;
            this.m_LiveShowDMXSceneBridge = p_LiveShowDMXSceneBridge;
            this.m_IsStartAdjustment = p_IsStartAjustment;
            this.refreshDMXScene();
        }

        private void initMembers() {
            this.setObjectType(13);
            this.m_LiveCloseSemaphore = new LiveCloseSemaphore(this.getClass().getSimpleName());
        }

        @Override
        public void close(boolean p_Finish) {
            if (!this.m_LiveCloseSemaphore.enterCloseSection()) {
                return;
            }
            super.close(p_Finish);
            this.m_LiveShowDMXObject = null;
            this.m_DMXDevice = null;
            this.m_LiveCloseSemaphore.leaveCloseSection();
            if (!(this instanceof DMXDeviceAdjustObjectSceneBridge)) {
                DMXDeviceAdjustObject.poolAddEmpty(this);
            }
        }

        public void reactivate(LiveShowDMXObjectDescription p_LiveShowDMXObjectDescription) {
            this.m_LiveCloseSemaphore.refresh();
            super.reactivate(p_LiveShowDMXObjectDescription);
        }

        public void refreshDMXScene() {
            LiveShowDMXObject o_LiveShowDMXObject = this.m_LiveShowDMXObject;
            DMXDevice o_DMXDevice = this.m_DMXDevice;
            if (o_LiveShowDMXObject != null && o_DMXDevice != null) {
                DMXScene o_DMXScene = o_LiveShowDMXObject.getDMXScene();
                if (o_DMXScene == null) {
                    return;
                }
                super.setDMXScene(o_DMXScene);
                DMXScene.DMXSceneValueContainer o_DMXSceneValueContainer = o_DMXScene.getDMXSceneValueContainer();
                if (o_DMXSceneValueContainer != null) {
                    this.m_DMXSceneDeviceValues = o_DMXSceneValueContainer.getDMXSceneDeviceValues(o_DMXDevice.getID());
                }
            }
        }

        public void setAdjustmentActive(boolean p_Active) {
            this.m_AdjustmentIsActive = p_Active;
        }

        public long correctCrossover(long p_FrameLength) {
            LiveShowDMXVIP o_LiveShowDMXVIP = this.m_LiveShowDMXVIP;
            if (o_LiveShowDMXVIP == null) {
                return p_FrameLength;
            }
            double doubleFrameTime = o_LiveShowDMXVIP.getFrameTime();
            if (doubleFrameTime <= 0.0) {
                return p_FrameLength;
            }
            if ((double)p_FrameLength > (double)TIMEFORADKUSTMENT / doubleFrameTime) {
                p_FrameLength = (long)((double)TIMEFORADKUSTMENT / doubleFrameTime);
            }
            return p_FrameLength;
        }

        public long correctDelay(long p_DistanceFadeRest) {
            long longDelay = 0L;
            if (ADJUSTMENTDELAY <= 0L) {
                return 0L;
            }
            longDelay = p_DistanceFadeRest >= ADJUSTMENTDELAY - 2L * LiveShowDMXVIPAdjustment.getAdjustmentCrossoverCorrectionFrames() ? ADJUSTMENTDELAY - 2L * LiveShowDMXVIPAdjustment.getAdjustmentCrossoverCorrectionFrames() : p_DistanceFadeRest - 2L * LiveShowDMXVIPAdjustment.getAdjustmentCrossoverCorrectionFrames();
            if (longDelay < 0L) {
                longDelay = 0L;
            }
            return longDelay;
        }

        public void calculateAdjustment(ArrayList<LiveShowObject> p_StartLiveShowDMXObjects, ArrayList<LiveShowObject> p_LastLiveShowDMXObjects, ArrayList<LiveShowObject> p_LastLiveShowDMXSceneBridges) {
            if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
                return;
            }
            DMXDeviceAdjustGroup o_DMXDeviceAdjustGroup = this.m_DMXDeviceAdjustGroup;
            if (o_DMXDeviceAdjustGroup == null) {
                this.m_LiveCloseSemaphore.leaveWorkerSection();
                return;
            }
            DMXDeviceAdjustment o_DMXDeviceAdjustment = o_DMXDeviceAdjustGroup.getDMXDeviceAdjustment();
            if (o_DMXDeviceAdjustment == null) {
                this.m_LiveCloseSemaphore.leaveWorkerSection();
                return;
            }
            if (this.m_IsStartAdjustment) {
                LiveShowObject o_LiveShowObject_Last;
                long longFrameStart = 0L;
                if (p_LastLiveShowDMXObjects.size() > 0 && (o_LiveShowObject_Last = p_LastLiveShowDMXObjects.get(0)) != null) {
                    longFrameStart = o_LiveShowObject_Last.getFrameEnd();
                }
                this.calculateAdjustmentStart(longFrameStart);
            } else {
                LiveShowDMXVIP o_LiveShowDMXVIP = this.m_LiveShowDMXVIP;
                if (o_LiveShowDMXVIP == null) {
                    this.m_LiveCloseSemaphore.leaveWorkerSection();
                    return;
                }
                LiveShowObject o_LiveShowObject_Start = null;
                long longFrameEnd = o_LiveShowDMXVIP.getFrameEnd();
                if (p_StartLiveShowDMXObjects.size() > 0 && (o_LiveShowObject_Start = p_StartLiveShowDMXObjects.get(0)) != null) {
                    longFrameEnd = o_LiveShowObject_Start.getFrameStart();
                }
                this.calculateAdjustmentEnd(longFrameEnd);
            }
            this.m_LiveCloseSemaphore.leaveWorkerSection();
        }

        public void calculateAdjustmentStart(long p_FrameStart) {
            DMXDeviceAdjustGroup o_DMXDeviceAdjustGroup = this.m_DMXDeviceAdjustGroup;
            DMXDeviceAdjustment o_DMXDeviceAdjustment = this.m_DMXDeviceAdjustment;
            LiveShowDMXVIP o_LiveShowDMXVIP = this.m_LiveShowDMXVIP;
            LiveShowDMXObject o_LiveShowDMXObject = this.m_LiveShowDMXObject;
            if (o_DMXDeviceAdjustGroup == null || o_LiveShowDMXVIP == null || o_DMXDeviceAdjustment == null || o_LiveShowDMXObject == null) {
                return;
            }
            this.refreshDMXScene();
            long longStart = p_FrameStart;
            long longLength = o_LiveShowDMXObject.getFrameStart() - p_FrameStart;
            long longCrossover = this.correctCrossover(longLength);
            if (longCrossover < 0L) {
                this.m_AdjustmentIsActive = false;
                return;
            }
            longLength += o_LiveShowDMXObject.getFrameFadeInLength();
            long longFadeInLength = longCrossover;
            long longFadeOutLength = o_LiveShowDMXObject.getFrameFadeInLength();
            long longDistanceFadeRest = o_LiveShowDMXObject.getFrameStart() - longStart - longFadeInLength - longFadeOutLength;
            long longDelay = this.correctDelay(longDistanceFadeRest);
            longStart += longDelay;
            longLength -= longDelay;
            if (longCrossover > 2L * CROSSOVERCORRECTIONFRAMES) {
                longStart += CROSSOVERCORRECTIONFRAMES;
                longLength -= CROSSOVERCORRECTIONFRAMES;
                longFadeInLength -= 2L * CROSSOVERCORRECTIONFRAMES;
            }
            this.m_Description.setFrameStart(longStart);
            this.m_Description.setFrameLength(longLength);
            this.m_Description.setFrameFadeInLength(longFadeInLength);
            this.m_Description.setFrameFadeOutLength(longFadeOutLength);
            this.calculateFadeDescription(true);
            this.m_BelongingToSceneBridge = this.calculateBelongingSceneBridge(o_LiveShowDMXObject);
            o_DMXDeviceAdjustment.setAdjustmentFrameLast(longStart + longLength);
        }

        public void calculateAdjustmentEnd(long p_FrameEnd) {
            LiveShowDMXObject o_LiveShowDMXObject = this.m_LiveShowDMXObject;
            DMXDeviceAdjustment o_DMXDeviceAdjustment = this.m_DMXDeviceAdjustment;
            if (p_FrameEnd < 0L) {
                return;
            }
            if (this.m_IsStartAdjustment) {
                return;
            }
            if (o_LiveShowDMXObject == null) {
                return;
            }
            if (o_DMXDeviceAdjustment == null) {
                return;
            }
            this.refreshDMXScene();
            long longCrossover = this.correctCrossover(p_FrameEnd - o_LiveShowDMXObject.getFrameEnd());
            if (longCrossover < 0L) {
                this.m_AdjustmentIsActive = false;
                return;
            }
            long longStart = o_LiveShowDMXObject.getFrameEnd() - o_LiveShowDMXObject.getFrameFadeOutLength();
            long longLength = o_LiveShowDMXObject.getFrameFadeOutLength() + longCrossover;
            long longFadeInLength = o_LiveShowDMXObject.getFrameFadeOutLength();
            long longFadeOutLength = longCrossover;
            long longDistanceFadeRest = p_FrameEnd - longStart - longFadeInLength - longFadeOutLength;
            long longDelay = this.correctDelay(longDistanceFadeRest);
            longLength += longDelay;
            if (longCrossover > 2L * CROSSOVERCORRECTIONFRAMES) {
                longLength -= CROSSOVERCORRECTIONFRAMES;
                longFadeOutLength -= 2L * CROSSOVERCORRECTIONFRAMES;
            }
            this.m_Description.setFrameStart(longStart);
            this.m_Description.setFrameLength(longLength);
            this.m_Description.setFrameFadeInLength(longFadeInLength);
            this.m_Description.setFrameFadeOutLength(longFadeOutLength);
            this.calculateFadeDescription(false);
            o_DMXDeviceAdjustment.setAdjustmentFrameLast(longStart + longLength);
        }

        public void calculateAdjustmentInside(LiveShowDMXSceneBridge p_LiveShowDMXSceneBridge) {
            long longFadeOutLength;
            long longFadeInLength;
            long longLength;
            long longStart;
            if (p_LiveShowDMXSceneBridge == null) {
                return;
            }
            LiveShowDMXObject o_LiveShowDMXObject = this.m_LiveShowDMXObject;
            DMXDeviceAdjustment o_DMXDeviceAdjustment = this.m_DMXDeviceAdjustment;
            if (o_LiveShowDMXObject == null || o_DMXDeviceAdjustment == null) {
                return;
            }
            DMXDeviceAdjustGroupSceneBridge o_DMXDeviceAdjustGroupSceneBridge = (DMXDeviceAdjustGroupSceneBridge)this.m_DMXDeviceAdjustGroup;
            this.refreshDMXScene();
            long longSceneBridgeFadeOutEnd = p_LiveShowDMXSceneBridge.getFrameStart() + p_LiveShowDMXSceneBridge.getFrameFadeOutLength();
            long longSceneBridgeFadeInStart = p_LiveShowDMXSceneBridge.getFrameStart() + p_LiveShowDMXSceneBridge.getFrameLength() - p_LiveShowDMXSceneBridge.getFrameFadeInLength();
            if (longSceneBridgeFadeInStart < longSceneBridgeFadeOutEnd) {
                long longCrossover;
                if (o_LiveShowDMXObject.getFrameStart() > longSceneBridgeFadeInStart) {
                    longStart = p_LiveShowDMXSceneBridge.getFrameStart() + p_LiveShowDMXSceneBridge.getFrameFadeOutLength();
                    longLength = o_LiveShowDMXObject.getFrameStart() - longStart + o_LiveShowDMXObject.getFrameFadeInLength();
                    longCrossover = o_LiveShowDMXObject.getFrameStart() - longStart;
                } else {
                    longStart = p_LiveShowDMXSceneBridge.getFrameStart() + p_LiveShowDMXSceneBridge.getFrameFadeOutOffset();
                    longLength = o_LiveShowDMXObject.getFrameStart() - longStart + o_LiveShowDMXObject.getFrameFadeInLength();
                    longCrossover = p_LiveShowDMXSceneBridge.getFrameFadeOutLength() - p_LiveShowDMXSceneBridge.getFrameFadeOutOffset();
                }
                longCrossover = this.correctCrossover(longCrossover);
                if (longCrossover < 0L) {
                    this.m_AdjustmentIsActive = false;
                    return;
                }
                longFadeInLength = longCrossover;
                longFadeOutLength = o_LiveShowDMXObject.getFrameFadeInLength();
                long longDistanceFadeRest = longLength - longFadeOutLength - longFadeInLength;
                long longDelay = this.correctDelay(longDistanceFadeRest);
                longStart += longDelay;
                longLength -= longDelay;
                if (longCrossover > 2L * CROSSOVERCORRECTIONFRAMES) {
                    longStart += CROSSOVERCORRECTIONFRAMES;
                    longLength -= CROSSOVERCORRECTIONFRAMES;
                    longFadeInLength -= 2L * CROSSOVERCORRECTIONFRAMES;
                }
            } else {
                long longCrossover;
                longStart = p_LiveShowDMXSceneBridge.getFrameStart() + p_LiveShowDMXSceneBridge.getFrameFadeOutLength();
                if (o_LiveShowDMXObject.getFrameStart() > longSceneBridgeFadeInStart) {
                    longCrossover = o_LiveShowDMXObject.getFrameStart() - p_LiveShowDMXSceneBridge.getFrameStart() - p_LiveShowDMXSceneBridge.getFrameFadeOutLength();
                    if ((longCrossover = this.correctCrossover(longCrossover)) < 0L) {
                        this.m_AdjustmentIsActive = false;
                        return;
                    }
                    longFadeInLength = longCrossover;
                    longLength = o_LiveShowDMXObject.getFrameStart() - p_LiveShowDMXSceneBridge.getFrameStart() - p_LiveShowDMXSceneBridge.getFrameFadeOutLength() + this.m_LiveShowDMXObject.getFrameFadeInLength();
                    longFadeOutLength = o_LiveShowDMXObject.getFrameFadeInLength();
                } else {
                    longCrossover = p_LiveShowDMXSceneBridge.getFrameLength() - p_LiveShowDMXSceneBridge.getFrameFadeOutLength() - p_LiveShowDMXSceneBridge.getFrameFadeInLength();
                    if ((longCrossover = this.correctCrossover(longCrossover)) < 0L) {
                        this.m_AdjustmentIsActive = false;
                        return;
                    }
                    longFadeInLength = longCrossover;
                    longLength = p_LiveShowDMXSceneBridge.getFrameLength() - p_LiveShowDMXSceneBridge.getFrameFadeOutLength() - p_LiveShowDMXSceneBridge.getFrameFadeInOffset();
                    longFadeOutLength = p_LiveShowDMXSceneBridge.getFrameFadeInLength() - p_LiveShowDMXSceneBridge.getFrameFadeInOffset();
                }
                long longDistanceFadeRest = longLength - longFadeOutLength - longFadeInLength;
                long longDelay = this.correctDelay(longDistanceFadeRest);
                longStart += longDelay;
                longLength -= longDelay;
                if (longCrossover > 2L * CROSSOVERCORRECTIONFRAMES) {
                    longStart += CROSSOVERCORRECTIONFRAMES;
                    longLength -= CROSSOVERCORRECTIONFRAMES;
                    longFadeInLength -= 2L * CROSSOVERCORRECTIONFRAMES;
                }
            }
            this.m_Description.setFrameStart(longStart);
            this.m_Description.setFrameLength(longLength);
            this.m_Description.setFrameFadeInLength(longFadeInLength);
            this.m_Description.setFrameFadeOutLength(longFadeOutLength);
            this.calculateFadeDescription(true);
            o_DMXDeviceAdjustment.setAdjustmentFrameLast(longStart + longLength);
        }

        public void calculateAdjustmentPre(LiveShowDMXSceneBridge p_LiveShowDMXSceneBridge, long p_PreviousFrame) {
            LiveShowDMXObject o_LiveShowDMXObject = this.m_LiveShowDMXObject;
            DMXDeviceAdjustment o_DMXDeviceAdjustment = this.m_DMXDeviceAdjustment;
            LiveShowDMXVIP o_LiveShowDMXVIP = this.m_LiveShowDMXVIP;
            if (o_LiveShowDMXObject == null || o_DMXDeviceAdjustment == null || o_LiveShowDMXVIP == null) {
                return;
            }
            this.refreshDMXScene();
            long longStart = p_PreviousFrame;
            long longLength = p_LiveShowDMXSceneBridge.getFrameStart() - p_PreviousFrame;
            long longCrossover = this.correctCrossover(longLength);
            if (longCrossover < 0L) {
                this.m_AdjustmentIsActive = false;
                return;
            }
            long longFadeInLength = longCrossover;
            long longFadeOutLength = 0L;
            long longDistanceFadeRest = p_LiveShowDMXSceneBridge.getFrameStart() - longStart - longFadeInLength - longFadeOutLength;
            long longDelay = this.correctDelay(longDistanceFadeRest);
            longStart += longDelay;
            longLength -= longDelay;
            if (longCrossover > 2L * CROSSOVERCORRECTIONFRAMES) {
                longStart += CROSSOVERCORRECTIONFRAMES;
                longLength -= CROSSOVERCORRECTIONFRAMES;
                longFadeInLength -= 2L * CROSSOVERCORRECTIONFRAMES;
            }
            this.m_Description.setFrameStart(longStart);
            this.m_Description.setFrameLength(longLength);
            this.m_Description.setFrameFadeInLength(longFadeInLength);
            this.m_Description.setFrameFadeOutLength(longFadeOutLength);
            this.calculateFadeDescription(true);
            this.m_BelongingToSceneBridge = this.calculateBelongingSceneBridge(o_LiveShowDMXObject);
            o_DMXDeviceAdjustment.setAdjustmentFrameLast(longStart + longLength);
        }

        private void calculateFadeDescription(boolean p_Start) {
            LiveShowDMXObject o_LiveShowDMXObject = this.m_LiveShowDMXObject;
            DMXDevice o_DMXDevice = this.m_DMXDevice;
            if (o_LiveShowDMXObject == null || o_DMXDevice == null) {
                return;
            }
            DMXFadeDescription o_DMXFadeDescription = o_LiveShowDMXObject.getDMXFadeDescription();
            DMXFadeDescription o_DMXFadeDescriptionSelf = this.getDMXFadeDescription();
            if (o_DMXFadeDescription == null) {
                return;
            }
            if (o_DMXFadeDescriptionSelf == null) {
                return;
            }
            DMXFadeDescription.DMXDeviceFadeDescription o_DMXDeviceFadeDescription = o_DMXFadeDescription.getDMXDeviceFadeDescription(o_DMXDevice.getID());
            DMXFadeDescription.DMXDeviceFadeDescription o_DMXDeviceFadeDescriptionSelf = o_DMXFadeDescriptionSelf.getDMXDeviceFadeDescription(o_DMXDevice.getID());
            if (o_DMXDeviceFadeDescription == null) {
                return;
            }
            if (o_DMXDeviceFadeDescriptionSelf == null) {
                return;
            }
            for (int intDMXControlType = 0; intDMXControlType < o_DMXDevice.getDMXControlComponentCount(); ++intDMXControlType) {
                int intFadeValueMax;
                double doubleSceneValue;
                int intFadeValueMin;
                int intDimension;
                DMXControlComponent.ControlType o_ControlType;
                int intControlType;
                boolean boolChecked = false;
                DMXControlComponent.DMXControlType o_DMXControlType = o_DMXDevice.getDMXDeviceType().getDMXControlType(intDMXControlType);
                if (o_DMXControlType == null) continue;
                DMXFadeDescription.DMXControlTypeFadeDescription o_DMXControlTypeFadeDescription = o_DMXDeviceFadeDescription.getDMXControlTypeFadeDescription(o_DMXControlType.getID());
                DMXFadeDescription.DMXControlTypeFadeDescription o_DMXControlTypeFadeDescriptionSelf = o_DMXDeviceFadeDescriptionSelf.getDMXControlTypeFadeDescription(o_DMXControlType.getID());
                if (o_DMXControlTypeFadeDescription == null || o_DMXControlTypeFadeDescriptionSelf == null) continue;
                if (o_DMXDevice.isDimmer_DMXControlTypeID(o_DMXControlType.getID())) {
                    o_DMXControlTypeFadeDescriptionSelf.setDisabled(true);
                    boolChecked = true;
                }
                if (!boolChecked && o_DMXDevice.isDimmerSubstitute_DMXControlTypeID(o_DMXControlType.getID())) {
                    o_DMXControlTypeFadeDescriptionSelf.setDisabled(true);
                    boolChecked = true;
                }
                if (!boolChecked) {
                    o_DMXControlTypeFadeDescriptionSelf.setDisabled(o_DMXControlTypeFadeDescription.getDisabled());
                    if (o_DMXControlTypeFadeDescription.getDisabledAdjustment()) {
                        o_DMXControlTypeFadeDescriptionSelf.setDisabled(true);
                        o_DMXControlTypeFadeDescriptionSelf.setDisabledAdjustment(true);
                    } else {
                        o_DMXControlTypeFadeDescriptionSelf.setDisabledAdjustment(false);
                    }
                }
                if (!p_Start) {
                    o_DMXControlTypeFadeDescriptionSelf.setFadeIn_Start(o_DMXControlTypeFadeDescription.getFadeOut_Start());
                    o_DMXControlTypeFadeDescriptionSelf.setFadeIn_End(o_DMXControlTypeFadeDescription.getFadeOut_End());
                    o_DMXControlTypeFadeDescriptionSelf.setFadeOut_Start(0.0f);
                    o_DMXControlTypeFadeDescriptionSelf.setFadeOut_End(1.0f);
                    for (intControlType = 0; intControlType < o_DMXControlType.getControlTypeCount(); ++intControlType) {
                        o_ControlType = o_DMXControlType.getControlType(intControlType);
                        if (o_ControlType == null) continue;
                        for (intDimension = 0; intDimension < o_ControlType.getControlDimensionTypeCount(); ++intDimension) {
                            intFadeValueMin = o_DMXControlTypeFadeDescription.getFadeValue(1, 1, intControlType, intDimension);
                            doubleSceneValue = this.m_DMXSceneDeviceValues == null ? 0.0 : this.m_DMXSceneDeviceValues.getValueDMXDevice(o_DMXControlType, intControlType, intDimension);
                            if (doubleSceneValue < (double)(intFadeValueMax = o_DMXControlTypeFadeDescription.getFadeValue(1, 0, intControlType, intDimension))) {
                                intFadeValueMax = (int)doubleSceneValue;
                            }
                            o_DMXControlTypeFadeDescriptionSelf.setFadeValue(intFadeValueMax, 1, 0, intControlType, intDimension);
                            o_DMXControlTypeFadeDescriptionSelf.setFadeValue(intFadeValueMin, 1, 1, intControlType, intDimension);
                            intFadeValueMin = o_DMXControlTypeFadeDescription.getFadeValue(0, 0, intControlType, intDimension);
                            intFadeValueMax = o_DMXControlTypeFadeDescription.getFadeValue(0, 1, intControlType, intDimension);
                            o_DMXControlTypeFadeDescriptionSelf.setFadeValue(intFadeValueMin, 0, 0, intControlType, intDimension);
                            o_DMXControlTypeFadeDescriptionSelf.setFadeValue(intFadeValueMax, 0, 1, intControlType, intDimension);
                        }
                    }
                    continue;
                }
                o_DMXControlTypeFadeDescriptionSelf.setFadeIn_Start(0.0f);
                o_DMXControlTypeFadeDescriptionSelf.setFadeIn_End(1.0f);
                o_DMXControlTypeFadeDescriptionSelf.setFadeOut_Start(o_DMXControlTypeFadeDescription.getFadeIn_Start());
                o_DMXControlTypeFadeDescriptionSelf.setFadeOut_End(o_DMXControlTypeFadeDescription.getFadeIn_End());
                for (intControlType = 0; intControlType < o_DMXControlType.getControlTypeCount(); ++intControlType) {
                    o_ControlType = o_DMXControlType.getControlType(intControlType);
                    if (o_ControlType == null) continue;
                    for (intDimension = 0; intDimension < o_ControlType.getControlDimensionTypeCount(); ++intDimension) {
                        intFadeValueMax = o_DMXControlTypeFadeDescription.getFadeValue(0, 1, intControlType, intDimension);
                        intFadeValueMin = o_DMXControlTypeFadeDescription.getFadeValue(0, 0, intControlType, intDimension);
                        doubleSceneValue = this.m_DMXSceneDeviceValues == null ? 0.0 : this.m_DMXSceneDeviceValues.getValueDMXDevice(o_DMXControlType, intControlType, intDimension);
                        if (doubleSceneValue < (double)intFadeValueMax) {
                            intFadeValueMax = (int)doubleSceneValue;
                        }
                        o_DMXControlTypeFadeDescriptionSelf.setFadeValue(intFadeValueMin, 0, 0, intControlType, intDimension);
                        o_DMXControlTypeFadeDescriptionSelf.setFadeValue(intFadeValueMax, 0, 1, intControlType, intDimension);
                        intFadeValueMin = o_DMXControlTypeFadeDescription.getFadeValue(1, 1, intControlType, intDimension);
                        intFadeValueMax = o_DMXControlTypeFadeDescription.getFadeValue(1, 0, intControlType, intDimension);
                        if (doubleSceneValue < (double)intFadeValueMax) {
                            intFadeValueMax = (int)doubleSceneValue;
                        }
                        o_DMXControlTypeFadeDescriptionSelf.setFadeValue(intFadeValueMax, 1, 0, intControlType, intDimension);
                        o_DMXControlTypeFadeDescriptionSelf.setFadeValue(intFadeValueMin, 1, 1, intControlType, intDimension);
                    }
                }
            }
        }

        public LiveShowDMXSceneBridge calculateBelongingSceneBridge(LiveShowDMXObject p_LiveShowDMXObject) {
            if (p_LiveShowDMXObject == null) {
                return null;
            }
            LiveShowDMXVIP o_LiveShowDMXVIP = this.m_LiveShowDMXVIP;
            if (o_LiveShowDMXVIP == null) {
                return null;
            }
            boolean boolOnlyCheckMainBridges = false;
            LiveShowDMXSceneBridge o_LiveShowDMXSceneBridge = (LiveShowDMXSceneBridge)o_LiveShowDMXVIP.getLiveShowSceneBridge_Position(p_LiveShowDMXObject.getFrameStart(), true, false);
            if (o_LiveShowDMXSceneBridge != null && !o_LiveShowDMXSceneBridge.getActive()) {
                boolOnlyCheckMainBridges = true;
            }
            if (!boolOnlyCheckMainBridges) {
                o_LiveShowDMXSceneBridge = (LiveShowDMXSceneBridge)o_LiveShowDMXVIP.getLiveShowSceneBridge_Position(p_LiveShowDMXObject.getFrameStart(), false, false);
            }
            if (o_LiveShowDMXSceneBridge != null && !o_LiveShowDMXSceneBridge.getActive()) {
                o_LiveShowDMXSceneBridge = (LiveShowDMXSceneBridge)o_LiveShowDMXVIP.getLiveShowSceneBridge_Next(p_LiveShowDMXObject.getFrameStart(), boolOnlyCheckMainBridges, true);
            }
            return o_LiveShowDMXSceneBridge;
        }

        public LiveShowDMXObject getLiveShowDMXObject() {
            return this.m_LiveShowDMXObject;
        }

        public LiveShowDMXSceneBridge getLiveShowDMXSceneBridge() {
            return this.m_LiveShowDMXSceneBridge;
        }

        public LiveShowDMXSceneBridge getBelongingToSceneBridge() {
            return this.m_BelongingToSceneBridge;
        }

        public boolean getIsStartObject() {
            return this.m_IsStartAdjustment;
        }

        @Override
        public Playable.PlayObject read(Play p_Play, Playable.PlayObject p_PlayObject, LiveShowSceneBridge p_LiveShowSceneBridge, long p_SceneBridgeFrameInside, double p_SceneBridgeFadeProgress, boolean p_IsPreObject) {
            DMXEffect o_DMXEffect;
            if (p_PlayObject == null) {
                return null;
            }
            if (!this.m_AdjustmentIsActive) {
                return null;
            }
            DMXDeviceAdjustGroup o_DMXDeviceAdjustGroup = this.m_DMXDeviceAdjustGroup;
            DMXDevice o_DMXDevice = this.m_DMXDevice;
            if (o_DMXDevice == null || o_DMXDeviceAdjustGroup == null) {
                return null;
            }
            boolean boolFadeIn = false;
            boolean boolFadeOut = false;
            if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
                return p_PlayObject;
            }
            PlayDMX.DMXPlayObject o_DMXPlayObject = (PlayDMX.DMXPlayObject)p_PlayObject;
            long longFramePosition = p_PlayObject.getFramePosition();
            long longFramesToRead = p_PlayObject.getFramesToRead();
            if (longFramePosition < this.m_Description.getFrameStart()) {
                if (this.m_IsStartAdjustment && this.m_BelongingToSceneBridge != null) {
                    boolean boolCheckReadNext = true;
                    if (o_DMXDeviceAdjustGroup instanceof DMXDeviceAdjustGroupSceneBridge && ((DMXDeviceAdjustGroupSceneBridge)o_DMXDeviceAdjustGroup).m_DMXDeviceAdjustObjectsPost.contains(this)) {
                        boolCheckReadNext = false;
                    }
                    if (boolCheckReadNext) {
                        o_DMXDeviceAdjustGroup.checkDMXDeviceAdjustObject_ReadNext(this);
                    }
                }
                this.m_LiveCloseSemaphore.leaveWorkerSection();
                return null;
            }
            if (longFramePosition >= this.m_Description.getFrameStart() + this.m_Description.getFrameLength()) {
                this.m_LiveCloseSemaphore.leaveWorkerSection();
                return null;
            }
            boolean boolInside = false;
            double doubleFadeInFactor = 1.0;
            double doubleFadeOutFactor = 0.0;
            double doubleFadeProgress = 1.0;
            float floatVolumeFactor = 1.0f;
            long longFramePositionInside = longFramePosition - this.m_Description.getFrameStart();
            if (longFramePositionInside > 0L || longFramePositionInside < this.m_Description.getFrameLength()) {
                boolInside = true;
            }
            if (boolInside) {
                floatVolumeFactor = this.m_Description.getVolumeFactor_Linear();
                doubleFadeInFactor = 1.0;
                if (this.m_Description.getFrameFadeInLength() > 0L && longFramePositionInside < this.m_Description.getFrameFadeInLength()) {
                    doubleFadeInFactor = p_Play.getWillStopAtSceneBridge() != null ? 1.0 : (double)longFramePositionInside / (double)this.m_Description.getFrameFadeInLength();
                    if (doubleFadeInFactor < 0.0) {
                        doubleFadeInFactor = 0.0;
                    }
                    if (doubleFadeInFactor > 1.0) {
                        doubleFadeInFactor = 1.0;
                    }
                    doubleFadeProgress = doubleFadeInFactor;
                    boolFadeIn = true;
                }
                doubleFadeOutFactor = 1.0;
                long longFrameFromEndPosition = this.m_Description.getFrameLength() - longFramePositionInside;
                if (this.m_Description.getFrameFadeOutLength() > 0L && longFrameFromEndPosition < this.m_Description.getFrameFadeOutLength()) {
                    doubleFadeOutFactor = (double)longFrameFromEndPosition / (double)this.m_Description.getFrameFadeOutLength();
                    if (doubleFadeOutFactor < 0.0) {
                        doubleFadeOutFactor = 0.0;
                    }
                    if (doubleFadeOutFactor > 1.0) {
                        doubleFadeOutFactor = 1.0;
                    }
                    doubleFadeProgress = doubleFadeOutFactor;
                    boolFadeOut = true;
                }
            }
            DMXScene.DMXSceneValueContainer o_PlayObjectValueContainer = o_DMXPlayObject.getDMXSceneValueContainer();
            DMXScene.DMXSceneDeviceValues o_PlayDMXSceneDeviceValues = o_PlayObjectValueContainer.getDMXSceneDeviceValues(o_DMXDevice.getID());
            o_PlayObjectValueContainer.setFadeInProgress(doubleFadeInFactor);
            o_PlayObjectValueContainer.setFadeOutProgress(doubleFadeOutFactor);
            o_PlayObjectValueContainer.setFadeProgress(doubleFadeProgress);
            boolean boolReadScene = true;
            LiveShowDMXObject o_LiveShowDMXObject = this.m_LiveShowDMXObject;
            if (o_LiveShowDMXObject != null && (o_DMXEffect = this.m_LiveShowDMXObject.getDMXEffect()) != null) {
                o_DMXEffect.readAdjustment(this.m_IsStartAdjustment, this, o_DMXPlayObject, longFramePositionInside, this.m_DMXSceneDeviceValues, floatVolumeFactor, doubleFadeProgress, boolFadeIn, boolFadeOut);
                boolReadScene = false;
            }
            if (boolReadScene) {
                o_PlayDMXSceneDeviceValues.fillPlayObject(true, this.m_DMXSceneDeviceValues, this, floatVolumeFactor, this.getDMXFadeDescription(), doubleFadeProgress, boolFadeIn, boolFadeOut);
            }
            this.m_LiveCloseSemaphore.leaveWorkerSection();
            if (this.m_IsStartAdjustment && boolInside && this.m_BelongingToSceneBridge != null) {
                o_DMXDeviceAdjustGroup.checkDMXDeviceAdjustObject_ReadNext(this);
                if (this.getFrameLength() <= 0L) {
                    return null;
                }
                return o_DMXPlayObject;
            }
            return null;
        }
    }

    public static class DMXDeviceAdjustGroupSceneBridge
    extends DMXDeviceAdjustGroup {
        private static Object s_SyncObjectPool = new Object();
        private static ArrayList<DMXDeviceAdjustGroupSceneBridge> s_DMXDeviceAdjustGroupSceneBridgePool = new ArrayList();
        private LiveShowDMXSceneBridge m_LiveShowDMXSceneBridge;
        private DMXDeviceAdjustObjectSceneBridge m_DMXDeviceAdjustObjectStart;
        private ArrayList<DMXDeviceAdjustObject> m_DMXDeviceAdjustObjectsPre;
        private ArrayList<DMXDeviceAdjustObject> m_DMXDeviceAdjustObjectsPost;
        private long m_NextStartFrame;
        private final Object m_SyncPlay = new Object();
        private boolean m_Closed;
        private final Object m_SyncObject = new Object();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static DMXDeviceAdjustGroupSceneBridge poolGet(DMXDeviceAdjustment p_DMXDeviceAdjustment, LiveShowDMXSceneBridge p_LiveShowDMXSceneBridge) {
            DMXDeviceAdjustGroupSceneBridge o_DMXDeviceAdjustGroupSceneBridge;
            Object object = s_SyncObjectPool;
            synchronized (object) {
                if (s_DMXDeviceAdjustGroupSceneBridgePool.size() > 0) {
                    int intIndex = s_DMXDeviceAdjustGroupSceneBridgePool.size() - 1;
                    o_DMXDeviceAdjustGroupSceneBridge = s_DMXDeviceAdjustGroupSceneBridgePool.get(intIndex);
                    o_DMXDeviceAdjustGroupSceneBridge.reactivate();
                    o_DMXDeviceAdjustGroupSceneBridge.setParams(p_DMXDeviceAdjustment, p_LiveShowDMXSceneBridge);
                    s_DMXDeviceAdjustGroupSceneBridgePool.remove(intIndex);
                } else {
                    o_DMXDeviceAdjustGroupSceneBridge = new DMXDeviceAdjustGroupSceneBridge(p_DMXDeviceAdjustment, p_LiveShowDMXSceneBridge);
                }
            }
            return o_DMXDeviceAdjustGroupSceneBridge;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static boolean poolAddEmpty(DMXDeviceAdjustGroupSceneBridge p_DMXDeviceAdjustGroupSceneBridge) {
            if (p_DMXDeviceAdjustGroupSceneBridge == null) {
                return false;
            }
            Object object = s_SyncObjectPool;
            synchronized (object) {
                if (s_DMXDeviceAdjustGroupSceneBridgePool.size() < 5000) {
                    s_DMXDeviceAdjustGroupSceneBridgePool.add(p_DMXDeviceAdjustGroupSceneBridge);
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void poolClear() {
            Object object = s_SyncObjectPool;
            synchronized (object) {
                s_DMXDeviceAdjustGroupSceneBridgePool.clear();
            }
        }

        public DMXDeviceAdjustGroupSceneBridge(DMXDeviceAdjustment p_DMXDeviceAdjustment, LiveShowDMXSceneBridge p_LiveShowDMXSceneBridge) {
            super(p_DMXDeviceAdjustment, p_LiveShowDMXSceneBridge);
            this.initMembers();
            this.m_LiveShowDMXSceneBridge = p_LiveShowDMXSceneBridge;
            this.m_DMXDeviceAdjustObjectStart = DMXDeviceAdjustObjectSceneBridge.poolGet(this, p_LiveShowDMXSceneBridge, false);
        }

        private void initMembers() {
            this.m_DMXDeviceAdjustObjectsPre = new ArrayList();
            this.m_DMXDeviceAdjustObjectsPost = new ArrayList();
            this.m_NextStartFrame = 0L;
            this.m_Closed = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close(boolean p_Finish) {
            Object object = this.m_SyncPlay;
            synchronized (object) {
                if (this.m_DMXDeviceAdjustObjectStart != null) {
                    this.m_DMXDeviceAdjustObjectStart.close(true);
                    this.m_DMXDeviceAdjustObjectStart = null;
                }
                this.clearAdjustmentsSceneBridgePre();
                this.clearAdjustmentsSceneBridgePost();
                super.close(false);
                if (p_Finish) {
                    Object object2 = this.m_SyncObject;
                    synchronized (object2) {
                        if (this.m_Closed) {
                            return;
                        }
                        this.m_Closed = true;
                        if (!DMXDeviceAdjustGroupSceneBridge.poolAddEmpty(this)) {
                            // empty if block
                        }
                    }
                }
            }
        }

        public void setParams(DMXDeviceAdjustment p_DMXDeviceAdjustment, LiveShowDMXSceneBridge p_LiveShowDMXSceneBridge) {
            super.setParams(p_DMXDeviceAdjustment, p_LiveShowDMXSceneBridge);
            this.m_LiveShowDMXSceneBridge = p_LiveShowDMXSceneBridge;
            this.m_Closed = false;
            this.m_NextStartFrame = 0L;
        }

        @Override
        public DMXDeviceAdjustObject getDMXDeviceAdjustObject_Start() {
            return this.m_DMXDeviceAdjustObjectStart;
        }

        public ArrayList<DMXDeviceAdjustObject> getDMXDeviceAdjustObjectsPre() {
            return this.m_DMXDeviceAdjustObjectsPre;
        }

        public ArrayList<DMXDeviceAdjustObject> getDMXDeviceAdjustObjectsPost() {
            return this.m_DMXDeviceAdjustObjectsPost;
        }

        @Override
        public void setStartAdjustmentActive(boolean p_AdjustmentActive) {
            if (this.m_DMXDeviceAdjustObjectStart != null) {
                this.m_DMXDeviceAdjustObjectStart.setAdjustmentActive(p_AdjustmentActive);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setAdjustmentsPreActive(boolean p_AdjustmentActive) {
            Object object = this.m_SyncPlay;
            synchronized (object) {
                if (this.m_DMXDeviceAdjustObjectsPre != null) {
                    for (int intAdjustObject = this.m_DMXDeviceAdjustObjectsPre.size() - 1; intAdjustObject >= 0; --intAdjustObject) {
                        DMXDeviceAdjustObject o_DMXDeviceAdjustObject = this.m_DMXDeviceAdjustObjectsPre.get(intAdjustObject);
                        if (o_DMXDeviceAdjustObject == null) continue;
                        o_DMXDeviceAdjustObject.setAdjustmentActive(p_AdjustmentActive);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setAdjustmentsPostActive(boolean p_AdjustmentActive) {
            Object object = this.m_SyncPlay;
            synchronized (object) {
                if (this.m_DMXDeviceAdjustObjectsPost != null) {
                    for (int intAdjustObject = this.m_DMXDeviceAdjustObjectsPost.size() - 1; intAdjustObject >= 0; --intAdjustObject) {
                        DMXDeviceAdjustObject o_DMXDeviceAdjustObject = this.m_DMXDeviceAdjustObjectsPost.get(intAdjustObject);
                        if (o_DMXDeviceAdjustObject == null) continue;
                        o_DMXDeviceAdjustObject.setAdjustmentActive(p_AdjustmentActive);
                    }
                }
            }
        }

        public void setNextStartFrame(long p_NectStartFrame) {
            this.m_NextStartFrame = p_NectStartFrame;
        }

        public long getNextStartFrame() {
            return this.m_NextStartFrame;
        }

        public void calculateAdjustmentSceneBridgeStarted(DMXScene.DMXSceneDeviceValues p_DMXSceneDeviceValues, DMXFadeDescription.DMXDeviceFadeDescription p_DMXDeviceFadeDescription) {
            if (p_DMXSceneDeviceValues == null) {
                return;
            }
            LiveShowDMXSceneBridge o_LiveShowDMXSceneBridge = this.m_LiveShowDMXSceneBridge;
            if (o_LiveShowDMXSceneBridge == null) {
                return;
            }
            if (this.m_DMXDeviceAdjustObjectStart == null) {
                this.m_DMXDeviceAdjustObjectStart = DMXDeviceAdjustObjectSceneBridge.poolGet(this, o_LiveShowDMXSceneBridge, false);
            }
            this.m_DMXDeviceAdjustObjectStart.calculateAdjustmentSceneBridgeStarted(p_DMXSceneDeviceValues, p_DMXDeviceFadeDescription);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clearAdjustmentsSceneBridgePre() {
            Object object = this.m_SyncPlay;
            synchronized (object) {
                if (this.m_DMXDeviceAdjustObjectsPre != null) {
                    for (int intAdjustObject = this.m_DMXDeviceAdjustObjectsPre.size() - 1; intAdjustObject >= 0; --intAdjustObject) {
                        DMXDeviceAdjustObject o_DMXDeviceAdjustObject = this.m_DMXDeviceAdjustObjectsPre.get(intAdjustObject);
                        if (o_DMXDeviceAdjustObject != null) {
                            o_DMXDeviceAdjustObject.close(true);
                        }
                        this.m_DMXDeviceAdjustObjectsPre.remove(intAdjustObject);
                    }
                    this.m_DMXDeviceAdjustObjectsPre.clear();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clearAdjustmentsSceneBridgePost() {
            Object object = this.m_SyncPlay;
            synchronized (object) {
                if (this.m_DMXDeviceAdjustObjectsPost != null) {
                    for (int intAdjustObject = this.m_DMXDeviceAdjustObjectsPost.size() - 1; intAdjustObject >= 0; --intAdjustObject) {
                        DMXDeviceAdjustObject o_DMXDeviceAdjustObject = this.m_DMXDeviceAdjustObjectsPost.get(intAdjustObject);
                        if (o_DMXDeviceAdjustObject != null) {
                            o_DMXDeviceAdjustObject.close(true);
                        }
                        this.m_DMXDeviceAdjustObjectsPost.remove(intAdjustObject);
                    }
                    this.m_DMXDeviceAdjustObjectsPost.clear();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void calculateAdjustmentSceneBridgePre(LiveShowDMXSceneBridge p_StartLiveShowDMXSceneBridgePre, ArrayList<LiveShowObject> p_StartLiveShowObjects, ArrayList<LiveShowObject> p_OldLastLiveShowObjects, ArrayList<LiveShowObject> p_OldLastLiveShowSceneBridges) {
            if (p_StartLiveShowObjects == null) {
                return;
            }
            if (p_OldLastLiveShowObjects == null) {
                return;
            }
            if (p_OldLastLiveShowSceneBridges == null) {
                return;
            }
            LiveShowDMXSceneBridge o_LiveShowDMXSceneBridge = this.m_LiveShowDMXSceneBridge;
            DMXDeviceAdjustment o_DMXDeviceAdjustment = this.m_DMXDeviceAdjustment;
            LiveShowDMXVIP o_LiveShowVIP = null;
            if (o_DMXDeviceAdjustment != null) {
                o_LiveShowVIP = o_DMXDeviceAdjustment.getLiveShowDMXVIP();
            }
            if (o_DMXDeviceAdjustment == null) {
                return;
            }
            if (o_LiveShowDMXSceneBridge == null) {
                return;
            }
            if (o_LiveShowVIP == null) {
                return;
            }
            if (p_StartLiveShowObjects.size() > 0 && p_StartLiveShowObjects.get(0).getFrameStart() < o_LiveShowDMXSceneBridge.getFrameStart()) {
                this.clearAdjustmentsSceneBridgePre();
                return;
            }
            Object object = this.m_SyncPlay;
            synchronized (object) {
                LiveShowDMXSceneBridge o_LiveShowDMXSceneBridge_Previous;
                LiveShowObject o_LiveShowObject;
                boolean boolCalculateLastObjects = false;
                long longPreviousFrame = 0L;
                if (p_StartLiveShowDMXSceneBridgePre != null) {
                    longPreviousFrame = p_StartLiveShowDMXSceneBridgePre.getFrameStart() + p_StartLiveShowDMXSceneBridgePre.getFrameFadeOutLength();
                } else {
                    LiveShowObject o_LiveShowSceneBridge = p_OldLastLiveShowSceneBridges.size() > 0 ? p_OldLastLiveShowSceneBridges.get(0) : null;
                    o_LiveShowObject = p_OldLastLiveShowObjects.size() > 0 ? p_OldLastLiveShowObjects.get(0) : null;
                    if (o_LiveShowSceneBridge != null && o_LiveShowObject != null) {
                        if (o_LiveShowObject.getFrameEnd() > o_LiveShowSceneBridge.getFrameStart() + o_LiveShowSceneBridge.getFrameFadeOutLength()) {
                            longPreviousFrame = o_LiveShowObject.getFrameEnd();
                            boolCalculateLastObjects = true;
                        } else {
                            longPreviousFrame = o_LiveShowSceneBridge.getFrameStart() + o_LiveShowSceneBridge.getFrameFadeOutLength();
                        }
                    } else if (o_LiveShowSceneBridge != null) {
                        longPreviousFrame = o_LiveShowSceneBridge.getFrameStart() + o_LiveShowSceneBridge.getFrameFadeOutLength();
                    } else if (o_LiveShowObject != null) {
                        longPreviousFrame = o_LiveShowObject.getFrameEnd();
                        boolCalculateLastObjects = true;
                    }
                }
                if (longPreviousFrame >= o_LiveShowDMXSceneBridge.getFrameStart()) {
                    this.clearAdjustmentsSceneBridgePre();
                    if (longPreviousFrame > o_LiveShowDMXSceneBridge.getFrameStart()) {
                        return;
                    }
                } else {
                    for (int intStartObject = 0; intStartObject < p_StartLiveShowObjects.size(); ++intStartObject) {
                        o_LiveShowObject = p_StartLiveShowObjects.get(intStartObject);
                        DMXDeviceAdjustObject o_DeviceAdjustObject = DMXDeviceAdjustObject.poolGet(this, (LiveShowDMXObject)o_LiveShowObject, null, true);
                        this.m_DMXDeviceAdjustObjectsPre.add(o_DeviceAdjustObject);
                        o_DeviceAdjustObject.calculateAdjustmentPre(o_LiveShowDMXSceneBridge, longPreviousFrame);
                        o_DeviceAdjustObject.setAdjustmentActive(true);
                    }
                }
                if (boolCalculateLastObjects) {
                    for (int intLastObject = 0; intLastObject < p_OldLastLiveShowObjects.size(); ++intLastObject) {
                        DMXDeviceAdjustGroup o_DMXDeviceAdjustGroup;
                        o_LiveShowObject = p_OldLastLiveShowObjects.get(intLastObject);
                        if (o_LiveShowObject instanceof LiveShowDMXSceneBridge || (o_DMXDeviceAdjustGroup = o_DMXDeviceAdjustment.getDMXDeviceAdjustGroup(o_LiveShowObject)) == null) continue;
                        o_DMXDeviceAdjustGroup.calculateAdjustmentEnd(o_LiveShowDMXSceneBridge.getFrameStart());
                        o_DMXDeviceAdjustGroup.setEndAdjustmentActive(true);
                    }
                }
                boolean boolActive = true;
                LiveShowDMXSceneBridge o_LiveShowDMXSceneBridge_MainPrevious = (LiveShowDMXSceneBridge)o_LiveShowVIP.getLiveShowSceneBridge_Previous(o_LiveShowDMXSceneBridge, true, false);
                if (o_LiveShowDMXSceneBridge_MainPrevious != null && !o_LiveShowDMXSceneBridge_MainPrevious.getActive()) {
                    boolActive = false;
                }
                if (boolActive && (o_LiveShowDMXSceneBridge_Previous = (LiveShowDMXSceneBridge)o_LiveShowVIP.getLiveShowSceneBridge_Previous(o_LiveShowDMXSceneBridge, false, false)) != null && !o_LiveShowDMXSceneBridge_Previous.getActive()) {
                    boolActive = false;
                }
                if (!boolActive) {
                    this.setAdjustmentsPreActive(false);
                }
            }
        }

        public void calculateAdjustmentSceneBridgePost(LiveShowDMXSceneBridge p_StartLiveShowDMXSceneBridgePost, ArrayList<LiveShowObject> p_StartLiveShowObjects, ArrayList<LiveShowObject> p_OldLastLiveShowObjects, ArrayList<LiveShowObject> p_OldLastLiveShowSceneBridges) {
            LiveShowDMXSceneBridge o_LiveShowDMXSceneBridge = this.m_LiveShowDMXSceneBridge;
            DMXDeviceAdjustment o_DMXDeviceAdjustment = this.m_DMXDeviceAdjustment;
            LiveShowDMXVIP o_LiveShowVIP = null;
            if (o_DMXDeviceAdjustment != null) {
                o_LiveShowVIP = o_DMXDeviceAdjustment.getLiveShowDMXVIP();
            }
            if (o_DMXDeviceAdjustment == null) {
                return;
            }
            if (o_LiveShowVIP == null) {
                return;
            }
            if (o_LiveShowDMXSceneBridge == null) {
                return;
            }
            long longNextFrame = o_LiveShowVIP.getFrameEnd();
            if (p_StartLiveShowObjects.size() > 0 && p_StartLiveShowObjects.get(0).getFrameStart() < o_LiveShowDMXSceneBridge.getFrameEnd()) {
                this.clearAdjustmentsSceneBridgePost();
                this.calculateAdjustmentSceneBridgeInside(p_StartLiveShowObjects);
                return;
            }
            if (p_StartLiveShowDMXSceneBridgePost != null) {
                longNextFrame = p_StartLiveShowDMXSceneBridgePost.getFrameStart();
            }
            if (p_StartLiveShowObjects.size() > 0 && p_StartLiveShowObjects.get(0).getFrameStart() < longNextFrame) {
                longNextFrame = p_StartLiveShowObjects.get(0).getFrameStart();
            }
            this.setNextStartFrame(longNextFrame);
            if (longNextFrame < o_LiveShowDMXSceneBridge.getFrameEnd()) {
                this.clearAdjustmentsSceneBridgePost();
                return;
            }
            if (p_StartLiveShowDMXSceneBridgePost != null) {
                if (p_StartLiveShowObjects.size() <= 0) {
                    return;
                }
                if (p_StartLiveShowObjects.get(0).getFrameStart() >= p_StartLiveShowDMXSceneBridgePost.getFrameStart()) {
                    return;
                }
            }
            boolean boolActive = true;
            LiveShowDMXSceneBridge o_MainSceneBridge = null;
            if (!o_LiveShowDMXSceneBridge.getActive()) {
                boolActive = false;
            } else if (!o_LiveShowDMXSceneBridge.getIsMainBridge() && (o_MainSceneBridge = (LiveShowDMXSceneBridge)o_LiveShowVIP.getLiveShowSceneBridge_Previous(o_LiveShowDMXSceneBridge.getFrameStart(), true, false)) != null && !o_MainSceneBridge.getActive()) {
                boolActive = false;
            }
            for (int intStartObject = 0; intStartObject < p_StartLiveShowObjects.size(); ++intStartObject) {
                LiveShowObject o_LiveShowObject = p_StartLiveShowObjects.get(intStartObject);
                DMXDeviceAdjustGroup o_DeviceAdjustGroup = o_DMXDeviceAdjustment.getDMXDeviceAdjustGroup(o_LiveShowObject);
                if (o_DeviceAdjustGroup == null) continue;
                o_DeviceAdjustGroup.calculateAdjustmentStart(o_LiveShowDMXSceneBridge.getFrameStart() + o_LiveShowDMXSceneBridge.getFrameFadeOutLength());
                o_DeviceAdjustGroup.setStartAdjustmentActive(boolActive);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void calculateAdjustmentSceneBridgeInside(ArrayList<LiveShowObject> p_StartLiveShowObjects) {
            if (p_StartLiveShowObjects == null) {
                return;
            }
            if (p_StartLiveShowObjects.size() <= 0) {
                return;
            }
            LiveShowDMXSceneBridge o_LiveShowDMXSceneBridge = this.m_LiveShowDMXSceneBridge;
            DMXDeviceAdjustment o_DMXDeviceAdjustment = this.m_DMXDeviceAdjustment;
            LiveShowDMXVIP o_LiveShowVIP = null;
            if (o_DMXDeviceAdjustment != null) {
                o_LiveShowVIP = o_DMXDeviceAdjustment.getLiveShowDMXVIP();
            }
            if (o_DMXDeviceAdjustment == null) {
                return;
            }
            if (o_LiveShowVIP == null) {
                return;
            }
            if (o_LiveShowDMXSceneBridge == null) {
                return;
            }
            this.clearAdjustmentsSceneBridgePost();
            Object object = this.m_SyncPlay;
            synchronized (object) {
                LiveShowObject o_LiveShowObject = p_StartLiveShowObjects.get(0);
                long longNextStartFrame = o_LiveShowObject.getFrameStart();
                long longSceneBridgeFadeOutEnd = o_LiveShowDMXSceneBridge.getFrameStart() + o_LiveShowDMXSceneBridge.getFrameFadeOutLength();
                long longSceneBridgeFadeInStart = o_LiveShowDMXSceneBridge.getFrameStart() + o_LiveShowDMXSceneBridge.getFrameLength() - o_LiveShowDMXSceneBridge.getFrameFadeInLength();
                if (longSceneBridgeFadeInStart >= longSceneBridgeFadeOutEnd && (o_LiveShowObject = p_StartLiveShowObjects.get(0)).getFrameStart() <= longSceneBridgeFadeInStart) {
                    longNextStartFrame = longSceneBridgeFadeInStart;
                }
                this.setNextStartFrame(longNextStartFrame);
                boolean boolActive = true;
                LiveShowDMXSceneBridge o_MainSceneBridge = null;
                if (!o_LiveShowDMXSceneBridge.getActive()) {
                    boolActive = false;
                } else if (!o_LiveShowDMXSceneBridge.getIsMainBridge() && (o_MainSceneBridge = (LiveShowDMXSceneBridge)o_LiveShowVIP.getLiveShowSceneBridge_Previous(o_LiveShowDMXSceneBridge.getFrameStart(), true, false)) != null && !o_MainSceneBridge.getActive()) {
                    boolActive = false;
                }
                for (int intObject = 0; intObject < p_StartLiveShowObjects.size(); ++intObject) {
                    o_LiveShowObject = p_StartLiveShowObjects.get(intObject);
                    DMXDeviceAdjustObject o_DMXDeviceAdjustObject = DMXDeviceAdjustObject.poolGet(this, (LiveShowDMXObject)o_LiveShowObject, null, true);
                    this.m_DMXDeviceAdjustObjectsPost.add(o_DMXDeviceAdjustObject);
                    o_DMXDeviceAdjustObject.calculateAdjustmentInside(o_LiveShowDMXSceneBridge);
                    o_DMXDeviceAdjustObject.setAdjustmentActive(boolActive);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Playable.PlayObject read(Play p_Play, Playable.PlayObject p_PlayObject, LiveShowSceneBridge p_LiveShowSceneBridge, long p_SceneBridgeFrameInside, double p_SceneBridgeFadeProgress, boolean p_IsPreObject) {
            Playable.PlayObject o_PlayObject = null;
            Playable.PlayObject o_ResultPlayObject = null;
            Object object = this.m_SyncPlay;
            synchronized (object) {
                DMXDeviceAdjustObject o_DMXDeviceAdjustObject;
                int intAdjustObject;
                if (this.m_DMXDeviceAdjustObjectStart != null && (o_PlayObject = this.m_DMXDeviceAdjustObjectStart.read(p_Play, p_PlayObject, p_LiveShowSceneBridge, p_SceneBridgeFrameInside, p_SceneBridgeFadeProgress, p_IsPreObject)) != null) {
                    o_ResultPlayObject = o_PlayObject;
                }
                for (intAdjustObject = 0; intAdjustObject < this.m_DMXDeviceAdjustObjectsPre.size(); ++intAdjustObject) {
                    o_DMXDeviceAdjustObject = this.m_DMXDeviceAdjustObjectsPre.get(intAdjustObject);
                    if (o_DMXDeviceAdjustObject == null || (o_PlayObject = o_DMXDeviceAdjustObject.read(p_Play, p_PlayObject, p_LiveShowSceneBridge, p_SceneBridgeFrameInside, p_SceneBridgeFadeProgress, p_IsPreObject)) == null) continue;
                    o_ResultPlayObject = o_PlayObject;
                }
                for (intAdjustObject = 0; intAdjustObject < this.m_DMXDeviceAdjustObjectsPost.size(); ++intAdjustObject) {
                    o_DMXDeviceAdjustObject = this.m_DMXDeviceAdjustObjectsPost.get(intAdjustObject);
                    if (o_DMXDeviceAdjustObject == null || (o_PlayObject = o_DMXDeviceAdjustObject.read(p_Play, p_PlayObject, p_LiveShowSceneBridge, p_SceneBridgeFrameInside, p_SceneBridgeFadeProgress, p_IsPreObject)) == null) continue;
                    o_ResultPlayObject = o_PlayObject;
                }
            }
            return o_ResultPlayObject;
        }
    }

    public static class DMXDeviceAdjustGroup {
        public static Object s_SyncObjectPool = new Object();
        public static ArrayList<DMXDeviceAdjustGroup> s_DMXDeviceAdjustGroupPool = new ArrayList();
        protected DMXDeviceAdjustment m_DMXDeviceAdjustment;
        protected DMXDevice m_DMXDevice;
        private LiveShowDMXObject m_LiveShowDMXObject;
        private LiveShowDMXSceneBridge m_BelongingToSceneBridge;
        private boolean m_DimmerOff;
        private DMXDeviceAdjustObject m_DMXDeviceAdjustObjectStart;
        private DMXDeviceAdjustObject m_DMXDeviceAdjustObjectEnd;
        private DMXDeviceAdjustObject m_DMXDeviceAdjustObjectStart_ReadNext;
        private final Object m_SyncPlay = new Object();
        private boolean m_Closed;
        private final Object m_SyncObject = new Object();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static DMXDeviceAdjustGroup poolGet(DMXDeviceAdjustment p_DMXDeviceAdjustment, LiveShowObjectInterface p_LiveShowObjectInterface) {
            DMXDeviceAdjustGroup o_DMXDeviceAdjustGroup;
            Object object = s_SyncObjectPool;
            synchronized (object) {
                if (s_DMXDeviceAdjustGroupPool.size() > 0) {
                    int intIndex = s_DMXDeviceAdjustGroupPool.size() - 1;
                    o_DMXDeviceAdjustGroup = s_DMXDeviceAdjustGroupPool.get(intIndex);
                    o_DMXDeviceAdjustGroup.reactivate();
                    o_DMXDeviceAdjustGroup.setParams(p_DMXDeviceAdjustment, p_LiveShowObjectInterface);
                    s_DMXDeviceAdjustGroupPool.remove(intIndex);
                } else {
                    o_DMXDeviceAdjustGroup = new DMXDeviceAdjustGroup(p_DMXDeviceAdjustment, p_LiveShowObjectInterface);
                }
            }
            return o_DMXDeviceAdjustGroup;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static boolean poolAddEmpty(DMXDeviceAdjustGroup p_DMXDeviceAdjustGroup) {
            if (p_DMXDeviceAdjustGroup == null) {
                return false;
            }
            Object object = s_SyncObjectPool;
            synchronized (object) {
                if (s_DMXDeviceAdjustGroupPool.size() < 5000) {
                    s_DMXDeviceAdjustGroupPool.add(p_DMXDeviceAdjustGroup);
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void poolClear() {
            Object object = s_SyncObjectPool;
            synchronized (object) {
                s_DMXDeviceAdjustGroupPool.clear();
            }
        }

        public DMXDeviceAdjustGroup(DMXDeviceAdjustment p_DMXDeviceAdjustment, LiveShowObjectInterface p_LiveShowObjectInterface) {
            this.initMembers();
            this.setParams(p_DMXDeviceAdjustment, p_LiveShowObjectInterface);
        }

        private void initMembers() {
            this.m_Closed = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close(boolean p_Finish) {
            Object object = this.m_SyncPlay;
            synchronized (object) {
                if (this.m_DMXDeviceAdjustObjectStart != null) {
                    this.m_DMXDeviceAdjustObjectStart.close(true);
                    this.m_DMXDeviceAdjustObjectStart = null;
                }
                if (this.m_DMXDeviceAdjustObjectEnd != null) {
                    this.m_DMXDeviceAdjustObjectEnd.close(true);
                    this.m_DMXDeviceAdjustObjectEnd = null;
                }
            }
            this.m_DMXDeviceAdjustment = null;
            this.m_DMXDevice = null;
            this.m_BelongingToSceneBridge = null;
            this.m_LiveShowDMXObject = null;
            if (p_Finish) {
                object = this.m_SyncObject;
                synchronized (object) {
                    if (this.m_Closed) {
                        return;
                    }
                    this.m_Closed = true;
                    if (!DMXDeviceAdjustGroup.poolAddEmpty(this)) {
                        // empty if block
                    }
                }
            }
        }

        public void setParams(DMXDeviceAdjustment p_DMXDeviceAdjustment, LiveShowObjectInterface p_LiveShowObjectInterface) {
            this.m_DMXDeviceAdjustment = p_DMXDeviceAdjustment;
            this.m_DMXDevice = this.m_DMXDeviceAdjustment.getDMXDevice();
            if (p_LiveShowObjectInterface instanceof LiveShowDMXObject) {
                this.m_LiveShowDMXObject = (LiveShowDMXObject)p_LiveShowObjectInterface;
                this.m_DimmerOff = false;
                this.m_BelongingToSceneBridge = this.calculateBelongingSceneBridge(this.m_LiveShowDMXObject);
            } else {
                this.m_LiveShowDMXObject = null;
                this.m_BelongingToSceneBridge = null;
                this.m_DimmerOff = false;
            }
        }

        public LiveShowDMXObject getLiveShowDMXObject() {
            return this.m_LiveShowDMXObject;
        }

        public void reactivate() {
            this.m_Closed = false;
        }

        public DMXDeviceAdjustment getDMXDeviceAdjustment() {
            return this.m_DMXDeviceAdjustment;
        }

        public DMXDevice getDMXDevice() {
            return this.m_DMXDevice;
        }

        public DMXDeviceAdjustObject getDMXDeviceAdjustObject_Start() {
            return this.m_DMXDeviceAdjustObjectStart;
        }

        public DMXDeviceAdjustObject getDMXDeviceAdjustObject_End() {
            return this.m_DMXDeviceAdjustObjectEnd;
        }

        public LiveShowDMXSceneBridge calculateBelongingSceneBridge(LiveShowDMXObject p_LiveShowDMXObject) {
            if (p_LiveShowDMXObject == null) {
                return null;
            }
            LiveShowDMXVIP o_LiveShowDMXVIP = (LiveShowDMXVIP)p_LiveShowDMXObject.getLiveShowVIP();
            if (o_LiveShowDMXVIP == null) {
                return null;
            }
            boolean boolOnlyCheckMainBridges = false;
            LiveShowDMXSceneBridge o_LiveShowDMXSceneBridge = (LiveShowDMXSceneBridge)o_LiveShowDMXVIP.getLiveShowSceneBridge_Position(p_LiveShowDMXObject.getFrameStart(), true, false);
            if (o_LiveShowDMXSceneBridge != null && !o_LiveShowDMXSceneBridge.getActive()) {
                boolOnlyCheckMainBridges = true;
            }
            if (!boolOnlyCheckMainBridges) {
                o_LiveShowDMXSceneBridge = (LiveShowDMXSceneBridge)o_LiveShowDMXVIP.getLiveShowSceneBridge_Position(p_LiveShowDMXObject.getFrameStart(), false, false);
            }
            if (o_LiveShowDMXSceneBridge != null && !o_LiveShowDMXSceneBridge.getActive()) {
                o_LiveShowDMXSceneBridge = (LiveShowDMXSceneBridge)o_LiveShowDMXVIP.getLiveShowSceneBridge_Next(p_LiveShowDMXObject.getFrameStart(), boolOnlyCheckMainBridges, true);
            }
            return o_LiveShowDMXSceneBridge;
        }

        public LiveShowDMXSceneBridge getBelongingToSceneBridge() {
            return this.m_BelongingToSceneBridge;
        }

        public void setStartAdjustmentActive(boolean p_AdjustmentActive) {
            if (this.m_DMXDeviceAdjustObjectStart != null) {
                this.m_DMXDeviceAdjustObjectStart.setAdjustmentActive(p_AdjustmentActive);
            }
        }

        public void setEndAdjustmentActive(boolean p_AdjustmentActive) {
            if (this.m_DMXDeviceAdjustObjectEnd != null) {
                this.m_DMXDeviceAdjustObjectEnd.setAdjustmentActive(p_AdjustmentActive);
            }
        }

        public void setDMXSceneDimmerOff(boolean p_DimmerOff) {
            LiveShowDMXObject o_LiveShowDMXObject = this.m_LiveShowDMXObject;
            DMXDevice o_DMXDevice = this.m_DMXDevice;
            if (o_LiveShowDMXObject == null) {
                return;
            }
            if (o_DMXDevice == null) {
                return;
            }
            this.m_DimmerOff = p_DimmerOff;
            DMXScene o_DMXScene = o_LiveShowDMXObject.getDMXScene();
            if (o_DMXScene == null) {
                return;
            }
            DMXScene.DMXSceneValueContainer o_DMXSceneValueContainer = o_DMXScene.getDMXSceneValueContainer();
            if (o_DMXSceneValueContainer == null) {
                return;
            }
            DMXScene.DMXSceneDeviceValues o_DMXSceneDeviceValues = o_DMXSceneValueContainer.getDMXSceneDeviceValues(o_DMXDevice.getID());
            if (o_DMXSceneDeviceValues == null) {
                return;
            }
            o_DMXSceneDeviceValues.setAdjustmentDimmerOff(p_DimmerOff, o_LiveShowDMXObject);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void calculateAdjustmentDimmerOff() {
            Object object = this.m_SyncPlay;
            synchronized (object) {
                this.setDMXSceneDimmerOff(true);
                if (this.m_DMXDeviceAdjustObjectStart != null) {
                    this.m_DMXDeviceAdjustObjectStart.setAdjustmentActive(false);
                }
                if (this.m_DMXDeviceAdjustObjectEnd != null) {
                    this.m_DMXDeviceAdjustObjectEnd.setAdjustmentActive(false);
                }
            }
        }

        public boolean getDimmerOff() {
            return this.m_DimmerOff;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void calculateAdjustmentStart(ArrayList<LiveShowObject> p_StartLiveShowObjects, ArrayList<LiveShowObject> p_LastLiveShowObjects, ArrayList<LiveShowObject> p_LastLiveShowSceneBridges) {
            Object object = this.m_SyncPlay;
            synchronized (object) {
                this.setDMXSceneDimmerOff(false);
                if (this.m_DMXDeviceAdjustObjectStart == null) {
                    this.m_DMXDeviceAdjustObjectStart = DMXDeviceAdjustObject.poolGet(this, this.m_LiveShowDMXObject, null, true);
                }
                this.m_DMXDeviceAdjustObjectStart.setAdjustmentActive(true);
                this.m_DMXDeviceAdjustObjectStart.calculateAdjustment(p_StartLiveShowObjects, p_LastLiveShowObjects, p_LastLiveShowSceneBridges);
            }
        }

        public void calculateAdjustmentStart(long p_FrameStart) {
            this.setDMXSceneDimmerOff(false);
            if (this.m_DMXDeviceAdjustObjectStart == null) {
                this.m_DMXDeviceAdjustObjectStart = DMXDeviceAdjustObject.poolGet(this, this.m_LiveShowDMXObject, null, true);
            }
            this.m_DMXDeviceAdjustObjectStart.setAdjustmentActive(true);
            this.m_DMXDeviceAdjustObjectStart.calculateAdjustmentStart(p_FrameStart);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void calculateAdjustmentEnd(ArrayList<LiveShowObject> p_StartLiveShoObjects, ArrayList<LiveShowObject> p_LastLiveShoObjects, ArrayList<LiveShowObject> p_LastLiveShowSceneBridges) {
            Object object = this.m_SyncPlay;
            synchronized (object) {
                this.setDMXSceneDimmerOff(false);
                if (this.m_DMXDeviceAdjustObjectEnd == null) {
                    this.m_DMXDeviceAdjustObjectEnd = DMXDeviceAdjustObject.poolGet(this, this.m_LiveShowDMXObject, null, false);
                }
                this.m_DMXDeviceAdjustObjectEnd.setAdjustmentActive(true);
                this.m_DMXDeviceAdjustObjectEnd.calculateAdjustment(p_StartLiveShoObjects, p_LastLiveShoObjects, p_LastLiveShowSceneBridges);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void calculateAdjustmentEnd(long p_FrameEnd) {
            Object object = this.m_SyncPlay;
            synchronized (object) {
                this.setDMXSceneDimmerOff(false);
                if (this.m_DMXDeviceAdjustObjectEnd == null) {
                    this.m_DMXDeviceAdjustObjectEnd = DMXDeviceAdjustObject.poolGet(this, this.m_LiveShowDMXObject, null, false);
                }
                this.m_DMXDeviceAdjustObjectEnd.setAdjustmentActive(true);
                this.m_DMXDeviceAdjustObjectEnd.calculateAdjustmentEnd(p_FrameEnd);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Playable.PlayObject read(Play p_Play, Playable.PlayObject p_PlayObject, LiveShowSceneBridge p_LiveShowSceneBridge, long p_SceneBridgeFrameInside, double p_SceneBridgeFadeProgress, boolean p_IsPreObject) {
            Playable.PlayObject o_ResultPlayObject = null;
            Object object = this.m_SyncPlay;
            synchronized (object) {
                if (this.m_DMXDeviceAdjustObjectStart != null) {
                    o_ResultPlayObject = this.m_DMXDeviceAdjustObjectStart.read(p_Play, p_PlayObject, p_LiveShowSceneBridge, p_SceneBridgeFrameInside, p_SceneBridgeFadeProgress, p_IsPreObject);
                }
                if (this.m_DMXDeviceAdjustObjectEnd != null) {
                    o_ResultPlayObject = this.m_DMXDeviceAdjustObjectEnd.read(p_Play, p_PlayObject, p_LiveShowSceneBridge, p_SceneBridgeFrameInside, p_SceneBridgeFadeProgress, p_IsPreObject);
                    o_ResultPlayObject = null;
                }
            }
            return o_ResultPlayObject;
        }

        public void checkDMXDeviceAdjustObject_ReadNext(DMXDeviceAdjustObject p_DMXDeviceAdjustObject) {
            if (this.m_DMXDeviceAdjustObjectStart_ReadNext == null) {
                this.m_DMXDeviceAdjustObjectStart_ReadNext = p_DMXDeviceAdjustObject;
                return;
            }
            if (p_DMXDeviceAdjustObject.getFrameStart() < this.m_DMXDeviceAdjustObjectStart_ReadNext.getFrameStart()) {
                this.m_DMXDeviceAdjustObjectStart_ReadNext = p_DMXDeviceAdjustObject;
            }
        }

        public void setDMXDeviceAdjustObject_ReadNext(DMXDeviceAdjustObject p_DMXDeviceAdjustObject) {
            this.m_DMXDeviceAdjustObjectStart_ReadNext = p_DMXDeviceAdjustObject;
        }

        public DMXDeviceAdjustObject getDMXDeviceAdjustObject_ReadNext() {
            return this.m_DMXDeviceAdjustObjectStart_ReadNext;
        }
    }

    public static class DMXDeviceAdjustment
    implements PropertyChangeListener {
        private LiveShowDMXVIPAdjustment m_LiveShowDMXVIPAdjustment;
        private LiveShowDMXVIP m_LiveShowDMXVIP;
        private DMXDevice m_DMXDevice;
        private ArrayList<LiveShowObject> m_LiveShowDMXObjectsStart;
        private ArrayList<LiveShowObject> m_LiveShowDMXObjectsLast;
        private ArrayList<LiveShowObject> m_OldLiveShowDMXObjectsLast;
        private ArrayList<LiveShowObject> m_TempLiveShowDMXObjectsLast;
        private ArrayList<LiveShowObject> m_LiveShowDMXSceneBridgesLast;
        private ArrayList<LiveShowObject> m_OldLiveShowDMXSceneBridgesLast;
        private ArrayList<LiveShowObject> m_TempLiveShowDMXSceneBridgesLast;
        private long m_LastFrameDimmerON;
        private int m_IndexActualDMXObject;
        private HashMap<LiveShowObject, DMXDeviceAdjustGroup> m_DMXDeviceAdjustmentGroups;
        private HashMap<LiveShowObject, DMXDeviceAdjustGroupSceneBridge> m_DMXDeviceAdjustmentGroupsSceneBridge;
        private DMXDeviceAdjustObject m_DMXDeviceAdjustObject_ReadNext;
        private long m_AdjustmentLastFrame;
        private Runnable m_RunnableCalculateAdjustment;
        private final Object m_SyncObject_AdjustmentGroups = new Object();

        public DMXDeviceAdjustment(LiveShowDMXVIPAdjustment p_LiveShowDMXVIPAdjustment, DMXDevice p_DMXDevice) {
            this.initMembers();
            this.m_LiveShowDMXVIPAdjustment = p_LiveShowDMXVIPAdjustment;
            this.m_LiveShowDMXVIP = this.m_LiveShowDMXVIPAdjustment.getLiveShowDMXVIP();
            this.m_DMXDevice = p_DMXDevice;
        }

        private void initMembers() {
            this.m_DMXDeviceAdjustmentGroups = new HashMap();
            this.m_DMXDeviceAdjustmentGroupsSceneBridge = new HashMap();
            this.m_LiveShowDMXObjectsStart = new ArrayList();
            this.m_LiveShowDMXObjectsLast = new ArrayList();
            this.m_OldLiveShowDMXObjectsLast = new ArrayList();
            this.m_LiveShowDMXSceneBridgesLast = new ArrayList();
            this.m_OldLiveShowDMXSceneBridgesLast = new ArrayList();
            this.m_RunnableCalculateAdjustment = new Runnable(){

                @Override
                public void run() {
                    this.calculateAdjustment();
                }
            };
        }

        public void close() {
            this.clearDMXDeviceAdjustmentGroups();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void clearDMXDeviceAdjustmentGroups() {
            Object object = this.m_SyncObject_AdjustmentGroups;
            synchronized (object) {
                Iterator<DMXDeviceAdjustGroup> o_IteratorDMXObject = this.m_DMXDeviceAdjustmentGroups.values().iterator();
                while (o_IteratorDMXObject.hasNext()) {
                    DMXDeviceAdjustGroup o_DMXDeviceAdjustGroup = o_IteratorDMXObject.next();
                    o_IteratorDMXObject.remove();
                    o_DMXDeviceAdjustGroup.close(true);
                }
                Iterator<DMXDeviceAdjustGroupSceneBridge> o_IteratorDMXSceneBridge = this.m_DMXDeviceAdjustmentGroupsSceneBridge.values().iterator();
                while (o_IteratorDMXSceneBridge.hasNext()) {
                    DMXDeviceAdjustGroupSceneBridge o_DMXDeviceAdjustGroupSceneBridge = o_IteratorDMXSceneBridge.next();
                    o_IteratorDMXSceneBridge.remove();
                    o_DMXDeviceAdjustGroupSceneBridge.close(true);
                }
            }
        }

        public DMXDevice getDMXDevice() {
            return this.m_DMXDevice;
        }

        public LiveShowDMXVIPAdjustment getLiveShowDMXVIPAdjustment() {
            return this.m_LiveShowDMXVIPAdjustment;
        }

        public LiveShowDMXVIP getLiveShowDMXVIP() {
            return this.m_LiveShowDMXVIP;
        }

        public DMXDeviceAdjustGroup getDMXDeviceAdjustGroup(LiveShowObject p_LiveShowObject) {
            if (p_LiveShowObject == null) {
                return null;
            }
            return this.m_DMXDeviceAdjustmentGroups.get(p_LiveShowObject);
        }

        public DMXDeviceAdjustGroupSceneBridge getDMXDeviceAdjustGroupSceneBridge(LiveShowObject p_LiveShowObject) {
            if (p_LiveShowObject == null) {
                return null;
            }
            return this.m_DMXDeviceAdjustmentGroupsSceneBridge.get(p_LiveShowObject);
        }

        private long checkFrameEndDMXObjects(LiveShowObject p_LiveShowDMXObject, long p_FrameEnd) {
            if (p_LiveShowDMXObject.getFrameEnd() >= p_FrameEnd) {
                if (p_LiveShowDMXObject.getFrameEnd() > p_FrameEnd) {
                    this.m_LiveShowDMXObjectsLast.clear();
                }
                this.m_LiveShowDMXObjectsLast.add(p_LiveShowDMXObject);
                return p_LiveShowDMXObject.getFrameEnd();
            }
            return p_FrameEnd;
        }

        private long checkFrameEndDMXSceneBridges(LiveShowObject p_LiveShowDMXObject, long p_FrameEnd) {
            if (p_LiveShowDMXObject.getFrameEnd() >= p_FrameEnd) {
                if (p_LiveShowDMXObject.getFrameEnd() > p_FrameEnd) {
                    this.m_LiveShowDMXSceneBridgesLast.clear();
                }
                this.m_LiveShowDMXSceneBridgesLast.add(p_LiveShowDMXObject);
                return p_LiveShowDMXObject.getFrameEnd();
            }
            return p_FrameEnd;
        }

        public Runnable getRunnableCalculateAdjustment() {
            return this.m_RunnableCalculateAdjustment;
        }

        public void setAdjustmentFrameLast(long p_FramePosition) {
            if (p_FramePosition > this.m_AdjustmentLastFrame) {
                this.m_AdjustmentLastFrame = p_FramePosition;
            }
        }

        public long getAdjustmentFrameLast() {
            return this.m_AdjustmentLastFrame;
        }

        public static void printtestTime(DMXDevice p_DMXDevice, String p_FunctionName, long p_TimeStart) {
            String stringDeviceName = p_DMXDevice == null ? "---" : p_DMXDevice.getName();
            long testDuration = System.nanoTime() - p_TimeStart;
            System.out.println("    " + stringDeviceName + " Duration: " + p_FunctionName + "  " + testDuration);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void calculateAdjustment() {
            this.m_AdjustmentLastFrame = 0L;
            if (!this.m_DMXDevice.getIsDimmable()) {
                this.clearDMXDeviceAdjustmentGroups();
                this.m_DMXDevice.setUsedInTimeline(true);
                return;
            }
            DMXDeviceAdjustGroup o_DMXDeviceAdjustGroup_Actual = null;
            LiveShowDMXSceneBridge o_LiveShowDMXSceneBridgeNext = null;
            DMXDeviceAdjustGroupSceneBridge o_DMXDeviceAdjustGroupSceneBridge = null;
            ArrayList<LiveShowDMXSceneBridge> o_ActualSceneBridges = new ArrayList<LiveShowDMXSceneBridge>();
            int intStartDMXObject = 0;
            long longDMXObjectsFrameEnd = 0L;
            long longDMXSceneBridgesFrameEnd = 0L;
            boolean boolDimmerOn = false;
            this.m_LastFrameDimmerON = 0L;
            this.m_LiveShowDMXObjectsStart.clear();
            this.m_LiveShowDMXObjectsLast.clear();
            this.m_OldLiveShowDMXObjectsLast.clear();
            this.m_LiveShowDMXSceneBridgesLast.clear();
            this.m_OldLiveShowDMXSceneBridgesLast.clear();
            intStartDMXObject = 0;
            while (intStartDMXObject < this.m_LiveShowDMXVIP.getLiveShowObjectInterfaceCount()) {
                int intIndexLastStartDMXObject = -1;
                longDMXObjectsFrameEnd = 0L;
                longDMXSceneBridgesFrameEnd = 0L;
                this.m_IndexActualDMXObject = intStartDMXObject;
                while (this.m_IndexActualDMXObject < this.m_LiveShowDMXVIP.getLiveShowObjectInterfaceCount()) {
                    LiveShowObjectInterface o_LiveShowObjectInterface = this.m_LiveShowDMXVIP.getLiveShowObjectInterface(this.m_IndexActualDMXObject);
                    if (o_LiveShowObjectInterface != null && !o_LiveShowObjectInterface.getIsJingle() && (o_LiveShowObjectInterface instanceof LiveShowDMXObject || o_LiveShowObjectInterface instanceof LiveShowDMXSceneBridge)) {
                        LiveShowDMXSceneBridge o_LiveShowMainDMXSceneBridge;
                        LiveShowDMXSceneBridge o_LiveShowDMXSceneBridge;
                        boolean boolInactiveMainBridge;
                        LiveShowObject o_LiveShowObject = (LiveShowObject)o_LiveShowObjectInterface;
                        if (o_LiveShowObject instanceof LiveShowDMXObject) {
                            Object object;
                            DMXScene.DMXSceneDeviceValues o_DMXSceneDeviceValues;
                            DMXScene.DMXSceneValueContainer o_DMXSceneValueContainer;
                            boolean boolUseObject_InactiveScenebridge = false;
                            boolInactiveMainBridge = false;
                            o_LiveShowDMXSceneBridge = null;
                            LiveShowDMXObject o_LiveShowDMXObject = (LiveShowDMXObject)o_LiveShowObject;
                            DMXScene o_DMXScene = o_LiveShowDMXObject.getDMXScene();
                            if (o_DMXScene != null && (o_DMXSceneValueContainer = o_DMXScene.getDMXSceneValueContainer()) != null && (o_DMXSceneDeviceValues = o_DMXSceneValueContainer.getDMXSceneDeviceValues(this.m_DMXDevice.getID())) != null) {
                                o_DMXSceneDeviceValues.calculateDeactivationCancelled(o_LiveShowDMXObject);
                            }
                            this.m_LiveShowDMXVIPAdjustment.addDMXSceneToListen(o_DMXScene);
                            o_LiveShowMainDMXSceneBridge = (LiveShowDMXSceneBridge)this.m_LiveShowDMXVIP.getLiveShowSceneBridge_Previous(o_LiveShowDMXObject.getFrameStart() + 1L, true, false);
                            if (o_LiveShowMainDMXSceneBridge != null && !o_LiveShowMainDMXSceneBridge.getActive()) {
                                o_LiveShowDMXSceneBridge = o_LiveShowMainDMXSceneBridge;
                                boolInactiveMainBridge = true;
                            }
                            if (!boolInactiveMainBridge) {
                                o_LiveShowDMXSceneBridge = (LiveShowDMXSceneBridge)this.m_LiveShowDMXVIP.getLiveShowSceneBridge_Previous(o_LiveShowDMXObject.getFrameStart() + 1L, false, false);
                            }
                            if (o_LiveShowDMXSceneBridge != null && !o_LiveShowDMXSceneBridge.getActive()) {
                                o_LiveShowDMXSceneBridgeNext = (LiveShowDMXSceneBridge)this.m_LiveShowDMXVIP.getLiveShowSceneBridge_Next(o_LiveShowDMXObject.getFrameStart() + 1L, boolInactiveMainBridge, false);
                                while (o_LiveShowDMXSceneBridgeNext != null && o_LiveShowDMXObject.getFrameEnd() > o_LiveShowDMXSceneBridgeNext.getFrameEnd()) {
                                    if (o_LiveShowDMXSceneBridgeNext.getActive()) {
                                        boolUseObject_InactiveScenebridge = true;
                                        break;
                                    }
                                    o_LiveShowDMXSceneBridgeNext = (LiveShowDMXSceneBridge)this.m_LiveShowDMXVIP.getLiveShowSceneBridge_Next(o_LiveShowDMXSceneBridgeNext.getFrameStart() + 1L, boolInactiveMainBridge, false);
                                }
                                if (!boolUseObject_InactiveScenebridge) {
                                    object = this.m_SyncObject_AdjustmentGroups;
                                    synchronized (object) {
                                        o_DMXDeviceAdjustGroup_Actual = this.m_DMXDeviceAdjustmentGroups.get(o_LiveShowDMXObject);
                                        if (o_DMXDeviceAdjustGroup_Actual != null) {
                                            o_DMXDeviceAdjustGroup_Actual.setEndAdjustmentActive(false);
                                            o_DMXDeviceAdjustGroup_Actual.setStartAdjustmentActive(false);
                                            this.m_DMXDeviceAdjustmentGroups.remove(o_LiveShowDMXObject);
                                        }
                                    }
                                }
                            }
                            if ((o_DMXDeviceAdjustGroup_Actual = this.m_DMXDeviceAdjustmentGroups.get(o_LiveShowDMXObject)) == null) {
                                o_DMXDeviceAdjustGroup_Actual = DMXDeviceAdjustGroup.poolGet(this, o_LiveShowDMXObject);
                                object = this.m_SyncObject_AdjustmentGroups;
                                synchronized (object) {
                                    this.m_DMXDeviceAdjustmentGroups.put(o_LiveShowDMXObject, o_DMXDeviceAdjustGroup_Actual);
                                }
                            }
                            o_DMXDeviceAdjustGroup_Actual.setStartAdjustmentActive(false);
                            o_DMXDeviceAdjustGroup_Actual.setEndAdjustmentActive(false);
                            if (!boolUseObject_InactiveScenebridge || o_LiveShowDMXSceneBridge != null) {
                                // empty if block
                            }
                            if (!this.isDimmerOn(o_LiveShowDMXObject) || this.isDeactivated(o_LiveShowDMXObject)) {
                                o_DMXDeviceAdjustGroup_Actual.calculateAdjustmentDimmerOff();
                            } else {
                                if (this.m_LastFrameDimmerON < o_LiveShowDMXObject.getFrameEnd()) {
                                    this.m_LastFrameDimmerON = o_LiveShowDMXObject.getFrameEnd();
                                }
                                o_DMXDeviceAdjustGroup_Actual.setDMXSceneDimmerOff(false);
                                boolDimmerOn = true;
                                if (this.m_LiveShowDMXObjectsStart.size() <= 0) {
                                    this.m_LiveShowDMXObjectsStart.add(o_LiveShowDMXObject);
                                    longDMXObjectsFrameEnd = this.checkFrameEndDMXObjects(o_LiveShowDMXObject, longDMXObjectsFrameEnd);
                                    intIndexLastStartDMXObject = this.m_IndexActualDMXObject;
                                } else if (o_LiveShowDMXObject.getFrameStart() == this.m_LiveShowDMXObjectsStart.get(0).getFrameStart()) {
                                    this.m_LiveShowDMXObjectsStart.add(o_LiveShowDMXObject);
                                    longDMXObjectsFrameEnd = this.checkFrameEndDMXObjects(o_LiveShowDMXObject, longDMXObjectsFrameEnd);
                                    intIndexLastStartDMXObject = this.m_IndexActualDMXObject;
                                } else {
                                    if (o_LiveShowDMXObject.getFrameStart() < longDMXSceneBridgesFrameEnd || o_LiveShowDMXObject.getFrameStart() >= longDMXObjectsFrameEnd) break;
                                    longDMXObjectsFrameEnd = this.checkFrameEndDMXObjects(o_LiveShowDMXObject, longDMXObjectsFrameEnd);
                                }
                            }
                        } else {
                            boolInactiveMainBridge = false;
                            o_LiveShowDMXSceneBridge = (LiveShowDMXSceneBridge)o_LiveShowObject;
                            o_LiveShowMainDMXSceneBridge = (LiveShowDMXSceneBridge)this.m_LiveShowDMXVIP.getLiveShowSceneBridge_Previous(o_LiveShowDMXSceneBridge.getFrameStart() - 1L, true, false);
                            if (o_LiveShowMainDMXSceneBridge != null && !o_LiveShowMainDMXSceneBridge.getActive() && !o_LiveShowDMXSceneBridge.getIsMainBridge()) {
                                boolInactiveMainBridge = true;
                            }
                            if (boolInactiveMainBridge || !o_LiveShowDMXSceneBridge.getActive()) {
                                // empty if block
                            }
                            this.calculateSceneBridgeInit(o_LiveShowDMXSceneBridge);
                            o_DMXDeviceAdjustGroupSceneBridge = this.m_DMXDeviceAdjustmentGroupsSceneBridge.get(o_LiveShowDMXSceneBridge);
                            o_DMXDeviceAdjustGroupSceneBridge.setStartAdjustmentActive(false);
                            o_DMXDeviceAdjustGroupSceneBridge.setAdjustmentsPreActive(false);
                            o_DMXDeviceAdjustGroupSceneBridge.setAdjustmentsPostActive(false);
                            o_DMXDeviceAdjustGroupSceneBridge.clearAdjustmentsSceneBridgePre();
                            o_DMXDeviceAdjustGroupSceneBridge.clearAdjustmentsSceneBridgePost();
                            if (this.m_LiveShowDMXObjectsLast.size() > 0 && o_LiveShowDMXSceneBridge.getFrameStart() >= this.m_LiveShowDMXObjectsLast.get(0).getFrameEnd()) break;
                            longDMXSceneBridgesFrameEnd = this.checkFrameEndDMXSceneBridges(o_LiveShowDMXSceneBridge, longDMXSceneBridgesFrameEnd);
                            o_ActualSceneBridges.add(o_LiveShowDMXSceneBridge);
                        }
                    }
                    ++this.m_IndexActualDMXObject;
                }
                LiveShowDMXSceneBridge o_LiveShowSceneBridgeHangOver = null;
                if (o_ActualSceneBridges.size() > 0) {
                    if (this.m_LiveShowDMXSceneBridgesLast.size() > 0 && this.m_LiveShowDMXObjectsLast.size() > 0 && this.m_LiveShowDMXSceneBridgesLast.get(0).getFrameEnd() >= this.m_LiveShowDMXObjectsLast.get(0).getFrameEnd() && this.m_LiveShowDMXSceneBridgesLast.get(0).getFrameStart() > this.m_LiveShowDMXObjectsLast.get(0).getFrameStart()) {
                        o_LiveShowSceneBridgeHangOver = (LiveShowDMXSceneBridge)this.m_LiveShowDMXSceneBridgesLast.get(0);
                        this.m_LiveShowDMXSceneBridgesLast.remove(o_LiveShowSceneBridgeHangOver);
                        o_ActualSceneBridges.remove(o_LiveShowSceneBridgeHangOver);
                    }
                    if (o_ActualSceneBridges.size() > 0) {
                        this.calculateAdjustmentDMXSceneBridges(o_ActualSceneBridges, this.m_LiveShowDMXObjectsStart, this.m_OldLiveShowDMXObjectsLast, this.m_OldLiveShowDMXSceneBridgesLast);
                    }
                }
                if (this.m_LiveShowDMXObjectsStart.size() > 0 || this.m_OldLiveShowDMXObjectsLast.size() > 0) {
                    this.calculateAdjustmentDMXObjects(this.m_LiveShowDMXObjectsStart, this.m_OldLiveShowDMXObjectsLast, this.m_OldLiveShowDMXSceneBridgesLast);
                }
                this.m_LiveShowDMXObjectsStart.clear();
                this.m_TempLiveShowDMXObjectsLast = this.m_OldLiveShowDMXObjectsLast;
                this.m_OldLiveShowDMXObjectsLast = this.m_LiveShowDMXObjectsLast;
                this.m_LiveShowDMXObjectsLast = this.m_TempLiveShowDMXObjectsLast;
                this.m_LiveShowDMXObjectsLast.clear();
                this.m_TempLiveShowDMXSceneBridgesLast = this.m_OldLiveShowDMXSceneBridgesLast;
                this.m_OldLiveShowDMXSceneBridgesLast = this.m_LiveShowDMXSceneBridgesLast;
                this.m_LiveShowDMXSceneBridgesLast = this.m_TempLiveShowDMXSceneBridgesLast;
                this.m_LiveShowDMXSceneBridgesLast.clear();
                if (o_LiveShowSceneBridgeHangOver != null) {
                    this.m_LiveShowDMXSceneBridgesLast.add(o_LiveShowSceneBridgeHangOver);
                    o_ActualSceneBridges.add(o_LiveShowSceneBridgeHangOver);
                }
                intStartDMXObject = this.m_IndexActualDMXObject;
            }
            if (o_ActualSceneBridges.size() > 0) {
                this.calculateAdjustmentDMXSceneBridges(o_ActualSceneBridges, this.m_LiveShowDMXObjectsStart, this.m_OldLiveShowDMXObjectsLast, this.m_OldLiveShowDMXSceneBridgesLast);
            }
            this.calculateAdjustmentDMXObjects(this.m_LiveShowDMXObjectsStart, this.m_OldLiveShowDMXObjectsLast, this.m_OldLiveShowDMXSceneBridgesLast);
            this.m_DMXDevice.setUsedInTimeline(boolDimmerOn);
        }

        private void calculateAdjustmentDMXObjects(ArrayList<LiveShowObject> p_StartLiveShowObjects, ArrayList<LiveShowObject> p_LastLiveShowObjects, ArrayList<LiveShowObject> p_LastLiveShowSceneBridges) {
            DMXDeviceAdjustGroup o_DMXDeviceAdjustGroup;
            for (int intDMXObject = 0; intDMXObject < p_StartLiveShowObjects.size(); ++intDMXObject) {
                LiveShowDMXObject o_LiveShowDMXObject = (LiveShowDMXObject)p_StartLiveShowObjects.get(intDMXObject);
                o_DMXDeviceAdjustGroup = this.m_DMXDeviceAdjustmentGroups.get(o_LiveShowDMXObject);
                if (o_DMXDeviceAdjustGroup == null) continue;
                o_DMXDeviceAdjustGroup.calculateAdjustmentStart(p_StartLiveShowObjects, p_LastLiveShowObjects, p_LastLiveShowSceneBridges);
            }
            for (int intObject = 0; intObject < p_LastLiveShowObjects.size(); ++intObject) {
                LiveShowObject o_LiveShowObject = p_LastLiveShowObjects.get(intObject);
                if (!(o_LiveShowObject instanceof LiveShowDMXObject) || (o_DMXDeviceAdjustGroup = this.m_DMXDeviceAdjustmentGroups.get(o_LiveShowObject)) == null) continue;
                o_DMXDeviceAdjustGroup.calculateAdjustmentEnd(p_StartLiveShowObjects, p_LastLiveShowObjects, p_LastLiveShowSceneBridges);
            }
        }

        private void calculateAdjustmentDMXSceneBridges(ArrayList<LiveShowDMXSceneBridge> p_LiveShowDMXSceneBridges, ArrayList<LiveShowObject> p_StartLiveShowObjects, ArrayList<LiveShowObject> p_OldLastLiveShowObjects, ArrayList<LiveShowObject> p_OldLastLiveShowSceneBridges) {
            if (p_LiveShowDMXSceneBridges == null) {
                return;
            }
            if (p_StartLiveShowObjects == null) {
                return;
            }
            if (p_OldLastLiveShowObjects == null) {
                return;
            }
            if (p_LiveShowDMXSceneBridges.size() <= 0) {
                return;
            }
            for (int intBridge = 0; intBridge < p_LiveShowDMXSceneBridges.size(); ++intBridge) {
                LiveShowDMXSceneBridge o_LiveShowDMXSceneBridgePre;
                LiveShowDMXSceneBridge o_LiveShowDMXSceneBridge = p_LiveShowDMXSceneBridges.get(intBridge);
                if (o_LiveShowDMXSceneBridge == null) continue;
                if (intBridge == 0) {
                    o_LiveShowDMXSceneBridgePre = null;
                    if (p_StartLiveShowObjects.size() > 0 && p_StartLiveShowObjects.get(0).getFrameStart() < o_LiveShowDMXSceneBridge.getFrameStart()) {
                        this.calculateAdjustmentDMXObjects(p_StartLiveShowObjects, p_OldLastLiveShowObjects, p_OldLastLiveShowSceneBridges);
                    }
                } else {
                    o_LiveShowDMXSceneBridgePre = p_LiveShowDMXSceneBridges.get(intBridge - 1);
                }
                LiveShowDMXSceneBridge o_LiveShowDMXSceneBridgePost = intBridge < p_LiveShowDMXSceneBridges.size() - 1 ? p_LiveShowDMXSceneBridges.get(intBridge + 1) : null;
                DMXDeviceAdjustGroupSceneBridge o_AdjustGroupSceneBridge = this.m_DMXDeviceAdjustmentGroupsSceneBridge.get(o_LiveShowDMXSceneBridge);
                if (o_AdjustGroupSceneBridge == null) continue;
                o_AdjustGroupSceneBridge.calculateAdjustmentSceneBridgePre(o_LiveShowDMXSceneBridgePre, p_StartLiveShowObjects, p_OldLastLiveShowObjects, p_OldLastLiveShowSceneBridges);
                o_AdjustGroupSceneBridge.calculateAdjustmentSceneBridgePost(o_LiveShowDMXSceneBridgePost, p_StartLiveShowObjects, p_OldLastLiveShowObjects, p_OldLastLiveShowSceneBridges);
            }
            p_LiveShowDMXSceneBridges.clear();
            p_StartLiveShowObjects.clear();
            p_OldLastLiveShowObjects.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void calculateSceneBridgeInit(LiveShowDMXSceneBridge p_LiveShowDMXSceneBridge) {
            if (p_LiveShowDMXSceneBridge == null) {
                return;
            }
            DMXDeviceAdjustGroupSceneBridge o_DMXDeviceAdjustGroupSceneBridge = this.m_DMXDeviceAdjustmentGroupsSceneBridge.get(p_LiveShowDMXSceneBridge);
            if (o_DMXDeviceAdjustGroupSceneBridge == null) {
                o_DMXDeviceAdjustGroupSceneBridge = DMXDeviceAdjustGroupSceneBridge.poolGet(this, p_LiveShowDMXSceneBridge);
                Object object = this.m_SyncObject_AdjustmentGroups;
                synchronized (object) {
                    this.m_DMXDeviceAdjustmentGroupsSceneBridge.put(p_LiveShowDMXSceneBridge, o_DMXDeviceAdjustGroupSceneBridge);
                }
            }
            o_DMXDeviceAdjustGroupSceneBridge.setNextStartFrame(0L);
        }

        public void calculateAdjustmentSceneBridgeStarted(LiveShowDMXSceneBridge p_LiveShowDMXSceneBridge, DMXScene.DMXSceneDeviceValues p_DMXSceneDeviceValues, DMXFadeDescription.DMXDeviceFadeDescription p_DMXDeviceFadeDescription) {
            if (p_LiveShowDMXSceneBridge == null) {
                return;
            }
            if (p_DMXSceneDeviceValues == null) {
                return;
            }
            DMXDeviceAdjustGroupSceneBridge o_DMXDeviceAdjustGroupSceneBridge = this.m_DMXDeviceAdjustmentGroupsSceneBridge.get(p_LiveShowDMXSceneBridge);
            if (o_DMXDeviceAdjustGroupSceneBridge == null) {
                return;
            }
            o_DMXDeviceAdjustGroupSceneBridge.calculateAdjustmentSceneBridgeStarted(p_DMXSceneDeviceValues, p_DMXDeviceFadeDescription);
        }

        public boolean isDimmerOn(LiveShowDMXObject p_LiveShowDMXObject) {
            if (p_LiveShowDMXObject == null) {
                return false;
            }
            DMXScene o_DMXScene = p_LiveShowDMXObject.getDMXScene();
            if (o_DMXScene == null) {
                return false;
            }
            boolean boolDimmerOn = false;
            DMXEffect o_DMXEffect = p_LiveShowDMXObject.getDMXEffect();
            if (o_DMXEffect != null) {
                boolDimmerOn = o_DMXEffect.containsDMXDevice(this.m_DMXDevice);
            }
            if (boolDimmerOn) {
                return true;
            }
            return o_DMXScene.isDimmerOn(this.m_DMXDevice);
        }

        public boolean isDeactivated(LiveShowDMXObject p_LiveShowDMXObject) {
            if (p_LiveShowDMXObject == null) {
                return true;
            }
            DMXScene o_DMXScene = p_LiveShowDMXObject.getDMXScene();
            if (o_DMXScene == null) {
                return true;
            }
            DMXFadeDescription o_DMXFadeDescription = p_LiveShowDMXObject.getDMXFadeDescription();
            if (o_DMXFadeDescription == null) {
                return true;
            }
            DMXFadeDescription.DMXDeviceFadeDescription o_DMXDeviceFadeDescription = o_DMXFadeDescription.getDMXDeviceFadeDescription(this.m_DMXDevice.getID());
            if (o_DMXDeviceFadeDescription == null) {
                return true;
            }
            return o_DMXDeviceFadeDescription.isDisabled();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Playable.PlayObject read(Play p_Play, Playable.PlayObject p_PlayObject, LiveShowSceneBridge p_LiveShowSceneBridge, long p_SceneBridgeFrameInside, double p_SceneBridgeFadeProgress, boolean p_IsPreObject, LiveShowDMXSceneBridge p_LiveShowDMXSceneBridgeNext, LiveShowDMXSceneBridge p_LiveShowDMXSceneBridgeNextNext) {
            if (!this.m_DMXDevice.getUsedInTimeline()) {
                return p_PlayObject;
            }
            Playable.PlayObject o_PlayObject = null;
            long longPlayCursor = p_PlayObject.getFramePosition();
            LiveShowObject o_LiveShowDMXSceneBridge_Adjusted = null;
            Object object = this.m_SyncObject_AdjustmentGroups;
            synchronized (object) {
                this.m_DMXDeviceAdjustObject_ReadNext = null;
                for (DMXDeviceAdjustGroup dMXDeviceAdjustGroup : this.m_DMXDeviceAdjustmentGroups.values()) {
                    LiveShowDMXObject o_LiveShowDMXObject;
                    if (dMXDeviceAdjustGroup == null) continue;
                    dMXDeviceAdjustGroup.setDMXDeviceAdjustObject_ReadNext(null);
                    o_PlayObject = dMXDeviceAdjustGroup.read(p_Play, p_PlayObject, p_LiveShowSceneBridge, p_SceneBridgeFrameInside, p_SceneBridgeFadeProgress, p_IsPreObject);
                    LiveShowObject o_LiveShowDMXSceneBridge = null;
                    if (p_LiveShowDMXSceneBridgeNext != null && !dMXDeviceAdjustGroup.getDimmerOff() && (o_LiveShowDMXObject = dMXDeviceAdjustGroup.getLiveShowDMXObject()) != null && o_LiveShowDMXObject.getFrameEnd() >= longPlayCursor) {
                        if (o_LiveShowDMXObject.getFrameStart() > longPlayCursor) {
                            if (o_LiveShowDMXObject.getFrameStart() < p_LiveShowDMXSceneBridgeNext.getFrameStart()) {
                                o_LiveShowDMXSceneBridge = dMXDeviceAdjustGroup.getBelongingToSceneBridge();
                            } else if (p_LiveShowDMXSceneBridgeNextNext != null && o_LiveShowDMXObject.getFrameStart() < p_LiveShowDMXSceneBridgeNextNext.getFrameStart()) {
                                o_LiveShowDMXSceneBridge = p_LiveShowDMXSceneBridgeNext;
                            }
                        } else if (o_LiveShowDMXObject.getFrameEnd() > p_LiveShowDMXSceneBridgeNext.getFrameStart() + p_LiveShowDMXSceneBridgeNext.getFrameLength()) {
                            o_LiveShowDMXSceneBridge = p_LiveShowDMXSceneBridgeNext;
                        }
                    }
                    if (o_LiveShowDMXSceneBridge != null) {
                        if (o_LiveShowDMXSceneBridge_Adjusted == null) {
                            o_LiveShowDMXSceneBridge_Adjusted = o_LiveShowDMXSceneBridge;
                        } else if (o_LiveShowDMXSceneBridge.getFrameStart() < o_LiveShowDMXSceneBridge_Adjusted.getFrameStart()) {
                            o_LiveShowDMXSceneBridge_Adjusted = o_LiveShowDMXSceneBridge;
                        }
                    }
                    if (dMXDeviceAdjustGroup.getDMXDeviceAdjustObject_ReadNext() == null) continue;
                    if (this.m_DMXDeviceAdjustObject_ReadNext == null) {
                        this.m_DMXDeviceAdjustObject_ReadNext = dMXDeviceAdjustGroup.getDMXDeviceAdjustObject_ReadNext();
                        continue;
                    }
                    if (this.m_DMXDeviceAdjustObject_ReadNext.getFrameStart() <= dMXDeviceAdjustGroup.getDMXDeviceAdjustObject_ReadNext().getFrameStart()) continue;
                    this.m_DMXDeviceAdjustObject_ReadNext = dMXDeviceAdjustGroup.getDMXDeviceAdjustObject_ReadNext();
                }
                for (DMXDeviceAdjustGroup dMXDeviceAdjustGroup : this.m_DMXDeviceAdjustmentGroupsSceneBridge.values()) {
                    dMXDeviceAdjustGroup.setDMXDeviceAdjustObject_ReadNext(null);
                    o_PlayObject = dMXDeviceAdjustGroup.read(p_Play, p_PlayObject, p_LiveShowSceneBridge, p_SceneBridgeFrameInside, p_SceneBridgeFadeProgress, p_IsPreObject);
                    if (dMXDeviceAdjustGroup.getDMXDeviceAdjustObject_ReadNext() == null) continue;
                    if (this.m_DMXDeviceAdjustObject_ReadNext == null) {
                        this.m_DMXDeviceAdjustObject_ReadNext = dMXDeviceAdjustGroup.getDMXDeviceAdjustObject_ReadNext();
                        continue;
                    }
                    if (this.m_DMXDeviceAdjustObject_ReadNext.getFrameStart() <= dMXDeviceAdjustGroup.getDMXDeviceAdjustObject_ReadNext().getFrameStart()) continue;
                    this.m_DMXDeviceAdjustObject_ReadNext = dMXDeviceAdjustGroup.getDMXDeviceAdjustObject_ReadNext();
                }
            }
            if (o_LiveShowDMXSceneBridge_Adjusted == null && this.m_DMXDeviceAdjustObject_ReadNext != null) {
                o_LiveShowDMXSceneBridge_Adjusted = this.m_DMXDeviceAdjustObject_ReadNext.getBelongingToSceneBridge();
            }
            if (!((PlayDMX.DMXPlayObject)p_PlayObject).getEditMode()) {
                this.m_DMXDevice.setSceneBridge_Adjusted((LiveShowDMXSceneBridge)o_LiveShowDMXSceneBridge_Adjusted);
            } else {
                this.m_DMXDevice.setSceneBridge_AdjustedEditMode((LiveShowDMXSceneBridge)o_LiveShowDMXSceneBridge_Adjusted);
            }
            return o_PlayObject;
        }

        public DMXDeviceAdjustObject getDMXDeviceAdjustObject_ReadNext() {
            return this.m_DMXDeviceAdjustObject_ReadNext;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void eventLiveShowDMXObectRemoved(LiveShowDMXObject p_LiveShowDMXObject) {
            DMXDeviceAdjustGroup o_DMXDeviceAdjustGroup;
            Object object = this.m_SyncObject_AdjustmentGroups;
            synchronized (object) {
                o_DMXDeviceAdjustGroup = this.m_DMXDeviceAdjustmentGroups.get(p_LiveShowDMXObject);
                if (o_DMXDeviceAdjustGroup != null) {
                    this.m_DMXDeviceAdjustmentGroups.remove(p_LiveShowDMXObject);
                }
            }
            if (o_DMXDeviceAdjustGroup != null) {
                o_DMXDeviceAdjustGroup.close(true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void eventLiveShowDMXSceneBridgeRemoved(LiveShowDMXSceneBridge p_LiveShowDMXSceneBridge) {
            DMXDeviceAdjustGroupSceneBridge o_DMXDeviceAdjustGroupSceneBridge;
            Object object = this.m_SyncObject_AdjustmentGroups;
            synchronized (object) {
                o_DMXDeviceAdjustGroupSceneBridge = this.m_DMXDeviceAdjustmentGroupsSceneBridge.get(p_LiveShowDMXSceneBridge);
                if (o_DMXDeviceAdjustGroupSceneBridge != null) {
                    this.m_DMXDeviceAdjustmentGroupsSceneBridge.remove(p_LiveShowDMXSceneBridge);
                }
            }
            if (o_DMXDeviceAdjustGroupSceneBridge != null) {
                o_DMXDeviceAdjustGroupSceneBridge.close(true);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
        }
    }
}

