/*
 * Decompiled with CFR 0.152.
 */
package DMXVirtualPackage;

import DMX512.DMXUniverse;
import DMXDevicePackage.DMXDevice;
import DMXDevicePackage.DMXDeviceType;
import DMXEffectsPackage.DMXEffect;
import DMXEffectsPackage.DMXEffect_PlayContainer;
import DMXScenePackage.DMXScene;
import DMXVirtualPackage.LiveShowDMXObject;
import DMXVirtualPackage.LiveShowDMXObjectDescription;
import DMXVirtualPackage.LiveShowDMXSceneBridge;
import DMXVirtualPackage.LiveShowDMXVIPAdjustment;
import DMXVirtualPackage.LiveShowDMXVIPTrack;
import Icons.IconManager;
import LiveShowNotificationPackage.LiveShowNotification;
import LiveShowObjectPackage.LiveShowDragDrop;
import LiveShowObjectPackage.LiveShowObjectDescription;
import LiveShowObjectPackage.LiveShowObjectInterface;
import LiveShowObjectPackage.LiveShowObjectListener;
import LiveShowObjectPackage.LiveShowProjectDescription;
import LiveShowObjectPackage.LiveShowUndo;
import LiveShowPlayPackage.Play;
import LiveShowPlayPackage.Playable;
import LiveShowVirtualPackage.LiveShowSceneBridge;
import LiveShowVirtualPackage.LiveShowSceneBridgeMain;
import LiveShowVirtualPackage.LiveShowTimer;
import LiveShowVirtualPackage.LiveShowVIP;
import LiveShowVirtualPackage.LiveShowVIPTrack;
import LiveShowVirtualPackage.LiveShow_ExportDescription;
import LiveShowVirtualPackage.LiveShow_ImportDescription;
import PlayDMXPackage.PlayDMX;
import StartPackage.LiveShowDMXSystem;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorMap;
import java.io.Externalizable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.swing.ImageIcon;

public class LiveShowDMXVIP
extends LiveShowVIP
implements Externalizable,
LiveShowObjectListener {
    public static final int SOFTWAREVERSION = 21;
    public static final String FILESUFFIX = ".ldv";
    public static ImageIcon s_Icon = IconManager.getImageIcon("DMX.png");
    public static String ERROR_NODATALINEFOUND = "No matching Dataline was found!";
    public static ArrayList<LiveShowDMXObject> s_LiveShowDMXObjects_LastRead = new ArrayList(5);
    public static final Object s_SyncDMXObjects_LastRead = new Object();
    private PlayDMX.DMXPlayObject m_VipTrackDMXPlayObject;
    private LiveShowDMXVIPAdjustment m_LiveShowDMXVIPAdjustment;
    private final Object m_SyncPlay = new Object();
    public static Exception s_LoadException = null;

    public LiveShowDMXVIP(boolean p_Create) {
        this.initMembers();
        if (p_Create) {
            this.initializeVIP();
        }
    }

    public void createPlay() {
        if (this.m_Play != null) {
            this.m_Play.close();
        }
        this.m_Play = new PlayDMX(this, 0);
        this.m_Play.createOutputLine();
    }

    public void initializeVIP() {
        this.createPlay();
        for (int intVipTrack = 0; intVipTrack < DEFAULT_TRACKSCOUNT; ++intVipTrack) {
            this.createLiveShowVipTrack();
        }
        LiveShowTimer.selfReference().addLiveShowVIP(this);
        this.notifyLiveShowVIPListeners_MaxFrame(this.getFramePositionMax());
    }

    @Override
    public void eventEndOfAction(LiveShowVIP.LiveShowVIPStatus p_LiveShowVIPStatus, boolean p_Success, int p_Action) {
        super.eventEndOfAction(p_LiveShowVIPStatus, p_Success, p_Action);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeExternal_Objects(ObjectOutput out, LiveShowProjectDescription p_LiveShowProjectDescription, LiveShow_ExportDescription p_LiveShowExportDescription) throws IOException {
        DMXDevice o_DMXDevice;
        int intDMXDevice;
        DMXEffect o_DMXEffect;
        DMXScene o_DMXScene;
        LiveShowObjectInterface o_LiveShowObjectInterface;
        if (out == null) {
            return false;
        }
        if (p_LiveShowExportDescription == null) {
            return false;
        }
        out.writeInt(21);
        out.writeBoolean(this.m_Active);
        ArrayList<LiveShowSceneBridge> o_ArrayListSceneBridges = new ArrayList<LiveShowSceneBridge>();
        ArrayList<LiveShowObjectInterface> o_ArrayListObjects = new ArrayList<LiveShowObjectInterface>();
        ArrayList<DMXScene> o_ArrayListDMXScenes = new ArrayList<DMXScene>();
        ArrayList<DMXEffect> o_ArrayListDMXEffects = new ArrayList<DMXEffect>();
        ArrayList<DMXDevice> o_ArrayListDMXDevices = new ArrayList<DMXDevice>();
        Object object = this.m_SyncObjects;
        synchronized (object) {
            int intObject;
            Object[] o_SceneBridges = this.m_SceneBridges.toArray();
            for (intObject = 0; intObject < o_SceneBridges.length; ++intObject) {
                LiveShowSceneBridge o_LiveShowSceneBridge = (LiveShowSceneBridge)o_SceneBridges[intObject];
                if (!p_LiveShowExportDescription.getSaveProject() && !p_LiveShowExportDescription.getExportProjectAll() && !o_LiveShowSceneBridge.getSelected()) continue;
                o_ArrayListSceneBridges.add(o_LiveShowSceneBridge);
            }
            Object[] o_Objects = this.m_LiveShowObjects.toArray();
            for (intObject = 0; intObject < o_Objects.length; ++intObject) {
                o_LiveShowObjectInterface = (LiveShowObjectInterface)o_Objects[intObject];
                if (o_LiveShowObjectInterface instanceof LiveShowSceneBridge || !p_LiveShowExportDescription.getSaveProject() && !p_LiveShowExportDescription.getExportProjectAll() && !o_LiveShowObjectInterface.getSelected()) continue;
                o_DMXScene = ((LiveShowDMXObject)o_LiveShowObjectInterface).getDMXScene();
                if (o_DMXScene != null && !o_ArrayListDMXScenes.contains(o_DMXScene)) {
                    o_ArrayListDMXScenes.add(o_DMXScene);
                }
                if ((o_DMXEffect = ((LiveShowDMXObject)o_LiveShowObjectInterface).getDMXEffect()) != null && !o_ArrayListDMXEffects.contains(o_DMXEffect)) {
                    o_ArrayListDMXEffects.add(o_DMXEffect);
                }
                o_ArrayListObjects.add(o_LiveShowObjectInterface);
            }
        }
        int intJingleCount = p_LiveShowExportDescription.getLiveShowJingleObjectCount(this);
        for (int intJingle = 0; intJingle < intJingleCount; ++intJingle) {
            LiveShowDMXObject o_LiveShowDMXObject;
            o_LiveShowObjectInterface = p_LiveShowExportDescription.getLiveShowJingleObject(this, intJingle);
            if (o_LiveShowObjectInterface == null || (o_DMXScene = (o_LiveShowDMXObject = (LiveShowDMXObject)o_LiveShowObjectInterface).getDMXScene()) == null) continue;
            if (!o_ArrayListDMXScenes.contains(o_DMXScene)) {
                o_ArrayListDMXScenes.add(o_DMXScene);
            }
            if ((o_DMXEffect = o_LiveShowDMXObject.getDMXEffect()) == null || o_ArrayListDMXEffects.contains(o_DMXEffect)) continue;
            o_ArrayListDMXEffects.add(o_DMXEffect);
        }
        if (!p_LiveShowExportDescription.getSaveProject() && !p_LiveShowExportDescription.getExportProjectAll() && o_ArrayListSceneBridges.size() <= 0 && o_ArrayListObjects.size() <= 0 && o_ArrayListDMXScenes.size() <= 0 && o_ArrayListDMXEffects.size() <= 0) {
            return false;
        }
        for (int intDMXScene = 0; intDMXScene < o_ArrayListDMXScenes.size(); ++intDMXScene) {
            o_DMXScene = (DMXScene)o_ArrayListDMXScenes.get(intDMXScene);
            for (intDMXDevice = 0; intDMXDevice < DMXDevice.getDMXDeviceCount(); ++intDMXDevice) {
                o_DMXDevice = DMXDevice.getDMXDevice(intDMXDevice);
                if (o_DMXDevice == null || !o_DMXScene.isDimmerOn(o_DMXDevice) || o_ArrayListDMXDevices.contains(o_DMXDevice)) continue;
                o_ArrayListDMXDevices.add(o_DMXDevice);
            }
        }
        for (int intDMXEffect = 0; intDMXEffect < o_ArrayListDMXEffects.size(); ++intDMXEffect) {
            o_DMXEffect = (DMXEffect)o_ArrayListDMXEffects.get(intDMXEffect);
            for (intDMXDevice = 0; intDMXDevice < DMXDevice.getDMXDeviceCount(); ++intDMXDevice) {
                o_DMXDevice = DMXDevice.getDMXDevice(intDMXDevice);
                if (o_DMXDevice == null || !o_DMXEffect.contains(o_DMXDevice) || o_ArrayListDMXDevices.contains(o_DMXDevice)) continue;
                o_ArrayListDMXDevices.add(o_DMXDevice);
            }
        }
        out.writeDouble(FRAMETIME);
        out.writeInt(this.m_LiveShowVIPTracks.size());
        out.writeInt(o_ArrayListSceneBridges.size());
        for (int intDMXSceneBridge = 0; intDMXSceneBridge < o_ArrayListSceneBridges.size(); ++intDMXSceneBridge) {
            o_LiveShowObjectInterface = (LiveShowObjectInterface)o_ArrayListSceneBridges.get(intDMXSceneBridge);
            o_LiveShowObjectInterface.getDescription().writeExternal(out);
            p_LiveShowExportDescription.addLiveShowSceneBridge(this, (LiveShowSceneBridge)o_LiveShowObjectInterface);
        }
        out.writeInt(o_ArrayListObjects.size());
        for (int intDMXObject = 0; intDMXObject < o_ArrayListObjects.size(); ++intDMXObject) {
            o_LiveShowObjectInterface = (LiveShowObjectInterface)o_ArrayListObjects.get(intDMXObject);
            if (o_LiveShowObjectInterface instanceof LiveShowSceneBridge) continue;
            o_LiveShowObjectInterface.getDescription().writeExternal(out);
            p_LiveShowExportDescription.addLiveShowObject(this, o_LiveShowObjectInterface);
        }
        if (p_LiveShowExportDescription.getSaveProject() || p_LiveShowExportDescription.getExportProjectAll()) {
            LiveShowDMXSystem.saveDMXScenes(p_LiveShowProjectDescription, null);
            LiveShowDMXSystem.saveDMXEffects(p_LiveShowProjectDescription, null);
            LiveShowDMXSystem.saveDMXUniverses(p_LiveShowProjectDescription, null);
            LiveShowDMXSystem.saveDMXPowerSources(p_LiveShowProjectDescription, null);
            LiveShowDMXSystem.saveDMXHardwares(p_LiveShowProjectDescription);
            LiveShowDMXSystem.saveDMXMixerPanels(p_LiveShowProjectDescription);
        } else {
            LiveShowDMXSystem.saveDMXScenes(p_LiveShowProjectDescription, o_ArrayListDMXScenes);
            LiveShowDMXSystem.saveDMXEffects(p_LiveShowProjectDescription, o_ArrayListDMXEffects);
            LiveShowDMXSystem.saveDMXUniverses(p_LiveShowProjectDescription, o_ArrayListDMXDevices);
            LiveShowDMXSystem.saveDMXPowerSources(p_LiveShowProjectDescription, o_ArrayListDMXDevices);
            LiveShowDMXSystem.deleteDMXHardwares(p_LiveShowProjectDescription);
            LiveShowDMXSystem.deleteDMXMixerPanels(p_LiveShowProjectDescription);
        }
        return true;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }

    public void readExternal_Objects(ObjectInput in, LiveShow_ImportDescription p_LiveShow_ImportDescription) throws IOException, ClassNotFoundException {
        if (p_LiveShow_ImportDescription == null) {
            return;
        }
        int intSoftwareVersion = in.readInt();
        if (intSoftwareVersion >= 2) {
            boolean boolActive = in.readBoolean();
            if (p_LiveShow_ImportDescription.getLoadNewProject()) {
                this.m_Active = boolActive;
            }
        }
        boolean boolOK = true;
        double doubleFrameTime = in.readDouble();
        int intTrackCount = in.readInt();
        if (intTrackCount <= 0) {
            intTrackCount = 1;
        }
        if (p_LiveShow_ImportDescription.getLoadNewProject()) {
            this.createPlay();
            if (intTrackCount > this.m_LiveShowVIPTracks.size()) {
                for (int intTrack = this.m_LiveShowVIPTracks.size(); intTrack < intTrackCount; ++intTrack) {
                    this.createLiveShowVipTrack();
                }
            }
        } else if (FRAMETIME != doubleFrameTime) {
            boolOK = false;
        }
        if (boolOK) {
            LiveShowDMXObjectDescription o_LiveShowDMXObjectDescription;
            int intObject;
            int intObjectCount = in.readInt();
            for (intObject = 0; intObject < intObjectCount; ++intObject) {
                o_LiveShowDMXObjectDescription = LiveShowDMXObjectDescription.poolGet(false);
                o_LiveShowDMXObjectDescription.readExternal(in);
                p_LiveShow_ImportDescription.checkImportObject(this, o_LiveShowDMXObjectDescription);
                LiveShowSceneBridge o_LiveShowDMXSceneBridge = this.createLiveShowSceneBridge(o_LiveShowDMXObjectDescription);
                this.addLiveShowSceneBridge(o_LiveShowDMXSceneBridge, o_LiveShowDMXSceneBridge.getFrameStart());
                p_LiveShow_ImportDescription.addLiveShowSceneBridge(this, o_LiveShowDMXSceneBridge);
                o_LiveShowDMXObjectDescription.close(true);
            }
            this.refreshJumps();
            intObjectCount = in.readInt();
            for (intObject = 0; intObject < intObjectCount; ++intObject) {
                o_LiveShowDMXObjectDescription = LiveShowDMXObjectDescription.poolGet(false);
                o_LiveShowDMXObjectDescription.readExternal(in);
                DMXScene o_DMXScene = DMXScene.getDMXScene(o_LiveShowDMXObjectDescription.getSourceString());
                if (o_DMXScene != null) {
                    o_LiveShowDMXObjectDescription.setSourceName(o_DMXScene.getName());
                } else {
                    o_LiveShowDMXObjectDescription.setSourceName("");
                }
                int intVipTrackNumber = o_LiveShowDMXObjectDescription.getVIPTrackNumber();
                if (intVipTrackNumber >= 0) {
                    if (intVipTrackNumber >= this.m_LiveShowVIPTracks.size()) {
                        for (int intVipTrack = this.m_LiveShowVIPTracks.size(); intVipTrack <= intVipTrackNumber; ++intVipTrack) {
                            this.createLiveShowVipTrack();
                        }
                    }
                    p_LiveShow_ImportDescription.checkImportObject(this, o_LiveShowDMXObjectDescription);
                    LiveShowObjectInterface o_LiveShowObjectInterface = this.createLiveShowObject(o_LiveShowDMXObjectDescription);
                    if (o_LiveShowObjectInterface == null) continue;
                    LiveShowVIPTrack o_LiveShowDMXVIPTrack = (LiveShowVIPTrack)this.m_LiveShowVIPTracks.get(o_LiveShowObjectInterface.getVIPTrackNumber());
                    if (o_LiveShowDMXVIPTrack != null) {
                        o_LiveShowDMXVIPTrack.addLiveShowObjectInterface(o_LiveShowObjectInterface, o_LiveShowObjectInterface.getFrameStart());
                        p_LiveShow_ImportDescription.addLiveShowObject(this, o_LiveShowObjectInterface);
                    }
                }
                o_LiveShowDMXObjectDescription.close(true);
            }
        }
        if (this.m_LiveShowVIPTracks.size() == 0) {
            this.createLiveShowVipTrack();
        }
        this.calculateFramesToNextSceneBridge();
        this.notifyLiveShowVIPListeners_MaxFrame(this.getFramePositionMax());
        LiveShowTimer.selfReference().addLiveShowVIP(this);
        if (!p_LiveShow_ImportDescription.getLoadNewProject()) {
            this.m_LiveShowDMXVIPAdjustment.calculateAdjustment();
        }
    }

    @Override
    public long getDiskSpaceEstimated(File p_ExportDirectory, boolean p_OnlySelectedObjects, ArrayList<Object> p_SourceObjects) {
        DMXUniverse o_DMXUniverse;
        DMXDevice o_DMXDevice;
        int intDMXDevice;
        DMXEffect o_DMXEffect;
        DMXScene o_DMXScene;
        long longBytesCount = 0L;
        ArrayList<DMXScene> o_DMXScenes = new ArrayList<DMXScene>();
        ArrayList<DMXEffect> o_DMXEffects = new ArrayList<DMXEffect>();
        ArrayList<DMXDevice> o_DMXDevices = new ArrayList<DMXDevice>();
        ArrayList<Object> o_DMXUniverses = new ArrayList();
        longBytesCount += 4L;
        ++longBytesCount;
        longBytesCount += 8L;
        longBytesCount += 4L;
        longBytesCount += 4L;
        longBytesCount += 4L;
        Object[] o_Objects = this.m_LiveShowObjects.toArray();
        for (int intObject = 0; intObject < o_Objects.length; ++intObject) {
            LiveShowObjectInterface o_LiveShowObjectInterface = (LiveShowObjectInterface)o_Objects[intObject];
            if (p_OnlySelectedObjects && !o_LiveShowObjectInterface.getSelected()) continue;
            if (o_LiveShowObjectInterface instanceof LiveShowSceneBridge) {
                longBytesCount += o_LiveShowObjectInterface.getDiskSpaceEstimated();
                continue;
            }
            if (!(o_LiveShowObjectInterface instanceof LiveShowDMXObject)) continue;
            longBytesCount += o_LiveShowObjectInterface.getDiskSpaceEstimated();
            if (!p_OnlySelectedObjects) continue;
            o_DMXScene = ((LiveShowDMXObject)o_LiveShowObjectInterface).getDMXScene();
            if (o_DMXScene != null) {
                if (!o_DMXScenes.contains(o_DMXScene)) {
                    o_DMXScenes.add(o_DMXScene);
                }
                if (!(p_SourceObjects != null && p_SourceObjects.contains(o_DMXScene) || p_SourceObjects == null)) {
                    p_SourceObjects.add(o_DMXScene);
                }
            }
            if ((o_DMXEffect = ((LiveShowDMXObject)o_LiveShowObjectInterface).getDMXEffect()) != null) {
                if (!o_DMXEffects.contains(o_DMXScene)) {
                    o_DMXEffects.add(o_DMXEffect);
                }
                if (!(p_SourceObjects != null && p_SourceObjects.contains(o_DMXEffect) || p_SourceObjects == null)) {
                    p_SourceObjects.add(o_DMXEffect);
                }
            }
            for (intDMXDevice = 0; intDMXDevice < DMXDevice.getDMXDeviceCount(); ++intDMXDevice) {
                o_DMXDevice = DMXDevice.getDMXDevice(intDMXDevice);
                if (o_DMXDevice == null || (o_DMXScene == null || !o_DMXScene.isDimmerOn(o_DMXDevice)) && (o_DMXEffect == null || !o_DMXEffect.contains(o_DMXDevice)) || o_DMXDevices.contains(o_DMXDevice)) continue;
                o_DMXDevices.add(o_DMXDevice);
                for (int intSector = 0; intSector < o_DMXDevice.getInternalSectorCount(); ++intSector) {
                    o_DMXUniverse = o_DMXDevice.getDMXUniverse(intSector);
                    if (o_DMXUniverse == null || o_DMXUniverses.contains(o_DMXUniverse)) continue;
                    o_DMXUniverses.add(o_DMXUniverse);
                }
            }
        }
        if (!p_OnlySelectedObjects) {
            o_DMXScenes.clear();
            o_DMXScenes.addAll(DMXScene.getDMXScenes());
            o_DMXEffects.clear();
            o_DMXEffects.addAll(DMXEffect.getDMXEffects());
            if (p_SourceObjects != null) {
                p_SourceObjects.addAll(o_DMXScenes);
            }
            o_DMXDevices.clear();
            o_DMXDevices.addAll(DMXDevice.getTreeModel_Device_Channels().getDMXDevices());
            o_DMXUniverses.clear();
            o_DMXUniverses = DMXUniverse.getDMXUniverses();
        }
        for (int intDMXScene = 0; intDMXScene < o_DMXScenes.size(); ++intDMXScene) {
            o_DMXScene = (DMXScene)o_DMXScenes.get(intDMXScene);
            if (o_DMXScene == null) continue;
            longBytesCount += o_DMXScene.getDiskSpaceEstimated();
        }
        for (int intDMXEffect = 0; intDMXEffect < o_DMXEffects.size(); ++intDMXEffect) {
            o_DMXEffect = (DMXEffect)o_DMXEffects.get(intDMXEffect);
            if (o_DMXEffect == null) continue;
            longBytesCount += o_DMXEffect.getDiskSpaceEstimated();
        }
        ArrayList<DMXDeviceType> o_DMXDeviceTypes = new ArrayList<DMXDeviceType>();
        for (intDMXDevice = 0; intDMXDevice < o_DMXDevices.size(); ++intDMXDevice) {
            o_DMXDevice = (DMXDevice)o_DMXDevices.get(intDMXDevice);
            if (o_DMXDevice == null) continue;
            longBytesCount += o_DMXDevice.getDiskSpaceEstimated();
            DMXDeviceType o_DMXDeviceType = o_DMXDevice.getDMXDeviceType();
            if (o_DMXDeviceType == null || o_DMXDeviceTypes.contains(o_DMXDeviceType)) continue;
            o_DMXDeviceTypes.add(o_DMXDeviceType);
            longBytesCount += o_DMXDeviceType.getDiskSpaceEstimated();
        }
        for (int intDMXUniverse = 0; intDMXUniverse < o_DMXUniverses.size(); ++intDMXUniverse) {
            o_DMXUniverse = (DMXUniverse)o_DMXUniverses.get(intDMXUniverse);
            if (o_DMXUniverse == null) continue;
            longBytesCount += o_DMXUniverse.getDiskSpaceEstimated();
        }
        return longBytesCount;
    }

    public static boolean saveDMXVIP(LiveShowDMXVIP o_LiveShowDMXVIP, LiveShowProjectDescription p_LiveShowProjectDescription, LiveShow_ExportDescription p_LiveShowExportDescription) {
        if (o_LiveShowDMXVIP == null) {
            return false;
        }
        if (p_LiveShowProjectDescription == null) {
            return false;
        }
        if (p_LiveShowExportDescription == null) {
            return false;
        }
        FileOutputStream o_OutputStream = null;
        ObjectOutputStream o_ObjectOutput = null;
        boolean boolHasSomething = true;
        boolean boolError = false;
        File o_File = new File(p_LiveShowProjectDescription.getProjectPathName() + FILESUFFIX);
        if (o_File.exists()) {
            o_File.delete();
        }
        try {
            o_OutputStream = new FileOutputStream(o_File);
            o_ObjectOutput = new ObjectOutputStream(o_OutputStream);
            o_ObjectOutput.writeInt(21);
            boolHasSomething = o_LiveShowDMXVIP.writeExternal_Objects(o_ObjectOutput, p_LiveShowProjectDescription, p_LiveShowExportDescription);
            o_ObjectOutput.close();
            ((OutputStream)o_OutputStream).close();
            if (!boolHasSomething) {
                LiveShowDMXVIP.deleteDMXVIP(o_LiveShowDMXVIP, p_LiveShowProjectDescription);
            }
        }
        catch (Exception e) {
            boolError = true;
            System.out.println("Error cannot write LiveShowDMXVIP: " + o_File.getAbsolutePath());
            try {
                if (o_ObjectOutput != null) {
                    o_ObjectOutput.close();
                }
                if (o_OutputStream != null) {
                    ((OutputStream)o_OutputStream).close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return boolError;
    }

    public static boolean deleteDMXVIP(LiveShowDMXVIP o_LiveShowDMXVIP, LiveShowProjectDescription p_LiveShowProjectDescription) {
        if (o_LiveShowDMXVIP == null) {
            return false;
        }
        if (p_LiveShowProjectDescription == null) {
            return false;
        }
        boolean boolSuccess = false;
        File o_File = new File(p_LiveShowProjectDescription.getProjectPathName() + FILESUFFIX);
        if (o_File.exists()) {
            boolSuccess = o_File.delete();
        }
        LiveShowDMXSystem.deleteDMXHardwares(p_LiveShowProjectDescription);
        LiveShowDMXSystem.deleteDMXUniverses(p_LiveShowProjectDescription);
        LiveShowDMXSystem.deleteDMXPowerSources(p_LiveShowProjectDescription);
        LiveShowDMXSystem.deleteDMXMixerPanels(p_LiveShowProjectDescription);
        LiveShowDMXSystem.deleteDMXScenes(p_LiveShowProjectDescription);
        return boolSuccess;
    }

    public static LiveShowDMXVIP loadDMXVIP(LiveShowDMXVIP p_LiveShowDMXVIP, LiveShowProjectDescription p_LiveShowProjectDescription, LiveShow_ImportDescription p_LiveShow_ImportDescription, LiveShowNotification p_LiveShowNotification) {
        s_LoadException = null;
        if (p_LiveShowDMXVIP == null) {
            return null;
        }
        if (p_LiveShowProjectDescription == null) {
            return null;
        }
        FileInputStream o_InputStream = null;
        ObjectInputStream o_ObjectInput = null;
        p_LiveShowNotification.setActionText(LiveShowDMXSystem.NOTIFICATION_ACTION_LOAD_DMXHARDWARE);
        LiveShowDMXSystem.loadDMXHardwares(p_LiveShowProjectDescription, p_LiveShow_ImportDescription);
        p_LiveShowNotification.setActionText(LiveShowDMXSystem.NOTIFICATION_ACTION_LOAD_DMXUNIVERSES);
        LiveShowDMXSystem.loadDMXUniverses(p_LiveShowProjectDescription, p_LiveShow_ImportDescription);
        p_LiveShowNotification.setActionText(LiveShowDMXSystem.NOTIFICATION_ACTION_LOAD_DMXPOWERSOURCES);
        LiveShowDMXSystem.loadDMXPowerSources(p_LiveShowProjectDescription, p_LiveShow_ImportDescription);
        p_LiveShowNotification.setActionText(LiveShowDMXSystem.NOTIFICATION_ACTION_LOAD_DMXMIXERS);
        LiveShowDMXSystem.loadDMXMixerPanels(p_LiveShowProjectDescription, p_LiveShow_ImportDescription);
        p_LiveShowNotification.setActionText(LiveShowDMXSystem.NOTIFICATION_ACTION_LOAD_DMXSCENES);
        LiveShowDMXSystem.loadDMXScenes(p_LiveShowProjectDescription, p_LiveShow_ImportDescription);
        p_LiveShowNotification.setActionText(LiveShowDMXSystem.NOTIFICATION_ACTION_LOAD_DMXEFFECTS);
        LiveShowDMXSystem.loadDMXEffects(p_LiveShowProjectDescription, p_LiveShow_ImportDescription);
        p_LiveShowNotification.setActionText(LiveShowDMXSystem.NOTIFICATION_ACTION_LOAD_DMXUNIVERSES_READ);
        LiveShowDMXSystem.readAllDMXUniverses();
        p_LiveShowNotification.setActionText(LiveShowDMXSystem.NOTIFICATION_ACTION_LOAD_DMX);
        File o_File = new File(p_LiveShowProjectDescription.getProjectPathName() + FILESUFFIX);
        if (!o_File.exists()) {
            if (p_LiveShow_ImportDescription.getLoadNewProject()) {
                p_LiveShowDMXVIP.initializeVIP();
            }
            return p_LiveShowDMXVIP;
        }
        try {
            o_InputStream = new FileInputStream(o_File);
            o_ObjectInput = new ObjectInputStream(o_InputStream);
            int intSoftwareVersion = o_ObjectInput.readInt();
            p_LiveShowDMXVIP.setLiveShowNotification(p_LiveShowNotification);
            p_LiveShowDMXVIP.readExternal_Objects(o_ObjectInput, p_LiveShow_ImportDescription);
            o_ObjectInput.close();
            ((InputStream)o_InputStream).close();
        }
        catch (Exception e) {
            s_LoadException = e;
            System.err.println("Error LiveShowDMXVIP loadLiveShowDMXVIP File: " + o_File.getAbsolutePath());
            e.printStackTrace();
            try {
                if (o_ObjectInput != null) {
                    o_ObjectInput.close();
                }
                if (o_InputStream != null) {
                    ((InputStream)o_InputStream).close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return p_LiveShowDMXVIP;
        }
        return p_LiveShowDMXVIP;
    }

    private void initMembers() {
        super.setType("DMX");
        this.m_LiveShowDMXVIPAdjustment = new LiveShowDMXVIPAdjustment(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        LiveShowTimer.selfReference().removeLiveShowVIP(this);
        this.m_LiveShowDMXVIPAdjustment.close();
        super.close();
        Object object = s_SyncDMXObjects_LastRead;
        synchronized (object) {
            s_LiveShowDMXObjects_LastRead.clear();
        }
        if (this.m_VipTrackDMXPlayObject != null) {
            this.m_VipTrackDMXPlayObject.close();
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    @Override
    public boolean accepts(LiveShowObjectInterface p_LiveShowObjectInterface) {
        if (p_LiveShowObjectInterface == null) {
            return false;
        }
        if (p_LiveShowObjectInterface.getObjectType() == 11) {
            return true;
        }
        return p_LiveShowObjectInterface.getObjectType() == 12;
    }

    @Override
    public DataFlavor getDataFlavor() {
        return LiveShowDragDrop.LiveShowTransferable.DMXOBJECTFLAVOUR;
    }

    @Override
    public FlavorMap getDataFlavorMap() {
        return LiveShowDragDrop.LiveShowTransferable.getFlavorMapDMX();
    }

    public LiveShowDMXVIPAdjustment getLiveShowDMXVIPAdjustment() {
        return this.m_LiveShowDMXVIPAdjustment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LiveShowVIPTrack createLiveShowVipTrack() {
        LiveShowDMXVIPTrack o_LiveShowDMXVIPTrack = null;
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return null;
        }
        Object object = this.m_SyncVIPTracks;
        synchronized (object) {
            o_LiveShowDMXVIPTrack = new LiveShowDMXVIPTrack(this);
            this.addLiveShowVIPTrack(o_LiveShowDMXVIPTrack);
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        return o_LiveShowDMXVIPTrack;
    }

    @Override
    public LiveShowObjectInterface createLiveShowObject(LiveShowObjectDescription p_LiveShowObjectDescription) {
        if (p_LiveShowObjectDescription == null) {
            return null;
        }
        if (p_LiveShowObjectDescription.getObjectType() != 11) {
            return null;
        }
        LiveShowDMXObject o_LiveShowDMXObject = new LiveShowDMXObject((LiveShowDMXObjectDescription)p_LiveShowObjectDescription);
        if (o_LiveShowDMXObject.getSource() == null) {
            o_LiveShowDMXObject.close(true);
            o_LiveShowDMXObject = null;
        }
        return o_LiveShowDMXObject;
    }

    @Override
    public LiveShowSceneBridge createLiveShowSceneBridge(LiveShowObjectDescription p_LiveShowObjectDescription) {
        if (p_LiveShowObjectDescription == null) {
            long longLength = LiveShowSceneBridge.DEFAULTFRAMELENGTHSCENEBRIDGE;
            LiveShowDMXObjectDescription o_LiveShowDMXObjectDescription = LiveShowDMXObjectDescription.poolGet(true);
            o_LiveShowDMXObjectDescription.setObjectType(12);
            o_LiveShowDMXObjectDescription.setFrameStart(0L);
            o_LiveShowDMXObjectDescription.setFrameLength(longLength);
            o_LiveShowDMXObjectDescription.setFrameFadeInLength(longLength);
            o_LiveShowDMXObjectDescription.setFrameFadeOutLength(longLength);
            o_LiveShowDMXObjectDescription.setName("newSceneBridge");
            LiveShowDMXSceneBridge o_LiveShowDMXSceneBridge = new LiveShowDMXSceneBridge(o_LiveShowDMXObjectDescription);
            return o_LiveShowDMXSceneBridge;
        }
        if (p_LiveShowObjectDescription.getObjectType() != 12) {
            return null;
        }
        LiveShowDMXSceneBridge o_LiveShowDMXSceneBridge = new LiveShowDMXSceneBridge((LiveShowDMXObjectDescription)p_LiveShowObjectDescription);
        return o_LiveShowDMXSceneBridge;
    }

    @Override
    public LiveShowSceneBridge createLiveShowSceneBridge(LiveShowSceneBridgeMain p_LiveShowSceneBridgeMain, LiveShowObjectDescription p_LiveShowObjectDescription) {
        if (p_LiveShowObjectDescription == null) {
            return null;
        }
        if (p_LiveShowSceneBridgeMain == null) {
            return null;
        }
        LiveShowDMXObjectDescription o_LiveShowObjectDescription = LiveShowDMXObjectDescription.poolGet(true);
        o_LiveShowObjectDescription.setID(p_LiveShowSceneBridgeMain.getID());
        o_LiveShowObjectDescription.setObjectType(12);
        o_LiveShowObjectDescription.setName(p_LiveShowObjectDescription.getName());
        o_LiveShowObjectDescription.setIsMainBridge(true);
        long longLength = p_LiveShowObjectDescription.getFrameLength();
        o_LiveShowObjectDescription.setFrameStart(p_LiveShowObjectDescription.getFrameStart());
        o_LiveShowObjectDescription.setFrameLength(longLength);
        o_LiveShowObjectDescription.setFrameFadeInLength(longLength);
        o_LiveShowObjectDescription.setFrameFadeOutLength(longLength);
        o_LiveShowObjectDescription.setStopAtStart(p_LiveShowObjectDescription.getStopAtStart());
        o_LiveShowObjectDescription.setActive(p_LiveShowObjectDescription.getActive());
        LiveShowDMXSceneBridge o_LiveShowMediaSceneBridge = new LiveShowDMXSceneBridge(o_LiveShowObjectDescription);
        this.addLiveShowSceneBridge(o_LiveShowMediaSceneBridge, o_LiveShowMediaSceneBridge.getFrameStart());
        return o_LiveShowMediaSceneBridge;
    }

    @Override
    public boolean addLiveShowObject(LiveShowObjectInterface p_LiveShowObjectInterface) {
        boolean boolAdded = super.addLiveShowObject(p_LiveShowObjectInterface);
        if (boolAdded && p_LiveShowObjectInterface.getIsJingle()) {
            this.m_Play.addLiveShowObjectInterface_Jingle((LiveShowDMXObject)p_LiveShowObjectInterface);
        }
        return boolAdded;
    }

    @Override
    public boolean removeLiveShowObject(LiveShowObjectInterface p_LiveShowObjectInterface) {
        boolean boolAdded = super.removeLiveShowObject(p_LiveShowObjectInterface);
        if (boolAdded && p_LiveShowObjectInterface.getIsJingle()) {
            this.m_Play.removeLiveShowObjectInterface_Jingle((LiveShowDMXObject)p_LiveShowObjectInterface);
        }
        return boolAdded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Playable.PlayObject read(Play p_Play, Playable.PlayObject p_PlayObject) {
        if (p_PlayObject == null) {
            return null;
        }
        if (p_PlayObject.getFramePosition() < 0L) {
            return null;
        }
        if (p_PlayObject.getData() == null) {
            return null;
        }
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return null;
        }
        Playable.PlayObject o_PlayObject = null;
        Object object = this.m_SyncPlay;
        synchronized (object) {
            p_PlayObject.clear();
            LiveShowSceneBridge o_ActualSceneBridge = this.m_ActualSceneBridge;
            if (o_ActualSceneBridge != null) {
                o_PlayObject = o_ActualSceneBridge.read(p_Play, p_PlayObject, o_ActualSceneBridge, -1L, 1.0, false);
                Object object2 = s_SyncDMXObjects_LastRead;
                synchronized (object2) {
                    s_LiveShowDMXObjects_LastRead.clear();
                }
            }
            Object object3 = s_SyncDMXObjects_LastRead;
            synchronized (object3) {
                s_LiveShowDMXObjects_LastRead.clear();
            }
            DMXEffect_PlayContainer o_DMXEffect_PlayContainer = ((PlayDMX)p_Play).getDMXEffect_PlayContainer();
            o_DMXEffect_PlayContainer.reset();
            o_PlayObject = this.readInternal(p_Play, p_PlayObject, null, -1L, 1.0, false);
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        if (!this.m_Active) {
            return null;
        }
        return o_PlayObject;
    }

    @Override
    public Playable.PlayObject readInternal(Play p_Play, Playable.PlayObject p_PlayObject, LiveShowSceneBridge p_LiveShowSceneBridge, long p_SceneBridgeFrameInside, double p_SceneBridgeFadeProgress, boolean p_IsPreObject) {
        if (!this.m_Active) {
            return p_PlayObject;
        }
        if (p_PlayObject == null) {
            return null;
        }
        if (p_PlayObject.getFramePosition() < 0L) {
            return null;
        }
        if (p_PlayObject.getData() == null) {
            return null;
        }
        if (!(p_PlayObject instanceof PlayDMX.DMXPlayObject)) {
            return null;
        }
        PlayDMX.DMXPlayObject o_DMXPlayObject = (PlayDMX.DMXPlayObject)p_PlayObject;
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return null;
        }
        PlayDMX.DMXPlayObject o_Result = null;
        if (this.m_VipTrackDMXPlayObject == null) {
            this.m_VipTrackDMXPlayObject = new PlayDMX.DMXPlayObject(this);
        }
        if (this.m_VipTrackDMXPlayObject.getFramesBuffered() != o_DMXPlayObject.getFramesBuffered()) {
            this.m_VipTrackDMXPlayObject.setFramesBuffered(o_DMXPlayObject.getFramesBuffered());
        }
        this.m_VipTrackDMXPlayObject.setFramePosition(o_DMXPlayObject.getFramePosition());
        this.m_VipTrackDMXPlayObject.setFramesToRead(o_DMXPlayObject.getFramesToRead());
        for (int intTrack = 0; intTrack < this.m_LiveShowVIPTracks.size(); ++intTrack) {
            PlayDMX.DMXPlayObject o_PlayObjectTrack;
            LiveShowDMXVIPTrack o_LiveShowDMXVIPTrack = (LiveShowDMXVIPTrack)this.m_LiveShowVIPTracks.get(intTrack);
            if (o_LiveShowDMXVIPTrack == null || (o_PlayObjectTrack = (PlayDMX.DMXPlayObject)o_LiveShowDMXVIPTrack.read(p_Play, o_DMXPlayObject, p_LiveShowSceneBridge, p_SceneBridgeFrameInside, p_SceneBridgeFadeProgress, p_IsPreObject)) == null) continue;
            o_Result = o_DMXPlayObject;
        }
        if (p_LiveShowSceneBridge == null) {
            o_Result = (PlayDMX.DMXPlayObject)this.m_LiveShowDMXVIPAdjustment.readInternal(p_Play, o_DMXPlayObject, null, -1L, 1.0, false);
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        return o_Result;
    }

    @Override
    public void startSceneBridge(LiveShowSceneBridge p_LiveShowSceneBridge, boolean p_WillPlay) {
        super.startSceneBridge(p_LiveShowSceneBridge, p_WillPlay);
        this.notifyDMXDevices_ActualSceneBridge(p_LiveShowSceneBridge);
    }

    @Override
    public void setSceneBridgeCursorChanged(LiveShowSceneBridge p_LiveShowSceneBridge) {
        this.notifyDMXDevices_ActualSceneBridge(p_LiveShowSceneBridge);
    }

    public void notifyDMXDevices_ActualSceneBridge(LiveShowSceneBridge p_LiveShowSceneBridge) {
        DMXDevice o_DMXDevice;
        if (p_LiveShowSceneBridge == null) {
            return;
        }
        int intDMXDeviceCount = DMXDevice.getDMXDeviceCount();
        for (int intDMXDevice = 0; intDMXDevice < intDMXDeviceCount && (o_DMXDevice = DMXDevice.getDMXDevice(intDMXDevice)) != null; ++intDMXDevice) {
            o_DMXDevice.setSceneBridge_Actual(p_LiveShowSceneBridge);
        }
    }

    @Override
    public ImageIcon getImageIcon() {
        return s_Icon;
    }

    @Override
    public void setEditModeOn(boolean p_EditModeOn, boolean p_SetEditModusFriends) {
        super.setEditModeOn(p_EditModeOn, p_SetEditModusFriends);
        DMXDevice.setEditModeOn(p_EditModeOn);
    }

    @Override
    public long checkSnappingSpecial(long p_ActorFramePosition, int p_ActorLabelType, LiveShowObjectDescription p_LiveShowObjectDescription, boolean p_ObjectItself) {
        long longFramePositionEndEffect;
        long longFramePositionDelay;
        long longFramePositionCheck;
        if (p_LiveShowObjectDescription == null) {
            return p_ActorFramePosition;
        }
        if (!(p_LiveShowObjectDescription instanceof LiveShowDMXObjectDescription)) {
            return p_ActorFramePosition;
        }
        if (p_ObjectItself) {
            switch (p_ActorLabelType) {
                case 5: {
                    break;
                }
                default: {
                    return p_ActorFramePosition;
                }
            }
        }
        boolean boolSnapped = false;
        LiveShowDMXObjectDescription o_LiveShowDMXObjectDescription = (LiveShowDMXObjectDescription)p_LiveShowObjectDescription;
        if (o_LiveShowDMXObjectDescription.getEffectSourceString() == null) {
            return p_ActorFramePosition;
        }
        long longNewFramePosition = p_ActorFramePosition;
        long longFrameObjectStart = o_LiveShowDMXObjectDescription.getFrameStart();
        ArrayList<Double> o_DMXEffectsParameters = o_LiveShowDMXObjectDescription.getEffectParameters();
        long longEffectLoops = DMXEffect.getLoops(o_DMXEffectsParameters);
        long longEffectDelay = DMXEffect.getDelay(o_DMXEffectsParameters);
        long longEffectDuration = DMXEffect.getDuration(o_DMXEffectsParameters);
        if (longEffectDelay > 0L && Math.abs((longFramePositionCheck = longFrameObjectStart + (longFramePositionDelay = DMXEffect.getFramePosition(longEffectDelay))) - p_ActorFramePosition) < this.getSnapFramesDistance()) {
            longNewFramePosition = longFramePositionCheck;
            boolSnapped = true;
        }
        if ((longFramePositionEndEffect = DMXEffect.getFramePosition(longEffectDelay + longEffectDuration * longEffectLoops)) > 0L && Math.abs((longFramePositionCheck = longFrameObjectStart + longFramePositionEndEffect) - p_ActorFramePosition) < this.getSnapFramesDistance()) {
            if (!boolSnapped) {
                longNewFramePosition = longFramePositionCheck;
            } else if (Math.abs(p_ActorFramePosition - longFramePositionCheck) < Math.abs(p_ActorFramePosition - longNewFramePosition)) {
                longNewFramePosition = longFramePositionCheck;
            }
            boolSnapped = true;
        }
        return longNewFramePosition;
    }

    public void createDMXObjectsBetweenEmptySceneBridges() {
        boolean boolObjectsAdded = false;
        LiveShowVIP.LiveShowVIPStatus o_LiveShowVIPStatus = new LiveShowVIP.LiveShowVIPStatus();
        LiveShowSceneBridge o_LiveShowSceneBridge_Start = null;
        LiveShowSceneBridge o_LiveShowSceneBridge_End = null;
        int intSceneBridgeCount = this.getLiveShowSceneBridgeCount();
        this.clearSelectedObjects(true);
        int intLastObjectIndex = 0;
        this.startUndoAction(11, LiveShowUndo.ACTION_ADD_STRING, null);
        for (int intBridge = 0; intBridge < intSceneBridgeCount - 1; ++intBridge) {
            o_LiveShowSceneBridge_Start = this.getLiveShowSceneBridge(intBridge);
            if (intBridge < intSceneBridgeCount - 1) {
                o_LiveShowSceneBridge_End = this.getLiveShowSceneBridge(intBridge + 1);
            }
            if (o_LiveShowSceneBridge_Start == null || o_LiveShowSceneBridge_End == null) continue;
            LiveShowObjectInterface o_LiveShowObject_Existing = null;
            int intObjectCount = this.getLiveShowObjectInterfaceCount();
            for (int intObject = intLastObjectIndex; intObject < intObjectCount; ++intObject) {
                LiveShowObjectInterface o_LiveShowObjectInterface = this.getLiveShowObjectInterface(intObject);
                if (o_LiveShowObjectInterface == null || o_LiveShowObjectInterface instanceof LiveShowSceneBridge) continue;
                if (o_LiveShowObjectInterface.getFrameStart() + o_LiveShowObjectInterface.getFrameLength() <= o_LiveShowSceneBridge_Start.getFrameStart() + o_LiveShowSceneBridge_Start.getFrameLength()) {
                    intLastObjectIndex = intObject;
                    continue;
                }
                if (o_LiveShowObjectInterface.getFrameStart() >= o_LiveShowSceneBridge_End.getFrameStart()) break;
                if (o_LiveShowObject_Existing != null) continue;
                o_LiveShowObject_Existing = o_LiveShowObjectInterface;
                break;
            }
            if (o_LiveShowObject_Existing != null || (o_LiveShowObject_Existing = this.createNewDMXObject(o_LiveShowSceneBridge_Start.getName(), 0, o_LiveShowSceneBridge_Start.getFrameStart(), o_LiveShowSceneBridge_End.getFrameStart())) == null) continue;
            boolObjectsAdded = true;
            o_LiveShowVIPStatus.addLiveShowObjectDescription_ForAction(o_LiveShowObject_Existing.getDescription());
            this.addSelectedObject(o_LiveShowObject_Existing);
        }
        this.endUndoAction(11, boolObjectsAdded, o_LiveShowVIPStatus);
        LiveShowDMXVIPAdjustment.calculateAdjustmentAll();
    }

    private LiveShowDMXObject createNewDMXObject(String p_Name, int p_VipTrackNumber, long p_FrameStart, long p_FrameEnd) {
        LiveShowVIPTrack o_LiveShowDMXVIPTrack = this.getLiveShowVIPTrack(p_VipTrackNumber);
        if (o_LiveShowDMXVIPTrack == null) {
            o_LiveShowDMXVIPTrack = this.getLiveShowVIPTrack(0);
        }
        if (o_LiveShowDMXVIPTrack == null) {
            return null;
        }
        LiveShowDMXObjectDescription o_LiveShowDMXObjectDescription = new LiveShowDMXObjectDescription(true);
        o_LiveShowDMXObjectDescription.setObjectType(11);
        o_LiveShowDMXObjectDescription.setFrameStart(p_FrameStart);
        o_LiveShowDMXObjectDescription.setFrameLength(p_FrameEnd - p_FrameStart);
        o_LiveShowDMXObjectDescription.setVIPTrackNumber(p_VipTrackNumber);
        DMXScene o_DMXScene = DMXScene.getDMXSceneByName(p_Name);
        if (o_DMXScene == null) {
            o_DMXScene = new DMXScene();
            o_DMXScene.setName(p_Name);
            DMXScene.addDMXScene(o_DMXScene);
        }
        o_LiveShowDMXObjectDescription.setSourceName(o_DMXScene.getName());
        o_LiveShowDMXObjectDescription.setSourceString(o_DMXScene.getID());
        LiveShowDMXObject o_LiveShowDMXObject = (LiveShowDMXObject)this.createLiveShowObject(o_LiveShowDMXObjectDescription);
        o_LiveShowDMXVIPTrack.addLiveShowObjectInterface(o_LiveShowDMXObject, o_LiveShowDMXObject.getFrameStart());
        return o_LiveShowDMXObject;
    }
}

