/*
 * Decompiled with CFR 0.152.
 */
package DMXVirtualPackage;

import DMXDevicePackage.DMXDevice;
import DMXVirtualPackage.DMXFadeDescription;
import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LanguageTools.LiveLanguagePackage.LiveLanguageString;
import LiveShowObjectPackage.LiveShowObjectDescription;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;

public class LiveShowDMXObjectDescription
extends LiveShowObjectDescription {
    @LiveLanguageString
    public static String DEFAULTNAME = "DMXObject";
    public static ArrayList<LiveShowDMXObjectDescription> s_LiveShowDMXObjectDescriptionsPool = new ArrayList();
    public static ArrayList<LiveShowDMXObjectDescription> s_LiveShowDMXObjectDescriptionsPool_OnlyOneDevice = new ArrayList();
    public static final Object s_SyncDescriptions = new Object();
    private String m_DMXDeviceID;
    private boolean m_OnlyOneDMXDevice;
    private DMXFadeDescription m_DMXFadeDescription;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LiveShowDMXObjectDescription poolGet(boolean p_SetToDefault) {
        LiveShowDMXObjectDescription o_LiveShowDMXObjectDescription;
        Object object = s_SyncDescriptions;
        synchronized (object) {
            if (s_LiveShowDMXObjectDescriptionsPool.size() > 0) {
                int intIndex = s_LiveShowDMXObjectDescriptionsPool.size() - 1;
                o_LiveShowDMXObjectDescription = s_LiveShowDMXObjectDescriptionsPool.get(intIndex);
                o_LiveShowDMXObjectDescription.reactivate(p_SetToDefault);
                s_LiveShowDMXObjectDescriptionsPool.remove(intIndex);
            } else {
                o_LiveShowDMXObjectDescription = new LiveShowDMXObjectDescription(p_SetToDefault);
            }
        }
        return o_LiveShowDMXObjectDescription;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LiveShowDMXObjectDescription poolGet(String p_DMXDeviceID) {
        LiveShowDMXObjectDescription o_LiveShowDMXObjectDescription;
        Object object = s_SyncDescriptions;
        synchronized (object) {
            if (s_LiveShowDMXObjectDescriptionsPool_OnlyOneDevice.size() > 0) {
                int intIndex = s_LiveShowDMXObjectDescriptionsPool_OnlyOneDevice.size() - 1;
                o_LiveShowDMXObjectDescription = s_LiveShowDMXObjectDescriptionsPool_OnlyOneDevice.get(intIndex);
                o_LiveShowDMXObjectDescription.setDMXDeviceID(p_DMXDeviceID);
                o_LiveShowDMXObjectDescription.reactivate(true);
                s_LiveShowDMXObjectDescriptionsPool_OnlyOneDevice.remove(intIndex);
            } else {
                o_LiveShowDMXObjectDescription = new LiveShowDMXObjectDescription(p_DMXDeviceID);
            }
        }
        return o_LiveShowDMXObjectDescription;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean poolAddEmpty(LiveShowDMXObjectDescription p_LiveShowDMXObjectDescription) {
        Object object = s_SyncDescriptions;
        synchronized (object) {
            if (!p_LiveShowDMXObjectDescription.getOnlyOneDMXDevice()) {
                if (s_LiveShowDMXObjectDescriptionsPool.size() < 500) {
                    s_LiveShowDMXObjectDescriptionsPool.add(p_LiveShowDMXObjectDescription);
                    return true;
                }
            } else if (s_LiveShowDMXObjectDescriptionsPool_OnlyOneDevice.size() < 5000) {
                s_LiveShowDMXObjectDescriptionsPool_OnlyOneDevice.add(p_LiveShowDMXObjectDescription);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void poolClear() {
        Object object = s_SyncDescriptions;
        synchronized (object) {
            s_LiveShowDMXObjectDescriptionsPool.clear();
            s_LiveShowDMXObjectDescriptionsPool_OnlyOneDevice.clear();
        }
    }

    public LiveShowDMXObjectDescription() {
        this(false);
    }

    public LiveShowDMXObjectDescription(boolean p_SetToDefault) {
        this.initMembers();
        LiveLanguage.addLanguageListener((Object)this, null);
        this.m_OnlyOneDMXDevice = false;
        super.setObjectType(11);
        this.m_DMXFadeDescription = new DMXFadeDescription(p_SetToDefault);
    }

    public LiveShowDMXObjectDescription(String p_DMXDeviceID) {
        this.initMembers();
        this.m_DMXDeviceID = p_DMXDeviceID == null ? "" : p_DMXDeviceID;
        this.m_OnlyOneDMXDevice = true;
        super.setObjectType(11);
        this.m_DMXFadeDescription = new DMXFadeDescription(this.m_DMXDeviceID);
    }

    private void initMembers() {
        this.m_DMXDeviceID = "";
        this.m_OnlyOneDMXDevice = false;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        this.m_DMXFadeDescription.writeExternal(out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.m_DMXFadeDescription.readExternal(in);
        this.checkEqualsFadeSettingsToDefault();
    }

    @Override
    public long getDiskSpaceEstimated() {
        long longBytesCount = 0L;
        longBytesCount += super.getDiskSpaceEstimated();
        if (this.m_DMXFadeDescription != null) {
            longBytesCount += this.m_DMXFadeDescription.getDiskSpaceEstimated();
        }
        return longBytesCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(boolean p_Final) {
        super.close(false);
        if (this.m_DMXFadeDescription != null) {
            this.m_DMXFadeDescription.close(p_Final);
        }
        if (p_Final) {
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (this.m_Closed) {
                    return;
                }
                this.m_Closed = true;
                if (!LiveShowDMXObjectDescription.poolAddEmpty(this)) {
                    // empty if block
                }
            }
        } else {
            this.m_DMXFadeDescription = null;
        }
    }

    @Override
    public void reactivate(boolean p_SetToDefault) {
        super.reactivate(p_SetToDefault);
        if (!this.m_OnlyOneDMXDevice) {
            DMXFadeDescription o_DMXFadeDescription = this.getDMXFadeDescription();
            if (o_DMXFadeDescription == null) {
                this.m_DMXFadeDescription = new DMXFadeDescription(p_SetToDefault);
            } else {
                o_DMXFadeDescription.reactivate(p_SetToDefault);
            }
        } else {
            DMXFadeDescription o_DMXFadeDescription = this.getDMXFadeDescription();
            if (o_DMXFadeDescription == null) {
                this.m_DMXFadeDescription = new DMXFadeDescription(this.getDMXDeviceID());
            } else {
                o_DMXFadeDescription.setDMXDeviceID(this.m_DMXDeviceID);
                o_DMXFadeDescription.reactivate(p_SetToDefault);
            }
        }
    }

    public DMXFadeDescription getDMXFadeDescription() {
        return this.m_DMXFadeDescription;
    }

    @Override
    public LiveShowObjectDescription clone(LiveShowObjectDescription p_LiveShowObjectDescription) {
        LiveShowDMXObjectDescription o_LiveShowDMXObjectDescription = !this.m_OnlyOneDMXDevice ? (p_LiveShowObjectDescription == null ? LiveShowDMXObjectDescription.poolGet(false) : (LiveShowDMXObjectDescription)p_LiveShowObjectDescription) : (p_LiveShowObjectDescription == null ? LiveShowDMXObjectDescription.poolGet(this.getDMXDeviceID()) : (LiveShowDMXObjectDescription)p_LiveShowObjectDescription);
        super.clone(o_LiveShowDMXObjectDescription);
        this.m_DMXFadeDescription.copyTo(o_LiveShowDMXObjectDescription.getDMXFadeDescription());
        o_LiveShowDMXObjectDescription.checkEqualsFadeSettingsToDefault();
        return o_LiveShowDMXObjectDescription;
    }

    public boolean checkEqualsFadeSettingsToDefault() {
        boolean boolEquals = true;
        for (int intDMXDevice = 0; intDMXDevice < DMXDevice.getDMXDeviceCount(); ++intDMXDevice) {
            DMXFadeDescription.DMXDeviceFadeDescription o_DMXDeviceFadeDescription_New;
            DMXFadeDescription.DMXDeviceFadeDescription o_DMXDeviceFadeDescription_Default;
            DMXDevice o_DMXDevice = DMXDevice.getDMXDevice(intDMXDevice);
            if (o_DMXDevice == null || (o_DMXDeviceFadeDescription_Default = o_DMXDevice.getDMXDeviceType().getDefaultDMXDeviceFadeDescription()).equals(o_DMXDeviceFadeDescription_New = this.m_DMXFadeDescription.getDMXDeviceFadeDescription(o_DMXDevice.getID()))) continue;
            boolEquals = false;
            break;
        }
        this.m_EqualDefaultSettings = boolEquals;
        return boolEquals;
    }

    public boolean isEqual(LiveShowDMXObjectDescription p_LiveShowDMXObjectDescription) {
        if (!super.isEqual(p_LiveShowDMXObjectDescription)) {
            return false;
        }
        return this.m_DMXFadeDescription.isEqual(p_LiveShowDMXObjectDescription.getDMXFadeDescription());
    }

    public boolean getOnlyOneDMXDevice() {
        return this.m_OnlyOneDMXDevice;
    }

    public String getDMXDeviceID() {
        return this.m_DMXDeviceID;
    }

    public void setDMXDeviceID(String p_DMXDeviceID) {
        if (p_DMXDeviceID == null) {
            p_DMXDeviceID = "";
        }
        this.m_DMXDeviceID = p_DMXDeviceID;
    }

    public DMXDevice getDMXDevice() {
        return DMXDevice.getDMXDevice(this.m_DMXDeviceID);
    }
}

