/*
 * Decompiled with CFR 0.152.
 */
package DMXVirtualPackage;

import DMXDevicePackage.DMXDevice;
import DMXDevicePackage.DMXDeviceType;
import DMXMixer.DMXControlComponent;
import LiveShowObjectPackage.SinglePropertyChangeSupport;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class DMXFadeDescription
implements PropertyChangeListener,
Externalizable {
    public static final int SOFTWAREVERSION = 1;
    public static final int FADEIN = 0;
    public static final int FADEOUT = 1;
    public static final int FADESTART = 0;
    public static final int FADEEND = 1;
    public static final String PROP_PARAMSCHANGED = "paramsChanged";
    private String m_DMXDeviceID;
    private boolean m_OnlyOneDMXDevice;
    private HashMap<String, DMXDeviceFadeDescription> m_DMXDeviceFadeDescriptionHashMap;
    private ArrayList<DMXFadeDescriptionListener> m_DMXFadeDescriptionListeners;
    private final Object m_SyncFadeDescriptions = new Object();
    private final Object m_SyncListeners = new Object();

    public DMXFadeDescription(boolean p_SetToDefault) {
        this.initMembers();
        this.m_OnlyOneDMXDevice = false;
        this.reactivate(p_SetToDefault);
    }

    public DMXFadeDescription(String p_DMXDeviceID) {
        this.initMembers();
        this.m_DMXDeviceID = p_DMXDeviceID == null ? "" : p_DMXDeviceID;
        this.m_OnlyOneDMXDevice = true;
        this.reactivate(true);
    }

    public void setDMXDeviceID(String p_DMXDeviceID) {
        if (p_DMXDeviceID == null) {
            p_DMXDeviceID = "";
        } else {
            this.m_DMXDeviceID = p_DMXDeviceID;
        }
    }

    public void reactivate(boolean p_SetToDefault) {
        if (!this.m_OnlyOneDMXDevice) {
            DMXDevice.getTreeModel_ControlTypes_Devices().addPropertyChangeListener(this);
        }
        if (p_SetToDefault) {
            this.setToDefault();
        }
    }

    private void initMembers() {
        this.m_DMXDeviceID = "";
        this.m_OnlyOneDMXDevice = false;
        this.m_DMXDeviceFadeDescriptionHashMap = new HashMap();
        this.m_DMXFadeDescriptionListeners = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(1);
        Object object = this.m_SyncFadeDescriptions;
        synchronized (object) {
            int intDMXDeviceTypeFadeDescriptionCount = this.m_DMXDeviceFadeDescriptionHashMap.size();
            ArrayList<DMXDeviceFadeDescription> o_DMXDeviceFadeDescriptions = new ArrayList<DMXDeviceFadeDescription>(intDMXDeviceTypeFadeDescriptionCount);
            for (DMXDeviceFadeDescription o_DMXDeviceFadeDescription : this.m_DMXDeviceFadeDescriptionHashMap.values()) {
                if (o_DMXDeviceFadeDescription == null || o_DMXDeviceFadeDescription.getDMXDeviceID() == null) continue;
                o_DMXDeviceFadeDescriptions.add(o_DMXDeviceFadeDescription);
            }
            out.writeInt(o_DMXDeviceFadeDescriptions.size());
            for (int intDescription = 0; intDescription < o_DMXDeviceFadeDescriptions.size(); ++intDescription) {
                DMXDeviceFadeDescription o_DMXDeviceFadeDescription;
                o_DMXDeviceFadeDescription = (DMXDeviceFadeDescription)o_DMXDeviceFadeDescriptions.get(intDescription);
                String stringDMXDeviceID = o_DMXDeviceFadeDescription.getDMXDeviceID();
                out.writeUTF(stringDMXDeviceID);
                o_DMXDeviceFadeDescription.writeExternal(out);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int intSoftwareVersion = in.readInt();
        int intDMXDeviceTypeFadeDescriptionCount = in.readInt();
        for (int intDescription = 0; intDescription < intDMXDeviceTypeFadeDescriptionCount; ++intDescription) {
            DMXDeviceFadeDescription o_DMXDeviceFadeDescription;
            String stringDMXDeviceID = in.readUTF();
            DMXDevice o_DMXDevice = DMXDevice.getDMXDevice(stringDMXDeviceID);
            if (o_DMXDevice == null) {
                o_DMXDeviceFadeDescription = new DMXDeviceFadeDescription(stringDMXDeviceID);
                o_DMXDeviceFadeDescription.readExternal(in);
                o_DMXDeviceFadeDescription.close();
                continue;
            }
            Object object = this.m_SyncFadeDescriptions;
            synchronized (object) {
                o_DMXDeviceFadeDescription = this.m_DMXDeviceFadeDescriptionHashMap.get(stringDMXDeviceID);
                if (o_DMXDeviceFadeDescription == null) {
                    o_DMXDeviceFadeDescription = new DMXDeviceFadeDescription(stringDMXDeviceID);
                }
                o_DMXDeviceFadeDescription.readExternal(in);
                this.m_DMXDeviceFadeDescriptionHashMap.put(stringDMXDeviceID, o_DMXDeviceFadeDescription);
                continue;
            }
        }
    }

    public long getDiskSpaceEstimated() {
        long longBytesCount = 0L;
        Iterator<DMXDeviceFadeDescription> o_Iterator = this.m_DMXDeviceFadeDescriptionHashMap.values().iterator();
        longBytesCount += 4L;
        longBytesCount += 4L;
        while (o_Iterator.hasNext()) {
            DMXDeviceFadeDescription o_DMXDeviceFadeDescription = o_Iterator.next();
            longBytesCount += o_DMXDeviceFadeDescription.getDiskSpaceEstimated();
        }
        return longBytesCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean p_KeepInPool) {
        if (DMXDevice.getTreeModel_ControlTypes_Devices() != null) {
            DMXDevice.getTreeModel_ControlTypes_Devices().removePropertyChangeListener(this);
        }
        this.m_DMXFadeDescriptionListeners.clear();
        if (!p_KeepInPool) {
            Object object = this.m_SyncFadeDescriptions;
            synchronized (object) {
                if (this.m_DMXDeviceFadeDescriptionHashMap != null) {
                    Iterator<DMXDeviceFadeDescription> o_Iterator = this.m_DMXDeviceFadeDescriptionHashMap.values().iterator();
                    while (o_Iterator.hasNext()) {
                        DMXDeviceFadeDescription o_DMXDeviceFadeDescription = o_Iterator.next();
                        o_Iterator.remove();
                        if (o_DMXDeviceFadeDescription == null) continue;
                        o_DMXDeviceFadeDescription.close();
                    }
                    this.m_DMXDeviceFadeDescriptionHashMap.clear();
                }
            }
        }
    }

    public boolean getOnlyOneDMXDevice() {
        return this.m_OnlyOneDMXDevice;
    }

    public String getDMXDeviceID() {
        return this.m_DMXDeviceID;
    }

    public DMXDevice getDMXDevice() {
        return DMXDevice.getDMXDevice(this.m_DMXDeviceID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DMXDeviceFadeDescription addDMXDeviceFadeDescription(String p_DMXDeviceID) {
        if (p_DMXDeviceID == null) {
            return null;
        }
        DMXDevice o_DMXDevice = DMXDevice.getDMXDevice(p_DMXDeviceID);
        DMXDeviceFadeDescription o_DMXDeviceFadeDescription = this.getDMXDeviceFadeDescription(p_DMXDeviceID);
        if (o_DMXDeviceFadeDescription == null) {
            if (o_DMXDevice != null) {
                Object object = this.m_SyncFadeDescriptions;
                synchronized (object) {
                    o_DMXDeviceFadeDescription = new DMXDeviceFadeDescription(p_DMXDeviceID);
                    o_DMXDeviceFadeDescription.setDMXFadeDescription(this);
                    this.m_DMXDeviceFadeDescriptionHashMap.put(p_DMXDeviceID, o_DMXDeviceFadeDescription);
                }
            }
        } else if (o_DMXDevice == null) {
            o_DMXDeviceFadeDescription.close();
        } else {
            o_DMXDeviceFadeDescription.setDMXDevice(p_DMXDeviceID);
        }
        this.notifyListeners_DMXDevice();
        return o_DMXDeviceFadeDescription;
    }

    public void removeDMXDeviceFadeDescription(String p_DMXDeviceID) {
        if (p_DMXDeviceID == null) {
            return;
        }
        DMXDeviceFadeDescription o_DMXDeviceFadeDescription = this.getDMXDeviceFadeDescription(p_DMXDeviceID);
        if (o_DMXDeviceFadeDescription != null) {
            this.removeDMXDeviceFadeDescription(o_DMXDeviceFadeDescription);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDMXDeviceFadeDescription(DMXDeviceFadeDescription p_DMXDeviceFadeDescription) {
        DMXDeviceFadeDescription o_DMXDeviceFadeDescription;
        if (p_DMXDeviceFadeDescription == null) {
            return;
        }
        Object object = this.m_SyncFadeDescriptions;
        synchronized (object) {
            o_DMXDeviceFadeDescription = this.m_DMXDeviceFadeDescriptionHashMap.remove(p_DMXDeviceFadeDescription.getDMXDeviceID());
        }
        if (o_DMXDeviceFadeDescription != null) {
            o_DMXDeviceFadeDescription.close();
            this.notifyListeners_DMXDevice();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDMXDeviceFadeDescriptionFromMap(DMXDeviceFadeDescription p_DMXDeviceFadeDescription) {
        DMXDeviceFadeDescription o_DMXDeviceFadeDescription;
        if (p_DMXDeviceFadeDescription == null) {
            return;
        }
        Object object = this.m_SyncFadeDescriptions;
        synchronized (object) {
            o_DMXDeviceFadeDescription = this.m_DMXDeviceFadeDescriptionHashMap.remove(p_DMXDeviceFadeDescription.getDMXDeviceID());
        }
        if (o_DMXDeviceFadeDescription != null) {
            this.notifyListeners_DMXDevice();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setToDefault() {
        this.correct();
        if (!this.m_OnlyOneDMXDevice) {
            int intDMXDeviceCount = DMXDevice.getDMXDeviceCount();
            for (int intDMXDevice = 0; intDMXDevice < intDMXDeviceCount; ++intDMXDevice) {
                DMXDeviceFadeDescription o_DMXDeviceFadeDescription_Self;
                DMXDevice o_DMXDevice = DMXDevice.getDMXDevice(intDMXDevice);
                if (o_DMXDevice == null) continue;
                String stringDMXDeviceID = o_DMXDevice.getID();
                Object object = this.m_SyncFadeDescriptions;
                synchronized (object) {
                    o_DMXDeviceFadeDescription_Self = this.getCreateDMXDeviceFadeDescription(stringDMXDeviceID);
                }
                if (o_DMXDeviceFadeDescription_Self == null) continue;
                o_DMXDeviceFadeDescription_Self.setToDefault(stringDMXDeviceID);
            }
        } else {
            DMXDeviceFadeDescription o_DMXDeviceFadeDescription_Self;
            Object object = this.m_SyncFadeDescriptions;
            synchronized (object) {
                o_DMXDeviceFadeDescription_Self = this.getCreateDMXDeviceFadeDescription(this.m_DMXDeviceID);
            }
            if (o_DMXDeviceFadeDescription_Self == null) {
                return;
            }
            o_DMXDeviceFadeDescription_Self.setToDefault(this.m_DMXDeviceID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void correct() {
        Object object = this.m_SyncFadeDescriptions;
        synchronized (object) {
            if (this.m_DMXDeviceFadeDescriptionHashMap.size() == DMXDevice.getDMXDeviceCount()) {
                return;
            }
            Iterator<String> o_Iterator = this.m_DMXDeviceFadeDescriptionHashMap.keySet().iterator();
            while (o_Iterator.hasNext()) {
                String stringDeviceID = o_Iterator.next();
                DMXDeviceFadeDescription o_DMXDeviceFadeDescription_Self = this.m_DMXDeviceFadeDescriptionHashMap.get(stringDeviceID);
                DMXDevice o_DMXDevice = DMXDevice.getDMXDevice(stringDeviceID);
                if (o_DMXDevice == null) {
                    o_Iterator.remove();
                    if (o_DMXDeviceFadeDescription_Self == null) continue;
                    o_DMXDeviceFadeDescription_Self.close();
                    continue;
                }
                if (this.m_DMXDeviceID.equals(o_DMXDevice.getID())) continue;
                o_Iterator.remove();
                if (o_DMXDeviceFadeDescription_Self == null) continue;
                o_DMXDeviceFadeDescription_Self.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DMXDeviceFadeDescription getDMXDeviceFadeDescription(String p_DMXDeviceID) {
        DMXDeviceFadeDescription o_DMXDeviceFadeDescription_Self;
        if (p_DMXDeviceID == null) {
            return null;
        }
        Object object = this.m_SyncFadeDescriptions;
        synchronized (object) {
            o_DMXDeviceFadeDescription_Self = this.m_DMXDeviceFadeDescriptionHashMap.get(p_DMXDeviceID);
        }
        return o_DMXDeviceFadeDescription_Self;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DMXDeviceFadeDescription getCreateDMXDeviceFadeDescription(String p_DMXDeviceID) {
        DMXDeviceFadeDescription o_DMXDeviceFadeDescription_Self;
        if (p_DMXDeviceID == null) {
            return null;
        }
        Object object = this.m_SyncFadeDescriptions;
        synchronized (object) {
            o_DMXDeviceFadeDescription_Self = this.m_DMXDeviceFadeDescriptionHashMap.get(p_DMXDeviceID);
        }
        if (o_DMXDeviceFadeDescription_Self == null) {
            o_DMXDeviceFadeDescription_Self = this.addDMXDeviceFadeDescription(p_DMXDeviceID);
        }
        return o_DMXDeviceFadeDescription_Self;
    }

    public DMXControlTypeFadeDescription getDMXControlTypeFadeDescription(String p_DMXDeviceID, String p_DMXControlTypeID) {
        if (p_DMXDeviceID == null || p_DMXControlTypeID == null) {
            return null;
        }
        DMXDeviceFadeDescription o_DMXDeviceFadeDescription = this.getDMXDeviceFadeDescription(p_DMXDeviceID);
        if (o_DMXDeviceFadeDescription == null) {
            return null;
        }
        return o_DMXDeviceFadeDescription.getDMXControlTypeFadeDescription(p_DMXControlTypeID);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof DMXDevice.TreeModel_DMXControlType_Devices) {
            if ("dmxdevicetreemodelDMXDeviceRemoved".equals(evt.getPropertyName())) {
                DMXDevice o_DMXDevice = (DMXDevice)evt.getOldValue();
                if (o_DMXDevice == null) {
                    return;
                }
                this.removeDMXDeviceFadeDescription(o_DMXDevice.getID());
            } else if ("dmxdevicetreemodelDMXDeviceAdded".equals(evt.getPropertyName())) {
                DMXDevice o_DMXDevice = (DMXDevice)evt.getNewValue();
                if (o_DMXDevice == null) {
                    return;
                }
                this.addDMXDeviceFadeDescription(o_DMXDevice.getID());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEqual(DMXFadeDescription p_DMXFadeDescription) {
        if (p_DMXFadeDescription == null) {
            return false;
        }
        boolean boolIsSame = true;
        Object object = this.m_SyncFadeDescriptions;
        synchronized (object) {
            if (!this.m_OnlyOneDMXDevice) {
                for (int intDevice = 0; intDevice < DMXDevice.getDMXDeviceCount(); ++intDevice) {
                    DMXDeviceFadeDescription o_DMXDeviceFadeDescription_Dest;
                    String stringDMXDeviceID;
                    DMXDeviceFadeDescription o_DMXDeviceFadeDescription_Self;
                    DMXDevice o_DMXDevice = DMXDevice.getDMXDevice(intDevice);
                    if (o_DMXDevice == null || (o_DMXDeviceFadeDescription_Self = this.getDMXDeviceFadeDescription(stringDMXDeviceID = o_DMXDevice.getID())) == null || (o_DMXDeviceFadeDescription_Dest = p_DMXFadeDescription.getDMXDeviceFadeDescription(stringDMXDeviceID)) == null || o_DMXDeviceFadeDescription_Self.equals(o_DMXDeviceFadeDescription_Dest)) continue;
                    boolIsSame = false;
                    break;
                }
            } else {
                DMXDevice o_DMXDevice_Self = this.getDMXDevice();
                DMXDevice o_DMXDevice = p_DMXFadeDescription.getDMXDevice();
                if (o_DMXDevice_Self == null || o_DMXDevice == null) {
                    return false;
                }
                String stringDMXDeviceID = o_DMXDevice_Self.getID();
                DMXDeviceFadeDescription o_DMXDeviceFadeDescription_Self = this.getDMXDeviceFadeDescription(stringDMXDeviceID);
                if (o_DMXDeviceFadeDescription_Self == null) {
                    return false;
                }
                DMXDeviceFadeDescription o_DMXDeviceFadeDescription_Dest = p_DMXFadeDescription.getDMXDeviceFadeDescription(stringDMXDeviceID);
                if (o_DMXDeviceFadeDescription_Dest == null) {
                    return false;
                }
                if (!o_DMXDeviceFadeDescription_Self.equals(o_DMXDeviceFadeDescription_Dest)) {
                    boolIsSame = false;
                }
            }
        }
        return boolIsSame;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DMXFadeDescription copyTo(DMXFadeDescription p_DMXFadeDescription) {
        if (p_DMXFadeDescription == null) {
            p_DMXFadeDescription = !this.m_OnlyOneDMXDevice ? new DMXFadeDescription(false) : new DMXFadeDescription(this.m_DMXDeviceID);
        }
        Object object = this.m_SyncFadeDescriptions;
        synchronized (object) {
            if (!this.m_OnlyOneDMXDevice) {
                for (int intDevice = 0; intDevice < DMXDevice.getDMXDeviceCount(); ++intDevice) {
                    DMXDeviceFadeDescription o_DMXDeviceFadeDescription_Dest;
                    String stringDMXDeviceID;
                    DMXDeviceFadeDescription o_DMXDeviceFadeDescription_Self;
                    DMXDevice o_DMXDevice = DMXDevice.getDMXDevice(intDevice);
                    if (o_DMXDevice == null || (o_DMXDeviceFadeDescription_Self = this.getDMXDeviceFadeDescription(stringDMXDeviceID = o_DMXDevice.getID())) == null && (o_DMXDeviceFadeDescription_Self = this.addDMXDeviceFadeDescription(o_DMXDevice.getID())) == null || (o_DMXDeviceFadeDescription_Dest = p_DMXFadeDescription.getDMXDeviceFadeDescription(stringDMXDeviceID)) == null && (o_DMXDeviceFadeDescription_Dest = p_DMXFadeDescription.addDMXDeviceFadeDescription(stringDMXDeviceID)) == null) continue;
                    if (o_DMXDeviceFadeDescription_Self.getDMXDeviceType() != o_DMXDeviceFadeDescription_Dest.getDMXDeviceType()) {
                        o_DMXDeviceFadeDescription_Dest.setDMXDeviceType(o_DMXDeviceFadeDescription_Self.getDMXDeviceType());
                    }
                    o_DMXDeviceFadeDescription_Self.copyTo(o_DMXDeviceFadeDescription_Dest);
                }
            } else {
                DMXDevice o_DMXDevice_Self = this.getDMXDevice();
                DMXDevice o_DMXDevice = p_DMXFadeDescription.getDMXDevice();
                if (!this.m_DMXDeviceID.equals(p_DMXFadeDescription.getDMXDeviceID())) {
                    p_DMXFadeDescription.removeDMXDeviceFadeDescription(p_DMXFadeDescription.getDMXDeviceID());
                }
                if (o_DMXDevice_Self == null) {
                    return p_DMXFadeDescription;
                }
                String stringDMXDeviceID = this.m_DMXDeviceID;
                DMXDeviceFadeDescription o_DMXDeviceFadeDescription_Self = this.getDMXDeviceFadeDescription(stringDMXDeviceID);
                if (o_DMXDeviceFadeDescription_Self == null && (o_DMXDeviceFadeDescription_Self = this.addDMXDeviceFadeDescription(o_DMXDevice.getID())) == null) {
                    return p_DMXFadeDescription;
                }
                DMXDeviceFadeDescription o_DMXDeviceFadeDescription_Dest = p_DMXFadeDescription.getDMXDeviceFadeDescription(stringDMXDeviceID);
                if (o_DMXDeviceFadeDescription_Dest == null && (o_DMXDeviceFadeDescription_Dest = p_DMXFadeDescription.addDMXDeviceFadeDescription(stringDMXDeviceID)) == null) {
                    return p_DMXFadeDescription;
                }
                if (o_DMXDeviceFadeDescription_Self.getDMXDeviceType() != o_DMXDeviceFadeDescription_Dest.getDMXDeviceType()) {
                    o_DMXDeviceFadeDescription_Dest.setDMXDeviceType(o_DMXDeviceFadeDescription_Self.getDMXDeviceType());
                }
                o_DMXDeviceFadeDescription_Self.copyTo(o_DMXDeviceFadeDescription_Dest);
            }
        }
        this.correct();
        p_DMXFadeDescription.correct();
        return p_DMXFadeDescription;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDMXFadeDescriptionListener(DMXFadeDescriptionListener p_DMXFadeDescriptionListener) {
        if (p_DMXFadeDescriptionListener == null) {
            return;
        }
        Object object = this.m_SyncListeners;
        synchronized (object) {
            if (this.m_DMXFadeDescriptionListeners.contains(p_DMXFadeDescriptionListener)) {
                return;
            }
            this.m_DMXFadeDescriptionListeners.add(p_DMXFadeDescriptionListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDMXFadeDescriptionListener(DMXFadeDescriptionListener p_DMXFadeDescriptionListener) {
        if (p_DMXFadeDescriptionListener == null) {
            return;
        }
        Object object = this.m_SyncListeners;
        synchronized (object) {
            this.m_DMXFadeDescriptionListeners.remove(p_DMXFadeDescriptionListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners_DMXDevice() {
        ArrayList<DMXFadeDescriptionListener> o_DMXFadeDescriptionListeners;
        Object object = this.m_SyncListeners;
        synchronized (object) {
            if (this.m_DMXFadeDescriptionListeners.size() <= 0) {
                return;
            }
            o_DMXFadeDescriptionListeners = new ArrayList<DMXFadeDescriptionListener>(this.m_DMXFadeDescriptionListeners.size());
            o_DMXFadeDescriptionListeners.addAll(this.m_DMXFadeDescriptionListeners);
        }
        for (int intListener = 0; intListener < o_DMXFadeDescriptionListeners.size(); ++intListener) {
            DMXFadeDescriptionListener o_DMXFadeDescriptionListener = (DMXFadeDescriptionListener)o_DMXFadeDescriptionListeners.get(intListener);
            o_DMXFadeDescriptionListener.eventFadeDescriptionDMXDevice(this);
        }
    }

    public static interface DMXFadeDescriptionListener {
        public void eventFadeDescriptionDMXDevice(DMXFadeDescription var1);
    }

    public static class FadeValues
    implements Externalizable {
        public static final int SOFTWAREVERSION = 1;
        public static final String PROP_FADEIN_STARTVALUE = "fadeIn_StartValue";
        public static final String PROP_FADEIN_ENDVALUE = "fadeIn_EndValue";
        public static final String PROP_FADEOUT_STARTVALUE = "fadeOut_StartValue";
        public static final String PROP_FADEOUT_ENDVALUE = "fadeOut_EndValue";
        DMXControlComponent.ControlDimensionType m_ControlDimensionType;
        private int m_FadeIn_StartValue;
        private int m_FadeIn_EndValue;
        private int m_FadeOut_StartValue;
        private int m_FadeOut_EndValue;

        public FadeValues(DMXControlComponent.ControlDimensionType p_ControlDimensionType) {
            this.m_ControlDimensionType = p_ControlDimensionType;
            if (this.m_ControlDimensionType != null) {
                this.initMembersFurther();
            }
        }

        private void initMembersFurther() {
            this.m_FadeIn_StartValue = 0;
            this.m_FadeIn_EndValue = this.m_ControlDimensionType == null ? 255 : this.m_ControlDimensionType.getValueMaximum();
            this.m_FadeOut_StartValue = this.m_ControlDimensionType == null ? 255 : this.m_ControlDimensionType.getValueMaximum();
            this.m_FadeOut_EndValue = 0;
        }

        public void setControlDimensionType(DMXControlComponent.ControlDimensionType P_ControlDimensionType) {
            if (this.m_ControlDimensionType == P_ControlDimensionType) {
                return;
            }
            this.m_ControlDimensionType = P_ControlDimensionType;
            if (this.m_ControlDimensionType != null) {
                this.initMembersFurther();
            }
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(1);
            out.writeInt(this.m_FadeIn_StartValue);
            out.writeInt(this.m_FadeIn_EndValue);
            out.writeInt(this.m_FadeOut_StartValue);
            out.writeInt(this.m_FadeOut_EndValue);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int intSoftwareVersion = in.readInt();
            this.m_FadeIn_StartValue = in.readInt();
            this.m_FadeIn_EndValue = in.readInt();
            this.m_FadeOut_StartValue = in.readInt();
            this.m_FadeOut_EndValue = in.readInt();
        }

        public long getDiskSpaceEstimated() {
            long longBytesCount = 0L;
            longBytesCount += 4L;
            longBytesCount += 4L;
            longBytesCount += 4L;
            longBytesCount += 4L;
            return longBytesCount += 4L;
        }

        public void close() {
            this.m_ControlDimensionType = null;
        }

        public void setFadeIn_StartValue(int p_Value) {
            if (this.m_ControlDimensionType == null) {
                return;
            }
            if (p_Value < 0) {
                p_Value = 0;
            }
            if (p_Value > this.m_ControlDimensionType.getValueMaximum()) {
                p_Value = this.m_ControlDimensionType.getValueMaximum();
            }
            if (this.m_FadeIn_StartValue != p_Value) {
                int oldValue = this.m_FadeIn_StartValue;
                this.m_FadeIn_StartValue = p_Value;
            }
        }

        public int getFadeIn_StartValue() {
            return this.m_FadeIn_StartValue;
        }

        public void setFadeIn_EndValue(int p_Value) {
            if (this.m_ControlDimensionType == null) {
                return;
            }
            if (p_Value < 0) {
                p_Value = 0;
            }
            if (p_Value > this.m_ControlDimensionType.getValueMaximum()) {
                p_Value = this.m_ControlDimensionType.getValueMaximum();
            }
            if (this.m_FadeIn_EndValue != p_Value) {
                int oldValue = this.m_FadeIn_EndValue;
                this.m_FadeIn_EndValue = p_Value;
            }
        }

        public int getFadeIn_EndValue() {
            return this.m_FadeIn_EndValue;
        }

        public void setFadeOut_StartValue(int p_Value) {
            if (this.m_ControlDimensionType == null) {
                return;
            }
            if (p_Value < 0) {
                p_Value = 0;
            }
            if (p_Value > this.m_ControlDimensionType.getValueMaximum()) {
                p_Value = this.m_ControlDimensionType.getValueMaximum();
            }
            if (this.m_FadeOut_StartValue != p_Value) {
                int oldValue = this.m_FadeOut_StartValue;
                this.m_FadeOut_StartValue = p_Value;
            }
        }

        public int getFadeOut_StartValue() {
            return this.m_FadeOut_StartValue;
        }

        public void setFadeOut_EndValue(int p_Value) {
            if (this.m_ControlDimensionType == null) {
                return;
            }
            if (p_Value < 0) {
                p_Value = 0;
            }
            if (p_Value > this.m_ControlDimensionType.getValueMaximum()) {
                p_Value = this.m_ControlDimensionType.getValueMaximum();
            }
            if (this.m_FadeOut_EndValue != p_Value) {
                int oldValue = this.m_FadeOut_EndValue;
                this.m_FadeOut_EndValue = p_Value;
            }
        }

        public int getFadeOut_EndValue() {
            return this.m_FadeOut_EndValue;
        }

        public FadeValues copyTo(FadeValues p_FadeValues) {
            if (p_FadeValues == null) {
                p_FadeValues = new FadeValues(this.m_ControlDimensionType);
            }
            p_FadeValues.setFadeIn_StartValue(this.m_FadeIn_StartValue);
            p_FadeValues.setFadeIn_EndValue(this.m_FadeIn_EndValue);
            p_FadeValues.setFadeOut_StartValue(this.m_FadeOut_StartValue);
            p_FadeValues.setFadeOut_EndValue(this.m_FadeOut_EndValue);
            return p_FadeValues;
        }

        public boolean equals(FadeValues p_FadeValues) {
            if (p_FadeValues == null) {
                return false;
            }
            if (p_FadeValues.getFadeIn_StartValue() != this.m_FadeIn_StartValue) {
                return false;
            }
            if (p_FadeValues.getFadeIn_EndValue() != this.m_FadeIn_EndValue) {
                return false;
            }
            if (p_FadeValues.getFadeOut_StartValue() != this.m_FadeOut_StartValue) {
                return false;
            }
            return p_FadeValues.getFadeOut_EndValue() == this.m_FadeOut_EndValue;
        }
    }

    public static class DMXControlTypeFadeDescription
    implements Externalizable {
        public static final int SOFTWAREVERSION = 2;
        private DMXDeviceFadeDescription m_DMXDeviceFadeDescription;
        private DMXControlComponent.DMXControlType m_DMXControlType;
        private boolean m_Disabled;
        private boolean m_DisabledAdjustment;
        private float m_FadeIn_Start;
        private float m_FadeIn_End;
        private float m_FadeOut_Start;
        private float m_FadeOut_End;
        private ArrayList<ArrayList<FadeValues>> m_FadeValueses;
        private SinglePropertyChangeSupport m_PropertyChangeSupport;

        public DMXControlTypeFadeDescription(DMXDeviceFadeDescription p_DMXDeviceFadeDescription, DMXControlComponent.DMXControlType p_DMXControlType) {
            this.initMembers();
            this.m_DMXDeviceFadeDescription = p_DMXDeviceFadeDescription;
            this.setDMXControlType(p_DMXControlType);
        }

        private void initMembers() {
            this.m_Disabled = false;
            this.m_DisabledAdjustment = false;
            this.m_FadeIn_Start = 0.0f;
            this.m_FadeIn_End = 1.0f;
            this.m_FadeOut_Start = 0.0f;
            this.m_FadeOut_End = 1.0f;
            this.m_FadeValueses = new ArrayList();
            this.m_PropertyChangeSupport = new SinglePropertyChangeSupport(this);
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(2);
            out.writeBoolean(this.m_Disabled);
            out.writeBoolean(this.m_DisabledAdjustment);
            out.writeFloat(this.m_FadeIn_Start);
            out.writeFloat(this.m_FadeIn_End);
            out.writeFloat(this.m_FadeOut_Start);
            out.writeFloat(this.m_FadeOut_End);
            int intControlCount = this.m_FadeValueses.size();
            out.writeInt(intControlCount);
            for (int intControl = 0; intControl < intControlCount; ++intControl) {
                ArrayList<FadeValues> o_ControlFadeValues = this.m_FadeValueses.get(intControl);
                int intControlDimensionCount = o_ControlFadeValues.size();
                out.writeInt(intControlDimensionCount);
                for (int intDimension = 0; intDimension < intControlDimensionCount; ++intDimension) {
                    FadeValues o_FadeValues = o_ControlFadeValues.get(intDimension);
                    o_FadeValues.writeExternal(out);
                }
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int intSoftwareVersion = in.readInt();
            this.m_Disabled = in.readBoolean();
            if (intSoftwareVersion > 1) {
                this.m_DisabledAdjustment = in.readBoolean();
            }
            this.m_FadeIn_Start = in.readFloat();
            this.m_FadeIn_End = in.readFloat();
            this.m_FadeOut_Start = in.readFloat();
            this.m_FadeOut_End = in.readFloat();
            int intControlCount = in.readInt();
            for (int intControl = 0; intControl < intControlCount; ++intControl) {
                ArrayList<Object> o_ControlFadeValues;
                if (intControl < this.m_FadeValueses.size()) {
                    o_ControlFadeValues = this.m_FadeValueses.get(intControl);
                } else {
                    o_ControlFadeValues = new ArrayList();
                    this.m_FadeValueses.add(o_ControlFadeValues);
                }
                int intControlDimensionCount = in.readInt();
                for (int intDimension = 0; intDimension < intControlDimensionCount; ++intDimension) {
                    FadeValues o_FadeValues;
                    if (intDimension < o_ControlFadeValues.size()) {
                        o_FadeValues = (FadeValues)o_ControlFadeValues.get(intDimension);
                    } else {
                        o_FadeValues = new FadeValues(null);
                        o_ControlFadeValues.add(o_FadeValues);
                    }
                    o_FadeValues.readExternal(in);
                }
            }
            this.correct();
        }

        public long getDiskSpaceEstimated() {
            long longBytesCount = 0L;
            int intControlCount = this.m_FadeValueses.size();
            longBytesCount += 4L;
            for (int intControl = 0; intControl < intControlCount; ++intControl) {
                ArrayList<FadeValues> o_ControlFadeValues = this.m_FadeValueses.get(intControl);
                int intControlDimensionCount = o_ControlFadeValues.size();
                longBytesCount += 4L;
                for (int intDimension = 0; intDimension < intControlDimensionCount; ++intDimension) {
                    FadeValues o_FadeValues = o_ControlFadeValues.get(intDimension);
                    longBytesCount += o_FadeValues.getDiskSpaceEstimated();
                }
            }
            return longBytesCount;
        }

        public void close() {
            int intControlCount = this.m_FadeValueses.size();
            for (int intControl = intControlCount - 1; intControl >= 0; --intControl) {
                ArrayList<FadeValues> o_ControlFadeValues = this.m_FadeValueses.get(intControl);
                int intControlDimensionCount = o_ControlFadeValues.size();
                for (int intDimension = intControlDimensionCount - 1; intDimension >= 0; --intDimension) {
                    FadeValues o_FadeValues = o_ControlFadeValues.get(intDimension);
                    if (o_FadeValues == null) continue;
                    o_FadeValues.close();
                    o_ControlFadeValues.remove(intDimension);
                }
                this.m_FadeValueses.remove(intControl);
            }
        }

        public void addPropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
            this.m_PropertyChangeSupport.addPropertyChangeListener(p_PropertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
            this.m_PropertyChangeSupport.removePropertyChangeListener(p_PropertyChangeListener);
        }

        public void addPropertyChangeListener(String p_PropertyName, PropertyChangeListener p_PropertyChangeListener) {
            this.m_PropertyChangeSupport.addPropertyChangeListener(p_PropertyName, p_PropertyChangeListener);
        }

        public void removePropertyChangeListener(String p_PropertyName, PropertyChangeListener p_PropertyChangeListener) {
            this.m_PropertyChangeSupport.removePropertyChangeListener(p_PropertyName, p_PropertyChangeListener);
        }

        public PropertyChangeListener[] getPropertyChangeListeners() {
            return this.m_PropertyChangeSupport.getPropertyChangeListeners();
        }

        public PropertyChangeListener[] getPropertyChangeListeners(String p_PropertyName) {
            return this.m_PropertyChangeSupport.getPropertyChangeListeners(p_PropertyName);
        }

        public boolean hasListeners(String p_PropertyName) {
            return this.m_PropertyChangeSupport.hasListeners(p_PropertyName);
        }

        private void setDMXControlType(DMXControlComponent.DMXControlType p_DMXControlType) {
            this.m_FadeValueses.clear();
            this.m_DMXControlType = p_DMXControlType;
            if (this.m_DMXControlType != null) {
                for (int intControlType = 0; intControlType < this.m_DMXControlType.getControlTypeCount(); ++intControlType) {
                    ArrayList<Object> o_ControlDimensionFadeValues;
                    if (intControlType < this.m_FadeValueses.size()) {
                        o_ControlDimensionFadeValues = this.m_FadeValueses.get(intControlType);
                    } else {
                        o_ControlDimensionFadeValues = new ArrayList();
                        this.m_FadeValueses.add(o_ControlDimensionFadeValues);
                    }
                    DMXControlComponent.ControlType o_ControlType = this.m_DMXControlType.getControlType(intControlType);
                    if (o_ControlType == null) continue;
                    for (int intControlDimension = 0; intControlDimension < o_ControlType.getControlDimensionTypeCount(); ++intControlDimension) {
                        FadeValues o_FadeValuesDimension;
                        DMXControlComponent.ControlDimensionType o_ControlDimensionType = o_ControlType.getControlDimensionType(intControlDimension);
                        if (intControlDimension < o_ControlDimensionFadeValues.size()) {
                            o_FadeValuesDimension = (FadeValues)o_ControlDimensionFadeValues.get(intControlDimension);
                            o_FadeValuesDimension.setControlDimensionType(o_ControlDimensionType);
                            continue;
                        }
                        o_FadeValuesDimension = new FadeValues(o_ControlDimensionType);
                        o_ControlDimensionFadeValues.add(o_FadeValuesDimension);
                    }
                }
            }
            this.correct();
        }

        public void correct() {
            int intControlTypeCount = this.m_DMXControlType == null ? 0 : this.m_DMXControlType.getControlTypeCount();
            for (int intIndex = this.m_FadeValueses.size() - 1; intIndex >= intControlTypeCount; --intIndex) {
                ArrayList<FadeValues> o_FadeValueses = this.m_FadeValueses.get(intIndex);
                for (int intDimension = o_FadeValueses.size() - 1; intDimension >= 0; --intDimension) {
                    FadeValues o_FadeValuesDimension = o_FadeValueses.get(intDimension);
                    if (o_FadeValuesDimension == null) continue;
                    o_FadeValuesDimension.close();
                }
                this.m_FadeValueses.remove(intIndex);
            }
        }

        public DMXControlComponent.DMXControlType getDMXControlType() {
            return this.m_DMXControlType;
        }

        public boolean setToDefault() {
            DMXControlTypeFadeDescription o_DMXControlTypeFadeDescription_Default;
            DMXDeviceFadeDescription o_DMXDeviceFadeDescription_Default;
            boolean boolDefaultDone = false;
            boolean boolChanged = false;
            if (this.m_DMXDeviceFadeDescription != null && this.m_DMXControlType != null && (o_DMXDeviceFadeDescription_Default = this.m_DMXDeviceFadeDescription.getDefaultDMXDeviceFadeDescription()) != null && (o_DMXControlTypeFadeDescription_Default = o_DMXDeviceFadeDescription_Default.getDMXControlTypeFadeDescription(this.m_DMXControlType.getID())) != null) {
                if (!o_DMXControlTypeFadeDescription_Default.equals(this)) {
                    boolChanged = true;
                }
                o_DMXControlTypeFadeDescription_Default.copyTo(this);
                boolDefaultDone = true;
            }
            if (boolDefaultDone || this.m_DMXControlType != null) {
                // empty if block
            }
            if (boolChanged) {
                this.m_PropertyChangeSupport.firePropertyChange(DMXFadeDescription.PROP_PARAMSCHANGED, null, this);
            }
            return boolChanged;
        }

        public void setDisabled(boolean p_Disabled) {
            if (this.m_Disabled == p_Disabled) {
                return;
            }
            this.m_Disabled = p_Disabled;
            this.m_PropertyChangeSupport.firePropertyChange(DMXFadeDescription.PROP_PARAMSCHANGED, null, this);
        }

        public boolean getDisabled() {
            return this.m_Disabled;
        }

        public void setDisabledAdjustment(boolean p_DisabledAdjustment) {
            if (this.m_DisabledAdjustment == p_DisabledAdjustment) {
                return;
            }
            this.m_DisabledAdjustment = p_DisabledAdjustment;
            this.m_PropertyChangeSupport.firePropertyChange(DMXFadeDescription.PROP_PARAMSCHANGED, null, this);
        }

        public boolean getDisabledAdjustment() {
            return this.m_DisabledAdjustment;
        }

        public void setFadeIn_Start(float p_Value) {
            if (p_Value < 0.0f) {
                p_Value = 0.0f;
            }
            if (p_Value > 1.0f) {
                p_Value = 1.0f;
            }
            if (p_Value > this.m_FadeIn_End) {
                p_Value = this.m_FadeIn_End;
            }
            if (this.m_FadeIn_Start == p_Value) {
                return;
            }
            float oldValue = this.m_FadeIn_Start;
            this.m_FadeIn_Start = p_Value;
            this.m_PropertyChangeSupport.firePropertyChange(DMXFadeDescription.PROP_PARAMSCHANGED, null, this);
        }

        public float getInternalFadeIn_Start() {
            return this.m_FadeIn_Start;
        }

        public float getFadeIn_Start() {
            if (!this.m_DisabledAdjustment) {
                return 0.0f;
            }
            return this.m_FadeIn_Start;
        }

        public void setFadeIn_End(float p_Value) {
            if (p_Value < 0.0f) {
                p_Value = 0.0f;
            }
            if (p_Value > 1.0f) {
                p_Value = 1.0f;
            }
            if (p_Value < this.m_FadeIn_Start) {
                p_Value = this.m_FadeIn_Start;
            }
            if (this.m_FadeIn_End == p_Value) {
                return;
            }
            float oldValue = this.m_FadeIn_End;
            this.m_FadeIn_End = p_Value;
            this.m_PropertyChangeSupport.firePropertyChange(DMXFadeDescription.PROP_PARAMSCHANGED, null, this);
        }

        public float getInternalFadeIn_End() {
            return this.m_FadeIn_End;
        }

        public float getFadeIn_End() {
            if (!this.m_DisabledAdjustment) {
                return 1.0f;
            }
            return this.m_FadeIn_End;
        }

        public void setFadeOut_Start(float p_Value) {
            if (p_Value < 0.0f) {
                p_Value = 0.0f;
            }
            if (p_Value > 1.0f) {
                p_Value = 1.0f;
            }
            if (p_Value > this.m_FadeOut_End) {
                p_Value = this.m_FadeOut_End;
            }
            if (this.m_FadeIn_End == p_Value) {
                return;
            }
            float oldValue = this.m_FadeOut_Start;
            this.m_FadeOut_Start = p_Value;
            this.m_PropertyChangeSupport.firePropertyChange(DMXFadeDescription.PROP_PARAMSCHANGED, null, this);
        }

        public float getInternalFadeOut_Start() {
            return this.m_FadeOut_Start;
        }

        public float getFadeOut_Start() {
            if (!this.m_DisabledAdjustment) {
                return 0.0f;
            }
            return this.m_FadeOut_Start;
        }

        public void setFadeOut_End(float p_Value) {
            if (p_Value < 0.0f) {
                p_Value = 0.0f;
            }
            if (p_Value > 1.0f) {
                p_Value = 1.0f;
            }
            if (p_Value < this.m_FadeOut_Start) {
                p_Value = this.m_FadeOut_Start;
            }
            if (this.m_FadeOut_End == p_Value) {
                return;
            }
            float oldValue = this.m_FadeOut_End;
            this.m_FadeOut_End = p_Value;
            this.m_PropertyChangeSupport.firePropertyChange(DMXFadeDescription.PROP_PARAMSCHANGED, null, this);
        }

        public float getInternalFadeOut_End() {
            return this.m_FadeOut_End;
        }

        public float getFadeOut_End() {
            if (!this.m_DisabledAdjustment) {
                return 1.0f;
            }
            return this.m_FadeOut_End;
        }

        public float getFade(int p_FadeInOut, int p_FadeStartEnd) {
            switch (p_FadeInOut) {
                case 0: {
                    if (p_FadeStartEnd == 0) {
                        return this.m_FadeIn_Start;
                    }
                    return this.m_FadeIn_End;
                }
                case 1: {
                    if (p_FadeStartEnd == 0) {
                        return this.m_FadeOut_Start;
                    }
                    return this.m_FadeOut_End;
                }
            }
            return -1.0f;
        }

        public void setFade(float p_Value, int p_FadeInOut, int p_FadeStartEnd) {
            float floatStartValue = 0.0f;
            float floatEndValue = 1.0f;
            switch (p_FadeInOut) {
                case 0: {
                    if (p_FadeStartEnd == 0) {
                        floatStartValue = p_Value;
                        floatEndValue = this.m_FadeIn_End;
                        break;
                    }
                    floatStartValue = this.m_FadeIn_Start;
                    floatEndValue = p_Value;
                    break;
                }
                case 1: {
                    if (p_FadeStartEnd == 0) {
                        floatStartValue = p_Value;
                        floatEndValue = this.m_FadeOut_End;
                        break;
                    }
                    floatStartValue = this.m_FadeOut_Start;
                    floatEndValue = p_Value;
                }
            }
            this.setFade(p_FadeInOut, p_FadeStartEnd, floatStartValue, floatEndValue);
        }

        public void setFade(int p_FadeInOut, int p_FadeStartEnd, float p_Start, float p_End) {
            boolean boolChanged = false;
            if (p_Start < 0.0f) {
                p_Start = 0.0f;
            }
            if (p_Start > 1.0f) {
                p_Start = 1.0f;
            }
            if (p_End < 0.0f) {
                p_End = 0.0f;
            }
            if (p_End > 1.0f) {
                p_End = 1.0f;
            }
            if (p_Start > p_End) {
                if (p_FadeStartEnd == 0) {
                    p_Start = p_End;
                } else {
                    p_End = p_Start;
                }
            }
            if (p_FadeInOut == 0) {
                if (this.m_FadeIn_Start != p_Start) {
                    this.m_FadeIn_Start = p_Start;
                    boolChanged = true;
                }
                if (this.m_FadeIn_End != p_End) {
                    this.m_FadeIn_End = p_End;
                    boolChanged = true;
                }
            } else {
                if (this.m_FadeOut_Start != p_Start) {
                    this.m_FadeOut_Start = p_Start;
                    boolChanged = true;
                }
                if (this.m_FadeOut_End != p_End) {
                    this.m_FadeOut_End = p_End;
                    boolChanged = true;
                }
            }
            if (boolChanged) {
                this.m_PropertyChangeSupport.firePropertyChange(DMXFadeDescription.PROP_PARAMSCHANGED, null, this);
            }
        }

        public FadeValues getFadeValues(int p_ControlIndex, int p_ControlDimensionIndex) {
            if (p_ControlIndex < 0) {
                return null;
            }
            if (p_ControlDimensionIndex < 0) {
                return null;
            }
            if (p_ControlIndex >= this.m_FadeValueses.size()) {
                return null;
            }
            ArrayList<FadeValues> o_FadeValueses = this.m_FadeValueses.get(p_ControlIndex);
            if (p_ControlDimensionIndex >= o_FadeValueses.size()) {
                return null;
            }
            return o_FadeValueses.get(p_ControlDimensionIndex);
        }

        public int getInternalFadeValue(int p_FadeOutIn, int p_FadeStartEnd, int p_ControlIndex, int p_ControlDimensionIndex) {
            FadeValues o_FadeValues = this.getFadeValues(p_ControlIndex, p_ControlDimensionIndex);
            if (o_FadeValues == null) {
                return -1;
            }
            switch (p_FadeOutIn) {
                case 0: {
                    if (p_FadeStartEnd == 0) {
                        return o_FadeValues.m_FadeIn_StartValue;
                    }
                    return o_FadeValues.m_FadeIn_EndValue;
                }
                case 1: {
                    if (p_FadeStartEnd == 0) {
                        return o_FadeValues.m_FadeOut_StartValue;
                    }
                    return o_FadeValues.m_FadeOut_EndValue;
                }
            }
            return -1;
        }

        public int getFadeValue(int p_FadeOutIn, int p_FadeStartEnd, int p_ControlIndex, int p_ControlDimensionIndex) {
            FadeValues o_FadeValues = this.getFadeValues(p_ControlIndex, p_ControlDimensionIndex);
            if (o_FadeValues == null) {
                return -1;
            }
            switch (p_FadeOutIn) {
                case 0: {
                    if (p_FadeStartEnd == 0) {
                        if (!this.m_DisabledAdjustment) {
                            return 0;
                        }
                        return o_FadeValues.m_FadeIn_StartValue;
                    }
                    if (!this.m_DisabledAdjustment) {
                        return o_FadeValues.m_ControlDimensionType.getValueMaximum();
                    }
                    return o_FadeValues.m_FadeIn_EndValue;
                }
                case 1: {
                    if (p_FadeStartEnd == 0) {
                        if (!this.m_DisabledAdjustment) {
                            return o_FadeValues.m_ControlDimensionType.getValueMaximum();
                        }
                        return o_FadeValues.m_FadeOut_StartValue;
                    }
                    if (!this.m_DisabledAdjustment) {
                        return 0;
                    }
                    return o_FadeValues.m_FadeOut_EndValue;
                }
            }
            return -1;
        }

        public void setFadeValue(int p_Value, int p_FadeOutIn, int p_FadeStartEnd, int p_ControlIndex, int p_ControlDimensionIndex) {
            FadeValues o_FadeValues = this.getFadeValues(p_ControlIndex, p_ControlDimensionIndex);
            if (o_FadeValues == null) {
                return;
            }
            boolean boolChanged = false;
            switch (p_FadeOutIn) {
                case 0: {
                    if (p_FadeStartEnd == 0) {
                        if (o_FadeValues.getFadeIn_StartValue() == p_Value) break;
                        o_FadeValues.setFadeIn_StartValue(p_Value);
                        boolChanged = true;
                        break;
                    }
                    if (o_FadeValues.getFadeIn_EndValue() == p_Value) break;
                    o_FadeValues.setFadeIn_EndValue(p_Value);
                    boolChanged = true;
                    break;
                }
                case 1: {
                    if (p_FadeStartEnd == 0) {
                        if (o_FadeValues.getFadeOut_StartValue() == p_Value) break;
                        o_FadeValues.setFadeOut_StartValue(p_Value);
                        boolChanged = true;
                        break;
                    }
                    if (o_FadeValues.getFadeOut_EndValue() == p_Value) break;
                    o_FadeValues.setFadeOut_EndValue(p_Value);
                    boolChanged = true;
                }
            }
            if (boolChanged) {
                this.m_PropertyChangeSupport.firePropertyChange(DMXFadeDescription.PROP_PARAMSCHANGED, null, this);
            }
        }

        public DMXControlTypeFadeDescription copyTo(DMXControlTypeFadeDescription p_DMXControlTypeFadeDescription) {
            DMXControlComponent.DMXControlType o_DMXControlType;
            if (p_DMXControlTypeFadeDescription == null) {
                p_DMXControlTypeFadeDescription = new DMXControlTypeFadeDescription(this.m_DMXDeviceFadeDescription, this.m_DMXControlType);
            }
            if ((o_DMXControlType = p_DMXControlTypeFadeDescription.getDMXControlType()) == null || this.m_DMXControlType == null) {
                return null;
            }
            if (!o_DMXControlType.getClassName().equals(this.m_DMXControlType.getClassName())) {
                return null;
            }
            p_DMXControlTypeFadeDescription.setDisabled(this.m_Disabled);
            p_DMXControlTypeFadeDescription.setDisabledAdjustment(this.m_DisabledAdjustment);
            p_DMXControlTypeFadeDescription.setFade(0, 0, this.m_FadeIn_Start, this.m_FadeIn_End);
            p_DMXControlTypeFadeDescription.setFade(1, 0, this.m_FadeOut_Start, this.m_FadeOut_End);
            for (int intControl = 0; intControl < this.m_DMXControlType.getControlTypeCount(); ++intControl) {
                DMXControlComponent.ControlType o_ControlType = this.m_DMXControlType.getControlType(intControl);
                if (o_ControlType == null) continue;
                for (int intDimension = 0; intDimension < o_ControlType.getControlDimensionTypeCount(); ++intDimension) {
                    FadeValues o_FadeValuesSelf = this.getFadeValues(intControl, intDimension);
                    if (o_FadeValuesSelf == null) continue;
                    FadeValues o_FadeValues = p_DMXControlTypeFadeDescription.getFadeValues(intControl, intDimension);
                    o_FadeValuesSelf.copyTo(o_FadeValues);
                }
            }
            return p_DMXControlTypeFadeDescription;
        }

        public boolean equals(DMXControlTypeFadeDescription p_DMXControlTypeFadeDescription) {
            if (p_DMXControlTypeFadeDescription == null) {
                return false;
            }
            DMXControlComponent.DMXControlType o_DMXControlType = p_DMXControlTypeFadeDescription.getDMXControlType();
            if (o_DMXControlType == null && this.m_DMXControlType == null) {
                return true;
            }
            if (o_DMXControlType == null || this.m_DMXControlType == null) {
                return false;
            }
            if (!o_DMXControlType.getClassName().equals(this.m_DMXControlType.getClassName())) {
                return false;
            }
            if (p_DMXControlTypeFadeDescription.getDisabled() != this.m_Disabled) {
                return false;
            }
            if (p_DMXControlTypeFadeDescription.getDisabledAdjustment() != this.m_DisabledAdjustment) {
                return false;
            }
            if (p_DMXControlTypeFadeDescription.getInternalFadeIn_Start() != this.m_FadeIn_Start) {
                return false;
            }
            if (p_DMXControlTypeFadeDescription.getInternalFadeIn_End() != this.m_FadeIn_End) {
                return false;
            }
            if (p_DMXControlTypeFadeDescription.getInternalFadeOut_Start() != this.m_FadeOut_Start) {
                return false;
            }
            if (p_DMXControlTypeFadeDescription.getInternalFadeOut_End() != this.m_FadeOut_End) {
                return false;
            }
            for (int intControl = 0; intControl < this.m_DMXControlType.getControlTypeCount(); ++intControl) {
                DMXControlComponent.ControlType o_ControlType = this.m_DMXControlType.getControlType(intControl);
                for (int intDimension = 0; intDimension < o_ControlType.getControlDimensionTypeCount(); ++intDimension) {
                    FadeValues o_FadeValuesSelf = this.getFadeValues(intControl, intDimension);
                    FadeValues o_FadeValues = p_DMXControlTypeFadeDescription.getFadeValues(intControl, intDimension);
                    if (o_FadeValuesSelf == null || o_FadeValuesSelf.equals(o_FadeValues)) continue;
                    return false;
                }
            }
            return true;
        }
    }

    public static class DMXDeviceFadeDescription
    implements PropertyChangeListener,
    Externalizable {
        public static final int SOFTWAREVERSION = 1;
        private String m_DMXDeviceID;
        private DMXDeviceType m_DMXDeviceType;
        private DMXFadeDescription m_DMXFadeDescription;
        private HashMap<String, DMXControlTypeFadeDescription> m_DMXControlTypeFadeDescriptionHashMap;
        private final Object m_SyncHashMap = new Object();

        public DMXDeviceFadeDescription(String p_DMXDeviceID) {
            this.initMembers();
            this.setDMXDevice(p_DMXDeviceID);
        }

        public DMXDeviceFadeDescription(DMXDeviceType p_DMXDeviceType) {
            this.initMembers();
            this.setDMXDeviceType(p_DMXDeviceType);
        }

        private void initMembers() {
            this.m_DMXControlTypeFadeDescriptionHashMap = new HashMap();
            this.m_DMXDeviceID = null;
            this.m_DMXDeviceType = null;
            this.m_DMXFadeDescription = null;
        }

        public void close() {
            this.clearDMXControlTypeFadeDesriptions();
            if (this.m_DMXFadeDescription != null) {
                this.m_DMXFadeDescription.removeDMXDeviceFadeDescriptionFromMap(this);
            }
            if (this.m_DMXDeviceID != null) {
                DMXDevice o_DMXDevice = DMXDevice.getDMXDevice(this.m_DMXDeviceID);
                if (o_DMXDevice != null) {
                    o_DMXDevice.removePropertyChangeListener(this);
                }
                this.m_DMXDeviceID = null;
            }
            this.m_DMXDeviceType = null;
            this.m_DMXFadeDescription = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void clearDMXControlTypeFadeDesriptions() {
            Object object = this.m_SyncHashMap;
            synchronized (object) {
                Iterator<DMXControlTypeFadeDescription> o_Iterator = this.m_DMXControlTypeFadeDescriptionHashMap.values().iterator();
                while (o_Iterator.hasNext()) {
                    DMXControlTypeFadeDescription o_DMXControlTypeFadeDescription;
                    try {
                        o_DMXControlTypeFadeDescription = o_Iterator.next();
                    }
                    catch (Exception error) {
                        o_DMXControlTypeFadeDescription = null;
                    }
                    if (o_DMXControlTypeFadeDescription == null) continue;
                    o_DMXControlTypeFadeDescription.close();
                }
                this.m_DMXControlTypeFadeDescriptionHashMap.clear();
            }
        }

        public void setDMXFadeDescription(DMXFadeDescription p_DMXFadeDescription) {
            this.m_DMXFadeDescription = p_DMXFadeDescription;
        }

        public void setDMXDevice(String p_DMXDeviceID) {
            DMXDevice o_DMXDevice;
            if (this.m_DMXDeviceID != null && (o_DMXDevice = DMXDevice.getDMXDevice(this.m_DMXDeviceID)) != null) {
                o_DMXDevice.removePropertyChangeListener("dmxdeviceDMXDeviceType", this);
            }
            this.m_DMXDeviceID = p_DMXDeviceID;
            if (this.m_DMXDeviceID != null) {
                o_DMXDevice = DMXDevice.getDMXDevice(this.m_DMXDeviceID);
                if (o_DMXDevice != null) {
                    o_DMXDevice.addPropertyChangeListener("dmxdeviceDMXDeviceType", this);
                    this.setDMXDeviceType(o_DMXDevice.getDMXDeviceType());
                } else {
                    this.setDMXDeviceType(null);
                }
            } else {
                this.setDMXDeviceType(null);
            }
        }

        public void setDMXDeviceType(DMXDeviceType p_DMXDeviceType) {
            if (this.m_DMXDeviceType == p_DMXDeviceType) {
                return;
            }
            if (p_DMXDeviceType == null) {
                this.close();
            } else {
                this.m_DMXDeviceType = p_DMXDeviceType;
                for (int intDMXControl = 0; intDMXControl < p_DMXDeviceType.getDMXControlTypeCount(); ++intDMXControl) {
                    DMXControlComponent.DMXControlType o_DMXControlType = p_DMXDeviceType.getDMXControlType(intDMXControl);
                    this.addDMXControlTypeFadeDescription(o_DMXControlType);
                }
                this.correct(p_DMXDeviceType);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DMXControlTypeFadeDescription addDMXControlTypeFadeDescription(DMXControlComponent.DMXControlType p_DMXControlType) {
            if (p_DMXControlType == null) {
                return null;
            }
            DMXControlTypeFadeDescription o_DMXControlTypeFadeDescription = this.getDMXControlTypeFadeDescription(p_DMXControlType.getID());
            if (o_DMXControlTypeFadeDescription == null) {
                DMXControlTypeFadeDescription o_DefaultDMXControlTypeFadeDescription;
                o_DMXControlTypeFadeDescription = new DMXControlTypeFadeDescription(this, p_DMXControlType);
                Object object = this.m_SyncHashMap;
                synchronized (object) {
                    this.m_DMXControlTypeFadeDescriptionHashMap.put(p_DMXControlType.getID(), o_DMXControlTypeFadeDescription);
                }
                if (this.m_DMXDeviceType != null && (o_DefaultDMXControlTypeFadeDescription = this.m_DMXDeviceType.getDefaultDMXControlTypeFadeDescription(p_DMXControlType)) != null) {
                    o_DefaultDMXControlTypeFadeDescription.copyTo(o_DMXControlTypeFadeDescription);
                }
            }
            return o_DMXControlTypeFadeDescription;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeDMXControlTypeFadeDescription(DMXControlComponent.DMXControlType p_DMXControlType) {
            if (p_DMXControlType == null) {
                return;
            }
            String stringDMXControlTypeID = p_DMXControlType.getID();
            Object object = this.m_SyncHashMap;
            synchronized (object) {
                this.m_DMXControlTypeFadeDescriptionHashMap.remove(stringDMXControlTypeID);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(1);
            Object object = this.m_SyncHashMap;
            synchronized (object) {
                DMXControlComponent.DMXControlType o_DMXControlType;
                int intDMXControlCount = this.m_DMXControlTypeFadeDescriptionHashMap.size();
                ArrayList<DMXControlTypeFadeDescription> o_DMXControlTypeFadeDescriptions = new ArrayList<DMXControlTypeFadeDescription>(intDMXControlCount);
                for (DMXControlTypeFadeDescription o_DMXControlTypeFadeDescription : this.m_DMXControlTypeFadeDescriptionHashMap.values()) {
                    String stringDMXControlTypeID;
                    if (o_DMXControlTypeFadeDescription == null || (o_DMXControlType = o_DMXControlTypeFadeDescription.getDMXControlType()) == null || (stringDMXControlTypeID = o_DMXControlType.getID()) == null) continue;
                    o_DMXControlTypeFadeDescriptions.add(o_DMXControlTypeFadeDescription);
                }
                intDMXControlCount = o_DMXControlTypeFadeDescriptions.size();
                out.writeInt(intDMXControlCount);
                for (int intDescription = 0; intDescription < intDMXControlCount; ++intDescription) {
                    DMXControlTypeFadeDescription o_DMXControlTypeFadeDescription;
                    o_DMXControlTypeFadeDescription = (DMXControlTypeFadeDescription)o_DMXControlTypeFadeDescriptions.get(intDescription);
                    o_DMXControlType = o_DMXControlTypeFadeDescription.getDMXControlType();
                    out.writeUTF(o_DMXControlType.getID());
                    o_DMXControlTypeFadeDescription.writeExternal(out);
                }
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            DMXDevice o_DMXDevice;
            int intSoftwareVersion = in.readInt();
            if (this.m_DMXDeviceID != null && (o_DMXDevice = DMXDevice.getDMXDevice(this.m_DMXDeviceID)) != null) {
                this.m_DMXDeviceType = o_DMXDevice.getDMXDeviceType();
            }
            int intDMXControlCount = in.readInt();
            for (int intDMXControl = 0; intDMXControl < intDMXControlCount; ++intDMXControl) {
                String stringDMXControlID = in.readUTF();
                DMXControlComponent.DMXControlType o_DMXControlType = this.m_DMXDeviceType != null ? this.m_DMXDeviceType.getDMXControlType(stringDMXControlID) : null;
                DMXControlTypeFadeDescription o_DMXControlTypeFadeDescription = this.getDMXControlTypeFadeDescription(stringDMXControlID);
                if (o_DMXControlTypeFadeDescription == null) {
                    o_DMXControlTypeFadeDescription = new DMXControlTypeFadeDescription(this, o_DMXControlType);
                }
                o_DMXControlTypeFadeDescription.readExternal(in);
                if (o_DMXControlType == null) continue;
                this.m_DMXControlTypeFadeDescriptionHashMap.put(stringDMXControlID, o_DMXControlTypeFadeDescription);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long getDiskSpaceEstimated() {
            long longBytesCount = 0L;
            longBytesCount += 4L;
            longBytesCount += 4L;
            Object object = this.m_SyncHashMap;
            synchronized (object) {
                for (DMXControlTypeFadeDescription o_DMXControlTypeFadeDescription : this.m_DMXControlTypeFadeDescriptionHashMap.values()) {
                    if (o_DMXControlTypeFadeDescription == null) continue;
                    longBytesCount += (long)(o_DMXControlTypeFadeDescription.getDMXControlType().getID().length() * 2);
                    longBytesCount += o_DMXControlTypeFadeDescription.getDiskSpaceEstimated();
                }
            }
            return longBytesCount;
        }

        public DMXDeviceFadeDescription getDefaultDMXDeviceFadeDescription() {
            if (this.m_DMXDeviceType == null) {
                return null;
            }
            return this.m_DMXDeviceType.getDefaultDMXDeviceFadeDescription();
        }

        public void setToDefault(String p_DMXDeviceID) {
            DMXDevice o_DMXDevice;
            if (p_DMXDeviceID == null) {
                return;
            }
            if (!p_DMXDeviceID.equals(this.m_DMXDeviceID)) {
                this.m_DMXDeviceID = p_DMXDeviceID;
            }
            if ((o_DMXDevice = DMXDevice.getDMXDevice(this.m_DMXDeviceID)) == null) {
                this.correct(null);
                return;
            }
            DMXDeviceType o_DMXDeviceType = o_DMXDevice.getDMXDeviceType();
            if (o_DMXDeviceType == null) {
                this.correct(null);
                return;
            }
            DMXDeviceFadeDescription o_DMXDeviceFadeDescription_Default = o_DMXDeviceType.getDefaultDMXDeviceFadeDescription();
            if (o_DMXDeviceFadeDescription_Default == null) {
                // empty if block
            }
            int intDMXControlTypeCount = o_DMXDeviceType.getDMXControlTypeCount();
            for (int intDMXControlType = 0; intDMXControlType < intDMXControlTypeCount; ++intDMXControlType) {
                DMXControlTypeFadeDescription o_DMXControlTypeFadeDescription_Default;
                String stringDMXControlTypeID;
                DMXControlTypeFadeDescription o_DMXControlTypeFadeDescription_Self;
                DMXControlComponent.DMXControlType o_DMXControlType = o_DMXDeviceType.getDMXControlType(intDMXControlType);
                if (o_DMXControlType == null || (o_DMXControlTypeFadeDescription_Self = this.getCreateDMXControlTypeFadeDescription(stringDMXControlTypeID = o_DMXControlType.getID())) == null || o_DMXDeviceFadeDescription_Default == null || (o_DMXControlTypeFadeDescription_Default = o_DMXDeviceFadeDescription_Default.getDMXControlTypeFadeDescription(stringDMXControlTypeID)) == null) continue;
                o_DMXControlTypeFadeDescription_Default.copyTo(o_DMXControlTypeFadeDescription_Self);
            }
            this.correct(o_DMXDeviceType);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void correct(DMXDeviceType p_DMXDeviceType) {
            if (p_DMXDeviceType == null) {
                return;
            }
            Object object = this.m_SyncHashMap;
            synchronized (object) {
                if (p_DMXDeviceType.getDMXControlTypeCount() == this.m_DMXControlTypeFadeDescriptionHashMap.size()) {
                    return;
                }
                Iterator<String> o_Iterator = this.m_DMXControlTypeFadeDescriptionHashMap.keySet().iterator();
                while (o_Iterator.hasNext()) {
                    String stringDMXControlTypeID = o_Iterator.next();
                    DMXControlTypeFadeDescription o_DMXControlTypeFadeDescription_Self = this.m_DMXControlTypeFadeDescriptionHashMap.get(stringDMXControlTypeID);
                    if (p_DMXDeviceType.getDMXControlType(stringDMXControlTypeID) != null) continue;
                    o_Iterator.remove();
                    if (o_DMXControlTypeFadeDescription_Self == null) continue;
                    o_DMXControlTypeFadeDescription_Self.close();
                }
            }
        }

        public String getDMXDeviceID() {
            return this.m_DMXDeviceID;
        }

        public DMXDeviceType getDMXDeviceType() {
            return this.m_DMXDeviceType;
        }

        public DMXControlTypeFadeDescription getDMXControlTypeFadeDescription(String p_DMXControlTypeID) {
            if (p_DMXControlTypeID == null) {
                return null;
            }
            if (this.m_DMXDeviceType == null) {
                return null;
            }
            DMXControlTypeFadeDescription o_DMXControlTypeFadeDescription_Self = this.m_DMXControlTypeFadeDescriptionHashMap.get(p_DMXControlTypeID);
            return o_DMXControlTypeFadeDescription_Self;
        }

        public DMXControlTypeFadeDescription getCreateDMXControlTypeFadeDescription(String p_DMXControlTypeID) {
            DMXControlTypeFadeDescription o_DMXControlTypeFadeDescription_Self = this.m_DMXControlTypeFadeDescriptionHashMap.get(p_DMXControlTypeID);
            if (o_DMXControlTypeFadeDescription_Self == null) {
                if (this.m_DMXDeviceType == null) {
                    return null;
                }
                DMXControlComponent.DMXControlType o_DMXControlType = this.m_DMXDeviceType.getDMXControlType(this.m_DMXDeviceID);
                o_DMXControlTypeFadeDescription_Self = this.addDMXControlTypeFadeDescription(o_DMXControlType);
            }
            return o_DMXControlTypeFadeDescription_Self;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isDisabled() {
            Object object = this.m_SyncHashMap;
            synchronized (object) {
                if (this.m_DMXControlTypeFadeDescriptionHashMap.size() <= 0) {
                    return true;
                }
                for (DMXControlTypeFadeDescription o_DMXControlTypeFadeDescription : this.m_DMXControlTypeFadeDescriptionHashMap.values()) {
                    if (o_DMXControlTypeFadeDescription == null || o_DMXControlTypeFadeDescription.getDisabled()) continue;
                    return false;
                }
            }
            return true;
        }

        public DMXDeviceFadeDescription copyTo(DMXDeviceFadeDescription p_DMXDeviceFadeDescription) {
            DMXDevice o_DMXDevice;
            if (p_DMXDeviceFadeDescription == null) {
                p_DMXDeviceFadeDescription = new DMXDeviceFadeDescription(this.m_DMXDeviceID);
            }
            if ((o_DMXDevice = DMXDevice.getDMXDevice(this.m_DMXDeviceID)) == null) {
                this.correct(null);
                return p_DMXDeviceFadeDescription;
            }
            DMXDeviceType o_DMXDeviceType = o_DMXDevice.getDMXDeviceType();
            if (o_DMXDeviceType == null) {
                this.correct(null);
                return p_DMXDeviceFadeDescription;
            }
            int intDMXControlTypeCount = o_DMXDeviceType.getDMXControlTypeCount();
            for (int intDMXControlType = 0; intDMXControlType < intDMXControlTypeCount; ++intDMXControlType) {
                DMXControlTypeFadeDescription o_DMXControlTypeFadeDescription_Dest;
                String stringDMXControlTypeID;
                DMXControlTypeFadeDescription o_DMXControlTypeFadeDescription_Self;
                DMXControlComponent.DMXControlType o_DMXControlType = o_DMXDeviceType.getDMXControlType(intDMXControlType);
                if (o_DMXControlType == null || (o_DMXControlTypeFadeDescription_Self = this.getCreateDMXControlTypeFadeDescription(stringDMXControlTypeID = o_DMXControlType.getID())) == null || (o_DMXControlTypeFadeDescription_Dest = p_DMXDeviceFadeDescription.getCreateDMXControlTypeFadeDescription(stringDMXControlTypeID)) == null) continue;
                o_DMXControlTypeFadeDescription_Self.copyTo(o_DMXControlTypeFadeDescription_Dest);
            }
            this.correct(o_DMXDeviceType);
            return p_DMXDeviceFadeDescription;
        }

        public boolean equals(DMXDeviceFadeDescription p_DMXDeviceFadeDescription) {
            if (p_DMXDeviceFadeDescription == null) {
                return false;
            }
            boolean boolIsSame = true;
            DMXDeviceType o_DMXDeviceType = this.m_DMXDeviceType;
            if (o_DMXDeviceType == null) {
                return false;
            }
            int intDMXControlTypeCount = o_DMXDeviceType.getDMXControlTypeCount();
            for (int intDMXControlType = 0; intDMXControlType < intDMXControlTypeCount; ++intDMXControlType) {
                DMXControlTypeFadeDescription o_DMXControlTypeFadeDescription_Dest;
                String stringDMXControlTypeID;
                DMXControlTypeFadeDescription o_DMXControlTypeFadeDescription_Self;
                DMXControlComponent.DMXControlType o_DMXControlType = o_DMXDeviceType.getDMXControlType(intDMXControlType);
                if (o_DMXControlType == null || (o_DMXControlTypeFadeDescription_Self = this.getDMXControlTypeFadeDescription(stringDMXControlTypeID = o_DMXControlType.getID())) == null || (o_DMXControlTypeFadeDescription_Dest = p_DMXDeviceFadeDescription.getDMXControlTypeFadeDescription(stringDMXControlTypeID)) == null || o_DMXControlTypeFadeDescription_Self.equals(o_DMXControlTypeFadeDescription_Dest)) continue;
                boolIsSame = false;
                break;
            }
            this.correct(o_DMXDeviceType);
            return boolIsSame;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() instanceof DMXDevice && "dmxdeviceDMXDeviceType".equals(evt.getPropertyName())) {
                this.setDMXDeviceType((DMXDeviceType)evt.getNewValue());
            }
        }
    }
}

