/*
 * Decompiled with CFR 0.152.
 */
package DMXScenePackage;

import DMXDevicePackage.DMXDevice;
import DMXDevicePackage.DMXDeviceGroup;
import DMXDevicePackage.DMXDeviceGroupPanel;
import DMXGraphics.LiveShowDMXStageView;
import DMXScenePackage.DMXScene;
import DMXVirtualPackage.LiveShowDMXObject;
import DMXVirtualPackage.LiveShowDMXVIP;
import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LanguageTools.LiveLanguagePackage.LiveLanguageString;
import LiveShowObjectPackage.LiveShowJingle;
import LiveShowObjectPackage.LiveShowObject;
import LiveShowObjectPackage.LiveShowObjectGroup;
import LiveShowObjectPackage.LiveShowObjectGroupPanel;
import LiveShowObjectPackage.LiveShowObjectInterface;
import StartPackage.LiveShowDMXSystem;
import SwingModelPackage.TableAndListModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JList;
import javax.swing.RowFilter;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

public class DMXSceneFilter
implements PropertyChangeListener {
    public static final TableAndListModel.ListModel<DMXSceneFilter> s_DMXSceneFilterListModel = new TableAndListModel.ListModel(false);
    public static DMXSceneFilterRenderer s_DMXSceneFilterRenderer;
    @LiveLanguageString
    public static String DMXSCENEFILTER_ALL_NAME;
    @LiveLanguageString
    public static String DMXSCENEFILTER_ALL_REMARK;
    public static DMXSceneFilterAll s_DMXSceneFilterAll;
    @LiveLanguageString
    public static String DMXSCENEFILTER_TEXT_NAME;
    @LiveLanguageString
    public static String DMXSCENEFILTER_TEXT_REMARK;
    public static DMXSceneFilterText s_DMXSceneFilterText;
    @LiveLanguageString
    public static String DMXSCENEFILTER_USED_NAME;
    @LiveLanguageString
    public static String DMXSCENEFILTER_USED_REMARK;
    public static DMXSceneFilterUsed s_DMXSceneFilterUsed;
    @LiveLanguageString
    public static String DMXSCENEFILTER_DEVICE_NAME;
    @LiveLanguageString
    public static String DMXSCENEFILTER_DEVICE_REMARK;
    public static DMXSceneFilterDevice s_DMXSceneFilterDevice;
    @LiveLanguageString
    public static String DMXSCENEFILTER_DEVICEGROUP_NAME;
    @LiveLanguageString
    public static String DMXSCENEFILTER_DEVICEGROUP_REMARK;
    public static DMXSceneFilterDeviceGroup s_DMXSceneFilterDeviceGroup;
    @LiveLanguageString
    public static String DMXSCENEFILTER_TIMELINE_NAME;
    @LiveLanguageString
    public static String DMXSCENEFILTER_TIMELINE_REMARK;
    public static DMXSceneFilterTimeline s_DMXSceneFilterTimeline;
    @LiveLanguageString
    public static String DMXSCENEFILTER_JINGLE_NAME;
    @LiveLanguageString
    public static String DMXSCENEFILTER_JINGLE_REMARK;
    public static DMXSceneFilterJingle s_DMXSceneFilterJingle;
    @LiveLanguageString
    public static String DMXSCENEFILTER_OBJECTGROUP_NAME;
    @LiveLanguageString
    public static String DMXSCENEFILTER_OBJECTGROUP_REMARK;
    public static DMXSceneFilterObjectGroup s_DMXSceneFilterObjectGroup;
    public static boolean s_InvertFilter;
    protected FilterInterface m_FilterInterface;
    protected boolean m_Closed;

    public static TableAndListModel.ListModel<DMXSceneFilter> getListModel() {
        return s_DMXSceneFilterListModel;
    }

    public static DefaultListCellRenderer getListCellRenderer() {
        return s_DMXSceneFilterRenderer;
    }

    public static DMXSceneFilter createDMXSceneFilter(FilterInterface p_FilterInterface) {
        DMXSceneFilter o_DMXDeviceFilter = DMXSceneFilter.getDMXDeviceFilter(p_FilterInterface);
        if (o_DMXDeviceFilter != null) {
            return o_DMXDeviceFilter;
        }
        o_DMXDeviceFilter = new DMXSceneFilter(p_FilterInterface);
        return o_DMXDeviceFilter;
    }

    public static void addDMXSceneFilter(DMXSceneFilter p_DMXSceneFilter) {
        if (p_DMXSceneFilter == null) {
            return;
        }
        s_DMXSceneFilterListModel.add(p_DMXSceneFilter);
    }

    public static void removeDMXSceneFilter(DMXSceneFilter p_DMXSceneFilter) {
        if (p_DMXSceneFilter == null) {
            return;
        }
        if (s_DMXSceneFilterListModel.remove(p_DMXSceneFilter)) {
            p_DMXSceneFilter.close();
        }
    }

    public static DMXSceneFilter getDMXDeviceFilter(FilterInterface p_FilterInterface) {
        FilterInterface o_FilterInterface;
        DMXSceneFilter o_DMXSceneFilter;
        int intIndex;
        if (p_FilterInterface == null) {
            return null;
        }
        for (intIndex = 0; intIndex < s_DMXSceneFilterListModel.size(); ++intIndex) {
            o_DMXSceneFilter = s_DMXSceneFilterListModel.get(intIndex);
            if (o_DMXSceneFilter == null || (o_FilterInterface = o_DMXSceneFilter.getFilterInterface()) != p_FilterInterface) continue;
            return o_DMXSceneFilter;
        }
        for (intIndex = 0; intIndex < s_DMXSceneFilterListModel.size_FilteredNot(); ++intIndex) {
            o_DMXSceneFilter = s_DMXSceneFilterListModel.get_FilteredNot(intIndex);
            if (o_DMXSceneFilter == null || (o_FilterInterface = o_DMXSceneFilter.getFilterInterface()) != p_FilterInterface) continue;
            return o_DMXSceneFilter;
        }
        return null;
    }

    public static boolean getInvertFilter() {
        return s_InvertFilter;
    }

    public static void setInvertFilter(boolean p_InvertFilter) {
        s_InvertFilter = p_InvertFilter;
    }

    public DMXSceneFilter(FilterInterface p_FilterInterface) {
        this.initMembers();
        this.setFilterInterface(p_FilterInterface);
        DMXSceneFilter.addDMXSceneFilter(this);
    }

    protected void initMembers() {
        LiveLanguage.addLanguageListener((Object)this, null);
        this.m_Closed = false;
    }

    public void close() {
        if (this.m_Closed) {
            return;
        }
        this.m_Closed = true;
        LiveLanguage.removeLanguageListener((Object)this);
        if (this.m_FilterInterface != null) {
            this.setFilterInterface(null);
        }
    }

    public void setFilterInterface(FilterInterface p_FilterInterface) {
        Method o_Method;
        if (p_FilterInterface == this.m_FilterInterface) {
            return;
        }
        FilterInterface oldValue = this.m_FilterInterface;
        if (this.m_FilterInterface != null) {
            o_Method = null;
            try {
                o_Method = this.m_FilterInterface.getClass().getDeclaredMethod("removePropertyChangeListener", PropertyChangeListener.class);
                if (o_Method != null) {
                    o_Method.invoke((Object)this.m_FilterInterface, this);
                }
            }
            catch (Exception e) {
                o_Method = null;
            }
        }
        this.m_FilterInterface = p_FilterInterface;
        if (this.m_FilterInterface != null) {
            o_Method = null;
            try {
                o_Method = this.m_FilterInterface.getClass().getDeclaredMethod("addPropertyChangeListener", PropertyChangeListener.class);
                if (o_Method != null) {
                    o_Method.invoke((Object)this.m_FilterInterface, this);
                }
            }
            catch (Exception e) {
                Object var3_3 = null;
            }
        }
    }

    public FilterInterface getFilterInterface() {
        return this.m_FilterInterface;
    }

    public String getName() {
        if (this.m_FilterInterface == null) {
            return "";
        }
        return this.m_FilterInterface.getName();
    }

    public String getRemark() {
        if (this.m_FilterInterface == null) {
            return "";
        }
        return this.m_FilterInterface.getRemark();
    }

    public Icon getIcon() {
        if (this.m_FilterInterface == null) {
            return null;
        }
        return this.m_FilterInterface.getIcon();
    }

    public boolean containsDMXScene(DMXScene p_DMXScene) {
        if (this.m_FilterInterface == null) {
            return false;
        }
        return this.m_FilterInterface.useDMXScene(p_DMXScene);
    }

    public String getListSortPreFix() {
        if (this instanceof DMXSceneFilterText) {
            return "A";
        }
        if (this instanceof DMXSceneFilterUsed) {
            return "B";
        }
        if (this instanceof DMXSceneFilterDevice) {
            return "C";
        }
        if (this instanceof DMXSceneFilterDeviceGroup) {
            return "CA";
        }
        if (this instanceof DMXSceneFilterTimeline) {
            return "DA";
        }
        if (this instanceof DMXSceneFilterJingle) {
            return "DB";
        }
        if (this.m_FilterInterface == null) {
            return "";
        }
        return "";
    }

    public String getSortName() {
        StringBuilder o_StringBuilder = new StringBuilder();
        o_StringBuilder.append(this.getListSortPreFix());
        o_StringBuilder.append(this.getClass().getSimpleName());
        o_StringBuilder.append(this.getName());
        return o_StringBuilder.toString();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof FilterInterface) {
            FilterInterface o_FilterInterface = (FilterInterface)evt.getSource();
            ArrayList<DMXSceneFilter> o_DMXSceneFilters = s_DMXSceneFilterListModel.getElementArrayList_Safe();
            for (int intDMXDeviceFilter = 0; intDMXDeviceFilter < o_DMXSceneFilters.size(); ++intDMXDeviceFilter) {
                DMXSceneFilter o_DMXSceneFilter = o_DMXSceneFilters.get(intDMXDeviceFilter);
                if (o_DMXSceneFilter.getFilterInterface() != o_FilterInterface) continue;
                s_DMXSceneFilterListModel.changedElement(o_DMXSceneFilter);
            }
        }
    }

    static {
        s_DMXSceneFilterListModel.setGetSortStringMethod(DMXSceneFilter.class, "getSortString", true);
        s_DMXSceneFilterListModel.setGetNameMethod(DMXSceneFilter.class, "getName");
        s_DMXSceneFilterRenderer = new DMXSceneFilterRenderer();
        DMXSCENEFILTER_ALL_NAME = "All";
        DMXSCENEFILTER_ALL_REMARK = "show all light ambiances";
        s_DMXSceneFilterAll = new DMXSceneFilterAll();
        DMXSCENEFILTER_TEXT_NAME = "Text Filter";
        DMXSCENEFILTER_TEXT_REMARK = "show all light ambiances conatining the search string in name or remark";
        s_DMXSceneFilterText = new DMXSceneFilterText();
        DMXSCENEFILTER_USED_NAME = "Used";
        DMXSCENEFILTER_USED_REMARK = "show all light ambiances used in timeline or jingles";
        s_DMXSceneFilterUsed = new DMXSceneFilterUsed();
        DMXSCENEFILTER_DEVICE_NAME = "Selected Lamp Filter";
        DMXSCENEFILTER_DEVICE_REMARK = "show all light ambiances using one of the selected lamps in DMXStageView";
        s_DMXSceneFilterDevice = new DMXSceneFilterDevice();
        DMXSCENEFILTER_DEVICEGROUP_NAME = "Selected Lamp Group Filter";
        DMXSCENEFILTER_DEVICEGROUP_REMARK = "show all light ambiances using one of lamps of the selected lampgroup";
        s_DMXSceneFilterDeviceGroup = new DMXSceneFilterDeviceGroup();
        DMXSCENEFILTER_TIMELINE_NAME = "Selected light objects";
        DMXSCENEFILTER_TIMELINE_REMARK = "show all light ambiances used in the selected light objects in the timeline";
        s_DMXSceneFilterTimeline = new DMXSceneFilterTimeline();
        DMXSCENEFILTER_JINGLE_NAME = "Selected light objects";
        DMXSCENEFILTER_JINGLE_REMARK = "show all light ambiances used in the selected light objects in the timeline";
        s_DMXSceneFilterJingle = new DMXSceneFilterJingle();
        DMXSCENEFILTER_OBJECTGROUP_NAME = "Selected Object Group Filter";
        DMXSCENEFILTER_OBJECTGROUP_REMARK = "show all light ambiances used by the selected objectgroup";
        s_DMXSceneFilterObjectGroup = new DMXSceneFilterObjectGroup();
        s_InvertFilter = false;
    }

    public static class DMXSceneFilterObjectGroup
    extends DMXSceneFilter {
        public static Icon s_Icon = new ImageIcon(DMXSceneFilterText.class.getResource("/IconsPackage/Timeline_ObjectGroup.png"));

        public DMXSceneFilterObjectGroup() {
            super(null);
            this.initMembers();
        }

        @Override
        protected void initMembers() {
            super.initMembers();
        }

        @Override
        public String getName() {
            return DMXSCENEFILTER_OBJECTGROUP_NAME;
        }

        @Override
        public String getRemark() {
            return DMXSCENEFILTER_OBJECTGROUP_REMARK;
        }

        @Override
        public Icon getIcon() {
            return s_Icon;
        }

        @Override
        public boolean containsDMXScene(DMXScene p_DMXScene) {
            if (p_DMXScene == null) {
                return false;
            }
            int intSelectedGroupCount = LiveShowObjectGroupPanel.getSelectedGroupCount();
            for (int intGroup = 0; intGroup < intSelectedGroupCount; ++intGroup) {
                LiveShowObjectGroup o_LiveShowObjectGroup = LiveShowObjectGroupPanel.getSelectedGroup(intGroup);
                if (o_LiveShowObjectGroup == null) continue;
                int intObjectCount = o_LiveShowObjectGroup.getObjectCount();
                for (int intObject = 0; intObject < intObjectCount; ++intObject) {
                    LiveShowDMXObject o_LiveShowDMXObject;
                    LiveShowObjectInterface o_LiveShowObjectInterface = o_LiveShowObjectGroup.getObject(intObject);
                    if (o_LiveShowObjectInterface == null || !(o_LiveShowObjectInterface instanceof LiveShowDMXObject) || (o_LiveShowDMXObject = (LiveShowDMXObject)o_LiveShowObjectInterface).getDMXScene() != p_DMXScene) continue;
                    return true;
                }
            }
            return false;
        }
    }

    public static class DMXSceneFilterJingle
    extends DMXSceneFilter {
        public static Icon s_Icon = new ImageIcon(DMXSceneFilterText.class.getResource("/IconsPackage/Object_Select.png"));

        public DMXSceneFilterJingle() {
            super(null);
            this.initMembers();
        }

        @Override
        protected void initMembers() {
            super.initMembers();
        }

        @Override
        public String getName() {
            return DMXSCENEFILTER_JINGLE_NAME;
        }

        @Override
        public String getRemark() {
            return DMXSCENEFILTER_JINGLE_REMARK;
        }

        @Override
        public Icon getIcon() {
            return s_Icon;
        }

        @Override
        public boolean containsDMXScene(DMXScene p_DMXScene) {
            if (p_DMXScene == null) {
                return false;
            }
            LiveShowJingle.JingleContainerInterface o_JingleContainerInterface = LiveShowDMXSystem.getJingleContainerInterface();
            int intJingleCount = o_JingleContainerInterface.getSelectedJingleViewCount();
            for (int intJingle = 0; intJingle < intJingleCount; ++intJingle) {
                LiveShowDMXObject o_LiveShowDMXObject;
                DMXScene o_DMXScene;
                LiveShowObject o_LiveShowObjectInterface;
                LiveShowJingle.JingleInterface o_JingleInterface = o_JingleContainerInterface.getSelectedJingleView(intJingle);
                if (o_JingleInterface == null || (o_LiveShowObjectInterface = o_JingleInterface.getLiveShowObject()) == null || !(o_LiveShowObjectInterface instanceof LiveShowDMXObject) || (o_DMXScene = (o_LiveShowDMXObject = (LiveShowDMXObject)o_LiveShowObjectInterface).getDMXScene()) != p_DMXScene) continue;
                return true;
            }
            return false;
        }
    }

    public static class DMXSceneFilterTimeline
    extends DMXSceneFilter {
        public static Icon s_Icon = new ImageIcon(DMXSceneFilterText.class.getResource("/IconsPackage/Object_Select.png"));

        public DMXSceneFilterTimeline() {
            super(null);
            this.initMembers();
        }

        @Override
        protected void initMembers() {
            super.initMembers();
        }

        @Override
        public String getName() {
            return DMXSCENEFILTER_TIMELINE_NAME;
        }

        @Override
        public String getRemark() {
            return DMXSCENEFILTER_TIMELINE_REMARK;
        }

        @Override
        public Icon getIcon() {
            return s_Icon;
        }

        @Override
        public boolean containsDMXScene(DMXScene p_DMXScene) {
            if (p_DMXScene == null) {
                return false;
            }
            LiveShowDMXVIP o_LiveShowDMXVIP = LiveShowDMXSystem.getLiveShowDMXVIP();
            int intSelectedObjectCount = o_LiveShowDMXVIP.getSelectedObjectsCount();
            for (int intObject = 0; intObject < intSelectedObjectCount; ++intObject) {
                LiveShowDMXObject o_LiveShowDMXObject;
                LiveShowObjectInterface o_LiveShowObjectInterface = o_LiveShowDMXVIP.getSelectedObjectInterface(intObject);
                if (o_LiveShowObjectInterface == null || !(o_LiveShowObjectInterface instanceof LiveShowDMXObject) || (o_LiveShowDMXObject = (LiveShowDMXObject)o_LiveShowObjectInterface).getDMXScene() != p_DMXScene) continue;
                return true;
            }
            return false;
        }
    }

    public static class DMXSceneFilterUsed
    extends DMXSceneFilter {
        public static Icon s_IconSelectedObjects = new ImageIcon(DMXSceneFilterUsed.class.getResource("/IconsPackage/Object.png"));

        public DMXSceneFilterUsed() {
            super(null);
        }

        @Override
        protected void initMembers() {
            super.initMembers();
        }

        @Override
        public String getName() {
            return DMXSCENEFILTER_USED_NAME;
        }

        @Override
        public String getRemark() {
            return DMXSCENEFILTER_USED_REMARK;
        }

        @Override
        public boolean containsDMXScene(DMXScene p_DMXScene) {
            if (p_DMXScene == null) {
                return false;
            }
            return p_DMXScene.getLiveShowDMXObjectCount() > 0;
        }

        @Override
        public Icon getIcon() {
            return s_IconSelectedObjects;
        }
    }

    public static class DMXSceneFilterDeviceGroup
    extends DMXSceneFilter {
        public static Icon s_Icon = new ImageIcon(DMXSceneFilterText.class.getResource("/IconsPackage/DeviceGroupView.png"));

        public DMXSceneFilterDeviceGroup() {
            super(null);
            this.initMembers();
        }

        @Override
        protected void initMembers() {
            super.initMembers();
        }

        @Override
        public String getName() {
            return DMXSCENEFILTER_DEVICEGROUP_NAME;
        }

        @Override
        public String getRemark() {
            return DMXSCENEFILTER_DEVICEGROUP_REMARK;
        }

        @Override
        public Icon getIcon() {
            return s_Icon;
        }

        @Override
        public boolean containsDMXScene(DMXScene p_DMXScene) {
            if (p_DMXScene == null) {
                return false;
            }
            int intSelectedGroupCount = DMXDeviceGroupPanel.getSelectedGroupCount();
            for (int intGroup = 0; intGroup < intSelectedGroupCount; ++intGroup) {
                DMXDeviceGroup o_DMXDeviceGroup = DMXDeviceGroupPanel.getSelectedGroup(intGroup);
                if (o_DMXDeviceGroup == null) continue;
                int intDMXDeviceCount = o_DMXDeviceGroup.getObjectCount();
                for (int intDMXDevice = 0; intDMXDevice < intDMXDeviceCount; ++intDMXDevice) {
                    DMXDevice o_DMXDevice = o_DMXDeviceGroup.getObject(intDMXDevice);
                    if (o_DMXDevice == null || !p_DMXScene.useDMXDevice(o_DMXDevice)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    public static class DMXSceneFilterDevice
    extends DMXSceneFilter {
        public static Icon s_Icon = new ImageIcon(DMXSceneFilterText.class.getResource("/IconsPackage/DMX.png"));

        public DMXSceneFilterDevice() {
            super(null);
            this.initMembers();
        }

        @Override
        protected void initMembers() {
            super.initMembers();
        }

        @Override
        public String getName() {
            return DMXSCENEFILTER_DEVICE_NAME;
        }

        @Override
        public String getRemark() {
            return DMXSCENEFILTER_DEVICE_REMARK;
        }

        @Override
        public Icon getIcon() {
            return s_Icon;
        }

        @Override
        public boolean containsDMXScene(DMXScene p_DMXScene) {
            if (p_DMXScene == null) {
                return false;
            }
            LiveShowDMXStageView o_LiveShowDMXStageView = LiveShowDMXStageView.s_SelfReference;
            int intSelectedDeviceCount = o_LiveShowDMXStageView.getSelectedDMXDeviceCount();
            for (int intDMXDevice = 0; intDMXDevice < intSelectedDeviceCount; ++intDMXDevice) {
                DMXDevice o_DMXDevice = o_LiveShowDMXStageView.getSelectedDMXDevice(intDMXDevice);
                if (o_DMXDevice == null || !p_DMXScene.useDMXDevice(o_DMXDevice)) continue;
                return true;
            }
            return false;
        }
    }

    public static class DMXSceneFilterText
    extends DMXSceneFilter {
        public static Icon s_Icon = new ImageIcon(DMXSceneFilterText.class.getResource("/IconsPackage/Text.png"));
        protected String m_FilterString;

        public DMXSceneFilterText() {
            super(null);
            this.initMembers();
        }

        @Override
        protected void initMembers() {
            super.initMembers();
            this.m_FilterString = "";
        }

        @Override
        public String getName() {
            return DMXSCENEFILTER_TEXT_NAME;
        }

        @Override
        public String getRemark() {
            return DMXSCENEFILTER_TEXT_REMARK;
        }

        @Override
        public Icon getIcon() {
            return s_Icon;
        }

        public void setFilterString(String p_FilterString) {
            this.m_FilterString = p_FilterString == null ? "" : p_FilterString.toLowerCase();
        }

        @Override
        public boolean containsDMXScene(DMXScene p_DMXScene) {
            if (p_DMXScene == null) {
                return false;
            }
            if (this.m_FilterString == null || this.m_FilterString.length() <= 0) {
                return true;
            }
            if (p_DMXScene.getName().toLowerCase().contains(this.m_FilterString)) {
                return true;
            }
            return p_DMXScene.getRemark().toLowerCase().contains(this.m_FilterString);
        }
    }

    public static class DMXSceneFilterAll
    extends DMXSceneFilter {
        public DMXSceneFilterAll() {
            super(null);
        }

        @Override
        public String getName() {
            return DMXSCENEFILTER_ALL_NAME;
        }

        @Override
        public String getRemark() {
            return DMXSCENEFILTER_ALL_REMARK;
        }

        @Override
        public Icon getIcon() {
            return null;
        }

        @Override
        public boolean containsDMXScene(DMXScene p_DMXScene) {
            return p_DMXScene != null;
        }
    }

    public static class DMXSceneFilterRenderer
    extends DefaultListCellRenderer {
        protected static final Border SAFE_NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);
        protected static final Border DEFAULT_NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);
        protected static final Border SELECTED_BORDER = new LineBorder(Color.BLUE, 2, true);
        protected Dimension m_PreferredDimension = new Dimension(20, 28);

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setComponentOrientation(list.getComponentOrientation());
            Color o_Background = null;
            Color o_Foreground = null;
            o_Background = list.getBackground();
            o_Foreground = list.getForeground();
            if (isSelected) {
                if (list.hasFocus()) {
                    o_Background = UIManager.getColor("List.selectionBackground");
                    o_Foreground = UIManager.getColor("List.selectionForeground");
                } else {
                    o_Background = UIManager.getColor("List.selectionInactiveBackground");
                    o_Foreground = UIManager.getColor("List.selectionInactiveForeground");
                }
            }
            this.setForeground(o_Foreground);
            this.setBackground(o_Background);
            this.setHorizontalAlignment(0);
            if (value instanceof Icon) {
                this.setIcon((Icon)value);
                this.setText("");
            } else {
                String stringFilterRemark;
                String stringFilterName;
                this.setIcon(null);
                if (value == null) {
                    stringFilterName = "---";
                    stringFilterRemark = null;
                } else {
                    DMXSceneFilter o_DMXSceneFilter = (DMXSceneFilter)value;
                    stringFilterName = o_DMXSceneFilter.getName();
                    stringFilterRemark = o_DMXSceneFilter.getRemark();
                    Icon o_Icon = o_DMXSceneFilter.getIcon();
                    if (o_Icon == null) {
                        this.setPreferredSize(this.m_PreferredDimension);
                    }
                    this.setIcon(o_Icon);
                    FilterInterface o_FilterInterface = o_DMXSceneFilter.getFilterInterface();
                    if (o_FilterInterface != null) {
                        // empty if block
                    }
                }
                this.setText(stringFilterName);
                this.setToolTipText(stringFilterRemark);
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            Border border = null;
            if (isSelected) {
                border = SELECTED_BORDER;
            }
            if (border == null) {
                border = this.getNoFocusBorder();
            }
            return this;
        }

        private Border getNoFocusBorder() {
            Border border = null;
            if (System.getSecurityManager() != null) {
                if (border != null) {
                    return border;
                }
                return SAFE_NO_FOCUS_BORDER;
            }
            if (border != null && (noFocusBorder == null || noFocusBorder == DEFAULT_NO_FOCUS_BORDER)) {
                return border;
            }
            return noFocusBorder;
        }
    }

    public static class DMXSceneRowFilter
    extends RowFilter<DMXScene.DMXSceneTableModel, Integer> {
        private DMXScene.DMXSceneTableModel m_DMXSceneTableModel;
        private DMXSceneFilter m_DMXSceneFilter;

        public DMXSceneRowFilter(DMXScene.DMXSceneTableModel p_DMXSceneTableModel) {
            this.initMembers();
            this.m_DMXSceneTableModel = p_DMXSceneTableModel;
        }

        private void initMembers() {
            this.m_DMXSceneFilter = null;
        }

        public void setDMXSceneFilter(DMXSceneFilter p_DMXSceneFilter) {
            this.m_DMXSceneFilter = p_DMXSceneFilter;
            if (this.m_DMXSceneTableModel != null) {
                this.m_DMXSceneTableModel.fireTableDataChanged();
            }
        }

        @Override
        public boolean include(RowFilter.Entry entry) {
            if (this.m_DMXSceneTableModel == null) {
                return false;
            }
            if (this.m_DMXSceneFilter == null) {
                return true;
            }
            int intRow = (Integer)entry.getIdentifier();
            DMXScene o_DMXScene = this.m_DMXSceneTableModel.getDMXScene(intRow);
            if (o_DMXScene == null) {
                return false;
            }
            if (!DMXSceneFilter.getInvertFilter()) {
                return this.m_DMXSceneFilter.containsDMXScene(o_DMXScene);
            }
            return !this.m_DMXSceneFilter.containsDMXScene(o_DMXScene);
        }
    }

    public static interface FilterInterface {
        public String getName();

        public String getRemark();

        public Icon getIcon();

        public boolean useDMXScene(DMXScene var1);
    }
}

