/*
 * Decompiled with CFR 0.152.
 */
package DMXScenePackage;

import DMX512.DMXUniverse;
import DMXDevicePackage.DMXDevice;
import DMXDevicePackage.DMXDeviceFilter;
import DMXDevicePackage.DMXDeviceType;
import DMXGraphics.LiveShowDMXCrossTable_DMXDeviceDMXScene;
import DMXMixer.DMXControlComponent;
import DMXMixer.DMXControlDescription;
import DMXMixer.DMXControl_GridPanTilt;
import DMXMixer.DMXControl_GridPanTilt_DeviceSettings;
import DMXMixer.DMXControl_RGB;
import DMXScenePackage.DMXSceneCopyInterface;
import DMXScenePackage.DMXSceneFilter;
import DMXVirtualPackage.DMXFadeDescription;
import DMXVirtualPackage.LiveShowDMXObject;
import DMXVirtualPackage.LiveShowDMXSceneBridge;
import DMXVirtualPackage.LiveShowDMXVIP;
import DMXVirtualPackage.LiveShowDMXVIPAdjustment;
import GUID.LiveGUID;
import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LanguageTools.LiveLanguagePackage.LiveLanguageString;
import LiveShowControlObjects.ControlObject;
import LiveShowObjectPackage.LiveShowObject;
import LiveShowObjectPackage.LiveShowObjectInterface;
import LiveShowObjectPackage.LiveShowProjectDescription;
import LiveShowObjectPackage.SinglePropertyChangeSupport;
import LiveShowPlayPackage.Playable;
import LiveShowVirtualPackage.LiveShowVIP;
import LiveShowVirtualPackage.LiveShow_ImportDescription;
import PlayDMXPackage.PlayDMX;
import StartPackage.LiveShowDMXSystem;
import SwingModelPackage.TableAndListModel;
import SwingToolTipPackage.PopUpToolTip;
import Text.NameExtension;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Externalizable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;

public class DMXScene
implements Externalizable,
DMXDeviceFilter.FilterInterface {
    public static final int SOFTWAREVERSION = 1;
    public static final String FILESUFFIX = ".lss";
    @LiveLanguageString
    public static String DEFAULT_DMXSCENENAME = "Ambiance";
    public static final int COPYFLAG_NONE = 0;
    public static final int COPYFLAG_OK = 1;
    public static final int COPYFLAG_UNCERTAIN = 2;
    public static final int COPYFLAG_FAILURE = 3;
    public static final String PROP_DMXSCENE_NAME = "dmxsceneName";
    public static final String PROP_DMXSCENE_REMARK = "dmxsceneRemark";
    public static final String PROP_DMXSCENE_CHANGED = "dmxsceneChanged";
    public static final int FLAG_MIXINMAIN_NOTDEFINED = -1;
    public static final int FLAG_MIXINMAIN_TIMELINE = 0;
    public static final int FLAG_MIXINMAIN_MIXER = 1;
    public static final int FLAG_MIXINMAIN_JINGLE = 2;
    public static final int FLAG_MIXINMAIN_LINE = 9;
    public static final int FLAG_EDITMODE = 10;
    protected static DMXSceneTableModel s_DMXSceneTableModel = new DMXSceneTableModel();
    protected static DMXSceneListModel s_DMXSceneListModel = new DMXSceneListModel();
    protected static TableAndListModel.ListRenderer s_DMXSceneListRenderer = new TableAndListModel.ListRenderer();
    protected String m_ID;
    protected String m_Name;
    protected String m_Remark;
    protected StringBuffer m_StringBuilderToolTip;
    protected DMXSceneValueContainer m_DMXSceneValueContainer;
    protected SinglePropertyChangeSupport m_PropertyChangeSupport;
    protected ArrayList<LiveShowDMXObject> m_LiveShowDMXObjects;
    protected LiveShow_ImportDescription m_LiveShow_ImportDescription;
    public static DMXSceneValueContainer s_DMXSceneValueContainer_EditMode = new DMXSceneValueContainer(null, 10);
    public static DMXSceneValueContainer s_DMXSceneValueContainer_Main = new DMXSceneValueContainer(null, 9);
    public static DMXSceneValueContainer s_DMXSceneValueContainer_Mixer = new DMXSceneValueContainer(null, 1);
    public static DMXSceneValueContainer s_DMXSceneValueContainer_Timeline = new DMXSceneValueContainer(null, 0);
    public static DMXSceneValueContainer s_DMXSceneValueContainer_TimelineDiff = new DMXSceneValueContainer(null);
    public static ArrayList<DMXSceneValueContainer> s_List_Jingles_ValueContainer = new ArrayList(3);
    public static DMXSceneValueContainer s_DMXSceneValueContainer_Jingle = new DMXSceneValueContainer(null, 2);
    public static DMXSceneValueContainer s_DMXSceneValueContainer_JingleSum = new DMXSceneValueContainer(null, 2);
    public static DMXSceneValueContainer s_DMXSceneValueContainer_JingleDiff = new DMXSceneValueContainer(null);
    public static DMXSceneValueContainer s_DMXSceneValueContainer_JingleStart = new DMXSceneValueContainer(null);
    private static boolean s_JingleActive = false;
    private static boolean s_JingleActive_Changed = false;
    public static boolean s_JingleFadeInBlackout = true;
    public static ImageIcon s_Icon = new ImageIcon(DMXScene.class.getResource("/IconsPackage/DMXScene_20.png"));
    private static final Object m_SyncMixObject = new Object();
    private final Object m_SyncStringBuilder = new Object();
    public static int DMXDEVICES_PER_COLUMN = 25;
    public static DMXScene_Comparator s_DMXScene_Comparator = new DMXScene_Comparator();

    public DMXScene() {
        this("");
    }

    public DMXScene(String p_Name) {
        this.initMembers();
        this.m_Name = this.createName(p_Name);
        this.refreshToolTipText();
    }

    private void initMembers() {
        this.m_ID = LiveGUID.getUID();
        this.m_PropertyChangeSupport = new SinglePropertyChangeSupport(this);
        this.m_LiveShowDMXObjects = new ArrayList();
        this.m_StringBuilderToolTip = new StringBuffer();
        LiveLanguage.addLanguageListener((Object)this, null);
        this.m_Remark = "";
        this.m_DMXSceneValueContainer = new DMXSceneValueContainer(this, 0);
        DMXDeviceFilter.createDMXDeviceFilter(this);
        this.m_LiveShow_ImportDescription = null;
    }

    public void close() {
        DMXDeviceFilter.removeDMXDeviceFilter(this);
        if (this.m_PropertyChangeSupport != null) {
            this.m_PropertyChangeSupport.firePropertyChange("liveShowObject_SourceClose", this, null);
            this.m_PropertyChangeSupport.clear();
        }
        if (this.m_DMXSceneValueContainer != null) {
            this.m_DMXSceneValueContainer.close();
            this.m_DMXSceneValueContainer = null;
        }
        LiveLanguage.removeLanguageListener((Object)this);
    }

    public void finalize() throws Throwable {
        super.finalize();
        this.m_PropertyChangeSupport = null;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(1);
        out.writeUTF(this.m_ID);
        out.writeUTF(this.m_Name);
        out.writeUTF(this.m_Remark);
        this.m_DMXSceneValueContainer.writeExternal(out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int intSoftwareVersion = in.readInt();
        String oldValue = this.m_Name;
        this.m_ID = in.readUTF();
        this.m_Name = in.readUTF();
        this.m_Remark = in.readUTF();
        this.m_DMXSceneValueContainer.readExternal(in);
        this.refreshToolTipText();
        if (this.m_PropertyChangeSupport != null) {
            this.m_PropertyChangeSupport.firePropertyChange(PROP_DMXSCENE_NAME, oldValue, this.m_Name);
        }
    }

    public DMXScene clone(DMXScene p_DMXScene) {
        if (p_DMXScene == null) {
            p_DMXScene = new DMXScene();
        }
        this.m_DMXSceneValueContainer.clone(p_DMXScene.getDMXSceneValueContainer());
        return p_DMXScene;
    }

    public void setLiveShow_ImportDescription(LiveShow_ImportDescription p_LiveShow_ImportDescription) {
        this.m_LiveShow_ImportDescription = p_LiveShow_ImportDescription;
    }

    public LiveShow_ImportDescription getLiveShow_ImportDescription() {
        return this.m_LiveShow_ImportDescription;
    }

    public long getDiskSpaceEstimated() {
        long longBytesCount = 0L;
        longBytesCount += 36L;
        longBytesCount += (long)(this.m_Name.length() * 2);
        longBytesCount += (long)(this.m_Remark.length() * 2);
        longBytesCount = this.m_DMXSceneValueContainer.getDiskSpaceEstimated();
        return longBytesCount;
    }

    public String getID() {
        return this.m_ID;
    }

    private String createName(String p_Name) {
        int intPrefixCount = 0;
        int intMaxPostfix = 0;
        String stringPrefix = p_Name != null && p_Name.length() > 0 ? NameExtension.getPrefix(p_Name) : DEFAULT_DMXSCENENAME;
        for (int intScene = 0; intScene < DMXScene.getDMXSceneCount(); ++intScene) {
            int intPostfix;
            DMXScene o_DMXScene = DMXScene.getDMXScene(intScene);
            if (o_DMXScene == null || (intPostfix = NameExtension.getPostfix_Int(o_DMXScene.getName(), stringPrefix)) == -2) continue;
            if (intPostfix == -1) {
                intPostfix = ++intPrefixCount;
            }
            if (intPostfix <= intMaxPostfix) continue;
            intMaxPostfix = intPostfix;
        }
        return NameExtension.createName(stringPrefix, ++intMaxPostfix, "000", true);
    }

    public void setName(String p_Name) {
        if (p_Name == null) {
            return;
        }
        String oldValue = this.m_Name;
        this.m_Name = p_Name;
        this.refreshToolTipText();
        if (this.m_PropertyChangeSupport != null) {
            this.m_PropertyChangeSupport.firePropertyChange(PROP_DMXSCENE_NAME, oldValue, this.m_Name);
        }
    }

    @Override
    public String getName() {
        return this.m_Name;
    }

    public void setRemark(String p_Remark) {
        if (p_Remark == null) {
            return;
        }
        String oldValue = this.m_Remark;
        this.m_Remark = p_Remark;
        this.refreshToolTipText();
        if (this.m_PropertyChangeSupport != null) {
            this.m_PropertyChangeSupport.firePropertyChange(PROP_DMXSCENE_REMARK, oldValue, this.m_Remark);
        }
    }

    @Override
    public String getRemark() {
        return this.m_Remark;
    }

    public String getToolTipText() {
        return this.m_StringBuilderToolTip.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshToolTipText() {
        int intDMXDeviceCount_InColumn = 0;
        Object object = this.m_SyncStringBuilder;
        synchronized (object) {
            this.m_StringBuilderToolTip.delete(0, this.m_StringBuilderToolTip.length());
            this.m_StringBuilderToolTip.append("<html><center>");
            this.m_StringBuilderToolTip.append("<b>");
            this.m_StringBuilderToolTip.append(this.getName());
            this.m_StringBuilderToolTip.append("</b><br>");
            this.m_StringBuilderToolTip.append(this.getRemark());
            this.m_StringBuilderToolTip.append("</center>");
            this.m_StringBuilderToolTip.append("<table align=center>");
            this.m_StringBuilderToolTip.append("<tr>");
            this.m_StringBuilderToolTip.append("<td align=center>");
            this.m_StringBuilderToolTip.append("<table align=top>");
            for (int intDMXDevice = 0; intDMXDevice < DMXDevice.getDMXDeviceCount(); ++intDMXDevice) {
                DMXDevice o_DMXDevice = DMXDevice.getDMXDevice(intDMXDevice);
                if (o_DMXDevice == null) continue;
                if (!o_DMXDevice.getIsDimmable()) {
                    if (!this.isSomethingOn(o_DMXDevice)) continue;
                    if (intDMXDeviceCount_InColumn >= DMXDEVICES_PER_COLUMN) {
                        intDMXDeviceCount_InColumn = 0;
                        this.m_StringBuilderToolTip.append("</table>");
                        this.m_StringBuilderToolTip.append("</td>");
                        this.m_StringBuilderToolTip.append("<td align=center>");
                        this.m_StringBuilderToolTip.append("<table align=top>");
                    }
                    this.m_StringBuilderToolTip.append("<p>");
                    this.m_StringBuilderToolTip.append("<tr>");
                    this.m_StringBuilderToolTip.append("<td align=right>");
                    this.m_StringBuilderToolTip.append(o_DMXDevice.getName());
                    this.m_StringBuilderToolTip.append("</td>");
                    this.m_StringBuilderToolTip.append("<td align=right>");
                    this.m_StringBuilderToolTip.append("?");
                    this.m_StringBuilderToolTip.append("</td>");
                    this.m_StringBuilderToolTip.append("</tr>");
                    this.m_StringBuilderToolTip.append("</p");
                    ++intDMXDeviceCount_InColumn;
                    continue;
                }
                double doubleValueMax = this.getDimmerValue(o_DMXDevice);
                if (!(doubleValueMax > 0.0)) continue;
                if (intDMXDeviceCount_InColumn >= DMXDEVICES_PER_COLUMN) {
                    intDMXDeviceCount_InColumn = 0;
                    this.m_StringBuilderToolTip.append("</table>");
                    this.m_StringBuilderToolTip.append("</td>");
                    this.m_StringBuilderToolTip.append("<td align=center>");
                    this.m_StringBuilderToolTip.append("<table align=top>");
                }
                this.m_StringBuilderToolTip.append("<p>");
                this.m_StringBuilderToolTip.append("<tr>");
                this.m_StringBuilderToolTip.append("<td align=right>");
                this.m_StringBuilderToolTip.append(o_DMXDevice.getName());
                this.m_StringBuilderToolTip.append("</td>");
                this.m_StringBuilderToolTip.append("<td align=right style=\"color:rgb(0,255,0)\">");
                this.m_StringBuilderToolTip.append((int)(doubleValueMax / 65535.0 * 100.0 + 0.5));
                this.m_StringBuilderToolTip.append("</td>");
                this.m_StringBuilderToolTip.append("</tr>");
                this.m_StringBuilderToolTip.append("</p");
                ++intDMXDeviceCount_InColumn;
            }
            this.m_StringBuilderToolTip.append("</table>");
            this.m_StringBuilderToolTip.append("</td>");
            this.m_StringBuilderToolTip.append("</table>");
            this.m_StringBuilderToolTip.append("</html>");
        }
    }

    public DMXSceneValueContainer getDMXSceneValueContainer() {
        return this.m_DMXSceneValueContainer;
    }

    public void saveDMXSceneLight() {
        if (this.m_DMXSceneValueContainer != null) {
            this.m_DMXSceneValueContainer.saveDMXSceneLight();
            if (this.m_PropertyChangeSupport != null) {
                this.m_PropertyChangeSupport.firePropertyChange(PROP_DMXSCENE_CHANGED, null, this);
            }
        }
        this.refreshToolTipText();
    }

    public void writeDMXSceneLight() {
        if (this.m_DMXSceneValueContainer != null) {
            this.m_DMXSceneValueContainer.writeDMXSceneLight();
        }
    }

    public void cleanUpDMXSceneLight() {
        if (this.m_DMXSceneValueContainer != null) {
            this.m_DMXSceneValueContainer.cleanUpDMXSceneLight();
        }
    }

    public void externalChanged() {
        if (this.m_PropertyChangeSupport != null) {
            this.m_PropertyChangeSupport.firePropertyChange(PROP_DMXSCENE_CHANGED, null, this);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
        if (p_PropertyChangeListener == null) {
            return;
        }
        if (this.m_PropertyChangeSupport != null) {
            this.m_PropertyChangeSupport.addPropertyChangeListener(p_PropertyChangeListener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
        if (this.m_PropertyChangeSupport != null) {
            this.m_PropertyChangeSupport.removePropertyChangeListener(p_PropertyChangeListener);
        }
    }

    public boolean isSomethingOn(DMXDevice p_DMXDevice) {
        if (p_DMXDevice == null) {
            return false;
        }
        DMXSceneValueContainer o_DMXSceneValueContainer = this.getDMXSceneValueContainer();
        if (o_DMXSceneValueContainer == null) {
            return false;
        }
        DMXSceneDeviceValues o_DMXSceneDeviceValues = o_DMXSceneValueContainer.getDMXSceneDeviceValues(p_DMXDevice.getID());
        if (o_DMXSceneDeviceValues == null) {
            return false;
        }
        return o_DMXSceneDeviceValues.calculateSomethingOn();
    }

    public boolean isDimmerOn(DMXDevice p_DMXDevice) {
        if (p_DMXDevice == null) {
            return false;
        }
        if (!p_DMXDevice.getIsDimmable()) {
            return true;
        }
        DMXSceneValueContainer o_DMXSceneValueContainer = this.getDMXSceneValueContainer();
        if (o_DMXSceneValueContainer == null) {
            return false;
        }
        DMXSceneDeviceValues o_DMXSceneDeviceValues = o_DMXSceneValueContainer.getDMXSceneDeviceValues(p_DMXDevice.getID());
        if (o_DMXSceneDeviceValues == null) {
            return false;
        }
        return o_DMXSceneDeviceValues.isDimmerOn();
    }

    public double getDimmerValue(DMXDevice p_DMXDevice) {
        if (p_DMXDevice == null) {
            return 0.0;
        }
        DMXSceneValueContainer o_DMXSceneValueContainer = this.getDMXSceneValueContainer();
        if (o_DMXSceneValueContainer == null) {
            return 0.0;
        }
        DMXSceneDeviceValues o_DMXSceneDeviceValues = o_DMXSceneValueContainer.getDMXSceneDeviceValues(p_DMXDevice.getID());
        if (o_DMXSceneDeviceValues == null) {
            return 0.0;
        }
        return o_DMXSceneDeviceValues.calculateDimmerValue();
    }

    public void addLiveShowDMXObject(LiveShowDMXObject p_LiveShowDMXObject) {
        if (p_LiveShowDMXObject == null) {
            return;
        }
        if (this.m_LiveShowDMXObjects.contains(p_LiveShowDMXObject)) {
            return;
        }
        this.m_LiveShowDMXObjects.add(p_LiveShowDMXObject);
    }

    public void removeLiveShowDMXObject(LiveShowDMXObject p_LiveShowDMXObject) {
        if (p_LiveShowDMXObject == null) {
            return;
        }
        if (!this.m_LiveShowDMXObjects.contains(p_LiveShowDMXObject)) {
            return;
        }
        this.m_LiveShowDMXObjects.remove(p_LiveShowDMXObject);
    }

    public int getLiveShowDMXObjectCount() {
        return this.m_LiveShowDMXObjects.size();
    }

    public double getMinValue(DMXDevice p_DMXDevice, String p_DMXControlDescription_ID, int p_ControlIndex, int p_DimensionIndex) {
        if (p_DMXDevice == null) {
            return -2.147483648E9;
        }
        if (p_DMXControlDescription_ID == null) {
            return -2.147483648E9;
        }
        double doubleMinValue = 2.147483647E9;
        ArrayList<DMXControlComponent.DMXControlType> o_DMXControlTypes = p_DMXDevice.getDMXDeviceType().getDMXControlTypes(p_DMXControlDescription_ID);
        if (o_DMXControlTypes == null) {
            return -2.147483648E9;
        }
        for (int intDMXControlType = 0; intDMXControlType < o_DMXControlTypes.size(); ++intDMXControlType) {
            DMXControlComponent.DMXControlType o_DMXControlType = o_DMXControlTypes.get(intDMXControlType);
            double doubleValue = this.getValue(p_DMXDevice, o_DMXControlType, p_ControlIndex, p_DimensionIndex);
            if (doubleValue < 0.0 || !(doubleValue < doubleMinValue)) continue;
            doubleMinValue = doubleValue;
        }
        if (doubleMinValue == 2.147483647E9) {
            doubleMinValue = -2.147483648E9;
        }
        return doubleMinValue;
    }

    public double getMaxValue(DMXDevice p_DMXDevice, String p_DMXControlDescription_ID, int p_ControlIndex, int p_DimensionIndex) {
        if (p_DMXDevice == null) {
            return -2.147483648E9;
        }
        if (p_DMXControlDescription_ID == null) {
            return -2.147483648E9;
        }
        double doubleMaxValue = -2.147483648E9;
        ArrayList<DMXControlComponent.DMXControlType> o_DMXControlTypes = p_DMXDevice.getDMXDeviceType().getDMXControlTypes(p_DMXControlDescription_ID);
        if (o_DMXControlTypes == null) {
            return -2.147483648E9;
        }
        for (int intDMXControlType = 0; intDMXControlType < o_DMXControlTypes.size(); ++intDMXControlType) {
            DMXControlComponent.DMXControlType o_DMXControlType = o_DMXControlTypes.get(intDMXControlType);
            double doubleValue = this.getValue(p_DMXDevice, o_DMXControlType, p_ControlIndex, p_DimensionIndex);
            if (doubleValue < 0.0 || !(doubleValue > doubleMaxValue)) continue;
            doubleMaxValue = doubleValue;
        }
        return doubleMaxValue;
    }

    public double getValue(DMXDevice p_DMXDevice, DMXControlComponent.DMXControlType p_DMXControlType, int p_ControlIndex, int p_DimensionIndex) {
        if (p_DMXDevice == null) {
            return -2.147483648E9;
        }
        if (p_DMXControlType == null) {
            return -2.147483648E9;
        }
        if (this.m_DMXSceneValueContainer == null) {
            return -2.147483648E9;
        }
        DMXSceneDeviceValues o_DMXSceneDeviceValues = this.m_DMXSceneValueContainer.getDMXSceneDeviceValues(p_DMXDevice.getID());
        if (o_DMXSceneDeviceValues == null) {
            return -2.147483648E9;
        }
        DMXControlComponent.ControlType o_ControlType = p_DMXControlType.getControlType(p_ControlIndex);
        if (o_ControlType == null) {
            return -2.147483648E9;
        }
        DMXControlComponent.ControlDimensionType o_ControlDimensionType = o_ControlType.getControlDimensionType(p_DimensionIndex);
        if (o_ControlDimensionType == null) {
            return -2.147483648E9;
        }
        double doubleValue = o_DMXSceneDeviceValues.getValueDMXDevice(o_ControlDimensionType);
        return doubleValue;
    }

    public double setValue(double p_Value, DMXDevice p_DMXDevice, DMXControlComponent.DMXControlType p_DMXControlType, int p_ControlIndex, int p_DimensionIndex) {
        if (p_DMXDevice == null) {
            return -2.147483648E9;
        }
        if (p_DMXControlType == null) {
            return -2.147483648E9;
        }
        if (this.m_DMXSceneValueContainer == null) {
            return -2.147483648E9;
        }
        DMXSceneDeviceValues o_DMXSceneDeviceValues = this.m_DMXSceneValueContainer.getDMXSceneDeviceValues(p_DMXDevice.getID());
        if (o_DMXSceneDeviceValues == null) {
            return -2.147483648E9;
        }
        DMXControlComponent.ControlType o_ControlType = p_DMXControlType.getControlType(p_ControlIndex);
        if (o_ControlType == null) {
            return -2.147483648E9;
        }
        DMXControlComponent.ControlDimensionType o_ControlDimensionType = o_ControlType.getControlDimensionType(p_DimensionIndex);
        if (o_ControlDimensionType == null) {
            return -2.147483648E9;
        }
        o_DMXSceneDeviceValues.setValueDMXDevice(p_Value, o_ControlDimensionType);
        double doubleValue = o_DMXSceneDeviceValues.getValueDMXDevice(o_ControlDimensionType);
        return doubleValue;
    }

    public static void setPanTilt_VirtualPointFromAngles(DMXScene p_DMXScene, DMXDevice p_DMXDevice) {
        DMXSceneDeviceValues o_DMXSceneDeviceValues;
        if (p_DMXScene == null) {
            return;
        }
        if (p_DMXDevice == null) {
            return;
        }
        DMXSceneValueContainer o_DMXSceneValueContainer = p_DMXScene.getDMXSceneValueContainer();
        if (o_DMXSceneValueContainer != null && (o_DMXSceneDeviceValues = o_DMXSceneValueContainer.getDMXSceneDeviceValues(p_DMXDevice.getID())) != null) {
            o_DMXSceneDeviceValues.setPanTilt_VirtualPointFromAngles();
        }
    }

    public static void setPanTilt_AnglesFromVirtualPoint(DMXScene p_DMXScene, DMXDevice p_DMXDevice, DMXControl_GridPanTilt_DeviceSettings.VirtualPoint p_VirtualPoint) {
        DMXSceneDeviceValues o_DMXSceneDeviceValues;
        if (p_DMXScene == null) {
            return;
        }
        if (p_DMXDevice == null) {
            return;
        }
        if (p_VirtualPoint == null) {
            return;
        }
        DMXSceneValueContainer o_DMXSceneValueContainer = p_DMXScene.getDMXSceneValueContainer();
        if (o_DMXSceneValueContainer != null && (o_DMXSceneDeviceValues = o_DMXSceneValueContainer.getDMXSceneDeviceValues(p_DMXDevice.getID())) != null) {
            o_DMXSceneDeviceValues.setPanTilt_AnglesFromVirtualPoint(p_VirtualPoint);
        }
    }

    public static void addJingleDMXSceneValueContainer(DMXSceneValueContainer p_DMXSceneValueContainer) {
        DMXScene.addJingleDMXSceneValueContainer(-1, p_DMXSceneValueContainer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addJingleDMXSceneValueContainer(int p_Index, DMXSceneValueContainer p_DMXSceneValueContainer) {
        if (p_DMXSceneValueContainer == null) {
            return;
        }
        Object object = m_SyncMixObject;
        synchronized (object) {
            if (s_List_Jingles_ValueContainer.size() == 0 && !s_JingleActive) {
                s_JingleActive = true;
                s_JingleActive_Changed = true;
            }
            if (s_List_Jingles_ValueContainer.contains(p_DMXSceneValueContainer)) {
                return;
            }
            if (p_Index < 0) {
                s_List_Jingles_ValueContainer.add(p_DMXSceneValueContainer);
            } else {
                s_List_Jingles_ValueContainer.add(p_Index, p_DMXSceneValueContainer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeJingleDMXSceneValueContainer(DMXSceneValueContainer p_DMXSceneValueContainer) {
        if (p_DMXSceneValueContainer == null) {
            return;
        }
        Object object = m_SyncMixObject;
        synchronized (object) {
            s_List_Jingles_ValueContainer.remove(p_DMXSceneValueContainer);
            if (s_List_Jingles_ValueContainer.size() == 0 && s_JingleActive) {
                s_JingleActive = false;
                s_JingleActive_Changed = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void changedJingleDMXSceneValueContainer(ArrayList<Playable.PlayObject> p_Added, ArrayList<Playable.PlayObject> p_Removed) {
        Object object = m_SyncMixObject;
        synchronized (object) {
            DMXSceneValueContainer o_DMXSceneValueContainer;
            PlayDMX.DMXPlayObject o_DMXPlayObject;
            int intJingle;
            if (p_Removed != null) {
                for (intJingle = 0; intJingle < p_Removed.size(); ++intJingle) {
                    o_DMXPlayObject = (PlayDMX.DMXPlayObject)p_Removed.get(intJingle);
                    if (o_DMXPlayObject == null || (o_DMXSceneValueContainer = o_DMXPlayObject.getDMXSceneValueContainer()) == null) continue;
                    s_List_Jingles_ValueContainer.remove(o_DMXPlayObject.getDMXSceneValueContainer());
                    if (s_List_Jingles_ValueContainer.size() != 0 || !s_JingleActive) continue;
                    s_JingleActive = false;
                    s_JingleActive_Changed = true;
                }
            }
            if (p_Added != null) {
                for (intJingle = 0; intJingle < p_Added.size(); ++intJingle) {
                    o_DMXPlayObject = (PlayDMX.DMXPlayObject)p_Added.get(intJingle);
                    if (o_DMXPlayObject == null || (o_DMXSceneValueContainer = o_DMXPlayObject.getDMXSceneValueContainer()) == null) continue;
                    if (s_List_Jingles_ValueContainer.size() == 0 && !s_JingleActive) {
                        s_JingleActive = true;
                        s_JingleActive_Changed = true;
                    }
                    s_List_Jingles_ValueContainer.remove(o_DMXSceneValueContainer);
                    s_List_Jingles_ValueContainer.add(intJingle, o_DMXSceneValueContainer);
                }
            }
        }
    }

    public static void mixJingles(DMXSceneValueContainer p_DMXSceneValueContainer) {
        if (p_DMXSceneValueContainer == null) {
            return;
        }
        DMXScene.mixJingles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mixJingles() {
        boolean boolFirstReset = true;
        Object object = m_SyncMixObject;
        synchronized (object) {
            s_DMXSceneValueContainer_JingleSum.setFadeProgress(0.0);
            s_DMXSceneValueContainer_JingleSum.setFadeInProgress(0.0);
            s_DMXSceneValueContainer_JingleSum.setFadeOutProgress(0.0);
            for (int intJingle = 0; intJingle < s_List_Jingles_ValueContainer.size(); ++intJingle) {
                DMXSceneValueContainer o_DMXSceneValueContainer_Jingle = s_List_Jingles_ValueContainer.get(intJingle);
                s_DMXSceneValueContainer_JingleSum.mixInJingle(o_DMXSceneValueContainer_Jingle, boolFirstReset);
                boolFirstReset = false;
                if (!(o_DMXSceneValueContainer_Jingle.getFadeProgress() > s_DMXSceneValueContainer_JingleSum.getFadeProgress())) continue;
                s_DMXSceneValueContainer_JingleSum.setFadeInProgress(o_DMXSceneValueContainer_Jingle.getFadeInProgress());
                s_DMXSceneValueContainer_JingleSum.setFadeOutProgress(o_DMXSceneValueContainer_Jingle.getFadeOutProgress());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mixMain(DMXSceneValueContainer p_DMXSceneValueContainer) {
        if (p_DMXSceneValueContainer == null) {
            return;
        }
        boolean boolChanged = false;
        Object object = m_SyncMixObject;
        synchronized (object) {
            int intDMXDeviceCount = DMXDevice.getDMXDeviceCount();
            if (2 == p_DMXSceneValueContainer.getFlagMixSource()) {
                DMXScene.mixJingles(p_DMXSceneValueContainer);
                p_DMXSceneValueContainer = s_DMXSceneValueContainer_JingleSum;
            }
            for (int intDMXDevice = 0; intDMXDevice < intDMXDeviceCount; ++intDMXDevice) {
                DMXSceneDeviceValues o_DMXSceneDeviceValues;
                DMXDevice o_DMXDevice = DMXDevice.getDMXDevice(intDMXDevice);
                if (o_DMXDevice == null || (o_DMXSceneDeviceValues = p_DMXSceneValueContainer.getDMXSceneDeviceValues(o_DMXDevice.getID())) == null || !DMXSceneDeviceValues.mixMain(o_DMXDevice, o_DMXSceneDeviceValues)) continue;
                boolChanged = true;
            }
            s_JingleActive_Changed = false;
            s_DMXSceneValueContainer_Timeline.setOverwriteManualValues(false);
        }
        if (boolChanged) {
            boolean boolManuallySet = 1 == p_DMXSceneValueContainer.getFlagMixSource();
            DMXScene.writeMainMixToChannels(boolManuallySet);
        }
    }

    public static void writeMainMixToChannels(boolean p_NanuallySet) {
        s_DMXSceneValueContainer_Main.writeDMXSceneToChannels(p_NanuallySet);
        s_DMXSceneValueContainer_Timeline.setOverwriteManualValues(false);
    }

    @Override
    public Icon getIcon() {
        return s_Icon;
    }

    @Override
    public boolean useDMXDevice(DMXDevice p_DMXDevice) {
        return this.isDimmerOn(p_DMXDevice);
    }

    public static void copyFrom(DMXSceneCopyInterface p_CopyInterface_Dest, DMXDevice p_DMXDevice_Dest, DMXScene p_DMXScene_Dest, DMXDevice p_DMXDevice_Source, DMXScene p_DMXScene_Source) {
        if (p_CopyInterface_Dest == null) {
            return;
        }
        if (p_DMXDevice_Source == null || p_DMXScene_Source == null) {
            return;
        }
        if (p_DMXDevice_Dest == null || p_DMXScene_Dest == null) {
            return;
        }
        if (p_DMXDevice_Dest == p_DMXDevice_Source && p_DMXScene_Dest == p_DMXScene_Source) {
            return;
        }
        ArrayList<DMXControlDescription> o_DMXControlDescriptions_Dest = new ArrayList<DMXControlDescription>();
        for (int intDMXControl = 0; intDMXControl < p_DMXDevice_Dest.getDMXControlComponentCount(); ++intDMXControl) {
            DMXControlComponent o_DMXControlComponent_Dest = p_DMXDevice_Dest.getDMXControlComponent(intDMXControl);
            DMXControlDescription o_DMXControlDescription_Dest = o_DMXControlComponent_Dest.getDMXControlType().getDMXControlDescription();
            if (o_DMXControlDescriptions_Dest.contains(o_DMXControlDescription_Dest)) continue;
            o_DMXControlDescriptions_Dest.add(o_DMXControlDescription_Dest);
        }
        DMXScene.copyFrom(p_CopyInterface_Dest, p_DMXDevice_Dest, p_DMXScene_Dest, p_DMXDevice_Source, p_DMXScene_Source, o_DMXControlDescriptions_Dest);
    }

    public static void copyFrom(DMXSceneCopyInterface p_CopyInterface_Dest, DMXDevice p_DMXDevice_Dest, DMXScene p_DMXScene_Dest, DMXDevice p_DMXDevice_Source, DMXScene p_DMXScene_Source, ArrayList<DMXControlDescription> p_DMXControlDescriptions_Dest) {
        if (p_CopyInterface_Dest == null) {
            return;
        }
        if (p_DMXDevice_Dest == null || p_DMXDevice_Source == null) {
            return;
        }
        if (p_DMXScene_Dest == null || p_DMXScene_Source == null) {
            return;
        }
        if (p_DMXControlDescriptions_Dest == null || p_DMXControlDescriptions_Dest.size() <= 0) {
            return;
        }
        if (p_DMXDevice_Dest == p_DMXDevice_Source && p_DMXScene_Dest == p_DMXScene_Source) {
            return;
        }
        boolean intCopyEstimation = true;
        DMXControlDescription o_DMXControlDescription = DMXControlDescription.getDMXControlDescription("dimmer");
        if (p_DMXControlDescriptions_Dest.contains(o_DMXControlDescription)) {
            p_DMXControlDescriptions_Dest.remove(o_DMXControlDescription);
            DMXScene.copyFromDimmer(p_CopyInterface_Dest, p_DMXDevice_Dest, p_DMXScene_Dest, p_DMXDevice_Source, p_DMXScene_Source);
        }
        if (p_DMXControlDescriptions_Dest.contains(o_DMXControlDescription = DMXControlDescription.getDMXControlDescription("rgbcmy"))) {
            p_DMXControlDescriptions_Dest.remove(o_DMXControlDescription);
            DMXScene.copyFromRGB(p_CopyInterface_Dest, p_DMXDevice_Dest, p_DMXScene_Dest, p_DMXDevice_Source, p_DMXScene_Source);
        }
        if (p_DMXControlDescriptions_Dest.contains(o_DMXControlDescription = DMXControlDescription.getDMXControlDescription("pantilt"))) {
            p_DMXControlDescriptions_Dest.remove(o_DMXControlDescription);
            DMXScene.copyFromPanTilt(p_CopyInterface_Dest, p_DMXDevice_Dest, p_DMXScene_Dest, p_DMXDevice_Source, p_DMXScene_Source);
        }
        if (p_DMXDevice_Source.getDMXDeviceType().getID().equals(p_DMXDevice_Dest.getDMXDeviceType().getID())) {
            for (int intDMXControlComponent = 0; intDMXControlComponent < p_DMXDevice_Source.getDMXControlComponentCount(); ++intDMXControlComponent) {
                intCopyEstimation = true;
                DMXControlComponent o_DMXControlComponent_Dest = p_DMXDevice_Dest.getDMXControlComponent(intDMXControlComponent);
                if (!p_DMXControlDescriptions_Dest.contains(o_DMXControlComponent_Dest.getDMXControlType().getDMXControlDescription())) continue;
                DMXControlComponent o_DMXControlComponent_Source = p_DMXDevice_Source.getDMXControlComponent(intDMXControlComponent);
                DMXScene.copyFromControl(p_CopyInterface_Dest, p_DMXDevice_Dest, p_DMXScene_Dest, o_DMXControlComponent_Dest, p_DMXDevice_Source, p_DMXScene_Source, o_DMXControlComponent_Source);
            }
        } else {
            ArrayList<DMXControlComponent> o_DMXControlComponents_Source = new ArrayList<DMXControlComponent>();
            ArrayList<DMXControlComponent> o_DMXControlComponents_Dest = new ArrayList<DMXControlComponent>();
            for (int intDescription = 0; intDescription < p_DMXControlDescriptions_Dest.size(); ++intDescription) {
                intCopyEstimation = true;
                o_DMXControlDescription = p_DMXControlDescriptions_Dest.get(intDescription);
                if (o_DMXControlDescription == null || o_DMXControlDescription.getID().equals(DMXControlDescription.ID_UNDEFINED)) continue;
                o_DMXControlComponents_Source.clear();
                o_DMXControlComponents_Dest.clear();
                o_DMXControlComponents_Source = p_DMXDevice_Source.getDMXControlComponentsByDescription(o_DMXControlDescription, o_DMXControlComponents_Source);
                o_DMXControlComponents_Dest = p_DMXDevice_Dest.getDMXControlComponentsByDescription(o_DMXControlDescription, o_DMXControlComponents_Dest);
                if (o_DMXControlComponents_Dest.size() <= 0 || o_DMXControlComponents_Source.size() <= 0 || o_DMXControlComponents_Source.size() > o_DMXControlComponents_Dest.size() || o_DMXControlComponents_Source.size() < o_DMXControlComponents_Dest.size() && o_DMXControlComponents_Source.size() > 1) continue;
                for (int intDMXControl = 0; intDMXControl < o_DMXControlComponents_Dest.size(); ++intDMXControl) {
                    DMXControlComponent o_DMXControlComponent_Dest = o_DMXControlComponents_Dest.get(intDMXControl);
                    DMXControlComponent o_DMXControlComponent_Source = intDMXControl >= o_DMXControlComponents_Source.size() ? o_DMXControlComponents_Source.get(o_DMXControlComponents_Source.size() - 1) : o_DMXControlComponents_Source.get(intDMXControl);
                    DMXScene.copyFromControl(p_CopyInterface_Dest, p_DMXDevice_Dest, p_DMXScene_Dest, o_DMXControlComponent_Dest, p_DMXDevice_Source, p_DMXScene_Source, o_DMXControlComponent_Source);
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static int copyFromControl(DMXSceneCopyInterface p_CopyInterface_Dest, DMXDevice p_DMXDevice_Dest, DMXScene p_DMXScene_Dest, DMXControlComponent p_DMXControlComponent_Dest, DMXDevice p_DMXDevice_Source, DMXScene p_DMXScene_Source, DMXControlComponent p_DMXControlComponent_Source) {
        if (p_DMXDevice_Dest == null) {
            return 3;
        }
        if (p_DMXScene_Dest == null) {
            return 3;
        }
        if (p_DMXControlComponent_Dest == null) {
            return 3;
        }
        if (p_DMXDevice_Source == null) {
            return 3;
        }
        if (p_DMXScene_Source == null) {
            return 3;
        }
        if (p_DMXControlComponent_Source == null) {
            return 3;
        }
        if (p_DMXControlComponent_Dest.getDMXControlDescription() != p_DMXControlComponent_Source.getDMXControlDescription()) {
            return 3;
        }
        if (p_DMXControlComponent_Dest.getControlObjectCount() != p_DMXControlComponent_Source.getControlObjectCount()) {
            return 3;
        }
        boolSomethingCopied = false;
        intCopyEstimated = 1;
        boolDeviceTypesEquals = p_DMXDevice_Dest.getDMXDeviceType().getID().equals(p_DMXDevice_Source.getDMXDeviceType().getID()) == true;
        for (intControlObject = 0; intControlObject < p_DMXControlComponent_Dest.getControlObjectCount(); ++intControlObject) {
            o_ControlObject_Dest = p_DMXControlComponent_Dest.getControlObject(intControlObject);
            o_ControlObject_Source = p_DMXControlComponent_Source.getControlObject(intControlObject);
            if (o_ControlObject_Dest.getControlDimensionCount() != o_ControlObject_Source.getControlDimensionCount()) continue;
            block9: for (intDimension = 0; intDimension < o_ControlObject_Dest.getControlDimensionCount(); ++intDimension) {
                if (!p_DMXControlComponent_Dest.getIsLinked(o_ControlObject_Dest.getControlDimension(intDimension)) || !p_DMXControlComponent_Source.getIsLinked(o_ControlObject_Source.getControlDimension(intDimension))) continue;
                if (boolDeviceTypesEquals) ** GOTO lbl-1000
                intCopyEstimated = 2;
                o_ControlDimension_Dest = o_ControlObject_Dest.getControlDimension(intDimension);
                o_ControlDimension_Source = o_ControlObject_Source.getControlDimension(intDimension);
                o_ControlLabelModel_Dest = o_ControlDimension_Dest.getControlLabelModel();
                if (o_ControlLabelModel_Dest.isSameAs(o_ControlLabelModel_Source = o_ControlDimension_Source.getControlLabelModel())) ** GOTO lbl-1000
                if (!o_ControlLabelModel_Dest.isSameStructure(o_ControlLabelModel_Source)) continue;
                var22_20 = p_DMXControlComponent_Dest.getDMXControlDescription().getID();
                var23_21 = -1;
                switch (var22_20.hashCode()) {
                    case -1001082257: {
                        if (!var22_20.equals("programs")) break;
                        var23_21 = 0;
                        break;
                    }
                    case 2072762349: {
                        if (!var22_20.equals("shutter")) break;
                        var23_21 = 1;
                        break;
                    }
                    case -891980511: {
                        if (!var22_20.equals("strobe")) break;
                        var23_21 = 2;
                    }
                }
                switch (var23_21) {
                    case 0: 
                    case 1: 
                    case 2: {
                        continue block9;
                    }
                    default: lbl-1000:
                    // 3 sources

                    {
                        doubleValue_Dest = p_CopyInterface_Dest.getValueCopyDMXScene(p_DMXDevice_Dest, p_DMXScene_Dest, p_DMXControlComponent_Dest.getDMXControlType(), intControlObject, intDimension);
                        doubleValue_Source = p_DMXScene_Source.getValue(p_DMXDevice_Source, p_DMXControlComponent_Source.getDMXControlType(), intControlObject, intDimension);
                        if (doubleValue_Source == doubleValue_Dest) continue block9;
                        p_CopyInterface_Dest.setValueCopyDMXScene(doubleValue_Source, p_DMXDevice_Dest, p_DMXScene_Dest, p_DMXControlComponent_Dest.getDMXControlType(), intControlObject, intDimension);
                        boolSomethingCopied = true;
                    }
                }
            }
        }
        if (boolSomethingCopied) {
            p_CopyInterface_Dest.setCopyDMXSceneDone(intCopyEstimated, p_DMXDevice_Dest, p_DMXScene_Dest, p_DMXControlComponent_Dest);
        }
        return intCopyEstimated;
    }

    public static int copyFromDimmer(DMXSceneCopyInterface p_CopyInterface_Dest, DMXDevice p_DMXDevice_Dest, DMXScene p_DMXScene_Dest, DMXDevice p_DMXDevice_Source, DMXScene p_DMXScene_Source) {
        double doubleDimmerValue;
        if (p_CopyInterface_Dest == null) {
            return 3;
        }
        if (p_DMXDevice_Dest == null) {
            return 3;
        }
        if (p_DMXScene_Dest == null) {
            return 3;
        }
        if (p_DMXDevice_Source == null) {
            return 3;
        }
        if (p_DMXScene_Source == null) {
            return 3;
        }
        int intValueCounter = 0;
        int intCopyEstimation = 1;
        DMXControlComponent o_DMXControlComponent_Dest = p_DMXDevice_Dest.getDMXControlComponent_Dimmer();
        if (o_DMXControlComponent_Dest == null) {
            return 3;
        }
        DMXControlComponent o_DMXControlComponent_Source = p_DMXDevice_Source.getDMXControlComponent_Dimmer();
        if (o_DMXControlComponent_Source != null) {
            doubleDimmerValue = p_DMXScene_Source.getValue(p_DMXDevice_Source, o_DMXControlComponent_Source.getDMXControlType(), 0, 0);
        } else {
            intCopyEstimation = 2;
            if (p_DMXDevice_Dest.getDMXControlComponentCountByDescription("rgbcmy") > 0 && p_DMXDevice_Source.getDMXControlComponentCountByDescription("rgbcmy") > 0 || p_DMXDevice_Dest.getDMXControlComponentCountByDescription("coloramber") > 0 || p_DMXDevice_Source.getDMXControlComponentCountByDescription("colorlime") > 0 || p_DMXDevice_Source.getDMXControlComponentCountByDescription("coloruv") > 0 || p_DMXDevice_Source.getDMXControlComponentCountByDescription("colorcyan") > 0 || p_DMXDevice_Source.getDMXControlComponentCountByDescription("colormagenta") > 0 || p_DMXDevice_Source.getDMXControlComponentCountByDescription("coloryellow") > 0 || p_DMXDevice_Source.getDMXControlComponentCountByDescription("colorwhite") > 0 || p_DMXDevice_Source.getDMXControlComponentCountByDescription("colorwhitecold") > 0 || p_DMXDevice_Source.getDMXControlComponentCountByDescription("colorwhitewarm") > 0) {
                doubleDimmerValue = o_DMXControlComponent_Dest.getValueMaximum(0, 0);
            } else if (p_DMXDevice_Source.getDMXControlComponent_Dimmer_Substitutes_Count() <= 0) {
                doubleDimmerValue = 0.0;
            } else {
                doubleDimmerValue = 0.0;
                for (int intDMXControl = 0; intDMXControl < p_DMXDevice_Source.getDMXControlComponent_Dimmer_Substitutes_Count(); ++intDMXControl) {
                    o_DMXControlComponent_Source = p_DMXDevice_Source.getDMXControlComponent_Dimmer_Substitute(intDMXControl);
                    if (o_DMXControlComponent_Source == null) continue;
                    for (int intControlObject = 0; intControlObject < o_DMXControlComponent_Source.getControlObjectCount(); ++intControlObject) {
                        ControlObject o_ControlObject = o_DMXControlComponent_Source.getControlObject(intControlObject);
                        for (int intControlDimension = 0; intControlDimension < o_ControlObject.getControlDimensionCount(); ++intControlDimension) {
                            double doubleValue = p_DMXScene_Source.getValue(p_DMXDevice_Source, o_DMXControlComponent_Source.getDMXControlType(), intControlObject, intControlDimension);
                            if (!(doubleValue >= 0.0)) continue;
                            doubleDimmerValue += doubleValue;
                            ++intValueCounter;
                        }
                    }
                }
                doubleDimmerValue = intValueCounter > 0 ? (doubleDimmerValue /= (double)intValueCounter) : 0.0;
            }
        }
        p_CopyInterface_Dest.setValueCopyDMXScene(doubleDimmerValue, p_DMXDevice_Dest, p_DMXScene_Dest, o_DMXControlComponent_Dest.getDMXControlType(), 0, 0);
        p_CopyInterface_Dest.setCopyDMXSceneDone(intCopyEstimation, p_DMXDevice_Dest, p_DMXScene_Dest, o_DMXControlComponent_Dest);
        return intCopyEstimation;
    }

    public static int copyFromRGB(DMXSceneCopyInterface p_CopyInterface_Dest, DMXDevice p_DMXDevice_Dest, DMXScene p_DMXScene_Dest, DMXDevice p_DMXDevice_Source, DMXScene p_DMXScene_Source) {
        int intColor;
        if (p_CopyInterface_Dest == null) {
            return 3;
        }
        if (p_DMXDevice_Dest == null) {
            return 3;
        }
        if (p_DMXScene_Dest == null) {
            return 3;
        }
        if (p_DMXDevice_Source == null) {
            return 3;
        }
        if (p_DMXScene_Source == null) {
            return 3;
        }
        ArrayList<DMXControlComponent> o_DMXControlComponents_Source = null;
        ArrayList<DMXControlComponent> o_DMXControlComponents_Dest = null;
        double doubleMaxValue = 0.0;
        int intValueCounter = 0;
        boolean boolSourceIsRGBLinked = false;
        int intCopyEstimation = 1;
        if ((o_DMXControlComponents_Dest = p_DMXDevice_Dest.getDMXControlComponentsByDescription("rgbcmy", o_DMXControlComponents_Dest)) == null || o_DMXControlComponents_Dest.size() <= 0) {
            return 3;
        }
        if ((o_DMXControlComponents_Source = p_DMXDevice_Source.getDMXControlComponentsByDescription("rgbcmy", o_DMXControlComponents_Source)) == null || o_DMXControlComponents_Source.size() <= 0) {
            return 3;
        }
        ArrayList<Double> doubleColorValues = new ArrayList<Double>(6);
        for (intColor = 0; intColor < 6; ++intColor) {
            doubleColorValues.add(0.0);
        }
        if (o_DMXControlComponents_Dest.size() != o_DMXControlComponents_Source.size()) {
            double doubleValue;
            int intControlObject;
            int intDMXControl;
            intCopyEstimation = 2;
            intValueCounter = 0;
            boolSourceIsRGBLinked = true;
            for (intDMXControl = 0; intDMXControl < o_DMXControlComponents_Source.size(); ++intDMXControl) {
                DMXControl_RGB o_DMXControlRGB_Source = (DMXControl_RGB)o_DMXControlComponents_Source.get(intDMXControl);
                if (o_DMXControlRGB_Source == null) continue;
                for (intControlObject = 0; intControlObject < o_DMXControlRGB_Source.getControlObjectCount(); ++intControlObject) {
                    ControlObject o_ControlObject_Source = o_DMXControlRGB_Source.getControlObject(intControlObject);
                    if (o_ControlObject_Source == null || !o_DMXControlRGB_Source.getIsLinked(o_DMXControlRGB_Source.getControlType(intControlObject).getControlDimensionType(0))) continue;
                    if (intControlObject >= 3) {
                        boolSourceIsRGBLinked = false;
                    }
                    doubleMaxValue = o_DMXControlRGB_Source.getValueMaximum(intControlObject, 0);
                    doubleValue = p_DMXScene_Source.getValue(p_DMXDevice_Source, o_DMXControlRGB_Source.getDMXControlType(), intControlObject, 0);
                    if (!(doubleValue >= 0.0)) continue;
                    doubleColorValues.set(intControlObject, doubleValue += ((Double)doubleColorValues.get(intControlObject)).doubleValue());
                }
                ++intValueCounter;
            }
            for (intColor = 0; intColor < 6; ++intColor) {
                if (intValueCounter <= 0) {
                    doubleColorValues.set(intColor, 0.0);
                    continue;
                }
                doubleColorValues.set(intColor, (Double)doubleColorValues.get(intColor) / (double)intValueCounter);
            }
            if (intValueCounter > 0 && doubleMaxValue != 0.0) {
                for (intColor = 0; intColor < 3; ++intColor) {
                    if (boolSourceIsRGBLinked) {
                        doubleValue = (Double)doubleColorValues.get(intColor);
                        doubleValue = doubleMaxValue * ((doubleMaxValue - doubleValue) / doubleMaxValue);
                        doubleColorValues.set(intColor + 3, doubleValue);
                        continue;
                    }
                    doubleValue = (Double)doubleColorValues.get(intColor + 3);
                    doubleValue = doubleMaxValue * ((doubleMaxValue - doubleValue) / doubleMaxValue);
                    doubleColorValues.set(intColor, doubleValue);
                }
            }
            for (intDMXControl = 0; intDMXControl < o_DMXControlComponents_Dest.size(); ++intDMXControl) {
                DMXControl_RGB o_DMXControlRGB_Dest = (DMXControl_RGB)o_DMXControlComponents_Dest.get(intDMXControl);
                if (o_DMXControlRGB_Dest == null) continue;
                for (intControlObject = 0; intControlObject < o_DMXControlRGB_Dest.getControlObjectCount(); ++intControlObject) {
                    ControlObject o_ControlObject_Dest = o_DMXControlRGB_Dest.getControlObject(intControlObject);
                    if (o_ControlObject_Dest == null || !o_DMXControlRGB_Dest.getIsLinked(o_DMXControlRGB_Dest.getControlType(intControlObject).getControlDimensionType(0))) continue;
                    doubleValue = (Double)doubleColorValues.get(intControlObject);
                    p_CopyInterface_Dest.setValueCopyDMXScene(doubleValue, p_DMXDevice_Dest, p_DMXScene_Dest, o_DMXControlRGB_Dest.getDMXControlType(), intControlObject, 0);
                }
                p_CopyInterface_Dest.setCopyDMXSceneDone(intCopyEstimation, p_DMXDevice_Dest, p_DMXScene_Dest, o_DMXControlRGB_Dest);
            }
            return intCopyEstimation;
        }
        intCopyEstimation = 1;
        for (int intDMXControl = 0; intDMXControl < o_DMXControlComponents_Dest.size(); ++intDMXControl) {
            DMXControl_RGB o_DMXControlRGB_Dest = (DMXControl_RGB)o_DMXControlComponents_Dest.get(intDMXControl);
            DMXControl_RGB o_DMXControlRGB_Source = (DMXControl_RGB)o_DMXControlComponents_Source.get(intDMXControl);
            if (o_DMXControlRGB_Dest == null || o_DMXControlRGB_Source == null) continue;
            int intIndexStartDest = o_DMXControlRGB_Dest.isRGBControlled() ? 0 : 3;
            int intIndexstartSource = o_DMXControlRGB_Source.isRGBControlled() ? 0 : 3;
            for (int intControlObject = 0; intControlObject < 3; ++intControlObject) {
                ControlObject o_ControlObject_Source;
                ControlObject o_ControlObject_Dest = o_DMXControlRGB_Dest.getControlObject(intIndexStartDest + intControlObject);
                if (o_ControlObject_Dest == null || (o_ControlObject_Source = o_DMXControlRGB_Source.getControlObject(intIndexstartSource + intControlObject)) == null) continue;
                double doubleValue = p_DMXScene_Source.getValue(p_DMXDevice_Source, o_DMXControlRGB_Source.getDMXControlType(), intIndexstartSource + intControlObject, 0);
                doubleMaxValue = o_DMXControlRGB_Source.getValueMaximum(intIndexstartSource + intControlObject, 0);
                if (intIndexStartDest != intIndexstartSource) {
                    doubleValue = doubleMaxValue * ((doubleMaxValue - doubleValue) / doubleMaxValue);
                }
                p_CopyInterface_Dest.setValueCopyDMXScene(doubleValue, p_DMXDevice_Dest, p_DMXScene_Dest, o_DMXControlRGB_Dest.getDMXControlType(), intIndexStartDest + intControlObject, 0);
            }
            p_CopyInterface_Dest.setCopyDMXSceneDone(intCopyEstimation, p_DMXDevice_Dest, p_DMXScene_Dest, o_DMXControlRGB_Dest);
        }
        return intCopyEstimation;
    }

    public static int copyFromPanTilt(DMXSceneCopyInterface p_CopyInterface_Dest, DMXDevice p_DMXDevice_Dest, DMXScene p_DMXScene_Dest, DMXDevice p_DMXDevice_Source, DMXScene p_DMXScene_Source) {
        if (p_CopyInterface_Dest == null) {
            return 3;
        }
        if (p_DMXDevice_Dest == null) {
            return 3;
        }
        if (p_DMXScene_Dest == null) {
            return 3;
        }
        if (p_DMXDevice_Source == null) {
            return 3;
        }
        if (p_DMXScene_Source == null) {
            return 3;
        }
        ArrayList<DMXControlComponent> o_DMXControlComponents_Source = null;
        ArrayList<DMXControlComponent> o_DMXControlComponents_Dest = null;
        int intCopyEstimation = 1;
        if ((o_DMXControlComponents_Dest = p_DMXDevice_Dest.getDMXControlComponentsByDescription("pantilt", o_DMXControlComponents_Dest)) == null || o_DMXControlComponents_Dest.size() <= 0) {
            return 3;
        }
        if ((o_DMXControlComponents_Source = p_DMXDevice_Source.getDMXControlComponentsByDescription("pantilt", o_DMXControlComponents_Source)) == null || o_DMXControlComponents_Source.size() <= 0) {
            return 3;
        }
        if (o_DMXControlComponents_Dest.size() != o_DMXControlComponents_Source.size()) {
            return 3;
        }
        for (int intDMXControl = 0; intDMXControl < o_DMXControlComponents_Dest.size(); ++intDMXControl) {
            double doubleValueY_Dest;
            double doubleValueX_Dest;
            DMXControl_GridPanTilt o_DMXControlPanTilt_Dest = (DMXControl_GridPanTilt)o_DMXControlComponents_Dest.get(intDMXControl);
            DMXControl_GridPanTilt o_DMXControlPanTilt_Source = (DMXControl_GridPanTilt)o_DMXControlComponents_Source.get(intDMXControl);
            if (o_DMXControlPanTilt_Dest == null || o_DMXControlPanTilt_Source == null) continue;
            Point2D o_Point2D_Dest = null;
            double doubleValueX_Source = p_DMXScene_Source.getValue(p_DMXDevice_Source, o_DMXControlPanTilt_Source.getDMXControlType(), 0, DMXControl_GridPanTilt.DIMENSIONINDEX_PAN);
            double doubleValueY_Source = p_DMXScene_Source.getValue(p_DMXDevice_Source, o_DMXControlPanTilt_Source.getDMXControlType(), 0, DMXControl_GridPanTilt.DIMENSIONINDEX_TILT);
            if (p_DMXDevice_Dest != p_DMXDevice_Source) {
                DMXControl_GridPanTilt_DeviceSettings.VirtualPoint o_VirtualPoint = DMXControl_GridPanTilt_DeviceSettings.calculateVirtualPointFromAnglesBilinear(null, p_DMXDevice_Source, doubleValueX_Source, doubleValueY_Source, false);
                if (o_VirtualPoint != null) {
                    o_Point2D_Dest = DMXControl_GridPanTilt_DeviceSettings.calculateAnglesFromVirtualPoint(o_VirtualPoint.getVirtualPoint2D(), p_DMXDevice_Dest, o_VirtualPoint);
                }
                if (o_Point2D_Dest != null) {
                    doubleValueX_Dest = o_Point2D_Dest.getX();
                    doubleValueY_Dest = o_Point2D_Dest.getY();
                } else {
                    intCopyEstimation = 2;
                    doubleValueX_Dest = doubleValueX_Source;
                    doubleValueY_Dest = doubleValueY_Source;
                }
            } else {
                doubleValueX_Dest = doubleValueX_Source;
                doubleValueY_Dest = doubleValueY_Source;
            }
            p_CopyInterface_Dest.setValueCopyDMXScene(doubleValueX_Dest, p_DMXDevice_Dest, p_DMXScene_Dest, o_DMXControlPanTilt_Dest.getDMXControlType(), 0, DMXControl_GridPanTilt.DIMENSIONINDEX_PAN);
            p_CopyInterface_Dest.setValueCopyDMXScene(doubleValueY_Dest, p_DMXDevice_Dest, p_DMXScene_Dest, o_DMXControlPanTilt_Dest.getDMXControlType(), 0, DMXControl_GridPanTilt.DIMENSIONINDEX_TILT);
            p_CopyInterface_Dest.setCopyDMXSceneDone(intCopyEstimation, p_DMXDevice_Dest, p_DMXScene_Dest, o_DMXControlPanTilt_Dest);
        }
        return intCopyEstimation;
    }

    public static DMXSceneTableModel getDMXSceneTableModel() {
        return s_DMXSceneTableModel;
    }

    public static void addDMXScene(DMXScene p_DMXScene) {
        if (p_DMXScene == null) {
            return;
        }
        s_DMXSceneTableModel.addDMXScene(p_DMXScene);
        s_DMXSceneListModel.addDMXScene(p_DMXScene);
        LiveShowDMXCrossTable_DMXDeviceDMXScene.addDMXScene(p_DMXScene);
    }

    public static void removeDMXScene(DMXScene p_DMXScene, boolean p_ProjectClosed) {
        if (p_DMXScene == null) {
            return;
        }
        s_DMXSceneTableModel.removeDMXScene(p_DMXScene);
        s_DMXSceneListModel.removeDMXScene(p_DMXScene);
        LiveShowDMXCrossTable_DMXDeviceDMXScene.removeDMXScene(p_DMXScene);
        p_DMXScene.close();
        if (!p_ProjectClosed) {
            LiveShowDMXVIPAdjustment.calculateAdjustmentAll();
        }
    }

    public static ArrayList<DMXScene> getDMXScenes() {
        ArrayList<DMXScene> o_DMXScenes = s_DMXSceneTableModel.getElementArrayList_Safe();
        return o_DMXScenes;
    }

    public static int getDMXSceneCount() {
        return s_DMXSceneTableModel.size();
    }

    public static DMXScene getDMXScene(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        return s_DMXSceneTableModel.getDMXScene(p_Index);
    }

    public static boolean contains(String p_ID) {
        return s_DMXSceneTableModel.contains(p_ID);
    }

    public static DMXScene getDMXScene(String p_ID) {
        if (p_ID == null) {
            return null;
        }
        Object o_DMXScene = null;
        return s_DMXSceneTableModel.getDMXScene(p_ID);
    }

    public static DMXScene getDMXSceneByName(String p_Name) {
        if (p_Name == null) {
            return null;
        }
        DMXScene o_DMXScene = null;
        int intDMXSceneCount = DMXScene.getDMXSceneCount();
        for (int intDMXScene = 0; intDMXScene < intDMXSceneCount; ++intDMXScene) {
            o_DMXScene = s_DMXSceneTableModel.getDMXScene(intDMXScene);
            if (o_DMXScene == null) continue;
            if (p_Name.equals(o_DMXScene.getName())) break;
            o_DMXScene = null;
        }
        return o_DMXScene;
    }

    public static int indexOf(DMXScene p_DMXScene) {
        if (p_DMXScene == null) {
            return -1;
        }
        return s_DMXSceneTableModel.indexOf(p_DMXScene);
    }

    public static ArrayList<DMXScene> getDMXScenesUsed() {
        ArrayList<DMXScene> o_DMXScenes = new ArrayList<DMXScene>();
        LiveShowDMXVIP o_LiveShowDMXVIP = LiveShowDMXSystem.getLiveShowDMXVIP();
        if (o_LiveShowDMXVIP == null) {
            return o_DMXScenes;
        }
        ArrayList<LiveShowObjectInterface> o_LiveShowObjectInterfaces = o_LiveShowDMXVIP.getLiveShowObjectInterfaces();
        for (int intSceneRow = 0; intSceneRow < s_DMXSceneTableModel.size(); ++intSceneRow) {
            DMXScene o_DMXScene = s_DMXSceneTableModel.getDMXScene(intSceneRow);
            if (o_DMXScene == null || o_DMXScene.getLiveShowDMXObjectCount() <= 0) continue;
            o_DMXScenes.add(o_DMXScene);
        }
        return o_DMXScenes;
    }

    public static ArrayList<DMXScene> getDMXScenesUnused() {
        ArrayList<DMXScene> o_DMXScenes = new ArrayList<DMXScene>();
        LiveShowDMXVIP o_LiveShowDMXVIP = LiveShowDMXSystem.getLiveShowDMXVIP();
        if (o_LiveShowDMXVIP == null) {
            return o_DMXScenes;
        }
        for (int intSceneRow = 0; intSceneRow < s_DMXSceneTableModel.size(); ++intSceneRow) {
            DMXScene o_DMXScene = s_DMXSceneTableModel.getDMXScene(intSceneRow);
            if (o_DMXScene == null || o_DMXScene.getLiveShowDMXObjectCount() > 0) continue;
            o_DMXScenes.add(o_DMXScene);
        }
        return o_DMXScenes;
    }

    public static void clear() {
        int intDMXSceneCount = DMXScene.getDMXSceneCount();
        for (int intDMXScene = intDMXSceneCount - 1; intDMXScene >= 0; --intDMXScene) {
            DMXScene o_DMXScene = s_DMXSceneTableModel.getDMXScene(intDMXScene);
            DMXScene.removeDMXScene(o_DMXScene, true);
        }
    }

    public static void clearUnusedDMXScenes() {
        ArrayList<DMXScene> o_DMXScenes = DMXScene.getDMXScenesUnused();
        for (int intScene = o_DMXScenes.size() - 1; intScene >= 0; --intScene) {
            DMXScene o_DMXScene = o_DMXScenes.get(intScene);
            DMXScene.removeDMXScene(o_DMXScene, false);
        }
    }

    public static int getUnusedDMXScenesCount() {
        int intUnusedCount = 0;
        LiveShowDMXVIP o_LiveShowDMXVIP = LiveShowDMXSystem.getLiveShowDMXVIP();
        if (o_LiveShowDMXVIP == null) {
            return 0;
        }
        for (int intSceneRow = 0; intSceneRow < s_DMXSceneTableModel.size(); ++intSceneRow) {
            DMXScene o_DMXScene = s_DMXSceneTableModel.getDMXScene(intSceneRow);
            if (o_DMXScene == null || o_DMXScene.getLiveShowDMXObjectCount() > 0) continue;
            ++intUnusedCount;
        }
        return intUnusedCount;
    }

    public static boolean saveDMXScenes(LiveShowProjectDescription p_LiveShowProjectDescription, ArrayList<DMXScene> p_DMXScenes) {
        if (p_LiveShowProjectDescription == null) {
            return false;
        }
        String stringFileName = p_LiveShowProjectDescription.getProjectPathName() + FILESUFFIX;
        try {
            File o_File = new File(stringFileName);
            if (o_File.exists()) {
                try {
                    o_File.delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            o_File.createNewFile();
            FileOutputStream o_FileOutputStream = new FileOutputStream(o_File);
            ObjectOutputStream o_ObjectOutput = new ObjectOutputStream(o_FileOutputStream);
            o_ObjectOutput.writeInt(1);
            if (p_DMXScenes == null) {
                int intDMXScenesCount = DMXScene.getDMXSceneCount();
                o_ObjectOutput.writeInt(intDMXScenesCount);
                for (int intScene = 0; intScene < intDMXScenesCount; ++intScene) {
                    DMXScene o_DMXScene = DMXScene.getDMXScene(intScene);
                    if (o_DMXScene == null) continue;
                    o_DMXScene.writeExternal(o_ObjectOutput);
                }
            } else {
                int intDMXScenesCount = p_DMXScenes.size();
                o_ObjectOutput.writeInt(intDMXScenesCount);
                for (int intScene = 0; intScene < intDMXScenesCount; ++intScene) {
                    DMXScene o_DMXScene = p_DMXScenes.get(intScene);
                    if (o_DMXScene == null) continue;
                    o_DMXScene.writeExternal(o_ObjectOutput);
                }
            }
            o_ObjectOutput.close();
            o_FileOutputStream.close();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean deleteDMXScenes(LiveShowProjectDescription p_LiveShowProjectDescription) {
        if (p_LiveShowProjectDescription == null) {
            return false;
        }
        boolean boolSuccess = false;
        String stringFileName = p_LiveShowProjectDescription.getProjectPathName() + FILESUFFIX;
        File o_File = new File(stringFileName);
        if (o_File.exists()) {
            try {
                boolSuccess = o_File.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return boolSuccess;
    }

    public static boolean loadDMXScenes(LiveShowProjectDescription p_LiveShowProjectDescription, LiveShow_ImportDescription p_LiveShow_ImportDescription) {
        if (p_LiveShowProjectDescription == null) {
            return false;
        }
        FileInputStream o_FileInputStream = null;
        ObjectInputStream o_ObjectInput = null;
        String stringFileName = p_LiveShowProjectDescription.getProjectPathName() + FILESUFFIX;
        try {
            File o_File = new File(stringFileName);
            o_FileInputStream = new FileInputStream(o_File);
            o_ObjectInput = new ObjectInputStream(o_FileInputStream);
            int intSoftwareVersion = o_ObjectInput.readInt();
            int intDMXScenesCount = o_ObjectInput.readInt();
            for (int intScene = 0; intScene < intDMXScenesCount; ++intScene) {
                DMXScene o_DMXScene = new DMXScene();
                o_DMXScene.setLiveShow_ImportDescription(p_LiveShow_ImportDescription);
                o_DMXScene.readExternal(o_ObjectInput);
                if (DMXScene.contains(o_DMXScene.getID())) {
                    o_DMXScene.close();
                    continue;
                }
                if (p_LiveShow_ImportDescription == null || p_LiveShow_ImportDescription.getLoadNewProject()) {
                    DMXScene.addDMXScene(o_DMXScene);
                    continue;
                }
                String stringDMXSceneName = o_DMXScene.getName();
                stringDMXSceneName = LiveShow_ImportDescription.createImportedName(stringDMXSceneName);
                o_DMXScene.setName(stringDMXSceneName);
                DMXScene.addDMXScene(o_DMXScene);
            }
            o_ObjectInput.close();
            o_FileInputStream.close();
        }
        catch (Exception e) {
            try {
                if (o_ObjectInput != null) {
                    o_ObjectInput.close();
                }
                if (o_FileInputStream != null) {
                    o_FileInputStream.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
        return true;
    }

    public static DMXSceneListModel getDMXSceneListModel() {
        return s_DMXSceneListModel;
    }

    public static TableAndListModel.ListRenderer getDMXSceneListRenderer() {
        return s_DMXSceneListRenderer;
    }

    public static class DMXScene_Comparator
    implements Comparator<DMXScene> {
        @Override
        public int compare(DMXScene o1, DMXScene o2) {
            if (o1 == null || o2 == null) {
                return 0;
            }
            return o1.getName().compareToIgnoreCase(o2.getName());
        }
    }

    public static class DMXSceneTableModel
    extends TableAndListModel<DMXScene>
    implements PropertyChangeListener {
        public static final int COLUMNCOUNT = 2;
        public static final int COLUMNINDEX_SCENENAME = 0;
        public static final int COLUMNINDEX_SCENEDESCRIPTION = 1;
        @LiveLanguageString
        public static String COLUMN_SCENENAME = "Name";
        @LiveLanguageString
        public static String COLUMN_SCENEDESCRIPTION = "Description";
        private final Object m_SyncObject = new Object();

        public DMXSceneTableModel() {
            super(false);
            this.initMembers();
            LiveLanguage.addLanguageListener((Object)this, null);
        }

        private void initMembers() {
        }

        public void finishJTable(JTable p_JTable) {
            TableAndListModel.TableCellEditorRenderer_String o_TableCellEditorRenderer_String;
            if (p_JTable == null) {
                return;
            }
            TableRowSorter<DMXSceneTableModel> o_TableRowSorter = new TableRowSorter<DMXSceneTableModel>(this);
            o_TableRowSorter.setComparator(0, TableAndListModel.getStringComparator_Normal());
            o_TableRowSorter.setComparator(1, TableAndListModel.getStringComparator_Normal());
            DMXSceneFilter.DMXSceneRowFilter o_TableRowFilter = new DMXSceneFilter.DMXSceneRowFilter(s_DMXSceneTableModel);
            super.finishJTable(p_JTable, o_TableRowSorter, o_TableRowFilter);
            TableColumnModel o_TableColumnModel = p_JTable.getColumnModel();
            TableColumn o_TableColumn = o_TableColumnModel.getColumn(0);
            if (o_TableColumn != null) {
                o_TableCellEditorRenderer_String = new TableAndListModel.TableCellEditorRenderer_String();
                o_TableCellEditorRenderer_String.setIcon(s_Icon);
                o_TableCellEditorRenderer_String.setHorizontalAlignment(10);
                o_TableCellEditorRenderer_String.setToolTipText_Automatic(2);
                o_TableCellEditorRenderer_String.setToolTipTextAt(false, true);
                o_TableColumn.setCellEditor(o_TableCellEditorRenderer_String);
                o_TableColumn.setCellRenderer(o_TableCellEditorRenderer_String);
            }
            if ((o_TableColumn = o_TableColumnModel.getColumn(1)) != null) {
                o_TableCellEditorRenderer_String = new TableAndListModel.TableCellEditorRenderer_String();
                o_TableCellEditorRenderer_String.setToolTipText_Automatic(2);
                o_TableCellEditorRenderer_String.setHorizontalAlignment(10);
                o_TableCellEditorRenderer_String.setToolTipTextAt(false, true);
                o_TableColumn.setCellEditor(o_TableCellEditorRenderer_String);
                o_TableColumn.setCellRenderer(o_TableCellEditorRenderer_String);
            }
            p_JTable.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        }

        @Override
        public boolean contains(String p_ID) {
            if (p_ID == null) {
                return false;
            }
            DMXScene o_DMXScene = this.getDMXScene(p_ID);
            return o_DMXScene != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DMXScene getDMXScene(String p_ID) {
            Object object = this.m_SyncObject;
            synchronized (object) {
                for (int intDMXScene = 0; intDMXScene < this.size(); ++intDMXScene) {
                    DMXScene o_DMXScene = (DMXScene)this.get(intDMXScene);
                    if (o_DMXScene == null || !p_ID.equals(o_DMXScene.getID())) continue;
                    return o_DMXScene;
                }
            }
            return null;
        }

        public void addDMXScene(DMXScene p_DMXScene) {
            if (p_DMXScene == null) {
                return;
            }
            if (this.add(p_DMXScene)) {
                p_DMXScene.addPropertyChangeListener(this);
            }
        }

        public void removeDMXScene(DMXScene p_DMXScene) {
            if (p_DMXScene == null) {
                return;
            }
            if (this.remove(p_DMXScene)) {
                p_DMXScene.removePropertyChangeListener(this);
            }
        }

        public void addSelectedDMXScene(JTable p_JTable, DMXScene p_DMXScene) {
            if (p_JTable == null) {
                return;
            }
            if (p_DMXScene == null) {
                return;
            }
            super.addSelectedElement(p_JTable, p_DMXScene);
        }

        public void removeSelectedDMXScene(JTable p_JTable, DMXScene p_DMXScene) {
            if (p_JTable == null) {
                return;
            }
            if (p_DMXScene == null) {
                return;
            }
            super.removeSelectedElement(p_JTable, p_DMXScene);
        }

        public DMXScene getDMXScene(int p_Index) {
            if (p_Index < 0) {
                return null;
            }
            return (DMXScene)super.get(p_Index);
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return COLUMN_SCENENAME;
                }
                case 1: {
                    return COLUMN_SCENEDESCRIPTION;
                }
            }
            return "";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getValue(DMXScene p_DMXScene, int columnIndex) {
            String stringValue = "";
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (p_DMXScene == null) {
                    return stringValue;
                }
                switch (columnIndex) {
                    case 0: {
                        stringValue = p_DMXScene.getName();
                        break;
                    }
                    case 1: {
                        stringValue = p_DMXScene.getRemark();
                    }
                }
                return stringValue;
            }
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            switch (col) {
                case 0: {
                    return true;
                }
                case 1: {
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setValue(DMXScene p_DMXScene, Object value, int col) {
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (p_DMXScene == null) {
                    return;
                }
            }
            switch (col) {
                case 0: {
                    String stringValue = (String)value;
                    p_DMXScene.setName(stringValue);
                    break;
                }
                case 1: {
                    String stringValue = (String)value;
                    p_DMXScene.setRemark(stringValue);
                }
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() instanceof DMXScene) {
                DMXScene o_DMXScene = (DMXScene)evt.getSource();
                if (DMXScene.PROP_DMXSCENE_NAME.equals(evt.getPropertyName())) {
                    this.changedElement(o_DMXScene);
                } else if (DMXScene.PROP_DMXSCENE_REMARK.equals(evt.getPropertyName())) {
                    this.changedElement(o_DMXScene);
                } else if ("liveShowObject_SourceClose".equals(evt.getPropertyName())) {
                    this.removeDMXScene(o_DMXScene);
                }
            }
        }
    }

    public static class DMXSceneListModel
    extends TableAndListModel.ListModel<DMXScene>
    implements PropertyChangeListener {
        public DMXSceneListModel() {
            super(false, true);
            super.setGetSortStringMethod(DMXScene.class, "getName", true);
        }

        public void addDMXScene(DMXScene p_DMXScene) {
            if (p_DMXScene == null) {
                return;
            }
            this.add(p_DMXScene);
        }

        public void removeDMXScene(DMXScene p_DMXScene) {
            if (p_DMXScene == null) {
                return;
            }
            this.remove(p_DMXScene);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() instanceof DMXScene) {
                DMXScene o_DMXScene = (DMXScene)evt.getSource();
                if (DMXScene.PROP_DMXSCENE_NAME.equals(evt.getPropertyName())) {
                    this.changedElement(o_DMXScene);
                } else if (DMXScene.PROP_DMXSCENE_REMARK.equals(evt.getPropertyName())) {
                    this.changedElement(o_DMXScene);
                } else if ("liveShowObject_SourceClose".equals(evt.getPropertyName())) {
                    this.removeDMXScene(o_DMXScene);
                }
            }
        }
    }

    public static class DMXSceneDeviceSectorValues
    implements Externalizable {
        public static final int SOFTWAREVERSION = 1;
        private DMXDevice.InternalSector m_DMXDeviceInternalSector;
        private DMXSceneDeviceValues m_DMXSceneDeviceValues;
        private ArrayList<Double> m_SectorValues;
        private ArrayList<Boolean> m_SectorValueManuallySet;
        private ArrayList<Double> m_SectorFadeValues;
        private ArrayList<Integer> m_DeviceInternalChannels;
        private final Object m_SyncObject = new Object();

        public DMXSceneDeviceSectorValues(DMXSceneDeviceValues p_DMXSceneDeviceValues) {
            this.m_DMXSceneDeviceValues = p_DMXSceneDeviceValues;
            this.initMembers();
        }

        private void initMembers() {
            this.m_DMXDeviceInternalSector = null;
            this.m_SectorValues = new ArrayList();
            this.m_SectorValueManuallySet = new ArrayList();
            this.m_SectorFadeValues = new ArrayList();
            this.m_DeviceInternalChannels = new ArrayList();
        }

        public void close() {
            if (this.m_DMXDeviceInternalSector != null) {
                this.m_DMXDeviceInternalSector = null;
            }
            if (this.m_DMXSceneDeviceValues != null) {
                this.m_DMXSceneDeviceValues.removeDMXSceneDeviceSectorValues(this);
                this.m_DMXSceneDeviceValues = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(1);
            if (this.m_DMXDeviceInternalSector == null) {
                out.writeInt(-1);
                return;
            }
            out.writeInt(this.m_DMXDeviceInternalSector.getDMXDeviceSectorIndex());
            Object object = this.m_SyncObject;
            synchronized (object) {
                int intValuesCount = this.m_SectorValues.size();
                out.writeInt(intValuesCount);
                for (int intValue = 0; intValue < intValuesCount; ++intValue) {
                    out.writeInt((int)(this.m_SectorValues.get(intValue) + 0.5));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int intSoftwareVersion = in.readInt();
            int intSectorIndex = in.readInt();
            if (intSectorIndex < 0) {
                return;
            }
            int intValuesCount = in.readInt();
            for (int intChannel = 0; intChannel < intValuesCount; ++intChannel) {
                int intValue = in.readInt();
                Object object = this.m_SyncObject;
                synchronized (object) {
                    if (intChannel >= this.m_SectorValues.size()) {
                        continue;
                    }
                    this.m_SectorValues.set(intChannel, Double.valueOf(intValue));
                    this.m_SectorFadeValues.set(intChannel, 0.0);
                    continue;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clone(DMXSceneDeviceSectorValues p_DMXSceneDeviceSectorValues) {
            Object object = this.m_SyncObject;
            synchronized (object) {
                int intValuesCount = this.m_SectorValues.size();
                for (int intValue = 0; intValue < intValuesCount; ++intValue) {
                    p_DMXSceneDeviceSectorValues.setDeviceValue(intValue, this.m_SectorValues.get(intValue));
                    p_DMXSceneDeviceSectorValues.setFadeValue(intValue, this.m_SectorFadeValues.get(intValue));
                }
            }
        }

        public long getDiskSpaceEstimated() {
            long longBytesCount = 0L;
            longBytesCount += 4L;
            longBytesCount += 4L;
            longBytesCount += 4L;
            int intValuesCount = this.m_SectorValues.size();
            return longBytesCount += (long)(intValuesCount * 4);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setDMXDeviceInternalSector(DMXDevice.InternalSector p_DMXDeviceInternalSector) {
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (this.m_DMXDeviceInternalSector != null && p_DMXDeviceInternalSector != null) {
                    this.m_DMXDeviceInternalSector = p_DMXDeviceInternalSector;
                    if (this.m_SectorValues.size() > this.m_DMXDeviceInternalSector.getInternalChannelCount()) {
                        for (int intChannel = this.m_SectorValues.size() - 1; intChannel >= this.m_DMXDeviceInternalSector.getInternalChannelCount(); --intChannel) {
                            this.m_SectorValues.remove(intChannel);
                            this.m_SectorValueManuallySet.remove(intChannel);
                            this.m_SectorFadeValues.remove(intChannel);
                            this.m_DeviceInternalChannels.remove(intChannel);
                        }
                    } else if (this.m_SectorValues.size() < this.m_DMXDeviceInternalSector.getInternalChannelCount()) {
                        for (int intChannel = this.m_SectorValues.size(); intChannel < this.m_DMXDeviceInternalSector.getInternalChannelCount(); ++intChannel) {
                            this.m_SectorValues.add(0.0);
                            this.m_SectorValueManuallySet.add(false);
                            this.m_SectorFadeValues.add(0.0);
                            this.m_DeviceInternalChannels.add(intChannel);
                        }
                    }
                    return;
                }
                if (this.m_DMXDeviceInternalSector != null) {
                    this.m_SectorValues.clear();
                    this.m_SectorValueManuallySet.clear();
                    this.m_SectorFadeValues.clear();
                    this.m_DeviceInternalChannels.clear();
                }
                this.m_DMXDeviceInternalSector = p_DMXDeviceInternalSector;
                if (this.m_DMXDeviceInternalSector != null) {
                    int intChannelCount = this.m_DMXDeviceInternalSector.getInternalChannelCount();
                    for (int intChannel = 0; intChannel < intChannelCount; ++intChannel) {
                        this.m_DeviceInternalChannels.add(intChannel);
                        this.m_SectorValues.add(0.0);
                        this.m_SectorValueManuallySet.add(false);
                        this.m_SectorFadeValues.add(0.0);
                    }
                }
            }
        }

        public DMXSceneDeviceValues getDMXSceneDeviceValues() {
            return this.m_DMXSceneDeviceValues;
        }

        public int getFlagMixSource() {
            DMXSceneDeviceValues o_DMXSceneDeviceValues = this.m_DMXSceneDeviceValues;
            if (o_DMXSceneDeviceValues == null) {
                return -1;
            }
            return o_DMXSceneDeviceValues.getFlagMixSource();
        }

        public DMXDevice.InternalSector getDMXDeviceInternalSector() {
            return this.m_DMXDeviceInternalSector;
        }

        public ArrayList<Integer> getDeviceInternalChannels() {
            return this.m_DeviceInternalChannels;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void saveDMXDeviceDefaultValues(DMXDevice p_DMXDevice) {
            if (p_DMXDevice == null) {
                return;
            }
            if (this.m_DMXDeviceInternalSector == null) {
                return;
            }
            int intInternalSectorIndex = this.m_DMXDeviceInternalSector.getDMXDeviceSectorIndex();
            DMXDevice.InternalSector o_InternalSector = p_DMXDevice.getInternalSector(intInternalSectorIndex);
            DMXDeviceType o_DMXDeviceType = p_DMXDevice.getDMXDeviceType();
            if (o_DMXDeviceType == null) {
                return;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                for (int intDMXControl = 0; intDMXControl < o_DMXDeviceType.getDMXControlTypeCount(); ++intDMXControl) {
                    DMXControlComponent.DMXControlType o_DMXControlType = o_DMXDeviceType.getDMXControlType(intDMXControl);
                    if (o_DMXControlType == null) continue;
                    for (int intControl = 0; intControl < o_DMXControlType.getControlTypeCount(); ++intControl) {
                        DMXControlComponent.ControlType o_ControlType = o_DMXControlType.getControlType(intControl);
                        if (o_ControlType == null) continue;
                        for (int intDimension = 0; intDimension < o_ControlType.getControlDimensionTypeCount(); ++intDimension) {
                            DMXControlComponent.ControlDimensionType o_ControlDimensionType = o_ControlType.getControlDimensionType(intDimension);
                            if (o_ControlDimensionType == null) continue;
                            int intDefaultValue = o_ControlDimensionType.getDefaultValue();
                            for (int intLink = 0; intLink < o_ControlDimensionType.getDeviceControlLinkCount(); ++intLink) {
                                DMXControlComponent.DeviceControlLink o_DeviceControlLink = o_ControlDimensionType.getDeviceControlLink(intLink);
                                if (o_DeviceControlLink == null || o_DeviceControlLink.getDMXDeviceSectorIndex() != intInternalSectorIndex) continue;
                                o_DeviceControlLink.setValueScene((double)intDefaultValue, this);
                                o_DeviceControlLink.setValueSetManually(this, true);
                            }
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void saveDMXDeviceValues_EditMode(DMXDevice p_DMXDevice) {
            if (this.m_DMXDeviceInternalSector == null) {
                return;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                int intDeviceSectorIndex = this.m_DMXDeviceInternalSector.getDMXDeviceSectorIndex();
                DMXDevice.InternalSector o_InternalSector = p_DMXDevice.getInternalSector(intDeviceSectorIndex);
                int intChannelCount = o_InternalSector.getInternalChannelCount();
                for (int intChannel = 0; intChannel < intChannelCount; ++intChannel) {
                    DMXDevice.InternalChannel o_InternalChannel = o_InternalSector.getInternalChannel(intChannel);
                    int intValue = o_InternalChannel == null ? 0 : o_InternalChannel.getValue_EditMode();
                    this.m_SectorValues.set(intChannel, Double.valueOf(intValue));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void saveDMXDeviceValues(DMXDevice p_DMXDevice) {
            if (this.m_DMXDeviceInternalSector == null) {
                return;
            }
            int intDeviceSectorIndex = this.m_DMXDeviceInternalSector.getDMXDeviceSectorIndex();
            DMXDevice.InternalSector o_InternalSector = p_DMXDevice.getInternalSector(intDeviceSectorIndex);
            int intChannelCount = o_InternalSector.getInternalChannelCount();
            Object object = this.m_SyncObject;
            synchronized (object) {
                for (int intChannel = 0; intChannel < intChannelCount; ++intChannel) {
                    DMXDevice.InternalChannel o_InternalChannel = o_InternalSector.getInternalChannel(intChannel);
                    int intValue = o_InternalChannel == null ? 0 : o_InternalChannel.getValue();
                    if (intChannel < 0 || intChannel >= this.m_SectorValues.size()) continue;
                    this.m_SectorValues.set(intChannel, Double.valueOf(intValue));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cleanUpDMXDeviceValues(DMXDevice p_DMXDevice) {
            if (this.m_DMXDeviceInternalSector == null) {
                return;
            }
            int intDeviceSectorIndex = this.m_DMXDeviceInternalSector.getDMXDeviceSectorIndex();
            DMXDevice.InternalSector o_InternalSector = p_DMXDevice.getInternalSector(intDeviceSectorIndex);
            int intChannelCount = o_InternalSector.getInternalChannelCount();
            Object object = this.m_SyncObject;
            synchronized (object) {
                for (int intChannel = 0; intChannel < intChannelCount; ++intChannel) {
                    DMXDevice.InternalChannel o_InternalChannel = o_InternalSector.getInternalChannel(intChannel);
                    boolean intValue = false;
                    if (intChannel < 0 || intChannel >= this.m_SectorValues.size()) continue;
                    this.m_SectorValues.set(intChannel, (double)intValue);
                }
            }
        }

        public int getDeviceValuesCount() {
            return this.m_SectorValues.size();
        }

        public ArrayList<Double> getDeviceValues() {
            return this.m_SectorValues;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Double getDeviceValue(int p_InternalChannelIndex) {
            if (p_InternalChannelIndex < 0) {
                return null;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (p_InternalChannelIndex >= this.m_SectorValues.size()) {
                    return 0.0;
                }
                return this.m_SectorValues.get(p_InternalChannelIndex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean setDeviceValue(int p_InternalChannelIndex, double p_Value) {
            if (p_InternalChannelIndex < 0) {
                return false;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (p_InternalChannelIndex >= this.m_SectorValues.size()) {
                    return false;
                }
                this.m_SectorValues.set(p_InternalChannelIndex, p_Value);
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean setDeviceValueSetManually(int p_InternalChannelIndex, boolean p_SetManually) {
            if (p_InternalChannelIndex < 0) {
                return false;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (p_InternalChannelIndex >= this.m_SectorValueManuallySet.size()) {
                    return false;
                }
                this.m_SectorValueManuallySet.set(p_InternalChannelIndex, p_SetManually);
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean getDeviceValueSetManually(int p_InternalChannelIndex) {
            if (p_InternalChannelIndex < 0) {
                return false;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (p_InternalChannelIndex >= this.m_SectorValues.size()) {
                    return false;
                }
                return this.m_SectorValueManuallySet.get(p_InternalChannelIndex);
            }
        }

        public ArrayList<Double> getFadeValues() {
            return this.m_SectorFadeValues;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Double getFadeValue(int p_InternalChannelIndex) {
            if (p_InternalChannelIndex < 0) {
                return null;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (p_InternalChannelIndex >= this.m_SectorFadeValues.size()) {
                    return 0.0;
                }
                return this.m_SectorFadeValues.get(p_InternalChannelIndex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean setFadeValue(int p_InternalChannelIndex, double p_Value) {
            if (p_InternalChannelIndex < 0) {
                return false;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (p_InternalChannelIndex >= this.m_SectorFadeValues.size()) {
                    return false;
                }
                this.m_SectorFadeValues.set(p_InternalChannelIndex, p_Value);
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void copyValuesNewFromChannels() {
            if (this.m_DMXDeviceInternalSector == null) {
                return;
            }
            for (int intInternalChannel = 0; intInternalChannel < this.m_DeviceInternalChannels.size(); ++intInternalChannel) {
                DMXDevice.InternalChannel o_InternalChannel = this.m_DMXDeviceInternalSector.getInternalChannel(this.m_DeviceInternalChannels.get(intInternalChannel));
                if (o_InternalChannel == null) continue;
                Object object = this.m_SyncObject;
                synchronized (object) {
                    if (intInternalChannel < 0 || intInternalChannel >= this.m_SectorValues.size()) {
                        continue;
                    }
                    this.m_SectorValues.set(intInternalChannel, Double.valueOf(o_InternalChannel.getValue()));
                    continue;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setValuesToNull() {
            Object object = this.m_SyncObject;
            synchronized (object) {
                for (int intInternalChannel = 0; intInternalChannel < this.m_SectorValues.size(); ++intInternalChannel) {
                    this.m_SectorValues.set(intInternalChannel, 0.0);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void copyValuesFrom(DMXSceneDeviceSectorValues p_DMXSceneDeviceSectorValues) {
            if (p_DMXSceneDeviceSectorValues == null) {
                return;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                for (int intInternalChannel = 0; intInternalChannel < this.m_SectorValues.size() && intInternalChannel < p_DMXSceneDeviceSectorValues.getDeviceValuesCount(); ++intInternalChannel) {
                    this.m_SectorValues.set(intInternalChannel, p_DMXSceneDeviceSectorValues.getDeviceValue(intInternalChannel));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeDMXSceneToChannels_EditMode(DMXDevice p_DMXDevice) {
            if (p_DMXDevice == null) {
                return;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (this.m_DMXDeviceInternalSector == null) {
                    return;
                }
                p_DMXDevice.setValues(this.m_DMXDeviceInternalSector.getDMXDeviceSectorIndex(), this.m_DeviceInternalChannels, this.m_SectorValues, false, true, true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeDMXSceneToChannels(DMXDevice p_DMXDevice, boolean p_ManuallySet) {
            if (p_DMXDevice == null) {
                return;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (this.m_DMXDeviceInternalSector == null) {
                    return;
                }
                p_DMXDevice.setValues(this.m_DMXDeviceInternalSector.getDMXDeviceSectorIndex(), this.m_DeviceInternalChannels, this.m_SectorValues, false, p_ManuallySet, false);
            }
        }
    }

    public static class DMXSceneDeviceValues
    implements Externalizable {
        public static final int SOFTWAREVERSION = 2;
        private DMXDevice m_DMXDevice;
        private DMXSceneValueContainer m_DMXSceneValueContainer;
        private ArrayList<DMXSceneDeviceSectorValues> m_DMXSceneDeviceSectorValueses;
        private DMXControl_GridPanTilt_DeviceSettings.VirtualPoint m_VirtualPoint_PanTilt;
        private DMXControl_GridPanTilt_DeviceSettings.VirtualPoint_Path_DMXDevice m_VirtualPoint_Path_DMXDevice;
        private Point2D m_Point2D_Angles_Filled;
        private int m_FlagMixSource;
        private boolean m_OverwriteManualValues;
        private double m_FadeProgress;
        private boolean m_FadeIn;
        private boolean m_FadeOut;
        private boolean m_FadeInBlackout;
        private HashMap<LiveShowDMXObject, Boolean> m_DimmerOff_Objects;
        private HashMap<LiveShowDMXObject, Boolean> m_DisabledCancelled_Objects;
        private HashMap<DMXControlComponent.DMXControlType, Boolean> m_OverwriteManualDMXEffect;
        private final Object m_SyncObject = new Object();
        private static DMXControl_GridPanTilt_DeviceSettings.VirtualPoint s_VirtualPoint_Timeline = new DMXControl_GridPanTilt_DeviceSettings.VirtualPoint();
        private static DMXControl_GridPanTilt_DeviceSettings.VirtualPoint s_VirtualPoint_Jingle = new DMXControl_GridPanTilt_DeviceSettings.VirtualPoint();

        public DMXSceneDeviceValues(DMXSceneValueContainer p_DMXSceneValueContainer) {
            this.m_DMXSceneValueContainer = p_DMXSceneValueContainer;
            this.initMembers();
            if (this.m_DMXSceneValueContainer != null) {
                this.m_FlagMixSource = this.m_DMXSceneValueContainer.getFlagMixSource();
            }
        }

        private void initMembers() {
            this.m_DMXDevice = null;
            this.m_DMXSceneDeviceSectorValueses = new ArrayList();
            this.m_FlagMixSource = -1;
            this.m_OverwriteManualValues = true;
            this.m_FadeProgress = 0.0;
            this.m_DimmerOff_Objects = new HashMap();
            this.m_DisabledCancelled_Objects = new HashMap();
            this.m_OverwriteManualDMXEffect = new HashMap();
            this.m_VirtualPoint_PanTilt = null;
            this.m_Point2D_Angles_Filled = new Point2D.Double();
            this.m_FadeIn = false;
            this.m_FadeOut = false;
            this.m_FadeInBlackout = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(2);
            if (this.m_DMXDevice == null) {
                out.writeUTF("null");
                return;
            }
            out.writeUTF(this.m_DMXDevice.getID());
            Object object = this.m_SyncObject;
            synchronized (object) {
                int intSectorCount = this.m_DMXSceneDeviceSectorValueses.size();
                out.writeInt(intSectorCount);
                for (int intSector = 0; intSector < intSectorCount; ++intSector) {
                    DMXSceneDeviceSectorValues o_DMXSceneDeviceSectorValues = this.m_DMXSceneDeviceSectorValueses.get(intSector);
                    o_DMXSceneDeviceSectorValues.writeExternal(out);
                }
            }
            int intAdditionalCount = 0;
            DMXControl_GridPanTilt o_DMXControl_GridPanTilt = (DMXControl_GridPanTilt)this.m_DMXDevice.getDMXControlComponentByDescriptionFirst("pantilt");
            if (o_DMXControl_GridPanTilt != null) {
                ++intAdditionalCount;
            }
            out.writeInt(intAdditionalCount);
            if (o_DMXControl_GridPanTilt != null) {
                if (this.m_VirtualPoint_PanTilt == null) {
                    out.writeUTF(DMXControlDescription.ID_UNDEFINED);
                } else {
                    out.writeUTF("pantilt");
                    this.m_VirtualPoint_PanTilt.writeExternal(out);
                }
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            DMXDevice o_DMXDevice;
            int intSoftwareVersion = in.readInt();
            String stringDMXDeviceID = in.readUTF();
            if ("null".equals(stringDMXDeviceID)) {
                return;
            }
            if ("TEST".equals(stringDMXDeviceID)) {
                o_DMXDevice = null;
            } else {
                LiveShow_ImportDescription o_LiveShow_ImportDescription;
                DMXScene o_DMXScene;
                o_DMXDevice = DMXDevice.getDMXDevice(stringDMXDeviceID);
                if (o_DMXDevice == null && this.m_DMXSceneValueContainer != null && (o_DMXScene = this.m_DMXSceneValueContainer.getDMXScene()) != null && (o_LiveShow_ImportDescription = o_DMXScene.getLiveShow_ImportDescription()) != null) {
                    stringDMXDeviceID = o_LiveShow_ImportDescription.getDMXDeviceIDReplacement(stringDMXDeviceID);
                    o_DMXDevice = DMXDevice.getDMXDevice(stringDMXDeviceID);
                }
            }
            if (o_DMXDevice != null) {
                this.setDMXDevice(o_DMXDevice);
            }
            int intSectorCount = in.readInt();
            for (int intSector = 0; intSector < intSectorCount; ++intSector) {
                DMXSceneDeviceSectorValues o_DMXSceneDeviceSectorValues = this.getDMXSceneDeviceSectorValues(intSector);
                if (o_DMXSceneDeviceSectorValues == null) {
                    o_DMXSceneDeviceSectorValues = new DMXSceneDeviceSectorValues(this);
                    this.m_DMXSceneDeviceSectorValueses.add(o_DMXSceneDeviceSectorValues);
                }
                o_DMXSceneDeviceSectorValues.readExternal(in);
            }
            int intAdditionalCount = 0;
            this.m_VirtualPoint_PanTilt = null;
            if (intSoftwareVersion < 2) {
                this.setPanTilt_VirtualPointFromAngles();
            }
            if (intSoftwareVersion >= 2) {
                intAdditionalCount = in.readInt();
            }
            for (int intAddition = 0; intAddition < intAdditionalCount; ++intAddition) {
                String stringAddtionalID = in.readUTF();
                if (!"pantilt".equals(stringAddtionalID)) continue;
                this.m_VirtualPoint_PanTilt = new DMXControl_GridPanTilt_DeviceSettings.VirtualPoint();
                this.m_VirtualPoint_PanTilt.readExternal(in);
                this.setPanTilt_AnglesFromVirtualPoint(this.m_VirtualPoint_PanTilt);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clone(DMXSceneDeviceValues p_DMXSceneDeviceValues) {
            if (p_DMXSceneDeviceValues == null) {
                return;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                int intSectorCount = this.m_DMXSceneDeviceSectorValueses.size();
                for (int intSector = 0; intSector < intSectorCount; ++intSector) {
                    DMXSceneDeviceSectorValues o_DMXSceneDeviceSectorValues = this.getDMXSceneDeviceSectorValues(intSector);
                    DMXSceneDeviceSectorValues o_DestDMXSceneDeviceSectorValues = p_DMXSceneDeviceValues.getDMXSceneDeviceSectorValues(intSector);
                    if (o_DMXSceneDeviceSectorValues == null || o_DestDMXSceneDeviceSectorValues == null) continue;
                    o_DMXSceneDeviceSectorValues.clone(o_DestDMXSceneDeviceSectorValues);
                }
                DMXControl_GridPanTilt_DeviceSettings.VirtualPoint o_VirtualPoint = p_DMXSceneDeviceValues.getVirtualPoint_PanTilt();
                if (this.m_VirtualPoint_PanTilt != null) {
                    if (o_VirtualPoint == null) {
                        o_VirtualPoint = new DMXControl_GridPanTilt_DeviceSettings.VirtualPoint();
                        p_DMXSceneDeviceValues.setVirtualPoint_PanTilt(o_VirtualPoint);
                    }
                    this.m_VirtualPoint_PanTilt.clone(o_VirtualPoint);
                }
                this.m_FadeIn = p_DMXSceneDeviceValues.getFadeIn();
                this.m_FadeIn = p_DMXSceneDeviceValues.getFadeOut();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long getDiskSpaceEstimated() {
            long longExportBytesCount = 0L;
            Object object = this.m_SyncObject;
            synchronized (object) {
                int intSectorCount = this.m_DMXSceneDeviceSectorValueses.size();
                longExportBytesCount += 4L;
                longExportBytesCount += 36L;
                longExportBytesCount += 4L;
                for (int intSector = 0; intSector < intSectorCount; ++intSector) {
                    DMXSceneDeviceSectorValues o_DMXSceneDeviceSectorValues = this.m_DMXSceneDeviceSectorValueses.get(intSector);
                    longExportBytesCount += o_DMXSceneDeviceSectorValues.getDiskSpaceEstimated();
                }
            }
            return longExportBytesCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            this.m_DimmerOff_Objects.clear();
            this.m_DisabledCancelled_Objects.clear();
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (this.m_DMXSceneDeviceSectorValueses != null) {
                    for (int intSector = this.m_DMXSceneDeviceSectorValueses.size() - 1; intSector >= 0; --intSector) {
                        DMXSceneDeviceSectorValues o_DMXSceneDeviceSectorValues = this.m_DMXSceneDeviceSectorValueses.get(intSector);
                        if (o_DMXSceneDeviceSectorValues == null) continue;
                        o_DMXSceneDeviceSectorValues.close();
                    }
                }
                if (this.m_VirtualPoint_Path_DMXDevice != null) {
                    this.m_VirtualPoint_Path_DMXDevice.close();
                    this.m_VirtualPoint_Path_DMXDevice = null;
                }
            }
            if (this.m_DMXDevice != null) {
                this.m_DMXDevice = null;
            }
            this.m_OverwriteManualDMXEffect.clear();
        }

        public DMXSceneValueContainer getDMXSceneValueContainer() {
            return this.m_DMXSceneValueContainer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setDMXDevice(DMXDevice p_DMXDevice) {
            DMXControlComponent o_DMXControlComponent;
            DMXSceneDeviceSectorValues o_DMXSceneDeviceSectorValues;
            int intSector;
            if (p_DMXDevice == null) {
                return;
            }
            if (this.m_DMXDevice == p_DMXDevice) {
                DMXDeviceType o_DMXDeviceType = this.m_DMXDevice.getDMXDeviceType();
                if (o_DMXDeviceType == null) {
                    return;
                }
                Object object = this.m_SyncObject;
                synchronized (object) {
                    DMXSceneDeviceSectorValues o_DMXSceneDeviceSectorValues2;
                    int intSector2;
                    if (this.m_DMXSceneDeviceSectorValueses.size() > o_DMXDeviceType.getDMXDeviceSectorCount()) {
                        for (intSector2 = this.m_DMXSceneDeviceSectorValueses.size() - 1; intSector2 >= o_DMXDeviceType.getDMXDeviceSectorCount(); --intSector2) {
                            o_DMXSceneDeviceSectorValues2 = this.m_DMXSceneDeviceSectorValueses.get(intSector2);
                            if (o_DMXSceneDeviceSectorValues2 == null) continue;
                            o_DMXSceneDeviceSectorValues2.close();
                            this.removeDMXSceneDeviceSectorValues(o_DMXSceneDeviceSectorValues2);
                        }
                    } else if (this.m_DMXSceneDeviceSectorValueses.size() < o_DMXDeviceType.getDMXDeviceSectorCount()) {
                        for (intSector2 = this.m_DMXSceneDeviceSectorValueses.size(); intSector2 < o_DMXDeviceType.getDMXDeviceSectorCount(); ++intSector2) {
                            o_DMXSceneDeviceSectorValues2 = new DMXSceneDeviceSectorValues(this);
                            this.addDMXSceneDeviceSectorValues(o_DMXSceneDeviceSectorValues2);
                        }
                    }
                    for (intSector2 = 0; intSector2 < this.m_DMXSceneDeviceSectorValueses.size(); ++intSector2) {
                        o_DMXSceneDeviceSectorValues2 = this.m_DMXSceneDeviceSectorValueses.get(intSector2);
                        if (o_DMXSceneDeviceSectorValues2 == null) continue;
                        o_DMXSceneDeviceSectorValues2.setDMXDeviceInternalSector(this.m_DMXDevice.getInternalSector(intSector2));
                    }
                }
                return;
            }
            if (this.m_DMXDevice != null) {
                Object object = this.m_SyncObject;
                synchronized (object) {
                    for (intSector = this.m_DMXSceneDeviceSectorValueses.size() - 1; intSector >= 0; --intSector) {
                        o_DMXSceneDeviceSectorValues = this.m_DMXSceneDeviceSectorValueses.get(intSector);
                        if (o_DMXSceneDeviceSectorValues == null) continue;
                        o_DMXSceneDeviceSectorValues.close();
                        this.removeDMXSceneDeviceSectorValues(o_DMXSceneDeviceSectorValues);
                    }
                }
            }
            this.m_DMXDevice = p_DMXDevice;
            if (this.m_DMXDevice == null) {
                return;
            }
            if (this.m_DMXSceneValueContainer != null && this.m_DMXSceneValueContainer.getFlagMixSource() != 1 && this.m_DMXSceneValueContainer.getFlagMixSource() != -1 && this.m_DMXSceneValueContainer.getDMXScene() == null && (o_DMXControlComponent = this.m_DMXDevice.getDMXControlComponentByDescriptionFirst("pantilt")) != null) {
                this.m_VirtualPoint_Path_DMXDevice = new DMXControl_GridPanTilt_DeviceSettings.VirtualPoint_Path_DMXDevice(this.m_DMXDevice);
            }
            int intSectorCount = this.m_DMXDevice.getInternalSectorCount();
            for (intSector = 0; intSector < intSectorCount; ++intSector) {
                o_DMXSceneDeviceSectorValues = new DMXSceneDeviceSectorValues(this);
                this.addDMXSceneDeviceSectorValues(o_DMXSceneDeviceSectorValues);
                o_DMXSceneDeviceSectorValues.setDMXDeviceInternalSector(this.m_DMXDevice.getInternalSector(intSector));
            }
        }

        public DMXDevice getDMXDevice() {
            return this.m_DMXDevice;
        }

        public boolean isDimmerOn() {
            DMXDevice o_DMXDevice = this.m_DMXDevice;
            if (!o_DMXDevice.getIsDimmable()) {
                return true;
            }
            double doubleDimmerValue = this.calculateDimmerValue();
            return doubleDimmerValue != 0.0;
        }

        public double calculateDimmerValue() {
            DMXDevice o_DMXDevice = this.m_DMXDevice;
            if (o_DMXDevice == null) {
                return 0.0;
            }
            double doubleValueDMXControl = 0.0;
            double doubleValueResult = -2.147483648E9;
            int intDimensionCount = 0;
            DMXControlComponent o_DMXControlComponent = o_DMXDevice.getDMXControlComponent_Dimmer();
            if (o_DMXControlComponent != null) {
                doubleValueResult = this.getValueDMXDevice(o_DMXControlComponent.getDMXControlType(), 0, 0);
            } else {
                for (int intComponent = 0; intComponent < o_DMXDevice.getDMXControlComponent_Dimmer_Substitutes_Count(); ++intComponent) {
                    o_DMXControlComponent = o_DMXDevice.getDMXControlComponent_Dimmer_Substitute(intComponent);
                    if (o_DMXControlComponent == null) continue;
                    intDimensionCount = 0;
                    doubleValueDMXControl = -2.147483648E9;
                    DMXControlComponent.DMXControlType o_DMXControlType = o_DMXControlComponent.getDMXControlType();
                    if (o_DMXControlType == null) continue;
                    for (int intControlIndex = 0; intControlIndex < o_DMXControlType.getControlTypeCount(); ++intControlIndex) {
                        DMXControlComponent.ControlType o_ControlType = o_DMXControlType.getControlType(intControlIndex);
                        if (o_ControlType == null) continue;
                        for (int intDimension = 0; intDimension < o_ControlType.getControlDimensionTypeCount(); ++intDimension) {
                            intDimensionCount = o_DMXControlComponent instanceof DMXControl_RGB ? 3 : ++intDimensionCount;
                            double doubleValue = this.getValueDMXDevice(o_DMXControlType, intControlIndex, intDimension);
                            if (doubleValue < 0.0) continue;
                            if (doubleValueDMXControl < 0.0) {
                                doubleValueDMXControl = doubleValue;
                                continue;
                            }
                            doubleValueDMXControl += doubleValue;
                        }
                    }
                    if (intDimensionCount <= 0 || !(doubleValueDMXControl >= 0.0)) continue;
                    doubleValueDMXControl /= (double)intDimensionCount;
                    if (doubleValueResult < 0.0) {
                        doubleValueResult = doubleValueDMXControl;
                        continue;
                    }
                    doubleValueResult += doubleValueDMXControl;
                }
                if (doubleValueResult < 0.0) {
                    return doubleValueResult;
                }
                doubleValueResult = o_DMXDevice.getDMXControlComponent_Dimmer_Substitutes_Count() > 0 ? (doubleValueResult /= (double)o_DMXDevice.getDMXControlComponent_Dimmer_Substitutes_Count()) : 0.0;
            }
            return doubleValueResult;
        }

        public void setAdjustmentDimmerOff(boolean p_DimmerOff, LiveShowDMXObject p_LiveShowDMXObject) {
            if (p_LiveShowDMXObject == null) {
                return;
            }
            if (!p_DimmerOff) {
                this.m_DimmerOff_Objects.remove(p_LiveShowDMXObject);
            } else {
                this.m_DimmerOff_Objects.put(p_LiveShowDMXObject, true);
            }
        }

        public boolean getAdjustmentDimmerOff(LiveShowDMXObject p_LiveShowDMXObject) {
            if (p_LiveShowDMXObject == null) {
                return false;
            }
            return this.m_DimmerOff_Objects.get(p_LiveShowDMXObject) != null;
        }

        public boolean calculateSomethingOn() {
            DMXDevice o_DMXDevice = this.m_DMXDevice;
            if (o_DMXDevice == null) {
                return false;
            }
            double doubleValueDMXControl = 0.0;
            for (int intComponent = 0; intComponent < o_DMXDevice.getDMXControlComponentCount(); ++intComponent) {
                DMXControlComponent o_DMXControlComponent = o_DMXDevice.getDMXControlComponent(intComponent);
                if (o_DMXControlComponent == null) continue;
                doubleValueDMXControl = -2.147483648E9;
                DMXControlComponent.DMXControlType o_DMXControlType = o_DMXControlComponent.getDMXControlType();
                if (o_DMXControlType == null) continue;
                for (int intControlIndex = 0; intControlIndex < o_DMXControlType.getControlTypeCount(); ++intControlIndex) {
                    DMXControlComponent.ControlType o_ControlType = o_DMXControlType.getControlType(intControlIndex);
                    if (o_ControlType == null) continue;
                    for (int intDimension = 0; intDimension < o_ControlType.getControlDimensionTypeCount(); ++intDimension) {
                        double doubleValue = this.getValueDMXDevice(o_DMXControlType, intControlIndex, intDimension);
                        if (doubleValue < 0.0) continue;
                        if (doubleValueDMXControl < 0.0) {
                            doubleValueDMXControl = doubleValue;
                            continue;
                        }
                        doubleValueDMXControl += doubleValue;
                    }
                    if (!(doubleValueDMXControl > 0.0)) continue;
                    return true;
                }
            }
            return false;
        }

        public void calculateDeactivationCancelled(LiveShowDMXObject p_LiveShowDMXObject) {
            if (p_LiveShowDMXObject == null) {
                return;
            }
            boolean boolDisabledCancelled = false;
            DMXDevice o_DMXDevice = this.m_DMXDevice;
            if (o_DMXDevice == null) {
                return;
            }
            DMXDeviceType o_DMXDeviceType = o_DMXDevice.getDMXDeviceType();
            if (o_DMXDeviceType == null) {
                return;
            }
            DMXFadeDescription o_DMXFadeDescription = p_LiveShowDMXObject.getDMXFadeDescription();
            if (o_DMXFadeDescription == null) {
                return;
            }
            DMXFadeDescription.DMXDeviceFadeDescription o_DMXDeviceFadeDescription_Object = p_LiveShowDMXObject.getDMXFadeDescription().getDMXDeviceFadeDescription(o_DMXDevice.getID());
            DMXFadeDescription.DMXDeviceFadeDescription o_DMXDeviceFadeDescription_Device = o_DMXDeviceType.getDefaultDMXDeviceFadeDescription();
            if (o_DMXDeviceFadeDescription_Object == null || o_DMXDeviceFadeDescription_Device == null) {
                this.setDisabledCancelled(false, p_LiveShowDMXObject);
                return;
            }
            for (int intDMXControlType = 0; intDMXControlType < o_DMXDeviceType.getDMXControlTypeCount(); ++intDMXControlType) {
                DMXControlComponent.DMXControlType o_DMXControlType = o_DMXDeviceType.getDMXControlType(intDMXControlType);
                if (o_DMXControlType == null) continue;
                DMXFadeDescription.DMXControlTypeFadeDescription o_DMXControlFadeDescription_Device = o_DMXDeviceFadeDescription_Device.getDMXControlTypeFadeDescription(o_DMXControlType.getID());
                DMXFadeDescription.DMXControlTypeFadeDescription o_DMXControlFadeDescription_Object = o_DMXDeviceFadeDescription_Object.getDMXControlTypeFadeDescription(o_DMXControlType.getID());
                if (o_DMXControlFadeDescription_Device == null || o_DMXControlFadeDescription_Object == null || !o_DMXControlFadeDescription_Device.getDisabled() || o_DMXControlFadeDescription_Object.getDisabled()) continue;
                boolDisabledCancelled = true;
                break;
            }
            this.setDisabledCancelled(boolDisabledCancelled, p_LiveShowDMXObject);
        }

        public void setDisabledCancelled(boolean p_DeactivationCancelled, LiveShowDMXObject p_LiveShowDMXObject) {
            if (p_LiveShowDMXObject == null) {
                return;
            }
            if (!p_DeactivationCancelled) {
                this.m_DisabledCancelled_Objects.remove(p_LiveShowDMXObject);
            } else {
                this.m_DisabledCancelled_Objects.put(p_LiveShowDMXObject, true);
            }
        }

        public boolean getDisabledCancelled(LiveShowDMXObject p_LiveShowDMXObject) {
            return this.m_DisabledCancelled_Objects.get(p_LiveShowDMXObject) != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addDMXSceneDeviceSectorValues(DMXSceneDeviceSectorValues p_DMXSceneDeviceSectorValues) {
            if (p_DMXSceneDeviceSectorValues == null) {
                return;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (this.m_DMXSceneDeviceSectorValueses.contains(p_DMXSceneDeviceSectorValues)) {
                    return;
                }
                this.m_DMXSceneDeviceSectorValueses.add(p_DMXSceneDeviceSectorValues);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeDMXSceneDeviceSectorValues(DMXSceneDeviceSectorValues p_DMXSceneDeviceSectorValues) {
            if (p_DMXSceneDeviceSectorValues == null) {
                return;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (!this.m_DMXSceneDeviceSectorValueses.contains(p_DMXSceneDeviceSectorValues)) {
                    return;
                }
                this.m_DMXSceneDeviceSectorValueses.remove(p_DMXSceneDeviceSectorValues);
            }
        }

        public int getDMXSceneDeviceSectorValuesCount() {
            return this.m_DMXSceneDeviceSectorValueses.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DMXSceneDeviceSectorValues getDMXSceneDeviceSectorValues(int p_Sector) {
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (p_Sector < 0 || p_Sector >= this.m_DMXSceneDeviceSectorValueses.size()) {
                    return null;
                }
                return this.m_DMXSceneDeviceSectorValueses.get(p_Sector);
            }
        }

        public void clear(Playable p_Playable) {
            DMXDeviceType o_DMXDeviceType;
            if (this.m_DMXDevice == null) {
                return;
            }
            boolean boolDisabled = false;
            DMXControl_GridPanTilt_DeviceSettings.VirtualPoint_Path_DMXDevice o_VirtualPoint_Path_DMXDevice = this.m_VirtualPoint_Path_DMXDevice;
            if (o_VirtualPoint_Path_DMXDevice != null) {
                o_VirtualPoint_Path_DMXDevice.clearVirtualPoints_Read();
                o_VirtualPoint_Path_DMXDevice.setCalculationCount(0);
            }
            if ((o_DMXDeviceType = this.m_DMXDevice.getDMXDeviceType()) == null) {
                return;
            }
            for (int intDMXControlType = 0; intDMXControlType < o_DMXDeviceType.getDMXControlTypeCount(); ++intDMXControlType) {
                DMXFadeDescription o_DMXFadeDescription;
                DMXControlComponent.DMXControlType o_DMXControlType = o_DMXDeviceType.getDMXControlType(intDMXControlType);
                DMXFadeDescription.DMXControlTypeFadeDescription o_DMXControlTypeFadeDescription = o_DMXDeviceType.getDefaultDMXControlTypeFadeDescription(o_DMXControlType);
                if (o_DMXControlTypeFadeDescription == null) continue;
                boolDisabled = o_DMXControlTypeFadeDescription.getDisabled();
                if (p_Playable != null && p_Playable instanceof LiveShowDMXObject && (o_DMXFadeDescription = ((LiveShowDMXObject)p_Playable).getDMXFadeDescription()) != null && (o_DMXControlTypeFadeDescription = o_DMXFadeDescription.getDMXControlTypeFadeDescription(this.m_DMXDevice.getID(), o_DMXControlType.getID())) != null) {
                    boolDisabled = o_DMXControlTypeFadeDescription.getDisabled();
                }
                DMXSceneDeviceValues o_DMXSceneDeviceValues = this;
                for (int intControlType = 0; intControlType < o_DMXControlType.getControlTypeCount(); ++intControlType) {
                    DMXControlComponent.ControlType o_ControlType = o_DMXControlType.getControlType(intControlType);
                    if (o_ControlType == null) continue;
                    for (int intDimensionType = 0; intDimensionType < o_ControlType.getControlDimensionTypeCount(); ++intDimensionType) {
                        DMXControlComponent.ControlDimensionType o_ControlDimensionType = o_ControlType.getControlDimensionType(intDimensionType);
                        if (o_ControlDimensionType == null) continue;
                        for (int intLink = 0; intLink < o_ControlDimensionType.getDeviceControlLinkCount(); ++intLink) {
                            DMXControlComponent.DeviceControlLink o_DeviceControlLink = o_ControlDimensionType.getDeviceControlLink(intLink);
                            if (o_DeviceControlLink == null) continue;
                            long longValueNew = boolDisabled ? Integer.MIN_VALUE : 0L;
                            o_DeviceControlLink.setValueScene((double)longValueNew, o_DMXSceneDeviceValues);
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void saveDMXDeviceValues_EditMode(DMXDevice p_DMXDevice) {
            this.setDMXDevice(p_DMXDevice);
            Object object = this.m_SyncObject;
            synchronized (object) {
                for (int intSector = 0; intSector < this.m_DMXSceneDeviceSectorValueses.size(); ++intSector) {
                    this.m_DMXSceneDeviceSectorValueses.get(intSector).saveDMXDeviceValues_EditMode(p_DMXDevice);
                }
                this.setPanTilt_VirtualPointFromAngles();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void saveDMXDeviceValues(DMXDevice p_DMXDevice) {
            this.setDMXDevice(p_DMXDevice);
            Object object = this.m_SyncObject;
            synchronized (object) {
                for (int intSector = 0; intSector < this.m_DMXSceneDeviceSectorValueses.size(); ++intSector) {
                    this.m_DMXSceneDeviceSectorValueses.get(intSector).saveDMXDeviceValues(p_DMXDevice);
                }
                this.setPanTilt_VirtualPointFromAngles();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cleanUpDMXDeviceValues(DMXDevice p_DMXDevice) {
            if (this.isDimmerOn()) {
                return;
            }
            this.setDMXDevice(p_DMXDevice);
            Object object = this.m_SyncObject;
            synchronized (object) {
                for (int intSector = 0; intSector < this.m_DMXSceneDeviceSectorValueses.size(); ++intSector) {
                    this.m_DMXSceneDeviceSectorValueses.get(intSector).cleanUpDMXDeviceValues(p_DMXDevice);
                }
                this.setPanTilt_VirtualPointFromAngles();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void saveDMXDeviceDefaultValues(DMXDevice p_DMXDevice) {
            this.setDMXDevice(p_DMXDevice);
            Object object = this.m_SyncObject;
            synchronized (object) {
                for (int intSector = 0; intSector < this.m_DMXSceneDeviceSectorValueses.size(); ++intSector) {
                    this.m_DMXSceneDeviceSectorValueses.get(intSector).saveDMXDeviceDefaultValues(p_DMXDevice);
                }
            }
        }

        public void setPanTilt_VirtualPointFromAngles() {
            DMXDevice o_DMXDevice = this.m_DMXDevice;
            if (o_DMXDevice == null) {
                this.m_VirtualPoint_PanTilt = null;
                return;
            }
            DMXControl_GridPanTilt o_DMXControl_GridPanTilt = (DMXControl_GridPanTilt)o_DMXDevice.getDMXControlComponentByDescriptionFirst("pantilt");
            if (o_DMXControl_GridPanTilt == null) {
                this.m_VirtualPoint_PanTilt = null;
                return;
            }
            double doubleValueSceneX = 0.0;
            double doubleValueSceneY = 0.0;
            ArrayList<DMXControlComponent.DeviceControlLink> o_DeviceControlLinks = o_DMXControl_GridPanTilt.getDMXControlType().getDeviceControlLinks();
            if (o_DeviceControlLinks.size() < 2) {
                this.m_VirtualPoint_PanTilt = null;
                return;
            }
            for (int intLink = 0; intLink < o_DeviceControlLinks.size(); ++intLink) {
                DMXControlComponent.DeviceControlLink o_DeviceControlLink = o_DeviceControlLinks.get(intLink);
                if (o_DeviceControlLink.getControlDimensionTypeIndex() == 1) {
                    doubleValueSceneY = o_DeviceControlLink.getValueScene(this);
                }
                if (o_DeviceControlLink.getControlDimensionTypeIndex() != 0) continue;
                doubleValueSceneX = o_DeviceControlLink.getValueScene(this);
            }
            this.m_VirtualPoint_PanTilt = DMXControl_GridPanTilt_DeviceSettings.calculateVirtualPointFromAnglesBilinear(this.m_VirtualPoint_PanTilt, o_DMXDevice, doubleValueSceneX, doubleValueSceneY, false);
        }

        public void setPanTilt_AnglesFromVirtualPoint(DMXControl_GridPanTilt_DeviceSettings.VirtualPoint p_VirtualPoint) {
            DMXDevice o_DMXDevice = this.m_DMXDevice;
            if (o_DMXDevice == null) {
                return;
            }
            Point2D o_Point2D = this.calculatePanTilt_AnglesFromVirtualPoint(null, o_DMXDevice, p_VirtualPoint);
            if (o_Point2D == null) {
                return;
            }
            DMXControl_GridPanTilt o_DMXControl_GridPanTilt = (DMXControl_GridPanTilt)o_DMXDevice.getDMXControlComponentByDescriptionFirst("pantilt");
            if (o_DMXControl_GridPanTilt == null) {
                return;
            }
            ArrayList<DMXControlComponent.DeviceControlLink> o_DeviceControlLinks = o_DMXControl_GridPanTilt.getDMXControlType().getDeviceControlLinks();
            if (o_DeviceControlLinks.size() < 2) {
                return;
            }
            o_Point2D = DMXControl_GridPanTilt_DeviceSettings.calculateAnglesFromVirtualPoint(null, o_DMXDevice, p_VirtualPoint);
            if (o_Point2D == null) {
                return;
            }
            for (int intLink = 0; intLink < o_DeviceControlLinks.size(); ++intLink) {
                DMXControlComponent.DeviceControlLink o_DeviceControlLink = o_DeviceControlLinks.get(intLink);
                if (o_DeviceControlLink.getControlDimensionTypeIndex() == 1) {
                    o_DeviceControlLink.setValueScene(o_Point2D.getY(), this);
                }
                if (o_DeviceControlLink.getControlDimensionTypeIndex() != 0) continue;
                o_DeviceControlLink.setValueScene(o_Point2D.getX(), this);
            }
        }

        public Point2D calculatePanTilt_AnglesFromVirtualPoint(Point2D p_Point2D, DMXDevice p_DMXDevice, DMXControl_GridPanTilt_DeviceSettings.VirtualPoint p_VirtualPoint) {
            if (p_DMXDevice == null) {
                return null;
            }
            if (p_VirtualPoint == null) {
                return null;
            }
            DMXControl_GridPanTilt o_DMXControl_GridPanTilt = (DMXControl_GridPanTilt)p_DMXDevice.getDMXControlComponentByDescriptionFirst("pantilt");
            if (o_DMXControl_GridPanTilt == null) {
                return null;
            }
            ArrayList<DMXControlComponent.DeviceControlLink> o_DeviceControlLinks = o_DMXControl_GridPanTilt.getDMXControlType().getDeviceControlLinks();
            if (o_DeviceControlLinks.size() < 2) {
                return null;
            }
            Point2D o_Point2D = DMXControl_GridPanTilt_DeviceSettings.calculateAnglesFromVirtualPoint(p_Point2D, p_DMXDevice, p_VirtualPoint);
            return o_Point2D;
        }

        public DMXControl_GridPanTilt_DeviceSettings.VirtualPoint getVirtualPoint_PanTilt() {
            return this.m_VirtualPoint_PanTilt;
        }

        public void setVirtualPoint_PanTilt(DMXControl_GridPanTilt_DeviceSettings.VirtualPoint p_VirtualPoint) {
            this.m_VirtualPoint_PanTilt = p_VirtualPoint;
        }

        public double getValueDMXDevice_Max(DMXControlComponent.DMXControlType p_DMXControlType) {
            if (p_DMXControlType == null) {
                return -2.147483648E9;
            }
            double doubleValueMax = -2.147483648E9;
            for (int intControlType = 0; intControlType < p_DMXControlType.getControlTypeCount(); ++intControlType) {
                DMXControlComponent.ControlType o_ControlType = p_DMXControlType.getControlType(intControlType);
                if (o_ControlType == null) continue;
                for (int intDimension = 0; intDimension < o_ControlType.getControlDimensionTypeCount(); ++intDimension) {
                    double doubleValue = this.getValueDMXDevice(p_DMXControlType, intControlType, intDimension);
                    if (!(doubleValue > doubleValueMax)) continue;
                    doubleValueMax = doubleValue;
                }
            }
            return doubleValueMax;
        }

        public double getValueDMXDevice(DMXControlComponent.DMXControlType p_DMXControlType, int p_ControlIndex, int p_DimensionIndex) {
            if (p_DMXControlType == null) {
                return -2.147483648E9;
            }
            DMXControlComponent.ControlType o_ControlType = p_DMXControlType.getControlType(p_ControlIndex);
            if (o_ControlType == null) {
                return -2.147483648E9;
            }
            DMXControlComponent.ControlDimensionType o_ControlDimensionType = o_ControlType.getControlDimensionType(p_DimensionIndex);
            if (o_ControlDimensionType == null) {
                return -2.147483648E9;
            }
            return this.getValueDMXDevice(o_ControlDimensionType);
        }

        public double setValueDMXDevice(double p_Value, DMXControlComponent.DMXControlType p_DMXControlType, int p_ControlIndex, int p_DimensionIndex) {
            if (p_DMXControlType == null) {
                return -2.147483648E9;
            }
            DMXControlComponent.ControlType o_ControlType = p_DMXControlType.getControlType(p_ControlIndex);
            if (o_ControlType == null) {
                return -2.147483648E9;
            }
            DMXControlComponent.ControlDimensionType o_ControlDimensionType = o_ControlType.getControlDimensionType(p_DimensionIndex);
            if (o_ControlDimensionType == null) {
                return -2.147483648E9;
            }
            this.setValueDMXDevice(p_Value, o_ControlDimensionType);
            return this.getValueDMXDevice(o_ControlDimensionType);
        }

        public double getValueDMXDevice(DMXControlComponent.ControlDimensionType p_ControlDimensionType) {
            if (p_ControlDimensionType == null) {
                return -2.147483648E9;
            }
            int intDeviceControlLinkCount = p_ControlDimensionType.getDeviceControlLinkCount();
            switch (intDeviceControlLinkCount) {
                case 0: {
                    return -2.147483648E9;
                }
                case 1: {
                    DMXControlComponent.DeviceControlLink o_DeviceControlLink = p_ControlDimensionType.getDeviceControlLink(0);
                    return o_DeviceControlLink.getValueScene(this);
                }
            }
            return -2.147483648E9;
        }

        public double setValueDMXDevice(double p_Value, DMXControlComponent.ControlDimensionType p_ControlDimensionType) {
            if (p_ControlDimensionType == null) {
                return -2.147483648E9;
            }
            int intDeviceControlLinkCount = p_ControlDimensionType.getDeviceControlLinkCount();
            switch (intDeviceControlLinkCount) {
                case 0: {
                    return -2.147483648E9;
                }
                case 1: {
                    DMXControlComponent.DeviceControlLink o_DeviceControlLink = p_ControlDimensionType.getDeviceControlLink(0);
                    o_DeviceControlLink.setValueScene(p_Value, this);
                    return o_DeviceControlLink.getValueScene(this);
                }
            }
            return -2.147483648E9;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeDMXSceneToChannels_EditMode() {
            Object object = this.m_SyncObject;
            synchronized (object) {
                for (int intSector = 0; intSector < this.m_DMXSceneDeviceSectorValueses.size(); ++intSector) {
                    this.m_DMXSceneDeviceSectorValueses.get(intSector).writeDMXSceneToChannels_EditMode(this.m_DMXDevice);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeDMXSceneToChannels(boolean p_SendToDMXUniverses, boolean p_ManuallySet) {
            int intSector;
            Object object = this.m_SyncObject;
            synchronized (object) {
                for (intSector = 0; intSector < this.m_DMXSceneDeviceSectorValueses.size(); ++intSector) {
                    this.m_DMXSceneDeviceSectorValueses.get(intSector).writeDMXSceneToChannels(this.m_DMXDevice, p_ManuallySet);
                }
            }
            if (p_SendToDMXUniverses && this.m_DMXDevice != null) {
                for (intSector = 0; intSector < this.m_DMXDevice.getInternalSectorCount(); ++intSector) {
                    DMXUniverse o_DMXUniverse = this.m_DMXDevice.getDMXUniverse(intSector);
                    if (o_DMXUniverse == null) continue;
                    o_DMXUniverse.callDMXOutput_WriteChannels();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void copyValuesNewFromChannels() {
            Object object = this.m_SyncObject;
            synchronized (object) {
                for (int intSector = 0; intSector < this.m_DMXSceneDeviceSectorValueses.size(); ++intSector) {
                    DMXSceneDeviceSectorValues o_DMXSceneDeviceSectorValues = this.m_DMXSceneDeviceSectorValueses.get(intSector);
                    o_DMXSceneDeviceSectorValues.copyValuesNewFromChannels();
                }
            }
        }

        public void copyValuesFrom(DMXSceneDeviceValues p_DMXSceneDeviceValues) {
            for (int intSector = 0; intSector < p_DMXSceneDeviceValues.getDMXSceneDeviceSectorValuesCount(); ++intSector) {
                DMXSceneDeviceSectorValues o_DMXSceneDeviceSectorValuesFrom;
                DMXSceneDeviceSectorValues o_DMXSceneDeviceSectorValues = this.getDMXSceneDeviceSectorValues(intSector);
                if (o_DMXSceneDeviceSectorValues == null || (o_DMXSceneDeviceSectorValuesFrom = p_DMXSceneDeviceValues.getDMXSceneDeviceSectorValues(intSector)) == null) continue;
                o_DMXSceneDeviceSectorValues.copyValuesFrom(o_DMXSceneDeviceSectorValuesFrom);
            }
        }

        public void fillPlayObject(boolean p_MixIn, DMXSceneDeviceValues p_DMXSceneDeviceValuesFrom, LiveShowObject p_LiveShowObject, float p_VolumeFactor, DMXFadeDescription p_DMXFadeDescription, double p_FadeProgress, boolean p_FadeIn, boolean p_FadeOut) {
            if (this.m_DMXDevice == null) {
                return;
            }
            if (p_DMXSceneDeviceValuesFrom == null) {
                return;
            }
            if (p_DMXFadeDescription == null) {
                return;
            }
            boolean boolFillOnlyDisabled = false;
            if (p_LiveShowObject instanceof LiveShowDMXObject && p_DMXSceneDeviceValuesFrom.getAdjustmentDimmerOff((LiveShowDMXObject)p_LiveShowObject)) {
                if (p_DMXSceneDeviceValuesFrom.getDisabledCancelled((LiveShowDMXObject)p_LiveShowObject)) {
                    boolFillOnlyDisabled = true;
                } else {
                    return;
                }
            }
            boolean boolDisabled = false;
            DMXDevice o_DMXDevice = this.m_DMXDevice;
            if (o_DMXDevice == null) {
                return;
            }
            DMXDeviceType o_DMXDeviceType = o_DMXDevice.getDMXDeviceType();
            if (o_DMXDeviceType == null) {
                return;
            }
            DMXFadeDescription.DMXDeviceFadeDescription o_DMXDeviceFadeDescription = p_DMXFadeDescription.getDMXDeviceFadeDescription(o_DMXDevice.getID());
            if (o_DMXDeviceFadeDescription == null) {
                return;
            }
            this.m_FadeIn = p_FadeIn;
            this.m_FadeOut = p_FadeOut;
            for (int intDMXControlType = 0; intDMXControlType < o_DMXDeviceType.getDMXControlTypeCount(); ++intDMXControlType) {
                DMXControl_GridPanTilt_DeviceSettings.VirtualPoint o_VirtualPoint_Filled;
                DMXFadeDescription.DMXControlTypeFadeDescription o_DefaultDMXControlTypeFadeDescription;
                DMXFadeDescription.DMXControlTypeFadeDescription o_DMXControlTypeFadeDescription;
                DMXControlComponent.DMXControlType o_DMXControlType = o_DMXDeviceType.getDMXControlType(intDMXControlType);
                if (o_DMXControlType == null || (o_DMXControlTypeFadeDescription = o_DMXDeviceFadeDescription.getDMXControlTypeFadeDescription(o_DMXControlType.getID())) == null || (o_DefaultDMXControlTypeFadeDescription = o_DMXDeviceType.getDefaultDMXControlTypeFadeDescription(o_DMXControlType)) == null || boolFillOnlyDisabled && !o_DefaultDMXControlTypeFadeDescription.getDisabled()) continue;
                boolDisabled = p_LiveShowObject == null || p_LiveShowObject instanceof LiveShowDMXSceneBridge ? o_DefaultDMXControlTypeFadeDescription.getDisabled() : o_DMXControlTypeFadeDescription.getDisabled();
                double doubleFadeFactor = boolDisabled ? 1.0 : this.calculateFadeFactor(o_DMXControlTypeFadeDescription, p_FadeProgress, p_FadeIn, p_FadeOut);
                if (p_MixIn && !boolDisabled && o_DMXControlType.getDMXControlDescription().getID() == "pantilt" && (o_VirtualPoint_Filled = p_DMXSceneDeviceValuesFrom.getVirtualPoint_PanTilt()) != null) {
                    this.m_VirtualPoint_PanTilt = o_VirtualPoint_Filled;
                    DMXControl_GridPanTilt_DeviceSettings.VirtualPoint_Path_DMXDevice o_VirtualPoint_Path_DMXDevice = this.m_VirtualPoint_Path_DMXDevice;
                    if (o_VirtualPoint_Path_DMXDevice != null) {
                        o_VirtualPoint_Path_DMXDevice.addVirtualPoint_Read(o_VirtualPoint_Filled, p_FadeProgress, -1);
                    }
                }
                for (int intControlType = 0; intControlType < o_DMXControlType.getControlTypeCount(); ++intControlType) {
                    DMXControlComponent.ControlType o_ControlType = o_DMXControlType.getControlType(intControlType);
                    if (o_ControlType == null) continue;
                    for (int intDimensionType = 0; intDimensionType < o_ControlType.getControlDimensionTypeCount(); ++intDimensionType) {
                        DMXControlComponent.ControlDimensionType o_ControlDimensionType = o_ControlType.getControlDimensionType(intDimensionType);
                        if (o_ControlDimensionType == null) continue;
                        for (int intLink = 0; intLink < o_ControlDimensionType.getDeviceControlLinkCount(); ++intLink) {
                            double doubleValueScene;
                            double doubleValueNew;
                            DMXControlComponent.DeviceControlLink o_DeviceControlLink = o_ControlDimensionType.getDeviceControlLink(intLink);
                            if (o_DeviceControlLink == null) continue;
                            if (p_MixIn) {
                                double doubleValueSelf = o_DeviceControlLink.getValueScene(this);
                                if (boolDisabled) {
                                    doubleValueNew = doubleValueSelf;
                                } else {
                                    doubleValueScene = o_DeviceControlLink.getValueScene(p_DMXSceneDeviceValuesFrom);
                                    doubleValueNew = this.calculateNewValue(o_DeviceControlLink, doubleValueScene, p_VolumeFactor, o_DMXControlTypeFadeDescription, doubleFadeFactor, p_FadeIn, p_FadeOut);
                                    if (doubleValueSelf >= 0.0) {
                                        doubleValueNew += doubleValueSelf;
                                    }
                                }
                            } else if (boolDisabled) {
                                doubleValueNew = -2.147483648E9;
                            } else {
                                doubleValueScene = o_DeviceControlLink.getValueScene(p_DMXSceneDeviceValuesFrom);
                                doubleValueNew = this.calculateNewValue(o_DeviceControlLink, doubleValueScene, p_VolumeFactor, o_DMXControlTypeFadeDescription, doubleFadeFactor, p_FadeIn, p_FadeOut);
                            }
                            o_DeviceControlLink.setValueScene(doubleValueNew, this);
                        }
                    }
                }
            }
        }

        public void setFadeIn(boolean p_FadeIn) {
            this.m_FadeIn = p_FadeIn;
        }

        public boolean getFadeIn() {
            return this.m_FadeIn;
        }

        public void setFadeOut(boolean p_FadeOut) {
            this.m_FadeOut = p_FadeOut;
        }

        public boolean getFadeOut() {
            return this.m_FadeOut;
        }

        public void fillPlayObject(DMXControlComponent p_DMXControlComponent, boolean p_MixIn, DMXSceneDeviceValues p_DMXSceneDeviceValuesFrom, LiveShowObject p_LiveShowObject, float p_VolumeFactor, DMXFadeDescription p_DMXFadeDescription, double p_FadeProgress, boolean p_FadeIn, boolean p_FadeOut) {
            DMXControl_GridPanTilt_DeviceSettings.VirtualPoint_Path_DMXDevice o_VirtualPoint_Path_DMXDevice;
            DMXControl_GridPanTilt_DeviceSettings.VirtualPoint o_VirtualPoint_Filled;
            if (this.m_DMXDevice == null) {
                return;
            }
            if (p_DMXControlComponent == null) {
                return;
            }
            if (p_DMXSceneDeviceValuesFrom == null) {
                return;
            }
            if (p_DMXFadeDescription == null) {
                return;
            }
            if (p_DMXSceneDeviceValuesFrom.getAdjustmentDimmerOff((LiveShowDMXObject)p_LiveShowObject)) {
                return;
            }
            boolean boolDisabled = false;
            DMXDevice o_DMXDevice = this.m_DMXDevice;
            if (o_DMXDevice == null) {
                return;
            }
            DMXDeviceType o_DMXDeviceType = o_DMXDevice.getDMXDeviceType();
            if (o_DMXDeviceType == null) {
                return;
            }
            DMXFadeDescription.DMXDeviceFadeDescription o_DMXDeviceFadeDescription = p_DMXFadeDescription.getDMXDeviceFadeDescription(o_DMXDevice.getID());
            if (o_DMXDeviceFadeDescription == null) {
                return;
            }
            DMXControlComponent.DMXControlType o_DMXControlType = p_DMXControlComponent.getDMXControlType();
            if (o_DMXControlType == null) {
                return;
            }
            DMXFadeDescription.DMXControlTypeFadeDescription o_DMXControlTypeFadeDescription = o_DMXDeviceFadeDescription.getDMXControlTypeFadeDescription(o_DMXControlType.getID());
            if (o_DMXControlTypeFadeDescription == null) {
                return;
            }
            this.m_FadeIn = p_FadeIn;
            this.m_FadeOut = p_FadeOut;
            DMXFadeDescription.DMXControlTypeFadeDescription o_DefaultDMXControlTypeFadeDescription = o_DMXDeviceType.getDefaultDMXControlTypeFadeDescription(o_DMXControlType);
            boolDisabled = p_LiveShowObject == null || p_LiveShowObject instanceof LiveShowDMXSceneBridge ? (o_DefaultDMXControlTypeFadeDescription != null ? o_DefaultDMXControlTypeFadeDescription.getDisabled() : true) : o_DMXControlTypeFadeDescription.getDisabled();
            if (p_MixIn && !boolDisabled && o_DMXControlType.getDMXControlDescription().getID() == "pantilt" && (o_VirtualPoint_Filled = p_DMXSceneDeviceValuesFrom.getVirtualPoint_PanTilt()) != null && (o_VirtualPoint_Path_DMXDevice = this.m_VirtualPoint_Path_DMXDevice) != null) {
                o_VirtualPoint_Path_DMXDevice.addVirtualPoint_Read(o_VirtualPoint_Filled, p_FadeProgress, -1);
            }
            double doubleFadeFactor = boolDisabled ? 1.0 : this.calculateFadeFactor(o_DMXControlTypeFadeDescription, p_FadeProgress, p_FadeIn, p_FadeOut);
            for (int intControlType = 0; intControlType < o_DMXControlType.getControlTypeCount(); ++intControlType) {
                DMXControlComponent.ControlType o_ControlType = o_DMXControlType.getControlType(intControlType);
                if (o_ControlType == null) continue;
                for (int intDimensionType = 0; intDimensionType < o_ControlType.getControlDimensionTypeCount(); ++intDimensionType) {
                    DMXControlComponent.ControlDimensionType o_ControlDimensionType = o_ControlType.getControlDimensionType(intDimensionType);
                    if (o_ControlDimensionType == null) continue;
                    for (int intLink = 0; intLink < o_ControlDimensionType.getDeviceControlLinkCount(); ++intLink) {
                        double doubleValueScene;
                        double doubleValueNew;
                        DMXControlComponent.DeviceControlLink o_DeviceControlLink = o_ControlDimensionType.getDeviceControlLink(intLink);
                        if (o_DeviceControlLink == null) continue;
                        if (p_MixIn) {
                            double doubleValueSelf = o_DeviceControlLink.getValueScene(this);
                            if (boolDisabled) {
                                doubleValueNew = doubleValueSelf;
                            } else {
                                doubleValueScene = o_DeviceControlLink.getValueScene(p_DMXSceneDeviceValuesFrom);
                                doubleValueNew = this.calculateNewValue(o_DeviceControlLink, doubleValueScene, p_VolumeFactor, o_DMXControlTypeFadeDescription, doubleFadeFactor, p_FadeIn, p_FadeOut);
                                if (doubleValueSelf >= 0.0) {
                                    doubleValueNew += doubleValueSelf;
                                }
                            }
                        } else if (boolDisabled) {
                            doubleValueNew = -2.147483648E9;
                        } else {
                            doubleValueScene = o_DeviceControlLink.getValueScene(p_DMXSceneDeviceValuesFrom);
                            doubleValueNew = this.calculateNewValue(o_DeviceControlLink, doubleValueScene, p_VolumeFactor, o_DMXControlTypeFadeDescription, doubleFadeFactor, p_FadeIn, p_FadeOut);
                        }
                        o_DeviceControlLink.setValueScene(doubleValueNew, this);
                    }
                }
            }
        }

        public DMXControl_GridPanTilt_DeviceSettings.VirtualPoint_Path_DMXDevice getVirtualPoint_Path_DMXDevice() {
            return this.m_VirtualPoint_Path_DMXDevice;
        }

        public Point2D calculateVirtualPointPath(boolean p_WriteValues) {
            DMXControl_GridPanTilt_DeviceSettings.VirtualPoint_Path_DMXDevice o_VirtualPoint_Path_DMXDevice = this.m_VirtualPoint_Path_DMXDevice;
            if (o_VirtualPoint_Path_DMXDevice != null) {
                if (o_VirtualPoint_Path_DMXDevice.calculate_VirtualPointPath(this.m_Point2D_Angles_Filled) == null) {
                    return null;
                }
            } else {
                return null;
            }
            DMXDevice o_DMXDevice = this.m_DMXDevice;
            if (o_DMXDevice == null) {
                return null;
            }
            DMXControl_GridPanTilt o_DMXControl_GridPanTilt = (DMXControl_GridPanTilt)o_DMXDevice.getDMXControlComponentByDescriptionFirst("pantilt");
            if (o_DMXControl_GridPanTilt == null) {
                return null;
            }
            DMXControlComponent.DMXControlType o_DMXControlType = o_DMXControl_GridPanTilt.getDMXControlType();
            if (o_DMXControlType == null) {
                return null;
            }
            if (!p_WriteValues) {
                return this.m_Point2D_Angles_Filled;
            }
            for (int intControlType = 0; intControlType < o_DMXControlType.getControlTypeCount(); ++intControlType) {
                DMXControlComponent.ControlType o_ControlType = o_DMXControlType.getControlType(intControlType);
                if (o_ControlType == null) continue;
                for (int intDimensionType = 0; intDimensionType < o_ControlType.getControlDimensionTypeCount(); ++intDimensionType) {
                    DMXControlComponent.ControlDimensionType o_ControlDimensionType = o_ControlType.getControlDimensionType(intDimensionType);
                    if (o_ControlDimensionType == null) continue;
                    for (int intLink = 0; intLink < o_ControlDimensionType.getDeviceControlLinkCount(); ++intLink) {
                        DMXControlComponent.DeviceControlLink o_DeviceControlLink = o_ControlDimensionType.getDeviceControlLink(intLink);
                        if (o_DeviceControlLink == null) continue;
                        if (intDimensionType == 0) {
                            o_DeviceControlLink.setValueScene(this.m_Point2D_Angles_Filled.getX(), this);
                        }
                        if (intDimensionType != 1) continue;
                        o_DeviceControlLink.setValueScene(this.m_Point2D_Angles_Filled.getY(), this);
                    }
                }
            }
            return this.m_Point2D_Angles_Filled;
        }

        public double calculateFadeFactor(DMXFadeDescription.DMXControlTypeFadeDescription p_DMXControlTypeFadeDescription, double p_FadeProgress, boolean p_FadeIn, boolean p_FadeOut) {
            double doubleFadeFactor = 1.0;
            double doubleFadeProgressStart = 0.0;
            double doubleFadeProgressEnd = 1.0;
            if (p_FadeIn) {
                doubleFadeProgressStart = p_DMXControlTypeFadeDescription.getFadeIn_Start();
                doubleFadeProgressEnd = p_DMXControlTypeFadeDescription.getFadeIn_End();
            } else if (p_FadeOut) {
                doubleFadeProgressStart = 1.0f - p_DMXControlTypeFadeDescription.getFadeOut_End();
                doubleFadeProgressEnd = 1.0f - p_DMXControlTypeFadeDescription.getFadeOut_Start();
            }
            if (doubleFadeProgressStart == doubleFadeProgressEnd) {
                doubleFadeFactor = p_FadeProgress == doubleFadeProgressStart ? (p_FadeIn ? 0.0 : 1.0) : (p_FadeProgress < doubleFadeProgressStart ? 0.0 : 1.0);
            } else {
                double doubleFadeLength = doubleFadeProgressEnd - doubleFadeProgressStart;
                doubleFadeFactor = p_FadeProgress <= doubleFadeProgressStart ? 0.0 : (p_FadeProgress >= doubleFadeProgressEnd ? 1.0 : (p_FadeProgress - doubleFadeProgressStart) / doubleFadeLength);
            }
            return doubleFadeFactor;
        }

        public double calculateNewValue(DMXControlComponent.DeviceControlLink p_DeviceControlLink, double p_ValueScene, double p_VolumeFactor, DMXFadeDescription.DMXControlTypeFadeDescription p_DMXControlTypeFadeDescription, double p_FadeFactor, boolean p_FadeIn, boolean p_FadeOut) {
            double doubleValueNew;
            double doubleValueEnd;
            double doubleValueStart;
            double doubleVolumeFactor = 1.0;
            DMXControlComponent.DMXControlType o_DMXControlType = p_DMXControlTypeFadeDescription.getDMXControlType();
            if (o_DMXControlType.getIsDimmer() || o_DMXControlType.getIsDimmerSubstitute()) {
                doubleVolumeFactor = p_VolumeFactor;
            }
            if (doubleVolumeFactor == 0.0) {
                return 0.0;
            }
            if (p_FadeFactor == 0.0) {
                return 0.0;
            }
            if (p_FadeFactor == 1.0) {
                return (long)(p_ValueScene * doubleVolumeFactor);
            }
            int intControlIndex = p_DeviceControlLink.getControlTypeIndex();
            int intDimensionIndex = p_DeviceControlLink.getControlDimensionTypeIndex();
            if (p_FadeIn) {
                doubleValueStart = p_DMXControlTypeFadeDescription.getFadeValue(0, 0, intControlIndex, intDimensionIndex);
                doubleValueEnd = p_DMXControlTypeFadeDescription.getFadeValue(0, 1, intControlIndex, intDimensionIndex);
            } else {
                doubleValueStart = p_DMXControlTypeFadeDescription.getFadeValue(1, 0, intControlIndex, intDimensionIndex);
                doubleValueEnd = p_DMXControlTypeFadeDescription.getFadeValue(1, 1, intControlIndex, intDimensionIndex);
            }
            if (p_FadeIn) {
                if (doubleValueEnd > p_ValueScene) {
                    doubleValueEnd = p_ValueScene;
                }
                if (doubleValueStart > p_ValueScene) {
                    doubleValueStart = p_ValueScene;
                }
                doubleValueNew = doubleValueStart + (doubleValueEnd - doubleValueStart) * p_FadeFactor;
            } else {
                if (doubleValueStart > p_ValueScene) {
                    doubleValueStart = p_ValueScene;
                }
                if (doubleValueEnd > p_ValueScene) {
                    doubleValueEnd = p_ValueScene;
                }
                p_FadeFactor = 1.0 - p_FadeFactor;
                doubleValueNew = doubleValueStart + (doubleValueEnd - doubleValueStart) * p_FadeFactor;
            }
            return doubleValueNew * doubleVolumeFactor;
        }

        public void mixDMXSceneBridgePlayObjects(DMXSceneDeviceValues p_DMXSceneDeviceValues, double p_FadeOutProgress) {
            DMXControl_GridPanTilt_DeviceSettings.VirtualPoint_Path_DMXDevice o_VirtualPoint_Path_DMXDevice;
            if (this.m_DMXDevice == null) {
                return;
            }
            DMXDeviceType o_DMXDeviceType = this.m_DMXDevice.getDMXDeviceType();
            if (o_DMXDeviceType == null) {
                return;
            }
            DMXControl_GridPanTilt_DeviceSettings.VirtualPoint o_VirtualPoint = p_DMXSceneDeviceValues.getVirtualPoint_PanTilt();
            if (o_VirtualPoint != null && (o_VirtualPoint_Path_DMXDevice = this.m_VirtualPoint_Path_DMXDevice) != null) {
                o_VirtualPoint_Path_DMXDevice.addVirtualPoint_Read(o_VirtualPoint, p_FadeOutProgress, 0);
            }
            for (int intDMXControlType = 0; intDMXControlType < o_DMXDeviceType.getDMXControlTypeCount(); ++intDMXControlType) {
                DMXControlComponent.DMXControlType o_DMXControlType = o_DMXDeviceType.getDMXControlType(intDMXControlType);
                if (o_DMXDeviceType == null) continue;
                for (int intControlType = 0; intControlType < o_DMXControlType.getControlTypeCount(); ++intControlType) {
                    DMXControlComponent.ControlType o_ControlType = o_DMXControlType.getControlType(intControlType);
                    if (o_ControlType == null) continue;
                    for (int intDimensionType = 0; intDimensionType < o_ControlType.getControlDimensionTypeCount(); ++intDimensionType) {
                        DMXControlComponent.ControlDimensionType o_ControlDimensionType = o_ControlType.getControlDimensionType(intDimensionType);
                        if (o_ControlDimensionType == null) continue;
                        for (int intLink = 0; intLink < o_ControlDimensionType.getDeviceControlLinkCount(); ++intLink) {
                            DMXControlComponent.DeviceControlLink o_DeviceControlLink = o_ControlDimensionType.getDeviceControlLink(intLink);
                            if (o_DeviceControlLink == null) continue;
                            double doubleValueOutside = o_DeviceControlLink.getValueScene(p_DMXSceneDeviceValues);
                            double doubleValueSelf = o_DeviceControlLink.getValueScene(this);
                            double doubleValueNew = doubleValueSelf < 0.0 && doubleValueOutside < 0.0 ? -2.147483648E9 : (doubleValueSelf < 0.0 ? doubleValueOutside : (doubleValueOutside < 0.0 ? doubleValueSelf : doubleValueOutside + doubleValueSelf));
                            o_DeviceControlLink.setValueScene(doubleValueNew, this);
                        }
                    }
                }
            }
        }

        public void setFadeInBlackout(boolean p_FadeInBlackot) {
            this.m_FadeInBlackout = p_FadeInBlackot;
        }

        public boolean getFadeInBlackout() {
            return this.m_FadeInBlackout;
        }

        public void mixInJingle(DMXSceneDeviceValues p_DMXSceneDeviceValues, boolean p_Reset) {
            if (this.m_DMXDevice == null) {
                return;
            }
            if (p_DMXSceneDeviceValues == null) {
                return;
            }
            boolean boolPanTiltIsDeactivated = false;
            DMXDeviceType o_DMXDeviceType = this.m_DMXDevice.getDMXDeviceType();
            if (o_DMXDeviceType == null) {
                return;
            }
            DMXControl_GridPanTilt_DeviceSettings.VirtualPoint_Path_DMXDevice o_VirtualPoint_Path_DMXDevice = this.m_VirtualPoint_Path_DMXDevice;
            if (p_Reset) {
                if (o_VirtualPoint_Path_DMXDevice != null) {
                    o_VirtualPoint_Path_DMXDevice.clearVirtualPoints_Read();
                    o_VirtualPoint_Path_DMXDevice.clearVirtualPoint_Calculated_Temp();
                    o_VirtualPoint_Path_DMXDevice.setCalculationCount(0);
                }
                this.m_FadeIn = false;
                this.m_FadeOut = false;
            }
            boolean boolDMXDeviceIsOn = p_DMXSceneDeviceValues.isDimmerOn();
            double doubleFadeFactorOutside = p_DMXSceneDeviceValues.getFadeProgress();
            if (p_DMXSceneDeviceValues.getFadeIn()) {
                this.m_FadeIn = p_DMXSceneDeviceValues.getFadeIn();
            }
            if (p_DMXSceneDeviceValues.getFadeOut()) {
                this.m_FadeOut = p_DMXSceneDeviceValues.getFadeOut();
            }
            boolean boolFadeInBlackout = s_JingleFadeInBlackout;
            boolean boolMovableControlsDeactivated = true;
            boolean boolDimmerDeactivated = true;
            boolPanTiltIsDeactivated = false;
            double doubleFadeFactorPanTilt = 0.0;
            for (int intDMXControlType = 0; intDMXControlType < o_DMXDeviceType.getDMXControlTypeCount(); ++intDMXControlType) {
                DMXControlComponent.DMXControlType o_DMXControlType = o_DMXDeviceType.getDMXControlType(intDMXControlType);
                if (o_DMXDeviceType == null) continue;
                for (int intControlType = 0; intControlType < o_DMXControlType.getControlTypeCount(); ++intControlType) {
                    DMXControlComponent.ControlType o_ControlType = o_DMXControlType.getControlType(intControlType);
                    if (o_ControlType == null) continue;
                    for (int intDimensionType = 0; intDimensionType < o_ControlType.getControlDimensionTypeCount(); ++intDimensionType) {
                        DMXControlComponent.ControlDimensionType o_ControlDimensionType = o_ControlType.getControlDimensionType(intDimensionType);
                        if (o_ControlDimensionType == null) continue;
                        for (int intLink = 0; intLink < o_ControlDimensionType.getDeviceControlLinkCount(); ++intLink) {
                            double doubleFadeFactorNew;
                            double doubleValueNew;
                            double doubleFadeFactorSelf;
                            double doubleValueSelf;
                            DMXControlComponent.DeviceControlLink o_DeviceControlLink = o_ControlDimensionType.getDeviceControlLink(intLink);
                            if (o_DeviceControlLink == null) continue;
                            double doubleValueOutside = o_DeviceControlLink.getValueScene(p_DMXSceneDeviceValues);
                            if (p_Reset) {
                                doubleValueSelf = -2.147483648E9;
                                doubleFadeFactorSelf = 0.0;
                            } else {
                                doubleValueSelf = o_DeviceControlLink.getValueScene(this);
                                doubleFadeFactorSelf = o_DeviceControlLink.getFadeValue(this);
                            }
                            if (!boolDMXDeviceIsOn) {
                                if (!o_DMXControlType.getIsDimmer() && !o_DMXControlType.getIsDimmerSubstitute()) {
                                    doubleValueOutside = -2.147483648E9;
                                }
                                boolPanTiltIsDeactivated = true;
                                boolFadeInBlackout = false;
                            }
                            if (doubleValueSelf < 0.0 && doubleValueOutside < 0.0) {
                                doubleValueNew = -2.147483648E9;
                                doubleFadeFactorNew = 0.0;
                                if (o_DMXControlType.getDMXControlDescription().getID() == "pantilt") {
                                    doubleFadeFactorPanTilt = doubleFadeFactorSelf;
                                    boolPanTiltIsDeactivated = true;
                                }
                            } else if (doubleValueSelf < 0.0) {
                                doubleValueNew = doubleValueOutside;
                                doubleFadeFactorNew = doubleFadeFactorOutside;
                                this.setFadeProgress(doubleFadeFactorOutside);
                                if (boolMovableControlsDeactivated && DMXControlDescription.MOVABLECONTROLS_IDS.contains(o_DMXControlType.getDMXControlDescription().getID())) {
                                    boolMovableControlsDeactivated = false;
                                }
                                if (boolDimmerDeactivated && (o_DMXControlType.getIsDimmer() || o_DMXControlType.getIsDimmerSubstitute())) {
                                    boolDimmerDeactivated = false;
                                }
                            } else if (doubleValueOutside < 0.0) {
                                doubleValueNew = doubleValueSelf;
                                doubleFadeFactorNew = doubleFadeFactorSelf;
                                if (o_DMXControlType.getDMXControlDescription().getID() == "pantilt") {
                                    doubleFadeFactorPanTilt = doubleFadeFactorSelf;
                                    boolPanTiltIsDeactivated = true;
                                }
                            } else {
                                doubleValueNew = doubleValueSelf * (1.0 - doubleFadeFactorOutside) + doubleValueOutside;
                                doubleFadeFactorPanTilt = doubleFadeFactorSelf;
                                doubleFadeFactorNew = doubleFadeFactorOutside > doubleFadeFactorSelf ? doubleFadeFactorOutside : doubleFadeFactorSelf;
                                this.setFadeProgress(doubleFadeFactorOutside);
                                if (boolMovableControlsDeactivated && DMXControlDescription.MOVABLECONTROLS_IDS.contains(o_DMXControlType.getDMXControlDescription().getID())) {
                                    boolMovableControlsDeactivated = false;
                                }
                                if (boolDimmerDeactivated && (o_DMXControlType.getIsDimmer() || o_DMXControlType.getIsDimmerSubstitute())) {
                                    boolDimmerDeactivated = false;
                                }
                            }
                            o_DeviceControlLink.setValueScene(doubleValueNew, this);
                            o_DeviceControlLink.setFadeValue(doubleFadeFactorNew, this);
                        }
                    }
                }
                if (boolPanTiltIsDeactivated || !(doubleFadeFactorOutside > 0.0) || !"pantilt".equals(o_DMXControlType.getDMXControlDescription().getID())) continue;
                p_DMXSceneDeviceValues.calculateVirtualPointPath(false);
                if (p_DMXSceneDeviceValues.getVirtualPoint_Path_DMXDevice() == null) continue;
                DMXControl_GridPanTilt_DeviceSettings.VirtualPoint o_VirtualPoint = p_DMXSceneDeviceValues.getVirtualPoint_Path_DMXDevice().getVirtualPoint_Calculated();
                if (o_VirtualPoint_Path_DMXDevice == null) continue;
                if (o_VirtualPoint_Path_DMXDevice.getVirtualPoint_ReadCount() > 0) {
                    o_VirtualPoint_Path_DMXDevice.clearVirtualPoints_Read();
                }
                o_VirtualPoint_Path_DMXDevice.addVirtualPoint_Read(o_VirtualPoint_Path_DMXDevice.getVirtualPoint_Calculated_Temp(), doubleFadeFactorPanTilt, -1);
                o_VirtualPoint_Path_DMXDevice.addVirtualPoint_Read(o_VirtualPoint, doubleFadeFactorOutside, -1);
                o_VirtualPoint_Path_DMXDevice.setFadeProgress_Read(0, 1.0 - doubleFadeFactorOutside);
                Point2D o_Point2D = this.calculateVirtualPointPath(true);
                o_VirtualPoint_Path_DMXDevice.setVirtualPoint_Calculated_Temp(o_VirtualPoint_Path_DMXDevice.getVirtualPoint_Calculated());
                if (o_Point2D != null || o_VirtualPoint_Path_DMXDevice.getCalculationCount() <= 1) continue;
                o_VirtualPoint_Path_DMXDevice.clearVirtualPoints_Read();
            }
            if (boolDimmerDeactivated) {
                boolFadeInBlackout = false;
            }
            if (boolMovableControlsDeactivated) {
                boolFadeInBlackout = false;
            }
            this.setFadeInBlackout(boolFadeInBlackout);
        }

        public void setFadeProgress(double p_FadeProgress) {
            this.m_FadeProgress = p_FadeProgress;
            if (this.m_DMXSceneValueContainer != null) {
                this.m_DMXSceneValueContainer.setFadeProgress(p_FadeProgress);
            }
        }

        public double getFadeProgress() {
            if (this.m_DMXSceneValueContainer != null) {
                this.m_FadeProgress = this.m_DMXSceneValueContainer.getFadeProgress();
            }
            return this.m_FadeProgress;
        }

        public void setOverwriteManualValues(boolean p_Overwrite) {
            this.m_OverwriteManualValues = p_Overwrite;
            if (this.m_DMXSceneValueContainer != null) {
                this.m_DMXSceneValueContainer.setOverwriteManualValues(p_Overwrite);
            }
        }

        public boolean getOverwriteManualValues() {
            if (this.m_DMXSceneValueContainer != null) {
                this.m_OverwriteManualValues = this.m_DMXSceneValueContainer.getOverwriteManualValues();
            }
            return this.m_OverwriteManualValues;
        }

        public void setOverwriteManualDMXEffect(boolean p_Overwrite, DMXControlComponent.DMXControlType p_DMXControlType) {
            Boolean o_Overwrite = this.m_OverwriteManualDMXEffect.get(p_DMXControlType);
            if (o_Overwrite != null) {
                this.m_OverwriteManualDMXEffect.put(p_DMXControlType, p_Overwrite);
                return;
            }
            if (p_Overwrite) {
                this.m_OverwriteManualDMXEffect.put(p_DMXControlType, p_Overwrite);
            }
        }

        public boolean getOverwriteManualDMXEffect(DMXControlComponent.DMXControlType p_DMXControlType) {
            Boolean o_Overwrite = this.m_OverwriteManualDMXEffect.get(p_DMXControlType);
            if (o_Overwrite == null) {
                return false;
            }
            return o_Overwrite;
        }

        public void setFlagMixSource(int p_FlagMixSource) {
            this.m_FlagMixSource = p_FlagMixSource;
            if (this.m_DMXSceneValueContainer != null) {
                this.m_DMXSceneValueContainer.setFlagMixSource(p_FlagMixSource);
            }
        }

        public int getFlagMixSource() {
            if (this.m_DMXSceneValueContainer != null) {
                this.m_FlagMixSource = this.m_DMXSceneValueContainer.getFlagMixSource();
            }
            return this.m_FlagMixSource;
        }

        public static boolean mixMain(DMXDevice p_DMXDevice, DMXSceneDeviceValues p_DMXSceneDeviceValues) {
            DMXControl_GridPanTilt_DeviceSettings.VirtualPoint o_VirtualPoint_Calculated;
            DMXSceneValueContainer o_DMXSceneValueContainer;
            if (p_DMXDevice == null) {
                return false;
            }
            if (p_DMXSceneDeviceValues == null) {
                return false;
            }
            boolean boolValuesChanged = false;
            boolean boolTimelineValuesChangeByMixer = false;
            boolean boolJingleValuesChangeByMixer = false;
            Point2D o_Point2D_Angles = null;
            DMXSceneDeviceValues o_DMXSceneDeviceValues_Main = s_DMXSceneValueContainer_Main.getDMXSceneDeviceValues(p_DMXDevice.getID());
            if (o_DMXSceneDeviceValues_Main == null) {
                return false;
            }
            DMXSceneDeviceValues o_DMXSceneDeviceValues_Timeline = s_DMXSceneValueContainer_Timeline.getDMXSceneDeviceValues(p_DMXDevice.getID());
            if (o_DMXSceneDeviceValues_Timeline == null) {
                return false;
            }
            DMXSceneDeviceValues o_DMXSceneDeviceValues_TimelineDiff = s_DMXSceneValueContainer_TimelineDiff.getDMXSceneDeviceValues(p_DMXDevice.getID());
            if (o_DMXSceneDeviceValues_TimelineDiff == null) {
                return false;
            }
            DMXSceneDeviceValues o_DMXSceneDeviceValues_JingleSum = s_DMXSceneValueContainer_JingleSum.getDMXSceneDeviceValues(p_DMXDevice.getID());
            if (o_DMXSceneDeviceValues_JingleSum == null) {
                return false;
            }
            DMXSceneDeviceValues o_DMXSceneDeviceValues_JingleDiff = s_DMXSceneValueContainer_JingleDiff.getDMXSceneDeviceValues(p_DMXDevice.getID());
            if (o_DMXSceneDeviceValues_JingleDiff == null) {
                return false;
            }
            DMXSceneDeviceValues o_DMXSceneDeviceValues_JingleStart = s_DMXSceneValueContainer_JingleStart.getDMXSceneDeviceValues(p_DMXDevice.getID());
            if (o_DMXSceneDeviceValues_JingleStart == null) {
                return false;
            }
            DMXSceneDeviceValues o_DMXSceneDeviceValues_MixerControls = s_DMXSceneValueContainer_Mixer.getDMXSceneDeviceValues(p_DMXDevice.getID());
            if (o_DMXSceneDeviceValues_MixerControls == null) {
                return false;
            }
            DMXControl_GridPanTilt_DeviceSettings.VirtualPoint_Path_DMXDevice o_VirtualPoint_Path_DMXDevice_Main = o_DMXSceneDeviceValues_Main.getVirtualPoint_Path_DMXDevice();
            switch (p_DMXSceneDeviceValues.getFlagMixSource()) {
                case 1: {
                    break;
                }
                case 0: {
                    o_DMXSceneDeviceValues_Timeline.setOverwriteManualValues(p_DMXSceneDeviceValues.getOverwriteManualValues());
                    o_DMXSceneValueContainer = o_DMXSceneDeviceValues_Timeline.getDMXSceneValueContainer();
                    if (o_DMXSceneValueContainer != null) {
                        o_DMXSceneValueContainer.setFadeProgress(p_DMXSceneDeviceValues.getDMXSceneValueContainer().getFadeProgress());
                    }
                    Point2D o_Point2D_Calculated = p_DMXSceneDeviceValues.calculateVirtualPointPath(true);
                    if (o_DMXSceneDeviceValues_Timeline.getVirtualPoint_Path_DMXDevice() == null || p_DMXSceneDeviceValues.getVirtualPoint_Path_DMXDevice() == null) break;
                    o_VirtualPoint_Calculated = p_DMXSceneDeviceValues.getVirtualPoint_Path_DMXDevice().getVirtualPoint_Calculated();
                    o_DMXSceneDeviceValues_Timeline.setVirtualPoint_PanTilt(o_VirtualPoint_Calculated);
                }
            }
            if (s_JingleActive && o_DMXSceneDeviceValues_JingleSum.getVirtualPoint_Path_DMXDevice() != null) {
                o_VirtualPoint_Calculated = o_DMXSceneDeviceValues_JingleSum.getVirtualPoint_Path_DMXDevice().getVirtualPoint_Calculated();
                o_DMXSceneDeviceValues_JingleSum.setVirtualPoint_PanTilt(o_VirtualPoint_Calculated);
            }
            boolean boolTimelineOverwriteManual = o_DMXSceneDeviceValues_Timeline.getOverwriteManualValues();
            DMXDeviceType o_DMXDeviceType = p_DMXDevice.getDMXDeviceType();
            if (o_DMXDeviceType == null) {
                return false;
            }
            for (int intDMXControlType = 0; intDMXControlType < o_DMXDeviceType.getDMXControlTypeCount(); ++intDMXControlType) {
                DMXControlComponent.ControlDimensionType o_ControlDimensionType;
                DMXControlComponent.ControlType o_ControlType;
                DMXControlComponent.DMXControlType o_DMXControlType = o_DMXDeviceType.getDMXControlType(intDMXControlType);
                if (o_DMXControlType == null || o_DMXControlType.getIsDisabledInFunctions() && (o_DMXSceneValueContainer = p_DMXSceneDeviceValues.getDMXSceneValueContainer()) != null && o_DMXSceneValueContainer.getDMXScene() != null) continue;
                boolean boolDisabledInJingle = false;
                boolean boolDisabledInTimeline = false;
                double doubleJingleProgress_PanTilt = 0.0;
                boolTimelineValuesChangeByMixer = false;
                boolJingleValuesChangeByMixer = false;
                for (int intControlType = 0; intControlType < o_DMXControlType.getControlTypeCount(); ++intControlType) {
                    o_ControlType = o_DMXControlType.getControlType(intControlType);
                    if (o_ControlType == null) continue;
                    for (int intDimensionType = 0; intDimensionType < o_ControlType.getControlDimensionTypeCount(); ++intDimensionType) {
                        o_ControlDimensionType = o_ControlType.getControlDimensionType(intDimensionType);
                        if (o_ControlDimensionType == null) continue;
                        for (int intLink = 0; intLink < o_ControlDimensionType.getDeviceControlLinkCount(); ++intLink) {
                            double doubleValueDiff;
                            double doubleValue;
                            DMXControlComponent.DeviceControlLink o_DeviceControlLink = o_ControlDimensionType.getDeviceControlLink(intLink);
                            if (o_DeviceControlLink == null) continue;
                            double doubleValueMainOld = o_DeviceControlLink.getValueScene(o_DMXSceneDeviceValues_Main);
                            switch (p_DMXSceneDeviceValues.getFlagMixSource()) {
                                case 0: {
                                    doubleValue = o_DeviceControlLink.getValueScene(p_DMXSceneDeviceValues);
                                    o_DeviceControlLink.setValueScene(doubleValue, o_DMXSceneDeviceValues_Timeline);
                                    break;
                                }
                                case 1: {
                                    doubleValue = o_DeviceControlLink.getValueScene(p_DMXSceneDeviceValues);
                                    o_DeviceControlLink.setValueScene(doubleValue, o_DMXSceneDeviceValues_MixerControls);
                                    break;
                                }
                                case 2: {
                                    break;
                                }
                                default: {
                                    return false;
                                }
                            }
                            if (s_JingleActive_Changed && s_JingleActive) {
                                doubleValue = o_DeviceControlLink.getValueScene(o_DMXSceneDeviceValues_MixerControls);
                                o_DeviceControlLink.setValueScene(doubleValue, o_DMXSceneDeviceValues_JingleStart);
                            }
                            double doubleValueMainNew = doubleValueMainOld;
                            double doubleValueTimeline = o_DeviceControlLink.getValueScene(o_DMXSceneDeviceValues_Timeline);
                            double doubleValueJingle = o_DeviceControlLink.getValueScene(o_DMXSceneDeviceValues_JingleSum);
                            double doubleValueMixer = o_DeviceControlLink.getValueScene(o_DMXSceneDeviceValues_MixerControls);
                            boolean booleanValueMixerChangedManually = o_DeviceControlLink.getValueSetManually(o_DMXSceneDeviceValues_MixerControls);
                            switch (p_DMXSceneDeviceValues.getFlagMixSource()) {
                                case 0: {
                                    if (boolTimelineOverwriteManual) {
                                        o_DeviceControlLink.setValueScene(0.0, o_DMXSceneDeviceValues_TimelineDiff);
                                    }
                                    if (!p_DMXSceneDeviceValues.getOverwriteManualDMXEffect(o_DMXControlType)) break;
                                    o_DeviceControlLink.setValueScene(0.0, o_DMXSceneDeviceValues_TimelineDiff);
                                    break;
                                }
                                case 1: {
                                    if (!s_JingleActive) {
                                        if (doubleValueTimeline >= 0.0 && booleanValueMixerChangedManually) {
                                            doubleValueDiff = doubleValueMixer - doubleValueTimeline;
                                            o_DeviceControlLink.setValueScene(doubleValueDiff, o_DMXSceneDeviceValues_TimelineDiff);
                                        }
                                    } else if (doubleValueJingle >= 0.0 && booleanValueMixerChangedManually) {
                                        doubleValueDiff = doubleValueMixer - doubleValueJingle;
                                        o_DeviceControlLink.setValueScene(doubleValueDiff, o_DMXSceneDeviceValues_JingleDiff);
                                    }
                                    o_DeviceControlLink.setValueSetManually(o_DMXSceneDeviceValues_MixerControls, false);
                                    break;
                                }
                            }
                            if (s_JingleActive_Changed || o_DMXSceneDeviceValues_JingleSum.getOverwriteManualDMXEffect(o_DMXControlType)) {
                                o_DeviceControlLink.setValueScene(0.0, o_DMXSceneDeviceValues_JingleDiff);
                            }
                            if (doubleValueTimeline >= 0.0) {
                                doubleValueDiff = o_DeviceControlLink.getValueScene(o_DMXSceneDeviceValues_TimelineDiff);
                                if (doubleValueDiff != 0.0) {
                                    boolTimelineValuesChangeByMixer = true;
                                    doubleValueTimeline += doubleValueDiff;
                                }
                            } else {
                                boolDisabledInTimeline = true;
                            }
                            if (s_JingleActive) {
                                if (doubleValueJingle >= 0.0) {
                                    doubleValueDiff = o_DeviceControlLink.getValueScene(o_DMXSceneDeviceValues_JingleDiff);
                                    if (doubleValueDiff != 0.0) {
                                        boolJingleValuesChangeByMixer = true;
                                        doubleValueJingle += doubleValueDiff;
                                    }
                                } else {
                                    boolDisabledInJingle = true;
                                }
                            } else {
                                doubleValueJingle = 0.0;
                                boolDisabledInJingle = true;
                            }
                            if (s_JingleActive) {
                                double doubleJingleProgress = o_DeviceControlLink.getFadeValue(o_DMXSceneDeviceValues_JingleSum);
                                if (doubleValueJingle >= 0.0 && doubleValueTimeline >= 0.0) {
                                    doubleValueMainNew = doubleValueTimeline * (1.0 - doubleJingleProgress) + doubleValueJingle;
                                } else if (doubleValueJingle >= 0.0) {
                                    double doubleValueJingleStart = o_DeviceControlLink.getValueScene(o_DMXSceneDeviceValues_JingleStart);
                                    doubleValueMainNew = doubleValueJingleStart * (1.0 - doubleJingleProgress) + doubleValueJingle;
                                } else {
                                    doubleValueMainNew = doubleValueTimeline >= 0.0 ? doubleValueTimeline : doubleValueMixer;
                                }
                                if ((o_DMXControlType.getIsDimmer() || o_DMXControlType.getIsDimmerSubstitute()) && o_DMXSceneDeviceValues_JingleSum.getFadeInBlackout() && (o_DMXSceneDeviceValues_JingleSum.getFadeIn() || o_DMXSceneDeviceValues_JingleSum.getFadeOut()) && o_DMXSceneDeviceValues_JingleSum.getFadeProgress() != 0.0 && o_DMXSceneDeviceValues_JingleSum.getFadeProgress() != 1.0) {
                                    doubleValueMainNew = 0.0;
                                }
                                if (!boolDisabledInJingle && "pantilt".equals(o_DMXControlType.getDMXControlDescription().getID())) {
                                    doubleJingleProgress_PanTilt = doubleJingleProgress;
                                }
                            } else {
                                doubleValueMainNew = doubleValueTimeline >= 0.0 ? doubleValueTimeline : doubleValueMixer;
                            }
                            if (doubleValueMainOld == doubleValueMainNew) continue;
                            o_DeviceControlLink.setValueScene(doubleValueMainNew, o_DMXSceneDeviceValues_Main);
                            boolValuesChanged = true;
                        }
                    }
                }
                if (!boolDisabledInJingle && !boolDisabledInTimeline && "pantilt".equals(o_DMXControlType.getDMXControlDescription().getID()) && s_JingleActive) {
                    if (o_VirtualPoint_Path_DMXDevice_Main != null) {
                        o_VirtualPoint_Path_DMXDevice_Main.clearVirtualPoints_Read();
                        o_VirtualPoint_Path_DMXDevice_Main.setCalculationCount(0);
                    }
                    if (o_DMXSceneDeviceValues_JingleSum.getFadeIn() || o_DMXSceneDeviceValues_JingleSum.getFadeOut()) {
                        double doubleValueY;
                        DMXControl_GridPanTilt_DeviceSettings.VirtualPoint o_VirtualPoint_Timeline = o_DMXSceneDeviceValues_Timeline.getVirtualPoint_PanTilt();
                        DMXControl_GridPanTilt_DeviceSettings.VirtualPoint o_VirtualPoint_Jingle = o_DMXSceneDeviceValues_JingleSum.getVirtualPoint_PanTilt();
                        if (boolTimelineValuesChangeByMixer && o_VirtualPoint_Timeline != null) {
                            if ((o_Point2D_Angles = DMXControl_GridPanTilt_DeviceSettings.calculateAnglesFromVirtualPoint(o_Point2D_Angles, p_DMXDevice, o_VirtualPoint_Timeline)) != null) {
                                o_ControlType = o_DMXControlType.getControlType(0);
                                o_ControlDimensionType = o_ControlType.getControlDimensionType(0);
                                double doubleValueX = o_Point2D_Angles.getX() + o_DMXSceneDeviceValues_TimelineDiff.getValueDMXDevice(o_ControlDimensionType);
                                o_ControlDimensionType = o_ControlType.getControlDimensionType(1);
                                doubleValueY = o_Point2D_Angles.getY() + o_DMXSceneDeviceValues_TimelineDiff.getValueDMXDevice(o_ControlDimensionType);
                                o_VirtualPoint_Timeline = DMXControl_GridPanTilt_DeviceSettings.calculateVirtualPointFromAnglesBilinear(s_VirtualPoint_Timeline, p_DMXDevice, doubleValueX, doubleValueY, false);
                            } else {
                                o_VirtualPoint_Timeline = null;
                            }
                        }
                        if (boolJingleValuesChangeByMixer && o_VirtualPoint_Jingle != null) {
                            if ((o_Point2D_Angles = DMXControl_GridPanTilt_DeviceSettings.calculateAnglesFromVirtualPoint(o_Point2D_Angles, p_DMXDevice, o_VirtualPoint_Jingle)) != null) {
                                o_ControlType = o_DMXControlType.getControlType(0);
                                o_ControlDimensionType = o_ControlType.getControlDimensionType(0);
                                double doubleValueX = o_Point2D_Angles.getX() + o_DMXSceneDeviceValues_JingleDiff.getValueDMXDevice(o_ControlDimensionType);
                                o_ControlDimensionType = o_ControlType.getControlDimensionType(1);
                                doubleValueY = o_Point2D_Angles.getY() + o_DMXSceneDeviceValues_JingleDiff.getValueDMXDevice(o_ControlDimensionType);
                                o_VirtualPoint_Jingle = DMXControl_GridPanTilt_DeviceSettings.calculateVirtualPointFromAnglesBilinear(s_VirtualPoint_Jingle, p_DMXDevice, doubleValueX, doubleValueY, false);
                            } else {
                                o_VirtualPoint_Jingle = null;
                            }
                        }
                        if (o_DMXSceneDeviceValues_JingleSum.getFadeIn()) {
                            o_VirtualPoint_Path_DMXDevice_Main.addVirtualPoint_Read(o_VirtualPoint_Timeline, 1.0 - doubleJingleProgress_PanTilt, -1);
                            o_VirtualPoint_Path_DMXDevice_Main.addVirtualPoint_Read(o_VirtualPoint_Jingle, doubleJingleProgress_PanTilt, -1);
                            o_DMXSceneDeviceValues_Main.calculateVirtualPointPath(true);
                            boolValuesChanged = true;
                        } else if (o_DMXSceneDeviceValues_JingleSum.getFadeOut()) {
                            o_VirtualPoint_Path_DMXDevice_Main.addVirtualPoint_Read(o_VirtualPoint_Timeline, 1.0 - doubleJingleProgress_PanTilt, -1);
                            o_VirtualPoint_Path_DMXDevice_Main.addVirtualPoint_Read(o_VirtualPoint_Jingle, doubleJingleProgress_PanTilt, -1);
                            o_DMXSceneDeviceValues_Main.calculateVirtualPointPath(true);
                            boolValuesChanged = true;
                        }
                    }
                }
                if (p_DMXSceneDeviceValues.getFlagMixSource() != 0 && p_DMXSceneDeviceValues.getFlagMixSource() != 2) continue;
                p_DMXSceneDeviceValues.setOverwriteManualDMXEffect(false, o_DMXControlType);
            }
            return boolValuesChanged;
        }
    }

    public static class DMXSceneValueContainer
    implements Externalizable,
    PropertyChangeListener {
        public static final int SOFTWAREVERSION = 1;
        protected HashMap<String, DMXSceneDeviceValues> m_DMXSceneDeviceHashMap;
        protected DMXScene m_DMXScene;
        protected double m_FadeProgress;
        protected double m_FadeInProgress;
        protected double m_FadeOutProgress;
        protected int m_FlagMixSource;
        protected boolean m_OverwriteManualValues;

        public DMXSceneValueContainer(DMXScene p_DMXScene) {
            this.m_DMXScene = p_DMXScene;
            this.initMembers();
        }

        public DMXSceneValueContainer(DMXScene p_DMXScene, int p_FlagMixSource) {
            this.m_DMXScene = p_DMXScene;
            this.initMembers();
            this.m_FlagMixSource = p_FlagMixSource;
        }

        private void initMembers() {
            this.m_FadeProgress = 0.0;
            this.m_FadeInProgress = 0.0;
            this.m_FadeOutProgress = 0.0;
            this.m_DMXSceneDeviceHashMap = new HashMap();
            for (int intDMXDevice = 0; intDMXDevice < DMXDevice.getDMXDeviceCount(); ++intDMXDevice) {
                DMXDevice o_DMXDevice = DMXDevice.getDMXDevice(intDMXDevice);
                this.addDMXDevice(o_DMXDevice);
            }
            DMXDevice.getTreeModel_Device_Channels().addPropertyChangeListener(this);
            this.m_FlagMixSource = -1;
            this.m_OverwriteManualValues = false;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(1);
            Object[] o_HashMapValues = this.m_DMXSceneDeviceHashMap.values().toArray();
            int intDMXSceneValuesCount = o_HashMapValues.length;
            out.writeInt(intDMXSceneValuesCount);
            for (int intSceneValues = 0; intSceneValues < intDMXSceneValuesCount; ++intSceneValues) {
                DMXSceneDeviceValues o_DMXSceneDeviceValues = (DMXSceneDeviceValues)o_HashMapValues[intSceneValues];
                o_DMXSceneDeviceValues.writeExternal(out);
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int intSoftwareVersion = in.readInt();
            int intDMXSceneValuesCount = in.readInt();
            for (int intSceneValues = 0; intSceneValues < intDMXSceneValuesCount; ++intSceneValues) {
                DMXSceneDeviceValues o_DMXSceneDeviceValues = new DMXSceneDeviceValues(this);
                o_DMXSceneDeviceValues.readExternal(in);
                DMXDevice o_DMXDevice = o_DMXSceneDeviceValues.getDMXDevice();
                if (o_DMXDevice == null) {
                    o_DMXSceneDeviceValues.close();
                    continue;
                }
                this.m_DMXSceneDeviceHashMap.put(o_DMXDevice.getID(), o_DMXSceneDeviceValues);
            }
        }

        public void clone(DMXSceneValueContainer p_DMXSceneValueContainer) {
            for (String stringDMXDeviceID : this.m_DMXSceneDeviceHashMap.keySet()) {
                DMXSceneDeviceValues o_DMXSceneDeviceValues = this.getDMXSceneDeviceValues(stringDMXDeviceID);
                DMXSceneDeviceValues o_DestDMXSceneDeviceValues = p_DMXSceneValueContainer.getDMXSceneDeviceValues(stringDMXDeviceID);
                if (o_DMXSceneDeviceValues == null || o_DestDMXSceneDeviceValues == null) continue;
                o_DMXSceneDeviceValues.clone(o_DestDMXSceneDeviceValues);
            }
        }

        public long getDiskSpaceEstimated() {
            long longBytesCount = 0L;
            Object[] o_HashMapValues = this.m_DMXSceneDeviceHashMap.values().toArray();
            int intDMXSceneValuesCount = o_HashMapValues.length;
            longBytesCount += 4L;
            longBytesCount += 4L;
            for (int intSceneValues = 0; intSceneValues < intDMXSceneValuesCount; ++intSceneValues) {
                DMXSceneDeviceValues o_DMXSceneDeviceValues = (DMXSceneDeviceValues)o_HashMapValues[intSceneValues];
                longBytesCount = o_DMXSceneDeviceValues.getDiskSpaceEstimated();
            }
            return longBytesCount;
        }

        public void close() {
            DMXDevice.getTreeModel_Device_Channels().removePropertyChangeListener(this);
            if (this.m_DMXSceneDeviceHashMap != null) {
                Object[] o_HashMapValues = this.m_DMXSceneDeviceHashMap.values().toArray();
                int intDMXSceneValuesCount = o_HashMapValues.length;
                for (int intSceneValues = intDMXSceneValuesCount - 1; intSceneValues >= 0; --intSceneValues) {
                    DMXSceneDeviceValues o_DMXSceneDeviceValues = (DMXSceneDeviceValues)o_HashMapValues[intSceneValues];
                    this.removeDMXSceneDeviceValues(o_DMXSceneDeviceValues);
                }
            }
        }

        public DMXScene getDMXScene() {
            return this.m_DMXScene;
        }

        public int getFlagMixSource() {
            return this.m_FlagMixSource;
        }

        public void setFlagMixSource(int p_FlagMixSource) {
            this.m_FlagMixSource = p_FlagMixSource;
        }

        public void setFadeProgress(double p_FadeProgress) {
            this.m_FadeProgress = p_FadeProgress;
        }

        public double getFadeProgress() {
            return this.m_FadeProgress;
        }

        public void setFadeInProgress(double p_FadeProgress) {
            this.m_FadeInProgress = p_FadeProgress;
        }

        public double getFadeInProgress() {
            return this.m_FadeInProgress;
        }

        public void setFadeOutProgress(double p_FadeProgress) {
            this.m_FadeOutProgress = p_FadeProgress;
        }

        public double getFadeOutProgress() {
            return this.m_FadeOutProgress;
        }

        public void setOverwriteManualValues(boolean p_Overwrite) {
            this.m_OverwriteManualValues = p_Overwrite;
        }

        public boolean getOverwriteManualValues() {
            return this.m_OverwriteManualValues;
        }

        public int getDeviceCount() {
            return this.m_DMXSceneDeviceHashMap.size();
        }

        public void addDMXSceneDeviceValues(DMXSceneDeviceValues p_DMXSceneDeviceValues) {
            if (p_DMXSceneDeviceValues == null) {
                return;
            }
            DMXDevice o_DMXDevice = p_DMXSceneDeviceValues.getDMXDevice();
            if (o_DMXDevice == null) {
                return;
            }
            DMXSceneDeviceValues o_DMXSceneDeviceValues = this.m_DMXSceneDeviceHashMap.get(o_DMXDevice.getID());
            if (o_DMXSceneDeviceValues != null) {
                if (o_DMXSceneDeviceValues == p_DMXSceneDeviceValues) {
                    return;
                }
                return;
            }
            this.m_DMXSceneDeviceHashMap.put(o_DMXDevice.getID(), p_DMXSceneDeviceValues);
            o_DMXDevice.addPropertyChangeListener("dmxdeviceDMXDeviceType", this);
        }

        public void removeDMXSceneDeviceValues(DMXSceneDeviceValues p_DMXSceneDeviceValues) {
            if (p_DMXSceneDeviceValues == null) {
                return;
            }
            DMXDevice o_DMXDevice = p_DMXSceneDeviceValues.getDMXDevice();
            if (o_DMXDevice == null) {
                return;
            }
            DMXSceneDeviceValues o_DMXSceneDeviceValues = this.m_DMXSceneDeviceHashMap.get(o_DMXDevice.getID());
            if (o_DMXSceneDeviceValues != p_DMXSceneDeviceValues) {
                return;
            }
            o_DMXDevice.removePropertyChangeListener("dmxdeviceDMXDeviceType", this);
            this.m_DMXSceneDeviceHashMap.remove(o_DMXDevice.getID());
            o_DMXSceneDeviceValues.close();
        }

        public DMXSceneDeviceValues addDMXDevice(DMXDevice p_DMXDevice) {
            if (p_DMXDevice == null) {
                return null;
            }
            DMXSceneDeviceValues o_DMXSceneDeviceValues = this.m_DMXSceneDeviceHashMap.get(p_DMXDevice.getID());
            if (o_DMXSceneDeviceValues != null) {
                o_DMXSceneDeviceValues.setDMXDevice(p_DMXDevice);
            } else {
                o_DMXSceneDeviceValues = new DMXSceneDeviceValues(this);
                o_DMXSceneDeviceValues.setDMXDevice(p_DMXDevice);
                this.addDMXSceneDeviceValues(o_DMXSceneDeviceValues);
            }
            return o_DMXSceneDeviceValues;
        }

        public DMXSceneDeviceValues removeDMXDevice(DMXDevice p_DMXDevice) {
            if (p_DMXDevice == null) {
                return null;
            }
            DMXScene o_DMXScene = this.m_DMXScene;
            DMXSceneDeviceValues o_DMXSceneDeviceValues = this.m_DMXSceneDeviceHashMap.get(p_DMXDevice.getID());
            if (o_DMXSceneDeviceValues != null) {
                this.removeDMXSceneDeviceValues(o_DMXSceneDeviceValues);
            }
            if (o_DMXScene != null) {
                o_DMXScene.externalChanged();
            }
            return o_DMXSceneDeviceValues;
        }

        public DMXSceneDeviceValues refreshDMXDevice(DMXDevice p_DMXDevice) {
            if (p_DMXDevice == null) {
                return null;
            }
            DMXSceneDeviceValues o_DMXSceneDeviceValues = this.m_DMXSceneDeviceHashMap.get(p_DMXDevice.getID());
            if (o_DMXSceneDeviceValues != null) {
                o_DMXSceneDeviceValues.setDMXDevice(p_DMXDevice);
            }
            return o_DMXSceneDeviceValues;
        }

        public void fillPlayObject_DMXObject(LiveShowDMXObject p_LiveShowDMXObject, DMXSceneValueContainer p_DMXSceneValueContainer, float p_VolumeFactor, double p_FadeProgress, boolean p_FadeIn, boolean p_FadeOut) {
            DMXFadeDescription o_DMXFadeDescription = null;
            o_DMXFadeDescription = p_LiveShowDMXObject.getDMXFadeDescription();
            int intDMXDeviceCount = DMXDevice.getDMXDeviceCount();
            for (int intDMXDevice = 0; intDMXDevice < intDMXDeviceCount; ++intDMXDevice) {
                DMXDevice o_DMXDevice = DMXDevice.getDMXDevice(intDMXDevice);
                if (o_DMXDevice == null) continue;
                this.fillPlayObject(o_DMXDevice, p_DMXSceneValueContainer, p_VolumeFactor, p_LiveShowDMXObject, o_DMXFadeDescription, p_FadeProgress, p_FadeIn, p_FadeOut);
            }
        }

        public void fillPlayObject_DMXSceneBridgePre(LiveShowDMXSceneBridge p_LiveShowDMXSceneBridge, ArrayList<LiveShowDMXObject> p_LiveShowDMXObjectsLastRead, DMXSceneValueContainer p_DMXSceneValueContainer, float p_VolumeFactor, double p_FadeProgress, boolean p_FadeIn, boolean p_FadeOut) {
            DMXFadeDescription o_DMXFadeDescription = null;
            o_DMXFadeDescription = p_LiveShowDMXSceneBridge.getDMXFadeDescription();
            int intDMXDeviceCount = DMXDevice.getDMXDeviceCount();
            for (int intDMXDevice = 0; intDMXDevice < intDMXDeviceCount; ++intDMXDevice) {
                DMXDevice o_DMXDevice = DMXDevice.getDMXDevice(intDMXDevice);
                if (o_DMXDevice == null) continue;
                o_DMXFadeDescription = p_LiveShowDMXSceneBridge.getDMXFadeDescription();
                for (int intDMXObject = 0; intDMXObject < p_LiveShowDMXObjectsLastRead.size(); ++intDMXObject) {
                    LiveShowDMXObject o_LiveShowDMXObject = p_LiveShowDMXObjectsLastRead.get(intDMXObject);
                    DMXScene o_DMXScene = o_LiveShowDMXObject.getDMXScene();
                    if (o_DMXScene == null || !o_DMXScene.isDimmerOn(o_DMXDevice)) continue;
                    o_DMXFadeDescription = o_LiveShowDMXObject.getDMXFadeDescription();
                    break;
                }
                this.fillPlayObject(o_DMXDevice, p_DMXSceneValueContainer, p_VolumeFactor, p_LiveShowDMXSceneBridge, o_DMXFadeDescription, p_FadeProgress, p_FadeIn, p_FadeOut);
            }
        }

        public boolean fillPlayObject(DMXDevice p_DMXDevice, DMXSceneValueContainer p_DMXSceneValueContainer, float p_VolumeFactor, LiveShowObject p_LiveShowObject, DMXFadeDescription p_DMXFadeDescription, double p_FadeProgress, boolean p_FadeIn, boolean p_FadeOut) {
            if (p_DMXDevice == null) {
                return false;
            }
            DMXSceneDeviceValues o_DMXSceneDeviceValues = this.getDMXSceneDeviceValues(p_DMXDevice.getID());
            if (o_DMXSceneDeviceValues == null) {
                return false;
            }
            DMXSceneDeviceValues o_DMXSceneDeviceValuesFrom = p_DMXSceneValueContainer.getDMXSceneDeviceValues(p_DMXDevice.getID());
            if (o_DMXSceneDeviceValuesFrom == null) {
                return false;
            }
            o_DMXSceneDeviceValues.fillPlayObject(true, o_DMXSceneDeviceValuesFrom, p_LiveShowObject, p_VolumeFactor, p_DMXFadeDescription, p_FadeProgress, p_FadeIn, p_FadeOut);
            return true;
        }

        public void setPanTilt_VirtualPointFromAngles() {
            int intDMXDeviceCount = DMXDevice.getDMXDeviceCount();
            for (int intDMXDevice = 0; intDMXDevice < intDMXDeviceCount; ++intDMXDevice) {
                DMXDevice o_DMXDevice = DMXDevice.getDMXDevice(intDMXDevice);
                if (o_DMXDevice == null) continue;
                this.setPanTilt_VirtualPointFromAngles(o_DMXDevice);
            }
        }

        public void setPanTilt_VirtualPointFromAngles(DMXDevice p_DMXDevice) {
            DMXSceneDeviceValues o_DMXSceneDeviceValues = this.getDMXSceneDeviceValues(p_DMXDevice.getID());
            if (o_DMXSceneDeviceValues == null) {
                return;
            }
            o_DMXSceneDeviceValues.setPanTilt_VirtualPointFromAngles();
        }

        public void clearDMXSceneLight(Playable p_Playable) {
            int intDMXDeviceCount = DMXDevice.getDMXDeviceCount();
            for (int intDMXDevice = 0; intDMXDevice < intDMXDeviceCount; ++intDMXDevice) {
                DMXDevice o_DMXDevice = DMXDevice.getDMXDevice(intDMXDevice);
                if (o_DMXDevice == null) continue;
                this.clearDMXSceneLight(o_DMXDevice, p_Playable);
            }
        }

        public void clearDMXSceneLight(DMXDevice p_DMXDevice, Playable p_Playable) {
            if (p_DMXDevice == null) {
                return;
            }
            DMXSceneDeviceValues o_DMXSceneDeviceValues = this.m_DMXSceneDeviceHashMap.get(p_DMXDevice.getID());
            if (o_DMXSceneDeviceValues == null && (o_DMXSceneDeviceValues = this.addDMXDevice(p_DMXDevice)) == null) {
                return;
            }
            o_DMXSceneDeviceValues.clear(p_Playable);
        }

        public void saveDMXSceneLight() {
            for (int intDMXDevice = 0; intDMXDevice < DMXDevice.getDMXDeviceCount(); ++intDMXDevice) {
                DMXDevice o_DMXDevice = DMXDevice.getDMXDevice(intDMXDevice);
                if (o_DMXDevice == null) continue;
                this.saveDMXSceneLight(o_DMXDevice);
            }
            this.writeDMXSceneLight();
        }

        public void saveDMXSceneLight(DMXDevice p_DMXDevice) {
            if (p_DMXDevice == null) {
                return;
            }
            DMXSceneDeviceValues o_DMXSceneDeviceValues = this.m_DMXSceneDeviceHashMap.get(p_DMXDevice.getID());
            if (o_DMXSceneDeviceValues == null && (o_DMXSceneDeviceValues = this.addDMXDevice(p_DMXDevice)) == null) {
                return;
            }
            if (!LiveShowDMXVIP.EDITMODEON) {
                o_DMXSceneDeviceValues.saveDMXDeviceValues(p_DMXDevice);
            } else {
                o_DMXSceneDeviceValues.saveDMXDeviceValues_EditMode(p_DMXDevice);
            }
        }

        public void cleanUpDMXSceneLight() {
            for (int intDMXDevice = 0; intDMXDevice < DMXDevice.getDMXDeviceCount(); ++intDMXDevice) {
                DMXDevice o_DMXDevice = DMXDevice.getDMXDevice(intDMXDevice);
                if (o_DMXDevice == null) continue;
                this.cleanUpDMXSceneLight(o_DMXDevice);
            }
        }

        public void cleanUpDMXSceneLight(DMXDevice p_DMXDevice) {
            if (p_DMXDevice == null) {
                return;
            }
            DMXSceneDeviceValues o_DMXSceneDeviceValues = this.m_DMXSceneDeviceHashMap.get(p_DMXDevice.getID());
            if (o_DMXSceneDeviceValues == null && (o_DMXSceneDeviceValues = this.addDMXDevice(p_DMXDevice)) == null) {
                return;
            }
            if (o_DMXSceneDeviceValues.isDimmerOn()) {
                return;
            }
            o_DMXSceneDeviceValues.cleanUpDMXDeviceValues(p_DMXDevice);
            if (!LiveShowDMXVIP.EDITMODEON) {
                // empty if block
            }
        }

        public void writeDMXSceneLight() {
            if (!LiveShowVIP.EDITMODEON) {
                boolean boolOldOverwrite = this.getOverwriteManualValues();
                this.setOverwriteManualValues(true);
                DMXScene.mixMain(this);
                this.setOverwriteManualValues(boolOldOverwrite);
                DMXScene.writeMainMixToChannels(false);
            } else {
                this.writeDMXSceneToChannels_EditMode();
            }
        }

        public void writeDMXSceneToChannels_EditMode() {
            int intDMXDeviceCount = DMXDevice.getDMXDeviceCount();
            for (int intDMXDevice = 0; intDMXDevice < intDMXDeviceCount; ++intDMXDevice) {
                DMXDevice o_DMXDevice = DMXDevice.getDMXDevice(intDMXDevice);
                if (o_DMXDevice == null) continue;
                DMXSceneDeviceValues o_DMXSceneDeviceValues = this.m_DMXSceneDeviceHashMap.get(o_DMXDevice.getID());
                if (o_DMXSceneDeviceValues == null && (o_DMXSceneDeviceValues = this.addDMXDevice(o_DMXDevice)) == null) {
                    return;
                }
                o_DMXSceneDeviceValues.writeDMXSceneToChannels_EditMode();
            }
        }

        public void writeDMXSceneToChannels(boolean p_ManuallySet) {
            int intDMXDeviceCount = DMXDevice.getDMXDeviceCount();
            for (int intDMXDevice = 0; intDMXDevice < intDMXDeviceCount; ++intDMXDevice) {
                DMXDevice o_DMXDevice = DMXDevice.getDMXDevice(intDMXDevice);
                if (o_DMXDevice == null) continue;
                DMXSceneDeviceValues o_DMXSceneDeviceValues = this.m_DMXSceneDeviceHashMap.get(o_DMXDevice.getID());
                if (o_DMXSceneDeviceValues == null && (o_DMXSceneDeviceValues = this.addDMXDevice(o_DMXDevice)) == null) {
                    return;
                }
                o_DMXSceneDeviceValues.writeDMXSceneToChannels(false, p_ManuallySet);
            }
            for (int intUniverse = 1; intUniverse < DMXUniverse.getDMXUniverseCount(); ++intUniverse) {
                DMXUniverse o_DMXUniverse = DMXUniverse.getDMXUniverse(intUniverse);
                if (o_DMXUniverse == null) continue;
                o_DMXUniverse.callDMXOutput_WriteChannels();
            }
        }

        public void mixDMXSceneBridgePlayObjects(DMXSceneValueContainer p_DMXSceneValueContainer, double p_FadeOutProgress) {
            if (p_DMXSceneValueContainer == null) {
                return;
            }
            int intDMXDeviceCount = DMXDevice.getDMXDeviceCount();
            for (int intDMXDevice = 0; intDMXDevice < intDMXDeviceCount; ++intDMXDevice) {
                DMXSceneDeviceValues o_DMXSceneDeviceValues;
                DMXSceneDeviceValues o_DMXSceneDeviceValues_Line;
                DMXDevice o_DMXDevice = DMXDevice.getDMXDevice(intDMXDevice);
                if (o_DMXDevice == null || (o_DMXSceneDeviceValues_Line = this.getDMXSceneDeviceValues(o_DMXDevice.getID())) == null || (o_DMXSceneDeviceValues = p_DMXSceneValueContainer.getDMXSceneDeviceValues(o_DMXDevice.getID())) == null) continue;
                o_DMXSceneDeviceValues_Line.mixDMXSceneBridgePlayObjects(o_DMXSceneDeviceValues, p_FadeOutProgress);
            }
        }

        public void mixInJingle(DMXSceneValueContainer p_DMXSceneValueContainer, boolean p_Reset) {
            if (p_DMXSceneValueContainer == null) {
                return;
            }
            int intDMXDeviceCount = DMXDevice.getDMXDeviceCount();
            for (int intDMXDevice = 0; intDMXDevice < intDMXDeviceCount; ++intDMXDevice) {
                DMXSceneDeviceValues o_DMXSceneDeviceValues;
                DMXSceneDeviceValues o_DMXSceneDeviceValues_JingleSum;
                DMXDevice o_DMXDevice = DMXDevice.getDMXDevice(intDMXDevice);
                if (o_DMXDevice == null || (o_DMXSceneDeviceValues_JingleSum = this.getDMXSceneDeviceValues(o_DMXDevice.getID())) == null || (o_DMXSceneDeviceValues = p_DMXSceneValueContainer.getDMXSceneDeviceValues(o_DMXDevice.getID())) == null) continue;
                o_DMXSceneDeviceValues_JingleSum.mixInJingle(o_DMXSceneDeviceValues, p_Reset);
            }
        }

        public DMXSceneDeviceValues getDMXSceneDeviceValues(String p_DeviceID) {
            DMXSceneDeviceValues o_DMXSceneDeviceValues = this.m_DMXSceneDeviceHashMap.get(p_DeviceID);
            if (o_DMXSceneDeviceValues == null) {
                DMXDevice o_DMXDevice = DMXDevice.getDMXDevice(p_DeviceID);
                if (o_DMXDevice == null) {
                    return null;
                }
                this.addDMXDevice(o_DMXDevice);
            }
            return this.m_DMXSceneDeviceHashMap.get(p_DeviceID);
        }

        DMXControl_GridPanTilt_DeviceSettings.VirtualPoint getVirtualPoint_PanTilt(DMXDevice p_DMXDevice) {
            if (p_DMXDevice == null) {
                return null;
            }
            DMXSceneDeviceValues o_DMXSceneDeviceValues = this.getDMXSceneDeviceValues(p_DMXDevice.getID());
            if (o_DMXSceneDeviceValues == null) {
                return null;
            }
            return o_DMXSceneDeviceValues.getVirtualPoint_PanTilt();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() instanceof DMXDevice) {
                if ("dmxdeviceDMXDeviceType".equals(evt.getPropertyName())) {
                    DMXDevice o_DMXDevice = (DMXDevice)evt.getSource();
                    this.refreshDMXDevice(o_DMXDevice);
                }
            } else if (evt.getSource() instanceof DMXDevice.TreeModel_Device_Channels) {
                if ("dmxdevicetreemodelDMXDeviceRemoved".equals(evt.getPropertyName())) {
                    DMXDevice o_DMXDevice = (DMXDevice)evt.getOldValue();
                    this.removeDMXDevice(o_DMXDevice);
                } else if ("dmxdevicetreemodelDMXDeviceAdded".equals(evt.getPropertyName())) {
                    DMXDevice o_DMXDevice = (DMXDevice)evt.getNewValue();
                    this.addDMXDevice(o_DMXDevice);
                }
            }
        }
    }
}

