/*
 * Decompiled with CFR 0.152.
 */
package DMXMixer;

import DMXDevicePackage.DMXDevice;
import DMXDevicePackage.DMXPresets;
import DMXGraphics.LiveShowDMXStageView;
import DMXMixer.DMXControlComponent;
import DMXMixer.DMXControl_GridPanTilt;
import DMXMixer.DMXControl_RGB;
import GraphicsDeviceToolsPackage.GraphicsDeviceTools;
import LiveShowControlModels.ControlLabelModel;
import LiveShowControlObjects.ControlObject;
import LiveShowControlObjects.ValueSelectionInterface;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.ArrayList;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultRowSorter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableRowSorter;

public class DMXValueSelection
extends JDialog {
    public static Icon s_Icon = new ImageIcon(DMXValueSelection.class.getResource("/IconsPackage/Slider.png"));
    public static Dimension s_Dimension_Normal = new Dimension(350, 370);
    public static DMXValueSelection s_DMXValueSelection = new DMXValueSelection(null, false);
    private DMXControlComponent m_DMXControlComponent;
    private ValueSelectionInterface m_ValueSelectionInterface;
    private ControlObject m_ControlObject;
    private ArrayList<ControlObject.ControlDimension> m_ControlDimensions;
    private ControlLabelModel.ControlLabelList m_ControlLabelList;
    private ArrayList<Double> m_ActualValues;
    private ArrayList<RowSorter.SortKey> m_SortKeys;
    private ArrayList<DMXDevice> m_DMXDevices;
    private Dimension m_PreferredSize;
    private JButton jButton_Cancel;
    private JButton jButton_Save;
    private JColorChooser jColorChooser2;
    private JList jList_Labels;
    private JPanel jPanel1;
    private JPanel jPanel_ColorChooser;
    private JPanel jPanel_DMXControlLabels;
    private JPanel jPanel_Presets;
    private JScrollPane jScrollPane_DMXPresets;
    private JScrollPane jScrollPane_Labels;
    private JTable jTable_DMXPresets;

    public static DMXValueSelection getDMXValueSelection() {
        if (s_DMXValueSelection == null) {
            s_DMXValueSelection = new DMXValueSelection(null, false);
        }
        return s_DMXValueSelection;
    }

    public static void show(DMXPresets p_DMXPresets, ArrayList<DMXDevice> p_DMXDevices, int p_X, int p_Y) {
        DMXValueSelection o_DMXValueSelection = DMXValueSelection.getDMXValueSelection();
        o_DMXValueSelection.showSelection(p_DMXPresets, p_DMXDevices, p_X, p_Y);
    }

    public static void show(DMXControlComponent p_DMXControlComponent, ValueSelectionInterface p_ValueSelectionInterface, ArrayList<ControlObject.ControlDimension> p_ControlDimensions, int p_X, int p_Y) {
        DMXPresets o_DMXPresets = null;
        if (p_DMXControlComponent != null) {
            o_DMXPresets = DMXPresets.getDMXPresets(p_DMXControlComponent.getDMXControlType().getDMXControlDescription().getID());
        }
        DMXValueSelection o_DMXValueSelection = DMXValueSelection.getDMXValueSelection();
        o_DMXValueSelection.showSelection(o_DMXPresets, p_DMXControlComponent, p_ValueSelectionInterface, p_ControlDimensions, p_X, p_Y);
    }

    public DMXValueSelection(Frame parent, boolean modal) {
        super(parent, modal);
        this.initMembers();
        this.initComponents();
        this.initComponentsFurther();
    }

    private void initMembers() {
        this.m_DMXDevices = new ArrayList();
        this.m_ActualValues = new ArrayList(1);
        this.m_ActualValues.add(0.0);
        this.m_SortKeys = new ArrayList();
        RowSorter.SortKey o_SortKey = new RowSorter.SortKey(0, SortOrder.ASCENDING);
        this.m_SortKeys.add(o_SortKey);
        this.m_PreferredSize = new Dimension();
        this.m_PreferredSize.setSize(s_Dimension_Normal);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jPanel_Presets = new JPanel();
        this.jScrollPane_DMXPresets = new JScrollPane();
        this.jTable_DMXPresets = new JTable();
        this.jPanel_DMXControlLabels = new JPanel();
        this.jScrollPane_Labels = new JScrollPane();
        this.jList_Labels = new JList();
        this.jPanel_ColorChooser = new JPanel();
        this.jColorChooser2 = new JColorChooser();
        this.jButton_Save = new JButton();
        this.jButton_Cancel = new JButton();
        this.setMinimumSize(new Dimension(250, 300));
        this.setPreferredSize(new Dimension(250, 370));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DMXValueSelection.this.closeDialog(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.jPanel1.setBorder(BorderFactory.createLineBorder(Color.gray));
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel_Presets.setForeground(new Color(255, 255, 255));
        this.jPanel_Presets.setMinimumSize(new Dimension(100, 100));
        this.jPanel_Presets.setPreferredSize(new Dimension(100, 100));
        this.jPanel_Presets.setLayout(new GridBagLayout());
        this.jTable_DMXPresets.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTable_DMXPresets.setFillsViewportHeight(true);
        this.jScrollPane_DMXPresets.setViewportView(this.jTable_DMXPresets);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Presets.add((Component)this.jScrollPane_DMXPresets, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jPanel_Presets, gridBagConstraints);
        this.jPanel_DMXControlLabels.setMinimumSize(new Dimension(100, 100));
        this.jPanel_DMXControlLabels.setPreferredSize(new Dimension(100, 100));
        this.jPanel_DMXControlLabels.setLayout(new GridBagLayout());
        this.jList_Labels.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jScrollPane_Labels.setViewportView(this.jList_Labels);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_DMXControlLabels.add((Component)this.jScrollPane_Labels, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jPanel_DMXControlLabels, gridBagConstraints);
        this.jPanel_ColorChooser.setMinimumSize(new Dimension(607, 328));
        this.jPanel_ColorChooser.setName("");
        this.jPanel_ColorChooser.setPreferredSize(new Dimension(607, 366));
        this.jPanel_ColorChooser.setLayout(new GridBagLayout());
        this.jColorChooser2.setMaximumSize(new Dimension(607, 328));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 1, 0);
        this.jPanel_ColorChooser.add((Component)this.jColorChooser2, gridBagConstraints);
        this.jButton_Save.setBackground(new Color(0, 0, 0));
        this.jButton_Save.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Edit_OK.png")));
        this.jButton_Save.setContentAreaFilled(false);
        this.jButton_Save.setIconTextGap(0);
        this.jButton_Save.setMargin(new Insets(0, 0, 0, 0));
        this.jButton_Save.setMaximumSize(new Dimension(32, 32));
        this.jButton_Save.setMinimumSize(new Dimension(32, 32));
        this.jButton_Save.setPreferredSize(new Dimension(32, 32));
        this.jButton_Save.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_Save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DMXValueSelection.this.jButton_SaveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 100, 1, 3);
        this.jPanel_ColorChooser.add((Component)this.jButton_Save, gridBagConstraints);
        this.jButton_Cancel.setBackground(new Color(0, 0, 0));
        this.jButton_Cancel.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Edit_Cancel.png")));
        this.jButton_Cancel.setContentAreaFilled(false);
        this.jButton_Cancel.setIconTextGap(0);
        this.jButton_Cancel.setMargin(new Insets(0, 0, 0, 0));
        this.jButton_Cancel.setMaximumSize(new Dimension(32, 32));
        this.jButton_Cancel.setMinimumSize(new Dimension(32, 32));
        this.jButton_Cancel.setPreferredSize(new Dimension(32, 32));
        this.jButton_Cancel.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_Cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DMXValueSelection.this.jButton_CancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(1, 3, 1, 100);
        this.jPanel_ColorChooser.add((Component)this.jButton_Cancel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jPanel_ColorChooser, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.pack();
    }

    private void initComponentsFurther() {
        this.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
            }

            @Override
            public void windowLostFocus(WindowEvent e) {
                DMXValueSelection.this.setVisible(false);
            }
        });
        this.setMinimumSize(s_Dimension_Normal);
        this.setIconImage(((ImageIcon)s_Icon).getImage());
        this.jPanel_Presets.setVisible(false);
        this.jScrollPane_DMXPresets.getViewport().setBackground(Color.BLACK);
        this.jTable_DMXPresets.getColumnModel().getColumn(1).setMinWidth(0);
        this.jTable_DMXPresets.getColumnModel().getColumn(1).setMaxWidth(0);
        this.jTable_DMXPresets.setRowHeight(30);
        this.jTable_DMXPresets.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                DMXPresets.DMXPresetTableModel o_DMXPresetTableModel;
                DMXPresets.DMXPreset o_DMXPreset;
                int intRow = DMXValueSelection.this.jTable_DMXPresets.rowAtPoint(e.getPoint());
                if (DMXValueSelection.this.jTable_DMXPresets.getModel() instanceof DMXPresets.DMXPresetTableModel && intRow >= 0 && (o_DMXPreset = (o_DMXPresetTableModel = (DMXPresets.DMXPresetTableModel)DMXValueSelection.this.jTable_DMXPresets.getModel()).getDMXPreset(intRow = DMXValueSelection.this.jTable_DMXPresets.convertRowIndexToModel(intRow))) != null) {
                    if (DMXValueSelection.this.m_DMXControlComponent == null) {
                        o_DMXPreset.writeValues(DMXValueSelection.this.m_DMXDevices, null);
                    } else {
                        DMXDevice o_DMXDevice = DMXValueSelection.this.m_DMXControlComponent.getLinkedDMXDevice(0);
                        if (o_DMXDevice == null) {
                            return;
                        }
                        LiveShowDMXStageView.s_SelfReference.getSelectedDMXDevices(DMXValueSelection.this.m_DMXDevices);
                        if (!DMXValueSelection.this.m_DMXDevices.contains(o_DMXDevice)) {
                            DMXValueSelection.this.m_DMXDevices.clear();
                            DMXValueSelection.this.m_DMXDevices.add(o_DMXDevice);
                        }
                        o_DMXPreset.writeValues(DMXValueSelection.this.m_DMXDevices, DMXValueSelection.this.m_DMXControlComponent.getDMXControlDescriptionID());
                    }
                }
                DMXValueSelection.this.setVisible(false);
            }
        });
        this.jPanel_DMXControlLabels.setVisible(true);
        this.jList_Labels.setCellRenderer(new ControlLabelModel.ControlLabelDescriptionCellRenderer());
        this.jList_Labels.setFixedCellHeight(30);
        this.jList_Labels.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ControlLabelModel.ControlLabelDescription o_ControlLabelDescription = (ControlLabelModel.ControlLabelDescription)DMXValueSelection.this.jList_Labels.getSelectedValue();
                if (o_ControlLabelDescription != null) {
                    double doubleValue = o_ControlLabelDescription.getValueDefault();
                    DMXValueSelection.this.m_ActualValues.set(0, doubleValue);
                    if (DMXValueSelection.this.m_ValueSelectionInterface != null) {
                        DMXValueSelection.this.m_ValueSelectionInterface.setValuesSelected(DMXValueSelection.this.m_ActualValues, DMXValueSelection.this.m_ControlDimensions);
                    }
                }
                DMXValueSelection.this.setVisible(false);
            }
        });
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
    }

    private void jButton_SaveActionPerformed(ActionEvent evt) {
        if (this.m_DMXControlComponent instanceof DMXControl_RGB) {
            DMXControl_RGB o_DMXControl_RGB = (DMXControl_RGB)this.m_DMXControlComponent;
            if (this.m_ValueSelectionInterface != null) {
                o_DMXControl_RGB.setColor(this.m_ValueSelectionInterface, this.jColorChooser2.getColor());
            }
        }
        this.setVisible(false);
    }

    private void jButton_CancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    public void showSelection(DMXPresets p_DMXPresets, ArrayList<DMXDevice> p_DMXDevices, int p_X, int p_Y) {
        if (p_DMXPresets == null || p_DMXPresets.getDMXPresetCount() <= 0) {
            return;
        }
        this.jPanel_Presets.setVisible(true);
        this.jPanel_DMXControlLabels.setVisible(false);
        this.jPanel_ColorChooser.setVisible(false);
        this.m_DMXControlComponent = null;
        this.m_DMXDevices.clear();
        this.m_DMXDevices.addAll(p_DMXDevices);
        DMXPresets.DMXPresetTableModel o_TableModel = p_DMXPresets.getTableModel();
        TableRowSorter o_TableRowSorter_Devices = p_DMXPresets.getTableRowSorter_Devices();
        DMXPresets.DMXPresetsRowFilter o_DMXPresetsRowFilter_Devices = p_DMXPresets.getDMXPresetsRowFilter_Devices();
        this.jTable_DMXPresets.setModel(o_TableModel);
        o_TableModel.finishJTable(this.jTable_DMXPresets, o_TableRowSorter_Devices, o_DMXPresetsRowFilter_Devices);
        o_TableModel.filter(p_DMXDevices);
        this.jTable_DMXPresets.getColumnModel().getColumn(1).setMinWidth(0);
        this.jTable_DMXPresets.getColumnModel().getColumn(1).setMaxWidth(0);
        this.jTable_DMXPresets.setRowHeight(30);
        this.jScrollPane_DMXPresets.setColumnHeader(null);
        this.jTable_DMXPresets.setTableHeader(null);
        this.m_PreferredSize.setSize(s_Dimension_Normal);
        this.setSize(this.m_PreferredSize);
        this.setLocation(p_X, p_Y);
        this.setVisible(true);
    }

    public void showSelection(DMXPresets p_DMXPresets, DMXControlComponent p_DMXControlComponent, ValueSelectionInterface p_ValueSelectionInterface, ArrayList<ControlObject.ControlDimension> p_ControlDimensions, int p_X, int p_Y) {
        DefaultRowSorter o_TableRowSorter_Devices = null;
        DMXPresets.DMXPresetsRowFilter o_DMXPresetsRowFilter = null;
        boolean boolShowPresets = false;
        boolean boolShowDMXControlLabels = false;
        boolean boolShowColorChooser = false;
        this.m_DMXDevices.clear();
        if (p_DMXPresets != null && p_DMXPresets.getDMXPresetCount() > 0) {
            if (p_DMXControlComponent == null || p_DMXControlComponent.getLinkedDMXDeviceCount() != 1) {
                boolShowPresets = false;
            } else {
                boolShowPresets = true;
                LiveShowDMXStageView.getDMXDevices(false, this.m_DMXDevices);
                DMXPresets.DMXPresetTableModel o_TableModel = p_DMXPresets.getTableModel();
                o_TableRowSorter_Devices = p_DMXPresets.getTableRowSorter_Devices();
                o_DMXPresetsRowFilter = p_DMXPresets.getDMXPresetsRowFilter_Devices();
                this.jTable_DMXPresets.setModel(p_DMXPresets.getTableModel());
                o_TableModel.finishJTable(this.jTable_DMXPresets, (TableRowSorter)o_TableRowSorter_Devices, o_DMXPresetsRowFilter);
                o_TableModel.filter(this.m_DMXDevices);
                this.jTable_DMXPresets.getColumnModel().getColumn(1).setMinWidth(0);
                this.jTable_DMXPresets.getColumnModel().getColumn(1).setMaxWidth(0);
                this.jTable_DMXPresets.setRowHeight(30);
                this.jScrollPane_DMXPresets.setColumnHeader(null);
                this.jTable_DMXPresets.setTableHeader(null);
            }
        }
        if (p_DMXControlComponent == null || p_ControlDimensions == null || p_ControlDimensions.size() <= 0 || p_ValueSelectionInterface == null) {
            boolShowDMXControlLabels = false;
            boolShowColorChooser = false;
        } else {
            this.m_DMXControlComponent = p_DMXControlComponent;
            this.m_ValueSelectionInterface = p_ValueSelectionInterface;
            this.m_ControlDimensions = p_ControlDimensions;
            this.m_ControlObject = this.m_ControlDimensions.get(0).getControlObject();
            DMXDevice o_DMXDevice = this.m_DMXControlComponent.getLinkedDMXDevice(0);
            if (o_DMXDevice != null) {
                LiveShowDMXStageView.s_SelfReference.getSelectedDMXDevices(this.m_DMXDevices);
                if (!this.m_DMXDevices.contains(o_DMXDevice)) {
                    this.m_DMXDevices.clear();
                    this.m_DMXDevices.add(o_DMXDevice);
                }
            }
            if (this.m_DMXControlComponent instanceof DMXControl_RGB) {
                boolShowColorChooser = true;
                DMXControl_RGB o_DMXControl_RGB = (DMXControl_RGB)this.m_DMXControlComponent;
                this.jColorChooser2.setColor(o_DMXControl_RGB.getColor(this.m_ValueSelectionInterface));
                super.setTitle(p_DMXControlComponent.getName());
            } else if (this.m_DMXControlComponent instanceof DMXControl_GridPanTilt) {
                boolShowColorChooser = false;
                boolShowDMXControlLabels = false;
                super.setTitle(this.m_ControlObject.getName());
            } else {
                boolShowDMXControlLabels = true;
                super.setTitle(this.m_ControlObject.getName());
                this.m_ControlLabelList = this.m_ValueSelectionInterface.getControlLabelListSelected(this.m_ControlDimensions.get(0));
                if (this.m_ControlLabelList != null && this.m_ControlLabelList.getSize() > 0) {
                    ControlObject.ControlDimension o_ControlDimension;
                    if (this.m_ActualValues.size() != this.m_ControlDimensions.size()) {
                        this.m_ActualValues.clear();
                        for (int intDimension = 0; intDimension < this.m_ControlDimensions.size(); ++intDimension) {
                            o_ControlDimension = this.m_ControlDimensions.get(intDimension);
                            this.m_ActualValues.add(o_ControlDimension.getValue());
                        }
                    }
                    for (int intDimension = 0; intDimension < this.m_ControlDimensions.size(); ++intDimension) {
                        o_ControlDimension = this.m_ControlDimensions.get(intDimension);
                        this.m_ActualValues.set(intDimension, o_ControlDimension.getValue());
                    }
                    this.jList_Labels.setModel(this.m_ControlLabelList);
                    ControlLabelModel.ControlLabelDescription o_ControlLabelDescription = this.m_ControlLabelList.getControlLabelDescriptionFromValue(this.m_ActualValues.get(0).doubleValue());
                    int intIndex = this.m_ControlLabelList.getIndexOf(o_ControlLabelDescription);
                    this.jList_Labels.setSelectedIndex(intIndex);
                    this.jList_Labels.ensureIndexIsVisible(intIndex);
                } else {
                    boolShowDMXControlLabels = false;
                }
            }
        }
        if (!(boolShowPresets || boolShowDMXControlLabels || boolShowColorChooser)) {
            return;
        }
        if (boolShowPresets) {
            if (o_DMXPresetsRowFilter != null) {
                o_DMXPresetsRowFilter.setDMXDevices(this.m_DMXDevices);
            }
            if (o_TableRowSorter_Devices != null) {
                o_TableRowSorter_Devices.sort();
            }
        }
        this.jPanel_Presets.setVisible(boolShowPresets);
        this.jPanel_DMXControlLabels.setVisible(boolShowDMXControlLabels);
        this.jPanel_ColorChooser.setVisible(boolShowColorChooser);
        if (!boolShowColorChooser) {
            if (boolShowPresets) {
                this.m_PreferredSize.setSize(DMXValueSelection.s_Dimension_Normal.width + DMXValueSelection.s_Dimension_Normal.width / 2, DMXValueSelection.s_Dimension_Normal.height);
            } else {
                this.m_PreferredSize.setSize(s_Dimension_Normal);
            }
        } else if (boolShowPresets) {
            this.m_PreferredSize.setSize(20 + DMXValueSelection.s_Dimension_Normal.width / 2 + 624, DMXValueSelection.s_Dimension_Normal.height);
        } else {
            this.m_PreferredSize.setSize(644, DMXValueSelection.s_Dimension_Normal.height);
        }
        this.setSize(this.m_PreferredSize);
        this.setLocation(p_X, p_Y);
        this.setVisible(true);
    }

    @Override
    public void setLocation(int p_XOnScreen, int p_YOnScreen) {
        Dimension o_Dimension = this.m_PreferredSize;
        if (o_Dimension == null) {
            o_Dimension = s_Dimension_Normal;
        }
        int intX = p_XOnScreen;
        int intY = p_YOnScreen;
        GraphicsDeviceTools.GraphicsDeviceDescription o_GraphicsDeviceDescription = GraphicsDeviceTools.getGraphicsDeviceDescription(p_XOnScreen, p_YOnScreen);
        if (o_GraphicsDeviceDescription == null) {
            o_GraphicsDeviceDescription = GraphicsDeviceTools.getGraphicsDeviceDescription(0);
        }
        if (o_GraphicsDeviceDescription != null) {
            if (intX < o_GraphicsDeviceDescription.getX()) {
                intX = o_GraphicsDeviceDescription.getX();
            }
            if (intX + o_Dimension.width > o_GraphicsDeviceDescription.getX() + o_GraphicsDeviceDescription.getWidth()) {
                intX = o_GraphicsDeviceDescription.getX() + o_GraphicsDeviceDescription.getWidth() - o_Dimension.width;
            }
            if (intY < o_GraphicsDeviceDescription.getY()) {
                intY = o_GraphicsDeviceDescription.getY();
            }
            if (intY + o_Dimension.height > o_GraphicsDeviceDescription.getY() + o_GraphicsDeviceDescription.getHeight()) {
                intY = o_GraphicsDeviceDescription.getY() + o_GraphicsDeviceDescription.getHeight() - o_Dimension.height;
            }
        }
        super.setLocation(intX, intY);
    }
}

