/*
 * Decompiled with CFR 0.152.
 */
package DMXMixer;

import DMXDeviceEditorPackage.LiveShowDMXDeviceEditor;
import DMXDevicePackage.DMXDeviceType;
import DMXGraphics.LiveShowDMXMixerMainView;
import DMXMixer.DMXControlComponent;
import DMXMixer.DMXControl_Dimmer;
import DMXMixer.DMXMixerPanel;
import FileToolPackage.FileSelection;
import GUID.LiveGUID;
import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LiveShowControlModels.ControlLabelModel;
import StartPackage.LiveShowDMXSystem;
import SwingToolTipPackage.PopUpToolTip;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.AbstractListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.filechooser.FileNameExtensionFilter;

public class DMXMixerPanelControl
extends JPanel
implements DMXMixerPanel.DMXMixerPanelListener {
    private DMXMixerPanel m_SelectedDMXMixerPanel;
    private JButton jButton_AddDMXControl;
    private JButton jButton_ImportDMXControls;
    private JButton jButton_MoveLeftDMXControl;
    private JButton jButton_MoveRightDMXControl;
    private JButton jButton_RemoveDMXControl;
    private JList jList_DMXControlType;
    private JScrollPane jScrollPane2;
    private JToolBar jToolBar_Fader;
    private JToolBar jToolBar_FaderMove;

    public DMXMixerPanelControl() {
        this.initComponents();
        this.initComponentsFurther();
        LiveLanguage.addLanguageListener((Object)this, null);
    }

    private void initMembers() {
        this.m_SelectedDMXMixerPanel = null;
    }

    private void initComponents() {
        this.jScrollPane2 = new JScrollPane();
        this.jList_DMXControlType = new JList();
        this.jToolBar_Fader = new JToolBar();
        this.jButton_AddDMXControl = new JButton();
        this.jButton_ImportDMXControls = new JButton();
        this.jButton_RemoveDMXControl = new JButton();
        this.jToolBar_FaderMove = new JToolBar();
        this.jButton_MoveLeftDMXControl = new JButton();
        this.jButton_MoveRightDMXControl = new JButton();
        this.setLayout(new GridBagLayout());
        this.jScrollPane2.setBorder(null);
        this.jList_DMXControlType.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jList_DMXControlType.setSelectionMode(0);
        this.jScrollPane2.setViewportView(this.jList_DMXControlType);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jScrollPane2, gridBagConstraints);
        this.jToolBar_Fader.setBorder(null);
        this.jToolBar_Fader.setFloatable(false);
        this.jToolBar_Fader.setRollover(true);
        this.jButton_AddDMXControl.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Edit_Plus.png")));
        this.jButton_AddDMXControl.setContentAreaFilled(false);
        this.jButton_AddDMXControl.setFocusable(false);
        this.jButton_AddDMXControl.setHorizontalTextPosition(0);
        this.jButton_AddDMXControl.setMargin(new Insets(-1, -1, -1, -1));
        this.jButton_AddDMXControl.setMaximumSize(new Dimension(32, 32));
        this.jButton_AddDMXControl.setMinimumSize(new Dimension(32, 32));
        this.jButton_AddDMXControl.setPreferredSize(new Dimension(32, 32));
        this.jButton_AddDMXControl.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_AddDMXControl.setVerticalTextPosition(3);
        this.jButton_AddDMXControl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DMXMixerPanelControl.this.jButton_AddDMXControlActionPerformed(evt);
            }
        });
        this.jToolBar_Fader.add(this.jButton_AddDMXControl);
        this.jButton_ImportDMXControls.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Device_Import.png")));
        this.jButton_ImportDMXControls.setContentAreaFilled(false);
        this.jButton_ImportDMXControls.setFocusable(false);
        this.jButton_ImportDMXControls.setHorizontalTextPosition(0);
        this.jButton_ImportDMXControls.setMargin(new Insets(-1, -1, -1, -1));
        this.jButton_ImportDMXControls.setMaximumSize(new Dimension(32, 32));
        this.jButton_ImportDMXControls.setMinimumSize(new Dimension(32, 32));
        this.jButton_ImportDMXControls.setPreferredSize(new Dimension(32, 32));
        this.jButton_ImportDMXControls.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_ImportDMXControls.setVerticalTextPosition(3);
        this.jButton_ImportDMXControls.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DMXMixerPanelControl.this.jButton_ImportDMXControlsActionPerformed(evt);
            }
        });
        this.jToolBar_Fader.add(this.jButton_ImportDMXControls);
        this.jButton_RemoveDMXControl.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Delete.png")));
        this.jButton_RemoveDMXControl.setContentAreaFilled(false);
        this.jButton_RemoveDMXControl.setFocusable(false);
        this.jButton_RemoveDMXControl.setHorizontalTextPosition(0);
        this.jButton_RemoveDMXControl.setMargin(new Insets(-1, -1, -1, -1));
        this.jButton_RemoveDMXControl.setMaximumSize(new Dimension(32, 32));
        this.jButton_RemoveDMXControl.setMinimumSize(new Dimension(32, 32));
        this.jButton_RemoveDMXControl.setPreferredSize(new Dimension(32, 32));
        this.jButton_RemoveDMXControl.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_RemoveDMXControl.setVerticalTextPosition(3);
        this.jButton_RemoveDMXControl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DMXMixerPanelControl.this.jButton_RemoveDMXControlActionPerformed(evt);
            }
        });
        this.jToolBar_Fader.add(this.jButton_RemoveDMXControl);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jToolBar_Fader, gridBagConstraints);
        this.jToolBar_FaderMove.setBorder(null);
        this.jToolBar_FaderMove.setFloatable(false);
        this.jToolBar_FaderMove.setRollover(true);
        this.jButton_MoveLeftDMXControl.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Arrow_Left.png")));
        this.jButton_MoveLeftDMXControl.setContentAreaFilled(false);
        this.jButton_MoveLeftDMXControl.setFocusable(false);
        this.jButton_MoveLeftDMXControl.setHorizontalTextPosition(0);
        this.jButton_MoveLeftDMXControl.setMargin(new Insets(-1, -1, -1, -1));
        this.jButton_MoveLeftDMXControl.setMaximumSize(new Dimension(32, 32));
        this.jButton_MoveLeftDMXControl.setMinimumSize(new Dimension(32, 32));
        this.jButton_MoveLeftDMXControl.setPreferredSize(new Dimension(32, 32));
        this.jButton_MoveLeftDMXControl.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_MoveLeftDMXControl.setVerticalTextPosition(3);
        this.jButton_MoveLeftDMXControl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DMXMixerPanelControl.this.jButton_MoveLeftDMXControlActionPerformed(evt);
            }
        });
        this.jToolBar_FaderMove.add(this.jButton_MoveLeftDMXControl);
        this.jButton_MoveRightDMXControl.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Arrow_Right.png")));
        this.jButton_MoveRightDMXControl.setContentAreaFilled(false);
        this.jButton_MoveRightDMXControl.setFocusable(false);
        this.jButton_MoveRightDMXControl.setHorizontalTextPosition(0);
        this.jButton_MoveRightDMXControl.setMargin(new Insets(-1, -1, -1, -1));
        this.jButton_MoveRightDMXControl.setPreferredSize(new Dimension(32, 32));
        this.jButton_MoveRightDMXControl.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_MoveRightDMXControl.setVerticalTextPosition(3);
        this.jButton_MoveRightDMXControl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DMXMixerPanelControl.this.jButton_MoveRightDMXControlActionPerformed(evt);
            }
        });
        this.jToolBar_FaderMove.add(this.jButton_MoveRightDMXControl);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jToolBar_FaderMove, gridBagConstraints);
    }

    private void initComponentsFurther() {
        this.jList_DMXControlType.setModel(LiveShowDMXSystem.getDMXControlTypeListModel());
        this.jList_DMXControlType.setCellRenderer(new DMXControlComponent.DMXControlTypeCellRenderer());
        this.setDMXMixerPanel(this.m_SelectedDMXMixerPanel);
        this.jButton_AddDMXControl.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_ImportDMXControls.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_MoveLeftDMXControl.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_MoveRightDMXControl.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_RemoveDMXControl.setComponentPopupMenu(PopUpToolTip.getSelfReference());
    }

    private void jButton_AddDMXControlActionPerformed(ActionEvent evt) {
        if (this.m_SelectedDMXMixerPanel == null) {
            return;
        }
        boolean boolIsDMXEditor = false;
        boolean boolIsMainMixerPanel = false;
        DMXControlComponent.DMXControlType o_DMXControlType = (DMXControlComponent.DMXControlType)this.jList_DMXControlType.getSelectedValue();
        if (o_DMXControlType == null) {
            return;
        }
        if (LiveShowDMXDeviceEditor.DEVICE_DEFAULTNAME.equals(this.m_SelectedDMXMixerPanel.getName())) {
            boolIsDMXEditor = true;
            if (o_DMXControlType.getClassName().equals(DMXControl_Dimmer.class.getName()) && this.m_SelectedDMXMixerPanel.containsDMXControlComponent(DMXControl_Dimmer.class.getName())) {
                this.m_SelectedDMXMixerPanel.showDialog_OnlyOneDimmer();
                return;
            }
        } else if (LiveShowDMXMixerMainView.MAINDMXMIXERPANELNAME.equals(this.m_SelectedDMXMixerPanel.getName())) {
            boolIsMainMixerPanel = true;
        }
        o_DMXControlType = new DMXControlComponent.DMXControlType(o_DMXControlType.getClassName(), o_DMXControlType.getName(), o_DMXControlType.getRemark());
        this.m_SelectedDMXMixerPanel.clearSelectedControlComponents();
        o_DMXControlType.setMixerPanelOwner(this.m_SelectedDMXMixerPanel.getOwner());
        this.m_SelectedDMXMixerPanel.loadDMXControlComponent(o_DMXControlType);
    }

    private void jButton_ImportDMXControlsActionPerformed(ActionEvent evt) {
        DMXControlComponent o_DMXControlComponent;
        DMXControlComponent.DMXControlType o_DMXControlType;
        if (this.m_SelectedDMXMixerPanel == null) {
            return;
        }
        boolean boolIsDMXEditor = false;
        boolean boolIsMainMixerPanel = false;
        FileNameExtensionFilter o_FileNameExtensionFilter = FileSelection.createFileNameExtensionFilter(DMXDeviceType.DEVICETYPE_NAME + " (" + ".dvd" + ")", ".dvd");
        File o_SelectedFile = FileSelection.showOpen(this, DMXDeviceType.DEVICETYPE_IMPORT, new File(LiveShowDMXSystem.getPathDeviceTypes()), o_FileNameExtensionFilter, true, false);
        if (o_SelectedFile == null) {
            return;
        }
        DMXDeviceType o_DMXDeviceType = DMXDeviceType.load(o_SelectedFile.getName());
        if (o_DMXDeviceType == null) {
            return;
        }
        if (o_DMXDeviceType.getDMXControlTypeCount() <= 0) {
            return;
        }
        this.m_SelectedDMXMixerPanel.clearSelectedControlComponents();
        if (LiveShowDMXDeviceEditor.DEVICE_DEFAULTNAME.equals(this.m_SelectedDMXMixerPanel.getName())) {
            boolIsDMXEditor = true;
        } else if (LiveShowDMXMixerMainView.MAINDMXMIXERPANELNAME.equals(this.m_SelectedDMXMixerPanel.getName())) {
            boolIsMainMixerPanel = true;
        }
        ArrayList<String> oldIDs = new ArrayList<String>();
        ArrayList<DMXControlComponent> o_DMXControlComponents_WithoutLinks = new ArrayList<DMXControlComponent>();
        for (int intDMXControlType = 0; intDMXControlType < o_DMXDeviceType.getDMXControlTypeCount(); ++intDMXControlType) {
            o_DMXControlType = o_DMXDeviceType.getDMXControlType(intDMXControlType);
            DMXControlComponent.DMXControlType o_DMXControlType_WithoutLinks = o_DMXControlType.copyWithoutLinks();
            oldIDs.add(o_DMXControlType.getID());
            o_DMXControlType_WithoutLinks.setID(LiveGUID.getUID());
            o_DMXControlType_WithoutLinks.setMixerPanelOwner(this.m_SelectedDMXMixerPanel.getOwner());
            o_DMXControlComponent = this.m_SelectedDMXMixerPanel.loadDMXControlComponent(o_DMXControlType_WithoutLinks);
            if (o_DMXControlComponent == null) continue;
            o_DMXControlComponents_WithoutLinks.add(o_DMXControlComponent);
        }
        for (int intDMXControlType = 0; intDMXControlType < o_DMXControlComponents_WithoutLinks.size(); ++intDMXControlType) {
            o_DMXControlComponent = (DMXControlComponent)o_DMXControlComponents_WithoutLinks.get(intDMXControlType);
            o_DMXControlType = o_DMXControlComponent.getDMXControlType();
            for (int intControlType = 0; intControlType < o_DMXControlType.getControlTypeCount(); ++intControlType) {
                DMXControlComponent.ControlType o_ControlType = o_DMXControlType.getControlType(intControlType);
                for (int intDimension = 0; intDimension < o_ControlType.getControlDimensionTypeCount(); ++intDimension) {
                    DMXControlComponent.ControlDimensionType o_ControlDimensionType = o_ControlType.getControlDimensionType(intDimension);
                    ControlLabelModel o_ControlLabelModel = o_ControlDimensionType.getControlLabelModel();
                    for (int intLabelList = 0; intLabelList < o_ControlLabelModel.getControlLabelListSize(); ++intLabelList) {
                        ControlLabelModel.ControlLabelList o_ControlLabelList = o_ControlLabelModel.getControlLabelList(intLabelList);
                        for (int intCondition = 0; intCondition < o_ControlLabelList.getLabelListConditionSize(); ++intCondition) {
                            ControlLabelModel.LabelListCondition o_LabelListCondition = o_ControlLabelList.getLabelListCondition(intCondition);
                            int intIndex = oldIDs.indexOf(o_LabelListCondition.getRemoteID());
                            if (intIndex < 0) {
                                o_DMXControlComponent.unlinkLabelListCondition(o_LabelListCondition);
                                o_LabelListCondition.setRemoteID("");
                                continue;
                            }
                            DMXControlComponent.DMXControlType o_RemoteDMXControlType = ((DMXControlComponent)o_DMXControlComponents_WithoutLinks.get((int)intIndex)).m_DMXControlType;
                            o_LabelListCondition.setRemoteID(o_RemoteDMXControlType.getID());
                            o_DMXControlComponent.linkLabelListCondition(o_LabelListCondition);
                        }
                    }
                }
            }
        }
    }

    private void jButton_RemoveDMXControlActionPerformed(ActionEvent evt) {
        if (this.m_SelectedDMXMixerPanel == null) {
            return;
        }
        int intSelectedCount = this.m_SelectedDMXMixerPanel.getSelectedControlComponentCount();
        for (int intComponent = intSelectedCount - 1; intComponent >= 0; --intComponent) {
            DMXControlComponent o_DMXControlComponent = this.m_SelectedDMXMixerPanel.getSelectedControlComponent(intComponent);
            DMXControlComponent.DMXControlType o_DMXControlType = o_DMXControlComponent.getDMXControlType();
            this.m_SelectedDMXMixerPanel.removeControlComponent(o_DMXControlComponent, false);
        }
    }

    private void jButton_MoveLeftDMXControlActionPerformed(ActionEvent evt) {
        if (this.m_SelectedDMXMixerPanel == null) {
            return;
        }
        int intSelectedCount = this.m_SelectedDMXMixerPanel.getSelectedControlComponentCount();
        for (int intComponent = 0; intComponent < intSelectedCount; ++intComponent) {
            DMXControlComponent o_DMXControlComponent = this.m_SelectedDMXMixerPanel.getSelectedControlComponent(intComponent);
            int intNewPosition = this.m_SelectedDMXMixerPanel.moveleftDMXControlComponent(o_DMXControlComponent);
        }
    }

    private void jButton_MoveRightDMXControlActionPerformed(ActionEvent evt) {
        if (this.m_SelectedDMXMixerPanel == null) {
            return;
        }
        int intSelectedCount = this.m_SelectedDMXMixerPanel.getSelectedControlComponentCount();
        for (int intComponent = intSelectedCount - 1; intComponent >= 0; --intComponent) {
            DMXControlComponent o_DMXControlComponent = this.m_SelectedDMXMixerPanel.getSelectedControlComponent(intComponent);
            int intNewPosition = this.m_SelectedDMXMixerPanel.moverightDMXControlComponent(o_DMXControlComponent);
        }
    }

    public void setDMXMixerPanel(DMXMixerPanel p_DMXMixerPanel) {
        if (this.m_SelectedDMXMixerPanel == p_DMXMixerPanel) {
            this.refreshButtons();
            return;
        }
        if (this.m_SelectedDMXMixerPanel != null) {
            this.m_SelectedDMXMixerPanel.removeSelectionListener(this);
        }
        this.m_SelectedDMXMixerPanel = p_DMXMixerPanel;
        if (this.m_SelectedDMXMixerPanel != null) {
            this.m_SelectedDMXMixerPanel.addSelectionListener(this);
        }
        this.refreshButtons();
    }

    private void refreshButtons() {
        this.jButton_AddDMXControl.setEnabled(false);
        this.jButton_ImportDMXControls.setEnabled(false);
        this.jButton_RemoveDMXControl.setEnabled(false);
        this.jButton_MoveLeftDMXControl.setEnabled(false);
        this.jButton_MoveRightDMXControl.setEnabled(false);
        if (this.m_SelectedDMXMixerPanel == null) {
            return;
        }
        this.jButton_AddDMXControl.setEnabled(true);
        this.jButton_ImportDMXControls.setEnabled(true);
        if (this.m_SelectedDMXMixerPanel.getSelectedControlComponentCount() > 0) {
            this.jButton_RemoveDMXControl.setEnabled(true);
            if (this.m_SelectedDMXMixerPanel.getDMXControlComponentCount() > 1) {
                this.jButton_MoveLeftDMXControl.setEnabled(true);
                this.jButton_MoveRightDMXControl.setEnabled(true);
            }
        }
    }

    @Override
    public void eventDMXMixerPanelClose(DMXMixerPanel p_DMXMixerpanel) {
        this.setDMXMixerPanel(null);
    }

    @Override
    public void eventDMXMixerPanelSelected(DMXMixerPanel p_DMXMixerPanel) {
        this.refreshButtons();
    }

    @Override
    public void eventDMXMixerPanelDMXControlAdded(DMXMixerPanel p_DMXMixerpanel, DMXControlComponent p_DMXControlComponent) {
        this.refreshButtons();
    }

    @Override
    public void eventDMXMixerPanelDMXControlRemoved(DMXMixerPanel p_DMXMixerPanel, DMXControlComponent p_DMXControlComponent) {
        this.refreshButtons();
    }

    @Override
    public void eventDMXMixerPanelDMXControlMoved(DMXMixerPanel p_DMXMixerPanel, DMXControlComponent p_DMXControlComponent, int p_NewPosition) {
    }
}

