/*
 * Decompiled with CFR 0.152.
 */
package DMXMixer;

import DMXDevicePackage.DMXDevice;
import DMXDevicePackage.DMXDeviceType;
import DMXMixer.DMXControlComponent;
import DMXMixer.DMXControlDescription;
import DMXMixer.DMXControlDisplayLabel;
import DMXMixer.DMXControlSpecialSettings;
import DMXMixer.DMXControlValuesPanel;
import DMXMixer.DMXValueSelection;
import DMXScenePackage.DMXScene;
import DMXVirtualPackage.DMXFadeDescription;
import GraphicsDeviceToolsPackage.GraphicsDeviceTools;
import JarLoader.JarResources;
import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LanguageTools.LiveLanguagePackage.LiveLanguageString;
import LiveShowControlModels.ControlFunctionModel;
import LiveShowControlModels.ControlLabelModel;
import LiveShowControlObjects.ControlGroup;
import LiveShowControlObjects.ControlObject;
import LiveShowControlObjects.ValueSelectionInterface;
import LiveShowControls.JControlMeter;
import LiveShowControls.JControlSlider;
import StartPackage.LiveShowDMXSystem;
import SwingComponents.MouseAdapter_Delayed;
import SwingToolTipPackage.PopUpToolTip;
import SynchronizationPackage.EventQueueHandler;
import ToolsGraphics.GraphicsTools;
import ToolsGraphics.ImagesTools;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DMXControl_RGB
extends DMXControlComponent
implements ValueSelectionInterface {
    @LiveLanguageString
    public static String CONTROLNAME = "RGB-CMY";
    @LiveLanguageString
    public static String CONTROLDESCRIPTION = "RGB Control uses 3 Faders (Red, Green, Blue) to mix RGB-Color";
    @LiveLanguageString
    public static String DIMENSIONNAME_0_RED = "Red";
    @LiveLanguageString
    public static String DIMENSIONNAME_0_GREEN = "Green";
    @LiveLanguageString
    public static String DIMENSIONNAME_0_BLUE = "Blue";
    public static final int CONTROLINDEX_RED = 0;
    public static final int CONTROLINDEX_GREEN = 1;
    public static final int CONTROLINDEX_BLUE = 2;
    @LiveLanguageString
    public static String DIMENSIONNAME_0_CYAN = "Cyan";
    @LiveLanguageString
    public static String DIMENSIONNAME_0_MAGENTA = "Magenta";
    @LiveLanguageString
    public static String DIMENSIONNAME_0_YELLOW = "Yellow";
    public static final int CONTROLINDEX_CYAN = 3;
    public static final int CONTROLINDEX_MAGENTA = 4;
    public static final int CONTROLINDEX_YELLOW = 5;
    public static DMXControlComponent.DMXControlType s_DMXControlType = new DMXControlComponent.DMXControlType(DMXControl_RGB.class.getName(), CONTROLNAME, CONTROLDESCRIPTION);
    private static DMXFadeDescription.DMXControlTypeFadeDescription s_DMXControlTypeFadeDescription = null;
    private boolean m_ControlsVisible_RGB;
    private DMXControlDisplayLabel m_DMXControlDisplayLabel_Copy;
    private Color m_DisplayColor;
    private Image m_DisplayImage;
    private ArrayList<ControlObject.ControlDimension> m_ControlDimensions;
    private ArrayList<Double> m_DisplayValues;
    private ArrayList<Double> m_DisplayValuesTemp;
    private boolean m_DisplayChangedByRGB;
    private boolean m_IsRGBControlled;
    private int m_ValueMaximumLinked;
    private JColorChooser m_ColorChooser;
    private JDialog m_JDialog;
    private ValueSelectionInterface m_LastValueSelectionInterface;
    private Runnable m_RunnableRefreshDisplay;
    private DMXControl_RGB m_SelfReference;
    private final Object m_SyncObject = new Object();
    private DMXControlDisplayLabel dMXControlDisplayLabel1;
    private DMXControlValuesPanel dMXControlValuesPanel_Blue;
    private DMXControlValuesPanel dMXControlValuesPanel_Cyan;
    private DMXControlValuesPanel dMXControlValuesPanel_Green;
    private DMXControlValuesPanel dMXControlValuesPanel_Magenta;
    private DMXControlValuesPanel dMXControlValuesPanel_Red;
    private DMXControlValuesPanel dMXControlValuesPanel_Yellow;
    private JButton jButton_Settings;
    private JControlMeter jControlMeter_Blue;
    private JControlMeter jControlMeter_Cyan;
    private JControlMeter jControlMeter_Green;
    private JControlMeter jControlMeter_Magenta;
    private JControlMeter jControlMeter_Red;
    private JControlMeter jControlMeter_Yellow;
    private JControlSlider jControlSlider_Blue;
    private JControlSlider jControlSlider_Cyan;
    private JControlSlider jControlSlider_Green;
    private JControlSlider jControlSlider_Magenta;
    private JControlSlider jControlSlider_Red;
    private JControlSlider jControlSlider_Yellow;
    private JLabel jLabel_Name;
    private JLabel jLabel_RGB_CMY;
    private JPanel jPanel1;
    private JPanel jPanel_SliderBlue;
    private JPanel jPanel_SliderCyan;
    private JPanel jPanel_SliderGreen;
    private JPanel jPanel_SliderMagenta;
    private JPanel jPanel_SliderRed;
    private JPanel jPanel_SliderYellow;

    public DMXControl_RGB() {
        this((DMXControlComponent.DMXControlType)null);
    }

    public DMXControl_RGB(DMXControlComponent.DMXControlType p_DMXControlType) {
        super(p_DMXControlType);
        this.initMembers();
        this.initComponents();
        this.m_DisplayColor = Color.BLACK;
        this.initComponentsFurther();
        this.setEditable(false);
        this.initDMXControlComponentFinal();
        if (s_DMXControlTypeFadeDescription == null) {
            s_DMXControlTypeFadeDescription = new DMXFadeDescription.DMXControlTypeFadeDescription(null, s_DMXControlType);
            this.setDefaultDMXFadeDescriptionMembers();
        }
        this.dMXControlValuesPanel_Red.setControlDimensionType(this.getControlType(0).getControlDimensionType(0), null);
        this.dMXControlValuesPanel_Green.setControlDimensionType(this.getControlType(1).getControlDimensionType(0), null);
        this.dMXControlValuesPanel_Blue.setControlDimensionType(this.getControlType(2).getControlDimensionType(0), null);
        this.dMXControlValuesPanel_Cyan.setControlDimensionType(this.getControlType(3).getControlDimensionType(0), null);
        this.dMXControlValuesPanel_Magenta.setControlDimensionType(this.getControlType(4).getControlDimensionType(0), null);
        this.dMXControlValuesPanel_Yellow.setControlDimensionType(this.getControlType(5).getControlDimensionType(0), null);
        this.getControlType(0).getControlDimensionType(0).setPartnerControlDimensionType(this.getControlType(3).getControlDimensionType(0));
        this.getControlType(1).getControlDimensionType(0).setPartnerControlDimensionType(this.getControlType(4).getControlDimensionType(0));
        this.getControlType(2).getControlDimensionType(0).setPartnerControlDimensionType(this.getControlType(5).getControlDimensionType(0));
        this.getControlType(3).getControlDimensionType(0).setPartnerControlDimensionType(this.getControlType(0).getControlDimensionType(0));
        this.getControlType(4).getControlDimensionType(0).setPartnerControlDimensionType(this.getControlType(1).getControlDimensionType(0));
        this.getControlType(5).getControlDimensionType(0).setPartnerControlDimensionType(this.getControlType(2).getControlDimensionType(0));
        LiveLanguage.addLanguageListener((Object)this, null);
        this.setControlsVisible_RGB(true);
        this.eventLabelList();
        this.refreshToolTipText_PartDMXControl();
        this.checkOppositeSliders("");
        this.refreshDisplay();
    }

    private void initMembers() {
        this.m_SelfReference = this;
        this.m_ControlsVisible_RGB = true;
        this.m_DisplayChangedByRGB = true;
        this.m_IsRGBControlled = false;
        this.m_ValueMaximumLinked = 65535;
        this.m_RunnableRefreshDisplay = new Runnable(){

            @Override
            public void run() {
                DMXControl_RGB.this.refreshDisplay();
            }
        };
        this.m_DMXControlType.setDMXControlDescription(DMXControlDescription.getDMXControlDescription("rgbcmy"));
        this.m_DisplayValues = new ArrayList(6);
        this.m_DisplayValues.add(0.0);
        this.m_DisplayValues.add(0.0);
        this.m_DisplayValues.add(0.0);
        this.m_DisplayValues.add(65535.0);
        this.m_DisplayValues.add(65535.0);
        this.m_DisplayValues.add(65535.0);
        this.m_DisplayImage = null;
        this.m_DisplayValuesTemp = new ArrayList(6);
        this.m_DisplayValuesTemp.add(0.0);
        this.m_DisplayValuesTemp.add(0.0);
        this.m_DisplayValuesTemp.add(0.0);
        this.m_DisplayValuesTemp.add(65535.0);
        this.m_DisplayValuesTemp.add(65535.0);
        this.m_DisplayValuesTemp.add(65535.0);
    }

    private void initComponents() {
        this.jPanel_SliderRed = new JPanel();
        this.jControlSlider_Red = new JControlSlider();
        this.jControlMeter_Red = new JControlMeter();
        this.jPanel_SliderGreen = new JPanel();
        this.jControlSlider_Green = new JControlSlider();
        this.jControlMeter_Green = new JControlMeter();
        this.jPanel_SliderBlue = new JPanel();
        this.jControlMeter_Blue = new JControlMeter();
        this.jControlSlider_Blue = new JControlSlider();
        this.jButton_Settings = new JButton();
        this.jLabel_Name = new JLabel();
        this.jPanel_SliderCyan = new JPanel();
        this.jControlSlider_Cyan = new JControlSlider();
        this.jControlMeter_Cyan = new JControlMeter();
        this.jPanel_SliderMagenta = new JPanel();
        this.jControlSlider_Magenta = new JControlSlider();
        this.jControlMeter_Magenta = new JControlMeter();
        this.jPanel_SliderYellow = new JPanel();
        this.jControlMeter_Yellow = new JControlMeter();
        this.jControlSlider_Yellow = new JControlSlider();
        this.jPanel1 = new JPanel();
        this.jLabel_RGB_CMY = new JLabel();
        this.dMXControlDisplayLabel1 = new DMXControlDisplayLabel();
        this.dMXControlValuesPanel_Red = new DMXControlValuesPanel();
        this.dMXControlValuesPanel_Green = new DMXControlValuesPanel();
        this.dMXControlValuesPanel_Blue = new DMXControlValuesPanel();
        this.dMXControlValuesPanel_Cyan = new DMXControlValuesPanel();
        this.dMXControlValuesPanel_Magenta = new DMXControlValuesPanel();
        this.dMXControlValuesPanel_Yellow = new DMXControlValuesPanel();
        this.setBackground(new Color(153, 153, 153));
        this.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.setFocusable(false);
        this.setMinimumSize(new Dimension(195, 50));
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(195, 50));
        this.setLayout(new GridBagLayout());
        this.jPanel_SliderRed.setMinimumSize(new Dimension(10, 20));
        this.jPanel_SliderRed.setOpaque(false);
        this.jPanel_SliderRed.setPreferredSize(new Dimension(0, 0));
        this.jPanel_SliderRed.setLayout(new GridBagLayout());
        this.jControlSlider_Red.setBlocksBorder(BorderFactory.createEtchedBorder(Color.black, Color.white));
        this.jControlSlider_Red.setLabelsBorder(BorderFactory.createEtchedBorder(Color.black, Color.lightGray));
        this.jControlSlider_Red.setMaximumSize(new Dimension(30, Integer.MAX_VALUE));
        this.jControlSlider_Red.setMinimumSize(new Dimension(30, 170));
        this.jControlSlider_Red.setPreferredSize(new Dimension(30, 170));
        this.jControlSlider_Red.setSnapDistanceTransformed(1.0);
        this.jControlSlider_Red.setTrackInsets(new Insets(0, 12, 0, 12));
        this.jControlSlider_Red.setValueMaximum(65535.0);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel_SliderRed.add((Component)this.jControlSlider_Red, gridBagConstraints);
        this.jControlMeter_Red.setLabelsVisible(false);
        this.jControlMeter_Red.setMaximumSize(new Dimension(10, Integer.MAX_VALUE));
        this.jControlMeter_Red.setMeterBarInsets(new Insets(20, 0, 20, 0));
        this.jControlMeter_Red.setMeterBarWidth(3);
        this.jControlMeter_Red.setMinimumSize(new Dimension(10, 170));
        this.jControlMeter_Red.setPreferredSize(new Dimension(10, 170));
        this.jControlMeter_Red.setTicksVisible(false);
        this.jControlMeter_Red.setValueMaximum(65535.0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 1.0;
        this.jPanel_SliderRed.add((Component)this.jControlMeter_Red, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jPanel_SliderRed, gridBagConstraints);
        this.jPanel_SliderGreen.setMinimumSize(new Dimension(10, 20));
        this.jPanel_SliderGreen.setOpaque(false);
        this.jPanel_SliderGreen.setPreferredSize(new Dimension(0, 0));
        this.jPanel_SliderGreen.setLayout(new GridBagLayout());
        this.jControlSlider_Green.setBlocksBorder(BorderFactory.createEtchedBorder(Color.black, Color.white));
        this.jControlSlider_Green.setLabelsBorder(BorderFactory.createEtchedBorder(Color.black, Color.lightGray));
        this.jControlSlider_Green.setMaximumSize(new Dimension(30, Integer.MAX_VALUE));
        this.jControlSlider_Green.setMinimumSize(new Dimension(30, 170));
        this.jControlSlider_Green.setPreferredSize(new Dimension(30, 170));
        this.jControlSlider_Green.setSnapDistanceTransformed(1.0);
        this.jControlSlider_Green.setTrackInsets(new Insets(0, 12, 0, 12));
        this.jControlSlider_Green.setValueMaximum(65535.0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel_SliderGreen.add((Component)this.jControlSlider_Green, gridBagConstraints);
        this.jControlMeter_Green.setLabelsVisible(false);
        this.jControlMeter_Green.setMaximumSize(new Dimension(10, Integer.MAX_VALUE));
        this.jControlMeter_Green.setMeterBarInsets(new Insets(20, 0, 20, 0));
        this.jControlMeter_Green.setMeterBarWidth(3);
        this.jControlMeter_Green.setMinimumSize(new Dimension(10, 170));
        this.jControlMeter_Green.setPreferredSize(new Dimension(10, 170));
        this.jControlMeter_Green.setTicksVisible(false);
        this.jControlMeter_Green.setValueMaximum(65535.0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 1.0;
        this.jPanel_SliderGreen.add((Component)this.jControlMeter_Green, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jPanel_SliderGreen, gridBagConstraints);
        this.jPanel_SliderBlue.setMinimumSize(new Dimension(10, 20));
        this.jPanel_SliderBlue.setOpaque(false);
        this.jPanel_SliderBlue.setPreferredSize(new Dimension(0, 0));
        this.jPanel_SliderBlue.setLayout(new GridBagLayout());
        this.jControlMeter_Blue.setLabelsVisible(false);
        this.jControlMeter_Blue.setMaximumSize(new Dimension(10, Integer.MAX_VALUE));
        this.jControlMeter_Blue.setMeterBarInsets(new Insets(20, 0, 20, 0));
        this.jControlMeter_Blue.setMeterBarWidth(3);
        this.jControlMeter_Blue.setMinimumSize(new Dimension(10, 170));
        this.jControlMeter_Blue.setPreferredSize(new Dimension(10, 170));
        this.jControlMeter_Blue.setTicksVisible(false);
        this.jControlMeter_Blue.setValueMaximum(65535.0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 1.0;
        this.jPanel_SliderBlue.add((Component)this.jControlMeter_Blue, gridBagConstraints);
        this.jControlSlider_Blue.setBlocksBorder(BorderFactory.createEtchedBorder(Color.black, Color.white));
        this.jControlSlider_Blue.setLabelsBorder(BorderFactory.createEtchedBorder(Color.black, Color.lightGray));
        this.jControlSlider_Blue.setMaximumSize(new Dimension(30, Integer.MAX_VALUE));
        this.jControlSlider_Blue.setMinimumSize(new Dimension(30, 170));
        this.jControlSlider_Blue.setPreferredSize(new Dimension(30, 170));
        this.jControlSlider_Blue.setSnapDistanceTransformed(1.0);
        this.jControlSlider_Blue.setTrackInsets(new Insets(0, 12, 0, 12));
        this.jControlSlider_Blue.setValueMaximum(65535.0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel_SliderBlue.add((Component)this.jControlSlider_Blue, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jPanel_SliderBlue, gridBagConstraints);
        this.jButton_Settings.setText("...");
        this.jButton_Settings.setMaximumSize(new Dimension(45, 16));
        this.jButton_Settings.setMinimumSize(new Dimension(45, 16));
        this.jButton_Settings.setPreferredSize(new Dimension(16, 16));
        this.jButton_Settings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DMXControl_RGB.this.jButton_SettingsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jButton_Settings, gridBagConstraints);
        this.jLabel_Name.setBackground(new Color(0, 0, 50));
        this.jLabel_Name.setForeground(new Color(200, 200, 200));
        this.jLabel_Name.setHorizontalAlignment(0);
        this.jLabel_Name.setText("jLabel1");
        this.jLabel_Name.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.add((Component)this.jLabel_Name, gridBagConstraints);
        this.jPanel_SliderCyan.setMinimumSize(new Dimension(10, 20));
        this.jPanel_SliderCyan.setOpaque(false);
        this.jPanel_SliderCyan.setPreferredSize(new Dimension(0, 0));
        this.jPanel_SliderCyan.setLayout(new GridBagLayout());
        this.jControlSlider_Cyan.setBlocksBorder(BorderFactory.createEtchedBorder(Color.black, Color.white));
        this.jControlSlider_Cyan.setLabelsBorder(BorderFactory.createEtchedBorder(Color.black, Color.lightGray));
        this.jControlSlider_Cyan.setMaximumSize(new Dimension(30, Integer.MAX_VALUE));
        this.jControlSlider_Cyan.setMinimumSize(new Dimension(30, 170));
        this.jControlSlider_Cyan.setPreferredSize(new Dimension(30, 170));
        this.jControlSlider_Cyan.setSnapDistanceTransformed(1.0);
        this.jControlSlider_Cyan.setTrackInsets(new Insets(0, 12, 0, 12));
        this.jControlSlider_Cyan.setValueMaximum(65535.0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel_SliderCyan.add((Component)this.jControlSlider_Cyan, gridBagConstraints);
        this.jControlMeter_Cyan.setLabelsVisible(false);
        this.jControlMeter_Cyan.setMaximumSize(new Dimension(10, Integer.MAX_VALUE));
        this.jControlMeter_Cyan.setMeterBarInsets(new Insets(12, 0, 12, 0));
        this.jControlMeter_Cyan.setMeterBarWidth(3);
        this.jControlMeter_Cyan.setMinimumSize(new Dimension(10, 170));
        this.jControlMeter_Cyan.setPreferredSize(new Dimension(10, 170));
        this.jControlMeter_Cyan.setTicksVisible(false);
        this.jControlMeter_Cyan.setValueMaximum(65535.0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 1.0;
        this.jPanel_SliderCyan.add((Component)this.jControlMeter_Cyan, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jPanel_SliderCyan, gridBagConstraints);
        this.jPanel_SliderMagenta.setMinimumSize(new Dimension(10, 20));
        this.jPanel_SliderMagenta.setOpaque(false);
        this.jPanel_SliderMagenta.setPreferredSize(new Dimension(0, 0));
        this.jPanel_SliderMagenta.setLayout(new GridBagLayout());
        this.jControlSlider_Magenta.setBlocksBorder(BorderFactory.createEtchedBorder(Color.black, Color.white));
        this.jControlSlider_Magenta.setLabelsBorder(BorderFactory.createEtchedBorder(Color.black, Color.lightGray));
        this.jControlSlider_Magenta.setMaximumSize(new Dimension(30, Integer.MAX_VALUE));
        this.jControlSlider_Magenta.setMinimumSize(new Dimension(30, 170));
        this.jControlSlider_Magenta.setPreferredSize(new Dimension(30, 170));
        this.jControlSlider_Magenta.setSnapDistanceTransformed(1.0);
        this.jControlSlider_Magenta.setTrackInsets(new Insets(0, 12, 0, 12));
        this.jControlSlider_Magenta.setValueMaximum(65535.0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel_SliderMagenta.add((Component)this.jControlSlider_Magenta, gridBagConstraints);
        this.jControlMeter_Magenta.setLabelsVisible(false);
        this.jControlMeter_Magenta.setMaximumSize(new Dimension(10, Integer.MAX_VALUE));
        this.jControlMeter_Magenta.setMeterBarInsets(new Insets(12, 0, 12, 0));
        this.jControlMeter_Magenta.setMeterBarWidth(3);
        this.jControlMeter_Magenta.setMinimumSize(new Dimension(10, 170));
        this.jControlMeter_Magenta.setPreferredSize(new Dimension(10, 170));
        this.jControlMeter_Magenta.setTicksVisible(false);
        this.jControlMeter_Magenta.setValueMaximum(65535.0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 1.0;
        this.jPanel_SliderMagenta.add((Component)this.jControlMeter_Magenta, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jPanel_SliderMagenta, gridBagConstraints);
        this.jPanel_SliderYellow.setMinimumSize(new Dimension(10, 20));
        this.jPanel_SliderYellow.setOpaque(false);
        this.jPanel_SliderYellow.setPreferredSize(new Dimension(0, 0));
        this.jPanel_SliderYellow.setLayout(new GridBagLayout());
        this.jControlMeter_Yellow.setLabelsVisible(false);
        this.jControlMeter_Yellow.setMaximumSize(new Dimension(10, Integer.MAX_VALUE));
        this.jControlMeter_Yellow.setMeterBarInsets(new Insets(12, 0, 12, 0));
        this.jControlMeter_Yellow.setMeterBarWidth(3);
        this.jControlMeter_Yellow.setMinimumSize(new Dimension(10, 170));
        this.jControlMeter_Yellow.setPreferredSize(new Dimension(10, 170));
        this.jControlMeter_Yellow.setTicksVisible(false);
        this.jControlMeter_Yellow.setValueMaximum(65535.0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 1.0;
        this.jPanel_SliderYellow.add((Component)this.jControlMeter_Yellow, gridBagConstraints);
        this.jControlSlider_Yellow.setBlocksBorder(BorderFactory.createEtchedBorder(Color.black, Color.white));
        this.jControlSlider_Yellow.setLabelsBorder(BorderFactory.createEtchedBorder(Color.black, Color.lightGray));
        this.jControlSlider_Yellow.setMaximumSize(new Dimension(30, Integer.MAX_VALUE));
        this.jControlSlider_Yellow.setMinimumSize(new Dimension(30, 170));
        this.jControlSlider_Yellow.setPreferredSize(new Dimension(30, 170));
        this.jControlSlider_Yellow.setSnapDistanceTransformed(1.0);
        this.jControlSlider_Yellow.setTrackInsets(new Insets(0, 12, 0, 12));
        this.jControlSlider_Yellow.setValueMaximum(65535.0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel_SliderYellow.add((Component)this.jControlSlider_Yellow, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jPanel_SliderYellow, gridBagConstraints);
        this.jPanel1.setOpaque(false);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel_RGB_CMY.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Color_RGB_CMY.png")));
        this.jLabel_RGB_CMY.setToolTipText("RGB <-> CMY");
        this.jLabel_RGB_CMY.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DMXControl_RGB.this.jLabel_RGB_CMYMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.jLabel_RGB_CMY, gridBagConstraints);
        this.dMXControlDisplayLabel1.setBorder(BorderFactory.createLineBorder(Color.gray));
        this.dMXControlDisplayLabel1.setMinimumSize(new Dimension(34, 34));
        this.dMXControlDisplayLabel1.setPreferredSize(new Dimension(34, 34));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.dMXControlDisplayLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        this.add((Component)this.jPanel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.add((Component)this.dMXControlValuesPanel_Red, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.add((Component)this.dMXControlValuesPanel_Green, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.add((Component)this.dMXControlValuesPanel_Blue, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.add((Component)this.dMXControlValuesPanel_Cyan, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.add((Component)this.dMXControlValuesPanel_Magenta, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.add((Component)this.dMXControlValuesPanel_Yellow, gridBagConstraints);
    }

    private void initComponentsFurther() {
        this.dMXControlDisplayLabel1.setDMXControlComponent(this);
        this.dMXControlDisplayLabel1.setBackgroundStyle(0);
        this.dMXControlDisplayLabel1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DMXControl_RGB.this.showValueSelection(DMXControl_RGB.this.m_SelfReference, evt.getXOnScreen(), evt.getYOnScreen());
            }
        });
        ControlLabelModel o_ControlLabelModel = this.jControlSlider_Red.getControlLabelModel();
        o_ControlLabelModel.clearControlLabelDescriptions();
        o_ControlLabelModel.createControlLabelDescription(0.0, 0.0, Double.valueOf(0.0), "0%", null, Color.BLACK);
        o_ControlLabelModel.createControlLabelDescription(16384.0, 16384.0, Double.valueOf(16384.0), "25%", null, new Color(64, 0, 0));
        o_ControlLabelModel.createControlLabelDescription(32768.0, 32768.0, Double.valueOf(32768.0), "50%", null, new Color(128, 0, 0));
        o_ControlLabelModel.createControlLabelDescription(49152.0, 49152.0, Double.valueOf(49152.0), "75%", null, new Color(192, 0, 0));
        o_ControlLabelModel.createControlLabelDescription(65535.0, 65535.0, Double.valueOf(65535.0), "100%", null, Color.RED);
        o_ControlLabelModel = this.jControlSlider_Green.getControlLabelModel();
        o_ControlLabelModel.clearControlLabelDescriptions();
        o_ControlLabelModel.createControlLabelDescription(0.0, 0.0, Double.valueOf(0.0), "0%", null, Color.BLACK);
        o_ControlLabelModel.createControlLabelDescription(16384.0, 16384.0, Double.valueOf(16384.0), "25%", null, new Color(0, 64, 0));
        o_ControlLabelModel.createControlLabelDescription(32768.0, 32768.0, Double.valueOf(32768.0), "50%", null, new Color(0, 128, 0));
        o_ControlLabelModel.createControlLabelDescription(49152.0, 49152.0, Double.valueOf(49152.0), "75%", null, new Color(0, 192, 0));
        o_ControlLabelModel.createControlLabelDescription(65535.0, 65535.0, Double.valueOf(65535.0), "100%", null, Color.GREEN);
        o_ControlLabelModel = this.jControlSlider_Blue.getControlLabelModel();
        o_ControlLabelModel.clearControlLabelDescriptions();
        o_ControlLabelModel.createControlLabelDescription(0.0, 0.0, Double.valueOf(0.0), "0%", null, Color.BLACK);
        o_ControlLabelModel.createControlLabelDescription(16384.0, 16384.0, Double.valueOf(16384.0), "25%", null, new Color(0, 0, 64));
        o_ControlLabelModel.createControlLabelDescription(32768.0, 32768.0, Double.valueOf(32768.0), "50%", null, new Color(0, 0, 128));
        o_ControlLabelModel.createControlLabelDescription(49152.0, 49152.0, Double.valueOf(49152.0), "75%", null, new Color(0, 0, 192));
        o_ControlLabelModel.createControlLabelDescription(65535.0, 65535.0, Double.valueOf(65535.0), "100%", null, Color.BLUE);
        this.jControlSlider_Red.addMouseListener((MouseListener)new MouseAdapter_Delayed(){

            @Override
            public void mouseClicked_Delayed(MouseEvent evt) {
                ControlGroup o_ControlGroup = LiveShowDMXSystem.getControlGroupActive();
                if (o_ControlGroup == null) {
                    return;
                }
                if (evt.getClickCount() != 1) {
                    if (evt.getClickCount() == 2) {
                        if (evt.isShiftDown() || evt.isControlDown()) {
                            o_ControlGroup.clearControlObjects();
                        } else if (o_ControlGroup.contains((ControlObject)DMXControl_RGB.this.jControlSlider_Red)) {
                            o_ControlGroup.removeControlObject((ControlObject)DMXControl_RGB.this.jControlSlider_Red);
                        } else {
                            o_ControlGroup.addControlObject((ControlObject)DMXControl_RGB.this.jControlSlider_Red);
                        }
                    } else {
                        o_ControlGroup.clearControlObjects();
                    }
                }
                DMXControl_RGB.this.fireMouseListenerEvent(DMXControl_RGB.this.m_SelfReference, evt);
            }
        });
        this.jControlSlider_Green.addMouseListener((MouseListener)new MouseAdapter_Delayed(){

            @Override
            public void mouseClicked_Delayed(MouseEvent evt) {
                ControlGroup o_ControlGroup = LiveShowDMXSystem.getControlGroupActive();
                if (o_ControlGroup == null) {
                    return;
                }
                if (evt.getClickCount() != 1) {
                    if (evt.getClickCount() == 2) {
                        if (evt.isShiftDown() || evt.isControlDown()) {
                            o_ControlGroup.clearControlObjects();
                        } else if (o_ControlGroup.contains((ControlObject)DMXControl_RGB.this.jControlSlider_Green)) {
                            o_ControlGroup.removeControlObject((ControlObject)DMXControl_RGB.this.jControlSlider_Green);
                        } else {
                            o_ControlGroup.addControlObject((ControlObject)DMXControl_RGB.this.jControlSlider_Green);
                        }
                    } else {
                        o_ControlGroup.clearControlObjects();
                    }
                }
                DMXControl_RGB.this.fireMouseListenerEvent(DMXControl_RGB.this.m_SelfReference, evt);
            }
        });
        this.jControlSlider_Blue.addMouseListener((MouseListener)new MouseAdapter_Delayed(){

            @Override
            public void mouseClicked_Delayed(MouseEvent evt) {
                ControlGroup o_ControlGroup = LiveShowDMXSystem.getControlGroupActive();
                if (o_ControlGroup == null) {
                    return;
                }
                if (evt.getClickCount() != 1) {
                    if (evt.getClickCount() == 2) {
                        if (evt.isShiftDown() || evt.isControlDown()) {
                            o_ControlGroup.clearControlObjects();
                        } else if (o_ControlGroup.contains((ControlObject)DMXControl_RGB.this.jControlSlider_Blue)) {
                            o_ControlGroup.removeControlObject((ControlObject)DMXControl_RGB.this.jControlSlider_Blue);
                        } else {
                            o_ControlGroup.addControlObject((ControlObject)DMXControl_RGB.this.jControlSlider_Blue);
                        }
                    } else {
                        o_ControlGroup.clearControlObjects();
                    }
                }
                DMXControl_RGB.this.fireMouseListenerEvent(DMXControl_RGB.this.m_SelfReference, evt);
            }
        });
        this.jControlSlider_Cyan.addMouseListener((MouseListener)new MouseAdapter_Delayed(){

            @Override
            public void mouseClicked_Delayed(MouseEvent evt) {
                ControlGroup o_ControlGroup = LiveShowDMXSystem.getControlGroupActive();
                if (o_ControlGroup == null) {
                    return;
                }
                if (evt.getClickCount() != 1) {
                    if (evt.getClickCount() == 2) {
                        if (evt.isShiftDown() || evt.isControlDown()) {
                            o_ControlGroup.clearControlObjects();
                        } else if (o_ControlGroup.contains((ControlObject)DMXControl_RGB.this.jControlSlider_Cyan)) {
                            o_ControlGroup.removeControlObject((ControlObject)DMXControl_RGB.this.jControlSlider_Cyan);
                        } else {
                            o_ControlGroup.addControlObject((ControlObject)DMXControl_RGB.this.jControlSlider_Cyan);
                        }
                    } else {
                        o_ControlGroup.clearControlObjects();
                    }
                }
                DMXControl_RGB.this.fireMouseListenerEvent(DMXControl_RGB.this.m_SelfReference, evt);
            }
        });
        this.jControlSlider_Magenta.addMouseListener((MouseListener)new MouseAdapter_Delayed(){

            @Override
            public void mouseClicked_Delayed(MouseEvent evt) {
                ControlGroup o_ControlGroup = LiveShowDMXSystem.getControlGroupActive();
                if (o_ControlGroup == null) {
                    return;
                }
                if (evt.getClickCount() != 1) {
                    if (evt.getClickCount() == 2) {
                        if (evt.isShiftDown() || evt.isControlDown()) {
                            o_ControlGroup.clearControlObjects();
                        } else if (o_ControlGroup.contains((ControlObject)DMXControl_RGB.this.jControlSlider_Magenta)) {
                            o_ControlGroup.removeControlObject((ControlObject)DMXControl_RGB.this.jControlSlider_Magenta);
                        } else {
                            o_ControlGroup.addControlObject((ControlObject)DMXControl_RGB.this.jControlSlider_Magenta);
                        }
                    } else {
                        o_ControlGroup.clearControlObjects();
                    }
                }
                DMXControl_RGB.this.fireMouseListenerEvent(DMXControl_RGB.this.m_SelfReference, evt);
            }
        });
        this.jControlSlider_Yellow.addMouseListener((MouseListener)new MouseAdapter_Delayed(){

            @Override
            public void mouseClicked_Delayed(MouseEvent evt) {
                ControlGroup o_ControlGroup = LiveShowDMXSystem.getControlGroupActive();
                if (o_ControlGroup == null) {
                    return;
                }
                if (evt.getClickCount() != 1) {
                    if (evt.getClickCount() == 2) {
                        if (evt.isShiftDown() || evt.isControlDown()) {
                            o_ControlGroup.clearControlObjects();
                        } else if (o_ControlGroup.contains((ControlObject)DMXControl_RGB.this.jControlSlider_Yellow)) {
                            o_ControlGroup.removeControlObject((ControlObject)DMXControl_RGB.this.jControlSlider_Yellow);
                        } else {
                            o_ControlGroup.addControlObject((ControlObject)DMXControl_RGB.this.jControlSlider_Yellow);
                        }
                    } else {
                        o_ControlGroup.clearControlObjects();
                    }
                }
                DMXControl_RGB.this.fireMouseListenerEvent(DMXControl_RGB.this.m_SelfReference, evt);
            }
        });
        this.jControlSlider_Red.getControlDimension(0).setDimensionName(DIMENSIONNAME_0_RED);
        this.jControlSlider_Red.setName(DIMENSIONNAME_0_RED);
        this.setControlObject((ControlObject)this.jControlSlider_Red, 0);
        this.jControlSlider_Green.getControlDimension(0).setDimensionName(DIMENSIONNAME_0_GREEN);
        this.jControlSlider_Green.setName(DIMENSIONNAME_0_GREEN);
        this.setControlObject((ControlObject)this.jControlSlider_Green, 1);
        this.jControlSlider_Blue.getControlDimension(0).setDimensionName(DIMENSIONNAME_0_BLUE);
        this.jControlSlider_Blue.setName(DIMENSIONNAME_0_BLUE);
        this.setControlObject((ControlObject)this.jControlSlider_Blue, 2);
        this.setControlMeter(this.jControlMeter_Red, 0, 0);
        this.setControlMeter(this.jControlMeter_Green, 1, 0);
        this.setControlMeter(this.jControlMeter_Blue, 2, 0);
        this.jControlMeter_Red.addDimensionPropertyChangeListener("value", (PropertyChangeListener)this.jControlSlider_Red.getControlDimension(), 0);
        this.jControlMeter_Green.addDimensionPropertyChangeListener("value", (PropertyChangeListener)this.jControlSlider_Green.getControlDimension(), 0);
        this.jControlMeter_Blue.addDimensionPropertyChangeListener("value", (PropertyChangeListener)this.jControlSlider_Blue.getControlDimension(), 0);
        o_ControlLabelModel = this.jControlSlider_Cyan.getControlLabelModel();
        o_ControlLabelModel.clearControlLabelDescriptions();
        o_ControlLabelModel.createControlLabelDescription(0.0, 0.0, Double.valueOf(0.0), "0%", null, Color.BLACK);
        o_ControlLabelModel.createControlLabelDescription(16384.0, 16384.0, Double.valueOf(16384.0), "25%", null, new Color(0, 64, 64));
        o_ControlLabelModel.createControlLabelDescription(32768.0, 32768.0, Double.valueOf(32768.0), "50%", null, new Color(0, 128, 128));
        o_ControlLabelModel.createControlLabelDescription(49152.0, 49152.0, Double.valueOf(49152.0), "75%", null, new Color(0, 192, 192));
        o_ControlLabelModel.createControlLabelDescription(65535.0, 65535.0, Double.valueOf(65535.0), "100%", null, Color.CYAN);
        o_ControlLabelModel = this.jControlSlider_Magenta.getControlLabelModel();
        o_ControlLabelModel.clearControlLabelDescriptions();
        o_ControlLabelModel.createControlLabelDescription(0.0, 0.0, Double.valueOf(0.0), "0%", null, Color.BLACK);
        o_ControlLabelModel.createControlLabelDescription(16384.0, 16384.0, Double.valueOf(16384.0), "25%", null, new Color(64, 0, 64));
        o_ControlLabelModel.createControlLabelDescription(32768.0, 32768.0, Double.valueOf(32768.0), "50%", null, new Color(128, 0, 128));
        o_ControlLabelModel.createControlLabelDescription(49152.0, 49152.0, Double.valueOf(49152.0), "75%", null, new Color(192, 0, 192));
        o_ControlLabelModel.createControlLabelDescription(65535.0, 65535.0, Double.valueOf(65535.0), "100%", null, Color.MAGENTA);
        o_ControlLabelModel = this.jControlSlider_Yellow.getControlLabelModel();
        o_ControlLabelModel.clearControlLabelDescriptions();
        o_ControlLabelModel.createControlLabelDescription(0.0, 0.0, Double.valueOf(0.0), "0%", null, Color.BLACK);
        o_ControlLabelModel.createControlLabelDescription(16384.0, 16384.0, Double.valueOf(16384.0), "25%", null, new Color(64, 64, 0));
        o_ControlLabelModel.createControlLabelDescription(32768.0, 32768.0, Double.valueOf(32768.0), "50%", null, new Color(128, 128, 0));
        o_ControlLabelModel.createControlLabelDescription(49152.0, 49152.0, Double.valueOf(49152.0), "75%", null, new Color(192, 192, 0));
        o_ControlLabelModel.createControlLabelDescription(65535.0, 65535.0, Double.valueOf(65535.0), "100%", null, Color.YELLOW);
        this.jControlSlider_Cyan.getControlDimension(0).setDimensionName(DIMENSIONNAME_0_CYAN);
        this.jControlSlider_Cyan.setName(DIMENSIONNAME_0_CYAN);
        this.jControlSlider_Cyan.setInvertedSecondary(true);
        this.setControlObject((ControlObject)this.jControlSlider_Cyan, 3);
        this.jControlSlider_Magenta.getControlDimension(0).setDimensionName(DIMENSIONNAME_0_MAGENTA);
        this.jControlSlider_Magenta.setName(DIMENSIONNAME_0_MAGENTA);
        this.jControlSlider_Magenta.setInvertedSecondary(true);
        this.setControlObject((ControlObject)this.jControlSlider_Magenta, 4);
        this.jControlSlider_Yellow.getControlDimension(0).setDimensionName(DIMENSIONNAME_0_YELLOW);
        this.jControlSlider_Yellow.setName(DIMENSIONNAME_0_YELLOW);
        this.jControlSlider_Yellow.setInvertedSecondary(true);
        this.setControlObject((ControlObject)this.jControlSlider_Yellow, 5);
        this.setControlMeter(this.jControlMeter_Cyan, 3, 0);
        this.setControlMeter(this.jControlMeter_Magenta, 4, 0);
        this.setControlMeter(this.jControlMeter_Yellow, 5, 0);
        this.jControlMeter_Cyan.addDimensionPropertyChangeListener("value", (PropertyChangeListener)this.jControlSlider_Cyan.getControlDimension(), 0);
        this.jControlMeter_Magenta.addDimensionPropertyChangeListener("value", (PropertyChangeListener)this.jControlSlider_Magenta.getControlDimension(), 0);
        this.jControlMeter_Yellow.addDimensionPropertyChangeListener("value", (PropertyChangeListener)this.jControlSlider_Yellow.getControlDimension(), 0);
        int[] CMY = ImagesTools.translateColor_RGBToCMY(this.m_DisplayColor);
        this.jControlSlider_Cyan.setValue((double)((int)((double)CMY[0] / 255.0 * this.jControlMeter_Cyan.getValueMaximum() + 0.5)));
        this.jControlSlider_Magenta.setValue((double)((int)((double)CMY[1] / 255.0 * this.jControlMeter_Magenta.getValueMaximum() + 0.5)));
        this.jControlSlider_Yellow.setValue((double)((int)((double)CMY[2] / 255.0 * this.jControlMeter_Yellow.getValueMaximum() + 0.5)));
        this.jControlSlider_Red.getControlDimension(0).setPartnerControlDimension(this.jControlSlider_Cyan.getControlDimension(0));
        this.jControlSlider_Cyan.getControlDimension(0).setPartnerControlDimension(this.jControlSlider_Red.getControlDimension(0));
        this.jControlSlider_Green.getControlDimension(0).setPartnerControlDimension(this.jControlSlider_Magenta.getControlDimension(0));
        this.jControlSlider_Magenta.getControlDimension(0).setPartnerControlDimension(this.jControlSlider_Green.getControlDimension(0));
        this.jControlSlider_Blue.getControlDimension(0).setPartnerControlDimension(this.jControlSlider_Yellow.getControlDimension(0));
        this.jControlSlider_Yellow.getControlDimension(0).setPartnerControlDimension(this.jControlSlider_Blue.getControlDimension(0));
        this.jControlSlider_Red.setSnapDistance(1.0);
        this.jControlSlider_Green.setSnapDistance(1.0);
        this.jControlSlider_Blue.setSnapDistance(1.0);
        this.jControlSlider_Cyan.setSnapDistance(1.0);
        this.jControlSlider_Magenta.setSnapDistance(1.0);
        this.jControlSlider_Yellow.setSnapDistance(1.0);
        this.dMXControlDisplayLabel1.setColor(Color.BLACK);
        this.setJarResources(LiveShowDMXSystem.s_JarResources_Default);
        this.m_ControlDimensions = new ArrayList(6);
        this.m_ControlDimensions.add(this.jControlSlider_Red.getControlDimension());
        this.m_ControlDimensions.add(this.jControlSlider_Green.getControlDimension());
        this.m_ControlDimensions.add(this.jControlSlider_Blue.getControlDimension());
        this.m_ControlDimensions.add(this.jControlSlider_Cyan.getControlDimension());
        this.m_ControlDimensions.add(this.jControlSlider_Magenta.getControlDimension());
        this.m_ControlDimensions.add(this.jControlSlider_Yellow.getControlDimension());
        this.jButton_Settings.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jLabel_RGB_CMY.setCursor(Cursor.getPredefinedCursor(12));
        this.jLabel_RGB_CMY.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.dMXControlDisplayLabel1.setCursor(Cursor.getPredefinedCursor(12));
    }

    @Override
    public void close() {
        this.jButton_Settings.setComponentPopupMenu(null);
        this.jLabel_RGB_CMY.setComponentPopupMenu(null);
        this.dMXControlValuesPanel_Red.close();
        this.dMXControlValuesPanel_Green.close();
        this.dMXControlValuesPanel_Blue.close();
        this.dMXControlValuesPanel_Cyan.close();
        this.dMXControlValuesPanel_Magenta.close();
        this.dMXControlValuesPanel_Yellow.close();
        super.close();
        LiveLanguage.removeLanguageListener((Object)this);
    }

    @Override
    public void setJarResources(JarResources p_JarResources) {
        if (p_JarResources != null) {
            this.jControlSlider_Red.setJarResources(p_JarResources);
            this.jControlSlider_Green.setJarResources(p_JarResources);
            this.jControlSlider_Blue.setJarResources(p_JarResources);
            this.jControlMeter_Red.setJarResources(p_JarResources);
            this.jControlMeter_Green.setJarResources(p_JarResources);
            this.jControlMeter_Blue.setJarResources(p_JarResources);
            this.jControlSlider_Cyan.setJarResources(p_JarResources);
            this.jControlSlider_Magenta.setJarResources(p_JarResources);
            this.jControlSlider_Yellow.setJarResources(p_JarResources);
            this.jControlMeter_Cyan.setJarResources(p_JarResources);
            this.jControlMeter_Magenta.setJarResources(p_JarResources);
            this.jControlMeter_Yellow.setJarResources(p_JarResources);
        }
    }

    public void fireMouseListenerEvent(JComponent p_JComponent, MouseEvent p_MouseEvent) {
        MouseEvent o_MouseEvent = MouseAdapter_Delayed.createMouseEvent(p_MouseEvent.getComponent(), p_MouseEvent.getID(), p_MouseEvent.getWhen(), p_MouseEvent.getModifiers(), p_MouseEvent.getX(), p_MouseEvent.getY(), p_MouseEvent.getXOnScreen(), p_MouseEvent.getYOnScreen(), p_MouseEvent.getClickCount(), p_MouseEvent.isPopupTrigger(), p_MouseEvent.getButton());
        int intMouseEvent = p_MouseEvent.getID();
        block14: for (int intListener = 0; intListener < this.getMouseListeners().length; ++intListener) {
            MouseListener o_MouseListener = this.getMouseListeners()[intListener];
            if (o_MouseListener == null) continue;
            if (o_MouseListener instanceof MouseAdapter_Delayed) {
                MouseAdapter_Delayed o_MouseAdapter_Delayed = (MouseAdapter_Delayed)o_MouseListener;
                switch (intMouseEvent) {
                    case 504: {
                        o_MouseAdapter_Delayed.mouseEntered_Delayed(o_MouseEvent);
                        break;
                    }
                    case 505: {
                        o_MouseAdapter_Delayed.mouseExited_Delayed(o_MouseEvent);
                        break;
                    }
                    case 501: {
                        o_MouseAdapter_Delayed.mousePressed_Delayed(o_MouseEvent);
                        break;
                    }
                    case 502: {
                        o_MouseAdapter_Delayed.mouseReleased_Delayed(o_MouseEvent);
                        break;
                    }
                    case 500: {
                        o_MouseAdapter_Delayed.mouseClicked_Delayed(o_MouseEvent);
                    }
                }
                continue;
            }
            switch (intMouseEvent) {
                case 504: {
                    o_MouseListener.mouseEntered(o_MouseEvent);
                    continue block14;
                }
                case 505: {
                    o_MouseListener.mouseExited(o_MouseEvent);
                    continue block14;
                }
                case 501: {
                    o_MouseListener.mousePressed(o_MouseEvent);
                    continue block14;
                }
                case 502: {
                    o_MouseListener.mouseReleased(o_MouseEvent);
                    continue block14;
                }
                case 500: {
                    o_MouseListener.mouseClicked(o_MouseEvent);
                }
            }
        }
    }

    @Override
    public String getName() {
        return super.getName();
    }

    @Override
    public String getRemark() {
        return super.getRemark();
    }

    @Override
    public DMXControlDisplayLabel getDisplayLabel() {
        return this.dMXControlDisplayLabel1;
    }

    @Override
    public JLabel getNameLabel() {
        return this.jLabel_Name;
    }

    private void selectColor(ValueSelectionInterface p_ValueSelectionInterface, int p_XOnScreen, int p_YOnScreen) {
        this.m_LastValueSelectionInterface = p_ValueSelectionInterface;
        if (this.m_ColorChooser == null) {
            this.m_ColorChooser = new JColorChooser(this.getColor(this.m_LastValueSelectionInterface));
            ActionListener okActionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DMXControl_RGB.this.setColor(DMXControl_RGB.this.m_LastValueSelectionInterface, DMXControl_RGB.this.m_ColorChooser.getColor());
                }
            };
            ActionListener cancelActionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                }
            };
            this.m_JDialog = JColorChooser.createDialog(null, "", false, this.m_ColorChooser, okActionListener, cancelActionListener);
            this.m_JDialog.setAlwaysOnTop(true);
            this.m_JDialog.setDefaultCloseOperation(1);
            this.m_JDialog.addWindowFocusListener(new WindowFocusListener(){

                @Override
                public void windowGainedFocus(WindowEvent e) {
                }

                @Override
                public void windowLostFocus(WindowEvent e) {
                    DMXControl_RGB.this.m_JDialog.setVisible(false);
                }
            });
        }
        this.m_ColorChooser.setColor(this.getColor(p_ValueSelectionInterface));
        Dimension o_Dimension = this.m_JDialog.getPreferredSize();
        int intX = p_XOnScreen;
        int intY = p_YOnScreen;
        GraphicsDeviceTools.GraphicsDeviceDescription o_GraphicsDeviceDescription = GraphicsDeviceTools.getGraphicsDeviceDescription(p_XOnScreen, p_YOnScreen);
        if (o_GraphicsDeviceDescription == null) {
            o_GraphicsDeviceDescription = GraphicsDeviceTools.getGraphicsDeviceDescription(0);
        }
        if (o_GraphicsDeviceDescription != null) {
            if (intX < o_GraphicsDeviceDescription.getX()) {
                intX = o_GraphicsDeviceDescription.getX();
            }
            if (intX + o_Dimension.width > o_GraphicsDeviceDescription.getX() + o_GraphicsDeviceDescription.getWidth()) {
                intX = o_GraphicsDeviceDescription.getX() + o_GraphicsDeviceDescription.getWidth() - o_Dimension.width;
            }
            if (intY < o_GraphicsDeviceDescription.getY()) {
                intY = o_GraphicsDeviceDescription.getY();
            }
            if (intY + o_Dimension.height > o_GraphicsDeviceDescription.getY() + o_GraphicsDeviceDescription.getHeight()) {
                intY = o_GraphicsDeviceDescription.getY() + o_GraphicsDeviceDescription.getHeight() - o_Dimension.height;
            }
        }
        this.m_JDialog.setLocation(intX, intY);
        this.m_JDialog.setVisible(true);
    }

    @Override
    public DMXControlDisplayLabel getDisplayLabelCopy() {
        if (this.m_DMXControlDisplayLabel_Copy == null) {
            if (this.dMXControlDisplayLabel1 == null) {
                return null;
            }
            this.m_DMXControlDisplayLabel_Copy = new DMXControlDisplayLabel();
            this.m_DMXControlDisplayLabel_Copy.setDMXControlComponent(this);
            this.m_DMXControlDisplayLabel_Copy.setBackground(new Color(0, 0, 0));
            this.m_DMXControlDisplayLabel_Copy.setBorder(DMXControlComponent.s_DisplayLabelBorderNormal);
            this.m_DMXControlDisplayLabel_Copy.setBackgroundStyle(0);
            this.m_DMXControlDisplayLabel_Copy.setMinimumSize(new Dimension(32, 32));
            this.m_DMXControlDisplayLabel_Copy.setPreferredSize(new Dimension(32, 32));
            this.m_DMXControlDisplayLabel_Copy.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    DMXControl_RGB.this.showValueSelection(DMXControl_RGB.this.m_SelfReference, evt.getXOnScreen(), evt.getYOnScreen());
                }
            });
            this.m_DMXControlDisplayLabel_Copy.setColor(this.dMXControlDisplayLabel1.getColor());
        }
        return this.m_DMXControlDisplayLabel_Copy;
    }

    @Override
    public void setVisible(boolean p_IsVisible) {
        super.setVisible(p_IsVisible);
        this.refreshDisplay();
    }

    @Override
    public void showValueSelection(ValueSelectionInterface p_ValueSelectionInterface, int p_XOnScreen, int p_YOnScreen) {
        if (!this.isMaster()) {
            DMXValueSelection.show(this, p_ValueSelectionInterface, this.m_ControlDimensions, p_XOnScreen, p_YOnScreen);
        } else {
            this.selectColor(p_ValueSelectionInterface, p_XOnScreen, p_YOnScreen);
        }
    }

    public void setValuesSelected(ArrayList<Double> p_Values, ArrayList<ControlObject.ControlDimension> p_ControlDimensions) {
        for (int intDimension = 0; intDimension < p_ControlDimensions.size(); ++intDimension) {
            ControlObject.ControlDimension o_ControlDimension = p_ControlDimensions.get(intDimension);
            double doubleValue = p_Values.get(intDimension);
            o_ControlDimension.setValue(doubleValue, 2);
        }
        this.jControlSlider_Red.setValueManuallyIsReady();
        this.jControlSlider_Green.setValueManuallyIsReady();
        this.jControlSlider_Blue.setValueManuallyIsReady();
    }

    public ArrayList<Double> getValues() {
        return this.m_DisplayValues;
    }

    public ControlLabelModel.ControlLabelList getControlLabelListSelected(ControlObject.ControlDimension p_ControlDimension) {
        return null;
    }

    @Override
    public void setEnableSettings(boolean p_Enabled) {
        super.setEnableSettings(p_Enabled);
        if (p_Enabled) {
            this.jButton_Settings.setVisible(true);
        } else {
            this.jButton_Settings.setVisible(false);
        }
    }

    @Override
    public boolean getEnableSettings() {
        return super.getEnableSettings();
    }

    private void jButton_SettingsActionPerformed(ActionEvent evt) {
        this.showSettings();
    }

    private void jLabel_RGB_CMYMouseClicked(MouseEvent evt) {
        if (this.m_ControlsVisible_RGB) {
            this.setControlsVisible_RGB(false);
        } else {
            this.setControlsVisible_RGB(true);
        }
    }

    private void setControlsVisible_RGB(boolean p_IsRGB) {
        try {
            this.m_ControlsVisible_RGB = p_IsRGB;
            if (!this.m_ControlsVisible_RGB) {
                this.jPanel_SliderRed.setVisible(false);
                this.jPanel_SliderGreen.setVisible(false);
                this.jPanel_SliderBlue.setVisible(false);
                this.dMXControlValuesPanel_Red.setVisible(false);
                this.dMXControlValuesPanel_Green.setVisible(false);
                this.dMXControlValuesPanel_Blue.setVisible(false);
                this.jPanel_SliderCyan.setVisible(true);
                this.jPanel_SliderMagenta.setVisible(true);
                this.jPanel_SliderYellow.setVisible(true);
                this.dMXControlValuesPanel_Cyan.setVisible(true);
                this.dMXControlValuesPanel_Magenta.setVisible(true);
                this.dMXControlValuesPanel_Yellow.setVisible(true);
            } else {
                this.jPanel_SliderCyan.setVisible(false);
                this.jPanel_SliderMagenta.setVisible(false);
                this.jPanel_SliderYellow.setVisible(false);
                this.dMXControlValuesPanel_Cyan.setVisible(false);
                this.dMXControlValuesPanel_Magenta.setVisible(false);
                this.dMXControlValuesPanel_Yellow.setVisible(false);
                this.jPanel_SliderRed.setVisible(true);
                this.jPanel_SliderGreen.setVisible(true);
                this.jPanel_SliderBlue.setVisible(true);
                this.dMXControlValuesPanel_Red.setVisible(true);
                this.dMXControlValuesPanel_Green.setVisible(true);
                this.dMXControlValuesPanel_Blue.setVisible(true);
            }
        }
        catch (Exception e) {
            System.out.println("Error DMXControl_RGB setControlsVisible_RGB " + e.getMessage());
        }
        this.revalidate();
    }

    @Override
    public boolean getIsOn() {
        boolean boolIsOn = false;
        if (this.jControlSlider_Red.getValue() > 0.0 || this.jControlSlider_Green.getValue() > 0.0 || this.jControlSlider_Blue.getValue() > 0.0) {
            boolIsOn = true;
        }
        return boolIsOn;
    }

    @Override
    public boolean getIsOn(ArrayList<Double> p_Values) {
        if (p_Values == null) {
            return false;
        }
        if (this.m_DMXControlType == null) {
            return false;
        }
        int intControlsCount = this.m_DMXControlType.getControlTypeCount();
        if (intControlsCount <= 0) {
            return false;
        }
        DMXControlComponent.ControlType o_ControlType = this.m_DMXControlType.getControlType(0);
        if (o_ControlType == null) {
            return false;
        }
        int intDimensionCount = o_ControlType.getControlDimensionTypeCount();
        if (p_Values.size() != intControlsCount * intDimensionCount) {
            return false;
        }
        if (this.isRGBControlled()) {
            for (int intValue = 0; intValue < 3; ++intValue) {
                double doubleValue = p_Values.get(intValue);
                if (!(doubleValue > 0.0)) continue;
                return true;
            }
        } else {
            for (int intValue = 3; intValue < 6; ++intValue) {
                double doubleValue = p_Values.get(intValue);
                if (!(doubleValue < 65535.0)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void validateValuesDevice(boolean p_IsScene, boolean p_EditMode) {
    }

    @Override
    public void refreshDisplay_HardwareValueChanged() {
    }

    private void checkOppositeSliders(String p_PropertyChangeCause) {
        boolean boolIsRGBControlled = this.isRGBControlled();
        int intValueMaximum = this.m_ValueMaximumLinked;
        boolean boolChanged = false;
        if (this.m_DisplayChangedByRGB) {
            int intValue_Old = (int)this.jControlSlider_Cyan.getValue();
            int intValue_New = (int)((double)intValueMaximum - this.m_DisplayValues.get(0) + 0.5);
            if (intValue_New < 0) {
                intValue_New = 0;
            }
            if (intValue_Old != intValue_New) {
                this.m_DisplayValues.set(3, Double.valueOf(intValue_New));
                this.jControlSlider_Cyan.setValue((double)intValue_New);
                boolChanged = true;
            }
            intValue_Old = (int)this.jControlSlider_Magenta.getValue();
            intValue_New = (int)((double)intValueMaximum - this.m_DisplayValues.get(1) + 0.5);
            if (intValue_New < 0) {
                intValue_New = 0;
            }
            if (intValue_Old != intValue_New) {
                this.m_DisplayValues.set(4, Double.valueOf(intValue_New));
                this.jControlSlider_Magenta.setValue((double)intValue_New);
                boolChanged = true;
            }
            intValue_Old = (int)this.jControlSlider_Yellow.getValue();
            intValue_New = (int)((double)intValueMaximum - this.m_DisplayValues.get(2) + 0.5);
            if (intValue_New < 0) {
                intValue_New = 0;
            }
            if (intValue_Old != intValue_New) {
                this.m_DisplayValues.set(5, Double.valueOf(intValue_New));
                this.jControlSlider_Yellow.setValue((double)intValue_New);
                boolChanged = true;
            }
            if (boolChanged && "valueChangedManually".equals(p_PropertyChangeCause)) {
                this.jControlSlider_Cyan.setValueManuallyIsReady();
                this.jControlSlider_Magenta.setValueManuallyIsReady();
                this.jControlSlider_Yellow.setValueManuallyIsReady();
            }
        } else {
            int intValue_Old = (int)this.jControlSlider_Red.getValue();
            int intValue_New = (int)((double)intValueMaximum - this.m_DisplayValues.get(3) + 0.5);
            if (intValue_New < 0) {
                intValue_New = 0;
            }
            if (intValue_Old != intValue_New) {
                this.m_DisplayValues.set(0, Double.valueOf(intValue_New));
                this.jControlSlider_Red.setValue((double)intValue_New);
                boolChanged = true;
            }
            intValue_Old = (int)this.jControlSlider_Green.getValue();
            intValue_New = (int)((double)intValueMaximum - this.m_DisplayValues.get(4) + 0.5);
            if (intValue_New < 0) {
                intValue_New = 0;
            }
            if (intValue_Old != intValue_New) {
                this.m_DisplayValues.set(1, Double.valueOf(intValue_New));
                this.jControlSlider_Green.setValue((double)intValue_New);
                boolChanged = true;
            }
            intValue_Old = (int)this.jControlSlider_Blue.getValue();
            intValue_New = (int)((double)intValueMaximum - this.m_DisplayValues.get(5) + 0.5);
            if (intValue_New < 0) {
                intValue_New = 0;
            }
            if (intValue_Old != intValue_New) {
                this.m_DisplayValues.set(2, Double.valueOf(intValue_New));
                this.jControlSlider_Blue.setValue((double)intValue_New);
                boolChanged = true;
            }
            if (boolChanged && "valueChangedManually".equals(p_PropertyChangeCause)) {
                this.jControlSlider_Red.setValueManuallyIsReady();
                this.jControlSlider_Green.setValueManuallyIsReady();
                this.jControlSlider_Blue.setValueManuallyIsReady();
            }
        }
    }

    @Override
    public void refreshDisplay_ControlValueChanged(DMXControlComponent p_DMXControlComponent, ControlObject p_ControlObject, ControlObject.ControlDimension p_ControlDimension, String p_PropertyChangeCause) {
        if (p_ControlObject == null) {
            return;
        }
        boolean boolChanged = false;
        this.m_DisplayChangedByRGB = p_ControlObject != this.jControlSlider_Cyan && p_ControlObject != this.jControlSlider_Magenta && p_ControlObject != this.jControlSlider_Yellow;
        if (this.m_DisplayChangedByRGB) {
            if (this.m_DisplayValues.get(0).doubleValue() != this.jControlSlider_Red.getValue()) {
                boolChanged = true;
                this.m_DisplayValues.set(0, Double.valueOf((int)this.jControlSlider_Red.getValue()));
                this.m_ControlObjectValueChanged = p_ControlObject;
            }
            if (this.m_DisplayValues.get(1).doubleValue() != this.jControlSlider_Green.getValue()) {
                boolChanged = true;
                this.m_DisplayValues.set(1, Double.valueOf((int)this.jControlSlider_Green.getValue()));
                this.m_ControlObjectValueChanged = p_ControlObject;
            }
            if (this.m_DisplayValues.get(2).doubleValue() != this.jControlSlider_Blue.getValue()) {
                boolChanged = true;
                this.m_DisplayValues.set(2, Double.valueOf((int)this.jControlSlider_Blue.getValue()));
                this.m_ControlObjectValueChanged = p_ControlObject;
            }
        } else {
            if (this.m_DisplayValues.get(3).doubleValue() != this.jControlSlider_Cyan.getValue()) {
                boolChanged = true;
                this.m_DisplayValues.set(3, Double.valueOf((int)this.jControlSlider_Cyan.getValue()));
                this.m_ControlObjectValueChanged = p_ControlObject;
            }
            if (this.m_DisplayValues.get(4).doubleValue() != this.jControlSlider_Magenta.getValue()) {
                boolChanged = true;
                this.m_DisplayValues.set(4, Double.valueOf((int)this.jControlSlider_Magenta.getValue()));
                this.m_ControlObjectValueChanged = p_ControlObject;
            }
            if (this.m_DisplayValues.get(5).doubleValue() != this.jControlSlider_Yellow.getValue()) {
                boolChanged = true;
                this.m_DisplayValues.set(5, Double.valueOf((int)this.jControlSlider_Yellow.getValue()));
                this.m_ControlObjectValueChanged = p_ControlObject;
            }
        }
        if (!boolChanged) {
            return;
        }
        this.checkOppositeSliders(p_PropertyChangeCause);
        EventQueueHandler.invokeLater(this.m_RunnableRefreshDisplay);
    }

    @Override
    public boolean refreshDisplay() {
        boolean boolIsRGBControlled = this.isRGBControlled();
        boolean boolIsOn = false;
        boolean boolChanged = false;
        double doubleValue_Red = this.jControlSlider_Red.getValue();
        double doubleValue_Green = this.jControlSlider_Green.getValue();
        double doubleValue_Blue = this.jControlSlider_Blue.getValue();
        if (doubleValue_Red > 0.0) {
            boolIsOn = true;
        }
        if (doubleValue_Green > 0.0) {
            boolIsOn = true;
        }
        if (doubleValue_Blue > 0.0) {
            boolIsOn = true;
        }
        int intValueMaximum = this.m_ValueMaximumLinked;
        Color o_Color = GraphicsTools.newColorSave((int)(doubleValue_Red / (double)intValueMaximum * 255.0 + 0.5), (int)(doubleValue_Green / (double)intValueMaximum * 255.0 + 0.5), (int)(doubleValue_Blue / (double)intValueMaximum * 255.0 + 0.5));
        boolChanged = true;
        this.m_DisplayColor = o_Color;
        if (this.m_IsVisible) {
            this.dMXControlDisplayLabel1.setSurface(null, null, this.m_DisplayColor, this.m_DisplayImage, this.m_ControlDimensions, this.m_DisplayValues, boolIsOn);
        }
        if (this.m_DMXControlDisplayLabel_Copy != null) {
            this.m_DMXControlDisplayLabel_Copy.setSurface(null, null, this.m_DisplayColor, this.m_DisplayImage, this.m_ControlDimensions, this.m_DisplayValues, boolIsOn);
        }
        return boolChanged;
    }

    @Override
    public void refreshDisplay_Foreign(DMXControlDisplayLabel p_DMXControlDisplayLabel, DMXDevice p_DMXDevice, DMXScene p_DMXScene) {
        boolean boolIsOn = false;
        p_DMXControlDisplayLabel.setBackgroundStyle(0);
        if (this.isRGBControlled()) {
            this.m_DisplayValuesTemp.set(0, Double.valueOf((int)p_DMXScene.getValue(p_DMXDevice, this.m_DMXControlType, 0, 0)));
            this.m_DisplayValuesTemp.set(1, Double.valueOf((int)p_DMXScene.getValue(p_DMXDevice, this.m_DMXControlType, 1, 0)));
            this.m_DisplayValuesTemp.set(2, Double.valueOf((int)p_DMXScene.getValue(p_DMXDevice, this.m_DMXControlType, 2, 0)));
            this.refreshDisplay_Foreign(p_DMXControlDisplayLabel, this.findControlLabelList(p_DMXDevice, p_DMXScene), this.m_DisplayValuesTemp, 0);
        } else {
            this.m_DisplayValuesTemp.set(3, Double.valueOf((int)p_DMXScene.getValue(p_DMXDevice, this.m_DMXControlType, 3, 0)));
            this.m_DisplayValuesTemp.set(4, Double.valueOf((int)p_DMXScene.getValue(p_DMXDevice, this.m_DMXControlType, 4, 0)));
            this.m_DisplayValuesTemp.set(5, Double.valueOf((int)p_DMXScene.getValue(p_DMXDevice, this.m_DMXControlType, 5, 0)));
            this.refreshDisplay_Foreign(p_DMXControlDisplayLabel, this.findControlLabelList(p_DMXDevice, p_DMXScene), this.m_DisplayValuesTemp, 3);
        }
    }

    @Override
    public void refreshDisplay_Foreign(DMXControlDisplayLabel p_DMXControlDisplayLabel, ControlLabelModel.ControlLabelList p_ControlLabelList, ArrayList<Double> p_Values) {
        if (this.isRGBControlled()) {
            this.refreshDisplay_Foreign(p_DMXControlDisplayLabel, p_ControlLabelList, p_Values, 0);
        } else {
            this.refreshDisplay_Foreign(p_DMXControlDisplayLabel, p_ControlLabelList, p_Values, 3);
        }
    }

    @Override
    public void refreshDisplay_Foreign(DMXControlDisplayLabel p_DMXControlDisplayLabel, ControlLabelModel.ControlLabelList p_ControlLabelList, ArrayList<Double> p_Values, int p_ChangedIndex) {
        boolean boolIsOn = false;
        boolean boolIsRGBControlled = this.isRGBControlled();
        int intValueMaximum = this.m_ValueMaximumLinked;
        if (p_ChangedIndex == 0 || p_ChangedIndex == 1 || p_ChangedIndex == 2) {
            this.m_DisplayValuesTemp.set(0, Double.valueOf(p_Values.get(0).intValue()));
            this.m_DisplayValuesTemp.set(1, Double.valueOf(p_Values.get(1).intValue()));
            this.m_DisplayValuesTemp.set(2, Double.valueOf(p_Values.get(2).intValue()));
            double doubleValueNew = (int)((double)intValueMaximum - p_Values.get(0) + 0.5);
            if (doubleValueNew < 0.0) {
                doubleValueNew = 0.0;
            }
            this.m_DisplayValuesTemp.set(3, doubleValueNew);
            doubleValueNew = (int)((double)intValueMaximum - p_Values.get(1) + 0.5);
            if (doubleValueNew < 0.0) {
                doubleValueNew = 0.0;
            }
            this.m_DisplayValuesTemp.set(4, doubleValueNew);
            doubleValueNew = (int)((double)intValueMaximum - p_Values.get(2) + 0.5);
            if (doubleValueNew < 0.0) {
                doubleValueNew = 0.0;
            }
            this.m_DisplayValuesTemp.set(5, doubleValueNew);
        } else {
            this.m_DisplayValuesTemp.set(3, Double.valueOf(p_Values.get(3).intValue()));
            this.m_DisplayValuesTemp.set(4, Double.valueOf(p_Values.get(4).intValue()));
            this.m_DisplayValuesTemp.set(5, Double.valueOf(p_Values.get(5).intValue()));
            double doubleValueNew = (int)((double)intValueMaximum - p_Values.get(3) + 0.5);
            if (doubleValueNew < 0.0) {
                doubleValueNew = 0.0;
            }
            this.m_DisplayValuesTemp.set(0, doubleValueNew);
            doubleValueNew = (int)((double)intValueMaximum - p_Values.get(4) + 0.5);
            if (doubleValueNew < 0.0) {
                doubleValueNew = 0.0;
            }
            this.m_DisplayValuesTemp.set(1, doubleValueNew);
            doubleValueNew = (int)((double)intValueMaximum - p_Values.get(5) + 0.5);
            if (doubleValueNew < 0.0) {
                doubleValueNew = 0.0;
            }
            this.m_DisplayValuesTemp.set(2, doubleValueNew);
        }
        if (this.m_DisplayValuesTemp.get(0) > 0.0 || this.m_DisplayValuesTemp.get(1) > 0.0 || this.m_DisplayValuesTemp.get(2) > 0.0) {
            boolIsOn = true;
        }
        Color o_DisplayColor = GraphicsTools.newColorSave((int)(this.m_DisplayValuesTemp.get(0) / this.jControlSlider_Red.getValueMaximum() * 255.0 + 0.5), (int)(this.m_DisplayValuesTemp.get(1) / this.jControlSlider_Green.getValueMaximum() * 255.0 + 0.5), (int)(this.m_DisplayValuesTemp.get(2) / this.jControlSlider_Blue.getValueMaximum() * 255.0 + 0.5));
        p_DMXControlDisplayLabel.setSurface(p_ControlLabelList, null, o_DisplayColor, null, this.m_ControlDimensions, this.m_DisplayValuesTemp, boolIsOn);
    }

    @Override
    public void changedDMXControlLinks() {
        DMXControlComponent.DMXControlType o_DMXControlType = this.getDMXControlType();
        DMXControlComponent.ControlType o_ControlType_Red = o_DMXControlType.getControlType((ControlObject)this.jControlSlider_Red);
        DMXControlComponent.ControlType o_ControlType_Green = o_DMXControlType.getControlType((ControlObject)this.jControlSlider_Green);
        DMXControlComponent.ControlType o_ControlType_Blue = o_DMXControlType.getControlType((ControlObject)this.jControlSlider_Blue);
        if (this.getIsLinked(o_ControlType_Red.getControlDimensionType(0)) || this.getIsLinked(o_ControlType_Green.getControlDimensionType(0)) || this.getIsLinked(o_ControlType_Blue.getControlDimensionType(0))) {
            this.m_IsRGBControlled = true;
            this.m_ValueMaximumLinked = this.getValueMaximum_Linked(this.jControlSlider_Red.getControlDimension());
            return;
        }
        DMXControlComponent.ControlType o_ControlType_Cyan = o_DMXControlType.getControlType((ControlObject)this.jControlSlider_Cyan);
        DMXControlComponent.ControlType o_ControlType_Magenta = o_DMXControlType.getControlType((ControlObject)this.jControlSlider_Magenta);
        DMXControlComponent.ControlType o_ControlType_Yellow = o_DMXControlType.getControlType((ControlObject)this.jControlSlider_Yellow);
        if (this.getIsLinked(o_ControlType_Cyan.getControlDimensionType(0)) || this.getIsLinked(o_ControlType_Magenta.getControlDimensionType(0)) || this.getIsLinked(o_ControlType_Yellow.getControlDimensionType(0))) {
            this.m_IsRGBControlled = false;
            this.m_ValueMaximumLinked = this.getValueMaximum_Linked(this.jControlSlider_Cyan.getControlDimension());
            return;
        }
        this.m_ValueMaximumLinked = 65535;
        this.m_IsRGBControlled = true;
    }

    public boolean isRGBControlled() {
        return this.m_IsRGBControlled;
    }

    @Override
    public void changedParentHeight(int p_ParentHeight) {
    }

    @Override
    public DMXFadeDescription.DMXControlTypeFadeDescription getDefaultDMXFadeDescription() {
        return s_DMXControlTypeFadeDescription;
    }

    @Override
    public void setDefaultDMXFadeDescriptionMembers() {
        s_DMXControlTypeFadeDescription.setDisabled(false);
        s_DMXControlTypeFadeDescription.setFade(0, 0, 0.0f, 1.0f);
        s_DMXControlTypeFadeDescription.setFade(1, 0, 0.0f, 1.0f);
    }

    public void setColor(ValueSelectionInterface p_ValueSelectionInterface, Color p_Color) {
        if (p_Color == null) {
            return;
        }
        ArrayList<Double> o_Values = p_ValueSelectionInterface.getValues();
        if (o_Values == null || o_Values.size() < 6) {
            return;
        }
        o_Values = new ArrayList<Double>();
        for (int intControl = 0; intControl < 6; ++intControl) {
            o_Values.add(0.0);
        }
        o_Values.set(0, Double.valueOf((int)((double)p_Color.getRed() / 255.0 * this.jControlSlider_Red.getValueMaximum() + 0.5)));
        o_Values.set(1, Double.valueOf((int)((double)p_Color.getGreen() / 255.0 * this.jControlSlider_Green.getValueMaximum() + 0.5)));
        o_Values.set(2, Double.valueOf((int)((double)p_Color.getBlue() / 255.0 * this.jControlSlider_Blue.getValueMaximum() + 0.5)));
        o_Values.set(3, Double.valueOf((int)(this.jControlSlider_Cyan.getValueMaximum() - (Double)o_Values.get(0))));
        o_Values.set(4, Double.valueOf((int)(this.jControlSlider_Magenta.getValueMaximum() - (Double)o_Values.get(1))));
        o_Values.set(5, Double.valueOf((int)(this.jControlSlider_Yellow.getValueMaximum() - (Double)o_Values.get(2))));
        p_ValueSelectionInterface.setValuesSelected(o_Values, this.m_ControlDimensions);
    }

    public Color getColor(ValueSelectionInterface p_ValueSelectionInterface) {
        if (p_ValueSelectionInterface == null) {
            return Color.BLACK;
        }
        ArrayList o_Values = p_ValueSelectionInterface.getValues();
        if (o_Values == null || o_Values.size() < 3) {
            return Color.BLACK;
        }
        int intValueMaximum = this.m_ValueMaximumLinked;
        Color o_Color = GraphicsTools.newColorSave((int)((Double)o_Values.get(0) / (double)intValueMaximum * 255.0 + 0.5), (int)((Double)o_Values.get(1) / (double)intValueMaximum * 255.0 + 0.5), (int)((Double)o_Values.get(2) / (double)intValueMaximum * 255.0 + 0.5));
        return o_Color;
    }

    @Override
    public ArrayList<Double> getInitValues(ArrayList<Double> p_Values) {
        int intControlCount = this.getControlObjectCount();
        ControlObject o_ControlObject = this.getControlObject(0);
        if (o_ControlObject == null) {
            return null;
        }
        int intDimensionCount = o_ControlObject.getControlDimensionCount();
        if (p_Values == null) {
            p_Values = new ArrayList(intControlCount * intDimensionCount);
            for (int intValue = 0; intValue < intControlCount * intDimensionCount; ++intValue) {
                p_Values.add(-1.0);
            }
        } else if (p_Values.size() != intControlCount * intDimensionCount) {
            return null;
        }
        p_Values.set(0, 0.0);
        p_Values.set(1, 0.0);
        p_Values.set(2, 0.0);
        p_Values.set(3, 65535.0);
        p_Values.set(4, 65535.0);
        p_Values.set(5, 65535.0);
        return p_Values;
    }

    @Override
    public boolean setValuesByDMXEffect(ArrayList<Double> p_Values) {
        if (p_Values == null) {
            return false;
        }
        int intControlCount = this.getControlObjectCount();
        ControlObject o_ControlObject = this.getControlObject(0);
        if (o_ControlObject == null) {
            return false;
        }
        int intDimensionCount = o_ControlObject.getControlDimensionCount();
        int intSize = intControlCount * intDimensionCount;
        if (p_Values == null) {
            p_Values = new ArrayList(intSize);
            for (int intValue = 0; intValue < intSize; ++intValue) {
                p_Values.add(0.0);
            }
        }
        if (p_Values.size() != intSize) {
            return false;
        }
        int intStartControlIndex = 0;
        intControlCount = 3;
        intStartControlIndex = 0;
        this.m_DisplayChangedByRGB = true;
        for (int intControl = intStartControlIndex; intControl < intStartControlIndex + intControlCount; ++intControl) {
            o_ControlObject = this.getControlObject(intControl);
            for (int intDimension = 0; intDimension < intDimensionCount; ++intDimension) {
                double doubleValue = p_Values.get(intControl * intDimensionCount + intDimension);
                this.setValue(doubleValue, intControl, intDimension);
            }
        }
        return true;
    }

    @Override
    public void createAutomaticFunctions() {
        if (this.getDMXControlType() == null) {
            return;
        }
        block8: for (int intControl = 0; intControl < this.getControlObjectCount(); ++intControl) {
            DMXControlComponent.ControlType o_ControlType = this.getControlType(intControl);
            if (o_ControlType == null) continue;
            DMXControlComponent.ControlDimensionType o_ControlDimensionType = o_ControlType.getControlDimensionType(0);
            o_ControlDimensionType.getControlFunctionModel();
            ControlFunctionModel o_ControlFunctionModel = o_ControlDimensionType.getControlFunctionModel();
            if (o_ControlFunctionModel.getControlFunctionDescriptionSize() != 0) continue;
            switch (intControl) {
                case 0: {
                    ControlFunctionModel.ControlFunctionDescription o_ControlFunctionDescription = new ControlFunctionModel.ControlFunctionDescription(DMXDeviceType.s_FunctionColorWhite, (double)o_ControlDimensionType.getValueMaximum());
                    o_ControlFunctionModel.addControlFunctionDescription(o_ControlFunctionDescription);
                    o_ControlFunctionDescription = new ControlFunctionModel.ControlFunctionDescription(DMXDeviceType.s_FunctionColorBlack, 0.0);
                    o_ControlFunctionModel.addControlFunctionDescription(o_ControlFunctionDescription);
                    o_ControlFunctionDescription = new ControlFunctionModel.ControlFunctionDescription(DMXDeviceType.s_FunctionColorRed, (double)o_ControlDimensionType.getValueMaximum());
                    o_ControlFunctionModel.addControlFunctionDescription(o_ControlFunctionDescription);
                    o_ControlFunctionDescription = new ControlFunctionModel.ControlFunctionDescription(DMXDeviceType.s_FunctionColorGreen, 0.0);
                    o_ControlFunctionModel.addControlFunctionDescription(o_ControlFunctionDescription);
                    o_ControlFunctionDescription = new ControlFunctionModel.ControlFunctionDescription(DMXDeviceType.s_FunctionColorBlue, 0.0);
                    o_ControlFunctionModel.addControlFunctionDescription(o_ControlFunctionDescription);
                    continue block8;
                }
                case 1: {
                    ControlFunctionModel.ControlFunctionDescription o_ControlFunctionDescription = new ControlFunctionModel.ControlFunctionDescription(DMXDeviceType.s_FunctionColorWhite, (double)o_ControlDimensionType.getValueMaximum());
                    o_ControlFunctionModel.addControlFunctionDescription(o_ControlFunctionDescription);
                    o_ControlFunctionDescription = new ControlFunctionModel.ControlFunctionDescription(DMXDeviceType.s_FunctionColorBlack, 0.0);
                    o_ControlFunctionModel.addControlFunctionDescription(o_ControlFunctionDescription);
                    o_ControlFunctionDescription = new ControlFunctionModel.ControlFunctionDescription(DMXDeviceType.s_FunctionColorRed, 0.0);
                    o_ControlFunctionModel.addControlFunctionDescription(o_ControlFunctionDescription);
                    o_ControlFunctionDescription = new ControlFunctionModel.ControlFunctionDescription(DMXDeviceType.s_FunctionColorGreen, (double)o_ControlDimensionType.getValueMaximum());
                    o_ControlFunctionModel.addControlFunctionDescription(o_ControlFunctionDescription);
                    o_ControlFunctionDescription = new ControlFunctionModel.ControlFunctionDescription(DMXDeviceType.s_FunctionColorBlue, 0.0);
                    o_ControlFunctionModel.addControlFunctionDescription(o_ControlFunctionDescription);
                    continue block8;
                }
                case 2: {
                    ControlFunctionModel.ControlFunctionDescription o_ControlFunctionDescription = new ControlFunctionModel.ControlFunctionDescription(DMXDeviceType.s_FunctionColorWhite, (double)o_ControlDimensionType.getValueMaximum());
                    o_ControlFunctionModel.addControlFunctionDescription(o_ControlFunctionDescription);
                    o_ControlFunctionDescription = new ControlFunctionModel.ControlFunctionDescription(DMXDeviceType.s_FunctionColorBlack, 0.0);
                    o_ControlFunctionModel.addControlFunctionDescription(o_ControlFunctionDescription);
                    o_ControlFunctionDescription = new ControlFunctionModel.ControlFunctionDescription(DMXDeviceType.s_FunctionColorRed, 0.0);
                    o_ControlFunctionModel.addControlFunctionDescription(o_ControlFunctionDescription);
                    o_ControlFunctionDescription = new ControlFunctionModel.ControlFunctionDescription(DMXDeviceType.s_FunctionColorGreen, 0.0);
                    o_ControlFunctionModel.addControlFunctionDescription(o_ControlFunctionDescription);
                    o_ControlFunctionDescription = new ControlFunctionModel.ControlFunctionDescription(DMXDeviceType.s_FunctionColorBlue, (double)o_ControlDimensionType.getValueMaximum());
                    o_ControlFunctionModel.addControlFunctionDescription(o_ControlFunctionDescription);
                    continue block8;
                }
                case 3: {
                    ControlFunctionModel.ControlFunctionDescription o_ControlFunctionDescription = new ControlFunctionModel.ControlFunctionDescription(DMXDeviceType.s_FunctionColorCyan, (double)o_ControlDimensionType.getValueMaximum());
                    o_ControlFunctionModel.addControlFunctionDescription(o_ControlFunctionDescription);
                    o_ControlFunctionDescription = new ControlFunctionModel.ControlFunctionDescription(DMXDeviceType.s_FunctionColorMagenta, 0.0);
                    o_ControlFunctionModel.addControlFunctionDescription(o_ControlFunctionDescription);
                    o_ControlFunctionDescription = new ControlFunctionModel.ControlFunctionDescription(DMXDeviceType.s_FunctionColorYellow, 0.0);
                    o_ControlFunctionModel.addControlFunctionDescription(o_ControlFunctionDescription);
                    continue block8;
                }
                case 4: {
                    ControlFunctionModel.ControlFunctionDescription o_ControlFunctionDescription = new ControlFunctionModel.ControlFunctionDescription(DMXDeviceType.s_FunctionColorCyan, 0.0);
                    o_ControlFunctionModel.addControlFunctionDescription(o_ControlFunctionDescription);
                    o_ControlFunctionDescription = new ControlFunctionModel.ControlFunctionDescription(DMXDeviceType.s_FunctionColorMagenta, (double)o_ControlDimensionType.getValueMaximum());
                    o_ControlFunctionModel.addControlFunctionDescription(o_ControlFunctionDescription);
                    o_ControlFunctionDescription = new ControlFunctionModel.ControlFunctionDescription(DMXDeviceType.s_FunctionColorYellow, 0.0);
                    o_ControlFunctionModel.addControlFunctionDescription(o_ControlFunctionDescription);
                    continue block8;
                }
                case 5: {
                    ControlFunctionModel.ControlFunctionDescription o_ControlFunctionDescription = new ControlFunctionModel.ControlFunctionDescription(DMXDeviceType.s_FunctionColorCyan, 0.0);
                    o_ControlFunctionModel.addControlFunctionDescription(o_ControlFunctionDescription);
                    o_ControlFunctionDescription = new ControlFunctionModel.ControlFunctionDescription(DMXDeviceType.s_FunctionColorMagenta, 0.0);
                    o_ControlFunctionModel.addControlFunctionDescription(o_ControlFunctionDescription);
                    o_ControlFunctionDescription = new ControlFunctionModel.ControlFunctionDescription(DMXDeviceType.s_FunctionColorYellow, (double)o_ControlDimensionType.getValueMaximum());
                    o_ControlFunctionModel.addControlFunctionDescription(o_ControlFunctionDescription);
                }
            }
        }
    }

    @Override
    public void setDMXDeviceSettingsPanel(DMXDevice p_DMXDevice, DMXControlComponent.DeviceSettingsPanel p_DeviceSettingsPanel) {
    }

    @Override
    public DMXControlComponent.DeviceSettingsPanel getDMXDeviceSettingsPanel(DMXDevice p_DMXDevice, boolean p_Create) {
        return null;
    }

    @Override
    public void eventDMXControlSpecialSettings(DMXControlSpecialSettings p_DMXControlSpecialSettings) {
    }

    @Override
    public void eventLabelList() {
    }
}

