/*
 * Decompiled with CFR 0.152.
 */
package DMXMixer;

import DMXMixer.DMXControlComponent;
import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LiveShowControlObjects.ControlObject;
import StartPackage.LiveShowDMXSystem;
import SwingTextPackage.DocumentFilter_Integer;
import SwingToolTipPackage.PopUpToolTip;
import SynchronizationPackage.EventQueueHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class DMXControlValuesPanel
extends JPanel
implements PropertyChangeListener,
LiveShowDMXSystem.UnitMixerListener {
    private DMXControlComponent.ControlType m_ControlType;
    private ControlObject m_ControlObject;
    private DMXControlComponent.ControlDimensionType m_ControlDimensionType;
    private ControlObject.ControlDimension m_ControlDimension;
    private ControlObject.ControlDimension m_ActiveControlDimension;
    private String m_Name;
    private int m_ByteResolution;
    private int m_ByteResolutionOld;
    private boolean m_IsMaster;
    private double m_Value;
    private int m_ByteIndex;
    private boolean m_VisibleByteValues;
    private boolean m_VisiblePercent;
    private Runnable m_RunnableRefreshTextFields;
    private JLabel jLabel_Header;
    private JTextField jTextField_High;
    private JTextField jTextField_Low;
    private JTextField jTextField_Percent;

    public DMXControlValuesPanel() {
        this.initMembers();
        this.initComponents();
        this.initComponentsFurther();
        LiveShowDMXSystem.addUnitMixerListener(this);
        LiveLanguage.addLanguageListener((Object)this, null);
        if (!SwingUtilities.isEventDispatchThread()) {
            EventQueueHandler.invokeLater(this.m_RunnableRefreshTextFields);
        } else {
            this.refreshTextFields();
        }
    }

    private void initMembers() {
        this.m_ByteResolution = 1;
        this.m_ByteResolutionOld = -1;
        this.m_Name = "";
        this.m_IsMaster = false;
        this.m_Value = 0.0;
        this.m_ByteIndex = 0;
        this.m_ActiveControlDimension = null;
        this.m_ControlObject = null;
        this.m_ControlDimension = null;
        this.m_VisibleByteValues = false;
        this.m_VisiblePercent = false;
        this.m_RunnableRefreshTextFields = new Runnable(){

            @Override
            public void run() {
                DMXControlValuesPanel.this.refreshTextFields();
            }
        };
    }

    private void initComponentsFurther() {
        DocumentFilter_Integer o_DocumentFilter_Integer = new DocumentFilter_Integer(this.jTextField_High);
        o_DocumentFilter_Integer.setAllowNegativeNumbers(false);
        o_DocumentFilter_Integer = new DocumentFilter_Integer(this.jTextField_Low);
        o_DocumentFilter_Integer.setAllowNegativeNumbers(false);
        this.jTextField_High.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                DMXControlValuesPanel.this.jTextField_High.selectAll();
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        this.jTextField_Low.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                DMXControlValuesPanel.this.jTextField_Low.selectAll();
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        this.jTextField_Percent.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                DMXControlValuesPanel.this.jTextField_Percent.selectAll();
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        this.jTextField_High.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (DMXControlValuesPanel.this.m_ControlDimension == null) {
                    return;
                }
                if (e.getKeyCode() == 10) {
                    DMXControlValuesPanel.this.calculateTextValue(false);
                } else if (e.getKeyCode() == 225 || e.getKeyCode() == 40) {
                    DMXControlValuesPanel.this.m_ControlDimension.setValue(DMXControlValuesPanel.this.m_Value - 1.0, -1.0, 2);
                    DMXControlValuesPanel.this.m_ControlDimension.getControlObject().setValueManuallyIsReady();
                } else if (e.getKeyCode() == 224 || e.getKeyCode() == 38) {
                    DMXControlValuesPanel.this.m_ControlDimension.setValue(DMXControlValuesPanel.this.m_Value + 1.0, 1.0, 2);
                    DMXControlValuesPanel.this.m_ControlDimension.getControlObject().setValueManuallyIsReady();
                }
            }
        });
        this.jTextField_Low.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (DMXControlValuesPanel.this.m_ControlDimension == null) {
                    return;
                }
                if (e.getKeyCode() == 10) {
                    DMXControlValuesPanel.this.calculateTextValue(false);
                } else if (e.getKeyCode() == 225 || e.getKeyCode() == 40) {
                    DMXControlValuesPanel.this.m_ControlDimension.setValue(DMXControlValuesPanel.this.m_Value - 1.0, -1.0, 2);
                    DMXControlValuesPanel.this.m_ControlDimension.getControlObject().setValueManuallyIsReady();
                } else if (e.getKeyCode() == 224 || e.getKeyCode() == 38) {
                    DMXControlValuesPanel.this.m_ControlDimension.setValue(DMXControlValuesPanel.this.m_Value + 1.0, 1.0, 2);
                    DMXControlValuesPanel.this.m_ControlDimension.getControlObject().setValueManuallyIsReady();
                }
            }
        });
        this.jTextField_Percent.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (DMXControlValuesPanel.this.m_ControlDimension == null) {
                    return;
                }
                if (e.getKeyCode() == 10) {
                    DMXControlValuesPanel.this.calculateTextValue(true);
                } else if (e.getKeyCode() == 225 || e.getKeyCode() == 40) {
                    DMXControlValuesPanel.this.m_ControlDimension.setValue(DMXControlValuesPanel.this.m_Value - 1.0, -1.0, 2);
                    DMXControlValuesPanel.this.m_ControlDimension.getControlObject().setValueManuallyIsReady();
                } else if (e.getKeyCode() == 224 || e.getKeyCode() == 38) {
                    DMXControlValuesPanel.this.m_ControlDimension.setValue(DMXControlValuesPanel.this.m_Value + 1.0, 1.0, 2);
                    DMXControlValuesPanel.this.m_ControlDimension.getControlObject().setValueManuallyIsReady();
                }
            }
        });
        this.jTextField_High.addMouseWheelListener(new MouseAdapter(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if (DMXControlValuesPanel.this.m_ControlObject != null) {
                    DMXControlValuesPanel.this.setActive(1);
                    double doubleValueDiff = -((double)e.getWheelRotation() * DMXControlValuesPanel.this.m_ControlDimension.getMouseWheelStep());
                    DMXControlValuesPanel.this.m_ControlDimension.setValue(DMXControlValuesPanel.this.m_ControlDimension.getValue() + doubleValueDiff, doubleValueDiff, 8);
                    DMXControlValuesPanel.this.m_ControlDimension.getControlObject().setValueManuallyIsReady();
                    EventQueueHandler.invokeLater(DMXControlValuesPanel.this.m_RunnableRefreshTextFields);
                }
            }
        });
        this.jTextField_Low.addMouseWheelListener(new MouseAdapter(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if (DMXControlValuesPanel.this.m_ControlObject != null) {
                    DMXControlValuesPanel.this.setActive(0);
                    double doubleValueDiff = -((double)e.getWheelRotation() * DMXControlValuesPanel.this.m_ControlDimension.getMouseWheelStep());
                    DMXControlValuesPanel.this.m_ControlDimension.setValue(DMXControlValuesPanel.this.m_ControlDimension.getValue() + doubleValueDiff, doubleValueDiff, 8);
                    DMXControlValuesPanel.this.m_ControlDimension.getControlObject().setValueManuallyIsReady();
                    EventQueueHandler.invokeLater(DMXControlValuesPanel.this.m_RunnableRefreshTextFields);
                }
            }
        });
        this.jTextField_Percent.addMouseWheelListener(new MouseAdapter(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if (DMXControlValuesPanel.this.m_ControlObject != null) {
                    DMXControlValuesPanel.this.setActive(1);
                    double doubleValueDiff = -((double)e.getWheelRotation() * DMXControlValuesPanel.this.m_ControlDimension.getMouseWheelStep());
                    DMXControlValuesPanel.this.m_ControlDimension.setValue(DMXControlValuesPanel.this.m_ControlDimension.getValue() + doubleValueDiff, doubleValueDiff, 8);
                    DMXControlValuesPanel.this.m_ControlDimension.getControlObject().setValueManuallyIsReady();
                    EventQueueHandler.invokeLater(DMXControlValuesPanel.this.m_RunnableRefreshTextFields);
                }
            }
        });
        this.jTextField_High.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                DMXControlValuesPanel.this.setActive(1);
                EventQueueHandler.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DMXControlValuesPanel.this.jTextField_High.selectAll();
                    }
                });
            }
        });
        this.jTextField_High.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (DMXControlValuesPanel.this.m_ControlObject != null) {
                    DMXControlValuesPanel.this.m_ControlObject.setMousePressed(true);
                }
            }
        });
        this.jTextField_High.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                if (DMXControlValuesPanel.this.m_ControlObject != null) {
                    DMXControlValuesPanel.this.m_ControlObject.setMousePressed(false);
                }
            }
        });
        this.jTextField_Low.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                DMXControlValuesPanel.this.setActive(0);
                EventQueueHandler.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DMXControlValuesPanel.this.jTextField_Low.selectAll();
                    }
                });
            }
        });
        this.jTextField_Low.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (DMXControlValuesPanel.this.m_ControlObject != null) {
                    DMXControlValuesPanel.this.m_ControlObject.setMousePressed(true);
                }
            }
        });
        this.jTextField_Low.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                if (DMXControlValuesPanel.this.m_ControlObject != null) {
                    DMXControlValuesPanel.this.m_ControlObject.setMousePressed(false);
                }
            }
        });
        this.jTextField_Percent.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                DMXControlValuesPanel.this.setActive(1);
                EventQueueHandler.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DMXControlValuesPanel.this.jTextField_Percent.selectAll();
                    }
                });
            }
        });
        this.jTextField_Percent.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (DMXControlValuesPanel.this.m_ControlObject != null) {
                    DMXControlValuesPanel.this.m_ControlObject.setMousePressed(true);
                }
            }
        });
        this.jTextField_Percent.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                if (DMXControlValuesPanel.this.m_ControlObject != null) {
                    DMXControlValuesPanel.this.m_ControlObject.setMousePressed(false);
                }
            }
        });
        this.jTextField_High.setOpaque(false);
        this.jTextField_Low.setOpaque(false);
        this.jTextField_Percent.setOpaque(false);
        this.setOpaque(false);
        this.jTextField_Low.setVisible(false);
        this.jTextField_High.setVisible(false);
        this.jTextField_Percent.setVisible(false);
        this.jTextField_Percent.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jTextField_High.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jTextField_Low.setComponentPopupMenu(PopUpToolTip.getSelfReference());
    }

    public void close() {
        this.jTextField_Percent.setComponentPopupMenu(null);
        this.jTextField_High.setComponentPopupMenu(null);
        this.jTextField_Low.setComponentPopupMenu(null);
        LiveShowDMXSystem.removeUnitMixerListener(this);
        LiveLanguage.removeLanguageListener((Object)this);
    }

    public void setControlDimensionType(DMXControlComponent.ControlDimensionType p_ControlDimensionType, ControlObject.ControlDimension p_ControlDimension) {
        if (this.m_ControlDimensionType != null) {
            this.m_ControlDimensionType.removePropertyChangeListener(this);
        }
        if (this.m_ControlDimension != null) {
            this.m_ControlDimension.getControlObject().removePropertyChangeListener((PropertyChangeListener)this);
            this.m_ControlDimension.removePropertyChangeListener((PropertyChangeListener)this);
        }
        this.m_ControlObject = null;
        this.m_ControlType = null;
        this.m_ControlDimension = null;
        this.m_ControlDimensionType = p_ControlDimensionType;
        if (this.m_ControlDimensionType == null) {
            return;
        }
        this.m_ControlType = this.m_ControlDimensionType.getControlType();
        if (this.m_ControlType == null) {
            return;
        }
        this.m_ControlDimension = p_ControlDimension == null ? this.m_ControlDimensionType.getInstance() : p_ControlDimension;
        if (this.m_ControlDimension == null) {
            return;
        }
        this.m_ControlObject = this.m_ControlDimension.getControlObject();
        if (this.m_ControlObject == null) {
            return;
        }
        this.m_IsMaster = this.m_ControlDimension.getControlObject().getControlMaster();
        this.m_ControlDimensionType.addPropertyChangeListener(this);
        this.m_ControlDimension.addPropertyChangeListener((PropertyChangeListener)this);
        this.m_ControlDimension.getControlObject().addPropertyChangeListener((PropertyChangeListener)this);
        this.checkByteResolution();
        EventQueueHandler.invokeLater(this.m_RunnableRefreshTextFields);
    }

    private void setActive(int p_ByteIndex) {
        if (this.m_ControlObject == null) {
            return;
        }
        if (this.m_ControlDimension == null) {
            return;
        }
        this.m_ByteIndex = p_ByteIndex;
        this.m_ControlObject.setActiveDimension(this.m_ControlDimension);
        int intMouseWheelStep = this.m_ByteIndex >= 1 ? (this.m_ControlDimensionType.getByteResolution() < 2 ? 1 : 256) : 1;
        this.m_ControlDimension.setMouseWheelStep((double)intMouseWheelStep);
        if (this.m_ControlDimension.getPartnerControlDimension() != null) {
            this.m_ControlDimension.getPartnerControlDimension().setMouseWheelStep((double)intMouseWheelStep);
        }
        EventQueueHandler.invokeLater(this.m_RunnableRefreshTextFields);
    }

    private void checkByteResolution() {
        int intByteResolutionMax = 0;
        if (this.m_ControlDimensionType.getDeviceControlLinkCount() == 0) {
            intByteResolutionMax = 2;
        } else {
            for (int intLink = 0; intLink < this.m_ControlDimensionType.getDeviceControlLinkCount(); ++intLink) {
                int intByte;
                DMXControlComponent.DeviceControlLink o_DeviceControlLink = this.m_ControlDimensionType.getDeviceControlLink(intLink);
                int intByteCount = o_DeviceControlLink.getByteResolution();
                for (intByte = 0; intByte < intByteCount && o_DeviceControlLink.getDeviceInternalChannel(intByte) >= 0; ++intByte) {
                }
                if (intByte <= intByteResolutionMax) continue;
                intByteResolutionMax = intByte;
            }
        }
        this.setByteResolution(intByteResolutionMax);
    }

    public void setByteResolution(int p_ByteResolution) {
        this.m_ByteResolution = p_ByteResolution;
        if (this.m_ByteResolution >= 2) {
            this.m_ByteIndex = 0;
        } else if (this.m_ByteResolution >= 1) {
            this.jTextField_Low.setText("0");
            this.m_ByteIndex = 1;
        } else {
            this.jTextField_High.setText("0");
            this.jTextField_Low.setText("0");
            this.m_ByteIndex = -1;
        }
        this.setActive(this.m_ByteIndex);
    }

    @Override
    public void setName(String p_Name) {
        if (p_Name == null) {
            this.m_Name = "";
        }
        this.m_Name = p_Name;
        this.jLabel_Header.setText(this.m_Name);
    }

    public void setValue(double p_Value) {
        if (p_Value < 0.0) {
            p_Value = 0.0;
        }
        if (p_Value > (double)this.m_ControlDimensionType.getValueMaximum()) {
            p_Value = this.m_ControlDimensionType.getValueMaximum();
        }
        if (this.m_Value == p_Value) {
            return;
        }
        this.m_Value = p_Value;
        EventQueueHandler.invokeLater(this.m_RunnableRefreshTextFields);
    }

    public void refreshTextFields() {
        int intByteResolution = 1;
        if (LiveShowDMXSystem.getShowUnitMixer_Percent() != this.m_VisiblePercent || LiveShowDMXSystem.getShowUnitMixer_ByteValues() != this.m_VisibleByteValues || this.m_ByteResolution != this.m_ByteResolutionOld) {
            this.m_VisiblePercent = LiveShowDMXSystem.getShowUnitMixer_Percent();
            this.m_VisibleByteValues = LiveShowDMXSystem.getShowUnitMixer_ByteValues();
            if (this.m_VisiblePercent) {
                this.jTextField_Percent.setVisible(true);
            } else {
                this.jTextField_Percent.setVisible(false);
            }
            if (this.m_VisibleByteValues) {
                if (this.m_ByteResolution >= 1) {
                    this.jTextField_High.setVisible(true);
                } else {
                    this.jTextField_High.setVisible(false);
                }
                if (this.m_ByteResolution >= 2) {
                    this.jTextField_Low.setVisible(true);
                } else {
                    this.jTextField_Low.setVisible(false);
                }
            } else {
                this.jTextField_High.setVisible(false);
                this.jTextField_Low.setVisible(false);
            }
            this.m_ByteResolutionOld = this.m_ByteResolution;
            this.revalidate();
            if (!SwingUtilities.isEventDispatchThread()) {
                System.out.println("DMXControlValuesPanel refreshTextFields");
            }
            this.repaint();
        }
        if (this.m_ActiveControlDimension == this.m_ControlDimension) {
            if (this.m_ByteIndex < 0) {
                this.jTextField_High.setForeground(Color.WHITE);
                this.jTextField_Low.setForeground(Color.WHITE);
            } else if (this.m_ByteIndex == 0) {
                this.jTextField_High.setForeground(Color.WHITE);
                this.jTextField_Low.setForeground(Color.YELLOW);
            } else {
                this.jTextField_High.setForeground(Color.YELLOW);
                this.jTextField_Low.setForeground(Color.WHITE);
            }
        } else {
            this.jTextField_High.setForeground(Color.WHITE);
            this.jTextField_Low.setForeground(Color.WHITE);
        }
        intByteResolution = this.m_ControlDimensionType == null ? 1 : this.m_ControlDimensionType.getByteResolution();
        if (intByteResolution < 2) {
            this.jTextField_High.setText(String.valueOf((int)this.m_Value));
            int intValuePercent = (int)(this.m_Value / 255.0 * 100.0 + 0.5);
            this.jTextField_Percent.setText(String.valueOf(intValuePercent));
        } else {
            int intHighByteValue = (int)(this.m_Value / 256.0);
            int intLowByteValue = (int)(this.m_Value - (double)(intHighByteValue * 256));
            int intValuePercent = (int)(this.m_Value / 65535.0 * 100.0 + 0.5);
            this.jTextField_High.setText(String.valueOf(intHighByteValue));
            this.jTextField_Low.setText(String.valueOf(intLowByteValue));
            this.jTextField_Percent.setText(String.valueOf(intValuePercent));
        }
    }

    public void calculateTextValue(boolean p_Percent) {
        double doubleNewValue;
        if (this.m_ControlDimension == null) {
            return;
        }
        if (p_Percent) {
            int intValuePercent = this.jTextField_Percent.getText().length() <= 0 ? 0 : Integer.valueOf(this.jTextField_Percent.getText());
            doubleNewValue = this.m_ControlDimensionType.getByteResolution() < 2 ? 255.0 * ((double)intValuePercent / 100.0) : 65535.0 * ((double)intValuePercent / 100.0);
        } else if (this.m_ControlDimensionType.getByteResolution() < 2) {
            int intHighByteValue = this.jTextField_High.getText().length() <= 0 ? 0 : Integer.valueOf(this.jTextField_High.getText());
            doubleNewValue = intHighByteValue;
        } else {
            int intHighByteValue = this.jTextField_High.getText().length() <= 0 ? 0 : Integer.valueOf(this.jTextField_High.getText());
            int intLowByteValue = this.jTextField_Low.getText().length() <= 0 ? 0 : Integer.valueOf(this.jTextField_Low.getText());
            doubleNewValue = intHighByteValue * 256 + intLowByteValue;
        }
        double doubleValueDiff = doubleNewValue - this.m_ControlDimension.getValue();
        this.m_ControlDimension.setValue(doubleNewValue, doubleValueDiff, 2);
        this.m_ControlDimension.getControlObject().setValueManuallyIsReady();
    }

    private void initComponents() {
        this.jTextField_High = new JTextField();
        this.jTextField_Low = new JTextField();
        this.jLabel_Header = new JLabel();
        this.jTextField_Percent = new JTextField();
        this.setMinimumSize(new Dimension(36, 15));
        this.setName("");
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(36, 15));
        this.setLayout(new GridBagLayout());
        this.jTextField_High.setFont(new Font("Tahoma", 0, 10));
        this.jTextField_High.setHorizontalAlignment(0);
        this.jTextField_High.setText("255");
        this.jTextField_High.setToolTipText("High Byte Value");
        this.jTextField_High.setBorder(null);
        this.jTextField_High.setMinimumSize(new Dimension(17, 15));
        this.jTextField_High.setOpaque(false);
        this.jTextField_High.setPreferredSize(new Dimension(17, 15));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.add((Component)this.jTextField_High, gridBagConstraints);
        this.jTextField_Low.setFont(new Font("Tahoma", 0, 10));
        this.jTextField_Low.setForeground(new Color(255, 255, 0));
        this.jTextField_Low.setHorizontalAlignment(0);
        this.jTextField_Low.setText("255");
        this.jTextField_Low.setToolTipText("Low Byte Value");
        this.jTextField_Low.setBorder(null);
        this.jTextField_Low.setMinimumSize(new Dimension(17, 15));
        this.jTextField_Low.setName("");
        this.jTextField_Low.setOpaque(false);
        this.jTextField_Low.setPreferredSize(new Dimension(17, 15));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.add((Component)this.jTextField_Low, gridBagConstraints);
        this.jLabel_Header.setFont(new Font("Tahoma", 0, 10));
        this.jLabel_Header.setForeground(new Color(255, 255, 255));
        this.jLabel_Header.setHorizontalAlignment(2);
        this.jLabel_Header.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        this.add((Component)this.jLabel_Header, gridBagConstraints);
        this.jTextField_Percent.setBackground(new Color(0, 0, 0));
        this.jTextField_Percent.setFont(new Font("Tahoma", 0, 12));
        this.jTextField_Percent.setForeground(new Color(0, 255, 0));
        this.jTextField_Percent.setHorizontalAlignment(0);
        this.jTextField_Percent.setText("100");
        this.jTextField_Percent.setToolTipText("Value in percentage");
        this.jTextField_Percent.setBorder(null);
        this.jTextField_Percent.setMaximumSize(new Dimension(20, 15));
        this.jTextField_Percent.setMinimumSize(new Dimension(20, 15));
        this.jTextField_Percent.setOpaque(false);
        this.jTextField_Percent.setPreferredSize(new Dimension(20, 15));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.add((Component)this.jTextField_Percent, gridBagConstraints);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof ControlObject) {
            if ("adjusterActiveDimension".equals(evt.getPropertyName())) {
                this.m_ActiveControlDimension = (ControlObject.ControlDimension)evt.getNewValue();
                EventQueueHandler.invokeLater(this.m_RunnableRefreshTextFields);
            } else if ("controlMaster".equals(evt.getPropertyName())) {
                this.m_IsMaster = (Boolean)evt.getNewValue();
            }
        } else if (evt.getSource() == this.m_ControlDimension) {
            if (this.m_ControlDimension == null) {
                return;
            }
            if ("value".equals(evt.getPropertyName())) {
                if (this.m_IsMaster) {
                    return;
                }
                this.setValue(this.m_ControlDimension.getValue());
            } else if ("valueAdjustedManually".equals(evt.getPropertyName())) {
                if (this.m_IsMaster) {
                    return;
                }
                this.setValue(this.m_ControlDimension.getValue());
            } else if ("valueFactor".equals(evt.getPropertyName())) {
                if (!this.m_IsMaster) {
                    return;
                }
                this.setValue(this.m_ControlDimension.getValueMaximum() * (Double)evt.getNewValue());
            }
        } else if (evt.getSource() == this.m_ControlDimensionType) {
            if ("controldimensiontypeDeviceControlLink".equals(evt.getPropertyName())) {
                this.checkByteResolution();
            } else if ("controldimensiontypeDeviceControlLinkByte".equals(evt.getPropertyName())) {
                this.checkByteResolution();
            }
        }
    }

    @Override
    public void eventDMXShowUnitMixer(boolean p_ShowPercent, boolean p_ShowByteValues) {
        EventQueueHandler.invokeLater(this.m_RunnableRefreshTextFields);
    }
}

