/*
 * Decompiled with CFR 0.152.
 */
package DMXMixer;

import DMXMixer.DMXControlComponent;
import DMXMixer.DMXControl_Dimmer;
import DMXScenePackage.DMXScene;
import LiveShowControlModels.ControlLabelModel;
import LiveShowControlObjects.ControlObject;
import SwingToolTipPackage.PopUpToolTip;
import ToolsGraphics.JLabelBackground;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DMXControlDisplayLabel
extends JPanel {
    public static Image s_IconDeactivated = new ImageIcon(DMXScene.class.getResource("/IconsPackage/Deactivated.png")).getImage();
    public static final Color s_DimmerColor_Low = Color.WHITE;
    public static final Color s_DimmerColor_Middle = new Color(0, 127, 0);
    public static final Color s_DimmerColor_High = new Color(0, 0, 0);
    private DMXControlComponent m_DMXControlComponent;
    private ArrayList<ControlObject.ControlDimension> m_ControlDimensions;
    private ArrayList<Double> m_Values;
    private int m_BytesResolution_Linked_Max;
    private ControlLabelModel.ControlLabelList m_LastControlLabelList;
    private ControlLabelModel.ControlLabelDescription m_LastControlLabelDescription;
    private String m_ToolTipText_Foreign;
    private String m_ToolTipText_DMXControl;
    private String m_ToolTipText_ListValue;
    private StringBuffer m_ToolTipTextStringBuffer;
    private StringBuffer m_ToolTipText_ListStringBuffer;
    private Image m_Image;
    private Color m_Color;
    private int m_BackgroundStyle;
    private boolean m_Deactivated;
    private MouseAdapter m_MouseAdapterRedirect;
    private ArrayList<MouseListener> m_MouseListeners;
    private ArrayList<MouseMotionListener> m_MouseMotionListeners;
    private ArrayList<MouseWheelListener> m_MouseWheelListeners;
    private final Object m_SyncMouseListeners = new Object();
    private JLabelBackground jLabelBackground1;
    private JLabel jLabelValueIsOn;
    private JLabel jLabel_List;
    private JLabel jLabel_Value;

    public DMXControlDisplayLabel() {
        this.initMembers();
        this.initComponents();
        this.initComponentsFurther();
    }

    private void initMembers() {
        this.m_DMXControlComponent = null;
        this.m_Values = new ArrayList();
        this.m_ControlDimensions = new ArrayList();
        this.m_ToolTipTextStringBuffer = new StringBuffer();
        this.m_ToolTipText_Foreign = null;
        this.m_ToolTipText_ListStringBuffer = new StringBuffer();
        this.m_ToolTipText_DMXControl = "";
        this.m_ToolTipText_ListValue = "";
        this.m_Deactivated = false;
        this.m_BackgroundStyle = 0;
        this.m_MouseListeners = new ArrayList();
        this.m_MouseMotionListeners = new ArrayList();
        this.m_MouseWheelListeners = new ArrayList();
    }

    private void initComponentsFurther() {
        this.jLabelBackground1.setText("");
        this.jLabelBackground1.setBackgroundOpaque(true);
        this.jLabel_List.setVisible(false);
        this.jLabelValueIsOn.setVisible(false);
        this.jLabel_Value.setVisible(false);
        this.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jLabel_Value.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.m_MouseAdapterRedirect = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                DMXControlDisplayLabel.this.sendMouseClicked(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                DMXControlDisplayLabel.this.sendMousePressed(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                DMXControlDisplayLabel.this.sendMouseReleased(e);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                DMXControlDisplayLabel.this.sendMouseEntered(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                DMXControlDisplayLabel.this.sendMouseExited(e);
            }

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                DMXControlDisplayLabel.this.sendMouseWheelMoved(e);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                DMXControlDisplayLabel.this.sendMouseDragged(e);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                DMXControlDisplayLabel.this.sendMouseMoved(e);
            }
        };
        super.addMouseListener(this.m_MouseAdapterRedirect);
        this.jLabel_Value.addMouseListener(this.m_MouseAdapterRedirect);
        this.jLabel_Value.addMouseMotionListener(this.m_MouseAdapterRedirect);
        this.jLabel_Value.addMouseWheelListener(this.m_MouseAdapterRedirect);
        this.jLabelBackground1.addMouseListener(this.m_MouseAdapterRedirect);
        this.jLabelBackground1.addMouseMotionListener(this.m_MouseAdapterRedirect);
        this.jLabelBackground1.addMouseWheelListener(this.m_MouseAdapterRedirect);
        this.jLabelValueIsOn.addMouseListener(this.m_MouseAdapterRedirect);
        this.jLabelValueIsOn.addMouseMotionListener(this.m_MouseAdapterRedirect);
        this.jLabelValueIsOn.addMouseWheelListener(this.m_MouseAdapterRedirect);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.setComponentPopupMenu(null);
        this.jLabel_Value.setComponentPopupMenu(null);
        super.removeMouseListener(this.m_MouseAdapterRedirect);
        this.jLabel_Value.removeMouseListener(this.m_MouseAdapterRedirect);
        this.jLabel_Value.removeMouseMotionListener(this.m_MouseAdapterRedirect);
        this.jLabel_Value.removeMouseWheelListener(this.m_MouseAdapterRedirect);
        this.jLabelBackground1.removeMouseListener(this.m_MouseAdapterRedirect);
        this.jLabelBackground1.removeMouseMotionListener(this.m_MouseAdapterRedirect);
        this.jLabelBackground1.removeMouseWheelListener(this.m_MouseAdapterRedirect);
        this.jLabelValueIsOn.removeMouseListener(this.m_MouseAdapterRedirect);
        this.jLabelValueIsOn.removeMouseMotionListener(this.m_MouseAdapterRedirect);
        this.jLabelValueIsOn.removeMouseWheelListener(this.m_MouseAdapterRedirect);
        Object object = this.m_SyncMouseListeners;
        synchronized (object) {
            this.m_MouseListeners.clear();
            this.m_MouseMotionListeners.clear();
            this.m_MouseWheelListeners.clear();
        }
        this.m_DMXControlComponent = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMouseClicked(MouseEvent p_MouseEvent) {
        if (p_MouseEvent == null) {
            return;
        }
        p_MouseEvent.setSource(this);
        Object object = this.m_SyncMouseListeners;
        synchronized (object) {
            for (int intListener = 0; intListener < this.m_MouseListeners.size(); ++intListener) {
                MouseListener o_MouseListener = this.m_MouseListeners.get(intListener);
                o_MouseListener.mouseClicked(p_MouseEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMousePressed(MouseEvent p_MouseEvent) {
        if (p_MouseEvent == null) {
            return;
        }
        p_MouseEvent.setSource(this);
        Object object = this.m_SyncMouseListeners;
        synchronized (object) {
            for (int intListener = 0; intListener < this.m_MouseListeners.size(); ++intListener) {
                MouseListener o_MouseListener = this.m_MouseListeners.get(intListener);
                o_MouseListener.mousePressed(p_MouseEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMouseReleased(MouseEvent p_MouseEvent) {
        if (p_MouseEvent == null) {
            return;
        }
        p_MouseEvent.setSource(this);
        Object object = this.m_SyncMouseListeners;
        synchronized (object) {
            for (int intListener = 0; intListener < this.m_MouseListeners.size(); ++intListener) {
                MouseListener o_MouseListener = this.m_MouseListeners.get(intListener);
                o_MouseListener.mouseReleased(p_MouseEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMouseEntered(MouseEvent p_MouseEvent) {
        if (p_MouseEvent == null) {
            return;
        }
        p_MouseEvent.setSource(this);
        Object object = this.m_SyncMouseListeners;
        synchronized (object) {
            for (int intListener = 0; intListener < this.m_MouseListeners.size(); ++intListener) {
                MouseListener o_MouseListener = this.m_MouseListeners.get(intListener);
                o_MouseListener.mouseEntered(p_MouseEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMouseExited(MouseEvent p_MouseEvent) {
        if (p_MouseEvent == null) {
            return;
        }
        p_MouseEvent.setSource(this);
        Object object = this.m_SyncMouseListeners;
        synchronized (object) {
            for (int intListener = 0; intListener < this.m_MouseListeners.size(); ++intListener) {
                MouseListener o_MouseListener = this.m_MouseListeners.get(intListener);
                o_MouseListener.mouseExited(p_MouseEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMouseWheelMoved(MouseWheelEvent p_MouseWheelEvent) {
        if (p_MouseWheelEvent == null) {
            return;
        }
        p_MouseWheelEvent.setSource(this);
        Object object = this.m_SyncMouseListeners;
        synchronized (object) {
            for (int intListener = 0; intListener < this.m_MouseWheelListeners.size(); ++intListener) {
                MouseWheelListener o_MouseListener = this.m_MouseWheelListeners.get(intListener);
                o_MouseListener.mouseWheelMoved(p_MouseWheelEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMouseDragged(MouseEvent p_MouseEvent) {
        if (p_MouseEvent == null) {
            return;
        }
        p_MouseEvent.setSource(this);
        Object object = this.m_SyncMouseListeners;
        synchronized (object) {
            for (int intListener = 0; intListener < this.m_MouseMotionListeners.size(); ++intListener) {
                MouseMotionListener o_MouseListener = this.m_MouseMotionListeners.get(intListener);
                o_MouseListener.mouseDragged(p_MouseEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMouseMoved(MouseEvent p_MouseEvent) {
        if (p_MouseEvent == null) {
            return;
        }
        p_MouseEvent.setSource(this);
        Object object = this.m_SyncMouseListeners;
        synchronized (object) {
            for (int intListener = 0; intListener < this.m_MouseMotionListeners.size(); ++intListener) {
                MouseMotionListener o_MouseListener = this.m_MouseMotionListeners.get(intListener);
                o_MouseListener.mouseMoved(p_MouseEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMouseListener(MouseListener p_MouseListener) {
        if (p_MouseListener == null) {
            return;
        }
        Object object = this.m_SyncMouseListeners;
        synchronized (object) {
            if (this.m_MouseListeners.contains(p_MouseListener)) {
                return;
            }
            this.m_MouseListeners.add(p_MouseListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMouseListener(MouseListener p_MouseListener) {
        if (p_MouseListener == null) {
            return;
        }
        Object object = this.m_SyncMouseListeners;
        synchronized (object) {
            this.m_MouseListeners.add(p_MouseListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMouseMotionListener(MouseMotionListener p_MouseMotionListener) {
        if (p_MouseMotionListener == null) {
            return;
        }
        Object object = this.m_SyncMouseListeners;
        synchronized (object) {
            if (this.m_MouseMotionListeners.contains(p_MouseMotionListener)) {
                return;
            }
            this.m_MouseMotionListeners.add(p_MouseMotionListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMouseMotionListener(MouseMotionListener p_MouseMotionListener) {
        if (p_MouseMotionListener == null) {
            return;
        }
        Object object = this.m_SyncMouseListeners;
        synchronized (object) {
            this.m_MouseMotionListeners.remove(p_MouseMotionListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMouseWheelListener(MouseWheelListener p_MouseWheelListener) {
        if (p_MouseWheelListener == null) {
            return;
        }
        Object object = this.m_SyncMouseListeners;
        synchronized (object) {
            if (this.m_MouseWheelListeners.contains(p_MouseWheelListener)) {
                return;
            }
            this.m_MouseWheelListeners.add(p_MouseWheelListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMouseWheelListener(MouseWheelListener p_MouseWheelListener) {
        if (p_MouseWheelListener == null) {
            return;
        }
        Object object = this.m_SyncMouseListeners;
        synchronized (object) {
            this.m_MouseWheelListeners.remove(p_MouseWheelListener);
        }
    }

    public void addMouseListener_List(MouseListener p_MouseListener) {
        this.jLabel_List.addMouseListener(p_MouseListener);
    }

    public void setBackgroundStyle(int p_BackgroundStyle) {
        this.m_BackgroundStyle = p_BackgroundStyle;
        this.jLabelBackground1.setText("");
        this.jLabelBackground1.setBackgroundStyle(this.m_BackgroundStyle);
        this.jLabelBackground1.setBackgroundOpaque(true);
    }

    public void setDMXControlComponent(DMXControlComponent p_DMXControlComponent) {
        this.m_DMXControlComponent = p_DMXControlComponent;
    }

    public DMXControlComponent getDMXControlComponent() {
        return this.m_DMXControlComponent;
    }

    @Override
    public void setFont(Font p_Font) {
        if (this.jLabel_Value == null) {
            super.setFont(p_Font);
        } else {
            this.jLabel_Value.setFont(p_Font);
        }
    }

    @Override
    public Font getFont() {
        if (this.jLabel_Value == null) {
            return super.getFont();
        }
        return this.jLabel_Value.getFont();
    }

    public void setSurface(ControlLabelModel.ControlLabelList p_ControlLabelList, ControlLabelModel.ControlLabelDescription p_ControlLabelDescription, Color p_Color, Image p_Image, ArrayList<ControlObject.ControlDimension> p_ControlDimensions, ArrayList<Double> p_Values, boolean p_IsOn) {
        if (p_Color != null) {
            this.setColor(p_Color);
        }
        if (p_Image != null) {
            this.setImage(p_Image);
        }
        this.m_ControlDimensions = p_ControlDimensions;
        this.m_Values = p_Values;
        if (this.m_DMXControlComponent instanceof DMXControl_Dimmer) {
            this.jLabelValueIsOn.setVisible(false);
            if (p_IsOn) {
                this.jLabel_Value.setVisible(true);
                int intValue = (int)(this.m_Values.get(0) / 65535.0 * 100.0 + 0.5);
                if (intValue < 45) {
                    this.jLabel_Value.setForeground(s_DimmerColor_Low);
                } else {
                    this.jLabel_Value.setForeground(s_DimmerColor_High);
                }
                this.jLabel_Value.setText(String.valueOf(intValue));
            } else {
                this.jLabel_Value.setVisible(false);
            }
        } else {
            this.jLabel_Value.setVisible(false);
            if (p_IsOn) {
                this.jLabelValueIsOn.setVisible(true);
            } else {
                this.jLabelValueIsOn.setVisible(false);
            }
        }
        this.m_BytesResolution_Linked_Max = 0;
        for (int intControlDimension = 0; intControlDimension < this.m_ControlDimensions.size(); ++intControlDimension) {
            ControlObject.ControlDimension o_ControlDimension = this.m_ControlDimensions.get(intControlDimension);
            int intByteResolution_Linked = this.m_DMXControlComponent == null ? 0 : this.m_DMXControlComponent.getByteResolution_Linked(o_ControlDimension);
            if (intByteResolution_Linked <= this.m_BytesResolution_Linked_Max) continue;
            this.m_BytesResolution_Linked_Max = intByteResolution_Linked;
        }
        if (p_ControlLabelList != this.m_LastControlLabelList) {
            this.m_LastControlLabelList = p_ControlLabelList;
            if (p_ControlLabelList != null) {
                this.setToolTipText_PartList(p_ControlLabelList.getListDescription());
            }
        }
    }

    public void setDeactivated(boolean p_Deactivated) {
        if (this.m_Deactivated == p_Deactivated) {
            return;
        }
        this.m_Deactivated = p_Deactivated;
        this.refreshLabel();
    }

    public boolean getDeactivated() {
        return this.m_Deactivated;
    }

    public int getValuesCount() {
        return this.m_Values.size();
    }

    public ArrayList<Double> getValues() {
        return this.m_Values;
    }

    public double getValue(int p_Index) {
        if (p_Index < 0 || p_Index >= this.m_Values.size()) {
            return -1.0;
        }
        return this.m_Values.get(p_Index);
    }

    public void setValue(int p_Index, double p_Value) {
        if (p_Index < 0 || p_Index >= this.m_Values.size()) {
            return;
        }
        this.m_Values.set(p_Index, p_Value);
    }

    public String getValueString(int p_Index) {
        if (p_Index < 0 || p_Index >= this.m_Values.size()) {
            return "";
        }
        ControlObject.ControlDimension o_ControlDimension = this.m_ControlDimensions.get(p_Index);
        StringBuffer o_StringBuffer = new StringBuffer();
        Double doubleValue = this.m_Values.get(p_Index);
        int intValue = doubleValue.intValue();
        int intValueHigh = intValue / 256;
        int intValueLow = intValue - intValueHigh * 256;
        switch (this.m_BytesResolution_Linked_Max) {
            case 0: {
                break;
            }
            case 1: {
                int intValuePercent = (int)((double)intValueLow / 255.0 * 100.0 + 0.5);
                o_StringBuffer.append("<font color=\"#00cc00\">");
                o_StringBuffer.append(intValuePercent);
                o_StringBuffer.append("% ");
                o_StringBuffer.append("</font>");
                o_StringBuffer.append("<font color=\"#cccc00\">");
                o_StringBuffer.append(intValueLow);
                o_StringBuffer.append("</font>");
                break;
            }
            case 2: {
                int intValuePercent = (int)((double)intValueHigh / 255.0 * 100.0 + 0.5);
                o_StringBuffer.append("<font color=\"#00cc00\">");
                o_StringBuffer.append(intValuePercent);
                o_StringBuffer.append("% ");
                o_StringBuffer.append("</font>");
                o_StringBuffer.append("<font color=\"#cccccc\">");
                o_StringBuffer.append(" ");
                o_StringBuffer.append(intValueHigh);
                o_StringBuffer.append("</font>");
                break;
            }
            case 3: {
                int intValuePercent = (int)((double)intValue / 65535.0 * 100.0 + 0.5);
                o_StringBuffer.append("<font color=\"#00cc00\">");
                o_StringBuffer.append(intValuePercent);
                o_StringBuffer.append("% ");
                o_StringBuffer.append("</font>");
                o_StringBuffer.append("<font color=\"cccccc\">");
                o_StringBuffer.append(" ");
                o_StringBuffer.append(intValueHigh);
                o_StringBuffer.append("</font>");
                o_StringBuffer.append("<font color=\"#cccc00\">");
                o_StringBuffer.append(" ");
                o_StringBuffer.append(intValueLow);
                o_StringBuffer.append("</font>");
            }
        }
        return o_StringBuffer.toString();
    }

    public int getControlDimensionsCount() {
        return this.m_ControlDimensions.size();
    }

    public ControlObject.ControlDimension getControlDimension(int p_Index) {
        if (p_Index < 0 || p_Index >= this.m_ControlDimensions.size()) {
            return null;
        }
        return this.m_ControlDimensions.get(p_Index);
    }

    public int getIndexOf(ControlObject.ControlDimension p_ControlDimension) {
        return this.m_ControlDimensions.indexOf(p_ControlDimension);
    }

    public String getControlName(int p_Index) {
        if (p_Index < 0 || p_Index >= this.m_ControlDimensions.size()) {
            return "";
        }
        return this.m_ControlDimensions.get(p_Index).getDimensionName();
    }

    public int getBytesResolution_LinkedMax() {
        return this.m_BytesResolution_Linked_Max;
    }

    public void setImage(Image p_BackgroundImage) {
        if (this.m_Image == p_BackgroundImage) {
            return;
        }
        this.m_Image = p_BackgroundImage;
        this.refreshLabel();
    }

    public void setColor(Color p_Color) {
        if (this.m_Color == null ? p_Color == null : this.m_Color.equals(p_Color)) {
            return;
        }
        this.m_Color = p_Color;
        this.refreshLabel();
    }

    public Color getColor() {
        return this.jLabelBackground1.getBackground();
    }

    private void refreshLabel() {
        if (this.m_Deactivated) {
            this.jLabelBackground1.setBackgroundStyle(2);
            this.jLabelBackground1.setBackgroundImage(s_IconDeactivated);
        } else {
            this.jLabelBackground1.setBackgroundStyle(this.m_BackgroundStyle);
            if (this.m_Color != null) {
                this.jLabelBackground1.setBackground(this.m_Color);
            }
            this.jLabelBackground1.setBackgroundImage(this.m_Image);
        }
    }

    public void setToolTipText_Foreign(String p_ToolTipText) {
        this.m_ToolTipText_Foreign = p_ToolTipText;
        this.refreshToolTipText();
    }

    public void setToolTipText_PartDMXControl(String p_ToolTipText) {
        this.m_ToolTipText_DMXControl = p_ToolTipText;
        this.refreshToolTipText();
    }

    public void setToolTipText_PartListValue(String p_ToolTipText) {
        if (p_ToolTipText == null) {
            return;
        }
        if (this.m_ToolTipText_ListValue.equals(p_ToolTipText)) {
            return;
        }
        this.m_ToolTipText_ListValue = p_ToolTipText;
        this.refreshToolTipText();
    }

    public void setToolTipText_PartList(String p_ToolTipText) {
        this.m_ToolTipText_ListStringBuffer.delete(0, this.m_ToolTipText_ListStringBuffer.length());
        this.m_ToolTipText_ListStringBuffer.append("<html>");
        this.m_ToolTipText_ListStringBuffer.append(p_ToolTipText);
        this.m_ToolTipText_ListStringBuffer.append("</html>");
        this.jLabel_List.setToolTipText(this.m_ToolTipText_ListStringBuffer.toString());
    }

    private void refreshToolTipText() {
        if (this.m_ToolTipText_Foreign != null) {
            this.setToolTipText(this.m_ToolTipText_Foreign);
            this.jLabelBackground1.setToolTipText(this.m_ToolTipText_Foreign);
            this.jLabelValueIsOn.setToolTipText(this.m_ToolTipText_Foreign);
            if (this.jLabel_Value != null) {
                this.jLabel_Value.setToolTipText(this.m_ToolTipText_Foreign);
            }
            return;
        }
        this.m_ToolTipTextStringBuffer.delete(0, this.m_ToolTipTextStringBuffer.length());
        this.m_ToolTipTextStringBuffer.append("<html>");
        this.m_ToolTipTextStringBuffer.append("<center>");
        this.m_ToolTipTextStringBuffer.append(this.m_ToolTipText_DMXControl);
        if (this.m_ToolTipText_ListValue.length() > 0) {
            this.m_ToolTipTextStringBuffer.append("<br>");
            this.m_ToolTipTextStringBuffer.append(this.m_ToolTipText_ListValue);
        }
        this.m_ToolTipTextStringBuffer.append("</center>");
        this.m_ToolTipTextStringBuffer.append("</html>");
        String stringToolTipText = this.m_ToolTipTextStringBuffer.toString();
        this.jLabelBackground1.setToolTipText(stringToolTipText);
        this.jLabelValueIsOn.setToolTipText(stringToolTipText);
        this.setToolTipText(stringToolTipText);
        if (this.jLabel_Value != null) {
            this.jLabel_Value.setToolTipText(stringToolTipText);
        }
    }

    public void setListCount(int p_ListCount) {
        if (p_ListCount < 2) {
            this.jLabel_List.setVisible(false);
        } else {
            this.jLabel_List.setVisible(true);
        }
    }

    public void setListIndex(int p_Index) {
        this.jLabel_List.setText(String.valueOf(p_Index + 1));
    }

    private void initComponents() {
        this.jLabel_Value = new JLabel();
        this.jLabelValueIsOn = new JLabel();
        this.jLabel_List = new JLabel();
        this.jLabelBackground1 = new JLabelBackground();
        this.setBorder(BorderFactory.createEtchedBorder(0, null, new Color(0, 0, 0)));
        this.setLayout(new GridBagLayout());
        this.jLabel_Value.setFont(new Font("Tahoma", 0, 12));
        this.jLabel_Value.setText("100");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.jLabel_Value, gridBagConstraints);
        this.jLabelValueIsOn.setBackground(new Color(255, 255, 0));
        this.jLabelValueIsOn.setIconTextGap(0);
        this.jLabelValueIsOn.setMaximumSize(new Dimension(5, 5));
        this.jLabelValueIsOn.setMinimumSize(new Dimension(5, 5));
        this.jLabelValueIsOn.setName("");
        this.jLabelValueIsOn.setOpaque(true);
        this.jLabelValueIsOn.setPreferredSize(new Dimension(5, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.jLabelValueIsOn, gridBagConstraints);
        this.jLabel_List.setBackground(new Color(255, 255, 255));
        this.jLabel_List.setBorder(BorderFactory.createEtchedBorder(null, new Color(0, 0, 0)));
        this.jLabel_List.setMaximumSize(new Dimension(16, 16));
        this.jLabel_List.setMinimumSize(new Dimension(16, 16));
        this.jLabel_List.setOpaque(true);
        this.jLabel_List.setPreferredSize(new Dimension(16, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 14;
        this.add((Component)this.jLabel_List, gridBagConstraints);
        this.jLabelBackground1.setBackground(new Color(0, 0, 0));
        this.jLabelBackground1.setForeground(new Color(255, 255, 255));
        this.jLabelBackground1.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jLabelBackground1, gridBagConstraints);
    }
}

