/*
 * Decompiled with CFR 0.152.
 */
package DMXMixer;

import DMXDeviceEditorPackage.LiveShowDMXDeviceEditor;
import DMXDevicePackage.DMXDevice;
import DMXDevicePackage.DMXDeviceType;
import DMXMixer.DMXControlComponentPool;
import DMXMixer.DMXControlDescription;
import DMXMixer.DMXControlDisplayLabel;
import DMXMixer.DMXControlSettings;
import DMXMixer.DMXControlSpecialSettings;
import DMXMixer.DMXControl_Dimmer;
import DMXMixer.DMXControl_FreeDimmer;
import DMXMixer.DMXControl_FreeFader;
import DMXMixer.DMXControl_FreeSwitch;
import DMXMixer.DMXControl_GridPanTilt;
import DMXMixer.DMXControl_RGB;
import DMXScenePackage.DMXScene;
import DMXVirtualPackage.DMXFadeDescription;
import GUID.LiveGUID;
import JarLoader.JarResources;
import LiveShowControlModels.ControlBlockModel;
import LiveShowControlModels.ControlFunctionModel;
import LiveShowControlModels.ControlLabelModel;
import LiveShowControlObjects.ControlObject;
import LiveShowControlObjects.ValueSelectionInterface;
import LiveShowControls.CorrectionModel;
import LiveShowControls.JControlMeter;
import LiveShowObjectPackage.SinglePropertyChangeSupport;
import LiveShowVirtualPackage.LiveShowVIP;
import SPITActionPackage.SPIT_ActionStatus;
import SPITActionPackage.SPIT_Action_Interface;
import SPITLibraryPackage.SPIT_Object_Interface;
import SPITLibraryPackage.SPIT_Type_Interface;
import SPITRemotePackage.SPITRemote;
import StartPackage.LiveShowDMXSystem;
import SwingModelPackage.TableAndListModel;
import SynchronizationPackage.EventQueueHandler;
import SynchronizationPackage.LiveCloseSemaphore;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public abstract class DMXControlComponent
extends JPanel
implements PropertyChangeListener,
SPIT_Action_Interface {
    public static String JARRESOURCENAME_DEFAULT = "LiveShowControls_Black";
    public static final String PROP_COMPONENTCLOSED = "DMXControlClosed";
    public static Border s_DisplayLabelBorderNormal = new LineBorder(Color.GRAY, 1);
    public static Border s_DisplayLabelBorderDisabled = new LineBorder(Color.RED, 2);
    public static Border s_DisplayLabelBorderDisabledAdjustment = new LineBorder(Color.ORANGE, 2);
    public static Border s_SelectedBorder = new LineBorder(Color.BLUE, 1);
    protected DMXControlType m_DMXControlType;
    protected ArrayList<ControlObject> m_ControlObjects;
    protected ArrayList<ArrayList<JControlMeter>> m_ControlMeters;
    protected int m_MixerPanelOwner;
    protected ControlObject m_ControlObjectValueChanged;
    private GridBagConstraints m_GridBagConstraints;
    protected boolean m_Editable;
    protected Border m_Border;
    protected boolean m_Selected;
    protected boolean m_EnableSettings;
    protected boolean m_DisabledByDefault;
    protected boolean m_DisabledAdjustmentByDefault;
    protected boolean m_IsVisible;
    protected DMXControlSettings m_DMXControlSettings;
    protected JDialog m_JDialog;
    protected DMXDeviceType m_DMXDeviceType;
    protected DMXControlComponentPool m_DMXControlComponentPool;
    protected HashMap<DMXDevice, DeviceSettingsPanel> m_LinkedDeviceSettingsPanels;
    protected ArrayList<DMXDevice> m_LinkedDMDevices;
    protected DMXDevice.TreeModel_Device_Channels m_DMXDeviceTreeModel_Channel;
    protected boolean m_IsMaster;
    protected DMXControlSpecialSettings m_DMXControlSpecialSettings;
    protected ArrayList<ManuallyChangeListener> m_ManuallyChangeListeners;
    private final Object m_SyncListeners = new Object();
    protected Runnable m_RunnableCloseDialog;
    protected double m_ValueSPITInput_Old;
    public static DMXControlComponentCellRenderer s_DMXControlComponentCellRenderer = new DMXControlComponentCellRenderer();

    public static Class<?> loadDMXControlClass(String p_ClassName) {
        Class<?> o_ClassObject;
        ClassLoader o_ClassLoader = ClassLoader.getSystemClassLoader();
        try {
            o_ClassObject = o_ClassLoader.loadClass(p_ClassName);
        }
        catch (Exception e) {
            return null;
        }
        return o_ClassObject;
    }

    public static DMXControlComponent loadDMXControlComponent(DMXControlType p_DMXControlType) {
        DMXControlComponent o_DMXControlComponent;
        if (p_DMXControlType == null) {
            return null;
        }
        Class<?> classControlComponent = DMXControlComponent.loadDMXControlClass(p_DMXControlType.getClassName());
        if (classControlComponent == null) {
            return null;
        }
        try {
            Constructor<?> o_Constructor = classControlComponent.getConstructor(DMXControlType.class);
            if (o_Constructor == null) {
                // empty if block
            }
            o_DMXControlComponent = (DMXControlComponent)o_Constructor.newInstance(p_DMXControlType);
        }
        catch (Exception e) {
            return null;
        }
        return o_DMXControlComponent;
    }

    public static DMXControlComponent loadDMXControlComponent(DMXControlType p_DMXControlType, DMXDevice.TreeModel_Device_Channels p_DMXDeviceTreeModel_Channel) {
        DMXControlComponent o_DMXControlComponent = DMXControlComponent.loadDMXControlComponent(p_DMXControlType);
        if (o_DMXControlComponent == null) {
            return null;
        }
        o_DMXControlComponent.setDMXDeviceTreeModel(p_DMXDeviceTreeModel_Channel);
        return o_DMXControlComponent;
    }

    public static DMXControlComponent getDMXControlComponent(DMXControlComponentPool p_DMXControlComponentPool, String p_ID) {
        if (p_DMXControlComponentPool == null) {
            return null;
        }
        if (p_ID == null) {
            return null;
        }
        return p_DMXControlComponentPool.getDMXControlComponentByID(p_ID);
    }

    public static ControlObject.ControlDimension getControlDimension(DMXControlComponentPool p_DMXControlComponentPool, ControlLabelModel.LabelListCondition p_LabelListCondition) {
        if (p_DMXControlComponentPool == null) {
            return null;
        }
        if (p_LabelListCondition == null) {
            return null;
        }
        DMXControlComponent o_DMXControlComponent = p_DMXControlComponentPool.getDMXControlComponentByID(p_LabelListCondition.getRemoteID());
        return DMXControlComponent.getControlDimension(o_DMXControlComponent, p_LabelListCondition.getRemoteControlIndex(), p_LabelListCondition.getRemoteDimensionIndex());
    }

    public static ControlObject.ControlDimension getControlDimension(DMXControlComponent p_DMXControlComponent, int p_ControlIndex, int p_DimensionIndex) {
        if (p_DMXControlComponent == null) {
            return null;
        }
        ControlObject o_ControlObject = p_DMXControlComponent.getControlObject(p_ControlIndex);
        if (o_ControlObject == null) {
            return null;
        }
        ControlObject.ControlDimension o_ControlDimension = o_ControlObject.getControlDimension(p_DimensionIndex);
        return o_ControlDimension;
    }

    public DMXControlComponent(DMXControlType p_DMXControlType) {
        this.initMembers();
        this.initComponents();
        this.m_DMXControlType = p_DMXControlType == null ? new DMXControlType(this.getClassName(), "", "") : p_DMXControlType;
    }

    private void initMembers() {
        this.m_MixerPanelOwner = 0;
        this.m_IsMaster = false;
        this.m_GridBagConstraints = new GridBagConstraints();
        this.m_DMXControlType = null;
        this.m_Selected = false;
        this.m_IsVisible = false;
        this.m_Border = new LineBorder(Color.GRAY, 2);
        this.m_EnableSettings = true;
        this.m_DisabledByDefault = false;
        this.m_DisabledAdjustmentByDefault = false;
        this.m_DMXDeviceType = null;
        this.m_ControlObjects = new ArrayList();
        this.m_ControlMeters = new ArrayList();
        this.m_LinkedDeviceSettingsPanels = new HashMap();
        this.m_LinkedDMDevices = new ArrayList();
        this.m_DMXControlSpecialSettings = null;
        this.m_RunnableCloseDialog = new Runnable(){

            @Override
            public void run() {
                try {
                    if (DMXControlComponent.this.m_JDialog == null) {
                        return;
                    }
                    DMXControlComponent.this.m_JDialog.dispose();
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                }
            }
        };
        this.m_ManuallyChangeListeners = new ArrayList();
        this.m_ValueSPITInput_Old = 0.0;
    }

    private void initComponents() {
        this.setBackground(new Color(153, 153, 153));
        this.setMinimumSize(new Dimension(40, 50));
        this.setOpaque(true);
        this.setPreferredSize(new Dimension(40, 100));
        this.setLayout(new GridBagLayout());
    }

    protected void initDMXControlComponentFinal() {
        this.refreshDMXControl_Component_Type(true, false);
        this.m_DMXControlType.setInstance(this);
    }

    public void setMixerPanelOwner(int p_MixerPanelOwner) {
        if (this.m_MixerPanelOwner == p_MixerPanelOwner) {
            return;
        }
        this.m_MixerPanelOwner = p_MixerPanelOwner;
        if (this.m_DMXControlType != null) {
            this.m_DMXControlType.setMixerPanelOwner(this.m_MixerPanelOwner);
        }
    }

    public int getMixerPanelOwner() {
        return this.m_MixerPanelOwner;
    }

    public abstract void changedParentHeight(int var1);

    public void clearInstance() {
        if (this.m_DMXControlSettings != null) {
            this.m_DMXControlSettings.close();
        }
        if (this.m_JDialog != null) {
            this.m_JDialog.removeWindowFocusListener(LiveShowDMXSystem.getHelpFocusListener());
            EventQueueHandler.invokeLater(this.m_RunnableCloseDialog);
            this.m_JDialog = null;
        }
        int intControlObjectCount = this.m_ControlObjects.size();
        for (int intControlObject = intControlObjectCount - 1; intControlObject >= 0; --intControlObject) {
            ControlObject o_ControlObject = this.m_ControlObjects.get(intControlObject);
            if (o_ControlObject != null) {
                o_ControlObject.removePropertyChangeListener((PropertyChangeListener)this);
            }
            this.m_ControlObjects.remove(intControlObject);
        }
        if (this.m_DMXControlType != null) {
            this.m_DMXControlType.setInstance(null);
            this.m_DMXControlType = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.m_SyncListeners;
        synchronized (object) {
            this.m_ManuallyChangeListeners.clear();
        }
        if (this.m_DMXControlSettings != null) {
            this.m_DMXControlSettings.close();
        }
        if (this.m_JDialog != null) {
            EventQueueHandler.invokeLater(this.m_RunnableCloseDialog);
            this.m_JDialog = null;
        }
        if (this.m_ControlObjects != null) {
            int intControlObjectCount = this.m_ControlObjects.size();
            for (int intControlObject = intControlObjectCount - 1; intControlObject >= 0; --intControlObject) {
                ControlObject o_ControlObject = this.m_ControlObjects.get(intControlObject);
                if (o_ControlObject != null) {
                    o_ControlObject.removePropertyChangeListener((PropertyChangeListener)this);
                }
                this.m_ControlObjects.remove(intControlObject);
            }
        }
        if (this.m_DMXControlType != null) {
            this.m_DMXControlType.close();
            this.m_DMXControlType = null;
        }
        this.m_DMXControlComponentPool = null;
    }

    public String getClassName() {
        return this.getClass().getName();
    }

    public String getClassSimpleName() {
        return this.getClass().getSimpleName();
    }

    public void setDMXControlComponentPool(DMXControlComponentPool p_DMXControlComponentPool) {
        this.m_DMXControlComponentPool = p_DMXControlComponentPool;
    }

    public DMXControlComponentPool getDMXControlComponentPool() {
        return this.m_DMXControlComponentPool;
    }

    @Override
    public String getName() {
        String stringName = "";
        if (this.m_DMXControlType != null) {
            stringName = this.m_DMXControlType.getName();
        }
        return stringName;
    }

    @Override
    public void setName(String p_Name) {
        if (this.m_DMXControlType != null) {
            this.m_DMXControlType.setName(p_Name);
            if (this.m_DMXControlType.getControlTypeCount() == 1) {
                ControlObject o_ControlObject;
                ControlType o_ControlType = this.m_DMXControlType.getControlType(0);
                o_ControlType.setName(p_Name);
                if (this.m_ControlObjects != null && this.m_ControlObjects.size() > 0 && (o_ControlObject = this.m_ControlObjects.get(0)) != null) {
                    o_ControlObject.setName(p_Name);
                }
            }
        }
    }

    public String getRemark() {
        String stringRemark = "";
        if (this.m_DMXControlType != null) {
            stringRemark = this.m_DMXControlType.getRemark();
        }
        return stringRemark;
    }

    public void setRemark(String p_Remark) {
        if (this.m_DMXControlType != null) {
            this.m_DMXControlType.setRemark(p_Remark);
        }
    }

    public boolean getIsDimmer() {
        if (this.m_DMXControlType != null) {
            return this.m_DMXControlType.getIsDimmer();
        }
        return false;
    }

    public void setIsDimmerSubstitute(boolean p_IsDimmerSubstitute) {
        if (this.m_DMXControlType != null) {
            this.m_DMXControlType.setIsDimmerSubstitute(p_IsDimmerSubstitute);
        }
    }

    public boolean getIsDimmerSubstitute() {
        if (this.m_DMXControlType != null) {
            return this.m_DMXControlType.getIsDimmerSubstitute();
        }
        return false;
    }

    public void setIsDisabledInFunctions(boolean p_IsDisabled) {
        if (this.m_DMXControlType != null) {
            this.m_DMXControlType.setIsDisabledInFunctions(p_IsDisabled);
        }
    }

    public boolean getIsDisabledInFunctions() {
        if (this.m_DMXControlType != null) {
            return this.m_DMXControlType.getIsDisabledInFunctions();
        }
        return false;
    }

    public boolean getEditable() {
        return this.m_Editable;
    }

    public void setEditable(boolean p_Editable) {
        this.m_Editable = p_Editable;
    }

    public void setSelected(boolean p_Selected) {
        if (this.m_Selected == p_Selected) {
            return;
        }
        this.m_Selected = p_Selected;
        if (this.m_Selected) {
            this.m_Border = super.getBorder();
            super.setBorder(s_SelectedBorder);
        } else {
            super.setBorder(this.m_Border);
        }
    }

    public void setEnableSettings(boolean p_Enabled) {
        this.m_EnableSettings = p_Enabled;
    }

    public boolean getEnableSettings() {
        return this.m_EnableSettings;
    }

    public void refreshBorder(JComponent p_JComponent) {
        if (p_JComponent == null) {
            return;
        }
        if (this.m_DisabledByDefault) {
            p_JComponent.setBorder(s_DisplayLabelBorderDisabled);
        } else if (this.m_DisabledAdjustmentByDefault) {
            p_JComponent.setBorder(s_DisplayLabelBorderDisabledAdjustment);
        } else {
            p_JComponent.setBorder(s_DisplayLabelBorderNormal);
        }
    }

    public void setDisabledByDefault(boolean p_DisabledByDefault) {
        if (this.m_DisabledByDefault == p_DisabledByDefault) {
            return;
        }
        this.m_DisabledByDefault = p_DisabledByDefault;
        this.refreshBorder(this.getDisplayLabel());
        this.refreshBorder(this.getDisplayLabelCopy());
    }

    public boolean getDisabledByDefault() {
        return this.m_DisabledByDefault;
    }

    public void setDisabledAdjustmentByDefault(boolean p_DisabledAdjustmentByDefault) {
        if (this.m_DisabledAdjustmentByDefault == p_DisabledAdjustmentByDefault) {
            return;
        }
        if (this.m_DisabledByDefault) {
            return;
        }
        this.m_DisabledAdjustmentByDefault = p_DisabledAdjustmentByDefault;
        this.refreshBorder(this.getDisplayLabel());
        this.refreshBorder(this.getDisplayLabelCopy());
    }

    public boolean getDisabledAdjustmentByDefault() {
        return this.m_DisabledAdjustmentByDefault;
    }

    public void setDMXDeviceTreeModel(DMXDevice.TreeModel_Device_Channels p_DMXDeviceTreeModel_Channel) {
        this.m_DMXDeviceTreeModel_Channel = p_DMXDeviceTreeModel_Channel;
    }

    public void setDMXDeviceType(DMXDeviceType p_DMXDeviceType) {
        this.m_DMXDeviceType = p_DMXDeviceType;
    }

    public abstract void validateValuesDevice(boolean var1, boolean var2);

    public DMXControlSpecialSettings getDMXControlSpecialSettings() {
        return this.m_DMXControlSpecialSettings;
    }

    public void setDMXControlSpecialSettings(DMXControlSpecialSettings p_DMXControlSpecialSettings) {
        this.m_DMXControlSpecialSettings = p_DMXControlSpecialSettings;
    }

    public abstract void eventDMXControlSpecialSettings(DMXControlSpecialSettings var1);

    public abstract void createAutomaticFunctions();

    public void addLinkedDMXDevice(DMXDevice p_DMXDevice) {
        if (p_DMXDevice == null) {
            return;
        }
        if (this.m_LinkedDeviceSettingsPanels.containsKey(p_DMXDevice)) {
            DeviceSettingsPanel o_DeviceSettingsPanel_Old = this.m_LinkedDeviceSettingsPanels.get(p_DMXDevice);
            DeviceSettingsPanel o_DeviceSettingsPanel = p_DMXDevice.getDeviceSettingsPanel(this);
            if (o_DeviceSettingsPanel_Old != null) {
                if (o_DeviceSettingsPanel == o_DeviceSettingsPanel_Old) {
                    return;
                }
                o_DeviceSettingsPanel_Old.removeDMXControlComponent(this);
            }
            this.m_LinkedDeviceSettingsPanels.put(p_DMXDevice, o_DeviceSettingsPanel);
            if (!this.m_LinkedDMDevices.contains(p_DMXDevice)) {
                this.m_LinkedDMDevices.add(p_DMXDevice);
            }
            if (o_DeviceSettingsPanel != null && this.m_LinkedDeviceSettingsPanels.size() == 1) {
                o_DeviceSettingsPanel.addDMXControlComponent(this);
            }
            return;
        }
        DeviceSettingsPanel o_DeviceSettingsPanel = p_DMXDevice.getDeviceSettingsPanel(this);
        if (o_DeviceSettingsPanel != null) {
            DeviceSettingsPanel o_DeviceSettingsPanel_Old;
            if (this.m_LinkedDeviceSettingsPanels.size() == 0) {
                o_DeviceSettingsPanel.addDMXControlComponent(this);
            } else if (this.m_LinkedDeviceSettingsPanels.size() == 1 && (o_DeviceSettingsPanel_Old = (DeviceSettingsPanel)this.m_LinkedDeviceSettingsPanels.values().toArray()[0]) != null) {
                o_DeviceSettingsPanel_Old.removeDMXControlComponent(this);
            }
        }
        this.m_LinkedDeviceSettingsPanels.put(p_DMXDevice, o_DeviceSettingsPanel);
        if (!this.m_LinkedDMDevices.contains(p_DMXDevice)) {
            this.m_LinkedDMDevices.add(p_DMXDevice);
        }
    }

    public void removeLinkedDMXDevice(DMXDevice p_DMXDevice) {
        if (p_DMXDevice == null) {
            return;
        }
        if (!this.m_LinkedDeviceSettingsPanels.containsKey(p_DMXDevice)) {
            return;
        }
        DeviceSettingsPanel o_DeviceSettingsPanel = this.m_LinkedDeviceSettingsPanels.get(p_DMXDevice);
        for (int intControl = 0; intControl < this.getControlObjectCount(); ++intControl) {
            ControlType o_ControlType = this.getControlType(intControl);
            for (int intDimension = 0; intDimension < o_ControlType.getControlDimensionTypeCount(); ++intDimension) {
                ControlDimensionType o_ControlDimensionType = o_ControlType.getControlDimensionType(intDimension);
                for (int intLink = 0; intLink < o_ControlDimensionType.getDeviceControlLinkCount(); ++intLink) {
                    DeviceControlLink o_DeviceControlLink = o_ControlDimensionType.getDeviceControlLink(intLink);
                    if (!p_DMXDevice.equals(o_DeviceControlLink.getDMXDevice())) continue;
                    return;
                }
            }
        }
        if (this.m_LinkedDeviceSettingsPanels.size() == 1 && o_DeviceSettingsPanel != null) {
            o_DeviceSettingsPanel.removeDMXControlComponent(this);
        }
        this.m_LinkedDeviceSettingsPanels.remove(p_DMXDevice);
        this.m_LinkedDMDevices.remove(p_DMXDevice);
        if (this.m_LinkedDeviceSettingsPanels.size() == 1 && (o_DeviceSettingsPanel = (DeviceSettingsPanel)this.m_LinkedDeviceSettingsPanels.values().toArray()[0]) != null) {
            o_DeviceSettingsPanel.addDMXControlComponent(this);
        }
    }

    public HashMap<DMXDevice, DeviceSettingsPanel> getLinkedDeviceSettingsPanel() {
        return this.m_LinkedDeviceSettingsPanels;
    }

    public int getLinkedDMXDeviceCount() {
        return this.m_LinkedDMDevices.size();
    }

    public DMXDevice getLinkedDMXDevice(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        if (p_Index >= this.m_LinkedDMDevices.size()) {
            return null;
        }
        return this.m_LinkedDMDevices.get(p_Index);
    }

    public ControlLabelModel.ControlLabelList getControlLabelList_First(DMXDevice p_DMXDevice) {
        if (p_DMXDevice == null) {
            return null;
        }
        if (this.m_ControlObjects == null) {
            return null;
        }
        if (this.m_ControlObjects.size() <= 0 || this.m_ControlObjects.size() > 1) {
            return null;
        }
        ControlObject o_ControlObject = this.m_ControlObjects.get(0);
        if (o_ControlObject.getControlDimensionCount() <= 0 || o_ControlObject.getControlDimensionCount() > 1) {
            return null;
        }
        ControlObject.ControlDimension o_ControlDimension = o_ControlObject.getControlDimension(0);
        ControlLabelModel o_ControlLabelModel = o_ControlDimension.getControlLabelModel();
        if (o_ControlLabelModel == null) {
            return null;
        }
        return o_ControlLabelModel.getControlLabelList(0);
    }

    public ControlLabelModel.ControlLabelList findControlLabelList(DMXDevice p_DMXDevice, DMXScene p_DMXScene) {
        if (p_DMXDevice == null) {
            return null;
        }
        if (p_DMXScene == null) {
            return null;
        }
        if (this.m_ControlObjects == null) {
            return null;
        }
        if (this.m_ControlObjects.size() <= 0 || this.m_ControlObjects.size() > 1) {
            return null;
        }
        ControlObject o_ControlObject = this.m_ControlObjects.get(0);
        if (o_ControlObject.getControlDimensionCount() <= 0 || o_ControlObject.getControlDimensionCount() > 1) {
            return null;
        }
        ControlObject.ControlDimension o_ControlDimension = o_ControlObject.getControlDimension(0);
        ControlLabelModel o_ControlLabelModel = o_ControlDimension.getControlLabelModel();
        if (o_ControlLabelModel == null) {
            return null;
        }
        int intListCount = o_ControlLabelModel.getControlLabelListSize();
        switch (intListCount) {
            case 0: {
                return null;
            }
            case 1: {
                return o_ControlLabelModel.getControlLabelList(0);
            }
        }
        for (int intList = 0; intList < intListCount; ++intList) {
            ControlLabelModel.ControlLabelList o_ControlLabelList = o_ControlLabelModel.getControlLabelList(intList);
            for (int intCondition = 0; intCondition < o_ControlLabelList.getLabelListConditionSize(); ++intCondition) {
                DMXControlComponent o_DMXControlComponent_Remote;
                ControlLabelModel.LabelListCondition o_LabelListCondition = o_ControlLabelList.getLabelListCondition(intCondition);
                if (o_LabelListCondition == null || (o_DMXControlComponent_Remote = p_DMXDevice.getDMXControlComponentByID(o_LabelListCondition.getRemoteID())) == null) continue;
                int intControlIndex_Remote = o_LabelListCondition.getRemoteControlIndex();
                int intDimensionIndex_Remote = o_LabelListCondition.getRemoteDimensionIndex();
                double doubleValueRemote = p_DMXScene.getValue(p_DMXDevice, o_DMXControlComponent_Remote.getDMXControlType(), intControlIndex_Remote, intDimensionIndex_Remote);
                if (!(doubleValueRemote >= o_LabelListCondition.getRemoteValueStart()) || !(doubleValueRemote <= o_LabelListCondition.getRemoteValueEnd())) continue;
                return o_ControlLabelList;
            }
        }
        return null;
    }

    public DeviceSettingsPanel getDeviceSettingsPanel(int p_Index) {
        if (p_Index < 0 || p_Index >= this.m_LinkedDeviceSettingsPanels.size()) {
            return null;
        }
        DMXDevice o_DMXDevice = null;
        Iterator<DMXDevice> o_Iterator = this.m_LinkedDeviceSettingsPanels.keySet().iterator();
        for (int intDevice = 0; intDevice <= p_Index; ++intDevice) {
            try {
                o_DMXDevice = o_Iterator.next();
                continue;
            }
            catch (Exception error) {
                o_DMXDevice = null;
                break;
            }
        }
        if (o_DMXDevice == null) {
            return null;
        }
        return this.m_LinkedDeviceSettingsPanels.get(o_DMXDevice);
    }

    public void refreshValuesControlDimensions_Manually() {
        if (!LiveShowVIP.EDITMODEON) {
            DMXScene.mixMain(DMXScene.s_DMXSceneValueContainer_Mixer);
            DMXScene.DMXSceneDeviceValues o_DMXSceneDeviceValues = LiveShowDMXDeviceEditor.s_SelfReference.getDMXSceneDeviceValues();
            o_DMXSceneDeviceValues.writeDMXSceneToChannels(true, true);
        } else {
            DMXScene.s_DMXSceneValueContainer_EditMode.writeDMXSceneToChannels_EditMode();
        }
    }

    public void refreshValueFactors() {
        for (DMXDevice o_DMXDevice : this.m_LinkedDeviceSettingsPanels.keySet()) {
            o_DMXDevice.refreshValueFactors();
        }
    }

    protected void showSettings() {
        if (this.m_DMXControlType == null) {
            return;
        }
        if (this.m_JDialog == null) {
            this.m_JDialog = new JDialog((Window)null);
            this.m_JDialog.setIconImage(new ImageIcon(DMXControlComponent.class.getResource("/IconsPackage/Slider_DeviceDefaultValues.png")).getImage());
            this.m_JDialog.setDefaultCloseOperation(1);
            this.m_JDialog.setAlwaysOnTop(true);
            this.m_JDialog.addWindowFocusListener(LiveShowDMXSystem.getHelpFocusListener());
        }
        if (this.m_DMXControlSettings == null) {
            this.m_DMXControlSettings = new DMXControlSettings(this.m_JDialog, this, this.m_DMXDeviceTreeModel_Channel, this.m_DMXDeviceType);
            this.m_JDialog.setContentPane(this.m_DMXControlSettings);
            this.m_DMXControlSettings.getLabel_ResizeFrame().setContainer(this.m_JDialog);
        }
        this.m_JDialog.pack();
        this.m_JDialog.setVisible(true);
    }

    public abstract void showValueSelection(ValueSelectionInterface var1, int var2, int var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addManuallyChangeListener(ManuallyChangeListener p_ManuallyChangeListener) {
        if (p_ManuallyChangeListener == null) {
            return;
        }
        Object object = this.m_SyncListeners;
        synchronized (object) {
            if (this.m_ManuallyChangeListeners.contains(p_ManuallyChangeListener)) {
                return;
            }
            this.m_ManuallyChangeListeners.add(p_ManuallyChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeManuallyChangeListener(ManuallyChangeListener p_ManuallyChangeListener) {
        if (p_ManuallyChangeListener == null) {
            return;
        }
        Object object = this.m_SyncListeners;
        synchronized (object) {
            this.m_ManuallyChangeListeners.remove(p_ManuallyChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void eventControlObjectManuallyChanged() {
        Object object = this.m_SyncListeners;
        synchronized (object) {
            for (int intListener = 0; intListener < this.m_ManuallyChangeListeners.size(); ++intListener) {
                ManuallyChangeListener o_ManuallyChangeListener = this.m_ManuallyChangeListeners.get(intListener);
                if (o_ManuallyChangeListener == null) continue;
                o_ManuallyChangeListener.eventManuallyChanged(this);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof ControlObject) {
            if ("valueChangedManually".equals(evt.getPropertyName())) {
                this.eventControlObjectManuallyChanged();
            }
        } else if (evt.getSource() instanceof ControlLabelModel) {
            if ("listAdded".equals(evt.getPropertyName())) {
                this.eventLabelList();
            } else if ("listRemoved".equals(evt.getPropertyName())) {
                this.eventLabelList();
            } else if ("listSelected".equals(evt.getPropertyName())) {
                this.refreshToolTipText_PartDMXControl();
                this.eventLabelList();
            }
        } else if (evt.getSource() instanceof ControlObject.ControlDimension && ("valueFactor".equals(evt.getPropertyName()) || "value".equals(evt.getPropertyName()))) {
            ControlObject.ControlDimension o_ControlDimension = (ControlObject.ControlDimension)evt.getSource();
            SPIT_Object_Interface o_SPIT_Object_Interface = SPITRemote.getRemoteSPIT_ObjectByActionObject((Object)o_ControlDimension);
            if (o_SPIT_Object_Interface == null) {
                return;
            }
            if (o_ControlDimension != o_SPIT_Object_Interface.getSPIT_Action_Object()) {
                return;
            }
            o_ControlDimension = (ControlObject.ControlDimension)o_SPIT_Object_Interface.getSPIT_Action_Object();
            double doublePlayValue = o_ControlDimension.getValue() / (o_ControlDimension.getValueMaximum() - o_ControlDimension.getValueMinimum());
            o_SPIT_Object_Interface.setPlayValue((int)(doublePlayValue * 1000000.0));
        }
    }

    public void createSPITRemote(String p_ID, String p_GroupName, String p_TypeName, ArrayList<SPIT_Object_Interface> p_SPIT_Object_Interfaces) {
        int intSPITIndex = 0;
        for (int intControl = 0; intControl < this.getControlObjectCount(); ++intControl) {
            ControlObject o_ControlObject = this.getControlObject(intControl);
            if (o_ControlObject == null) continue;
            for (int intDimension = 0; intDimension < o_ControlObject.getControlDimensionCount(); ++intDimension) {
                SPIT_Object_Interface o_SPIT_Object_Interface;
                SPIT_Type_Interface o_SPIT_Type_Interface;
                ControlObject.ControlDimension o_ControlDimension = o_ControlObject.getControlDimension(intDimension);
                if (o_ControlDimension == null) continue;
                String stringSPITID = p_ID + String.valueOf(intControl) + String.valueOf(intDimension);
                intSPITIndex = intControl * o_ControlObject.getControlDimensionCount() + intDimension;
                if (p_SPIT_Object_Interfaces == null) {
                    o_SPIT_Type_Interface = SPITRemote.createServerRemoteSPIT_Type((String)stringSPITID, (String)p_GroupName, (String)p_TypeName, (boolean)true);
                    SPITRemote.addRemoteSPIT_Type((SPIT_Type_Interface)o_SPIT_Type_Interface);
                    o_SPIT_Object_Interface = SPITRemote.createServerRemoteSPIT_Object((SPIT_Type_Interface)o_SPIT_Type_Interface, (String)stringSPITID, (String)o_ControlObject.getName(), (byte)1);
                    o_SPIT_Object_Interface.setSPIT_Action_Interface((SPIT_Action_Interface)this, (Object)o_ControlDimension);
                    o_ControlDimension.addPropertyChangeListener((PropertyChangeListener)this);
                    SPITRemote.addRemoteSPIT_Object((SPIT_Object_Interface)o_SPIT_Object_Interface);
                } else {
                    if (intSPITIndex >= p_SPIT_Object_Interfaces.size()) {
                        return;
                    }
                    o_SPIT_Object_Interface = p_SPIT_Object_Interfaces.get(intSPITIndex);
                    if (o_SPIT_Object_Interface == null || (o_SPIT_Type_Interface = o_SPIT_Object_Interface.getSPIT_Type()) == null) continue;
                    o_SPIT_Type_Interface.setGroupName(p_GroupName);
                    o_SPIT_Object_Interface.setName(o_ControlObject.getName());
                    o_SPIT_Object_Interface.setSPIT_Action_Interface((SPIT_Action_Interface)this, (Object)o_ControlDimension);
                    o_ControlDimension.addPropertyChangeListener((PropertyChangeListener)this);
                }
                double doublePlayValue = o_ControlDimension.getValue() / (o_ControlDimension.getValueMaximum() - o_ControlDimension.getValueMinimum());
                o_SPIT_Object_Interface.setPlayValue((int)(doublePlayValue * 1000000.0));
            }
        }
    }

    public void playStarted(SPIT_Object_Interface p_SPIT_Object_Interface, SPIT_ActionStatus p_SPIT_ActionStatus, Object p_SPIT_Action_Object) {
    }

    public void playEnd(SPIT_Object_Interface p_SPIT_Object_Interface, SPIT_ActionStatus p_SPIT_ActionStatus, Object p_SPIT_Action_Object) {
    }

    public void play(SPIT_Object_Interface p_SPIT_Object_Interface, SPIT_ActionStatus p_SPIT_ActionStatus, Object p_SPIT_Action_Object) {
        double doubleValue_Input;
        if (p_SPIT_Object_Interface == null) {
            return;
        }
        if (p_SPIT_ActionStatus == null) {
            return;
        }
        ControlObject.ControlDimension o_ControlDimension = null;
        if (p_SPIT_Action_Object == null) {
            return;
        }
        if (p_SPIT_Action_Object instanceof ControlObject.ControlDimension) {
            o_ControlDimension = (ControlObject.ControlDimension)p_SPIT_Action_Object;
        }
        if (o_ControlDimension == null) {
            return;
        }
        ControlObject o_ControlObject = o_ControlDimension.getControlObject();
        if (o_ControlObject == null) {
            return;
        }
        if (p_SPIT_Object_Interface.getID().contains("mainmixerDMX_Dimmer") || p_SPIT_Object_Interface.getID().contains("mainmixerDMX_RGB")) {
            boolean boolValueCaught = false;
            doubleValue_Input = (o_ControlDimension.getValueMaximum() - o_ControlDimension.getValueMinimum()) * ((double)p_SPIT_ActionStatus.getPlayValue() / 1000000.0);
            double doubleValue_Actual = o_ControlDimension.getValue();
            if (doubleValue_Input > this.m_ValueSPITInput_Old) {
                if (doubleValue_Input >= doubleValue_Actual && Math.abs(this.m_ValueSPITInput_Old - doubleValue_Actual) < (o_ControlDimension.getValueMaximum() - o_ControlDimension.getValueMinimum()) / 100.0) {
                    boolValueCaught = true;
                }
            } else if (doubleValue_Input <= doubleValue_Actual && Math.abs(this.m_ValueSPITInput_Old - doubleValue_Actual) < (o_ControlDimension.getValueMaximum() - o_ControlDimension.getValueMinimum()) / 100.0) {
                boolValueCaught = true;
            }
            if (boolValueCaught) {
                o_ControlDimension.setValue(doubleValue_Input);
                o_ControlObject.setValueManuallyIsReady();
            }
        } else {
            doubleValue_Input = (o_ControlDimension.getValueMaximum() - o_ControlDimension.getValueMinimum()) * ((double)p_SPIT_ActionStatus.getPlayValue() / 1000000.0);
            o_ControlDimension.setValue(doubleValue_Input);
            o_ControlObject.setValueManuallyIsReady();
        }
        this.m_ValueSPITInput_Old = doubleValue_Input;
    }

    public void setSelectedBlockList(int p_Index) {
        for (int intControl = 0; intControl < this.m_ControlObjects.size(); ++intControl) {
            ControlObject o_ControlObject = this.m_ControlObjects.get(intControl);
            for (int intDimension = 0; intDimension < o_ControlObject.getControlDimensionCount(); ++intDimension) {
                ControlObject.ControlDimension o_ControlDimension = o_ControlObject.getControlDimension(intDimension);
                ControlBlockModel o_ControlBlockModel = o_ControlDimension.getControlBlockModel();
                if (o_ControlBlockModel == null) continue;
                o_ControlBlockModel.setSelectedBlockList(p_Index);
            }
        }
    }

    public abstract void setJarResources(JarResources var1);

    public abstract boolean refreshDisplay();

    public abstract void refreshDisplay_ControlValueChanged(DMXControlComponent var1, ControlObject var2, ControlObject.ControlDimension var3, String var4);

    public abstract void refreshDisplay_HardwareValueChanged();

    public abstract void refreshDisplay_Foreign(DMXControlDisplayLabel var1, DMXDevice var2, DMXScene var3);

    public abstract void refreshDisplay_Foreign(DMXControlDisplayLabel var1, ControlLabelModel.ControlLabelList var2, ArrayList<Double> var3, int var4);

    public abstract void refreshDisplay_Foreign(DMXControlDisplayLabel var1, ControlLabelModel.ControlLabelList var2, ArrayList<Double> var3);

    public abstract DMXControlDisplayLabel getDisplayLabel();

    public abstract DMXControlDisplayLabel getDisplayLabelCopy();

    public abstract JLabel getNameLabel();

    public abstract DMXFadeDescription.DMXControlTypeFadeDescription getDefaultDMXFadeDescription();

    public abstract void setDefaultDMXFadeDescriptionMembers();

    public abstract void setDMXDeviceSettingsPanel(DMXDevice var1, DeviceSettingsPanel var2);

    public abstract DeviceSettingsPanel getDMXDeviceSettingsPanel(DMXDevice var1, boolean var2);

    public abstract void eventLabelList();

    public abstract boolean getIsOn();

    public boolean getIsOn(ArrayList<Double> p_Values) {
        if (p_Values == null) {
            return false;
        }
        if (this.m_DMXControlType == null) {
            return false;
        }
        int intControlsCount = this.m_DMXControlType.getControlTypeCount();
        if (intControlsCount <= 0) {
            return false;
        }
        ControlType o_ControlType = this.m_DMXControlType.getControlType(0);
        if (o_ControlType == null) {
            return false;
        }
        int intDimensionCount = o_ControlType.getControlDimensionTypeCount();
        if (p_Values.size() != intControlsCount * intDimensionCount) {
            return false;
        }
        for (int intValue = 0; intValue < p_Values.size(); ++intValue) {
            if (!(p_Values.get(intValue) > 0.0)) continue;
            return true;
        }
        return false;
    }

    public String getDMXControlTypeID() {
        if (this.m_DMXControlType == null) {
            return null;
        }
        return this.m_DMXControlType.getID();
    }

    public DMXControlDescription getDMXControlDescription() {
        if (this.m_DMXControlType == null) {
            return null;
        }
        DMXControlDescription o_DMXControlDescription = this.m_DMXControlType.getDMXControlDescription();
        return o_DMXControlDescription;
    }

    public String getDMXControlDescriptionID() {
        if (this.m_DMXControlType == null) {
            return null;
        }
        DMXControlDescription o_DMXControlDescription = this.m_DMXControlType.getDMXControlDescription();
        if (o_DMXControlDescription == null) {
            return null;
        }
        return o_DMXControlDescription.getID();
    }

    public DMXControlType getDMXControlType() {
        if (this.m_DMXControlType == null) {
            this.m_DMXControlType = new DMXControlType(this.getClassName(), this.getName(), this.getRemark());
        }
        return this.m_DMXControlType;
    }

    public int getControlTypeCount() {
        if (this.m_DMXControlType == null) {
            return 0;
        }
        return this.m_DMXControlType.getControlTypeCount();
    }

    public ControlType getControlType(ControlObject p_ControlObject) {
        if (this.m_DMXControlType == null) {
            return null;
        }
        return this.m_DMXControlType.getControlType(p_ControlObject);
    }

    public ControlType getControlType(int p_Index) {
        if (this.m_DMXControlType == null) {
            return null;
        }
        return this.m_DMXControlType.getControlType(p_Index);
    }

    public ControlDimensionType getControlDimensionType(ControlObject.ControlDimension p_ControlDimension) {
        ControlType o_ControlType = this.getControlType(p_ControlDimension.getControlObject());
        if (o_ControlType == null) {
            return null;
        }
        ControlDimensionType o_ControlDimensionType = o_ControlType.getControlDimensionType(p_ControlDimension);
        return o_ControlDimensionType;
    }

    public int getByteResolution_Linked(ControlObject.ControlDimension p_ControlDimension) {
        ControlDimensionType o_ControlDimensionType = this.getControlDimensionType(p_ControlDimension);
        if (o_ControlDimensionType == null) {
            return 0;
        }
        return o_ControlDimensionType.getByteResolution_Linked();
    }

    public int getValueMaximum_Linked(ControlObject.ControlDimension p_ControlDimension) {
        ControlDimensionType o_ControlDimensionType = this.getControlDimensionType(p_ControlDimension);
        if (o_ControlDimensionType == null) {
            return 0;
        }
        return o_ControlDimensionType.getValueMaximum_Linked();
    }

    public DeviceControlLink findDeviceControlLink(DMXDevice p_DMXDevice, ControlObject.ControlDimension p_ControlDimension) {
        ControlDimensionType o_ControlDimensionType = this.getControlDimensionType(p_ControlDimension);
        if (o_ControlDimensionType == null) {
            return null;
        }
        return o_ControlDimensionType.findDeviceControlLink(p_DMXDevice);
    }

    public void refreshDMXControl_Component_Type(boolean p_RefreshComponent, boolean p_RefreshType) {
        if (this.m_DMXControlType == null) {
            return;
        }
        boolean boolNewType = false;
        for (int intControl = 0; intControl < this.m_ControlObjects.size(); ++intControl) {
            boolNewType = false;
            ControlObject o_ControlObject = this.m_ControlObjects.get(intControl);
            if (o_ControlObject == null) continue;
            ControlType o_ControlType = this.m_DMXControlType.getControlType(intControl);
            if (o_ControlType == null) {
                o_ControlType = new ControlType(this.m_DMXControlType, intControl);
                this.m_DMXControlType.addControlType(o_ControlType);
                boolNewType = true;
            }
            if (p_RefreshType || boolNewType) {
                o_ControlType.setName(o_ControlObject.getName());
            }
            if (p_RefreshComponent) {
                o_ControlObject.setName(o_ControlType.getName());
            }
            int intDimensionCount = o_ControlObject.getControlDimensionCount();
            for (int intDimension = 0; intDimension < intDimensionCount; ++intDimension) {
                boolNewType = false;
                ControlObject.ControlDimension o_ControlDimension = o_ControlObject.getControlDimension(intDimension);
                ControlDimensionType o_ControlDimensionType = o_ControlType.getControlDimensionType(intDimension);
                if (o_ControlDimensionType == null) {
                    o_ControlDimensionType = new ControlDimensionType(o_ControlType, intDimension);
                    o_ControlType.addControlDimensionType(o_ControlDimensionType);
                    boolNewType = true;
                }
                if (o_ControlDimension == null) continue;
                if (p_RefreshType || boolNewType) {
                    this.unlinkLabelListConditions();
                    o_ControlDimensionType.setName(o_ControlDimension.getDimensionName());
                    o_ControlDimensionType.setValueMaximum((int)o_ControlDimension.getValueMaximum());
                    o_ControlDimensionType.setControlLabelModel(o_ControlDimension.getControlLabelModel());
                    o_ControlDimensionType.getControlLabelModel().setValueRange(0.0, (double)o_ControlDimensionType.getValueMaximum());
                    o_ControlDimensionType.getControlLabelModel().setOnlyIntegerValues(true);
                    o_ControlDimensionType.setControlBlockModel(o_ControlDimension.getControlBlockModel());
                    o_ControlDimensionType.getControlBlockModel().setValueRange(0.0, (double)o_ControlDimensionType.getValueMaximum());
                    o_ControlDimensionType.getControlBlockModel().setOnlyIntegerValues(true);
                    o_ControlDimensionType.setControlFunctionModel(o_ControlDimension.getControlFunctionModel());
                    o_ControlDimensionType.getControlFunctionModel().setValueRange(0.0, (double)o_ControlDimensionType.getValueMaximum());
                    o_ControlDimensionType.getControlFunctionModel().setOnlyIntegerValues(true);
                    this.linkLabelListConditions();
                }
                if (!p_RefreshComponent) continue;
                o_ControlDimension.setDimensionName(o_ControlDimensionType.getName());
                o_ControlDimension.setValueMaximum((double)o_ControlDimensionType.getValueMaximum());
                ControlLabelModel o_ControlLabelModel = o_ControlDimension.getControlLabelModel();
                if (o_ControlLabelModel != null) {
                    o_ControlLabelModel.removePropertyChangeListener((PropertyChangeListener)this);
                }
                if ((o_ControlLabelModel = o_ControlDimensionType.getControlLabelModel()) != null) {
                    o_ControlLabelModel.addPropertyChangeListener((PropertyChangeListener)this);
                }
                o_ControlDimension.setControlLabelModel(o_ControlLabelModel);
                o_ControlDimension.getControlLabelModel().setValueRange(o_ControlDimension.getValueMinimum(), o_ControlDimension.getValueMaximum());
                o_ControlDimension.getControlLabelModel().setOnlyIntegerValues(true);
                o_ControlDimension.setControlBlockModel(o_ControlDimensionType.getControlBlockModel());
                o_ControlDimension.getControlBlockModel().setValueRange(o_ControlDimension.getValueMinimum(), o_ControlDimension.getValueMaximum());
                o_ControlDimension.getControlBlockModel().setOnlyIntegerValues(true);
                o_ControlDimension.setControlFunctionModel(o_ControlDimensionType.getControlFunctionModel());
                o_ControlDimension.getControlFunctionModel().setValueRange(o_ControlDimension.getValueMinimum(), o_ControlDimension.getValueMaximum());
                o_ControlDimension.getControlFunctionModel().setOnlyIntegerValues(true);
            }
        }
        this.refreshToolTipText_PartDMXControl();
    }

    public String refreshToolTipText_PartDMXControl() {
        if (this.m_DMXControlType == null) {
            return null;
        }
        this.getNameLabel().setText(this.m_DMXControlType.getName());
        StringBuilder stringBuilderToolTipText = new StringBuilder();
        stringBuilderToolTipText.append("<b>");
        stringBuilderToolTipText.append(this.m_DMXControlType.getName());
        stringBuilderToolTipText.append("</b>");
        stringBuilderToolTipText.append("<br>");
        DMXControlDescription o_DMXControlDescription = this.m_DMXControlType.getDMXControlDescription();
        if (o_DMXControlDescription != null && o_DMXControlDescription.getID() != DMXControlDescription.ID_UNDEFINED) {
            stringBuilderToolTipText.append("(");
            stringBuilderToolTipText.append(o_DMXControlDescription.getName());
            stringBuilderToolTipText.append(")");
        }
        String stringToolTipText = stringBuilderToolTipText.toString();
        this.getDisplayLabel().setToolTipText_PartDMXControl(stringToolTipText);
        this.getDisplayLabelCopy().setToolTipText_PartDMXControl(stringToolTipText);
        return stringToolTipText;
    }

    public void linkLabelListConditions() {
        for (int intControlObject = 0; intControlObject < this.getControlObjectCount(); ++intControlObject) {
            ControlObject o_ControlObject = this.getControlObject(intControlObject);
            for (int intDimension = 0; intDimension < o_ControlObject.getControlDimensionCount(); ++intDimension) {
                ControlObject.ControlDimension o_ControlDimension = o_ControlObject.getControlDimension(intDimension);
                ControlLabelModel o_ControlLabelModel = o_ControlDimension.getControlLabelModel();
                for (int intLabelList = 0; intLabelList < o_ControlLabelModel.getControlLabelListSize(); ++intLabelList) {
                    ControlLabelModel.ControlLabelList o_ControlLabelList = o_ControlLabelModel.getControlLabelList(intLabelList);
                    for (int intCondition = 0; intCondition < o_ControlLabelList.getLabelListConditionSize(); ++intCondition) {
                        ControlLabelModel.LabelListCondition o_LabelListCondition = o_ControlLabelList.getLabelListCondition(intCondition);
                        this.linkLabelListCondition(o_LabelListCondition);
                    }
                }
            }
        }
    }

    public void linkLabelListCondition(ControlLabelModel.LabelListCondition p_LabelListCondition) {
        if (p_LabelListCondition == null) {
            return;
        }
        ControlObject.ControlDimension o_ControlDimension = DMXControlComponent.getControlDimension(this.getDMXControlComponentPool(), p_LabelListCondition);
        p_LabelListCondition.link(o_ControlDimension);
    }

    public void unlinkLabelListConditions() {
        for (int intControlObject = 0; intControlObject < this.getControlObjectCount(); ++intControlObject) {
            ControlObject o_ControlObject = this.getControlObject(intControlObject);
            for (int intDimension = 0; intDimension < o_ControlObject.getControlDimensionCount(); ++intDimension) {
                ControlObject.ControlDimension o_ControlDimension = o_ControlObject.getControlDimension(intDimension);
                ControlLabelModel o_ControlLabelModel = o_ControlDimension.getControlLabelModel();
                for (int intLabelList = 0; intLabelList < o_ControlLabelModel.getControlLabelListSize(); ++intLabelList) {
                    ControlLabelModel.ControlLabelList o_ControlLabelList = o_ControlLabelModel.getControlLabelList(intLabelList);
                    for (int intCondition = 0; intCondition < o_ControlLabelList.getLabelListConditionSize(); ++intCondition) {
                        ControlLabelModel.LabelListCondition o_LabelListCondition = o_ControlLabelList.getLabelListCondition(intCondition);
                        this.unlinkLabelListCondition(o_LabelListCondition);
                    }
                }
            }
        }
    }

    public void unlinkLabelListCondition(ControlLabelModel.LabelListCondition p_LabelListCondition) {
        if (p_LabelListCondition == null) {
            return;
        }
        p_LabelListCondition.unlink();
    }

    public GridBagConstraints getGridBagConstraints() {
        return this.m_GridBagConstraints;
    }

    public boolean getIsLinked(ControlObject.ControlDimension p_ControlDimension) {
        ControlDimensionType o_ControlDimensionType = this.getControlDimensionType(p_ControlDimension);
        return this.getIsLinked(o_ControlDimensionType);
    }

    public boolean getIsLinked(ControlDimensionType p_ControlDimensionType) {
        if (p_ControlDimensionType == null) {
            return false;
        }
        return p_ControlDimensionType.getDeviceControlLinkCount() > 0;
    }

    protected boolean setControlObject(ControlObject p_ControlObject, int p_ControlIndex) {
        ControlObject o_ControlObject;
        if (p_ControlIndex < 0) {
            return false;
        }
        if (p_ControlIndex >= this.m_ControlObjects.size()) {
            for (int intControl = this.m_ControlObjects.size(); intControl <= p_ControlIndex; ++intControl) {
                this.m_ControlObjects.add(null);
            }
        }
        if (p_ControlObject == (o_ControlObject = this.m_ControlObjects.get(p_ControlIndex))) {
            return true;
        }
        this.m_ControlObjects.set(p_ControlIndex, p_ControlObject);
        if (p_ControlObject != null) {
            p_ControlObject.addPropertyChangeListener((PropertyChangeListener)this);
        }
        return true;
    }

    public ControlObject getControlObject(int p_ControlIndex) {
        if (p_ControlIndex < 0 || p_ControlIndex >= this.m_ControlObjects.size()) {
            return null;
        }
        ControlObject o_ControlObject = this.m_ControlObjects.get(p_ControlIndex);
        return o_ControlObject;
    }

    @Override
    public void setVisible(boolean p_IsVisible) {
        super.setVisible(p_IsVisible);
        this.m_IsVisible = p_IsVisible;
        for (int intControlObject = 0; intControlObject < this.m_ControlObjects.size(); ++intControlObject) {
            ControlObject o_ControlObject = this.m_ControlObjects.get(intControlObject);
            if (o_ControlObject == null) continue;
            o_ControlObject.setVisibleOnScreen(p_IsVisible);
        }
    }

    public int indexOf(ControlObject p_ControlObject) {
        return this.m_ControlObjects.indexOf(p_ControlObject);
    }

    public int getControlObjectCount() {
        return this.m_ControlObjects.size();
    }

    public int getControlDimensionCountForDMXEffect() {
        ControlObject o_ControlObject = this.getControlObject(0);
        if (o_ControlObject == null) {
            return 0;
        }
        return o_ControlObject.getControlDimensionCount();
    }

    public ArrayList<Double> getValuesForDMXEffect(ArrayList<Double> p_Values) {
        int intControlCount = this.getControlObjectCount();
        ControlObject o_ControlObject = this.getControlObject(0);
        if (o_ControlObject == null) {
            return null;
        }
        int intDimensionCount = o_ControlObject.getControlDimensionCount();
        int intSize = intControlCount * intDimensionCount;
        if (p_Values == null) {
            p_Values = new ArrayList(intSize);
            for (int intValue = 0; intValue < intSize; ++intValue) {
                p_Values.add(-1.0);
            }
        }
        if (p_Values.size() != intSize) {
            return null;
        }
        for (int intControl = 0; intControl < intControlCount; ++intControl) {
            for (int intDimension = 0; intDimension < intDimensionCount; ++intDimension) {
                double doubleValue = this.getValue(intControl, intDimension);
                p_Values.set(intControl * intDimensionCount + intDimension, doubleValue);
            }
        }
        return p_Values;
    }

    public boolean setValuesByDMXEffect(ArrayList<Double> p_Values) {
        if (p_Values == null) {
            return false;
        }
        int intControlCount = this.getControlObjectCount();
        ControlObject o_ControlObject = this.getControlObject(0);
        if (o_ControlObject == null) {
            return false;
        }
        int intDimensionCount = o_ControlObject.getControlDimensionCount();
        int intSize = intControlCount * intDimensionCount;
        if (p_Values == null) {
            p_Values = new ArrayList(intSize);
            for (int intValue = 0; intValue < intSize; ++intValue) {
                p_Values.add(0.0);
            }
        }
        if (p_Values.size() != intSize) {
            return false;
        }
        for (int intControl = 0; intControl < intControlCount; ++intControl) {
            o_ControlObject = this.getControlObject(intControl);
            if (o_ControlObject == null) continue;
            for (int intDimension = 0; intDimension < intDimensionCount; ++intDimension) {
                ControlObject.ControlDimension o_ControlDimension = o_ControlObject.getControlDimension(intDimension);
                if (o_ControlDimension == null) continue;
                double doubleValue = p_Values.get(intControl * intDimensionCount + intDimension);
                this.setValue(doubleValue, intControl, intDimension);
            }
        }
        return true;
    }

    public double getValue(int p_ControlIndex, int p_DimensionIndex) {
        ControlObject o_ControlObject = this.getControlObject(p_ControlIndex);
        if (o_ControlObject == null) {
            return -1.0;
        }
        ControlObject.ControlDimension o_ControlDimension = o_ControlObject.getControlDimension(p_DimensionIndex);
        if (o_ControlDimension == null) {
            return -1.0;
        }
        return o_ControlDimension.getValue();
    }

    public void setValueManuallyIsReady() {
        int intControlCount = this.getControlObjectCount();
        for (int intControl = 0; intControl < intControlCount; ++intControl) {
            ControlObject o_ControlObject = this.getControlObject(intControl);
            if (o_ControlObject == null) continue;
            o_ControlObject.setValueManuallyIsReady();
        }
    }

    public ArrayList<Double> getInitValues(ArrayList<Double> p_Values) {
        int intControlCount = this.getControlObjectCount();
        ControlObject o_ControlObject = this.getControlObject(0);
        if (o_ControlObject == null) {
            return null;
        }
        int intDimensionCount = o_ControlObject.getControlDimensionCount();
        if (p_Values == null) {
            p_Values = new ArrayList(intControlCount * intDimensionCount);
            for (int intValue = 0; intValue < intControlCount * intDimensionCount; ++intValue) {
                p_Values.add(-1.0);
            }
        } else if (p_Values.size() != intControlCount * intDimensionCount) {
            return null;
        }
        for (int intControl = 0; intControl < intControlCount; ++intControl) {
            o_ControlObject = this.getControlObject(intControl);
            if (o_ControlObject == null) continue;
            for (int intDimension = 0; intDimension < intDimensionCount; ++intDimension) {
                double doubleValue = 0.0;
                p_Values.set(intControl * intDimensionCount + intDimension, doubleValue);
            }
        }
        return p_Values;
    }

    public boolean setValue(double p_Value, int p_ControlIndex, int p_DimensionIndex) {
        ControlObject o_ControlObject = this.getControlObject(p_ControlIndex);
        if (o_ControlObject == null) {
            return false;
        }
        ControlObject.ControlDimension o_ControlDimension = o_ControlObject.getControlDimension(p_DimensionIndex);
        if (o_ControlDimension == null) {
            return false;
        }
        o_ControlDimension.setValue(p_Value);
        o_ControlDimension.adjustToValue(p_Value, true);
        return true;
    }

    public double getValueMaximum(int p_ControlIndex, int p_DimensionIndex) {
        ControlObject o_ControlObject = this.getControlObject(p_ControlIndex);
        if (o_ControlObject == null) {
            return -1.0;
        }
        ControlObject.ControlDimension o_ControlDimension = o_ControlObject.getControlDimension(p_DimensionIndex);
        if (o_ControlDimension == null) {
            return -1.0;
        }
        return o_ControlDimension.getValueMaximum();
    }

    public double getValueMinimum(int p_ControlIndex, int p_DimensionIndex) {
        ControlObject o_ControlObject = this.getControlObject(p_ControlIndex);
        if (o_ControlObject == null) {
            return -1.0;
        }
        ControlObject.ControlDimension o_ControlDimension = o_ControlObject.getControlDimension(p_DimensionIndex);
        if (o_ControlDimension == null) {
            return -1.0;
        }
        return o_ControlDimension.getValueMinimum();
    }

    public boolean setControlMeter(JControlMeter p_ControlMeterObject, int p_ControlIndex, int p_DimensionIndex) {
        ArrayList<Object> o_Control_ControlMeters;
        if (p_ControlIndex < 0) {
            return false;
        }
        if (p_ControlIndex >= this.m_ControlMeters.size()) {
            for (int intControl = this.m_ControlMeters.size(); intControl <= p_ControlIndex; ++intControl) {
                this.m_ControlMeters.add(null);
            }
        }
        if ((o_Control_ControlMeters = this.m_ControlMeters.get(p_ControlIndex)) == null) {
            o_Control_ControlMeters = new ArrayList();
        }
        this.m_ControlMeters.set(p_ControlIndex, o_Control_ControlMeters);
        if (p_DimensionIndex >= o_Control_ControlMeters.size()) {
            for (int intDimension = o_Control_ControlMeters.size(); intDimension <= p_DimensionIndex; ++intDimension) {
                o_Control_ControlMeters.add(null);
            }
        }
        o_Control_ControlMeters.set(p_DimensionIndex, p_ControlMeterObject);
        return true;
    }

    public JControlMeter getControlMeter(int p_ControlIndex, int p_DimensionIndex) {
        if (p_ControlIndex < 0 || p_ControlIndex >= this.m_ControlMeters.size()) {
            return null;
        }
        ArrayList<JControlMeter> o_Control_ControlMeters = this.m_ControlMeters.get(p_ControlIndex);
        if (o_Control_ControlMeters == null) {
            return null;
        }
        if (p_DimensionIndex < 0 || p_DimensionIndex >= o_Control_ControlMeters.size()) {
            return null;
        }
        return o_Control_ControlMeters.get(p_DimensionIndex);
    }

    public JControlMeter getControlMeter(ControlObject.ControlDimension p_ControlDimension) {
        for (int intControl = 0; intControl < this.m_ControlObjects.size(); ++intControl) {
            ControlObject o_ControlObject = this.m_ControlObjects.get(intControl);
            for (int intDimension = 0; intDimension <= o_ControlObject.getControlDimensionCount(); ++intDimension) {
                if (o_ControlObject.getControlDimension(intDimension) != p_ControlDimension) continue;
                return this.getControlMeter(intControl, intDimension);
            }
        }
        return null;
    }

    public DeviceControlLink addDMXDeviceControlLink(DMXDevice p_DMXDevice, int p_DMXDeviceSectorIndex, int p_InternalChannel, int p_ControlIndex, int p_DimensionIndex, int p_ByteIndex) {
        if (this.m_DMXControlType == null) {
            this.getDMXControlType();
        }
        return this.m_DMXControlType.addDMXDeviceControlLink(p_DMXDevice, p_DMXDeviceSectorIndex, p_InternalChannel, p_ControlIndex, p_DimensionIndex, p_ByteIndex);
    }

    public DeviceControlLink getDeviceControlLink(DMXDevice p_DMXDevice, int p_DMXDeviceSectorIndex, int p_InternalChannel, int p_ControlIndex, int p_DimensionIndex, int p_ByteIndex) {
        if (this.m_DMXControlType == null) {
            this.getDMXControlType();
        }
        return this.m_DMXControlType.getDeviceControlLink(p_DMXDevice, p_DMXDeviceSectorIndex, p_InternalChannel, p_ControlIndex, p_DimensionIndex, p_ByteIndex);
    }

    public abstract void changedDMXControlLinks();

    public void setIsMaster(boolean p_IsMaster) {
        this.m_IsMaster = p_IsMaster;
        for (int intControlObject = 0; intControlObject < this.getControlObjectCount(); ++intControlObject) {
            ControlObject.ControlDimension o_ControlDimension;
            int intControlDimension;
            int intDimensionCount;
            ControlObject o_ControlObject = this.getControlObject(intControlObject);
            o_ControlObject.setControlMaster(p_IsMaster);
            if (!p_IsMaster) continue;
            if (!o_ControlObject.getInvertedSecondary()) {
                intDimensionCount = o_ControlObject.getControlDimensionCount();
                for (intControlDimension = 0; intControlDimension < intDimensionCount; ++intControlDimension) {
                    o_ControlDimension = o_ControlObject.getControlDimension(intControlDimension);
                    o_ControlDimension.setValue(o_ControlDimension.getValueMaximum());
                }
                continue;
            }
            intDimensionCount = o_ControlObject.getControlDimensionCount();
            for (intControlDimension = 0; intControlDimension < intDimensionCount; ++intControlDimension) {
                o_ControlDimension = o_ControlObject.getControlDimension(intControlDimension);
                o_ControlDimension.setValueWithoutFirePropertyChange(o_ControlDimension.getValueMaximum());
                o_ControlDimension.setValue(o_ControlDimension.getValueMinimum());
            }
        }
    }

    public boolean isMaster() {
        return this.m_IsMaster;
    }

    public static DMXControlComponentCellRenderer getDMXControlComponentCellRenderer() {
        return s_DMXControlComponentCellRenderer;
    }

    public static class DMXControlComponentCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private StringBuilder m_StringBuilder;

        public DMXControlComponentCellRenderer() {
            this.initMembers();
        }

        private void initMembers() {
            this.m_StringBuilder = new StringBuilder();
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Color o_Background = null;
            Color o_Foreground = null;
            o_Background = list.getBackground();
            o_Foreground = list.getForeground();
            if (isSelected) {
                if (list.hasFocus()) {
                    o_Background = UIManager.getColor("List.selectionBackground");
                    o_Foreground = UIManager.getColor("List.selectionForeground");
                } else {
                    o_Background = UIManager.getColor("List.selectionInactiveBackground");
                    o_Foreground = UIManager.getColor("List.selectionInactiveForeground");
                }
            }
            this.setForeground(o_Foreground);
            this.setBackground(o_Background);
            if (value == null) {
                this.setText("");
            } else if (value instanceof DMXControlComponent) {
                DMXControlComponent o_DMXControlComponent = (DMXControlComponent)value;
                this.m_StringBuilder.delete(0, this.m_StringBuilder.length());
                this.m_StringBuilder.append("<html>");
                this.m_StringBuilder.append("<b>");
                this.m_StringBuilder.append(o_DMXControlComponent.getName());
                this.m_StringBuilder.append("</b>");
                this.m_StringBuilder.append(" ");
                this.m_StringBuilder.append(o_DMXControlComponent.getDMXControlType().getDMXControlDescription().getName());
                this.m_StringBuilder.append("</html>");
                this.setText(this.m_StringBuilder.toString());
            }
            return this;
        }
    }

    public static class DMXControlComponentList
    extends TableAndListModel.ListModel<DMXControlComponent> {
        private HashMap<String, DMXControlComponent> m_DMXControlComponents = new HashMap();

        public DMXControlComponentList() {
            super(false);
        }

        @Override
        public boolean add(DMXControlComponent p_DMXControlComponent) {
            if (p_DMXControlComponent != null) {
                this.m_DMXControlComponents.put(p_DMXControlComponent.getDMXControlTypeID(), p_DMXControlComponent);
            }
            return super.add(p_DMXControlComponent);
        }

        @Override
        public boolean add(int p_Position, DMXControlComponent p_DMXControlComponent) {
            if (p_DMXControlComponent != null) {
                this.m_DMXControlComponents.put(p_DMXControlComponent.getDMXControlTypeID(), p_DMXControlComponent);
            }
            return super.add(p_Position, p_DMXControlComponent);
        }

        @Override
        public boolean remove(DMXControlComponent p_DMXControlComponent) {
            if (p_DMXControlComponent != null) {
                this.m_DMXControlComponents.remove(p_DMXControlComponent.getDMXControlTypeID());
            }
            return super.remove(p_DMXControlComponent);
        }

        public void remove(int p_Index) {
            if (p_Index < 0) {
                return;
            }
            DMXControlComponent o_DMXControlComponent = (DMXControlComponent)this.get(p_Index);
            if (o_DMXControlComponent == null) {
                return;
            }
            this.m_DMXControlComponents.remove(o_DMXControlComponent.getDMXControlTypeID());
            super.remove(o_DMXControlComponent);
        }

        public DMXControlComponent getByDMXControlTypeID(String p_ID) {
            return this.m_DMXControlComponents.get(p_ID);
        }
    }

    public static class ControlTypeCellRenderer
    implements ListCellRenderer {
        protected DefaultListCellRenderer defaultRenderer = new DefaultListCellRenderer();

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel renderer = (JLabel)this.defaultRenderer.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            Color o_Background = null;
            Color o_Foreground = null;
            o_Background = list.getBackground();
            o_Foreground = list.getForeground();
            if (isSelected) {
                if (list.hasFocus()) {
                    o_Background = UIManager.getColor("List.selectionBackground");
                    o_Foreground = UIManager.getColor("List.selectionForeground");
                } else {
                    o_Background = UIManager.getColor("List.selectionInactiveBackground");
                    o_Foreground = UIManager.getColor("List.selectionInactiveForeground");
                }
            }
            renderer.setForeground(o_Foreground);
            renderer.setBackground(o_Background);
            if (value instanceof ControlType) {
                ControlType o_ControlType = (ControlType)value;
                renderer.setText(o_ControlType.getName());
            }
            return renderer;
        }
    }

    public static class ControlTypeListModel
    implements ComboBoxModel,
    PropertyChangeListener {
        protected ArrayList<ListDataListener> m_ArrayListListDataListeners;
        protected ControlType m_SelectedControlType;
        protected DMXControlType m_DMXControlType;
        protected ControlTypeCellRenderer m_ControlTypeCellRenderer;

        public ControlTypeListModel() {
            this.initMembers();
            this.m_DMXControlType = null;
        }

        private void initMembers() {
            this.readResolve();
        }

        private Object readResolve() {
            this.m_ArrayListListDataListeners = new ArrayList();
            return this;
        }

        public void setDMXControlType(DMXControlType p_DMXControlType) {
            ControlType o_ControlType;
            int intControl;
            ListDataEvent o_ListDataEvent;
            if (this.m_DMXControlType == p_DMXControlType) {
                return;
            }
            DMXControlType oldValue = this.m_DMXControlType;
            if (oldValue != null) {
                o_ListDataEvent = new ListDataEvent(this, 2, 0, oldValue.getControlTypeCount() - 1);
                this.sendEventToDataListeners(o_ListDataEvent);
                for (intControl = 0; intControl < oldValue.getControlTypeCount(); ++intControl) {
                    o_ControlType = oldValue.getControlType(intControl);
                    o_ControlType.removePropertyChangeListener(this);
                }
            }
            this.m_DMXControlType = p_DMXControlType;
            if (this.m_DMXControlType != null) {
                o_ListDataEvent = new ListDataEvent(this, 1, 0, this.m_DMXControlType.getControlTypeCount() - 1);
                this.sendEventToDataListeners(o_ListDataEvent);
                for (intControl = 0; intControl < this.m_DMXControlType.getControlTypeCount(); ++intControl) {
                    o_ControlType = this.m_DMXControlType.getControlType(intControl);
                    o_ControlType.addPropertyChangeListener(this);
                }
            }
        }

        @Override
        public int getSize() {
            if (this.m_DMXControlType == null) {
                return 0;
            }
            return this.m_DMXControlType.getControlTypeCount();
        }

        @Override
        public Object getElementAt(int index) {
            if (this.m_DMXControlType == null) {
                return null;
            }
            if (index < 0) {
                return null;
            }
            if (index >= this.m_DMXControlType.getControlTypeCount()) {
                return null;
            }
            return this.m_DMXControlType.getControlType(index);
        }

        @Override
        public void setSelectedItem(Object anItem) {
            if (anItem == null) {
                this.m_SelectedControlType = null;
                return;
            }
            this.m_SelectedControlType = anItem instanceof ControlType ? (ControlType)anItem : null;
        }

        @Override
        public Object getSelectedItem() {
            return this.m_SelectedControlType;
        }

        @Override
        public void addListDataListener(ListDataListener p_ListDataListener) {
            if (p_ListDataListener == null) {
                return;
            }
            if (this.m_ArrayListListDataListeners == null) {
                return;
            }
            if (this.m_ArrayListListDataListeners.contains(p_ListDataListener)) {
                return;
            }
            this.m_ArrayListListDataListeners.add(p_ListDataListener);
        }

        @Override
        public void removeListDataListener(ListDataListener p_ListDataListener) {
            if (p_ListDataListener == null) {
                return;
            }
            if (this.m_ArrayListListDataListeners == null) {
                return;
            }
            this.m_ArrayListListDataListeners.remove(p_ListDataListener);
        }

        public void sendEventToDataListeners(ListDataEvent p_ListDataEvent) {
            if (p_ListDataEvent == null) {
                return;
            }
            if (this.m_ArrayListListDataListeners == null) {
                return;
            }
            for (int intListener = 0; intListener < this.m_ArrayListListDataListeners.size(); ++intListener) {
                ListDataListener o_ListDataListener = this.m_ArrayListListDataListeners.get(intListener);
                o_ListDataListener.intervalAdded(p_ListDataEvent);
            }
        }

        public void fireControlTypeAdded(ControlType p_ControlType) {
            if (this.m_ArrayListListDataListeners == null || this.m_DMXControlType == null) {
                return;
            }
            int intIndex = this.m_DMXControlType.getControlTypeIndex(p_ControlType);
            ListDataEvent o_ListDataEvent = new ListDataEvent(this, 1, intIndex, intIndex);
            this.sendEventToDataListeners(o_ListDataEvent);
        }

        public void fireControlTypeRemoved(ControlType p_ControlType) {
            if (p_ControlType == null) {
                return;
            }
            int intIndex = this.m_DMXControlType.getControlTypeIndex(p_ControlType);
            this.fireControlTypeRemoved(intIndex);
        }

        public void fireControlTypeRemoved(int p_Index) {
            ListDataEvent o_ListDataEvent = new ListDataEvent(this, 2, p_Index, p_Index);
            this.sendEventToDataListeners(o_ListDataEvent);
        }

        public void fireControlTypeChanged(ControlType p_ControlType) {
            int intIndex = this.m_DMXControlType.getControlTypeIndex(p_ControlType);
            ListDataEvent o_ListDataEvent = new ListDataEvent(this, 0, intIndex, intIndex);
            this.sendEventToDataListeners(o_ListDataEvent);
        }

        public DMXControlType getDMXControlType() {
            return this.m_DMXControlType;
        }

        public ControlTypeCellRenderer getControlTypeCellRenderer() {
            if (this.m_ControlTypeCellRenderer == null) {
                this.m_ControlTypeCellRenderer = new ControlTypeCellRenderer();
            }
            return this.m_ControlTypeCellRenderer;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (this.m_DMXControlType == null) {
                return;
            }
            if (evt.getSource() instanceof ControlType && "controltypeName".equals(evt.getPropertyName())) {
                int intIndex = this.m_DMXControlType.getControlTypeIndex((ControlType)evt.getSource());
                ListDataEvent o_ListDataEvent = new ListDataEvent(this, 0, intIndex, intIndex);
                this.sendEventToDataListeners(o_ListDataEvent);
            }
        }
    }

    public static class DeviceControlLink
    implements Externalizable,
    PropertyChangeListener {
        public static final int SOFTWAREVERSION = 1;
        public static final String PROP_INDEXED_DEVICECONTROLLINK_INTERNALCHANNEL = "deviceInternalChannel";
        public static final String PROP_DEVICECONTROLLINK_VALUENEW = "deviceInternalChannelNewValue";
        public static final String PROP_DEVICECONTROLLINK_VALUEFACTOR = "deviceInternalChannelValueFactor";
        public static final String PROPERTY_DEVICECONTROLLINK_VALUEINTERFACE = "valueInterface";
        public static final int FLAG_LINKED_NONE = 0;
        public static final int FLAG_LINKED_LOW = 1;
        public static final int FLAG_LINKED_HIGH = 2;
        public static final int FLAG_LINKED_BOTH = 3;
        private DMXDevice m_DMXDevice;
        private String m_DMXDeviceID;
        private int m_DMXDeviceSectorIndex;
        private ArrayList<Integer> m_DeviceInternalChannels;
        private DMXControlType m_DMXControlTypeOfDMXDeviceType;
        private ControlDimensionType m_ControlDimensionTypeOfDMXDeviceType;
        private long m_MaxValue;
        private ArrayList<Double> m_DeviceInternalChannelsValueFactor;
        private ControlDimensionType m_ControlDimensionType;
        private boolean m_IsMainMixerLink;
        private int m_MixerPanelOwner;
        private boolean m_IsMixerLink;
        private ControlObject.ControlDisplayItem m_ControlDisplayItem;
        private long m_ValueControlDimension;
        private long m_ValueChannels;
        private long m_ValueInterface;
        private long m_ValueInterface_Input;
        private long m_ValueEditMode;
        private double m_ValueFactor;
        private int m_FlagLinkedBytes;
        private int m_ValueLinkedMaximum;
        private LiveCloseSemaphore m_LiveCloseSemaphore;
        private SinglePropertyChangeSupport m_PropertyChangeSupport;

        public DeviceControlLink(ControlDimensionType p_ControlDimensionType) {
            this.initMembers();
            this.m_ControlDimensionType = p_ControlDimensionType;
        }

        public DeviceControlLink(DMXDevice p_DMXDevice, int p_DMXDeviceSectorIndex, ControlDimensionType p_ControlDimensionType) {
            this.initMembers();
            this.m_ControlDimensionType = p_ControlDimensionType;
            this.m_DMXDeviceSectorIndex = p_DMXDeviceSectorIndex;
            double doubleValuaMaximum = this.m_ControlDimensionType.getValueMaximum();
            for (int intByte = 0; intByte < this.m_ControlDimensionType.getByteResolution(); ++intByte) {
                this.addDeviceInternalChannel(intByte, -1);
            }
            JControlMeter o_JControlMeter = this.m_ControlDimensionType.getInstanceControlMeter();
            if (o_JControlMeter != null) {
                this.m_ControlDisplayItem = o_JControlMeter.createControlDisplayItem((Object)this, PROPERTY_DEVICECONTROLLINK_VALUEINTERFACE);
                this.m_ControlDisplayItem.setToolTipText(this.getDMXDeviceName());
            }
            this.setInstance(p_DMXDevice);
        }

        private void initMembers() {
            this.m_IsMainMixerLink = false;
            this.m_MixerPanelOwner = 0;
            this.m_IsMixerLink = false;
            this.m_LiveCloseSemaphore = new LiveCloseSemaphore(this.getClass().getSimpleName());
            this.m_DMXDevice = null;
            this.m_DeviceInternalChannels = new ArrayList();
            this.m_DeviceInternalChannelsValueFactor = new ArrayList();
            this.m_ControlDimensionType = null;
            this.m_DMXControlTypeOfDMXDeviceType = null;
            this.m_ControlDimensionTypeOfDMXDeviceType = null;
            this.m_PropertyChangeSupport = new SinglePropertyChangeSupport(this);
            this.m_ValueControlDimension = 0L;
            this.m_ValueChannels = 0L;
            this.m_ValueInterface = 0L;
            this.m_ValueInterface_Input = 0L;
            this.m_ValueEditMode = 0L;
            this.m_ValueFactor = 1.0;
            this.m_ControlDisplayItem = null;
            this.m_FlagLinkedBytes = 0;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(1);
            out.writeUTF(this.m_DMXDeviceID);
            out.writeInt(this.m_DMXDeviceSectorIndex);
            int intByteResolution = this.m_DeviceInternalChannels.size();
            out.writeInt(intByteResolution);
            for (int intByte = 0; intByte < intByteResolution; ++intByte) {
                out.writeInt(this.m_DeviceInternalChannels.get(intByte));
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int intSoftwareVersion = in.readInt();
            this.m_DMXDeviceID = in.readUTF();
            if ("TEST".equals(this.m_DMXDeviceID)) {
                this.m_DMXDeviceID = "";
            }
            this.m_DMXDeviceSectorIndex = in.readInt();
            JControlMeter o_JControlMeter = this.m_ControlDimensionType.getInstanceControlMeter();
            if (o_JControlMeter != null) {
                this.m_ControlDisplayItem = o_JControlMeter.createControlDisplayItem((Object)this, PROPERTY_DEVICECONTROLLINK_VALUEINTERFACE);
                this.m_ControlDisplayItem.setToolTipText(this.getDMXDeviceName());
            }
            int intDeviceByteResolution = in.readInt();
            for (int intByte = 0; intByte < intDeviceByteResolution; ++intByte) {
                this.addDeviceInternalChannel(intByte, in.readInt());
            }
        }

        public long getDiskSpaceEstimated() {
            long longBytesCount = 0L;
            longBytesCount += 4L;
            longBytesCount += (long)(this.m_DMXDeviceID.length() * 2);
            longBytesCount += 4L;
            int intByteResolution = this.m_DeviceInternalChannels.size();
            longBytesCount += 4L;
            for (int intByte = 0; intByte < intByteResolution; ++intByte) {
                longBytesCount += 4L;
            }
            return longBytesCount;
        }

        public void close() {
            if (!this.m_LiveCloseSemaphore.enterCloseSection()) {
                return;
            }
            if (this.m_ControlDisplayItem != null) {
                this.m_ControlDisplayItem.getControlDimension().removeControlDisplayItem(this.m_ControlDisplayItem);
            }
            this.m_ControlDisplayItem = null;
            if (this.m_DeviceInternalChannels != null) {
                int intByteResolution = this.m_DeviceInternalChannels.size();
                for (int intByte = intByteResolution - 1; intByte >= 0; --intByte) {
                    this.removeDeviceInternalChannel(intByte);
                }
            }
            if (this.m_ControlDimensionType != null) {
                this.m_ControlDimensionType.removeDeviceControlLink(this);
            }
            this.m_ControlDimensionType = null;
            if (this.m_DMXDevice != null) {
                this.m_DMXDevice.removePropertyChangeListener(this);
                this.m_DMXDevice.removeDeviceControlLink(this);
            }
            this.m_DMXDevice = null;
            if (this.m_DeviceInternalChannels != null) {
                this.m_DeviceInternalChannels.clear();
            }
            if (this.m_DeviceInternalChannelsValueFactor != null) {
                this.m_DeviceInternalChannelsValueFactor.clear();
            }
            if (this.m_PropertyChangeSupport != null) {
                this.m_PropertyChangeSupport.clear();
            }
            this.m_LiveCloseSemaphore.leaveCloseSection();
        }

        public void finalize() throws Throwable {
            super.finalize();
            this.m_PropertyChangeSupport = null;
        }

        public void setIsMainMixerLink(boolean p_IsMainLink) {
            this.m_IsMainMixerLink = p_IsMainLink;
        }

        public boolean getIsMainMixerLink() {
            return this.m_IsMainMixerLink;
        }

        public void setMixerPanelOwner(int p_MixerPanelOwner) {
            this.m_MixerPanelOwner = p_MixerPanelOwner;
        }

        public int getMixerPanelOwner() {
            return this.m_MixerPanelOwner;
        }

        public void setInstance(DMXDevice p_DMXDevice) {
            if (this.m_DMXDevice == p_DMXDevice) {
                return;
            }
            if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
                return;
            }
            DMXDevice oldDMXDevice = this.m_DMXDevice;
            this.m_LiveCloseSemaphore.leaveWorkerSection();
            if (oldDMXDevice != null) {
                oldDMXDevice.removePropertyChangeListener(this);
                oldDMXDevice.removeDeviceControlLink(this);
            }
            this.m_DMXDevice = p_DMXDevice;
            if (this.m_DMXDevice != null) {
                this.m_DMXDeviceID = this.m_DMXDevice.getID();
                this.m_DMXDevice.addDeviceControlLink(this);
                this.m_DMXDevice.addPropertyChangeListener(this);
            } else {
                this.m_DMXDeviceID = "";
            }
            this.refreshValuesInternalChannels_EditMode();
            this.refreshValuesInternalChannels(false);
            this.refreshValueDMXInterface();
        }

        public int getControlDimensionTypeIndex() {
            return this.m_ControlDimensionType.getIndex();
        }

        public ControlDimensionType getControlDimensionType() {
            return this.m_ControlDimensionType;
        }

        public int getControlTypeIndex() {
            if (this.m_ControlDimensionType == null) {
                return -1;
            }
            ControlType o_ControlType = this.m_ControlDimensionType.getControlType();
            if (o_ControlType == null) {
                return -1;
            }
            return o_ControlType.getIndex();
        }

        public ControlType getControlType() {
            if (this.m_ControlDimensionType == null) {
                return null;
            }
            return this.m_ControlDimensionType.getControlType();
        }

        public DMXControlType getDMXControlType() {
            ControlType o_ControlType = this.getControlType();
            if (o_ControlType == null) {
                return null;
            }
            return o_ControlType.getDMXControlType();
        }

        public DMXControlComponent getDMXControlComponent() {
            if (this.m_ControlDimensionType == null) {
                return null;
            }
            return this.m_ControlDimensionType.getDMXControlComponent();
        }

        public boolean addDeviceInternalChannel(int p_ByteIndex, int p_DeviceInternalChannel) {
            boolean boolChanged = false;
            DMXControlType o_DMXControlType = null;
            ControlDimensionType o_ControlDimensionType = null;
            int intResolution = this.getByteResolution();
            int oldValue = -1;
            if (p_ByteIndex >= intResolution) {
                for (int intByte = p_ByteIndex; intByte >= intResolution; --intByte) {
                    this.m_DeviceInternalChannels.add(new Integer(-1));
                    this.m_DeviceInternalChannelsValueFactor.add(new Double(1.0));
                }
            }
            this.m_MaxValue = (long)Math.pow(256.0, this.m_DeviceInternalChannels.size()) - 1L;
            oldValue = this.m_DeviceInternalChannels.get(p_ByteIndex);
            if (oldValue != p_DeviceInternalChannel) {
                boolChanged = true;
            }
            if (boolChanged) {
                this.m_DeviceInternalChannels.set(p_ByteIndex, p_DeviceInternalChannel);
                if (this.m_DMXDevice != null) {
                    DMXDeviceType.DMXDeviceChannelType o_DMXDeviceChannelType;
                    DMXDeviceType.DMXDeviceSector o_DMXDeviceSector;
                    DMXDeviceType o_DMXDeviceType;
                    DMXDevice.InternalChannel o_InternalChannel = this.m_DMXDevice.getInternalChannel(this.m_DMXDeviceSectorIndex, oldValue);
                    if (o_InternalChannel != null) {
                        o_InternalChannel.removeDeviceControlLink(this);
                    }
                    if ((o_InternalChannel = this.m_DMXDevice.getInternalChannel(this.m_DMXDeviceSectorIndex, p_DeviceInternalChannel)) != null) {
                        o_InternalChannel.addDeviceControlLink(this, p_ByteIndex);
                    }
                    if ((o_DMXDeviceType = this.m_DMXDevice.getDMXDeviceType()) != null && (o_DMXDeviceSector = o_DMXDeviceType.getDMXDeviceSector(this.m_DMXDeviceSectorIndex)) != null && (o_DMXDeviceChannelType = o_DMXDeviceSector.getDMXDeviceChannelType(p_DeviceInternalChannel)) != null) {
                        o_DMXControlType = o_DMXDeviceChannelType.getDMXControlType();
                        o_ControlDimensionType = o_DMXDeviceChannelType.getControlDimensionType();
                    }
                }
                this.m_DMXControlTypeOfDMXDeviceType = o_DMXControlType;
                this.m_ControlDimensionTypeOfDMXDeviceType = o_ControlDimensionType;
                this.calculatedLinkedByteResolution();
                if (this.m_ControlDisplayItem != null) {
                    this.m_ControlDisplayItem.setName(this.getDMXDeviceChannelName());
                }
                this.m_PropertyChangeSupport.fireIndexedPropertyChange(PROP_INDEXED_DEVICECONTROLLINK_INTERNALCHANNEL, p_ByteIndex, oldValue, p_DeviceInternalChannel);
            }
            return boolChanged;
        }

        public boolean removeDeviceInternalChannel(int p_ByteIndex) {
            DMXDevice.InternalChannel o_InternalChannel;
            if (p_ByteIndex < 0 || p_ByteIndex >= this.m_DeviceInternalChannels.size()) {
                return false;
            }
            int oldValue = this.m_DeviceInternalChannels.get(p_ByteIndex);
            this.m_DeviceInternalChannels.set(p_ByteIndex, -1);
            this.m_DeviceInternalChannelsValueFactor.set(p_ByteIndex, 1.0);
            if (this.m_DMXDevice != null && (o_InternalChannel = this.m_DMXDevice.getInternalChannel(this.m_DMXDeviceSectorIndex, oldValue)) != null) {
                o_InternalChannel.removeDeviceControlLink(this);
            }
            this.calculatedLinkedByteResolution();
            if (this.m_ControlDisplayItem != null) {
                this.m_ControlDisplayItem.setName(this.getDMXDeviceChannelName());
            }
            this.m_PropertyChangeSupport.fireIndexedPropertyChange(PROP_INDEXED_DEVICECONTROLLINK_INTERNALCHANNEL, p_ByteIndex, oldValue, -1);
            this.refreshValuesInternalChannels(false);
            this.refreshValueDMXInterface();
            for (int intByte = 0; intByte < this.m_DeviceInternalChannels.size(); ++intByte) {
                if (this.m_DeviceInternalChannels.get(intByte) < 0) continue;
                return true;
            }
            this.close();
            return true;
        }

        public DMXControlType getDMXControlTypeOfDMXDeviceType() {
            return this.m_DMXControlTypeOfDMXDeviceType;
        }

        public ControlDimensionType getControlDimensionTypeOfDMXDeviceType() {
            return this.m_ControlDimensionTypeOfDMXDeviceType;
        }

        private void calculatedLinkedByteResolution() {
            int intChannelIndex_HighByte = -1;
            int intChannelIndex_LowByte = -1;
            if (this.m_DeviceInternalChannels.size() > 0) {
                intChannelIndex_HighByte = this.m_DeviceInternalChannels.get(0);
            }
            if (this.m_DeviceInternalChannels.size() > 1) {
                intChannelIndex_LowByte = this.m_DeviceInternalChannels.get(1);
            }
            if (intChannelIndex_HighByte >= 0 && intChannelIndex_LowByte >= 0) {
                this.m_FlagLinkedBytes = 3;
                this.m_ValueLinkedMaximum = 65535;
            } else if (intChannelIndex_HighByte >= 0) {
                this.m_FlagLinkedBytes = 2;
                this.m_ValueLinkedMaximum = 65280;
            } else if (intChannelIndex_LowByte >= 0) {
                this.m_FlagLinkedBytes = 1;
                this.m_ValueLinkedMaximum = 255;
            } else {
                this.m_FlagLinkedBytes = 0;
            }
        }

        public int getByteResolution_Linked() {
            return this.m_FlagLinkedBytes;
        }

        public int getValueLinkedMaximum() {
            return this.m_ValueLinkedMaximum;
        }

        public void eventDeviceTypeChanged() {
            if (this.m_ControlDisplayItem != null) {
                this.m_ControlDisplayItem.setName(this.getDMXDeviceChannelName());
            }
        }

        public int getByteResolution() {
            return this.m_DeviceInternalChannels.size();
        }

        public int getDeviceInternalChannel(int p_ByteIndex) {
            if (p_ByteIndex < 0 || p_ByteIndex >= this.m_DeviceInternalChannels.size()) {
                return -1;
            }
            return this.m_DeviceInternalChannels.get(p_ByteIndex);
        }

        public String getDMXDeviceID() {
            return this.m_DMXDeviceID;
        }

        public DMXDevice getDMXDevice() {
            return this.m_DMXDevice;
        }

        public String getDMXDeviceName() {
            String stringName = "";
            if (this.m_DMXDevice == null) {
                return stringName;
            }
            stringName = this.m_DMXDevice.getName();
            return stringName;
        }

        public int getDMXDeviceSectorIndex() {
            return this.m_DMXDeviceSectorIndex;
        }

        public String getDMXDeviceChannelName() {
            String stringName = "";
            if (this.m_DMXDevice == null) {
                return stringName;
            }
            stringName = this.m_DMXDevice.getName();
            for (int intByte = 0; intByte < this.m_DeviceInternalChannels.size(); ++intByte) {
                stringName = stringName + " ";
                stringName = stringName + this.m_DMXDevice.getChannelName(this.m_DMXDeviceSectorIndex, this.m_DeviceInternalChannels.get(intByte));
            }
            return stringName;
        }

        public void setInstanceControlDisplayItem(ControlObject.ControlDisplayItem p_ControlDisplayItem) {
            if (this.m_ControlDisplayItem == p_ControlDisplayItem) {
                return;
            }
            ControlObject.ControlDisplayItem oldValue = this.m_ControlDisplayItem;
            if (oldValue != null) {
                oldValue.getControlDimension().removeControlDisplayItem(this.m_ControlDisplayItem);
            }
            this.m_ControlDisplayItem = p_ControlDisplayItem;
            if (this.m_ControlDisplayItem != null) {
                this.m_ControlDisplayItem.setName(this.getDMXDeviceChannelName());
            }
            if (this.m_DMXDevice != null) {
                this.refreshValueDMXInterface();
            }
        }

        public ControlObject.ControlDisplayItem getControlDisplayItem() {
            return this.m_ControlDisplayItem;
        }

        public void setValueByte_ControlDimension(int p_ByteIndex, int p_Value, boolean p_ChangedManually) {
            int oldValue;
            int intInternalChannelIndex;
            DMXScene.DMXSceneDeviceSectorValues o_DMXSceneDeviceSectorValues;
            if (this.m_DMXDevice == null) {
                return;
            }
            if (p_ByteIndex < 0 || p_ByteIndex >= this.getByteResolution()) {
                return;
            }
            DMXDevice o_DMXDevice = this.m_DMXDevice;
            if (o_DMXDevice == null) {
                return;
            }
            if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
                return;
            }
            DMXDevice.InternalChannel o_DMXDeviceInternalChannel = o_DMXDevice.getInternalChannel(this.m_DMXDeviceSectorIndex, this.m_DeviceInternalChannels.get(p_ByteIndex));
            this.m_LiveCloseSemaphore.leaveWorkerSection();
            if (o_DMXDeviceInternalChannel == null) {
                return;
            }
            DMXScene.DMXSceneDeviceValues o_DMXSceneDeviceValues = "TEST".equals(this.m_DMXDeviceID) ? LiveShowDMXDeviceEditor.s_SelfReference.getDMXSceneDeviceValues() : (!LiveShowVIP.EDITMODEON ? DMXScene.s_DMXSceneValueContainer_Mixer.getDMXSceneDeviceValues(this.m_DMXDeviceID) : DMXScene.s_DMXSceneValueContainer_EditMode.getDMXSceneDeviceValues(this.m_DMXDeviceID));
            if (o_DMXSceneDeviceValues != null && (o_DMXSceneDeviceSectorValues = o_DMXSceneDeviceValues.getDMXSceneDeviceSectorValues(this.m_DMXDeviceSectorIndex)) != null && o_DMXSceneDeviceSectorValues.getDeviceValue(intInternalChannelIndex = this.m_DeviceInternalChannels.get(p_ByteIndex).intValue()) != (double)p_Value) {
                o_DMXSceneDeviceSectorValues.setDeviceValue(intInternalChannelIndex, p_Value);
                if (p_ChangedManually) {
                    o_DMXSceneDeviceSectorValues.setDeviceValueSetManually(intInternalChannelIndex, p_ChangedManually);
                }
            }
            if ((oldValue = o_DMXDeviceInternalChannel.getValue()) == p_Value) {
                return;
            }
            o_DMXDeviceInternalChannel.setValueByte_ControlDimension(p_Value);
            this.m_ValueControlDimension = this.getValue_ControlDimension();
        }

        public long getValue_ControlDimension() {
            if (this.m_DMXDevice == null) {
                return 0L;
            }
            long longResult = 0L;
            long longByteFactor = 1L;
            boolean boolOnlyOneByte = false;
            for (int intByte = this.m_DeviceInternalChannels.size() - 1; intByte >= 0; --intByte) {
                DMXDevice.InternalChannel o_DMXDeviceInternalChannel = this.m_DMXDevice.getInternalChannel(this.m_DMXDeviceSectorIndex, this.m_DeviceInternalChannels.get(intByte));
                if (o_DMXDeviceInternalChannel != null) {
                    longResult += (long)o_DMXDeviceInternalChannel.getValueByte_ControlDimension() * longByteFactor;
                }
                longByteFactor *= 256L;
            }
            return longResult;
        }

        public void setValueByte_Factor(int p_ByteIndex, double p_Value) {
            if (p_ByteIndex < 0 || p_ByteIndex >= this.getByteResolution()) {
                return;
            }
            if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
                return;
            }
            DMXDevice.InternalChannel o_DMXDeviceInternalChannel = this.m_DMXDevice.getInternalChannel(this.m_DMXDeviceSectorIndex, this.m_DeviceInternalChannels.get(p_ByteIndex));
            this.m_LiveCloseSemaphore.leaveWorkerSection();
            if (o_DMXDeviceInternalChannel == null) {
                return;
            }
            double oldValue = o_DMXDeviceInternalChannel.getValueByte_MasterFactor();
            if (oldValue == p_Value) {
                return;
            }
            o_DMXDeviceInternalChannel.setValueByte_MasterFactor(this, p_Value);
            this.m_ValueFactor = this.getValue_Factor();
        }

        public double getValue_Factor() {
            if (this.m_DMXDevice == null) {
                return 1.0;
            }
            double doubleResult = 1.0;
            for (int intByte = this.m_DeviceInternalChannels.size() - 1; intByte >= 0; --intByte) {
                double doubleChannelValueFactor;
                DMXDevice.InternalChannel o_DMXDeviceInternalChannel = this.m_DMXDevice.getInternalChannel(this.m_DMXDeviceSectorIndex, this.m_DeviceInternalChannels.get(intByte));
                if (o_DMXDeviceInternalChannel == null) continue;
                doubleResult = doubleChannelValueFactor = o_DMXDeviceInternalChannel.getValueByte_MasterFactor();
            }
            return doubleResult;
        }

        public int getValueByte(long p_Value, int p_ByteIndex) {
            long longValue = p_Value;
            int intByteValue = 0;
            long longByteFactor = this.m_MaxValue + 1L;
            for (int intByteIndex = 0; intByteIndex < this.m_DeviceInternalChannels.size(); ++intByteIndex) {
                intByteValue = (longByteFactor /= 256L) <= 0L ? 0 : (int)(longValue / longByteFactor);
                if (p_ByteIndex == intByteIndex) {
                    return intByteValue;
                }
                longValue -= longByteFactor * (long)intByteValue;
            }
            return 0;
        }

        public long getValueInternalChannels() {
            if (this.m_DMXDevice == null) {
                return 0L;
            }
            long longResult = 0L;
            long longByteFactor = 1L;
            for (int intByte = this.m_DeviceInternalChannels.size() - 1; intByte >= 0; --intByte) {
                DMXDevice.InternalChannel o_DMXDeviceInternalChannel = this.m_DMXDevice.getInternalChannel(this.m_DMXDeviceSectorIndex, this.m_DeviceInternalChannels.get(intByte));
                if (o_DMXDeviceInternalChannel != null) {
                    longResult += (long)o_DMXDeviceInternalChannel.getValue() * longByteFactor;
                }
                longByteFactor *= 256L;
            }
            return longResult;
        }

        public void refreshValuesInternalChannels(boolean p_ManuallySet) {
            long longValue;
            if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
                return;
            }
            this.m_ValueChannels = longValue = this.getValueInternalChannels();
            this.adjustControlDimension(p_ManuallySet);
            this.m_LiveCloseSemaphore.leaveWorkerSection();
        }

        public void adjustControlDimension(boolean p_ManuallySet) {
            ControlObject.ControlDimension o_ControlDimension;
            if (LiveShowVIP.EDITMODEON) {
                return;
            }
            if (this.m_ControlDimensionType.getDeviceControlLinkCount() == 1 && this.m_ControlDimensionType.getPartnerDeviceControlLinkCount() == 0 && (o_ControlDimension = this.m_ControlDimensionType.getInstance()) != null) {
                o_ControlDimension.getControlObject().adjustToValue(o_ControlDimension, (double)this.m_ValueChannels, p_ManuallySet);
            }
        }

        public void setValueInternalChannels_Validated(long p_ValueValidated) {
            long longValue = p_ValueValidated;
            int intByteValue = 0;
            long longByteFactor = this.m_MaxValue + 1L;
            if (longValue > this.m_MaxValue) {
                longValue = this.m_MaxValue;
            }
            for (int intByteIndex = 0; intByteIndex < this.m_DeviceInternalChannels.size(); ++intByteIndex) {
                DMXDevice.InternalChannel o_DMXDeviceInternalChannel = this.m_DMXDevice.getInternalChannel(this.m_DMXDeviceSectorIndex, this.m_DeviceInternalChannels.get(intByteIndex));
                intByteValue = (longByteFactor /= 256L) <= 0L ? 0 : (int)(longValue / longByteFactor);
                longValue -= longByteFactor * (long)intByteValue;
                if (o_DMXDeviceInternalChannel == null) continue;
                o_DMXDeviceInternalChannel.setValue_Validated(intByteValue);
            }
        }

        public long getValueInternalChannels_DMXChannels() {
            if (this.m_DMXDevice == null) {
                return 0L;
            }
            long longResult = 0L;
            long longByteFactor = 1L;
            for (int intByte = this.m_DeviceInternalChannels.size() - 1; intByte >= 0; --intByte) {
                DMXDevice.InternalChannel o_DMXDeviceInternalChannel = this.m_DMXDevice.getInternalChannel(this.m_DMXDeviceSectorIndex, this.m_DeviceInternalChannels.get(intByte));
                if (o_DMXDeviceInternalChannel != null) {
                    longResult += (long)o_DMXDeviceInternalChannel.getValueDMXChannel() * longByteFactor;
                }
                longByteFactor *= 256L;
            }
            return longResult;
        }

        public long getValueInternalChannels_EditMode() {
            if (this.m_DMXDevice == null) {
                return 0L;
            }
            long longResult = 0L;
            long longByteFactor = 1L;
            for (int intByte = this.m_DeviceInternalChannels.size() - 1; intByte >= 0; --intByte) {
                DMXDevice.InternalChannel o_DMXDeviceInternalChannel = this.m_DMXDevice.getInternalChannel(this.m_DMXDeviceSectorIndex, this.m_DeviceInternalChannels.get(intByte));
                if (o_DMXDeviceInternalChannel != null) {
                    longResult += (long)o_DMXDeviceInternalChannel.getValue_EditMode() * longByteFactor;
                }
                longByteFactor *= 256L;
            }
            return longResult;
        }

        public void refreshValuesInternalChannels_EditMode() {
            long longValue;
            if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
                return;
            }
            this.m_ValueEditMode = longValue = this.getValueInternalChannels_EditMode();
            this.adjustControlDimension_EditMode();
            this.m_LiveCloseSemaphore.leaveWorkerSection();
        }

        public void adjustControlDimension_EditMode() {
            ControlObject.ControlDimension o_ControlDimension;
            if (!LiveShowVIP.EDITMODEON) {
                return;
            }
            if (this.m_ControlDimensionType.getDeviceControlLinkCount() == 1 && this.m_ControlDimensionType.getPartnerDeviceControlLinkCount() == 0 && (o_ControlDimension = this.m_ControlDimensionType.getInstance()) != null) {
                o_ControlDimension.getControlObject().adjustToValue(o_ControlDimension, (double)this.m_ValueEditMode, true);
            }
        }

        public void setValueInternalChannels_Validated_EditMode(long p_ValueValidated) {
            long longValue = p_ValueValidated;
            int intByteValue = 0;
            long longByteFactor = this.m_MaxValue + 1L;
            if (longValue > this.m_MaxValue) {
                longValue = this.m_MaxValue;
            }
            for (int intByteIndex = 0; intByteIndex < this.m_DeviceInternalChannels.size(); ++intByteIndex) {
                DMXDevice.InternalChannel o_DMXDeviceInternalChannel = this.m_DMXDevice.getInternalChannel(this.m_DMXDeviceSectorIndex, this.m_DeviceInternalChannels.get(intByteIndex));
                intByteValue = (longByteFactor /= 256L) <= 0L ? 0 : (int)(longValue / longByteFactor);
                longValue -= longByteFactor * (long)intByteValue;
                if (o_DMXDeviceInternalChannel == null) continue;
                o_DMXDeviceInternalChannel.setValue_Validated_EditMode(intByteValue);
            }
        }

        public long getValueDMXInterface() {
            if (this.m_DMXDevice == null) {
                return 0L;
            }
            long longResult = 0L;
            long longByteFactor = 1L;
            for (int intByte = this.m_DeviceInternalChannels.size() - 1; intByte >= 0; --intByte) {
                DMXDevice.InternalChannel o_DMXDeviceInternalChannel = this.m_DMXDevice.getInternalChannel(this.m_DMXDeviceSectorIndex, this.m_DeviceInternalChannels.get(intByte));
                if (o_DMXDeviceInternalChannel != null) {
                    longResult += (long)o_DMXDeviceInternalChannel.getValueDMXInterface() * longByteFactor;
                }
                longByteFactor *= 256L;
            }
            return longResult;
        }

        public void refreshValueDMXInterface() {
            if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
                return;
            }
            long longValueInterface = this.getValueDMXInterface();
            if (this.m_ValueInterface != longValueInterface) {
                long longOldValue = this.m_ValueInterface;
                this.m_ValueInterface = longValueInterface;
                this.m_PropertyChangeSupport.firePropertyChange(PROPERTY_DEVICECONTROLLINK_VALUEINTERFACE, longOldValue, this.m_ValueInterface);
            }
            this.m_LiveCloseSemaphore.leaveWorkerSection();
        }

        public long getValueDMXInterface_Input() {
            if (this.m_DMXDevice == null) {
                return 0L;
            }
            long longResult = 0L;
            long longByteFactor = 1L;
            for (int intByte = this.m_DeviceInternalChannels.size() - 1; intByte >= 0; --intByte) {
                DMXDevice.InternalChannel o_DMXDeviceInternalChannel = this.m_DMXDevice.getInternalChannel(this.m_DMXDeviceSectorIndex, this.m_DeviceInternalChannels.get(intByte));
                if (o_DMXDeviceInternalChannel != null) {
                    longResult += (long)o_DMXDeviceInternalChannel.getValueDMXInterface_Input() * longByteFactor;
                }
                longByteFactor *= 256L;
            }
            return longResult;
        }

        public void refreshValueDMXReaden() {
            DMXDevice o_DMXDevice = this.m_DMXDevice;
            if (o_DMXDevice == null) {
                return;
            }
            if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
                return;
            }
            for (int intByte = 0; intByte < this.getByteResolution(); ++intByte) {
                DMXDevice.InternalChannel o_DMXDeviceInternalChannel = o_DMXDevice.getInternalChannel(this.m_DMXDeviceSectorIndex, this.m_DeviceInternalChannels.get(intByte));
                if (o_DMXDeviceInternalChannel == null) continue;
                this.setValueByte_ControlDimension(intByte, o_DMXDeviceInternalChannel.getValueDMXInterface(), false);
            }
            long longValueInterface = this.getValueDMXInterface();
            if (this.m_ValueInterface != longValueInterface) {
                long longOldValue = this.m_ValueInterface;
                this.m_ValueInterface = longValueInterface;
                this.m_PropertyChangeSupport.firePropertyChange(PROPERTY_DEVICECONTROLLINK_VALUEINTERFACE, longOldValue, this.m_ValueInterface);
            }
            this.m_ValueChannels = this.m_ValueInterface;
            if (!LiveShowVIP.EDITMODEON) {
                this.adjustControlDimension(false);
            }
            this.m_LiveCloseSemaphore.leaveWorkerSection();
        }

        public void refreshValueDMXReadenInput() {
            DMXDevice o_DMXDevice = this.m_DMXDevice;
            if (o_DMXDevice == null) {
                return;
            }
            if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
                return;
            }
            if (this.m_ControlDimensionType == null) {
                this.m_LiveCloseSemaphore.leaveWorkerSection();
                return;
            }
            long longValueInterfaceInput = this.getValueDMXInterface_Input();
            this.m_ControlDimensionType.getControlDimension().setValue_InputExternal((double)longValueInterfaceInput);
            this.m_LiveCloseSemaphore.leaveWorkerSection();
        }

        public long getValueDMXInterface_ValidatedReverse() {
            if (this.m_DMXDevice == null) {
                return 0L;
            }
            long longResult = 0L;
            long longByteFactor = 1L;
            for (int intByte = this.m_DeviceInternalChannels.size() - 1; intByte >= 0; --intByte) {
                DMXDevice.InternalChannel o_DMXDeviceInternalChannel = this.m_DMXDevice.getInternalChannel(this.m_DMXDeviceSectorIndex, this.m_DeviceInternalChannels.get(intByte));
                if (o_DMXDeviceInternalChannel != null) {
                    longResult += (long)o_DMXDeviceInternalChannel.getValueDMXInterface_ValidatedReversed() * longByteFactor;
                }
                longByteFactor *= 256L;
            }
            return longResult;
        }

        public void setValueDMXInterface_ValidatedReverse(long p_ValueValidatedReverse) {
            long longValue = p_ValueValidatedReverse;
            int intByteValue = 0;
            long longByteFactor = this.m_MaxValue + 1L;
            if (longValue > this.m_MaxValue) {
                longValue = this.m_MaxValue;
            }
            for (int intByteIndex = 0; intByteIndex < this.m_DeviceInternalChannels.size(); ++intByteIndex) {
                DMXDevice.InternalChannel o_DMXDeviceInternalChannel = this.m_DMXDevice.getInternalChannel(this.m_DMXDeviceSectorIndex, this.m_DeviceInternalChannels.get(intByteIndex));
                intByteValue = (longByteFactor /= 256L) <= 0L ? 0 : (int)(longValue / longByteFactor);
                longValue -= longByteFactor * (long)intByteValue;
                if (o_DMXDeviceInternalChannel == null) continue;
                o_DMXDeviceInternalChannel.setValueDMXInterface_ValidatedReverse(intByteValue);
            }
        }

        public double getValueScene(DMXScene.DMXSceneDeviceValues p_DMXSceneDeviceValues) {
            if (p_DMXSceneDeviceValues == null) {
                return 0.0;
            }
            DMXScene.DMXSceneDeviceSectorValues o_DMXSceneDeviceSectorValues = p_DMXSceneDeviceValues.getDMXSceneDeviceSectorValues(this.m_DMXDeviceSectorIndex);
            if (o_DMXSceneDeviceSectorValues == null) {
                return 0.0;
            }
            return this.getValueScene(o_DMXSceneDeviceSectorValues);
        }

        public double getValueScene(DMXScene.DMXSceneDeviceSectorValues p_DMXSceneDeviceSectorValues) {
            if (p_DMXSceneDeviceSectorValues == null) {
                return 0.0;
            }
            double longResult = 0.0;
            long longByteFactor = 1L;
            for (int intByteIndex = this.m_DeviceInternalChannels.size() - 1; intByteIndex >= 0; --intByteIndex) {
                int intInternalChannel = this.m_DeviceInternalChannels.get(intByteIndex);
                Double o_Value = p_DMXSceneDeviceSectorValues.getDeviceValue(intInternalChannel);
                if (o_Value != null) {
                    longResult += o_Value * (double)longByteFactor;
                }
                longByteFactor *= 256L;
            }
            return longResult;
        }

        public void setValueScene(double p_Value, DMXScene.DMXSceneDeviceValues p_DMXSceneDeviceValues) {
            if (p_DMXSceneDeviceValues == null) {
                return;
            }
            DMXScene.DMXSceneDeviceSectorValues o_DMXSceneDeviceSectorValues = p_DMXSceneDeviceValues.getDMXSceneDeviceSectorValues(this.m_DMXDeviceSectorIndex);
            if (o_DMXSceneDeviceSectorValues == null) {
                return;
            }
            this.setValueScene(p_Value, o_DMXSceneDeviceSectorValues);
        }

        public void setValueScene(double p_Value, DMXScene.DMXSceneDeviceSectorValues p_DMXSceneDeviceSectorValues) {
            if (p_DMXSceneDeviceSectorValues == null) {
                return;
            }
            double doubleValue = p_Value;
            double doubleByteValue = 0.0;
            long longByteFactor = this.m_MaxValue + 1L;
            if (doubleValue > 0.0) {
                doubleValue = (int)(doubleValue + 0.5);
            } else if (doubleValue < 0.0) {
                doubleValue = (int)(doubleValue - 0.5);
            }
            if (doubleValue > (double)this.m_MaxValue) {
                doubleValue = this.m_MaxValue;
            }
            for (int intByteIndex = 0; intByteIndex < this.m_DeviceInternalChannels.size(); ++intByteIndex) {
                int intInternalChannelNext;
                boolean boolExactValue = false;
                int intInternalChannel = this.m_DeviceInternalChannels.get(intByteIndex);
                if (intByteIndex < this.m_DeviceInternalChannels.size() - 1 && (intInternalChannelNext = this.m_DeviceInternalChannels.get(intByteIndex + 1).intValue()) < 0) {
                    boolExactValue = true;
                }
                if (this.m_DeviceInternalChannels.size() <= 1) {
                    boolExactValue = true;
                }
                longByteFactor /= 256L;
                if (p_Value < (double)(-this.m_MaxValue)) {
                    doubleByteValue = -2.147483648E9;
                } else {
                    doubleByteValue = boolExactValue ? (longByteFactor <= 0L ? 0.0 : doubleValue / (double)longByteFactor) : (longByteFactor <= 0L ? 0.0 : (double)((int)(doubleValue / (double)longByteFactor)));
                    doubleValue -= (double)longByteFactor * doubleByteValue;
                }
                p_DMXSceneDeviceSectorValues.setDeviceValue(intInternalChannel, doubleByteValue);
            }
        }

        public boolean getValueSetManually(DMXScene.DMXSceneDeviceValues p_DMXSceneDeviceValues) {
            if (p_DMXSceneDeviceValues == null) {
                return false;
            }
            DMXScene.DMXSceneDeviceSectorValues o_DMXSceneDeviceSectorValues = p_DMXSceneDeviceValues.getDMXSceneDeviceSectorValues(this.m_DMXDeviceSectorIndex);
            if (o_DMXSceneDeviceSectorValues == null) {
                return false;
            }
            return this.getValueSetManually(o_DMXSceneDeviceSectorValues);
        }

        public boolean getValueSetManually(DMXScene.DMXSceneDeviceSectorValues p_DMXSceneDeviceSectorValues) {
            if (p_DMXSceneDeviceSectorValues == null) {
                return false;
            }
            boolean boolValueSetManually = false;
            for (int intByteIndex = this.m_DeviceInternalChannels.size() - 1; intByteIndex >= 0; --intByteIndex) {
                int intInternalChannel = this.m_DeviceInternalChannels.get(intByteIndex);
                if (!p_DMXSceneDeviceSectorValues.getDeviceValueSetManually(intInternalChannel)) continue;
                boolValueSetManually = true;
                break;
            }
            return boolValueSetManually;
        }

        public void setValueSetManually(DMXScene.DMXSceneDeviceValues p_DMXSceneDeviceValues, boolean p_SetManually) {
            if (p_DMXSceneDeviceValues == null) {
                return;
            }
            DMXScene.DMXSceneDeviceSectorValues o_DMXSceneDeviceSectorValues = p_DMXSceneDeviceValues.getDMXSceneDeviceSectorValues(this.m_DMXDeviceSectorIndex);
            if (o_DMXSceneDeviceSectorValues == null) {
                return;
            }
            this.setValueSetManually(o_DMXSceneDeviceSectorValues, p_SetManually);
        }

        public void setValueSetManually(DMXScene.DMXSceneDeviceSectorValues p_DMXSceneDeviceSectorValues, boolean p_SetManually) {
            if (p_DMXSceneDeviceSectorValues == null) {
                return;
            }
            for (int intByteIndex = this.m_DeviceInternalChannels.size() - 1; intByteIndex >= 0; --intByteIndex) {
                int intInternalChannel = this.m_DeviceInternalChannels.get(intByteIndex);
                p_DMXSceneDeviceSectorValues.setDeviceValueSetManually(intInternalChannel, p_SetManually);
            }
        }

        public long getMaxValue() {
            return this.m_MaxValue;
        }

        public void setFadeValue(double p_Value, DMXScene.DMXSceneDeviceValues p_DMXSceneDeviceValues) {
            if (p_DMXSceneDeviceValues == null) {
                return;
            }
            DMXScene.DMXSceneDeviceSectorValues o_DMXSceneDeviceSectorValues = p_DMXSceneDeviceValues.getDMXSceneDeviceSectorValues(this.m_DMXDeviceSectorIndex);
            if (o_DMXSceneDeviceSectorValues == null) {
                return;
            }
            this.setFadeValue(p_Value, o_DMXSceneDeviceSectorValues);
        }

        public void setFadeValue(double p_Value, DMXScene.DMXSceneDeviceSectorValues p_DMXSceneDeviceSectorValues) {
            for (int intByteIndex = 0; intByteIndex < this.m_DeviceInternalChannels.size(); ++intByteIndex) {
                int intInternalChannel = this.m_DeviceInternalChannels.get(intByteIndex);
                if (intInternalChannel < 0) continue;
                p_DMXSceneDeviceSectorValues.setFadeValue(intInternalChannel, p_Value);
            }
        }

        public double getFadeValue(DMXScene.DMXSceneDeviceValues p_DMXSceneDeviceValues) {
            if (p_DMXSceneDeviceValues == null) {
                return 0.0;
            }
            DMXScene.DMXSceneDeviceSectorValues o_DMXSceneDeviceSectorValues = p_DMXSceneDeviceValues.getDMXSceneDeviceSectorValues(this.m_DMXDeviceSectorIndex);
            if (o_DMXSceneDeviceSectorValues == null) {
                return 0.0;
            }
            return this.getFadeValue(o_DMXSceneDeviceSectorValues);
        }

        public double getFadeValue(DMXScene.DMXSceneDeviceSectorValues p_DMXSceneDeviceSectorValues) {
            if (p_DMXSceneDeviceSectorValues == null) {
                return Double.MIN_VALUE;
            }
            double doubleResult = Double.MIN_VALUE;
            for (int intByteIndex = this.m_DeviceInternalChannels.size() - 1; intByteIndex >= 0; --intByteIndex) {
                int intInternalChannel = this.m_DeviceInternalChannels.get(intByteIndex);
                Double o_ByteValue = p_DMXSceneDeviceSectorValues.getFadeValue(intInternalChannel);
                if (o_ByteValue == null) continue;
                doubleResult = o_ByteValue;
                break;
            }
            return doubleResult;
        }

        public void addPropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
            if (p_PropertyChangeListener == null) {
                return;
            }
            this.m_PropertyChangeSupport.addPropertyChangeListener(p_PropertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
            this.m_PropertyChangeSupport.removePropertyChangeListener(p_PropertyChangeListener);
        }

        public void addPropertyChangeListener(String p_PropertyName, PropertyChangeListener p_PropertyChangeListener) {
            if (p_PropertyChangeListener == null) {
                return;
            }
            this.m_PropertyChangeSupport.addPropertyChangeListener(p_PropertyName, p_PropertyChangeListener);
        }

        public void removePropertyChangeListener(String p_PropertyName, PropertyChangeListener p_PropertyChangeListener) {
            this.m_PropertyChangeSupport.removePropertyChangeListener(p_PropertyName, p_PropertyChangeListener);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() instanceof DMXDevice) {
                if ("dmxdeviceAdjustedSceneBridge".equals(evt.getPropertyName())) {
                    return;
                }
                if ("dmxdeviceDimmerValue".equals(evt.getPropertyName())) {
                    return;
                }
                if (this.m_ControlDisplayItem != null) {
                    this.m_ControlDisplayItem.setToolTipText(this.getDMXDeviceName());
                }
            }
        }
    }

    public static class ControlDimensionType
    implements Externalizable,
    PropertyChangeListener {
        public static final int SOFTWAREVERSION = 2;
        public static final String PROP_CONTROLDIMENSIONTYPE_NAME = "controldimensiontypeName";
        public static final String PROP_CONTROLDIMENSIONTYPE_REMARK = "controldimensiontypeRemark";
        public static final String PROP_CONTROLDIMENSIONTYPE_DEVICECONTROLLINK = "controldimensiontypeDeviceControlLink";
        public static final String PROP_CONTROLDIMENSIONTYPE_DEVICECONTROLLINKBYTE = "controldimensiontypeDeviceControlLinkByte";
        public static final String PROP_CONTROLDIMENSIONTYPE_VALUEMAXIMUM = "controldimensiontypeValueMaximum";
        public static final String PROP_CONTROLDIMENSIONTYPE_CONTROLLABELMODEL = "controldimensiontypeControlLabelModel";
        public static final String PROP_CONTROLDIMENSIONTYPE_CONTROLBLOCKMODEL = "controldimensiontypeControlBlockModel";
        public static final String PROP_CONTROLDIMENSIONTYPE_CONTROLFUNCTIONMODEL = "controldimensiontypeControlFunctionModel";
        public static final String PROP_CONTROLDIMENSIONTYPE_BYTERESOLUTION = "controldimensiontypeByteResolution";
        public static final String PROP_CONTROLDIMENSIONTYPE_INSTANCECONTROLMETER = "controldimensiontypeInstanceControlMeter";
        public static final String PROP_CONTROLDIMENSIONTYPE_INSTANCE = "controldimensiontypeInstance";
        public static final String PROPERTY_CONTROLDIMENSIONTYPE_VALUENEW = "controldimensiontypeValueNew";
        private ControlType m_ControlType;
        private String m_Name;
        private String m_Remark;
        private int m_DimensionIndex;
        private ControlLabelModel m_ControlLabelModel;
        private ControlBlockModel m_ControlBlockModel;
        private ControlFunctionModel m_ControlFunctionModel;
        private int m_ValueMaximum;
        private int m_ValueMaximum_Linked;
        private int m_DefaultValue;
        private int m_ByteResolution;
        private boolean m_Inverted;
        private int m_MixerPanelOwner;
        private ControlObject.ControlDimension m_InstanceControlDimension;
        private JControlMeter m_InstanceJControlMeter;
        private ControlDimensionType m_PartnerControlDimensionType;
        private ArrayList<DeviceControlLink> m_DeviceControlLinks;
        private int m_ByteResolution_Linked;
        private SinglePropertyChangeSupport m_PropertyChangeSupport;

        public ControlDimensionType(ControlType p_ControlType, int p_DimensionIndex) {
            this.initMembers();
            this.m_ControlType = p_ControlType;
            this.m_Remark = "";
            this.m_DimensionIndex = p_DimensionIndex;
        }

        private void initMembers() {
            this.m_Name = "";
            this.m_Remark = "";
            this.m_MixerPanelOwner = 0;
            this.m_DeviceControlLinks = new ArrayList();
            this.m_ByteResolution_Linked = 0;
            this.m_ControlLabelModel = null;
            this.m_ControlBlockModel = null;
            this.m_ControlFunctionModel = null;
            this.m_ValueMaximum = 65535;
            this.m_ValueMaximum_Linked = 65535;
            this.m_DefaultValue = 0;
            this.m_ByteResolution = 1;
            this.m_InstanceControlDimension = null;
            this.m_PropertyChangeSupport = new SinglePropertyChangeSupport(this);
            this.m_Inverted = false;
            this.m_PartnerControlDimensionType = null;
        }

        public void close() {
            if (this.m_ControlLabelModel != null) {
                this.m_ControlLabelModel.clearControlLabelLists();
            }
            if (this.m_DeviceControlLinks != null) {
                int intLinkCount = this.m_DeviceControlLinks.size();
                for (int intLink = intLinkCount - 1; intLink >= 0; --intLink) {
                    DeviceControlLink o_DeviceControlLink = this.m_DeviceControlLinks.get(intLink);
                    this.removeDeviceControlLink(o_DeviceControlLink);
                }
            }
            this.m_InstanceJControlMeter = null;
            if (this.m_InstanceControlDimension != null) {
                this.m_InstanceControlDimension.removePropertyChangeListener((PropertyChangeListener)this);
            }
            this.m_InstanceControlDimension = null;
            if (this.m_PropertyChangeSupport != null) {
                this.m_PropertyChangeSupport.clear();
            }
            this.m_ControlBlockModel.clearControlBlockLists();
        }

        public void finalize() throws Throwable {
            super.finalize();
            this.m_PropertyChangeSupport = null;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(2);
            out.writeUTF(this.m_Name);
            out.writeUTF(this.m_Remark);
            out.writeBoolean(this.m_Inverted);
            out.writeInt(this.m_DimensionIndex);
            out.writeInt(this.m_ValueMaximum);
            out.writeInt(this.m_DefaultValue);
            this.m_ControlLabelModel.writeExternal(out);
            this.m_ControlBlockModel.writeExternal(out);
            this.m_ControlFunctionModel.writeExternal(out);
            out.writeInt(this.m_ByteResolution);
            int intLinkCount = this.m_DeviceControlLinks.size();
            out.writeInt(intLinkCount);
            for (int intLink = 0; intLink < intLinkCount; ++intLink) {
                DeviceControlLink o_DeviceControlLink = this.m_DeviceControlLinks.get(intLink);
                o_DeviceControlLink.writeExternal(out);
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int intSoftwareVersion = in.readInt();
            this.m_Name = in.readUTF();
            this.m_Remark = in.readUTF();
            this.m_Inverted = in.readBoolean();
            this.m_DimensionIndex = in.readInt();
            this.m_ValueMaximum = in.readInt();
            this.m_DefaultValue = in.readInt();
            String stringName = "";
            if (this.m_ControlType != null) {
                stringName = this.m_ControlType.getName();
            }
            this.m_ControlLabelModel = new ControlLabelModel(stringName, 0.0, (double)this.m_ValueMaximum);
            this.m_ControlLabelModel.setOnlyIntegerValues(true);
            this.m_ControlLabelModel.readExternal(in);
            this.m_ControlBlockModel = new ControlBlockModel(0.0, (double)this.m_ValueMaximum);
            this.m_ControlBlockModel.setOnlyIntegerValues(true);
            this.m_ControlBlockModel.readExternal(in);
            this.m_ControlFunctionModel = new ControlFunctionModel(0.0, (double)this.m_ValueMaximum);
            this.m_ControlFunctionModel.setOnlyIntegerValues(true);
            if (intSoftwareVersion >= 2) {
                this.m_ControlFunctionModel.readExternal(in);
            }
            this.m_ByteResolution = in.readInt();
            int intLinkCount = in.readInt();
            for (int intChannel = 0; intChannel < intLinkCount; ++intChannel) {
                DeviceControlLink o_DeviceControlLink = new DeviceControlLink(this);
                o_DeviceControlLink.readExternal(in);
                this.addDeviceControlLink(o_DeviceControlLink);
            }
        }

        public ControlDimensionType getCopyRare(ControlType p_ControlType) {
            ControlDimensionType o_ControlDimensionType = new ControlDimensionType(p_ControlType, this.getIndex());
            o_ControlDimensionType.setName(this.m_Name);
            o_ControlDimensionType.setRemark(this.m_Remark);
            o_ControlDimensionType.setInverted(this.m_Inverted);
            o_ControlDimensionType.setValueMaximum(this.m_ValueMaximum);
            o_ControlDimensionType.setDefaultValue(this.m_DefaultValue);
            o_ControlDimensionType.setByteResolution(this.m_ByteResolution);
            if (this.m_ControlLabelModel != null) {
                ControlLabelModel o_ControlLabelModel = this.m_ControlLabelModel.getCopy();
                o_ControlDimensionType.setControlLabelModel(o_ControlLabelModel);
            }
            if (this.m_ControlBlockModel != null) {
                ControlBlockModel o_ControlBlockModel = this.m_ControlBlockModel.getCopy();
                o_ControlDimensionType.setControlBlockModel(o_ControlBlockModel);
            }
            if (this.m_ControlFunctionModel != null) {
                ControlFunctionModel o_ControlFunctionModel = this.m_ControlFunctionModel.getCopy();
                o_ControlDimensionType.setControlFunctionModel(o_ControlFunctionModel);
            }
            return o_ControlDimensionType;
        }

        public long getDiskSpaceEstimated() {
            long longBytesCount = 0L;
            longBytesCount += 4L;
            longBytesCount += (long)(this.m_Name.length() * 2);
            longBytesCount += (long)(this.m_Remark.length() * 2);
            ++longBytesCount;
            longBytesCount += 4L;
            longBytesCount += 4L;
            longBytesCount += 4L;
            longBytesCount += this.m_ControlLabelModel.getDiskSpaceEstimated();
            longBytesCount += this.m_ControlBlockModel.getDiskSpaceEstimated();
            longBytesCount += this.m_ControlFunctionModel.getDiskSpaceEstimated();
            longBytesCount += 4L;
            int intLinkCount = this.m_DeviceControlLinks.size();
            longBytesCount += 4L;
            for (int intLink = 0; intLink < intLinkCount; ++intLink) {
                DeviceControlLink o_DeviceControlLink = this.m_DeviceControlLinks.get(intLink);
                longBytesCount += o_DeviceControlLink.getDiskSpaceEstimated();
            }
            return longBytesCount;
        }

        public ControlType getControlType() {
            return this.m_ControlType;
        }

        public String getName() {
            return this.m_Name;
        }

        public void setName(String p_Name) {
            if (p_Name == null) {
                return;
            }
            if (this.m_Name.equals(p_Name)) {
                return;
            }
            String oldValue = this.m_Name;
            this.m_Name = p_Name;
            this.m_PropertyChangeSupport.firePropertyChange(PROP_CONTROLDIMENSIONTYPE_NAME, oldValue, this.m_Name);
        }

        public String getRemark() {
            return this.m_Remark;
        }

        public void setRemark(String p_Remark) {
            if (p_Remark == null) {
                return;
            }
            if (this.m_Remark.equals(p_Remark)) {
                return;
            }
            String oldValue = this.m_Remark;
            this.m_Remark = p_Remark;
            this.m_PropertyChangeSupport.firePropertyChange(PROP_CONTROLDIMENSIONTYPE_REMARK, oldValue, this.m_Remark);
        }

        public void setMixerPanelOwner(int p_MixerPanelOwner) {
            this.m_MixerPanelOwner = p_MixerPanelOwner;
        }

        public int getMixerPanelOwner() {
            return this.m_MixerPanelOwner;
        }

        public boolean getInverted() {
            return this.m_Inverted;
        }

        public void setInverted(boolean p_Inverted) {
            this.m_Inverted = p_Inverted;
            if (this.m_InstanceControlDimension != null) {
                this.m_InstanceControlDimension.setInverted(this.m_Inverted);
            }
        }

        public int getIndex() {
            return this.m_DimensionIndex;
        }

        public ControlLabelModel getControlLabelModel() {
            return this.m_ControlLabelModel;
        }

        public void setControlLabelModel(ControlLabelModel p_ControlLabelModel) {
            if (p_ControlLabelModel == null) {
                return;
            }
            if (p_ControlLabelModel == this.m_ControlLabelModel) {
                return;
            }
            ControlLabelModel oldValue = this.m_ControlLabelModel;
            this.m_ControlLabelModel = p_ControlLabelModel;
            this.m_PropertyChangeSupport.firePropertyChange(PROP_CONTROLDIMENSIONTYPE_CONTROLLABELMODEL, oldValue, this.m_ControlLabelModel);
            if (oldValue != null) {
                oldValue.clearControlLabelLists();
            }
        }

        public ControlBlockModel getControlBlockModel() {
            return this.m_ControlBlockModel;
        }

        public void setControlBlockModel(ControlBlockModel p_ControlBlockModel) {
            if (p_ControlBlockModel == null) {
                return;
            }
            if (this.m_ControlBlockModel == p_ControlBlockModel) {
                return;
            }
            ControlBlockModel oldValue = this.m_ControlBlockModel;
            this.m_ControlBlockModel = p_ControlBlockModel;
            this.m_PropertyChangeSupport.firePropertyChange(PROP_CONTROLDIMENSIONTYPE_CONTROLBLOCKMODEL, oldValue, this.m_ControlBlockModel);
            if (oldValue != null) {
                oldValue.clearControlBlockLists();
            }
        }

        public ControlFunctionModel getControlFunctionModel() {
            return this.m_ControlFunctionModel;
        }

        public void setControlFunctionModel(ControlFunctionModel p_ControlFunctionModel) {
            if (p_ControlFunctionModel == null) {
                return;
            }
            if (p_ControlFunctionModel == this.m_ControlFunctionModel) {
                return;
            }
            ControlFunctionModel oldValue = this.m_ControlFunctionModel;
            this.m_ControlFunctionModel = p_ControlFunctionModel;
            this.m_PropertyChangeSupport.firePropertyChange(PROP_CONTROLDIMENSIONTYPE_CONTROLFUNCTIONMODEL, oldValue, this.m_ControlFunctionModel);
            if (oldValue != null) {
                oldValue.clearControlFunctionDescriptions();
            }
        }

        public ControlFunctionModel.ControlFunctionDescription getControlFunctionDescription(ControlFunctionModel.ControlFunctionType p_ControlFunctionType) {
            if (p_ControlFunctionType == null) {
                return null;
            }
            return this.getControlFunctionDescription(p_ControlFunctionType.getID());
        }

        public ControlFunctionModel.ControlFunctionDescription getControlFunctionDescription(String p_FunctionTypeID) {
            if (p_FunctionTypeID == null) {
                return null;
            }
            if (this.m_ControlFunctionModel == null) {
                return null;
            }
            return this.m_ControlFunctionModel.getControlFunctionDescription(p_FunctionTypeID);
        }

        public int getByteResolution() {
            return this.m_ByteResolution;
        }

        public void setByteResolution(int p_ByteResolution) {
            if (p_ByteResolution < 0) {
                return;
            }
            if (this.m_ByteResolution == p_ByteResolution) {
                return;
            }
            int oldValue = this.m_ByteResolution;
            this.m_ByteResolution = p_ByteResolution;
            this.m_PropertyChangeSupport.firePropertyChange(PROP_CONTROLDIMENSIONTYPE_BYTERESOLUTION, oldValue, this.m_ByteResolution);
        }

        public void setValueMaximum(int p_ValueMaximum) {
            if (p_ValueMaximum < 0) {
                return;
            }
            if (p_ValueMaximum >= 65536) {
                return;
            }
            int oldValue = this.m_ValueMaximum;
            this.m_ValueMaximum = p_ValueMaximum;
            int intBytesUsed = 0;
            if (this.m_ValueMaximum < 256) {
                intBytesUsed = 1;
            } else if (this.m_ValueMaximum < 65536) {
                intBytesUsed = 2;
            }
            this.setByteResolution(intBytesUsed);
            this.m_PropertyChangeSupport.firePropertyChange(PROP_CONTROLDIMENSIONTYPE_VALUEMAXIMUM, oldValue, this.m_ValueMaximum);
        }

        public int getValueMaximum() {
            return this.m_ValueMaximum;
        }

        public int getValueMaximum_Linked() {
            return this.m_ValueMaximum_Linked;
        }

        public int getByteResolution_Linked() {
            return this.m_ByteResolution_Linked;
        }

        private void calculateValueMaximumLinked() {
            if (this.m_DeviceControlLinks.size() <= 0) {
                this.m_ValueMaximum_Linked = 65535;
                return;
            }
            this.m_ValueMaximum_Linked = 255;
            for (int intLink = 0; intLink < this.m_DeviceControlLinks.size(); ++intLink) {
                DeviceControlLink o_DeviceControlLink = this.m_DeviceControlLinks.get(intLink);
                int intValueMax_Linked = o_DeviceControlLink.getValueLinkedMaximum();
                if (intValueMax_Linked <= this.m_ValueMaximum_Linked) continue;
                this.m_ValueMaximum_Linked = intValueMax_Linked;
            }
        }

        private void calculateByteResolution_Linked() {
            this.m_ByteResolution_Linked = 0;
            for (int intLink = 0; intLink < this.m_DeviceControlLinks.size(); ++intLink) {
                DeviceControlLink o_DeviceControlLink = this.m_DeviceControlLinks.get(intLink);
                int intFlagLinked = o_DeviceControlLink.getByteResolution_Linked();
                if (intFlagLinked <= this.m_ByteResolution_Linked) continue;
                this.m_ByteResolution_Linked = intFlagLinked;
            }
        }

        public void setDefaultValue(int p_DefaultValue) {
            this.m_DefaultValue = p_DefaultValue;
        }

        public int getDefaultValue() {
            return this.m_DefaultValue;
        }

        public boolean isSameAs(ControlDimensionType p_ControlDimensionType) {
            if (this.m_ByteResolution != p_ControlDimensionType.getByteResolution()) {
                return false;
            }
            return this.m_ControlLabelModel.isSameAs(p_ControlDimensionType.getControlLabelModel());
        }

        public boolean setInstanceControlMeter(JControlMeter p_JControlMeter) {
            DeviceControlLink o_DeviceControlLink;
            ControlObject.ControlDisplayItem o_ControlDisplayItem;
            if (p_JControlMeter == this.m_InstanceJControlMeter) {
                return true;
            }
            JControlMeter oldValue = this.m_InstanceJControlMeter;
            if (oldValue != null) {
                int intDisplayItemCount = oldValue.getControlDimension().getControlDisplayItemsCount();
                for (int intDisplay = intDisplayItemCount - 1; intDisplay >= 0; --intDisplay) {
                    o_ControlDisplayItem = oldValue.getControlDisplayItem(intDisplay);
                    if (o_ControlDisplayItem != null && (o_DeviceControlLink = (DeviceControlLink)o_ControlDisplayItem.getSourceObject()) != null) {
                        o_DeviceControlLink.setInstanceControlDisplayItem(null);
                    }
                    oldValue.removeControlDisplayItem(o_ControlDisplayItem);
                }
            }
            this.m_InstanceJControlMeter = p_JControlMeter;
            if (this.m_InstanceJControlMeter != null) {
                this.m_InstanceJControlMeter.getControlDimension().setValueMinimum(0.0);
                this.m_InstanceJControlMeter.getControlDimension().setValueMaximum((double)this.m_ValueMaximum);
                int intLinkCount = this.getDeviceControlLinkCount();
                for (int intLink = intLinkCount - 1; intLink >= 0; --intLink) {
                    o_DeviceControlLink = this.m_DeviceControlLinks.get(intLink);
                    o_ControlDisplayItem = this.m_InstanceJControlMeter.createControlDisplayItem((Object)o_DeviceControlLink, "valueInterface");
                    o_ControlDisplayItem.setToolTipText(o_DeviceControlLink.getDMXDeviceName());
                    o_DeviceControlLink.setInstanceControlDisplayItem(o_ControlDisplayItem);
                    o_ControlDisplayItem.setName(o_DeviceControlLink.getDMXDeviceChannelName());
                }
            }
            this.m_PropertyChangeSupport.firePropertyChange(PROP_CONTROLDIMENSIONTYPE_INSTANCECONTROLMETER, oldValue, this.m_InstanceJControlMeter);
            return true;
        }

        public JControlMeter getInstanceControlMeter() {
            return this.m_InstanceJControlMeter;
        }

        public void setInstance(ControlObject.ControlDimension p_ControlDimension) {
            DeviceControlLink o_DeviceControlLink;
            int intLink;
            ControlObject.ControlDimension oldValue = this.m_InstanceControlDimension;
            DMXControlComponent o_DMXControlComponent = this.getDMXControlComponent();
            if (oldValue != null) {
                oldValue.removePropertyChangeListener((PropertyChangeListener)this);
                for (intLink = 0; intLink < this.m_DeviceControlLinks.size(); ++intLink) {
                    o_DeviceControlLink = this.m_DeviceControlLinks.get(intLink);
                    o_DeviceControlLink.setInstance(null);
                }
                this.setInstanceControlMeter(null);
            }
            this.m_InstanceControlDimension = p_ControlDimension;
            if (this.m_InstanceControlDimension != null) {
                for (intLink = 0; intLink < this.m_DeviceControlLinks.size(); ++intLink) {
                    o_DeviceControlLink = this.m_DeviceControlLinks.get(intLink);
                    String stringDMXDeviceID = this.m_DeviceControlLinks.get(intLink).getDMXDeviceID();
                    DMXDevice o_DMXDevice = DMXDevice.getDMXDevice(stringDMXDeviceID);
                    o_DeviceControlLink.setInstance(o_DMXDevice);
                    this.checkDeviceControlLinkAdded(o_DeviceControlLink);
                }
                if (o_DMXControlComponent != null) {
                    JControlMeter o_ControlMeter = o_DMXControlComponent.getControlMeter(p_ControlDimension);
                    this.setInstanceControlMeter(o_ControlMeter);
                }
                this.m_InstanceControlDimension.addPropertyChangeListener((PropertyChangeListener)this);
                this.m_InstanceControlDimension.setInverted(this.m_Inverted);
            }
            this.m_PropertyChangeSupport.firePropertyChange(PROP_CONTROLDIMENSIONTYPE_INSTANCE, oldValue, this.m_InstanceControlDimension);
        }

        public ControlObject.ControlDimension getInstance() {
            return this.m_InstanceControlDimension;
        }

        public ControlObject.ControlDimension getControlDimension() {
            return this.m_InstanceControlDimension;
        }

        public void eventValueControlDimension(int p_OldValue, int p_Value, boolean p_IsValueNew) {
            this.m_DefaultValue = this.m_InstanceControlDimension != null ? this.m_InstanceControlDimension.getValueInt() : p_Value;
            switch (this.m_ByteResolution) {
                case 1: {
                    this.setValueByte_ControlDimension(0, p_Value, p_IsValueNew);
                    break;
                }
                case 2: {
                    int intValueHigh = 0;
                    int intValueLow = 0;
                    intValueHigh = p_Value / 256;
                    intValueLow = p_Value - intValueHigh * 256;
                    this.setValueByte_ControlDimension(0, intValueHigh, p_IsValueNew);
                    this.setValueByte_ControlDimension(1, intValueLow, p_IsValueNew);
                    break;
                }
            }
            if (this.m_InstanceControlDimension != null && p_IsValueNew) {
                this.m_PropertyChangeSupport.firePropertyChange(PROPERTY_CONTROLDIMENSIONTYPE_VALUENEW, p_OldValue, p_Value);
            }
        }

        public void setValueByte_ControlDimension(int p_ByteIndex, int p_Value, boolean p_ChangedManually) {
            for (int intLink = 0; intLink < this.m_DeviceControlLinks.size(); ++intLink) {
                DeviceControlLink o_DeviceControlLink = this.m_DeviceControlLinks.get(intLink);
                o_DeviceControlLink.setValueByte_ControlDimension(p_ByteIndex, p_Value, p_ChangedManually);
            }
        }

        public void eventValueFactor(double p_OldValue, double p_Value) {
            switch (this.m_ByteResolution) {
                case 1: {
                    this.setValueByteFactor(0, p_Value);
                    break;
                }
                case 2: {
                    this.setValueByteFactor(0, p_Value);
                    this.setValueByteFactor(1, p_Value);
                    break;
                }
            }
            this.refreshDisplay_ControlValueChanged("valueFactor");
            if (this.m_InstanceControlDimension != null) {
                this.m_PropertyChangeSupport.firePropertyChange(PROPERTY_CONTROLDIMENSIONTYPE_VALUENEW, p_OldValue, p_Value);
            }
        }

        public void setValueByteFactor(int p_ByteIndex, double p_Value) {
            for (int intLink = 0; intLink < this.m_DeviceControlLinks.size(); ++intLink) {
                DeviceControlLink o_DeviceControlLink = this.m_DeviceControlLinks.get(intLink);
                o_DeviceControlLink.setValueByte_Factor(p_ByteIndex, p_Value);
            }
        }

        public void refreshDisplay_ControlValueChanged(String p_PropertyChange_Cause) {
            DMXControlComponent o_DMXControlComponent = this.getDMXControlComponent();
            DMXControlComponent o_DMXControlComponent_Source = this.m_ControlType != null ? this.m_ControlType.getDMXControlComponent() : null;
            if (o_DMXControlComponent != null) {
                o_DMXControlComponent.refreshDisplay_ControlValueChanged(o_DMXControlComponent_Source, o_DMXControlComponent.getControlObject(this.getControlType().getIndex()), this.m_InstanceControlDimension, p_PropertyChange_Cause);
            }
        }

        public DMXControlType getDMXControlType() {
            if (this.m_ControlType == null) {
                return null;
            }
            return this.m_ControlType.getDMXControlType();
        }

        public DMXControlComponent getDMXControlComponent() {
            if (this.m_ControlType == null) {
                return null;
            }
            return this.m_ControlType.getDMXControlComponent();
        }

        public DeviceControlLink findDeviceControlLink(DMXDevice p_DMXDevice) {
            for (int intLink = 0; intLink < this.m_DeviceControlLinks.size(); ++intLink) {
                DeviceControlLink o_DeviceControlLink = this.m_DeviceControlLinks.get(intLink);
                if (!p_DMXDevice.getID().equals(o_DeviceControlLink.getDMXDeviceID())) continue;
                return o_DeviceControlLink;
            }
            return null;
        }

        public DeviceControlLink findDeviceControlLink(DMXDevice p_DMXDevice, DMXControlType p_DMXControlTypeOfDMXDeviceType) {
            for (int intLink = 0; intLink < this.m_DeviceControlLinks.size(); ++intLink) {
                DeviceControlLink o_DeviceControlLink = this.m_DeviceControlLinks.get(intLink);
                if (!p_DMXDevice.getID().equals(o_DeviceControlLink.getDMXDeviceID()) || o_DeviceControlLink.getDMXControlTypeOfDMXDeviceType() != p_DMXControlTypeOfDMXDeviceType) continue;
                return o_DeviceControlLink;
            }
            return null;
        }

        public DeviceControlLink findDeviceControlLink(DMXDevice p_DMXDevice, ControlDimensionType p_ControlDimensionTypeOfDMXDeviceType) {
            for (int intLink = 0; intLink < this.m_DeviceControlLinks.size(); ++intLink) {
                DeviceControlLink o_DeviceControlLink = this.m_DeviceControlLinks.get(intLink);
                if (!p_DMXDevice.getID().equals(o_DeviceControlLink.getDMXDeviceID()) || o_DeviceControlLink.getControlDimensionTypeOfDMXDeviceType() != p_ControlDimensionTypeOfDMXDeviceType) continue;
                return o_DeviceControlLink;
            }
            return null;
        }

        public DeviceControlLink findDeviceControlLink(DMXDevice p_DMXDevice, int p_DMXDeviceSectorIndex, int p_ByteIndex, int p_InternalChannel) {
            for (int intLink = 0; intLink < this.m_DeviceControlLinks.size(); ++intLink) {
                DeviceControlLink o_DeviceControlLink = this.m_DeviceControlLinks.get(intLink);
                if (o_DeviceControlLink.getDMXDevice() != p_DMXDevice || o_DeviceControlLink.getDMXDeviceSectorIndex() != p_DMXDeviceSectorIndex || o_DeviceControlLink.getDeviceInternalChannel(p_ByteIndex) != p_InternalChannel) continue;
                return o_DeviceControlLink;
            }
            return null;
        }

        public DeviceControlLink addDeviceControlLink(DMXDevice p_DMXDevice, int p_DMXDeviceSectorIndex, int p_ByteIndex, int p_InternalChannel) {
            if (p_DMXDevice == null) {
                return null;
            }
            DeviceControlLink o_DeviceControlLink = this.findDeviceControlLink(p_DMXDevice, p_DMXDeviceSectorIndex, p_ByteIndex, p_InternalChannel);
            if (o_DeviceControlLink != null) {
                return o_DeviceControlLink;
            }
            if (this.m_MixerPanelOwner == 3) {
                if (this.getByteResolution() > 1 && (o_DeviceControlLink = this.findDeviceControlLink(p_DMXDevice)) != null) {
                    if (o_DeviceControlLink.getDeviceInternalChannel(p_ByteIndex) >= 0) {
                        return null;
                    }
                    o_DeviceControlLink.addDeviceInternalChannel(p_ByteIndex, p_InternalChannel);
                    this.calculateByteResolution_Linked();
                    this.calculateValueMaximumLinked();
                    this.m_PropertyChangeSupport.fireIndexedPropertyChange(PROP_CONTROLDIMENSIONTYPE_DEVICECONTROLLINKBYTE, p_ByteIndex, null, o_DeviceControlLink);
                    return o_DeviceControlLink;
                }
            } else if (this.getByteResolution() > 1) {
                DMXDeviceType o_DMXDeviceType = p_DMXDevice.getDMXDeviceType();
                if (o_DMXDeviceType == null) {
                    return null;
                }
                DMXDeviceType.DMXDeviceSector o_DMXDeviceSector = o_DMXDeviceType.getDMXDeviceSector(p_DMXDeviceSectorIndex);
                if (o_DMXDeviceSector == null) {
                    return null;
                }
                DMXDeviceType.DMXDeviceChannelType o_DMXDeviceChannelType = o_DMXDeviceSector.getDMXDeviceChannelType(p_InternalChannel);
                if (o_DMXDeviceChannelType == null) {
                    return null;
                }
                ControlDimensionType o_ControlDimensionType = o_DMXDeviceChannelType.getControlDimensionType();
                o_DeviceControlLink = this.findDeviceControlLink(p_DMXDevice, o_ControlDimensionType);
                if (o_DeviceControlLink != null) {
                    if (o_DeviceControlLink.getDeviceInternalChannel(p_ByteIndex) >= 0) {
                        return null;
                    }
                    o_DeviceControlLink.addDeviceInternalChannel(p_ByteIndex, p_InternalChannel);
                    this.calculateByteResolution_Linked();
                    this.calculateValueMaximumLinked();
                    this.m_PropertyChangeSupport.fireIndexedPropertyChange(PROP_CONTROLDIMENSIONTYPE_DEVICECONTROLLINKBYTE, p_ByteIndex, null, o_DeviceControlLink);
                    return o_DeviceControlLink;
                }
            }
            o_DeviceControlLink = new DeviceControlLink(p_DMXDevice, p_DMXDeviceSectorIndex, this);
            o_DeviceControlLink.setMixerPanelOwner(this.m_MixerPanelOwner);
            o_DeviceControlLink.addDeviceInternalChannel(p_ByteIndex, p_InternalChannel);
            if (this.addDeviceControlLink(o_DeviceControlLink)) {
                return o_DeviceControlLink;
            }
            return null;
        }

        private boolean addDeviceControlLink(DeviceControlLink p_DeviceControlLink) {
            if (p_DeviceControlLink == null) {
                return false;
            }
            p_DeviceControlLink.setMixerPanelOwner(this.m_MixerPanelOwner);
            if (this.m_DeviceControlLinks.contains(p_DeviceControlLink)) {
                return true;
            }
            boolean boolAdded = false;
            boolAdded = this.m_DeviceControlLinks.add(p_DeviceControlLink);
            this.getDMXControlType().addDMXDeviceControlLinkToList(p_DeviceControlLink);
            this.calculateByteResolution_Linked();
            this.calculateValueMaximumLinked();
            if (boolAdded) {
                this.checkDeviceControlLinkAdded(p_DeviceControlLink);
                this.m_PropertyChangeSupport.firePropertyChange(PROP_CONTROLDIMENSIONTYPE_DEVICECONTROLLINK, null, p_DeviceControlLink);
            }
            p_DeviceControlLink.refreshValuesInternalChannels_EditMode();
            p_DeviceControlLink.refreshValuesInternalChannels(false);
            p_DeviceControlLink.refreshValueDMXInterface();
            return boolAdded;
        }

        public boolean removeDeviceControlLink(DMXDevice p_DMXDevice, int p_DMXDeviceSectorIndex, int p_ByteIndex, int p_InternalChannel) {
            if (p_DMXDevice == null) {
                return false;
            }
            DeviceControlLink o_DeviceControlLink = this.findDeviceControlLink(p_DMXDevice, p_DMXDeviceSectorIndex, p_ByteIndex, p_InternalChannel);
            if (o_DeviceControlLink == null) {
                return false;
            }
            boolean boolRemoved = false;
            boolRemoved = o_DeviceControlLink.removeDeviceInternalChannel(p_ByteIndex);
            this.calculateByteResolution_Linked();
            this.calculateValueMaximumLinked();
            if (boolRemoved) {
                this.m_PropertyChangeSupport.fireIndexedPropertyChange(PROP_CONTROLDIMENSIONTYPE_DEVICECONTROLLINKBYTE, p_ByteIndex, o_DeviceControlLink, null);
            }
            return boolRemoved;
        }

        public boolean removeDeviceControlLink(DeviceControlLink p_DeviceControlLink) {
            if (p_DeviceControlLink == null) {
                return false;
            }
            if (!this.m_DeviceControlLinks.contains(p_DeviceControlLink)) {
                return false;
            }
            boolean boolRemoved = false;
            boolRemoved = this.m_DeviceControlLinks.remove(p_DeviceControlLink);
            this.getDMXControlType().removeDMXDeviceControlLinkFromList(p_DeviceControlLink);
            this.checkDeviceControlLinkRemoved(p_DeviceControlLink);
            if (boolRemoved) {
                this.m_PropertyChangeSupport.firePropertyChange(PROP_CONTROLDIMENSIONTYPE_DEVICECONTROLLINK, p_DeviceControlLink, null);
                p_DeviceControlLink.close();
            }
            return boolRemoved;
        }

        public int getDeviceControlLinkCount() {
            return this.m_DeviceControlLinks.size();
        }

        public void setPartnerControlDimensionType(ControlDimensionType p_ControlDimensionType) {
            this.m_PartnerControlDimensionType = p_ControlDimensionType;
        }

        public ControlDimensionType getPartnerControlDimensionType() {
            return this.m_PartnerControlDimensionType;
        }

        public int getPartnerDeviceControlLinkCount() {
            if (this.m_PartnerControlDimensionType == null) {
                return 0;
            }
            return this.m_PartnerControlDimensionType.getDeviceControlLinkCount();
        }

        public DeviceControlLink getDeviceControlLink(int p_Index) {
            if (p_Index < 0 || p_Index >= this.m_DeviceControlLinks.size()) {
                return null;
            }
            return this.m_DeviceControlLinks.get(p_Index);
        }

        public void checkDeviceControlLinkAdded(DeviceControlLink p_DeviceControlLink) {
            if (p_DeviceControlLink == null) {
                return;
            }
            DMXControlComponent o_DMXControlComponent = this.getDMXControlComponent();
            if (o_DMXControlComponent == null) {
                return;
            }
            DMXDevice o_DMXDevice = p_DeviceControlLink.getDMXDevice();
            if (o_DMXDevice == null) {
                return;
            }
            o_DMXControlComponent.addLinkedDMXDevice(o_DMXDevice);
        }

        public void checkDeviceControlLinkRemoved(DeviceControlLink p_DeviceControlLink) {
            if (p_DeviceControlLink == null) {
                return;
            }
            DMXControlComponent o_DMXControlComponent = this.getDMXControlComponent();
            if (o_DMXControlComponent == null) {
                return;
            }
            DMXDevice o_DMXDevice = p_DeviceControlLink.getDMXDevice();
            if (o_DMXDevice == null) {
                return;
            }
            o_DMXControlComponent.removeLinkedDMXDevice(o_DMXDevice);
        }

        public DeviceControlLink getDeviceControlLink(DMXDevice p_DMXDevice) {
            for (int intLink = 0; intLink < this.m_DeviceControlLinks.size(); ++intLink) {
                DeviceControlLink o_DeviceControlLink = this.m_DeviceControlLinks.get(intLink);
                if (o_DeviceControlLink.getDMXDevice() != p_DMXDevice) continue;
                return o_DeviceControlLink;
            }
            return null;
        }

        public void addPropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
            if (p_PropertyChangeListener == null) {
                return;
            }
            this.m_PropertyChangeSupport.addPropertyChangeListener(p_PropertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
            this.m_PropertyChangeSupport.removePropertyChangeListener(p_PropertyChangeListener);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() instanceof ControlObject.ControlDimension) {
                if (evt.getSource() != this.m_InstanceControlDimension) {
                    return;
                }
                if ("value".equals(evt.getPropertyName())) {
                    this.eventValueControlDimension(((Double)evt.getOldValue()).intValue(), ((Double)evt.getNewValue()).intValue(), true);
                } else if ("valueFactor".equals(evt.getPropertyName())) {
                    this.eventValueFactor((Double)evt.getOldValue(), (Double)evt.getNewValue());
                } else if ("valueAdjustedManually".equals(evt.getPropertyName())) {
                    this.eventValueControlDimension(((Double)evt.getOldValue()).intValue(), ((Double)evt.getNewValue()).intValue(), false);
                    this.refreshDisplay_ControlValueChanged("valueAdjustedManually");
                } else if ("controlDimensionName".equals(evt.getPropertyName())) {
                    this.setName((String)evt.getNewValue());
                }
            } else if (evt.getSource() instanceof ControlObject) {
                boolean bl = false;
            }
        }
    }

    public static class ControlType
    implements PropertyChangeListener,
    Externalizable {
        public static final int SOFTWAREVERSION = 1;
        public static final String PROP_CONTROLTYPE_NAME = "controltypeName";
        public static final String PROP_CONTROLTYPE_REMARK = "controltypeRemark";
        public static final String PROP_CONTROLTYPE_CONTROLDIMENSIONTYPE = "controltypeControlDimensionType";
        public static final String PROP_CONTROLTYPE_INSTANCE = "controltypeInstance";
        private DMXControlType m_DMXControlType;
        private String m_Name;
        private String m_Remark;
        private int m_ControlTypeIndex;
        private ArrayList<ControlDimensionType> m_ControlDimensionTypes;
        private ControlObject m_InstanceControlObject;
        private SinglePropertyChangeSupport m_PropertyChangeSupport;
        private int m_MixerPanelOwner;

        public ControlType(DMXControlType p_DMXControlType, int p_Index) {
            this.initMembers();
            this.m_DMXControlType = p_DMXControlType;
            this.m_ControlTypeIndex = p_Index;
        }

        private void initMembers() {
            this.m_Name = "Control";
            this.m_Remark = "";
            this.m_MixerPanelOwner = 0;
            this.m_ControlDimensionTypes = new ArrayList();
            this.m_InstanceControlObject = null;
            this.m_PropertyChangeSupport = new SinglePropertyChangeSupport(this);
        }

        public void close() {
            if (this.m_ControlDimensionTypes != null) {
                int intDimensionCount = this.m_ControlDimensionTypes.size();
                for (int intType = intDimensionCount - 1; intType >= 0; --intType) {
                    ControlDimensionType o_ControlDimensionType = this.m_ControlDimensionTypes.get(intType);
                    this.removeControlDimensionType(o_ControlDimensionType);
                    o_ControlDimensionType.close();
                }
            }
            if (this.m_InstanceControlObject != null) {
                this.m_InstanceControlObject.removePropertyChangeListener((PropertyChangeListener)this);
            }
            this.m_InstanceControlObject = null;
            if (this.m_PropertyChangeSupport != null) {
                this.m_PropertyChangeSupport.clear();
            }
        }

        public void finalize() throws Throwable {
            super.finalize();
            this.m_PropertyChangeSupport = null;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(1);
            out.writeUTF(this.m_Name);
            out.writeUTF(this.m_Remark);
            out.writeInt(this.m_ControlDimensionTypes.size());
            for (int intDimension = 0; intDimension < this.m_ControlDimensionTypes.size(); ++intDimension) {
                ControlDimensionType o_ControlDimensionType = this.m_ControlDimensionTypes.get(intDimension);
                o_ControlDimensionType.writeExternal(out);
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int intSoftwareVersion = in.readInt();
            this.m_Name = in.readUTF();
            this.m_Remark = in.readUTF();
            int intDimensionCount = in.readInt();
            for (int intDimension = 0; intDimension < intDimensionCount; ++intDimension) {
                ControlDimensionType o_ControlDimensionType = new ControlDimensionType(this, intDimension);
                o_ControlDimensionType.setMixerPanelOwner(this.m_MixerPanelOwner);
                o_ControlDimensionType.readExternal(in);
                this.addControlDimensionType(o_ControlDimensionType);
            }
        }

        public long getDiskSpaceEstimated() {
            long longBytesCount = 0L;
            longBytesCount += 4L;
            longBytesCount += (long)(this.m_Name.length() * 2);
            longBytesCount += (long)(this.m_Remark.length() * 2);
            for (int intDimension = 0; intDimension < this.m_ControlDimensionTypes.size(); ++intDimension) {
                ControlDimensionType o_ControlDimensionType = this.m_ControlDimensionTypes.get(intDimension);
                longBytesCount += o_ControlDimensionType.getDiskSpaceEstimated();
            }
            return longBytesCount;
        }

        public ControlType getCopyRare(DMXControlType p_DMXControlType) {
            ControlType o_ControlType = new ControlType(p_DMXControlType, this.getIndex());
            o_ControlType.setName(this.m_Name);
            o_ControlType.setRemark(this.m_Remark);
            for (int intDimension = 0; intDimension < this.getControlDimensionTypeCount(); ++intDimension) {
                ControlDimensionType o_ControlDimensionType = this.getControlDimensionType(intDimension).getCopyRare(o_ControlType);
                o_ControlType.addControlDimensionType(o_ControlDimensionType);
            }
            return o_ControlType;
        }

        public String getName() {
            return this.m_Name;
        }

        public void setName(String p_ControlName) {
            if (p_ControlName == null) {
                return;
            }
            if (this.m_Name.equals(p_ControlName)) {
                return;
            }
            String oldValue = this.m_Name;
            this.m_Name = p_ControlName;
            this.m_PropertyChangeSupport.firePropertyChange(PROP_CONTROLTYPE_NAME, oldValue, this.m_Name);
            if (this.getControlDimensionTypeCount() == 1) {
                ControlDimensionType o_ControlDimensionType = this.getControlDimensionType(0);
                o_ControlDimensionType.setName(this.m_Name);
            }
        }

        public String getRemark() {
            return this.m_Remark;
        }

        public void setRemark(String p_ControlRemark) {
            if (p_ControlRemark == null) {
                return;
            }
            if (this.m_Remark.equals(p_ControlRemark)) {
                return;
            }
            String oldValue = this.m_Remark;
            this.m_Remark = p_ControlRemark;
            this.m_PropertyChangeSupport.firePropertyChange(PROP_CONTROLTYPE_REMARK, oldValue, this.m_Remark);
        }

        public void setMixerPanelOwner(int p_MixerPanelOwner) {
            if (this.m_MixerPanelOwner == p_MixerPanelOwner) {
                return;
            }
            this.m_MixerPanelOwner = p_MixerPanelOwner;
            for (int intControlDimensionType = 0; intControlDimensionType < this.m_ControlDimensionTypes.size(); ++intControlDimensionType) {
                ControlDimensionType o_ControlDimensionType = this.m_ControlDimensionTypes.get(intControlDimensionType);
                o_ControlDimensionType.setMixerPanelOwner(this.m_MixerPanelOwner);
            }
        }

        public int getMixerPanelOwner() {
            return this.m_MixerPanelOwner;
        }

        public int getIndex() {
            return this.m_ControlTypeIndex;
        }

        public DMXControlType getDMXControlType() {
            return this.m_DMXControlType;
        }

        public int getControlDimensionTypeCount() {
            return this.m_ControlDimensionTypes.size();
        }

        public boolean addControlDimensionType(ControlDimensionType p_ControlDimensionType) {
            if (p_ControlDimensionType == null) {
                return false;
            }
            p_ControlDimensionType.setMixerPanelOwner(this.m_MixerPanelOwner);
            if (this.m_ControlDimensionTypes.contains(p_ControlDimensionType)) {
                return true;
            }
            boolean boolAdded = false;
            boolAdded = this.m_ControlDimensionTypes.add(p_ControlDimensionType);
            if (boolAdded) {
                this.m_PropertyChangeSupport.firePropertyChange(PROP_CONTROLTYPE_CONTROLDIMENSIONTYPE, null, p_ControlDimensionType);
            }
            return boolAdded;
        }

        public boolean removeControlDimensionType(ControlDimensionType p_ControlDimensionType) {
            if (p_ControlDimensionType == null) {
                return false;
            }
            boolean boolRemoved = false;
            boolRemoved = this.m_ControlDimensionTypes.remove(p_ControlDimensionType);
            if (boolRemoved) {
                this.m_PropertyChangeSupport.firePropertyChange(PROP_CONTROLTYPE_CONTROLDIMENSIONTYPE, p_ControlDimensionType, null);
                p_ControlDimensionType.close();
            }
            return boolRemoved;
        }

        public boolean removeControlDimensionType(int p_Index) {
            if (p_Index < 0) {
                return false;
            }
            if (p_Index >= this.m_ControlDimensionTypes.size()) {
                return false;
            }
            ControlDimensionType o_ControlDimensionType = this.m_ControlDimensionTypes.get(p_Index);
            return this.removeControlDimensionType(o_ControlDimensionType);
        }

        public ControlDimensionType getControlDimensionType(int p_Index) {
            if (p_Index < 0) {
                return null;
            }
            if (p_Index >= this.m_ControlDimensionTypes.size()) {
                return null;
            }
            return this.m_ControlDimensionTypes.get(p_Index);
        }

        public ControlDimensionType getControlDimensionType(ControlObject.ControlDimension p_ControlDimension) {
            ControlDimensionType o_ControlDimensionType = null;
            for (int intDimensionType = 0; intDimensionType < this.m_ControlDimensionTypes.size(); ++intDimensionType) {
                o_ControlDimensionType = this.m_ControlDimensionTypes.get(intDimensionType);
                if (o_ControlDimensionType.getControlDimension() != p_ControlDimension) continue;
                return o_ControlDimensionType;
            }
            return null;
        }

        public void setInstance(ControlObject p_ControlObject) {
            ControlObject oldValue = this.m_InstanceControlObject;
            if (oldValue != null) {
                this.m_InstanceControlObject.removePropertyChangeListener((PropertyChangeListener)this);
            }
            this.m_InstanceControlObject = p_ControlObject;
            for (int intDimension = 0; intDimension < this.m_ControlDimensionTypes.size(); ++intDimension) {
                ControlDimensionType o_ControlDimensionType = this.m_ControlDimensionTypes.get(intDimension);
                ControlObject.ControlDimension o_ControlDimension = this.m_InstanceControlObject != null ? this.m_InstanceControlObject.getControlDimension(intDimension) : null;
                o_ControlDimensionType.setInstance(o_ControlDimension);
            }
            if (this.m_InstanceControlObject != null) {
                this.m_InstanceControlObject.addPropertyChangeListener((PropertyChangeListener)this);
            }
            this.m_PropertyChangeSupport.firePropertyChange(PROP_CONTROLTYPE_INSTANCE, oldValue, this.m_InstanceControlObject);
        }

        public ControlObject getInstance() {
            return this.m_InstanceControlObject;
        }

        public DMXControlComponent getDMXControlComponent() {
            if (this.m_DMXControlType == null) {
                return null;
            }
            return this.m_DMXControlType.getDMXControlComponent();
        }

        public boolean isSameAs(ControlType p_ControlType) {
            if (this.m_ControlDimensionTypes.size() != p_ControlType.getControlDimensionTypeCount()) {
                return false;
            }
            for (int intDimension = 0; intDimension < this.m_ControlDimensionTypes.size(); ++intDimension) {
                ControlDimensionType o_ControlDimensionType;
                ControlDimensionType o_ControlDimensionTypeSelf = this.m_ControlDimensionTypes.get(intDimension);
                if (o_ControlDimensionTypeSelf.isSameAs(o_ControlDimensionType = p_ControlType.getControlDimensionType(intDimension))) continue;
                return false;
            }
            return true;
        }

        public void addPropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
            if (p_PropertyChangeListener == null) {
                return;
            }
            this.m_PropertyChangeSupport.addPropertyChangeListener(p_PropertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
            this.m_PropertyChangeSupport.removePropertyChangeListener(p_PropertyChangeListener);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() instanceof ControlObject) {
                ControlObject o_ControlObject = (ControlObject)evt.getSource();
                if (o_ControlObject == null) {
                    return;
                }
                if ("valueChangedManually".equals(evt.getPropertyName())) {
                    DMXControlComponent o_DMXControlComponent = this.getDMXControlComponent();
                    if (!o_ControlObject.getControlMaster()) {
                        if (o_DMXControlComponent != null) {
                            o_DMXControlComponent.refreshValuesControlDimensions_Manually();
                            DMXControlComponent o_DMXControlComponentSource = this.m_DMXControlType != null ? this.m_DMXControlType.getDMXControlComponent() : null;
                            o_DMXControlComponent.refreshDisplay_ControlValueChanged(o_DMXControlComponentSource, o_ControlObject, null, "valueChangedManually");
                        }
                    } else if (o_DMXControlComponent != null) {
                        o_DMXControlComponent.refreshValueFactors();
                    }
                }
                if ("name".equals(evt.getPropertyName())) {
                    this.setName((String)evt.getNewValue());
                }
            }
        }
    }

    public static class DMXControlType
    implements Externalizable {
        public static final int SOFTWAREVERSION = 5;
        public static final String PROP_DMXCONTROLTYPE_NAME = "dmxcontroltypeName";
        public static final String PROP_DMXCONTROLTYPE_DIMMERSUBSTITUTE = "dmxcontroltypeDimmerSubstitute";
        public static final String PROP_DMXCONTROLTYPE_DIMMERSUBSTITUTEENABLED = "dmxcontroltypeDimmerSubstituteEnabled";
        public static final String PROP_DMXCONTROLTYPE_DISABLEDINFUNCTIONS = "dmxcontroltypeDisabledInFunctions";
        public static final String PROP_DMXCONTROLTYPE_REMARK = "dmxcontroltypeRemark";
        public static final String PROP_DMXCONTROLTYPE_CONTROLTYPE = "dmxcontroltypeCcontrolType";
        public static final String PROP_DMXCONTROLTYPE_DMXCONTROLDESCRIPTION = "dmxcontroltypeDMXControlDescription";
        public static final String PROP_DMXCONTROLTYPE_INSTANCE = "dmxcontroltypeInstance";
        private String m_ID;
        private String m_ClassName;
        private boolean m_DimmerSubstituteVisible;
        private boolean m_IsDimmerSubstitute;
        private boolean m_DimmerSubstituteEnabled;
        private boolean m_DisabledInFunctionsVisible;
        private boolean m_DisabledInFunctions;
        private int m_MixerPanelOwner;
        private String m_ClassificationName;
        private String m_Name;
        private String m_Remark;
        private DMXControlDescription m_DMXControlDescription;
        private ArrayList<ControlType> m_ControlTypes;
        private ArrayList<DeviceControlLink> m_DeviceControlLinks;
        private DMXControlComponent m_InstanceDMXControlComponent;
        private DMXControlSpecialSettings m_InstanceDMXControlSpecialSettings;
        private CorrectionModel m_CorrectionModel;
        private boolean m_OverwriteManualValues;
        private SinglePropertyChangeSupport m_PropertyChangeSupport;

        public DMXControlType() {
            this.initMembers();
        }

        public DMXControlType(String p_ClassName, String p_Name, String p_Description) {
            this.initMembers();
            this.m_ClassName = p_ClassName;
            this.m_Name = p_Name;
            this.m_Remark = p_Description;
        }

        private void initMembers() {
            this.m_ID = LiveGUID.getUID();
            this.m_ClassName = "";
            this.m_Name = "";
            this.m_IsDimmerSubstitute = false;
            this.m_DimmerSubstituteVisible = false;
            this.m_DisabledInFunctionsVisible = false;
            this.m_DisabledInFunctions = false;
            this.m_MixerPanelOwner = 0;
            this.m_Remark = "";
            this.m_ControlTypes = new ArrayList();
            this.m_DeviceControlLinks = new ArrayList();
            this.m_InstanceDMXControlComponent = null;
            this.m_PropertyChangeSupport = new SinglePropertyChangeSupport(this);
            this.m_DMXControlDescription = DMXControlDescription.getDMXControlDescription(DMXControlDescription.ID_UNDEFINED);
            this.m_OverwriteManualValues = false;
        }

        public void close() {
            if (this.m_ControlTypes != null) {
                int intControlsCount = this.m_ControlTypes.size();
                for (int intControl = intControlsCount - 1; intControl >= 0; --intControl) {
                    ControlType o_ControlType = this.m_ControlTypes.get(intControl);
                    this.removeControlType(o_ControlType);
                    o_ControlType.close();
                }
            }
            this.m_InstanceDMXControlComponent = null;
            if (this.m_PropertyChangeSupport != null) {
                this.m_PropertyChangeSupport.clear();
            }
        }

        public void finalize() throws Throwable {
            super.finalize();
            this.m_PropertyChangeSupport = null;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(5);
            out.writeUTF(this.m_ID);
            out.writeUTF(this.m_ClassName);
            out.writeUTF(this.m_Name);
            out.writeBoolean(this.m_IsDimmerSubstitute);
            out.writeBoolean(this.m_DisabledInFunctions);
            out.writeUTF(this.m_Remark);
            out.writeUTF(this.m_DMXControlDescription.getID());
            int intControlCount = this.m_ControlTypes.size();
            out.writeInt(intControlCount);
            for (int intControl = 0; intControl < intControlCount; ++intControl) {
                ControlType o_ControlType = this.m_ControlTypes.get(intControl);
                o_ControlType.writeExternal(out);
            }
            if (this.m_InstanceDMXControlSpecialSettings == null) {
                out.writeUTF("null");
            } else {
                out.writeUTF(this.m_InstanceDMXControlSpecialSettings.getClass().getName());
                this.m_InstanceDMXControlSpecialSettings.writeExternal(out);
            }
            if (this.m_CorrectionModel != null) {
                out.writeUTF(this.m_CorrectionModel.getID());
                this.m_CorrectionModel.writeExternal(out);
            } else {
                out.writeUTF("");
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            String stringCorrectionModelID;
            int intSoftwareVersion = in.readInt();
            this.m_ID = in.readUTF();
            this.m_ClassName = in.readUTF();
            this.m_Name = in.readUTF();
            if (intSoftwareVersion >= 3) {
                this.m_IsDimmerSubstitute = in.readBoolean();
            }
            if (intSoftwareVersion >= 5) {
                this.m_DisabledInFunctions = in.readBoolean();
            }
            this.m_Remark = in.readUTF();
            if (intSoftwareVersion >= 2) {
                String stringDescriptionID = in.readUTF();
                this.m_DMXControlDescription = DMXControlDescription.getDMXControlDescription(stringDescriptionID);
            } else {
                this.m_DMXControlDescription = null;
            }
            if (this.m_DMXControlDescription == null) {
                this.m_DMXControlDescription = DMXControl_RGB.class.getName().equals(this.getClassName()) ? DMXControlDescription.getDMXControlDescription("rgbcmy") : (DMXControl_Dimmer.class.getName().equals(this.getClassName()) ? DMXControlDescription.getDMXControlDescription("dimmer") : (DMXControl_GridPanTilt.class.getName().equals(this.getClassName()) ? DMXControlDescription.getDMXControlDescription("pantilt") : (DMXControl_FreeSwitch.class.getName().equals(this.getClassName()) ? DMXControlDescription.getDMXControlDescription("switch") : DMXControlDescription.getDMXControlDescription(DMXControlDescription.ID_UNDEFINED))));
            }
            int intControlCount = in.readInt();
            for (int intControl = 0; intControl < intControlCount; ++intControl) {
                ControlType o_ControlType = new ControlType(this, intControl);
                o_ControlType.setMixerPanelOwner(this.m_MixerPanelOwner);
                o_ControlType.readExternal(in);
                this.addControlType(o_ControlType);
            }
            DMXControlSpecialSettings o_DMXControlSpecialSettings = null;
            String stringControlSpecialSettings = in.readUTF();
            if (stringControlSpecialSettings.length() <= 0 || "null".equals(stringControlSpecialSettings)) {
                this.m_InstanceDMXControlSpecialSettings = null;
            } else {
                try {
                    Class<?> o_Class = DMXControlComponent.loadDMXControlClass(stringControlSpecialSettings);
                    o_DMXControlSpecialSettings = (DMXControlSpecialSettings)o_Class.newInstance();
                    o_DMXControlSpecialSettings.readExternal(in);
                }
                catch (Exception o_Exception) {
                    o_DMXControlSpecialSettings = null;
                }
            }
            this.m_InstanceDMXControlSpecialSettings = o_DMXControlSpecialSettings;
            if (intSoftwareVersion >= 4 && (stringCorrectionModelID = in.readUTF()).length() > 0) {
                this.m_CorrectionModel = new CorrectionModel();
                this.m_CorrectionModel.readExternal(in);
            }
        }

        public long getDiskSpaceEstimated() {
            long longBytesCount = 0L;
            longBytesCount += 4L;
            longBytesCount += (long)(this.m_ID.length() * 2);
            longBytesCount += (long)(this.m_ClassName.length() * 2);
            longBytesCount += (long)(this.m_Name.length() * 2);
            ++longBytesCount;
            ++longBytesCount;
            longBytesCount += (long)(this.m_Remark.length() * 2);
            longBytesCount += (long)(this.m_DMXControlDescription.getID().length() * 2);
            int intControlCount = this.m_ControlTypes.size();
            longBytesCount += 4L;
            for (int intControl = 0; intControl < intControlCount; ++intControl) {
                ControlType o_ControlType = this.m_ControlTypes.get(intControl);
                longBytesCount += o_ControlType.getDiskSpaceEstimated();
            }
            if (this.m_InstanceDMXControlSpecialSettings == null) {
                longBytesCount += (long)("null".length() * 2);
            } else {
                longBytesCount += (long)(this.m_InstanceDMXControlSpecialSettings.getClass().getName().length() * 2);
                longBytesCount += this.m_InstanceDMXControlSpecialSettings.getDiskSpaceEstimated();
            }
            if (this.m_CorrectionModel != null) {
                longBytesCount += (long)(this.m_CorrectionModel.getID().length() * 2);
                longBytesCount += this.m_CorrectionModel.getDiskSpaceEstimated();
            } else {
                longBytesCount += 2L;
            }
            return longBytesCount;
        }

        public String getClassName() {
            return this.m_ClassName;
        }

        public String getSimpleClassName() {
            int intIndex = this.m_ClassName.lastIndexOf(".");
            if (intIndex >= 0) {
                return this.m_ClassName.substring(intIndex + 1);
            }
            return this.m_ClassName;
        }

        public void setDMXControlDescription(DMXControlDescription p_DMXControlDescription) {
            if (p_DMXControlDescription == this.m_DMXControlDescription) {
                return;
            }
            DMXControlDescription oldValue = this.m_DMXControlDescription;
            this.m_DMXControlDescription = p_DMXControlDescription;
            this.m_PropertyChangeSupport.firePropertyChange(PROP_DMXCONTROLTYPE_DMXCONTROLDESCRIPTION, oldValue, this.m_DMXControlDescription);
        }

        public DMXControlDescription getDMXControlDescription() {
            return this.m_DMXControlDescription;
        }

        public String getID() {
            return this.m_ID;
        }

        public void setID(String p_ID) {
            if (p_ID == null) {
                return;
            }
            this.m_ID = p_ID;
        }

        public void setName(String p_Name) {
            if (p_Name == null) {
                return;
            }
            if (this.m_Name.equals(p_Name)) {
                return;
            }
            String oldValue = this.m_Name;
            this.m_Name = p_Name;
            this.m_PropertyChangeSupport.firePropertyChange(PROP_DMXCONTROLTYPE_NAME, oldValue, this.m_Name);
        }

        public String getName() {
            return this.m_Name;
        }

        public boolean getIsDimmer() {
            return "dimmer".equals(this.m_DMXControlDescription.getID());
        }

        public void setMixerPanelOwner(int p_MixerPanelOwner) {
            if (this.m_MixerPanelOwner == p_MixerPanelOwner) {
                return;
            }
            this.m_MixerPanelOwner = p_MixerPanelOwner;
            for (int intControlType = 0; intControlType < this.m_ControlTypes.size(); ++intControlType) {
                ControlType o_ControlType = this.m_ControlTypes.get(intControlType);
                o_ControlType.setMixerPanelOwner(this.m_MixerPanelOwner);
            }
        }

        public int getMixerPanelOwner() {
            return this.m_MixerPanelOwner;
        }

        public void setDimmerSubstituteEnabled(boolean p_IsEnabled) {
            if (this.m_DimmerSubstituteEnabled == p_IsEnabled) {
                return;
            }
            boolean oldValue = this.m_DimmerSubstituteEnabled;
            this.m_DimmerSubstituteEnabled = p_IsEnabled;
            this.m_PropertyChangeSupport.firePropertyChange(PROP_DMXCONTROLTYPE_DIMMERSUBSTITUTEENABLED, oldValue, this.m_DimmerSubstituteEnabled);
        }

        public boolean getDimmerSubstituteEnabled() {
            return this.m_DimmerSubstituteEnabled;
        }

        public void setDimmerSubstituteVisible(boolean p_IsVisible) {
            this.m_DimmerSubstituteVisible = p_IsVisible;
        }

        public boolean getDimmerSubstituteVisible() {
            return this.m_DimmerSubstituteVisible;
        }

        public void setIsDisabledInFunctions(boolean p_Disabled) {
            if (this.m_DisabledInFunctions == p_Disabled) {
                return;
            }
            boolean oldValue = this.m_DisabledInFunctions;
            this.m_DisabledInFunctions = p_Disabled;
            this.m_PropertyChangeSupport.firePropertyChange(PROP_DMXCONTROLTYPE_DISABLEDINFUNCTIONS, oldValue, this.m_DisabledInFunctions);
        }

        public boolean getIsDisabledInFunctions() {
            return this.m_DisabledInFunctions;
        }

        public void setDisabledInFunctionsVisible(boolean p_IsVisible) {
            this.m_DisabledInFunctionsVisible = p_IsVisible;
        }

        public boolean getDisabledInFunctionsVisible() {
            return this.m_DisabledInFunctionsVisible;
        }

        public void setIsDimmerSubstitute(boolean p_IsDimmerSubstitute) {
            if (this.m_IsDimmerSubstitute == p_IsDimmerSubstitute) {
                return;
            }
            boolean oldValue = this.m_IsDimmerSubstitute;
            this.m_IsDimmerSubstitute = p_IsDimmerSubstitute;
            this.m_PropertyChangeSupport.firePropertyChange(PROP_DMXCONTROLTYPE_DIMMERSUBSTITUTE, oldValue, this.m_IsDimmerSubstitute);
        }

        public boolean getIsDimmerSubstitute() {
            return this.m_IsDimmerSubstitute;
        }

        public void setRemark(String p_Remark) {
            if (p_Remark == null) {
                return;
            }
            if (this.m_Remark.equals(p_Remark)) {
                return;
            }
            String oldValue = this.m_Remark;
            this.m_Remark = p_Remark;
            this.m_PropertyChangeSupport.firePropertyChange(PROP_DMXCONTROLTYPE_REMARK, oldValue, this.m_Remark);
        }

        public String getRemark() {
            return this.m_Remark;
        }

        public void setCorrectionModel(CorrectionModel p_CorrectionModel) {
            this.m_CorrectionModel = p_CorrectionModel;
        }

        public CorrectionModel getCorrectionModel() {
            return this.m_CorrectionModel;
        }

        public int getControlTypeCount() {
            return this.m_ControlTypes.size();
        }

        public boolean addControlType(ControlType p_ControlType) {
            if (p_ControlType == null) {
                return false;
            }
            p_ControlType.setMixerPanelOwner(this.m_MixerPanelOwner);
            if (this.m_ControlTypes.contains(p_ControlType)) {
                return true;
            }
            boolean boolAdded = false;
            boolAdded = this.m_ControlTypes.add(p_ControlType);
            if (boolAdded) {
                this.m_PropertyChangeSupport.firePropertyChange(PROP_DMXCONTROLTYPE_CONTROLTYPE, null, p_ControlType);
            }
            return boolAdded;
        }

        public boolean removeControlType(ControlType p_ControlType) {
            if (p_ControlType == null) {
                return false;
            }
            boolean boolRemoved = false;
            boolRemoved = this.m_ControlTypes.remove(p_ControlType);
            if (boolRemoved) {
                this.m_PropertyChangeSupport.firePropertyChange(PROP_DMXCONTROLTYPE_CONTROLTYPE, p_ControlType, null);
                p_ControlType.close();
            }
            return boolRemoved;
        }

        public boolean removeControlType(int p_Index) {
            if (p_Index < 0) {
                return false;
            }
            if (p_Index >= this.m_ControlTypes.size()) {
                return false;
            }
            ControlType o_ControlType = this.m_ControlTypes.get(p_Index);
            return this.removeControlType(o_ControlType);
        }

        public ControlType getControlType(int p_Index) {
            if (p_Index < 0) {
                return null;
            }
            if (p_Index >= this.m_ControlTypes.size()) {
                return null;
            }
            return this.m_ControlTypes.get(p_Index);
        }

        public int getControlTypeIndex(ControlType p_ControlType) {
            if (p_ControlType == null) {
                return -1;
            }
            for (int intControl = 0; intControl < this.m_ControlTypes.size(); ++intControl) {
                if (p_ControlType != this.m_ControlTypes.get(intControl)) continue;
                return intControl;
            }
            return -1;
        }

        public ControlType getControlType(ControlObject p_ControlObject) {
            for (int intType = 0; intType < this.m_ControlTypes.size(); ++intType) {
                ControlType o_ControlType = this.m_ControlTypes.get(intType);
                if (o_ControlType.getInstance() != p_ControlObject) continue;
                return o_ControlType;
            }
            return null;
        }

        public void setDMXControlSpecialSettings(DMXControlSpecialSettings p_DMXControlSpecialSettings) {
            this.m_InstanceDMXControlSpecialSettings = p_DMXControlSpecialSettings;
        }

        public DMXControlSpecialSettings getDMXControlSpecialSettings() {
            return this.m_InstanceDMXControlSpecialSettings;
        }

        public DMXControlType copyWithoutLinks() {
            DMXControlType o_DMXControlType_New = new DMXControlType(this.getClassName(), this.getName(), this.getRemark());
            o_DMXControlType_New.setIsDimmerSubstitute(this.getIsDimmerSubstitute());
            o_DMXControlType_New.setIsDisabledInFunctions(this.getIsDisabledInFunctions());
            o_DMXControlType_New.setDMXControlDescription(this.getDMXControlDescription());
            o_DMXControlType_New.setID(this.getID());
            for (int intControl = 0; intControl < this.getControlTypeCount(); ++intControl) {
                ControlType o_ControlType = this.getControlType(intControl);
                ControlType o_ControlType_New = new ControlType(o_DMXControlType_New, intControl);
                o_ControlType_New.setName(o_ControlType.getName());
                o_ControlType_New.setRemark(o_ControlType.getRemark());
                o_DMXControlType_New.addControlType(o_ControlType_New);
                for (int intDimension = 0; intDimension < o_ControlType.getControlDimensionTypeCount(); ++intDimension) {
                    ControlDimensionType o_ControlDimensionType = o_ControlType.getControlDimensionType(intDimension);
                    ControlDimensionType o_ControlDimensionType_New = new ControlDimensionType(o_ControlType_New, intDimension);
                    o_ControlDimensionType_New.setName(o_ControlDimensionType.getName());
                    o_ControlDimensionType_New.setValueMaximum(o_ControlDimensionType.getValueMaximum());
                    o_ControlDimensionType_New.setControlLabelModel(o_ControlDimensionType.getControlLabelModel().getCopy());
                    o_ControlDimensionType_New.setControlBlockModel(o_ControlDimensionType.getControlBlockModel().getCopy());
                    o_ControlDimensionType_New.setControlFunctionModel(o_ControlDimensionType.getControlFunctionModel().getCopy());
                    o_ControlDimensionType_New.setByteResolution(o_ControlDimensionType.getByteResolution());
                    o_ControlType_New.addControlDimensionType(o_ControlDimensionType_New);
                }
            }
            if (this.m_InstanceDMXControlSpecialSettings == null) {
                o_DMXControlType_New.setDMXControlSpecialSettings(null);
            } else {
                o_DMXControlType_New.setDMXControlSpecialSettings(this.m_InstanceDMXControlSpecialSettings.getCopy());
            }
            if (this.m_CorrectionModel != null) {
                if (o_DMXControlType_New.getCorrectionModel() == null) {
                    o_DMXControlType_New.setCorrectionModel(new CorrectionModel());
                }
                this.m_CorrectionModel.copyTo(o_DMXControlType_New.getCorrectionModel());
            }
            return o_DMXControlType_New;
        }

        public DeviceControlLink addDMXDeviceControlLink(DMXDevice p_DMXDevice, int p_DMXDeviceSectorIndex, int p_InternalChannel, int p_ControlIndex, int p_DimensionIndex, int p_ByteIndex) {
            if (p_DMXDevice == null) {
                return null;
            }
            ControlType o_ControlType = this.getControlType(p_ControlIndex);
            if (o_ControlType == null) {
                return null;
            }
            ControlDimensionType o_ControlDimensionType = o_ControlType.getControlDimensionType(p_DimensionIndex);
            if (o_ControlDimensionType == null) {
                return null;
            }
            DeviceControlLink o_DeviceControlLink = o_ControlDimensionType.addDeviceControlLink(p_DMXDevice, p_DMXDeviceSectorIndex, p_ByteIndex, p_InternalChannel);
            if (o_DeviceControlLink == null) {
                return null;
            }
            DMXControlComponent o_DMXControlComponent = this.getDMXControlComponent();
            if (o_DMXControlComponent != null) {
                o_DMXControlComponent.changedDMXControlLinks();
            }
            return o_DeviceControlLink;
        }

        public void addDMXDeviceControlLinkToList(DeviceControlLink p_DeviceControlLink) {
            if (p_DeviceControlLink == null) {
                return;
            }
            if (this.m_DeviceControlLinks.contains(p_DeviceControlLink)) {
                return;
            }
            this.m_DeviceControlLinks.add(p_DeviceControlLink);
        }

        public void removeDMXDeviceControlLinkFromList(DeviceControlLink p_DeviceControlLink) {
            if (p_DeviceControlLink == null) {
                return;
            }
            if (!this.m_DeviceControlLinks.contains(p_DeviceControlLink)) {
                return;
            }
            this.m_DeviceControlLinks.remove(p_DeviceControlLink);
        }

        public boolean removeDMXDeviceControlLink(DeviceControlLink p_DeviceControlLink) {
            DMXControlComponent o_DMXControlComponent;
            ControlType o_ControlType = this.getControlType(p_DeviceControlLink.getControlTypeIndex());
            if (o_ControlType == null) {
                return false;
            }
            ControlDimensionType o_ControlDimensionType = o_ControlType.getControlDimensionType(p_DeviceControlLink.getControlDimensionTypeIndex());
            if (o_ControlDimensionType == null) {
                return false;
            }
            boolean boolRemoved = false;
            boolRemoved = o_ControlDimensionType.removeDeviceControlLink(p_DeviceControlLink);
            if (boolRemoved && (o_DMXControlComponent = this.getDMXControlComponent()) != null) {
                o_DMXControlComponent.changedDMXControlLinks();
            }
            return boolRemoved;
        }

        public DeviceControlLink getDeviceControlLink(DMXDevice p_DMXDevice, int p_DMXDeviceSectorIndex, int p_InternalChannel, int p_ControlIndex, int p_DimensionIndex, int p_ByteIndex) {
            ControlType o_ControlType = this.getControlType(p_ControlIndex);
            if (o_ControlType == null) {
                return null;
            }
            ControlDimensionType o_ControlDimensionType = o_ControlType.getControlDimensionType(p_DimensionIndex);
            if (o_ControlDimensionType == null) {
                return null;
            }
            DeviceControlLink o_DeviceControlLink = null;
            o_DeviceControlLink = o_ControlDimensionType.findDeviceControlLink(p_DMXDevice, p_DMXDeviceSectorIndex, p_ByteIndex, p_InternalChannel);
            return o_DeviceControlLink;
        }

        public ArrayList<DeviceControlLink> getDeviceControlLinks() {
            return this.m_DeviceControlLinks;
        }

        public boolean copyDeviceControlLinksTo(DMXDevice p_DMXDevice, DMXControlType p_DMXControlType) {
            if (p_DMXControlType == null) {
                return false;
            }
            for (int intLink = 0; intLink < this.m_DeviceControlLinks.size(); ++intLink) {
                DeviceControlLink o_DeviceControlLink = this.m_DeviceControlLinks.get(intLink);
                int intDMXdeviceSectorIndex = o_DeviceControlLink.getDMXDeviceSectorIndex();
                int intControlIndex = o_DeviceControlLink.getControlTypeIndex();
                int intDimensionIndex = o_DeviceControlLink.getControlDimensionTypeIndex();
                int intByteCount = o_DeviceControlLink.getByteResolution();
                for (int intByte = 0; intByte < intByteCount; ++intByte) {
                    int intInternalChannel = o_DeviceControlLink.getDeviceInternalChannel(intByte);
                    if (intInternalChannel < 0) continue;
                    p_DMXControlType.addDMXDeviceControlLink(p_DMXDevice, intDMXdeviceSectorIndex, intInternalChannel, intControlIndex, intDimensionIndex, intByte);
                }
            }
            return true;
        }

        public void setInstance(DMXControlComponent p_DMXControlComponent) {
            DMXControlComponent oldValue = this.m_InstanceDMXControlComponent;
            this.m_InstanceDMXControlComponent = p_DMXControlComponent;
            ControlObject o_ControlObject = null;
            for (int intControl = 0; intControl < this.m_ControlTypes.size(); ++intControl) {
                ControlType o_ControlType = this.m_ControlTypes.get(intControl);
                o_ControlObject = this.m_InstanceDMXControlComponent != null ? this.m_InstanceDMXControlComponent.getControlObject(intControl) : null;
                o_ControlType.setInstance(o_ControlObject);
            }
            this.m_PropertyChangeSupport.firePropertyChange(PROP_DMXCONTROLTYPE_INSTANCE, oldValue, this.m_InstanceDMXControlComponent);
        }

        public DMXControlComponent getInstance() {
            return this.m_InstanceDMXControlComponent;
        }

        public DMXControlComponent getDMXControlComponent() {
            return this.m_InstanceDMXControlComponent;
        }

        public boolean isSameAs(DMXControlType p_DMXControlType) {
            if (!this.m_ClassName.equals(p_DMXControlType.getClassName())) {
                return false;
            }
            if (this.m_ControlTypes.size() != p_DMXControlType.getControlTypeCount()) {
                return false;
            }
            for (int intControlType = 0; intControlType < this.m_ControlTypes.size(); ++intControlType) {
                ControlType o_ControlType;
                ControlType o_ControlTypeSelf = this.m_ControlTypes.get(intControlType);
                if (o_ControlTypeSelf.isSameAs(o_ControlType = p_DMXControlType.getControlType(intControlType))) continue;
                return false;
            }
            return true;
        }

        public void addPropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
            if (p_PropertyChangeListener == null) {
                return;
            }
            this.m_PropertyChangeSupport.addPropertyChangeListener(p_PropertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
            this.m_PropertyChangeSupport.removePropertyChangeListener(p_PropertyChangeListener);
        }
    }

    public static class DMXControlTypeCellRenderer
    extends DefaultListCellRenderer {
        protected static final Border SAFE_NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);
        protected static final Border DEFAULT_NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);
        protected static final Border SELECTED_BORDER = new LineBorder(Color.BLUE, 2, true);

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setComponentOrientation(list.getComponentOrientation());
            Color o_Background = null;
            Color o_Foreground = null;
            o_Background = list.getBackground();
            o_Foreground = list.getForeground();
            if (isSelected) {
                if (list.hasFocus()) {
                    o_Background = UIManager.getColor("List.selectionBackground");
                    o_Foreground = UIManager.getColor("List.selectionForeground");
                } else {
                    o_Background = UIManager.getColor("List.selectionInactiveBackground");
                    o_Foreground = UIManager.getColor("List.selectionInactiveForeground");
                }
            }
            this.setForeground(o_Foreground);
            this.setBackground(o_Background);
            if (value instanceof Icon) {
                this.setIcon((Icon)value);
                this.setText("");
            } else {
                String stringDMXControlName;
                this.setIcon(null);
                if (value == null) {
                    stringDMXControlName = "";
                } else {
                    DMXControlType o_DMXControlType = (DMXControlType)value;
                    stringDMXControlName = o_DMXControlType.getName();
                }
                this.setText(stringDMXControlName);
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            Border border = null;
            if (isSelected) {
                border = SELECTED_BORDER;
            }
            if (border == null) {
                border = this.getNoFocusBorder();
            }
            return this;
        }

        private Border getNoFocusBorder() {
            Border border = null;
            if (System.getSecurityManager() != null) {
                if (border != null) {
                    return border;
                }
                return SAFE_NO_FOCUS_BORDER;
            }
            if (border != null && (noFocusBorder == null || noFocusBorder == DEFAULT_NO_FOCUS_BORDER)) {
                return border;
            }
            return noFocusBorder;
        }
    }

    public static class DMXControlTypeListModel
    extends DefaultComboBoxModel
    implements PropertyChangeListener {
        private final Object m_SyncObject = new Object();

        public DMXControlTypeListModel() {
            this.addElement(DMXControl_Dimmer.s_DMXControlType);
            this.addElement(DMXControl_RGB.s_DMXControlType);
            this.addElement(DMXControl_GridPanTilt.s_DMXControlType);
            this.addElement(DMXControl_FreeDimmer.s_DMXControlType);
            this.addElement(DMXControl_FreeFader.s_DMXControlType);
            this.addElement(DMXControl_FreeSwitch.s_DMXControlType);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean containsElement(DMXControlType p_DMXControlType) {
            Object object = this.m_SyncObject;
            synchronized (object) {
                for (int intType = 0; intType < super.getSize(); ++intType) {
                    DMXControlType o_DMXControlType = (DMXControlType)super.getElementAt(intType);
                    if (o_DMXControlType != p_DMXControlType) continue;
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void addElement(Object p_DMXControlType) {
            if (p_DMXControlType == null) {
                return;
            }
            if (!(p_DMXControlType instanceof DMXControlType)) {
                return;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                DMXControlType o_DMXControlType = (DMXControlType)p_DMXControlType;
                if (this.containsElement(o_DMXControlType)) {
                    return;
                }
                super.addElement(p_DMXControlType);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void removeElement(Object p_DMXControlType) {
            if (p_DMXControlType == null) {
                return;
            }
            if (!(p_DMXControlType instanceof DMXControlType)) {
                return;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                DMXControlType o_DMXControlType = (DMXControlType)p_DMXControlType;
                if (!this.containsElement(o_DMXControlType)) {
                    return;
                }
                super.removeElement(p_DMXControlType);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public DMXControlType getElementAt(int p_Index) {
            Object object = this.m_SyncObject;
            synchronized (object) {
                return (DMXControlType)super.getElementAt(p_Index);
            }
        }

        @Override
        public DMXControlType getSelectedItem() {
            return (DMXControlType)super.getSelectedItem();
        }

        @Override
        protected void fireContentsChanged(Object source, int index0, int index1) {
            super.fireContentsChanged(source, index0, index1);
        }

        @Override
        protected void fireIntervalAdded(Object source, int index0, int index1) {
            super.fireIntervalAdded(source, index0, index1);
        }

        @Override
        protected void fireIntervalRemoved(Object source, int index0, int index1) {
            super.fireIntervalRemoved(source, index0, index1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            int intIndex;
            Object object = this.m_SyncObject;
            synchronized (object) {
                intIndex = super.getIndexOf(evt.getSource());
                if (intIndex < 0) {
                    return;
                }
            }
            this.fireContentsChanged(this, intIndex, intIndex);
        }
    }

    public static abstract class DeviceSettingsPanel
    extends JPanel
    implements Externalizable {
        protected DMXDevice m_DMXDevice;
        protected DMXControlComponent m_DMXControlComponent;

        public DeviceSettingsPanel(DMXDevice p_DMXDevice, DMXControlComponent p_DMXControlComponent) {
            this.m_DMXDevice = p_DMXDevice;
            this.m_DMXControlComponent = p_DMXControlComponent;
        }

        public DMXDevice getDMXDevice() {
            return this.m_DMXDevice;
        }

        public void setDMXControlComponent(DMXControlComponent p_DMXControlComponent) {
            this.m_DMXControlComponent = p_DMXControlComponent;
        }

        public DMXControlComponent getDMXControlComponent() {
            return this.m_DMXControlComponent;
        }

        public String getDMXControlComponentName() {
            if (this.m_DMXControlComponent == null) {
                return "";
            }
            return this.m_DMXControlComponent.getName();
        }

        public abstract void close();

        public abstract boolean getIsEqualDefault();

        public abstract void setDMXDevice(DMXDevice var1);

        public abstract void addDMXControlComponent(DMXControlComponent var1);

        public abstract void removeDMXControlComponent(DMXControlComponent var1);

        public abstract void save();

        public abstract void cancel();

        public abstract void setDMXDeviceSettings();

        public abstract void validateValuesDevice(boolean var1, boolean var2);

        public abstract void validateReverseValuesInterface(boolean var1);

        @Override
        public abstract void writeExternal(ObjectOutput var1) throws IOException;

        @Override
        public abstract void readExternal(ObjectInput var1) throws IOException, ClassNotFoundException;

        public abstract long getDiskSpaceEstimated();
    }

    public static interface ManuallyChangeListener {
        public void eventManuallyChanged(DMXControlComponent var1);
    }
}

