/*
 * Decompiled with CFR 0.152.
 */
package DMXHardwarePackage;

import DMXHardwarePackage.DMXHardwareInterface;
import JarLoader.JarClassLoader;
import JarLoader.JarResources;
import StartPackage.LiveShowDMXSystem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.Externalizable;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DMXHardwareType
implements Externalizable {
    public static final int SOFTWAREVERSION = 1;
    protected static String HARDWAREPACKAGENAME = "DMXHardwarePackage.";
    protected static DMXHardwareTypeTreeModel<DMXHardwareTypeTreeNode<?>> s_DMXHardwareTypeTreeModel = new DMXHardwareTypeTreeModel();
    protected static DMXHardwareTypeTreeCellRenderer s_DMXHardwareTypeTreeCellRenderer = new DMXHardwareTypeTreeCellRenderer();
    protected String m_FileName;
    protected String m_ClassPathName;
    private ImageIcon m_ImageIconLogo;
    private ImageIcon m_ImageIconInterface;
    private String m_InterfaceName;
    private String m_ManufacturerName;
    private BufferedImage m_BufferedImage_Logo;
    private BufferedImage m_BufferedImage_Interface;
    private JarClassLoader m_JarClassLoader;
    private Class m_HardwareClass;
    private boolean m_Valid;
    private static HashMap<String, DMXHardwareType> s_DMXHardwareTypes = new HashMap();

    public static DMXHardwareType getDMXHardwareType(String p_ClassPathName) {
        if (p_ClassPathName == null) {
            return null;
        }
        DMXHardwareType o_DMXHardwareType = s_DMXHardwareTypes.get(p_ClassPathName);
        return o_DMXHardwareType;
    }

    public static boolean addDMXHardwareType(DMXHardwareType p_DMXHardwareType) {
        if (p_DMXHardwareType == null) {
            return false;
        }
        if (s_DMXHardwareTypes.get(p_DMXHardwareType.getClassName()) != null) {
            return false;
        }
        s_DMXHardwareTypes.put(p_DMXHardwareType.getClassName(), p_DMXHardwareType);
        return true;
    }

    public static DMXHardwareType readDMXHardwareType(ObjectInput in) throws IOException, ClassNotFoundException {
        DMXHardwareType o_DMXHardwareType;
        int intSoftwareVersion = in.readInt();
        String stringClassPathName = in.readUTF();
        String stringFileName = in.readUTF();
        if (stringClassPathName.indexOf("DMXHardware.") >= 0) {
            stringClassPathName = HARDWAREPACKAGENAME + stringClassPathName.substring(12);
        }
        if ((o_DMXHardwareType = s_DMXHardwareTypes.get(stringClassPathName)) != null) {
            return o_DMXHardwareType;
        }
        o_DMXHardwareType = new DMXHardwareType(stringFileName, stringClassPathName);
        return o_DMXHardwareType;
    }

    public static boolean removeDMXHardwareType(DMXHardwareType p_DMXHardwareType) {
        if (p_DMXHardwareType == null) {
            return false;
        }
        return s_DMXHardwareTypes.remove(p_DMXHardwareType.getClassName()) != null;
    }

    public DMXHardwareType(String p_FileName, String p_ClassName) {
        this.initMembers();
        this.m_ClassPathName = p_ClassName;
        this.m_FileName = p_FileName;
        if (p_ClassName.length() <= HARDWAREPACKAGENAME.length() || !p_ClassName.substring(0, HARDWAREPACKAGENAME.length()).equals(HARDWAREPACKAGENAME)) {
            this.m_ClassPathName = HARDWAREPACKAGENAME + p_ClassName;
        }
        if (this.loadHardwareInterface()) {
            DMXHardwareType.addDMXHardwareType(this);
        }
    }

    private void initMembers() {
        this.m_Valid = false;
        this.m_ClassPathName = "";
        this.m_BufferedImage_Logo = null;
        this.m_BufferedImage_Interface = null;
        this.m_HardwareClass = null;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(1);
        out.writeUTF(this.m_ClassPathName);
        out.writeUTF(this.m_FileName);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int intSoftwareVersion = in.readInt();
        this.m_ClassPathName = in.readUTF();
        this.m_FileName = in.readUTF();
    }

    public void close() {
        DMXHardwareType.removeDMXHardwareType(this);
        s_DMXHardwareTypeTreeModel.removeDMXHardwareType(this);
    }

    public String getClassName() {
        return this.m_ClassPathName;
    }

    public String getFileName() {
        return this.m_FileName;
    }

    public String getInterfaceName() {
        return this.m_InterfaceName;
    }

    public boolean equals(Object p_Object) {
        if (p_Object == null) {
            return false;
        }
        if (!(p_Object instanceof DMXHardwareType)) {
            return false;
        }
        DMXHardwareType o_DMXHardwareType = (DMXHardwareType)p_Object;
        return o_DMXHardwareType.getClassName().equals(this.m_ClassPathName);
    }

    public String getManufacturerName() {
        return this.m_ManufacturerName;
    }

    public BufferedImage getImage() {
        return this.m_BufferedImage_Logo;
    }

    public Icon getIconLogo() {
        return this.m_ImageIconLogo;
    }

    public Icon getIconInterface() {
        return this.m_ImageIconInterface;
    }

    public String getText() {
        return this.m_ClassPathName;
    }

    public boolean loadHardwareInterface() {
        Class o_Class;
        if (this.m_Valid) {
            return true;
        }
        this.m_HardwareClass = null;
        this.m_BufferedImage_Logo = null;
        if (this.m_FileName == null || this.m_FileName.length() <= 0) {
            System.err.println(this.m_FileName + "is not a valid HardwareFile");
            return false;
        }
        this.m_JarClassLoader = new JarClassLoader(LiveShowDMXSystem.getFolderHardwareInterfaces() + System.getProperty("file.separator") + this.m_FileName);
        if (!this.m_JarClassLoader.isValid()) {
            return false;
        }
        JarResources o_JarResources = this.m_JarClassLoader.getJarResources();
        ArrayList<String> o_ArrayListClassNames = this.m_JarClassLoader.getClassNames();
        ArrayList<String> o_ArrayListJPGNames = o_JarResources.getResourceNames("jpg");
        ArrayList<String> o_ArrayListGIFNames = o_JarResources.getResourceNames(".gif");
        ArrayList<String> o_ArrayListPNGNames = o_JarResources.getResourceNames("png");
        try {
            o_Class = this.m_JarClassLoader.loadClass(this.m_ClassPathName);
        }
        catch (ClassNotFoundException e_ClassNotFoundException) {
            System.err.println(this.m_FileName + " is not a valid HardwareFile");
            return false;
        }
        try {
            Constructor o_Constructor = o_Class.getConstructor(new Class[0]);
            Method o_Method = o_Class.getDeclaredMethod("staticManufacturerName", new Class[0]);
            if (o_Method != null) {
                this.m_ManufacturerName = (String)o_Method.invoke(null, new Object[0]);
            } else {
                this.m_ManufacturerName = "???";
                System.out.println("DMXHardwareType " + o_Class.getSimpleName() + " does not declare static method staticManufacturerName()");
            }
            o_Method = o_Class.getDeclaredMethod("staticInterfaceName", new Class[0]);
            if (o_Method != null) {
                this.m_InterfaceName = (String)o_Method.invoke(null, new Object[0]);
            } else {
                this.m_InterfaceName = "???";
                System.out.println("DMXHardwareType " + o_Class.getSimpleName() + " does not declare static method staticInterfaceName()");
            }
        }
        catch (Exception e_Exception) {
            System.err.println(this.m_FileName + " is not a valid HardwareFile");
            return false;
        }
        this.m_HardwareClass = o_Class;
        this.m_BufferedImage_Logo = null;
        if (this.m_BufferedImage_Logo == null && o_ArrayListPNGNames != null && o_ArrayListPNGNames.contains("Image/Logo.png")) {
            this.m_BufferedImage_Logo = o_JarResources.getImageResource("Image/Logo.png");
        }
        if (this.m_BufferedImage_Logo == null && o_ArrayListGIFNames != null && o_ArrayListGIFNames.contains("Image/Logo.gif")) {
            this.m_BufferedImage_Logo = o_JarResources.getImageResource("Image/Logo.gif");
        }
        if (this.m_BufferedImage_Logo == null && o_ArrayListJPGNames != null && o_ArrayListJPGNames.contains("Image/Logo.jpg")) {
            this.m_BufferedImage_Logo = o_JarResources.getImageResource("Image/Logo.jpg");
        }
        this.m_BufferedImage_Interface = null;
        if (this.m_BufferedImage_Interface == null && o_ArrayListPNGNames != null && o_ArrayListPNGNames.contains("Image/Interface.png")) {
            this.m_BufferedImage_Interface = o_JarResources.getImageResource("Image/Interface.png");
        }
        if (this.m_BufferedImage_Interface == null && o_ArrayListGIFNames != null && o_ArrayListGIFNames.contains("Image/Interface.gif")) {
            this.m_BufferedImage_Interface = o_JarResources.getImageResource("Image/Interface.gif");
        }
        if (this.m_BufferedImage_Interface == null && o_ArrayListJPGNames != null && o_ArrayListJPGNames.contains("Image/Interface.jpg")) {
            this.m_BufferedImage_Interface = o_JarResources.getImageResource("Image/Logo.jpg");
        }
        this.m_ImageIconLogo = this.m_BufferedImage_Logo != null ? new ImageIcon(this.m_BufferedImage_Logo) : null;
        this.m_ImageIconInterface = this.m_BufferedImage_Interface != null ? new ImageIcon(this.m_BufferedImage_Interface) : null;
        this.m_Valid = true;
        return true;
    }

    public boolean getValid() {
        return this.m_Valid;
    }

    public DMXHardwareInterface createInstanceOfDMXHardwareType() {
        DMXHardwareInterface o_DMXHardwareInterface;
        if (this.m_HardwareClass == null) {
            this.loadHardwareInterface();
            if (this.m_HardwareClass == null) {
                return null;
            }
        }
        try {
            Constructor o_Constructor = this.m_HardwareClass.getConstructor(new Class[0]);
            o_DMXHardwareInterface = (DMXHardwareInterface)o_Constructor.newInstance(new Object[0]);
        }
        catch (Exception e_Exception) {
            System.err.println(this.m_FileName + " is not a valid HardwareFile");
            return null;
        }
        return o_DMXHardwareInterface;
    }

    public static DMXHardwareTypeTreeModel getTreeModel() {
        return s_DMXHardwareTypeTreeModel;
    }

    public static DMXHardwareTypeTreeCellRenderer getTreeCellRenderer() {
        return s_DMXHardwareTypeTreeCellRenderer;
    }

    public static void refreshDMXHardwareTypes() {
        File o_HardwareDirectory = new File(LiveShowDMXSystem.getFolderHardwareInterfaces());
        if (!o_HardwareDirectory.exists()) {
            return;
        }
        if (!o_HardwareDirectory.isDirectory()) {
            return;
        }
        File[] o_HardwareFiles = o_HardwareDirectory.listFiles();
        for (int intFile = 0; intFile < o_HardwareFiles.length; ++intFile) {
            String stringHardwareClassName;
            DMXHardwareType o_DMXHardwareType;
            String stringHardwareFileName;
            File o_HardwareFile = o_HardwareFiles[intFile];
            if (o_HardwareFile.isDirectory() || !(stringHardwareFileName = o_HardwareFile.getName()).endsWith(".jar") || (o_DMXHardwareType = DMXHardwareType.getDMXHardwareType(stringHardwareClassName = HARDWAREPACKAGENAME + stringHardwareFileName.substring(0, stringHardwareFileName.length() - 4))) != null || !(o_DMXHardwareType = new DMXHardwareType(o_HardwareFile.getName(), stringHardwareClassName)).getValid()) continue;
            s_DMXHardwareTypeTreeModel.addDMXHardwareType(o_DMXHardwareType);
        }
    }

    public static class DMXHardwareTypeTreeCellRenderer
    extends JLabel
    implements TreeCellRenderer {
        protected static Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
        protected static Border SELECTION_BORDER = null;
        protected static Color colorChecked = new Color(0, 150, 0);
        protected static Color colorConnected = new Color(150, 150, 0);
        protected static Color colorNotConnected = new Color(150, 0, 0);

        public DMXHardwareTypeTreeCellRenderer() {
            this.initComponents();
        }

        private void initComponents() {
            this.setOpaque(false);
            this.setPreferredSize(new Dimension(250, 25));
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            String stringNodeText;
            Object o_SourceObject = null;
            Color o_Background = tree.getBackground();
            Color o_Foreground = UIManager.getColor("Tree.textForeground");
            if (selected) {
                if (tree.hasFocus()) {
                    o_Foreground = UIManager.getColor("Tree.selectionForeground");
                    o_Background = UIManager.getColor("Tree.selectionBackground");
                } else {
                    o_Foreground = UIManager.getColor("Tree.selectionInactiveForeground");
                    o_Background = UIManager.getColor("Tree.selectionInactiveBackground");
                }
            }
            this.setForeground(o_Foreground);
            this.setBackground(o_Background);
            if (!(value instanceof DMXHardwareTypeTreeNode)) {
                return this;
            }
            o_SourceObject = ((DMXHardwareTypeTreeNode)value).getSourceObject();
            if (o_SourceObject instanceof String) {
                stringNodeText = o_SourceObject;
            } else if (o_SourceObject instanceof DMXHardwareType) {
                DMXHardwareType o_DMXHardwareType = o_SourceObject;
                stringNodeText = o_DMXHardwareType.getInterfaceName();
            } else {
                stringNodeText = "";
            }
            this.setText(stringNodeText);
            return this;
        }
    }

    public static class DMXHardwareTypeTreeModel<TNode extends DMXHardwareTypeTreeNode<?>>
    implements TreeModel {
        private TreeNode m_Root;
        private ArrayList<TreeModelListener> m_TreeModelListeners;
        private final Object m_SyncListeners = new Object();

        public DMXHardwareTypeTreeModel() {
            this.m_Root = new DMXHardwareTypeTreeNode<Object>(null);
            this.m_TreeModelListeners = new ArrayList();
        }

        public boolean addDMXHardwareType(DMXHardwareType p_DMXHardwareType) {
            if (p_DMXHardwareType == null) {
                return false;
            }
            if (!p_DMXHardwareType.getValid()) {
                return false;
            }
            DMXHardwareTypeTreeNode<String> o_ManufactureerTreeNode = null;
            DMXHardwareTypeTreeNode o_Root = (DMXHardwareTypeTreeNode)this.getRoot();
            ArrayList<DMXHardwareTypeTreeNode<?>> o_ManufactureerNodes = o_Root.getChildren();
            for (int intManufactureer = 0; intManufactureer < o_ManufactureerNodes.size(); ++intManufactureer) {
                String stringManufactureer = (String)o_ManufactureerNodes.get(intManufactureer).getSourceObject();
                if (!stringManufactureer.equals(p_DMXHardwareType.getManufacturerName())) continue;
                o_ManufactureerTreeNode = o_ManufactureerNodes.get(intManufactureer);
                ArrayList<DMXHardwareTypeTreeNode<?>> o_DescriptionNodes = o_ManufactureerTreeNode.getChildren();
                for (int intType = 0; intType < o_DescriptionNodes.size(); ++intType) {
                    DMXHardwareTypeTreeNode<?> o_TypeNode = o_DescriptionNodes.get(intType);
                    DMXHardwareType o_DMXHardwareType = (DMXHardwareType)o_TypeNode.getSourceObject();
                    if (!o_DMXHardwareType.equals(p_DMXHardwareType)) continue;
                    return true;
                }
                this.addChild(o_ManufactureerTreeNode, new DMXHardwareTypeTreeNode<DMXHardwareType>(p_DMXHardwareType));
                return true;
            }
            o_ManufactureerTreeNode = new DMXHardwareTypeTreeNode<String>(p_DMXHardwareType.getManufacturerName());
            DMXHardwareTypeTreeNode<DMXHardwareType> o_TypeNode = new DMXHardwareTypeTreeNode<DMXHardwareType>(p_DMXHardwareType);
            this.addChild(o_Root, o_ManufactureerTreeNode);
            this.addChild(o_ManufactureerTreeNode, o_TypeNode);
            return true;
        }

        public boolean removeDMXHardwareType(DMXHardwareType p_DMXHardwareType) {
            if (p_DMXHardwareType == null) {
                return false;
            }
            DMXHardwareTypeTreeNode<?> o_ManufactureerTreeNode = null;
            DMXHardwareTypeTreeNode o_Root = (DMXHardwareTypeTreeNode)this.getRoot();
            ArrayList<DMXHardwareTypeTreeNode<?>> o_ManufactureerNodes = o_Root.getChildren();
            for (int intManufactureer = 0; intManufactureer < o_ManufactureerNodes.size(); ++intManufactureer) {
                ArrayList<DMXHardwareTypeTreeNode<?>> o_DescriptionNodes;
                int intType;
                String stringManufactureer = (String)o_ManufactureerNodes.get(intManufactureer).getSourceObject();
                if (!stringManufactureer.equals(p_DMXHardwareType.getManufacturerName()) || (intType = 0) >= (o_DescriptionNodes = (o_ManufactureerTreeNode = o_ManufactureerNodes.get(intManufactureer)).getChildren()).size()) continue;
                DMXHardwareTypeTreeNode<?> o_TypeNode = o_DescriptionNodes.get(intType);
                DMXHardwareType o_DMXHardwareType = (DMXHardwareType)o_TypeNode.getSourceObject();
                if (o_DMXHardwareType.equals(p_DMXHardwareType)) {
                    this.removeChild(o_ManufactureerTreeNode, new DMXHardwareTypeTreeNode<DMXHardwareType>(p_DMXHardwareType));
                }
                if (o_ManufactureerTreeNode.getChildCount() <= 0) {
                    this.removeChild(o_Root, o_ManufactureerTreeNode);
                }
                return true;
            }
            return false;
        }

        @Override
        public Object getRoot() {
            return this.m_Root;
        }

        public void addChild(TNode parent, TNode p_Child) {
            if (parent == null) {
                return;
            }
            if (p_Child == null) {
                return;
            }
            ((DMXHardwareTypeTreeNode)parent).addChild((DMXHardwareTypeTreeNode<?>)p_Child);
            Object[] o_ParentPathToRoot = (DMXHardwareTypeTreeNode[])this.getPathToRoot(parent);
            int[] o_Indexs = new int[1];
            Object[] o_Childs = new Object[1];
            o_Indexs[0] = ((DMXHardwareTypeTreeNode)parent).getIndex((TreeNode)p_Child);
            o_Childs[0] = p_Child;
            if (o_Indexs[0] != -1) {
                this.fireTreeNodesInserted(this, o_ParentPathToRoot, o_Indexs, o_Childs);
            }
        }

        public void removeChild(TNode p_ParentTreeNode, TNode p_ChildTreeNode) {
            if (p_ParentTreeNode == null) {
                return;
            }
            if (p_ChildTreeNode == null) {
                return;
            }
            int[] o_Indexs = new int[1];
            Object[] o_Childs = new Object[1];
            o_Indexs[0] = ((DMXHardwareTypeTreeNode)p_ParentTreeNode).getIndex((TreeNode)p_ChildTreeNode);
            o_Childs[0] = p_ChildTreeNode;
            if (o_Indexs[0] != -1) {
                Object[] o_ParentPathToRoot = (DMXHardwareTypeTreeNode[])this.getPathToRoot(p_ParentTreeNode);
                ((DMXHardwareTypeTreeNode)p_ParentTreeNode).removeChild((DMXHardwareTypeTreeNode<?>)p_ChildTreeNode);
                this.fireTreeNodesRemoved(this, o_ParentPathToRoot, o_Indexs, o_Childs);
                this.invokeTreeNodeChanged(p_ParentTreeNode);
            }
        }

        public TNode getChild(Object parent, int index) {
            if (parent instanceof DMXHardwareTypeTreeNode) {
                return (TNode)((DMXHardwareTypeTreeNode)parent).getChildAt(index);
            }
            return null;
        }

        @Override
        public int getChildCount(Object parent) {
            if (parent instanceof DMXHardwareTypeTreeNode) {
                return ((DMXHardwareTypeTreeNode)parent).getChildCount();
            }
            return 0;
        }

        @Override
        public boolean isLeaf(Object node) {
            if (node instanceof DMXHardwareTypeTreeNode) {
                return ((DMXHardwareTypeTreeNode)node).isLeaf();
            }
            return true;
        }

        @Override
        public void valueForPathChanged(TreePath path, Object newValue) {
        }

        @Override
        public int getIndexOfChild(Object parent, Object child) {
            if (parent instanceof DMXHardwareTypeTreeNode) {
                return ((DMXHardwareTypeTreeNode)parent).getIndex((DMXHardwareTypeTreeNode)child);
            }
            return 0;
        }

        public ArrayList<TNode> getArrayListPathToRoot(TNode p_HardwareNode) {
            ArrayList<TNode> o_ArrayListPathToRoot = new ArrayList<TNode>();
            for (Object o_TreeNode = p_HardwareNode; o_TreeNode != null; o_TreeNode = ((DMXHardwareTypeTreeNode)o_TreeNode).getParent()) {
                o_ArrayListPathToRoot.add(0, o_TreeNode);
            }
            return o_ArrayListPathToRoot;
        }

        public Object[] getPathToRoot(TNode p_HardwareNode) {
            ArrayList<TNode> o_ArrayListPathToRoot = this.getArrayListPathToRoot(p_HardwareNode);
            Object[] o_PathToRoot = new DMXHardwareTypeTreeNode[o_ArrayListPathToRoot.size()];
            for (int intNode = 0; intNode < o_ArrayListPathToRoot.size(); ++intNode) {
                o_PathToRoot[intNode] = (DMXHardwareTypeTreeNode)o_ArrayListPathToRoot.get(intNode);
            }
            return o_PathToRoot;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addTreeModelListener(TreeModelListener p_TreeModelListener) {
            if (p_TreeModelListener == null) {
                return;
            }
            Object object = this.m_SyncListeners;
            synchronized (object) {
                if (this.m_TreeModelListeners.contains(p_TreeModelListener)) {
                    return;
                }
                this.m_TreeModelListeners.add(p_TreeModelListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeTreeModelListener(TreeModelListener p_TreeModelListener) {
            Object object = this.m_SyncListeners;
            synchronized (object) {
                if (p_TreeModelListener == null) {
                    return;
                }
                this.m_TreeModelListeners.remove(p_TreeModelListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void fireTreeNodesInserted(Object source, Object[] path, int[] childIndices, Object[] children) {
            ArrayList<TreeModelListener> o_Listeners;
            Object object = this.m_SyncListeners;
            synchronized (object) {
                o_Listeners = new ArrayList<TreeModelListener>(this.m_TreeModelListeners.size());
                o_Listeners.addAll(this.m_TreeModelListeners);
            }
            TreeModelEvent e = null;
            for (int i = 0; i < o_Listeners.size(); ++i) {
                if (e == null) {
                    e = new TreeModelEvent(source, path, childIndices, children);
                }
                ((TreeModelListener)o_Listeners.get(i)).treeNodesInserted(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void fireTreeNodesRemoved(Object source, Object[] path, int[] childIndices, Object[] children) {
            ArrayList<TreeModelListener> o_Listeners;
            Object object = this.m_SyncListeners;
            synchronized (object) {
                o_Listeners = new ArrayList<TreeModelListener>(this.m_TreeModelListeners.size());
                o_Listeners.addAll(this.m_TreeModelListeners);
            }
            TreeModelEvent e = null;
            for (int i = 0; i < o_Listeners.size(); ++i) {
                if (e == null) {
                    e = new TreeModelEvent(source, path, childIndices, children);
                }
                ((TreeModelListener)o_Listeners.get(i)).treeNodesRemoved(e);
            }
        }

        private void invokeTreeNodeChanged(TNode p_ChangedTreeNode) {
            if (p_ChangedTreeNode == null) {
                return;
            }
            TreeNode o_ParentNode = ((DMXHardwareTypeTreeNode)p_ChangedTreeNode).getParent();
            if (o_ParentNode == null) {
                if (p_ChangedTreeNode == this.getRoot()) {
                    this.fireTreeNodesChanged(this, this.getPathToRoot(p_ChangedTreeNode), null, null);
                }
            } else {
                int[] o_Indexs = new int[]{((DMXHardwareTypeTreeNode)o_ParentNode).getIndex((TreeNode)p_ChangedTreeNode)};
                if (o_Indexs[0] != -1) {
                    Object[] o_Childs = new Object[]{p_ChangedTreeNode};
                    this.fireTreeNodesChanged(this, this.getPathToRoot(o_ParentNode), o_Indexs, o_Childs);
                }
            }
        }

        public void fireTreeNodeChanged(TreeNode p_ChangedTreeNode) {
            if (p_ChangedTreeNode == null) {
                return;
            }
            this.invokeTreeNodeChanged((DMXHardwareTypeTreeNode)p_ChangedTreeNode);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireTreeNodesChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
            ArrayList<TreeModelListener> o_Listeners;
            Object object = this.m_SyncListeners;
            synchronized (object) {
                o_Listeners = new ArrayList<TreeModelListener>(this.m_TreeModelListeners.size());
                o_Listeners.addAll(this.m_TreeModelListeners);
            }
            TreeModelEvent e = null;
            for (int i = 0; i < o_Listeners.size(); ++i) {
                if (e == null) {
                    e = new TreeModelEvent(source, path, childIndices, children);
                }
                ((TreeModelListener)o_Listeners.get(i)).treeNodesChanged(e);
            }
        }

        public void fireTreeStructureChanged() {
            if (this.m_Root == null) {
                return;
            }
            int[] o_Indexs = new int[1];
            Object[] o_Childs = new Object[1];
            o_Indexs[0] = 0;
            o_Childs[0] = this.m_Root;
            this.fireTreeStructureChanged(this, this.getPathToRoot((DMXHardwareTypeTreeNode)this.m_Root), o_Indexs, o_Childs);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireTreeStructureChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
            ArrayList<TreeModelListener> o_Listeners;
            Object object = this.m_SyncListeners;
            synchronized (object) {
                o_Listeners = new ArrayList<TreeModelListener>(this.m_TreeModelListeners.size());
                o_Listeners.addAll(this.m_TreeModelListeners);
            }
            TreeModelEvent e = null;
            for (int i = 0; i < o_Listeners.size(); ++i) {
                if (e == null) {
                    e = new TreeModelEvent(source, path, childIndices, children);
                }
                ((TreeModelListener)o_Listeners.get(i)).treeStructureChanged(e);
            }
        }
    }

    public static class DMXHardwareTypeTreeNode<T>
    implements TreeNode {
        DMXHardwareTypeTreeNode<?> m_Parent;
        ArrayList<DMXHardwareTypeTreeNode<?>> m_ArrayListChilds = new ArrayList();
        T m_SourceObject;

        public DMXHardwareTypeTreeNode(T p_SourceObject) {
            this.m_SourceObject = p_SourceObject;
        }

        public void addChild(DMXHardwareTypeTreeNode<?> p_Child) {
            if (p_Child == null) {
                return;
            }
            if (this.m_ArrayListChilds.contains(p_Child)) {
                return;
            }
            this.m_ArrayListChilds.add(p_Child);
            p_Child.setParent(this);
        }

        public void removeChild(DMXHardwareTypeTreeNode<?> p_Child) {
            if (p_Child == null) {
                return;
            }
            if (this.m_ArrayListChilds.remove(p_Child)) {
                p_Child.setParent(null);
            }
        }

        @Override
        public DMXHardwareTypeTreeNode<?> getChildAt(int childIndex) {
            if (this.m_ArrayListChilds == null) {
                return null;
            }
            if (childIndex < 0) {
                return null;
            }
            if (childIndex >= this.m_ArrayListChilds.size()) {
                return null;
            }
            return this.m_ArrayListChilds.get(childIndex);
        }

        @Override
        public int getChildCount() {
            if (this.m_ArrayListChilds == null) {
                return 0;
            }
            return this.m_ArrayListChilds.size();
        }

        @Override
        public DMXHardwareTypeTreeNode<?> getParent() {
            return this.m_Parent;
        }

        public void setParent(DMXHardwareTypeTreeNode<?> p_Parent) {
            this.m_Parent = p_Parent;
        }

        @Override
        public int getIndex(TreeNode node) {
            if (node == null) {
                return -1;
            }
            return this.m_ArrayListChilds.indexOf(node);
        }

        @Override
        public boolean getAllowsChildren() {
            return true;
        }

        @Override
        public boolean isLeaf() {
            if (this.m_ArrayListChilds == null) {
                return true;
            }
            return this.m_ArrayListChilds.size() <= 0;
        }

        public Enumeration<DMXHardwareTypeTreeNode<?>> children() {
            return Collections.enumeration(this.m_ArrayListChilds);
        }

        public ArrayList<DMXHardwareTypeTreeNode<?>> getChildren() {
            return this.m_ArrayListChilds;
        }

        public T getSourceObject() {
            return this.m_SourceObject;
        }

        public void setSourceObject(T p_SourceObject) {
            this.m_SourceObject = p_SourceObject;
        }
    }
}

