/*
 * Decompiled with CFR 0.152.
 */
package DMXHardwarePackage;

import DMX512.DMXUniverse;
import DMXHardwarePackage.DMXHardwareFeedbackInterface;
import DMXHardwarePackage.DMXHardwareInterface;
import DMXHardwarePackage.DMXHardwarePluginFeedbackInterface;
import DMXHardwarePackage.DMXHardwarePluginInterface;
import DMXHardwarePackage.DMXHardwareType;
import GUID.LiveGUID;
import LiveShowObjectPackage.LiveShowProjectDescription;
import LiveShowObjectPackage.SinglePropertyChangeSupport;
import LiveShowVirtualPackage.LiveShow_ImportDescription;
import ToolsGraphics.JLabelBackground;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DMXHardware
implements Externalizable,
DMXHardwareFeedbackInterface {
    public static final int SOFTWAREVERSION = 2;
    public static final String FILESUFFIX = ".lsh";
    public static final String PROP_HARDWARECONNECTIONSTATUS = "universeConnectionStatus";
    public static final String PROP_HARDWAREPLUGGEDIN = "universeHardwarePluggedIn";
    public static final String PROP_HARDWAREEXCEPTION = "universeHardwareException";
    protected static DMXHardwareTreeModel s_DMXHardwareTreeModel = new DMXHardwareTreeModel();
    protected static DMXHardwareTreeCellRenderer s_DMXHardwareTreeCellRenderer = new DMXHardwareTreeCellRenderer();
    protected DMXHardwareInterface m_DMXHardwareInterface;
    protected DMXHardwareType m_DMXHardwareType;
    protected String m_ID;
    protected int m_ConnectionStatus;
    protected String m_ConnectionParameters;
    protected DMXHardwareTreeNode m_DMXHardwareTreeNode;
    protected SinglePropertyChangeSupport m_PropertyChangeSupport;

    public DMXHardware() {
        this.initMembers();
    }

    public DMXHardware(DMXHardwareType p_DMXHardwareType) {
        this.initMembers();
        this.m_DMXHardwareType = p_DMXHardwareType;
        this.m_DMXHardwareInterface = DMXHardware.createDMXHardwareInterface(this.m_DMXHardwareType);
        if (this.m_DMXHardwareInterface != null) {
            this.m_DMXHardwareInterface.setID(this.m_ID);
        }
        this.initMembersFurther();
    }

    private void initMembers() {
        this.m_ID = LiveGUID.getUID();
        this.m_ConnectionParameters = "";
        this.m_PropertyChangeSupport = new SinglePropertyChangeSupport(this);
    }

    private void initMembersFurther() {
        if (this.m_DMXHardwareInterface != null) {
            this.m_DMXHardwareTreeNode = new DMXHardwareTreeNode<DMXHardware>(this);
            s_DMXHardwareTreeModel.addChild((DMXHardwareTreeNode)s_DMXHardwareTreeModel.getRoot(), this.m_DMXHardwareTreeNode);
            int intDMXPluginCount = this.m_DMXHardwareInterface.getDMXPluginCount();
            for (int intDMXPlugin = 0; intDMXPlugin < intDMXPluginCount; ++intDMXPlugin) {
                DMXHardwarePluginInterface o_DMXHardwarePluginInterface = this.m_DMXHardwareInterface.getDMXHardwarePlugin(intDMXPlugin);
                DMXHardwareTreeNode<DMXHardwarePluginInterface> o_DMXPluginNode = new DMXHardwareTreeNode<DMXHardwarePluginInterface>(o_DMXHardwarePluginInterface);
                s_DMXHardwareTreeModel.addChild(this.m_DMXHardwareTreeNode, o_DMXPluginNode);
            }
            this.m_DMXHardwareInterface.addDMXHardwareFeedbackInterface((DMXHardwareFeedbackInterface)this);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(2);
        out.writeUTF(this.m_ID);
        this.m_DMXHardwareType.writeExternal(out);
        if (this.m_DMXHardwareInterface != null) {
            out.writeUTF(this.m_DMXHardwareInterface.getConnectionParameters());
            if (this.m_DMXHardwareInterface.getConnectionStatus() == 5 || this.m_DMXHardwareInterface.getConnectionStatus() == 6) {
                out.writeBoolean(true);
            } else {
                out.writeBoolean(false);
            }
        } else {
            out.writeUTF("");
            out.writeBoolean(false);
        }
        ByteArrayOutputStream o_ByteBuffer = new ByteArrayOutputStream();
        o_ByteBuffer.reset();
        ObjectOutputStream o_AdditionalOutput = new ObjectOutputStream(o_ByteBuffer);
        if (this.m_DMXHardwareInterface != null) {
            this.m_DMXHardwareInterface.writeExternal((ObjectOutput)o_AdditionalOutput);
        }
        o_AdditionalOutput.flush();
        o_ByteBuffer.flush();
        int intByteBufferSize = o_ByteBuffer.size();
        out.writeInt(intByteBufferSize);
        out.write(o_ByteBuffer.toByteArray());
        o_AdditionalOutput.close();
        o_ByteBuffer.close();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int longByteCountHardware;
        int intSoftwareVersion = in.readInt();
        this.m_ID = in.readUTF();
        this.m_DMXHardwareType = DMXHardwareType.readDMXHardwareType(in);
        this.m_ConnectionParameters = in.readUTF();
        boolean boolWasConnected = in.readBoolean();
        this.m_DMXHardwareInterface = DMXHardware.createDMXHardwareInterface(this.m_DMXHardwareType);
        if (this.m_DMXHardwareInterface != null) {
            this.m_DMXHardwareInterface.setID(this.m_ID);
        }
        if (intSoftwareVersion >= 2 && (longByteCountHardware = in.readInt()) > 0) {
            if (this.m_DMXHardwareInterface != null) {
                byte[] o_ArrayByte = new byte[longByteCountHardware];
                in.readFully(o_ArrayByte);
                ByteArrayInputStream o_ByteArrayInputStream = new ByteArrayInputStream(o_ArrayByte);
                ObjectInputStream o_AdditionalInput = new ObjectInputStream(o_ByteArrayInputStream);
                this.m_DMXHardwareInterface.readExternal((ObjectInput)o_AdditionalInput);
                o_AdditionalInput.close();
                o_ByteArrayInputStream.close();
            } else {
                in.skip(longByteCountHardware);
            }
        }
        this.initMembersFurther();
        if (boolWasConnected) {
            this.connect();
        }
    }

    public void close() {
        if (this.m_PropertyChangeSupport != null) {
            this.m_PropertyChangeSupport.clear();
        }
        if (this.m_DMXHardwareTreeNode != null) {
            s_DMXHardwareTreeModel.removeChild(this.m_DMXHardwareTreeNode.getParent(), this.m_DMXHardwareTreeNode);
            this.m_DMXHardwareTreeNode = null;
        }
        if (this.m_DMXHardwareInterface != null) {
            this.m_DMXHardwareInterface.removeDMXHardwareFeedbackInterface((DMXHardwareFeedbackInterface)this);
            this.m_DMXHardwareInterface.close();
            this.m_DMXHardwareInterface = null;
        }
        this.m_DMXHardwareType = null;
        this.m_ConnectionParameters = null;
    }

    public void finalize() throws Throwable {
        super.finalize();
        this.m_PropertyChangeSupport = null;
    }

    public void addPropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
        this.m_PropertyChangeSupport.addPropertyChangeListener(p_PropertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
        this.m_PropertyChangeSupport.removePropertyChangeListener(p_PropertyChangeListener);
    }

    public void addPropertyChangeListener(String p_PropertyName, PropertyChangeListener p_PropertyChangeListener) {
        this.m_PropertyChangeSupport.addPropertyChangeListener(p_PropertyName, p_PropertyChangeListener);
    }

    public void removePropertyChangeListener(String p_PropertyName, PropertyChangeListener p_PropertyChangeListener) {
        this.m_PropertyChangeSupport.removePropertyChangeListener(p_PropertyName, p_PropertyChangeListener);
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.m_PropertyChangeSupport.getPropertyChangeListeners();
    }

    public PropertyChangeListener[] getPropertyChangeListeners(String p_PropertyName) {
        return this.m_PropertyChangeSupport.getPropertyChangeListeners(p_PropertyName);
    }

    public boolean hasListeners(String p_PropertyName) {
        return this.m_PropertyChangeSupport.hasListeners(p_PropertyName);
    }

    public String getID() {
        return this.m_ID;
    }

    public DMXHardwareType getDMXHardwareType() {
        return this.m_DMXHardwareType;
    }

    public DMXHardwareInterface getDMXHardwareInterface() {
        return this.m_DMXHardwareInterface;
    }

    public static DMXHardwareInterface createDMXHardwareInterface(DMXHardwareType p_DMXHardwareType) {
        if (p_DMXHardwareType == null) {
            return null;
        }
        DMXHardwareInterface o_DMXHardwareInterface = null;
        o_DMXHardwareInterface = p_DMXHardwareType.createInstanceOfDMXHardwareType();
        return o_DMXHardwareInterface;
    }

    public boolean connect() {
        if (this.m_DMXHardwareInterface == null) {
            return false;
        }
        boolean boolConnected = false;
        if (this.m_DMXHardwareInterface.connect(this.m_ConnectionParameters)) {
            boolConnected = this.m_DMXHardwareInterface.requestCheckHardware();
        }
        return boolConnected;
    }

    public boolean disconnect() {
        if (this.m_DMXHardwareInterface == null) {
            return false;
        }
        return this.m_DMXHardwareInterface.disconnect();
    }

    public DMXHardwareTreeNode getDMXHardwareTreeNode() {
        return this.m_DMXHardwareTreeNode;
    }

    public void eventHardwareConnectionStatus(DMXHardwareInterface p_DMXHardwareInterface, DMXHardwarePluginInterface p_DMXHardwarePluginInterface, int p_ConnectionStatus, String p_Remark) {
        DMXHardwareTreeNode<?> o_PluginNode;
        int intOldValue = 0;
        if (p_ConnectionStatus == 4 && this.m_DMXHardwareInterface != null) {
            this.m_ConnectionParameters = this.m_DMXHardwareInterface.getConnectionParameters();
        }
        if ((o_PluginNode = this.m_DMXHardwareTreeNode.getChild(p_DMXHardwarePluginInterface)) != null) {
            intOldValue = ((DMXHardwarePluginInterface)o_PluginNode.getSourceObject()).getConnectionStatus();
        }
        DMXHardware.s_DMXHardwareTreeModel.invokeTreeNodeChanged(o_PluginNode);
        DMXHardware.s_DMXHardwareTreeModel.invokeTreeNodeChanged(this.m_DMXHardwareTreeNode);
        this.m_PropertyChangeSupport.firePropertyChange(PROP_HARDWARECONNECTIONSTATUS, intOldValue, p_ConnectionStatus);
    }

    public void eventHardwareCheck(DMXHardwareInterface p_DMXHardwareInterface, boolean p_Valid, String p_Remark) {
    }

    public void eventHardwareInfo(DMXHardwareInterface p_DMXHardwareInterface, String p_Info) {
        if (this.m_DMXHardwareTreeNode == null) {
            return;
        }
        DMXHardware.s_DMXHardwareTreeModel.invokeTreeNodeChanged(this.m_DMXHardwareTreeNode);
    }

    public void eventHardwareException(DMXHardwareInterface p_DMXHardwareInterface, int p_ExceptionType, String p_ExceptionString) {
    }

    public void eventHardwarePlugin(DMXHardwareInterface p_DMXHardwareInterface, DMXHardwarePluginInterface p_DMXHardwarePluginInterface, DMXHardwarePluginFeedbackInterface p_OldDMXUniverseFeedbackInterface, DMXHardwarePluginFeedbackInterface p_NewDMXUniverseFeedbackInterface) {
        if (this.m_DMXHardwareTreeNode == null) {
            return;
        }
        DMXHardware.s_DMXHardwareTreeModel.invokeTreeNodeChanged(this.m_DMXHardwareTreeNode);
        DMXHardwareTreeNode<?> o_ChildNode = this.m_DMXHardwareTreeNode.getChild(p_DMXHardwarePluginInterface);
        if (o_ChildNode != null) {
            DMXHardware.s_DMXHardwareTreeModel.invokeTreeNodeChanged(o_ChildNode);
            this.m_PropertyChangeSupport.firePropertyChange(PROP_HARDWAREPLUGGEDIN, p_OldDMXUniverseFeedbackInterface, p_NewDMXUniverseFeedbackInterface);
        }
    }

    public void eventHardwarePluginAdded(DMXHardwareInterface p_DMXHardwareInterface, DMXHardwarePluginInterface p_DMXHardwarePluginInterface) {
        DMXHardwareTreeNode<DMXHardwarePluginInterface> o_DMXPluginNode = new DMXHardwareTreeNode<DMXHardwarePluginInterface>(p_DMXHardwarePluginInterface);
        s_DMXHardwareTreeModel.addChild(this.m_DMXHardwareTreeNode, o_DMXPluginNode);
        DMXHardware.s_DMXHardwareTreeModel.invokeTreeNodeChanged(this.m_DMXHardwareTreeNode);
        this.m_PropertyChangeSupport.firePropertyChange(PROP_HARDWAREPLUGGEDIN, null, p_DMXHardwarePluginInterface);
    }

    public void eventHardwarePluginRemoved(DMXHardwareInterface p_DMXHardwareInterface, DMXHardwarePluginInterface p_DMXHardwarePluginInterface) {
        DMXHardware.s_DMXHardwareTreeModel.invokeTreeNodeChanged(this.m_DMXHardwareTreeNode);
        DMXHardwareTreeNode<?> o_ChildNode = this.m_DMXHardwareTreeNode.getChild(p_DMXHardwarePluginInterface);
        if (o_ChildNode != null) {
            DMXHardware.s_DMXHardwareTreeModel.invokeTreeNodeChanged(o_ChildNode);
            this.m_PropertyChangeSupport.firePropertyChange(PROP_HARDWAREPLUGGEDIN, p_DMXHardwarePluginInterface, null);
            s_DMXHardwareTreeModel.removeChild(this.m_DMXHardwareTreeNode, o_ChildNode);
        }
        DMXHardware.s_DMXHardwareTreeModel.invokeTreeNodeChanged(this.m_DMXHardwareTreeNode);
    }

    public void eventHardwarePluginChanged(DMXHardwareInterface p_DMXHardwareInterface, DMXHardwarePluginInterface p_DMXHardwarePluginInterface) {
        DMXHardware.s_DMXHardwareTreeModel.invokeTreeNodeChanged(this.m_DMXHardwareTreeNode);
        DMXHardwareTreeNode<?> o_ChildNode = this.m_DMXHardwareTreeNode.getChild(p_DMXHardwarePluginInterface);
        if (o_ChildNode != null) {
            DMXHardware.s_DMXHardwareTreeModel.invokeTreeNodeChanged(o_ChildNode);
        }
        DMXHardware.s_DMXHardwareTreeModel.invokeTreeNodeChanged(this.m_DMXHardwareTreeNode);
    }

    public static DMXHardwareTreeModel getTreeModel() {
        return s_DMXHardwareTreeModel;
    }

    public static DMXHardwareTreeCellRenderer getTreeCellRenderer() {
        return s_DMXHardwareTreeCellRenderer;
    }

    public static DMXHardware getDMXHardware(DMXHardwarePluginInterface p_DMXHardwarePluginInterface) {
        if (p_DMXHardwarePluginInterface == null) {
            return null;
        }
        DMXHardwareTreeNode o_ChildNode = s_DMXHardwareTreeModel.getTreeNode(p_DMXHardwarePluginInterface);
        if (o_ChildNode == null) {
            return null;
        }
        return (DMXHardware)((DMXHardwareTreeNode)o_ChildNode.getParent()).getSourceObject();
    }

    public static void addDMXHardware(DMXHardware p_DMXHardware) {
        if (p_DMXHardware == null) {
            return;
        }
        DMXHardwareTreeNode o_Root = (DMXHardwareTreeNode)s_DMXHardwareTreeModel.getRoot();
        ArrayList<DMXHardwareTreeNode<?>> o_Children = o_Root.getChildren();
        for (int intChild = 0; intChild < o_Children.size(); ++intChild) {
            TreeNode o_ChildNode = o_Root.getChildAt(intChild);
            DMXHardware o_DMXHardware = (DMXHardware)((DMXHardwareTreeNode)o_ChildNode).getSourceObject();
            if (!o_DMXHardware.getID().equals(p_DMXHardware.getID())) continue;
            return;
        }
        DMXHardwareTreeNode<DMXHardware> o_DMXHardwareTreeNode = new DMXHardwareTreeNode<DMXHardware>(p_DMXHardware);
        s_DMXHardwareTreeModel.addChild(o_Root, o_DMXHardwareTreeNode);
    }

    public static void removeDMXHardware(DMXHardware p_DMXHardware) {
        if (p_DMXHardware == null) {
            return;
        }
        DMXHardwareTreeNode o_Root = (DMXHardwareTreeNode)s_DMXHardwareTreeModel.getRoot();
        ArrayList<DMXHardwareTreeNode<?>> o_Children = o_Root.getChildren();
        for (int intChild = o_Children.size() - 1; intChild >= 0; --intChild) {
            TreeNode o_ChildNode = o_Root.getChildAt(intChild);
            DMXHardware o_DMXHardware = (DMXHardware)((DMXHardwareTreeNode)o_ChildNode).getSourceObject();
            if (o_DMXHardware != p_DMXHardware) continue;
            p_DMXHardware.close();
            s_DMXHardwareTreeModel.removeChild(o_Root, o_ChildNode);
            return;
        }
    }

    public static ArrayList<DMXHardware> getDMXHardwares() {
        ArrayList<DMXHardware> o_Hardwares = new ArrayList<DMXHardware>();
        DMXHardwareTreeNode o_Root = (DMXHardwareTreeNode)s_DMXHardwareTreeModel.getRoot();
        ArrayList<DMXHardwareTreeNode<?>> o_Children = o_Root.getChildren();
        for (int intChild = 0; intChild < o_Children.size(); ++intChild) {
            o_Hardwares.add((DMXHardware)o_Children.get(intChild).getSourceObject());
        }
        return o_Hardwares;
    }

    public static boolean saveDMXHardwares(LiveShowProjectDescription p_LiveShowProjectDescription) {
        if (p_LiveShowProjectDescription == null) {
            return false;
        }
        String stringFileName = p_LiveShowProjectDescription.getProjectPathName() + FILESUFFIX;
        try {
            File o_File = new File(stringFileName);
            if (o_File.exists()) {
                try {
                    o_File.delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            o_File.createNewFile();
            FileOutputStream o_FileOutputStream = new FileOutputStream(o_File);
            ObjectOutputStream o_ObjectOutput = new ObjectOutputStream(o_FileOutputStream);
            o_ObjectOutput.writeInt(2);
            ArrayList<DMXHardware> o_Hardwares = DMXHardware.getDMXHardwares();
            o_ObjectOutput.writeInt(o_Hardwares.size());
            for (int intHardware = 0; intHardware < o_Hardwares.size(); ++intHardware) {
                DMXHardware o_DMXHardware = o_Hardwares.get(intHardware);
                o_DMXHardware.writeExternal(o_ObjectOutput);
            }
            o_ObjectOutput.close();
            o_FileOutputStream.close();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean deleteDMXHardwares(LiveShowProjectDescription p_LiveShowProjectDescription) {
        if (p_LiveShowProjectDescription == null) {
            return false;
        }
        boolean boolSuccess = false;
        String stringFileName = p_LiveShowProjectDescription.getProjectPathName() + FILESUFFIX;
        File o_File = new File(stringFileName);
        if (o_File.exists()) {
            try {
                boolSuccess = o_File.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return boolSuccess;
    }

    public static boolean loadDMXHardwares(LiveShowProjectDescription p_LiveShowProjectDescription, LiveShow_ImportDescription p_LiveShow_ImportDescription) {
        if (p_LiveShow_ImportDescription == null) {
            return false;
        }
        if (p_LiveShowProjectDescription == null) {
            return false;
        }
        FileInputStream o_FileInputStream = null;
        ObjectInput o_ObjectInput = null;
        if (!p_LiveShow_ImportDescription.getLoadNewProject()) {
            return true;
        }
        String stringFileName = p_LiveShowProjectDescription.getProjectPathName() + FILESUFFIX;
        try {
            File o_File = new File(stringFileName);
            o_FileInputStream = new FileInputStream(o_File);
            o_ObjectInput = new ObjectInputStream(o_FileInputStream);
            int intSoftwareVersion = o_ObjectInput.readInt();
            int intHardwareCount = o_ObjectInput.readInt();
            for (int intHardware = 0; intHardware < intHardwareCount; ++intHardware) {
                DMXHardware o_DMXHardware = new DMXHardware();
                o_DMXHardware.readExternal(o_ObjectInput);
                if (o_DMXHardware.getDMXHardwareInterface() == null) {
                    System.out.println("Error: Cannot find Hardware " + o_DMXHardware.getDMXHardwareType().getFileName());
                    continue;
                }
                DMXHardware.addDMXHardware(o_DMXHardware);
            }
            o_ObjectInput.close();
            o_FileInputStream.close();
        }
        catch (Exception e) {
            try {
                if (o_ObjectInput != null) {
                    o_ObjectInput.close();
                }
                if (o_FileInputStream != null) {
                    o_FileInputStream.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
        return true;
    }

    public void showConfigurationDialog() {
        if (this.m_DMXHardwareInterface == null) {
            return;
        }
        this.m_DMXHardwareInterface.showConfigurationDialog(null);
    }

    public void closeConfigurationDialog() {
        if (this.m_DMXHardwareInterface == null) {
            return;
        }
        this.m_DMXHardwareInterface.closeConfigurationDialog();
    }

    public static void closeConfigurationDialogs() {
        ArrayList<DMXHardware> o_Hardwares = DMXHardware.getDMXHardwares();
        for (int intHardware = 0; intHardware < o_Hardwares.size(); ++intHardware) {
            DMXHardware o_DMXHardware = o_Hardwares.get(intHardware);
            if (o_DMXHardware == null) continue;
            o_DMXHardware.closeConfigurationDialog();
        }
    }

    public static class DMXHardwareTreeCellRenderer
    extends JPanel
    implements TreeCellRenderer {
        private static Border SELECTIONBORDER = new LineBorder(Color.BLUE, 1);
        private JLabel jLabelIcon;
        private JLabelBackground jLabelNode;
        private static Icon s_HardwareInterfaceIcon = new ImageIcon(DMXHardwareTreeCellRenderer.class.getResource("/IconsPackage/DMX_USBPlug.png"));

        public DMXHardwareTreeCellRenderer() {
            this.initComponents();
        }

        private void initComponents() {
            this.setLayout(new GridBagLayout());
            this.setOpaque(false);
            this.jLabelIcon = new JLabel();
            GridBagConstraints o_GridBagConstraints = new GridBagConstraints();
            o_GridBagConstraints.gridx = 0;
            o_GridBagConstraints.gridy = 0;
            o_GridBagConstraints.weighty = 1.0;
            o_GridBagConstraints.fill = 1;
            this.add((Component)this.jLabelIcon, o_GridBagConstraints);
            this.jLabelNode = new JLabelBackground();
            this.jLabelNode.setBackgroundOpaque(true);
            this.jLabelNode.setBackgroundStyle(1);
            this.jLabelNode.setBackgroundGradientAngle(90);
            this.jLabelNode.setMinimumSize(new Dimension(250, 25));
            this.jLabelNode.setPreferredSize(new Dimension(250, 25));
            o_GridBagConstraints = new GridBagConstraints();
            o_GridBagConstraints.gridx = 1;
            o_GridBagConstraints.gridy = 0;
            o_GridBagConstraints.weightx = 1.0;
            o_GridBagConstraints.weighty = 1.0;
            o_GridBagConstraints.fill = 1;
            this.add((Component)this.jLabelNode, o_GridBagConstraints);
            this.setVisible(true);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Color o_Background = tree.getBackground();
            Color o_Foreground = UIManager.getColor("Tree.textForeground");
            if (selected) {
                if (tree.hasFocus()) {
                    o_Foreground = UIManager.getColor("Tree.selectionForeground");
                    o_Background = UIManager.getColor("Tree.selectionBackground");
                } else {
                    o_Foreground = UIManager.getColor("Tree.selectionInactiveForeground");
                    o_Background = UIManager.getColor("Tree.selectionInactiveBackground");
                }
            }
            this.jLabelIcon.setForeground(o_Foreground);
            this.jLabelIcon.setBackground(o_Background);
            this.jLabelNode.setForeground(o_Foreground);
            this.jLabelNode.setBackground(o_Background);
            this.setBorder(null);
            if (!(value instanceof DMXHardwareTreeNode)) {
                return this;
            }
            Object o_SourceObject = ((DMXHardwareTreeNode)value).getSourceObject();
            this.jLabelNode.setIcon(null);
            if (o_SourceObject == null) {
                this.jLabelNode.setText("");
                this.setBorder(null);
            } else if (o_SourceObject instanceof DMXHardware) {
                DMXHardware o_DMXHardware = (DMXHardware)o_SourceObject;
                if (o_DMXHardware == null) {
                    this.jLabelNode.setText("ERROR");
                    return this;
                }
                DMXHardwareInterface o_DMXHardwareInterface = o_DMXHardware.getDMXHardwareInterface();
                this.jLabelNode.setIcon(s_HardwareInterfaceIcon);
                this.jLabelNode.setText(o_DMXHardwareInterface.getInterfaceName());
                if (o_DMXHardwareInterface == null) {
                    this.jLabelNode.setBackgroundGradientColorFrom(DMXHardwareInterface.COLOR_CONNECTIONSTATUS_NOHARDWARE);
                    this.jLabelNode.setBackgroundGradientColorTo(DMXHardwareInterface.COLOR_CONNECTIONSTATUS_NOHARDWARE);
                } else {
                    Color o_ColorStatus;
                    switch (o_DMXHardwareInterface.getConnectionStatus()) {
                        case 2: {
                            o_ColorStatus = DMXHardwareInterface.COLOR_CONNECTIONSTATUS_NOTCONNECTED;
                            break;
                        }
                        case 3: {
                            o_ColorStatus = DMXHardwareInterface.COLOR_CONNECTIONSTATUS_PROGRESS;
                            break;
                        }
                        case 4: {
                            o_ColorStatus = DMXHardwareInterface.COLOR_CONNECTIONSTATUS_CONNECTED;
                            break;
                        }
                        case 5: {
                            o_ColorStatus = DMXHardwareInterface.COLOR_CONNECTIONSTATUS_CHECKED;
                            break;
                        }
                        case 6: {
                            o_ColorStatus = DMXHardwareInterface.COLOR_CONNECTIONSTATUS_SOMECHECKED;
                            break;
                        }
                        default: {
                            o_ColorStatus = DMXHardwareInterface.COLOR_CONNECTIONSTATUS_NOHARDWARE;
                        }
                    }
                    this.jLabelNode.setBackgroundGradientColorFrom(o_ColorStatus);
                    this.jLabelNode.setBackgroundGradientColorTo(o_ColorStatus);
                }
                this.setBorder(null);
            } else if (o_SourceObject instanceof DMXHardwarePluginInterface) {
                Color o_ColorStatus;
                DMXHardwarePluginInterface o_DMXHardwarePluginInterface = (DMXHardwarePluginInterface)o_SourceObject;
                DMXUniverse o_UniverseConnected = (DMXUniverse)o_DMXHardwarePluginInterface.getDMXPluggedInUniverse();
                String stringPluginInfo = o_DMXHardwarePluginInterface.getDMXPluginInfo();
                String stringConnectedUniverse = o_UniverseConnected == null ? "-" : o_UniverseConnected.getName();
                switch (o_DMXHardwarePluginInterface.getConnectionStatus()) {
                    case 2: {
                        o_ColorStatus = DMXHardwareInterface.COLOR_CONNECTIONSTATUS_NOTCONNECTED;
                        break;
                    }
                    case 3: {
                        o_ColorStatus = DMXHardwareInterface.COLOR_CONNECTIONSTATUS_PROGRESS;
                        break;
                    }
                    case 4: {
                        o_ColorStatus = DMXHardwareInterface.COLOR_CONNECTIONSTATUS_CONNECTED;
                        break;
                    }
                    case 5: {
                        o_ColorStatus = DMXHardwareInterface.COLOR_CONNECTIONSTATUS_CHECKED;
                        break;
                    }
                    case 6: {
                        o_ColorStatus = DMXHardwareInterface.COLOR_CONNECTIONSTATUS_SOMECHECKED;
                        break;
                    }
                    default: {
                        o_ColorStatus = DMXHardwareInterface.COLOR_CONNECTIONSTATUS_NOHARDWARE;
                    }
                }
                if (o_DMXHardwarePluginInterface.getDMXPluginType() == 0) {
                    this.jLabelNode.setText(stringPluginInfo + " <- " + stringConnectedUniverse);
                    this.jLabelNode.setBackgroundGradientColorTo(o_ColorStatus);
                    this.jLabelNode.setBackgroundGradientColorFrom(Color.BLACK);
                } else {
                    this.jLabelNode.setText(stringPluginInfo + " -> " + stringConnectedUniverse);
                    this.jLabelNode.setBackgroundGradientColorFrom(o_ColorStatus);
                    this.jLabelNode.setBackgroundGradientColorTo(Color.BLACK);
                }
                if (selected) {
                    this.setBorder(SELECTIONBORDER);
                } else {
                    this.setBorder(null);
                }
            }
            return this;
        }
    }

    public static class DMXHardwareTreeModel<TNode extends DMXHardwareTreeNode<?>>
    implements TreeModel {
        public static final String PROP_DMXHARDWAREREEMODEL_HARDWAREADDED = "dmxhardwaretreemodelHardwareAdded";
        public static final String PROP_DMXHARDWAREREEMODEL_HARDWAREREMOVED = "dmxhardwaretreemodelHardwareRemoved";
        protected TreeNode m_Root;
        protected ArrayList<TreeModelListener> m_TreeModelListeners;
        protected SinglePropertyChangeSupport m_PropertyChangeSupport;
        private final Object m_SyncListeners = new Object();

        public DMXHardwareTreeModel() {
            this.m_PropertyChangeSupport = new SinglePropertyChangeSupport(this);
            this.m_Root = new DMXHardwareTreeNode<Object>(null);
            this.m_TreeModelListeners = new ArrayList();
        }

        @Override
        public Object getRoot() {
            return this.m_Root;
        }

        public void addChild(TNode parent, TNode p_Child) {
            if (parent == null) {
                return;
            }
            if (p_Child == null) {
                return;
            }
            ((DMXHardwareTreeNode)parent).addChild((DMXHardwareTreeNode<?>)p_Child);
            Object[] o_ParentPathToRoot = (DMXHardwareTreeNode[])this.getPathToRoot(parent);
            int[] o_Indexs = new int[1];
            Object[] o_Childs = new Object[1];
            o_Indexs[0] = ((DMXHardwareTreeNode)parent).getIndex((TreeNode)p_Child);
            o_Childs[0] = p_Child;
            if (o_Indexs[0] != -1) {
                this.fireTreeNodesInserted(this, o_ParentPathToRoot, o_Indexs, o_Childs);
            }
            if (parent == this.m_Root) {
                this.m_PropertyChangeSupport.firePropertyChange(PROP_DMXHARDWAREREEMODEL_HARDWAREADDED, null, ((DMXHardwareTreeNode)p_Child).getSourceObject());
            }
        }

        public void addChild(TNode parent, TNode p_Child, int p_Index) {
            if (parent == null) {
                return;
            }
            if (p_Child == null) {
                return;
            }
            ((DMXHardwareTreeNode)parent).addChild((DMXHardwareTreeNode<?>)p_Child, p_Index);
            Object[] o_ParentPathToRoot = (DMXHardwareTreeNode[])this.getPathToRoot(parent);
            int[] o_Indexs = new int[1];
            Object[] o_Childs = new Object[1];
            o_Indexs[0] = ((DMXHardwareTreeNode)parent).getIndex((TreeNode)p_Child);
            o_Childs[0] = p_Child;
            if (o_Indexs[0] != -1) {
                this.fireTreeNodesInserted(this, o_ParentPathToRoot, o_Indexs, o_Childs);
            }
            if (parent == this.m_Root) {
                this.m_PropertyChangeSupport.firePropertyChange(PROP_DMXHARDWAREREEMODEL_HARDWAREADDED, null, ((DMXHardwareTreeNode)p_Child).getSourceObject());
            }
        }

        public void removeChild(TNode p_ParentTreeNode, TNode p_ChildTreeNode) {
            if (p_ParentTreeNode == null) {
                return;
            }
            if (p_ChildTreeNode == null) {
                return;
            }
            int[] o_Indexs = new int[1];
            Object[] o_Childs = new Object[1];
            o_Indexs[0] = ((DMXHardwareTreeNode)p_ParentTreeNode).getIndex((TreeNode)p_ChildTreeNode);
            o_Childs[0] = p_ChildTreeNode;
            if (o_Indexs[0] != -1) {
                Object[] o_ParentPathToRoot = (DMXHardwareTreeNode[])this.getPathToRoot(p_ParentTreeNode);
                ((DMXHardwareTreeNode)p_ParentTreeNode).removeChild((DMXHardwareTreeNode<?>)p_ChildTreeNode);
                this.fireTreeNodesRemoved(this, o_ParentPathToRoot, o_Indexs, o_Childs);
                this.invokeTreeNodeChanged(p_ParentTreeNode);
            }
            if (p_ParentTreeNode == this.m_Root) {
                this.m_PropertyChangeSupport.firePropertyChange(PROP_DMXHARDWAREREEMODEL_HARDWAREREMOVED, ((DMXHardwareTreeNode)p_ChildTreeNode).getSourceObject(), null);
            }
        }

        public DMXHardwarePluginInterface getDMXHardwarePluginInterface(DMXHardware p_DMXHardware, int p_Index) {
            DMXHardwareTreeNode o_HardwareNode = this.getTreeNode(p_DMXHardware);
            if (o_HardwareNode == null) {
                return null;
            }
            TreeNode o_PluginNode = o_HardwareNode.getChildAt(0);
            if (o_PluginNode == null) {
                return null;
            }
            return (DMXHardwarePluginInterface)((DMXHardwareTreeNode)o_PluginNode).getSourceObject();
        }

        public TNode getChild(Object parent, int index) {
            if (parent instanceof DMXHardwareTreeNode) {
                return (TNode)((DMXHardwareTreeNode)parent).getChildAt(index);
            }
            return null;
        }

        public TNode getChild(Object parent, Object p_SourceObject) {
            if (!(parent instanceof DMXHardwareTreeNode)) {
                return null;
            }
            DMXHardwareTreeNode o_ParentNode = (DMXHardwareTreeNode)parent;
            for (int intChild = 0; intChild <= o_ParentNode.getChildCount(); ++intChild) {
                TreeNode o_ChildNode = o_ParentNode.getChildAt(intChild);
                if (((DMXHardwareTreeNode)o_ChildNode).getSourceObject() != p_SourceObject) continue;
                return (TNode)o_ChildNode;
            }
            return null;
        }

        @Override
        public int getChildCount(Object parent) {
            if (parent instanceof DMXHardwareTreeNode) {
                return ((DMXHardwareTreeNode)parent).getChildCount();
            }
            return 0;
        }

        @Override
        public boolean isLeaf(Object node) {
            if (node instanceof DMXHardwareTreeNode) {
                return ((DMXHardwareTreeNode)node).isLeaf();
            }
            return true;
        }

        @Override
        public void valueForPathChanged(TreePath path, Object newValue) {
        }

        @Override
        public int getIndexOfChild(Object parent, Object child) {
            if (parent instanceof DMXHardwareTreeNode) {
                return ((DMXHardwareTreeNode)parent).getIndex((DMXHardwareTreeNode)child);
            }
            return 0;
        }

        public ArrayList<TNode> getArrayListPathToRoot(TNode p_HardwareNode) {
            ArrayList<TNode> o_ArrayListPathToRoot = new ArrayList<TNode>();
            for (Object o_TreeNode = p_HardwareNode; o_TreeNode != null; o_TreeNode = ((DMXHardwareTreeNode)o_TreeNode).getParent()) {
                o_ArrayListPathToRoot.add(0, o_TreeNode);
            }
            return o_ArrayListPathToRoot;
        }

        public Object[] getPathToRoot(TNode p_HardwareNode) {
            ArrayList<TNode> o_ArrayListPathToRoot = this.getArrayListPathToRoot(p_HardwareNode);
            Object[] o_PathToRoot = new DMXHardwareTreeNode[o_ArrayListPathToRoot.size()];
            for (int intNode = 0; intNode < o_ArrayListPathToRoot.size(); ++intNode) {
                o_PathToRoot[intNode] = (DMXHardwareTreeNode)o_ArrayListPathToRoot.get(intNode);
            }
            return o_PathToRoot;
        }

        public TreePath getTreePathToRoot(DMXHardware p_DMXHardware) {
            if (p_DMXHardware == null) {
                return null;
            }
            DMXHardwareTreeNode o_DMXHardwareTreeNode = this.getTreeNode(p_DMXHardware);
            return new TreePath(this.getPathToRoot(o_DMXHardwareTreeNode));
        }

        public TreePath getTreePathToRoot(DMXHardwarePluginInterface p_DMXHardwarePluginInterface) {
            if (p_DMXHardwarePluginInterface == null) {
                return null;
            }
            DMXHardwareTreeNode o_DMXHardwareTreeNode = this.getTreeNode(p_DMXHardwarePluginInterface);
            return new TreePath(this.getPathToRoot(o_DMXHardwareTreeNode));
        }

        public DMXHardwareTreeNode getTreeNode(Object p_SourceObject) {
            if (p_SourceObject == null) {
                return null;
            }
            DMXHardwareTreeNode o_Root = (DMXHardwareTreeNode)this.getRoot();
            ArrayList<DMXHardwareTreeNode<?>> o_HardwareNodes = o_Root.getChildren();
            if (o_HardwareNodes == null) {
                return null;
            }
            for (int intHardware = 0; intHardware < o_HardwareNodes.size(); ++intHardware) {
                DMXHardwareTreeNode<?> o_HardwareNode = o_HardwareNodes.get(intHardware);
                if (o_HardwareNode.getSourceObject() == p_SourceObject) {
                    return o_HardwareNode;
                }
                ArrayList<DMXHardwareTreeNode<?>> o_HardwanPluginNodes = o_HardwareNode.getChildren();
                for (int intOutput = 0; intOutput < o_HardwanPluginNodes.size(); ++intOutput) {
                    if (o_HardwanPluginNodes.get(intOutput).getSourceObject() != p_SourceObject) continue;
                    return o_HardwanPluginNodes.get(intOutput);
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addTreeModelListener(TreeModelListener p_TreeModelListener) {
            if (p_TreeModelListener == null) {
                return;
            }
            Object object = this.m_SyncListeners;
            synchronized (object) {
                if (this.m_TreeModelListeners.contains(p_TreeModelListener)) {
                    return;
                }
                this.m_TreeModelListeners.add(p_TreeModelListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeTreeModelListener(TreeModelListener p_TreeModelListener) {
            Object object = this.m_SyncListeners;
            synchronized (object) {
                if (p_TreeModelListener == null) {
                    return;
                }
                this.m_TreeModelListeners.remove(p_TreeModelListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void fireTreeNodesInserted(Object source, Object[] path, int[] childIndices, Object[] children) {
            ArrayList<TreeModelListener> o_Listeners;
            Object object = this.m_SyncListeners;
            synchronized (object) {
                o_Listeners = new ArrayList<TreeModelListener>(this.m_TreeModelListeners.size());
                o_Listeners.addAll(this.m_TreeModelListeners);
            }
            TreeModelEvent e = null;
            for (int i = 0; i < o_Listeners.size(); ++i) {
                if (e == null) {
                    e = new TreeModelEvent(source, path, childIndices, children);
                }
                ((TreeModelListener)o_Listeners.get(i)).treeNodesInserted(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void fireTreeNodesRemoved(Object source, Object[] path, int[] childIndices, Object[] children) {
            ArrayList<TreeModelListener> o_Listeners;
            Object object = this.m_SyncListeners;
            synchronized (object) {
                o_Listeners = new ArrayList<TreeModelListener>(this.m_TreeModelListeners.size());
                o_Listeners.addAll(this.m_TreeModelListeners);
            }
            TreeModelEvent e = null;
            for (int i = 0; i < o_Listeners.size(); ++i) {
                if (e == null) {
                    e = new TreeModelEvent(source, path, childIndices, children);
                }
                ((TreeModelListener)o_Listeners.get(i)).treeNodesRemoved(e);
            }
        }

        private void invokeTreeNodeChanged(TNode p_ChangedTreeNode) {
            if (p_ChangedTreeNode == null) {
                return;
            }
            TreeNode o_ParentNode = ((DMXHardwareTreeNode)p_ChangedTreeNode).getParent();
            if (o_ParentNode == null) {
                if (p_ChangedTreeNode == this.getRoot()) {
                    this.fireTreeNodesChanged(this, this.getPathToRoot(p_ChangedTreeNode), null, null);
                }
            } else {
                int[] o_Indexs = new int[]{((DMXHardwareTreeNode)o_ParentNode).getIndex((TreeNode)p_ChangedTreeNode)};
                if (o_Indexs[0] != -1) {
                    Object[] o_Childs = new Object[]{p_ChangedTreeNode};
                    this.fireTreeNodesChanged(this, this.getPathToRoot(o_ParentNode), o_Indexs, o_Childs);
                }
            }
        }

        public void fireTreeNodeChanged(TreeNode p_ChangedTreeNode) {
            if (p_ChangedTreeNode == null) {
                return;
            }
            this.invokeTreeNodeChanged((DMXHardwareTreeNode)p_ChangedTreeNode);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireTreeNodesChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
            ArrayList<TreeModelListener> o_Listeners;
            Object object = this.m_SyncListeners;
            synchronized (object) {
                o_Listeners = new ArrayList<TreeModelListener>(this.m_TreeModelListeners.size());
                o_Listeners.addAll(this.m_TreeModelListeners);
            }
            TreeModelEvent e = null;
            for (int i = 0; i < o_Listeners.size(); ++i) {
                if (e == null) {
                    e = new TreeModelEvent(source, path, childIndices, children);
                }
                ((TreeModelListener)o_Listeners.get(i)).treeNodesChanged(e);
            }
        }

        public void fireTreeStructureChanged() {
            if (this.m_Root == null) {
                return;
            }
            int[] o_Indexs = new int[1];
            Object[] o_Childs = new Object[1];
            o_Indexs[0] = 0;
            o_Childs[0] = this.m_Root;
            this.fireTreeStructureChanged(this, this.getPathToRoot((DMXHardwareTreeNode)this.m_Root), o_Indexs, o_Childs);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireTreeStructureChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
            ArrayList<TreeModelListener> o_Listeners;
            Object object = this.m_SyncListeners;
            synchronized (object) {
                o_Listeners = new ArrayList<TreeModelListener>(this.m_TreeModelListeners.size());
                o_Listeners.addAll(this.m_TreeModelListeners);
            }
            TreeModelEvent e = null;
            for (int i = 0; i < o_Listeners.size(); ++i) {
                if (e == null) {
                    e = new TreeModelEvent(source, path, childIndices, children);
                }
                ((TreeModelListener)o_Listeners.get(i)).treeStructureChanged(e);
            }
        }

        public DMXHardwareInterface getDMXHardwareInterface(String p_ID) {
            DMXHardwareInterface o_DMXHardwareInterface = null;
            DMXHardwareTreeNode o_Root = (DMXHardwareTreeNode)this.getRoot();
            ArrayList<DMXHardwareTreeNode<?>> o_HardwareNodes = o_Root.getChildren();
            if (o_HardwareNodes == null) {
                return null;
            }
            for (int intHardware = 0; intHardware < o_HardwareNodes.size(); ++intHardware) {
                if (!((DMXHardware)o_HardwareNodes.get(intHardware).getSourceObject()).getID().equals(p_ID)) continue;
                DMXHardware o_DMXHardware = (DMXHardware)o_HardwareNodes.get(intHardware).getSourceObject();
                o_DMXHardwareInterface = o_DMXHardware.getDMXHardwareInterface();
                break;
            }
            return o_DMXHardwareInterface;
        }

        public DMXHardware getDMXHardware(DMXHardwareInterface p_DMXHardwareInterface) {
            DMXHardware o_DMXHardware = null;
            DMXHardwareTreeNode o_Root = (DMXHardwareTreeNode)this.getRoot();
            ArrayList<DMXHardwareTreeNode<?>> o_Hardwares = o_Root.getChildren();
            if (o_Hardwares == null) {
                return null;
            }
            for (int intHardware = 0; intHardware < o_Hardwares.size(); ++intHardware) {
                if (((DMXHardware)o_Hardwares.get(intHardware).getSourceObject()).getDMXHardwareInterface() != p_DMXHardwareInterface) continue;
                o_DMXHardware = (DMXHardware)o_Hardwares.get(intHardware).getSourceObject();
                break;
            }
            return o_DMXHardware;
        }

        public void addPropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
            this.m_PropertyChangeSupport.addPropertyChangeListener(p_PropertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
            this.m_PropertyChangeSupport.removePropertyChangeListener(p_PropertyChangeListener);
        }

        public void addPropertyChangeListener(String p_PropertyName, PropertyChangeListener p_PropertyChangeListener) {
            this.m_PropertyChangeSupport.addPropertyChangeListener(p_PropertyName, p_PropertyChangeListener);
        }

        public void removePropertyChangeListener(String p_PropertyName, PropertyChangeListener p_PropertyChangeListener) {
            this.m_PropertyChangeSupport.removePropertyChangeListener(p_PropertyName, p_PropertyChangeListener);
        }

        public PropertyChangeListener[] getPropertyChangeListeners() {
            return this.m_PropertyChangeSupport.getPropertyChangeListeners();
        }

        public PropertyChangeListener[] getPropertyChangeListeners(String p_PropertyName) {
            return this.m_PropertyChangeSupport.getPropertyChangeListeners(p_PropertyName);
        }

        public boolean hasListeners(String p_PropertyName) {
            return this.m_PropertyChangeSupport.hasListeners(p_PropertyName);
        }
    }

    public static class DMXHardwareTreeNode<T>
    implements TreeNode {
        protected DMXHardwareTreeNode<?> m_Parent;
        protected ArrayList<DMXHardwareTreeNode<?>> m_ArrayListChilds = new ArrayList();
        protected T m_SourceObject;

        public DMXHardwareTreeNode(T p_SourceObject) {
            this.m_SourceObject = p_SourceObject;
        }

        public void addChild(DMXHardwareTreeNode<?> p_Child) {
            if (p_Child == null) {
                return;
            }
            if (this.m_ArrayListChilds.contains(p_Child)) {
                return;
            }
            if (p_Child.getSourceObject() instanceof DMXHardwarePluginInterface) {
                String stringOldSourceInfo;
                DMXHardwareTreeNode<?> o_Child;
                int intChild = 0;
                String stringNewSourceInfo = ((DMXHardwarePluginInterface)p_Child.getSourceObject()).getDMXPluginInfo();
                for (intChild = 0; intChild < this.m_ArrayListChilds.size() && ((o_Child = this.m_ArrayListChilds.get(intChild)) == null || stringNewSourceInfo.compareToIgnoreCase(stringOldSourceInfo = ((DMXHardwarePluginInterface)o_Child.getSourceObject()).getDMXPluginInfo()) >= 0); ++intChild) {
                }
                this.m_ArrayListChilds.add(intChild, p_Child);
            } else {
                this.m_ArrayListChilds.add(p_Child);
            }
            p_Child.setParent(this);
        }

        public void addChild(DMXHardwareTreeNode<?> p_Child, int p_Index) {
            if (p_Child == null) {
                return;
            }
            if (this.m_ArrayListChilds.contains(p_Child)) {
                return;
            }
            if (p_Index < 0) {
                boolean intIndex = false;
            } else if (p_Index > this.m_ArrayListChilds.size()) {
                int n = this.m_ArrayListChilds.size();
            }
            this.m_ArrayListChilds.add(p_Index, p_Child);
            p_Child.setParent(this);
        }

        public void removeChild(DMXHardwareTreeNode<?> p_Child) {
            if (p_Child == null) {
                return;
            }
            if (this.m_ArrayListChilds.remove(p_Child)) {
                p_Child.setParent(null);
            }
        }

        @Override
        public DMXHardwareTreeNode<?> getChildAt(int childIndex) {
            if (this.m_ArrayListChilds == null) {
                return null;
            }
            if (childIndex < 0) {
                return null;
            }
            if (childIndex >= this.m_ArrayListChilds.size()) {
                return null;
            }
            return this.m_ArrayListChilds.get(childIndex);
        }

        @Override
        public int getChildCount() {
            if (this.m_ArrayListChilds == null) {
                return 0;
            }
            return this.m_ArrayListChilds.size();
        }

        public DMXHardwareTreeNode<?> getChild(Object p_Value) {
            if (this.m_ArrayListChilds == null) {
                return null;
            }
            for (int intChild = 0; intChild < this.m_ArrayListChilds.size(); ++intChild) {
                DMXHardwareTreeNode<?> o_ChildNode = this.m_ArrayListChilds.get(intChild);
                if (o_ChildNode.getSourceObject() != p_Value) continue;
                return o_ChildNode;
            }
            return null;
        }

        @Override
        public DMXHardwareTreeNode<?> getParent() {
            return this.m_Parent;
        }

        public void setParent(DMXHardwareTreeNode<?> p_Parent) {
            this.m_Parent = p_Parent;
        }

        @Override
        public int getIndex(TreeNode node) {
            if (node == null) {
                return -1;
            }
            return this.m_ArrayListChilds.indexOf(node);
        }

        @Override
        public boolean getAllowsChildren() {
            return true;
        }

        @Override
        public boolean isLeaf() {
            if (this.m_ArrayListChilds == null) {
                return true;
            }
            return this.m_ArrayListChilds.size() <= 0;
        }

        public Enumeration<DMXHardwareTreeNode<?>> children() {
            return Collections.enumeration(this.m_ArrayListChilds);
        }

        public ArrayList<DMXHardwareTreeNode<?>> getChildren() {
            return this.m_ArrayListChilds;
        }

        public T getSourceObject() {
            return this.m_SourceObject;
        }

        public void setSourceObject(T p_SourceObject) {
            this.m_SourceObject = p_SourceObject;
        }
    }
}

