/*
 * Decompiled with CFR 0.152.
 */
package DMXGraphics;

import DMX512.DMXUniverse;
import DMXDevicePackage.DMXDevice;
import DMXDevicePackage.DMXDeviceFilter;
import DMXDevicePackage.DMXDeviceFunctionPanel;
import DMXDevicePackage.DMXDeviceGroup;
import DMXDevicePackage.DMXDeviceGroupPanel;
import DMXDevicePackage.DMXDeviceType;
import DMXDevicePackage.DMXDeviceView;
import DMXEffectsPackage.DMXEffect;
import DMXGraphics.LiveShowDMXDeviceSettings;
import DMXGraphics.LiveShowDMXDeviceTracking;
import DMXGraphics.LiveShowDMXDeviceTypeSelection;
import DMXGraphics.LiveShowDMXSceneView;
import DMXHardwarePackage.DMXPowerSource;
import DMXMixer.DMXControlComponent;
import DMXMixer.DMXMixerPanel;
import DMXScenePackage.DMXScene;
import DMXScenePackage.DMXSceneFilter;
import DMXVirtualPackage.LiveShowDMXObject;
import DMXVirtualPackage.LiveShowDMXObjectDescription;
import DMXVirtualPackage.LiveShowDMXVIP;
import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LanguageTools.LiveLanguagePackage.LiveLanguageString;
import LiveShowObjectPackage.LiveShowObject;
import LiveShowObjectPackage.LiveShowObjectInterface;
import LiveShowObjectPackage.LiveShowProjectDescription;
import LiveShowPlayPackage.PlaySceneBridgePanel;
import LiveShowVirtualPackage.LiveShowSceneBridge;
import LiveShowVirtualPackage.LiveShowVIP;
import LiveShowVirtualPackage.LiveShowVIPListener;
import LiveShowVirtualPackage.LiveShowVIPTrack;
import StartPackage.LiveShowDMXSystem;
import SwingFramePackage.JOptionDialog;
import SwingModelPackage.TableAndListModel;
import SwingTextPackage.DocumentFilter_Integer;
import SwingToolTipPackage.PopUpToolTip;
import SynchronizationPackage.EventQueueHandler;
import Text.Export_HTML;
import ToolsGraphics.JLabel_ResizeFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.print.PrintService;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableRowSorter;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class LiveShowDMXStageView
extends JPanel
implements LiveShowVIPListener,
ListSelectionListener,
PropertyChangeListener {
    public static final double s_ZoomChangeFactor = 1.2;
    @LiveLanguageString
    public static String TOOLTIP_TAB_DEVICES = "Device View";
    @LiveLanguageString
    public static String TOOLTIP_TAB_TABLE0 = "Table View";
    @LiveLanguageString
    public static String DELETE_SELECTEDDEVICES = "<html>Deleting of devices cannot be reversed.<br>Do you really want to delete the selected devices?</html>";
    @LiveLanguageString
    public static String DELETESELECTEDDEVICSES_TITEL = "Delete selected devices";
    @LiveLanguageString
    public static String XLS_COLUMNNAME_DMXCONTROL = "DMXControl";
    @LiveLanguageString
    public static String XLS_COLUMNNAME_CONTROL = "Control";
    @LiveLanguageString
    public static String XLS_COLUMNNAME_DIMENSION = "Dimension";
    @LiveLanguageString
    public static String XLS_COLUMNNAME_CONSUMPTIONDURATION = "Consumption/Duration";
    private static ArrayList<DMXDeviceView> s_DMXDeviceViews = new ArrayList();
    private static final Object s_SyncDMXDeviceViews = new Object();
    public static Border s_BorderButtonNormal = new EmptyBorder(1, 1, 1, 1);
    public static Border s_BorderFilterActive = new LineBorder(Color.GREEN, 1);
    public static Border s_BorderFilterActiveInverted = new LineBorder(Color.RED, 1);
    public static int GRID_MAXWIDTH = 100;
    public static int s_GridWidth = 5;
    public static boolean s_GridEnabled = true;
    private LiveShowDMXVIP m_LiveShowDMXVIP;
    private ArrayList<DMXDevice> m_SelectedDMXDevices;
    private static final Object s_SyncSelectedDMXDevices = new Object();
    private TableAndListModel.ListModelWrapper<DMXDeviceFilter> m_DMXDeviceFilterListModelWrapper;
    private DMXDeviceFilter m_SelectedDMXDeviceFilter;
    private ListSelectionModel m_SelectionModel;
    private double m_Zoom;
    private static ArrayList<DMXDeviceView> s_ExternalMouseDeviceViews = new ArrayList();
    private static Object s_ExternalMouseFirstView = null;
    private static boolean s_ExternalMouseFirstWasSelected = false;
    private Integer m_ExternalMouseLastX;
    private Integer m_ExternalMouseLastY;
    private Runnable m_RunnableRepaint = new Runnable(){

        @Override
        public void run() {
            LiveShowDMXStageView.this.repaint();
        }
    };
    private static ArrayList<LiveShowDMXStageViewListener> s_StageViewListeners;
    public static final Object s_SyncStageViewListener;
    public static LiveShowDMXStageView s_SelfReference;
    private boolean m_ListValueChangedIsAdjusting;
    private DMXDeviceFunctionPanel dMXDeviceFunctionPanel1;
    private DMXMixerPanel dMXMixerPanel_Stage;
    private JButton jButton_AddDevice;
    private JButton jButton_DMXSceneFilter;
    private JButton jButton_DeleteDevice;
    private JButton jButton_DeviceSettings;
    private JButton jButton_DeviceTracking;
    private JButton jButton_Export;
    private JButton jButton_InvertDMXDeviceFilter;
    private JButton jButton_ShowDMXDeviceGroups;
    private JButton jButton_ShowInTimeline;
    private JButton jButton_ZoomMinus;
    private JButton jButton_ZoomNull;
    private JButton jButton_ZoomPlus;
    private JCheckBox jCheckBox_EnableGrid;
    private JComboBox jComboBox_DMXDeviceFilter;
    private JLabel jLabel1;
    private JLabel_ResizeFrame jLabel_ResizeFrame1;
    private JPanel jPanelGrid;
    private JPanel jPanel_DeviceControlView;
    private JPanel jPanel_DeviceTableParent;
    private JPanel jPanel_Devices;
    private JPanel jPanel_StageView;
    private JPanel jPanel_StageViewParent;
    private JPanel jPanel_Zoom;
    private JScrollPane jScrollPane_DeviceTable;
    private JScrollPane jScrollPane_StageView;
    private JSplitPane jSplitPane_StageView;
    private JTabbedPane jTabbedPane1;
    private JTable jTable_Device;
    private JTextField jTextField_FindFilter;
    private JTextField jTextField_GridWidth;
    private PlaySceneBridgePanel playSceneBridgePanel1;

    public LiveShowDMXStageView() {
        this.initMembers();
        this.initComponents();
        this.initComponentsFurther();
        LiveLanguage.addLanguageListener((Object)this, null);
        this.jTabbedPane1.setToolTipTextAt(0, TOOLTIP_TAB_DEVICES);
        this.jTabbedPane1.setToolTipTextAt(1, TOOLTIP_TAB_TABLE0);
    }

    private void initMembers() {
        s_SelfReference = this;
        this.m_Zoom = 1.0;
        this.m_DMXDeviceFilterListModelWrapper = DMXDeviceFilter.getListModel().createListModelWrapper();
        this.m_SelectedDMXDevices = new ArrayList();
        this.m_SelectedDMXDeviceFilter = null;
        this.m_ListValueChangedIsAdjusting = false;
        this.m_ExternalMouseLastX = null;
        this.m_ExternalMouseLastY = null;
        s_StageViewListeners = new ArrayList();
    }

    public void setLiveShowDMXVip(LiveShowDMXVIP p_LiveShowDMXVIP) {
        if (this.m_LiveShowDMXVIP == p_LiveShowDMXVIP) {
            return;
        }
        if (this.m_LiveShowDMXVIP != null) {
            this.m_LiveShowDMXVIP.removeLiveShowVIPListener(this);
        }
        this.m_LiveShowDMXVIP = p_LiveShowDMXVIP;
        if (this.m_LiveShowDMXVIP != null) {
            this.m_LiveShowDMXVIP.addLiveShowVIPListener(this);
            if (!this.m_LiveShowDMXVIP.getEditModeOn()) {
                // empty if block
            }
        }
        this.playSceneBridgePanel1.setLiveShowVIP(p_LiveShowDMXVIP);
    }

    public JLabel_ResizeFrame getLabel_ResizeFrame() {
        return this.jLabel_ResizeFrame1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addDMXDevice(DMXDevice p_DMXDevice) {
        if (p_DMXDevice == null) {
            return false;
        }
        boolean boolAdded = false;
        DMXDeviceView o_DMXDeviceView = new DMXDeviceView(this);
        o_DMXDeviceView.setDMXDevice(p_DMXDevice);
        Object object = s_SyncDMXDeviceViews;
        synchronized (object) {
            s_DMXDeviceViews.add(o_DMXDeviceView);
        }
        LiveShowDMXStageView.notifyDMXDeviceViewAdded(o_DMXDeviceView);
        boolAdded = DMXDevice.addDMXDevice(p_DMXDevice);
        this.dMXDeviceFunctionPanel1.addDMXDevice(p_DMXDevice);
        p_DMXDevice.addPropertyChangeListener("dmxdeviceUniverse", this);
        this.filterDMXDevices();
        return boolAdded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addDMXDevice(DMXDevice p_DMXDevice, int p_Index) {
        if (p_DMXDevice == null) {
            return false;
        }
        boolean boolAdded = false;
        DMXDeviceView o_DMXDeviceView = new DMXDeviceView(this);
        o_DMXDeviceView.setDMXDevice(p_DMXDevice);
        Object object = s_SyncDMXDeviceViews;
        synchronized (object) {
            s_DMXDeviceViews.add(o_DMXDeviceView);
        }
        LiveShowDMXStageView.notifyDMXDeviceViewAdded(o_DMXDeviceView);
        boolAdded = DMXDevice.addDMXDevice(p_DMXDevice);
        this.dMXDeviceFunctionPanel1.addDMXDevice(p_DMXDevice);
        p_DMXDevice.addPropertyChangeListener("dmxdeviceUniverse", this);
        this.filterDMXDevices();
        this.jScrollPane_StageView.getHorizontalScrollBar().getValue();
        this.jScrollPane_StageView.getVerticalScrollBar().getValue();
        int intWidth = s_GridEnabled && s_GridWidth > 0 ? (o_DMXDeviceView.getNormWidth() / s_GridWidth + 1) * s_GridWidth : o_DMXDeviceView.getNormWidth() + 1;
        o_DMXDeviceView.setNormPosition((int)((double)(-this.jPanel_StageView.getX()) / this.m_Zoom + (double)(p_Index * intWidth)), (int)((double)(-this.jPanel_StageView.getY()) / this.m_Zoom));
        return boolAdded;
    }

    public boolean removeDMXDevice(DMXDevice p_DMXDevice) {
        if (p_DMXDevice == null) {
            return false;
        }
        boolean boolRemoved = false;
        p_DMXDevice.removePropertyChangeListener("dmxdeviceUniverse", this);
        this.dMXDeviceFunctionPanel1.removeDMXDevice(p_DMXDevice);
        DMXDeviceView o_DMXDeviceView = LiveShowDMXStageView.findDMXDeviceView(p_DMXDevice);
        if (o_DMXDeviceView == null) {
            return boolRemoved;
        }
        this.removeSelectedDMXDevice(p_DMXDevice);
        boolRemoved = this.removeDMXDeviceView(o_DMXDeviceView);
        this.filterDMXDevices();
        return boolRemoved;
    }

    public static void setGridEnabled(boolean p_Enabled) {
        if (s_GridEnabled == p_Enabled) {
            return;
        }
        s_GridEnabled = p_Enabled;
        if (s_SelfReference != null) {
            s_SelfReference.refreshUI();
        }
    }

    public static void setGridWidth(int p_GridWidth) {
        if (p_GridWidth < 0) {
            return;
        }
        if (s_GridWidth == p_GridWidth) {
            return;
        }
        s_GridWidth = p_GridWidth;
        if (s_GridWidth < 1) {
            s_GridWidth = 1;
        }
        if (s_GridWidth > GRID_MAXWIDTH) {
            s_GridWidth = GRID_MAXWIDTH;
        }
        if (s_SelfReference != null) {
            s_SelfReference.refreshUI();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Point movePosition_DMXDeviceViews(final DMXDeviceView p_Actor, boolean p_AllSelected, Point p_NormPosition_DragStart, int p_DiffX, int p_DiffY) {
        Point o_Point_Diff = new Point(0, 0);
        if (p_Actor == null) {
            return o_Point_Diff;
        }
        int intOldNormPosX = p_NormPosition_DragStart.x - p_Actor.getNormPositionX();
        int intOldNormPosY = p_NormPosition_DragStart.y - p_Actor.getNormPositionY();
        double doubleNormDiffX = (double)p_DiffX / this.m_Zoom + (double)intOldNormPosX;
        double doubleNormDiffY = (double)p_DiffY / this.m_Zoom + (double)intOldNormPosY;
        if (s_GridEnabled && s_GridWidth > 0) {
            int intActualGrid = (int)((double)p_Actor.getNormPositionX() / (double)s_GridWidth + 0.5) * s_GridWidth;
            doubleNormDiffX = doubleNormDiffX > 0.0 ? ((double)p_Actor.getNormPositionX() + doubleNormDiffX > (double)(intActualGrid + s_GridWidth) ? (double)(intActualGrid + s_GridWidth - p_Actor.getNormPositionX()) : 0.0) : ((double)p_Actor.getNormPositionX() + doubleNormDiffX < (double)(intActualGrid - s_GridWidth) ? (double)(intActualGrid - s_GridWidth - p_Actor.getNormPositionX()) : 0.0);
            intActualGrid = (int)((double)p_Actor.getNormPositionY() / (double)s_GridWidth + 0.5) * s_GridWidth;
            doubleNormDiffY = doubleNormDiffY > 0.0 ? ((double)p_Actor.getNormPositionY() + doubleNormDiffY > (double)(intActualGrid + s_GridWidth) ? (double)(intActualGrid + s_GridWidth - p_Actor.getNormPositionY()) : 0.0) : ((double)p_Actor.getNormPositionY() + doubleNormDiffY < (double)(intActualGrid - s_GridWidth) ? (double)(intActualGrid - s_GridWidth - p_Actor.getNormPositionY()) : 0.0);
        }
        Object object = s_SyncDMXDeviceViews;
        synchronized (object) {
            if (p_AllSelected) {
                DMXDeviceView o_DMXDeviceView;
                int intDMXDeviceView;
                for (intDMXDeviceView = 0; intDMXDeviceView < s_DMXDeviceViews.size(); ++intDMXDeviceView) {
                    o_DMXDeviceView = s_DMXDeviceViews.get(intDMXDeviceView);
                    if (!o_DMXDeviceView.getSelected()) continue;
                    if ((double)o_DMXDeviceView.getNormPositionX() + doubleNormDiffX < 0.0) {
                        doubleNormDiffX = -o_DMXDeviceView.getNormPositionX();
                    }
                    if (!((double)o_DMXDeviceView.getNormPositionY() + doubleNormDiffY < 0.0)) continue;
                    doubleNormDiffY = -o_DMXDeviceView.getNormPositionY();
                }
                for (intDMXDeviceView = 0; intDMXDeviceView < s_DMXDeviceViews.size(); ++intDMXDeviceView) {
                    o_DMXDeviceView = s_DMXDeviceViews.get(intDMXDeviceView);
                    if (!o_DMXDeviceView.getSelected()) continue;
                    o_DMXDeviceView.setNormPosition((int)((double)o_DMXDeviceView.getNormPositionX() + doubleNormDiffX), (int)((double)o_DMXDeviceView.getNormPositionY() + doubleNormDiffY));
                }
            } else {
                p_Actor.setNormPosition((int)((double)p_Actor.getNormPositionX() + doubleNormDiffX), (int)((double)p_Actor.getNormPositionY() + doubleNormDiffY));
            }
            o_Point_Diff.setLocation(p_Actor.getNormPositionX() - intOldNormPosX, p_Actor.getNormPositionY() - intOldNormPosY);
            EventQueueHandler.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if ((double)p_Actor.getNormPositionX() * LiveShowDMXStageView.this.m_Zoom < (double)LiveShowDMXStageView.this.jScrollPane_StageView.getHorizontalScrollBar().getValue()) {
                        LiveShowDMXStageView.this.jScrollPane_StageView.getHorizontalScrollBar().setValue((int)((double)p_Actor.getNormPositionX() * LiveShowDMXStageView.this.m_Zoom));
                    }
                    if ((double)(p_Actor.getNormPositionX() + p_Actor.getNormWidth()) * LiveShowDMXStageView.this.m_Zoom > (double)(LiveShowDMXStageView.this.jScrollPane_StageView.getHorizontalScrollBar().getValue() + LiveShowDMXStageView.this.jScrollPane_StageView.getWidth())) {
                        LiveShowDMXStageView.this.jScrollPane_StageView.getHorizontalScrollBar().setValue((int)((double)(p_Actor.getNormPositionX() + p_Actor.getNormWidth()) * LiveShowDMXStageView.this.m_Zoom - (double)LiveShowDMXStageView.this.jScrollPane_StageView.getWidth()));
                    }
                    if ((double)p_Actor.getNormPositionY() * LiveShowDMXStageView.this.m_Zoom < (double)LiveShowDMXStageView.this.jScrollPane_StageView.getVerticalScrollBar().getValue()) {
                        LiveShowDMXStageView.this.jScrollPane_StageView.getVerticalScrollBar().setValue((int)((double)p_Actor.getNormPositionY() * LiveShowDMXStageView.this.m_Zoom));
                    }
                    if ((double)(p_Actor.getNormPositionY() + p_Actor.getNormHeight()) * LiveShowDMXStageView.this.m_Zoom > (double)(LiveShowDMXStageView.this.jScrollPane_StageView.getVerticalScrollBar().getValue() + LiveShowDMXStageView.this.jScrollPane_StageView.getHeight())) {
                        LiveShowDMXStageView.this.jScrollPane_StageView.getVerticalScrollBar().setValue((int)((double)(p_Actor.getNormPositionY() + p_Actor.getNormHeight()) * LiveShowDMXStageView.this.m_Zoom - (double)LiveShowDMXStageView.this.jScrollPane_StageView.getHeight()));
                    }
                }
            });
        }
        return o_Point_Diff;
    }

    public void changedDMXDevice(DMXDevice p_DMXDevice) {
        if (p_DMXDevice == null) {
            return;
        }
        this.dMXDeviceFunctionPanel1.changeDMXDevice(p_DMXDevice);
    }

    public JComponent getDeviceViewComponent() {
        return this.jPanel_StageView;
    }

    public double getZoom() {
        return this.m_Zoom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setZoom(double p_Zoom, int p_MouseViewX, int p_MouseViewY, final Point p_MousePositionScrollPane) {
        if (p_Zoom < 0.0) {
            p_Zoom = 1.0;
        }
        if (p_Zoom < 0.25) {
            return;
        }
        if (p_Zoom > 8.0) {
            return;
        }
        if (p_Zoom == this.m_Zoom) {
            return;
        }
        double intNormMouseX = (double)p_MouseViewX / this.m_Zoom;
        double intNormMouseY = (double)p_MouseViewY / this.m_Zoom;
        this.m_Zoom = p_Zoom;
        Object object = s_SyncDMXDeviceViews;
        synchronized (object) {
            for (int intView = 0; intView < s_DMXDeviceViews.size(); ++intView) {
                DMXDeviceView o_DMXDeviceView = s_DMXDeviceViews.get(intView);
                o_DMXDeviceView.refresh();
                o_DMXDeviceView.refreshPosition();
            }
        }
        final int intNewX = (int)(intNormMouseX * this.m_Zoom);
        final int intNewY = (int)(intNormMouseY * this.m_Zoom);
        EventQueueHandler.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (p_MousePositionScrollPane != null) {
                    LiveShowDMXStageView.this.jScrollPane_StageView.getHorizontalScrollBar().setValue(intNewX - p_MousePositionScrollPane.x);
                    LiveShowDMXStageView.this.jScrollPane_StageView.getVerticalScrollBar().setValue(intNewY - p_MousePositionScrollPane.y);
                } else {
                    LiveShowDMXStageView.this.jScrollPane_StageView.getHorizontalScrollBar().setValue(intNewX - LiveShowDMXStageView.this.jScrollPane_StageView.getWidth() / 2);
                    LiveShowDMXStageView.this.jScrollPane_StageView.getVerticalScrollBar().setValue(intNewY - LiveShowDMXStageView.this.jScrollPane_StageView.getHeight() / 2);
                }
            }
        });
    }

    public static void toFront() {
        Container o_Container = s_SelfReference;
        try {
            do {
                if ((o_Container = o_Container.getParent()) == null) {
                    return;
                }
                if (!(o_Container instanceof JFrame)) continue;
                JFrame o_JFrame = (JFrame)o_Container;
                o_JFrame.setVisible(true);
                int intExtendedState = o_JFrame.getExtendedState();
                if (intExtendedState == 1) {
                    o_JFrame.setExtendedState(0);
                }
                o_JFrame.setVisible(true);
                o_JFrame.toFront();
                return;
            } while (!(o_Container instanceof JInternalFrame));
            JInternalFrame o_JInternalFrame = (JInternalFrame)o_Container;
            if (o_JInternalFrame.isIcon()) {
                o_JInternalFrame.setIcon(false);
            }
            o_JInternalFrame.setVisible(true);
            o_JInternalFrame.setSelected(true);
            o_JInternalFrame.moveToFront();
            return;
        }
        catch (Exception e) {
            return;
        }
    }

    public void refreshUI() {
        boolean boolFilterActive = true;
        if (this.m_SelectedDMXDeviceFilter == null) {
            boolFilterActive = false;
        }
        if (this.m_SelectedDMXDeviceFilter instanceof DMXDeviceFilter.DMXDeviceFilterAll) {
            boolFilterActive = false;
        }
        if (!boolFilterActive) {
            this.jButton_InvertDMXDeviceFilter.setEnabled(false);
            this.jButton_InvertDMXDeviceFilter.setBorder(s_BorderButtonNormal);
            this.jButton_InvertDMXDeviceFilter.setBorderPainted(false);
            this.jComboBox_DMXDeviceFilter.setBorder(s_BorderButtonNormal);
            this.jTextField_FindFilter.setBorder(s_BorderButtonNormal);
        } else {
            this.jButton_InvertDMXDeviceFilter.setEnabled(true);
            if (DMXDeviceFilter.getInvertFilter()) {
                this.jButton_InvertDMXDeviceFilter.setBorder(s_BorderFilterActiveInverted);
                this.jButton_InvertDMXDeviceFilter.setBorderPainted(true);
                this.jComboBox_DMXDeviceFilter.setBorder(s_BorderFilterActiveInverted);
                this.jTextField_FindFilter.setBorder(s_BorderFilterActiveInverted);
            } else {
                this.jButton_InvertDMXDeviceFilter.setBorder(s_BorderFilterActive);
                this.jButton_InvertDMXDeviceFilter.setBorderPainted(true);
                this.jComboBox_DMXDeviceFilter.setBorder(s_BorderFilterActive);
                this.jTextField_FindFilter.setBorder(s_BorderFilterActive);
            }
        }
        if (this.m_SelectedDMXDevices.size() <= 0) {
            this.jButton_DeleteDevice.setEnabled(false);
            this.jButton_DeviceSettings.setEnabled(false);
            this.jButton_DeviceTracking.setEnabled(false);
            this.jButton_ShowInTimeline.setEnabled(false);
            this.jButton_DMXSceneFilter.setEnabled(false);
        } else {
            if (this.m_SelectedDMXDevices.size() > 1) {
                this.jButton_DeviceSettings.setEnabled(false);
            } else {
                this.jButton_DeviceSettings.setEnabled(true);
            }
            this.jButton_DeleteDevice.setEnabled(true);
            this.jButton_DeviceTracking.setEnabled(true);
            this.jButton_ShowInTimeline.setEnabled(true);
            this.jButton_DMXSceneFilter.setEnabled(true);
        }
        if (s_GridEnabled) {
            this.jCheckBox_EnableGrid.setSelected(true);
        } else {
            this.jCheckBox_EnableGrid.setSelected(false);
        }
        this.jTextField_GridWidth.setText(String.valueOf(s_GridWidth));
        this.jLabel1.setText("(1.." + String.valueOf(GRID_MAXWIDTH) + ") px");
        if (!SwingUtilities.isEventDispatchThread()) {
            EventQueueHandler.invokeLater(this.m_RunnableRepaint);
        } else {
            this.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DMXDeviceView findDMXDeviceView(DMXDevice p_DMXDevice) {
        if (p_DMXDevice == null) {
            return null;
        }
        Object object = s_SyncDMXDeviceViews;
        synchronized (object) {
            for (int intDMXDeviceView = 0; intDMXDeviceView < s_DMXDeviceViews.size(); ++intDMXDeviceView) {
                DMXDeviceView o_DMXDeviceView = s_DMXDeviceViews.get(intDMXDeviceView);
                if (o_DMXDeviceView == null || o_DMXDeviceView.getDMXDevice() != p_DMXDevice) continue;
                return o_DMXDeviceView;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeDMXDeviceView(DMXDeviceView p_DMXDeviceView) {
        if (p_DMXDeviceView == null) {
            return false;
        }
        boolean boolRemoved = false;
        this.removeSelectedDMXDevice(p_DMXDeviceView.getDMXDevice());
        LiveShowDMXStageView.notifyDMXDeviceViewRemoved(p_DMXDeviceView);
        p_DMXDeviceView.setVisible(false);
        Object object = s_SyncDMXDeviceViews;
        synchronized (object) {
            boolRemoved = s_DMXDeviceViews.remove(p_DMXDeviceView);
        }
        p_DMXDeviceView.close();
        this.dMXMixerPanel_Stage.refreshControlComponents();
        return boolRemoved;
    }

    public void addSelectedDMXDevice(DMXDevice p_DMXDevice) {
        if (p_DMXDevice == null) {
            return;
        }
        DMXDevice.DMXDeviceTableModel o_DMXDeviceTableModel = DMXDevice.getTableModel();
        o_DMXDeviceTableModel.addSelectedDMXDevice(this.jTable_Device, p_DMXDevice);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSelectedDMXDevice(DMXDevice p_DMXDevice) {
        if (p_DMXDevice == null) {
            return;
        }
        if (!DMXDevice.getTableModel().contains(p_DMXDevice.getInternalSector(0))) {
            Object object = s_SyncSelectedDMXDevices;
            synchronized (object) {
                this.m_SelectedDMXDevices.remove(p_DMXDevice);
                this.dMXMixerPanel_Stage.removeDMXDevice(p_DMXDevice);
            }
            return;
        }
        DMXDevice.getTableModel().removeSelectedDMXDevice(this.jTable_Device, p_DMXDevice);
    }

    public int getSelectedDMXDeviceCount() {
        return this.m_SelectedDMXDevices.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<DMXDevice> getDMXDevices(boolean p_AllDevices, ArrayList<DMXDevice> p_DMXDevices) {
        if (p_DMXDevices == null) {
            p_DMXDevices = new ArrayList();
        }
        p_DMXDevices.clear();
        Object object = s_SyncDMXDeviceViews;
        synchronized (object) {
            for (int intDMXDeviceView = 0; intDMXDeviceView < LiveShowDMXStageView.getDMXDeviceViewCount(); ++intDMXDeviceView) {
                DMXDevice o_DMXDevice;
                DMXDeviceView o_DMXDeviceView = LiveShowDMXStageView.getDMXDeviceView(intDMXDeviceView);
                if (o_DMXDeviceView == null) continue;
                if (!p_AllDevices) {
                    if (!o_DMXDeviceView.getSelected() || (o_DMXDevice = o_DMXDeviceView.getDMXDevice()) == null) continue;
                    p_DMXDevices.add(o_DMXDevice);
                    continue;
                }
                o_DMXDevice = o_DMXDeviceView.getDMXDevice();
                if (o_DMXDevice == null) continue;
                p_DMXDevices.add(o_DMXDevice);
            }
        }
        return p_DMXDevices;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<DMXDevice> getSelectedDMXDevices(ArrayList<DMXDevice> p_SelectedDMXDevices) {
        if (p_SelectedDMXDevices == null) {
            p_SelectedDMXDevices = new ArrayList(this.m_SelectedDMXDevices.size());
        }
        p_SelectedDMXDevices.clear();
        Object object = s_SyncSelectedDMXDevices;
        synchronized (object) {
            p_SelectedDMXDevices.addAll(this.m_SelectedDMXDevices);
        }
        return p_SelectedDMXDevices;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DMXDevice getSelectedDMXDevice(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        try {
            Object object = s_SyncSelectedDMXDevices;
            synchronized (object) {
                if (p_Index >= this.m_SelectedDMXDevices.size()) {
                    return null;
                }
                return this.m_SelectedDMXDevices.get(p_Index);
            }
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void clearSelectedDMXDevices() {
        LiveShowDMXStageView.s_SelfReference.m_SelectionModel.clearSelection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSelectedDMXDevices() {
        ArrayList<DMXDevice> o_SelectedDMXDevices;
        Object object = s_SyncSelectedDMXDevices;
        synchronized (object) {
            o_SelectedDMXDevices = new ArrayList<DMXDevice>(this.m_SelectedDMXDevices);
        }
        for (int intDevice = o_SelectedDMXDevices.size() - 1; intDevice >= 0; --intDevice) {
            DMXDevice o_DMXDevice = o_SelectedDMXDevices.get(intDevice);
            this.removeDMXDevice(o_DMXDevice);
        }
        LiveShowDMXObjectDescription.poolClear();
    }

    public static int getDMXDeviceViewCount() {
        return s_DMXDeviceViews.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DMXDeviceView getDMXDeviceView(int p_Index) {
        Object object = s_SyncDMXDeviceViews;
        synchronized (object) {
            if (p_Index < 0 || p_Index >= s_DMXDeviceViews.size()) {
                return null;
            }
            return s_DMXDeviceViews.get(p_Index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DMXDeviceView getDMXDeviceView(String p_ID) {
        if (p_ID == null) {
            return null;
        }
        Object object = s_SyncDMXDeviceViews;
        synchronized (object) {
            for (int intDevice = 0; intDevice < s_DMXDeviceViews.size(); ++intDevice) {
                DMXDevice o_DMXDevice;
                DMXDeviceView o_DMXDeviceView = s_DMXDeviceViews.get(intDevice);
                if (o_DMXDeviceView == null || (o_DMXDevice = o_DMXDeviceView.getDMXDevice()) == null || !p_ID.equals(o_DMXDevice.getID())) continue;
                return o_DMXDeviceView;
            }
            return null;
        }
    }

    private void initComponents() {
        this.jLabel_ResizeFrame1 = new JLabel_ResizeFrame();
        this.jSplitPane_StageView = new JSplitPane();
        this.jPanel_DeviceControlView = new JPanel();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel_StageViewParent = new JPanel();
        this.jScrollPane_StageView = new JScrollPane();
        this.jPanel_StageView = new JPanel();
        this.jPanel_Zoom = new JPanel();
        this.jButton_ZoomMinus = new JButton();
        this.jButton_ZoomPlus = new JButton();
        this.jButton_ZoomNull = new JButton();
        this.jPanelGrid = new JPanel();
        this.jCheckBox_EnableGrid = new JCheckBox();
        this.jTextField_GridWidth = new JTextField();
        this.jLabel1 = new JLabel();
        this.jPanel_DeviceTableParent = new JPanel();
        this.jScrollPane_DeviceTable = new JScrollPane();
        this.jTable_Device = new JTable();
        this.jButton_Export = new JButton();
        this.playSceneBridgePanel1 = new PlaySceneBridgePanel();
        this.jPanel_Devices = new JPanel();
        this.jButton_DeviceSettings = new JButton();
        this.jButton_AddDevice = new JButton();
        this.jButton_DeleteDevice = new JButton();
        this.jComboBox_DMXDeviceFilter = new JComboBox();
        this.jTextField_FindFilter = new JTextField();
        this.jButton_DeviceTracking = new JButton();
        this.jButton_ShowInTimeline = new JButton();
        this.jButton_InvertDMXDeviceFilter = new JButton();
        this.jButton_ShowDMXDeviceGroups = new JButton();
        this.jButton_DMXSceneFilter = new JButton();
        this.dMXMixerPanel_Stage = new DMXMixerPanel();
        this.dMXDeviceFunctionPanel1 = new DMXDeviceFunctionPanel();
        this.setFocusable(false);
        this.setPreferredSize(new Dimension(800, 575));
        this.setLayout(new GridBagLayout());
        this.jLabel_ResizeFrame1.setToolTipText("");
        this.jLabel_ResizeFrame1.setFocusable(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 14;
        this.add((Component)this.jLabel_ResizeFrame1, gridBagConstraints);
        this.jSplitPane_StageView.setBorder(null);
        this.jSplitPane_StageView.setDividerLocation(400);
        this.jSplitPane_StageView.setDividerSize(16);
        this.jPanel_DeviceControlView.setFocusCycleRoot(true);
        this.jPanel_DeviceControlView.setFocusable(false);
        this.jPanel_DeviceControlView.setMinimumSize(new Dimension(200, 150));
        this.jPanel_DeviceControlView.setLayout(new GridBagLayout());
        this.jTabbedPane1.setTabLayoutPolicy(1);
        this.jTabbedPane1.setToolTipText("");
        this.jTabbedPane1.setFocusable(false);
        this.jPanel_StageViewParent.setFocusable(false);
        this.jPanel_StageViewParent.setLayout(new GridBagLayout());
        this.jScrollPane_StageView.setBorder(null);
        this.jPanel_StageView.setBackground(new Color(48, 48, 48));
        this.jPanel_StageView.setLayout((LayoutManager)new AbsoluteLayout());
        this.jScrollPane_StageView.setViewportView(this.jPanel_StageView);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel_StageViewParent.add((Component)this.jScrollPane_StageView, gridBagConstraints);
        this.jPanel_Zoom.setOpaque(false);
        this.jPanel_Zoom.setLayout(new GridBagLayout());
        this.jButton_ZoomMinus.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Edit_ZoomMinus.png")));
        this.jButton_ZoomMinus.setToolTipText("Zoom Minus");
        this.jButton_ZoomMinus.setContentAreaFilled(false);
        this.jButton_ZoomMinus.setMargin(new Insets(0, 0, 0, 0));
        this.jButton_ZoomMinus.setMaximumSize(new Dimension(24, 24));
        this.jButton_ZoomMinus.setMinimumSize(new Dimension(24, 24));
        this.jButton_ZoomMinus.setPreferredSize(new Dimension(24, 24));
        this.jButton_ZoomMinus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowDMXStageView.this.jButton_ZoomMinusActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Zoom.add((Component)this.jButton_ZoomMinus, gridBagConstraints);
        this.jButton_ZoomPlus.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Edit_ZoomPlus.png")));
        this.jButton_ZoomPlus.setToolTipText("Zoom Plus");
        this.jButton_ZoomPlus.setContentAreaFilled(false);
        this.jButton_ZoomPlus.setMargin(new Insets(0, 0, 0, 0));
        this.jButton_ZoomPlus.setMaximumSize(new Dimension(24, 24));
        this.jButton_ZoomPlus.setMinimumSize(new Dimension(24, 24));
        this.jButton_ZoomPlus.setPreferredSize(new Dimension(24, 24));
        this.jButton_ZoomPlus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowDMXStageView.this.jButton_ZoomPlusActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Zoom.add((Component)this.jButton_ZoomPlus, gridBagConstraints);
        this.jButton_ZoomNull.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Edit_ZoomAll.png")));
        this.jButton_ZoomNull.setToolTipText("No Zoom");
        this.jButton_ZoomNull.setContentAreaFilled(false);
        this.jButton_ZoomNull.setMargin(new Insets(0, 0, 0, 0));
        this.jButton_ZoomNull.setMaximumSize(new Dimension(24, 24));
        this.jButton_ZoomNull.setMinimumSize(new Dimension(24, 24));
        this.jButton_ZoomNull.setName("");
        this.jButton_ZoomNull.setPreferredSize(new Dimension(24, 24));
        this.jButton_ZoomNull.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowDMXStageView.this.jButton_ZoomNullActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Zoom.add((Component)this.jButton_ZoomNull, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 14;
        this.jPanel_StageViewParent.add((Component)this.jPanel_Zoom, gridBagConstraints);
        this.jPanelGrid.setLayout(new GridBagLayout());
        this.jCheckBox_EnableGrid.setText("Use Grid");
        this.jCheckBox_EnableGrid.setToolTipText("");
        this.jCheckBox_EnableGrid.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowDMXStageView.this.jCheckBox_EnableGridActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanelGrid.add((Component)this.jCheckBox_EnableGrid, gridBagConstraints);
        this.jTextField_GridWidth.setHorizontalAlignment(0);
        this.jTextField_GridWidth.setText("100");
        this.jTextField_GridWidth.setToolTipText("");
        this.jTextField_GridWidth.setMinimumSize(new Dimension(30, 24));
        this.jTextField_GridWidth.setPreferredSize(new Dimension(30, 24));
        this.jTextField_GridWidth.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                LiveShowDMXStageView.this.jTextField_GridWidthFocusLost(evt);
            }
        });
        this.jTextField_GridWidth.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                LiveShowDMXStageView.this.jTextField_GridWidthKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanelGrid.add((Component)this.jTextField_GridWidth, gridBagConstraints);
        this.jLabel1.setText("px");
        this.jLabel1.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanelGrid.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.jPanel_StageViewParent.add((Component)this.jPanelGrid, gridBagConstraints);
        this.jTabbedPane1.addTab("tab1", this.jPanel_StageViewParent);
        this.jPanel_DeviceTableParent.setFocusable(false);
        this.jPanel_DeviceTableParent.setLayout(new GridBagLayout());
        this.jScrollPane_DeviceTable.setBorder(null);
        this.jTable_Device.setFont(new Font("Tahoma", 0, 14));
        this.jTable_Device.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTable_Device.setAutoResizeMode(0);
        this.jTable_Device.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.jTable_Device.setRowHeight(18);
        this.jTable_Device.setSelectionMode(2);
        this.jScrollPane_DeviceTable.setViewportView(this.jTable_Device);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_DeviceTableParent.add((Component)this.jScrollPane_DeviceTable, gridBagConstraints);
        this.jButton_Export.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Export_html.png")));
        this.jButton_Export.setToolTipText("Export the scenebook as excel list (xls)");
        this.jButton_Export.setContentAreaFilled(false);
        this.jButton_Export.setFocusable(false);
        this.jButton_Export.setHorizontalTextPosition(0);
        this.jButton_Export.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_Export.setVerticalTextPosition(3);
        this.jButton_Export.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowDMXStageView.this.jButton_ExportActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_DeviceTableParent.add((Component)this.jButton_Export, gridBagConstraints);
        this.jTabbedPane1.addTab("tab2", this.jPanel_DeviceTableParent);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel_DeviceControlView.add((Component)this.jTabbedPane1, gridBagConstraints);
        this.jTabbedPane1.getAccessibleContext().setAccessibleName("");
        this.playSceneBridgePanel1.setMinimumSize(new Dimension(24, 20));
        this.playSceneBridgePanel1.setPreferredSize(new Dimension(24, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_DeviceControlView.add((Component)this.playSceneBridgePanel1, gridBagConstraints);
        this.jPanel_Devices.setLayout(new GridBagLayout());
        this.jButton_DeviceSettings.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Edit.png")));
        this.jButton_DeviceSettings.setToolTipText("Show Device Settings");
        this.jButton_DeviceSettings.setContentAreaFilled(false);
        this.jButton_DeviceSettings.setMargin(new Insets(0, 0, 0, 0));
        this.jButton_DeviceSettings.setMaximumSize(new Dimension(32, 32));
        this.jButton_DeviceSettings.setMinimumSize(new Dimension(32, 32));
        this.jButton_DeviceSettings.setPreferredSize(new Dimension(32, 32));
        this.jButton_DeviceSettings.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_DeviceSettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowDMXStageView.this.jButton_DeviceSettingsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Devices.add((Component)this.jButton_DeviceSettings, gridBagConstraints);
        this.jButton_AddDevice.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Edit_Plus.png")));
        this.jButton_AddDevice.setToolTipText("add Device");
        this.jButton_AddDevice.setContentAreaFilled(false);
        this.jButton_AddDevice.setMargin(new Insets(0, 0, 0, 0));
        this.jButton_AddDevice.setMaximumSize(new Dimension(32, 32));
        this.jButton_AddDevice.setMinimumSize(new Dimension(32, 32));
        this.jButton_AddDevice.setPreferredSize(new Dimension(32, 32));
        this.jButton_AddDevice.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_AddDevice.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowDMXStageView.this.jButton_AddDeviceActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Devices.add((Component)this.jButton_AddDevice, gridBagConstraints);
        this.jButton_DeleteDevice.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Delete.png")));
        this.jButton_DeleteDevice.setToolTipText("delete Device");
        this.jButton_DeleteDevice.setContentAreaFilled(false);
        this.jButton_DeleteDevice.setMargin(new Insets(0, 0, 0, 0));
        this.jButton_DeleteDevice.setMaximumSize(new Dimension(32, 32));
        this.jButton_DeleteDevice.setMinimumSize(new Dimension(32, 32));
        this.jButton_DeleteDevice.setName("");
        this.jButton_DeleteDevice.setPreferredSize(new Dimension(32, 32));
        this.jButton_DeleteDevice.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_DeleteDevice.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowDMXStageView.this.jButton_DeleteDeviceActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Devices.add((Component)this.jButton_DeleteDevice, gridBagConstraints);
        this.jComboBox_DMXDeviceFilter.setFont(new Font("Tahoma", 0, 12));
        this.jComboBox_DMXDeviceFilter.setPreferredSize(new Dimension(56, 24));
        this.jComboBox_DMXDeviceFilter.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                LiveShowDMXStageView.this.jComboBox_DMXDeviceFilterItemStateChanged(evt);
            }
        });
        this.jComboBox_DMXDeviceFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowDMXStageView.this.jComboBox_DMXDeviceFilterActionPerformed(evt);
            }
        });
        this.jComboBox_DMXDeviceFilter.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                LiveShowDMXStageView.this.jComboBox_DMXDeviceFilterKeyPressed(evt);
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                LiveShowDMXStageView.this.jComboBox_DMXDeviceFilterKeyTyped(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Devices.add((Component)this.jComboBox_DMXDeviceFilter, gridBagConstraints);
        this.jTextField_FindFilter.setFont(new Font("Tahoma", 0, 14));
        this.jTextField_FindFilter.setToolTipText("insert search-string of an device filter and press return");
        this.jTextField_FindFilter.setMinimumSize(new Dimension(60, 23));
        this.jTextField_FindFilter.setPreferredSize(new Dimension(60, 24));
        this.jTextField_FindFilter.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                LiveShowDMXStageView.this.jTextField_FindFilterMouseClicked(evt);
            }
        });
        this.jTextField_FindFilter.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                LiveShowDMXStageView.this.jTextField_FindFilterKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.3;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Devices.add((Component)this.jTextField_FindFilter, gridBagConstraints);
        this.jButton_DeviceTracking.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Device_Tracking.png")));
        this.jButton_DeviceTracking.setToolTipText("Device Tracking");
        this.jButton_DeviceTracking.setContentAreaFilled(false);
        this.jButton_DeviceTracking.setMargin(new Insets(0, 0, 0, 0));
        this.jButton_DeviceTracking.setMaximumSize(new Dimension(32, 32));
        this.jButton_DeviceTracking.setMinimumSize(new Dimension(32, 32));
        this.jButton_DeviceTracking.setPreferredSize(new Dimension(32, 32));
        this.jButton_DeviceTracking.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_DeviceTracking.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowDMXStageView.this.jButton_DeviceTrackingActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Devices.add((Component)this.jButton_DeviceTracking, gridBagConstraints);
        this.jButton_ShowInTimeline.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Timeline_Selection.png")));
        this.jButton_ShowInTimeline.setToolTipText("Selects all objects in timeline using this devices (dimmer > 0).");
        this.jButton_ShowInTimeline.setContentAreaFilled(false);
        this.jButton_ShowInTimeline.setFocusable(false);
        this.jButton_ShowInTimeline.setHorizontalTextPosition(0);
        this.jButton_ShowInTimeline.setIconTextGap(0);
        this.jButton_ShowInTimeline.setMargin(new Insets(0, 0, 0, 0));
        this.jButton_ShowInTimeline.setMaximumSize(new Dimension(32, 32));
        this.jButton_ShowInTimeline.setMinimumSize(new Dimension(32, 32));
        this.jButton_ShowInTimeline.setPreferredSize(new Dimension(32, 32));
        this.jButton_ShowInTimeline.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_ShowInTimeline.setVerticalTextPosition(3);
        this.jButton_ShowInTimeline.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowDMXStageView.this.jButton_ShowInTimelineActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        this.jPanel_Devices.add((Component)this.jButton_ShowInTimeline, gridBagConstraints);
        this.jButton_InvertDMXDeviceFilter.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Device_Filter_24.png")));
        this.jButton_InvertDMXDeviceFilter.setToolTipText("inverts the selected device filter");
        this.jButton_InvertDMXDeviceFilter.setContentAreaFilled(false);
        this.jButton_InvertDMXDeviceFilter.setFocusable(false);
        this.jButton_InvertDMXDeviceFilter.setHorizontalTextPosition(0);
        this.jButton_InvertDMXDeviceFilter.setIconTextGap(0);
        this.jButton_InvertDMXDeviceFilter.setMargin(new Insets(0, 0, 0, 0));
        this.jButton_InvertDMXDeviceFilter.setMaximumSize(new Dimension(32, 32));
        this.jButton_InvertDMXDeviceFilter.setMinimumSize(new Dimension(32, 32));
        this.jButton_InvertDMXDeviceFilter.setPreferredSize(new Dimension(32, 32));
        this.jButton_InvertDMXDeviceFilter.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_InvertDMXDeviceFilter.setVerticalTextPosition(3);
        this.jButton_InvertDMXDeviceFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowDMXStageView.this.jButton_InvertDMXDeviceFilterActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        this.jPanel_Devices.add((Component)this.jButton_InvertDMXDeviceFilter, gridBagConstraints);
        this.jButton_ShowDMXDeviceGroups.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/DeviceGroupView.png")));
        this.jButton_ShowDMXDeviceGroups.setToolTipText("Selects all objects in timeline using this devices (dimmer > 0).");
        this.jButton_ShowDMXDeviceGroups.setContentAreaFilled(false);
        this.jButton_ShowDMXDeviceGroups.setFocusable(false);
        this.jButton_ShowDMXDeviceGroups.setHorizontalTextPosition(0);
        this.jButton_ShowDMXDeviceGroups.setIconTextGap(0);
        this.jButton_ShowDMXDeviceGroups.setMargin(new Insets(0, 0, 0, 0));
        this.jButton_ShowDMXDeviceGroups.setMaximumSize(new Dimension(32, 32));
        this.jButton_ShowDMXDeviceGroups.setMinimumSize(new Dimension(32, 32));
        this.jButton_ShowDMXDeviceGroups.setPreferredSize(new Dimension(32, 32));
        this.jButton_ShowDMXDeviceGroups.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_ShowDMXDeviceGroups.setVerticalTextPosition(3);
        this.jButton_ShowDMXDeviceGroups.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowDMXStageView.this.jButton_ShowDMXDeviceGroupsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        this.jPanel_Devices.add((Component)this.jButton_ShowDMXDeviceGroups, gridBagConstraints);
        this.jButton_DMXSceneFilter.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/DMXScene_Filter.png")));
        this.jButton_DMXSceneFilter.setToolTipText("Selects all objects in timeline using this devices (dimmer > 0).");
        this.jButton_DMXSceneFilter.setContentAreaFilled(false);
        this.jButton_DMXSceneFilter.setFocusable(false);
        this.jButton_DMXSceneFilter.setHorizontalTextPosition(0);
        this.jButton_DMXSceneFilter.setIconTextGap(0);
        this.jButton_DMXSceneFilter.setMargin(new Insets(0, 0, 0, 0));
        this.jButton_DMXSceneFilter.setMaximumSize(new Dimension(32, 32));
        this.jButton_DMXSceneFilter.setMinimumSize(new Dimension(32, 32));
        this.jButton_DMXSceneFilter.setPreferredSize(new Dimension(32, 32));
        this.jButton_DMXSceneFilter.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_DMXSceneFilter.setVerticalTextPosition(3);
        this.jButton_DMXSceneFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowDMXStageView.this.jButton_DMXSceneFilterActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        this.jPanel_Devices.add((Component)this.jButton_DMXSceneFilter, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel_DeviceControlView.add((Component)this.jPanel_Devices, gridBagConstraints);
        this.jSplitPane_StageView.setLeftComponent(this.jPanel_DeviceControlView);
        this.jSplitPane_StageView.setRightComponent(this.dMXMixerPanel_Stage);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jSplitPane_StageView, gridBagConstraints);
        this.dMXDeviceFunctionPanel1.setFocusable(false);
        this.dMXDeviceFunctionPanel1.setMinimumSize(new Dimension(0, 34));
        this.dMXDeviceFunctionPanel1.setPreferredSize(new Dimension(100, 34));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 30);
        this.add((Component)this.dMXDeviceFunctionPanel1, gridBagConstraints);
    }

    private void initComponentsFurther() {
        this.jComboBox_DMXDeviceFilter.setModel(this.m_DMXDeviceFilterListModelWrapper);
        this.jComboBox_DMXDeviceFilter.setRenderer(DMXDeviceFilter.getListCellRenderer());
        this.dMXMixerPanel_Stage.setOwner(0);
        this.dMXMixerPanel_Stage.setName("---");
        this.dMXMixerPanel_Stage.setBorder(null);
        this.jScrollPane_DeviceTable.getViewport().setBackground(Color.BLACK);
        this.jTable_Device.setModel(DMXDevice.getTableModel());
        DMXDevice.getTableModel().finishJTable(this.jTable_Device);
        this.jTable_Device.setSelectionMode(2);
        this.m_SelectionModel = this.jTable_Device.getSelectionModel();
        this.m_SelectionModel.addListSelectionListener(this);
        this.jTable_Device.setRowHeight(22);
        this.jTabbedPane1.setTitleAt(0, "");
        this.jTabbedPane1.setForegroundAt(0, Color.WHITE);
        this.jTabbedPane1.setBackgroundAt(0, Color.BLACK);
        this.jTabbedPane1.setIconAt(0, new ImageIcon(this.getClass().getResource("/IconsPackage/DMX_16.png")));
        this.jTabbedPane1.setTitleAt(1, "");
        this.jTabbedPane1.setForegroundAt(1, Color.WHITE);
        this.jTabbedPane1.setBackgroundAt(1, Color.BLACK);
        this.jTabbedPane1.setIconAt(1, new ImageIcon(this.getClass().getResource("/IconsPackage/Table_16.png")));
        this.dMXMixerPanel_Stage.setControlFunctionsVisible(true);
        this.refreshUI();
        this.jSplitPane_StageView.setDividerLocation(0.5);
        this.jComboBox_DMXDeviceFilter.setSelectedIndex(0);
        this.revalidate();
        MouseAdapter o_MouseAdapter = new MouseAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mouseDragged(MouseEvent e) {
                DMXDeviceView o_DMXDeviceView;
                s_ExternalMouseDeviceViews.clear();
                if (LiveShowDMXStageView.this.m_ExternalMouseLastX == null) {
                    LiveShowDMXStageView.this.m_ExternalMouseLastX = e.getX();
                    LiveShowDMXStageView.this.m_ExternalMouseLastY = e.getY();
                }
                Object object = s_SyncDMXDeviceViews;
                synchronized (object) {
                    for (int intDMXDeviceView = 0; intDMXDeviceView < s_DMXDeviceViews.size(); ++intDMXDeviceView) {
                        o_DMXDeviceView = (DMXDeviceView)s_DMXDeviceViews.get(intDMXDeviceView);
                        if (!o_DMXDeviceView.isEnabled() || !o_DMXDeviceView.externalMouseEnter(LiveShowDMXStageView.this.m_ExternalMouseLastX, LiveShowDMXStageView.this.m_ExternalMouseLastY, e.getX(), e.getY())) continue;
                        if (s_ExternalMouseFirstView == null) {
                            s_ExternalMouseFirstView = o_DMXDeviceView;
                            s_ExternalMouseFirstWasSelected = o_DMXDeviceView.getSelected();
                        }
                        s_ExternalMouseDeviceViews.add(o_DMXDeviceView);
                    }
                    if (s_ExternalMouseFirstView == null) {
                        return;
                    }
                }
                for (int intDMXDeviceView = 0; intDMXDeviceView < s_ExternalMouseDeviceViews.size(); ++intDMXDeviceView) {
                    o_DMXDeviceView = (DMXDeviceView)s_ExternalMouseDeviceViews.get(intDMXDeviceView);
                    if (!o_DMXDeviceView.isEnabled()) {
                        LiveShowDMXStageView.this.removeSelectedDMXDevice(o_DMXDeviceView.getDMXDevice());
                        continue;
                    }
                    if (!s_ExternalMouseFirstWasSelected) {
                        LiveShowDMXStageView.this.addSelectedDMXDevice(o_DMXDeviceView.getDMXDevice());
                        continue;
                    }
                    LiveShowDMXStageView.this.removeSelectedDMXDevice(o_DMXDeviceView.getDMXDevice());
                }
                LiveShowDMXStageView.this.m_ExternalMouseLastX = e.getX();
                LiveShowDMXStageView.this.m_ExternalMouseLastY = e.getY();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mouseReleased(MouseEvent e) {
                s_ExternalMouseFirstView = null;
                LiveShowDMXStageView.this.m_ExternalMouseLastX = null;
                LiveShowDMXStageView.this.m_ExternalMouseLastY = null;
                Object object = s_SyncDMXDeviceViews;
                synchronized (object) {
                    for (int intDMXDeviceView = 0; intDMXDeviceView < s_DMXDeviceViews.size(); ++intDMXDeviceView) {
                        DMXDeviceView o_DMXDeviceView = (DMXDeviceView)s_DMXDeviceViews.get(intDMXDeviceView);
                        o_DMXDeviceView.externalMouseReleased(e.getX(), e.getY());
                    }
                }
            }
        };
        MouseWheelListener o_MouseWheelListener = new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                Point positionScrollPane = LiveShowDMXStageView.this.jScrollPane_StageView.getMousePosition();
                if (e.getWheelRotation() < 0) {
                    LiveShowDMXStageView.this.setZoom(LiveShowDMXStageView.this.m_Zoom * 1.2, e.getX(), e.getY(), positionScrollPane);
                } else if (e.getWheelRotation() > 0) {
                    LiveShowDMXStageView.this.setZoom(LiveShowDMXStageView.this.m_Zoom / 1.2, e.getX(), e.getY(), positionScrollPane);
                }
            }
        };
        this.jPanel_StageView.addMouseListener(o_MouseAdapter);
        this.jPanel_StageView.addMouseMotionListener(o_MouseAdapter);
        this.jPanel_StageView.addMouseWheelListener(o_MouseWheelListener);
        this.jTextField_FindFilter.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                LiveShowDMXStageView.this.jTextField_FindFilter_DocumentChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                LiveShowDMXStageView.this.jTextField_FindFilter_DocumentChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                LiveShowDMXStageView.this.jTextField_FindFilter_DocumentChanged();
            }
        });
        this.jTextField_FindFilter.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 8 || e.getKeyCode() == 127 || e.getKeyCode() == 10) {
                    LiveShowDMXStageView.this.jTextField_FindFilter_DocumentChanged();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
        DocumentFilter_Integer o_DocumentFilter_Integer = new DocumentFilter_Integer(this.jTextField_GridWidth);
        o_DocumentFilter_Integer.setAllowNegativeNumbers(false);
        this.jTable_Device.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_AddDevice.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_DMXSceneFilter.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jComboBox_DMXDeviceFilter.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jTextField_FindFilter.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_DeleteDevice.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_DeviceSettings.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_DeviceTracking.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_ShowInTimeline.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_InvertDMXDeviceFilter.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_Export.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_ShowDMXDeviceGroups.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_ZoomMinus.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_ZoomNull.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_ZoomPlus.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jCheckBox_EnableGrid.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jTextField_GridWidth.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        for (int intCopmponent = 0; intCopmponent < this.jSplitPane_StageView.getComponentCount(); ++intCopmponent) {
            Component o_Component = this.jSplitPane_StageView.getComponent(intCopmponent);
            if (!(o_Component instanceof BasicSplitPaneDivider)) continue;
            BasicSplitPaneDivider o_BasicSplitPaneDivider = (BasicSplitPaneDivider)o_Component;
            o_BasicSplitPaneDivider.setBorder(new DividerBorder());
            o_BasicSplitPaneDivider.setBackground(Color.BLACK);
            if (o_BasicSplitPaneDivider.getComponentCount() <= 0) continue;
            o_BasicSplitPaneDivider.remove(0);
        }
    }

    public DMXMixerPanel getDMXMixerPanel() {
        return this.dMXMixerPanel_Stage;
    }

    public void setEditModeOn(boolean p_EditMode) {
    }

    public void showDMXDeviceSettings(DMXDevice p_DMXDevice) {
        if (p_DMXDevice == null) {
            return;
        }
        LiveShowDMXDeviceSettings o_LiveShowDMXDeviceSettings = LiveShowDMXSystem.getLiveShowDMXDeviceSettings();
        o_LiveShowDMXDeviceSettings.setDMXDevice(p_DMXDevice);
        o_LiveShowDMXDeviceSettings.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void valueChanged(ListSelectionEvent e) {
        DMXDeviceView o_DMXDeviceView;
        int intModelRow;
        int intRow;
        if (e.getValueIsAdjusting()) {
            return;
        }
        if (this.m_ListValueChangedIsAdjusting) {
            return;
        }
        this.m_ListValueChangedIsAdjusting = true;
        DMXDevice o_DMXDevice = null;
        ArrayList<Integer> o_SelectedRows = new ArrayList<Integer>();
        int[] arraySelectedRows = this.jTable_Device.getSelectedRows();
        for (intRow = 0; intRow < arraySelectedRows.length; ++intRow) {
            o_SelectedRows.add(arraySelectedRows[intRow]);
        }
        for (int intDMXDevice = this.m_SelectedDMXDevices.size() - 1; intDMXDevice >= 0; --intDMXDevice) {
            int intViewRow;
            boolean boolIsSelected = true;
            o_DMXDevice = this.m_SelectedDMXDevices.get(intDMXDevice);
            Object object = s_SyncSelectedDMXDevices;
            synchronized (object) {
                for (int intSector = 0; intSector < o_DMXDevice.getInternalSectorCount(); ++intSector) {
                    intModelRow = DMXDevice.getTableModel().getRowOfDMXDevice(o_DMXDevice.getInternalSector(intSector));
                    if (intModelRow < 0 || o_SelectedRows.contains(intViewRow = this.jTable_Device.convertRowIndexToView(intModelRow))) continue;
                    boolIsSelected = false;
                    break;
                }
            }
            if (boolIsSelected) continue;
            for (int intSector = 0; intSector < o_DMXDevice.getInternalSectorCount(); ++intSector) {
                intModelRow = DMXDevice.getTableModel().getRowOfDMXDevice(o_DMXDevice.getInternalSector(intSector));
                intViewRow = this.jTable_Device.convertRowIndexToView(intModelRow);
                if (intViewRow < 0) continue;
                o_SelectedRows.remove((Object)intViewRow);
            }
            o_DMXDeviceView = LiveShowDMXStageView.findDMXDeviceView(o_DMXDevice);
            if (o_DMXDeviceView != null) {
                o_DMXDeviceView.setSelected(false);
            }
            this.dMXMixerPanel_Stage.removeDMXDevice(o_DMXDevice);
            if (!this.m_SelectedDMXDevices.remove(o_DMXDevice)) continue;
            DMXDevice.getTableModel().removeSelectedDMXDevice(this.jTable_Device, o_DMXDevice);
            LiveShowDMXStageView.notifyDMXDeviceViewSelected(o_DMXDeviceView, false);
        }
        for (intRow = 0; intRow < o_SelectedRows.size(); ++intRow) {
            try {
                intModelRow = this.jTable_Device.convertRowIndexToModel((Integer)o_SelectedRows.get(intRow));
                DMXDevice.InternalSector o_InternalSector = DMXDevice.getTableModel().getDMXDeviceInternalSector(intModelRow);
                o_DMXDevice = o_InternalSector.getDMXDevice();
            }
            catch (Exception error) {
                continue;
            }
            if (this.m_SelectedDMXDevices.contains(o_DMXDevice)) continue;
            this.m_SelectedDMXDevices.add(o_DMXDevice);
            o_DMXDeviceView = LiveShowDMXStageView.findDMXDeviceView(o_DMXDevice);
            if (o_DMXDeviceView != null) {
                o_DMXDeviceView.setSelected(true);
                this.jPanel_StageView.setComponentZOrder(o_DMXDeviceView, 0);
            }
            this.dMXMixerPanel_Stage.addDMXDevice(o_DMXDevice);
            DMXDevice.getTableModel().addSelectedDMXDevice(this.jTable_Device, o_DMXDevice);
            LiveShowDMXStageView.notifyDMXDeviceViewSelected(o_DMXDeviceView, true);
        }
        this.m_ListValueChangedIsAdjusting = false;
        this.refreshUI();
    }

    private void correctSelection(DMXDevice p_DMXDevice, int p_Sector, boolean p_Selected) {
        if (p_DMXDevice == null) {
            return;
        }
        for (int intSector = 0; intSector < p_DMXDevice.getInternalSectorCount(); ++intSector) {
            int intIndex = DMXDevice.getTableModel().getRowOfDMXDevice(p_DMXDevice.getInternalSector(intSector));
            if (intIndex < 0) {
                return;
            }
            intIndex = this.jTable_Device.convertRowIndexToView(intIndex);
            if (p_Selected) {
                this.m_SelectionModel.addSelectionInterval(intIndex, intIndex);
                continue;
            }
            this.m_SelectionModel.removeSelectionInterval(intIndex, intIndex);
        }
    }

    public void printDeviceTable(LiveShowProjectDescription p_LiveShowProjectDescription) {
        MessageFormat o_MessageFormatHeader = null;
        MessageFormat o_MessageFormatFooter = null;
        PrintRequestAttributeSet o_PrintRequestAttributeSet = null;
        PrintService o_PrintService = null;
        o_MessageFormatFooter = new MessageFormat("{0,number,integer}");
        if (p_LiveShowProjectDescription != null) {
            o_MessageFormatHeader = new MessageFormat(p_LiveShowProjectDescription.getProjectName());
        }
        try {
            this.jTable_Device.print(JTable.PrintMode.FIT_WIDTH, o_MessageFormatHeader, o_MessageFormatFooter, true, o_PrintRequestAttributeSet, false, o_PrintService);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void eventVIPActive(LiveShowVIP p_LiveShowVIP, boolean p_Active) {
    }

    @Override
    public void eventVIPToFront(LiveShowVIP p_LiveShowVIP) {
    }

    @Override
    public void eventVIPTrackAdded(LiveShowVIP p_LiveShowVIP, LiveShowVIPTrack p_LiveShowVIPTrack) {
    }

    @Override
    public void eventVIPTrackRemoved(LiveShowVIP p_LiveShowVIP, LiveShowVIPTrack p_LiveShowVIPTrack) {
    }

    @Override
    public void eventVIPFrameMaxObjects(LiveShowVIP p_LiveShowVIP, long p_FrameMaxObjects) {
    }

    @Override
    public void eventVIPMaxFrame(LiveShowVIP p_LiveShowVIP, long p_FrameMax) {
    }

    @Override
    public void eventVIPFrameTime(LiveShowVIP p_LiveShowVIP, double p_FrameTime) {
    }

    @Override
    public void eventVIPClosing(LiveShowVIP p_LiveShowVIP) {
    }

    @Override
    public void eventVIPSceneBridgeAdded(LiveShowVIP p_LiveShowVIP, LiveShowSceneBridge p_LiveShowSceneBridge) {
    }

    @Override
    public void eventVIPSceneBridgeRemoved(LiveShowVIP p_LiveShowVIP, LiveShowSceneBridge p_LiveShowSceneBridge) {
    }

    @Override
    public void eventVIPSceneBridgesResorted(LiveShowVIP p_LiveShowVIP, LiveShowSceneBridge p_LiveShowSceneBridge, ArrayList<LiveShowSceneBridge> p_LiveShowSceneBridges) {
    }

    @Override
    public void eventVIPSceneBridgeCursorChanged(LiveShowVIP p_LiveShowVIP, boolean p_ActualPlaying, boolean p_ActualStopAtStart) {
    }

    @Override
    public void eventVIPSceneBridgeEditCursorChanged(LiveShowVIP p_LiveShowVIP) {
        if (!p_LiveShowVIP.getEditModeOn()) {
            // empty if block
        }
    }

    @Override
    public void eventVIPSceneBridgeStart(LiveShowVIP p_LiveShowVIP, LiveShowSceneBridge p_LiveShowSceneBridge, boolean p_WillPlay) {
    }

    @Override
    public void eventVIPSceneBridgeEnd(LiveShowVIP p_LiveShowVIP, LiveShowSceneBridge p_LiveShowSceneBridge) {
    }

    @Override
    public void eventVIPObjectAdded(LiveShowVIP p_LiveShowVIP, LiveShowObjectInterface p_LiveShowObjectInterface) {
    }

    @Override
    public void eventVIPObjectRemoved(LiveShowVIP p_LiveShowVIP, LiveShowObjectInterface p_LiveShowObjectInterface) {
    }

    @Override
    public void eventVIPObjectParamChanged(LiveShowVIP p_LiveShowVIP, LiveShowObjectInterface p_LiveShowObjectInterface) {
    }

    @Override
    public void eventVIPObjectShowSettings(LiveShowVIP p_LiveShowVIP, LiveShowObjectInterface p_LiveShowObjectInterface) {
    }

    @Override
    public void eventVIPObjectSelection(LiveShowVIP p_LiveShowVIP, LiveShowObjectInterface p_LiveShowObjectInterface) {
    }

    @Override
    public void eventVIPEndOfAction(LiveShowVIP p_LiveShowVIP, LiveShowVIP p_ActorLiveShowVIP, boolean p_Success, int p_Action) {
    }

    @Override
    public void eventVIPEditModeOn(LiveShowVIP p_LiveShowVIP, boolean p_EditModeOn) {
        if (!p_EditModeOn) {
            // empty if block
        }
    }

    @Override
    public void eventVIPCursorMode(LiveShowVIP p_LiveShowVIP, int p_EditMode) {
    }

    private void jComboBox_DMXDeviceFilterItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.m_SelectedDMXDeviceFilter = (DMXDeviceFilter)this.jComboBox_DMXDeviceFilter.getSelectedItem();
            this.filterDMXDevices();
            this.refreshUI();
        }
    }

    public void filterDMXDevices(DMXDeviceFilter p_DMXDeviceFilter) {
        if (p_DMXDeviceFilter == null) {
            return;
        }
        this.jTextField_FindFilter.setText("");
        this.jComboBox_DMXDeviceFilter.setSelectedItem(p_DMXDeviceFilter);
        if (!SwingUtilities.isEventDispatchThread()) {
            System.out.println("LiveSHowDMXStageView filterDMXDevices not called from DispatchThread");
        }
        this.jComboBox_DMXDeviceFilter.repaint();
    }

    public void filterDMXDevices() {
        TableRowSorter o_TableRowSorter;
        if (this.m_SelectedDMXDeviceFilter == null) {
            if (DMXDeviceFilter.getInvertFilter()) {
                DMXDeviceFilter.setInvertFilter(false);
                this.refreshUI();
            }
        } else if (this.m_SelectedDMXDeviceFilter instanceof DMXDeviceFilter.DMXDeviceFilterAll && DMXDeviceFilter.getInvertFilter()) {
            DMXDeviceFilter.setInvertFilter(false);
            this.refreshUI();
        }
        if ((o_TableRowSorter = (TableRowSorter)this.jTable_Device.getRowSorter()) == null) {
            return;
        }
        DMXDeviceFilter.DMXDeviceRowFilter o_DMXDeviceRowFilter = (DMXDeviceFilter.DMXDeviceRowFilter)o_TableRowSorter.getRowFilter();
        if (o_DMXDeviceRowFilter == null) {
            return;
        }
        LiveShowDMXStageView.clearSelectedDMXDevices();
        o_DMXDeviceRowFilter.setDMXDeviceFilter(this.m_SelectedDMXDeviceFilter);
        int intCountEnabledDevices = 0;
        DMXDevice o_LastEnabledDMXDevice = null;
        for (int intDeviceView = 0; intDeviceView < LiveShowDMXStageView.getDMXDeviceViewCount(); ++intDeviceView) {
            DMXDeviceView o_DMXDeviceView = LiveShowDMXStageView.getDMXDeviceView(intDeviceView);
            DMXDevice o_DMXDevice = o_DMXDeviceView.getDMXDevice();
            if (this.m_SelectedDMXDeviceFilter == null) {
                o_DMXDeviceView.setEnabled(true);
                ++intCountEnabledDevices;
                o_LastEnabledDMXDevice = o_DMXDevice;
                continue;
            }
            if (!DMXDeviceFilter.getInvertFilter() && this.m_SelectedDMXDeviceFilter.containsDMXDevice(o_DMXDevice) || DMXDeviceFilter.getInvertFilter() && !this.m_SelectedDMXDeviceFilter.containsDMXDevice(o_DMXDevice)) {
                o_DMXDeviceView.setEnabled(true);
                if (this.m_SelectedDMXDeviceFilter.getFilterInterface() instanceof DMXDeviceGroup || this.m_SelectedDMXDeviceFilter instanceof DMXDeviceFilter.DMXDeviceFilterSelectedDMXDeviceGroups) {
                    this.addSelectedDMXDevice(o_DMXDevice);
                }
                ++intCountEnabledDevices;
                o_LastEnabledDMXDevice = o_DMXDevice;
                continue;
            }
            o_DMXDeviceView.setEnabled(false);
        }
        if (intCountEnabledDevices == 1 && this.m_SelectedDMXDeviceFilter != null && !(this.m_SelectedDMXDeviceFilter instanceof DMXDeviceFilter.DMXDeviceFilterAll)) {
            this.addSelectedDMXDevice(o_LastEnabledDMXDevice);
        }
    }

    private void jButton_DeviceSettingsActionPerformed(ActionEvent evt) {
        if (this.m_SelectedDMXDevices.size() != 1) {
            return;
        }
        this.showDMXDeviceSettings(this.m_SelectedDMXDevices.get(0));
    }

    private void jButton_AddDeviceActionPerformed(ActionEvent evt) {
        LiveShowDMXDeviceTypeSelection o_DMXDeviceTypeSelection = LiveShowDMXSystem.getDMXDeviceTypeSelection();
        if (o_DMXDeviceTypeSelection != null) {
            o_DMXDeviceTypeSelection.setVisible(true);
        }
    }

    private void jButton_DeleteDeviceActionPerformed(ActionEvent evt) {
        int intOptionAnswer = JOptionDialog.showConfirmDialog(null, DELETE_SELECTEDDEVICES, DELETESELECTEDDEVICSES_TITEL, 0, 1);
        if (intOptionAnswer == 0) {
            this.deleteSelectedDMXDevices();
        }
    }

    private void jComboBox_DMXDeviceFilterActionPerformed(ActionEvent evt) {
        this.m_SelectedDMXDeviceFilter = (DMXDeviceFilter)this.jComboBox_DMXDeviceFilter.getSelectedItem();
        this.filterDMXDevices();
        this.refreshUI();
    }

    private void jComboBox_DMXDeviceFilterKeyPressed(KeyEvent evt) {
    }

    private void jComboBox_DMXDeviceFilterKeyTyped(KeyEvent evt) {
        char o_TypedKey = evt.getKeyChar();
        if (o_TypedKey == '\uffff') {
            return;
        }
        DMXDeviceFilter o_DMXDeviceFilter = DMXDeviceFilter.getListModel().findByName(String.valueOf(o_TypedKey));
        if (o_DMXDeviceFilter != null) {
            this.jComboBox_DMXDeviceFilter.setSelectedItem(o_DMXDeviceFilter);
            if (!SwingUtilities.isEventDispatchThread()) {
                System.out.println("LiveSHowDMXStageView jComboBox_DMXDeviceFilterKeyTyped not called from DispatchThread");
            }
            this.jComboBox_DMXDeviceFilter.repaint();
        }
    }

    private void jTextField_FindFilterKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            String stringFilterSubString = this.jTextField_FindFilter.getText();
            DMXDeviceFilter.getListModel().filterByName(stringFilterSubString);
            DMXDeviceFilter o_DMXDeviceFilter = stringFilterSubString == null || stringFilterSubString.length() <= 0 ? DMXDeviceFilter.s_DMXDeviceFilterAll : DMXDeviceFilter.getListModel().findByName(stringFilterSubString);
            if (o_DMXDeviceFilter != null) {
                this.jComboBox_DMXDeviceFilter.setSelectedItem(o_DMXDeviceFilter);
                this.jComboBox_DMXDeviceFilter.repaint();
            }
        }
    }

    private void jButton_DeviceTrackingActionPerformed(ActionEvent evt) {
        if (this.m_SelectedDMXDevices.size() <= 0) {
            return;
        }
        LiveShowDMXDeviceTracking o_LiveShowDMXDeviceTracking = new LiveShowDMXDeviceTracking();
        for (int intDMXDevice = 0; intDMXDevice < this.m_SelectedDMXDevices.size(); ++intDMXDevice) {
            DMXDevice o_DMXDevice = this.m_SelectedDMXDevices.get(intDMXDevice);
            o_LiveShowDMXDeviceTracking.addDMXDevice(o_DMXDevice);
        }
        o_LiveShowDMXDeviceTracking.setVisible(true);
    }

    private void jButton_ShowInTimelineActionPerformed(ActionEvent evt) {
        if (this.m_SelectedDMXDevices.size() <= 0) {
            return;
        }
        LiveShowDMXVIP o_LiveShowDMXVIP = LiveShowDMXSystem.getLiveShowDMXVIP();
        if (o_LiveShowDMXVIP == null) {
            return;
        }
        o_LiveShowDMXVIP.clearSelectedObjects(true);
        block0: for (int intObject = 0; intObject < o_LiveShowDMXVIP.getLiveShowObjectInterfaceCount(); ++intObject) {
            LiveShowObjectInterface o_LiveShowObjectInterface = o_LiveShowDMXVIP.getLiveShowObjectInterface(intObject);
            if (o_LiveShowObjectInterface instanceof LiveShowSceneBridge) continue;
            LiveShowDMXObject o_LiveShowDMXObject = (LiveShowDMXObject)o_LiveShowObjectInterface;
            DMXScene o_DMXScene = o_LiveShowDMXObject.getDMXScene();
            DMXEffect o_DMXEffect = o_LiveShowDMXObject.getDMXEffect();
            if (o_DMXScene == null && o_DMXEffect == null) continue;
            for (int intDMXDevice = 0; intDMXDevice < this.m_SelectedDMXDevices.size(); ++intDMXDevice) {
                DMXDevice o_DMXDevice = this.m_SelectedDMXDevices.get(intDMXDevice);
                if (o_DMXScene != null && o_DMXScene.isDimmerOn(o_DMXDevice)) {
                    o_LiveShowDMXVIP.addSelectedObject(o_LiveShowDMXObject);
                    continue block0;
                }
                if (o_DMXEffect == null || !o_DMXEffect.useDMXDevice(o_DMXDevice)) continue;
                o_LiveShowDMXVIP.addSelectedObject(o_LiveShowDMXObject);
                continue block0;
            }
        }
        if (o_LiveShowDMXVIP.getSelectedObjectsCount() > 0) {
            o_LiveShowDMXVIP.toFront();
        }
    }

    private void jButton_ZoomMinusActionPerformed(ActionEvent evt) {
        this.setZoom(this.m_Zoom / 1.2, -this.jPanel_StageView.getX() + this.jScrollPane_StageView.getWidth() / 2, -this.jPanel_StageView.getY() + this.jScrollPane_StageView.getHeight() / 2, null);
    }

    private void jButton_ZoomPlusActionPerformed(ActionEvent evt) {
        this.setZoom(this.m_Zoom * 1.2, -this.jPanel_StageView.getX() + this.jScrollPane_StageView.getWidth() / 2, -this.jPanel_StageView.getY() + this.jScrollPane_StageView.getHeight() / 2, null);
    }

    private void jButton_ZoomNullActionPerformed(ActionEvent evt) {
        this.setZoom(1.0, 0, 0, null);
    }

    private void jTextField_FindFilterMouseClicked(MouseEvent evt) {
        this.jTextField_FindFilter.selectAll();
    }

    private void jButton_ExportActionPerformed(ActionEvent evt) {
        this.exportHTML();
    }

    public void exportHTML() {
        int intRowCount = this.jTable_Device.getRowCount();
        if (intRowCount <= 0) {
            return;
        }
        if (!Export_HTML.export_Start(LiveShowDMXSystem.getLiveShowProjectDescription(), "DMX")) {
            return;
        }
        int intLabelCount = 12;
        int intIndexName = 0;
        int intIndexDMXUniverse = 1;
        int intIndexDMXStartAddress = 2;
        int intIndexDMXDeviceSectorChannelCount = 3;
        int intIndexDMXDeviceManufacturer = 4;
        int intIndexDMXDeviceType = 5;
        int intIndexPowerSource = 6;
        int intIndexWattage = 7;
        int intIndexDMXControl = 8;
        int intIndexControl = 9;
        int intIndexDimension = 10;
        int intIndexDuration = 11;
        ArrayList<Object> o_ArrayListLabels = new ArrayList<Object>(intLabelCount);
        ArrayList<Integer> o_ArrayListColumnFormats = new ArrayList<Integer>(intLabelCount);
        for (int intLabel = 0; intLabel < intLabelCount; ++intLabel) {
            o_ArrayListLabels.add(null);
            o_ArrayListColumnFormats.add(null);
        }
        o_ArrayListLabels.set(intIndexName, DMXDevice.DMXDeviceTableModel.COLUMN_DEVICENAME);
        o_ArrayListColumnFormats.set(intIndexName, 0);
        o_ArrayListLabels.set(intIndexDMXDeviceManufacturer, DMXDevice.DMXDeviceTableModel.COLUMN_DEVICEMANUFACTURER);
        o_ArrayListColumnFormats.set(intIndexDMXDeviceManufacturer, 0);
        o_ArrayListLabels.set(intIndexDMXDeviceType, DMXDevice.DMXDeviceTableModel.COLUMN_DEVICETYPE);
        o_ArrayListColumnFormats.set(intIndexDMXDeviceType, 0);
        o_ArrayListLabels.set(intIndexDMXDeviceSectorChannelCount, DMXDevice.DMXDeviceTableModel.COLUMN_DEVICECHANNELS);
        o_ArrayListColumnFormats.set(intIndexDMXDeviceSectorChannelCount, 2);
        o_ArrayListLabels.set(intIndexDMXUniverse, DMXDevice.DMXDeviceTableModel.COLUMN_DEVICEUNIVERSE);
        o_ArrayListColumnFormats.set(intIndexDMXUniverse, 0);
        o_ArrayListLabels.set(intIndexDMXStartAddress, DMXDevice.DMXDeviceTableModel.COLUMN_DEVICEADDRESS);
        o_ArrayListColumnFormats.set(intIndexDMXStartAddress, 2);
        o_ArrayListLabels.set(intIndexPowerSource, DMXDevice.DMXDeviceTableModel.COLUMN_DEVICEPOWERSOURCE);
        o_ArrayListColumnFormats.set(intIndexPowerSource, 0);
        o_ArrayListLabels.set(intIndexWattage, DMXDevice.DMXDeviceTableModel.COLUMN_DEVICEWATTAGE);
        o_ArrayListColumnFormats.set(intIndexWattage, 2);
        o_ArrayListLabels.set(intIndexDMXControl, XLS_COLUMNNAME_DMXCONTROL);
        o_ArrayListColumnFormats.set(intIndexDMXControl, 4);
        o_ArrayListLabels.set(intIndexControl, XLS_COLUMNNAME_CONTROL);
        o_ArrayListColumnFormats.set(intIndexControl, 4);
        o_ArrayListLabels.set(intIndexDimension, XLS_COLUMNNAME_DIMENSION);
        o_ArrayListColumnFormats.set(intIndexDimension, 4);
        o_ArrayListLabels.set(intIndexDuration, XLS_COLUMNNAME_CONSUMPTIONDURATION);
        o_ArrayListColumnFormats.set(intIndexDuration, 4);
        Export_HTML.export_TableStart(o_ArrayListLabels, o_ArrayListColumnFormats);
        ArrayList<ArrayList<Object>> o_ArrayList_DeviceElements = new ArrayList<ArrayList<Object>>();
        for (int intRow = 0; intRow < intRowCount; ++intRow) {
            DMXDevice o_DMXDevice;
            DMXDevice.InternalSector o_DMXDeviceInternalSector;
            try {
                int intModelRow = this.jTable_Device.convertRowIndexToModel(intRow);
                o_DMXDeviceInternalSector = DMXDevice.getTableModel().getDMXDeviceInternalSector(intModelRow);
                o_DMXDevice = o_DMXDeviceInternalSector.getDMXDevice();
            }
            catch (Exception e) {
                continue;
            }
            o_ArrayList_DeviceElements.clear();
            o_ArrayListLabels = new ArrayList(intLabelCount);
            for (int intLabel = 0; intLabel < intLabelCount; ++intLabel) {
                o_ArrayListLabels.add(null);
            }
            long longFrameDurationSum = 0L;
            int intInternalSectorCount = o_DMXDevice.getInternalSectorCount();
            String stringDeviceName = intInternalSectorCount > 1 ? o_DMXDevice.getName() + " (DMX " + (o_DMXDeviceInternalSector.getDMXDeviceSectorIndex() + 1) + ")" : o_DMXDevice.getName();
            o_ArrayListLabels.set(intIndexName, stringDeviceName);
            o_ArrayListLabels.set(intIndexDMXDeviceManufacturer, o_DMXDevice.getManufactureerName());
            o_ArrayListLabels.set(intIndexDMXDeviceType, o_DMXDevice.getDeviceTypeName());
            o_ArrayListLabels.set(intIndexDMXDeviceSectorChannelCount, String.valueOf(o_DMXDeviceInternalSector.getInternalChannelCount()));
            DMXUniverse o_DMXUniverse = o_DMXDeviceInternalSector.getDMXUniverse();
            if (o_DMXUniverse == null) {
                o_ArrayListLabels.set(intIndexDMXUniverse, null);
                o_ArrayListLabels.set(intIndexDMXStartAddress, null);
            } else {
                o_ArrayListLabels.set(intIndexDMXUniverse, o_DMXUniverse.getName());
                o_ArrayListLabels.set(intIndexDMXStartAddress, String.valueOf(o_DMXDeviceInternalSector.getDMXStartAddress() + 1));
            }
            DMXPowerSource o_DMXPowerSource = o_DMXDeviceInternalSector.getDMXPowerSource();
            if (o_DMXPowerSource == null) {
                o_ArrayListLabels.set(intIndexPowerSource, null);
            } else {
                o_ArrayListLabels.set(intIndexPowerSource, o_DMXPowerSource.getName());
            }
            o_ArrayListLabels.set(intIndexWattage, String.valueOf(o_DMXDeviceInternalSector.getWattage()));
            o_ArrayListLabels.set(intIndexDMXControl, null);
            o_ArrayListLabels.set(intIndexControl, null);
            o_ArrayListLabels.set(intIndexDimension, null);
            o_ArrayListLabels.set(intIndexDuration, null);
            o_ArrayList_DeviceElements.add(o_ArrayListLabels);
            LiveShowDMXVIP o_LiveShowDMXVIP = LiveShowDMXSystem.getLiveShowDMXVIP();
            int intDMXInterfacesCount = o_LiveShowDMXVIP.getLiveShowObjectInterfaceCount();
            DMXDeviceType o_DMXDeviceType = o_DMXDevice.getDMXDeviceType();
            for (int intDMXControl = 0; intDMXControl < o_DMXDevice.getDMXControlComponentCount(); ++intDMXControl) {
                DMXControlComponent o_DMXControlComponent = o_DMXDevice.getDMXControlComponent(intDMXControl);
                if (o_DMXControlComponent == null || !o_DMXControlComponent.getIsDimmer() && !o_DMXControlComponent.getIsDimmerSubstitute()) continue;
                for (int intControl = 0; intControl < o_DMXControlComponent.getControlTypeCount(); ++intControl) {
                    DMXControlComponent.ControlType o_ControlType = o_DMXControlComponent.getControlType(intControl);
                    if (o_ControlType == null) continue;
                    for (int intDimension = 0; intDimension < o_ControlType.getControlDimensionTypeCount(); ++intDimension) {
                        DMXControlComponent.ControlDimensionType o_ControlDimensionType = o_ControlType.getControlDimensionType(intDimension);
                        if (o_ControlDimensionType == null) continue;
                        long longFrameDuration = 0L;
                        for (int intLiveShowInterface = 0; intLiveShowInterface < intDMXInterfacesCount; ++intLiveShowInterface) {
                            LiveShowObjectInterface o_LiveShowObjectInterface = o_LiveShowDMXVIP.getLiveShowObjectInterface(intLiveShowInterface);
                            if (o_LiveShowObjectInterface == null || !(o_LiveShowObjectInterface instanceof LiveShowDMXObject)) continue;
                            LiveShowDMXObject o_LiveShowDMXObject = (LiveShowDMXObject)o_LiveShowObjectInterface;
                            longFrameDuration += o_LiveShowDMXObject.getFrameDuration_consumption(o_DMXDevice, o_DMXControlComponent, intControl, intDimension);
                        }
                        if (longFrameDuration <= 0L) continue;
                        o_ArrayListLabels = new ArrayList(intLabelCount);
                        for (int intLabel = 0; intLabel < intLabelCount; ++intLabel) {
                            o_ArrayListLabels.add(null);
                        }
                        o_ArrayListLabels.set(intIndexDMXControl, o_DMXControlComponent.getName());
                        if (o_DMXControlComponent.getControlObjectCount() > 1) {
                            o_ArrayListLabels.set(intIndexControl, o_ControlType.getName());
                        }
                        if (o_ControlType.getControlDimensionTypeCount() > 1) {
                            o_ArrayListLabels.set(intIndexDimension, o_ControlDimensionType.getName());
                        }
                        o_ArrayListLabels.set(intIndexDuration, LiveShowObject.getTimeStringFromMillis((long)((double)longFrameDuration * LiveShowVIP.getFRAMETIME())));
                        longFrameDurationSum += longFrameDuration;
                        o_ArrayList_DeviceElements.add(o_ArrayListLabels);
                    }
                }
            }
            o_ArrayListLabels = (ArrayList)o_ArrayList_DeviceElements.get(0);
            if (longFrameDurationSum > 0L) {
                o_ArrayListLabels.set(intIndexDuration, LiveShowObject.getTimeStringFromMillis((long)((double)longFrameDurationSum * LiveShowVIP.getFRAMETIME())));
            }
            Export_HTML.export_TableAddRow(o_ArrayListLabels);
            if (o_ArrayList_DeviceElements.size() <= 2) continue;
            for (int intElement = 1; intElement < o_ArrayList_DeviceElements.size(); ++intElement) {
                o_ArrayListLabels = (ArrayList)o_ArrayList_DeviceElements.get(intElement);
                Export_HTML.export_TableAddRow(o_ArrayListLabels);
            }
        }
        Export_HTML.export_End();
    }

    private void jButton_InvertDMXDeviceFilterActionPerformed(ActionEvent evt) {
        if (!DMXDeviceFilter.getInvertFilter()) {
            DMXDeviceFilter.setInvertFilter(true);
        } else {
            DMXDeviceFilter.setInvertFilter(false);
        }
        this.filterDMXDevices();
        this.refreshUI();
    }

    private void jButton_ShowDMXDeviceGroupsActionPerformed(ActionEvent evt) {
        DMXDeviceGroupPanel.showFrame();
    }

    private void jButton_DMXSceneFilterActionPerformed(ActionEvent evt) {
        LiveShowDMXSceneView o_LiveShowDMXSceneView = LiveShowDMXSceneView.s_SelfReference;
        o_LiveShowDMXSceneView.filterDMXScenes(DMXSceneFilter.s_DMXSceneFilterDevice);
        LiveShowDMXSceneView.toFront();
    }

    private void jCheckBox_EnableGridActionPerformed(ActionEvent evt) {
        LiveShowDMXStageView.setGridEnabled(this.jCheckBox_EnableGrid.isSelected());
    }

    private void jTextField_GridWidthFocusLost(FocusEvent evt) {
        try {
            int intGridWidth = Integer.decode(this.jTextField_GridWidth.getText());
            LiveShowDMXStageView.setGridWidth(intGridWidth);
        }
        catch (Exception e) {
            this.refreshUI();
        }
    }

    private void jTextField_GridWidthKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            try {
                int intGridWidth = Integer.decode(this.jTextField_GridWidth.getText());
                LiveShowDMXStageView.setGridWidth(intGridWidth);
            }
            catch (Exception e) {
                this.refreshUI();
            }
        }
    }

    private void jTextField_FindFilter_DocumentChanged() {
        String stringFilter = this.jTextField_FindFilter.getText();
        TableAndListModel.ListModel<DMXDeviceFilter> o_LiveShowListModel_DMXDeviceFilter = this.m_DMXDeviceFilterListModelWrapper.getListModel();
        o_LiveShowListModel_DMXDeviceFilter.filterByName(stringFilter);
        DMXDeviceFilter o_DMXDeviceFilter = o_LiveShowListModel_DMXDeviceFilter.size() == 2 ? o_LiveShowListModel_DMXDeviceFilter.get(1) : (stringFilter.length() <= 0 ? DMXDeviceFilter.s_DMXDeviceFilterAll : this.getSingleDMXDeviceFilter_DMXDevice());
        if (o_DMXDeviceFilter != null) {
            this.jComboBox_DMXDeviceFilter.setSelectedItem(o_DMXDeviceFilter);
            this.jComboBox_DMXDeviceFilter.repaint();
        }
    }

    public DMXDeviceFilter getSingleDMXDeviceFilter_DMXDevice() {
        DMXDeviceFilter o_DMXDeviceFilter = null;
        DMXDeviceFilter o_DMXDeviceFilterFound = null;
        TableAndListModel.ListModel<DMXDeviceFilter> o_LiveShowListModel_DMXDeviceFilter = this.m_DMXDeviceFilterListModelWrapper.getListModel();
        if (o_LiveShowListModel_DMXDeviceFilter.size() <= 1) {
            return null;
        }
        for (int intFilter = 1; intFilter < o_LiveShowListModel_DMXDeviceFilter.size(); ++intFilter) {
            o_DMXDeviceFilter = o_LiveShowListModel_DMXDeviceFilter.get(intFilter);
            if (!(o_DMXDeviceFilter.getFilterInterface() instanceof DMXDevice)) continue;
            if (o_DMXDeviceFilterFound != null) {
                return null;
            }
            o_DMXDeviceFilterFound = o_DMXDeviceFilter;
        }
        return o_DMXDeviceFilterFound;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!(evt.getSource() instanceof DMXDevice) || "dmxdeviceUniverse".equals(evt.getPropertyName())) {
            // empty if block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addLiveShowStageViewListener(LiveShowDMXStageViewListener p_LiveShowDMXStageViewListener) {
        if (p_LiveShowDMXStageViewListener == null) {
            return;
        }
        Object object = s_SyncStageViewListener;
        synchronized (object) {
            if (s_StageViewListeners.contains(p_LiveShowDMXStageViewListener)) {
                return;
            }
            s_StageViewListeners.add(p_LiveShowDMXStageViewListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeLiveShowStageViewListener(LiveShowDMXStageViewListener p_LiveShowDMXStageViewListener) {
        if (p_LiveShowDMXStageViewListener == null) {
            return;
        }
        Object object = s_SyncStageViewListener;
        synchronized (object) {
            s_StageViewListeners.add(p_LiveShowDMXStageViewListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyDMXDeviceViewAdded(DMXDeviceView p_DMXDeviceView) {
        ArrayList<LiveShowDMXStageViewListener> o_StageViewListeners;
        if (p_DMXDeviceView == null) {
            return;
        }
        Object object = s_SyncStageViewListener;
        synchronized (object) {
            if (s_StageViewListeners.size() <= 0) {
                return;
            }
            o_StageViewListeners = new ArrayList<LiveShowDMXStageViewListener>(s_StageViewListeners.size());
            o_StageViewListeners.addAll(s_StageViewListeners);
        }
        for (int intListener = 0; intListener < o_StageViewListeners.size(); ++intListener) {
            LiveShowDMXStageViewListener o_StageViewListener = (LiveShowDMXStageViewListener)o_StageViewListeners.get(intListener);
            if (o_StageViewListener == null) continue;
            o_StageViewListener.eventDMXDeviceViewAdded(p_DMXDeviceView);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyDMXDeviceViewRemoved(DMXDeviceView p_DMXDeviceView) {
        ArrayList<LiveShowDMXStageViewListener> o_StageViewListeners;
        if (p_DMXDeviceView == null) {
            return;
        }
        Object object = s_SyncStageViewListener;
        synchronized (object) {
            if (s_StageViewListeners.size() <= 0) {
                return;
            }
            o_StageViewListeners = new ArrayList<LiveShowDMXStageViewListener>(s_StageViewListeners.size());
            o_StageViewListeners.addAll(s_StageViewListeners);
        }
        for (int intListener = 0; intListener < o_StageViewListeners.size(); ++intListener) {
            LiveShowDMXStageViewListener o_StageViewListener = (LiveShowDMXStageViewListener)o_StageViewListeners.get(intListener);
            if (o_StageViewListener == null) continue;
            o_StageViewListener.eventDMXDeviceViewRemoved(p_DMXDeviceView);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyDMXDeviceViewSelected(DMXDeviceView p_DMXDeviceView, boolean p_Selected) {
        ArrayList<LiveShowDMXStageViewListener> o_StageViewListeners;
        if (p_DMXDeviceView == null) {
            return;
        }
        Object object = s_SyncStageViewListener;
        synchronized (object) {
            if (s_StageViewListeners.size() <= 0) {
                return;
            }
            o_StageViewListeners = new ArrayList<LiveShowDMXStageViewListener>(s_StageViewListeners.size());
            o_StageViewListeners.addAll(s_StageViewListeners);
        }
        for (int intListener = 0; intListener < o_StageViewListeners.size(); ++intListener) {
            LiveShowDMXStageViewListener o_StageViewListener = (LiveShowDMXStageViewListener)o_StageViewListeners.get(intListener);
            if (o_StageViewListener == null) continue;
            o_StageViewListener.eventDMXDeviceViewSelected(p_DMXDeviceView, p_Selected);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyDMXDeviceViewChanged(DMXDeviceView p_DMXDeviceView) {
        ArrayList<LiveShowDMXStageViewListener> o_StageViewListeners;
        if (p_DMXDeviceView == null) {
            return;
        }
        Object object = s_SyncStageViewListener;
        synchronized (object) {
            if (s_StageViewListeners.size() <= 0) {
                return;
            }
            o_StageViewListeners = new ArrayList<LiveShowDMXStageViewListener>(s_StageViewListeners.size());
            o_StageViewListeners.addAll(s_StageViewListeners);
        }
        for (int intListener = 0; intListener < o_StageViewListeners.size(); ++intListener) {
            LiveShowDMXStageViewListener o_StageViewListener = (LiveShowDMXStageViewListener)o_StageViewListeners.get(intListener);
            if (o_StageViewListener == null) continue;
            o_StageViewListener.eventDMXDeviceViewChanged(p_DMXDeviceView);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyDMXControlComponentAdded(DMXControlComponent p_DMXControlComponent, int p_Index) {
        ArrayList<LiveShowDMXStageViewListener> o_StageViewListeners;
        if (p_DMXControlComponent == null) {
            return;
        }
        Object object = s_SyncStageViewListener;
        synchronized (object) {
            if (s_StageViewListeners.size() <= 0) {
                return;
            }
            o_StageViewListeners = new ArrayList<LiveShowDMXStageViewListener>(s_StageViewListeners.size());
            o_StageViewListeners.addAll(s_StageViewListeners);
        }
        for (int intListener = 0; intListener < o_StageViewListeners.size(); ++intListener) {
            LiveShowDMXStageViewListener o_StageViewListener = (LiveShowDMXStageViewListener)o_StageViewListeners.get(intListener);
            if (o_StageViewListener == null) continue;
            o_StageViewListener.eventDMXControlComponentAdded(p_DMXControlComponent, p_Index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyDMXControlComponentRemoved(DMXControlComponent p_DMXControlComponent, int p_Index) {
        ArrayList<LiveShowDMXStageViewListener> o_StageViewListeners;
        if (p_DMXControlComponent == null) {
            return;
        }
        Object object = s_SyncStageViewListener;
        synchronized (object) {
            if (s_StageViewListeners.size() <= 0) {
                return;
            }
            o_StageViewListeners = new ArrayList<LiveShowDMXStageViewListener>(s_StageViewListeners.size());
            o_StageViewListeners.addAll(s_StageViewListeners);
        }
        for (int intListener = 0; intListener < o_StageViewListeners.size(); ++intListener) {
            LiveShowDMXStageViewListener o_StageViewListener = (LiveShowDMXStageViewListener)o_StageViewListeners.get(intListener);
            if (o_StageViewListener == null) continue;
            o_StageViewListener.eventDMXControlComponentRemoved(p_DMXControlComponent, p_Index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyDMXControlComponentVisible(DMXControlComponent p_DMXControlComponent, int p_Index, boolean p_Visible) {
        ArrayList<LiveShowDMXStageViewListener> o_StageViewListeners;
        if (p_DMXControlComponent == null) {
            return;
        }
        Object object = s_SyncStageViewListener;
        synchronized (object) {
            if (s_StageViewListeners.size() <= 0) {
                return;
            }
            o_StageViewListeners = new ArrayList<LiveShowDMXStageViewListener>(s_StageViewListeners.size());
            o_StageViewListeners.addAll(s_StageViewListeners);
        }
        for (int intListener = 0; intListener < o_StageViewListeners.size(); ++intListener) {
            LiveShowDMXStageViewListener o_StageViewListener = (LiveShowDMXStageViewListener)o_StageViewListeners.get(intListener);
            if (o_StageViewListener == null) continue;
            o_StageViewListener.eventDMXControlComponentVisible(p_DMXControlComponent, p_Index, p_Visible);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyControlGroupsChangeType(int p_ControlGroupsChangeType) {
        ArrayList<LiveShowDMXStageViewListener> o_StageViewListeners;
        Object object = s_SyncStageViewListener;
        synchronized (object) {
            if (s_StageViewListeners.size() <= 0) {
                return;
            }
            o_StageViewListeners = new ArrayList<LiveShowDMXStageViewListener>(s_StageViewListeners.size());
            o_StageViewListeners.addAll(s_StageViewListeners);
        }
        for (int intListener = 0; intListener < o_StageViewListeners.size(); ++intListener) {
            LiveShowDMXStageViewListener o_StageViewListener = (LiveShowDMXStageViewListener)o_StageViewListeners.get(intListener);
            if (o_StageViewListener == null) continue;
            o_StageViewListener.eventControlGroupsChangeType(p_ControlGroupsChangeType);
        }
    }

    static {
        s_SyncStageViewListener = new Object();
    }

    public static interface LiveShowDMXStageViewListener {
        public void eventDMXDeviceGroupAdded(DMXDeviceGroup var1);

        public void eventDMXDeviceGroupRemoved(DMXDeviceGroup var1);

        public void eventDMXDeviceGroupChanged(DMXDeviceGroup var1);

        public void eventDMXUniverseAdded(DMXUniverse var1);

        public void eventDMXUniverseRemoved(DMXUniverse var1);

        public void eventDMXUniverseChanged(DMXUniverse var1);

        public void eventDMXDeviceViewAdded(DMXDeviceView var1);

        public void eventDMXDeviceViewRemoved(DMXDeviceView var1);

        public void eventDMXDeviceViewChanged(DMXDeviceView var1);

        public void eventDMXDeviceViewSelected(DMXDeviceView var1, boolean var2);

        public void eventDMXControlComponentAdded(DMXControlComponent var1, int var2);

        public void eventDMXControlComponentRemoved(DMXControlComponent var1, int var2);

        public void eventDMXControlComponentVisible(DMXControlComponent var1, int var2, boolean var3);

        public void eventControlGroupsChangeType(int var1);
    }

    public static class DividerBorder
    implements Border {
        private Insets m_Insets;
        private int m_ReduceLine;

        public DividerBorder() {
            this.initMembers();
        }

        private void initMembers() {
            this.m_Insets = new Insets(0, 0, 0, 0);
            this.m_ReduceLine = 20;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Color o_ColorOld = g.getColor();
            g.setColor(Color.DARK_GRAY);
            g.drawLine(width / 2, this.m_ReduceLine, width / 2, height - this.m_ReduceLine);
            g.setColor(o_ColorOld);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.m_Insets;
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }
    }
}

