/*
 * Decompiled with CFR 0.152.
 */
package DMXGraphics;

import DMXDevicePackage.DMXDeviceFilter;
import DMXGraphics.LiveShowDMXStageView;
import DMXScenePackage.DMXScene;
import DMXScenePackage.DMXSceneFilter;
import DMXVirtualPackage.LiveShowDMXObjectDescription;
import DMXVirtualPackage.LiveShowDMXVIP;
import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LanguageTools.LiveLanguagePackage.LiveLanguageString;
import LiveShowObjectPackage.LiveShowDragDrop;
import LiveShowObjectPackage.LiveShowObjectInterface;
import LiveShowVirtualPackage.LiveShowSceneBridge;
import StartPackage.LiveShowDMXSystem;
import SwingFramePackage.JOptionDialog;
import SwingToolTipPackage.PopUpToolTip;
import ToolsGraphics.JLabel_ResizeFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableRowSorter;

public class LiveShowDMXSceneView
extends JPanel
implements DragGestureListener,
DragSourceListener,
ListSelectionListener {
    @LiveLanguageString
    public static String DELETE_SELECTEDSCENE = "<html>Deleting of a ligth ambiance cannot be reversed!<br>All objects which uses this ligth ambiances will be deleted too.<br>Do you really want to delete the selected ligth ambiances?</html>";
    @LiveLanguageString
    public static String DELETESELECTEDSCENE_TITEL = "Delete selected scene";
    @LiveLanguageString
    public static String REMOVE_UNUSEDSCENES = "<html>Deleting of ligth ambiances cannot be reversed.<br>Do you really want to delete the unused ligth ambiances?</html>";
    @LiveLanguageString
    public static String REMOVE_UNUSEDSCENES_TITEL = "Delete unused ligth ambiances";
    private DMXScene m_SelectedDMXScene;
    private DragSource m_DragSource;
    private Border m_BorderButtonSelected;
    private Border m_BorderButtonNormal;
    private Border m_BorderFilterActive;
    private Border m_BorderFilterActiveInverted;
    private DMXSceneFilter m_SelectedDMXSceneFilter;
    public static LiveShowDMXSceneView s_SelfReference;
    private JButton jButton_CleanUpScene;
    private JButton jButton_CopyDMXScene;
    private JButton jButton_FilterDevices;
    private JButton jButton_InvertDMXSceneFilter;
    private JButton jButton_LightToScene;
    private JButton jButton_NewScene;
    private JButton jButton_RemoveScene;
    private JButton jButton_RemoveUnused;
    private JButton jButton_SceneToLight;
    private JButton jButton_ShowInTimeline;
    private JComboBox<DMXSceneFilter> jComboBox_Filter;
    private JLabel_ResizeFrame jLabel_ResizeFrame1;
    private JPanel jPanel_DMXScenes;
    private JPanel jPanel_Edit;
    private JPanel jPanel_Filter;
    private JPanel jPanel_Show;
    private JScrollPane jScrollPane_DMXScenes;
    private JTable jTable_DMXScenes;
    private JTextField jTextField_FilterDMXScene;

    public LiveShowDMXSceneView() {
        this.initMembers();
        this.initComponents();
        this.initComponentsFurther();
        LiveLanguage.addLanguageListener((Object)this, null);
        this.filterDMXScenes(DMXSceneFilter.s_DMXSceneFilterAll);
        this.refreshUI();
    }

    private void initMembers() {
        s_SelfReference = this;
        this.m_SelectedDMXScene = null;
        this.m_BorderButtonNormal = new EmptyBorder(1, 1, 1, 1);
        this.m_BorderButtonSelected = new LineBorder(Color.BLUE, 1);
        this.m_BorderFilterActive = new LineBorder(Color.GREEN, 1);
        this.m_BorderFilterActiveInverted = new LineBorder(Color.RED, 1);
        this.m_SelectedDMXSceneFilter = null;
    }

    private void initComponentsFurther() {
        this.jScrollPane_DMXScenes.getViewport().setBackground(Color.BLACK);
        this.jTable_DMXScenes.setModel(DMXScene.getDMXSceneTableModel());
        DMXScene.getDMXSceneTableModel().finishJTable(this.jTable_DMXScenes);
        this.jTable_DMXScenes.getSelectionModel().addListSelectionListener(this);
        this.jTable_DMXScenes.setRowHeight(24);
        this.m_DragSource = new DragSource();
        this.m_DragSource.createDefaultDragGestureRecognizer(this.jTable_DMXScenes, 2, this);
        this.jComboBox_Filter.setModel(DMXSceneFilter.getListModel());
        this.jComboBox_Filter.setRenderer(DMXSceneFilter.getListCellRenderer());
        this.jTextField_FilterDMXScene.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                LiveShowDMXSceneView.this.jTextField_FilterDMXScene_DocumentChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                LiveShowDMXSceneView.this.jTextField_FilterDMXScene_DocumentChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                LiveShowDMXSceneView.this.jTextField_FilterDMXScene_DocumentChanged();
            }
        });
        this.jTextField_FilterDMXScene.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 8 || e.getKeyCode() == 127 || e.getKeyCode() == 10) {
                    LiveShowDMXSceneView.this.jTextField_FilterDMXScene_DocumentChanged();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
        this.jButton_InvertDMXSceneFilter.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jTable_DMXScenes.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_FilterDevices.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_ShowInTimeline.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_LightToScene.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_NewScene.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_CleanUpScene.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_RemoveScene.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_RemoveUnused.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_SceneToLight.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jTextField_FilterDMXScene.setComponentPopupMenu(PopUpToolTip.getSelfReference());
    }

    public JLabel_ResizeFrame getLabel_ResizeFrame() {
        return this.jLabel_ResizeFrame1;
    }

    private void initComponents() {
        this.jPanel_DMXScenes = new JPanel();
        this.jScrollPane_DMXScenes = new JScrollPane();
        this.jTable_DMXScenes = new JTable();
        this.jLabel_ResizeFrame1 = new JLabel_ResizeFrame();
        this.jPanel_Filter = new JPanel();
        this.jButton_InvertDMXSceneFilter = new JButton();
        this.jTextField_FilterDMXScene = new JTextField();
        this.jComboBox_Filter = new JComboBox();
        this.jPanel_Edit = new JPanel();
        this.jButton_NewScene = new JButton();
        this.jButton_LightToScene = new JButton();
        this.jButton_RemoveScene = new JButton();
        this.jButton_RemoveUnused = new JButton();
        this.jButton_CopyDMXScene = new JButton();
        this.jButton_CleanUpScene = new JButton();
        this.jPanel_Show = new JPanel();
        this.jButton_FilterDevices = new JButton();
        this.jButton_ShowInTimeline = new JButton();
        this.jButton_SceneToLight = new JButton();
        this.setPreferredSize(new Dimension(450, 500));
        this.setLayout(new GridBagLayout());
        this.jPanel_DMXScenes.setMinimumSize(new Dimension(200, 200));
        this.jPanel_DMXScenes.setPreferredSize(new Dimension(300, 300));
        this.jPanel_DMXScenes.setRequestFocusEnabled(false);
        this.jPanel_DMXScenes.setLayout(new GridBagLayout());
        this.jTable_DMXScenes.setFont(new Font("Tahoma", 0, 14));
        this.jTable_DMXScenes.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTable_DMXScenes.setAutoResizeMode(4);
        this.jTable_DMXScenes.setRowHeight(20);
        this.jTable_DMXScenes.setSelectionMode(0);
        this.jScrollPane_DMXScenes.setViewportView(this.jTable_DMXScenes);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel_DMXScenes.add((Component)this.jScrollPane_DMXScenes, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jPanel_DMXScenes, gridBagConstraints);
        this.jLabel_ResizeFrame1.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 14;
        this.add((Component)this.jLabel_ResizeFrame1, gridBagConstraints);
        this.jPanel_Filter.setMinimumSize(new Dimension(100, 38));
        this.jPanel_Filter.setPreferredSize(new Dimension(100, 38));
        this.jPanel_Filter.setLayout(new GridBagLayout());
        this.jButton_InvertDMXSceneFilter.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/DMXScene_Filter.png")));
        this.jButton_InvertDMXSceneFilter.setToolTipText("inverts the selected light ambience filter");
        this.jButton_InvertDMXSceneFilter.setContentAreaFilled(false);
        this.jButton_InvertDMXSceneFilter.setFocusable(false);
        this.jButton_InvertDMXSceneFilter.setHorizontalTextPosition(0);
        this.jButton_InvertDMXSceneFilter.setIconTextGap(0);
        this.jButton_InvertDMXSceneFilter.setMargin(new Insets(0, 0, 0, 0));
        this.jButton_InvertDMXSceneFilter.setMaximumSize(new Dimension(32, 32));
        this.jButton_InvertDMXSceneFilter.setMinimumSize(new Dimension(32, 32));
        this.jButton_InvertDMXSceneFilter.setPreferredSize(new Dimension(32, 32));
        this.jButton_InvertDMXSceneFilter.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_InvertDMXSceneFilter.setVerticalTextPosition(3);
        this.jButton_InvertDMXSceneFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowDMXSceneView.this.jButton_InvertDMXSceneFilterActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Filter.add((Component)this.jButton_InvertDMXSceneFilter, gridBagConstraints);
        this.jTextField_FilterDMXScene.setFont(new Font("Tahoma", 0, 14));
        this.jTextField_FilterDMXScene.setToolTipText("insert search-string");
        this.jTextField_FilterDMXScene.setMinimumSize(new Dimension(60, 24));
        this.jTextField_FilterDMXScene.setPreferredSize(new Dimension(60, 24));
        this.jTextField_FilterDMXScene.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                LiveShowDMXSceneView.this.jTextField_FilterDMXSceneMouseClicked(evt);
            }
        });
        this.jTextField_FilterDMXScene.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                LiveShowDMXSceneView.this.jTextField_FilterDMXSceneKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.3;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Filter.add((Component)this.jTextField_FilterDMXScene, gridBagConstraints);
        this.jComboBox_Filter.setMinimumSize(new Dimension(63, 24));
        this.jComboBox_Filter.setName("");
        this.jComboBox_Filter.setPreferredSize(new Dimension(63, 24));
        this.jComboBox_Filter.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                LiveShowDMXSceneView.this.jComboBox_FilterItemStateChanged(evt);
            }
        });
        this.jComboBox_Filter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowDMXSceneView.this.jComboBox_FilterActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.3;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Filter.add(this.jComboBox_Filter, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jPanel_Filter, gridBagConstraints);
        this.jPanel_Edit.setMinimumSize(new Dimension(300, 38));
        this.jPanel_Edit.setPreferredSize(new Dimension(300, 38));
        this.jPanel_Edit.setLayout(new GridBagLayout());
        this.jButton_NewScene.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Edit_Plus.png")));
        this.jButton_NewScene.setToolTipText("Add new scene");
        this.jButton_NewScene.setContentAreaFilled(false);
        this.jButton_NewScene.setFocusable(false);
        this.jButton_NewScene.setHorizontalTextPosition(0);
        this.jButton_NewScene.setIconTextGap(0);
        this.jButton_NewScene.setMargin(new Insets(2, 2, 2, 2));
        this.jButton_NewScene.setMaximumSize(new Dimension(36, 36));
        this.jButton_NewScene.setMinimumSize(new Dimension(36, 36));
        this.jButton_NewScene.setPreferredSize(new Dimension(36, 36));
        this.jButton_NewScene.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_NewScene.setVerticalTextPosition(3);
        this.jButton_NewScene.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowDMXSceneView.this.jButton_NewSceneActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Edit.add((Component)this.jButton_NewScene, gridBagConstraints);
        this.jButton_LightToScene.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Device_Read.png")));
        this.jButton_LightToScene.setToolTipText("Overwrite selected scene");
        this.jButton_LightToScene.setContentAreaFilled(false);
        this.jButton_LightToScene.setFocusable(false);
        this.jButton_LightToScene.setHorizontalTextPosition(0);
        this.jButton_LightToScene.setIconTextGap(0);
        this.jButton_LightToScene.setMargin(new Insets(0, 0, 0, 0));
        this.jButton_LightToScene.setMaximumSize(new Dimension(64, 32));
        this.jButton_LightToScene.setMinimumSize(new Dimension(64, 32));
        this.jButton_LightToScene.setPreferredSize(new Dimension(64, 32));
        this.jButton_LightToScene.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed_Wide.png")));
        this.jButton_LightToScene.setVerticalTextPosition(3);
        this.jButton_LightToScene.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowDMXSceneView.this.jButton_LightToSceneActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Edit.add((Component)this.jButton_LightToScene, gridBagConstraints);
        this.jButton_RemoveScene.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Delete.png")));
        this.jButton_RemoveScene.setToolTipText("Remove selected scene");
        this.jButton_RemoveScene.setContentAreaFilled(false);
        this.jButton_RemoveScene.setFocusable(false);
        this.jButton_RemoveScene.setHorizontalTextPosition(0);
        this.jButton_RemoveScene.setIconTextGap(0);
        this.jButton_RemoveScene.setMargin(new Insets(0, 0, 0, 0));
        this.jButton_RemoveScene.setMaximumSize(new Dimension(32, 32));
        this.jButton_RemoveScene.setMinimumSize(new Dimension(32, 32));
        this.jButton_RemoveScene.setPreferredSize(new Dimension(32, 32));
        this.jButton_RemoveScene.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_RemoveScene.setVerticalTextPosition(3);
        this.jButton_RemoveScene.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowDMXSceneView.this.jButton_RemoveSceneActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Edit.add((Component)this.jButton_RemoveScene, gridBagConstraints);
        this.jButton_RemoveUnused.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Edit_Sweep.png")));
        this.jButton_RemoveUnused.setToolTipText("Delete all unused scenes");
        this.jButton_RemoveUnused.setContentAreaFilled(false);
        this.jButton_RemoveUnused.setFocusable(false);
        this.jButton_RemoveUnused.setHorizontalTextPosition(0);
        this.jButton_RemoveUnused.setIconTextGap(0);
        this.jButton_RemoveUnused.setMargin(new Insets(0, 0, 0, 0));
        this.jButton_RemoveUnused.setMaximumSize(new Dimension(64, 32));
        this.jButton_RemoveUnused.setMinimumSize(new Dimension(64, 32));
        this.jButton_RemoveUnused.setPreferredSize(new Dimension(64, 32));
        this.jButton_RemoveUnused.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed_Wide.png")));
        this.jButton_RemoveUnused.setVerticalTextPosition(3);
        this.jButton_RemoveUnused.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowDMXSceneView.this.jButton_RemoveUnusedActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Edit.add((Component)this.jButton_RemoveUnused, gridBagConstraints);
        this.jButton_CopyDMXScene.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Edit_Copy.png")));
        this.jButton_CopyDMXScene.setToolTipText("Copy selected ambiance");
        this.jButton_CopyDMXScene.setContentAreaFilled(false);
        this.jButton_CopyDMXScene.setFocusable(false);
        this.jButton_CopyDMXScene.setHorizontalTextPosition(0);
        this.jButton_CopyDMXScene.setIconTextGap(0);
        this.jButton_CopyDMXScene.setMargin(new Insets(0, 0, 0, 0));
        this.jButton_CopyDMXScene.setMaximumSize(new Dimension(32, 32));
        this.jButton_CopyDMXScene.setMinimumSize(new Dimension(32, 32));
        this.jButton_CopyDMXScene.setPreferredSize(new Dimension(32, 32));
        this.jButton_CopyDMXScene.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_CopyDMXScene.setVerticalTextPosition(3);
        this.jButton_CopyDMXScene.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowDMXSceneView.this.jButton_CopyDMXSceneActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Edit.add((Component)this.jButton_CopyDMXScene, gridBagConstraints);
        this.jButton_CleanUpScene.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Slider_DeviceSweepValues.png")));
        this.jButton_CleanUpScene.setToolTipText("<html>Clean up selected lighting ambiance.<br>All values of lamps that are not on in the lighting ambiance<br>will be set to 0.</html> ");
        this.jButton_CleanUpScene.setContentAreaFilled(false);
        this.jButton_CleanUpScene.setFocusable(false);
        this.jButton_CleanUpScene.setHorizontalTextPosition(0);
        this.jButton_CleanUpScene.setIconTextGap(0);
        this.jButton_CleanUpScene.setMargin(new Insets(0, 0, 0, 0));
        this.jButton_CleanUpScene.setMaximumSize(new Dimension(32, 32));
        this.jButton_CleanUpScene.setMinimumSize(new Dimension(32, 32));
        this.jButton_CleanUpScene.setPreferredSize(new Dimension(32, 32));
        this.jButton_CleanUpScene.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed_Wide.png")));
        this.jButton_CleanUpScene.setVerticalTextPosition(3);
        this.jButton_CleanUpScene.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowDMXSceneView.this.jButton_CleanUpSceneActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Edit.add((Component)this.jButton_CleanUpScene, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jPanel_Edit, gridBagConstraints);
        this.jPanel_Show.setForeground(new Color(255, 255, 255));
        this.jPanel_Show.setMinimumSize(new Dimension(200, 38));
        this.jPanel_Show.setPreferredSize(new Dimension(200, 38));
        this.jPanel_Show.setLayout(new GridBagLayout());
        this.jButton_FilterDevices.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Device_Filter.png")));
        this.jButton_FilterDevices.setToolTipText("Show devices used in this lightscene");
        this.jButton_FilterDevices.setContentAreaFilled(false);
        this.jButton_FilterDevices.setFocusable(false);
        this.jButton_FilterDevices.setHorizontalTextPosition(0);
        this.jButton_FilterDevices.setIconTextGap(0);
        this.jButton_FilterDevices.setMargin(new Insets(0, 0, 0, 0));
        this.jButton_FilterDevices.setMaximumSize(new Dimension(32, 32));
        this.jButton_FilterDevices.setMinimumSize(new Dimension(32, 32));
        this.jButton_FilterDevices.setPreferredSize(new Dimension(32, 32));
        this.jButton_FilterDevices.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_FilterDevices.setVerticalTextPosition(3);
        this.jButton_FilterDevices.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowDMXSceneView.this.jButton_FilterDevicesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Show.add((Component)this.jButton_FilterDevices, gridBagConstraints);
        this.jButton_ShowInTimeline.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Timeline_Selection.png")));
        this.jButton_ShowInTimeline.setToolTipText("Selects all objects in timeline using this scene.");
        this.jButton_ShowInTimeline.setContentAreaFilled(false);
        this.jButton_ShowInTimeline.setFocusable(false);
        this.jButton_ShowInTimeline.setHorizontalTextPosition(0);
        this.jButton_ShowInTimeline.setIconTextGap(0);
        this.jButton_ShowInTimeline.setMargin(new Insets(0, 0, 0, 0));
        this.jButton_ShowInTimeline.setMaximumSize(new Dimension(32, 32));
        this.jButton_ShowInTimeline.setMinimumSize(new Dimension(32, 32));
        this.jButton_ShowInTimeline.setPreferredSize(new Dimension(32, 32));
        this.jButton_ShowInTimeline.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_ShowInTimeline.setVerticalTextPosition(3);
        this.jButton_ShowInTimeline.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowDMXSceneView.this.jButton_ShowInTimelineActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Show.add((Component)this.jButton_ShowInTimeline, gridBagConstraints);
        this.jButton_SceneToLight.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Device_Write.png")));
        this.jButton_SceneToLight.setToolTipText("Show selected scene");
        this.jButton_SceneToLight.setContentAreaFilled(false);
        this.jButton_SceneToLight.setFocusable(false);
        this.jButton_SceneToLight.setHorizontalTextPosition(0);
        this.jButton_SceneToLight.setIconTextGap(0);
        this.jButton_SceneToLight.setMargin(null);
        this.jButton_SceneToLight.setMaximumSize(new Dimension(64, 32));
        this.jButton_SceneToLight.setMinimumSize(new Dimension(64, 32));
        this.jButton_SceneToLight.setPreferredSize(new Dimension(66, 36));
        this.jButton_SceneToLight.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed_Wide.png")));
        this.jButton_SceneToLight.setVerticalTextPosition(3);
        this.jButton_SceneToLight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowDMXSceneView.this.jButton_SceneToLightActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Show.add((Component)this.jButton_SceneToLight, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jPanel_Show, gridBagConstraints);
    }

    public void newDMXScene() {
        DMXScene o_DMXScene = new DMXScene();
        DMXScene.addDMXScene(o_DMXScene);
        this.setSelectedDMXScene(o_DMXScene);
        o_DMXScene.saveDMXSceneLight();
    }

    public void removeDMXScene(DMXScene p_DMXScene) {
        if (p_DMXScene == null) {
            return;
        }
        DMXScene.removeDMXScene(p_DMXScene, false);
        this.setSelectedDMXScene(null);
    }

    public DMXScene getDMXScene(int p_Index) {
        if (p_Index < 0 || p_Index >= DMXScene.getDMXSceneCount()) {
            return null;
        }
        return DMXScene.getDMXScene(p_Index);
    }

    public int getDMXSceneCount() {
        return DMXScene.getDMXSceneCount();
    }

    public void clearSelectedDMXScenes() {
        this.setSelectedDMXScene(null);
    }

    public void setSelectedDMXScene(DMXScene p_DMXScene) {
        DMXScene.DMXSceneTableModel o_DMXSceneTableModel = DMXScene.getDMXSceneTableModel();
        if (p_DMXScene == null) {
            o_DMXSceneTableModel.clearSelection(this.jTable_DMXScenes);
        } else {
            o_DMXSceneTableModel.setSelectedElement(this.jTable_DMXScenes, p_DMXScene);
            o_DMXSceneTableModel.scrollToSelection(this.jTable_DMXScenes);
        }
        this.m_SelectedDMXScene = p_DMXScene;
        this.refreshUI();
    }

    private void refreshUI() {
        if (this.m_SelectedDMXScene == null) {
            this.jButton_RemoveScene.setEnabled(false);
            this.jButton_CopyDMXScene.setEnabled(false);
            this.jButton_LightToScene.setEnabled(false);
            this.jButton_SceneToLight.setEnabled(false);
            this.jButton_FilterDevices.setEnabled(false);
            this.jButton_ShowInTimeline.setEnabled(false);
            this.jButton_CleanUpScene.setEnabled(false);
        } else {
            this.jButton_RemoveScene.setEnabled(true);
            this.jButton_CopyDMXScene.setEnabled(true);
            this.jButton_LightToScene.setEnabled(true);
            this.jButton_SceneToLight.setEnabled(true);
            this.jButton_FilterDevices.setEnabled(true);
            this.jButton_ShowInTimeline.setEnabled(true);
            this.jButton_CleanUpScene.setEnabled(true);
        }
        boolean boolFilterActive = true;
        if (this.m_SelectedDMXSceneFilter == null) {
            this.jButton_InvertDMXSceneFilter.setEnabled(false);
            boolFilterActive = false;
        } else if (this.m_SelectedDMXSceneFilter instanceof DMXSceneFilter.DMXSceneFilterAll) {
            this.jButton_InvertDMXSceneFilter.setEnabled(false);
            boolFilterActive = false;
        } else {
            this.jButton_InvertDMXSceneFilter.setEnabled(true);
            boolFilterActive = true;
        }
        if (!boolFilterActive) {
            this.jButton_InvertDMXSceneFilter.setBorder(this.m_BorderButtonNormal);
            this.jButton_InvertDMXSceneFilter.setBorderPainted(false);
            this.jComboBox_Filter.setBorder(this.m_BorderButtonNormal);
            this.jTextField_FilterDMXScene.setBorder(this.m_BorderButtonNormal);
        } else if (!DMXSceneFilter.getInvertFilter()) {
            this.jButton_InvertDMXSceneFilter.setBorder(this.m_BorderFilterActive);
            this.jButton_InvertDMXSceneFilter.setBorderPainted(true);
            this.jComboBox_Filter.setBorder(this.m_BorderFilterActive);
            this.jTextField_FilterDMXScene.setBorder(this.m_BorderFilterActive);
        } else {
            this.jButton_InvertDMXSceneFilter.setBorder(this.m_BorderFilterActiveInverted);
            this.jButton_InvertDMXSceneFilter.setBorderPainted(true);
            this.jComboBox_Filter.setBorder(this.m_BorderFilterActiveInverted);
            this.jTextField_FilterDMXScene.setBorder(this.m_BorderFilterActiveInverted);
        }
    }

    private void jButton_NewSceneActionPerformed(ActionEvent evt) {
        this.newDMXScene();
    }

    private void jButton_LightToSceneActionPerformed(ActionEvent evt) {
        DMXScene o_SelectedDMXScene = this.m_SelectedDMXScene;
        if (o_SelectedDMXScene == null) {
            return;
        }
        o_SelectedDMXScene.saveDMXSceneLight();
    }

    private void jButton_RemoveSceneActionPerformed(ActionEvent evt) {
        int intOptionAnswer;
        DMXScene o_SelectedDMXScene = this.m_SelectedDMXScene;
        if (o_SelectedDMXScene == null) {
            return;
        }
        boolean boolRemove = true;
        boolean boolInUse = false;
        if (o_SelectedDMXScene.getLiveShowDMXObjectCount() > 0) {
            boolInUse = true;
        }
        if (boolInUse && (intOptionAnswer = JOptionDialog.showConfirmDialog(null, DELETE_SELECTEDSCENE, DELETESELECTEDSCENE_TITEL, 0, 1)) != 0) {
            boolRemove = false;
        }
        if (boolRemove) {
            int intIndex = DMXScene.indexOf(o_SelectedDMXScene);
            this.removeDMXScene(o_SelectedDMXScene);
            if (intIndex < 0) {
                intIndex = 0;
            }
            if (intIndex >= DMXScene.getDMXSceneCount()) {
                intIndex = DMXScene.getDMXSceneCount() - 1;
            }
            if (intIndex >= 0) {
                this.setSelectedDMXScene(DMXScene.getDMXScene(intIndex));
            }
        }
    }

    private void jButton_SceneToLightActionPerformed(ActionEvent evt) {
        DMXScene o_SelectedDMXScene = this.m_SelectedDMXScene;
        if (o_SelectedDMXScene == null) {
            return;
        }
        o_SelectedDMXScene.writeDMXSceneLight();
    }

    private void jButton_RemoveUnusedActionPerformed(ActionEvent evt) {
        int intUnusedDMXSceneCount = DMXScene.getUnusedDMXScenesCount();
        if (intUnusedDMXSceneCount == 0) {
            return;
        }
        int intOptionAnswer = JOptionDialog.showConfirmDialog(null, REMOVE_UNUSEDSCENES, REMOVE_UNUSEDSCENES_TITEL + " " + String.valueOf(intUnusedDMXSceneCount) + " / " + String.valueOf(DMXScene.getDMXSceneCount()), 0, 1);
        if (intOptionAnswer == 0) {
            DMXScene.clearUnusedDMXScenes();
        }
    }

    private void jButton_FilterDevicesActionPerformed(ActionEvent evt) {
        DMXScene o_SelectedDMXScene = this.m_SelectedDMXScene;
        if (o_SelectedDMXScene == null) {
            return;
        }
        DMXDeviceFilter o_DMXDeviceFilter = DMXDeviceFilter.getDMXDeviceFilter(o_SelectedDMXScene);
        LiveShowDMXStageView o_LiveShowDMXStageView = LiveShowDMXSystem.getLiveShowDMXStageView();
        o_LiveShowDMXStageView.filterDMXDevices(o_DMXDeviceFilter);
        o_LiveShowDMXStageView.toFront();
    }

    private void jButton_ShowInTimelineActionPerformed(ActionEvent evt) {
        DMXScene o_SelectedDMXScene = this.m_SelectedDMXScene;
        if (o_SelectedDMXScene == null) {
            return;
        }
        LiveShowDMXVIP o_LiveShowDMXVIP = LiveShowDMXSystem.getLiveShowDMXVIP();
        if (o_LiveShowDMXVIP == null) {
            return;
        }
        o_LiveShowDMXVIP.clearSelectedObjects(true);
        for (int intObject = 0; intObject < o_LiveShowDMXVIP.getLiveShowObjectInterfaceCount(); ++intObject) {
            LiveShowObjectInterface o_LiveShowObjectInterface = o_LiveShowDMXVIP.getLiveShowObjectInterface(intObject);
            if (o_LiveShowObjectInterface instanceof LiveShowSceneBridge || !o_SelectedDMXScene.getID().equals(o_LiveShowObjectInterface.getDescription().getSourceString())) continue;
            o_LiveShowDMXVIP.addSelectedObject(o_LiveShowObjectInterface);
        }
        if (o_LiveShowDMXVIP.getSelectedObjectsCount() > 0) {
            o_LiveShowDMXVIP.toFront();
        }
    }

    private void jButton_CopyDMXSceneActionPerformed(ActionEvent evt) {
        DMXScene o_SelectedDMXScene = this.m_SelectedDMXScene;
        if (o_SelectedDMXScene == null) {
            return;
        }
        DMXScene o_NewDMXScene = new DMXScene(o_SelectedDMXScene.getName());
        o_SelectedDMXScene.clone(o_NewDMXScene);
        DMXScene.addDMXScene(o_NewDMXScene);
        this.setSelectedDMXScene(o_NewDMXScene);
    }

    private void jButton_InvertDMXSceneFilterActionPerformed(ActionEvent evt) {
        if (!DMXSceneFilter.getInvertFilter()) {
            DMXSceneFilter.setInvertFilter(true);
        } else {
            DMXSceneFilter.setInvertFilter(false);
        }
        this.filterDMXScenes();
        this.refreshUI();
    }

    private void jTextField_FilterDMXSceneMouseClicked(MouseEvent evt) {
        this.jTextField_FilterDMXScene.selectAll();
    }

    private void jComboBox_FilterItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.m_SelectedDMXSceneFilter = (DMXSceneFilter)this.jComboBox_Filter.getSelectedItem();
            this.filterDMXScenes();
            this.refreshUI();
        }
    }

    private void jComboBox_FilterActionPerformed(ActionEvent evt) {
        this.m_SelectedDMXSceneFilter = (DMXSceneFilter)this.jComboBox_Filter.getSelectedItem();
        this.filterDMXScenes();
        this.refreshUI();
    }

    private void jTextField_FilterDMXSceneKeyPressed(KeyEvent evt) {
        String stringFilterSubString;
        if (evt.getKeyCode() == 10 && ((stringFilterSubString = this.jTextField_FilterDMXScene.getText()) == null || stringFilterSubString.length() <= 0)) {
            this.filterDMXScenes(DMXSceneFilter.s_DMXSceneFilterAll);
        }
    }

    private void jButton_CleanUpSceneActionPerformed(ActionEvent evt) {
        DMXScene o_SelectedDMXScene = this.m_SelectedDMXScene;
        if (o_SelectedDMXScene == null) {
            return;
        }
        o_SelectedDMXScene.cleanUpDMXSceneLight();
    }

    private void jTextField_FilterDMXScene_DocumentChanged() {
        String stringFilter = this.jTextField_FilterDMXScene.getText();
        if (stringFilter != null && stringFilter.length() > 0) {
            DMXSceneFilter.s_DMXSceneFilterText.setFilterString(stringFilter);
            this.filterDMXScenes(DMXSceneFilter.s_DMXSceneFilterText);
        } else {
            DMXSceneFilter.s_DMXSceneFilterText.setFilterString("");
            this.filterDMXScenes(DMXSceneFilter.s_DMXSceneFilterAll);
        }
    }

    public void filterDMXScenes(DMXSceneFilter p_DMXSceneFilter) {
        if (p_DMXSceneFilter == null) {
            return;
        }
        this.jComboBox_Filter.setSelectedItem(p_DMXSceneFilter);
        if (!SwingUtilities.isEventDispatchThread()) {
            System.out.println("LiveSHowDMXStageView filterDMXDevices not called from DispatchThread");
        }
        this.jComboBox_Filter.repaint();
    }

    public void filterDMXScenes() {
        TableRowSorter o_TableRowSorter;
        if (this.m_SelectedDMXSceneFilter == null) {
            if (DMXSceneFilter.getInvertFilter()) {
                DMXSceneFilter.setInvertFilter(false);
                this.refreshUI();
            }
        } else if (this.m_SelectedDMXSceneFilter instanceof DMXSceneFilter.DMXSceneFilterAll && DMXSceneFilter.getInvertFilter()) {
            DMXSceneFilter.setInvertFilter(false);
            this.refreshUI();
        }
        if ((o_TableRowSorter = (TableRowSorter)this.jTable_DMXScenes.getRowSorter()) == null) {
            return;
        }
        DMXSceneFilter.DMXSceneRowFilter o_DMXSceneRowFilter = (DMXSceneFilter.DMXSceneRowFilter)o_TableRowSorter.getRowFilter();
        if (o_DMXSceneRowFilter == null) {
            return;
        }
        this.clearSelectedDMXScenes();
        o_DMXSceneRowFilter.setDMXSceneFilter(this.m_SelectedDMXSceneFilter);
    }

    public static void toFront() {
        Container o_Container = s_SelfReference;
        try {
            do {
                if ((o_Container = o_Container.getParent()) == null) {
                    return;
                }
                if (!(o_Container instanceof JFrame)) continue;
                JFrame o_JFrame = (JFrame)o_Container;
                o_JFrame.setVisible(true);
                int intExtendedState = o_JFrame.getExtendedState();
                if (intExtendedState == 1) {
                    o_JFrame.setExtendedState(0);
                }
                o_JFrame.setVisible(true);
                o_JFrame.toFront();
                return;
            } while (!(o_Container instanceof JInternalFrame));
            JInternalFrame o_JInternalFrame = (JInternalFrame)o_Container;
            if (o_JInternalFrame.isIcon()) {
                o_JInternalFrame.setIcon(false);
            }
            o_JInternalFrame.setVisible(true);
            o_JInternalFrame.setSelected(true);
            o_JInternalFrame.moveToFront();
            return;
        }
        catch (Exception e) {
            return;
        }
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dge) {
        DMXScene o_SelectedDMXScene;
        Point o_Point = dge.getDragOrigin();
        Component o_DragComponent = dge.getComponent();
        if (o_DragComponent == this.jTable_DMXScenes) {
            int intSelectedRow = this.jTable_DMXScenes.getSelectedRow();
            if (intSelectedRow < 0) {
                return;
            }
            try {
                intSelectedRow = this.jTable_DMXScenes.convertRowIndexToModel(intSelectedRow);
            }
            catch (Exception e) {
                return;
            }
            DMXScene.DMXSceneTableModel o_DMXSceneTableModel = (DMXScene.DMXSceneTableModel)this.jTable_DMXScenes.getModel();
            DMXScene o_DMXScene = o_DMXSceneTableModel.getDMXScene(intSelectedRow);
            this.setSelectedDMXScene(o_DMXScene);
        }
        if ((o_SelectedDMXScene = this.m_SelectedDMXScene) == null) {
            return;
        }
        LiveShowDMXObjectDescription o_LiveShowDMXObjectDescription = LiveShowDMXObjectDescription.poolGet(true);
        o_LiveShowDMXObjectDescription.setObjectType(11);
        o_LiveShowDMXObjectDescription.setSourceName(o_SelectedDMXScene.getName());
        o_LiveShowDMXObjectDescription.setSourceString(o_SelectedDMXScene.getID());
        o_LiveShowDMXObjectDescription.setFrameLength(LiveShowDMXObjectDescription.DEFAULTFRAMELENGTH);
        o_LiveShowDMXObjectDescription.setName("");
        LiveShowDragDrop.LiveShowTransferable o_Transferable = new LiveShowDragDrop.LiveShowTransferable(o_LiveShowDMXObjectDescription, LiveShowDragDrop.LiveShowTransferable.DMXOBJECTFLAVOUR);
        try {
            LiveShowDragDrop.setSource(this);
            dge.startDrag(null, o_Transferable, this);
        }
        catch (InvalidDnDOperationException invalidDnDOperationException) {
            // empty catch block
        }
    }

    @Override
    public void dragEnter(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dsde) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragExit(DragSourceEvent dse) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde) {
        Point o_Point = dsde.getLocation();
        if (!dsde.getDropSuccess()) {
            LiveShowDragDrop.notifyDropCancelled();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        int intFirstIndex = e.getFirstIndex();
        int intLastIndex = e.getLastIndex();
        DMXScene o_DMXScene = null;
        if (this.jTable_DMXScenes.getSelectedRowCount() > 1) {
            return;
        }
        int intSelectedRow = this.jTable_DMXScenes.getSelectedRow();
        if (intSelectedRow >= 0) {
            try {
                intSelectedRow = this.jTable_DMXScenes.convertRowIndexToModel(intSelectedRow);
                o_DMXScene = DMXScene.getDMXScene(intSelectedRow);
            }
            catch (Exception error) {
                System.out.println(error.getMessage());
                o_DMXScene = null;
            }
        } else {
            o_DMXScene = null;
        }
        this.setSelectedDMXScene(o_DMXScene);
        this.refreshUI();
    }
}

