/*
 * Decompiled with CFR 0.152.
 */
package DMXGraphics;

import DMX512.DMXUniverse;
import DMX512.DMXUniverseInputPatch;
import DMXMixer.DMXControlDescription;
import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LanguageTools.LiveLanguagePackage.LiveLanguageString;
import LiveShowPlayPackage.PlayRemoteActions;
import SwingComponents.FrameParent;
import SwingModelPackage.TableAndListModel;
import SwingToolTipPackage.PopUpToolTip;
import ToolsGraphics.JLabel_ResizeFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableRowSorter;

public class LiveShowDMXInputSettings
extends JPanel
implements ItemListener,
PropertyChangeListener {
    @LiveLanguageString
    public static String REMARK_NODMXUNIVERSE = "No ubiverse selected";
    @LiveLanguageString
    public static String REMARK_NODMXINPUT = "Universe has no input";
    private TableAndListModel.ListModelWrapper<DMXUniverse> m_DMXUniverseInputListModelWrapper;
    private TableAndListModel.ListModelWrapper<DMXUniverse> m_DMXUniverseOutputListModelWrapper;
    private DMXUniverse m_SelectedInputDMXUniverse;
    private DMXUniverse m_SelectedOutputDMXUniverse;
    private DMXUniverseInputPatch m_DMXUniverseInputPatch;
    private ButtonGroup buttonGroup_Input;
    private ButtonGroup buttonGroup_Output;
    private JButton jButton_AddLimitation;
    private JButton jButton_RemoveLimitation;
    private JButton jButton_ShowRemoteSettings;
    private JComboBox jComboBox_Input_DMXUniverse;
    private JComboBox jComboBox_Output_DMXUniverse;
    private JComboBox jComboBox_Output_Limitations;
    private JLabel jLabel_Header_Input;
    private JLabel jLabel_Header_Output;
    private JLabel jLabel_Header_OutputLimitation;
    private JLabel jLabel_Icon_DMXUniverseInput;
    private JLabel jLabel_Icon_DMXUniverseInput_Arrow;
    private JLabel jLabel_Icon_DMXUniverseOtput_Arrow;
    private JLabel jLabel_Limitations;
    private JLabel jLabel_Remark_Input;
    private JLabel_ResizeFrame jLabel_ResizeFrame1;
    private JPanel jPanel_Limitations;
    private JRadioButton jRadioButton_Input_AllValues;
    private JRadioButton jRadioButton_Input_ChangedValues;
    private JRadioButton jRadioButton_Input_ChangedValuesCaught;
    private JRadioButton jRadioButton_Input_Remote;
    private JRadioButton jRadioButton_Output_AllDevices;
    private JRadioButton jRadioButton_Output_SelectedDevices;
    private JRadioButton jRadioButton_Output_SelectedDevices_Patched;
    private JScrollPane jScrollPane_InputPatches;
    private JScrollPane jScrollPane_Limitations;
    private JSeparator jSeparator_InputMode;
    private JSeparator jSeparator_InputOutput;
    private JSeparator jSeparator_OutputMode;
    private JTable jTable_InputPatches;
    public static FrameParent s_FrameParent;

    public LiveShowDMXInputSettings() {
        this.initMembers();
        this.initComponents();
        this.initComponentsFurther();
        LiveLanguage.addLanguageListener((Object)this, null);
        this.refreshGUI();
    }

    private void initMembers() {
        this.m_SelectedInputDMXUniverse = null;
        this.m_SelectedOutputDMXUniverse = null;
        this.m_DMXUniverseInputListModelWrapper = DMXUniverse.getListModel().createListModelWrapper();
        this.m_DMXUniverseOutputListModelWrapper = DMXUniverse.getListModel().createListModelWrapper();
    }

    private void initComponentsFurther() {
        this.jComboBox_Input_DMXUniverse.setModel(this.m_DMXUniverseInputListModelWrapper);
        this.jComboBox_Input_DMXUniverse.setRenderer(DMXUniverse.getCellRenderer());
        this.jComboBox_Input_DMXUniverse.addItemListener(this);
        this.jComboBox_Output_DMXUniverse.setModel(this.m_DMXUniverseOutputListModelWrapper);
        this.jComboBox_Output_DMXUniverse.setRenderer(DMXUniverse.getCellRenderer());
        this.jComboBox_Output_DMXUniverse.addItemListener(this);
        this.jComboBox_Output_Limitations.setModel(DMXUniverseInputPatch.s_DMXControlDescriptionList.createListModelWrapper());
        this.jComboBox_Output_Limitations.setRenderer(DMXControlDescription.getRenderer());
        this.jComboBox_Output_Limitations.setSelectedIndex(0);
        this.jScrollPane_Limitations.getViewport().setBackground(Color.BLACK);
        this.jScrollPane_Limitations.getViewport().setForeground(Color.WHITE);
        this.jScrollPane_InputPatches.getViewport().setBackground(Color.BLACK);
        this.jScrollPane_InputPatches.getViewport().setForeground(Color.WHITE);
        this.setInputPatchTableModel(DMXUniverseInputPatch.s_EmptyInputPatchTableModel);
        this.jComboBox_Input_DMXUniverse.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jComboBox_Output_DMXUniverse.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jComboBox_Output_Limitations.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jRadioButton_Input_AllValues.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jRadioButton_Input_ChangedValues.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jRadioButton_Input_ChangedValuesCaught.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jRadioButton_Input_Remote.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jRadioButton_Output_AllDevices.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jRadioButton_Output_SelectedDevices.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jRadioButton_Output_SelectedDevices_Patched.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_ShowRemoteSettings.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_AddLimitation.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_RemoveLimitation.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jLabel_Limitations.setComponentPopupMenu(PopUpToolTip.getSelfReference());
    }

    private void setInputPatchTableModel(DMXUniverseInputPatch.InputPatchTableModel p_InputPatchTableModel) {
        if (p_InputPatchTableModel == null) {
            return;
        }
        this.jTable_InputPatches.setModel(p_InputPatchTableModel);
        DefaultTableCellRenderer o_DefaultTableCellRenderer = p_InputPatchTableModel.getDefaultTableCellRenderer(0);
        if (o_DefaultTableCellRenderer != null) {
            o_DefaultTableCellRenderer.setHorizontalAlignment(0);
        }
        this.jTable_InputPatches.getColumnModel().getColumn(0).setCellRenderer(o_DefaultTableCellRenderer);
        this.jTable_InputPatches.getColumnModel().getColumn(0).setPreferredWidth(60);
        o_DefaultTableCellRenderer = p_InputPatchTableModel.getDefaultTableCellRenderer(1);
        if (o_DefaultTableCellRenderer != null) {
            o_DefaultTableCellRenderer.setHorizontalAlignment(0);
        }
        this.jTable_InputPatches.getColumnModel().getColumn(1).setCellRenderer(o_DefaultTableCellRenderer);
        o_DefaultTableCellRenderer = p_InputPatchTableModel.getDefaultTableCellRenderer(2);
        if (o_DefaultTableCellRenderer != null) {
            o_DefaultTableCellRenderer.setHorizontalAlignment(0);
        }
        this.jTable_InputPatches.getColumnModel().getColumn(2).setCellRenderer(o_DefaultTableCellRenderer);
        TableRowSorter<DMXUniverseInputPatch.InputPatchTableModel> o_TableRowSorter = new TableRowSorter<DMXUniverseInputPatch.InputPatchTableModel>(p_InputPatchTableModel);
        this.jTable_InputPatches.setRowSorter(o_TableRowSorter);
        o_TableRowSorter.setComparator(0, TableAndListModel.getStringComparator_Integer());
        o_TableRowSorter.setComparator(1, TableAndListModel.getStringComparator_Normal());
        o_TableRowSorter.setComparator(2, TableAndListModel.getStringComparator_Normal());
    }

    private void initComponents() {
        this.buttonGroup_Input = new ButtonGroup();
        this.buttonGroup_Output = new ButtonGroup();
        this.jLabel_ResizeFrame1 = new JLabel_ResizeFrame();
        this.jLabel_Icon_DMXUniverseInput = new JLabel();
        this.jComboBox_Input_DMXUniverse = new JComboBox();
        this.jRadioButton_Input_Remote = new JRadioButton();
        this.jRadioButton_Input_AllValues = new JRadioButton();
        this.jRadioButton_Input_ChangedValues = new JRadioButton();
        this.jRadioButton_Input_ChangedValuesCaught = new JRadioButton();
        this.jLabel_Header_Input = new JLabel();
        this.jLabel_Icon_DMXUniverseInput_Arrow = new JLabel();
        this.jLabel_Header_Output = new JLabel();
        this.jRadioButton_Output_AllDevices = new JRadioButton();
        this.jRadioButton_Output_SelectedDevices = new JRadioButton();
        this.jRadioButton_Output_SelectedDevices_Patched = new JRadioButton();
        this.jLabel_Icon_DMXUniverseOtput_Arrow = new JLabel();
        this.jComboBox_Output_DMXUniverse = new JComboBox();
        this.jScrollPane_InputPatches = new JScrollPane();
        this.jTable_InputPatches = new JTable();
        this.jButton_ShowRemoteSettings = new JButton();
        this.jSeparator_InputMode = new JSeparator();
        this.jLabel_Remark_Input = new JLabel();
        this.jSeparator_InputOutput = new JSeparator();
        this.jSeparator_OutputMode = new JSeparator();
        this.jPanel_Limitations = new JPanel();
        this.jLabel_Header_OutputLimitation = new JLabel();
        this.jScrollPane_Limitations = new JScrollPane();
        this.jLabel_Limitations = new JLabel();
        this.jComboBox_Output_Limitations = new JComboBox();
        this.jButton_AddLimitation = new JButton();
        this.jButton_RemoveLimitation = new JButton();
        this.setForeground(new Color(255, 255, 255));
        this.setLayout(new GridBagLayout());
        this.jLabel_ResizeFrame1.setToolTipText("");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 17;
        gridBagConstraints.anchor = 14;
        this.add((Component)this.jLabel_ResizeFrame1, gridBagConstraints);
        this.jLabel_Icon_DMXUniverseInput.setToolTipText("");
        this.jLabel_Icon_DMXUniverseInput.setMaximumSize(new Dimension(34, 34));
        this.jLabel_Icon_DMXUniverseInput.setMinimumSize(new Dimension(34, 34));
        this.jLabel_Icon_DMXUniverseInput.setPreferredSize(new Dimension(34, 34));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jLabel_Icon_DMXUniverseInput, gridBagConstraints);
        this.jComboBox_Input_DMXUniverse.setMaximumRowCount(12);
        this.jComboBox_Input_DMXUniverse.setToolTipText("Select an input universe");
        this.jComboBox_Input_DMXUniverse.setBorder(null);
        this.jComboBox_Input_DMXUniverse.setMinimumSize(new Dimension(51, 28));
        this.jComboBox_Input_DMXUniverse.setPreferredSize(new Dimension(51, 28));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jComboBox_Input_DMXUniverse, gridBagConstraints);
        this.buttonGroup_Input.add(this.jRadioButton_Input_Remote);
        this.jRadioButton_Input_Remote.setText("Remote Commands");
        this.jRadioButton_Input_Remote.setToolTipText("");
        this.jRadioButton_Input_Remote.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowDMXInputSettings.this.jRadioButton_Input_RemoteActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jRadioButton_Input_Remote, gridBagConstraints);
        this.buttonGroup_Input.add(this.jRadioButton_Input_AllValues);
        this.jRadioButton_Input_AllValues.setText("All Values");
        this.jRadioButton_Input_AllValues.setToolTipText("<html>All input universe values are accepted.</html>");
        this.jRadioButton_Input_AllValues.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowDMXInputSettings.this.jRadioButton_Input_AllValuesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jRadioButton_Input_AllValues, gridBagConstraints);
        this.buttonGroup_Input.add(this.jRadioButton_Input_ChangedValues);
        this.jRadioButton_Input_ChangedValues.setText("Only Changed Values");
        this.jRadioButton_Input_ChangedValues.setToolTipText("<html>Only the changed channels(values)<br>of the input universe<br>are accepted.</html>");
        this.jRadioButton_Input_ChangedValues.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowDMXInputSettings.this.jRadioButton_Input_ChangedValuesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jRadioButton_Input_ChangedValues, gridBagConstraints);
        this.buttonGroup_Input.add(this.jRadioButton_Input_ChangedValuesCaught);
        this.jRadioButton_Input_ChangedValuesCaught.setText("Only Changed Values (caught)");
        this.jRadioButton_Input_ChangedValuesCaught.setToolTipText("<html>The changed values of the input universe are accepted<br>if the current value of the output was caught.</html>");
        this.jRadioButton_Input_ChangedValuesCaught.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowDMXInputSettings.this.jRadioButton_Input_ChangedValuesCaughtActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jRadioButton_Input_ChangedValuesCaught, gridBagConstraints);
        this.jLabel_Header_Input.setFont(new Font("Tahoma", 0, 12));
        this.jLabel_Header_Input.setText("Input");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jLabel_Header_Input, gridBagConstraints);
        this.jLabel_Icon_DMXUniverseInput_Arrow.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Arrow_Right.png")));
        this.jLabel_Icon_DMXUniverseInput_Arrow.setToolTipText("");
        this.jLabel_Icon_DMXUniverseInput_Arrow.setMaximumSize(new Dimension(34, 34));
        this.jLabel_Icon_DMXUniverseInput_Arrow.setMinimumSize(new Dimension(34, 34));
        this.jLabel_Icon_DMXUniverseInput_Arrow.setPreferredSize(new Dimension(34, 34));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jLabel_Icon_DMXUniverseInput_Arrow, gridBagConstraints);
        this.jLabel_Header_Output.setFont(new Font("Tahoma", 0, 12));
        this.jLabel_Header_Output.setText("Output");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jLabel_Header_Output, gridBagConstraints);
        this.buttonGroup_Output.add(this.jRadioButton_Output_AllDevices);
        this.jRadioButton_Output_AllDevices.setText("All Devices of the universe");
        this.jRadioButton_Output_AllDevices.setToolTipText("");
        this.jRadioButton_Output_AllDevices.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowDMXInputSettings.this.jRadioButton_Output_AllDevicesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jRadioButton_Output_AllDevices, gridBagConstraints);
        this.buttonGroup_Output.add(this.jRadioButton_Output_SelectedDevices);
        this.jRadioButton_Output_SelectedDevices.setText("Only Selected Devices of the universe");
        this.jRadioButton_Output_SelectedDevices.setToolTipText("");
        this.jRadioButton_Output_SelectedDevices.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowDMXInputSettings.this.jRadioButton_Output_SelectedDevicesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jRadioButton_Output_SelectedDevices, gridBagConstraints);
        this.buttonGroup_Output.add(this.jRadioButton_Output_SelectedDevices_Patched);
        this.jRadioButton_Output_SelectedDevices_Patched.setText("Only Selected Devices (patched)");
        this.jRadioButton_Output_SelectedDevices_Patched.setToolTipText("");
        this.jRadioButton_Output_SelectedDevices_Patched.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowDMXInputSettings.this.jRadioButton_Output_SelectedDevices_PatchedActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 3, 3, 3);
        this.add((Component)this.jRadioButton_Output_SelectedDevices_Patched, gridBagConstraints);
        this.jLabel_Icon_DMXUniverseOtput_Arrow.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Arrow_Left.png")));
        this.jLabel_Icon_DMXUniverseOtput_Arrow.setToolTipText("");
        this.jLabel_Icon_DMXUniverseOtput_Arrow.setMaximumSize(new Dimension(34, 34));
        this.jLabel_Icon_DMXUniverseOtput_Arrow.setMinimumSize(new Dimension(34, 34));
        this.jLabel_Icon_DMXUniverseOtput_Arrow.setPreferredSize(new Dimension(34, 34));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jLabel_Icon_DMXUniverseOtput_Arrow, gridBagConstraints);
        this.jComboBox_Output_DMXUniverse.setMaximumRowCount(12);
        this.jComboBox_Output_DMXUniverse.setToolTipText("select an output universe");
        this.jComboBox_Output_DMXUniverse.setBorder(null);
        this.jComboBox_Output_DMXUniverse.setMinimumSize(new Dimension(51, 28));
        this.jComboBox_Output_DMXUniverse.setPreferredSize(new Dimension(51, 28));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jComboBox_Output_DMXUniverse, gridBagConstraints);
        this.jScrollPane_InputPatches.setName("");
        this.jTable_InputPatches.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTable_InputPatches.setRowHeight(20);
        this.jScrollPane_InputPatches.setViewportView(this.jTable_InputPatches);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 3, 3, 3);
        this.add((Component)this.jScrollPane_InputPatches, gridBagConstraints);
        this.jButton_ShowRemoteSettings.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Edit.png")));
        this.jButton_ShowRemoteSettings.setToolTipText("show remote settings");
        this.jButton_ShowRemoteSettings.setActionCommand("Add DMXUniverse");
        this.jButton_ShowRemoteSettings.setContentAreaFilled(false);
        this.jButton_ShowRemoteSettings.setMaximumSize(new Dimension(125, 23));
        this.jButton_ShowRemoteSettings.setMinimumSize(new Dimension(32, 32));
        this.jButton_ShowRemoteSettings.setPreferredSize(new Dimension(32, 32));
        this.jButton_ShowRemoteSettings.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_ShowRemoteSettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowDMXInputSettings.this.jButton_ShowRemoteSettingsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jButton_ShowRemoteSettings, gridBagConstraints);
        this.jSeparator_InputMode.setPreferredSize(new Dimension(100, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jSeparator_InputMode, gridBagConstraints);
        this.jLabel_Remark_Input.setFont(new Font("Tahoma", 0, 12));
        this.jLabel_Remark_Input.setForeground(new Color(255, 0, 0));
        this.jLabel_Remark_Input.setHorizontalAlignment(0);
        this.jLabel_Remark_Input.setText("Remark");
        this.jLabel_Remark_Input.setToolTipText("");
        this.jLabel_Remark_Input.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.jLabel_Remark_Input.setPreferredSize(new Dimension(100, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jLabel_Remark_Input, gridBagConstraints);
        this.jSeparator_InputOutput.setPreferredSize(new Dimension(100, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jSeparator_InputOutput, gridBagConstraints);
        this.jSeparator_OutputMode.setPreferredSize(new Dimension(100, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jSeparator_OutputMode, gridBagConstraints);
        this.jPanel_Limitations.setLayout(new GridBagLayout());
        this.jLabel_Header_OutputLimitation.setFont(new Font("Tahoma", 0, 12));
        this.jLabel_Header_OutputLimitation.setHorizontalAlignment(0);
        this.jLabel_Header_OutputLimitation.setText("Limitations");
        this.jLabel_Header_OutputLimitation.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 3, 3, 3);
        this.jPanel_Limitations.add((Component)this.jLabel_Header_OutputLimitation, gridBagConstraints);
        this.jScrollPane_Limitations.setVerticalScrollBarPolicy(21);
        this.jScrollPane_Limitations.setMinimumSize(new Dimension(23, 30));
        this.jScrollPane_Limitations.setPreferredSize(new Dimension(36, 30));
        this.jLabel_Limitations.setMaximumSize(new Dimension(34, 24));
        this.jLabel_Limitations.setMinimumSize(new Dimension(34, 24));
        this.jLabel_Limitations.setPreferredSize(new Dimension(34, 24));
        this.jScrollPane_Limitations.setViewportView(this.jLabel_Limitations);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Limitations.add((Component)this.jScrollPane_Limitations, gridBagConstraints);
        this.jComboBox_Output_Limitations.setMaximumRowCount(12);
        this.jComboBox_Output_Limitations.setBorder(null);
        this.jComboBox_Output_Limitations.setMinimumSize(new Dimension(51, 28));
        this.jComboBox_Output_Limitations.setPreferredSize(new Dimension(51, 28));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Limitations.add((Component)this.jComboBox_Output_Limitations, gridBagConstraints);
        this.jButton_AddLimitation.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Edit_Plus.png")));
        this.jButton_AddLimitation.setToolTipText("Add Universe");
        this.jButton_AddLimitation.setActionCommand("Add DMXUniverse");
        this.jButton_AddLimitation.setContentAreaFilled(false);
        this.jButton_AddLimitation.setMaximumSize(new Dimension(125, 23));
        this.jButton_AddLimitation.setMinimumSize(new Dimension(32, 32));
        this.jButton_AddLimitation.setPreferredSize(new Dimension(32, 32));
        this.jButton_AddLimitation.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_AddLimitation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowDMXInputSettings.this.jButton_AddLimitationActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Limitations.add((Component)this.jButton_AddLimitation, gridBagConstraints);
        this.jButton_RemoveLimitation.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Delete.png")));
        this.jButton_RemoveLimitation.setToolTipText("Remove Universe");
        this.jButton_RemoveLimitation.setActionCommand("Remove DMXUniverse");
        this.jButton_RemoveLimitation.setContentAreaFilled(false);
        this.jButton_RemoveLimitation.setMaximumSize(new Dimension(125, 23));
        this.jButton_RemoveLimitation.setMinimumSize(new Dimension(32, 32));
        this.jButton_RemoveLimitation.setPreferredSize(new Dimension(32, 32));
        this.jButton_RemoveLimitation.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_RemoveLimitation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowDMXInputSettings.this.jButton_RemoveLimitationActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Limitations.add((Component)this.jButton_RemoveLimitation, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jPanel_Limitations, gridBagConstraints);
    }

    private void jRadioButton_Input_RemoteActionPerformed(ActionEvent evt) {
        if (this.m_DMXUniverseInputPatch == null) {
            return;
        }
        if (this.jRadioButton_Input_Remote.isSelected()) {
            this.m_DMXUniverseInputPatch.setInputMode(0);
        }
    }

    private void jRadioButton_Input_AllValuesActionPerformed(ActionEvent evt) {
        if (this.m_DMXUniverseInputPatch == null) {
            return;
        }
        if (this.jRadioButton_Input_AllValues.isSelected()) {
            this.m_DMXUniverseInputPatch.setInputMode(2);
        }
    }

    private void jRadioButton_Input_ChangedValuesActionPerformed(ActionEvent evt) {
        if (this.m_DMXUniverseInputPatch == null) {
            return;
        }
        if (this.jRadioButton_Input_ChangedValues.isSelected()) {
            this.m_DMXUniverseInputPatch.setInputMode(4);
        }
    }

    private void jRadioButton_Input_ChangedValuesCaughtActionPerformed(ActionEvent evt) {
        if (this.m_DMXUniverseInputPatch == null) {
            return;
        }
        if (this.jRadioButton_Input_ChangedValuesCaught.isSelected()) {
            this.m_DMXUniverseInputPatch.setInputMode(8);
        }
    }

    private void jRadioButton_Output_AllDevicesActionPerformed(ActionEvent evt) {
        if (this.m_DMXUniverseInputPatch == null) {
            return;
        }
        if (this.jRadioButton_Output_AllDevices.isSelected()) {
            this.m_DMXUniverseInputPatch.setOutputMode(0);
        }
    }

    private void jRadioButton_Output_SelectedDevicesActionPerformed(ActionEvent evt) {
        if (this.m_DMXUniverseInputPatch == null) {
            return;
        }
        if (this.jRadioButton_Output_SelectedDevices.isSelected()) {
            this.m_DMXUniverseInputPatch.setOutputMode(4);
        }
    }

    private void jRadioButton_Output_SelectedDevices_PatchedActionPerformed(ActionEvent evt) {
        if (this.m_DMXUniverseInputPatch == null) {
            return;
        }
        if (this.jRadioButton_Output_SelectedDevices_Patched.isSelected()) {
            this.m_DMXUniverseInputPatch.setOutputMode(16);
        }
    }

    private void jButton_AddLimitationActionPerformed(ActionEvent evt) {
        if (this.m_DMXUniverseInputPatch == null) {
            return;
        }
        DMXControlDescription o_DMXControlDescription = (DMXControlDescription)this.jComboBox_Output_Limitations.getSelectedItem();
        if (o_DMXControlDescription == null) {
            return;
        }
        String stringLimitationID = o_DMXControlDescription.getID();
        this.m_DMXUniverseInputPatch.addLimitation(stringLimitationID);
        this.refreshGUI();
    }

    private void jButton_RemoveLimitationActionPerformed(ActionEvent evt) {
        if (this.m_DMXUniverseInputPatch == null) {
            return;
        }
        DMXControlDescription o_DMXControlDescription = (DMXControlDescription)this.jComboBox_Output_Limitations.getSelectedItem();
        if (o_DMXControlDescription == null) {
            return;
        }
        String stringLimitationID = o_DMXControlDescription.getID();
        this.m_DMXUniverseInputPatch.removeLimitation(stringLimitationID);
        this.refreshGUI();
    }

    private void jButton_ShowRemoteSettingsActionPerformed(ActionEvent evt) {
        PlayRemoteActions.s_PlayRemoteActionConfiguration.setVisible(true);
    }

    public void setSelectedInputDMXUniverse(DMXUniverse p_DMXUniverse) {
        if (this.m_SelectedInputDMXUniverse == p_DMXUniverse) {
            return;
        }
        if (p_DMXUniverse != null) {
            this.m_SelectedInputDMXUniverse = p_DMXUniverse;
            this.jComboBox_Input_DMXUniverse.setSelectedItem(p_DMXUniverse);
        } else if (this.m_DMXUniverseInputListModelWrapper.getSize() > 0) {
            this.m_SelectedInputDMXUniverse = (DMXUniverse)this.jComboBox_Input_DMXUniverse.getItemAt(0);
            this.jComboBox_Input_DMXUniverse.setSelectedIndex(0);
        } else {
            this.m_SelectedInputDMXUniverse = null;
        }
        if (this.m_DMXUniverseInputPatch != null) {
            this.m_DMXUniverseInputPatch.removePropertyChangeListener(this);
        }
        this.m_DMXUniverseInputPatch = this.m_SelectedInputDMXUniverse != null ? this.m_SelectedInputDMXUniverse.getDMXUniverseInputPatch() : null;
        if (this.m_DMXUniverseInputPatch != null) {
            this.m_DMXUniverseInputPatch.addPropertyChangeListener(this);
            this.m_SelectedOutputDMXUniverse = this.m_DMXUniverseInputPatch.getDMXUniverseOutput();
            this.setInputPatchTableModel(this.m_DMXUniverseInputPatch.getInputPatchTableModel());
            this.m_DMXUniverseInputPatch.calculateChannelPatch();
        } else {
            this.m_SelectedOutputDMXUniverse = null;
            this.setInputPatchTableModel(DMXUniverseInputPatch.s_EmptyInputPatchTableModel);
        }
        this.refreshGUI();
    }

    public void setSelectedOutputDMXUniverse(DMXUniverse p_DMXUniverse) {
        if (this.m_SelectedOutputDMXUniverse == p_DMXUniverse) {
            return;
        }
        if (p_DMXUniverse != null) {
            this.m_SelectedOutputDMXUniverse = p_DMXUniverse;
            this.jComboBox_Output_DMXUniverse.setSelectedItem(p_DMXUniverse);
        } else if (this.m_DMXUniverseOutputListModelWrapper.getSize() > 0) {
            this.m_SelectedOutputDMXUniverse = (DMXUniverse)this.jComboBox_Output_DMXUniverse.getItemAt(0);
            this.jComboBox_Output_DMXUniverse.setSelectedIndex(0);
        } else {
            this.m_SelectedOutputDMXUniverse = null;
        }
        if (this.m_DMXUniverseInputPatch != null) {
            this.m_DMXUniverseInputPatch.setDMXUniverseOutput(this.m_SelectedOutputDMXUniverse);
        }
        this.refreshGUI();
    }

    public void refreshGUI() {
        if (this.m_SelectedInputDMXUniverse == null || this.m_DMXUniverseInputPatch == null) {
            this.jRadioButton_Input_AllValues.setEnabled(false);
            this.jRadioButton_Input_ChangedValues.setEnabled(false);
            this.jRadioButton_Input_ChangedValuesCaught.setEnabled(false);
            this.jRadioButton_Input_Remote.setEnabled(false);
            this.jLabel_Remark_Input.setText(REMARK_NODMXUNIVERSE);
            this.jLabel_Remark_Input.setVisible(true);
        } else {
            if (this.m_DMXUniverseInputPatch.getDMXUniverseInput() == null || !this.m_DMXUniverseInputPatch.isDMXInputConnected()) {
                this.jLabel_Remark_Input.setVisible(true);
                this.jLabel_Remark_Input.setText(REMARK_NODMXINPUT);
            } else {
                this.jLabel_Remark_Input.setVisible(false);
            }
            this.jRadioButton_Input_AllValues.setEnabled(true);
            this.jRadioButton_Input_ChangedValues.setEnabled(true);
            this.jRadioButton_Input_ChangedValuesCaught.setEnabled(true);
            this.jRadioButton_Input_Remote.setEnabled(true);
            this.jComboBox_Input_DMXUniverse.setSelectedItem(this.m_SelectedInputDMXUniverse);
            int intInputMode = this.m_DMXUniverseInputPatch.getInputMode();
            switch (intInputMode) {
                case 0: {
                    this.jRadioButton_Input_Remote.setSelected(true);
                    break;
                }
                case 2: {
                    this.jRadioButton_Input_AllValues.setSelected(true);
                    break;
                }
                case 4: {
                    this.jRadioButton_Input_ChangedValues.setSelected(true);
                    break;
                }
                case 8: {
                    this.jRadioButton_Input_ChangedValuesCaught.setSelected(true);
                }
            }
            this.jComboBox_Output_DMXUniverse.setSelectedItem(this.m_SelectedOutputDMXUniverse);
            int intOutputMode = this.m_DMXUniverseInputPatch.getOutputMode();
            switch (intOutputMode) {
                case 0: {
                    this.jRadioButton_Output_AllDevices.setSelected(true);
                    break;
                }
                case 4: {
                    this.jRadioButton_Output_SelectedDevices.setSelected(true);
                    break;
                }
                case 16: {
                    this.jRadioButton_Output_SelectedDevices_Patched.setSelected(true);
                }
            }
            StringBuilder o_StringBuilder = new StringBuilder();
            int intLimitationCount = this.m_DMXUniverseInputPatch.getLimitationCount();
            for (int intLimitation = 0; intLimitation < intLimitationCount; ++intLimitation) {
                String stringLimitationName = this.m_DMXUniverseInputPatch.getLimitationName(intLimitation);
                if (stringLimitationName == null) continue;
                if (o_StringBuilder.length() > 0) {
                    o_StringBuilder.append(" - ");
                }
                o_StringBuilder.append(stringLimitationName);
            }
            this.jLabel_Limitations.setText(o_StringBuilder.toString());
        }
    }

    public JLabel_ResizeFrame getLabel_ResizeFrame() {
        return this.jLabel_ResizeFrame1;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.jComboBox_Input_DMXUniverse) {
            if (this.jComboBox_Input_DMXUniverse.getSelectedItem() == this.m_SelectedInputDMXUniverse) {
                return;
            }
            this.setSelectedInputDMXUniverse((DMXUniverse)this.jComboBox_Input_DMXUniverse.getSelectedItem());
        } else if (e.getSource() == this.jComboBox_Output_DMXUniverse) {
            if (this.jComboBox_Output_DMXUniverse.getSelectedItem() == this.m_SelectedOutputDMXUniverse) {
                return;
            }
            this.setSelectedOutputDMXUniverse((DMXUniverse)this.jComboBox_Output_DMXUniverse.getSelectedItem());
        }
    }

    public static void showFrame() {
        if (s_FrameParent != null) {
            s_FrameParent.showFrame();
        }
    }

    public static void setFrameParent(FrameParent p_FrameParent) {
        s_FrameParent = p_FrameParent;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this.m_DMXUniverseInputPatch) {
            this.refreshGUI();
        }
    }
}

