/*
 * Decompiled with CFR 0.152.
 */
package DMXGraphics;

import DMXDevicePackage.DMXDevice;
import DMXDevicePackage.DMXDeviceReplacePanel;
import DMXDevicePackage.DMXDeviceType;
import DMXGraphics.LiveShowDMXAddressSetting;
import DMXMixer.DMXControlComponent;
import DMXVirtualPackage.LiveShowDMXVIP;
import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LanguageTools.LiveLanguagePackage.LiveLanguageString;
import StartPackage.LiveShowDMXSystem;
import SwingTextPackage.DocumentFilter_Integer;
import SwingToolTipPackage.PopUpToolTip;
import ToolsGraphics.JLabel_ResizeFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class LiveShowDMXDeviceSettings
extends JDialog
implements PropertyChangeListener,
ComponentListener,
WindowListener {
    public static LiveShowDMXDeviceSettings s_SelfReference;
    @LiveLanguageString
    public static String TAB_DMX;
    @LiveLanguageString
    public static String TAB_REPLACE;
    @LiveLanguageString
    public static String STRING_SECTORS;
    @LiveLanguageString
    public static String STRING_CHANNELS;
    private DMXDevice m_DMXDevice;
    private boolean m_Solo;
    private boolean m_Mute;
    private boolean m_Active;
    private int m_Scale;
    private Dimension m_OldSize;
    private boolean m_HasBeenSaved;
    private boolean m_HasBeenCancelled;
    private ArrayList<DMXControlComponent.DeviceSettingsPanel> m_DMXControlDeviceSettingsPanels;
    private DMXDeviceReplacePanel dMXDeviceReplacePanel1;
    private JButton jButton_Cancel;
    private JButton jButton_Save;
    private JLabel jLabelBackground_DMXDeviceImage;
    private JLabel jLabel_Active;
    private JLabel jLabel_ActiveHeader;
    private JLabel jLabel_DeviceChannelCount;
    private JLabel jLabel_DeviceDescription;
    private JLabel jLabel_DeviceManufactureer;
    private JLabel jLabel_DeviceName;
    private JLabel jLabel_DeviceSectorCount;
    private JLabel jLabel_DeviceTypeName;
    private JLabel jLabel_Mute;
    private JLabel jLabel_MuteHeader;
    private JLabel_ResizeFrame jLabel_ResizeFrame1;
    private JLabel jLabel_ScaleHeader;
    private JLabel jLabel_Solo;
    private JLabel jLabel_SoloHeader;
    private JPanel jPanel1;
    private JPanel jPanel_Content;
    private JPanel jPanel_DMXDevice;
    private JScrollPane jScrollPane_DeviceImage;
    private JTabbedPane jTabbedPane_DMXControlDeviceSettings;
    private JTextField jTextField_DeviceName;
    private JTextField jTextField_Scale;
    private LiveShowDMXAddressSetting liveShowDMXAddressSetting1;

    public static LiveShowDMXDeviceSettings getSelfRefernece() {
        return s_SelfReference;
    }

    public static void closeProject() {
        if (s_SelfReference != null) {
            s_SelfReference.setVisible(false);
            LiveShowDMXDeviceSettings.s_SelfReference.dMXDeviceReplacePanel1.setLiveShowDMXVIP(null);
        }
    }

    public static void close() {
        if (s_SelfReference != null) {
            LiveShowDMXDeviceSettings.closeProject();
            LiveShowDMXDeviceSettings.s_SelfReference.jButton_Cancel.setComponentPopupMenu(null);
            LiveShowDMXDeviceSettings.s_SelfReference.jButton_Save.setComponentPopupMenu(null);
            LiveShowDMXDeviceSettings.s_SelfReference.jTextField_DeviceName.setComponentPopupMenu(null);
            LiveShowDMXDeviceSettings.s_SelfReference.jTextField_Scale.setComponentPopupMenu(null);
        }
    }

    public LiveShowDMXDeviceSettings(Frame parent, boolean modal) {
        super(parent, modal);
        super.setAlwaysOnTop(true);
        this.initMembers();
        s_SelfReference = this;
        this.m_DMXControlDeviceSettingsPanels = new ArrayList();
        this.initComponents();
        this.initComponentsFurther();
        DMXDevice.getTreeModel_Device_Channels().addPropertyChangeListener(this);
        this.liveShowDMXAddressSetting1.addPropertyChangeListener(this);
        LiveLanguage.addLanguageListener((Object)this, null);
        this.jTabbedPane_DMXControlDeviceSettings.setTitleAt(0, TAB_DMX);
        this.jTabbedPane_DMXControlDeviceSettings.setTitleAt(1, TAB_REPLACE);
        this.addComponentListener(this);
        this.addWindowListener(this);
        this.setIconImage(new ImageIcon(this.getClass().getResource("/IconsPackage/DMX.png")).getImage());
    }

    private void initMembers() {
        this.m_OldSize = new Dimension(0, 0);
        this.m_HasBeenSaved = false;
        this.m_HasBeenCancelled = false;
    }

    private void initComponents() {
        this.jPanel_Content = new JPanel();
        this.jLabel_ResizeFrame1 = new JLabel_ResizeFrame();
        this.jLabel_DeviceName = new JLabel();
        this.jTextField_DeviceName = new JTextField();
        this.jPanel_DMXDevice = new JPanel();
        this.jScrollPane_DeviceImage = new JScrollPane();
        this.jLabelBackground_DMXDeviceImage = new JLabel();
        this.jLabel_DeviceManufactureer = new JLabel();
        this.jLabel_DeviceTypeName = new JLabel();
        this.jLabel_DeviceDescription = new JLabel();
        this.jLabel_SoloHeader = new JLabel();
        this.jLabel_Solo = new JLabel();
        this.jLabel_MuteHeader = new JLabel();
        this.jLabel_Mute = new JLabel();
        this.jLabel_ActiveHeader = new JLabel();
        this.jLabel_Active = new JLabel();
        this.jLabel_ScaleHeader = new JLabel();
        this.jTextField_Scale = new JTextField();
        this.jButton_Save = new JButton();
        this.jButton_Cancel = new JButton();
        this.jTabbedPane_DMXControlDeviceSettings = new JTabbedPane();
        this.jPanel1 = new JPanel();
        this.liveShowDMXAddressSetting1 = new LiveShowDMXAddressSetting();
        this.jLabel_DeviceChannelCount = new JLabel();
        this.jLabel_DeviceSectorCount = new JLabel();
        this.dMXDeviceReplacePanel1 = new DMXDeviceReplacePanel();
        this.setBackground(new Color(51, 51, 51));
        this.setMinimumSize(new Dimension(600, 600));
        this.setPreferredSize(new Dimension(900, 337));
        this.getContentPane().setLayout(new GridBagLayout());
        this.jPanel_Content.setBackground(Color.darkGray);
        this.jPanel_Content.setBorder(BorderFactory.createLineBorder(Color.gray));
        this.jPanel_Content.setLayout(new GridBagLayout());
        this.jLabel_ResizeFrame1.setToolTipText("");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 14;
        this.jPanel_Content.add((Component)this.jLabel_ResizeFrame1, gridBagConstraints);
        this.jLabel_DeviceName.setForeground(new Color(255, 255, 255));
        this.jLabel_DeviceName.setText("Device Name:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 3, 3, 3);
        this.jPanel_Content.add((Component)this.jLabel_DeviceName, gridBagConstraints);
        this.jTextField_DeviceName.setHorizontalAlignment(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Content.add((Component)this.jTextField_DeviceName, gridBagConstraints);
        this.jPanel_DMXDevice.setBackground(Color.darkGray);
        this.jPanel_DMXDevice.setLayout(new GridBagLayout());
        this.jScrollPane_DeviceImage.setBackground(Color.darkGray);
        this.jScrollPane_DeviceImage.setBorder(null);
        this.jScrollPane_DeviceImage.setMinimumSize(new Dimension(128, 128));
        this.jScrollPane_DeviceImage.setPreferredSize(new Dimension(128, 128));
        this.jLabelBackground_DMXDeviceImage.setBackground(Color.darkGray);
        this.jLabelBackground_DMXDeviceImage.setHorizontalAlignment(0);
        this.jScrollPane_DeviceImage.setViewportView(this.jLabelBackground_DMXDeviceImage);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_DMXDevice.add((Component)this.jScrollPane_DeviceImage, gridBagConstraints);
        this.jLabel_DeviceManufactureer.setForeground(new Color(255, 255, 255));
        this.jLabel_DeviceManufactureer.setHorizontalAlignment(0);
        this.jLabel_DeviceManufactureer.setPreferredSize(new Dimension(50, 14));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_DMXDevice.add((Component)this.jLabel_DeviceManufactureer, gridBagConstraints);
        this.jLabel_DeviceTypeName.setBackground(new Color(192, 192, 192));
        this.jLabel_DeviceTypeName.setForeground(new Color(255, 255, 255));
        this.jLabel_DeviceTypeName.setHorizontalAlignment(0);
        this.jLabel_DeviceTypeName.setPreferredSize(new Dimension(50, 14));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_DMXDevice.add((Component)this.jLabel_DeviceTypeName, gridBagConstraints);
        this.jLabel_DeviceDescription.setForeground(new Color(255, 255, 255));
        this.jLabel_DeviceDescription.setHorizontalAlignment(0);
        this.jLabel_DeviceDescription.setPreferredSize(new Dimension(50, 14));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_DMXDevice.add((Component)this.jLabel_DeviceDescription, gridBagConstraints);
        this.jLabel_SoloHeader.setForeground(new Color(255, 255, 255));
        this.jLabel_SoloHeader.setText("Solo");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_DMXDevice.add((Component)this.jLabel_SoloHeader, gridBagConstraints);
        this.jLabel_Solo.setBackground(new Color(64, 64, 64));
        this.jLabel_Solo.setBorder(BorderFactory.createLineBorder(new Color(255, 255, 0)));
        this.jLabel_Solo.setMaximumSize(new Dimension(16, 16));
        this.jLabel_Solo.setMinimumSize(new Dimension(16, 16));
        this.jLabel_Solo.setOpaque(true);
        this.jLabel_Solo.setPreferredSize(new Dimension(16, 16));
        this.jLabel_Solo.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                LiveShowDMXDeviceSettings.this.jLabel_SoloMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_DMXDevice.add((Component)this.jLabel_Solo, gridBagConstraints);
        this.jLabel_MuteHeader.setForeground(new Color(255, 255, 255));
        this.jLabel_MuteHeader.setText("Mute");
        this.jLabel_MuteHeader.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_DMXDevice.add((Component)this.jLabel_MuteHeader, gridBagConstraints);
        this.jLabel_Mute.setBackground(new Color(64, 64, 64));
        this.jLabel_Mute.setBorder(BorderFactory.createLineBorder(new Color(255, 175, 175)));
        this.jLabel_Mute.setMaximumSize(new Dimension(16, 16));
        this.jLabel_Mute.setMinimumSize(new Dimension(16, 16));
        this.jLabel_Mute.setOpaque(true);
        this.jLabel_Mute.setPreferredSize(new Dimension(16, 16));
        this.jLabel_Mute.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                LiveShowDMXDeviceSettings.this.jLabel_MuteMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_DMXDevice.add((Component)this.jLabel_Mute, gridBagConstraints);
        this.jLabel_ActiveHeader.setForeground(new Color(255, 255, 255));
        this.jLabel_ActiveHeader.setText("Active");
        this.jLabel_ActiveHeader.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_DMXDevice.add((Component)this.jLabel_ActiveHeader, gridBagConstraints);
        this.jLabel_Active.setBackground(new Color(64, 64, 64));
        this.jLabel_Active.setBorder(BorderFactory.createLineBorder(new Color(255, 0, 0)));
        this.jLabel_Active.setMaximumSize(new Dimension(16, 16));
        this.jLabel_Active.setMinimumSize(new Dimension(16, 16));
        this.jLabel_Active.setOpaque(true);
        this.jLabel_Active.setPreferredSize(new Dimension(16, 16));
        this.jLabel_Active.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                LiveShowDMXDeviceSettings.this.jLabel_ActiveMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_DMXDevice.add((Component)this.jLabel_Active, gridBagConstraints);
        this.jLabel_ScaleHeader.setForeground(new Color(255, 255, 255));
        this.jLabel_ScaleHeader.setText("Scale");
        this.jLabel_ScaleHeader.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_DMXDevice.add((Component)this.jLabel_ScaleHeader, gridBagConstraints);
        this.jTextField_Scale.setHorizontalAlignment(0);
        this.jTextField_Scale.setToolTipText("");
        this.jTextField_Scale.setPreferredSize(new Dimension(70, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 1, 3);
        this.jPanel_DMXDevice.add((Component)this.jTextField_Scale, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Content.add((Component)this.jPanel_DMXDevice, gridBagConstraints);
        this.jButton_Save.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Edit_OK.png")));
        this.jButton_Save.setBorderPainted(false);
        this.jButton_Save.setContentAreaFilled(false);
        this.jButton_Save.setIconTextGap(0);
        this.jButton_Save.setMargin(new Insets(0, 0, 0, 0));
        this.jButton_Save.setMaximumSize(new Dimension(32, 32));
        this.jButton_Save.setMinimumSize(new Dimension(32, 32));
        this.jButton_Save.setPreferredSize(new Dimension(32, 32));
        this.jButton_Save.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_Save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowDMXDeviceSettings.this.jButton_SaveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Content.add((Component)this.jButton_Save, gridBagConstraints);
        this.jButton_Cancel.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Edit_Cancel.png")));
        this.jButton_Cancel.setBorderPainted(false);
        this.jButton_Cancel.setContentAreaFilled(false);
        this.jButton_Cancel.setIconTextGap(0);
        this.jButton_Cancel.setMargin(new Insets(0, 0, 0, 0));
        this.jButton_Cancel.setMaximumSize(new Dimension(32, 32));
        this.jButton_Cancel.setMinimumSize(new Dimension(32, 32));
        this.jButton_Cancel.setPreferredSize(new Dimension(32, 32));
        this.jButton_Cancel.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_Cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowDMXDeviceSettings.this.jButton_CancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Content.add((Component)this.jButton_Cancel, gridBagConstraints);
        this.jTabbedPane_DMXControlDeviceSettings.setBackground(Color.darkGray);
        this.jTabbedPane_DMXControlDeviceSettings.setMinimumSize(new Dimension(200, 200));
        this.jTabbedPane_DMXControlDeviceSettings.setOpaque(true);
        this.jTabbedPane_DMXControlDeviceSettings.setPreferredSize(new Dimension(200, 200));
        this.jPanel1.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.liveShowDMXAddressSetting1, gridBagConstraints);
        this.jLabel_DeviceChannelCount.setBackground(new Color(0, 0, 80));
        this.jLabel_DeviceChannelCount.setFont(new Font("Tahoma", 0, 14));
        this.jLabel_DeviceChannelCount.setForeground(new Color(255, 255, 255));
        this.jLabel_DeviceChannelCount.setHorizontalAlignment(0);
        this.jLabel_DeviceChannelCount.setText("DMX channels");
        this.jLabel_DeviceChannelCount.setToolTipText("");
        this.jLabel_DeviceChannelCount.setMaximumSize(new Dimension(71, 25));
        this.jLabel_DeviceChannelCount.setMinimumSize(new Dimension(20, 25));
        this.jLabel_DeviceChannelCount.setName("");
        this.jLabel_DeviceChannelCount.setOpaque(true);
        this.jLabel_DeviceChannelCount.setPreferredSize(new Dimension(50, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.jLabel_DeviceChannelCount, gridBagConstraints);
        this.jLabel_DeviceSectorCount.setBackground(new Color(0, 0, 80));
        this.jLabel_DeviceSectorCount.setFont(new Font("Tahoma", 0, 14));
        this.jLabel_DeviceSectorCount.setForeground(new Color(255, 255, 255));
        this.jLabel_DeviceSectorCount.setHorizontalAlignment(0);
        this.jLabel_DeviceSectorCount.setText("DMX inputs");
        this.jLabel_DeviceSectorCount.setToolTipText("");
        this.jLabel_DeviceSectorCount.setMaximumSize(new Dimension(71, 25));
        this.jLabel_DeviceSectorCount.setMinimumSize(new Dimension(20, 25));
        this.jLabel_DeviceSectorCount.setName("");
        this.jLabel_DeviceSectorCount.setOpaque(true);
        this.jLabel_DeviceSectorCount.setPreferredSize(new Dimension(50, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.jLabel_DeviceSectorCount, gridBagConstraints);
        this.jTabbedPane_DMXControlDeviceSettings.addTab("DMX", this.jPanel1);
        this.dMXDeviceReplacePanel1.setForeground(new Color(255, 255, 255));
        this.jTabbedPane_DMXControlDeviceSettings.addTab("Replace", this.dMXDeviceReplacePanel1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Content.add((Component)this.jTabbedPane_DMXControlDeviceSettings, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jPanel_Content, gridBagConstraints);
        this.pack();
    }

    private void initComponentsFurther() {
        this.getContentPane().setBackground(Color.DARK_GRAY);
        this.jScrollPane_DeviceImage.getViewport().setBackground(Color.DARK_GRAY);
        this.jLabel_ResizeFrame1.setContainer(this);
        DocumentFilter_Integer o_DocumentFilter_Integer = new DocumentFilter_Integer(this.jTextField_Scale);
        this.jButton_Cancel.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_Save.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jTextField_DeviceName.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jTextField_Scale.setComponentPopupMenu(PopUpToolTip.getSelfReference());
    }

    public void setLiveShowDMXVIP(LiveShowDMXVIP p_LiveShowDMXVIP) {
        this.dMXDeviceReplacePanel1.setLiveShowDMXVIP(p_LiveShowDMXVIP);
    }

    public void setDMXDevice(DMXDevice p_DMXDevice) {
        DMXControlComponent.DeviceSettingsPanel o_DMXControlDeviceSettingPanel;
        for (int intPanel = this.m_DMXControlDeviceSettingsPanels.size() - 1; intPanel >= 0; --intPanel) {
            o_DMXControlDeviceSettingPanel = this.m_DMXControlDeviceSettingsPanels.get(intPanel);
            o_DMXControlDeviceSettingPanel.setVisible(false);
            this.jTabbedPane_DMXControlDeviceSettings.remove(o_DMXControlDeviceSettingPanel);
            this.m_DMXControlDeviceSettingsPanels.remove(o_DMXControlDeviceSettingPanel);
        }
        if (this.m_DMXDevice != null) {
            this.m_DMXDevice.removePropertyChangeListener(this);
        }
        this.m_DMXDevice = p_DMXDevice;
        if (this.m_DMXDevice != null) {
            this.dMXDeviceReplacePanel1.setLiveShowDMXVIP(LiveShowDMXSystem.getLiveShowDMXVIP());
            this.dMXDeviceReplacePanel1.setDMXDevice(this.m_DMXDevice);
            this.m_DMXDevice.addPropertyChangeListener(this);
            this.m_Solo = this.m_DMXDevice.getSolo();
            this.m_Mute = this.m_DMXDevice.getMute();
            this.m_Scale = this.m_DMXDevice.getHasDimmerLinked() ? this.m_DMXDevice.getScale() : 100;
            this.m_Active = this.m_DMXDevice.getActive();
        } else {
            this.m_Solo = false;
            this.m_Mute = false;
            this.m_Scale = 100;
            this.m_Active = false;
        }
        if (this.m_DMXDevice != null) {
            int intDeviceSettingsPanelCount = this.m_DMXDevice.getDeviceSettingsPanelCount();
            for (int intDMXControl = 0; intDMXControl < intDeviceSettingsPanelCount; ++intDMXControl) {
                o_DMXControlDeviceSettingPanel = this.m_DMXDevice.getDeviceSettingsPanel(intDMXControl);
                this.m_DMXControlDeviceSettingsPanels.add(o_DMXControlDeviceSettingPanel);
                int intTabCount = this.jTabbedPane_DMXControlDeviceSettings.getTabCount();
                this.jTabbedPane_DMXControlDeviceSettings.insertTab(o_DMXControlDeviceSettingPanel.getDMXControlComponentName(), null, o_DMXControlDeviceSettingPanel, null, this.jTabbedPane_DMXControlDeviceSettings.getTabCount());
                o_DMXControlDeviceSettingPanel.setDMXDevice(this.m_DMXDevice);
                o_DMXControlDeviceSettingPanel.setVisible(false);
            }
            if (this.jTabbedPane_DMXControlDeviceSettings.getTabCount() > 0) {
                this.jTabbedPane_DMXControlDeviceSettings.setSelectedIndex(0);
            }
        }
        this.refresh();
    }

    private void refresh() {
        if (this.m_DMXDevice == null) {
            this.jTextField_DeviceName.setText("");
            this.liveShowDMXAddressSetting1.setDMXAddressSectors(null);
            this.jLabelBackground_DMXDeviceImage.setIcon(null);
            this.jLabel_DeviceManufactureer.setText("");
            this.jLabel_DeviceTypeName.setText("");
            this.jLabel_DeviceDescription.setText("");
            this.jLabel_DeviceChannelCount.setText("");
            this.jLabel_Solo.setBackground(Color.GRAY);
            this.jLabel_Mute.setBackground(Color.GRAY);
            this.jLabel_Active.setBackground(Color.GRAY);
            this.jTextField_Scale.setText("100");
            this.jLabel_Solo.setVisible(false);
            this.jLabel_SoloHeader.setVisible(false);
            this.jLabel_Mute.setVisible(false);
            this.jLabel_MuteHeader.setVisible(false);
            this.jLabel_ScaleHeader.setVisible(false);
            this.jTextField_Scale.setVisible(false);
            this.dMXDeviceReplacePanel1.setDMXDevice(null);
        } else {
            DMXDeviceType o_DMXDeviceType = this.m_DMXDevice.getDMXDeviceType();
            this.jTextField_DeviceName.setText(this.m_DMXDevice.getName());
            this.liveShowDMXAddressSetting1.setDMXAddressSectors(this.m_DMXDevice);
            this.liveShowDMXAddressSetting1.checkAddressValid(this.m_DMXDevice);
            if (o_DMXDeviceType != null) {
                DMXDeviceType.DMXDeviceSector o_InternalSector;
                this.jLabelBackground_DMXDeviceImage.setIcon(o_DMXDeviceType.getDeviceIcon());
                this.jLabel_DeviceManufactureer.setText(o_DMXDeviceType.getManufactureerName());
                this.jLabel_DeviceTypeName.setText(o_DMXDeviceType.getTypeName());
                DMXDevice.SectorAddress o_SelectedSectorAddress = this.liveShowDMXAddressSetting1.getSelectedDMXAddressSector();
                StringBuilder o_StringBuilder = new StringBuilder();
                o_StringBuilder.delete(0, o_StringBuilder.length());
                o_StringBuilder.append(STRING_SECTORS);
                o_StringBuilder.append(" ");
                o_StringBuilder.append(o_DMXDeviceType.getDMXDeviceSectorCount());
                this.jLabel_DeviceSectorCount.setText(o_StringBuilder.toString());
                o_StringBuilder.delete(0, o_StringBuilder.length());
                o_StringBuilder.append(STRING_CHANNELS);
                o_StringBuilder.append(" ");
                if (o_SelectedSectorAddress != null && (o_InternalSector = o_DMXDeviceType.getDMXDeviceSector(o_SelectedSectorAddress.getDMXDeviceSectorIndex())) != null) {
                    o_StringBuilder.append(String.valueOf(o_InternalSector.getChannelCount()));
                }
                this.jLabel_DeviceChannelCount.setText(o_StringBuilder.toString());
                this.jLabel_DeviceDescription.setText(o_DMXDeviceType.getRemark());
            }
            if (this.m_DMXDevice.getIsDimmable()) {
                this.jLabel_Solo.setVisible(true);
                this.jLabel_SoloHeader.setVisible(true);
                this.jLabel_Mute.setVisible(true);
                this.jLabel_MuteHeader.setVisible(true);
                this.jLabel_ScaleHeader.setVisible(true);
                this.jTextField_Scale.setVisible(true);
                if (this.m_Solo) {
                    this.jLabel_Solo.setBackground(Color.YELLOW);
                } else {
                    this.jLabel_Solo.setBackground(Color.DARK_GRAY);
                }
                if (this.m_Mute) {
                    this.jLabel_Mute.setBackground(Color.PINK);
                } else {
                    this.jLabel_Mute.setBackground(Color.DARK_GRAY);
                }
                this.jTextField_Scale.setText(String.valueOf(this.m_Scale));
                if (this.m_DMXDevice.getHasDimmerLinked()) {
                    this.jTextField_Scale.setEnabled(true);
                } else {
                    this.jTextField_Scale.setEnabled(false);
                }
            } else {
                this.jLabel_Solo.setVisible(false);
                this.jLabel_SoloHeader.setVisible(false);
                this.jLabel_Mute.setVisible(false);
                this.jLabel_MuteHeader.setVisible(false);
                this.jLabel_ScaleHeader.setVisible(false);
                this.jTextField_Scale.setVisible(false);
            }
            if (this.m_Active) {
                this.jLabel_Active.setBackground(Color.GREEN);
            } else {
                this.jLabel_Active.setBackground(Color.RED);
            }
            this.dMXDeviceReplacePanel1.setDMXDevice(this.m_DMXDevice);
        }
    }

    private void jButton_SaveActionPerformed(ActionEvent evt) {
        if (this.m_DMXDevice == null) {
            return;
        }
        this.m_DMXDevice.removePropertyChangeListener(this);
        this.m_DMXDevice.setName(this.jTextField_DeviceName.getText());
        this.liveShowDMXAddressSetting1.setDMXDeviceToDMXAddress(this.m_DMXDevice);
        this.m_DMXDevice.setActive(this.m_Active);
        if (this.m_DMXDevice.getIsDimmable()) {
            this.m_DMXDevice.setSolo(this.m_Solo);
            this.m_DMXDevice.setMute(this.m_Mute);
            this.m_DMXDevice.setScale(this.m_Scale);
        } else {
            this.m_DMXDevice.setSolo(false);
            this.m_DMXDevice.setMute(false);
            this.m_DMXDevice.setScale(100);
        }
        for (int intDeviceSettings = 0; intDeviceSettings < this.m_DMXControlDeviceSettingsPanels.size(); ++intDeviceSettings) {
            DMXControlComponent.DeviceSettingsPanel o_DeviceSettingsPanel = this.m_DMXControlDeviceSettingsPanels.get(intDeviceSettings);
            o_DeviceSettingsPanel.save();
        }
        if (this.m_DMXDevice.getIsDimmable()) {
            try {
                this.m_DMXDevice.setScale(Integer.valueOf(this.jTextField_Scale.getText()));
            }
            catch (Exception e) {
                this.jTextField_Scale.setText(String.valueOf(this.m_DMXDevice.getScale()));
            }
        }
        this.m_DMXDevice.addPropertyChangeListener(this);
        this.refresh();
        this.m_HasBeenSaved = true;
        this.setVisible(false);
    }

    private void jButton_CancelActionPerformed(ActionEvent evt) {
        this.cancel();
        this.setVisible(false);
    }

    private void cancel() {
        if (this.m_DMXDevice != null) {
            this.m_Solo = this.m_DMXDevice.getSolo();
            this.m_Mute = this.m_DMXDevice.getMute();
            this.m_Scale = this.m_DMXDevice.getScale();
            this.m_Active = this.m_DMXDevice.getActive();
        }
        for (int intDeviceSettings = 0; intDeviceSettings < this.m_DMXControlDeviceSettingsPanels.size(); ++intDeviceSettings) {
            DMXControlComponent.DeviceSettingsPanel o_DeviceSettingsPanel = this.m_DMXControlDeviceSettingsPanels.get(intDeviceSettings);
            o_DeviceSettingsPanel.cancel();
        }
        this.refresh();
        this.m_HasBeenCancelled = true;
    }

    private void jLabel_SoloMouseClicked(MouseEvent evt) {
        if (this.m_DMXDevice != null) {
            this.m_Solo = !this.m_Solo;
        }
        this.refresh();
    }

    private void jLabel_MuteMouseClicked(MouseEvent evt) {
        if (this.m_DMXDevice != null) {
            this.m_Mute = !this.m_Mute;
        }
        this.refresh();
    }

    private void jLabel_ActiveMouseClicked(MouseEvent evt) {
        if (this.m_DMXDevice != null) {
            this.m_Active = !this.m_Active;
        }
        this.refresh();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof DMXDevice.TreeModel_Device_Channels) {
            if ("dmxdevicetreemodelDMXDeviceRemoved".equals(evt.getPropertyName())) {
                DMXDevice.TreeModel_Device_Channels o_DMXDeviceTreeModel_Channel = (DMXDevice.TreeModel_Device_Channels)evt.getSource();
                DMXDevice o_DMXDevice = (DMXDevice)evt.getOldValue();
                if (o_DMXDevice == this.m_DMXDevice) {
                    this.setDMXDevice(null);
                }
            }
        } else if (evt.getSource() instanceof LiveShowDMXAddressSetting) {
            if (LiveShowDMXAddressSetting.PROPERTY_DMXDEVICESECTORINDEX.equals(evt.getPropertyName())) {
                this.refresh();
            }
            if (LiveShowDMXAddressSetting.PROPERTY_DMXUNIVERSE.equals(evt.getPropertyName())) {
                this.liveShowDMXAddressSetting1.checkAddressValid(this.m_DMXDevice);
            } else if (LiveShowDMXAddressSetting.PROPERTY_DMXADDRESS.equals(evt.getPropertyName())) {
                this.liveShowDMXAddressSetting1.checkAddressValid(this.m_DMXDevice);
            }
        } else if (evt.getSource() instanceof DMXDevice) {
            DMXDevice o_DMXDevice = (DMXDevice)evt.getSource();
            if ("dmxdeviceDeviceActive".equals(evt.getPropertyName())) {
                this.m_Active = o_DMXDevice.getActive();
            }
            if ("dmxdeviceAdjustedSceneBridge".equals(evt.getPropertyName())) {
                return;
            }
            if ("dmxdeviceDimmerValue".equals(evt.getPropertyName())) {
                return;
            }
            this.refresh();
        }
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (this.getWidth() == this.m_OldSize.width && this.getHeight() == this.m_OldSize.height) {
            return;
        }
        this.m_OldSize.setSize(this.getWidth(), this.getHeight());
        this.revalidate();
        this.repaint();
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
        this.m_HasBeenSaved = false;
        this.m_HasBeenCancelled = false;
    }

    @Override
    public void windowClosing(WindowEvent e) {
        if (!this.m_HasBeenSaved && !this.m_HasBeenCancelled) {
            this.cancel();
        }
        this.m_HasBeenSaved = false;
        this.m_HasBeenCancelled = false;
        this.dMXDeviceReplacePanel1.setDMXDevice(null);
        this.dMXDeviceReplacePanel1.setLiveShowDMXVIP(null);
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    static {
        TAB_DMX = "DMX";
        TAB_REPLACE = "replace";
        STRING_SECTORS = "DMX inputs:";
        STRING_CHANNELS = "DMX channels:";
    }
}

