/*
 * Decompiled with CFR 0.152.
 */
package DMXGraphics;

import DMXDevicePackage.DMXDevice;
import DMXGraphics.DMXTrackingSceneEditPanel;
import DMXMixer.DMXControlComponent;
import DMXMixer.DMXControlDisplayLabel;
import DMXScenePackage.DMXScene;
import DMXVirtualPackage.LiveShowDMXVIP;
import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LanguageTools.LiveLanguagePackage.LiveLanguageString;
import LiveShowControlModels.ControlLabelModel;
import LiveShowControlObjects.ControlObject;
import SwingModelPackage.TableAndListModel;
import SwingToolTipPackage.PopUpToolTip;
import SynchronizationPackage.EventQueueHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;

public class LiveShowDMXCrossTable_DMXDeviceDMXScene
extends JPanel
implements DMXTrackingSceneEditPanel.SelectionSourceInterface,
ListSelectionListener,
TableModelListener,
ComponentListener {
    private static ArrayList<LiveShowDMXCrossTable_DMXDeviceDMXScene> s_CrossTables = new ArrayList();
    public static DMXCrossTableCellRenderer_DMXDeviceDMXScene s_CrossTableCellRenderer_DMXDeviceDMXScene = new DMXCrossTableCellRenderer_DMXDeviceDMXScene();
    public static DMXCrossTableHeaderRenderer_DMXDeviceDMXScene s_CrossTableHeaderRenderer_DMXDeviceDMXScene = new DMXCrossTableHeaderRenderer_DMXDeviceDMXScene();
    private DMXCrossTableModel_DMXDeviceDMXScene m_CrossTableModel_DMXDeviceDMXScene;
    private ArrayList<SelectionListenerDMXDeviceDMXScene> m_SelectionListenerDMXDeviceDMXScenes;
    private boolean m_CopyOn;
    private DMXControlComponent m_CopyDestination;
    private static Cursor s_CopyCursor = Toolkit.getDefaultToolkit().createCustomCursor(new ImageIcon(LiveShowDMXCrossTable_DMXDeviceDMXScene.class.getResource("/IconsPackage/MousePointer_Copy.png")).getImage(), new Point(0, 0), "CursorCopy");
    private int m_ActualSelectedRow;
    private int m_ActualSelectedColumn;
    private final Object m_SyncObject_Table = new Object();
    public static final Object s_SyncObject = new Object();
    private JButton jButton_ZoomMinus;
    private JButton jButton_ZoomPlus;
    private JScrollPane jScrollPane1;
    private JTable jTable_DMXDeviceDMXScene;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDMXScene(DMXScene p_DMXScene) {
        Object object = s_SyncObject;
        synchronized (object) {
            for (int intTable = 0; intTable < s_CrossTables.size(); ++intTable) {
                LiveShowDMXCrossTable_DMXDeviceDMXScene o_CrossTable = s_CrossTables.get(intTable);
                DMXCrossTableModel_DMXDeviceDMXScene o_DMXCrossTableModel_DMXDeviceDMXScene = o_CrossTable.getTableModel();
                if (o_DMXCrossTableModel_DMXDeviceDMXScene == null) continue;
                o_DMXCrossTableModel_DMXDeviceDMXScene.addDMXScene(p_DMXScene);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeDMXScene(DMXScene p_DMXScene) {
        Object object = s_SyncObject;
        synchronized (object) {
            for (int intTable = 0; intTable < s_CrossTables.size(); ++intTable) {
                LiveShowDMXCrossTable_DMXDeviceDMXScene o_CrossTable = s_CrossTables.get(intTable);
                DMXCrossTableModel_DMXDeviceDMXScene o_DMXCrossTableModel_DMXDeviceDMXScene = o_CrossTable.getTableModel();
                if (o_DMXCrossTableModel_DMXDeviceDMXScene == null) continue;
                o_CrossTable.getTableModel().removeDMXScene(p_DMXScene);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LiveShowDMXCrossTable_DMXDeviceDMXScene() {
        this.initMembers();
        this.initComponents();
        this.initComponentsFurther();
        LiveLanguage.addLanguageListener((Object)this, null);
        Object object = s_SyncObject;
        synchronized (object) {
            s_CrossTables.add(this);
        }
    }

    private void initMembers() {
        this.m_SelectionListenerDMXDeviceDMXScenes = new ArrayList();
        this.m_CrossTableModel_DMXDeviceDMXScene = new DMXCrossTableModel_DMXDeviceDMXScene();
        this.m_CopyOn = false;
        this.m_CopyDestination = null;
    }

    private void initComponentsFurther() {
        this.jTable_DMXDeviceDMXScene.setModel(this.m_CrossTableModel_DMXDeviceDMXScene);
        this.m_CrossTableModel_DMXDeviceDMXScene.finishJTable(this.jTable_DMXDeviceDMXScene);
        this.m_CrossTableModel_DMXDeviceDMXScene.addTableModelListener(this);
        this.jTable_DMXDeviceDMXScene.getColumnModel().getColumn(0).setCellRenderer(s_CrossTableCellRenderer_DMXDeviceDMXScene);
        this.jTable_DMXDeviceDMXScene.getSelectionModel().addListSelectionListener(this);
        this.jTable_DMXDeviceDMXScene.getColumnModel().getSelectionModel().addListSelectionListener(this);
        this.jTable_DMXDeviceDMXScene.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent p_MouseEvent) {
                Point o_PointMousePosition = p_MouseEvent.getPoint();
                if (o_PointMousePosition == null) {
                    return;
                }
                int intSelectedRow = LiveShowDMXCrossTable_DMXDeviceDMXScene.this.jTable_DMXDeviceDMXScene.rowAtPoint(o_PointMousePosition);
                int intSelectedColumn = LiveShowDMXCrossTable_DMXDeviceDMXScene.this.jTable_DMXDeviceDMXScene.columnAtPoint(p_MouseEvent.getPoint());
                if (intSelectedRow < 0 || intSelectedRow >= LiveShowDMXCrossTable_DMXDeviceDMXScene.this.jTable_DMXDeviceDMXScene.getRowCount()) {
                    return;
                }
                if (intSelectedColumn < 0 || intSelectedColumn >= LiveShowDMXCrossTable_DMXDeviceDMXScene.this.jTable_DMXDeviceDMXScene.getColumnCount()) {
                    return;
                }
                if (!LiveShowDMXCrossTable_DMXDeviceDMXScene.this.m_CopyOn) {
                    LiveShowDMXCrossTable_DMXDeviceDMXScene.this.setSelectedCell(intSelectedRow, intSelectedColumn);
                } else {
                    DMXDevice o_DMXDevice = null;
                    DMXScene o_DMXScene = null;
                    if (intSelectedColumn >= 0) {
                        try {
                            intSelectedColumn = LiveShowDMXCrossTable_DMXDeviceDMXScene.this.jTable_DMXDeviceDMXScene.convertColumnIndexToModel(intSelectedColumn);
                            o_DMXDevice = LiveShowDMXCrossTable_DMXDeviceDMXScene.this.m_CrossTableModel_DMXDeviceDMXScene.getDMXDevice(intSelectedColumn - 1);
                        }
                        catch (Exception e) {
                            o_DMXDevice = null;
                        }
                    }
                    if (intSelectedRow >= 0) {
                        try {
                            intSelectedRow = LiveShowDMXCrossTable_DMXDeviceDMXScene.this.jTable_DMXDeviceDMXScene.convertRowIndexToModel(intSelectedRow);
                            o_DMXScene = LiveShowDMXCrossTable_DMXDeviceDMXScene.this.m_CrossTableModel_DMXDeviceDMXScene.getDMXScene(intSelectedRow);
                        }
                        catch (Exception e) {
                            o_DMXScene = null;
                        }
                    }
                    try {
                        LiveShowDMXCrossTable_DMXDeviceDMXScene.this.jTable_DMXDeviceDMXScene.setRowSelectionInterval(LiveShowDMXCrossTable_DMXDeviceDMXScene.this.m_ActualSelectedRow, LiveShowDMXCrossTable_DMXDeviceDMXScene.this.m_ActualSelectedRow);
                        LiveShowDMXCrossTable_DMXDeviceDMXScene.this.jTable_DMXDeviceDMXScene.setColumnSelectionInterval(LiveShowDMXCrossTable_DMXDeviceDMXScene.this.m_ActualSelectedColumn, LiveShowDMXCrossTable_DMXDeviceDMXScene.this.m_ActualSelectedColumn);
                    }
                    catch (Exception e) {
                        System.out.println(e.getStackTrace());
                    }
                    LiveShowDMXCrossTable_DMXDeviceDMXScene.this.notifySelectionListeners_CopyFrom(o_DMXScene, o_DMXDevice);
                }
            }
        });
        this.jTable_DMXDeviceDMXScene.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jTable_DMXDeviceDMXScene.getTableHeader().setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_ZoomMinus.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_ZoomPlus.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_ZoomMinus.setEnabled(false);
        this.addComponentListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        LiveLanguage.removeLanguageListener((Object)this);
        Object object = this.m_SyncObject_Table;
        synchronized (object) {
            this.jTable_DMXDeviceDMXScene.setComponentPopupMenu(null);
            this.jTable_DMXDeviceDMXScene.getTableHeader().setComponentPopupMenu(null);
            this.jButton_ZoomMinus.setComponentPopupMenu(null);
            this.jButton_ZoomPlus.setComponentPopupMenu(null);
            this.jTable_DMXDeviceDMXScene.getSelectionModel().removeListSelectionListener(this);
            this.jTable_DMXDeviceDMXScene.getColumnModel().getSelectionModel().removeListSelectionListener(this);
            Object object2 = s_SyncObject;
            synchronized (object2) {
                s_CrossTables.remove(this);
            }
            this.m_CrossTableModel_DMXDeviceDMXScene.close();
            this.m_SelectionListenerDMXDeviceDMXScenes.clear();
            this.jTable_DMXDeviceDMXScene.setComponentPopupMenu(null);
            this.jButton_ZoomMinus.setComponentPopupMenu(null);
            this.jButton_ZoomPlus.setComponentPopupMenu(null);
        }
        LiveLanguage.removeLanguageListener((Object)this);
    }

    private void setSelectedCell(int p_SelectedRow, int p_SelectedColumn) {
        this.m_ActualSelectedColumn = p_SelectedColumn;
        this.m_ActualSelectedRow = p_SelectedRow;
        DMXDevice o_DMXDevice = null;
        DMXScene o_DMXScene = null;
        if (p_SelectedColumn >= 0 && p_SelectedColumn < this.jTable_DMXDeviceDMXScene.getColumnCount()) {
            try {
                int intSelectedColumn = this.jTable_DMXDeviceDMXScene.convertColumnIndexToModel(p_SelectedColumn);
                o_DMXDevice = this.m_CrossTableModel_DMXDeviceDMXScene.getDMXDevice(intSelectedColumn - 1);
            }
            catch (Exception e) {
                o_DMXDevice = null;
            }
        }
        if (p_SelectedRow >= 0 && p_SelectedRow < this.jTable_DMXDeviceDMXScene.getRowCount()) {
            try {
                int intSelectedRow = this.jTable_DMXDeviceDMXScene.convertRowIndexToModel(p_SelectedRow);
                o_DMXScene = this.m_CrossTableModel_DMXDeviceDMXScene.getDMXScene(intSelectedRow);
            }
            catch (Exception e) {
                o_DMXScene = null;
            }
        }
        try {
            if (this.m_ActualSelectedRow >= 0 && this.m_ActualSelectedColumn >= 0 && this.m_ActualSelectedRow < this.jTable_DMXDeviceDMXScene.getRowCount() && this.m_ActualSelectedColumn < this.jTable_DMXDeviceDMXScene.getColumnCount() && (this.jTable_DMXDeviceDMXScene.getSelectedRow() != this.m_ActualSelectedRow || this.jTable_DMXDeviceDMXScene.getSelectedColumn() != this.m_ActualSelectedColumn)) {
                this.jTable_DMXDeviceDMXScene.setRowSelectionInterval(this.m_ActualSelectedRow, this.m_ActualSelectedRow);
                this.jTable_DMXDeviceDMXScene.setColumnSelectionInterval(this.m_ActualSelectedColumn, this.m_ActualSelectedColumn);
            }
        }
        catch (Exception e) {
            System.out.println(e.getStackTrace());
        }
        this.notifySelectionListeners_Select(o_DMXScene, o_DMXDevice);
    }

    public void setLiveShowDMXVIP(LiveShowDMXVIP p_LiveShowDMXVIP) {
        this.m_CrossTableModel_DMXDeviceDMXScene.setLiveShowDMXVIP(p_LiveShowDMXVIP);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTable_DMXDeviceDMXScene = new JTable();
        this.jButton_ZoomPlus = new JButton();
        this.jButton_ZoomMinus = new JButton();
        this.setToolTipText("");
        this.setLayout(new GridBagLayout());
        this.jTable_DMXDeviceDMXScene.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTable_DMXDeviceDMXScene.setToolTipText("");
        this.jTable_DMXDeviceDMXScene.setAutoResizeMode(0);
        this.jTable_DMXDeviceDMXScene.setCellSelectionEnabled(true);
        this.jTable_DMXDeviceDMXScene.setFillsViewportHeight(true);
        this.jTable_DMXDeviceDMXScene.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.jTable_DMXDeviceDMXScene.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.jTable_DMXDeviceDMXScene);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jButton_ZoomPlus.setText("+");
        this.jButton_ZoomPlus.setToolTipText("Save the device type");
        this.jButton_ZoomPlus.setMargin(new Insets(0, 0, 0, 0));
        this.jButton_ZoomPlus.setMaximumSize(new Dimension(16, 16));
        this.jButton_ZoomPlus.setMinimumSize(new Dimension(16, 16));
        this.jButton_ZoomPlus.setName("");
        this.jButton_ZoomPlus.setPreferredSize(new Dimension(16, 16));
        this.jButton_ZoomPlus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowDMXCrossTable_DMXDeviceDMXScene.this.jButton_ZoomPlusActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 3, 1, 5);
        this.add((Component)this.jButton_ZoomPlus, gridBagConstraints);
        this.jButton_ZoomMinus.setText("-");
        this.jButton_ZoomMinus.setToolTipText("Cancel");
        this.jButton_ZoomMinus.setMargin(new Insets(0, 0, 0, 0));
        this.jButton_ZoomMinus.setMaximumSize(new Dimension(16, 16));
        this.jButton_ZoomMinus.setMinimumSize(new Dimension(16, 16));
        this.jButton_ZoomMinus.setName("");
        this.jButton_ZoomMinus.setPreferredSize(new Dimension(16, 16));
        this.jButton_ZoomMinus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowDMXCrossTable_DMXDeviceDMXScene.this.jButton_ZoomMinusActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(1, 5, 1, 3);
        this.add((Component)this.jButton_ZoomMinus, gridBagConstraints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButton_ZoomPlusActionPerformed(ActionEvent evt) {
        if (this.m_CrossTableModel_DMXDeviceDMXScene == null) {
            return;
        }
        TableColumnModel o_TableColumnModel = this.jTable_DMXDeviceDMXScene.getColumnModel();
        if (o_TableColumnModel == null) {
            return;
        }
        ArrayList<Integer> o_ColumnsWidth_Max = this.m_CrossTableModel_DMXDeviceDMXScene.getColumnsWidth_Max();
        ArrayList<Integer> o_ColumnsWidth_Actual = this.m_CrossTableModel_DMXDeviceDMXScene.getColumnsWidth_Actual();
        o_ColumnsWidth_Actual.clear();
        Object object = this.m_SyncObject_Table;
        synchronized (object) {
            for (int intColumn = 0; intColumn < this.m_CrossTableModel_DMXDeviceDMXScene.getColumnCount(); ++intColumn) {
                DMXCrossTableCellComponent o_DMXCrossTableCellComponent = this.m_CrossTableModel_DMXDeviceDMXScene.getCellComponent(0, intColumn);
                TableColumn o_TableColumn = o_TableColumnModel.getColumn(intColumn);
                if (o_TableColumn == null) continue;
                o_ColumnsWidth_Actual.add(o_TableColumn.getPreferredWidth());
                if (o_DMXCrossTableCellComponent == null) continue;
                o_TableColumn.setPreferredWidth(o_ColumnsWidth_Max.get(intColumn));
                o_TableColumn.setWidth(o_ColumnsWidth_Max.get(intColumn));
            }
        }
        this.jTable_DMXDeviceDMXScene.revalidate();
        this.jTable_DMXDeviceDMXScene.repaint();
        this.jButton_ZoomMinus.setEnabled(true);
        this.jButton_ZoomPlus.setEnabled(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButton_ZoomMinusActionPerformed(ActionEvent evt) {
        if (this.m_CrossTableModel_DMXDeviceDMXScene == null) {
            return;
        }
        TableColumnModel o_TableColumnModel = this.jTable_DMXDeviceDMXScene.getColumnModel();
        if (o_TableColumnModel == null) {
            return;
        }
        ArrayList<Integer> o_ColumnsWidth_Actual = this.m_CrossTableModel_DMXDeviceDMXScene.getColumnsWidth_Actual();
        if (o_ColumnsWidth_Actual == null) {
            return;
        }
        Object object = this.m_SyncObject_Table;
        synchronized (object) {
            for (int intColumn = 0; intColumn < this.m_CrossTableModel_DMXDeviceDMXScene.getColumnCount() && intColumn < o_ColumnsWidth_Actual.size(); ++intColumn) {
                TableColumn o_TableColumn = o_TableColumnModel.getColumn(intColumn);
                if (o_TableColumn == null) continue;
                o_TableColumn.setPreferredWidth(o_ColumnsWidth_Actual.get(intColumn));
                o_TableColumn.setWidth(o_ColumnsWidth_Actual.get(intColumn));
            }
        }
        this.jTable_DMXDeviceDMXScene.revalidate();
        this.jTable_DMXDeviceDMXScene.repaint();
        this.jButton_ZoomMinus.setEnabled(false);
        this.jButton_ZoomPlus.setEnabled(true);
    }

    public JTable getTable() {
        return this.jTable_DMXDeviceDMXScene;
    }

    public DMXCrossTableModel_DMXDeviceDMXScene getTableModel() {
        return this.m_CrossTableModel_DMXDeviceDMXScene;
    }

    public void addDMXDevice(DMXDevice p_DMXDevice) {
        if (p_DMXDevice == null) {
            return;
        }
        this.m_CrossTableModel_DMXDeviceDMXScene.addDMXDevice(p_DMXDevice);
        EventQueueHandler.invokeLater(new Runnable(){

            @Override
            public void run() {
                LiveShowDMXCrossTable_DMXDeviceDMXScene.this.refreshTable();
            }
        });
    }

    public void addDMXDevice(int p_Column, DMXDevice p_DMXDevice) {
        if (p_DMXDevice == null) {
            return;
        }
        this.m_CrossTableModel_DMXDeviceDMXScene.addDMXDevice(p_Column, p_DMXDevice);
        EventQueueHandler.invokeLater(new Runnable(){

            @Override
            public void run() {
                LiveShowDMXCrossTable_DMXDeviceDMXScene.this.refreshTable();
            }
        });
    }

    public void removeDMXDevice(DMXDevice p_DMXDevice) {
        if (p_DMXDevice == null) {
            return;
        }
        this.m_CrossTableModel_DMXDeviceDMXScene.removeDMXDevice(p_DMXDevice);
        EventQueueHandler.invokeLater(new Runnable(){

            @Override
            public void run() {
                LiveShowDMXCrossTable_DMXDeviceDMXScene.this.refreshTable();
            }
        });
    }

    public int getColumnOfDMXDevice(DMXDevice p_DMXDevice) {
        return this.m_CrossTableModel_DMXDeviceDMXScene.getColumnOfDMXDevice(p_DMXDevice);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshTable() {
        TableColumnModel o_TableColumnModel = this.jTable_DMXDeviceDMXScene.getColumnModel();
        if (o_TableColumnModel == null) {
            return;
        }
        int intColumnSceneName = 0;
        intColumnSceneName = this.jTable_DMXDeviceDMXScene.convertColumnIndexToView(intColumnSceneName);
        JTableHeader o_JTableHeader = this.jTable_DMXDeviceDMXScene.getTableHeader();
        if (o_JTableHeader == null) {
            return;
        }
        o_JTableHeader.setDefaultRenderer(s_CrossTableHeaderRenderer_DMXDeviceDMXScene);
        Object object = this.m_SyncObject_Table;
        synchronized (object) {
            for (int intColumn = 0; intColumn < this.m_CrossTableModel_DMXDeviceDMXScene.getColumnCount(); ++intColumn) {
                TableColumn o_TableColumn;
                int intColumnView = this.jTable_DMXDeviceDMXScene.convertColumnIndexToView(intColumn);
                if (intColumnView < 0 || (o_TableColumn = o_TableColumnModel.getColumn(intColumn)) == null) continue;
                o_TableColumn.setCellRenderer(s_CrossTableCellRenderer_DMXDeviceDMXScene);
            }
            this.jTable_DMXDeviceDMXScene.setRowHeight(this.m_CrossTableModel_DMXDeviceDMXScene.getRowMinHeight());
        }
        if (this.jButton_ZoomMinus.isEnabled()) {
            this.jButton_ZoomPlusActionPerformed(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSelectionListener(SelectionListenerDMXDeviceDMXScene p_SelectionListenerDMXDeviceDMXScene) {
        if (p_SelectionListenerDMXDeviceDMXScene == null) {
            return;
        }
        Object object = this.m_SyncObject_Table;
        synchronized (object) {
            if (this.m_SelectionListenerDMXDeviceDMXScenes.contains(p_SelectionListenerDMXDeviceDMXScene)) {
                return;
            }
            this.m_SelectionListenerDMXDeviceDMXScenes.add(p_SelectionListenerDMXDeviceDMXScene);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSelectionListener(SelectionListenerDMXDeviceDMXScene p_SelectionListenerDMXDeviceDMXScene) {
        if (p_SelectionListenerDMXDeviceDMXScene == null) {
            return;
        }
        Object object = this.m_SyncObject_Table;
        synchronized (object) {
            if (!this.m_SelectionListenerDMXDeviceDMXScenes.contains(p_SelectionListenerDMXDeviceDMXScene)) {
                return;
            }
            this.m_SelectionListenerDMXDeviceDMXScenes.remove(p_SelectionListenerDMXDeviceDMXScene);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSelectionListeners() {
        Object object = this.m_SyncObject_Table;
        synchronized (object) {
            this.m_SelectionListenerDMXDeviceDMXScenes.clear();
        }
    }

    public void notifySelectionListeners_Select(DMXScene p_DMXScene, DMXDevice p_DMXDevice) {
        Object[] o_Listeners = this.m_SelectionListenerDMXDeviceDMXScenes.toArray();
        for (int intListener = 0; intListener < o_Listeners.length; ++intListener) {
            SelectionListenerDMXDeviceDMXScene o_SelectionListener = (SelectionListenerDMXDeviceDMXScene)o_Listeners[intListener];
            o_SelectionListener.valueChanged(this.jTable_DMXDeviceDMXScene, p_DMXScene, p_DMXDevice);
        }
    }

    public void notifySelectionListeners_CopyFrom(DMXScene p_DMXScene, DMXDevice p_DMXDevice) {
        Object[] o_Listeners = this.m_SelectionListenerDMXDeviceDMXScenes.toArray();
        for (int intListener = 0; intListener < o_Listeners.length; ++intListener) {
            SelectionListenerDMXDeviceDMXScene o_SelectionListener = (SelectionListenerDMXDeviceDMXScene)o_Listeners[intListener];
            o_SelectionListener.valueCopy(this.jTable_DMXDeviceDMXScene, p_DMXScene, p_DMXDevice);
        }
    }

    @Override
    public void setCopyModeOn(DMXControlComponent p_DMXControlComponent_Dest, boolean p_CopyOn) {
        this.m_CopyDestination = p_DMXControlComponent_Dest;
        if (this.m_CopyOn == p_CopyOn) {
            return;
        }
        this.m_CopyOn = p_CopyOn;
        if (this.m_CopyOn) {
            this.jTable_DMXDeviceDMXScene.setCursor(s_CopyCursor);
        } else {
            this.jTable_DMXDeviceDMXScene.setCursor(Cursor.getDefaultCursor());
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        if (this.m_CopyOn) {
            return;
        }
        this.setSelectedCell(this.jTable_DMXDeviceDMXScene.getSelectedRow(), this.jTable_DMXDeviceDMXScene.getSelectedColumn());
    }

    @Override
    public void tableChanged(TableModelEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    public static class DMXCrossTableHeaderRenderer_DMXDeviceDMXScene
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component o_Component;
            block10: {
                o_Component = super.getTableCellRendererComponent(table, value, hasFocus, hasFocus, row, column);
                if (o_Component == null) {
                    return o_Component;
                }
                Color o_Background = UIManager.getColor("TableHeader.background");
                Color o_Foreground = UIManager.getColor("TableHeader.foreground");
                o_Component.setBackground(o_Background);
                o_Component.setForeground(o_Foreground);
                DMXCrossTableModel_DMXDeviceDMXScene o_DMXCrossTableModel_DMXDeviceDMXScene = (DMXCrossTableModel_DMXDeviceDMXScene)table.getModel();
                if (o_DMXCrossTableModel_DMXDeviceDMXScene == null) {
                    return o_Component;
                }
                if (o_Component instanceof JComponent) {
                    JLabel o_JLabel = o_Component instanceof JLabel ? (JLabel)o_Component : null;
                    JComponent o_JComponent = (JComponent)o_Component;
                    try {
                        int intColumnModel = table.convertColumnIndexToModel(column);
                        if (intColumnModel == 0) {
                            o_JComponent.setToolTipText(DMXScene.DEFAULT_DMXSCENENAME);
                            if (o_JLabel != null) {
                                o_JLabel.setIcon(DMXScene.s_Icon);
                            }
                        } else {
                            DMXDevice o_DMXDevice = o_DMXCrossTableModel_DMXDeviceDMXScene.getDMXDevice(intColumnModel - 1);
                            if (o_DMXDevice != null) {
                                o_JComponent.setToolTipText(o_DMXDevice.getToolTipText());
                                if (o_JLabel != null) {
                                    o_JLabel.setIcon(DMXDevice.s_Icon);
                                    o_JLabel.setText(o_DMXDevice.getName());
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        if (o_JLabel == null) break block10;
                        o_JLabel.setText("");
                        o_JLabel.setIcon(null);
                    }
                }
            }
            return o_Component;
        }
    }

    public static class DMXCrossTableCellRenderer_DMXDeviceDMXScene
    extends JPanel
    implements TableCellRenderer,
    Serializable {
        private static final Border DEFAULT_NO_FOCUS_BORDER = new EmptyBorder(2, 2, 2, 2);
        protected Border m_NoFocusBorder = DEFAULT_NO_FOCUS_BORDER;
        private static final Border SELECTED_BORDER = new LineBorder(Color.BLUE, 2);
        private Color m_UnselectedForeground;
        private Color m_UnselectedBackground;

        public DMXCrossTableCellRenderer_DMXDeviceDMXScene() {
            this.setBorder(this.getNoFocusBorder());
            this.setName("Table.cellRenderer");
            this.setLayout(new GridBagLayout());
        }

        private Border getNoFocusBorder() {
            return this.m_NoFocusBorder;
        }

        @Override
        public void setForeground(Color c) {
            super.setForeground(c);
            this.m_UnselectedForeground = c;
        }

        @Override
        public void setBackground(Color c) {
            super.setBackground(c);
            this.m_UnselectedBackground = c;
        }

        @Override
        public void updateUI() {
            super.updateUI();
            this.setForeground(null);
            this.setBackground(null);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            DMXCrossTableModel_DMXDeviceDMXScene o_DMXCrossTableModel_DMXDeviceDMXScene;
            int intModelRow = 0;
            Color o_Background = table.getBackground();
            Color o_Foreground = table.getForeground();
            Border o_Border = this.m_NoFocusBorder;
            if (isSelected) {
                o_Border = SELECTED_BORDER;
                if (table.hasFocus()) {
                    o_Background = UIManager.getColor("Table.selectionBackground");
                    o_Foreground = UIManager.getColor("Table.selectionForeground");
                } else {
                    o_Background = UIManager.getColor("Table.selectionInactiveBackground");
                    o_Foreground = UIManager.getColor("Table.selectionInactiveForeground");
                }
            }
            this.setBackground(o_Background);
            this.setForeground(o_Foreground);
            this.setBorder(o_Border);
            int intModelColumn = table.convertColumnIndexToModel(column);
            try {
                intModelRow = table.convertRowIndexToModel(row);
                o_DMXCrossTableModel_DMXDeviceDMXScene = (DMXCrossTableModel_DMXDeviceDMXScene)table.getModel();
            }
            catch (Exception e) {
                o_DMXCrossTableModel_DMXDeviceDMXScene = null;
            }
            if (o_DMXCrossTableModel_DMXDeviceDMXScene == null) {
                return this;
            }
            DMXCrossTableCellComponent o_DMXCrossTableCellComponent = o_DMXCrossTableModel_DMXDeviceDMXScene.getCellComponent(intModelRow, intModelColumn);
            if (o_DMXCrossTableCellComponent == null) {
                return this;
            }
            if (o_DMXCrossTableCellComponent == null) {
                this.setBackground(Color.RED);
                return this;
            }
            o_DMXCrossTableCellComponent.setForeground(o_Foreground);
            o_DMXCrossTableCellComponent.setBackground(o_Background);
            o_DMXCrossTableCellComponent.setBorder(o_Border);
            return o_DMXCrossTableCellComponent;
        }
    }

    public static class DMXCrossTableCellComponent
    extends JPanel
    implements PropertyChangeListener {
        public static Dimension s_DisplayLabelDimension = new Dimension(20, 20);
        public static int s_LabelToolTipPerRow = 10;
        private JLabel m_LabelText;
        private JPanel m_JPanelDisplayLabels;
        private GridBagConstraints m_GridBagConstraints;
        private ArrayList<DMXControlDisplayLabel> m_DisplayLabels;
        private Dimension m_Dimension;
        private DMXScene m_DMXScene;
        private DMXDevice m_DMXDevice;
        private boolean m_IsDimmerOn;
        private int m_MaxWidth;
        private boolean m_Closing;
        private final Object m_SyncObject = new Object();

        public DMXCrossTableCellComponent() {
            super.setFont(new Font(this.getFont().getFamily(), 0, 12));
        }

        public DMXCrossTableCellComponent(DMXScene p_DMXScene, DMXDevice p_DMXDevice) {
            this.initMembers();
            this.initComponents();
            this.setOpaque(true);
            this.m_DMXDevice = p_DMXDevice;
            this.m_DMXScene = p_DMXScene;
            this.calculateDisplayLabels();
            if (this.m_DMXDevice != null) {
                this.m_DMXDevice.addPropertyChangeListener(this);
            }
            if (this.m_DMXScene != null) {
                this.m_DMXScene.addPropertyChangeListener(this);
            }
        }

        private void initMembers() {
            this.m_DisplayLabels = new ArrayList();
            this.m_Dimension = new Dimension(80, DMXCrossTableCellComponent.s_DisplayLabelDimension.height);
            this.m_IsDimmerOn = false;
            this.m_MaxWidth = 1;
            this.m_Closing = false;
        }

        private void initComponents() {
            this.setLayout(new GridBagLayout());
            this.m_GridBagConstraints = new GridBagConstraints();
            this.m_GridBagConstraints.gridx = 0;
            this.m_GridBagConstraints.gridy = 0;
            this.m_GridBagConstraints.weightx = 1.0;
            this.m_GridBagConstraints.fill = 2;
            this.m_LabelText = new JLabel();
            this.m_LabelText.setFont(super.getFont());
            this.add((Component)this.m_LabelText, this.m_GridBagConstraints);
            this.m_LabelText.setVisible(false);
            this.m_JPanelDisplayLabels = new JPanel();
            this.m_JPanelDisplayLabels.setLayout(new GridBagLayout());
            this.add((Component)this.m_JPanelDisplayLabels, this.m_GridBagConstraints);
            this.setVisible(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            this.m_Closing = true;
            if (this.m_DMXDevice != null) {
                this.m_DMXDevice.removePropertyChangeListener(this);
            }
            if (this.m_DMXScene != null) {
                this.m_DMXScene.removePropertyChangeListener(this);
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                for (int intLabel = this.m_DisplayLabels.size() - 1; intLabel >= 0; --intLabel) {
                    DMXControlDisplayLabel o_DMXControlDisplayLabel = this.m_DisplayLabels.get(intLabel);
                    o_DMXControlDisplayLabel.setVisible(false);
                    o_DMXControlDisplayLabel.close();
                }
            }
        }

        @Override
        public void setForeground(Color p_Color) {
            super.setForeground(p_Color);
            if (this.m_JPanelDisplayLabels != null) {
                this.m_JPanelDisplayLabels.setForeground(p_Color);
            }
            if (this.m_LabelText != null) {
                this.m_LabelText.setForeground(p_Color);
            }
        }

        @Override
        public void setBackground(Color p_Color) {
            super.setBackground(p_Color);
            if (this.m_JPanelDisplayLabels != null) {
                this.m_JPanelDisplayLabels.setBackground(p_Color);
            }
            if (this.m_LabelText != null) {
                this.m_LabelText.setBackground(p_Color);
            }
        }

        public JLabel getJLabelText() {
            return this.m_LabelText;
        }

        public JPanel getJPanelDisplayLabels() {
            return this.m_JPanelDisplayLabels;
        }

        public GridBagConstraints getGridBagConstraints() {
            return this.m_GridBagConstraints;
        }

        public ControlLabelModel.ControlLabelList findControlLabelList(ControlObject.ControlDimension p_ControlDimension) {
            if (this.m_DMXScene == null || this.m_DMXDevice == null) {
                return null;
            }
            if (p_ControlDimension == null) {
                return null;
            }
            ControlLabelModel o_ControlLabelModel = p_ControlDimension.getControlLabelModel();
            if (o_ControlLabelModel == null) {
                return null;
            }
            int intListCount = o_ControlLabelModel.getControlLabelListSize();
            switch (intListCount) {
                case 0: {
                    return null;
                }
                case 1: {
                    return o_ControlLabelModel.getControlLabelList(0);
                }
            }
            for (int intList = 0; intList < intListCount; ++intList) {
                ControlLabelModel.ControlLabelList o_ControlLabelList = o_ControlLabelModel.getControlLabelList(intList);
                if (o_ControlLabelList == null) continue;
                for (int intCondition = 0; intCondition < o_ControlLabelList.getLabelListConditionSize(); ++intCondition) {
                    DMXControlComponent o_DMXControlComponent_Remote;
                    ControlLabelModel.LabelListCondition o_LabelListCondition = o_ControlLabelList.getLabelListCondition(intCondition);
                    if (o_LabelListCondition == null || (o_DMXControlComponent_Remote = this.m_DMXDevice.getDMXControlComponentByID(o_LabelListCondition.getRemoteID())) == null) continue;
                    int intControlIndex_Remote = o_LabelListCondition.getRemoteControlIndex();
                    int intDimensionIndex_Remote = o_LabelListCondition.getRemoteDimensionIndex();
                    double doubleValueRemote = this.m_DMXScene.getValue(this.m_DMXDevice, o_DMXControlComponent_Remote.getDMXControlType(), intControlIndex_Remote, intDimensionIndex_Remote);
                    if (!(doubleValueRemote >= o_LabelListCondition.getRemoteValueStart()) || !(doubleValueRemote <= o_LabelListCondition.getRemoteValueEnd())) continue;
                    return o_ControlLabelList;
                }
            }
            return null;
        }

        private void addDisplayLabels(int p_Count) {
            for (int intLabel = 0; intLabel < p_Count; ++intLabel) {
                this.addDisplayLabel();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addDisplayLabel() {
            DMXControlDisplayLabel o_DMXControlDisplayLabel = new DMXControlDisplayLabel();
            o_DMXControlDisplayLabel.setMaximumSize(s_DisplayLabelDimension);
            o_DMXControlDisplayLabel.setMinimumSize(s_DisplayLabelDimension);
            o_DMXControlDisplayLabel.setPreferredSize(s_DisplayLabelDimension);
            Font o_Font = o_DMXControlDisplayLabel.getFont();
            Font o_FontNew = o_Font.deriveFont(10.1f);
            o_DMXControlDisplayLabel.setFont(o_FontNew);
            Object object = this.m_SyncObject;
            synchronized (object) {
                this.m_DisplayLabels.add(o_DMXControlDisplayLabel);
                GridBagConstraints o_GridBagConstraints = new GridBagConstraints();
                o_GridBagConstraints.gridx = this.m_DisplayLabels.size();
                o_GridBagConstraints.gridy = 0;
                o_GridBagConstraints.weightx = 0.0;
                o_GridBagConstraints.fill = 0;
                this.m_JPanelDisplayLabels.add((Component)o_DMXControlDisplayLabel, o_GridBagConstraints);
                o_DMXControlDisplayLabel.setVisible(true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeDisplayLabel(DMXControlDisplayLabel p_DMXControlDisplayLabel) {
            if (p_DMXControlDisplayLabel == null) {
                return;
            }
            p_DMXControlDisplayLabel.setVisible(false);
            p_DMXControlDisplayLabel.close();
            Object object = this.m_SyncObject;
            synchronized (object) {
                this.m_JPanelDisplayLabels.remove(p_DMXControlDisplayLabel);
                this.m_DisplayLabels.remove(p_DMXControlDisplayLabel);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void calculateDisplayLabels() {
            if (this.m_Closing) {
                return;
            }
            this.m_IsDimmerOn = false;
            this.m_MaxWidth = 1;
            int intMinHeight = DMXCrossTableCellComponent.s_DisplayLabelDimension.height + 4;
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (this.m_DMXScene != null && this.m_DMXDevice != null) {
                    DMXControlDisplayLabel o_DMXControlDisplayLabel;
                    int intLabel;
                    if (this.m_DisplayLabels.size() < this.m_DMXDevice.getDMXControlComponentCount()) {
                        this.addDisplayLabels(this.m_DMXDevice.getDMXControlComponentCount() - this.m_DisplayLabels.size());
                    }
                    if (this.m_DisplayLabels.size() > this.m_DMXDevice.getDMXControlComponentCount()) {
                        for (intLabel = this.m_DisplayLabels.size() - 1; intLabel >= this.m_DMXDevice.getDMXControlComponentCount(); --intLabel) {
                            o_DMXControlDisplayLabel = this.m_DisplayLabels.get(intLabel);
                            this.removeDisplayLabel(o_DMXControlDisplayLabel);
                        }
                    }
                    StringBuilder stringBuffer = new StringBuilder();
                    stringBuffer.append("<html>");
                    stringBuffer.append(DMXScene.DEFAULT_DMXSCENENAME);
                    stringBuffer.append(": ");
                    stringBuffer.append(this.m_DMXScene.getName());
                    stringBuffer.append("<br>");
                    stringBuffer.append(DMXDevice.DEFAULT_DMXDEVICENAME);
                    stringBuffer.append(": ");
                    stringBuffer.append(this.m_DMXDevice.getName());
                    stringBuffer.append("<br>");
                    stringBuffer.append("<table>");
                    stringBuffer.append("<tr>");
                    this.m_LabelText.setIcon(null);
                    this.m_LabelText.setHorizontalAlignment(0);
                    this.m_LabelText.setText("");
                    this.m_IsDimmerOn = this.m_DMXScene.isDimmerOn(this.m_DMXDevice);
                    int intDMXControlComponentCount = this.m_DMXDevice.getDMXControlComponentCount();
                    int intMinWidth = DMXCrossTableCellComponent.s_DisplayLabelDimension.width * intDMXControlComponentCount + 10;
                    if (intMinWidth < 80) {
                        intMinWidth = 80;
                    }
                    if (this.m_IsDimmerOn) {
                        this.m_Dimension.setSize(intMinWidth, intMinHeight);
                    }
                    if (intMinWidth > this.m_MaxWidth) {
                        this.m_MaxWidth = intMinWidth;
                    }
                    if (!this.m_IsDimmerOn) {
                        this.m_LabelText.setVisible(true);
                        this.m_JPanelDisplayLabels.setVisible(false);
                    } else {
                        this.m_LabelText.setVisible(false);
                        this.m_JPanelDisplayLabels.setVisible(true);
                        this.setMinimumSize(this.m_Dimension);
                        this.setPreferredSize(this.m_Dimension);
                    }
                    intLabel = 0;
                    int intLabelStart = 0;
                    int intLabelToolTipMax = s_LabelToolTipPerRow;
                    while (intLabel < intDMXControlComponentCount) {
                        while (intLabel < intLabelToolTipMax && intLabel < intDMXControlComponentCount) {
                            o_DMXControlDisplayLabel = this.m_DisplayLabels.get(intLabel);
                            if (o_DMXControlDisplayLabel == null) {
                                ++intLabel;
                                continue;
                            }
                            DMXControlComponent o_DMXControlComponent = this.m_DMXDevice.getDMXControlComponent(intLabel);
                            if (o_DMXControlComponent == null) {
                                ++intLabel;
                                continue;
                            }
                            o_DMXControlDisplayLabel.setDMXControlComponent(o_DMXControlComponent);
                            o_DMXControlComponent.refreshBorder(o_DMXControlDisplayLabel);
                            o_DMXControlComponent.refreshDisplay_Foreign(o_DMXControlDisplayLabel, this.m_DMXDevice, this.m_DMXScene);
                            stringBuffer.append("<td><b>");
                            stringBuffer.append(o_DMXControlComponent.getName());
                            stringBuffer.append("</b></td>");
                            o_DMXControlDisplayLabel.setVisible(true);
                            ++intLabel;
                        }
                        intLabelToolTipMax += s_LabelToolTipPerRow;
                        stringBuffer.append("</tr>");
                        int intMaxValues = 1;
                        for (int intActualValue = 0; intActualValue < intMaxValues; ++intActualValue) {
                            stringBuffer.append("<tr>");
                            for (int intLabel_Value = intLabelStart; intLabel_Value < intLabel && intLabel_Value < intDMXControlComponentCount; ++intLabel_Value) {
                                o_DMXControlDisplayLabel = this.m_DisplayLabels.get(intLabel_Value);
                                if (o_DMXControlDisplayLabel == null) continue;
                                if (o_DMXControlDisplayLabel.getValuesCount() > intMaxValues) {
                                    intMaxValues = o_DMXControlDisplayLabel.getValuesCount();
                                }
                                stringBuffer.append("<td>");
                                if (intActualValue < o_DMXControlDisplayLabel.getValuesCount()) {
                                    stringBuffer.append(o_DMXControlDisplayLabel.getControlName(intActualValue));
                                    stringBuffer.append(": ");
                                    stringBuffer.append(o_DMXControlDisplayLabel.getValueString(intActualValue));
                                }
                                stringBuffer.append("</td>");
                            }
                            stringBuffer.append("</tr>");
                        }
                        intLabelStart = intLabel;
                        if (intLabel >= intDMXControlComponentCount) continue;
                        stringBuffer.append("<tr>");
                        stringBuffer.append("</tr>");
                        stringBuffer.append("<tr>");
                    }
                    stringBuffer.append("</table>");
                    stringBuffer.append("</html>");
                    this.setToolTipText(stringBuffer.toString());
                } else {
                    for (int intLabel = this.m_DisplayLabels.size() - 1; intLabel >= 0; --intLabel) {
                        DMXControlDisplayLabel o_DMXControlDisplayLabel = this.m_DisplayLabels.get(intLabel);
                        this.removeDisplayLabel(o_DMXControlDisplayLabel);
                    }
                    this.m_JPanelDisplayLabels.setVisible(false);
                    if (this.m_DMXScene != null) {
                        this.m_LabelText.setIcon(DMXScene.s_Icon);
                        this.m_LabelText.setHorizontalAlignment(10);
                        this.m_LabelText.setText(this.m_DMXScene.getName());
                        this.m_LabelText.setVisible(true);
                        int intMinWidth = this.m_LabelText.getFontMetrics(this.m_LabelText.getFont()).stringWidth(this.m_LabelText.getText());
                        if ((intMinWidth += 30) < 80) {
                            intMinWidth = 80;
                        }
                        this.m_Dimension.setSize(intMinWidth, intMinHeight);
                        if (intMinWidth > this.m_MaxWidth) {
                            this.m_MaxWidth = intMinWidth;
                        }
                        this.setMinimumSize(this.m_Dimension);
                        this.setPreferredSize(this.m_Dimension);
                        this.setToolTipText(this.m_DMXScene.getToolTipText());
                    } else {
                        this.m_JPanelDisplayLabels.setVisible(false);
                        this.m_LabelText.setVisible(true);
                        this.setToolTipText(null);
                    }
                }
            }
        }

        public boolean getIsDimmerOn() {
            return this.m_IsDimmerOn;
        }

        public Dimension getDimension() {
            return this.m_Dimension;
        }

        public int getMaxWidth() {
            return this.m_MaxWidth;
        }

        public int getMinHeight() {
            return this.m_Dimension.height;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() instanceof DMXScene) {
                DMXScene o_DMXScene = (DMXScene)evt.getSource();
                if ("liveShowObject_SourceClose".equals(evt.getPropertyName())) {
                    return;
                }
                this.calculateDisplayLabels();
            }
            if (evt.getSource() instanceof DMXDevice) {
                DMXDevice o_DMXDevice = (DMXDevice)evt.getSource();
                if ("dmxdeviceDMXDeviceType".equals(evt.getPropertyName()) && o_DMXDevice.getDMXDeviceType() == null) {
                    return;
                }
                this.calculateDisplayLabels();
            }
        }
    }

    public static class DMXCrossTableModel_DMXDeviceDMXScene
    extends TableAndListModel<DMXScene>
    implements PropertyChangeListener {
        public static final int COLUMNINDEX_SCENENAME = 0;
        @LiveLanguageString
        public static String COLUMN_SCENENAME = "SceneName";
        private LiveShowDMXVIP m_LiveShowDMXVIP;
        private ArrayList<DMXDevice> m_DMXDevices;
        private ArrayList<ArrayList<DMXCrossTableCellComponent>> m_TableCellComponents;
        private TableRowSorter m_TableRowSorter;
        private int m_ColumnCount = 1;
        private ArrayList<Integer> m_ColumnsWidth_Actual;
        private ArrayList<Integer> m_ColumnsWidth_Max;
        private int m_RowMinHeight;
        private DefaultTableColumnModel m_TableColumnModel;
        private final Object m_SyncObject = new Object();

        public DMXCrossTableModel_DMXDeviceDMXScene() {
            super(false);
            this.initMembers();
            LiveLanguage.addLanguageListener((Object)this, null);
            for (int intDMXScene = 0; intDMXScene < DMXScene.getDMXSceneCount(); ++intDMXScene) {
                DMXScene o_DMXScene = DMXScene.getDMXScene(intDMXScene);
                this.addDMXScene(o_DMXScene);
            }
        }

        private void initMembers() {
            this.m_LiveShowDMXVIP = null;
            this.m_DMXDevices = new ArrayList();
            this.m_TableCellComponents = new ArrayList();
            this.m_TableRowSorter = new TableRowSorter<DMXCrossTableModel_DMXDeviceDMXScene>(this);
            this.m_ColumnsWidth_Actual = new ArrayList();
            this.m_ColumnsWidth_Max = new ArrayList();
            this.m_ColumnsWidth_Max.add(1);
            this.m_RowMinHeight = 26;
            this.m_TableColumnModel = null;
        }

        public void finishJTable(JTable p_JTable) {
            if (p_JTable == null) {
                return;
            }
            this.m_TableRowSorter.setComparator(0, TableAndListModel.getStringComparator_Normal());
            super.finishJTable(p_JTable, this.m_TableRowSorter, null);
            if (p_JTable.getColumnModel() instanceof DefaultTableColumnModel) {
                this.m_TableColumnModel = (DefaultTableColumnModel)p_JTable.getColumnModel();
            }
            if (this.m_TableColumnModel == null) {
                return;
            }
            TableColumn o_TableColumn = this.m_TableColumnModel.getColumn(0);
            if (o_TableColumn == null) {
                return;
            }
            o_TableColumn.setCellRenderer(s_CrossTableCellRenderer_DMXDeviceDMXScene);
        }

        public void close() {
            this.setLiveShowDMXVIP(null);
            LiveLanguage.removeLanguageListener((Object)this);
        }

        public void setLiveShowDMXVIP(LiveShowDMXVIP p_LiveShowDMXVIP) {
            if (this.m_LiveShowDMXVIP == p_LiveShowDMXVIP) {
                return;
            }
            if (this.m_LiveShowDMXVIP != null) {
                this.clearDMXScenes();
                this.clearDMXDevices();
            }
            this.m_LiveShowDMXVIP = p_LiveShowDMXVIP;
            if (this.m_LiveShowDMXVIP != null) {
                for (int intDMXScene = 0; intDMXScene < DMXScene.getDMXSceneCount(); ++intDMXScene) {
                    DMXScene o_DMXScene = DMXScene.getDMXScene(intDMXScene);
                    this.addDMXScene(o_DMXScene);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addDMXScene(DMXScene p_DMXScene) {
            if (this.m_LiveShowDMXVIP == null) {
                return;
            }
            if (p_DMXScene == null) {
                return;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (this.contains(p_DMXScene)) {
                    return;
                }
                ArrayList<DMXCrossTableCellComponent> o_DMXCrossTableCellComponents = new ArrayList<DMXCrossTableCellComponent>();
                DMXCrossTableCellComponent o_DMXCrossTableCellComponent = new DMXCrossTableCellComponent(p_DMXScene, null);
                o_DMXCrossTableCellComponents.add(o_DMXCrossTableCellComponent);
                if (o_DMXCrossTableCellComponent.getMaxWidth() > this.m_ColumnsWidth_Max.get(0)) {
                    this.m_ColumnsWidth_Max.set(0, o_DMXCrossTableCellComponent.getMaxWidth());
                }
                for (int intDevice = 0; intDevice < this.m_DMXDevices.size(); ++intDevice) {
                    o_DMXCrossTableCellComponent = new DMXCrossTableCellComponent(p_DMXScene, this.m_DMXDevices.get(intDevice));
                    o_DMXCrossTableCellComponents.add(o_DMXCrossTableCellComponent);
                    if (o_DMXCrossTableCellComponent.getMaxWidth() <= this.m_ColumnsWidth_Max.get(intDevice + 1)) continue;
                    this.m_ColumnsWidth_Max.set(intDevice + 1, o_DMXCrossTableCellComponent.getMaxWidth());
                }
                this.m_TableCellComponents.add(o_DMXCrossTableCellComponents);
                this.add(p_DMXScene);
                p_DMXScene.addPropertyChangeListener(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeDMXScene(DMXScene p_DMXScene) {
            if (p_DMXScene == null) {
                return;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                int intRow = this.indexOf(p_DMXScene);
                if (!this.remove(p_DMXScene)) {
                    return;
                }
                p_DMXScene.removePropertyChangeListener(this);
                ArrayList<DMXCrossTableCellComponent> o_DMXCrossTableCellComponents = this.m_TableCellComponents.get(intRow);
                this.m_TableCellComponents.remove(intRow);
                for (int intCell = o_DMXCrossTableCellComponents.size() - 1; intCell >= 0; --intCell) {
                    DMXCrossTableCellComponent o_DMXCrossTableCellComponent = o_DMXCrossTableCellComponents.get(intCell);
                    o_DMXCrossTableCellComponent.close();
                }
                o_DMXCrossTableCellComponents.clear();
                this.checkMaxColumnWidth_Scene();
            }
        }

        public void clearDMXScenes() {
            for (int intDMXScene = this.size() - 1; intDMXScene >= 0; --intDMXScene) {
                DMXScene o_DMXScene = (DMXScene)this.get(intDMXScene);
                if (o_DMXScene == null) continue;
                this.removeDMXScene(o_DMXScene);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addSelectedDMXScene(JTable p_JTable, DMXScene p_DMXScene) {
            if (p_JTable == null) {
                return;
            }
            if (p_DMXScene == null) {
                return;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                this.addSelectedElement(p_JTable, p_DMXScene);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeSelectedDMXScene(JTable p_JTable, DMXScene p_DMXScene) {
            if (p_JTable == null) {
                return;
            }
            if (p_DMXScene == null) {
                return;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                this.removeSelectedElement(p_JTable, p_DMXScene);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DMXScene getDMXScene(int p_Index) {
            if (p_Index < 0) {
                return null;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                return (DMXScene)this.get(p_Index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkMaxColumnWidth_Scene() {
            this.m_ColumnsWidth_Max.set(0, 0);
            Object object = this.m_SyncObject;
            synchronized (object) {
                for (int intRow = 0; intRow < this.size(); ++intRow) {
                    int intMaxWidth;
                    DMXCrossTableCellComponent o_DMXCrossTableCellComponent;
                    ArrayList<DMXCrossTableCellComponent> o_DMXCrossTableCellComponents = this.m_TableCellComponents.get(intRow);
                    if (o_DMXCrossTableCellComponents == null || o_DMXCrossTableCellComponents.size() <= 0 || (o_DMXCrossTableCellComponent = o_DMXCrossTableCellComponents.get(0)) == null || (intMaxWidth = o_DMXCrossTableCellComponent.getMaxWidth()) <= this.m_ColumnsWidth_Max.get(0)) continue;
                    this.m_ColumnsWidth_Max.set(0, intMaxWidth);
                }
            }
        }

        public void addDMXDevice(DMXDevice p_DMXDevice) {
            this.addDMXDevice(this.m_DMXDevices.size(), p_DMXDevice);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addDMXDevice(int p_Column, DMXDevice p_DMXDevice) {
            if (p_DMXDevice == null) {
                return;
            }
            if (p_Column < 0) {
                p_Column = this.m_DMXDevices.size();
            }
            if (p_Column > this.m_DMXDevices.size()) {
                p_Column = this.m_DMXDevices.size();
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (this.m_DMXDevices.contains(p_DMXDevice)) {
                    return;
                }
                this.m_DMXDevices.add(p_Column, p_DMXDevice);
                int intColumn = this.getColumnOfDMXDevice(p_DMXDevice);
                int intMaxWidth = 1;
                int intMinHeight = 20;
                for (int intScene = 0; intScene < this.size(); ++intScene) {
                    DMXScene o_DMXScene = (DMXScene)this.get(intScene);
                    if (o_DMXScene == null) continue;
                    ArrayList<DMXCrossTableCellComponent> o_DMXCrossTableCellComponents = this.m_TableCellComponents.get(intScene);
                    DMXCrossTableCellComponent o_DMXCrossTableCellComponent = new DMXCrossTableCellComponent(o_DMXScene, p_DMXDevice);
                    o_DMXCrossTableCellComponents.add(intColumn, o_DMXCrossTableCellComponent);
                    if (o_DMXCrossTableCellComponent.getMaxWidth() > intMaxWidth) {
                        intMaxWidth = o_DMXCrossTableCellComponent.getMaxWidth();
                    }
                    if (o_DMXCrossTableCellComponent.getMinHeight() <= intMinHeight) continue;
                    intMinHeight = o_DMXCrossTableCellComponent.getMinHeight();
                }
                this.m_ColumnsWidth_Max.add(intColumn, intMaxWidth);
                if (intMinHeight > this.m_RowMinHeight) {
                    this.m_RowMinHeight = intMinHeight;
                }
                p_DMXDevice.addPropertyChangeListener(this);
            }
            this.refreshTableStructure();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeDMXDevice(DMXDevice p_DMXDevice) {
            if (p_DMXDevice == null) {
                return;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (!this.m_DMXDevices.contains(p_DMXDevice)) {
                    return;
                }
                int intColumn = this.getColumnOfDMXDevice(p_DMXDevice);
                this.m_DMXDevices.remove(p_DMXDevice);
                p_DMXDevice.removePropertyChangeListener(this);
                for (int intScene = 0; intScene < this.size(); ++intScene) {
                    DMXCrossTableCellComponent o_DMXCrossTableCellComponent;
                    ArrayList<DMXCrossTableCellComponent> o_DMXCrossTableCellComponents;
                    DMXScene o_DMXScene = (DMXScene)this.get(intScene);
                    if (o_DMXScene == null || (o_DMXCrossTableCellComponents = this.m_TableCellComponents.get(intScene)) == null || (o_DMXCrossTableCellComponent = o_DMXCrossTableCellComponents.get(intColumn)) == null) continue;
                    o_DMXCrossTableCellComponents.remove(o_DMXCrossTableCellComponent);
                    o_DMXCrossTableCellComponent.close();
                }
                if (intColumn >= 0 && intColumn < this.m_ColumnsWidth_Max.size()) {
                    this.m_ColumnsWidth_Max.remove(intColumn);
                }
            }
            this.refreshTableStructure();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getColumnOfDMXDevice(DMXDevice p_DMXDevice) {
            if (p_DMXDevice == null) {
                return -1;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (!this.m_DMXDevices.contains(p_DMXDevice)) {
                    return -1;
                }
                return this.m_DMXDevices.indexOf(p_DMXDevice) + 1;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clearDMXDevices() {
            Object object = this.m_SyncObject;
            synchronized (object) {
                for (int intDMXDevice = this.m_DMXDevices.size() - 1; intDMXDevice >= 0; --intDMXDevice) {
                    DMXDevice o_DMXDevice = this.m_DMXDevices.get(intDMXDevice);
                    if (o_DMXDevice == null) continue;
                    o_DMXDevice.removePropertyChangeListener(this);
                }
                this.m_DMXDevices.clear();
            }
            this.refreshTableStructure();
        }

        public void setDMXDevices(ArrayList<DMXDevice> p_DMXDevices) {
            if (p_DMXDevices == null) {
                return;
            }
            this.clearDMXDevices();
            for (int intDMXDevice = 0; intDMXDevice < p_DMXDevices.size(); ++intDMXDevice) {
                DMXDevice o_DMXDevice = p_DMXDevices.get(intDMXDevice);
                this.addDMXDevice(o_DMXDevice);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DMXDevice getDMXDevice(int p_Index) {
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (p_Index < 0 || p_Index >= this.m_DMXDevices.size()) {
                    return null;
                }
                return this.m_DMXDevices.get(p_Index);
            }
        }

        public DMXCrossTableCellComponent getCellComponent(int p_IndexDMXScene, int p_IndexDMXDevice) {
            if (p_IndexDMXScene < 0) {
                return null;
            }
            if (p_IndexDMXDevice < 0) {
                return null;
            }
            if (p_IndexDMXScene >= this.m_TableCellComponents.size()) {
                return null;
            }
            ArrayList<DMXCrossTableCellComponent> o_DMXCrossTableCellComponents = this.m_TableCellComponents.get(p_IndexDMXScene);
            if (o_DMXCrossTableCellComponents == null) {
                return null;
            }
            if (p_IndexDMXDevice >= o_DMXCrossTableCellComponents.size()) {
                return null;
            }
            DMXCrossTableCellComponent o_DMXCrossTableCellComponent = o_DMXCrossTableCellComponents.get(p_IndexDMXDevice);
            return o_DMXCrossTableCellComponent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void refreshTableStructure() {
            Object object = this.m_SyncObject;
            synchronized (object) {
                this.m_ColumnCount = this.m_DMXDevices.size() + 1;
                this.fireTableStructureChanged();
                this.m_TableRowSorter.setModel(this);
                this.m_TableRowSorter.setComparator(0, TableAndListModel.getStringComparator_Normal());
                for (int intDMXDevice = 0; intDMXDevice < this.m_DMXDevices.size(); ++intDMXDevice) {
                    DMXDevice o_DMXDevice = this.m_DMXDevices.get(intDMXDevice);
                    if (o_DMXDevice == null) continue;
                    int intColumn = this.getColumnOfDMXDevice(o_DMXDevice);
                    this.m_TableRowSorter.setComparator(intColumn, TableAndListModel.getStringComparator_Normal());
                    DMXCrossTableCellComponent o_DMXCrossTableCellComponent = this.getCellComponent(0, intColumn);
                    if (o_DMXCrossTableCellComponent == null) continue;
                    this.m_ColumnsWidth_Max.set(intColumn, o_DMXCrossTableCellComponent.getMaxWidth());
                }
            }
        }

        @Override
        public int getColumnCount() {
            return this.m_ColumnCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return COLUMN_SCENENAME;
                }
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (col < 0 || col > this.m_DMXDevices.size()) {
                    return "";
                }
                return this.m_DMXDevices.get(col - 1).getName();
            }
        }

        public ArrayList<Integer> getColumnsWidth_Actual() {
            return this.m_ColumnsWidth_Actual;
        }

        public ArrayList<Integer> getColumnsWidth_Max() {
            return this.m_ColumnsWidth_Max;
        }

        public int getRowMinHeight() {
            return this.m_RowMinHeight;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getValue(DMXScene p_DMXScene, int p_ColumnIndex) {
            String stringValue = "";
            if (p_DMXScene == null) {
                return stringValue;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                switch (p_ColumnIndex) {
                    case 0: {
                        stringValue = p_DMXScene.getName();
                        break;
                    }
                    default: {
                        if (p_ColumnIndex < 1 || p_ColumnIndex > this.m_DMXDevices.size()) {
                            return "";
                        }
                        DMXDevice o_DMXDevice = this.m_DMXDevices.get(p_ColumnIndex - 1);
                        stringValue = p_DMXScene.isDimmerOn(o_DMXDevice) ? DMXDevice.DMXDeviceTableModel.COLUMN_DEVICEON : "-";
                    }
                }
            }
            return stringValue;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            switch (col) {
                case 0: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public void setValue(DMXScene p_DMXScene, Object value, int col) {
            if (p_DMXScene == null) {
                return;
            }
            boolean boolChanged = false;
            switch (col) {
                case 0: {
                    String stringValue = (String)value;
                    p_DMXScene.setName(stringValue);
                    boolChanged = true;
                    break;
                }
                default: {
                    boolChanged = false;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() instanceof DMXScene) {
                DMXScene o_DMXScene = (DMXScene)evt.getSource();
                Object object = this.m_SyncObject;
                synchronized (object) {
                    this.checkMaxColumnWidth_Scene();
                    if ("dmxsceneName".equals(evt.getPropertyName())) {
                        this.changedElement(o_DMXScene);
                    } else if ("dmxsceneRemark".equals(evt.getPropertyName())) {
                        this.changedElement(o_DMXScene);
                    } else if ("liveShowObject_SourceClose".equals(evt.getPropertyName())) {
                        this.removeDMXScene(o_DMXScene);
                    } else if ("dmxsceneChanged".equals(evt.getPropertyName())) {
                        this.changedElement(o_DMXScene);
                    }
                }
            } else if (evt.getSource() instanceof DMXDevice) {
                // empty if block
            }
        }
    }

    public static interface SelectionListenerDMXDeviceDMXScene {
        public void valueChanged(JTable var1, DMXScene var2, DMXDevice var3);

        public void valueCopy(JTable var1, DMXScene var2, DMXDevice var3);
    }
}

