/*
 * Decompiled with CFR 0.152.
 */
package DMXGraphics;

import DMXDevicePackage.DMXDevice;
import DMXGraphics.LiveShowDMXCrossTable_DMXDeviceDMXObject;
import DMXMixer.DMXControlComponent;
import DMXMixer.DMXControlDescription;
import DMXMixer.DMXControlDisplayLabel;
import DMXMixer.DMXControl_GridPanTilt;
import DMXScenePackage.DMXScene;
import DMXScenePackage.DMXSceneCopyInterface;
import DMXVirtualPackage.DMXFadeDescription;
import DMXVirtualPackage.DMXFadeDescriptionPanel;
import DMXVirtualPackage.LiveShowDMXObject;
import DMXVirtualPackage.LiveShowDMXObjectCopyInterface;
import DMXVirtualPackage.LiveShowDMXVIP;
import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LanguageTools.LiveLanguagePackage.LiveLanguageString;
import LiveShowControlModels.ControlLabelModel;
import LiveShowControlModels.JTextFieldBytePanel;
import LiveShowControlObjects.ControlObject;
import LiveShowControlObjects.ValueSelectionInterface;
import LiveShowObjectPackage.LiveShowObject;
import LiveShowObjectPackage.LiveShowObjectDescription;
import LiveShowObjectPackage.LiveShowObjectInterface;
import LiveShowObjectPackage.LiveShowObjectListener;
import LiveShowObjectPackage.LiveShowUndo;
import LiveShowVirtualPackage.LiveShowVIP;
import StartPackage.LiveShowDMXSystem;
import SwingToolTipPackage.PopUpToolTip;
import ToolsGraphics.JLabelBackground;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;

public class DMXTrackingObjectEditPanel
extends JPanel
implements LiveShowDMXObjectCopyInterface,
DMXSceneCopyInterface,
PropertyChangeListener,
LiveShowObjectListener {
    public static final Icon s_IconCopyOk = new ImageIcon(DMXTrackingObjectEditPanel.class.getResource("/IconsPackage/Edit_OK.png"));
    public static final Icon s_IconCopyUncertain = new ImageIcon(DMXTrackingObjectEditPanel.class.getResource("/IconsPackage/Question.png"));
    public static ImageIcon s_IconCheckBox_Unselected = new ImageIcon(DMXTrackingObjectEditPanel.class.getResource("/IconsPackage/CheckBox_Black_Unselected.png"));
    public static ImageIcon s_IconCheckBox_Selected = new ImageIcon(DMXTrackingObjectEditPanel.class.getResource("/IconsPackage/CheckBox_Black_Selected.png"));
    @LiveLanguageString
    private static String s_CopyButtonToolTip = "Copy values from another scene/device";
    private static final Border s_CopyBorder = new LineBorder(Color.BLUE, 2);
    public static boolean s_LastShowDetails = false;
    public static boolean s_LastCopyObjectSettings = true;
    public static boolean s_LastCopySceneValues = true;
    private LiveShowObject m_LiveShowObject;
    private DMXScene m_DMXScene;
    private DMXDevice m_DMXDevice;
    private DMXFadeDescription m_DMXFadeDescription;
    private DMXFadeDescription.DMXDeviceFadeDescription m_DMXDeviceFadeDescription;
    private ArrayList<ValuesPanel> m_ValuesPanels;
    private ArrayList<SelectionSourceInterface> m_SelectionSourceInterfaces;
    private boolean m_CopyModeOn;
    private boolean m_ShowDetails;
    private DMXControlComponent m_CopyDestination;
    private final Object m_SyncObject = new Object();
    private JButton jButton_Cancel;
    private JButton jButton_Copy;
    private JButton jButton_Save;
    private JButton jButton_ShowInTimeline;
    private JButton jButton_ShowObjectDetails;
    private JButton jButton_ShowObjectSettings;
    private JCheckBox jCheckBox_CopyObjectSettings;
    private JCheckBox jCheckBox_CopySceneValues;
    private JLabelBackground jLabel_DMXDeviceIcon;
    private JLabel jLabel_DMXDeviceName;
    private JLabel jLabel_DMXScene;
    private JLabel jLabel_Object;
    private JPanel jPanel_SceneDeviceValues;
    private JScrollPane jScrollPane1;

    public DMXTrackingObjectEditPanel() {
        this.initMembers();
        this.initComponents();
        LiveLanguage.addLanguageListener((Object)this, null);
        this.initComponentsFurther();
    }

    private void initMembers() {
        this.m_DMXScene = null;
        this.m_DMXDevice = null;
        this.m_ValuesPanels = new ArrayList();
        this.m_SelectionSourceInterfaces = new ArrayList();
        this.m_CopyModeOn = false;
        this.m_DMXFadeDescription = new DMXFadeDescription(true);
    }

    private void initComponentsFurther() {
        this.jScrollPane1.getViewport().setBackground(Color.BLACK);
        this.jLabel_DMXDeviceIcon.setText("");
        this.jLabel_DMXDeviceIcon.setBackgroundStyle(3);
        this.jButton_Save.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_Cancel.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_Copy.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_ShowObjectSettings.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_ShowObjectDetails.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jCheckBox_CopySceneValues.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jCheckBox_CopyObjectSettings.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jCheckBox_CopySceneValues.setSelected(s_LastCopySceneValues);
        this.jCheckBox_CopyObjectSettings.setSelected(s_LastCopyObjectSettings);
        this.m_ShowDetails = s_LastShowDetails;
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        LiveLanguage.removeLanguageListener((Object)this);
        Object object = this.m_SyncObject;
        synchronized (object) {
            if (this.m_LiveShowObject != null) {
                this.m_LiveShowObject.removeLiveShowObjectListener(this);
            }
            if (this.m_DMXScene != null) {
                this.m_DMXScene.removePropertyChangeListener(this);
            }
            if (this.m_DMXDevice != null) {
                this.m_DMXDevice.removePropertyChangeListener(this);
            }
            this.jButton_Save.setComponentPopupMenu(null);
            this.jButton_Cancel.setComponentPopupMenu(null);
            this.jButton_Copy.setComponentPopupMenu(null);
            this.jButton_ShowObjectSettings.setComponentPopupMenu(null);
            this.jButton_ShowObjectDetails.setComponentPopupMenu(null);
            this.jCheckBox_CopySceneValues.setComponentPopupMenu(null);
            this.jCheckBox_CopyObjectSettings.setComponentPopupMenu(null);
            this.m_SelectionSourceInterfaces.clear();
            for (int intPanel = 0; intPanel < this.m_ValuesPanels.size(); ++intPanel) {
                ValuesPanel o_ValuesPanel = this.m_ValuesPanels.get(intPanel);
                o_ValuesPanel.close();
            }
        }
        LiveLanguage.removeLanguageListener((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        LiveShowObject o_LiveShowObject = this.m_LiveShowObject;
        DMXScene o_DMXScene = this.m_DMXScene;
        DMXDevice o_DMXDevice = this.m_DMXDevice;
        if (o_LiveShowObject != null) {
            this.jLabel_Object.setText(o_LiveShowObject.getName());
            this.jButton_ShowObjectSettings.setEnabled(true);
            this.jButton_ShowInTimeline.setEnabled(true);
        } else {
            this.jButton_ShowObjectSettings.setEnabled(false);
            this.jButton_ShowInTimeline.setEnabled(false);
        }
        if (this.m_ShowDetails) {
            this.jButton_ShowObjectDetails.setBorder(s_CopyBorder);
        } else {
            this.jButton_ShowObjectDetails.setBorder(null);
        }
        if (o_DMXDevice != null) {
            this.jLabel_DMXDeviceIcon.setBackgroundImage(o_DMXDevice.getDeviceImage());
            this.jLabel_DMXDeviceIcon.setBackgroundOpaque(true);
            this.jLabel_DMXDeviceName.setText(o_DMXDevice.getName());
            this.jLabel_DMXDeviceIcon.setVisible(true);
            this.jLabel_DMXDeviceName.setVisible(true);
        } else {
            this.jLabel_DMXDeviceIcon.setBackgroundImage(null);
            this.jLabel_DMXDeviceIcon.setBackgroundOpaque(false);
            this.jLabel_DMXDeviceName.setText("");
        }
        if (o_DMXScene != null) {
            this.jLabel_DMXScene.setIcon(DMXScene.s_Icon);
            this.jLabel_DMXScene.setText(o_DMXScene.getName());
            this.jLabel_DMXScene.setVisible(true);
        } else {
            this.jLabel_DMXScene.setIcon(null);
            this.jLabel_DMXScene.setText("");
        }
        if (o_DMXScene == null || o_DMXDevice == null) {
            this.clearAllValuesPanels();
            this.jButton_Save.setEnabled(false);
            this.jButton_Cancel.setEnabled(false);
            this.jButton_Copy.setEnabled(false);
            this.jCheckBox_CopySceneValues.setEnabled(false);
            this.jCheckBox_CopyObjectSettings.setEnabled(false);
            return;
        }
        if (o_DMXScene != null && o_DMXDevice != null) {
            this.jButton_Copy.setEnabled(true);
            this.jCheckBox_CopySceneValues.setEnabled(true);
            this.jCheckBox_CopyObjectSettings.setEnabled(true);
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            ValuesPanel o_ValuesPanel;
            for (int intDMXControl = 0; intDMXControl < o_DMXDevice.getDMXControlComponentCount(); ++intDMXControl) {
                DMXControlComponent o_DMXControlComponent = o_DMXDevice.getDMXControlComponent(intDMXControl);
                if (intDMXControl >= this.m_ValuesPanels.size()) {
                    o_ValuesPanel = new ValuesPanel(this);
                    this.m_ValuesPanels.add(o_ValuesPanel);
                    GridBagConstraints o_GridBagConstraints = new GridBagConstraints();
                    o_GridBagConstraints.gridx = intDMXControl;
                    o_GridBagConstraints.gridy = 0;
                    o_GridBagConstraints.weighty = 1.0;
                    o_GridBagConstraints.fill = 3;
                    this.jPanel_SceneDeviceValues.add((Component)o_ValuesPanel, o_GridBagConstraints);
                }
                o_ValuesPanel = this.m_ValuesPanels.get(intDMXControl);
                o_ValuesPanel.setDMXControlComponent(o_LiveShowObject, o_DMXScene, o_DMXDevice, o_DMXControlComponent);
                o_ValuesPanel.setVisible(true);
                o_ValuesPanel.refreshGUI();
            }
            for (int intValuesPanel = intDMXControl; intValuesPanel < this.m_ValuesPanels.size(); ++intValuesPanel) {
                o_ValuesPanel = this.m_ValuesPanels.get(intValuesPanel);
                o_ValuesPanel.setDMXControlComponent(null, null, null, null);
                o_ValuesPanel.setVisible(false);
            }
        }
    }

    public void setButtonsSaveCancelEnabled(boolean p_Enabled) {
        this.jButton_Save.setEnabled(p_Enabled);
        this.jButton_Cancel.setEnabled(p_Enabled);
    }

    public void refreshButtonCopyMode() {
        ValuesPanel o_ValuesPanel = null;
        for (int intValuesPanel = 0; intValuesPanel < this.m_ValuesPanels.size(); ++intValuesPanel) {
            o_ValuesPanel = this.m_ValuesPanels.get(intValuesPanel);
            o_ValuesPanel.setCopyModeOn(false);
        }
        this.jButton_Copy.setBorder(null);
        this.jButton_Copy.setBorderPainted(false);
        if (this.m_CopyModeOn) {
            if (this.m_CopyDestination == null) {
                this.jButton_Copy.setBorder(s_CopyBorder);
                this.jButton_Copy.setBorderPainted(true);
            } else {
                o_ValuesPanel = this.getValuesPanel(this.m_CopyDestination.getDMXControlType().getID());
                if (o_ValuesPanel != null) {
                    o_ValuesPanel.setCopyModeOn(true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSelectionSourceInterface(SelectionSourceInterface p_SelectionSourceInterface) {
        if (p_SelectionSourceInterface == null) {
            return;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            if (this.m_SelectionSourceInterfaces.contains(p_SelectionSourceInterface)) {
                return;
            }
            this.m_SelectionSourceInterfaces.add(p_SelectionSourceInterface);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSelectionSourceInterface(SelectionSourceInterface p_SelectionSourceInterface) {
        if (p_SelectionSourceInterface == null) {
            return;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            if (!this.m_SelectionSourceInterfaces.contains(p_SelectionSourceInterface)) {
                return;
            }
            this.m_SelectionSourceInterfaces.remove(p_SelectionSourceInterface);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCopyModeOn(DMXControlComponent p_DMXControlComponent_Dest, boolean p_CopyModeOn) {
        this.m_CopyModeOn = p_CopyModeOn;
        this.m_CopyDestination = p_DMXControlComponent_Dest;
        Object object = this.m_SyncObject;
        synchronized (object) {
            for (int intInterface = 0; intInterface < this.m_SelectionSourceInterfaces.size(); ++intInterface) {
                SelectionSourceInterface o_SelectionSourceInterface = this.m_SelectionSourceInterfaces.get(intInterface);
                o_SelectionSourceInterface.setCopyModeOn(p_DMXControlComponent_Dest, this.m_CopyModeOn);
            }
        }
        this.refreshButtonCopyMode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelection(LiveShowObject p_LiveShowObject, DMXDevice p_DMXDevice) {
        Object object = this.m_SyncObject;
        synchronized (object) {
            for (int intInterface = 0; intInterface < this.m_SelectionSourceInterfaces.size(); ++intInterface) {
                SelectionSourceInterface o_SelectionSourceInterface = this.m_SelectionSourceInterfaces.get(intInterface);
                o_SelectionSourceInterface.setSelection(p_LiveShowObject, p_DMXDevice);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValuesPanel getValuesPanel(String p_ID) {
        if (p_ID == null) {
            return null;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            for (int intPanel = 0; intPanel < this.m_ValuesPanels.size(); ++intPanel) {
                ValuesPanel o_ValuesPanel = this.m_ValuesPanels.get(intPanel);
                DMXControlComponent o_DMXControlComponent = o_ValuesPanel.getDMXControlComponent();
                if (!p_ID.equals(o_DMXControlComponent.getDMXControlType().getID())) continue;
                return o_ValuesPanel;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValuesPanel getValuesPanel(int p_Index) {
        Object object = this.m_SyncObject;
        synchronized (object) {
            if (p_Index < 0 || p_Index >= this.m_ValuesPanels.size()) {
                return null;
            }
            return this.m_ValuesPanels.get(p_Index);
        }
    }

    public ControlLabelModel.ControlLabelList findControlLabelList(ControlObject.ControlDimension p_ControlDimension) {
        if (p_ControlDimension == null) {
            return null;
        }
        ControlLabelModel o_ControlLabelModel = p_ControlDimension.getControlLabelModel();
        if (o_ControlLabelModel == null) {
            return null;
        }
        int intListCount = o_ControlLabelModel.getControlLabelListSize();
        switch (intListCount) {
            case 0: {
                return null;
            }
            case 1: {
                return o_ControlLabelModel.getControlLabelList(0);
            }
        }
        for (int intList = 0; intList < intListCount; ++intList) {
            ControlLabelModel.ControlLabelList o_ControlLabelList = o_ControlLabelModel.getControlLabelList(intList);
            for (int intCondition = 0; intCondition < o_ControlLabelList.getLabelListConditionSize(); ++intCondition) {
                ControlObject.ControlDimension o_ConditionRemoteControlDimension;
                double doubleRemoteValue;
                ValuesPanel o_RemoteValuesPanel;
                ControlLabelModel.LabelListCondition o_LabelListCondition = o_ControlLabelList.getLabelListCondition(intCondition);
                if (o_LabelListCondition == null || (o_RemoteValuesPanel = this.getValuesPanel(o_LabelListCondition.getRemoteID())) == null || !((doubleRemoteValue = o_RemoteValuesPanel.getValue(o_ConditionRemoteControlDimension = o_LabelListCondition.getRemoteControlDimension())) >= o_LabelListCondition.getRemoteValueStart()) || !(doubleRemoteValue <= o_LabelListCondition.getRemoteValueEnd())) continue;
                return o_ControlLabelList;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelected(LiveShowObject p_LiveShowObject, DMXDevice p_DMXDevice) {
        boolean boolChanged = false;
        DMXScene o_DMXScene = null;
        Object object = this.m_SyncObject;
        synchronized (object) {
            if (this.m_LiveShowObject != p_LiveShowObject) {
                boolChanged = true;
                if (this.m_LiveShowObject != null) {
                    this.m_LiveShowObject.removeLiveShowObjectListener(this);
                }
                this.m_LiveShowObject = p_LiveShowObject;
                if (this.m_LiveShowObject != null) {
                    this.m_LiveShowObject.addLiveShowObjectListener(this);
                }
            }
            if (this.m_LiveShowObject != null) {
                o_DMXScene = this.m_LiveShowObject instanceof LiveShowDMXObject ? ((LiveShowDMXObject)p_LiveShowObject).getDMXScene() : null;
            }
            if (this.m_DMXScene != o_DMXScene) {
                if (this.m_DMXScene != null) {
                    this.m_DMXScene.removePropertyChangeListener(this);
                }
                this.m_DMXScene = o_DMXScene;
                if (this.m_DMXScene != null) {
                    this.m_DMXScene.addPropertyChangeListener(this);
                }
                boolChanged = true;
            }
            if (this.m_DMXDevice != p_DMXDevice) {
                if (this.m_DMXDevice != null) {
                    this.m_DMXDevice.removePropertyChangeListener(this);
                    this.m_DMXFadeDescription.removeDMXDeviceFadeDescription(this.m_DMXDeviceFadeDescription);
                }
                this.m_DMXDevice = p_DMXDevice;
                if (this.m_DMXDevice != null) {
                    this.m_DMXDevice.addPropertyChangeListener(this);
                    this.m_DMXFadeDescription.addDMXDeviceFadeDescription(this.m_DMXDevice.getID());
                    this.m_DMXDeviceFadeDescription = this.m_DMXFadeDescription.getDMXDeviceFadeDescription(this.m_DMXDevice.getID());
                }
                boolChanged = true;
            }
        }
        if (boolChanged) {
            this.refresh();
        }
    }

    public DMXFadeDescription.DMXDeviceFadeDescription getDMXDeviceFadeDescription() {
        return this.m_DMXDeviceFadeDescription;
    }

    public void setCopySceneValues(boolean p_CopySceneValues) {
        this.jCheckBox_CopySceneValues.setSelected(p_CopySceneValues);
    }

    public boolean getCopySceneValues() {
        return this.jCheckBox_CopySceneValues.isSelected();
    }

    public void setCopyObjectSettings(boolean p_CopyObjectSettings) {
        this.jCheckBox_CopyObjectSettings.setSelected(p_CopyObjectSettings);
    }

    public boolean getCopyObjectSettings() {
        return this.jCheckBox_CopyObjectSettings.isSelected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFrom(LiveShowObject p_LiveShowObject_Source, DMXDevice p_DMXDevice_Source) {
        if (p_DMXDevice_Source == null || p_LiveShowObject_Source == null) {
            return;
        }
        if (!(p_LiveShowObject_Source instanceof LiveShowDMXObject)) {
            return;
        }
        DMXScene o_DMXScene_Source = ((LiveShowDMXObject)p_LiveShowObject_Source).getDMXScene();
        if (o_DMXScene_Source == null) {
            return;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            if (this.m_DMXDevice == null || this.m_DMXScene == null) {
                return;
            }
            if (this.m_DMXDevice == p_DMXDevice_Source && this.m_DMXScene == o_DMXScene_Source) {
                return;
            }
            if (this.m_CopyDestination == null) {
                if (this.jCheckBox_CopySceneValues.isSelected()) {
                    DMXScene.copyFrom(this, this.m_DMXDevice, this.m_DMXScene, p_DMXDevice_Source, o_DMXScene_Source);
                }
                if (this.jCheckBox_CopyObjectSettings.isSelected()) {
                    LiveShowDMXObject.copyFrom(this, this.m_LiveShowObject, this.m_DMXDevice, p_LiveShowObject_Source, p_DMXDevice_Source);
                }
            } else {
                if (this.jCheckBox_CopySceneValues.isSelected()) {
                    ArrayList<DMXControlDescription> o_DMXControlDescriptions = new ArrayList<DMXControlDescription>();
                    for (int intDMXControl = 0; intDMXControl < this.m_DMXDevice.getDMXControlComponentCount(); ++intDMXControl) {
                        DMXControlComponent o_DMXControlComponent_Dest = this.m_DMXDevice.getDMXControlComponent(intDMXControl);
                        DMXControlDescription o_DMXControlDescription = o_DMXControlComponent_Dest.getDMXControlType().getDMXControlDescription();
                        if (o_DMXControlDescriptions.contains(o_DMXControlDescription)) continue;
                        o_DMXControlDescriptions.add(o_DMXControlDescription);
                    }
                    DMXScene.copyFrom(this, this.m_DMXDevice, this.m_DMXScene, p_DMXDevice_Source, o_DMXScene_Source, o_DMXControlDescriptions);
                }
                if (this.jCheckBox_CopyObjectSettings.isSelected()) {
                    LiveShowDMXObject.copyFrom(this, this.m_CopyDestination, this.m_LiveShowObject, this.m_DMXDevice, this.m_DMXScene, p_LiveShowObject_Source, p_DMXDevice_Source, o_DMXScene_Source);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAllValuesPanels() {
        Object object = this.m_SyncObject;
        synchronized (object) {
            for (int intPanel = 0; intPanel < this.m_ValuesPanels.size(); ++intPanel) {
                ValuesPanel o_ValuesPanel = this.m_ValuesPanels.get(intPanel);
                o_ValuesPanel.setDMXControlComponent(null, null, null, null);
            }
        }
    }

    private void initComponents() {
        this.jLabel_DMXScene = new JLabel();
        this.jLabel_DMXDeviceName = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jPanel_SceneDeviceValues = new JPanel();
        this.jLabel_DMXDeviceIcon = new JLabelBackground();
        this.jButton_Save = new JButton();
        this.jButton_Cancel = new JButton();
        this.jButton_Copy = new JButton();
        this.jLabel_Object = new JLabel();
        this.jButton_ShowObjectSettings = new JButton();
        this.jCheckBox_CopySceneValues = new JCheckBox();
        this.jCheckBox_CopyObjectSettings = new JCheckBox();
        this.jButton_ShowObjectDetails = new JButton();
        this.jButton_ShowInTimeline = new JButton();
        this.setForeground(new Color(51, 51, 51));
        this.setToolTipText("");
        this.setMinimumSize(new Dimension(99, 100));
        this.setPreferredSize(new Dimension(78, 150));
        this.setLayout(new GridBagLayout());
        this.jLabel_DMXScene.setHorizontalAlignment(0);
        this.jLabel_DMXScene.setText("Scene");
        this.jLabel_DMXScene.setToolTipText("");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jLabel_DMXScene, gridBagConstraints);
        this.jLabel_DMXDeviceName.setHorizontalAlignment(0);
        this.jLabel_DMXDeviceName.setText("DeviceName");
        this.jLabel_DMXDeviceName.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(1, 3, 3, 3);
        this.add((Component)this.jLabel_DMXDeviceName, gridBagConstraints);
        this.jScrollPane1.setBorder(null);
        this.jPanel_SceneDeviceValues.setToolTipText("");
        this.jPanel_SceneDeviceValues.setLayout(new GridBagLayout());
        this.jScrollPane1.setViewportView(this.jPanel_SceneDeviceValues);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jLabel_DMXDeviceIcon.setText("jLabelBackground1");
        this.jLabel_DMXDeviceIcon.setMaximumSize(new Dimension(100, 100));
        this.jLabel_DMXDeviceIcon.setMinimumSize(new Dimension(32, 32));
        this.jLabel_DMXDeviceIcon.setPreferredSize(new Dimension(32, 32));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(3, 3, 1, 3);
        this.add((Component)this.jLabel_DMXDeviceIcon, gridBagConstraints);
        this.jButton_Save.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Edit_OK.png")));
        this.jButton_Save.setToolTipText("Save the device type");
        this.jButton_Save.setContentAreaFilled(false);
        this.jButton_Save.setMargin(new Insets(-1, -1, -1, -1));
        this.jButton_Save.setMaximumSize(new Dimension(32, 32));
        this.jButton_Save.setMinimumSize(new Dimension(32, 32));
        this.jButton_Save.setPreferredSize(new Dimension(32, 32));
        this.jButton_Save.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_Save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DMXTrackingObjectEditPanel.this.jButton_SaveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jButton_Save, gridBagConstraints);
        this.jButton_Cancel.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Edit_Cancel.png")));
        this.jButton_Cancel.setToolTipText("Cancel");
        this.jButton_Cancel.setContentAreaFilled(false);
        this.jButton_Cancel.setMargin(new Insets(-1, -1, -1, -1));
        this.jButton_Cancel.setMaximumSize(new Dimension(32, 32));
        this.jButton_Cancel.setMinimumSize(new Dimension(32, 32));
        this.jButton_Cancel.setPreferredSize(new Dimension(32, 32));
        this.jButton_Cancel.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_Cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DMXTrackingObjectEditPanel.this.jButton_CancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jButton_Cancel, gridBagConstraints);
        this.jButton_Copy.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Edit_Copy.png")));
        this.jButton_Copy.setToolTipText("copy all values from another scene/device");
        this.jButton_Copy.setBorderPainted(false);
        this.jButton_Copy.setContentAreaFilled(false);
        this.jButton_Copy.setMargin(new Insets(-1, -1, -1, -1));
        this.jButton_Copy.setMaximumSize(new Dimension(32, 32));
        this.jButton_Copy.setMinimumSize(new Dimension(32, 32));
        this.jButton_Copy.setPreferredSize(new Dimension(32, 32));
        this.jButton_Copy.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_Copy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DMXTrackingObjectEditPanel.this.jButton_CopyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        this.add((Component)this.jButton_Copy, gridBagConstraints);
        this.jLabel_Object.setFont(new Font("Tahoma", 0, 12));
        this.jLabel_Object.setForeground(new Color(255, 255, 255));
        this.jLabel_Object.setHorizontalAlignment(0);
        this.jLabel_Object.setText("ObjectName");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jLabel_Object, gridBagConstraints);
        this.jButton_ShowObjectSettings.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Edit.png")));
        this.jButton_ShowObjectSettings.setToolTipText("show object settings");
        this.jButton_ShowObjectSettings.setContentAreaFilled(false);
        this.jButton_ShowObjectSettings.setMargin(new Insets(-1, -1, -1, -1));
        this.jButton_ShowObjectSettings.setMaximumSize(new Dimension(32, 32));
        this.jButton_ShowObjectSettings.setMinimumSize(new Dimension(32, 32));
        this.jButton_ShowObjectSettings.setPreferredSize(new Dimension(32, 32));
        this.jButton_ShowObjectSettings.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_ShowObjectSettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DMXTrackingObjectEditPanel.this.jButton_ShowObjectSettingsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jButton_ShowObjectSettings, gridBagConstraints);
        this.jCheckBox_CopySceneValues.setText("Copy scene values");
        this.jCheckBox_CopySceneValues.setToolTipText("when selected - the scene-values will be copied");
        this.jCheckBox_CopySceneValues.setOpaque(false);
        this.jCheckBox_CopySceneValues.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DMXTrackingObjectEditPanel.this.jCheckBox_CopySceneValuesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 1, 3);
        this.add((Component)this.jCheckBox_CopySceneValues, gridBagConstraints);
        this.jCheckBox_CopyObjectSettings.setText("copy object settings");
        this.jCheckBox_CopyObjectSettings.setToolTipText("when selected - the object's settings will be copied");
        this.jCheckBox_CopyObjectSettings.setOpaque(false);
        this.jCheckBox_CopyObjectSettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DMXTrackingObjectEditPanel.this.jCheckBox_CopyObjectSettingsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 3, 3, 3);
        this.add((Component)this.jCheckBox_CopyObjectSettings, gridBagConstraints);
        this.jButton_ShowObjectDetails.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Object_Details.png")));
        this.jButton_ShowObjectDetails.setToolTipText("copy all values from another scene/device");
        this.jButton_ShowObjectDetails.setContentAreaFilled(false);
        this.jButton_ShowObjectDetails.setMargin(new Insets(-1, -1, -1, -1));
        this.jButton_ShowObjectDetails.setMaximumSize(new Dimension(32, 32));
        this.jButton_ShowObjectDetails.setMinimumSize(new Dimension(32, 32));
        this.jButton_ShowObjectDetails.setPreferredSize(new Dimension(32, 32));
        this.jButton_ShowObjectDetails.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_ShowObjectDetails.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DMXTrackingObjectEditPanel.this.jButton_ShowObjectDetailsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jButton_ShowObjectDetails, gridBagConstraints);
        this.jButton_ShowInTimeline.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Timeline_Selection.png")));
        this.jButton_ShowInTimeline.setToolTipText("Selects the object in timeline");
        this.jButton_ShowInTimeline.setContentAreaFilled(false);
        this.jButton_ShowInTimeline.setFocusable(false);
        this.jButton_ShowInTimeline.setHorizontalTextPosition(0);
        this.jButton_ShowInTimeline.setIconTextGap(0);
        this.jButton_ShowInTimeline.setMargin(new Insets(0, 0, 0, 0));
        this.jButton_ShowInTimeline.setMaximumSize(new Dimension(32, 32));
        this.jButton_ShowInTimeline.setMinimumSize(new Dimension(32, 32));
        this.jButton_ShowInTimeline.setPreferredSize(new Dimension(32, 32));
        this.jButton_ShowInTimeline.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_ShowInTimeline.setVerticalTextPosition(3);
        this.jButton_ShowInTimeline.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DMXTrackingObjectEditPanel.this.jButton_ShowInTimelineActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jButton_ShowInTimeline, gridBagConstraints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshButtonSaveCancel() {
        boolean boolValuesChanged = false;
        Object object = this.m_SyncObject;
        synchronized (object) {
            for (int intValuesPanel = 0; intValuesPanel < this.m_ValuesPanels.size(); ++intValuesPanel) {
                ValuesPanel o_ValuesPanel = this.m_ValuesPanels.get(intValuesPanel);
                if (!o_ValuesPanel.getValuesChanged()) continue;
                boolValuesChanged = true;
                break;
            }
        }
        if (boolValuesChanged) {
            this.setButtonsSaveCancelEnabled(true);
        } else {
            this.setButtonsSaveCancelEnabled(false);
        }
    }

    public void startUndoAction(int p_Action, String p_ActionString) {
        LiveShowUndo o_LiveShowUndo = null;
        LiveShowObject o_LiveShowObjectInterface = this.m_LiveShowObject;
        if (o_LiveShowObjectInterface == null) {
            return;
        }
        LiveShowVIP o_LiveShowVIP = o_LiveShowObjectInterface.getLiveShowVIP();
        if (o_LiveShowVIP == null) {
            return;
        }
        o_LiveShowUndo = o_LiveShowVIP.getLiveShowUndo();
        if (o_LiveShowUndo == null) {
            return;
        }
        if (o_LiveShowUndo.checkStartAction(p_Action)) {
            LiveShowVIP.LiveShowVIPStatus o_LiveShowVIPStatus = new LiveShowVIP.LiveShowVIPStatus();
            o_LiveShowVIPStatus.addLiveShowObject_Cloned(o_LiveShowObjectInterface);
            o_LiveShowUndo.startAction(p_Action, p_ActionString, o_LiveShowVIP, o_LiveShowVIPStatus);
        }
    }

    public void endUndoAction(int p_Action, boolean p_Success) {
        LiveShowUndo o_LiveShowUndo = null;
        LiveShowObject o_LiveShowObjectInterface = this.m_LiveShowObject;
        if (o_LiveShowObjectInterface == null) {
            return;
        }
        LiveShowVIP o_LiveShowVIP = o_LiveShowObjectInterface.getLiveShowVIP();
        if (o_LiveShowVIP == null) {
            return;
        }
        o_LiveShowUndo = o_LiveShowVIP.getLiveShowUndo();
        if (o_LiveShowUndo == null) {
            return;
        }
        if (o_LiveShowUndo.checkEndAction(p_Action)) {
            LiveShowVIP.LiveShowVIPStatus o_LiveShowVIPStatus = new LiveShowVIP.LiveShowVIPStatus();
            o_LiveShowVIPStatus.addLiveShowObject_Cloned(o_LiveShowObjectInterface);
            o_LiveShowUndo.endAction(p_Success, p_Action, o_LiveShowVIP, o_LiveShowVIPStatus);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButton_SaveActionPerformed(ActionEvent evt) {
        if (LiveShowDMXSystem.getLiveShowDMXVIP() != null && this.m_DMXDevice != null && this.m_LiveShowObject != null && this.m_LiveShowObject instanceof LiveShowDMXObject) {
            LiveShowDMXObject o_LiveShowDMXObject_Selected = (LiveShowDMXObject)this.m_LiveShowObject;
            if (o_LiveShowDMXObject_Selected == null) {
                return;
            }
            DMXScene o_DMXScene = this.m_DMXScene;
            DMXDevice o_DMXDevice_Selected = this.m_DMXDevice;
            int intAction = 121;
            String stringAction = LiveShowUndo.ACTION_FADESETTINGS_STRING;
            this.startUndoAction(intAction, stringAction);
            Object object = this.m_SyncObject;
            synchronized (object) {
                for (int intDMXControl = 0; intDMXControl < o_DMXDevice_Selected.getDMXControlComponentCount() && intDMXControl < this.m_ValuesPanels.size(); ++intDMXControl) {
                    ValuesPanel o_ValuesPanel = this.m_ValuesPanels.get(intDMXControl);
                    if (o_ValuesPanel == null) continue;
                    o_ValuesPanel.save();
                }
            }
            o_LiveShowDMXObject_Selected.checkEqualsFadeSettingsToDefault();
            o_LiveShowDMXObject_Selected.notifyObjectListeners_ObjectParameterChanged(o_LiveShowDMXObject_Selected.getDescription());
            this.endUndoAction(intAction, true);
            this.setSelection(o_LiveShowDMXObject_Selected, o_DMXDevice_Selected);
            this.refreshButtonSaveCancel();
            if (o_DMXScene != null) {
                o_DMXScene.externalChanged();
            }
        } else {
            this.refreshButtonSaveCancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButton_CancelActionPerformed(ActionEvent evt) {
        Object object = this.m_SyncObject;
        synchronized (object) {
            for (int intPanel = 0; intPanel < this.m_ValuesPanels.size(); ++intPanel) {
                ValuesPanel o_ValuesPanel = this.m_ValuesPanels.get(intPanel);
                o_ValuesPanel.refreshDMXSceneDMXDevice();
            }
        }
        this.refreshButtonSaveCancel();
    }

    private void jButton_CopyActionPerformed(ActionEvent evt) {
        if (this.m_CopyDestination != null) {
            this.setCopyModeOn(null, true);
        } else if (!this.m_CopyModeOn) {
            this.setCopyModeOn(null, true);
        } else {
            this.setCopyModeOn(null, false);
        }
    }

    private void jButton_ShowObjectSettingsActionPerformed(ActionEvent evt) {
        LiveShowDMXVIP o_LiveShowDMXVIP = LiveShowDMXSystem.getLiveShowDMXVIP();
        if (o_LiveShowDMXVIP != null && this.m_LiveShowObject != null) {
            o_LiveShowDMXVIP.notifyLiveShowVIPListeners_ShowObjectSettings(this.m_LiveShowObject);
        }
    }

    private void jCheckBox_CopySceneValuesActionPerformed(ActionEvent evt) {
        s_LastCopySceneValues = this.jCheckBox_CopySceneValues.isSelected();
    }

    private void jCheckBox_CopyObjectSettingsActionPerformed(ActionEvent evt) {
        s_LastCopyObjectSettings = this.jCheckBox_CopyObjectSettings.isSelected();
    }

    public boolean getShowDetails() {
        return this.m_ShowDetails;
    }

    private void jButton_ShowObjectDetailsActionPerformed(ActionEvent evt) {
        this.m_ShowDetails = !this.m_ShowDetails;
        this.refresh();
    }

    private void jButton_ShowInTimelineActionPerformed(ActionEvent evt) {
        LiveShowObject o_LiveShowObject = this.m_LiveShowObject;
        if (o_LiveShowObject == null) {
            return;
        }
        LiveShowDMXVIP o_LiveShowDMXVIP = LiveShowDMXSystem.getLiveShowDMXVIP();
        if (o_LiveShowDMXVIP == null) {
            return;
        }
        o_LiveShowDMXVIP.clearSelectedObjects(true);
        o_LiveShowDMXVIP.addSelectedObject(o_LiveShowObject);
        if (o_LiveShowDMXVIP.getSelectedObjectsCount() > 0) {
            o_LiveShowDMXVIP.toFront();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof DMXScene) {
            if ("liveShowObject_SourceClose".equals(evt.getPropertyName())) {
                Object object = this.m_SyncObject;
                synchronized (object) {
                    this.m_LiveShowObject = null;
                    this.m_DMXScene = null;
                }
            }
            this.refresh();
        }
        if (evt.getSource() instanceof DMXDevice) {
            if ("dmxdeviceAdjustedSceneBridge".equals(evt.getPropertyName())) {
                return;
            }
            if ("dmxdeviceDimmerValue".equals(evt.getPropertyName())) {
                return;
            }
            this.refresh();
        }
    }

    @Override
    public void eventObjectParameterChanged(LiveShowObjectInterface p_LiveShowObjectInterface, LiveShowObjectDescription p_LiveShowObjectDescription) {
        this.refresh();
    }

    @Override
    public void eventObjectVolumeChanged(LiveShowObjectInterface p_LiveShowObjectInterface, float p_Volume) {
    }

    @Override
    public void eventObjectAdditionalChanged(LiveShowObjectInterface p_LiveShowObjectInterface, LiveShowObjectDescription p_LiveShowObjectDescription) {
    }

    @Override
    public void eventObjectClosed(LiveShowObjectInterface p_LiveShowObjectInterface) {
        if (this.m_LiveShowObject == p_LiveShowObjectInterface) {
            this.m_LiveShowObject = null;
        }
        this.refresh();
    }

    @Override
    public void eventObjectSelection(LiveShowObjectInterface p_LiveShowObjectInterface, boolean p_IsSelected, boolean p_Added) {
    }

    @Override
    public DMXFadeDescription.DMXControlTypeFadeDescription getValue(LiveShowObject p_LiveShowObject, DMXDevice p_DMXDevice, DMXScene p_DMXScene, DMXControlComponent.DMXControlType p_DMXControlType, int p_ControlIndex, int p_DimensionIndex) {
        ValuesPanel o_ValuesPanel = this.getValuesPanel(p_DMXControlType.getID());
        if (o_ValuesPanel == null) {
            return null;
        }
        return o_ValuesPanel.getValueFadeDescription();
    }

    @Override
    public DMXFadeDescription.DMXControlTypeFadeDescription setValue(DMXFadeDescription.DMXControlTypeFadeDescription p_Value, LiveShowObject p_LiveShowObject, DMXDevice p_DMXDevice, DMXScene p_DMXScene, DMXControlComponent.DMXControlType p_DMXControlType) {
        ValuesPanel o_ValuesPanel = this.getValuesPanel(p_DMXControlType.getID());
        if (o_ValuesPanel == null) {
            return null;
        }
        o_ValuesPanel.setValueFadeDescription(p_Value);
        return o_ValuesPanel.getValueFadeDescription();
    }

    @Override
    public void setCopyDone(int p_CopyFlag, DMXDevice p_DMXDevice, DMXScene p_DMXScene, DMXControlComponent p_DMXControlComponent) {
        ValuesPanel o_ValuesPanel = this.getValuesPanel(p_DMXControlComponent.getDMXControlType().getID());
        o_ValuesPanel.setCopyFlag(p_CopyFlag);
        o_ValuesPanel.refreshValuesSet();
        this.refreshButtonSaveCancel();
    }

    @Override
    public void setCopyDMXSceneDone(int p_CopyFlag, DMXDevice p_DMXDevice, DMXScene p_DMXScene, DMXControlComponent p_DMXControlComponent) {
        ValuesPanel o_ValuesPanel = this.getValuesPanel(p_DMXControlComponent.getDMXControlType().getID());
        o_ValuesPanel.setCopyFlag(p_CopyFlag);
        o_ValuesPanel.refreshValuesSet();
        this.refreshButtonSaveCancel();
    }

    @Override
    public double getValueCopyDMXScene(DMXDevice p_DMXDevice, DMXScene p_DMXScene, DMXControlComponent.DMXControlType p_DMXControlType, int p_ControlIndex, int p_DimensionIndex) {
        if (p_DMXControlType == null) {
            return -2.147483648E9;
        }
        ValuesPanel o_ValuesPanel = this.getValuesPanel(p_DMXControlType.getID());
        if (o_ValuesPanel == null) {
            return -2.147483648E9;
        }
        return o_ValuesPanel.getValue(p_DMXControlType.getControlType(p_ControlIndex).getControlDimensionType(p_DimensionIndex).getControlDimension());
    }

    @Override
    public double setValueCopyDMXScene(double p_Value, DMXDevice p_DMXDevice, DMXScene p_DMXScene, DMXControlComponent.DMXControlType p_DMXControlType, int p_ControlIndex, int p_DimensionIndex) {
        if (p_DMXControlType == null) {
            return -2.147483648E9;
        }
        ValuesPanel o_ValuesPanel = this.getValuesPanel(p_DMXControlType.getID());
        if (o_ValuesPanel == null) {
            return -2.147483648E9;
        }
        o_ValuesPanel.setValue(p_DMXControlType.getControlType(p_ControlIndex).getControlDimensionType(p_DimensionIndex).getControlDimension(), p_Value);
        return o_ValuesPanel.getValue(p_DMXControlType.getControlType(p_ControlIndex).getControlDimensionType(p_DimensionIndex).getControlDimension());
    }

    public static interface SelectionSourceInterface {
        public void setCopyModeOn(DMXControlComponent var1, boolean var2);

        public void setSelection(LiveShowObject var1, DMXDevice var2);
    }

    public static class ValuesPanel
    extends JPanel
    implements ValueSelectionInterface,
    PropertyChangeListener {
        public static Dimension s_DisplayLabelDimension = new Dimension(32, 32);
        public static Border s_Border = new LineBorder(Color.BLACK, 1);
        private DMXTrackingObjectEditPanel m_DMXTrackingObjectEditPanel;
        private DMXControlComponent m_DMXControlComponent;
        private DMXControlDisplayLabel m_DMXControlDisplayLabel;
        private JLabel m_CopyLabel;
        private JCheckBox m_CheckBox_Deactivated;
        private JLabel m_JLabel_DMXControlName;
        private JPanel m_JPanel_TextFields;
        private ArrayList<JLabel> m_JTextFieldLabels;
        private ArrayList<JTextFieldBytePanel> m_JTextFieldBytePanels;
        private ArrayList<Double> m_Values;
        private DMXFadeDescriptionPanel m_DMXFadeDescriptionPanel;
        private LiveShowDMXObject m_LiveShowDMXObject;
        private ControlObject.ControlDimension m_LastSetControlDimension;
        private DMXScene m_DMXScene;
        private DMXDevice m_DMXDevice;
        private DMXFadeDescription.DMXControlTypeFadeDescription m_DMXControlTypeFadeDescription;
        private boolean m_ValuesChanged;
        private boolean m_CopyModeOn;
        private final Object m_SyncObject = new Object();

        public ValuesPanel(DMXTrackingObjectEditPanel p_DMXTrackingObjectEditPanel) {
            this.initMembers();
            this.m_DMXTrackingObjectEditPanel = p_DMXTrackingObjectEditPanel;
            this.initComponents();
            this.initComponentsFurther();
        }

        private void initMembers() {
            this.m_JTextFieldLabels = new ArrayList();
            this.m_JTextFieldBytePanels = new ArrayList();
            this.m_Values = new ArrayList();
            this.m_ValuesChanged = false;
            this.m_CopyModeOn = false;
        }

        private void initComponents() {
            this.setBackground(Color.BLACK);
            this.setLayout(new GridBagLayout());
            this.setBorder(s_Border);
            GridBagConstraints o_GridBagConstraints = new GridBagConstraints();
            o_GridBagConstraints.gridx = 0;
            o_GridBagConstraints.gridy = 0;
            o_GridBagConstraints.gridwidth = 2;
            o_GridBagConstraints.anchor = 11;
            this.m_DMXControlDisplayLabel = new DMXControlDisplayLabel();
            this.m_DMXControlDisplayLabel.setBorder(new LineBorder(Color.GRAY, 1));
            this.m_DMXControlDisplayLabel.setDMXControlComponent(this.m_DMXControlComponent);
            this.m_DMXControlDisplayLabel.setPreferredSize(s_DisplayLabelDimension);
            this.add((Component)this.m_DMXControlDisplayLabel, o_GridBagConstraints);
            o_GridBagConstraints = new GridBagConstraints();
            o_GridBagConstraints.gridx = 0;
            o_GridBagConstraints.gridy = 1;
            o_GridBagConstraints.gridwidth = 2;
            this.m_JLabel_DMXControlName = new JLabel();
            this.m_JLabel_DMXControlName.setForeground(Color.WHITE);
            this.add((Component)this.m_JLabel_DMXControlName, o_GridBagConstraints);
            o_GridBagConstraints = new GridBagConstraints();
            o_GridBagConstraints.gridx = 0;
            o_GridBagConstraints.gridy = 2;
            o_GridBagConstraints.weightx = 1.0;
            o_GridBagConstraints.anchor = 10;
            this.m_CheckBox_Deactivated = new JCheckBox();
            this.m_CheckBox_Deactivated.setForeground(Color.WHITE);
            this.m_CheckBox_Deactivated.setBackground(Color.BLACK);
            this.m_CheckBox_Deactivated.setText(LiveShowDMXCrossTable_DMXDeviceDMXObject.STRING_DEACTIVATED);
            this.m_CheckBox_Deactivated.setSelected(false);
            this.add((Component)this.m_CheckBox_Deactivated, o_GridBagConstraints);
            this.m_CheckBox_Deactivated.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    this.checkDeactivated();
                }
            });
            o_GridBagConstraints = new GridBagConstraints();
            o_GridBagConstraints.gridx = 1;
            o_GridBagConstraints.gridy = 0;
            o_GridBagConstraints.anchor = 13;
            this.m_CopyLabel = new JLabel();
            this.m_CopyLabel.setMaximumSize(new Dimension(32, 32));
            this.m_CopyLabel.setMinimumSize(new Dimension(32, 32));
            this.m_CopyLabel.setPreferredSize(new Dimension(32, 32));
            this.add((Component)this.m_CopyLabel, o_GridBagConstraints);
            this.m_CopyLabel.setVisible(false);
            o_GridBagConstraints = new GridBagConstraints();
            o_GridBagConstraints.gridx = 0;
            o_GridBagConstraints.gridy = 3;
            o_GridBagConstraints.gridwidth = 2;
            o_GridBagConstraints.weighty = 1.0;
            o_GridBagConstraints.fill = 3;
            this.m_JPanel_TextFields = new JPanel();
            this.m_JPanel_TextFields.setLayout(new GridBagLayout());
            this.add((Component)this.m_JPanel_TextFields, o_GridBagConstraints);
            o_GridBagConstraints = new GridBagConstraints();
            o_GridBagConstraints.gridx = 0;
            o_GridBagConstraints.gridy = 4;
            o_GridBagConstraints.gridwidth = 2;
            o_GridBagConstraints.weightx = 1.0;
            o_GridBagConstraints.weighty = 1.0;
            o_GridBagConstraints.fill = 1;
            this.m_DMXFadeDescriptionPanel = new DMXFadeDescriptionPanel();
            this.m_DMXFadeDescriptionPanel.setMinimumSize(new Dimension(300, 450));
            this.add((Component)this.m_DMXFadeDescriptionPanel, o_GridBagConstraints);
        }

        private void initComponentsFurther() {
            this.m_DMXControlDisplayLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    this.showValueSelection(e.getXOnScreen(), e.getYOnScreen());
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            if (this.m_DMXControlDisplayLabel != null) {
                this.m_DMXControlDisplayLabel.close();
            }
            if (this.m_DMXControlTypeFadeDescription != null) {
                this.m_DMXControlTypeFadeDescription.removePropertyChangeListener(this);
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                for (int intTextField = this.m_JTextFieldBytePanels.size() - 1; intTextField >= 0; --intTextField) {
                    JTextFieldBytePanel o_JTextFieldBytePanel = this.m_JTextFieldBytePanels.get(intTextField);
                    JLabel o_JLabel = this.m_JTextFieldLabels.get(intTextField);
                    this.remove((Component)o_JTextFieldBytePanel);
                    this.remove(o_JLabel);
                    o_JTextFieldBytePanel.removePropertyChangeListener((PropertyChangeListener)this);
                }
                this.m_JTextFieldBytePanels.clear();
                this.m_JTextFieldLabels.clear();
            }
        }

        public void save() {
            DMXFadeDescription o_DMXFadeDescription;
            if (this.m_LiveShowDMXObject == null) {
                return;
            }
            if (this.m_DMXScene == null) {
                return;
            }
            if (this.m_DMXDevice == null) {
                return;
            }
            if (this.m_DMXControlComponent == null) {
                return;
            }
            if (LiveShowDMXSystem.getLiveShowDMXVIP() == null) {
                return;
            }
            DMXFadeDescription.DMXControlTypeFadeDescription o_DMXControlTypeFadeDescription_Self = this.m_DMXControlTypeFadeDescription;
            if (o_DMXControlTypeFadeDescription_Self != null && (o_DMXFadeDescription = this.m_LiveShowDMXObject.getDMXFadeDescription()) != null) {
                DMXFadeDescription.DMXControlTypeFadeDescription o_DMXControlTypeFadeDescription = o_DMXFadeDescription.getDMXControlTypeFadeDescription(this.m_DMXDevice.getID(), this.m_DMXControlComponent.getDMXControlType().getID());
                o_DMXControlTypeFadeDescription_Self.copyTo(o_DMXControlTypeFadeDescription);
            }
            for (int intDimension = 0; intDimension < this.m_DMXControlDisplayLabel.getControlDimensionsCount(); ++intDimension) {
                JTextFieldBytePanel o_JTextFieldBytePanel;
                DMXScene.DMXSceneDeviceSectorValues o_DMXSceneDeviceSectorValues;
                DMXScene.DMXSceneDeviceValues o_DMXSceneDeviceValues;
                DMXScene.DMXSceneValueContainer o_DMXSceneValueContainer;
                DMXControlComponent.DeviceControlLink o_DeviceControlLink;
                ControlObject.ControlDimension o_ControlDimension = this.m_DMXControlDisplayLabel.getControlDimension(intDimension);
                if (o_ControlDimension == null || (o_DeviceControlLink = this.m_DMXControlComponent.findDeviceControlLink(this.m_DMXDevice, o_ControlDimension)) == null || (o_DMXSceneValueContainer = this.m_DMXScene.getDMXSceneValueContainer()) == null || (o_DMXSceneDeviceValues = o_DMXSceneValueContainer.getDMXSceneDeviceValues(this.m_DMXDevice.getID())) == null || (o_DMXSceneDeviceSectorValues = o_DMXSceneDeviceValues.getDMXSceneDeviceSectorValues(o_DeviceControlLink.getDMXDeviceSectorIndex())) == null || (o_JTextFieldBytePanel = this.getJTextFieldBytePanel(intDimension)) == null) continue;
                for (int intByte = 0; intByte < o_DeviceControlLink.getByteResolution(); ++intByte) {
                    o_DMXSceneDeviceSectorValues.setDeviceValue(o_DeviceControlLink.getDeviceInternalChannel(intByte), o_JTextFieldBytePanel.getValue(intByte));
                }
                if (!(this.m_DMXControlComponent instanceof DMXControl_GridPanTilt)) continue;
                o_DMXSceneDeviceValues.setPanTilt_VirtualPointFromAngles();
            }
            this.refreshDMXSceneDMXDevice();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void refreshDMXSceneDMXDevice() {
            LiveShowDMXObject o_LiveShowDMXObject = this.m_LiveShowDMXObject;
            DMXScene o_DMXScene = this.m_DMXScene;
            DMXDevice o_DMXDevice = this.m_DMXDevice;
            DMXControlComponent o_DMXControlComponent = this.m_DMXControlComponent;
            DMXFadeDescription.DMXControlTypeFadeDescription o_DMXControlTypeFadeDescription = this.m_DMXControlTypeFadeDescription;
            DMXControlDisplayLabel o_DMXControlDisplayLabel = this.m_DMXControlDisplayLabel;
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (o_LiveShowDMXObject != null && o_DMXScene != null && o_DMXDevice != null && o_DMXControlComponent != null && o_DMXControlDisplayLabel != null) {
                    o_DMXControlComponent.refreshDisplay_Foreign(o_DMXControlDisplayLabel, o_DMXDevice, o_DMXScene);
                    for (int intDimension = 0; intDimension < o_DMXControlDisplayLabel.getControlDimensionsCount() && intDimension < this.m_Values.size(); ++intDimension) {
                        this.m_Values.set(intDimension, o_DMXControlDisplayLabel.getValue(intDimension));
                    }
                    if (o_DMXControlTypeFadeDescription != null) {
                        DMXFadeDescription.DMXControlTypeFadeDescription o_DMXControlTypeFadeDescription_Copy;
                        DMXFadeDescription o_DMXFadeDescription_Copy = o_LiveShowDMXObject.getDMXFadeDescription();
                        if (o_DMXFadeDescription_Copy != null && (o_DMXControlTypeFadeDescription_Copy = o_DMXFadeDescription_Copy.getDMXControlTypeFadeDescription(o_DMXDevice.getID(), o_DMXControlComponent.getDMXControlType().getID())) != null) {
                            o_DMXControlTypeFadeDescription_Copy.copyTo(o_DMXControlTypeFadeDescription);
                        }
                        if (o_DMXControlTypeFadeDescription.getDisabled()) {
                            o_DMXControlDisplayLabel.setDeactivated(true);
                            this.m_CheckBox_Deactivated.setSelected(true);
                        } else {
                            o_DMXControlDisplayLabel.setDeactivated(false);
                            this.m_CheckBox_Deactivated.setSelected(false);
                        }
                    }
                }
            }
            this.setCopyFlag(0);
            this.setValuesChanged(false);
            this.refreshGUI();
        }

        private void refreshValuesSet() {
            this.refreshValuesSet(this.indexOf(this.m_LastSetControlDimension));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void refreshValuesSet(int p_ChangedIndex) {
            DMXControlDisplayLabel o_DMXControlDisplayLabel = this.m_DMXControlDisplayLabel;
            DMXControlComponent o_DMXControlComponent = this.m_DMXControlComponent;
            if (o_DMXControlDisplayLabel != null && o_DMXControlComponent != null) {
                ControlLabelModel.ControlLabelList o_ControlLabelList = this.getControlLabelListSelected(o_DMXControlDisplayLabel.getControlDimension(0));
                Object object = this.m_SyncObject;
                synchronized (object) {
                    this.m_DMXControlComponent.refreshDisplay_Foreign(o_DMXControlDisplayLabel, o_ControlLabelList, this.m_Values, p_ChangedIndex);
                    for (int intDimension = 0; intDimension < o_DMXControlDisplayLabel.getControlDimensionsCount() && intDimension < this.m_Values.size(); ++intDimension) {
                        this.m_Values.set(intDimension, o_DMXControlDisplayLabel.getValue(intDimension));
                    }
                }
            }
            this.refreshGUI();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void refreshGUI() {
            LiveShowDMXObject o_LiveShowDMXObject = this.m_LiveShowDMXObject;
            DMXControlDisplayLabel o_DMXControlDisplayLabel = this.m_DMXControlDisplayLabel;
            DMXControlComponent o_DMXControlComponent = this.m_DMXControlComponent;
            DMXFadeDescription.DMXControlTypeFadeDescription o_DMXControlTypeFadeDescription = this.m_DMXControlTypeFadeDescription;
            DMXFadeDescriptionPanel o_DMXFadeDescriptionPanel = this.m_DMXFadeDescriptionPanel;
            if (this.m_LiveShowDMXObject == null || this.m_DMXControlComponent == null) {
                Object object = this.m_SyncObject;
                synchronized (object) {
                    for (int intTextField = 0; intTextField < this.m_JTextFieldBytePanels.size(); ++intTextField) {
                        JTextFieldBytePanel o_JTextFieldBytePanel = this.m_JTextFieldBytePanels.get(intTextField);
                        o_JTextFieldBytePanel.setValue(0.0);
                        o_JTextFieldBytePanel.setVisible(false);
                    }
                }
                if (o_DMXControlDisplayLabel != null) {
                    o_DMXControlDisplayLabel.setVisible(false);
                }
                this.m_JLabel_DMXControlName.setVisible(false);
                this.m_CheckBox_Deactivated.setVisible(false);
                if (o_DMXFadeDescriptionPanel != null) {
                    o_DMXFadeDescriptionPanel.setVisible(false);
                }
                this.setVisible(false);
            } else {
                Object object = this.m_SyncObject;
                synchronized (object) {
                    if (o_DMXControlComponent != null) {
                        this.m_JLabel_DMXControlName.setText(o_DMXControlComponent.getName());
                    } else {
                        this.m_JLabel_DMXControlName.setText("");
                    }
                    if (o_DMXControlDisplayLabel != null) {
                        for (int intDimension = 0; intDimension < this.m_Values.size(); ++intDimension) {
                            JLabel o_JTextFieldLabel;
                            JTextFieldBytePanel o_JTextFieldBytePanel;
                            ControlObject.ControlDimension o_ControlDimension = o_DMXControlDisplayLabel.getControlDimension(intDimension);
                            if (intDimension >= this.m_JTextFieldBytePanels.size()) {
                                int intGridY;
                                int intGridX;
                                if (intDimension >= 3) {
                                    intGridX = 2;
                                    intGridY = intDimension - 3;
                                } else {
                                    intGridX = 0;
                                    intGridY = intDimension;
                                }
                                o_JTextFieldBytePanel = new JTextFieldBytePanel();
                                this.m_JTextFieldBytePanels.add(o_JTextFieldBytePanel);
                                o_JTextFieldLabel = new JLabel();
                                o_JTextFieldLabel.setForeground(Color.WHITE);
                                this.m_JTextFieldLabels.add(o_JTextFieldLabel);
                                GridBagConstraints o_GridBagConstraints = new GridBagConstraints();
                                o_GridBagConstraints.gridx = intGridX;
                                o_GridBagConstraints.gridy = intGridY;
                                o_GridBagConstraints.weightx = 0.0;
                                o_GridBagConstraints.anchor = 13;
                                o_GridBagConstraints.insets = new Insets(0, 3, 0, 3);
                                this.m_JPanel_TextFields.add((Component)o_JTextFieldLabel, o_GridBagConstraints);
                                o_GridBagConstraints = new GridBagConstraints();
                                o_GridBagConstraints.gridx = intGridX + 1;
                                o_GridBagConstraints.gridy = intGridY;
                                o_GridBagConstraints.weightx = 1.0;
                                o_GridBagConstraints.fill = 2;
                                this.m_JPanel_TextFields.add((Component)o_JTextFieldBytePanel, o_GridBagConstraints);
                                o_JTextFieldBytePanel.addPropertyChangeListener((PropertyChangeListener)this);
                            }
                            o_JTextFieldBytePanel = this.m_JTextFieldBytePanels.get(intDimension);
                            o_JTextFieldLabel = this.m_JTextFieldLabels.get(intDimension);
                            if (o_ControlDimension != null) {
                                o_JTextFieldLabel.setText(o_ControlDimension.getDimensionName());
                                o_JTextFieldLabel.setVisible(true);
                                o_JTextFieldBytePanel.setValueSourceObject((Object)o_ControlDimension);
                                o_JTextFieldBytePanel.setLabelString(null);
                                o_JTextFieldBytePanel.setOnlyIntegerValues(true);
                                o_JTextFieldBytePanel.setValueRange(o_ControlDimension.getValueMinimum(), o_ControlDimension.getValueMaximum());
                                o_JTextFieldBytePanel.setVisible(true);
                                o_JTextFieldBytePanel.setValue(this.m_Values.get(intDimension).doubleValue());
                                continue;
                            }
                            o_JTextFieldLabel.setText("");
                            o_JTextFieldLabel.setVisible(false);
                            o_JTextFieldBytePanel.setValueSourceObject(null);
                            o_JTextFieldBytePanel.setLabelString(null);
                            o_JTextFieldBytePanel.setValue(0.0);
                            o_JTextFieldBytePanel.setVisible(false);
                        }
                    }
                }
                if (o_DMXControlTypeFadeDescription != null) {
                    this.m_CheckBox_Deactivated.setSelected(o_DMXControlTypeFadeDescription.getDisabled());
                }
                if (o_DMXControlDisplayLabel != null) {
                    o_DMXControlDisplayLabel.setVisible(true);
                }
                this.m_JLabel_DMXControlName.setVisible(true);
                this.m_CheckBox_Deactivated.setVisible(true);
                if (o_DMXFadeDescriptionPanel != null) {
                    o_DMXFadeDescriptionPanel.setVisible(true);
                    o_DMXFadeDescriptionPanel.refresh();
                    if (this.m_DMXTrackingObjectEditPanel.getShowDetails()) {
                        o_DMXFadeDescriptionPanel.setVisible(true);
                        this.m_CheckBox_Deactivated.setVisible(false);
                    } else {
                        o_DMXFadeDescriptionPanel.setVisible(false);
                        this.m_CheckBox_Deactivated.setVisible(true);
                    }
                }
                this.setVisible(true);
            }
        }

        public void setCopyModeOn(boolean p_CopyModeOn) {
            this.m_CopyModeOn = p_CopyModeOn;
            if (this.m_CopyModeOn) {
                // empty if block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public JTextFieldBytePanel getJTextFieldBytePanel(int p_Index) {
            if (p_Index < 0) {
                return null;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (p_Index >= this.m_JTextFieldBytePanels.size()) {
                    return null;
                }
                return this.m_JTextFieldBytePanels.get(p_Index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setDMXControlComponent(LiveShowObject p_LiveShowObject, DMXScene p_DMXScene, DMXDevice p_DMXDevice, DMXControlComponent p_DMXControlComponent) {
            Object object = this.m_SyncObject;
            synchronized (object) {
                this.m_LiveShowDMXObject = p_LiveShowObject instanceof LiveShowDMXObject ? (LiveShowDMXObject)p_LiveShowObject : null;
                this.m_DMXScene = p_DMXScene;
                this.m_DMXDevice = p_DMXDevice;
                this.m_DMXControlComponent = p_DMXControlComponent;
                if (this.m_DMXControlTypeFadeDescription != null) {
                    this.m_DMXControlTypeFadeDescription.removePropertyChangeListener(this);
                }
                this.m_DMXFadeDescriptionPanel.clearDMXControlTypeFadeDescriptions();
                DMXFadeDescription.DMXDeviceFadeDescription o_DMXDeviceFadeDescription = this.m_DMXTrackingObjectEditPanel.getDMXDeviceFadeDescription();
                if (o_DMXDeviceFadeDescription != null && this.m_DMXControlComponent != null) {
                    this.m_DMXControlTypeFadeDescription = o_DMXDeviceFadeDescription.getDMXControlTypeFadeDescription(this.m_DMXControlComponent.getDMXControlType().getID());
                    this.m_DMXFadeDescriptionPanel.addDMXControlTypeFadeDescription(this.m_DMXControlTypeFadeDescription);
                    if (this.m_DMXControlTypeFadeDescription != null) {
                        this.m_DMXControlTypeFadeDescription.addPropertyChangeListener(this);
                    }
                } else {
                    this.m_DMXControlTypeFadeDescription = null;
                }
                if (this.m_DMXControlComponent == null) {
                    this.m_Values.clear();
                } else {
                    for (int intControl = 0; intControl < this.m_DMXControlComponent.getControlObjectCount(); ++intControl) {
                        ControlObject o_ControlObject = this.m_DMXControlComponent.getControlObject(intControl);
                        for (int intDimension = 0; intDimension < o_ControlObject.getControlDimensionCount(); ++intDimension) {
                            this.m_Values.add(0.0);
                        }
                    }
                }
            }
            this.refreshDMXSceneDMXDevice();
        }

        public DMXControlComponent getDMXControlComponent() {
            return this.m_DMXControlComponent;
        }

        public int indexOf(JTextFieldBytePanel p_JTextFieldBytePanel) {
            if (p_JTextFieldBytePanel == null) {
                return -1;
            }
            return this.m_JTextFieldBytePanels.indexOf(p_JTextFieldBytePanel);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() instanceof JTextFieldBytePanel) {
                JTextFieldBytePanel o_JTextFieldBytePanel = (JTextFieldBytePanel)evt.getSource();
                if ("valueChanged".equals(evt.getPropertyName()) && o_JTextFieldBytePanel.getValueSourceObject() instanceof ControlObject.ControlDimension) {
                    ControlObject.ControlDimension o_ControlDimension = (ControlObject.ControlDimension)o_JTextFieldBytePanel.getValueSourceObject();
                    int intIndex = this.indexOf(o_JTextFieldBytePanel);
                    if (intIndex < 0 || intIndex >= this.m_Values.size()) {
                        return;
                    }
                    this.setValue(intIndex, o_JTextFieldBytePanel.getValue());
                    this.setCopyFlag(0);
                    this.refreshValuesSet(intIndex);
                }
            }
            if (evt.getSource() instanceof DMXFadeDescription.DMXControlTypeFadeDescription && "paramsChanged".equals(evt.getPropertyName())) {
                this.setValuesChanged(true);
                this.m_DMXTrackingObjectEditPanel.refreshButtonSaveCancel();
                this.refreshGUI();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setValuesSelected(ArrayList<Double> p_Values, ArrayList<ControlObject.ControlDimension> p_ControlDimensions) {
            if (p_Values == null) {
                return;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                for (int intValue = 0; intValue < p_Values.size() && intValue < this.m_DMXControlDisplayLabel.getControlDimensionsCount(); ++intValue) {
                    this.setValue(intValue, (double)p_Values.get(intValue));
                }
            }
            this.setValuesChanged(true);
            this.setCopyFlag(0);
            this.refreshValuesSet(0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkDeactivated() {
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (this.m_DMXControlTypeFadeDescription == null) {
                    return;
                }
                boolean boolIsDeactivated = this.m_DMXControlTypeFadeDescription.getDisabled();
                if (this.m_CheckBox_Deactivated.isSelected() != boolIsDeactivated) {
                    this.m_DMXControlTypeFadeDescription.setDisabled(this.m_CheckBox_Deactivated.isSelected());
                }
            }
        }

        public DMXFadeDescription.DMXControlTypeFadeDescription getValueFadeDescription() {
            return this.m_DMXControlTypeFadeDescription;
        }

        public void setValueFadeDescription(DMXFadeDescription.DMXControlTypeFadeDescription p_DMXControlTypeFadeDescription) {
            DMXFadeDescription.DMXControlTypeFadeDescription o_DMXControlTypeFadeDescription = this.m_DMXControlTypeFadeDescription;
            if (o_DMXControlTypeFadeDescription == null) {
                return;
            }
            p_DMXControlTypeFadeDescription.copyTo(o_DMXControlTypeFadeDescription);
            this.m_DMXFadeDescriptionPanel.refresh();
            this.m_CheckBox_Deactivated.setSelected(o_DMXControlTypeFadeDescription.getDisabled());
            this.checkDeactivated();
        }

        public ArrayList<Double> getValues() {
            return this.m_Values;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public double getValue(ControlObject.ControlDimension p_ControlDimension) {
            DMXControlDisplayLabel o_DMXControlDisplayLabel = this.m_DMXControlDisplayLabel;
            if (o_DMXControlDisplayLabel == null) {
                return 0.0;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                int intIndex = o_DMXControlDisplayLabel.getIndexOf(p_ControlDimension);
                if (intIndex < 0 || intIndex >= this.m_Values.size()) {
                    return 0.0;
                }
                return this.m_Values.get(intIndex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean setValue(ControlObject.ControlDimension p_ControlDimension, double p_Value) {
            DMXControlDisplayLabel o_DMXControlDisplayLabel = this.m_DMXControlDisplayLabel;
            if (o_DMXControlDisplayLabel == null) {
                return false;
            }
            if (p_Value < 0.0) {
                return false;
            }
            if (p_Value > p_ControlDimension.getValueMaximum()) {
                return false;
            }
            int intIndex = o_DMXControlDisplayLabel.getIndexOf(p_ControlDimension);
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (intIndex < 0 || intIndex >= this.m_Values.size()) {
                    return false;
                }
                this.m_LastSetControlDimension = p_ControlDimension;
                if (this.m_Values.get(intIndex) != p_Value) {
                    this.m_Values.set(intIndex, p_Value);
                    this.setValuesChanged(true);
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean setValue(int p_Index, double p_Value) {
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (p_Index < 0 || p_Index >= this.m_Values.size()) {
                    return false;
                }
                if (this.m_Values.get(p_Index) != p_Value) {
                    this.m_Values.set(p_Index, p_Value);
                    this.setValuesChanged(true);
                }
            }
            return true;
        }

        public void setCopyFlag(int p_CopyFlag) {
            switch (p_CopyFlag) {
                case 0: {
                    this.m_CopyLabel.setIcon(null);
                    this.m_CopyLabel.setVisible(false);
                    break;
                }
                case 1: {
                    this.m_CopyLabel.setIcon(s_IconCopyOk);
                    this.m_CopyLabel.setVisible(true);
                    break;
                }
                case 2: {
                    this.m_CopyLabel.setIcon(s_IconCopyUncertain);
                    this.m_CopyLabel.setVisible(true);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int indexOf(ControlObject.ControlDimension p_ControlDimension) {
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (this.m_DMXControlDisplayLabel == null) {
                    return -1;
                }
                return this.m_DMXControlDisplayLabel.getIndexOf(p_ControlDimension);
            }
        }

        private void setValuesChanged(boolean p_ValuesChanged) {
            if (this.m_ValuesChanged == p_ValuesChanged) {
                return;
            }
            this.m_ValuesChanged = p_ValuesChanged;
            this.m_DMXTrackingObjectEditPanel.refreshButtonSaveCancel();
        }

        public boolean getValuesChanged() {
            return this.m_ValuesChanged;
        }

        public ControlLabelModel.ControlLabelList getControlLabelListSelected(ControlObject.ControlDimension p_ControlDimension) {
            return this.m_DMXTrackingObjectEditPanel.findControlLabelList(p_ControlDimension);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void showValueSelection(int p_XOnScreen, int p_YOnScreen) {
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (this.m_DMXControlComponent != null) {
                    this.m_DMXControlComponent.showValueSelection(this, p_XOnScreen, p_YOnScreen);
                }
            }
        }
    }
}

