/*
 * Decompiled with CFR 0.152.
 */
package DMXEffectsPackage;

import DMXEffectsPackage.DMXEffect;
import DMXVirtualPackage.LiveShowDMXObject;
import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LanguageTools.LiveLanguagePackage.LiveLanguageString;
import LiveShowObjectPackage.LiveShowObjectDescription;
import LiveShowObjectPackage.LiveShowObjectInterface;
import LiveShowObjectPackage.LiveShowObjectListener;
import LiveShowVirtualPackage.LiveShowVIP;
import SwingTextPackage.DocumentFilter_Integer;
import SwingTextPackage.DocumentFilter_Time;
import SwingToolTipPackage.PopUpToolTip;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class LiveShowDMXObjectEffectSettingsPanel
extends LiveShowObjectInterface.EffectPanel
implements LiveShowObjectListener,
DocumentListener,
FocusListener {
    @LiveLanguageString
    protected String m_Header;
    protected LiveShowObjectInterface.EffectPanelContainer m_EffectPanelContainer;
    protected LiveShowDMXObject m_LiveShowDMXObject;
    protected boolean m_InternalChange;
    protected boolean m_DMXEffectManuallySet;
    protected boolean m_DelayManuallySet;
    protected boolean m_DurationManuallySet;
    protected boolean m_LoopsManuallySet;
    protected boolean m_TriggerManuallySet;
    protected boolean m_Changed_DMXEffect;
    protected KeyAdapter m_KeyAdapter;
    private ButtonGroup buttonGroup_Trigger;
    private JButton jButton_Resize;
    private JComboBox<DMXEffect> jComboBox_DMXEffects;
    private JLabel jLabel_DMXEffectDelay;
    private JLabel jLabel_DMXEffectDuration;
    private JLabel jLabel_DMXEffectLoops;
    private JLabel jLabel_DMXEffectLoops_Remark;
    private JLabel jLabel_Trigger;
    private JPanel jPanel_Trigger;
    private JRadioButton jRadioButton_TriggerExtra;
    private JRadioButton jRadioButton_TriggerTimeline;
    private JTextField jTextField_DMXEffectDelay;
    private JTextField jTextField_DMXEffectDuration;
    private JTextField jTextField_DMXEffectLoops;

    public LiveShowDMXObjectEffectSettingsPanel() {
        this.initMembers();
        this.initComponents();
        this.initComponentsFurther();
        LiveLanguage.addLanguageListener((Object)this, null);
    }

    private void initMembers() {
        this.m_Header = "Effect";
        this.m_InternalChange = true;
        this.m_Changed_DMXEffect = false;
        this.m_DMXEffectManuallySet = false;
        this.m_DelayManuallySet = false;
        this.m_DurationManuallySet = false;
        this.m_LoopsManuallySet = false;
        this.m_TriggerManuallySet = false;
    }

    private void initComponents() {
        this.buttonGroup_Trigger = new ButtonGroup();
        this.jComboBox_DMXEffects = new JComboBox();
        this.jLabel_DMXEffectDuration = new JLabel();
        this.jTextField_DMXEffectDuration = new JTextField();
        this.jLabel_DMXEffectLoops = new JLabel();
        this.jTextField_DMXEffectLoops = new JTextField();
        this.jLabel_DMXEffectLoops_Remark = new JLabel();
        this.jButton_Resize = new JButton();
        this.jPanel_Trigger = new JPanel();
        this.jRadioButton_TriggerTimeline = new JRadioButton();
        this.jRadioButton_TriggerExtra = new JRadioButton();
        this.jLabel_Trigger = new JLabel();
        this.jLabel_DMXEffectDelay = new JLabel();
        this.jTextField_DMXEffectDelay = new JTextField();
        this.setBackground(new Color(255, 255, 204));
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(100, 25));
        this.setLayout(new GridBagLayout());
        this.jComboBox_DMXEffects.setToolTipText("Select a DMXEffect");
        this.jComboBox_DMXEffects.setMinimumSize(new Dimension(28, 24));
        this.jComboBox_DMXEffects.setPreferredSize(new Dimension(28, 24));
        this.jComboBox_DMXEffects.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowDMXObjectEffectSettingsPanel.this.jComboBox_DMXEffectsActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add(this.jComboBox_DMXEffects, gridBagConstraints);
        this.jLabel_DMXEffectDuration.setForeground(new Color(255, 255, 255));
        this.jLabel_DMXEffectDuration.setText("Duration");
        this.jLabel_DMXEffectDuration.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jLabel_DMXEffectDuration, gridBagConstraints);
        this.jTextField_DMXEffectDuration.setFont(new Font("Tahoma", 0, 12));
        this.jTextField_DMXEffectDuration.setHorizontalAlignment(0);
        this.jTextField_DMXEffectDuration.setToolTipText("Enter the duration in milliseconds of the effect for one loop");
        this.jTextField_DMXEffectDuration.setMinimumSize(new Dimension(85, 20));
        this.jTextField_DMXEffectDuration.setPreferredSize(new Dimension(85, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jTextField_DMXEffectDuration, gridBagConstraints);
        this.jLabel_DMXEffectLoops.setForeground(new Color(255, 255, 255));
        this.jLabel_DMXEffectLoops.setText("Loops");
        this.jLabel_DMXEffectLoops.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jLabel_DMXEffectLoops, gridBagConstraints);
        this.jTextField_DMXEffectLoops.setFont(new Font("Tahoma", 0, 12));
        this.jTextField_DMXEffectLoops.setHorizontalAlignment(0);
        this.jTextField_DMXEffectLoops.setText("0");
        this.jTextField_DMXEffectLoops.setToolTipText("<html>Enter the amount of loops.<br>0 = the effect loops infinitely.</html>");
        this.jTextField_DMXEffectLoops.setMinimumSize(new Dimension(85, 20));
        this.jTextField_DMXEffectLoops.setPreferredSize(new Dimension(85, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jTextField_DMXEffectLoops, gridBagConstraints);
        this.jLabel_DMXEffectLoops_Remark.setForeground(new Color(255, 255, 255));
        this.jLabel_DMXEffectLoops_Remark.setText("0 = repeat infinity");
        this.jLabel_DMXEffectLoops_Remark.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jLabel_DMXEffectLoops_Remark, gridBagConstraints);
        this.jButton_Resize.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Edit_Adjust.png")));
        this.jButton_Resize.setToolTipText("<html>Set the length of the object<br>to match the length of the effect</html>");
        this.jButton_Resize.setBorderPainted(false);
        this.jButton_Resize.setContentAreaFilled(false);
        this.jButton_Resize.setMargin(new Insets(2, 5, 2, 5));
        this.jButton_Resize.setMaximumSize(new Dimension(64, 32));
        this.jButton_Resize.setMinimumSize(new Dimension(64, 32));
        this.jButton_Resize.setPreferredSize(new Dimension(64, 32));
        this.jButton_Resize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowDMXObjectEffectSettingsPanel.this.jButton_ResizeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 1;
        this.add((Component)this.jButton_Resize, gridBagConstraints);
        this.jPanel_Trigger.setOpaque(false);
        this.jPanel_Trigger.setLayout(new GridBagLayout());
        this.buttonGroup_Trigger.add(this.jRadioButton_TriggerTimeline);
        this.jRadioButton_TriggerTimeline.setForeground(new Color(255, 255, 255));
        this.jRadioButton_TriggerTimeline.setText("Timeline");
        this.jRadioButton_TriggerTimeline.setOpaque(false);
        this.jRadioButton_TriggerTimeline.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowDMXObjectEffectSettingsPanel.this.jRadioButton_TriggerTimelineActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.jPanel_Trigger.add((Component)this.jRadioButton_TriggerTimeline, gridBagConstraints);
        this.buttonGroup_Trigger.add(this.jRadioButton_TriggerExtra);
        this.jRadioButton_TriggerExtra.setForeground(new Color(255, 255, 255));
        this.jRadioButton_TriggerExtra.setText("Extra");
        this.jRadioButton_TriggerExtra.setOpaque(false);
        this.jRadioButton_TriggerExtra.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowDMXObjectEffectSettingsPanel.this.jRadioButton_TriggerExtraActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel_Trigger.add((Component)this.jRadioButton_TriggerExtra, gridBagConstraints);
        this.jLabel_Trigger.setForeground(new Color(255, 255, 255));
        this.jLabel_Trigger.setText("Trigger");
        this.jLabel_Trigger.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.jPanel_Trigger.add((Component)this.jLabel_Trigger, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jPanel_Trigger, gridBagConstraints);
        this.jLabel_DMXEffectDelay.setForeground(new Color(255, 255, 255));
        this.jLabel_DMXEffectDelay.setText("Delay");
        this.jLabel_DMXEffectDelay.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jLabel_DMXEffectDelay, gridBagConstraints);
        this.jTextField_DMXEffectDelay.setFont(new Font("Tahoma", 0, 12));
        this.jTextField_DMXEffectDelay.setHorizontalAlignment(0);
        this.jTextField_DMXEffectDelay.setToolTipText("Enter the delay in Milliseconds when the effect should start");
        this.jTextField_DMXEffectDelay.setMinimumSize(new Dimension(85, 20));
        this.jTextField_DMXEffectDelay.setPreferredSize(new Dimension(85, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jTextField_DMXEffectDelay, gridBagConstraints);
    }

    @Override
    public String getHeader() {
        return this.m_Header;
    }

    private void jComboBox_DMXEffectsActionPerformed(ActionEvent evt) {
        this.changeDMXEffect();
    }

    private void jButton_ResizeActionPerformed(ActionEvent evt) {
        long longLoops;
        if (this.m_LiveShowDMXObject == null) {
            return;
        }
        if (this.m_EffectPanelContainer == null) {
            return;
        }
        DMXEffect o_DMXEffect = (DMXEffect)this.jComboBox_DMXEffects.getSelectedItem();
        if (o_DMXEffect == null) {
            return;
        }
        try {
            longLoops = Long.valueOf(this.jTextField_DMXEffectLoops.getText());
        }
        catch (Exception e) {
            longLoops = 0L;
        }
        if (longLoops == 0L) {
            longLoops = 1L;
        }
        if (this.m_EffectPanelContainer != null && this.m_EffectPanelContainer.getSelectedUnit() == 1) {
            long longValue;
            try {
                longValue = Long.parseLong(this.jTextField_DMXEffectDelay.getText());
                longValue += Long.parseLong(this.jTextField_DMXEffectDuration.getText());
            }
            catch (Exception e) {
                longValue = this.m_LiveShowDMXObject.getDMXEffectDelay() + this.m_LiveShowDMXObject.getDMXEffectDuration() * longLoops;
            }
            this.m_EffectPanelContainer.setObjectLengthToEffectLength(longValue);
        } else {
            long longValue = (long)((double)DocumentFilter_Time.getMillisecondsFromString(this.jTextField_DMXEffectDelay.getText()) / LiveShowVIP.FRAMETIME);
            this.m_EffectPanelContainer.setObjectLengthToEffectLength(longValue += (long)((double)DocumentFilter_Time.getMillisecondsFromString(this.jTextField_DMXEffectDuration.getText()) / LiveShowVIP.FRAMETIME) * longLoops);
        }
    }

    private void jRadioButton_TriggerTimelineActionPerformed(ActionEvent evt) {
        this.changeTrigger(0);
    }

    private void jRadioButton_TriggerExtraActionPerformed(ActionEvent evt) {
        this.changeTrigger(1);
    }

    private void initComponentsFurther() {
        this.m_KeyAdapter = new KeyAdapter(){
            long longValue;

            @Override
            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 10) {
                    LiveShowDMXObjectEffectSettingsPanel.this.correctText(evt.getSource());
                }
            }
        };
        this.jComboBox_DMXEffects.setModel(DMXEffect.getDMXEffectListModel());
        this.jComboBox_DMXEffects.setRenderer(DMXEffect.getDMXEffectListRenderer());
        DocumentFilter_Time o_DocumentFilter_Time = new DocumentFilter_Time(this.jTextField_DMXEffectDelay);
        this.jTextField_DMXEffectDelay.setText(String.valueOf(DMXEffect.s_DefaultEffectDelay));
        this.jTextField_DMXEffectDelay.getDocument().addDocumentListener(this);
        this.jTextField_DMXEffectDelay.addKeyListener(this.m_KeyAdapter);
        this.jTextField_DMXEffectDelay.addFocusListener(this);
        o_DocumentFilter_Time = new DocumentFilter_Time(this.jTextField_DMXEffectDuration);
        this.jTextField_DMXEffectDuration.setText(DocumentFilter_Time.getTimeStringFromMillis((long)((double)DMXEffect.s_DefaultEffectDuration * LiveShowVIP.FRAMETIME)));
        this.jTextField_DMXEffectDuration.getDocument().addDocumentListener(this);
        this.jTextField_DMXEffectDuration.addKeyListener(this.m_KeyAdapter);
        this.jTextField_DMXEffectDuration.addFocusListener(this);
        this.jTextField_DMXEffectLoops.setText(String.valueOf(DMXEffect.s_DefaultEffectLoops));
        DocumentFilter_Integer o_DocumentFilter_Integer = new DocumentFilter_Integer(this.jTextField_DMXEffectLoops);
        o_DocumentFilter_Integer.setAllowNegativeNumbers(false);
        this.jTextField_DMXEffectLoops.addKeyListener(this.m_KeyAdapter);
        this.jTextField_DMXEffectLoops.addFocusListener(this);
        this.jTextField_DMXEffectLoops.getDocument().addDocumentListener(this);
        this.jPanel_Trigger.setVisible(false);
        this.jTextField_DMXEffectDelay.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jTextField_DMXEffectDuration.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jTextField_DMXEffectLoops.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_Resize.setComponentPopupMenu(PopUpToolTip.getSelfReference());
    }

    @Override
    public void setLiveShowObject(LiveShowObjectInterface p_LiveShowObjectInterface) {
        if (p_LiveShowObjectInterface == null) {
            return;
        }
        if (!(p_LiveShowObjectInterface instanceof LiveShowDMXObject)) {
            return;
        }
        if (this.m_LiveShowDMXObject == p_LiveShowObjectInterface) {
            return;
        }
        this.m_DMXEffectManuallySet = false;
        this.m_DelayManuallySet = false;
        this.m_DurationManuallySet = false;
        this.m_LoopsManuallySet = false;
        this.m_TriggerManuallySet = false;
        if (this.m_LiveShowDMXObject != null) {
            this.m_LiveShowDMXObject.removeLiveShowObjectListener(this);
        }
        this.m_LiveShowDMXObject = (LiveShowDMXObject)p_LiveShowObjectInterface;
        if (this.m_LiveShowDMXObject != null) {
            this.m_LiveShowDMXObject.addLiveShowObjectListener(this);
        }
        this.refresh();
    }

    @Override
    public void setSelectedUnit(int p_SelectedUnit) {
        this.m_DelayManuallySet = false;
        this.m_DurationManuallySet = false;
        this.m_LoopsManuallySet = false;
        this.m_TriggerManuallySet = false;
        this.refresh();
    }

    @Override
    public void refresh() {
        DMXEffect o_DMXEffect;
        this.m_InternalChange = true;
        if (this.m_LiveShowDMXObject == null) {
            this.jComboBox_DMXEffects.setEnabled(false);
            this.jTextField_DMXEffectDelay.setEnabled(false);
            this.jTextField_DMXEffectDuration.setEnabled(false);
            this.jTextField_DMXEffectLoops.setEnabled(false);
            this.m_InternalChange = false;
            return;
        }
        this.jComboBox_DMXEffects.setEnabled(true);
        if (!this.m_DMXEffectManuallySet) {
            this.jComboBox_DMXEffects.setSelectedItem(this.m_LiveShowDMXObject.getDMXEffect());
        }
        this.m_Changed_DMXEffect = (o_DMXEffect = (DMXEffect)this.jComboBox_DMXEffects.getSelectedItem()) != this.m_LiveShowDMXObject.getDMXEffect();
        if (o_DMXEffect == null) {
            this.jTextField_DMXEffectDelay.setEnabled(false);
            this.jTextField_DMXEffectDuration.setEnabled(false);
            this.jTextField_DMXEffectLoops.setEnabled(false);
            this.jRadioButton_TriggerTimeline.setEnabled(false);
            this.jRadioButton_TriggerExtra.setEnabled(false);
        } else {
            long longValue;
            if (!this.m_DelayManuallySet) {
                longValue = this.m_LiveShowDMXObject.getDMXEffectDelay();
                if (this.m_EffectPanelContainer != null && this.m_EffectPanelContainer.getSelectedUnit() == 1) {
                    this.jTextField_DMXEffectDelay.setText(String.valueOf(longValue));
                } else {
                    this.jTextField_DMXEffectDelay.setText(DocumentFilter_Time.getTimeStringFromMillis((long)((double)longValue * LiveShowVIP.FRAMETIME)));
                }
                this.m_DelayManuallySet = false;
            }
            this.jTextField_DMXEffectDelay.setEnabled(true);
            if (!this.m_DurationManuallySet) {
                longValue = this.m_LiveShowDMXObject.getDMXEffectDuration();
                if (this.m_EffectPanelContainer != null && this.m_EffectPanelContainer.getSelectedUnit() == 1) {
                    this.jTextField_DMXEffectDuration.setText(String.valueOf(longValue));
                } else {
                    this.jTextField_DMXEffectDuration.setText(DocumentFilter_Time.getTimeStringFromMillis((long)((double)longValue * LiveShowVIP.FRAMETIME)));
                }
                this.m_DurationManuallySet = false;
            }
            this.jTextField_DMXEffectDuration.setEnabled(true);
            if (!this.m_LoopsManuallySet) {
                longValue = this.m_LiveShowDMXObject.getDMXEffectLoops();
                longValue = this.m_LiveShowDMXObject.setDMXEffectLoops(longValue);
                this.jTextField_DMXEffectLoops.setText(String.valueOf(longValue));
                this.m_LoopsManuallySet = false;
            }
            this.jTextField_DMXEffectLoops.setEnabled(true);
            if (!this.m_TriggerManuallySet) {
                longValue = DMXEffect.getTrigger(this.m_LiveShowDMXObject.getEffectParameters());
                if ((longValue = (long)DMXEffect.setTrigger(o_DMXEffect, (int)longValue, this.m_LiveShowDMXObject.getEffectParameters())) == 0L) {
                    this.jRadioButton_TriggerTimeline.setSelected(true);
                } else if (longValue == 1L) {
                    this.jRadioButton_TriggerExtra.setSelected(true);
                }
                this.m_TriggerManuallySet = false;
            }
            this.jRadioButton_TriggerTimeline.setEnabled(true);
            this.jRadioButton_TriggerExtra.setEnabled(true);
        }
        this.m_InternalChange = false;
        if (this.m_EffectPanelContainer != null) {
            this.m_EffectPanelContainer.eventEffectChanged(this.getChanged());
        }
    }

    private void changeDMXEffect() {
        DMXEffect o_DMXEffect = (DMXEffect)this.jComboBox_DMXEffects.getSelectedItem();
        if (this.m_LiveShowDMXObject != null) {
            if (o_DMXEffect != this.m_LiveShowDMXObject.getDMXEffect()) {
                this.m_Changed_DMXEffect = true;
                this.m_DMXEffectManuallySet = true;
            } else {
                this.m_Changed_DMXEffect = false;
                this.m_DMXEffectManuallySet = false;
            }
        }
        if (this.m_EffectPanelContainer != null) {
            this.m_EffectPanelContainer.eventEffectChanged(this.getChanged());
        }
        this.refresh();
    }

    @Override
    public void save() {
        if (this.getChanged()) {
            if (this.m_LiveShowDMXObject == null) {
                return;
            }
            if (this.m_Changed_DMXEffect) {
                DMXEffect o_DMXEffect = (DMXEffect)this.jComboBox_DMXEffects.getSelectedItem();
                this.m_LiveShowDMXObject.setDMXEffect(o_DMXEffect);
            }
            if (this.m_EffectPanelContainer != null && this.m_EffectPanelContainer.getSelectedUnit() == 1) {
                try {
                    if (this.m_DelayManuallySet) {
                        this.m_LiveShowDMXObject.setDMXEffectDelay(Long.parseLong(this.jTextField_DMXEffectDelay.getText()));
                    }
                    if (this.m_DurationManuallySet) {
                        this.m_LiveShowDMXObject.setDMXEffectDuration(Long.parseLong(this.jTextField_DMXEffectDuration.getText()));
                    }
                }
                catch (Exception exception) {}
            } else {
                if (this.m_DelayManuallySet) {
                    this.m_LiveShowDMXObject.setDMXEffectDelay((long)((double)DocumentFilter_Time.getMillisecondsFromString(this.jTextField_DMXEffectDelay.getText()) / LiveShowVIP.FRAMETIME));
                }
                if (this.m_DurationManuallySet) {
                    this.m_LiveShowDMXObject.setDMXEffectDuration((long)((double)DocumentFilter_Time.getMillisecondsFromString(this.jTextField_DMXEffectDuration.getText()) / LiveShowVIP.FRAMETIME));
                }
            }
            if (this.m_LoopsManuallySet) {
                long longValue;
                try {
                    longValue = Long.valueOf(this.jTextField_DMXEffectLoops.getText());
                }
                catch (Exception e) {
                    longValue = 0L;
                }
                this.m_LiveShowDMXObject.setDMXEffectLoops(longValue);
            }
            if (this.jRadioButton_TriggerTimeline.isSelected()) {
                this.m_LiveShowDMXObject.setDMXEffectTrigger(0);
            } else if (this.jRadioButton_TriggerExtra.isSelected()) {
                this.m_LiveShowDMXObject.setDMXEffectTrigger(1);
            }
        }
        this.m_DMXEffectManuallySet = false;
        this.m_DelayManuallySet = false;
        this.m_DurationManuallySet = false;
        this.m_LoopsManuallySet = false;
        this.m_TriggerManuallySet = false;
        this.refresh();
    }

    @Override
    public void cancel() {
        this.m_DMXEffectManuallySet = false;
        this.m_DelayManuallySet = false;
        this.m_DurationManuallySet = false;
        this.m_LoopsManuallySet = false;
        this.m_TriggerManuallySet = false;
        this.refresh();
    }

    public String getString(long p_Miliiseconds) {
        if (this.m_LiveShowDMXObject == null) {
            return "";
        }
        return DocumentFilter_Time.getTimeStringFromMillis(p_Miliiseconds);
    }

    @Override
    public boolean getChanged() {
        if (this.m_Changed_DMXEffect) {
            return true;
        }
        if (this.m_DelayManuallySet) {
            return true;
        }
        if (this.m_DurationManuallySet) {
            return true;
        }
        if (this.m_LoopsManuallySet) {
            return true;
        }
        return this.m_TriggerManuallySet;
    }

    @Override
    public void setEffectPanelContainer(LiveShowObjectInterface.EffectPanelContainer p_EffectPanelContainer) {
        this.m_EffectPanelContainer = p_EffectPanelContainer;
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.changedText(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.changedText(e);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.changedText(e);
    }

    private void changedText(DocumentEvent e) {
        if (this.m_LiveShowDMXObject == null) {
            return;
        }
        if (this.m_InternalChange) {
            return;
        }
        if (e.getDocument() == this.jTextField_DMXEffectDelay.getDocument()) {
            this.m_DelayManuallySet = true;
        } else if (e.getDocument() == this.jTextField_DMXEffectDuration.getDocument()) {
            this.m_DurationManuallySet = true;
        } else if (e.getDocument() == this.jTextField_DMXEffectLoops.getDocument()) {
            this.m_LoopsManuallySet = true;
        }
        if (this.m_EffectPanelContainer != null) {
            this.m_EffectPanelContainer.eventEffectChanged(this.getChanged());
        }
    }

    public void changeTrigger(int p_TriggerFlag) {
        if (DMXEffect.getTrigger(this.m_LiveShowDMXObject.getEffectParameters()) != p_TriggerFlag) {
            this.m_TriggerManuallySet = true;
        }
        if (this.m_EffectPanelContainer != null) {
            this.m_EffectPanelContainer.eventEffectChanged(this.getChanged());
        }
    }

    @Override
    public void eventObjectParameterChanged(LiveShowObjectInterface p_LiveShowObjectInterface, LiveShowObjectDescription p_LiveShowObjectDescription) {
        this.m_DelayManuallySet = false;
        this.m_DurationManuallySet = false;
        this.m_LoopsManuallySet = false;
        this.m_TriggerManuallySet = false;
        this.refresh();
    }

    @Override
    public void eventObjectVolumeChanged(LiveShowObjectInterface p_LiveShowObjectInterface, float p_Volume) {
    }

    @Override
    public void eventObjectAdditionalChanged(LiveShowObjectInterface p_LiveShowObjectInterface, LiveShowObjectDescription p_LiveShowObjectDescription) {
    }

    @Override
    public void eventObjectClosed(LiveShowObjectInterface p_LiveShowObjectInterface) {
        if (p_LiveShowObjectInterface == this.m_LiveShowDMXObject) {
            this.setLiveShowObject(null);
        }
    }

    @Override
    public void eventObjectSelection(LiveShowObjectInterface p_LiveShowObjectInterface, boolean p_IsSelected, boolean p_Added) {
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.correctText(e.getSource());
    }

    public void correctText(Object p_Object) {
        block26: {
            if (p_Object == null) {
                return;
            }
            LiveShowDMXObject o_LiveShowDMXObject = this.m_LiveShowDMXObject;
            if (p_Object == this.jTextField_DMXEffectDelay) {
                if (this.m_EffectPanelContainer != null && this.m_EffectPanelContainer.getSelectedUnit() == 1) {
                    try {
                        long longValue = Long.parseLong(this.jTextField_DMXEffectDelay.getText());
                        if (o_LiveShowDMXObject != null && longValue == o_LiveShowDMXObject.getDMXEffectDelay()) {
                            this.m_DelayManuallySet = false;
                        }
                    }
                    catch (Exception e) {
                        if (this.m_LiveShowDMXObject != null) {
                            this.jTextField_DMXEffectDelay.setText(String.valueOf(this.m_LiveShowDMXObject.getDMXEffectDelay()));
                        } else {
                            this.jTextField_DMXEffectDelay.setText("0");
                        }
                        this.m_DelayManuallySet = false;
                    }
                } else {
                    long longValue;
                    String stringNew;
                    String stringOld = this.jTextField_DMXEffectDelay.getText();
                    if (!stringOld.equals(stringNew = DocumentFilter_Time.getTimeStringFromMillis(longValue = DocumentFilter_Time.getMillisecondsFromString(this.jTextField_DMXEffectDelay.getText())))) {
                        this.jTextField_DMXEffectDelay.setText(stringNew);
                    }
                }
            } else if (p_Object == this.jTextField_DMXEffectDuration) {
                if (this.m_EffectPanelContainer != null && this.m_EffectPanelContainer.getSelectedUnit() == 1) {
                    try {
                        long longValue = Long.parseLong(this.jTextField_DMXEffectDuration.getText());
                        if (o_LiveShowDMXObject != null && longValue == o_LiveShowDMXObject.getDMXEffectDuration()) {
                            this.m_DurationManuallySet = false;
                        }
                    }
                    catch (Exception e) {
                        if (this.m_LiveShowDMXObject != null) {
                            this.jTextField_DMXEffectDuration.setText(String.valueOf(this.m_LiveShowDMXObject.getDMXEffectDuration()));
                            break block26;
                        }
                        this.jTextField_DMXEffectDuration.setText("0");
                    }
                } else {
                    long longValue;
                    String stringNew;
                    String stringOld = this.jTextField_DMXEffectDuration.getText();
                    if (!stringOld.equals(stringNew = DocumentFilter_Time.getTimeStringFromMillis(longValue = DocumentFilter_Time.getMillisecondsFromString(this.jTextField_DMXEffectDuration.getText())))) {
                        this.jTextField_DMXEffectDuration.setText(stringNew);
                    }
                }
            } else if (p_Object == this.jTextField_DMXEffectLoops) {
                long longValue;
                String stringOld = this.jTextField_DMXEffectLoops.getText();
                try {
                    longValue = Long.valueOf(this.jTextField_DMXEffectLoops.getText());
                }
                catch (Exception e) {
                    longValue = 0L;
                }
                String stringNew = String.valueOf(longValue);
                if (!stringOld.equals(stringNew)) {
                    this.jTextField_DMXEffectLoops.setText(stringNew);
                }
                if (o_LiveShowDMXObject != null && o_LiveShowDMXObject.getDMXEffectLoops() == longValue) {
                    this.m_LoopsManuallySet = false;
                    if (this.m_EffectPanelContainer != null) {
                        this.m_EffectPanelContainer.eventEffectChanged(this.getChanged());
                    }
                }
            }
        }
    }
}

