/*
 * Decompiled with CFR 0.152.
 */
package DMXEffectsPackage;

import DMXEffectsPackage.DMXEffect;
import DMXVirtualPackage.LiveShowDMXObject;
import DMXVirtualPackage.LiveShowDMXObjectPanel;
import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LiveShowObjectPackage.LiveShowObjectDescription;
import LiveShowObjectPackage.LiveShowObjectInterface;
import LiveShowObjectPackage.LiveShowUndo;
import LiveShowVirtualPackage.LiveShowVIP;
import SwingComponents.MouseAdapter_Delayed;
import SwingToolTipPackage.PopUpToolTip;
import SynchronizationPackage.EventQueueHandler;
import ToolsGraphics.GraphicsTools;
import ToolsGraphics.JLabelBackground;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class LiveShowDMXObjectEffectPanel
extends JPanel
implements PropertyChangeListener {
    public static int s_Height = 16;
    public static int s_MiddleLoopPosition = 8;
    public Color m_ColorBackground_Transparent;
    private LiveShowDMXObject m_LiveShowDMXObject;
    private LiveShowDMXObjectPanel m_LiveShowDMXObjectPanel;
    private DMXEffect m_DMXEffect;
    private AbsoluteConstraints m_AbsoluteConstraints;
    private JLabelBackground m_JLabel_EffectDelay;
    private JLabelBackground m_JLabel_EffectFirstLoop;
    private JLabelBackground m_JLabel_EffectMiddleLoop;
    private JLabelBackground m_JLabel_EffectLastLoop;
    private long m_EffectLastLoopPosition;
    private boolean m_EffectLastLoopDragging;
    private AbsoluteConstraints m_Delay_AbsoluteConstraints;
    private AbsoluteConstraints m_FirstLoop_AbsoluteConstraints;
    private AbsoluteConstraints m_MiddleLoop_AbsoluteConstraints;
    private AbsoluteConstraints m_LastLoop_AbsoluteConstraints;
    private MouseAdapter_Delayed m_MouseAdapter_Delayed;
    private Runnable m_RunnableRepaint;

    public LiveShowDMXObjectEffectPanel(LiveShowDMXObjectPanel p_LiveShowDMXObject) {
        this.initMembers();
        this.m_LiveShowDMXObjectPanel = p_LiveShowDMXObject;
        this.m_LiveShowDMXObject = (LiveShowDMXObject)p_LiveShowDMXObject.getLiveShowObjectInterface();
        this.initComponents();
        LiveLanguage.addLanguageListener((Object)this, null);
        this.refresh();
    }

    private void initMembers() {
        this.m_DMXEffect = null;
        this.m_EffectLastLoopDragging = false;
        this.m_RunnableRepaint = new Runnable(){

            @Override
            public void run() {
                LiveShowDMXObjectEffectPanel.this.repaint();
            }
        };
    }

    private void initComponents() {
        this.setBackground(Color.YELLOW);
        this.setOpaque(false);
        this.setLayout((LayoutManager)new AbsoluteLayout());
        this.m_AbsoluteConstraints = new AbsoluteConstraints(0, 0, 0, 0);
        this.m_AbsoluteConstraints.height = s_Height;
        this.m_Delay_AbsoluteConstraints = new AbsoluteConstraints(0, 0, 0, 0);
        this.m_Delay_AbsoluteConstraints.height = s_Height;
        this.m_Delay_AbsoluteConstraints.width = s_Height;
        this.m_FirstLoop_AbsoluteConstraints = new AbsoluteConstraints(0, 0, 0, 0);
        this.m_FirstLoop_AbsoluteConstraints.height = s_Height;
        this.m_FirstLoop_AbsoluteConstraints.width = s_Height;
        this.m_MiddleLoop_AbsoluteConstraints = new AbsoluteConstraints(0, 0, 0, 0);
        this.m_MiddleLoop_AbsoluteConstraints.height = s_Height;
        this.m_MiddleLoop_AbsoluteConstraints.width = s_Height;
        this.m_LastLoop_AbsoluteConstraints = new AbsoluteConstraints(0, 0, 0, 0);
        this.m_LastLoop_AbsoluteConstraints.height = s_Height;
        this.m_LastLoop_AbsoluteConstraints.width = s_Height;
        this.m_JLabel_EffectDelay = new JLabelBackground();
        this.m_JLabel_EffectDelay.setBackgroundOpaque(true);
        this.m_JLabel_EffectDelay.setBackgroundStyle(3);
        this.m_JLabel_EffectDelay.setBackgroundImage(new ImageIcon(this.getClass().getResource("/IconsPackage/Edit_Resize_Horizontal_Green_32.png")).getImage());
        this.m_JLabel_EffectDelay.setBackground(Color.RED);
        this.m_JLabel_EffectDelay.setCursor(Cursor.getPredefinedCursor(10));
        this.add((Component)this.m_JLabel_EffectDelay, this.m_Delay_AbsoluteConstraints);
        this.m_JLabel_EffectFirstLoop = new JLabelBackground();
        this.m_JLabel_EffectFirstLoop.setBackgroundOpaque(true);
        this.m_JLabel_EffectFirstLoop.setBackgroundStyle(3);
        this.m_JLabel_EffectFirstLoop.setBackgroundImage(new ImageIcon(this.getClass().getResource("/IconsPackage/Edit_Resize_Horizontal_Blue_32.png")).getImage());
        this.m_JLabel_EffectFirstLoop.setBackground(Color.RED);
        this.m_JLabel_EffectFirstLoop.setCursor(Cursor.getPredefinedCursor(11));
        this.add((Component)this.m_JLabel_EffectFirstLoop, this.m_FirstLoop_AbsoluteConstraints);
        this.m_JLabel_EffectMiddleLoop = new JLabelBackground();
        this.m_JLabel_EffectMiddleLoop.setBackgroundOpaque(true);
        this.m_JLabel_EffectMiddleLoop.setBackgroundStyle(3);
        this.m_JLabel_EffectMiddleLoop.setBackgroundImage(new ImageIcon(this.getClass().getResource("/IconsPackage/Edit_Resize_Horizontal_Blue_32.png")).getImage());
        this.m_JLabel_EffectMiddleLoop.setBackground(Color.RED);
        this.m_JLabel_EffectMiddleLoop.setCursor(Cursor.getPredefinedCursor(11));
        this.add((Component)this.m_JLabel_EffectMiddleLoop, this.m_MiddleLoop_AbsoluteConstraints);
        this.m_JLabel_EffectLastLoop = new JLabelBackground();
        this.m_JLabel_EffectLastLoop.setBackgroundOpaque(true);
        this.m_JLabel_EffectLastLoop.setBackgroundStyle(3);
        this.m_JLabel_EffectLastLoop.setBackgroundImage(new ImageIcon(this.getClass().getResource("/IconsPackage/Edit_Resize_Horizontal_Blue_32.png")).getImage());
        this.m_JLabel_EffectLastLoop.setBackground(Color.RED);
        this.m_JLabel_EffectLastLoop.setCursor(Cursor.getPredefinedCursor(11));
        this.add((Component)this.m_JLabel_EffectLastLoop, this.m_LastLoop_AbsoluteConstraints);
        this.m_MouseAdapter_Delayed = new MouseAdapter_Delayed(){

            @Override
            public void mouseDragged_Delayed(MouseEvent e) {
                long longDuration;
                long longDelay;
                long longFramesOld;
                long longFrames;
                int intTransferredX;
                LiveShowDMXObject o_LiveShowObjectDMXObject = LiveShowDMXObjectEffectPanel.this.m_LiveShowDMXObject;
                if (o_LiveShowObjectDMXObject == null) {
                    return;
                }
                DMXEffect o_DMXEffect = o_LiveShowObjectDMXObject.getDMXEffect();
                if (o_DMXEffect == null) {
                    return;
                }
                LiveShowVIP o_LiveShowVIP = o_LiveShowObjectDMXObject.getLiveShowVIP();
                if (o_LiveShowVIP == null) {
                    return;
                }
                this.sleep(20L);
                int intX = e.getPoint().x;
                if (e.getSource() == LiveShowDMXObjectEffectPanel.this.m_JLabel_EffectDelay) {
                    intTransferredX = intX + ((LiveShowDMXObjectEffectPanel)LiveShowDMXObjectEffectPanel.this).m_Delay_AbsoluteConstraints.x;
                    longFrames = LiveShowDMXObjectEffectPanel.this.m_LiveShowDMXObjectPanel.getPositionFrame(intTransferredX) - o_LiveShowObjectDMXObject.getFrameStartOffset();
                    if ((longDelay += longFrames - (longFramesOld = (longDelay = o_LiveShowObjectDMXObject.getDMXEffectDelay()))) > o_LiveShowObjectDMXObject.getFrameLength()) {
                        longDelay = o_LiveShowObjectDMXObject.getFrameLength();
                    }
                    o_LiveShowObjectDMXObject.setDMXEffectDelay(longDelay);
                }
                if (e.getSource() == LiveShowDMXObjectEffectPanel.this.m_JLabel_EffectFirstLoop) {
                    intTransferredX = intX + ((LiveShowDMXObjectEffectPanel)LiveShowDMXObjectEffectPanel.this).m_FirstLoop_AbsoluteConstraints.x;
                    longFrames = LiveShowDMXObjectEffectPanel.this.m_LiveShowDMXObjectPanel.getPositionFrame(intTransferredX) - o_LiveShowObjectDMXObject.getFrameStartOffset();
                    longDelay = o_LiveShowObjectDMXObject.getDMXEffectDelay();
                    longDuration = o_LiveShowObjectDMXObject.getDMXEffectDuration();
                    if ((longDuration += longFrames - (longFramesOld = longDelay + longDuration)) + longDelay > o_LiveShowObjectDMXObject.getFrameLength()) {
                        longDuration = o_LiveShowObjectDMXObject.getFrameLength() - longDelay;
                    }
                    o_LiveShowObjectDMXObject.setDMXEffectDuration(longDuration);
                }
                if (e.getSource() == LiveShowDMXObjectEffectPanel.this.m_JLabel_EffectMiddleLoop) {
                    intTransferredX = intX + ((LiveShowDMXObjectEffectPanel)LiveShowDMXObjectEffectPanel.this).m_MiddleLoop_AbsoluteConstraints.x;
                    longFrames = LiveShowDMXObjectEffectPanel.this.m_LiveShowDMXObjectPanel.getPositionFrame(intTransferredX) - o_LiveShowObjectDMXObject.getFrameStartOffset();
                    longDelay = o_LiveShowObjectDMXObject.getDMXEffectDelay();
                    longDuration = o_LiveShowObjectDMXObject.getDMXEffectDuration();
                    if ((longDuration += (longFrames - (longFramesOld = longDelay + longDuration * (long)s_MiddleLoopPosition)) / (long)s_MiddleLoopPosition) + longDelay > o_LiveShowObjectDMXObject.getFrameLength()) {
                        longDuration = o_LiveShowObjectDMXObject.getFrameLength() - longDelay;
                    }
                    o_LiveShowObjectDMXObject.setDMXEffectDuration(longDuration);
                }
                if (e.getSource() == LiveShowDMXObjectEffectPanel.this.m_JLabel_EffectLastLoop) {
                    LiveShowDMXObjectEffectPanel.this.m_EffectLastLoopDragging = true;
                    intTransferredX = intX + ((LiveShowDMXObjectEffectPanel)LiveShowDMXObjectEffectPanel.this).m_LastLoop_AbsoluteConstraints.x;
                    longFrames = LiveShowDMXObjectEffectPanel.this.m_LiveShowDMXObjectPanel.getPositionFrame(intTransferredX) - o_LiveShowObjectDMXObject.getFrameStartOffset();
                    longDelay = o_LiveShowObjectDMXObject.getDMXEffectDelay();
                    longDuration = o_LiveShowObjectDMXObject.getDMXEffectDuration();
                    longFramesOld = longDelay + longDuration * LiveShowDMXObjectEffectPanel.this.m_EffectLastLoopPosition;
                    if ((longDuration += (longFrames - longFramesOld) / LiveShowDMXObjectEffectPanel.this.m_EffectLastLoopPosition) + longDelay > o_LiveShowObjectDMXObject.getFrameLength()) {
                        longDuration = o_LiveShowObjectDMXObject.getFrameLength() - longDelay;
                    }
                    o_LiveShowObjectDMXObject.setDMXEffectDuration(longDuration);
                }
                LiveShowDMXObjectEffectPanel.this.startUndoAction(14, LiveShowUndo.ACTION_PARAMCHANGE_STRING);
            }

            @Override
            public void mouseReleased_Delayed(MouseEvent e) {
                if (e.getSource() == LiveShowDMXObjectEffectPanel.this.m_JLabel_EffectDelay || e.getSource() == LiveShowDMXObjectEffectPanel.this.m_JLabel_EffectFirstLoop || e.getSource() == LiveShowDMXObjectEffectPanel.this.m_JLabel_EffectMiddleLoop || e.getSource() == LiveShowDMXObjectEffectPanel.this.m_JLabel_EffectLastLoop) {
                    LiveShowDMXObjectEffectPanel.this.m_EffectLastLoopDragging = false;
                    LiveShowDMXObjectEffectPanel.this.endUndoAction(14, true);
                    LiveShowDMXObjectEffectPanel.this.setConstraintsParent(LiveShowDMXObjectEffectPanel.this.m_AbsoluteConstraints);
                }
            }
        };
        this.m_JLabel_EffectDelay.addMouseListener(this.m_MouseAdapter_Delayed);
        this.m_JLabel_EffectDelay.addMouseMotionListener(this.m_MouseAdapter_Delayed);
        this.m_JLabel_EffectFirstLoop.addMouseListener(this.m_MouseAdapter_Delayed);
        this.m_JLabel_EffectFirstLoop.addMouseMotionListener(this.m_MouseAdapter_Delayed);
        this.m_JLabel_EffectMiddleLoop.addMouseListener(this.m_MouseAdapter_Delayed);
        this.m_JLabel_EffectMiddleLoop.addMouseMotionListener(this.m_MouseAdapter_Delayed);
        this.m_JLabel_EffectLastLoop.addMouseListener(this.m_MouseAdapter_Delayed);
        this.m_JLabel_EffectLastLoop.addMouseMotionListener(this.m_MouseAdapter_Delayed);
        this.m_JLabel_EffectDelay.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.m_JLabel_EffectFirstLoop.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.m_JLabel_EffectMiddleLoop.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.m_JLabel_EffectLastLoop.setComponentPopupMenu(PopUpToolTip.getSelfReference());
    }

    public void close() {
        this.m_JLabel_EffectDelay.setComponentPopupMenu(null);
        this.m_JLabel_EffectFirstLoop.setComponentPopupMenu(null);
        this.m_JLabel_EffectMiddleLoop.setComponentPopupMenu(null);
        this.m_JLabel_EffectLastLoop.setComponentPopupMenu(null);
        DMXEffect o_DMXEffect = this.m_DMXEffect;
        if (o_DMXEffect != null) {
            o_DMXEffect.removePropertyChangeListener(this);
        }
        LiveLanguage.removeLanguageListener((Object)this);
    }

    @Override
    public void setBackground(Color p_BackgroundColor) {
        super.setBackground(p_BackgroundColor);
        this.m_ColorBackground_Transparent = GraphicsTools.newColorSave(p_BackgroundColor.getRed(), p_BackgroundColor.getGreen(), p_BackgroundColor.getBlue(), 100);
    }

    public AbsoluteConstraints getConstraints() {
        return this.m_AbsoluteConstraints;
    }

    public void setConstraintsParent(AbsoluteConstraints p_AbsoluteConstraints) {
        int intPosX;
        if (p_AbsoluteConstraints == null) {
            return;
        }
        this.m_AbsoluteConstraints.x = 0;
        this.m_AbsoluteConstraints.y = 0;
        this.m_AbsoluteConstraints.width = p_AbsoluteConstraints.width;
        LiveShowDMXObject o_LiveShowDMXObject = this.m_LiveShowDMXObject;
        if (o_LiveShowDMXObject == null) {
            return;
        }
        DMXEffect o_DMXEffect = o_LiveShowDMXObject.getDMXEffect();
        if (o_DMXEffect == null) {
            return;
        }
        long longDelay = o_LiveShowDMXObject.getDMXEffectDelay();
        long longFramePos = longDelay + o_LiveShowDMXObject.getFrameStartOffset();
        this.m_Delay_AbsoluteConstraints.x = intPosX = this.m_LiveShowDMXObjectPanel.getInsidePositionX(longFramePos) - s_Height / 2;
        long longDuration = o_LiveShowDMXObject.getDMXEffectDuration();
        longFramePos = longDelay + longDuration + o_LiveShowDMXObject.getFrameStartOffset();
        this.m_FirstLoop_AbsoluteConstraints.x = intPosX = this.m_LiveShowDMXObjectPanel.getInsidePositionX(longFramePos) - s_Height / 2;
        if ((long)s_MiddleLoopPosition > o_LiveShowDMXObject.getDMXEffectLoops() && o_LiveShowDMXObject.getDMXEffectLoops() > 0L) {
            this.m_JLabel_EffectMiddleLoop.setVisible(false);
        } else {
            longFramePos = longDelay + o_LiveShowDMXObject.getDMXEffectDuration() * (long)s_MiddleLoopPosition + o_LiveShowDMXObject.getFrameStartOffset();
            this.m_MiddleLoop_AbsoluteConstraints.x = intPosX = this.m_LiveShowDMXObjectPanel.getInsidePositionX(longFramePos) - s_Height / 2;
            this.m_JLabel_EffectMiddleLoop.setVisible(true);
        }
        if (!this.m_EffectLastLoopDragging) {
            this.m_EffectLastLoopPosition = (long)((double)((o_LiveShowDMXObject.getFrameLength() - o_LiveShowDMXObject.getFrameStartOffset() - longDelay) / longDuration) + 0.5);
            if (this.m_EffectLastLoopPosition > o_LiveShowDMXObject.getDMXEffectLoops() && o_LiveShowDMXObject.getDMXEffectLoops() > 0L) {
                this.m_EffectLastLoopPosition = o_LiveShowDMXObject.getDMXEffectLoops();
            }
        }
        long longLastLoop = o_LiveShowDMXObject.getDMXEffectDuration() * this.m_EffectLastLoopPosition;
        longFramePos = longDelay + longLastLoop + o_LiveShowDMXObject.getFrameStartOffset();
        this.m_LastLoop_AbsoluteConstraints.x = intPosX = this.m_LiveShowDMXObjectPanel.getInsidePositionX(longFramePos) - s_Height / 2;
        this.revalidate();
    }

    public void startUndoAction(int p_Action, String p_ActionString) {
        LiveShowUndo o_LiveShowUndo = null;
        LiveShowDMXObject o_LiveShowObjectInterface = this.m_LiveShowDMXObject;
        if (o_LiveShowObjectInterface == null) {
            return;
        }
        LiveShowVIP o_LiveShowVIP = o_LiveShowObjectInterface.getLiveShowVIP();
        if (o_LiveShowVIP == null) {
            return;
        }
        o_LiveShowUndo = o_LiveShowVIP.getLiveShowUndo();
        if (o_LiveShowUndo == null) {
            return;
        }
        if (o_LiveShowUndo.checkStartAction(p_Action)) {
            LiveShowVIP.LiveShowVIPStatus o_LiveShowVIPStatus = new LiveShowVIP.LiveShowVIPStatus();
            o_LiveShowVIPStatus.addLiveShowObject_Cloned(o_LiveShowObjectInterface);
            o_LiveShowUndo.startAction(p_Action, p_ActionString, o_LiveShowVIP, o_LiveShowVIPStatus);
        }
    }

    public void endUndoAction(int p_Action, boolean p_Success) {
        LiveShowUndo o_LiveShowUndo = null;
        LiveShowDMXObject o_LiveShowObjectInterface = this.m_LiveShowDMXObject;
        if (o_LiveShowObjectInterface == null) {
            return;
        }
        LiveShowVIP o_LiveShowVIP = o_LiveShowObjectInterface.getLiveShowVIP();
        if (o_LiveShowVIP == null) {
            return;
        }
        o_LiveShowUndo = o_LiveShowVIP.getLiveShowUndo();
        if (o_LiveShowUndo == null) {
            return;
        }
        if (o_LiveShowUndo.checkEndAction(p_Action)) {
            LiveShowVIP.LiveShowVIPStatus o_LiveShowVIPStatus = new LiveShowVIP.LiveShowVIPStatus();
            o_LiveShowVIPStatus.addLiveShowObject_Cloned(o_LiveShowObjectInterface);
            o_LiveShowUndo.endAction(p_Success, p_Action, o_LiveShowVIP, o_LiveShowVIPStatus);
        }
    }

    public void refresh() {
        if (this.m_DMXEffect != this.m_LiveShowDMXObject.getDMXEffect()) {
            if (this.m_DMXEffect != null) {
                this.m_DMXEffect.removePropertyChangeListener(this);
            }
            this.m_DMXEffect = this.m_LiveShowDMXObject.getDMXEffect();
            if (this.m_DMXEffect != null) {
                this.m_DMXEffect.addPropertyChangeListener(this);
            }
        }
        if (this.m_DMXEffect == null) {
            this.setVisible(false);
        } else {
            this.setVisible(true);
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            EventQueueHandler.invokeLater(this.m_RunnableRepaint);
        } else {
            this.repaint();
        }
    }

    @Override
    public void paintComponent(Graphics p_Graphics) {
        if (p_Graphics == null) {
            return;
        }
        super.paintComponent(p_Graphics);
        Graphics2D o_Graphics2D = (Graphics2D)p_Graphics;
        o_Graphics2D.setColor(this.m_ColorBackground_Transparent);
        o_Graphics2D.fillRect(0, 0, this.m_AbsoluteConstraints.width, this.m_AbsoluteConstraints.height);
        LiveShowDMXObject o_LiveShowDMXObject = this.m_LiveShowDMXObject;
        if (o_LiveShowDMXObject == null) {
            return;
        }
        DMXEffect o_DMXEffect = this.m_DMXEffect;
        if (o_DMXEffect == null) {
            return;
        }
        long longStepJump = 1L;
        long longDelay = o_LiveShowDMXObject.getDMXEffectDelay();
        long longDuration = o_LiveShowDMXObject.getDMXEffectDuration();
        long longLoopCount = o_LiveShowDMXObject.getDMXEffectLoops();
        int intEffectMaxSteps = o_DMXEffect.getMaxStepCount();
        if (intEffectMaxSteps <= 0) {
            return;
        }
        long longDurationFrames = longDuration;
        long longStartFrame = longDelay + o_LiveShowDMXObject.getFrameStartOffset();
        long longStepFrames = (long)((double)longDurationFrames / (double)intEffectMaxSteps + 0.5);
        long longPixelDiff = this.m_LiveShowDMXObjectPanel.getInsidePositionX(longStepFrames * 2L) - this.m_LiveShowDMXObjectPanel.getInsidePositionX(longStepFrames);
        if (longPixelDiff <= 4L) {
            longStepJump = intEffectMaxSteps;
            long longCorrectedStepFrames = (long)((double)longDurationFrames / (double)intEffectMaxSteps * (double)intEffectMaxSteps + 0.5);
            longPixelDiff = this.m_LiveShowDMXObjectPanel.getInsidePositionX(longCorrectedStepFrames * 2L) - this.m_LiveShowDMXObjectPanel.getInsidePositionX(longCorrectedStepFrames);
            if (longPixelDiff <= 4L) {
                return;
            }
        }
        long longStepsMax = longLoopCount > 0L ? longLoopCount * (long)intEffectMaxSteps : -1L;
        long longStepFrame = longStartFrame;
        long longLoop = 1L;
        o_Graphics2D.setColor(Color.BLACK);
        for (long longStep = 0L; (longStepsMax < 0L || longStep <= longStepsMax) && longStepFrame < o_LiveShowDMXObject.getFrameStartOffset() + o_LiveShowDMXObject.getFrameLength(); longStep += longStepJump) {
            longStepFrame = longStartFrame + longStep * longStepFrames;
            if (longStep == 0L) {
                o_Graphics2D.setColor(Color.GREEN);
            } else if (longStep == (long)intEffectMaxSteps * longLoop) {
                if (longLoopCount != 0L && longLoop == longLoopCount) {
                    o_Graphics2D.setColor(Color.RED);
                } else {
                    o_Graphics2D.setColor(Color.BLUE);
                }
                ++longLoop;
            }
            int intPosX = this.m_LiveShowDMXObjectPanel.getInsidePositionX(longStepFrame);
            o_Graphics2D.drawLine(intPosX, 0, intPosX, s_Height);
            o_Graphics2D.setColor(Color.BLACK);
        }
    }

    public void eventObjectParameterChanged(LiveShowObjectInterface p_LiveShowObjectInterface, LiveShowObjectDescription p_LiveShowObjectDescription) {
        if (p_LiveShowObjectInterface != this.m_LiveShowDMXObject) {
            return;
        }
        this.refresh();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this.m_DMXEffect) {
            this.refresh();
        }
    }
}

