/*
 * Decompiled with CFR 0.152.
 */
package DMXEffectsPackage;

import DMXEffectsPackage.DMXEffect;
import DMXScenePackage.DMXScene;
import DMXVirtualPackage.LiveShowDMXObject;
import DMXVirtualPackage.LiveShowDMXObjectDescription;
import DMXVirtualPackage.LiveShowDMXVIP;
import LiveShowObjectPackage.LiveShowObject;
import LiveShowPlayPackage.Play;
import LiveShowPlayPackage.PlayListener;
import PlayDMXPackage.PlayDMX;

public class DMXEffect_Jingle
implements PlayListener {
    public static final int SOFTWAREVERSION = 1;
    public static final long PLAYLENGTH_MS = 120000L;
    public static final long DMXEFFECT_DURATION_MIN = 100L;
    public static final long DMXEFFECT_DURATION_MAX = 10000L;
    public static final long DMXEFFECT_DURATION_DEFAULT = 4000L;
    private LiveShowDMXObjectDescription m_LiveShowDMXObjectDescription;
    private LiveShowDMXObject m_LiveShowDMXObject;
    private PlayDMX m_PlayDMX;
    private Play.PlaySynchronisizer m_PlaySynchronisizer;
    private boolean m_Closing;
    private DMXScene m_DMXScene;
    private DMXEffect m_DMXEffect;
    private long m_DMXEffectDuration;

    public DMXEffect_Jingle() {
        this.initMembers();
    }

    private void initMembers() {
        this.m_Closing = false;
        this.m_DMXScene = null;
        this.m_LiveShowDMXObjectDescription = new LiveShowDMXObjectDescription(true);
        this.m_LiveShowDMXObject = new LiveShowDMXObject(this.m_LiveShowDMXObjectDescription);
        this.m_LiveShowDMXObject.setFrameLength((long)(120000.0 / LiveShowDMXVIP.getFRAMETIME()));
        this.m_PlayDMX = new PlayDMX(this.m_LiveShowDMXObject, 2);
        this.m_PlayDMX.createOutputLine();
        this.m_PlaySynchronisizer = new Play.PlaySynchronisizer();
        this.m_PlayDMX.setPlaySynchronizer(this.m_PlaySynchronisizer);
        this.m_PlayDMX.addPlayListener(this);
        this.m_PlayDMX.setOverwriteManualValues(true);
        this.m_DMXEffectDuration = 4000L;
    }

    public void close() {
        if (this.m_Closing) {
            return;
        }
        this.m_Closing = true;
        if (this.m_PlayDMX != null) {
            if (this.m_PlaySynchronisizer != null) {
                this.m_PlaySynchronisizer.addPlayTriggerStop(this.m_PlayDMX);
            }
            this.m_PlayDMX.stopAndWaitFor();
            this.m_PlayDMX.removePlayListener(this);
        }
        if (this.m_PlayDMX != null) {
            this.m_PlayDMX.close();
        }
        if (this.m_PlaySynchronisizer != null) {
            this.m_PlaySynchronisizer.close();
        }
    }

    public void refresh() {
    }

    public void setLiveShowObject(LiveShowObject p_LiveShowObject) {
        if (p_LiveShowObject == null) {
            this.m_LiveShowDMXObject = null;
        } else {
            this.m_LiveShowDMXObject = (LiveShowDMXObject)p_LiveShowObject;
            this.m_LiveShowDMXObject.setFrameLength((long)(120000.0 / LiveShowDMXVIP.getFRAMETIME()));
            if (this.m_PlayDMX != null) {
                this.m_PlayDMX.setPlayable(p_LiveShowObject, 2);
            }
        }
    }

    public LiveShowObject getLiveShowObject() {
        return this.m_LiveShowDMXObject;
    }

    public Play.PlaySynchronisizer getPlaySynchronisizer() {
        return this.m_PlaySynchronisizer;
    }

    public Play getPlay() {
        return this.m_PlayDMX;
    }

    public int getPlayStatus() {
        if (this.m_PlayDMX == null) {
            return 9;
        }
        return this.m_PlayDMX.getStatus();
    }

    public void setDMXScene(DMXScene p_DMXScene) {
        this.m_PlaySynchronisizer.actionPlayStop();
        if (p_DMXScene == this.m_DMXScene) {
            return;
        }
        if (p_DMXScene == null) {
            this.m_LiveShowDMXObject.close(false);
            this.m_PlayDMX.setPlayable(null, 2);
            this.m_LiveShowDMXObject = null;
            this.m_DMXScene = null;
            return;
        }
        this.m_DMXScene = p_DMXScene;
        if (this.m_LiveShowDMXObject == null) {
            this.m_LiveShowDMXObjectDescription = new LiveShowDMXObjectDescription(true);
            this.m_LiveShowDMXObject = new LiveShowDMXObject(this.m_LiveShowDMXObjectDescription);
            this.m_LiveShowDMXObject.setFrameLength((long)(120000.0 / LiveShowDMXVIP.getFRAMETIME()));
            this.m_LiveShowDMXObject.setDMXEffect(this.m_DMXEffect);
            this.m_LiveShowDMXObject.setDMXEffectDuration((long)((double)this.m_DMXEffectDuration / LiveShowDMXVIP.getFRAMETIME()));
            this.m_PlayDMX.setPlayable(this.m_LiveShowDMXObject, 2);
        }
        this.m_LiveShowDMXObject.setDMXScene(this.m_DMXScene);
    }

    public void setDMXEffect(DMXEffect p_DMXEffect) {
        if (this.m_DMXEffect == p_DMXEffect) {
            return;
        }
        this.m_DMXEffect = p_DMXEffect;
        this.m_PlaySynchronisizer.actionPlayStop();
        if (this.m_LiveShowDMXObject != null) {
            this.m_LiveShowDMXObject.setDMXEffect(this.m_DMXEffect);
        }
    }

    public void setDuration(long p_Duration) {
        if (p_Duration < 100L) {
            p_Duration = 100L;
        }
        if (p_Duration > 10000L) {
            p_Duration = 10000L;
        }
        if (this.m_DMXEffectDuration == p_Duration) {
            return;
        }
        this.m_DMXEffectDuration = p_Duration;
        if (this.m_LiveShowDMXObject != null) {
            this.m_LiveShowDMXObject.setDMXEffectDuration((long)((double)this.m_DMXEffectDuration / LiveShowDMXVIP.getFRAMETIME()));
        }
    }

    @Override
    public void eventPlayStart(Play p_Play) {
        PlayDMX o_PlayDMX;
        PlayDMX.DMXPlayObject o_DMXPlayObject;
        if (p_Play instanceof PlayDMX && (o_DMXPlayObject = (PlayDMX.DMXPlayObject)(o_PlayDMX = (PlayDMX)p_Play).getPlayObject()) != null) {
            DMXScene.DMXSceneValueContainer o_DMXSceneValueContainer = o_DMXPlayObject.getDMXSceneValueContainer();
            DMXScene.addJingleDMXSceneValueContainer(o_DMXSceneValueContainer);
        }
    }

    @Override
    public void eventPlayStop(Play p_Play) {
        DMXScene.DMXSceneValueContainer o_DMXSceneValueContainer;
        PlayDMX o_PlayDMX;
        PlayDMX.DMXPlayObject o_DMXPlayObject;
        if (p_Play instanceof PlayDMX && (o_DMXPlayObject = (PlayDMX.DMXPlayObject)(o_PlayDMX = (PlayDMX)p_Play).getPlayObject()) != null && (o_DMXSceneValueContainer = o_DMXPlayObject.getDMXSceneValueContainer()) != null) {
            o_DMXSceneValueContainer.clearDMXSceneLight(o_PlayDMX.getPlayable());
            o_DMXSceneValueContainer.setFadeInProgress(0.0);
            o_DMXSceneValueContainer.setFadeOutProgress(0.0);
            o_DMXSceneValueContainer.setFadeProgress(0.0);
            DMXScene.mixMain(o_DMXSceneValueContainer);
            DMXScene.removeJingleDMXSceneValueContainer(o_DMXSceneValueContainer);
        }
    }

    @Override
    public void eventPlayPause(Play p_Play) {
    }

    @Override
    public void eventPlayRewind(Play p_Play) {
    }

    @Override
    public void eventPlayFastForward(Play p_Play) {
    }

    @Override
    public void eventPlayFadePossibility(Play p_Play, boolean p_FadeInPossible, boolean p_FadeOutPossible, double p_FadeProgress) {
    }

    @Override
    public void eventPlayFadedIn(Play p_Play, boolean p_FadedIn, double p_FadeProgress) {
    }

    @Override
    public long eventPlayCheckRead(Play p_Play, long p_FrameStart, long p_FramesToRead) {
        return p_FramesToRead;
    }

    @Override
    public void eventEditModeOn(Play p_Play, boolean p_EditModeOn) {
    }

    @Override
    public void eventEditCursorSet(Play p_Play, long p_PlayCursor) {
    }

    @Override
    public void eventPlayCursorSet(Play p_Play, long p_PlayCursor) {
    }

    @Override
    public void eventPlayCursor(Play p_Play, long p_OldPlayCursor, long p_PlayCursor) {
    }

    @Override
    public void eventPlayClosing(Play p_Play) {
    }

    @Override
    public void eventPlayError(Play p_Play, Exception p_Exception, String p_Remark) {
    }

    @Override
    public void eventPlayTimelineEnd(Play p_Play) {
    }
}

