/*
 * Decompiled with CFR 0.152.
 */
package DMXEffectsPackage;

import DMXDevicePackage.DMXDevice;
import DMXEffectsPackage.DMXEffect;
import DMXMixer.DMXControlComponent;
import DMXMixer.DMXControlDescription;
import DMXMixer.DMXControl_GridPanTilt_DeviceSettings;
import DMXScenePackage.DMXScene;
import DMXVirtualPackage.DMXFadeDescription;
import DMXVirtualPackage.LiveShowDMXObject;
import DMXVirtualPackage.LiveShowDMXVIP;
import LiveShowControlObjects.ControlObject;
import LiveShowObjectPackage.SinglePropertyChangeSupport;
import LiveShowPlayPackage.Playable;
import PlayDMXPackage.PlayDMX;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeListener;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;

public class DMXEffect_Function
implements Externalizable {
    public static final int SOFTWAREVERSION = 1;
    public static String PROP_DMXEFFECTFUNCTION_DMXEFFECTELEMENTADDED = "dmxeffectfunctionDMXEffectElementAdded";
    public static String PROP_DMXEFFECTFUNCTION_DMXEFFECTELEMENTREMOVED = "dmxeffectfunctionDMXEffectElementRemoved";
    public static String PROP_DMXEFFECTFUNCTION_DMXEFFECTELEMENTLISTCHANGED = "dmxeffectfunctionDMXEffectElementLISTCHANGED";
    public static String PROP_DMXEFFECTFUNCTION_STEPADDED = "dmxeffectfunctionStepAdded";
    public static String PROP_DMXEFFECTFUNCTION_STEPREMOVED = "dmxeffectfunctionStepRemoved";
    public static String PROP_DMXEFFECTFUNCTION_PARAMCHANGED = "dmxeffectfunctionParamChanged";
    public static String PROP_DMXEFFECTFUNCTION_VALUESCHANGED = "dmxeffectfunctionValuesChanged";
    public static final int FUNCTIONTYPE_DISCRETE = 0;
    protected DMXEffect m_DMXEffect;
    protected DMXControlDescription m_DMXControlDescription;
    protected int m_ControlsCount;
    protected int m_DimensionCount;
    protected DMXEffectElementList m_DMXEffectElementList;
    protected int m_DMXEffect_FunctionType;
    protected DMXEffect_ValuesMatrix m_DMXEffect_ValuesMatrix;
    protected ArrayList<Double> m_ValuesTemp;
    protected Point2D m_Point2DTemp;
    protected boolean m_Closed;
    public static final int FADETYPE_NORMAL = 0;
    public static final int FADETYPE_FADE = 1;
    public static final int FADETYPE_FADESINGLE = 5;
    public static final int FADETYPE_INCREASING = 2;
    public static final int FADETYPE_DESCENDING = 3;
    public static final int FADETYPE_FLASH = 4;
    protected int m_FadeType;
    protected long m_FadeTime;
    protected SinglePropertyChangeSupport m_PropertyChangeSupport;
    protected final Object m_SyncObject = new Object();
    private ArrayList<Double> m_RandomizerValues_Start;
    private ArrayList<Double> m_RandomizerValues_End;
    private ArrayList<Double> m_RandomizerVirtualValues_Start;
    private ArrayList<Double> m_RandomizerVirtualValues_End;

    public DMXEffect_Function(DMXEffect p_DMXEffect, DMXControlDescription p_DMXControlDescription) {
        this.initMembers();
        this.m_DMXEffect = p_DMXEffect;
        this.m_DMXControlDescription = p_DMXControlDescription;
        this.addPropertyChangeListener(p_DMXEffect);
    }

    private void initMembers() {
        this.m_DMXControlDescription = DMXControlDescription.getDMXControlDescription(DMXControlDescription.ID_UNDEFINED);
        this.m_DMXEffectElementList = new DMXEffectElementList(this);
        this.m_ControlsCount = -1;
        this.m_DimensionCount = -1;
        this.m_Closed = false;
        this.m_PropertyChangeSupport = new SinglePropertyChangeSupport(this);
        this.m_DMXEffect_ValuesMatrix = new DMXEffect_ValuesMatrix(this);
        this.m_FadeType = 0;
        this.m_FadeTime = PlayDMX.BUFFER_MILLISECONDS * 2;
        this.m_Point2DTemp = new Point2D.Double();
        this.m_RandomizerValues_Start = new ArrayList();
        this.m_RandomizerValues_End = new ArrayList();
        this.m_RandomizerVirtualValues_Start = new ArrayList();
        this.m_RandomizerVirtualValues_End = new ArrayList();
    }

    public void close() {
        if (this.m_Closed) {
            return;
        }
        this.m_Closed = true;
        this.m_DMXEffectElementList.clear();
        this.m_DMXEffect_ValuesMatrix.clear();
        DMXEffect o_DMXEffect = this.m_DMXEffect;
        if (o_DMXEffect != null) {
            this.removePropertyChangeListener(o_DMXEffect);
            if (this.m_DMXControlDescription != null) {
                o_DMXEffect.removeDMXEffectFunction(this);
            }
        }
        this.m_DMXEffect = null;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(1);
        out.writeUTF(this.m_DMXControlDescription.getID());
        out.writeInt(this.m_FadeType);
        out.writeLong(this.m_FadeTime);
        out.writeInt(this.m_DMXEffect_FunctionType);
        if (this.m_DMXEffect_FunctionType == 0) {
            out.writeInt(this.m_ControlsCount);
            out.writeInt(this.m_DimensionCount);
            out.writeInt(this.m_DMXEffect_ValuesMatrix.getStepCount());
            this.m_DMXEffect_ValuesMatrix.writeExternal(out);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int intSoftwareVersion = in.readInt();
        boolean boolOK = true;
        String stringID = in.readUTF();
        DMXControlDescription o_DMXControlDescription = DMXControlDescription.getDMXControlDescription(stringID);
        if (o_DMXControlDescription == null) {
            boolOK = false;
        }
        this.m_FadeType = in.readInt();
        this.m_FadeTime = in.readLong();
        if (this.m_FadeTime < (long)(PlayDMX.BUFFER_MILLISECONDS * 2)) {
            this.m_FadeTime = PlayDMX.BUFFER_MILLISECONDS * 2;
        }
        this.m_DMXEffect_FunctionType = in.readInt();
        if (this.m_DMXEffect_FunctionType == 0) {
            int intControlsCount = in.readInt();
            int intDimensionCount = in.readInt();
            int intStepCount = in.readInt();
            if (intControlsCount != this.m_ControlsCount) {
                boolOK = false;
            }
            if (intDimensionCount != this.m_DimensionCount) {
                boolOK = false;
            }
            if (boolOK) {
                for (int intStep = 0; intStep < intStepCount; ++intStep) {
                    this.addStep();
                }
            }
            this.m_DMXEffect_ValuesMatrix.readExternal(in);
        }
    }

    public DMXEffect_Function clone(DMXEffect_Function p_DMXEffect_Function) {
        if (p_DMXEffect_Function == null) {
            return null;
        }
        p_DMXEffect_Function.setFadeType(this.m_FadeType);
        p_DMXEffect_Function.setFadeTime(this.m_FadeTime);
        for (int intStep = p_DMXEffect_Function.getStepCount(); intStep < this.m_DMXEffect_ValuesMatrix.getStepCount(); ++intStep) {
            p_DMXEffect_Function.addStep();
        }
        this.m_DMXEffect_ValuesMatrix.clone(p_DMXEffect_Function.getDMXEffect_ValuesMatrix());
        return p_DMXEffect_Function;
    }

    public long getDiskSpaceEstimated() {
        long longDiskspace = 0L;
        longDiskspace += 4L;
        longDiskspace += (long)(this.m_DMXControlDescription.getID().length() * 2);
        ++longDiskspace;
        longDiskspace += 8L;
        return longDiskspace += this.m_DMXEffect_ValuesMatrix.getDiskSpaceEstimated();
    }

    public int getFadeType() {
        return this.m_FadeType;
    }

    public void setFadeType(int p_FadeType) {
        if (this.m_FadeType == p_FadeType) {
            return;
        }
        this.m_FadeType = p_FadeType;
        this.notifyParamChanged();
    }

    public void setFadeTime(long p_Milliseconds) {
        if (p_Milliseconds < 0L) {
            p_Milliseconds = 0L;
        }
        if (p_Milliseconds == this.m_FadeTime) {
            return;
        }
        if (p_Milliseconds < (long)(PlayDMX.BUFFER_MILLISECONDS * 2)) {
            p_Milliseconds = PlayDMX.BUFFER_MILLISECONDS * 2;
        }
        if (this.m_FadeTime == p_Milliseconds) {
            return;
        }
        this.m_FadeTime = p_Milliseconds;
        this.notifyParamChanged();
    }

    public long getFadeTime() {
        return this.m_FadeTime;
    }

    public DMXControlDescription getDMXControlDescription() {
        return this.m_DMXControlDescription;
    }

    public String getDMXControlDescriptionID() {
        if (this.m_DMXControlDescription == null) {
            return "";
        }
        return this.m_DMXControlDescription.getID();
    }

    public boolean calculateIsOnSteps(DMXEffectElement p_DMXEffectElement, ArrayList<Integer> p_IsOnSteps) {
        if (p_IsOnSteps == null) {
            return false;
        }
        if (p_DMXEffectElement == null) {
            return false;
        }
        return this.m_DMXEffect_ValuesMatrix.calculateIsOnSteps(p_DMXEffectElement, p_IsOnSteps);
    }

    public ArrayList<DMXControlComponent> getDMXControlComponents(DMXEffect.DMXDeviceElement p_DMXDeviceElement) {
        ArrayList<DMXControlComponent> o_DMXControlComponents = new ArrayList<DMXControlComponent>();
        if (p_DMXDeviceElement == null) {
            return o_DMXControlComponents;
        }
        DMXDevice o_DMXDevice = p_DMXDeviceElement.getDMXDevice();
        if (o_DMXDevice == null) {
            return null;
        }
        o_DMXControlComponents = o_DMXDevice.getDMXControlComponentsByDescription(this.m_DMXControlDescription.getID(), o_DMXControlComponents);
        if ("dimmer".equals(this.m_DMXControlDescription.getID())) {
            for (int intControl = 0; intControl < o_DMXDevice.getDMXControlComponent_Dimmer_Substitutes_Count(); ++intControl) {
                DMXControlDescription o_DMXControlDescription;
                DMXControlComponent o_DMXControlComponent = o_DMXDevice.getDMXControlComponent_Dimmer_Substitute(intControl);
                if (o_DMXControlComponent == null || "rgbcmy".equals((o_DMXControlDescription = o_DMXControlComponent.getDMXControlType().getDMXControlDescription()).getID()) || "coloramber".equals(o_DMXControlDescription.getID()) || "colorlime".equals(o_DMXControlDescription.getID()) || "coloruv".equals(o_DMXControlDescription.getID()) || "colorcyan".equals(o_DMXControlDescription.getID()) || "colormagenta".equals(o_DMXControlDescription.getID()) || "coloryellow".equals(o_DMXControlDescription.getID()) || "colorwhite".equals(o_DMXControlDescription.getID()) || "colorwhitecold".equals(o_DMXControlDescription.getID()) || "colorwhitewarm".equals(o_DMXControlDescription.getID()) || "intensity".equals(o_DMXControlDescription.getID())) continue;
                o_DMXControlComponents.add(o_DMXControlComponent);
            }
        }
        return o_DMXControlComponents;
    }

    public void addDMXDeviceElement(DMXEffect p_DMXEffect, DMXEffect.DMXDeviceElement p_DMXDeviceElement) {
        if (p_DMXEffect == null) {
            return;
        }
        if (p_DMXDeviceElement == null) {
            return;
        }
        DMXDevice o_DMXDevice = p_DMXDeviceElement.getDMXDevice();
        if (o_DMXDevice == null) {
            return;
        }
        int intIndex = p_DMXEffect.getIndexOf(p_DMXDeviceElement);
        DMXEffect.DMXDeviceElement o_DMXDeviceElement_Previous = intIndex <= 0 ? null : p_DMXEffect.getDMXDeviceElement(intIndex - 1);
        if (o_DMXDeviceElement_Previous == null) {
            intIndex = 0;
        } else {
            intIndex = this.m_DMXEffectElementList.getLastIndexOfDMXEffectElements(o_DMXDeviceElement_Previous);
            ++intIndex;
        }
        ArrayList<DMXControlComponent> o_DMXControlComponents = this.getDMXControlComponents(p_DMXDeviceElement);
        if (o_DMXControlComponents == null || o_DMXControlComponents.size() <= 0) {
            return;
        }
        if (!p_DMXDeviceElement.getInvertedControls()) {
            for (int intDMXControl = 0; intDMXControl < o_DMXControlComponents.size(); ++intDMXControl) {
                DMXControlComponent o_DMXControlComponent = o_DMXControlComponents.get(intDMXControl);
                if (!this.checkDMXControlType(o_DMXControlComponent.getDMXControlType())) continue;
                DMXEffectElement o_DMXEffectElement = this.m_DMXEffectElementList.addDMXControlComponent(intIndex, p_DMXDeviceElement, o_DMXControlComponent, intDMXControl, intDMXControl);
                this.m_DMXEffect_ValuesMatrix.addRow(intIndex);
                this.notifyDMXEffectElementAdded(o_DMXEffectElement);
                ++intIndex;
            }
        } else {
            for (int intControl = o_DMXControlComponents.size() - 1; intControl >= 0; --intControl) {
                DMXControlComponent o_DMXControlComponent = o_DMXControlComponents.get(intControl);
                if (!this.checkDMXControlType(o_DMXControlComponent.getDMXControlType())) continue;
                DMXEffectElement o_DMXEffectElement = this.m_DMXEffectElementList.addDMXControlComponent(intIndex, p_DMXDeviceElement, o_DMXControlComponent, o_DMXControlComponents.size() - 1 - intControl, intControl);
                this.m_DMXEffect_ValuesMatrix.addRow(intIndex);
                this.notifyDMXEffectElementAdded(o_DMXEffectElement);
                ++intIndex;
            }
        }
        p_DMXDeviceElement.calculateIsOnSteps();
    }

    private boolean checkDMXControlType(DMXControlComponent.DMXControlType p_DMXControlType) {
        if (p_DMXControlType == null) {
            return false;
        }
        boolean boolNewMatrix = false;
        int intControlsCount = p_DMXControlType.getControlTypeCount();
        if (intControlsCount <= 0) {
            return false;
        }
        DMXControlComponent.ControlType o_ControlType = p_DMXControlType.getControlType(0);
        if (o_ControlType == null) {
            return false;
        }
        int intDimensionCount = o_ControlType.getControlDimensionTypeCount();
        if (this.m_ControlsCount < 0) {
            this.m_ControlsCount = intControlsCount;
        }
        if (this.m_DimensionCount < 0) {
            this.m_DimensionCount = intDimensionCount;
        }
        if (intControlsCount != this.m_ControlsCount) {
            return false;
        }
        return intDimensionCount == this.m_DimensionCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invertDMXControls(DMXEffect.DMXDeviceElement p_DMXDeviceElement) {
        DMXEffectElement o_DMXEffectElement;
        int intElement;
        ArrayList<DMXControlComponent> o_DMXControlComponents;
        ArrayList<DMXEffectElement> o_DMXEffectElements;
        Object object = this.m_SyncObject;
        synchronized (object) {
            o_DMXEffectElements = new ArrayList<DMXEffectElement>();
            o_DMXControlComponents = new ArrayList<DMXControlComponent>();
            for (intElement = 0; intElement < this.m_DMXEffectElementList.size(); ++intElement) {
                o_DMXEffectElement = this.m_DMXEffectElementList.get(intElement);
                if (o_DMXEffectElement == null || o_DMXEffectElement.getDMXDeviceElement() != p_DMXDeviceElement) continue;
                o_DMXEffectElements.add(o_DMXEffectElement);
                o_DMXControlComponents.add(o_DMXEffectElement.getDMXControlComponent());
            }
        }
        if (o_DMXControlComponents.size() <= 1) {
            return;
        }
        for (intElement = 0; intElement < o_DMXEffectElements.size(); ++intElement) {
            int intNewIndex = o_DMXControlComponents.size() - 1 - intElement;
            o_DMXEffectElement = (DMXEffectElement)o_DMXEffectElements.get(intElement);
            DMXControlComponent o_DMXControlComponent = (DMXControlComponent)o_DMXControlComponents.get(intNewIndex);
            o_DMXEffectElement.setDMXControlComponent(o_DMXControlComponent);
        }
        this.notifyDMXEffectElementListChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDMXDeviceElement(DMXEffect.DMXDeviceElement p_DMXDeviceElement) {
        DMXEffectElement o_DMXEffectElement;
        ArrayList<DMXEffectElement> o_DMXEffectElements;
        if (p_DMXDeviceElement == null) {
            return;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            o_DMXEffectElements = new ArrayList<DMXEffectElement>();
            for (int intElement = 0; intElement < this.m_DMXEffectElementList.size(); ++intElement) {
                o_DMXEffectElement = this.m_DMXEffectElementList.get(intElement);
                if (o_DMXEffectElement == null || o_DMXEffectElement.getDMXDeviceElement() != p_DMXDeviceElement) continue;
                o_DMXEffectElements.add(o_DMXEffectElement);
            }
        }
        for (int intElement = 0; intElement < o_DMXEffectElements.size(); ++intElement) {
            o_DMXEffectElement = (DMXEffectElement)o_DMXEffectElements.get(intElement);
            if (o_DMXEffectElement == null) continue;
            int intRow = this.getIndexOf(o_DMXEffectElement);
            this.m_DMXEffectElementList.removeDMXEffectElement(o_DMXEffectElement);
            this.m_DMXEffect_ValuesMatrix.removeRowIndex(intRow);
            this.notifyDMXEffectElementRemoved(o_DMXEffectElement);
        }
        if (this.m_DMXEffectElementList.size() <= 0) {
            this.clearSteps();
            this.m_ControlsCount = -1;
            this.m_DimensionCount = -1;
            this.m_DMXEffect_ValuesMatrix.clear();
        }
    }

    public void resortDMXDevices(DMXEffect.DMXDeviceElement p_DMXDeviceElement) {
        DMXEffect_ValuesMatrix o_DMXEffect_ValuesMatrix;
        DMXEffect o_DMXEffect = this.m_DMXEffect;
        if (o_DMXEffect == null) {
            return;
        }
        int intIndexDMXDevice = o_DMXEffect.getIndexOf(p_DMXDeviceElement);
        int intIndexElement = this.m_DMXEffectElementList.getIndexOf(p_DMXDeviceElement);
        if (intIndexElement < 0) {
            return;
        }
        if (intIndexDMXDevice == intIndexElement) {
            return;
        }
        boolean boolChanged = this.m_DMXEffectElementList.moveDMXDevice(intIndexElement, intIndexDMXDevice);
        if (boolChanged && (o_DMXEffect_ValuesMatrix = this.m_DMXEffect_ValuesMatrix) != null) {
            o_DMXEffect_ValuesMatrix.recalculateValues();
        }
    }

    public void refreshDMXDeviceType(DMXEffect p_DMXEffect, DMXEffect.DMXDeviceElement p_DMXDeviceElement) {
        int intIndex;
        if (p_DMXDeviceElement == null) {
            return;
        }
        if (p_DMXEffect == null) {
            return;
        }
        DMXDevice o_DMXDevice = p_DMXDeviceElement.getDMXDevice();
        if (o_DMXDevice == null) {
            return;
        }
        DMXEffect_ValuesMatrix o_DMXEffect_ValuesMatrix = this.m_DMXEffect_ValuesMatrix;
        if (o_DMXEffect_ValuesMatrix == null) {
            return;
        }
        int intRowIndex = -1;
        ArrayList<DMXEffectElement> o_DMXEffectElements_Old = this.getDMXEffectElements(p_DMXDeviceElement);
        int intSize_Old = o_DMXEffectElements_Old.size();
        intRowIndex = intSize_Old > 0 ? this.getIndexOf(o_DMXEffectElements_Old.get(intSize_Old - 1)) : ((intIndex = p_DMXEffect.getIndexOf(p_DMXDeviceElement)) <= 0 ? 0 : this.m_DMXEffectElementList.getLastIndexOfDMXEffectElements(p_DMXEffect.getDMXDeviceElement(intIndex - 1)));
        if (intRowIndex < 0) {
            return;
        }
        ArrayList<DMXControlComponent> o_DMXControlComponents = this.getDMXControlComponents(p_DMXDeviceElement);
        if (!this.m_DMXEffectElementList.refreshDMXDeviceType(p_DMXDeviceElement, o_DMXControlComponents)) {
            return;
        }
        ArrayList<DMXEffectElement> o_DMXEffectElements_New = this.getDMXEffectElements(p_DMXDeviceElement);
        int intSize_New = o_DMXEffectElements_New.size();
        if (intSize_Old != intSize_New) {
            if (intSize_Old < intSize_New) {
                ++intRowIndex;
                for (intIndex = 0; intIndex < intSize_New - intSize_Old; ++intIndex) {
                    o_DMXEffect_ValuesMatrix.addRow(intRowIndex + intIndex);
                }
            } else if (intSize_Old > intSize_New) {
                for (intIndex = 0; intIndex < intSize_Old - intSize_New; ++intIndex) {
                    o_DMXEffect_ValuesMatrix.removeRowIndex(intRowIndex - intIndex);
                }
            }
        }
        this.notifyDMXEffectElementListChanged();
        p_DMXDeviceElement.calculateIsOnSteps();
    }

    public int getIndexOf(DMXEffectElement p_DMXEffectElement) {
        if (p_DMXEffectElement == null) {
            return -1;
        }
        return this.m_DMXEffectElementList.getIndexOf(p_DMXEffectElement);
    }

    public void addStep() {
        DMXEffect_ValuesMatrix o_DMXEffect_ValuesMatrix = this.m_DMXEffect_ValuesMatrix;
        if (o_DMXEffect_ValuesMatrix == null) {
            return;
        }
        o_DMXEffect_ValuesMatrix.addSteps(1);
        this.notifyStepAdded(o_DMXEffect_ValuesMatrix.getStepCount());
    }

    public void removeStep() {
        DMXEffect_ValuesMatrix o_DMXEffect_ValuesMatrix = this.m_DMXEffect_ValuesMatrix;
        if (o_DMXEffect_ValuesMatrix == null) {
            return;
        }
        o_DMXEffect_ValuesMatrix.removeSteps(1);
        this.notifyStepRemoved(o_DMXEffect_ValuesMatrix.getStepCount());
        DMXEffect o_DMXEffect = this.m_DMXEffect;
        if (o_DMXEffect != null) {
            o_DMXEffect.calculateIsOnSteps();
        }
    }

    public void clearSteps() {
        DMXEffect_ValuesMatrix o_DMXEffect_ValuesMatrix = this.m_DMXEffect_ValuesMatrix;
        if (o_DMXEffect_ValuesMatrix == null) {
            return;
        }
        o_DMXEffect_ValuesMatrix.removeSteps(o_DMXEffect_ValuesMatrix.getStepCount());
        this.notifyStepRemoved(o_DMXEffect_ValuesMatrix.getStepCount());
        DMXEffect o_DMXEffect = this.m_DMXEffect;
        if (o_DMXEffect != null) {
            o_DMXEffect.calculateIsOnSteps();
        }
    }

    public int getStepCount() {
        DMXEffect_ValuesMatrix o_DMXEffect_ValuesMatrix = this.m_DMXEffect_ValuesMatrix;
        if (o_DMXEffect_ValuesMatrix == null) {
            return 0;
        }
        return o_DMXEffect_ValuesMatrix.getStepCount();
    }

    public DMXEffect_ValuesMatrix getDMXEffect_ValuesMatrix() {
        return this.m_DMXEffect_ValuesMatrix;
    }

    public DMXEffect getDMXEffect() {
        return this.m_DMXEffect;
    }

    public int getDMXEffectElementCount() {
        return this.m_DMXEffectElementList.size();
    }

    public DMXEffectElement getDMXEffectElement(int p_Row) {
        if (p_Row < 0) {
            return null;
        }
        if (p_Row >= this.m_DMXEffectElementList.size()) {
            return null;
        }
        return this.m_DMXEffectElementList.get(p_Row);
    }

    public DMXEffectElement getDMXEffectElement(DMXControlComponent p_DMXControlComponent) {
        return this.m_DMXEffectElementList.get(p_DMXControlComponent);
    }

    public ArrayList<DMXEffectElement> getDMXEffectElements(DMXEffect.DMXDeviceElement p_DMXDeviceElement) {
        return this.m_DMXEffectElementList.getDMXEffectElements(p_DMXDeviceElement);
    }

    public ArrayList<Double> getValuesToReplace(int p_Step, DMXEffectElement p_DMXEffectElement) {
        if (p_Step < 0 || p_Step >= this.m_DMXEffect_ValuesMatrix.getStepCount()) {
            return null;
        }
        if (p_DMXEffectElement == null) {
            return null;
        }
        DMXControlComponent o_DMXControlComponent = p_DMXEffectElement.getDMXControlComponent();
        if (o_DMXControlComponent == null) {
            return null;
        }
        int intRow = this.m_DMXEffectElementList.getIndexOf(p_DMXEffectElement);
        ArrayList<Double> o_Values = new ArrayList<Double>();
        for (int intControlIndex = 0; intControlIndex < o_DMXControlComponent.getControlObjectCount(); ++intControlIndex) {
            ControlObject o_ControlObject = o_DMXControlComponent.getControlObject(intControlIndex);
            if (o_ControlObject == null) {
                return null;
            }
            for (int intDimensionIndex = 0; intDimensionIndex < o_ControlObject.getControlDimensionCount(); ++intDimensionIndex) {
                o_Values.add(this.m_DMXEffect_ValuesMatrix.getValue(intRow, p_Step, intControlIndex, intDimensionIndex));
            }
        }
        return o_Values;
    }

    public DMXControl_GridPanTilt_DeviceSettings.VirtualPoint getVirtualPoint(int p_Step, DMXEffectElement p_DMXEffectElement) {
        if (p_Step < 0 || p_Step >= this.m_DMXEffect_ValuesMatrix.getStepCount()) {
            return null;
        }
        if (p_DMXEffectElement == null) {
            return null;
        }
        int intRow = this.m_DMXEffectElementList.getIndexOf(p_DMXEffectElement);
        DMXEffect_ValuesMatrix.DMXEffect_ValuesRow o_DMXEffect_ValuesRow = this.m_DMXEffect_ValuesMatrix.getDMXEffect_ValuesRow(intRow);
        if (o_DMXEffect_ValuesRow == null) {
            return null;
        }
        return o_DMXEffect_ValuesRow.getStepVirtualPoint(p_Step);
    }

    public void setValuesToReplace(int p_Step, DMXEffectElement p_DMXEffectElement, ArrayList<Double> p_Values, DMXControl_GridPanTilt_DeviceSettings.VirtualPoint p_VirtualPoint) {
        if (p_Step < 0 || p_Step >= this.m_DMXEffect_ValuesMatrix.getStepCount()) {
            return;
        }
        if (p_DMXEffectElement == null) {
            return;
        }
        if (p_Values == null) {
            return;
        }
        DMXControlComponent o_DMXControlComponent = p_DMXEffectElement.getDMXControlComponent();
        if (o_DMXControlComponent == null) {
            return;
        }
        int intRow = this.m_DMXEffectElementList.getIndexOf(p_DMXEffectElement);
        this.m_DMXEffect_ValuesMatrix.setValuesToReplace(p_Values, intRow, p_Step, p_VirtualPoint);
        this.notifyValuesChanged();
    }

    public void setValues(int p_Step, DMXEffectElement p_DMXEffectElement, ArrayList<Double> p_Values) {
        if (p_Step < 0 || p_Step >= this.m_DMXEffect_ValuesMatrix.getStepCount()) {
            return;
        }
        if (p_DMXEffectElement == null) {
            return;
        }
        if (p_Values == null) {
            return;
        }
        DMXControlComponent o_DMXControlComponent = p_DMXEffectElement.getDMXControlComponent();
        if (o_DMXControlComponent == null) {
            return;
        }
        int intRow = this.m_DMXEffectElementList.getIndexOf(p_DMXEffectElement);
        this.m_DMXEffect_ValuesMatrix.setValues(p_Values, intRow, p_Step);
        this.notifyValuesChanged();
    }

    public double getValue(int p_Step, DMXControlComponent p_DMXControlComponent, int p_ControlIndex, int p_DimensionIndex) {
        if (p_Step < 0 || p_Step >= this.m_DMXEffect_ValuesMatrix.getStepCount()) {
            return 0.0;
        }
        DMXEffectElement o_DMXEffectElement = this.getDMXEffectElement(p_DMXControlComponent);
        int intRow = this.m_DMXEffectElementList.getIndexOf(o_DMXEffectElement);
        return this.m_DMXEffect_ValuesMatrix.getValue(intRow, p_Step, p_ControlIndex, p_DimensionIndex);
    }

    public void setRandomizerValues_Start(ArrayList<Double> p_Values) {
        if (p_Values == null) {
            return;
        }
        if (this.m_RandomizerValues_Start.size() != p_Values.size()) {
            this.m_RandomizerValues_Start.clear();
            for (int intValue = 0; intValue < p_Values.size(); ++intValue) {
                this.m_RandomizerValues_Start.add(p_Values.get(intValue));
            }
            return;
        }
        for (int intValue = 0; intValue < p_Values.size(); ++intValue) {
            this.m_RandomizerValues_Start.set(intValue, p_Values.get(intValue));
        }
    }

    public ArrayList<Double> getRandomizerValues_Start() {
        return this.m_RandomizerValues_Start;
    }

    public void setRandomizerValues_End(ArrayList<Double> p_Values) {
        if (p_Values == null) {
            return;
        }
        if (this.m_RandomizerValues_End.size() != p_Values.size()) {
            this.m_RandomizerValues_End.clear();
            for (int intValue = 0; intValue < p_Values.size(); ++intValue) {
                this.m_RandomizerValues_End.add(p_Values.get(intValue));
            }
            return;
        }
        for (int intValue = 0; intValue < p_Values.size(); ++intValue) {
            this.m_RandomizerValues_End.set(intValue, p_Values.get(intValue));
        }
    }

    public ArrayList<Double> getRandomizerValues_End() {
        return this.m_RandomizerValues_End;
    }

    public void setRandomizerVirtualValues_Start(ArrayList<Double> p_Values) {
        if (p_Values == null) {
            return;
        }
        if (this.m_RandomizerVirtualValues_Start.size() != p_Values.size()) {
            this.m_RandomizerVirtualValues_Start.clear();
            for (int intValue = 0; intValue < p_Values.size(); ++intValue) {
                this.m_RandomizerVirtualValues_Start.add(p_Values.get(intValue));
            }
            return;
        }
        for (int intValue = 0; intValue < p_Values.size(); ++intValue) {
            this.m_RandomizerVirtualValues_Start.set(intValue, p_Values.get(intValue));
        }
    }

    public ArrayList<Double> getRandomizerVirtualValues_Start() {
        return this.m_RandomizerVirtualValues_Start;
    }

    public void setRandomizerVirtualValues_End(ArrayList<Double> p_Values) {
        if (p_Values == null) {
            return;
        }
        if (this.m_RandomizerVirtualValues_End.size() != p_Values.size()) {
            this.m_RandomizerVirtualValues_End.clear();
            for (int intValue = 0; intValue < p_Values.size(); ++intValue) {
                this.m_RandomizerVirtualValues_End.add(p_Values.get(intValue));
            }
            return;
        }
        for (int intValue = 0; intValue < p_Values.size(); ++intValue) {
            this.m_RandomizerVirtualValues_End.set(intValue, p_Values.get(intValue));
        }
    }

    public ArrayList<Double> getRandomizerVirtualValues_End() {
        return this.m_RandomizerVirtualValues_End;
    }

    public void readLiveShowDMXObject(boolean p_OnlyReadAdjustmentsPreStatus, boolean p_MixIn, Playable.PlayObject p_PlayObject, LiveShowDMXObject p_LiveShowDMXObject, DMXFadeDescription p_DMXFadeDescription, PlayDMX.DMXPlayObject p_DMXPlayObjectPre_StartStatus, float p_VolumeFactor, double p_FadeFactor, long p_FrameInsideObject, long p_Delay, long p_Duration, long p_Loops, int p_TriggerFlag) {
        PlayDMX.DMXPlayObject o_DMXPlayObject = (PlayDMX.DMXPlayObject)p_PlayObject;
        DMXScene.DMXSceneDeviceValues o_PlayDeviceValues = null;
        DMXScene.DMXSceneValueContainer o_StartStatus_ValueContainer = null;
        DMXScene.DMXSceneDeviceValues o_StartStatus_DeviceValues = null;
        DMXDevice o_DMXDevice = null;
        DMXFadeDescription.DMXDeviceFadeDescription o_DMXDeviceFadeDescription = null;
        StepFactor o_StepFactor = p_LiveShowDMXObject.getDMXEffect_StepFactor();
        this.calculateStep(p_LiveShowDMXObject, o_StepFactor, p_FrameInsideObject, p_Delay, p_Duration, p_Loops, p_TriggerFlag);
        if (p_DMXPlayObjectPre_StartStatus != null) {
            o_StartStatus_ValueContainer = p_DMXPlayObjectPre_StartStatus.getDMXSceneValueContainer();
        }
        DMXScene.DMXSceneValueContainer o_PlayObjectValueContainer = o_DMXPlayObject.getDMXSceneValueContainer();
        for (int intElement = 0; intElement < this.m_DMXEffectElementList.size(); ++intElement) {
            DMXEffectElement o_DMXEffectElement = this.m_DMXEffectElementList.get(intElement);
            if (o_DMXDevice != o_DMXEffectElement.getDMXDevice()) {
                o_DMXDevice = o_DMXEffectElement.getDMXDevice();
                if (o_DMXDevice == null) continue;
                o_PlayDeviceValues = o_PlayObjectValueContainer.getDMXSceneDeviceValues(o_DMXDevice.getID());
                if (o_StartStatus_ValueContainer != null) {
                    o_StartStatus_DeviceValues = o_StartStatus_ValueContainer.getDMXSceneDeviceValues(o_DMXDevice.getID());
                }
                o_DMXDeviceFadeDescription = p_DMXFadeDescription.getDMXDeviceFadeDescription(o_DMXDevice.getID());
                if (o_PlayDeviceValues == null) continue;
            }
            this.readComponents(false, p_OnlyReadAdjustmentsPreStatus, p_MixIn, o_DMXEffectElement, intElement, o_DMXDevice, p_LiveShowDMXObject, o_DMXDeviceFadeDescription, o_PlayDeviceValues, o_StartStatus_DeviceValues, p_VolumeFactor, p_FadeFactor);
        }
    }

    public DMXEffectElement getDimmerDMXEffectElement(DMXEffectElement p_DMXEffectElement) {
        DMXEffectElement o_DimmerEffectElement = null;
        DMXEffect.DMXDeviceElement o_DMXDeviceElement = p_DMXEffectElement.getDMXDeviceElement();
        if (o_DMXDeviceElement == null) {
            return null;
        }
        o_DimmerEffectElement = o_DMXDeviceElement.getDimmerDMXEffectElement(p_DMXEffectElement.getDMXControlComponentIndex());
        return o_DimmerEffectElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readComponents(boolean p_IsAdjustment, boolean p_OnlyReadAdjustmentsPreStatus, boolean p_MixIn, DMXEffectElement p_DMXEffectElement, int p_Element, DMXDevice p_DMXDevice, LiveShowDMXObject p_LiveShowDMXObject, DMXFadeDescription.DMXDeviceFadeDescription p_DMXDeviceFadeDescription, DMXScene.DMXSceneDeviceValues p_PlayDeviceValues, DMXScene.DMXSceneDeviceValues p_StartStatus_DeviceValues, float p_VolumeFactor, double p_FadeFactor) {
        DMXControlComponent.DMXControlType o_DMXControlType;
        if (p_DMXEffectElement == null) {
            return;
        }
        if (p_DMXDevice == null) {
            return;
        }
        if (p_LiveShowDMXObject == null) {
            return;
        }
        if (p_DMXDeviceFadeDescription == null) {
            return;
        }
        if (p_PlayDeviceValues == null) {
            return;
        }
        if (p_PlayDeviceValues.getAdjustmentDimmerOff(p_LiveShowDMXObject)) {
            return;
        }
        DMXControlComponent o_DMXControlComponent = p_DMXEffectElement.getDMXControlComponent();
        if (o_DMXControlComponent == null) {
            return;
        }
        StepFactor o_StepFactor = p_LiveShowDMXObject.getDMXEffect_StepFactor();
        DMXControlComponent.DMXControlType o_DMXControlType_Device = p_DMXEffectElement.getDMXControlType_Device();
        if (!o_StepFactor.getReadDMXScene() && !p_IsAdjustment) {
            p_PlayDeviceValues.setOverwriteManualDMXEffect(true, o_DMXControlType_Device);
        }
        if ((o_DMXControlType = o_DMXControlComponent.getDMXControlType()) == null) {
            return;
        }
        DMXEffectElement o_DimmableDMXEffectElement = this.getDimmerDMXEffectElement(p_DMXEffectElement);
        DMXFadeDescription.DMXControlTypeFadeDescription o_DMXControlTypeFadeDescription = p_DMXDeviceFadeDescription.getDMXControlTypeFadeDescription(o_DMXControlType.getID());
        if (o_DMXControlTypeFadeDescription == null) {
            return;
        }
        boolean boolDisabled = o_DMXControlTypeFadeDescription.getDisabled();
        Object object = this.m_SyncObject;
        synchronized (object) {
            if (this.m_ValuesTemp == null || this.m_ValuesTemp.size() != this.m_ControlsCount * this.m_DimensionCount) {
                this.m_ValuesTemp = new ArrayList(this.m_ControlsCount * this.m_DimensionCount);
                for (int intValue = 0; intValue < this.m_ControlsCount * this.m_DimensionCount; ++intValue) {
                    this.m_ValuesTemp.add(-1.0);
                }
            }
            if (o_StepFactor.getReadDMXScene()) {
                this.calculateValuesFromScene(this.m_ValuesTemp, p_LiveShowDMXObject, p_DMXDevice, o_DMXControlType, p_PlayDeviceValues);
            } else {
                this.calculateValues(this.m_ValuesTemp, p_DMXEffectElement, o_DimmableDMXEffectElement, p_LiveShowDMXObject, o_DMXControlType, p_Element, o_StepFactor, p_PlayDeviceValues, p_IsAdjustment);
            }
            for (int intControl = 0; intControl < this.m_ControlsCount; ++intControl) {
                for (int intDimension = 0; intDimension < this.m_DimensionCount; ++intDimension) {
                    double doubleValueSelf;
                    double doubleValue = this.m_ValuesTemp.get(intControl * this.m_DimensionCount + intDimension);
                    if (doubleValue < 0.0) continue;
                    if (boolDisabled) {
                        return;
                    }
                    if (p_DMXEffectElement.isDimmable()) {
                        if (p_OnlyReadAdjustmentsPreStatus) {
                            return;
                        }
                        doubleValue *= (double)p_VolumeFactor;
                    }
                    if (p_StartStatus_DeviceValues != null) {
                        p_StartStatus_DeviceValues.setValueDMXDevice(doubleValue, o_DMXControlType, intControl, intDimension);
                    }
                    doubleValue *= p_FadeFactor;
                    if (p_MixIn && (doubleValueSelf = p_PlayDeviceValues.getValueDMXDevice(o_DMXControlType, intControl, intDimension)) >= 0.0) {
                        doubleValue += doubleValueSelf;
                    }
                    p_PlayDeviceValues.setValueDMXDevice(doubleValue, o_DMXControlType, intControl, intDimension);
                }
            }
        }
    }

    public void calculateStep(LiveShowDMXObject p_LiveShowDMXObject, StepFactor p_StepFactor, long p_FrameInsideObject, long p_Delay, long p_Duration, long p_Loops, int p_TriggerFlag) {
        if (p_StepFactor == null) {
            p_StepFactor = new StepFactor();
        }
        p_StepFactor.calculateStep(p_LiveShowDMXObject, this.m_DMXEffect, this, p_FrameInsideObject, p_Delay, p_Duration, p_Loops, p_TriggerFlag);
    }

    public ArrayList<Double> calculateValuesFromScene(ArrayList<Double> p_ResultValues, LiveShowDMXObject p_LiveShowDMXObject, DMXDevice p_DMXDevice, DMXControlComponent.DMXControlType p_DMXControlType, DMXScene.DMXSceneDeviceValues p_PlayDeviceValues) {
        if (p_DMXDevice == null) {
            return p_ResultValues;
        }
        if (p_LiveShowDMXObject == null) {
            return p_ResultValues;
        }
        if (p_DMXControlType == null) {
            return p_ResultValues;
        }
        DMXScene o_DMXScene = p_LiveShowDMXObject.getDMXScene();
        if (o_DMXScene == null) {
            return p_ResultValues;
        }
        DMXScene.DMXSceneValueContainer o_DMXSceneValueContainer = o_DMXScene.getDMXSceneValueContainer();
        if (o_DMXSceneValueContainer == null) {
            return p_ResultValues;
        }
        DMXScene.DMXSceneDeviceValues o_DMXSceneDeviceValues = o_DMXSceneValueContainer.getDMXSceneDeviceValues(p_DMXDevice.getID());
        if (o_DMXSceneDeviceValues == null) {
            return p_ResultValues;
        }
        DMXControl_GridPanTilt_DeviceSettings.VirtualPoint o_VirtualPoint_Actual = o_DMXSceneDeviceValues.getVirtualPoint_PanTilt();
        for (int intControl = 0; intControl < this.m_ControlsCount; ++intControl) {
            for (int intDimension = 0; intDimension < this.m_DimensionCount; ++intDimension) {
                double doubleValue = o_DMXSceneDeviceValues.getValueDMXDevice(p_DMXControlType, intControl, intDimension);
                p_ResultValues.set(intControl * this.m_DimensionCount + intDimension, doubleValue);
            }
        }
        DMXControl_GridPanTilt_DeviceSettings.VirtualPoint_Path_DMXDevice o_VirtualPoint_Path_DMXDevice = p_PlayDeviceValues.getVirtualPoint_Path_DMXDevice();
        if (o_VirtualPoint_Path_DMXDevice != null) {
            o_VirtualPoint_Path_DMXDevice.clearVirtualPoints_Read();
            o_VirtualPoint_Path_DMXDevice.setCalculationCount(0);
            o_VirtualPoint_Path_DMXDevice.addVirtualPoint_Read(o_VirtualPoint_Actual, 0.0, -1);
        }
        return p_ResultValues;
    }

    public double calculateValueFromScene(LiveShowDMXObject p_LiveShowDMXObject, DMXDevice p_DMXDevice, DMXControlComponent.DMXControlType p_DMXControlType, int p_ControlIndex, int p_DimensionIndex, DMXScene.DMXSceneDeviceValues p_PlayDeviceValues) {
        if (p_DMXDevice == null) {
            return -1.0;
        }
        if (p_LiveShowDMXObject == null) {
            return -1.0;
        }
        if (p_DMXControlType == null) {
            return -1.0;
        }
        DMXScene o_DMXScene = p_LiveShowDMXObject.getDMXScene();
        if (o_DMXScene == null) {
            return -1.0;
        }
        DMXScene.DMXSceneValueContainer o_DMXSceneValueContainer = o_DMXScene.getDMXSceneValueContainer();
        if (o_DMXSceneValueContainer == null) {
            return -1.0;
        }
        DMXScene.DMXSceneDeviceValues o_DMXSceneDeviceValues = o_DMXSceneValueContainer.getDMXSceneDeviceValues(p_DMXDevice.getID());
        if (o_DMXSceneDeviceValues == null) {
            return -1.0;
        }
        double doubleValue = o_DMXSceneDeviceValues.getValueDMXDevice(p_DMXControlType, p_ControlIndex, p_DimensionIndex);
        return doubleValue;
    }

    public ArrayList<Double> calculateValues(ArrayList<Double> p_ResultValues, DMXEffectElement p_DMXEffectElement, DMXEffectElement p_DimmableDMXEffectElement, LiveShowDMXObject p_LiveShowDMXObject, DMXControlComponent.DMXControlType p_DMXControlType, int p_Row, StepFactor p_StepFactor, DMXScene.DMXSceneDeviceValues p_PlayDeviceValues, boolean p_IsAdjustment) {
        if (p_DMXEffectElement == null) {
            return null;
        }
        DMXEffect_ValuesMatrix o_DMXEffect_ValuesMatrix = this.m_DMXEffect_ValuesMatrix;
        if (o_DMXEffect_ValuesMatrix == null) {
            return null;
        }
        DMXDevice o_DMXDevice = p_DMXEffectElement.getDMXDevice();
        if (o_DMXDevice == null || p_DMXEffectElement.isDimmable() && p_StepFactor.getInDelay()) {
            for (int intValue = 0; intValue < p_ResultValues.size(); ++intValue) {
                p_ResultValues.set(intValue, 0.0);
            }
            return p_ResultValues;
        }
        StepFactor o_StepFactor = p_LiveShowDMXObject.getDMXEffect_StepFactor();
        boolean boolIsCalibrated = false;
        if ("pantilt".equals(this.m_DMXControlDescription.getID())) {
            DMXControl_GridPanTilt_DeviceSettings.VirtualPoint_Path_DMXDevice o_VirtualPoint_Path_DMXDevice;
            DMXControl_GridPanTilt_DeviceSettings.VirtualPoint o_VirtualPoint_Next;
            if (o_DMXDevice == null) {
                return p_ResultValues;
            }
            Point2D o_Point2D_Calculated = null;
            boolIsCalibrated = false;
            DMXEffect_ValuesMatrix.DMXEffect_ValuesRow o_DMXEffect_ValuesRow = o_DMXEffect_ValuesMatrix.getDMXEffect_ValuesRow(p_Row);
            DMXControl_GridPanTilt_DeviceSettings.VirtualPoint o_VirtualPoint_Actual = o_DMXEffect_ValuesRow.getStepVirtualPoint(o_StepFactor.getStep_Actual());
            if (o_StepFactor.getIsLastStep()) {
                DMXScene.DMXSceneDeviceValues o_DMXSceneDeviceValues;
                DMXScene.DMXSceneValueContainer o_DMXSceneValueContainer;
                o_VirtualPoint_Next = null;
                DMXScene o_DMXScene = p_LiveShowDMXObject.getDMXScene();
                if (o_DMXScene != null && (o_DMXSceneValueContainer = o_DMXScene.getDMXSceneValueContainer()) != null && (o_DMXSceneDeviceValues = o_DMXSceneValueContainer.getDMXSceneDeviceValues(o_DMXDevice.getID())) != null) {
                    o_VirtualPoint_Next = o_DMXSceneDeviceValues.getVirtualPoint_PanTilt();
                }
            } else {
                o_VirtualPoint_Next = o_DMXEffect_ValuesRow.getStepVirtualPoint(o_StepFactor.getStep_Next());
            }
            if ((o_VirtualPoint_Path_DMXDevice = p_PlayDeviceValues.getVirtualPoint_Path_DMXDevice()) != null) {
                o_VirtualPoint_Path_DMXDevice.clearVirtualPoints_Read();
                o_VirtualPoint_Path_DMXDevice.setCalculationCount(0);
            }
            if (o_VirtualPoint_Actual != null && o_VirtualPoint_Next != null) {
                if (this.getFadeType() == 1) {
                    if (o_VirtualPoint_Path_DMXDevice != null) {
                        o_VirtualPoint_Path_DMXDevice.addVirtualPoint_Read(o_VirtualPoint_Actual, o_StepFactor.getFactor_Actual(), -1);
                        o_VirtualPoint_Path_DMXDevice.addVirtualPoint_Read(o_VirtualPoint_Next, o_StepFactor.getFactor_Next(), -1);
                        o_Point2D_Calculated = p_PlayDeviceValues.calculateVirtualPointPath(false);
                        if (o_Point2D_Calculated != null) {
                            boolIsCalibrated = true;
                        }
                    }
                } else if (this.getFadeType() == 0) {
                    o_VirtualPoint_Path_DMXDevice.addVirtualPoint_Read(o_VirtualPoint_Actual, 0.0, -1);
                }
            }
            if (boolIsCalibrated) {
                o_VirtualPoint_Path_DMXDevice.removeVirtualPoint_Read(o_VirtualPoint_Next);
                o_VirtualPoint_Path_DMXDevice.removeVirtualPoint_Read(o_VirtualPoint_Actual);
                if (!p_IsAdjustment) {
                    o_VirtualPoint_Path_DMXDevice.addVirtualPoint_Read(o_VirtualPoint_Path_DMXDevice.getVirtualPoint_Calculated(), 0.0, -1);
                }
                for (int intControl = 0; intControl < this.m_ControlsCount; ++intControl) {
                    for (int intDimension = 0; intDimension < this.m_DimensionCount; ++intDimension) {
                        if (intDimension == 0) {
                            p_ResultValues.set(intControl * this.m_DimensionCount + intDimension, o_Point2D_Calculated.getX());
                            continue;
                        }
                        p_ResultValues.set(intControl * this.m_DimensionCount + intDimension, o_Point2D_Calculated.getY());
                    }
                }
            }
        }
        if (!boolIsCalibrated) {
            for (int intControl = 0; intControl < this.m_ControlsCount; ++intControl) {
                for (int intDimension = 0; intDimension < this.m_DimensionCount; ++intDimension) {
                    double doubleValue_Next;
                    double doubleValue_Previous;
                    boolean boolValueSet = false;
                    double doubleValue_Result = 0.0;
                    double doubleValue_Actual = o_DMXEffect_ValuesMatrix.getValue(p_Row, o_StepFactor.getStep_Actual(), intControl, intDimension);
                    if (doubleValue_Actual >= 0.0) {
                        doubleValue_Result += doubleValue_Actual * o_StepFactor.getFactor_Actual();
                        boolValueSet = true;
                    }
                    if ((doubleValue_Previous = o_DMXEffect_ValuesMatrix.getValue(p_Row, o_StepFactor.getStep_Previos(), intControl, intDimension)) >= 0.0) {
                        doubleValue_Result += doubleValue_Previous * o_StepFactor.getFactor_Previuos();
                        boolValueSet = true;
                    }
                    if ((doubleValue_Next = o_StepFactor.getIsLastStep() ? this.calculateValueFromScene(p_LiveShowDMXObject, o_DMXDevice, p_DMXControlType, intControl, intDimension, p_PlayDeviceValues) : o_DMXEffect_ValuesMatrix.getValue(p_Row, o_StepFactor.getStep_Next(), intControl, intDimension)) >= 0.0) {
                        doubleValue_Result += doubleValue_Next * o_StepFactor.getFactor_Next();
                        boolValueSet = true;
                    }
                    if (boolValueSet) {
                        p_ResultValues.set(intControl * this.m_DimensionCount + intDimension, doubleValue_Result);
                        continue;
                    }
                    p_ResultValues.set(intControl * this.m_DimensionCount + intDimension, -1.0);
                }
            }
        }
        return p_ResultValues;
    }

    public double calculateValue(DMXEffectElement p_DMXEffectElement, DMXEffectElement p_DimmableDMXEffectElement, LiveShowDMXObject p_LiveShowDMXObject, int p_Row, int p_ControlIndex, int p_DimensionIndex, StepFactor p_StepFactor) {
        StepFactor o_StepFactor;
        DMXDevice o_DMXDevice;
        if (p_DMXEffectElement == null) {
            return -1.0;
        }
        DMXEffect_ValuesMatrix o_DMXEffect_ValuesMatrix = this.m_DMXEffect_ValuesMatrix;
        if (o_DMXEffect_ValuesMatrix == null) {
            return -1.0;
        }
        boolean boolValueSet = false;
        if (p_DMXEffectElement.isDimmable() && p_StepFactor.getInDelay()) {
            return 0.0;
        }
        double doubleValue_Actual = 0.0;
        double doubleValue_Previous = 0.0;
        double doubleValue_Next = 0.0;
        double doubleValue_Result = 0.0;
        if (!"pantilt".equals(this.m_DMXControlDescription.getID()) || (o_DMXDevice = p_DMXEffectElement.getDMXDevice()) != null) {
            // empty if block
        }
        if ((doubleValue_Actual = o_DMXEffect_ValuesMatrix.getValue(p_Row, (o_StepFactor = p_LiveShowDMXObject.getDMXEffect_StepFactor()).getStep_Actual(), p_ControlIndex, p_DimensionIndex)) >= 0.0) {
            doubleValue_Result += doubleValue_Actual * o_StepFactor.getFactor_Actual();
            boolValueSet = true;
        }
        if ((doubleValue_Previous = o_DMXEffect_ValuesMatrix.getValue(p_Row, o_StepFactor.getStep_Previos(), p_ControlIndex, p_DimensionIndex)) >= 0.0) {
            doubleValue_Result += doubleValue_Previous * o_StepFactor.getFactor_Previuos();
            boolValueSet = true;
        }
        if ((doubleValue_Next = o_DMXEffect_ValuesMatrix.getValue(p_Row, o_StepFactor.getStep_Next(), p_ControlIndex, p_DimensionIndex)) >= 0.0) {
            doubleValue_Result += doubleValue_Next * o_StepFactor.getFactor_Next();
            boolValueSet = true;
        }
        if (boolValueSet) {
            return doubleValue_Result;
        }
        return -1.0;
    }

    public ArrayList<Double> getValuesPanTilt(int p_Row, int p_Step) {
        DMXEffect_ValuesMatrix o_DMXEffect_ValuesMatrix = this.m_DMXEffect_ValuesMatrix;
        if (o_DMXEffect_ValuesMatrix == null) {
            return null;
        }
        return o_DMXEffect_ValuesMatrix.getValues(p_Row, p_Step);
    }

    public boolean setValuePanTilt(double p_ValueX, double p_ValueY, int p_Row, int p_Step, DMXControl_GridPanTilt_DeviceSettings.VirtualPoint p_VirtualPoint) {
        DMXEffect_ValuesMatrix o_DMXEffect_ValuesMatrix = this.m_DMXEffect_ValuesMatrix;
        if (o_DMXEffect_ValuesMatrix == null) {
            return false;
        }
        return o_DMXEffect_ValuesMatrix.setValuePanTilt(p_ValueX, p_ValueY, p_Row, p_Step, p_VirtualPoint);
    }

    public void addPropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
        this.m_PropertyChangeSupport.addPropertyChangeListener(p_PropertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
        this.m_PropertyChangeSupport.removePropertyChangeListener(p_PropertyChangeListener);
    }

    private void notifyParamChanged() {
        this.m_PropertyChangeSupport.firePropertyChange(PROP_DMXEFFECTFUNCTION_PARAMCHANGED, false, true);
    }

    private void notifyStepAdded(int p_StepCount) {
        this.m_PropertyChangeSupport.firePropertyChange(PROP_DMXEFFECTFUNCTION_STEPADDED, -1, p_StepCount);
    }

    private void notifyStepRemoved(int p_StepCount) {
        this.m_PropertyChangeSupport.firePropertyChange(PROP_DMXEFFECTFUNCTION_STEPREMOVED, -1, p_StepCount);
    }

    private void notifyDMXEffectElementAdded(DMXEffectElement p_DMXEffectElement) {
        this.m_PropertyChangeSupport.firePropertyChange(PROP_DMXEFFECTFUNCTION_DMXEFFECTELEMENTADDED, null, p_DMXEffectElement);
    }

    private void notifyDMXEffectElementRemoved(DMXEffectElement p_DMXEffectElement) {
        this.m_PropertyChangeSupport.firePropertyChange(PROP_DMXEFFECTFUNCTION_DMXEFFECTELEMENTREMOVED, p_DMXEffectElement, null);
    }

    public void notifyDMXEffectElementListChanged() {
        this.m_PropertyChangeSupport.firePropertyChange(PROP_DMXEFFECTFUNCTION_DMXEFFECTELEMENTLISTCHANGED, false, true);
    }

    private void notifyValuesChanged() {
        this.m_PropertyChangeSupport.firePropertyChange(PROP_DMXEFFECTFUNCTION_VALUESCHANGED, false, true);
    }

    public static class DMXEffect_ValuesMatrix
    implements Externalizable {
        public static final int SOFTWAREVERSION = 2;
        private DMXEffect_Function m_DMXEffect_Function;
        private int m_ControlsCount;
        private int m_DimensionCount;
        private int m_StepCount;
        private ArrayList<DMXEffect_ValuesRow> m_DMXEffect_ValuesRows;
        private final Object m_SyncValues = new Object();

        public DMXEffect_ValuesMatrix(DMXEffect_Function p_DMXEffect_Function) {
            this.initMembers();
            this.m_DMXEffect_Function = p_DMXEffect_Function;
        }

        private void initMembers() {
            this.m_StepCount = 0;
            this.m_DMXEffect_ValuesRows = new ArrayList();
            this.m_ControlsCount = 0;
            this.m_DimensionCount = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(2);
            out.writeInt(this.m_ControlsCount);
            out.writeInt(this.m_DimensionCount);
            out.writeInt(this.m_StepCount);
            Object object = this.m_SyncValues;
            synchronized (object) {
                out.writeInt(this.m_DMXEffect_ValuesRows.size());
                for (int intRow = 0; intRow < this.m_DMXEffect_ValuesRows.size(); ++intRow) {
                    DMXEffect_ValuesRow o_DMXEffect_ValuesRow = this.m_DMXEffect_ValuesRows.get(intRow);
                    int intStepCount = o_DMXEffect_ValuesRow.getStepCount();
                    out.writeInt(intStepCount);
                    for (int intStep = 0; intStep < intStepCount; ++intStep) {
                        ArrayList<Double> o_Values = o_DMXEffect_ValuesRow.getStepValues(intStep);
                        int intValuesCount = o_Values.size();
                        out.writeInt(intValuesCount);
                        for (int intValue = 0; intValue < intValuesCount; ++intValue) {
                            out.writeDouble(o_Values.get(intValue));
                        }
                        int intAdditionalCount = 0;
                        if ("pantilt".equals(this.m_DMXEffect_Function.getDMXControlDescriptionID())) {
                            ++intAdditionalCount;
                        }
                        out.writeInt(intAdditionalCount);
                        if (!"pantilt".equals(this.m_DMXEffect_Function.getDMXControlDescriptionID())) continue;
                        DMXControl_GridPanTilt_DeviceSettings.VirtualPoint o_VirtualPoint = o_DMXEffect_ValuesRow.getStepVirtualPoint(intStep);
                        if (o_VirtualPoint == null) {
                            out.writeUTF(DMXControlDescription.ID_UNDEFINED);
                            continue;
                        }
                        out.writeUTF("pantilt");
                        o_VirtualPoint.writeExternal(out);
                    }
                }
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            boolean boolOK = true;
            int intSoftwareVersion = in.readInt();
            int intControlsCount = in.readInt();
            int intDimensionCount = in.readInt();
            int intStepCount = in.readInt();
            int intRowCount = in.readInt();
            ArrayList<Double> o_Values = new ArrayList<Double>();
            if (intControlsCount != this.m_ControlsCount) {
                boolOK = false;
            }
            if (intDimensionCount != this.m_DimensionCount) {
                boolOK = false;
            }
            if (intStepCount != this.m_StepCount) {
                boolOK = false;
            }
            for (int intRow = 0; intRow < intRowCount; ++intRow) {
                intStepCount = in.readInt();
                for (int intStep = 0; intStep < intStepCount; ++intStep) {
                    int intValuesCount = in.readInt();
                    o_Values.clear();
                    for (int intValue = 0; intValue < intValuesCount; ++intValue) {
                        o_Values.add(in.readDouble());
                    }
                    int intAdditionalCount = 0;
                    if (intSoftwareVersion >= 2) {
                        intAdditionalCount = in.readInt();
                    }
                    DMXControl_GridPanTilt_DeviceSettings.VirtualPoint o_VirtualPoint = null;
                    for (int intAdditional = 0; intAdditional < intAdditionalCount; ++intAdditional) {
                        String stringAdditionalID = in.readUTF();
                        if (!"pantilt".equals(stringAdditionalID)) continue;
                        o_VirtualPoint = new DMXControl_GridPanTilt_DeviceSettings.VirtualPoint();
                        o_VirtualPoint.readExternal(in);
                    }
                    if (!boolOK) continue;
                    if ("pantilt".equals(this.m_DMXEffect_Function.getDMXControlDescriptionID())) {
                        if (o_VirtualPoint != null) {
                            Point2D o_Point2D = DMXControl_GridPanTilt_DeviceSettings.calculateAnglesFromVirtualPoint(null, this.getDMXDevice(intRow), o_VirtualPoint);
                            if (o_Point2D != null) {
                                o_Values.set(0, o_Point2D.getX());
                                o_Values.set(1, o_Point2D.getY());
                            }
                        } else {
                            o_VirtualPoint = DMXControl_GridPanTilt_DeviceSettings.calculateVirtualPointFromAnglesBilinear(null, this.getDMXDevice(intRow), o_Values.get(0), o_Values.get(1), false);
                        }
                        this.setValuePanTilt(o_Values.get(0), o_Values.get(1), intRow, intStep, o_VirtualPoint);
                        continue;
                    }
                    this.setValues(o_Values, intRow, intStep);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clone(DMXEffect_ValuesMatrix p_DMXEffect_ValuesMatrix) {
            Object object = this.m_SyncValues;
            synchronized (object) {
                for (int intRow = 0; intRow < this.m_DMXEffect_ValuesRows.size(); ++intRow) {
                    DMXEffect_ValuesRow o_DMXEffect_ValuesRow = this.getDMXEffect_ValuesRow(intRow);
                    if (o_DMXEffect_ValuesRow == null) continue;
                    for (int intStep = 0; intStep < o_DMXEffect_ValuesRow.getStepCount(); ++intStep) {
                        ArrayList<Double> o_Values = o_DMXEffect_ValuesRow.getStepValues(intStep);
                        if (o_Values == null) continue;
                        if ("pantilt".equals(this.m_DMXEffect_Function.getDMXControlDescription().getID())) {
                            if (o_Values.size() != 2) continue;
                            DMXControl_GridPanTilt_DeviceSettings.VirtualPoint o_VirtualPoint = o_DMXEffect_ValuesRow.getStepVirtualPoint(intStep);
                            o_DMXEffect_ValuesRow.setStepValuePanTilt(o_Values.get(0), o_Values.get(1), intStep, o_VirtualPoint);
                            continue;
                        }
                        p_DMXEffect_ValuesMatrix.setValues(o_Values, intRow, intStep);
                    }
                }
            }
        }

        public long getDiskSpaceEstimated() {
            long longDiskspace = 0L;
            longDiskspace += 4L;
            longDiskspace += 4L;
            longDiskspace += 4L;
            longDiskspace += 4L;
            return longDiskspace += (long)(this.m_DMXEffect_ValuesRows.size() * this.m_StepCount * this.m_ControlsCount * this.m_DimensionCount * 8);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            Object object = this.m_SyncValues;
            synchronized (object) {
                for (int intRow = this.m_DMXEffect_ValuesRows.size() - 1; intRow >= 0; --intRow) {
                    DMXEffect_ValuesRow o_DMXEffect_ValuesRow = this.m_DMXEffect_ValuesRows.get(intRow);
                    o_DMXEffect_ValuesRow.close();
                    this.m_DMXEffect_ValuesRows.remove(intRow);
                }
                this.m_ControlsCount = 0;
                this.m_DimensionCount = 0;
                this.m_StepCount = 0;
            }
        }

        public DMXEffect_Function getDMXEffect_Function() {
            return this.m_DMXEffect_Function;
        }

        public int getControlsCount() {
            return this.m_ControlsCount;
        }

        public int getDimensionCount() {
            return this.m_DimensionCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getRowCount() {
            Object object = this.m_SyncValues;
            synchronized (object) {
                return this.m_DMXEffect_ValuesRows.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addRow(int p_Index) {
            if (p_Index < 0) {
                p_Index = 0;
            }
            Object object = this.m_SyncValues;
            synchronized (object) {
                DMXEffectElement o_DMXEffectElement;
                if (p_Index > this.m_DMXEffect_ValuesRows.size()) {
                    p_Index = this.m_DMXEffect_ValuesRows.size();
                }
                if ((o_DMXEffectElement = this.m_DMXEffect_Function.getDMXEffectElement(p_Index)) == null) {
                    return;
                }
                if (p_Index == 0) {
                    DMXControlComponent o_DMXControlComponent = o_DMXEffectElement.getDMXControlComponent();
                    if (o_DMXControlComponent == null) {
                        return;
                    }
                    this.m_ControlsCount = o_DMXControlComponent.getControlObjectCount();
                    ControlObject o_ControlObject = o_DMXControlComponent.getControlObject(0);
                    if (o_ControlObject == null) {
                        return;
                    }
                    this.m_DimensionCount = o_ControlObject.getControlDimensionCount();
                }
                DMXEffect_ValuesRow o_DMXEffect_ValuesRow = new DMXEffect_ValuesRow(this, p_Index);
                o_DMXEffect_ValuesRow.addSteps(this.m_StepCount, o_DMXEffectElement);
                this.m_DMXEffect_ValuesRows.add(p_Index, o_DMXEffect_ValuesRow);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeRows(int p_RowCount) {
            if (p_RowCount <= 0) {
                return;
            }
            Object object = this.m_SyncValues;
            synchronized (object) {
                if (p_RowCount > this.m_DMXEffect_ValuesRows.size()) {
                    p_RowCount = this.m_DMXEffect_ValuesRows.size();
                }
                for (int intRow = 0; intRow < p_RowCount; ++intRow) {
                    int intIndex = this.m_DMXEffect_ValuesRows.size() - 1;
                    DMXEffect_ValuesRow o_DMXEffect_ValuesRow = this.m_DMXEffect_ValuesRows.get(intIndex);
                    o_DMXEffect_ValuesRow.close();
                    this.m_DMXEffect_ValuesRows.remove(intIndex);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeRowIndex(int p_RowIndex) {
            if (p_RowIndex < 0) {
                return;
            }
            Object object = this.m_SyncValues;
            synchronized (object) {
                if (p_RowIndex >= this.m_DMXEffect_ValuesRows.size()) {
                    return;
                }
                DMXEffect_ValuesRow o_DMXEffect_ValuesRow = this.m_DMXEffect_ValuesRows.get(p_RowIndex);
                o_DMXEffect_ValuesRow.close();
                this.m_DMXEffect_ValuesRows.remove(p_RowIndex);
            }
        }

        public int getStepCount() {
            return this.m_StepCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addSteps(int p_StepCount) {
            if (p_StepCount <= 0) {
                return;
            }
            Object object = this.m_SyncValues;
            synchronized (object) {
                this.m_StepCount += p_StepCount;
                for (int intRow = 0; intRow < this.m_DMXEffect_ValuesRows.size(); ++intRow) {
                    DMXEffectElement o_DMXEffectElement = this.m_DMXEffect_Function.getDMXEffectElement(intRow);
                    DMXEffect_ValuesRow o_DMXEffect_ValuesRow = this.m_DMXEffect_ValuesRows.get(intRow);
                    if (o_DMXEffectElement == null) continue;
                    o_DMXEffect_ValuesRow.addSteps(p_StepCount, o_DMXEffectElement);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeSteps(int p_StepCount) {
            if (p_StepCount <= 0) {
                return;
            }
            Object object = this.m_SyncValues;
            synchronized (object) {
                if (p_StepCount > this.m_StepCount) {
                    p_StepCount = this.m_StepCount;
                }
                this.m_StepCount -= p_StepCount;
                for (int intRow = 0; intRow < this.m_DMXEffect_ValuesRows.size(); ++intRow) {
                    DMXEffect_ValuesRow o_DMXEffect_ValuesRow = this.m_DMXEffect_ValuesRows.get(intRow);
                    o_DMXEffect_ValuesRow.removeSteps(p_StepCount);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DMXEffect_ValuesRow getDMXEffect_ValuesRow(int p_Row) {
            if (p_Row < 0) {
                return null;
            }
            Object object = this.m_SyncValues;
            synchronized (object) {
                if (p_Row >= this.m_DMXEffect_ValuesRows.size()) {
                    return null;
                }
                return this.m_DMXEffect_ValuesRows.get(p_Row);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ArrayList<Double> getValues(int p_Row, int p_Step) {
            DMXEffect_ValuesRow o_DMXEffect_ValuesRow = this.getDMXEffect_ValuesRow(p_Row);
            Object object = this.m_SyncValues;
            synchronized (object) {
                if (o_DMXEffect_ValuesRow == null) {
                    return null;
                }
                return o_DMXEffect_ValuesRow.getStepValues(p_Step);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public double getValue(int p_Row, int p_StepIndex, int p_ControlIndex, int p_DimensionIndex) {
            if (p_Row < 0) {
                return -1.0;
            }
            if (p_StepIndex < 0) {
                return -1.0;
            }
            if (p_ControlIndex < 0) {
                return -1.0;
            }
            if (p_DimensionIndex < 0) {
                return -1.0;
            }
            Object object = this.m_SyncValues;
            synchronized (object) {
                if (p_Row >= this.m_DMXEffect_ValuesRows.size()) {
                    return -1.0;
                }
                DMXEffect_ValuesRow o_DMXEffect_ValuesRow = this.m_DMXEffect_ValuesRows.get(p_Row);
                return o_DMXEffect_ValuesRow.getStepValue(p_StepIndex, p_ControlIndex, p_DimensionIndex);
            }
        }

        public DMXEffectElement getDMXEffectElement(int p_Row) {
            DMXEffect_Function o_DMXEffect_Function = this.getDMXEffect_Function();
            if (o_DMXEffect_Function == null) {
                return null;
            }
            return o_DMXEffect_Function.getDMXEffectElement(p_Row);
        }

        public DMXDevice getDMXDevice(int p_Row) {
            DMXEffectElement o_DMXEffectElement = this.getDMXEffectElement(p_Row);
            if (o_DMXEffectElement == null) {
                return null;
            }
            return o_DMXEffectElement.getDMXDevice();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean setValuePanTilt(double p_ValueX, double p_ValueY, int p_Row, int p_StepIndex, DMXControl_GridPanTilt_DeviceSettings.VirtualPoint p_VirtualPoint) {
            if (p_Row < 0) {
                return false;
            }
            if (p_StepIndex < 0) {
                return false;
            }
            Object object = this.m_SyncValues;
            synchronized (object) {
                if (p_Row >= this.m_DMXEffect_ValuesRows.size()) {
                    return false;
                }
                DMXEffect_ValuesRow o_DMXEffect_ValuesRow = this.m_DMXEffect_ValuesRows.get(p_Row);
                return o_DMXEffect_ValuesRow.setStepValuePanTilt(p_ValueX, p_ValueY, p_StepIndex, p_VirtualPoint);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean setValuesToReplace(ArrayList<Double> p_Values, int p_Row, int p_Step, DMXControl_GridPanTilt_DeviceSettings.VirtualPoint p_VirtualPoint) {
            if (p_Values == null) {
                return false;
            }
            Object object = this.m_SyncValues;
            synchronized (object) {
                DMXEffect_ValuesRow o_DMXEffect_ValuesRow = this.getDMXEffect_ValuesRow(p_Row);
                if (o_DMXEffect_ValuesRow == null) {
                    return false;
                }
                if (p_VirtualPoint == null) {
                    return o_DMXEffect_ValuesRow.setValuesToReplace(p_Values, p_Step);
                }
                if (p_Values.size() < 2) {
                    return false;
                }
                return o_DMXEffect_ValuesRow.setStepValuePanTilt(p_Values.get(0), p_Values.get(1), p_Step, p_VirtualPoint);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean setValues(ArrayList<Double> p_Values, int p_Row, int p_Step) {
            DMXEffect_ValuesRow o_DMXEffect_ValuesRow = this.getDMXEffect_ValuesRow(p_Row);
            Object object = this.m_SyncValues;
            synchronized (object) {
                if (o_DMXEffect_ValuesRow == null) {
                    return false;
                }
                return o_DMXEffect_ValuesRow.setValues(p_Values, p_Step);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void recalculateValues() {
            Object object = this.m_SyncValues;
            synchronized (object) {
                for (int intRow = 0; intRow < this.m_DMXEffect_ValuesRows.size(); ++intRow) {
                    DMXEffect_ValuesRow o_DMXEffect_ValuesRow = this.m_DMXEffect_ValuesRows.get(intRow);
                    o_DMXEffect_ValuesRow.recalculateValues();
                }
            }
        }

        public boolean calculateIsOnSteps(DMXEffectElement p_DMXEffectElement, ArrayList<Integer> p_IsOnSteps) {
            if (p_DMXEffectElement == null) {
                return false;
            }
            if (p_IsOnSteps == null) {
                return false;
            }
            int intRow = this.m_DMXEffect_Function.getIndexOf(p_DMXEffectElement);
            DMXEffect_ValuesRow o_DMXEffect_ValuesRow = this.getDMXEffect_ValuesRow(intRow);
            if (o_DMXEffect_ValuesRow == null) {
                return false;
            }
            return o_DMXEffect_ValuesRow.calculateIsOnSteps(p_DMXEffectElement, p_IsOnSteps);
        }

        public static class DMXEffect_ValuesRow {
            private DMXEffect_ValuesMatrix m_DMXEffect_ValuesMatrix;
            private int m_Row;
            private ArrayList<ArrayList<Double>> m_StepValues;
            private ArrayList<DMXControl_GridPanTilt_DeviceSettings.VirtualPoint> m_StepVirtualPoints;
            private final Object m_SyncValues = new Object();

            public DMXEffect_ValuesRow(DMXEffect_ValuesMatrix p_DMXEffect_ValuesMatrix, int p_Row) {
                this.initMembers();
                this.m_DMXEffect_ValuesMatrix = p_DMXEffect_ValuesMatrix;
                this.m_Row = p_Row;
                this.m_StepVirtualPoints = "pantilt".equals(p_DMXEffect_ValuesMatrix.getDMXEffect_Function().getDMXControlDescriptionID()) ? new ArrayList() : null;
            }

            private void initMembers() {
                this.m_StepValues = new ArrayList();
            }

            public void close() {
                this.m_DMXEffect_ValuesMatrix = null;
                this.m_StepValues.clear();
                if (this.m_StepVirtualPoints != null) {
                    this.m_StepVirtualPoints.clear();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void addSteps(int p_StepCount, DMXEffectElement p_DMXEffectElement) {
                if (p_StepCount <= 0) {
                    return;
                }
                if (p_DMXEffectElement == null) {
                    return;
                }
                DMXControlComponent o_DMXControlComponent = p_DMXEffectElement.getDMXControlComponent();
                if (o_DMXControlComponent == null) {
                    return;
                }
                DMXEffect_ValuesMatrix o_DMXEffect_ValuesMatrix = this.m_DMXEffect_ValuesMatrix;
                if (o_DMXEffect_ValuesMatrix == null) {
                    return;
                }
                Object object = this.m_SyncValues;
                synchronized (object) {
                    for (int intStep = 0; intStep < p_StepCount; ++intStep) {
                        int intControlsCount = o_DMXEffect_ValuesMatrix.getControlsCount();
                        int intDimensionCount = o_DMXEffect_ValuesMatrix.getDimensionCount();
                        int intValuesCount = intControlsCount * intDimensionCount;
                        ArrayList<Double> o_ArrayList_Values = new ArrayList<Double>(intValuesCount);
                        for (int intValue = 0; intValue < intValuesCount; ++intValue) {
                            o_ArrayList_Values.add(0.0);
                        }
                        o_DMXControlComponent.getInitValues(o_ArrayList_Values);
                        this.m_StepValues.add(o_ArrayList_Values);
                        if (this.m_StepVirtualPoints == null) continue;
                        this.m_StepVirtualPoints.add(null);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void removeSteps(int p_StepCount) {
                if (p_StepCount <= 0) {
                    return;
                }
                Object object = this.m_SyncValues;
                synchronized (object) {
                    int intExist = this.m_StepValues.size();
                    if (p_StepCount > intExist) {
                        p_StepCount = intExist;
                    }
                    for (int intStep = intExist - 1; intStep >= intExist - p_StepCount; --intStep) {
                        this.m_StepValues.remove(intStep);
                        if (this.m_StepVirtualPoints == null) continue;
                        this.m_StepVirtualPoints.remove(intStep);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void removeStep(int p_StepIndex) {
                if (p_StepIndex < 0) {
                    return;
                }
                Object object = this.m_SyncValues;
                synchronized (object) {
                    if (p_StepIndex >= this.m_StepValues.size()) {
                        return;
                    }
                    this.m_StepValues.remove(p_StepIndex);
                    if (this.m_StepVirtualPoints != null) {
                        this.m_StepVirtualPoints.remove(p_StepIndex);
                    }
                }
            }

            public int getStepCount() {
                return this.m_StepValues.size();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public ArrayList<Double> getStepValues(int p_StepIndex) {
                if (p_StepIndex < 0) {
                    return null;
                }
                Object object = this.m_SyncValues;
                synchronized (object) {
                    if (p_StepIndex >= this.m_StepValues.size()) {
                        return null;
                    }
                    return this.m_StepValues.get(p_StepIndex);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public double getStepValue(int p_StepIndex, int p_ControlIndex, int p_DimensionIndex) {
                if (p_StepIndex < 0) {
                    return -1.0;
                }
                if (p_ControlIndex < 0) {
                    return -1.0;
                }
                if (p_DimensionIndex < 0) {
                    return -1.0;
                }
                Object object = this.m_SyncValues;
                synchronized (object) {
                    DMXEffect_ValuesMatrix o_DMXEffect_ValuesMatrix = this.m_DMXEffect_ValuesMatrix;
                    if (o_DMXEffect_ValuesMatrix == null) {
                        return -1.0;
                    }
                    if (p_StepIndex >= this.m_StepValues.size()) {
                        return -1.0;
                    }
                    ArrayList<Double> o_ArrayList_Values = this.m_StepValues.get(p_StepIndex);
                    int intValueIndex = p_ControlIndex * o_DMXEffect_ValuesMatrix.getDimensionCount();
                    if ((intValueIndex += p_DimensionIndex) >= o_ArrayList_Values.size()) {
                        return -1.0;
                    }
                    return o_ArrayList_Values.get(intValueIndex);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean setValues(ArrayList<Double> p_Values, int p_StepIndex) {
                block11: {
                    if (p_Values == null) {
                        return false;
                    }
                    if (p_StepIndex < 0) {
                        return false;
                    }
                    DMXEffect_ValuesMatrix o_DMXEffect_ValuesMatrix = this.m_DMXEffect_ValuesMatrix;
                    if (o_DMXEffect_ValuesMatrix == null) {
                        return false;
                    }
                    DMXEffectElement o_DMXEffectElement = o_DMXEffect_ValuesMatrix.getDMXEffect_Function().getDMXEffectElement(this.m_Row);
                    ArrayList<Double> o_StepValues = this.getStepValues(p_StepIndex);
                    if (o_StepValues == null) {
                        return false;
                    }
                    if (o_StepValues.size() != p_Values.size()) {
                        return false;
                    }
                    Object object = this.m_SyncValues;
                    synchronized (object) {
                        block10: {
                            if (!"pantilt".equals(o_DMXEffect_ValuesMatrix.getDMXEffect_Function().getDMXControlDescriptionID())) break block10;
                            for (int intValue = 0; intValue < o_StepValues.size(); ++intValue) {
                                o_StepValues.set(intValue, p_Values.get(intValue));
                            }
                            if (o_DMXEffectElement == null) break block11;
                            DMXControl_GridPanTilt_DeviceSettings.VirtualPoint o_VirtualPoint = this.getStepVirtualPoint(p_StepIndex);
                            o_VirtualPoint = DMXControl_GridPanTilt_DeviceSettings.calculateVirtualPointFromAnglesBilinear(o_VirtualPoint, o_DMXEffectElement.getDMXDevice(), o_StepValues.get(0), o_StepValues.get(1), false);
                            if (this.m_StepVirtualPoints == null) break block11;
                            this.m_StepVirtualPoints.set(p_StepIndex, o_VirtualPoint);
                            break block11;
                        }
                        for (int intValue = 0; intValue < o_StepValues.size(); ++intValue) {
                            o_StepValues.set(intValue, p_Values.get(intValue));
                        }
                    }
                }
                return true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean setValuesToReplace(ArrayList<Double> p_Values, int p_StepIndex) {
                block11: {
                    if (p_Values == null) {
                        return false;
                    }
                    if (p_StepIndex < 0) {
                        return false;
                    }
                    DMXEffect_ValuesMatrix o_DMXEffect_ValuesMatrix = this.m_DMXEffect_ValuesMatrix;
                    if (o_DMXEffect_ValuesMatrix == null) {
                        return false;
                    }
                    DMXEffectElement o_DMXEffectElement = o_DMXEffect_ValuesMatrix.getDMXEffect_Function().getDMXEffectElement(this.m_Row);
                    ArrayList<Double> o_StepValues = this.getStepValues(p_StepIndex);
                    if (o_StepValues == null) {
                        return false;
                    }
                    if (o_StepValues.size() != p_Values.size()) {
                        return false;
                    }
                    Object object = this.m_SyncValues;
                    synchronized (object) {
                        block10: {
                            if (!"pantilt".equals(o_DMXEffect_ValuesMatrix.getDMXEffect_Function().getDMXControlDescriptionID())) break block10;
                            for (int intValue = 0; intValue < o_StepValues.size(); ++intValue) {
                                o_StepValues.set(intValue, p_Values.get(intValue));
                            }
                            if (o_DMXEffectElement == null) break block11;
                            DMXControl_GridPanTilt_DeviceSettings.VirtualPoint o_VirtualPoint = this.getStepVirtualPoint(p_StepIndex);
                            o_VirtualPoint = DMXControl_GridPanTilt_DeviceSettings.calculateVirtualPointFromAnglesBilinear(o_VirtualPoint, o_DMXEffectElement.getDMXDevice(), o_StepValues.get(0), o_StepValues.get(1), false);
                            if (this.m_StepVirtualPoints == null) break block11;
                            this.m_StepVirtualPoints.set(p_StepIndex, o_VirtualPoint);
                            break block11;
                        }
                        for (int intValue = 0; intValue < o_StepValues.size(); ++intValue) {
                            o_StepValues.set(intValue, p_Values.get(intValue));
                        }
                    }
                }
                return true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean setStepValuePanTilt(double p_ValueX, double p_ValueY, int p_StepIndex, DMXControl_GridPanTilt_DeviceSettings.VirtualPoint p_VirtualPoint) {
                if (p_StepIndex < 0) {
                    return false;
                }
                Object object = this.m_SyncValues;
                synchronized (object) {
                    DMXEffect_ValuesMatrix o_DMXEffect_ValuesMatrix = this.m_DMXEffect_ValuesMatrix;
                    if (o_DMXEffect_ValuesMatrix == null) {
                        return false;
                    }
                    ArrayList<Double> o_StepValues = this.getStepValues(p_StepIndex);
                    if (o_StepValues == null) {
                        return false;
                    }
                    if (o_StepValues.size() != 2) {
                        return false;
                    }
                    o_StepValues.set(0, p_ValueX);
                    o_StepValues.set(1, p_ValueY);
                    if (this.m_StepVirtualPoints != null) {
                        this.m_StepVirtualPoints.set(p_StepIndex, p_VirtualPoint);
                    }
                }
                return true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public DMXControl_GridPanTilt_DeviceSettings.VirtualPoint getStepVirtualPoint(int p_StepIndex) {
                if (p_StepIndex < 0) {
                    return null;
                }
                Object object = this.m_SyncValues;
                synchronized (object) {
                    if (this.m_StepVirtualPoints == null) {
                        return null;
                    }
                    if (p_StepIndex >= this.m_StepVirtualPoints.size()) {
                        return null;
                    }
                    return this.m_StepVirtualPoints.get(p_StepIndex);
                }
            }

            public DMXDevice getDMXDevice() {
                DMXEffect_ValuesMatrix o_DMXEffect_ValuesMatrix = this.m_DMXEffect_ValuesMatrix;
                if (o_DMXEffect_ValuesMatrix == null) {
                    return null;
                }
                DMXEffectElement o_DMXEffectElement = o_DMXEffect_ValuesMatrix.getDMXEffectElement(this.m_Row);
                if (o_DMXEffectElement == null) {
                    return null;
                }
                return o_DMXEffectElement.getDMXDevice();
            }

            public void recalculateValues() {
                DMXEffect_ValuesMatrix o_DMXEffect_ValuesMatrix = this.m_DMXEffect_ValuesMatrix;
                if (o_DMXEffect_ValuesMatrix == null) {
                    return;
                }
                if ("pantilt".equals(o_DMXEffect_ValuesMatrix.getDMXEffect_Function().getDMXControlDescriptionID()) && this.m_StepVirtualPoints != null) {
                    for (int intStep = 0; intStep < this.m_StepVirtualPoints.size(); ++intStep) {
                        Point2D o_Point2D;
                        DMXDevice o_DMXDevice;
                        ArrayList<Double> o_StepValues;
                        DMXControl_GridPanTilt_DeviceSettings.VirtualPoint o_VirtualPoint = this.m_StepVirtualPoints.get(intStep);
                        if (o_VirtualPoint == null || (o_StepValues = this.getStepValues(intStep)) == null || (o_DMXDevice = this.getDMXDevice()) == null || (o_Point2D = DMXControl_GridPanTilt_DeviceSettings.calculateAnglesFromVirtualPoint(null, o_DMXDevice, o_VirtualPoint)) == null) continue;
                        o_StepValues.set(0, o_Point2D.getX());
                        o_StepValues.set(1, o_Point2D.getY());
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean calculateIsOnSteps(DMXEffectElement p_DMXEffectElement, ArrayList<Integer> p_DMXDeviceElementIsOnSteps) {
                if (p_DMXEffectElement == null) {
                    return false;
                }
                if (p_DMXDeviceElementIsOnSteps == null) {
                    return false;
                }
                DMXControlComponent o_DMXControlComponent = p_DMXEffectElement.getDMXControlComponent();
                boolean boolChanged = false;
                Object object = this.m_SyncValues;
                synchronized (object) {
                    p_DMXEffectElement.clearIsOnSteps();
                    for (int intStep = 0; intStep < this.m_StepValues.size(); ++intStep) {
                        int intStepIsOnExists;
                        int intIndex;
                        ArrayList<Double> o_Values = this.getStepValues(intStep);
                        if (!o_DMXControlComponent.getIsOn(o_Values)) continue;
                        p_DMXEffectElement.addIsOnStep(intStep);
                        if (p_DMXDeviceElementIsOnSteps.contains(intStep)) continue;
                        for (intIndex = 0; intIndex < p_DMXDeviceElementIsOnSteps.size() && intStep >= (intStepIsOnExists = p_DMXDeviceElementIsOnSteps.get(intIndex).intValue()); ++intIndex) {
                        }
                        p_DMXDeviceElementIsOnSteps.add(intIndex, intStep);
                        boolChanged = true;
                    }
                }
                return boolChanged;
            }
        }
    }

    public static class DMXEffectElementList {
        public static String PROP_DMXEFFECTELEMENTLIST_CHANGED = "dmxeffectelementlist_changed";
        public static String PROP_DMXEFFECTELEMENTLIST_ELEMENTADDED = "dmxeffectelementlist_elementadded";
        public static String PROP_DMXEFFECTELEMENTLIST_ELEMENTREMOVED = "dmxeffectelementlist_elementremoved";
        private DMXEffect_Function m_DMXEffect_Function;
        private ArrayList<DMXEffectElement> m_DMXEffectElements;
        private SinglePropertyChangeSupport m_PropertyChangeSupport;
        private final Object m_SyncElements = new Object();

        public DMXEffectElementList(DMXEffect_Function p_DMXEffect_Function) {
            this.initMembers();
            this.m_DMXEffect_Function = p_DMXEffect_Function;
        }

        private void initMembers() {
            this.m_DMXEffectElements = new ArrayList();
            this.m_PropertyChangeSupport = new SinglePropertyChangeSupport(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            Object object = this.m_SyncElements;
            synchronized (object) {
                for (int intElement = this.m_DMXEffectElements.size() - 1; intElement >= 0; --intElement) {
                    DMXEffectElement o_DMXEffectElement = this.m_DMXEffectElements.get(intElement);
                    this.removeDMXEffectElement(o_DMXEffectElement);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DMXEffectElement addDMXControlComponent(int p_StartIndex, DMXEffect.DMXDeviceElement p_DMXDeviceElement, DMXControlComponent p_DMXControlComponent, int p_DMXControlComponentIndex, int p_InternalRow) {
            DMXEffectElement o_DMXEffectElement;
            if (p_DMXControlComponent == null) {
                return null;
            }
            if (p_DMXDeviceElement == null) {
                return null;
            }
            boolean boolAdded = false;
            Object object = this.m_SyncElements;
            synchronized (object) {
                int intElement;
                for (intElement = 0; intElement < this.m_DMXEffectElements.size(); ++intElement) {
                    o_DMXEffectElement = this.m_DMXEffectElements.get(intElement);
                    if (o_DMXEffectElement.getDMXControlComponent() != p_DMXControlComponent) continue;
                    return null;
                }
                o_DMXEffectElement = new DMXEffectElement(this.m_DMXEffect_Function, p_DMXDeviceElement, p_DMXControlComponent, p_DMXControlComponentIndex, p_InternalRow);
                this.m_DMXEffectElements.add(p_StartIndex, o_DMXEffectElement);
                this.notifyDMXEffectElementAdded(intElement, o_DMXEffectElement);
            }
            return o_DMXEffectElement;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DMXEffectElement removeDMXEffectElement(DMXEffectElement p_DMXEffectElement) {
            int intIndex;
            if (p_DMXEffectElement == null) {
                return null;
            }
            boolean boolRemoved = false;
            Object object = this.m_SyncElements;
            synchronized (object) {
                intIndex = this.m_DMXEffectElements.indexOf(p_DMXEffectElement);
                if (intIndex < 0) {
                    return null;
                }
                boolRemoved = this.m_DMXEffectElements.remove(p_DMXEffectElement);
                p_DMXEffectElement.close();
            }
            if (boolRemoved) {
                this.notifyDMXEffectElementRemoved(intIndex, p_DMXEffectElement);
            }
            return p_DMXEffectElement;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DMXEffectElement removeDMXControlComponent(DMXControlComponent p_DMXControlComponent) {
            if (p_DMXControlComponent == null) {
                return null;
            }
            DMXEffectElement o_DMXEffectElement = null;
            Object object = this.m_SyncElements;
            synchronized (object) {
                for (int intElement = 0; intElement < this.m_DMXEffectElements.size(); ++intElement) {
                    o_DMXEffectElement = this.m_DMXEffectElements.get(intElement);
                    if (o_DMXEffectElement.getDMXControlComponent() != p_DMXControlComponent) continue;
                    return this.removeDMXEffectElement(o_DMXEffectElement);
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ArrayList<DMXEffectElement> getDMXEffectElements(DMXEffect.DMXDeviceElement p_DMXDeviceElement) {
            ArrayList<DMXEffectElement> o_DMXEffectElements = new ArrayList<DMXEffectElement>();
            Object object = this.m_SyncElements;
            synchronized (object) {
                for (int intElement = 0; intElement < this.m_DMXEffectElements.size(); ++intElement) {
                    DMXEffectElement o_DMXEffectElement = this.m_DMXEffectElements.get(intElement);
                    DMXEffect.DMXDeviceElement o_DMXDeviceElement = o_DMXEffectElement.getDMXDeviceElement();
                    if (o_DMXDeviceElement != p_DMXDeviceElement) continue;
                    o_DMXEffectElements.add(o_DMXEffectElement);
                }
            }
            return o_DMXEffectElements;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getLastIndexOfDMXEffectElements(DMXEffect.DMXDeviceElement p_DMXDeviceElement) {
            if (p_DMXDeviceElement == null) {
                return -1;
            }
            int intLastIndex = -1;
            Object object = this.m_SyncElements;
            synchronized (object) {
                for (int intElement = 0; intElement < this.m_DMXEffectElements.size(); ++intElement) {
                    DMXEffectElement o_DMXEffectElement = this.m_DMXEffectElements.get(intElement);
                    DMXEffect.DMXDeviceElement o_DMXDeviceElement = o_DMXEffectElement.getDMXDeviceElement();
                    if (o_DMXDeviceElement != p_DMXDeviceElement) continue;
                    intLastIndex = intElement;
                }
            }
            return intLastIndex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean refreshDMXDeviceType(DMXEffect.DMXDeviceElement p_DMXDeviceElement, ArrayList<DMXControlComponent> p_DMXControlComponents) {
            if (p_DMXDeviceElement == null) {
                return false;
            }
            int intIndexFirst = 0;
            boolean boolChanged = false;
            Object object = this.m_SyncElements;
            synchronized (object) {
                DMXEffectElement o_DMXEffectElement;
                for (int intElement = this.m_DMXEffectElements.size() - 1; intElement >= 0; --intElement) {
                    o_DMXEffectElement = this.m_DMXEffectElements.get(intElement);
                    DMXEffect.DMXDeviceElement o_DMXDeviceElement = o_DMXEffectElement.getDMXDeviceElement();
                    if (o_DMXDeviceElement != p_DMXDeviceElement) continue;
                    intIndexFirst = intElement;
                    boolChanged = true;
                    this.m_DMXEffectElements.remove(intElement);
                    o_DMXEffectElement.close();
                }
                if (p_DMXControlComponents != null) {
                    for (int intControl = 0; intControl < p_DMXControlComponents.size(); ++intControl) {
                        DMXControlComponent o_DMXControlComponent = p_DMXControlComponents.get(intControl);
                        if (o_DMXControlComponent == null) continue;
                        boolChanged = true;
                        if (!p_DMXDeviceElement.getInvertedControls()) {
                            o_DMXEffectElement = new DMXEffectElement(this.m_DMXEffect_Function, p_DMXDeviceElement, o_DMXControlComponent, intControl, intControl);
                            this.m_DMXEffectElements.add(intIndexFirst, o_DMXEffectElement);
                            ++intIndexFirst;
                            continue;
                        }
                        o_DMXEffectElement = new DMXEffectElement(this.m_DMXEffect_Function, p_DMXDeviceElement, o_DMXControlComponent, intControl, p_DMXControlComponents.size() - 1 - intControl);
                        this.m_DMXEffectElements.add(intIndexFirst, o_DMXEffectElement);
                    }
                }
            }
            this.notifyDMXEffectElementListChanged();
            return boolChanged;
        }

        public int size() {
            return this.m_DMXEffectElements.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DMXEffectElement get(int p_Index) {
            if (p_Index < 0) {
                return null;
            }
            Object object = this.m_SyncElements;
            synchronized (object) {
                if (p_Index >= this.m_DMXEffectElements.size()) {
                    return null;
                }
                return this.m_DMXEffectElements.get(p_Index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DMXEffectElement get(DMXControlComponent p_DMXControlComponent) {
            Object object = this.m_SyncElements;
            synchronized (object) {
                for (int intElement = 0; intElement < this.m_DMXEffectElements.size(); ++intElement) {
                    DMXEffectElement o_DMXEffectElement = this.m_DMXEffectElements.get(intElement);
                    if (o_DMXEffectElement.getDMXControlComponent() != p_DMXControlComponent) continue;
                    return o_DMXEffectElement;
                }
            }
            return null;
        }

        public int getIndexOf(DMXEffectElement p_DMXEffectElement) {
            if (p_DMXEffectElement == null) {
                return -1;
            }
            return this.m_DMXEffectElements.indexOf(p_DMXEffectElement);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getIndexOf(DMXEffect.DMXDeviceElement p_DMXDeviceElement) {
            DMXEffect.DMXDeviceElement o_DMXDeviceElementOld = null;
            int intIndexCounter = -1;
            boolean boolFound = false;
            Object object = this.m_SyncElements;
            synchronized (object) {
                for (int intElement = 0; intElement < this.m_DMXEffectElements.size(); ++intElement) {
                    DMXEffectElement o_DMXEffectElement = this.m_DMXEffectElements.get(intElement);
                    DMXEffect.DMXDeviceElement o_DMXDeviceElement = o_DMXEffectElement.getDMXDeviceElement();
                    if (o_DMXDeviceElementOld != o_DMXDeviceElement) {
                        ++intIndexCounter;
                        o_DMXDeviceElementOld = o_DMXDeviceElement;
                    }
                    if (o_DMXDeviceElement != p_DMXDeviceElement) continue;
                    boolFound = true;
                    break;
                }
                if (!boolFound) {
                    intIndexCounter = -1;
                }
            }
            return intIndexCounter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean moveDMXDevice(int p_OldDMXDeviceIndex, int p_NewDMXDeviceIndex) {
            if (p_OldDMXDeviceIndex < 0) {
                return false;
            }
            if (p_NewDMXDeviceIndex < 0) {
                return false;
            }
            DMXEffectElement o_DMXEffectElement = null;
            DMXDevice o_DMXDevice = null;
            DMXDevice o_DMXDeviceOld = null;
            int intIndexCounter = -1;
            Object object = this.m_SyncElements;
            synchronized (object) {
                int intFoundElement;
                int intElement;
                for (intElement = 0; intElement < this.m_DMXEffectElements.size(); ++intElement) {
                    o_DMXEffectElement = this.m_DMXEffectElements.get(intElement);
                    o_DMXDevice = o_DMXEffectElement.getDMXDevice();
                    if (o_DMXDevice != o_DMXDeviceOld) {
                        o_DMXDeviceOld = o_DMXDevice;
                        if (++intIndexCounter == p_OldDMXDeviceIndex) break;
                    }
                    o_DMXEffectElement = null;
                }
                if (o_DMXEffectElement == null) {
                    return false;
                }
                ArrayList<DMXEffectElement> o_DMXEffectElements = new ArrayList<DMXEffectElement>();
                o_DMXEffectElements.add(o_DMXEffectElement);
                ++intElement;
                while (intElement < this.m_DMXEffectElements.size() && (o_DMXEffectElement = this.m_DMXEffectElements.get(intElement)).getDMXDevice() == o_DMXDevice) {
                    o_DMXEffectElements.add(o_DMXEffectElement);
                    ++intElement;
                }
                for (intFoundElement = 0; intFoundElement < o_DMXEffectElements.size(); ++intFoundElement) {
                    o_DMXEffectElement = (DMXEffectElement)o_DMXEffectElements.get(intFoundElement);
                    this.m_DMXEffectElements.remove(o_DMXEffectElement);
                }
                intIndexCounter = -1;
                for (intElement = 0; intElement < this.m_DMXEffectElements.size(); ++intElement) {
                    o_DMXEffectElement = this.m_DMXEffectElements.get(intElement);
                    o_DMXDevice = o_DMXEffectElement.getDMXDevice();
                    if (o_DMXDevice != o_DMXDeviceOld) {
                        o_DMXDeviceOld = o_DMXDevice;
                        if (++intIndexCounter == p_NewDMXDeviceIndex) break;
                    }
                    o_DMXEffectElement = null;
                }
                for (intFoundElement = 0; intFoundElement < o_DMXEffectElements.size(); ++intFoundElement) {
                    o_DMXEffectElement = (DMXEffectElement)o_DMXEffectElements.get(intFoundElement);
                    this.m_DMXEffectElements.add(intElement + intFoundElement, o_DMXEffectElement);
                }
            }
            return true;
        }

        public void addPropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
            this.m_PropertyChangeSupport.addPropertyChangeListener(p_PropertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
            this.m_PropertyChangeSupport.removePropertyChangeListener(p_PropertyChangeListener);
        }

        private void notifyDMXEffectElementListChanged() {
            this.m_PropertyChangeSupport.firePropertyChange(PROP_DMXEFFECTELEMENTLIST_CHANGED, null, this);
        }

        private void notifyDMXEffectElementAdded(int p_Index, DMXEffectElement p_DMXEffectElement) {
            this.m_PropertyChangeSupport.fireIndexedPropertyChange(PROP_DMXEFFECTELEMENTLIST_ELEMENTADDED, p_Index, null, p_DMXEffectElement);
        }

        private void notifyDMXEffectElementRemoved(int p_Index, DMXEffectElement p_DMXEffectElement) {
            this.m_PropertyChangeSupport.fireIndexedPropertyChange(PROP_DMXEFFECTELEMENTLIST_ELEMENTREMOVED, p_Index, p_DMXEffectElement, null);
        }
    }

    public static class StepFactor {
        private int m_Step_InEffect;
        private boolean m_InDelay;
        private long m_Loop;
        private double m_InsideStep;
        private double m_FlashPercent;
        private int m_Step_Actual;
        private double m_Factor_Actual;
        private int m_Step_Previous;
        private double m_Factor_Previos;
        private int m_Step_Next;
        private double m_Factor_Next;
        private boolean m_ReadDMXScene;
        private boolean m_IsLastStep;

        public StepFactor() {
            this.reset();
        }

        public void reset() {
            this.m_Step_InEffect = -1;
            this.m_InDelay = false;
            this.m_Loop = 0L;
            this.m_InsideStep = 0.0;
            this.m_Step_Actual = -1;
            this.m_Factor_Actual = 0.0;
            this.m_Step_Previous = -1;
            this.m_Factor_Previos = 0.0;
            this.m_Step_Next = -1;
            this.m_Factor_Next = 0.0;
            this.m_ReadDMXScene = false;
        }

        public double getInsideStep() {
            return this.m_InsideStep;
        }

        public void setInsideStep(double p_Step) {
            this.m_InsideStep = p_Step;
        }

        public void setLoop(long p_Loop) {
            if (p_Loop < 0L) {
                p_Loop = 0L;
            }
            this.m_Loop = p_Loop;
        }

        public long getLoop() {
            return this.m_Loop;
        }

        public void setFlashPercent(double p_FlashPercent) {
            if (p_FlashPercent < 0.0) {
                p_FlashPercent = 0.0;
            }
            if (p_FlashPercent > 1.0) {
                p_FlashPercent = 1.0;
            }
            this.m_FlashPercent = p_FlashPercent;
        }

        public double getFlashPercent() {
            return this.m_FlashPercent;
        }

        public int getStep_InEffect() {
            return this.m_Step_InEffect;
        }

        public void setStep_InEffect(int p_StepInEffect) {
            this.m_Step_InEffect = p_StepInEffect;
        }

        public boolean getInDelay() {
            return this.m_InDelay;
        }

        public int getStep_Actual() {
            return this.m_Step_Actual;
        }

        public void setStep_Actual(int p_StepActual) {
            this.m_Step_Actual = p_StepActual;
        }

        public double getFactor_Actual() {
            return this.m_Factor_Actual;
        }

        public void setFactor_Actual(double p_Factor) {
            this.m_Factor_Actual = p_Factor;
        }

        public int getStep_Previos() {
            return this.m_Step_Previous;
        }

        public void setStep_Previous(int p_StepPrevious) {
            this.m_Step_Previous = p_StepPrevious;
        }

        public double getFactor_Previuos() {
            return this.m_Factor_Previos;
        }

        public void setFactor_Previous(double p_Factor) {
            this.m_Factor_Previos = p_Factor;
        }

        public int getStep_Next() {
            return this.m_Step_Next;
        }

        public void setStep_Next(int p_StepNext) {
            this.m_Step_Next = p_StepNext;
        }

        public double getFactor_Next() {
            return this.m_Factor_Next;
        }

        public void setFactor_Next(double p_Factor) {
            this.m_Factor_Next = p_Factor;
        }

        public void setReadDMXScene(boolean p_ReadDMXScene) {
            this.m_ReadDMXScene = p_ReadDMXScene;
        }

        public boolean getReadDMXScene() {
            return this.m_ReadDMXScene;
        }

        public void setIsLastStep(boolean p_IsLastStep) {
            this.m_IsLastStep = p_IsLastStep;
        }

        public boolean getIsLastStep() {
            return this.m_IsLastStep;
        }

        public void calculateStep(LiveShowDMXObject p_LiveShowDMXObject, DMXEffect p_DMXEffect, DMXEffect_Function p_DMXEffect_Function, long p_FrameInsideObject, long p_Delay, long p_Duration, long p_Loops, int p_TriggerFlag) {
            int intMaxStepCounts;
            this.reset();
            if (p_DMXEffect == null) {
                return;
            }
            if (p_Duration <= 0L) {
                return;
            }
            long longFrameWithoutDelay = p_FrameInsideObject - p_Delay;
            boolean boolObjectLongerThanEffect = p_LiveShowDMXObject.getFrameLength() > p_Delay + p_Duration * p_Loops;
            long longLoop = (int)(longFrameWithoutDelay / p_Duration);
            this.setLoop(longLoop);
            if (p_Loops > 0L && longLoop >= p_Loops && boolObjectLongerThanEffect) {
                this.setReadDMXScene(true);
                return;
            }
            if (longFrameWithoutDelay < 0L) {
                this.m_InDelay = true;
            }
            if ((intMaxStepCounts = p_DMXEffect.getMaxStepCount()) <= 0) {
                return;
            }
            double doubleFramesPerStep = (double)p_Duration / (double)intMaxStepCounts;
            long longFlashFrames = (long)((double)p_DMXEffect_Function.getFadeTime() / LiveShowDMXVIP.FRAMETIME);
            double doubleFlashPercent = doubleFramesPerStep > 0.0 ? (double)longFlashFrames / doubleFramesPerStep : 0.0;
            this.setFlashPercent(doubleFlashPercent);
            switch (p_TriggerFlag) {
                case 1: {
                    break;
                }
                case 0: {
                    break;
                }
                default: {
                    return;
                }
            }
            double doubleStep = (double)longFrameWithoutDelay / doubleFramesPerStep;
            if (doubleStep < 0.0) {
                doubleStep = 0.0;
                this.setInsideStep(0.0);
            } else {
                this.setInsideStep(doubleStep - (double)((long)doubleStep));
            }
            int intStepInEffect = (int)doubleStep % intMaxStepCounts;
            this.setStep_InEffect(intStepInEffect);
            boolean boolIsLastStep = false;
            if (p_Loops > 0L && longLoop == p_Loops - 1L && boolObjectLongerThanEffect && (long)doubleStep % (long)intMaxStepCounts == (long)(intMaxStepCounts - 1)) {
                boolIsLastStep = true;
            }
            this.calculateStepFactors((int)doubleStep, boolIsLastStep, p_DMXEffect_Function);
        }

        public void calculateStepFactors(int p_Step, boolean p_LastStep, DMXEffect_Function p_DMXEffect_Function) {
            this.setIsLastStep(false);
            if (p_Step < 0) {
                return;
            }
            if (p_DMXEffect_Function == null) {
                return;
            }
            if (p_DMXEffect_Function.getStepCount() <= 0) {
                return;
            }
            int intStep_Actual = p_Step % p_DMXEffect_Function.getStepCount();
            this.setStep_Actual(intStep_Actual);
            int intStep_Next = intStep_Actual + 1;
            if (intStep_Next >= p_DMXEffect_Function.getStepCount()) {
                intStep_Next = 0;
            }
            this.setStep_Next(intStep_Next);
            int intStep_Previous = intStep_Actual - 1;
            if (intStep_Previous < 0) {
                intStep_Previous = p_DMXEffect_Function.getStepCount() - 1;
            }
            this.setStep_Previous(intStep_Previous);
            switch (p_DMXEffect_Function.getFadeType()) {
                case 0: {
                    this.setFactor_Actual(1.0);
                    break;
                }
                case 1: {
                    double doubleFadeFactorActual = 1.0 - this.getInsideStep();
                    double doubleFadeFactorNext = this.getInsideStep();
                    double doubleFadeFactorPreviuos = 0.0;
                    this.setFactor_Actual(doubleFadeFactorActual);
                    this.setFactor_Next(doubleFadeFactorNext);
                    this.setFactor_Previous(doubleFadeFactorPreviuos);
                    if (!p_LastStep) break;
                    this.setIsLastStep(true);
                    break;
                }
                case 5: {
                    double doubleFadeFactorPreviuos;
                    double doubleFadeFactorNext;
                    double doubleFadeFactorActual;
                    if (this.getInsideStep() <= 0.5) {
                        doubleFadeFactorActual = this.getInsideStep() * 2.0;
                        doubleFadeFactorNext = 0.0;
                        doubleFadeFactorPreviuos = 0.0;
                    } else {
                        doubleFadeFactorActual = 1.0 - (this.getInsideStep() - 0.5) * 2.0;
                        doubleFadeFactorNext = 0.0;
                        doubleFadeFactorPreviuos = 0.0;
                    }
                    this.setFactor_Actual(doubleFadeFactorActual);
                    this.setFactor_Next(doubleFadeFactorNext);
                    this.setFactor_Previous(doubleFadeFactorPreviuos);
                    if (!p_LastStep || !(this.getInsideStep() > 0.5)) break;
                    this.setFactor_Actual(1.0 - (this.getInsideStep() - 0.5) * 2.0);
                    this.setFactor_Next((this.getInsideStep() - 0.5) * 2.0);
                    this.setIsLastStep(true);
                    break;
                }
                case 2: {
                    this.setFactor_Actual(this.getInsideStep());
                    break;
                }
                case 3: {
                    this.setFactor_Actual(1.0 - this.getInsideStep());
                    break;
                }
                case 4: {
                    if (this.getInsideStep() >= 0.5 - this.getFlashPercent() / 2.0 && this.getInsideStep() <= 0.5 + this.getFlashPercent() / 2.0) {
                        this.setFactor_Actual(1.0);
                        break;
                    }
                    this.setFactor_Actual(0.0);
                }
            }
        }
    }

    public static class DMXEffectElement {
        private DMXEffect_Function m_DMXEffect_Function;
        private DMXEffect.DMXDeviceElement m_DMXDeviceElement;
        private DMXControlComponent m_DMXControlComponent;
        private DMXControlComponent.DMXControlType m_DMXControlType_Device;
        private int m_DMXControlComponentIndex;
        private int m_InternalRowIndex;
        private boolean m_IsDimmable;
        private ArrayList<Integer> m_IsOnSteps;
        private final Object m_SyncObject = new Object();

        public DMXEffectElement(DMXEffect_Function p_DMXEffect_Function, DMXEffect.DMXDeviceElement p_DMXDeviceElement, DMXControlComponent p_DMXControlComponent, int p_DMXControlComponentIndex, int p_InternalRowIndex) {
            this.initMembers();
            this.m_DMXEffect_Function = p_DMXEffect_Function;
            this.m_DMXDeviceElement = p_DMXDeviceElement;
            this.setDMXControlComponent(p_DMXControlComponent);
            this.m_DMXControlComponentIndex = p_DMXControlComponentIndex;
            this.m_InternalRowIndex = p_InternalRowIndex;
            if (this.m_DMXControlComponent.getIsDimmerSubstitute() || this.m_DMXControlComponent.getIsDimmer()) {
                this.m_DMXDeviceElement.addDimmerDMXEffectElement(this);
                this.m_IsDimmable = true;
            } else {
                this.m_IsDimmable = false;
            }
        }

        private void initMembers() {
            this.m_IsOnSteps = new ArrayList();
        }

        public void close() {
            if (this.m_DMXControlComponent.getIsDimmerSubstitute() || this.m_DMXControlComponent.getIsDimmer()) {
                this.m_DMXDeviceElement.removeDimmerDMXEffectElement(this);
            }
        }

        public DMXEffect_Function getDMXEffect_Function() {
            return this.m_DMXEffect_Function;
        }

        public DMXEffect.DMXDeviceElement getDMXDeviceElement() {
            return this.m_DMXDeviceElement;
        }

        public DMXDevice getDMXDevice() {
            return this.m_DMXDeviceElement.getDMXDevice();
        }

        public DMXControlComponent.DMXControlType getDMXControlType_Device() {
            return this.m_DMXControlType_Device;
        }

        public void setDMXControlComponent(DMXControlComponent p_DMXControlComponent) {
            if (p_DMXControlComponent == null) {
                return;
            }
            this.m_DMXControlComponent = p_DMXControlComponent;
            DMXDevice o_DMXDevice = this.m_DMXDeviceElement.getDMXDevice();
            DMXControlComponent.DMXControlType o_DMXControlType_Control = this.m_DMXControlComponent.getDMXControlType();
            this.m_DMXControlType_Device = o_DMXDevice.getDMXDeviceType().getDMXControlType(o_DMXControlType_Control.getID());
        }

        public DMXControlComponent getDMXControlComponent() {
            return this.m_DMXControlComponent;
        }

        public int getDMXControlComponentIndex() {
            return this.m_DMXControlComponentIndex;
        }

        public int getInternalRowIndex() {
            return this.m_InternalRowIndex;
        }

        public boolean isDimmable() {
            return this.m_IsDimmable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clearIsOnSteps() {
            Object object = this.m_SyncObject;
            synchronized (object) {
                this.m_IsOnSteps.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addIsOnStep(int p_Step) {
            if (p_Step < 0) {
                return;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                int intStepExist;
                for (int intIndex = 0; intIndex < this.m_IsOnSteps.size() && p_Step >= (intStepExist = this.m_IsOnSteps.get(intIndex).intValue()); ++intIndex) {
                    if (p_Step != intStepExist) continue;
                    return;
                }
                this.m_IsOnSteps.add(p_Step);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getFirstStepOn() {
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (this.m_IsOnSteps.size() <= 0) {
                    return -1;
                }
                return this.m_IsOnSteps.get(0);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getIsOnStepCount() {
            Object object = this.m_SyncObject;
            synchronized (object) {
                return this.m_IsOnSteps.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getIsOnStep(int p_Index) {
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (this.m_IsOnSteps.size() <= 0) {
                    return -1;
                }
                if (p_Index >= this.m_IsOnSteps.size()) {
                    return -1;
                }
                return this.m_IsOnSteps.get(p_Index);
            }
        }
    }
}

