/*
 * Decompiled with CFR 0.152.
 */
package DMXDevicePackage;

import DMXDevicePackage.DMXDevice;
import DMXDevicePackage.DMXDeviceFilter;
import DMXDevicePackage.DMXDeviceType;
import DMXDevicePackage.DMXDeviceView;
import DMXGraphics.LiveShowDMXStageView;
import DMXMixer.DMXControlComponent;
import DMXMixer.DMXControlDescription;
import DMXMixer.DMXControl_GridPanTilt;
import DMXMixer.DMXControl_GridPanTilt_DeviceSettings;
import GUID.LiveGUID;
import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LanguageTools.LiveLanguagePackage.LiveLanguageString;
import LiveShowControlObjects.ControlObject;
import LiveShowObjectPackage.LiveShowProjectDescription;
import LiveShowObjectPackage.SinglePropertyChangeSupport;
import LiveShowVirtualPackage.LiveShow_ImportDescription;
import SwingModelPackage.TableAndListModel;
import SwingToolTipPackage.PopUpToolTip;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Externalizable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;

public class DMXPresets
implements Externalizable,
DMXDeviceFilter.FilterInterface {
    public static final int DMXPRESTES_SOFTWAREVERSION = 1;
    public static final int SOFTWAREVERSION = 1;
    public static final String FILESUFFIX = ".dpr";
    public static int DMXPRESETSCOUNT = 3;
    @LiveLanguageString
    public static String s_NamePresets_Position = "Presets Position";
    @LiveLanguageString
    public static String s_RemarkPresets_Position = "(Pan/Tilt, zoom, focus, iris, framing, prisma)";
    public static ImageIcon s_Icon_Position = new ImageIcon(DMXPresets.class.getResource("/IconsPackage/GridAdjuster_16.png"));
    public static String[] s_ArrayID_Position = new String[]{"pantilt", "focus", "iris", "zoom", "frame", "frameangle", "frameheader", "prisma"};
    public static DMXPresets s_Presets_Position = new DMXPresets(s_ArrayID_Position, s_Icon_Position);
    @LiveLanguageString
    public static String s_NamePresets_Color = "Presets Color";
    @LiveLanguageString
    public static String s_RemarkPresets_Color = "(rgb, extra colors, color wheels, temperature)";
    public static ImageIcon s_Icon_Color = new ImageIcon(DMXPresets.class.getResource("/IconsPackage/Color_RGB_CMY.png"));
    public static String[] s_ArrayID_Color = new String[]{"rgbcmy", "coloramber", "colorlime", "coloruv", "colorcyan", "colormagenta", "coloryellow", "colorwhite", "colorwhitecold", "colorwhitewarm", "color1", "color2", "colortemperature"};
    public static DMXPresets s_Presets_Color = new DMXPresets(s_ArrayID_Color, s_Icon_Color);
    @LiveLanguageString
    public static String s_NamePresets_Dimmer = "Presets Dimmer";
    @LiveLanguageString
    public static String s_RemarkPresets_Dimmer = "(dimmer)";
    public static ImageIcon s_Icon_Dimmer = new ImageIcon(DMXPresets.class.getResource("/IconsPackage/Slider_Small.png"));
    public static String[] s_ArrayID_Dimmer = new String[]{"dimmer"};
    public static DMXPresets s_Presets_Dimmer = new DMXPresets(s_ArrayID_Dimmer, s_Icon_Dimmer);
    private String[] m_DMXControlDescriptionIDs;
    private ImageIcon m_Icon;
    private DMXPresetTableModel m_DMXPresetTableModel;
    private int m_NameCounter;
    private final Object m_SyncObject = new Object();
    public static ArrayList<DMXDevice> s_DMXDevices_ToSave;
    public static boolean s_IsImport;

    public static DMXPresets getDMXPresets(String p_DMXControlDescriptionID) {
        String stringControlDescriptionID;
        int intID;
        if (p_DMXControlDescriptionID == null) {
            return null;
        }
        String[] arrayIDs = s_Presets_Dimmer.getDMXControlDescriptionIDs();
        if (arrayIDs == null || arrayIDs.length <= 0) {
            return null;
        }
        for (intID = 0; intID < arrayIDs.length; ++intID) {
            stringControlDescriptionID = arrayIDs[intID];
            if (!p_DMXControlDescriptionID.equals(stringControlDescriptionID)) continue;
            return s_Presets_Dimmer;
        }
        arrayIDs = s_Presets_Color.getDMXControlDescriptionIDs();
        if (arrayIDs == null || arrayIDs.length <= 0) {
            return null;
        }
        for (intID = 0; intID < arrayIDs.length; ++intID) {
            stringControlDescriptionID = arrayIDs[intID];
            if (!p_DMXControlDescriptionID.equals(stringControlDescriptionID)) continue;
            return s_Presets_Color;
        }
        arrayIDs = s_Presets_Position.getDMXControlDescriptionIDs();
        if (arrayIDs == null || arrayIDs.length <= 0) {
            return null;
        }
        for (intID = 0; intID < arrayIDs.length; ++intID) {
            stringControlDescriptionID = arrayIDs[intID];
            if (!p_DMXControlDescriptionID.equals(stringControlDescriptionID)) continue;
            return s_Presets_Position;
        }
        return null;
    }

    public static void addDMXDevice(DMXDevice p_DMXDevice) {
        s_Presets_Dimmer.addDMXDeviceInternal(p_DMXDevice);
        s_Presets_Position.addDMXDeviceInternal(p_DMXDevice);
        s_Presets_Color.addDMXDeviceInternal(p_DMXDevice);
    }

    public static void removeDMXDevice(DMXDevice p_DMXDevice) {
        s_Presets_Dimmer.addDMXDeviceInternal(p_DMXDevice);
        s_Presets_Position.removedDMXDeviceInternal(p_DMXDevice);
        s_Presets_Color.removedDMXDeviceInternal(p_DMXDevice);
    }

    public static void closeDMXPresets() {
        s_Presets_Dimmer.clearDMXPresets();
        s_Presets_Position.clearDMXPresets();
        s_Presets_Color.clearDMXPresets();
    }

    public static boolean deleteDMXPresets(LiveShowProjectDescription p_LiveShowProjectDescription) {
        if (p_LiveShowProjectDescription == null) {
            return false;
        }
        boolean boolSuccess = false;
        String stringFileName = p_LiveShowProjectDescription.getProjectPathName() + FILESUFFIX;
        File o_File = new File(stringFileName);
        if (o_File.exists()) {
            try {
                boolSuccess = o_File.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        DMXDeviceType.deleteProjectDMXDeviceTypes(p_LiveShowProjectDescription);
        return boolSuccess;
    }

    public static void saveDMXPresets(LiveShowProjectDescription p_LiveShowProjectDescription, ArrayList<DMXDevice> p_DMXDevices) {
        ObjectOutput o_ObjectOutput = null;
        FileOutputStream o_FileOutputStream = null;
        String stringFileName = p_LiveShowProjectDescription.getProjectPathName() + FILESUFFIX;
        try {
            File o_File = new File(stringFileName);
            if (o_File.exists()) {
                try {
                    o_File.delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            o_File.createNewFile();
            o_FileOutputStream = new FileOutputStream(o_File);
            o_ObjectOutput = new ObjectOutputStream(o_FileOutputStream);
            o_ObjectOutput.writeInt(1);
            s_DMXDevices_ToSave = p_DMXDevices;
            o_ObjectOutput.writeInt(DMXPRESETSCOUNT);
            s_Presets_Position.writeExternal(o_ObjectOutput);
            s_Presets_Color.writeExternal(o_ObjectOutput);
            s_Presets_Dimmer.writeExternal(o_ObjectOutput);
            o_ObjectOutput.close();
            o_FileOutputStream.close();
        }
        catch (Exception e) {
            try {
                if (o_ObjectOutput != null) {
                    o_ObjectOutput.close();
                }
                if (o_FileOutputStream != null) {
                    o_FileOutputStream.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            boolean bl = false;
        }
    }

    public static boolean loadDMXPresets(LiveShowProjectDescription p_LiveShowProjectDescription, LiveShow_ImportDescription p_LiveShow_ImportDescription) {
        if (p_LiveShowProjectDescription == null) {
            return false;
        }
        String stringFileName = p_LiveShowProjectDescription.getProjectPathName() + FILESUFFIX;
        if (p_LiveShowProjectDescription == null || p_LiveShow_ImportDescription.getLoadNewProject()) {
            return DMXPresets.loadDMXPresets(stringFileName, false, null);
        }
        return DMXPresets.loadDMXPresets(stringFileName, true, p_LiveShow_ImportDescription);
    }

    public static boolean loadDMXPresets(String p_FileName, boolean p_IsImport, LiveShow_ImportDescription p_LiveShow_ImportDescription) {
        if (p_FileName == null) {
            return false;
        }
        s_IsImport = p_IsImport;
        try {
            String stringFileNamePostfix = p_FileName.substring(p_FileName.length() - 4, p_FileName.length());
            if (!stringFileNamePostfix.equals(FILESUFFIX)) {
                return false;
            }
            String stringRareFileName = p_FileName.substring(0, p_FileName.length() - 4);
        }
        catch (Exception e) {
            return false;
        }
        FileInputStream o_FileInputStream = null;
        ObjectInput o_ObjectInput = null;
        try {
            File o_File = new File(p_FileName);
            o_FileInputStream = new FileInputStream(o_File);
            o_ObjectInput = new ObjectInputStream(o_FileInputStream);
            int intDMXPreset_SoftwareVersion = o_ObjectInput.readInt();
            int intDMXPresetsTypeCount = o_ObjectInput.readInt();
            if (intDMXPresetsTypeCount >= 1) {
                s_Presets_Position.readExternal(o_ObjectInput);
            }
            if (intDMXPresetsTypeCount >= 2) {
                s_Presets_Color.readExternal(o_ObjectInput);
            }
            if (intDMXPresetsTypeCount >= 3) {
                s_Presets_Dimmer.readExternal(o_ObjectInput);
            }
            if (o_ObjectInput != null) {
                o_ObjectInput.close();
            }
            if (o_FileInputStream != null) {
                o_FileInputStream.close();
            }
        }
        catch (Exception e) {
            try {
                if (o_ObjectInput != null) {
                    o_ObjectInput.close();
                }
                if (o_FileInputStream != null) {
                    o_FileInputStream.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
        return true;
    }

    public DMXPresets(String[] p_DMXControlDescriptionID, ImageIcon p_ImageIcon) {
        this.initMembers();
        this.m_DMXControlDescriptionIDs = p_DMXControlDescriptionID;
        this.m_Icon = p_ImageIcon;
        this.m_DMXPresetTableModel.setIcon(this.m_Icon);
        LiveLanguage.addLanguageListener((Object)this, null);
        DMXDeviceFilter o_DMXDeviceFilter = DMXDeviceFilter.createDMXDeviceFilter(this);
    }

    private void initMembers() {
        this.m_NameCounter = 1;
        this.m_DMXPresetTableModel = new DMXPresetTableModel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(1);
        ArrayList<DMXPreset> o_DMXPresets = new ArrayList<DMXPreset>();
        Object object = this.m_SyncObject;
        synchronized (object) {
            DMXPreset o_DMXPreset;
            int intDMXPreset;
            int intDMXPresetCount;
            if (s_DMXDevices_ToSave == null) {
                o_DMXPresets.addAll(this.m_DMXPresetTableModel.getDMXPresets());
            } else {
                intDMXPresetCount = this.m_DMXPresetTableModel.size();
                for (intDMXPreset = 0; intDMXPreset < intDMXPresetCount; ++intDMXPreset) {
                    o_DMXPreset = this.m_DMXPresetTableModel.getDMXPreset(intDMXPreset);
                    for (int intDMXDevice = 0; intDMXDevice < s_DMXDevices_ToSave.size(); ++intDMXDevice) {
                        DMXDevice o_DMXDevice = s_DMXDevices_ToSave.get(intDMXDevice);
                        if (!this.affectsDMXDevice(o_DMXDevice)) continue;
                        o_DMXPresets.add(o_DMXPreset);
                    }
                }
            }
            intDMXPresetCount = o_DMXPresets.size();
            out.writeInt(intDMXPresetCount);
            for (intDMXPreset = 0; intDMXPreset < intDMXPresetCount; ++intDMXPreset) {
                o_DMXPreset = (DMXPreset)o_DMXPresets.get(intDMXPreset);
                out.writeUTF(o_DMXPreset.getID());
                o_DMXPreset.writeExternal(out);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int intSoftwareVersion = in.readInt();
        Object object = this.m_SyncObject;
        synchronized (object) {
            int intDMXPresetCount = in.readInt();
            for (int intDMXPreset = 0; intDMXPreset < intDMXPresetCount; ++intDMXPreset) {
                String stringDMXPresetID = in.readUTF();
                DMXPreset o_DMXPreset = this.m_DMXPresetTableModel.getDMXPreset(stringDMXPresetID);
                if (o_DMXPreset == null) {
                    o_DMXPreset = new DMXPreset(this);
                    o_DMXPreset.readExternal(in);
                    if (s_IsImport) {
                        o_DMXPreset.setName(LiveShow_ImportDescription.createImportedName(o_DMXPreset.getName()));
                    }
                    this.m_DMXPresetTableModel.addDMXPreset(o_DMXPreset);
                    continue;
                }
                o_DMXPreset.readExternal(in);
            }
            this.m_NameCounter = this.m_DMXPresetTableModel.size() + 1;
        }
    }

    @Override
    public ImageIcon getIcon() {
        return this.m_Icon;
    }

    public int getNameCounter() {
        return this.m_NameCounter;
    }

    public void increaseNameCounter() {
        ++this.m_NameCounter;
    }

    public DMXPreset createDMXPreset() {
        DMXPreset o_DMXPreset = new DMXPreset(this);
        this.m_DMXPresetTableModel.addDMXPreset(o_DMXPreset);
        return o_DMXPreset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDMXPreset(DMXPreset p_DMXPreset) {
        if (p_DMXPreset == null) {
            return;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            this.m_DMXPresetTableModel.removeDMXPreset(p_DMXPreset);
            p_DMXPreset.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearDMXPresets() {
        Object object = this.m_SyncObject;
        synchronized (object) {
            for (int intDMXPreset = this.m_DMXPresetTableModel.size() - 1; intDMXPreset >= 0; --intDMXPreset) {
                DMXPreset o_DMXPreset = this.m_DMXPresetTableModel.getDMXPreset(intDMXPreset);
                this.removeDMXPreset(o_DMXPreset);
            }
        }
        this.m_NameCounter = 1;
    }

    public int getDMXPresetCount() {
        return this.m_DMXPresetTableModel.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DMXPreset getDMXPreset(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            return this.m_DMXPresetTableModel.getDMXPreset(p_Index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DMXPreset getDMXPreset(String p_DMXPresetID) {
        if (p_DMXPresetID == null) {
            return null;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            return this.m_DMXPresetTableModel.getDMXPreset(p_DMXPresetID);
        }
    }

    public String[] getDMXControlDescriptionIDs() {
        return this.m_DMXControlDescriptionIDs;
    }

    public DMXPresetTableModel getTableModel() {
        return this.m_DMXPresetTableModel;
    }

    public TableRowSorter getTableRowSorter_Devices() {
        return this.m_DMXPresetTableModel.m_TableRowSorter_Devices;
    }

    public DMXPresetsRowFilter getDMXPresetsRowFilter_Devices() {
        return this.m_DMXPresetTableModel.getDMXPresetsRowFilter_Devices();
    }

    public TableRowSorter getTableRowSorter_Text() {
        return this.m_DMXPresetTableModel.getTableRowSorter_Text();
    }

    public DMXPresetsRowFilter getDMXPresetsRowFilter_Text() {
        return this.m_DMXPresetTableModel.getDMXPresetsRowFilter_Text();
    }

    public boolean affectsDMXDevice(DMXDevice p_DMXDevice) {
        if (p_DMXDevice == null) {
            return false;
        }
        for (int intID = 0; intID < this.m_DMXControlDescriptionIDs.length; ++intID) {
            String stringDMXControlDescriptionID = this.m_DMXControlDescriptionIDs[intID];
            if (!p_DMXDevice.hasDMXControlComponents_DescriptionID(stringDMXControlDescriptionID)) continue;
            return true;
        }
        return false;
    }

    public boolean addDMXDeviceInternal(DMXDevice p_DMXDevice) {
        return p_DMXDevice != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removedDMXDeviceInternal(DMXDevice p_DMXDevice) {
        if (p_DMXDevice == null) {
            return;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            int intDMXPresetCount = this.m_DMXPresetTableModel.size();
            for (int intRow = 0; intRow < intDMXPresetCount; ++intRow) {
                DMXPreset o_DMXPreset = this.m_DMXPresetTableModel.getDMXPreset(intRow);
                if (o_DMXPreset == null) continue;
                o_DMXPreset.removeDMXDevice(p_DMXDevice);
            }
        }
    }

    @Override
    public String getName() {
        if (this == s_Presets_Dimmer) {
            return s_NamePresets_Dimmer;
        }
        if (this == s_Presets_Color) {
            return s_NamePresets_Color;
        }
        if (this == s_Presets_Position) {
            return s_NamePresets_Position;
        }
        return "";
    }

    @Override
    public String getRemark() {
        if (this == s_Presets_Dimmer) {
            return s_RemarkPresets_Dimmer;
        }
        if (this == s_Presets_Color) {
            return s_RemarkPresets_Color;
        }
        if (this == s_Presets_Position) {
            return s_RemarkPresets_Position;
        }
        return "";
    }

    @Override
    public boolean useDMXDevice(DMXDevice p_DMXDevice) {
        return this.affectsDMXDevice(p_DMXDevice);
    }

    public static class DMXPresetTableModel
    extends TableAndListModel<DMXPreset>
    implements PropertyChangeListener {
        public static final int COLUMNCOUNT = 2;
        public static final int COLUMNINDEX_DMXPRESET_NAME = 0;
        public static final int COLUMNINDEX_DMXPRESET_REMARK = 1;
        @LiveLanguageString
        public static String COLUMN_DMXPRESET_NAME = "Name";
        @LiveLanguageString
        public static String COLUMN_DMXPRESET_REMARK = "Description";
        private TableRowSorter m_TableRowSorter_Devices;
        private DMXPresetsRowFilter m_DMXPresetsRowFilter1_Devices;
        private TableRowSorter m_TableRowSorter_Text;
        private DMXPresetsRowFilter m_DMXPresetsRowFilter1_Text;
        private Icon m_Icon;
        private TableAndListModel.TableCellEditorRenderer_String m_TableCellEditorRenderer_String_Name;
        private TableAndListModel.TableCellEditorRenderer_String m_TableCellEditorRenderer_String_Remark;
        private final Object m_SyncObject = new Object();

        public DMXPresetTableModel() {
            super(false);
            this.initMembers();
            LiveLanguage.addLanguageListener((Object)this, null);
        }

        private void initMembers() {
            this.m_TableRowSorter_Devices = new TableRowSorter<DMXPresetTableModel>(this);
            this.m_DMXPresetsRowFilter1_Devices = new DMXPresetsRowFilter(this);
            this.m_TableRowSorter_Text = new TableRowSorter<DMXPresetTableModel>(this);
            this.m_DMXPresetsRowFilter1_Text = new DMXPresetsRowFilter(this);
        }

        public void setIcon(Icon p_Icon) {
            this.m_Icon = p_Icon;
        }

        public void finishJTable(JTable p_JTable, TableRowSorter p_TableRowSorter, DMXPresetsRowFilter p_DMXPresetsRowFilter) {
            TableAndListModel.TableCellEditorRenderer_String o_TableCellEditorRenderer_String;
            if (p_JTable == null) {
                return;
            }
            if (p_TableRowSorter != null) {
                p_TableRowSorter.setComparator(0, TableAndListModel.getStringComparator_Normal());
                p_TableRowSorter.setComparator(1, TableAndListModel.getStringComparator_Normal());
            }
            super.finishJTable(p_JTable, p_TableRowSorter, p_DMXPresetsRowFilter);
            TableColumnModel o_TableColumnModel = p_JTable.getColumnModel();
            TableColumn o_TableColumn = o_TableColumnModel.getColumn(0);
            if (o_TableColumn != null) {
                if (this.m_TableCellEditorRenderer_String_Name == null) {
                    this.m_TableCellEditorRenderer_String_Name = new TableAndListModel.TableCellEditorRenderer_String();
                }
                o_TableCellEditorRenderer_String = this.m_TableCellEditorRenderer_String_Name;
                o_TableCellEditorRenderer_String.setIcon(this.m_Icon);
                o_TableCellEditorRenderer_String.setHorizontalAlignment(10);
                o_TableCellEditorRenderer_String.setToolTipText_Automatic(2);
                o_TableCellEditorRenderer_String.setToolTipTextAt(false, true);
                o_TableColumn.setCellEditor(o_TableCellEditorRenderer_String);
                o_TableColumn.setCellRenderer(o_TableCellEditorRenderer_String);
            }
            if ((o_TableColumn = o_TableColumnModel.getColumn(1)) != null) {
                if (this.m_TableCellEditorRenderer_String_Remark == null) {
                    this.m_TableCellEditorRenderer_String_Remark = new TableAndListModel.TableCellEditorRenderer_String();
                }
                o_TableCellEditorRenderer_String = this.m_TableCellEditorRenderer_String_Remark;
                o_TableCellEditorRenderer_String.setHorizontalAlignment(10);
                o_TableCellEditorRenderer_String.setToolTipText_Automatic(2);
                o_TableCellEditorRenderer_String.setToolTipTextAt(false, true);
                o_TableColumn.setCellEditor(o_TableCellEditorRenderer_String);
                o_TableColumn.setCellRenderer(o_TableCellEditorRenderer_String);
            }
            p_JTable.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        }

        public void filter(String p_FilterString) {
            if (this.m_DMXPresetsRowFilter1_Text != null) {
                this.m_DMXPresetsRowFilter1_Text.setFilterString(p_FilterString);
            }
        }

        public void filter(ArrayList<DMXDevice> p_FilterDevices) {
            if (this.m_DMXPresetsRowFilter1_Devices != null) {
                this.m_DMXPresetsRowFilter1_Devices.setDMXDevices(p_FilterDevices);
            }
        }

        public TableRowSorter getTableRowSorter_Devices() {
            return this.m_TableRowSorter_Devices;
        }

        public DMXPresetsRowFilter getDMXPresetsRowFilter_Devices() {
            return this.m_DMXPresetsRowFilter1_Devices;
        }

        public TableRowSorter getTableRowSorter_Text() {
            return this.m_TableRowSorter_Text;
        }

        public DMXPresetsRowFilter getDMXPresetsRowFilter_Text() {
            return this.m_DMXPresetsRowFilter1_Text;
        }

        public ArrayList<DMXPreset> getDMXPresets() {
            return this.getElementArrayList();
        }

        @Override
        public boolean contains(String p_ID) {
            if (p_ID == null) {
                return false;
            }
            DMXPreset o_DMXPreset = this.getDMXPreset(p_ID);
            return o_DMXPreset != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DMXPreset getDMXPreset(String p_ID) {
            Object object = this.m_SyncObject;
            synchronized (object) {
                for (int intPreset = 0; intPreset < this.size(); ++intPreset) {
                    DMXPreset o_DMXPreset = (DMXPreset)this.get(intPreset);
                    if (o_DMXPreset == null || !p_ID.equals(o_DMXPreset.getID())) continue;
                    return o_DMXPreset;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addDMXPreset(DMXPreset p_DMXPreset) {
            if (p_DMXPreset == null) {
                return;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (!this.add(p_DMXPreset)) {
                    return;
                }
            }
            p_DMXPreset.addPropertyChangeListener(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeDMXPreset(DMXPreset p_DMXPreset) {
            if (p_DMXPreset == null) {
                return;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (!this.remove(p_DMXPreset)) {
                    return;
                }
            }
            p_DMXPreset.removePropertyChangeListener(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addSelectedDMXPreset(JTable p_JTable, DMXPreset p_DMXPreset) {
            if (p_JTable == null) {
                return;
            }
            if (p_DMXPreset == null) {
                return;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                this.addSelectedElement(p_JTable, p_DMXPreset);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeSelectedDMXPreset(JTable p_JTable, DMXPreset p_DMXPreset) {
            if (p_JTable == null) {
                return;
            }
            if (p_DMXPreset == null) {
                return;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                this.removeSelectedElement(p_JTable, p_DMXPreset);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DMXPreset getDMXPreset(int p_Index) {
            if (p_Index < 0) {
                return null;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                return (DMXPreset)this.get(p_Index);
            }
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return COLUMN_DMXPRESET_NAME;
                }
                case 1: {
                    return COLUMN_DMXPRESET_REMARK;
                }
            }
            return "";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getValue(DMXPreset p_DMXPreset, int columnIndex) {
            String stringValue = "";
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (p_DMXPreset == null) {
                    return stringValue;
                }
            }
            switch (columnIndex) {
                case 0: {
                    stringValue = p_DMXPreset.getName();
                    break;
                }
                case 1: {
                    stringValue = p_DMXPreset.getRemark();
                }
            }
            return stringValue;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            switch (col) {
                case 0: {
                    return true;
                }
                case 1: {
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setValue(DMXPreset p_DMXPreset, Object value, int col) {
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (p_DMXPreset == null) {
                    return;
                }
            }
            switch (col) {
                case 0: {
                    String stringValue = (String)value;
                    p_DMXPreset.setName(stringValue);
                    break;
                }
                case 1: {
                    String stringValue = (String)value;
                    p_DMXPreset.setRemark(stringValue);
                }
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() instanceof DMXPreset) {
                DMXPreset o_DMXPreset = (DMXPreset)evt.getSource();
                if ("dmxpresetName".equals(evt.getPropertyName())) {
                    this.changedElement(o_DMXPreset);
                } else if ("dmxpresetRemark".equals(evt.getPropertyName())) {
                    this.changedElement(o_DMXPreset);
                } else if ("dmxpresetClosed".equals(evt.getPropertyName())) {
                    // empty if block
                }
            }
        }
    }

    public static class DMXPreset_Device
    implements Externalizable {
        public static final int SOFTWAREVERSION = 2;
        protected DMXPresets m_DMXPresets;
        protected DMXPreset m_DMXPreset;
        protected DMXDevice m_DMXDevice;
        protected HashMap<String, HashMap<String, HashMap<Integer, ArrayList<Double>>>> m_Values;
        protected DMXControl_GridPanTilt_DeviceSettings.VirtualPoint m_VirtualPoint_PanTilt;
        protected Point2D m_Point2D;

        public DMXPreset_Device(DMXPresets p_DMXPresets, DMXPreset p_DMXPreset, DMXDevice p_DMXDevice) {
            this.m_DMXPresets = p_DMXPresets;
            this.m_DMXPreset = p_DMXPreset;
            this.m_DMXDevice = p_DMXDevice;
            this.initMembers();
        }

        private void initMembers() {
            this.m_Values = new HashMap();
            this.m_VirtualPoint_PanTilt = null;
            this.m_Point2D = null;
        }

        public void close() {
            this.m_DMXDevice = null;
            this.m_Values.clear();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(2);
            if (this.m_DMXDevice == null) {
                out.writeUTF("");
            } else {
                out.writeUTF(this.m_DMXDevice.getID());
            }
            int intDMXControlDescriptionIDCount = this.m_Values.size();
            out.writeInt(intDMXControlDescriptionIDCount);
            for (String stringDMXControlDescriptionID : this.m_Values.keySet()) {
                out.writeUTF(stringDMXControlDescriptionID);
                HashMap<String, HashMap<Integer, ArrayList<Double>>> o_Values_DMXControlType = this.m_Values.get(stringDMXControlDescriptionID);
                int intDMXControlTypeIDCount = o_Values_DMXControlType.size();
                out.writeInt(intDMXControlTypeIDCount);
                for (String stringDMXControlTypeID : o_Values_DMXControlType.keySet()) {
                    out.writeUTF(stringDMXControlTypeID);
                    HashMap<Integer, ArrayList<Double>> o_Values_ControlObjectIndex = o_Values_DMXControlType.get(stringDMXControlTypeID);
                    int intControlObjectIndexCount = o_Values_ControlObjectIndex.size();
                    out.writeInt(intControlObjectIndexCount);
                    for (int intControlObjectIndex : o_Values_ControlObjectIndex.keySet()) {
                        out.writeInt(intControlObjectIndex);
                        ArrayList<Double> o_Values_ControlDimension = o_Values_ControlObjectIndex.get(intControlObjectIndex);
                        int intDimensionCount = o_Values_ControlDimension.size();
                        out.writeInt(intDimensionCount);
                        for (int intDimension = 0; intDimension < intDimensionCount; ++intDimension) {
                            double doubleValueDimension = o_Values_ControlDimension.get(intDimension);
                            out.writeDouble(doubleValueDimension);
                        }
                        int intAdditionalCount = 0;
                        if ("pantilt".equals(stringDMXControlDescriptionID)) {
                            ++intAdditionalCount;
                        }
                        out.writeInt(intAdditionalCount);
                        if (!"pantilt".equals(stringDMXControlDescriptionID)) continue;
                        if (this.m_VirtualPoint_PanTilt == null) {
                            out.writeUTF(DMXControlDescription.ID_UNDEFINED);
                            continue;
                        }
                        out.writeUTF("pantilt");
                        this.m_VirtualPoint_PanTilt.writeExternal(out);
                    }
                }
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int intSoftwareVersion = in.readInt();
            String stringDMXDeviceID = in.readUTF();
            this.m_DMXDevice = DMXDevice.getDMXDevice(stringDMXDeviceID);
            int intDMXControlDescriptionIDCount = in.readInt();
            for (int intDMXControlDescriptionID = 0; intDMXControlDescriptionID < intDMXControlDescriptionIDCount; ++intDMXControlDescriptionID) {
                String stringDMXControlDescriptionID = in.readUTF();
                HashMap<String, HashMap<Integer, ArrayList<Double>>> o_Values_DMXControlType = this.m_Values.get(stringDMXControlDescriptionID);
                if (o_Values_DMXControlType == null) {
                    o_Values_DMXControlType = new HashMap();
                }
                int intDMXControlTypeIDCount = in.readInt();
                for (int intDMXControlTypeID = 0; intDMXControlTypeID < intDMXControlTypeIDCount; ++intDMXControlTypeID) {
                    String stringDMXControlTypeID = in.readUTF();
                    HashMap<Integer, ArrayList<Double>> o_Values_ControlObjectIndex = o_Values_DMXControlType.get(stringDMXControlTypeID);
                    if (o_Values_ControlObjectIndex == null) {
                        o_Values_ControlObjectIndex = new HashMap();
                    }
                    int intControlObjectIndexCount = in.readInt();
                    for (int intIndex = 0; intIndex < intControlObjectIndexCount; ++intIndex) {
                        int intControlObjectIndex = in.readInt();
                        ArrayList<Double> o_Values_ControlDimension = o_Values_ControlObjectIndex.get(intControlObjectIndex);
                        if (o_Values_ControlDimension == null) {
                            o_Values_ControlDimension = new ArrayList();
                        }
                        int intDimensionCount = in.readInt();
                        for (int intDimension = 0; intDimension < intDimensionCount; ++intDimension) {
                            double doubleValueDimension = in.readDouble();
                            if (intDimension >= o_Values_ControlDimension.size()) {
                                o_Values_ControlDimension.add(doubleValueDimension);
                                continue;
                            }
                            o_Values_ControlDimension.set(intDimension, doubleValueDimension);
                        }
                        int intAdditionalCount = 0;
                        if (intSoftwareVersion >= 2) {
                            intAdditionalCount = in.readInt();
                        }
                        for (int intAddition = 0; intAddition < intAdditionalCount; ++intAddition) {
                            String stringAddtionalID = in.readUTF();
                            if (!"pantilt".equals(stringAddtionalID)) continue;
                            this.m_VirtualPoint_PanTilt = new DMXControl_GridPanTilt_DeviceSettings.VirtualPoint();
                            this.m_VirtualPoint_PanTilt.readExternal(in);
                        }
                        if ("pantilt".equals(stringDMXControlDescriptionID)) {
                            if (this.m_VirtualPoint_PanTilt != null) {
                                this.m_Point2D = DMXControl_GridPanTilt_DeviceSettings.calculateAnglesFromVirtualPoint(this.m_Point2D, this.m_DMXDevice, this.m_VirtualPoint_PanTilt);
                                if (this.m_Point2D != null) {
                                    o_Values_ControlDimension.set(0, this.m_Point2D.getX());
                                    o_Values_ControlDimension.set(1, this.m_Point2D.getY());
                                }
                            } else {
                                this.m_VirtualPoint_PanTilt = DMXControl_GridPanTilt_DeviceSettings.calculateVirtualPointFromAnglesBilinear(null, this.m_DMXDevice, o_Values_ControlDimension.get(0), o_Values_ControlDimension.get(1), false);
                            }
                        }
                        o_Values_ControlObjectIndex.put(intControlObjectIndex, o_Values_ControlDimension);
                    }
                    o_Values_DMXControlType.put(stringDMXControlTypeID, o_Values_ControlObjectIndex);
                }
                this.m_Values.put(stringDMXControlDescriptionID, o_Values_DMXControlType);
            }
        }

        public DMXPreset getDMXPreset() {
            return this.m_DMXPreset;
        }

        public void setDMXDevice(DMXDevice p_DMXDevice) {
            this.m_DMXDevice = p_DMXDevice;
        }

        public DMXDevice getDMXDevice() {
            return this.m_DMXDevice;
        }

        public String getDMXDeviceID() {
            DMXDevice o_DMXDevice = this.m_DMXDevice;
            if (o_DMXDevice == null) {
                return null;
            }
            return o_DMXDevice.getID();
        }

        public int getValues_DMXControlDescriptionIDCount() {
            return this.m_Values.size();
        }

        public ArrayList<String> getDMXControlIDs(String p_DMXControlDescriptionID) {
            ArrayList<String> o_DMXControlIDs = new ArrayList<String>();
            HashMap<String, HashMap<Integer, ArrayList<Double>>> o_Values_DescriptionID = this.m_Values.get(p_DMXControlDescriptionID);
            if (o_Values_DescriptionID == null) {
                return o_DMXControlIDs;
            }
            for (String stringDMXControlID : o_Values_DescriptionID.keySet()) {
                o_DMXControlIDs.add(stringDMXControlID);
            }
            return o_DMXControlIDs;
        }

        public ArrayList<Double> getValues(String p_DMXControlDescriptionID, String p_DMXControlID, int p_ControlObjectIndex) {
            HashMap<String, HashMap<Integer, ArrayList<Double>>> o_Values_DescriptionID = this.m_Values.get(p_DMXControlDescriptionID);
            if (o_Values_DescriptionID == null) {
                return null;
            }
            HashMap<Integer, ArrayList<Double>> o_Values_DMXControlID = o_Values_DescriptionID.get(p_DMXControlID);
            if (o_Values_DMXControlID == null) {
                return null;
            }
            ArrayList<Double> o_Values_ControlIndex = o_Values_DMXControlID.get(p_ControlObjectIndex);
            return o_Values_ControlIndex;
        }

        public void setValues(String p_DMXControlDescriptionID, String p_DMXControlID, int p_ControlObjectIndex, ArrayList<Double> p_Values, DMXControl_GridPanTilt_DeviceSettings.VirtualPoint p_VirtualPoint) {
            HashMap<String, HashMap<Integer, ArrayList<Double>>> o_Values_DescriptionID = this.m_Values.get(p_DMXControlDescriptionID);
            if (o_Values_DescriptionID == null) {
                return;
            }
            HashMap<Integer, ArrayList<Double>> o_Values_DMXControlID = o_Values_DescriptionID.get(p_DMXControlID);
            if (o_Values_DMXControlID == null) {
                return;
            }
            ArrayList<Double> o_Values_ControlIndex = o_Values_DMXControlID.get(p_ControlObjectIndex);
            if (o_Values_ControlIndex.size() != p_Values.size()) {
                return;
            }
            for (int intValue = 0; intValue < o_Values_ControlIndex.size(); ++intValue) {
                o_Values_ControlIndex.set(intValue, p_Values.get(intValue));
            }
            this.m_VirtualPoint_PanTilt = "pantilt".equals(p_DMXControlDescriptionID) ? p_VirtualPoint : null;
        }

        public void saveActualValues() {
            String[] arrayDMXControlDescriptionIDs = this.m_DMXPresets.getDMXControlDescriptionIDs();
            for (int intID = 0; intID < arrayDMXControlDescriptionIDs.length; ++intID) {
                String stringDMXControlDescriptionID = arrayDMXControlDescriptionIDs[intID];
                this.saveActualValues(stringDMXControlDescriptionID);
            }
        }

        public void saveActualValues(String p_DMXControlDescriptionID) {
            HashMap<Integer, ArrayList<Double>> o_DMXControlComponentValues;
            ArrayList<DMXControlComponent> o_DMXControlComponents = new ArrayList<DMXControlComponent>();
            DMXDevice o_DMXDevice = this.m_DMXDevice;
            if (o_DMXDevice == null) {
                return;
            }
            if ((o_DMXControlComponents = o_DMXDevice.getDMXControlComponentsByDescription(p_DMXControlDescriptionID, o_DMXControlComponents)).size() <= 0) {
                return;
            }
            HashMap<String, HashMap<Integer, ArrayList<Double>>> o_DMXControlDescriptionIDValues = this.m_Values.get(p_DMXControlDescriptionID);
            if (o_DMXControlDescriptionIDValues == null) {
                o_DMXControlDescriptionIDValues = new HashMap();
                this.m_Values.put(p_DMXControlDescriptionID, o_DMXControlDescriptionIDValues);
            }
            for (int intDMXControlComponent = 0; intDMXControlComponent < o_DMXControlComponents.size(); ++intDMXControlComponent) {
                DMXControlComponent o_DMXControlComponent = o_DMXControlComponents.get(intDMXControlComponent);
                if (o_DMXControlComponent == null) continue;
                o_DMXControlComponentValues = o_DMXControlDescriptionIDValues.get(o_DMXControlComponent.getDMXControlTypeID());
                if (o_DMXControlComponentValues == null) {
                    o_DMXControlComponentValues = new HashMap();
                    o_DMXControlDescriptionIDValues.put(o_DMXControlComponent.getDMXControlTypeID(), o_DMXControlComponentValues);
                }
                for (int intControlObject = 0; intControlObject < o_DMXControlComponent.getControlObjectCount(); ++intControlObject) {
                    int intDimension;
                    ControlObject o_ControlObject = o_DMXControlComponent.getControlObject(intControlObject);
                    if (o_ControlObject == null) continue;
                    ArrayList<Double> o_ControlObjectValues = o_DMXControlComponentValues.get(intControlObject);
                    if (o_ControlObjectValues == null) {
                        o_ControlObjectValues = new ArrayList(o_ControlObject.getControlDimensionCount());
                        for (intDimension = 0; intDimension < o_ControlObject.getControlDimensionCount(); ++intDimension) {
                            o_ControlObjectValues.add((Double)Double.MIN_VALUE);
                        }
                        o_DMXControlComponentValues.put(intControlObject, o_ControlObjectValues);
                    }
                    for (intDimension = 0; intDimension < o_ControlObject.getControlDimensionCount(); ++intDimension) {
                        ControlObject.ControlDimension o_ControlDimension = o_ControlObject.getControlDimension(intDimension);
                        if (o_ControlDimension == null) continue;
                        o_ControlObjectValues.set(intDimension, o_ControlDimension.getValue());
                    }
                }
            }
            if ("pantilt".equals(p_DMXControlDescriptionID) && o_DMXControlComponents.size() == 1) {
                DMXControl_GridPanTilt o_DMXControl_GridPanTilt = (DMXControl_GridPanTilt)o_DMXControlComponents.get(0);
                o_DMXControlComponentValues = o_DMXControlDescriptionIDValues.get(o_DMXControl_GridPanTilt.getDMXControlTypeID());
                this.m_VirtualPoint_PanTilt = o_DMXControlComponentValues != null ? DMXControl_GridPanTilt_DeviceSettings.calculateVirtualPointFromAnglesBilinear(this.m_VirtualPoint_PanTilt, o_DMXDevice, o_DMXControlComponentValues.get(0).get(0), o_DMXControlComponentValues.get(0).get(1), false) : null;
            }
        }

        public void writeValues() {
            String[] arrayDMXControlDescriptionIDs = this.m_DMXPresets.getDMXControlDescriptionIDs();
            for (int intID = 0; intID < arrayDMXControlDescriptionIDs.length; ++intID) {
                String stringDMXControlDescriptionID = arrayDMXControlDescriptionIDs[intID];
                this.writeValues(stringDMXControlDescriptionID);
            }
        }

        public void writeValues(String p_DMXControlDescriptionID) {
            DMXDevice o_DMXDevice = this.m_DMXDevice;
            if (o_DMXDevice == null) {
                return;
            }
            ArrayList<DMXControlComponent> o_DMXControlComponents = new ArrayList<DMXControlComponent>();
            if ((o_DMXControlComponents = o_DMXDevice.getDMXControlComponentsByDescription(p_DMXControlDescriptionID, o_DMXControlComponents)).size() <= 0) {
                return;
            }
            HashMap<String, HashMap<Integer, ArrayList<Double>>> o_DMXControlDescriptionIDValues = this.m_Values.get(p_DMXControlDescriptionID);
            if (o_DMXControlDescriptionIDValues == null) {
                return;
            }
            for (int intDMXControlComponent = 0; intDMXControlComponent < o_DMXControlComponents.size(); ++intDMXControlComponent) {
                HashMap<Integer, ArrayList<Double>> o_DMXControlComponentValues;
                DMXControlComponent o_DMXControlComponent = o_DMXControlComponents.get(intDMXControlComponent);
                if (o_DMXControlComponent == null || (o_DMXControlComponentValues = o_DMXControlDescriptionIDValues.get(o_DMXControlComponent.getDMXControlTypeID())) == null) continue;
                for (int intControlObject = 0; intControlObject < o_DMXControlComponent.getControlObjectCount(); ++intControlObject) {
                    ArrayList<Double> o_ControlObjectValues;
                    ControlObject o_ControlObject = o_DMXControlComponent.getControlObject(intControlObject);
                    if (o_ControlObject == null || (o_ControlObjectValues = o_DMXControlComponentValues.get(intControlObject)) == null) continue;
                    for (int intDimension = 0; intDimension < o_ControlObject.getControlDimensionCount(); ++intDimension) {
                        Double doubleValue;
                        ControlObject.ControlDimension o_ControlDimension = o_ControlObject.getControlDimension(intDimension);
                        if (o_ControlDimension == null || (doubleValue = o_ControlObjectValues.get(intDimension)) == null) continue;
                        o_ControlDimension.setValueWithoutGroups(doubleValue.doubleValue(), 0.0, 0);
                    }
                    o_ControlObject.setValueManuallyIsReady();
                }
            }
        }
    }

    public static class DMXPreset
    implements Externalizable,
    PropertyChangeListener {
        public static final int SOFTWAREVERSION = 1;
        public static final String PROP_NAME = "dmxpresetName";
        public static final String PROP_REMARK = "dmxpresetRemark";
        public static final String PROP_CLOSED = "dmxpresetClosed";
        protected DMXPresets m_DMXPresets;
        protected String m_ID;
        protected String m_Name;
        protected String m_Remark;
        protected String m_ToolTipText;
        protected SinglePropertyChangeSupport m_PropertyChangeSupport;
        private HashMap<String, DMXPreset_Device> m_DMXPreset_Devices;
        private ArrayList<DMXDevice> m_DMXDevices_Sorted;
        private final Object m_SyncObject = new Object();
        public static int DMXDEVICES_PER_COLUMN = 25;

        public DMXPreset(DMXPresets p_DMXPresets) {
            this.m_DMXPresets = p_DMXPresets;
            this.initMembers();
        }

        private void initMembers() {
            this.m_PropertyChangeSupport = new SinglePropertyChangeSupport(this);
            this.m_DMXPreset_Devices = new HashMap();
            this.m_DMXDevices_Sorted = new ArrayList();
            this.m_ID = LiveGUID.getGUID();
            this.m_Name = "Preset_" + String.valueOf(this.m_DMXPresets.getNameCounter());
            this.m_Remark = "";
            this.m_DMXPresets.increaseNameCounter();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            if (this.m_PropertyChangeSupport != null) {
                this.m_PropertyChangeSupport.firePropertyChange(PROP_CLOSED, this, null);
                this.m_PropertyChangeSupport.clear();
            }
            LiveLanguage.removeLanguageListener((Object)this);
            Object object = this.m_SyncObject;
            synchronized (object) {
                Iterator<String> o_Iterator = this.m_DMXPreset_Devices.keySet().iterator();
                while (o_Iterator.hasNext()) {
                    String stringKey = o_Iterator.next();
                    DMXPreset_Device o_DMXPreset_Device = this.m_DMXPreset_Devices.get(stringKey);
                    o_Iterator.remove();
                    if (o_DMXPreset_Device == null) continue;
                    this.m_DMXDevices_Sorted.remove(o_DMXPreset_Device.getDMXDevice());
                    o_DMXPreset_Device.close();
                }
                this.m_DMXPreset_Devices.clear();
                this.m_DMXDevices_Sorted.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(1);
            out.writeUTF(this.m_ID);
            out.writeUTF(this.m_Name);
            out.writeUTF(this.m_Remark);
            Object object = this.m_SyncObject;
            synchronized (object) {
                DMXPreset_Device o_DMXPreset_Device;
                int intDMXPreset_DeviceCount = this.m_DMXPreset_Devices.size();
                ArrayList<DMXPreset_Device> o_DMXPreset_Devices = new ArrayList<DMXPreset_Device>(intDMXPreset_DeviceCount);
                for (String stringDMXDeviceID : this.m_DMXPreset_Devices.keySet()) {
                    if (stringDMXDeviceID == null || (o_DMXPreset_Device = this.m_DMXPreset_Devices.get(stringDMXDeviceID)) == null || o_DMXPreset_Device.getDMXDeviceID() == null) continue;
                    o_DMXPreset_Devices.add(o_DMXPreset_Device);
                }
                intDMXPreset_DeviceCount = o_DMXPreset_Devices.size();
                out.writeInt(intDMXPreset_DeviceCount);
                for (int intDevice = 0; intDevice < intDMXPreset_DeviceCount; ++intDevice) {
                    String stringDMXDeviceID;
                    o_DMXPreset_Device = (DMXPreset_Device)o_DMXPreset_Devices.get(intDevice);
                    stringDMXDeviceID = o_DMXPreset_Device.getDMXDeviceID();
                    out.writeUTF(stringDMXDeviceID);
                    o_DMXPreset_Device.writeExternal(out);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int intSoftwareVersion = in.readInt();
            String oldName = this.m_Name;
            String oldRemark = this.m_Remark;
            this.m_ID = in.readUTF();
            this.m_Name = in.readUTF();
            this.m_Remark = in.readUTF();
            try {
                Object object = this.m_SyncObject;
                synchronized (object) {
                    int intDMXPreset_DeviceCount = in.readInt();
                    for (int intDMXPreset_Device = 0; intDMXPreset_Device < intDMXPreset_DeviceCount; ++intDMXPreset_Device) {
                        String stringDMXDeviceID = in.readUTF();
                        DMXDevice o_DMXDevice = DMXDevice.getDMXDevice(stringDMXDeviceID);
                        if (!this.m_DMXPresets.affectsDMXDevice(o_DMXDevice)) {
                            this.readDummy(in);
                            continue;
                        }
                        DMXPreset_Device o_DMXPreset_Device = this.m_DMXPreset_Devices.get(stringDMXDeviceID);
                        if (o_DMXPreset_Device == null) {
                            o_DMXPreset_Device = this.createDMXPreset_Device(o_DMXDevice);
                        }
                        if (o_DMXPreset_Device.getValues_DMXControlDescriptionIDCount() > 0) {
                            this.readDummy(in);
                            continue;
                        }
                        o_DMXPreset_Device.readExternal(in);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.m_PropertyChangeSupport != null) {
                this.m_PropertyChangeSupport.firePropertyChange(PROP_NAME, oldName, this.m_Name);
                this.m_PropertyChangeSupport.firePropertyChange(PROP_REMARK, oldRemark, this.m_Remark);
            }
            this.createToolTipText();
        }

        private void readDummy(ObjectInput in) throws Exception {
            DMXPreset_Device o_DMXPreset_Device1_Dummy = new DMXPreset_Device(this.m_DMXPresets, this, null);
            o_DMXPreset_Device1_Dummy.readExternal(in);
        }

        public ImageIcon getIcon() {
            return this.m_DMXPresets.getIcon();
        }

        public String getID() {
            return this.m_ID;
        }

        public void setName(String p_Name) {
            if (p_Name == null) {
                return;
            }
            if (p_Name.equals(this.m_Name)) {
                return;
            }
            String oldValue = this.m_Name;
            this.m_Name = p_Name;
            if (this.m_PropertyChangeSupport != null) {
                this.m_PropertyChangeSupport.firePropertyChange(PROP_NAME, oldValue, this.m_Name);
            }
            this.createToolTipText();
        }

        public String getName() {
            return this.m_Name;
        }

        public void setRemark(String p_Remark) {
            if (p_Remark == null) {
                return;
            }
            if (p_Remark.equals(this.m_Remark)) {
                return;
            }
            String oldValue = this.m_Remark;
            this.m_Remark = p_Remark;
            if (this.m_PropertyChangeSupport != null) {
                this.m_PropertyChangeSupport.firePropertyChange(PROP_REMARK, oldValue, this.m_Remark);
            }
            this.createToolTipText();
        }

        public String getRemark() {
            return this.m_Remark;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DMXPreset_Device getDMXPreset_Device(String p_DMXDeviceID) {
            DMXPreset_Device o_DMXPreset_Device = null;
            Object object = this.m_SyncObject;
            synchronized (object) {
                o_DMXPreset_Device = this.m_DMXPreset_Devices.get(p_DMXDeviceID);
                return o_DMXPreset_Device;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeDMXDevice(DMXDevice p_DMXDevice) {
            DMXPreset_Device o_DMXPreset_Device;
            if (p_DMXDevice == null) {
                return;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                o_DMXPreset_Device = this.m_DMXPreset_Devices.get(p_DMXDevice.getID());
                if (o_DMXPreset_Device == null) {
                    return;
                }
                this.m_DMXPreset_Devices.remove(p_DMXDevice.getID());
                this.removeDMXDeviceSortedByName(p_DMXDevice);
            }
            o_DMXPreset_Device.close();
            this.createToolTipText();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DMXPreset_Device createDMXPreset_Device(DMXDevice p_DMXDevice) {
            if (p_DMXDevice == null) {
                return null;
            }
            if (!this.m_DMXPresets.affectsDMXDevice(p_DMXDevice)) {
                return null;
            }
            DMXPreset_Device o_DMXPreset_Device = this.m_DMXPreset_Devices.get(p_DMXDevice.getID());
            if (o_DMXPreset_Device != null) {
                o_DMXPreset_Device.setDMXDevice(p_DMXDevice);
                return o_DMXPreset_Device;
            }
            o_DMXPreset_Device = new DMXPreset_Device(this.m_DMXPresets, this, p_DMXDevice);
            Object object = this.m_SyncObject;
            synchronized (object) {
                this.m_DMXPreset_Devices.put(p_DMXDevice.getID(), o_DMXPreset_Device);
                this.addDMXDeviceSortedByName(p_DMXDevice);
            }
            return o_DMXPreset_Device;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addDMXDeviceSortedByName(DMXDevice p_DMXDevice) {
            if (p_DMXDevice == null) {
                return;
            }
            boolean boolAdded = false;
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (this.m_DMXDevices_Sorted.contains(p_DMXDevice)) {
                    this.m_DMXDevices_Sorted.remove(p_DMXDevice);
                } else {
                    p_DMXDevice.addPropertyChangeListener("dmxdeviceDeviceName", this);
                }
                for (int intDMXDevice = 0; intDMXDevice < this.m_DMXDevices_Sorted.size(); ++intDMXDevice) {
                    DMXDevice o_DMXDevice = this.m_DMXDevices_Sorted.get(intDMXDevice);
                    if (o_DMXDevice == null || p_DMXDevice.getName().compareToIgnoreCase(o_DMXDevice.getName()) > 0) continue;
                    this.m_DMXDevices_Sorted.add(intDMXDevice, p_DMXDevice);
                    boolAdded = true;
                    break;
                }
                if (!boolAdded) {
                    this.m_DMXDevices_Sorted.add(this.m_DMXDevices_Sorted.size(), p_DMXDevice);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeDMXDeviceSortedByName(DMXDevice p_DMXDevice) {
            if (p_DMXDevice == null) {
                return;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                p_DMXDevice.removePropertyChangeListener("dmxdeviceDeviceName", this);
                this.m_DMXDevices_Sorted.remove(p_DMXDevice);
            }
        }

        public boolean contains(DMXDevice p_DMXDevice) {
            if (p_DMXDevice == null) {
                return false;
            }
            DMXPreset_Device o_DMXPreset_Device = this.getDMXPreset_Device(p_DMXDevice.getID());
            return o_DMXPreset_Device != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void saveActualValues(boolean p_AllDevices) {
            Object object = this.m_SyncObject;
            synchronized (object) {
                int intDMXDeviceViewCount = LiveShowDMXStageView.getDMXDeviceViewCount();
                for (int intDMXDeviceView = 0; intDMXDeviceView < intDMXDeviceViewCount; ++intDMXDeviceView) {
                    DMXDevice o_DMXDevice;
                    DMXDeviceView o_DMXDeviceView = LiveShowDMXStageView.getDMXDeviceView(intDMXDeviceView);
                    if (o_DMXDeviceView == null || !p_AllDevices && !o_DMXDeviceView.getSelected() || (o_DMXDevice = o_DMXDeviceView.getDMXDevice()) == null || !this.m_DMXPresets.affectsDMXDevice(o_DMXDevice)) continue;
                    DMXPreset_Device o_DMXPreset_Device = this.m_DMXPreset_Devices.get(o_DMXDevice.getID());
                    if (o_DMXPreset_Device == null) {
                        o_DMXPreset_Device = this.createDMXPreset_Device(o_DMXDevice);
                        this.m_DMXPreset_Devices.put(o_DMXDevice.getID(), o_DMXPreset_Device);
                    }
                    o_DMXPreset_Device.saveActualValues();
                }
            }
            this.createToolTipText();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeValues(ArrayList<DMXDevice> p_DMXDevices, String p_DMXControlDescriptionID) {
            if (p_DMXDevices == null) {
                return;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                int intDMXDeviceViewCount = p_DMXDevices.size();
                for (int intDMXDevice = 0; intDMXDevice < intDMXDeviceViewCount; ++intDMXDevice) {
                    DMXPreset_Device o_DMXPreset_Device;
                    DMXDevice o_DMXDevice = p_DMXDevices.get(intDMXDevice);
                    if (o_DMXDevice == null || (o_DMXPreset_Device = this.m_DMXPreset_Devices.get(o_DMXDevice.getID())) == null) continue;
                    if (p_DMXControlDescriptionID == null) {
                        o_DMXPreset_Device.writeValues();
                        continue;
                    }
                    o_DMXPreset_Device.writeValues(p_DMXControlDescriptionID);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ArrayList<DMXDevice> getDMXDevices(boolean p_AllDevices, ArrayList<DMXDevice> p_DMXDevices) {
            if (p_DMXDevices == null) {
                p_DMXDevices = new ArrayList();
            }
            p_DMXDevices.clear();
            Object object = this.m_SyncObject;
            synchronized (object) {
                p_DMXDevices.addAll(this.m_DMXDevices_Sorted);
            }
            return p_DMXDevices;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String createToolTipText() {
            int intDMXDeviceCount_InColumn = 0;
            StringBuilder o_StringBuffer = new StringBuilder();
            o_StringBuffer.append("<html>");
            o_StringBuffer.append("<center><b>");
            o_StringBuffer.append(this.getName());
            o_StringBuffer.append("</b></center>");
            o_StringBuffer.append("<br>");
            if (this.getRemark() != null && this.getRemark().length() > 0) {
                o_StringBuffer.append("<center><b>");
                o_StringBuffer.append(this.getRemark());
                o_StringBuffer.append("</b></center>");
                o_StringBuffer.append("<br>");
            }
            o_StringBuffer.append("<table align=center>");
            o_StringBuffer.append("<tr>");
            o_StringBuffer.append("<td align=center>");
            o_StringBuffer.append("");
            o_StringBuffer.append("</td>");
            o_StringBuffer.append("<td align=center>");
            o_StringBuffer.append("");
            o_StringBuffer.append("</td>");
            o_StringBuffer.append("</tr>");
            o_StringBuffer.append("<tr>");
            o_StringBuffer.append("<td align=right><b>");
            o_StringBuffer.append(DMXDevice.DEFAULT_DMXDEVICENAME);
            o_StringBuffer.append("</b></td>");
            o_StringBuffer.append("<td align=right><b>");
            o_StringBuffer.append("</b></td>");
            o_StringBuffer.append("</tr>");
            o_StringBuffer.append("</table>");
            o_StringBuffer.append("<table align=center>");
            o_StringBuffer.append("<tr>");
            o_StringBuffer.append("<td align=center>");
            o_StringBuffer.append("<table align=top>");
            Object object = this.m_SyncObject;
            synchronized (object) {
                for (int intDMXDevice = 0; intDMXDevice < this.m_DMXDevices_Sorted.size(); ++intDMXDevice) {
                    DMXDevice o_DMXDevice = this.m_DMXDevices_Sorted.get(intDMXDevice);
                    if (o_DMXDevice == null) continue;
                    if (intDMXDeviceCount_InColumn >= DMXDEVICES_PER_COLUMN) {
                        intDMXDeviceCount_InColumn = 0;
                        o_StringBuffer.append("</table>");
                        o_StringBuffer.append("</td>");
                        o_StringBuffer.append("<td align=center>");
                        o_StringBuffer.append("<table align=top>");
                    }
                    o_StringBuffer.append("<p>");
                    o_StringBuffer.append("<tr>");
                    o_StringBuffer.append("<td align=left>");
                    o_StringBuffer.append(o_DMXDevice.getName());
                    o_StringBuffer.append("</td>");
                    o_StringBuffer.append("</tr>");
                    o_StringBuffer.append("</p");
                    ++intDMXDeviceCount_InColumn;
                }
            }
            o_StringBuffer.append("</table>");
            o_StringBuffer.append("</td>");
            o_StringBuffer.append("<table>");
            o_StringBuffer.append("</html>");
            this.m_ToolTipText = o_StringBuffer.toString();
            return this.m_ToolTipText;
        }

        public String getToolTipText() {
            return this.m_ToolTipText;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() instanceof DMXDevice && "dmxdeviceDeviceName".equals(evt.getPropertyName())) {
                DMXDevice o_DMXDevice = (DMXDevice)evt.getSource();
                this.addDMXDeviceSortedByName(o_DMXDevice);
            }
        }

        public void addPropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
            if (p_PropertyChangeListener == null) {
                return;
            }
            if (this.m_PropertyChangeSupport != null) {
                this.m_PropertyChangeSupport.addPropertyChangeListener(p_PropertyChangeListener);
            }
        }

        public void removePropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
            if (this.m_PropertyChangeSupport != null) {
                this.m_PropertyChangeSupport.removePropertyChangeListener(p_PropertyChangeListener);
            }
        }
    }

    public static class DMXPresetsRowFilter
    extends RowFilter<DMXPresetTableModel, Integer> {
        private DMXPresetTableModel m_DMXPresetsTableModel;
        private ArrayList<DMXDevice> m_DMXDevices;
        private String m_FilterString;

        public DMXPresetsRowFilter(DMXPresetTableModel p_DMXDeviceTableModel) {
            this.initMembers();
            this.m_DMXPresetsTableModel = p_DMXDeviceTableModel;
        }

        private void initMembers() {
            this.m_DMXDevices = new ArrayList();
            this.m_FilterString = null;
        }

        public void setDMXDevices(ArrayList<DMXDevice> p_DMXDevices) {
            this.m_DMXDevices.clear();
            if (p_DMXDevices != null) {
                this.m_DMXDevices.addAll(p_DMXDevices);
            }
            if (this.m_DMXPresetsTableModel != null) {
                this.m_DMXPresetsTableModel.fireTableDataChanged();
            }
        }

        public void setFilterString(String p_FilterString) {
            this.m_FilterString = p_FilterString == null ? "" : p_FilterString.toLowerCase();
            if (this.m_DMXPresetsTableModel != null) {
                this.m_DMXPresetsTableModel.fireTableDataChanged();
            }
        }

        @Override
        public boolean include(RowFilter.Entry entry) {
            if (this.m_DMXPresetsTableModel == null) {
                return false;
            }
            boolean boolIncluded_Text = false;
            boolean boolIncluded_Devices = false;
            int intRow = (Integer)entry.getIdentifier();
            DMXPreset o_DMXPreset = this.m_DMXPresetsTableModel.getDMXPreset(intRow);
            if (o_DMXPreset == null) {
                return false;
            }
            if (this.m_FilterString == null || this.m_FilterString.length() <= 0) {
                boolIncluded_Text = true;
            } else if (o_DMXPreset.getName().toLowerCase().contains(this.m_FilterString)) {
                boolIncluded_Text = true;
            } else if (o_DMXPreset.getRemark().toLowerCase().contains(this.m_FilterString)) {
                boolIncluded_Text = true;
            }
            if (this.m_DMXDevices.size() <= 0) {
                boolIncluded_Devices = true;
            }
            for (int intDMXDevice = 0; intDMXDevice < this.m_DMXDevices.size(); ++intDMXDevice) {
                DMXDevice o_DMXDevice = this.m_DMXDevices.get(intDMXDevice);
                if (!o_DMXPreset.contains(o_DMXDevice)) continue;
                boolIncluded_Devices = true;
                break;
            }
            return boolIncluded_Text && boolIncluded_Devices;
        }
    }
}

