/*
 * Decompiled with CFR 0.152.
 */
package DMXDevicePackage;

import DMXDevicePackage.DMXDevice;
import DMXDevicePackage.DMXDeviceFilter;
import DMXDevicePackage.DMXDeviceGroup;
import DMXDevicePackage.DMXPresets;
import DMXEffectsPackage.DMXEffect;
import DMXGraphics.LiveShowDMXSceneView;
import DMXGraphics.LiveShowDMXStageView;
import DMXMixer.DMXValueSelection;
import DMXScenePackage.DMXScene;
import DMXScenePackage.DMXSceneFilter;
import DMXVirtualPackage.LiveShowDMXObject;
import DMXVirtualPackage.LiveShowDMXVIP;
import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LiveShowObjectPackage.LiveShowObjectInterface;
import LiveShowVirtualPackage.LiveShowSceneBridge;
import StartPackage.LiveShowDMXSystem;
import SwingComponents.FrameParent;
import SwingToolTipPackage.PopUpToolTip;
import SynchronizationPackage.EventQueueHandler;
import ToolsGraphics.JLabel_ResizeFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;

public class DMXDeviceGroupPanel
extends JPanel
implements DragGestureListener,
DragSourceListener,
ListSelectionListener {
    private DragSource m_DragSource;
    private static ArrayList<DMXDeviceGroup> s_SelectedDMXDeviceGroups = new ArrayList();
    public static DMXDeviceGroupPanel s_SelfReference;
    private static final Object s_SyncSelection;
    private ArrayList<DMXDevice> m_TempSelectedDMXDevices = new ArrayList();
    private JButton jButton_DMXSceneFilter;
    private JButton jButton_FilterDevices;
    private JButton jButton_GroupToSelection;
    private JButton jButton_NewGroup;
    private JLabel jButton_Presets_Color;
    private JLabel jButton_Presets_Dimmer;
    private JLabel jButton_Presets_Position;
    private JButton jButton_RemoveEmptyGroups;
    private JButton jButton_RemoveGroup;
    private JButton jButton_SelectionToGroup;
    private JButton jButton_ShowInTimeline;
    private JLabel jLabel_Filter;
    private JLabel_ResizeFrame jLabel_ResizeFrame1;
    private JPanel jPanel_DMXScenes;
    private JPanel jPanel_Search;
    private JScrollPane jScrollPane_DMXScenes;
    private JToolBar.Separator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JToolBar.Separator jSeparator3;
    private JToolBar.Separator jSeparator6;
    private JToolBar.Separator jSeparator7;
    private JTable jTable_Groups;
    private JTextField jTextField_Filter;
    private JToolBar jToolBar1;
    private JToolBar jToolBar_ShowScene;
    public static FrameParent s_FrameParent;

    public DMXDeviceGroupPanel() {
        this.initMembers();
        this.initComponents();
        this.initComponentsFurther();
        LiveLanguage.addLanguageListener((Object)this, null);
        this.refreshUI();
    }

    private void initMembers() {
        s_SelfReference = this;
    }

    private void initComponentsFurther() {
        this.jScrollPane_DMXScenes.getViewport().setBackground(Color.BLACK);
        this.jTable_Groups.setModel(DMXDeviceGroup.getGroupTableModel());
        DMXDeviceGroup.getGroupTableModel().finishJTable(this.jTable_Groups);
        this.jTable_Groups.getSelectionModel().addListSelectionListener(this);
        this.jTable_Groups.setRowHeight(24);
        this.m_DragSource = new DragSource();
        this.m_DragSource.createDefaultDragGestureRecognizer(this.jTable_Groups, 2, this);
        this.jTable_Groups.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_SelectionToGroup.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_NewGroup.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_RemoveGroup.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_RemoveEmptyGroups.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_GroupToSelection.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_ShowInTimeline.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_DMXSceneFilter.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_Presets_Dimmer.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_Presets_Color.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_Presets_Position.setComponentPopupMenu(PopUpToolTip.getSelfReference());
    }

    public JLabel_ResizeFrame getLabel_ResizeFrame() {
        return this.jLabel_ResizeFrame1;
    }

    private void initComponents() {
        this.jLabel_ResizeFrame1 = new JLabel_ResizeFrame();
        this.jPanel_DMXScenes = new JPanel();
        this.jScrollPane_DMXScenes = new JScrollPane();
        this.jTable_Groups = new JTable();
        this.jToolBar1 = new JToolBar();
        this.jButton_NewGroup = new JButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.jButton_SelectionToGroup = new JButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.jButton_RemoveGroup = new JButton();
        this.jSeparator3 = new JToolBar.Separator();
        this.jButton_RemoveEmptyGroups = new JButton();
        this.jSeparator6 = new JToolBar.Separator();
        this.jButton_Presets_Dimmer = new JLabel();
        this.jButton_Presets_Color = new JLabel();
        this.jButton_Presets_Position = new JLabel();
        this.jToolBar_ShowScene = new JToolBar();
        this.jButton_ShowInTimeline = new JButton();
        this.jButton_DMXSceneFilter = new JButton();
        this.jButton_FilterDevices = new JButton();
        this.jSeparator7 = new JToolBar.Separator();
        this.jButton_GroupToSelection = new JButton();
        this.jPanel_Search = new JPanel();
        this.jLabel_Filter = new JLabel();
        this.jTextField_Filter = new JTextField();
        this.setPreferredSize(new Dimension(500, 500));
        this.setLayout(new GridBagLayout());
        this.jLabel_ResizeFrame1.setToolTipText("");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 14;
        this.add((Component)this.jLabel_ResizeFrame1, gridBagConstraints);
        this.jPanel_DMXScenes.setMinimumSize(new Dimension(200, 200));
        this.jPanel_DMXScenes.setPreferredSize(new Dimension(300, 300));
        this.jPanel_DMXScenes.setRequestFocusEnabled(false);
        this.jPanel_DMXScenes.setLayout(new GridBagLayout());
        this.jTable_Groups.setFont(new Font("Tahoma", 0, 14));
        this.jTable_Groups.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTable_Groups.setAutoResizeMode(4);
        this.jTable_Groups.setRowHeight(20);
        this.jTable_Groups.setSelectionMode(2);
        this.jScrollPane_DMXScenes.setViewportView(this.jTable_Groups);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel_DMXScenes.add((Component)this.jScrollPane_DMXScenes, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jPanel_DMXScenes, gridBagConstraints);
        this.jToolBar1.setBorder(null);
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.jToolBar1.setMinimumSize(new Dimension(100, 36));
        this.jToolBar1.setPreferredSize(new Dimension(100, 36));
        this.jButton_NewGroup.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Edit_Plus.png")));
        this.jButton_NewGroup.setToolTipText("Add new group");
        this.jButton_NewGroup.setContentAreaFilled(false);
        this.jButton_NewGroup.setFocusable(false);
        this.jButton_NewGroup.setHorizontalTextPosition(0);
        this.jButton_NewGroup.setIconTextGap(0);
        this.jButton_NewGroup.setMargin(new Insets(2, 2, 2, 2));
        this.jButton_NewGroup.setMaximumSize(new Dimension(36, 36));
        this.jButton_NewGroup.setMinimumSize(new Dimension(36, 36));
        this.jButton_NewGroup.setPreferredSize(new Dimension(36, 36));
        this.jButton_NewGroup.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_NewGroup.setVerticalTextPosition(3);
        this.jButton_NewGroup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DMXDeviceGroupPanel.this.jButton_NewGroupActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_NewGroup);
        this.jSeparator1.setMaximumSize(new Dimension(20, Short.MAX_VALUE));
        this.jSeparator1.setPreferredSize(new Dimension(20, 10));
        this.jToolBar1.add(this.jSeparator1);
        this.jButton_SelectionToGroup.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/DeviceGroupFromSelection.png")));
        this.jButton_SelectionToGroup.setToolTipText("Overwrite group with selection of timeline");
        this.jButton_SelectionToGroup.setContentAreaFilled(false);
        this.jButton_SelectionToGroup.setFocusable(false);
        this.jButton_SelectionToGroup.setHorizontalTextPosition(0);
        this.jButton_SelectionToGroup.setIconTextGap(0);
        this.jButton_SelectionToGroup.setMargin(new Insets(0, 0, 0, 0));
        this.jButton_SelectionToGroup.setMaximumSize(new Dimension(64, 32));
        this.jButton_SelectionToGroup.setMinimumSize(new Dimension(64, 32));
        this.jButton_SelectionToGroup.setPreferredSize(new Dimension(64, 32));
        this.jButton_SelectionToGroup.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed_Wide.png")));
        this.jButton_SelectionToGroup.setVerticalTextPosition(3);
        this.jButton_SelectionToGroup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DMXDeviceGroupPanel.this.jButton_SelectionToGroupActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_SelectionToGroup);
        this.jSeparator2.setMaximumSize(new Dimension(40, Short.MAX_VALUE));
        this.jSeparator2.setPreferredSize(new Dimension(40, 10));
        this.jToolBar1.add(this.jSeparator2);
        this.jButton_RemoveGroup.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Delete.png")));
        this.jButton_RemoveGroup.setToolTipText("Remove selected group");
        this.jButton_RemoveGroup.setContentAreaFilled(false);
        this.jButton_RemoveGroup.setFocusable(false);
        this.jButton_RemoveGroup.setHorizontalTextPosition(0);
        this.jButton_RemoveGroup.setIconTextGap(0);
        this.jButton_RemoveGroup.setMargin(new Insets(0, 0, 0, 0));
        this.jButton_RemoveGroup.setMaximumSize(new Dimension(32, 32));
        this.jButton_RemoveGroup.setMinimumSize(new Dimension(32, 32));
        this.jButton_RemoveGroup.setPreferredSize(new Dimension(32, 32));
        this.jButton_RemoveGroup.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_RemoveGroup.setVerticalTextPosition(3);
        this.jButton_RemoveGroup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DMXDeviceGroupPanel.this.jButton_RemoveGroupActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_RemoveGroup);
        this.jToolBar1.add(this.jSeparator3);
        this.jButton_RemoveEmptyGroups.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Edit_Sweep.png")));
        this.jButton_RemoveEmptyGroups.setToolTipText("Delete all empty groups");
        this.jButton_RemoveEmptyGroups.setContentAreaFilled(false);
        this.jButton_RemoveEmptyGroups.setFocusable(false);
        this.jButton_RemoveEmptyGroups.setHorizontalTextPosition(0);
        this.jButton_RemoveEmptyGroups.setIconTextGap(0);
        this.jButton_RemoveEmptyGroups.setMargin(new Insets(0, 0, 0, 0));
        this.jButton_RemoveEmptyGroups.setMaximumSize(new Dimension(64, 32));
        this.jButton_RemoveEmptyGroups.setMinimumSize(new Dimension(64, 32));
        this.jButton_RemoveEmptyGroups.setPreferredSize(new Dimension(64, 32));
        this.jButton_RemoveEmptyGroups.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed_Wide.png")));
        this.jButton_RemoveEmptyGroups.setVerticalTextPosition(3);
        this.jButton_RemoveEmptyGroups.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DMXDeviceGroupPanel.this.jButton_RemoveEmptyGroupsActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_RemoveEmptyGroups);
        this.jToolBar1.add(this.jSeparator6);
        this.jButton_Presets_Dimmer.setHorizontalAlignment(0);
        this.jButton_Presets_Dimmer.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Slider_Small.png")));
        this.jButton_Presets_Dimmer.setToolTipText("call Prest Dimmer");
        this.jButton_Presets_Dimmer.setHorizontalTextPosition(0);
        this.jButton_Presets_Dimmer.setIconTextGap(0);
        this.jButton_Presets_Dimmer.setMaximumSize(new Dimension(32, 32));
        this.jButton_Presets_Dimmer.setMinimumSize(new Dimension(32, 32));
        this.jButton_Presets_Dimmer.setPreferredSize(new Dimension(32, 32));
        this.jButton_Presets_Dimmer.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DMXDeviceGroupPanel.this.jButton_Presets_DimmerMouseClicked(evt);
            }
        });
        this.jToolBar1.add(this.jButton_Presets_Dimmer);
        this.jButton_Presets_Color.setHorizontalAlignment(0);
        this.jButton_Presets_Color.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Color_RGB_CMY.png")));
        this.jButton_Presets_Color.setToolTipText("call Prest Color");
        this.jButton_Presets_Color.setHorizontalTextPosition(0);
        this.jButton_Presets_Color.setIconTextGap(0);
        this.jButton_Presets_Color.setMaximumSize(new Dimension(32, 32));
        this.jButton_Presets_Color.setMinimumSize(new Dimension(32, 32));
        this.jButton_Presets_Color.setPreferredSize(new Dimension(32, 32));
        this.jButton_Presets_Color.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DMXDeviceGroupPanel.this.jButton_Presets_ColorMouseClicked(evt);
            }
        });
        this.jToolBar1.add(this.jButton_Presets_Color);
        this.jButton_Presets_Position.setHorizontalAlignment(0);
        this.jButton_Presets_Position.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/GridAdjuster_16.png")));
        this.jButton_Presets_Position.setToolTipText("call Prest Position");
        this.jButton_Presets_Position.setHorizontalTextPosition(0);
        this.jButton_Presets_Position.setIconTextGap(0);
        this.jButton_Presets_Position.setMaximumSize(new Dimension(32, 32));
        this.jButton_Presets_Position.setMinimumSize(new Dimension(32, 32));
        this.jButton_Presets_Position.setPreferredSize(new Dimension(32, 32));
        this.jButton_Presets_Position.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DMXDeviceGroupPanel.this.jButton_Presets_PositionMouseClicked(evt);
            }
        });
        this.jToolBar1.add(this.jButton_Presets_Position);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jToolBar1, gridBagConstraints);
        this.jToolBar_ShowScene.setBorder(null);
        this.jToolBar_ShowScene.setFloatable(false);
        this.jToolBar_ShowScene.setRollover(true);
        this.jToolBar_ShowScene.setMaximumSize(new Dimension(175, 36));
        this.jToolBar_ShowScene.setMinimumSize(new Dimension(175, 36));
        this.jToolBar_ShowScene.setName("");
        this.jToolBar_ShowScene.setPreferredSize(new Dimension(175, 36));
        this.jButton_ShowInTimeline.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Timeline_Selection.png")));
        this.jButton_ShowInTimeline.setToolTipText("Selects all objects in timeline using this devices (dimmer > 0).");
        this.jButton_ShowInTimeline.setContentAreaFilled(false);
        this.jButton_ShowInTimeline.setFocusable(false);
        this.jButton_ShowInTimeline.setHorizontalTextPosition(0);
        this.jButton_ShowInTimeline.setIconTextGap(0);
        this.jButton_ShowInTimeline.setMargin(new Insets(0, 0, 0, 0));
        this.jButton_ShowInTimeline.setMaximumSize(new Dimension(32, 32));
        this.jButton_ShowInTimeline.setMinimumSize(new Dimension(32, 32));
        this.jButton_ShowInTimeline.setPreferredSize(new Dimension(32, 32));
        this.jButton_ShowInTimeline.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_ShowInTimeline.setVerticalTextPosition(3);
        this.jButton_ShowInTimeline.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DMXDeviceGroupPanel.this.jButton_ShowInTimelineActionPerformed(evt);
            }
        });
        this.jToolBar_ShowScene.add(this.jButton_ShowInTimeline);
        this.jButton_DMXSceneFilter.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/DMXScene_Filter.png")));
        this.jButton_DMXSceneFilter.setToolTipText("Selects all objects in timeline using this devices (dimmer > 0).");
        this.jButton_DMXSceneFilter.setContentAreaFilled(false);
        this.jButton_DMXSceneFilter.setFocusable(false);
        this.jButton_DMXSceneFilter.setHorizontalTextPosition(0);
        this.jButton_DMXSceneFilter.setIconTextGap(0);
        this.jButton_DMXSceneFilter.setMargin(new Insets(0, 0, 0, 0));
        this.jButton_DMXSceneFilter.setMaximumSize(new Dimension(32, 32));
        this.jButton_DMXSceneFilter.setMinimumSize(new Dimension(32, 32));
        this.jButton_DMXSceneFilter.setPreferredSize(new Dimension(32, 32));
        this.jButton_DMXSceneFilter.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_DMXSceneFilter.setVerticalTextPosition(3);
        this.jButton_DMXSceneFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DMXDeviceGroupPanel.this.jButton_DMXSceneFilterActionPerformed(evt);
            }
        });
        this.jToolBar_ShowScene.add(this.jButton_DMXSceneFilter);
        this.jButton_FilterDevices.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Device_Filter.png")));
        this.jButton_FilterDevices.setToolTipText("Filter all lamps of the selected groups in stageview");
        this.jButton_FilterDevices.setContentAreaFilled(false);
        this.jButton_FilterDevices.setFocusable(false);
        this.jButton_FilterDevices.setHorizontalTextPosition(0);
        this.jButton_FilterDevices.setIconTextGap(0);
        this.jButton_FilterDevices.setMargin(new Insets(0, 0, 0, 0));
        this.jButton_FilterDevices.setMaximumSize(new Dimension(32, 32));
        this.jButton_FilterDevices.setMinimumSize(new Dimension(32, 32));
        this.jButton_FilterDevices.setPreferredSize(new Dimension(32, 32));
        this.jButton_FilterDevices.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_FilterDevices.setVerticalTextPosition(3);
        this.jButton_FilterDevices.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DMXDeviceGroupPanel.this.jButton_FilterDevicesActionPerformed(evt);
            }
        });
        this.jToolBar_ShowScene.add(this.jButton_FilterDevices);
        this.jSeparator7.setMinimumSize(new Dimension(6, 0));
        this.jToolBar_ShowScene.add(this.jSeparator7);
        this.jButton_GroupToSelection.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/DeviceGroupToSelection.png")));
        this.jButton_GroupToSelection.setToolTipText("Timeline select objects of group");
        this.jButton_GroupToSelection.setContentAreaFilled(false);
        this.jButton_GroupToSelection.setFocusable(false);
        this.jButton_GroupToSelection.setHorizontalTextPosition(0);
        this.jButton_GroupToSelection.setIconTextGap(0);
        this.jButton_GroupToSelection.setMargin(null);
        this.jButton_GroupToSelection.setMaximumSize(new Dimension(64, 32));
        this.jButton_GroupToSelection.setMinimumSize(new Dimension(64, 32));
        this.jButton_GroupToSelection.setPreferredSize(new Dimension(66, 36));
        this.jButton_GroupToSelection.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed_Wide.png")));
        this.jButton_GroupToSelection.setVerticalTextPosition(3);
        this.jButton_GroupToSelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DMXDeviceGroupPanel.this.jButton_GroupToSelectionActionPerformed(evt);
            }
        });
        this.jToolBar_ShowScene.add(this.jButton_GroupToSelection);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jToolBar_ShowScene, gridBagConstraints);
        this.jPanel_Search.setLayout(new GridBagLayout());
        this.jLabel_Filter.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Edit_Search.png")));
        this.jLabel_Filter.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Search.add((Component)this.jLabel_Filter, gridBagConstraints);
        this.jTextField_Filter.setHorizontalAlignment(0);
        this.jTextField_Filter.setToolTipText("");
        this.jTextField_Filter.setMinimumSize(new Dimension(100, 20));
        this.jTextField_Filter.setPreferredSize(new Dimension(60, 24));
        this.jTextField_Filter.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                DMXDeviceGroupPanel.this.jTextField_FilterKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Search.add((Component)this.jTextField_Filter, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jPanel_Search, gridBagConstraints);
    }

    public void newGroup() {
        final DMXDeviceGroup o_Group = new DMXDeviceGroup();
        this.clearSelectedGroups();
        DMXDeviceGroup.addGroup(o_Group);
        o_Group.resetObjects();
        EventQueueHandler.invokeLater(new Runnable(){

            @Override
            public void run() {
                DMXDeviceGroup.getGroupTableModel().setSelectedElement(DMXDeviceGroupPanel.this.jTable_Groups, o_Group);
                DMXDeviceGroup.getGroupTableModel().scrollToSelection(DMXDeviceGroupPanel.this.jTable_Groups);
                DMXDeviceGroupPanel.this.refreshUI();
            }
        });
    }

    public void deleteSelectedGroups() {
        int[] intSelectedRows = this.jTable_Groups.getSelectedRows();
        this.clearSelectedGroups();
        for (int intSelectedRow = intSelectedRows.length - 1; intSelectedRow >= 0; --intSelectedRow) {
            DMXDeviceGroup o_Group;
            try {
                int intRowModel = this.jTable_Groups.convertRowIndexToModel(intSelectedRows[intSelectedRow]);
                o_Group = DMXDeviceGroup.getGroupTableModel().getGroup(intRowModel);
            }
            catch (Exception e) {
                continue;
            }
            DMXDeviceGroup.removeGroup(o_Group, false);
        }
    }

    public DMXDeviceGroup getGroup(int p_Index) {
        if (p_Index < 0 || p_Index >= DMXDeviceGroup.getGroupCount()) {
            return null;
        }
        return DMXDeviceGroup.getGroup(p_Index);
    }

    public int getGroupCount() {
        return DMXDeviceGroup.getGroupCount();
    }

    public void clearSelectedGroups() {
        this.jTable_Groups.getSelectionModel().clearSelection();
        this.refreshUI();
    }

    public void scrollToViewIndex(int p_FirstViewIndex) {
        if (p_FirstViewIndex < 0) {
            return;
        }
        if (p_FirstViewIndex >= 0) {
            JViewport o_JViewport = (JViewport)this.jTable_Groups.getParent();
            Rectangle o_CellRect = this.jTable_Groups.getCellRect(p_FirstViewIndex, 0, true);
            Rectangle o_ViewportRect = o_JViewport.getViewRect();
            if (o_CellRect.y + o_CellRect.height / 2 < o_ViewportRect.y || o_CellRect.y + o_CellRect.height / 2 > o_ViewportRect.y + o_ViewportRect.height) {
                o_CellRect.setLocation(o_CellRect.x - o_ViewportRect.x, o_CellRect.y - o_ViewportRect.y);
                int intCenterY = (o_ViewportRect.height - o_CellRect.height) / 2;
                if (o_CellRect.y < intCenterY) {
                    intCenterY = -intCenterY;
                }
                o_CellRect.translate(o_CellRect.x, intCenterY);
                o_JViewport.scrollRectToVisible(o_CellRect);
            }
        }
    }

    private void refreshUI() {
        if (s_SelectedDMXDeviceGroups.size() <= 0) {
            this.jButton_SelectionToGroup.setEnabled(false);
            this.jButton_RemoveGroup.setEnabled(false);
            this.jButton_ShowInTimeline.setEnabled(false);
            this.jButton_GroupToSelection.setEnabled(false);
            this.jButton_FilterDevices.setEnabled(false);
            this.jButton_DMXSceneFilter.setEnabled(false);
            this.jButton_Presets_Dimmer.setEnabled(false);
            this.jButton_Presets_Color.setEnabled(false);
            this.jButton_Presets_Position.setEnabled(false);
        } else {
            if (s_SelectedDMXDeviceGroups.size() == 1) {
                this.jButton_SelectionToGroup.setEnabled(true);
            } else {
                this.jButton_SelectionToGroup.setEnabled(false);
            }
            this.jButton_RemoveGroup.setEnabled(true);
            this.jButton_ShowInTimeline.setEnabled(true);
            this.jButton_GroupToSelection.setEnabled(true);
            this.jButton_FilterDevices.setEnabled(true);
            this.jButton_DMXSceneFilter.setEnabled(true);
            this.jButton_Presets_Dimmer.setEnabled(true);
            this.jButton_Presets_Color.setEnabled(true);
            this.jButton_Presets_Position.setEnabled(true);
        }
    }

    private void jButton_NewGroupActionPerformed(ActionEvent evt) {
        this.newGroup();
    }

    private void jButton_SelectionToGroupActionPerformed(ActionEvent evt) {
        if (this.jTable_Groups.getSelectedRowCount() != 1) {
            return;
        }
        int intIndex = this.jTable_Groups.getSelectedRow();
        if (intIndex < 0) {
            return;
        }
        DMXDeviceGroup o_Group = DMXDeviceGroup.getGroup(intIndex = this.jTable_Groups.convertRowIndexToModel(intIndex));
        if (o_Group == null) {
            return;
        }
        o_Group.resetObjects();
    }

    private void jButton_RemoveGroupActionPerformed(ActionEvent evt) {
        this.deleteSelectedGroups();
    }

    private void jButton_GroupToSelectionActionPerformed(ActionEvent evt) {
        LiveShowDMXStageView o_LiveShowDMXStageView = LiveShowDMXSystem.getLiveShowDMXStageView();
        if (o_LiveShowDMXStageView == null) {
            return;
        }
        this.selectDMXDevices();
        o_LiveShowDMXStageView.toFront();
    }

    public void selectDMXDevices() {
        int[] intSelectedRows = this.jTable_Groups.getSelectedRows();
        if (intSelectedRows.length <= 0) {
            return;
        }
        LiveShowDMXStageView o_LiveShowDMXStageView = LiveShowDMXSystem.getLiveShowDMXStageView();
        if (o_LiveShowDMXStageView == null) {
            return;
        }
        o_LiveShowDMXStageView.clearSelectedDMXDevices();
        for (int intSelectedRow = intSelectedRows.length - 1; intSelectedRow >= 0; --intSelectedRow) {
            DMXDeviceGroup o_Group;
            try {
                int intRowModel = this.jTable_Groups.convertRowIndexToModel(intSelectedRows[intSelectedRow]);
                o_Group = DMXDeviceGroup.getGroupTableModel().getGroup(intRowModel);
            }
            catch (Exception e) {
                continue;
            }
            if (o_Group == null) continue;
            o_Group.addSelectedDMXDevices();
        }
    }

    private void jButton_RemoveEmptyGroupsActionPerformed(ActionEvent evt) {
        int intGroupCount = DMXDeviceGroup.getGroupCount();
        if (intGroupCount == 0) {
            return;
        }
        DMXDeviceGroup.clearEmptyGroups();
    }

    private void jButton_ShowInTimelineActionPerformed(ActionEvent evt) {
        int[] intSelectedRows = this.jTable_Groups.getSelectedRows();
        if (intSelectedRows.length <= 0) {
            return;
        }
        LiveShowDMXVIP o_LiveShowDMXVIP = LiveShowDMXSystem.getLiveShowDMXVIP();
        if (o_LiveShowDMXVIP == null) {
            return;
        }
        o_LiveShowDMXVIP.clearSelectedObjects(true);
        for (int intObject = 0; intObject < o_LiveShowDMXVIP.getLiveShowObjectInterfaceCount(); ++intObject) {
            LiveShowObjectInterface o_LiveShowObjectInterface = o_LiveShowDMXVIP.getLiveShowObjectInterface(intObject);
            if (o_LiveShowObjectInterface instanceof LiveShowSceneBridge) continue;
            LiveShowDMXObject o_LiveShowDMXObject = (LiveShowDMXObject)o_LiveShowObjectInterface;
            DMXScene o_DMXScene = o_LiveShowDMXObject.getDMXScene();
            DMXEffect o_DMXEffect = o_LiveShowDMXObject.getDMXEffect();
            if (o_DMXScene == null && o_DMXEffect == null) continue;
            block3: for (int intSelectedRow = intSelectedRows.length - 1; intSelectedRow >= 0; --intSelectedRow) {
                DMXDeviceGroup o_Group;
                try {
                    int intRowModel = this.jTable_Groups.convertRowIndexToModel(intSelectedRows[intSelectedRow]);
                    o_Group = DMXDeviceGroup.getGroupTableModel().getGroup(intRowModel);
                }
                catch (Exception e) {
                    continue;
                }
                if (o_Group == null) continue;
                for (int intDMXDevice = 0; intDMXDevice < o_Group.getObjectCount(); ++intDMXDevice) {
                    DMXDevice o_DMXDevice = o_Group.getObject(intDMXDevice);
                    if (o_DMXScene != null && o_DMXScene.isDimmerOn(o_DMXDevice)) {
                        o_LiveShowDMXVIP.addSelectedObject(o_LiveShowDMXObject);
                        continue block3;
                    }
                    if (o_DMXEffect == null || !o_DMXEffect.useDMXDevice(o_DMXDevice)) continue;
                    o_LiveShowDMXVIP.addSelectedObject(o_LiveShowDMXObject);
                    continue block3;
                }
            }
        }
        if (o_LiveShowDMXVIP.getSelectedObjectsCount() > 0) {
            o_LiveShowDMXVIP.toFront();
        }
    }

    private void jButton_FilterDevicesActionPerformed(ActionEvent evt) {
        LiveShowDMXStageView o_LiveShowDMXStageView = LiveShowDMXSystem.getLiveShowDMXStageView();
        if (o_LiveShowDMXStageView == null) {
            return;
        }
        o_LiveShowDMXStageView.clearSelectedDMXDevices();
        o_LiveShowDMXStageView.filterDMXDevices(DMXDeviceFilter.s_DMXDeviceFilterDeviceGroup);
        o_LiveShowDMXStageView.toFront();
    }

    private void jButton_DMXSceneFilterActionPerformed(ActionEvent evt) {
        LiveShowDMXSceneView o_LiveShowDMXSceneView = LiveShowDMXSceneView.s_SelfReference;
        o_LiveShowDMXSceneView.filterDMXScenes(DMXSceneFilter.s_DMXSceneFilterDeviceGroup);
        LiveShowDMXSceneView.toFront();
    }

    private void jButton_Presets_DimmerMouseClicked(MouseEvent evt) {
        if (evt.getButton() != 1) {
            return;
        }
        if (!this.jButton_Presets_Dimmer.isEnabled()) {
            return;
        }
        DMXValueSelection.show(DMXPresets.s_Presets_Dimmer, DMXDeviceGroupPanel.getSelectedDMXDevices(this.m_TempSelectedDMXDevices), evt.getXOnScreen(), evt.getYOnScreen());
    }

    private void jButton_Presets_ColorMouseClicked(MouseEvent evt) {
        if (evt.getButton() != 1) {
            return;
        }
        if (!this.jButton_Presets_Color.isEnabled()) {
            return;
        }
        DMXValueSelection.show(DMXPresets.s_Presets_Color, DMXDeviceGroupPanel.getSelectedDMXDevices(this.m_TempSelectedDMXDevices), evt.getXOnScreen(), evt.getYOnScreen());
    }

    private void jButton_Presets_PositionMouseClicked(MouseEvent evt) {
        if (evt.getButton() != 1) {
            return;
        }
        if (!this.jButton_Presets_Position.isEnabled()) {
            return;
        }
        DMXValueSelection.show(DMXPresets.s_Presets_Position, DMXDeviceGroupPanel.getSelectedDMXDevices(this.m_TempSelectedDMXDevices), evt.getXOnScreen(), evt.getYOnScreen());
    }

    private void jTextField_FilterKeyReleased(KeyEvent evt) {
        this.clearSelectedGroups();
        DMXDeviceGroup.getGroupTableModel().filter(this.jTextField_Filter.getText());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<DMXDevice> getSelectedDMXDevices(ArrayList<DMXDevice> p_SelectedDMXDevices) {
        if (p_SelectedDMXDevices == null) {
            p_SelectedDMXDevices = new ArrayList();
        }
        p_SelectedDMXDevices.clear();
        Object object = DMXDeviceGroup.s_SyncObjects;
        synchronized (object) {
            for (int intGroup = 0; intGroup < s_SelectedDMXDeviceGroups.size(); ++intGroup) {
                DMXDeviceGroup o_DMXDeviceGroup = s_SelectedDMXDeviceGroups.get(intGroup);
                if (o_DMXDeviceGroup == null) continue;
                for (int intDevice = 0; intDevice < o_DMXDeviceGroup.getObjectCount(); ++intDevice) {
                    DMXDevice o_DMXDevice = o_DMXDeviceGroup.getObject(intDevice);
                    if (o_DMXDevice == null || p_SelectedDMXDevices.contains(o_DMXDevice)) continue;
                    p_SelectedDMXDevices.add(o_DMXDevice);
                }
            }
        }
        return p_SelectedDMXDevices;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshSelectedGroups() {
        Object object = DMXDeviceGroup.s_SyncObjects;
        synchronized (object) {
            s_SelectedDMXDeviceGroups.clear();
            int[] intSelectedRows = DMXDeviceGroupPanel.s_SelfReference.jTable_Groups.getSelectedRows();
            if (intSelectedRows.length <= 0) {
                return;
            }
            for (int intSelectedRow = intSelectedRows.length - 1; intSelectedRow >= 0; --intSelectedRow) {
                DMXDeviceGroup o_Group;
                try {
                    int intRowModel = DMXDeviceGroupPanel.s_SelfReference.jTable_Groups.convertRowIndexToModel(intSelectedRows[intSelectedRow]);
                    o_Group = DMXDeviceGroup.getGroupTableModel().getGroup(intRowModel);
                }
                catch (Exception e) {
                    continue;
                }
                if (o_Group == null) continue;
                s_SelectedDMXDeviceGroups.add(o_Group);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getSelectedGroupCount() {
        Object object = s_SyncSelection;
        synchronized (object) {
            return s_SelectedDMXDeviceGroups.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DMXDeviceGroup getSelectedGroup(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        Object object = s_SyncSelection;
        synchronized (object) {
            if (p_Index >= s_SelectedDMXDeviceGroups.size()) {
                return null;
            }
            return s_SelectedDMXDeviceGroups.get(p_Index);
        }
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dge) {
    }

    @Override
    public void dragEnter(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dsde) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragExit(DragSourceEvent dse) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde) {
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        DMXDeviceGroupPanel.refreshSelectedGroups();
        this.refreshUI();
    }

    public static void showFrame() {
        if (s_FrameParent != null) {
            s_FrameParent.showFrame();
        }
    }

    public static void setFrameParent(FrameParent p_FrameParent) {
        s_FrameParent = p_FrameParent;
    }

    static {
        s_SyncSelection = new Object();
    }
}

