/*
 * Decompiled with CFR 0.152.
 */
package DMXDevicePackage;

import DMXDevicePackage.DMXDevice;
import DMXDevicePackage.DMXDeviceFilter;
import DMXGraphics.LiveShowDMXStageView;
import GUID.LiveGUID;
import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LanguageTools.LiveLanguagePackage.LiveLanguageString;
import LiveShowObjectPackage.LiveShowProjectDescription;
import LiveShowObjectPackage.SinglePropertyChangeSupport;
import LiveShowVirtualPackage.LiveShow_ExportDescription;
import LiveShowVirtualPackage.LiveShow_ImportDescription;
import StartPackage.LiveShowDMXSystem;
import SwingModelPackage.TableAndListModel;
import SwingToolTipPackage.PopUpToolTip;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Externalizable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;

public class DMXDeviceGroup
implements PropertyChangeListener,
DMXDeviceFilter.FilterInterface,
Externalizable {
    public static final int SOFTWAREVERSION = 1;
    public static final String FILESUFFIX = ".ldg";
    public static ImageIcon s_Icon = new ImageIcon(DMXDeviceGroup.class.getResource("/IconsPackage/DeviceGroupView.png"));
    @LiveLanguageString
    public static String DEFAULT_GROUPNAME = "DeviceGroup";
    public static int s_GroupCounter = 0;
    public static DMXDeviceGroupTableModel s_GroupTableModel = new DMXDeviceGroupTableModel();
    public static final String PROP_NAME = "groupName";
    public static final String PROP_REMARK = "groupRemark";
    public static final String PROP_CLOSED = "groupClosed";
    private String m_ID;
    private String m_Name;
    private String m_Remark;
    private ArrayList<DMXDevice> m_DMXDevices;
    private String m_ToolTipText;
    private StringBuilder m_StringBuilderToolTip;
    private final Object m_SyncStringBuilder = new Object();
    protected SinglePropertyChangeSupport m_PropertyChangeSupport;
    protected static final Object s_SyncObjects = new Object();
    public static ArrayList<LiveShowDMXStageView.LiveShowDMXStageViewListener> s_DMXStageViewListeners = new ArrayList();
    public static final Object s_SyncStageViewListener = new Object();
    public static int DMXDEVICES_PER_COLUMN = 25;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addStageViewListener(LiveShowDMXStageView.LiveShowDMXStageViewListener p_LiveShowDMXStageViewListener) {
        if (p_LiveShowDMXStageViewListener == null) {
            return;
        }
        Object object = s_SyncStageViewListener;
        synchronized (object) {
            if (s_DMXStageViewListeners.contains(p_LiveShowDMXStageViewListener)) {
                return;
            }
            s_DMXStageViewListeners.add(p_LiveShowDMXStageViewListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeStageViewListener(LiveShowDMXStageView.LiveShowDMXStageViewListener p_LiveShowDMXStageViewListener) {
        if (p_LiveShowDMXStageViewListener == null) {
            return;
        }
        Object object = s_SyncStageViewListener;
        synchronized (object) {
            s_DMXStageViewListeners.remove(p_LiveShowDMXStageViewListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fireDMXStageView_DMXDeviceGroupAdded(DMXDeviceGroup p_DMXDeviceGroup) {
        ArrayList<LiveShowDMXStageView.LiveShowDMXStageViewListener> o_DMXStageViewListeners;
        Object object = s_SyncStageViewListener;
        synchronized (object) {
            o_DMXStageViewListeners = new ArrayList<LiveShowDMXStageView.LiveShowDMXStageViewListener>(s_DMXStageViewListeners.size());
            o_DMXStageViewListeners.addAll(s_DMXStageViewListeners);
        }
        for (int intListener = 0; intListener < o_DMXStageViewListeners.size(); ++intListener) {
            LiveShowDMXStageView.LiveShowDMXStageViewListener o_DMXStageViewListener = (LiveShowDMXStageView.LiveShowDMXStageViewListener)o_DMXStageViewListeners.get(intListener);
            o_DMXStageViewListener.eventDMXDeviceGroupAdded(p_DMXDeviceGroup);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fireDMXStageView_DMXDeviceGroupRemoved(DMXDeviceGroup p_DMXDeviceGroup) {
        ArrayList<LiveShowDMXStageView.LiveShowDMXStageViewListener> o_DMXStageViewListeners;
        Object object = s_SyncStageViewListener;
        synchronized (object) {
            o_DMXStageViewListeners = new ArrayList<LiveShowDMXStageView.LiveShowDMXStageViewListener>(s_DMXStageViewListeners.size());
            o_DMXStageViewListeners.addAll(s_DMXStageViewListeners);
        }
        for (int intListener = 0; intListener < o_DMXStageViewListeners.size(); ++intListener) {
            LiveShowDMXStageView.LiveShowDMXStageViewListener o_DMXStageViewListener = (LiveShowDMXStageView.LiveShowDMXStageViewListener)o_DMXStageViewListeners.get(intListener);
            o_DMXStageViewListener.eventDMXDeviceGroupRemoved(p_DMXDeviceGroup);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fireDMXStageView_DMXDeviceGroupChanged(DMXDeviceGroup p_DMXDeviceGroup) {
        ArrayList<LiveShowDMXStageView.LiveShowDMXStageViewListener> o_DMXStageViewListeners;
        Object object = s_SyncStageViewListener;
        synchronized (object) {
            o_DMXStageViewListeners = new ArrayList<LiveShowDMXStageView.LiveShowDMXStageViewListener>(s_DMXStageViewListeners.size());
            o_DMXStageViewListeners.addAll(s_DMXStageViewListeners);
        }
        for (int intListener = 0; intListener < o_DMXStageViewListeners.size(); ++intListener) {
            LiveShowDMXStageView.LiveShowDMXStageViewListener o_DMXStageViewListener = (LiveShowDMXStageView.LiveShowDMXStageViewListener)o_DMXStageViewListeners.get(intListener);
            o_DMXStageViewListener.eventDMXDeviceGroupChanged(p_DMXDeviceGroup);
        }
    }

    public DMXDeviceGroup() {
        this.initMembers();
        LiveLanguage.addLanguageListener((Object)this, null);
        this.m_Name = DEFAULT_GROUPNAME + String.valueOf(s_GroupCounter);
        this.createToolTipText();
        DMXDeviceFilter.createDMXDeviceFilter(this);
    }

    private void initMembers() {
        this.m_StringBuilderToolTip = new StringBuilder();
        this.m_DMXDevices = new ArrayList();
        this.m_PropertyChangeSupport = new SinglePropertyChangeSupport(this);
        this.m_ID = LiveGUID.getGUID();
        if (++s_GroupCounter <= s_GroupTableModel.size()) {
            s_GroupCounter = s_GroupTableModel.size() + 1;
        }
        this.m_Remark = "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(1);
        out.writeUTF(this.m_ID);
        out.writeUTF(this.m_Name);
        out.writeUTF(this.m_Remark);
        Object object = s_SyncObjects;
        synchronized (object) {
            out.writeInt(this.m_DMXDevices.size());
            for (int intObject = 0; intObject < this.m_DMXDevices.size(); ++intObject) {
                DMXDevice o_DMXDevice = this.m_DMXDevices.get(intObject);
                out.writeUTF(o_DMXDevice.getID());
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int intSoftwareVersion = in.readInt();
        String oldValue = this.m_Name;
        this.m_ID = in.readUTF();
        this.m_Name = in.readUTF();
        this.m_Remark = in.readUTF();
        int intObjectCount = in.readInt();
        for (int intObject = 0; intObject < intObjectCount; ++intObject) {
            String stringObjectID = in.readUTF();
            DMXDevice o_DMXDevice = DMXDevice.getDMXDevice(stringObjectID);
            if (o_DMXDevice == null) continue;
            this.addObject(o_DMXDevice);
        }
        this.createToolTipText();
        if (this.m_PropertyChangeSupport != null) {
            this.m_PropertyChangeSupport.firePropertyChange(PROP_NAME, oldValue, this.m_Name);
        }
    }

    protected void close() {
        DMXDeviceFilter.removeDMXDeviceFilter(this);
        this.clearObjects();
        if (this.m_PropertyChangeSupport != null) {
            this.m_PropertyChangeSupport.firePropertyChange(PROP_CLOSED, this, null);
            this.m_PropertyChangeSupport.clear();
        }
        LiveLanguage.removeLanguageListener((Object)this);
    }

    public String getID() {
        return this.m_ID;
    }

    private void setID(String p_ID) {
        if (p_ID == null) {
            return;
        }
        this.m_ID = p_ID;
    }

    @Override
    public String getName() {
        return this.m_Name;
    }

    public void setName(String p_Name) {
        if (p_Name == null) {
            return;
        }
        if (p_Name.equals(this.m_Name)) {
            return;
        }
        String oldValue = this.m_Name;
        this.m_Name = p_Name;
        this.createToolTipText();
        if (this.m_PropertyChangeSupport != null) {
            this.m_PropertyChangeSupport.firePropertyChange(PROP_NAME, oldValue, this.m_Name);
        }
        DMXDeviceGroup.fireDMXStageView_DMXDeviceGroupChanged(this);
    }

    @Override
    public String getRemark() {
        return this.m_Remark;
    }

    public void setRemark(String p_Remark) {
        if (p_Remark == null) {
            return;
        }
        if (p_Remark.equals(this.m_Remark)) {
            return;
        }
        String oldValue = this.m_Remark;
        this.m_Remark = p_Remark;
        this.createToolTipText();
        if (this.m_PropertyChangeSupport != null) {
            this.m_PropertyChangeSupport.firePropertyChange(PROP_REMARK, oldValue, this.m_Remark);
        }
        DMXDeviceGroup.fireDMXStageView_DMXDeviceGroupChanged(this);
    }

    public void resetObjects() {
        this.clearObjects();
        LiveShowDMXStageView o_LiveShowDMXStageView = LiveShowDMXSystem.getLiveShowDMXStageView();
        int intSelectedObjectCount = o_LiveShowDMXStageView.getSelectedDMXDeviceCount();
        for (int intDMXDevice = 0; intDMXDevice < intSelectedObjectCount; ++intDMXDevice) {
            DMXDevice o_DMXDevice = o_LiveShowDMXStageView.getSelectedDMXDevice(intDMXDevice);
            this.addObject(o_DMXDevice);
        }
        this.createToolTipText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearObjects() {
        Object object = s_SyncObjects;
        synchronized (object) {
            for (int intObject = this.m_DMXDevices.size() - 1; intObject >= 0; --intObject) {
                DMXDevice o_DMXDevice = this.m_DMXDevices.get(intObject);
                this.removeObject(o_DMXDevice, false);
            }
            this.m_DMXDevices.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getObjectCount() {
        Object object = s_SyncObjects;
        synchronized (object) {
            return this.m_DMXDevices.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addObject(DMXDevice p_DMXDevice) {
        if (p_DMXDevice == null) {
            return false;
        }
        Object object = s_SyncObjects;
        synchronized (object) {
            int intIndex = 0;
            if (this.m_DMXDevices.contains(p_DMXDevice)) {
                return false;
            }
            for (intIndex = 0; intIndex < this.m_DMXDevices.size(); ++intIndex) {
                DMXDevice o_DMXDevice = this.m_DMXDevices.get(intIndex);
                if (p_DMXDevice.getName().compareToIgnoreCase(o_DMXDevice.getName()) < 0) break;
            }
            this.m_DMXDevices.add(intIndex, p_DMXDevice);
            p_DMXDevice.addPropertyChangeListener("dmxdeviceClosed", this);
            p_DMXDevice.addPropertyChangeListener("dmxdeviceDeviceName", this);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeObject(DMXDevice p_DMXDevice, boolean p_KeepRemovedObjectID) {
        if (p_DMXDevice == null) {
            return false;
        }
        Object object = s_SyncObjects;
        synchronized (object) {
            if (!this.m_DMXDevices.contains(p_DMXDevice)) {
                return false;
            }
            this.m_DMXDevices.remove(p_DMXDevice);
            p_DMXDevice.removePropertyChangeListener("dmxdeviceClosed", this);
            p_DMXDevice.removePropertyChangeListener("dmxdeviceDeviceName", this);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DMXDevice getObject(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        Object object = s_SyncObjects;
        synchronized (object) {
            if (p_Index >= this.m_DMXDevices.size()) {
                return null;
            }
            return this.m_DMXDevices.get(p_Index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createToolTipText() {
        int intDMXDeviceCount_InColumn = 0;
        StringBuilder o_StringBuffer = new StringBuilder();
        o_StringBuffer.append("<html>");
        o_StringBuffer.append("<center><b>");
        o_StringBuffer.append(this.getName());
        o_StringBuffer.append("</b></center>");
        o_StringBuffer.append("<br>");
        if (this.getRemark() != null && this.getRemark().length() > 0) {
            o_StringBuffer.append("<center><b>");
            o_StringBuffer.append(this.getRemark());
            o_StringBuffer.append("</b></center>");
            o_StringBuffer.append("<br>");
        }
        o_StringBuffer.append("<table align=center>");
        o_StringBuffer.append("<tr>");
        o_StringBuffer.append("<td align=center>");
        o_StringBuffer.append("");
        o_StringBuffer.append("</td>");
        o_StringBuffer.append("<td align=center>");
        o_StringBuffer.append("");
        o_StringBuffer.append("</td>");
        o_StringBuffer.append("</tr>");
        o_StringBuffer.append("<tr>");
        o_StringBuffer.append("<td align=right><b>");
        o_StringBuffer.append(DMXDevice.DEFAULT_DMXDEVICENAME);
        o_StringBuffer.append("</b></td>");
        o_StringBuffer.append("<td align=right><b>");
        o_StringBuffer.append("</b></td>");
        o_StringBuffer.append("</tr>");
        o_StringBuffer.append("</table>");
        o_StringBuffer.append("<table align=center>");
        o_StringBuffer.append("<tr>");
        o_StringBuffer.append("<td align=center>");
        o_StringBuffer.append("<table align=top>");
        Object object = s_SyncObjects;
        synchronized (object) {
            for (int intDMXDevice = 0; intDMXDevice < this.m_DMXDevices.size(); ++intDMXDevice) {
                DMXDevice o_DMXDevice = this.m_DMXDevices.get(intDMXDevice);
                if (o_DMXDevice == null) continue;
                if (intDMXDeviceCount_InColumn >= DMXDEVICES_PER_COLUMN) {
                    intDMXDeviceCount_InColumn = 0;
                    o_StringBuffer.append("</table>");
                    o_StringBuffer.append("</td>");
                    o_StringBuffer.append("<td align=center>");
                    o_StringBuffer.append("<table align=top>");
                }
                o_StringBuffer.append("<p>");
                o_StringBuffer.append("<tr>");
                o_StringBuffer.append("<td align=left>");
                o_StringBuffer.append(o_DMXDevice.getName());
                o_StringBuffer.append("</td>");
                o_StringBuffer.append("</tr>");
                o_StringBuffer.append("</p");
                ++intDMXDeviceCount_InColumn;
            }
        }
        o_StringBuffer.append("</table>");
        o_StringBuffer.append("</td>");
        o_StringBuffer.append("<table>");
        o_StringBuffer.append("</html>");
        this.m_ToolTipText = o_StringBuffer.toString();
        return this.m_ToolTipText;
    }

    public String getToolTipText() {
        return this.m_ToolTipText;
    }

    public void addSelectedDMXDevices() {
        LiveShowDMXStageView o_LiveShowDMXStageView = LiveShowDMXSystem.getLiveShowDMXStageView();
        if (o_LiveShowDMXStageView == null) {
            return;
        }
        for (int intDMXDevice = 0; intDMXDevice < this.getObjectCount(); ++intDMXDevice) {
            DMXDevice o_DMXDevice = this.getObject(intDMXDevice);
            if (o_DMXDevice == null) continue;
            o_LiveShowDMXStageView.addSelectedDMXDevice(o_DMXDevice);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
        if (p_PropertyChangeListener == null) {
            return;
        }
        if (this.m_PropertyChangeSupport != null) {
            this.m_PropertyChangeSupport.addPropertyChangeListener(p_PropertyChangeListener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
        if (this.m_PropertyChangeSupport != null) {
            this.m_PropertyChangeSupport.removePropertyChangeListener(p_PropertyChangeListener);
        }
    }

    public static DMXDeviceGroupTableModel getGroupTableModel() {
        return s_GroupTableModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addGroup(DMXDeviceGroup p_Group) {
        if (p_Group == null) {
            return;
        }
        Object object = s_SyncObjects;
        synchronized (object) {
            s_GroupTableModel.addGroup(p_Group);
        }
        DMXDeviceGroup.fireDMXStageView_DMXDeviceGroupAdded(p_Group);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeGroup(DMXDeviceGroup p_Group, boolean p_ProjectClosed) {
        if (p_Group == null) {
            return;
        }
        Object object = s_SyncObjects;
        synchronized (object) {
            s_GroupTableModel.removeGroup(p_Group);
        }
        DMXDeviceGroup.fireDMXStageView_DMXDeviceGroupRemoved(p_Group);
        p_Group.close();
        if (!p_ProjectClosed) {
            // empty if block
        }
    }

    public static ArrayList<DMXDeviceGroup> getGroups() {
        ArrayList<DMXDeviceGroup> o_Groups = s_GroupTableModel.getElementArrayList_Safe();
        return o_Groups;
    }

    public static int getGroupCount() {
        return s_GroupTableModel.size();
    }

    public static DMXDeviceGroup getGroup(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        return s_GroupTableModel.getGroup(p_Index);
    }

    public static boolean contains(String p_ID) {
        return s_GroupTableModel.contains(p_ID);
    }

    public static DMXDeviceGroup getGroup(String p_ID) {
        if (p_ID == null) {
            return null;
        }
        Object o_Group = null;
        return s_GroupTableModel.getGroup(p_ID);
    }

    public static DMXDeviceGroup getGroupByName(String p_Name) {
        if (p_Name == null) {
            return null;
        }
        DMXDeviceGroup o_Group = null;
        int intGroupCount = DMXDeviceGroup.getGroupCount();
        for (int intGroup = 0; intGroup < intGroupCount; ++intGroup) {
            o_Group = s_GroupTableModel.getGroup(intGroup);
            if (o_Group == null) continue;
            if (p_Name.equals(o_Group.getName())) break;
            o_Group = null;
        }
        return o_Group;
    }

    public static void clear() {
        int intGroupCount = DMXDeviceGroup.getGroupCount();
        for (int intGroup = intGroupCount - 1; intGroup >= 0; --intGroup) {
            DMXDeviceGroup o_Group = s_GroupTableModel.getGroup(intGroup);
            DMXDeviceGroup.removeGroup(o_Group, true);
        }
    }

    public static void clearEmptyGroups() {
        for (int intGroup = DMXDeviceGroup.getGroupCount() - 1; intGroup >= 0; --intGroup) {
            DMXDeviceGroup o_Group = s_GroupTableModel.getGroup(intGroup);
            if (o_Group.getObjectCount() != 0) continue;
            DMXDeviceGroup.removeGroup(o_Group, false);
        }
    }

    public static boolean saveGroups(LiveShowProjectDescription p_LiveShowProjectDescription, LiveShow_ExportDescription p_LiveShow_ExportDescription) {
        if (!p_LiveShow_ExportDescription.getSaveProject() && !p_LiveShow_ExportDescription.getExportProjectAll()) {
            return false;
        }
        return DMXDeviceGroup.saveGroups(p_LiveShowProjectDescription, (ArrayList<DMXDeviceGroup>)null);
    }

    public static boolean saveGroups(LiveShowProjectDescription p_LiveShowProjectDescription, ArrayList<DMXDeviceGroup> p_Groups) {
        if (p_LiveShowProjectDescription == null) {
            return false;
        }
        String stringFileName = p_LiveShowProjectDescription.getProjectPathName() + FILESUFFIX;
        try {
            File o_File = new File(stringFileName);
            if (o_File.exists()) {
                try {
                    o_File.delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (p_Groups == null ? s_GroupTableModel.size() <= 0 : p_Groups.size() <= 0) {
                return true;
            }
            o_File.createNewFile();
            FileOutputStream o_FileOutputStream = new FileOutputStream(o_File);
            ObjectOutputStream o_ObjectOutput = new ObjectOutputStream(o_FileOutputStream);
            o_ObjectOutput.writeInt(1);
            if (p_Groups == null) {
                int intGroupCount = DMXDeviceGroup.getGroupCount();
                o_ObjectOutput.writeInt(intGroupCount);
                for (int intGroup = 0; intGroup < intGroupCount; ++intGroup) {
                    DMXDeviceGroup o_Group = DMXDeviceGroup.getGroup(intGroup);
                    if (o_Group == null) continue;
                    o_Group.writeExternal(o_ObjectOutput);
                }
            } else {
                int intGroupCount = p_Groups.size();
                o_ObjectOutput.writeInt(intGroupCount);
                for (int intGroup = 0; intGroup < intGroupCount; ++intGroup) {
                    DMXDeviceGroup o_Group = p_Groups.get(intGroup);
                    if (o_Group == null) continue;
                    o_Group.writeExternal(o_ObjectOutput);
                }
            }
            o_ObjectOutput.close();
            o_FileOutputStream.close();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean deleteGroups(LiveShowProjectDescription p_LiveShowProjectDescription) {
        if (p_LiveShowProjectDescription == null) {
            return false;
        }
        boolean boolSuccess = false;
        String stringFileName = p_LiveShowProjectDescription.getProjectPathName() + FILESUFFIX;
        File o_File = new File(stringFileName);
        if (o_File.exists()) {
            try {
                boolSuccess = o_File.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return boolSuccess;
    }

    public static boolean loadGroups(LiveShowProjectDescription p_LiveShowProjectDescription, LiveShow_ImportDescription p_LiveShow_ImportDescription) {
        if (p_LiveShowProjectDescription == null) {
            return false;
        }
        FileInputStream o_FileInputStream = null;
        ObjectInputStream o_ObjectInput = null;
        String stringFileName = p_LiveShowProjectDescription.getProjectPathName() + FILESUFFIX;
        try {
            File o_File = new File(stringFileName);
            if (!o_File.exists()) {
                return false;
            }
            o_FileInputStream = new FileInputStream(o_File);
            o_ObjectInput = new ObjectInputStream(o_FileInputStream);
            int intSoftwareVersion = o_ObjectInput.readInt();
            int intGroupCount = o_ObjectInput.readInt();
            for (int intGroup = 0; intGroup < intGroupCount; ++intGroup) {
                DMXDeviceGroup o_Group = new DMXDeviceGroup();
                o_Group.readExternal(o_ObjectInput);
                if (DMXDeviceGroup.contains(o_Group.getID())) {
                    o_Group.close();
                    continue;
                }
                if (p_LiveShow_ImportDescription == null || p_LiveShow_ImportDescription.getLoadNewProject()) {
                    DMXDeviceGroup.addGroup(o_Group);
                    continue;
                }
                String stringGroupName = o_Group.getName();
                stringGroupName = LiveShow_ImportDescription.createImportedName(stringGroupName);
                o_Group.setName(stringGroupName);
                DMXDeviceGroup.addGroup(o_Group);
            }
            o_ObjectInput.close();
            o_FileInputStream.close();
        }
        catch (Exception e) {
            try {
                if (o_ObjectInput != null) {
                    o_ObjectInput.close();
                }
                if (o_FileInputStream != null) {
                    o_FileInputStream.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
        return true;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof DMXDevice) {
            if ("dmxdeviceClosed".equals(evt.getPropertyName())) {
                this.removeObject((DMXDevice)evt.getSource(), true);
                this.createToolTipText();
            }
            if ("dmxdeviceDeviceName".equals(evt.getPropertyName())) {
                this.removeObject((DMXDevice)evt.getSource(), false);
                this.addObject((DMXDevice)evt.getSource());
                this.createToolTipText();
            }
        }
    }

    @Override
    public Icon getIcon() {
        return s_Icon;
    }

    @Override
    public boolean useDMXDevice(DMXDevice p_DMXDevice) {
        if (p_DMXDevice == null) {
            return false;
        }
        return this.m_DMXDevices.contains(p_DMXDevice);
    }

    public static class DMXDeviceGroup_RowFilter
    extends RowFilter<DMXDeviceGroup, Integer> {
        private DMXDeviceGroupTableModel m_DMXDeviceGroupTableModel;
        private String m_FilterString;

        public DMXDeviceGroup_RowFilter(DMXDeviceGroupTableModel p_DMXDeviceGroupTableModel) {
            this.initMembers();
            this.m_DMXDeviceGroupTableModel = p_DMXDeviceGroupTableModel;
        }

        private void initMembers() {
            this.m_FilterString = null;
        }

        public void setFilterString(String p_FilterString) {
            this.m_FilterString = p_FilterString == null ? "" : p_FilterString.toLowerCase();
            if (this.m_DMXDeviceGroupTableModel != null) {
                this.m_DMXDeviceGroupTableModel.fireTableDataChanged();
            }
        }

        @Override
        public boolean include(RowFilter.Entry entry) {
            if (this.m_DMXDeviceGroupTableModel == null) {
                return false;
            }
            if (this.m_FilterString == null) {
                return true;
            }
            if (this.m_FilterString.length() <= 0) {
                return true;
            }
            int intRow = (Integer)entry.getIdentifier();
            DMXDeviceGroup o_DMXDeviceGroup = this.m_DMXDeviceGroupTableModel.getGroup(intRow);
            if (o_DMXDeviceGroup == null) {
                return false;
            }
            if (o_DMXDeviceGroup.getName().toLowerCase().contains(this.m_FilterString)) {
                return true;
            }
            return o_DMXDeviceGroup.getRemark().toLowerCase().contains(this.m_FilterString);
        }
    }

    public static class DMXDeviceGroupTableModel
    extends TableAndListModel<DMXDeviceGroup>
    implements PropertyChangeListener {
        public static final int COLUMNCOUNT = 2;
        public static final int COLUMNINDEX_GROUPNAME = 0;
        public static final int COLUMNINDEX_GROUPREMARK = 1;
        @LiveLanguageString
        public static String COLUMN_GROUPNAME = "Name";
        @LiveLanguageString
        public static String COLUMN_GROUPREMARK = "Description";
        TableRowSorter m_TableRowSorter;
        DMXDeviceGroup_RowFilter m_DMXDeviceGroup_RowFilter;
        private final Object m_SyncObject = new Object();

        public DMXDeviceGroupTableModel() {
            super(false);
            this.initMembers();
            LiveLanguage.addLanguageListener((Object)this, null);
        }

        private void initMembers() {
            this.m_DMXDeviceGroup_RowFilter = new DMXDeviceGroup_RowFilter(this);
            this.m_TableRowSorter = new TableRowSorter<DMXDeviceGroupTableModel>(this);
            this.m_TableRowSorter.setComparator(0, TableAndListModel.getStringComparator_Normal());
            this.m_TableRowSorter.setComparator(1, TableAndListModel.getStringComparator_Normal());
        }

        public void finishJTable(JTable p_JTable) {
            TableAndListModel.TableCellEditorRenderer_String o_TableCellEditorRenderer_String;
            if (p_JTable == null) {
                return;
            }
            super.finishJTable(p_JTable, this.m_TableRowSorter, this.m_DMXDeviceGroup_RowFilter);
            TableColumnModel o_TableColumnModel = p_JTable.getColumnModel();
            TableColumn o_TableColumn = o_TableColumnModel.getColumn(0);
            if (o_TableColumn != null) {
                o_TableCellEditorRenderer_String = new TableAndListModel.TableCellEditorRenderer_String();
                o_TableCellEditorRenderer_String.setIcon(s_Icon);
                o_TableCellEditorRenderer_String.setHorizontalAlignment(10);
                o_TableCellEditorRenderer_String.setToolTipText_Automatic(2);
                o_TableCellEditorRenderer_String.setToolTipTextAt(false, true);
                o_TableColumn.setCellEditor(o_TableCellEditorRenderer_String);
                o_TableColumn.setCellRenderer(o_TableCellEditorRenderer_String);
            }
            if ((o_TableColumn = o_TableColumnModel.getColumn(1)) != null) {
                o_TableCellEditorRenderer_String = new TableAndListModel.TableCellEditorRenderer_String();
                o_TableCellEditorRenderer_String.setToolTipText_Automatic(2);
                o_TableCellEditorRenderer_String.setHorizontalAlignment(10);
                o_TableCellEditorRenderer_String.setToolTipTextAt(false, true);
                o_TableColumn.setCellEditor(o_TableCellEditorRenderer_String);
                o_TableColumn.setCellRenderer(o_TableCellEditorRenderer_String);
            }
            p_JTable.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        }

        public void filter(String p_FilterString) {
            if (this.m_DMXDeviceGroup_RowFilter != null) {
                this.m_DMXDeviceGroup_RowFilter.setFilterString(p_FilterString);
            }
        }

        @Override
        public boolean contains(String p_ID) {
            if (p_ID == null) {
                return false;
            }
            DMXDeviceGroup o_Group = this.getGroup(p_ID);
            return o_Group != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DMXDeviceGroup getGroup(String p_ID) {
            Object object = this.m_SyncObject;
            synchronized (object) {
                for (int intGroup = 0; intGroup < this.size(); ++intGroup) {
                    DMXDeviceGroup o_Group = (DMXDeviceGroup)this.get(intGroup);
                    if (o_Group == null || !p_ID.equals(o_Group.getID())) continue;
                    return o_Group;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addGroup(DMXDeviceGroup p_Group) {
            if (p_Group == null) {
                return;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (this.add(p_Group)) {
                    p_Group.addPropertyChangeListener(this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeGroup(DMXDeviceGroup p_Group) {
            if (p_Group == null) {
                return;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (this.remove(p_Group)) {
                    p_Group.removePropertyChangeListener(this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addSelectedGroup(JTable p_JTable, DMXDeviceGroup p_Group) {
            if (p_JTable == null) {
                return;
            }
            if (p_Group == null) {
                return;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                super.addSelectedElement(p_JTable, p_Group);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeSelectedGroup(JTable p_JTable, DMXDeviceGroup p_Group) {
            if (p_JTable == null) {
                return;
            }
            if (p_Group == null) {
                return;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                super.removeSelectedElement(p_JTable, p_Group);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DMXDeviceGroup getGroup(int p_Index) {
            if (p_Index < 0) {
                return null;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                return (DMXDeviceGroup)this.get(p_Index);
            }
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return COLUMN_GROUPNAME;
                }
                case 1: {
                    return COLUMN_GROUPREMARK;
                }
            }
            return "";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getValue(DMXDeviceGroup p_Group, int columnIndex) {
            String stringValue = "";
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (p_Group == null) {
                    return stringValue;
                }
                switch (columnIndex) {
                    case 0: {
                        stringValue = p_Group.getName();
                        break;
                    }
                    case 1: {
                        stringValue = p_Group.getRemark();
                    }
                }
                return stringValue;
            }
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            switch (col) {
                case 0: {
                    return true;
                }
                case 1: {
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setValue(DMXDeviceGroup p_Group, Object value, int col) {
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (p_Group == null) {
                    return;
                }
            }
            switch (col) {
                case 0: {
                    String stringValue = (String)value;
                    p_Group.setName(stringValue);
                    break;
                }
                case 1: {
                    String stringValue = (String)value;
                    p_Group.setRemark(stringValue);
                }
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() instanceof DMXDeviceGroup) {
                DMXDeviceGroup o_DMXDeviceGroup = (DMXDeviceGroup)evt.getSource();
                if (DMXDeviceGroup.PROP_NAME.equals(evt.getPropertyName())) {
                    this.changedElement(o_DMXDeviceGroup);
                } else if (DMXDeviceGroup.PROP_REMARK.equals(evt.getPropertyName())) {
                    this.changedElement(o_DMXDeviceGroup);
                } else if (DMXDeviceGroup.PROP_CLOSED.equals(evt.getPropertyName())) {
                    // empty if block
                }
            }
        }
    }
}

