/*
 * Decompiled with CFR 0.152.
 */
package DMXDevicePackage;

import DMXDevicePackage.DMXDevice;
import DMXDevicePackage.DMXDeviceType;
import DMXDevicePackage.DMXPresets;
import DMXMixer.DMXValueSelection;
import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LiveShowControlModels.ControlFunctionModel;
import SwingModelPackage.TableAndListModel;
import SwingToolTipPackage.PopUpToolTip;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class DMXDeviceFunctionPanel
extends JPanel
implements ListDataListener {
    public static final int ORIENTATION_HORIZONTAL = 0;
    public static final int ORIENTATION_VERTICAL = 1;
    public static final int BUTTON_OFFSET = DMXPresets.DMXPRESETSCOUNT + 2;
    private int m_Orientation;
    private ArrayList<FunctionTypeLabel> m_FunctionTypeLabels;
    private HashMap<ControlFunctionModel.ControlFunctionType, FunctionTypeLabel> m_HashMapFunctionTypeLabels;
    private ArrayList<DMXDevice> m_DMXDevices;
    private MouseAdapter m_MouseAdapter;
    private final Object m_SyncDMXDevices = new Object();
    private final Object m_SyncFunctionTypeLabel = new Object();
    private JLabel jButton_DeviceSetDefaults;
    private JLabel jButton_DeviceSetNull;
    private JLabel jButton_Presets_Color;
    private JLabel jButton_Presets_Dimmer;
    private JLabel jButton_Presets_Position;

    public DMXDeviceFunctionPanel() {
        this.initMembers();
        this.initComponents();
        this.initComponentsFurther();
        LiveLanguage.addLanguageListener((Object)this, null);
    }

    private void initMembers() {
        this.m_FunctionTypeLabels = new ArrayList();
        this.m_HashMapFunctionTypeLabels = new HashMap();
        this.m_DMXDevices = new ArrayList();
        this.m_Orientation = 0;
    }

    private void initComponents() {
        this.jButton_DeviceSetDefaults = new JLabel();
        this.jButton_DeviceSetNull = new JLabel();
        this.jButton_Presets_Color = new JLabel();
        this.jButton_Presets_Position = new JLabel();
        this.jButton_Presets_Dimmer = new JLabel();
        this.setLayout(new GridBagLayout());
        this.jButton_DeviceSetDefaults.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Slider_DeviceDefaultValues.png")));
        this.jButton_DeviceSetDefaults.setToolTipText("Set default channel values to all channels");
        this.jButton_DeviceSetDefaults.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DMXDeviceFunctionPanel.this.jButton_DeviceSetDefaultsMouseClicked(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jButton_DeviceSetDefaults, gridBagConstraints);
        this.jButton_DeviceSetNull.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Slider_DeviceNullValues.png")));
        this.jButton_DeviceSetNull.setToolTipText("set 0 values to all channels");
        this.jButton_DeviceSetNull.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DMXDeviceFunctionPanel.this.jButton_DeviceSetNullMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jButton_DeviceSetNull, gridBagConstraints);
        this.jButton_Presets_Color.setHorizontalAlignment(0);
        this.jButton_Presets_Color.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Color_RGB_CMY.png")));
        this.jButton_Presets_Color.setToolTipText("call Prest Color");
        this.jButton_Presets_Color.setHorizontalTextPosition(0);
        this.jButton_Presets_Color.setIconTextGap(0);
        this.jButton_Presets_Color.setMaximumSize(new Dimension(32, 32));
        this.jButton_Presets_Color.setMinimumSize(new Dimension(32, 32));
        this.jButton_Presets_Color.setPreferredSize(new Dimension(32, 32));
        this.jButton_Presets_Color.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DMXDeviceFunctionPanel.this.jButton_Presets_ColorMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jButton_Presets_Color, gridBagConstraints);
        this.jButton_Presets_Position.setHorizontalAlignment(0);
        this.jButton_Presets_Position.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/GridAdjuster_16.png")));
        this.jButton_Presets_Position.setToolTipText("call Prest Position");
        this.jButton_Presets_Position.setHorizontalTextPosition(0);
        this.jButton_Presets_Position.setIconTextGap(0);
        this.jButton_Presets_Position.setMaximumSize(new Dimension(32, 32));
        this.jButton_Presets_Position.setMinimumSize(new Dimension(32, 32));
        this.jButton_Presets_Position.setPreferredSize(new Dimension(32, 32));
        this.jButton_Presets_Position.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DMXDeviceFunctionPanel.this.jButton_Presets_PositionMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jButton_Presets_Position, gridBagConstraints);
        this.jButton_Presets_Dimmer.setHorizontalAlignment(0);
        this.jButton_Presets_Dimmer.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Slider_Small.png")));
        this.jButton_Presets_Dimmer.setToolTipText("call Prest Dimmer");
        this.jButton_Presets_Dimmer.setHorizontalTextPosition(0);
        this.jButton_Presets_Dimmer.setIconTextGap(0);
        this.jButton_Presets_Dimmer.setMaximumSize(new Dimension(32, 32));
        this.jButton_Presets_Dimmer.setMinimumSize(new Dimension(32, 32));
        this.jButton_Presets_Dimmer.setPreferredSize(new Dimension(32, 32));
        this.jButton_Presets_Dimmer.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DMXDeviceFunctionPanel.this.jButton_Presets_DimmerMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jButton_Presets_Dimmer, gridBagConstraints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButton_DeviceSetDefaultsMouseClicked(MouseEvent evt) {
        ArrayList<DMXDevice> o_DMXDevices;
        if (evt.getButton() != 1) {
            return;
        }
        if (!this.jButton_DeviceSetDefaults.isEnabled()) {
            return;
        }
        Object object = this.m_SyncDMXDevices;
        synchronized (object) {
            o_DMXDevices = new ArrayList<DMXDevice>(this.m_DMXDevices.size());
            o_DMXDevices.addAll(this.m_DMXDevices);
        }
        for (int intDevice = 0; intDevice < o_DMXDevices.size(); ++intDevice) {
            DMXDevice o_DMXDevice = (DMXDevice)o_DMXDevices.get(intDevice);
            if (o_DMXDevice == null) continue;
            o_DMXDevice.callControlFunction(DMXDeviceType.s_ControlFunctionType_Default);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButton_DeviceSetNullMouseClicked(MouseEvent evt) {
        ArrayList<DMXDevice> o_DMXDevices;
        if (evt.getButton() != 1) {
            return;
        }
        if (!this.jButton_DeviceSetNull.isEnabled()) {
            return;
        }
        Object object = this.m_SyncDMXDevices;
        synchronized (object) {
            o_DMXDevices = new ArrayList<DMXDevice>(this.m_DMXDevices.size());
            o_DMXDevices.addAll(this.m_DMXDevices);
        }
        for (int intDevice = 0; intDevice < o_DMXDevices.size(); ++intDevice) {
            DMXDevice o_DMXDevice = (DMXDevice)o_DMXDevices.get(intDevice);
            if (o_DMXDevice == null) continue;
            o_DMXDevice.callControlFunction(DMXDeviceType.s_ControlFunctionType_Null);
        }
    }

    private void jButton_Presets_ColorMouseClicked(MouseEvent evt) {
        if (evt.getButton() != 1) {
            return;
        }
        if (!this.jButton_Presets_Color.isEnabled()) {
            return;
        }
        DMXValueSelection.show(DMXPresets.s_Presets_Color, this.m_DMXDevices, evt.getXOnScreen(), evt.getYOnScreen());
    }

    private void jButton_Presets_PositionMouseClicked(MouseEvent evt) {
        if (evt.getButton() != 1) {
            return;
        }
        if (!this.jButton_Presets_Position.isEnabled()) {
            return;
        }
        DMXValueSelection.show(DMXPresets.s_Presets_Position, this.m_DMXDevices, evt.getXOnScreen(), evt.getYOnScreen());
    }

    private void jButton_Presets_DimmerMouseClicked(MouseEvent evt) {
        if (evt.getButton() != 1) {
            return;
        }
        if (!this.jButton_Presets_Dimmer.isEnabled()) {
            return;
        }
        DMXValueSelection.show(DMXPresets.s_Presets_Dimmer, this.m_DMXDevices, evt.getXOnScreen(), evt.getYOnScreen());
    }

    private void initComponentsFurther() {
        this.setOpaque(false);
        this.m_MouseAdapter = new MouseAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getSource() instanceof FunctionTypeLabel) {
                    ArrayList o_DMXDevices;
                    if (e.getButton() != 1) {
                        return;
                    }
                    FunctionTypeLabel o_FunctionTypeLabel = (FunctionTypeLabel)e.getSource();
                    if (o_FunctionTypeLabel == null || !o_FunctionTypeLabel.isEnabled()) {
                        return;
                    }
                    ControlFunctionModel.ControlFunctionType o_ControlFunctionType = o_FunctionTypeLabel.getControlFunctionType();
                    Object object = DMXDeviceFunctionPanel.this.m_SyncDMXDevices;
                    synchronized (object) {
                        o_DMXDevices = new ArrayList(DMXDeviceFunctionPanel.this.m_DMXDevices.size());
                        o_DMXDevices.addAll(DMXDeviceFunctionPanel.this.m_DMXDevices);
                    }
                    for (int intDMXDevice = 0; intDMXDevice < o_DMXDevices.size(); ++intDMXDevice) {
                        DMXDevice o_DMXDevice = (DMXDevice)o_DMXDevices.get(intDMXDevice);
                        if (o_DMXDevice == null) continue;
                        o_DMXDevice.callControlFunction(o_ControlFunctionType);
                    }
                }
            }
        };
        TableAndListModel.ListModel o_LiveShowListModel = ControlFunctionModel.ControlFunctionType.getControlFunctionTypeList();
        for (int intIndex = 0; intIndex < o_LiveShowListModel.size(); ++intIndex) {
            ControlFunctionModel.ControlFunctionType o_ControlFunctionType = (ControlFunctionModel.ControlFunctionType)o_LiveShowListModel.get(intIndex);
            this.addControlFunctionType(intIndex, o_ControlFunctionType);
        }
        ControlFunctionModel.ControlFunctionType.getControlFunctionTypeList().addListDataListener(this);
        this.refreshLabels();
        this.jButton_Presets_Dimmer.setEnabled(false);
        this.jButton_Presets_Color.setEnabled(false);
        this.jButton_Presets_Position.setEnabled(false);
        this.jButton_Presets_Dimmer.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_Presets_Color.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_Presets_Position.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_DeviceSetDefaults.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_DeviceSetNull.setComponentPopupMenu(PopUpToolTip.getSelfReference());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshLabels() {
        GridBagLayout o_GridBagLayout = (GridBagLayout)super.getLayout();
        Object object = this.m_SyncFunctionTypeLabel;
        synchronized (object) {
            for (int intLabel = 0; intLabel < this.m_FunctionTypeLabels.size(); ++intLabel) {
                FunctionTypeLabel o_FunctionTypeLabel = this.m_FunctionTypeLabels.get(intLabel);
                if (o_FunctionTypeLabel == null) continue;
                GridBagConstraints o_GridBagConstraints = o_FunctionTypeLabel.getGridBagConstraints();
                if (this.m_Orientation == 0) {
                    o_GridBagConstraints.gridy = 0;
                    o_GridBagConstraints.gridx = intLabel + BUTTON_OFFSET;
                } else {
                    o_GridBagConstraints.gridx = 0;
                    o_GridBagConstraints.gridy = intLabel + BUTTON_OFFSET;
                }
                o_FunctionTypeLabel.setPreferredSize(o_FunctionTypeLabel.getLabelDimension());
                o_GridBagLayout.setConstraints(o_FunctionTypeLabel, o_GridBagConstraints);
            }
        }
        super.revalidate();
    }

    public void setOrientation(int p_Orientation) {
        if (p_Orientation == 0) {
            this.m_Orientation = 0;
        } else if (p_Orientation == 1) {
            this.m_Orientation = 1;
        }
        this.refreshLabels();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addControlFunctionType(int p_Index, ControlFunctionModel.ControlFunctionType p_ControlFunctionType) {
        if (p_ControlFunctionType == null) {
            return;
        }
        FunctionTypeLabel o_FunctionTypeLabel = new FunctionTypeLabel(p_ControlFunctionType);
        Object object = this.m_SyncFunctionTypeLabel;
        synchronized (object) {
            this.m_FunctionTypeLabels.add(p_Index, o_FunctionTypeLabel);
            this.m_HashMapFunctionTypeLabels.put(p_ControlFunctionType, o_FunctionTypeLabel);
            o_FunctionTypeLabel.setEnabled(false);
        }
        o_FunctionTypeLabel.setVisible(true);
        GridBagConstraints o_GridBagConstraints = o_FunctionTypeLabel.getGridBagConstraints();
        o_GridBagConstraints.gridx = BUTTON_OFFSET + p_Index;
        o_GridBagConstraints.gridy = 0;
        this.add((Component)o_FunctionTypeLabel, o_GridBagConstraints);
        o_FunctionTypeLabel.addMouseListener(this.m_MouseAdapter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeControlFunctionType(ControlFunctionModel.ControlFunctionType p_ControlFunctionType) {
        if (p_ControlFunctionType == null) {
            return;
        }
        FunctionTypeLabel o_FunctionTypeLabel = this.m_HashMapFunctionTypeLabels.get(p_ControlFunctionType);
        o_FunctionTypeLabel.removeMouseListener(this.m_MouseAdapter);
        o_FunctionTypeLabel.setVisible(false);
        this.remove(o_FunctionTypeLabel);
        o_FunctionTypeLabel.close();
        Object object = this.m_SyncFunctionTypeLabel;
        synchronized (object) {
            this.m_FunctionTypeLabels.remove(o_FunctionTypeLabel);
            this.m_HashMapFunctionTypeLabels.remove(p_ControlFunctionType);
        }
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
        if (e.getSource() instanceof TableAndListModel.ListModel) {
            TableAndListModel.ListModel o_LiveShowListModel;
            try {
                o_LiveShowListModel = (TableAndListModel.ListModel)e.getSource();
            }
            catch (Exception error) {
                return;
            }
            for (int intIndex = e.getIndex0(); intIndex <= e.getIndex1(); ++intIndex) {
                ControlFunctionModel.ControlFunctionType o_ControlFunctionType = (ControlFunctionModel.ControlFunctionType)o_LiveShowListModel.get(intIndex);
                this.addControlFunctionType(intIndex, o_ControlFunctionType);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void intervalRemoved(ListDataEvent e) {
        if (e.getSource() instanceof TableAndListModel.ListModel) {
            ArrayList<FunctionTypeLabel> o_FunctionTypeLabels;
            Object object = this.m_SyncFunctionTypeLabel;
            synchronized (object) {
                o_FunctionTypeLabels = new ArrayList<FunctionTypeLabel>(this.m_FunctionTypeLabels.size());
                for (int intIndex = e.getIndex1(); intIndex >= e.getIndex0(); --intIndex) {
                    if (intIndex < 0 || intIndex >= this.m_FunctionTypeLabels.size()) continue;
                    o_FunctionTypeLabels.add(this.m_FunctionTypeLabels.get(intIndex));
                }
            }
            for (int intIndex = 0; intIndex < o_FunctionTypeLabels.size(); ++intIndex) {
                FunctionTypeLabel o_FunctionTypeLabel = (FunctionTypeLabel)o_FunctionTypeLabels.get(intIndex);
                if (o_FunctionTypeLabel == null) continue;
                this.removeControlFunctionType(o_FunctionTypeLabel.getControlFunctionType());
            }
            o_FunctionTypeLabels.clear();
        }
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        if (e.getSource() instanceof TableAndListModel.ListModel) {
            TableAndListModel.ListModel o_LiveShowListModel;
            try {
                o_LiveShowListModel = (TableAndListModel.ListModel)e.getSource();
            }
            catch (Exception error) {
                return;
            }
            for (int intIndex = e.getIndex0(); intIndex <= e.getIndex1(); ++intIndex) {
                FunctionTypeLabel o_FunctionTypeLabel;
                ControlFunctionModel.ControlFunctionType o_ControlFunctionType = (ControlFunctionModel.ControlFunctionType)o_LiveShowListModel.get(intIndex);
                if (intIndex < 0 || intIndex >= this.m_FunctionTypeLabels.size() || (o_FunctionTypeLabel = this.m_FunctionTypeLabels.get(intIndex)) == null) continue;
                o_FunctionTypeLabel.setControlFunctionType(o_ControlFunctionType);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDMXDevice(DMXDevice p_DMXDevice) {
        if (p_DMXDevice == null) {
            return;
        }
        ArrayList<DMXDevice> arrayList = this.m_DMXDevices;
        synchronized (arrayList) {
            if (this.m_DMXDevices.contains(p_DMXDevice)) {
                return;
            }
            this.m_DMXDevices.add(p_DMXDevice);
        }
        this.refreshDMXDevices(p_DMXDevice);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDMXDevice(DMXDevice p_DMXDevice) {
        if (p_DMXDevice == null) {
            return;
        }
        Object object = this.m_SyncDMXDevices;
        synchronized (object) {
            this.m_DMXDevices.remove(p_DMXDevice);
        }
        this.refreshDMXDevices(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeDMXDevice(DMXDevice p_DMXDevice) {
        if (p_DMXDevice == null) {
            return;
        }
        Object object = this.m_SyncDMXDevices;
        synchronized (object) {
            if (!this.m_DMXDevices.contains(p_DMXDevice)) {
                return;
            }
        }
        this.refreshDMXDevices(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshDMXDevices(DMXDevice p_DMXDevice) {
        FunctionTypeLabel o_FunctionTypeLabel;
        ArrayList<DMXDevice> o_DMXDevices;
        Object object = this.m_SyncDMXDevices;
        synchronized (object) {
            o_DMXDevices = new ArrayList<DMXDevice>(this.m_DMXDevices.size());
            o_DMXDevices.addAll(this.m_DMXDevices);
        }
        boolean boolAffects_Dimmer = false;
        boolean boolAffects_Color = false;
        boolean boolAffects_Position = false;
        this.jButton_Presets_Dimmer.setEnabled(false);
        this.jButton_Presets_Color.setEnabled(false);
        this.jButton_Presets_Position.setEnabled(false);
        object = this.m_SyncFunctionTypeLabel;
        synchronized (object) {
            for (int intLabel = 0; intLabel < this.m_FunctionTypeLabels.size(); ++intLabel) {
                o_FunctionTypeLabel = this.m_FunctionTypeLabels.get(intLabel);
                o_FunctionTypeLabel.setEnabled(false);
            }
        }
        for (int intDMXDevice = 0; intDMXDevice < o_DMXDevices.size(); ++intDMXDevice) {
            DMXDevice o_DMXDevice = (DMXDevice)o_DMXDevices.get(intDMXDevice);
            if (o_DMXDevice == null) continue;
            if (!boolAffects_Dimmer && DMXPresets.s_Presets_Dimmer.affectsDMXDevice(o_DMXDevice)) {
                this.jButton_Presets_Dimmer.setEnabled(true);
                boolAffects_Dimmer = true;
            }
            if (!boolAffects_Color && DMXPresets.s_Presets_Color.affectsDMXDevice(o_DMXDevice)) {
                this.jButton_Presets_Color.setEnabled(true);
                boolAffects_Color = true;
            }
            if (!boolAffects_Position && DMXPresets.s_Presets_Position.affectsDMXDevice(o_DMXDevice)) {
                this.jButton_Presets_Position.setEnabled(true);
                boolAffects_Position = true;
            }
            boolean boolHasFunction = true;
            Object object2 = this.m_SyncFunctionTypeLabel;
            synchronized (object2) {
                for (int intLabel = 0; intLabel < this.m_FunctionTypeLabels.size(); ++intLabel) {
                    o_FunctionTypeLabel = this.m_FunctionTypeLabels.get(intLabel);
                    if (o_FunctionTypeLabel.isEnabled()) continue;
                    DMXDeviceType o_DMXDeviceType = o_DMXDevice.getDMXDeviceType();
                    if (o_DMXDeviceType != null && o_DMXDeviceType.containsFunction(o_FunctionTypeLabel.getControlFunctionType())) {
                        o_FunctionTypeLabel.setEnabled(true);
                        continue;
                    }
                    boolHasFunction = false;
                }
            }
            if (boolAffects_Dimmer && boolAffects_Color && boolAffects_Position && boolHasFunction) break;
        }
    }

    public static class FunctionTypeLabel
    extends JLabel {
        private ControlFunctionModel.ControlFunctionType m_ControlFunctionType;
        private GridBagConstraints m_GridBagConstraints;
        private Dimension m_LabelDimension;
        private int m_LabelInsetSize;

        public FunctionTypeLabel(ControlFunctionModel.ControlFunctionType p_ControlFunctionType) {
            this.initMembers();
            this.m_ControlFunctionType = p_ControlFunctionType;
            this.initComponents();
            this.refresh();
        }

        private void initMembers() {
        }

        private void initComponents() {
            this.m_LabelDimension = new Dimension(32, 32);
            this.m_LabelInsetSize = 1;
            this.m_GridBagConstraints = new GridBagConstraints();
            this.m_GridBagConstraints.insets = new Insets(this.m_LabelInsetSize, this.m_LabelInsetSize, this.m_LabelInsetSize, this.m_LabelInsetSize);
            this.setEnabled(false);
            this.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        }

        public void close() {
            this.m_ControlFunctionType = null;
        }

        private void refresh() {
            this.setMinimumSize(this.m_LabelDimension);
            this.setMaximumSize(this.m_LabelDimension);
            this.setPreferredSize(this.m_LabelDimension);
            if (this.m_ControlFunctionType == null) {
                this.setToolTipText(null);
                this.setIcon(null);
            } else {
                this.setText("");
                this.setToolTipText(this.m_ControlFunctionType.getFunctionName());
                this.setIcon(this.m_ControlFunctionType.getLabelIconBig());
            }
        }

        public Dimension getLabelDimension() {
            return this.m_LabelDimension;
        }

        public void setControlFunctionType(ControlFunctionModel.ControlFunctionType p_ControlFunctionType) {
            this.m_ControlFunctionType = p_ControlFunctionType;
            this.refresh();
        }

        public ControlFunctionModel.ControlFunctionType getControlFunctionType() {
            return this.m_ControlFunctionType;
        }

        public GridBagConstraints getGridBagConstraints() {
            return this.m_GridBagConstraints;
        }
    }
}

