/*
 * Decompiled with CFR 0.152.
 */
package DMXDevicePackage;

import DMX512.DMXChannel;
import DMX512.DMXUniverse;
import DMX512.DMXUniverseInputPatch;
import DMXDevicePackage.DMXDeviceFilter;
import DMXDevicePackage.DMXDeviceType;
import DMXDevicePackage.DMXPresets;
import DMXGraphics.LiveShowDMXStageView;
import DMXHardwarePackage.DMXHardwareInterface;
import DMXHardwarePackage.DMXPowerSource;
import DMXMixer.DMXControlComponent;
import DMXMixer.DMXControlComponentPool;
import DMXMixer.DMXControlDescription;
import DMXMixer.DMXControl_Dimmer;
import DMXMixer.DMXControl_Dimmer_DeviceSettings;
import DMXMixer.DMXControl_FreeDimmer;
import DMXScenePackage.DMXScene;
import DMXVirtualPackage.DMXFadeDescription;
import DMXVirtualPackage.LiveShowDMXSceneBridge;
import DMXVirtualPackage.LiveShowDMXVIP;
import GUID.LiveGUID;
import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LanguageTools.LiveLanguagePackage.LiveLanguageString;
import LiveShowControlModels.ControlFunctionModel;
import LiveShowControlObjects.ControlObject;
import LiveShowControls.CorrectionModel;
import LiveShowObjectPackage.SinglePropertyChangeSupport;
import LiveShowVirtualPackage.LiveShowSceneBridge;
import StartPackage.LiveShowDMXSystem;
import SwingModelPackage.TableAndListModel;
import SwingTextPackage.DocumentFilter_Integer;
import SynchronizationPackage.EventQueueHandler;
import Text.NameExtension;
import ToolsGraphics.JCheckBox_MultiSelection;
import ToolsGraphics.JLabelBackground;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.beans.IndexedPropertyChangeEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DMXDevice
implements Externalizable,
PropertyChangeListener,
DMXControlComponentPool,
DMXDeviceFilter.FilterInterface {
    public static final int SOFTWAREVERSION = 2;
    @LiveLanguageString
    public static String CHANNEL = "Channel";
    @LiveLanguageString
    public static String INVALIDADDRESS = "DMX-Address-Conflict";
    @LiveLanguageString
    public static String DEFAULT_DMXDEVICENAME = "Device";
    public static boolean s_LanguageLoaded = false;
    public static final String PROP_DMXDEVICE_DEVICENAME = "dmxdeviceDeviceName";
    public static final String PROP_DMXDEVICE_DEVICEACTIVE = "dmxdeviceDeviceActive";
    public static final String PROP_DMXDEVICE_DEVICEMUTE = "dmxdeviceDeviceMute";
    public static final String PROP_DMXDEVICE_DEVICESOLO = "dmxdeviceDeviceSolo";
    public static final String PROP_DMXDEVICE_DEVICESCALE = "dmxdeviceDeviceScale";
    public static final String PROP_INDEXED_DMXDEVICE_UNIVERSE = "dmxdeviceUniverse";
    public static final String PROP_INDEXED_DMXDEVICE_UNIVERSENAME = "dmxdeviceUniverseName";
    public static final String PROP_INDEXED_DMXDEVICE_STARTADDRESS = "dmxdeviceStartAddress";
    public static final String PROP_DMXDEVICE_VALIDADDRESS = "dmxdeviceValidAddress";
    public static final String PROP_INDEXED_DMXDEVICE_DMXPOWERSOURCE = "dmxdevicePowerSource";
    public static final String PROP_DMXDEVICE_DMXDEVICETYPE = "dmxdeviceDMXDeviceType";
    public static final String PROP_DMXDEVICE_TYPEMANUFACTUREER = "dmxdeviceTypeManufactureer";
    public static final String PROP_DMXDEVICE_TYPENAME = "dmxdeviceTypeName";
    public static final String PROP_DMXDEVICE_TYPEDESCRIPTION = "dmxdeviceTypeDescription";
    public static final String PROP_DMXDEVICE_TYPEIMAGE = "dmxdeviceTypeImage";
    public static final String PROP_DMXDEVICE_INDEXED_DEVICESECTOR = "dmxdeviceDeviceSectorType";
    public static final String PROP_DMXDEVICE_INDEXED_DEVICECHANNELTYPE = "dmxdeviceDeviceChannelType";
    public static final String PROP_DMXDEVICE_DEVICECONTROLLINK = "dmxdeviceDeviceControlLink";
    public static final String PROP_DMXDEVICE_STAGEVIEWPOSITION = "dmxdeviceStageViewPosition";
    public static final String PROP_DMXDEVICE_DIMMERVALUE = "dmxdeviceDimmerValue";
    public static final String PROP_DMXDEVICE_ADJUSTEDSCENEBRIDGE = "dmxdeviceAdjustedSceneBridge";
    public static final String PROP_DMXDEVICE_CLOSED = "dmxdeviceClosed";
    public static Icon s_Icon = new ImageIcon(DMXDevice.class.getResource("/IconsPackage/DMX.png"));
    protected static TreeModel_Device_Channels s_TreeModel_Device_Channels = new TreeModel_Device_Channels(false);
    protected static TreeCellRenderer_Device_Channels s_CellRenderer_Device_Channels = new TreeCellRenderer_Device_Channels();
    protected static DMXDeviceTableModel s_DMXDeviceTableModel = new DMXDeviceTableModel();
    protected static TreeModel_DMXControlType_Devices s_TreeModel_DMXControlType_Devices = new TreeModel_DMXControlType_Devices();
    protected static TreeModel_Device_DMXControlTypes s_TreeModel_Devices_DMXControlTypes = new TreeModel_Device_DMXControlTypes();
    protected static TreeCellRenderer_Device_ControlTypes s_CellRenderer_DMXControlType_Devices = new TreeCellRenderer_Device_ControlTypes();
    protected static DMXDeviceListModel s_DMXDeviceComboBoxModel = new DMXDeviceListModel();
    protected static DMXDeviceListRenderer s_DMXDeviceListRenderer = new DMXDeviceListRenderer();
    protected static SinglePropertyChangeSupport s_PropertyChangeSupportDMXDeviceList = new SinglePropertyChangeSupport(DMXDevice.class);
    protected static boolean s_SoloOn = false;
    private boolean m_ValidAddress;
    private boolean m_Active;
    private boolean m_Mute;
    private boolean m_Solo;
    private int m_Scale;
    private boolean m_HasDimmerLinked;
    private boolean m_HasDimmerSubstituteLinked;
    private boolean m_Dimmable;
    private boolean m_HasMovableControls;
    private boolean m_EditMode;
    private DMXControlComponent m_DMXControlDimmer;
    private String m_DMXControlDimmer_ControlTypeID;
    private ArrayList<DMXControlComponent> m_DMXControlDimmer_Substitutes;
    private ArrayList<String> m_DMXControlDimmer_Substitutes_ControlTypeIDs;
    private double m_DimmerValue;
    private double m_DimmerValue_EditMode;
    private boolean m_IsOn;
    private boolean m_IsOn_EditMode;
    protected String m_ID;
    protected String m_Name;
    protected String m_Manufactureer;
    protected String m_DeviceTypename;
    protected String m_RDMDeviceUID;
    protected StringBuilder m_StringBuilderDeviceToolTip;
    private final Object m_SyncStringBuilder = new Object();
    protected boolean m_IsImported;
    protected DMXDeviceType m_DMXDeviceType;
    protected ArrayList<InternalSector> m_InternalSectors;
    private DMXControlComponent.DMXControlComponentList m_DMXControlComponents;
    private ArrayList<DMXControlComponent.DeviceSettingsPanel> m_DMXControlDeviceSettingsPanels;
    private boolean m_UsedInTimeline;
    private LiveShowSceneBridge m_SceneBridge_Adjusted;
    private LiveShowSceneBridge m_SceneBridge_AdjustedOld;
    private LiveShowSceneBridge m_SceneBridge_AdjustedEditMode;
    private LiveShowSceneBridge m_SceneBridge_AdjustedEditModeOld;
    private LiveShowSceneBridge m_SceneBridge_Actual;
    private Point m_StageViewPosition;
    private Runnable m_RunnableSceneBrideAdjusted;
    private Runnable m_RunnableSceneBrideAdjustedEditMode;
    private Runnable m_RunnableDimmerValue;
    protected SinglePropertyChangeSupport m_PropertyChangeSupport;
    protected DMXScene.DMXSceneDeviceValues m_DefaultDMXSceneDeviceValues;
    private boolean m_Closing;
    private final Object m_SyncDevice = new Object();
    private ArrayList<ControlObject> m_ControlFunctionChangedObjects = new ArrayList();

    public static void addPropertyChangeListenerDMXDeviceList(PropertyChangeListener p_PropertyChangeListener) {
        if (p_PropertyChangeListener == null) {
            return;
        }
        s_PropertyChangeSupportDMXDeviceList.addPropertyChangeListener(p_PropertyChangeListener);
    }

    public static void removePropertyChangeListenerDMXDeviceList(PropertyChangeListener p_PropertyChangeListener) {
        if (p_PropertyChangeListener == null) {
            return;
        }
        s_PropertyChangeSupportDMXDeviceList.removePropertyChangeListener(p_PropertyChangeListener);
    }

    public static void firePropertyChangeDMXDeviceList() {
        s_PropertyChangeSupportDMXDeviceList.firePropertyChange("DMXDeviceList", null, "DMXDeviceList");
    }

    public DMXDevice() {
        this("");
    }

    public DMXDevice(String p_Name) {
        this.initMembers();
        this.m_Name = this.createName(p_Name);
    }

    private void initMembers() {
        this.m_ID = LiveGUID.getUID();
        this.m_IsImported = false;
        this.m_RunnableSceneBrideAdjusted = null;
        this.m_RunnableSceneBrideAdjustedEditMode = null;
        this.m_RunnableDimmerValue = null;
        LiveLanguage.addLanguageListener((Object)this, null);
        this.m_StringBuilderDeviceToolTip = new StringBuilder();
        this.m_Manufactureer = "";
        this.m_DeviceTypename = "";
        this.m_RDMDeviceUID = "";
        this.m_DMXControlDimmer_Substitutes = new ArrayList();
        this.m_DMXControlDimmer_Substitutes_ControlTypeIDs = new ArrayList();
        this.m_PropertyChangeSupport = new SinglePropertyChangeSupport(this);
        this.m_Active = true;
        this.m_Solo = false;
        this.m_Mute = false;
        this.m_Scale = 100;
        this.m_HasDimmerLinked = false;
        this.m_HasDimmerSubstituteLinked = false;
        this.m_HasMovableControls = false;
        this.m_StageViewPosition = new Point(0, 0);
        this.m_DefaultDMXSceneDeviceValues = new DMXScene.DMXSceneDeviceValues(null);
        this.m_Closing = false;
        this.m_DMXControlComponents = new DMXControlComponent.DMXControlComponentList();
        this.m_DMXControlDeviceSettingsPanels = new ArrayList();
        this.m_ValidAddress = false;
        this.m_InternalSectors = new ArrayList();
        this.m_UsedInTimeline = false;
        this.m_SceneBridge_Adjusted = null;
        this.m_SceneBridge_AdjustedOld = null;
        this.m_IsOn = false;
        this.m_DimmerValue = 0.0;
        this.m_SceneBridge_AdjustedEditMode = null;
        this.m_SceneBridge_AdjustedEditModeOld = null;
        this.m_IsOn_EditMode = false;
        this.m_DimmerValue_EditMode = 0.0;
        this.m_EditMode = false;
        DMXDeviceFilter.createDMXDeviceFilter(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(2);
        out.writeUTF(this.m_ID);
        out.writeUTF(this.m_Name);
        out.writeBoolean(this.m_Active);
        String stringDeviceTypeID = "";
        if (this.m_DMXDeviceType != null) {
            stringDeviceTypeID = this.m_DMXDeviceType.getID();
        }
        out.writeUTF(this.m_RDMDeviceUID);
        out.writeUTF(this.m_Manufactureer);
        out.writeUTF(this.m_DeviceTypename);
        out.writeUTF(stringDeviceTypeID);
        out.writeInt(this.m_DMXControlComponents.size());
        for (int intDMXControl = 0; intDMXControl < this.m_DMXControlComponents.size(); ++intDMXControl) {
            DMXControlComponent o_DMXControlComponent = (DMXControlComponent)this.m_DMXControlComponents.get(intDMXControl);
            DMXControlComponent.DeviceSettingsPanel o_DeviceSettingsPanel = o_DMXControlComponent.getDMXDeviceSettingsPanel(this, true);
            if (o_DeviceSettingsPanel == null) {
                out.writeUTF("");
                continue;
            }
            out.writeUTF(o_DMXControlComponent.getDMXControlType().getID());
            o_DeviceSettingsPanel.writeExternal(out);
        }
        Object object = this.m_SyncDevice;
        synchronized (object) {
            int intSectorCount = this.m_InternalSectors.size();
            out.writeInt(intSectorCount);
            for (int intSector = 0; intSector < intSectorCount; ++intSector) {
                InternalSector o_InternalSector = this.m_InternalSectors.get(intSector);
                o_InternalSector.writeExternal(out);
            }
        }
        out.writeInt(this.m_StageViewPosition.x);
        out.writeInt(this.m_StageViewPosition.y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        String stringDeviceTypeID;
        DMXDeviceType o_DMXDeviceType;
        int intSoftwareVersion = in.readInt();
        this.m_ID = in.readUTF();
        this.m_Name = in.readUTF();
        boolean boolActive = in.readBoolean();
        if (intSoftwareVersion > 1) {
            this.m_RDMDeviceUID = in.readUTF();
            this.m_Manufactureer = in.readUTF();
            this.m_DeviceTypename = in.readUTF();
        }
        if ((o_DMXDeviceType = DMXDeviceType.getDMXDeviceTypeByID(stringDeviceTypeID = in.readUTF())) != null) {
            this.m_Manufactureer = o_DMXDeviceType.getManufactureerName();
            this.m_DeviceTypename = o_DMXDeviceType.getTypeName();
        }
        this.setDMXDeviceType(o_DMXDeviceType);
        int intDMXControlCount = in.readInt();
        for (int intDMXControl = 0; intDMXControl < intDMXControlCount; ++intDMXControl) {
            String stringControlTypeID = in.readUTF();
            if (stringControlTypeID.length() <= 0) continue;
            DMXControlComponent o_DMXControlComponent = this.getDMXControlComponentByID(stringControlTypeID);
            if (o_DMXControlComponent != null && o_DMXDeviceType != null) {
                DMXControlComponent.DeviceSettingsPanel o_DeviceSettingsPanel = o_DMXControlComponent.getDMXDeviceSettingsPanel(this, true);
                o_DeviceSettingsPanel.readExternal(in);
                continue;
            }
            int intByteLength = in.readInt();
            in.skip(intByteLength);
        }
        int intSectorCount = in.readInt();
        for (int intSector = 0; intSector < intSectorCount; ++intSector) {
            InternalSector o_InternalSector = this.getInternalSector(intSector);
            if (o_InternalSector == null) {
                o_InternalSector = new InternalSector(this, intSector);
                Object object = this.m_SyncDevice;
                synchronized (object) {
                    this.m_InternalSectors.add(o_InternalSector);
                }
            }
            o_InternalSector.readExternal(in);
        }
        this.setStageViewPosition(in.readInt(), in.readInt());
        if (o_DMXDeviceType != null && DMXDevice.getDMXDevice(this.m_ID) == null) {
            this.setActive(boolActive);
        } else {
            this.close();
        }
    }

    public long getDiskSpaceEstimated() {
        long longBytesCount = 0L;
        longBytesCount += 4L;
        longBytesCount += (long)(this.m_ID.length() * 2);
        longBytesCount += (long)(this.m_Name.length() * 2);
        ++longBytesCount;
        longBytesCount += (long)(this.m_RDMDeviceUID.length() * 2);
        longBytesCount += (long)(this.m_Manufactureer.length() * 2);
        longBytesCount += (long)(this.m_DeviceTypename.length() * 2);
        longBytesCount = this.m_DMXDeviceType != null ? (longBytesCount += (long)(this.m_DMXDeviceType.getID().length() * 2)) : (longBytesCount += 2L);
        longBytesCount += 4L;
        for (int intDMXControl = 0; intDMXControl < this.m_DMXControlComponents.size(); ++intDMXControl) {
            DMXControlComponent o_DMXControlComponent = (DMXControlComponent)this.m_DMXControlComponents.get(intDMXControl);
            if (o_DMXControlComponent == null) continue;
            DMXControlComponent.DeviceSettingsPanel o_DeviceSettingsPanel = o_DMXControlComponent.getDMXDeviceSettingsPanel(this, true);
            if (o_DeviceSettingsPanel == null) {
                longBytesCount += 2L;
                continue;
            }
            longBytesCount += (long)(o_DMXControlComponent.getDMXControlType().getID().length() * 2);
            longBytesCount += o_DeviceSettingsPanel.getDiskSpaceEstimated();
        }
        int intSectorCount = this.m_InternalSectors.size();
        longBytesCount += 4L;
        for (int intSector = 0; intSector < intSectorCount; ++intSector) {
            InternalSector o_InternalSector = this.getInternalSector(intSector);
            if (o_InternalSector == null) continue;
            longBytesCount += o_InternalSector.getDiskSpaceEstimated();
        }
        longBytesCount += 4L;
        return longBytesCount += 4L;
    }

    public void setImported(boolean p_IsImported) {
        this.m_IsImported = p_IsImported;
    }

    public boolean getImported() {
        return this.m_IsImported;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        DMXDeviceFilter.removeDMXDeviceFilter(this);
        LiveLanguage.removeLanguageListener((Object)this);
        if (this.m_DMXDeviceType == null) {
            return;
        }
        if (this.m_Closing) {
            return;
        }
        this.m_Closing = true;
        if (this.m_DMXDeviceType != null) {
            this.m_DMXDeviceType.removePropertyChangeListener(this);
        }
        this.unlinkLabelListConditions();
        DMXDeviceType o_OldDMXDeviceType = this.m_DMXDeviceType;
        DMXDevice.removeDMXDevice(this);
        this.removeDMXDeviceFilter_DMXDeviceType(o_OldDMXDeviceType);
        if (LiveShowDMXSystem.getLiveShowDMXStageView() != null) {
            LiveShowDMXSystem.getLiveShowDMXStageView().removeDMXDevice(this);
        }
        if (this.m_DMXControlComponents != null) {
            for (int intControl = this.m_DMXControlComponents.size() - 1; intControl >= 0; --intControl) {
                DMXControlComponent o_DMXControlComponent = (DMXControlComponent)this.m_DMXControlComponents.get(intControl);
                if (o_DMXControlComponent == null) continue;
                DMXControlComponent.DeviceSettingsPanel o_DeviceSettingsPanel = o_DMXControlComponent.getDMXDeviceSettingsPanel(this, false);
                if (o_DeviceSettingsPanel != null) {
                    this.m_DMXControlDeviceSettingsPanels.remove(o_DeviceSettingsPanel);
                }
                this.removeDMXControlComponent(o_DMXControlComponent);
                o_DMXControlComponent.close();
            }
            this.m_DMXControlComponents.close();
        }
        if (this.m_InternalSectors != null) {
            for (int intSector = this.m_InternalSectors.size() - 1; intSector >= 0; --intSector) {
                InternalSector o_InternalSector = this.getInternalSector(intSector);
                if (o_InternalSector == null) continue;
                for (int intChannel = o_InternalSector.getInternalChannelCount() - 1; intChannel >= 0; --intChannel) {
                    InternalChannel o_InternalChannel = o_InternalSector.getInternalChannel(intChannel);
                    if (o_InternalChannel != null) {
                        o_InternalChannel.close(false);
                    }
                    o_InternalSector.removeInternalChannel(o_InternalChannel);
                }
                Object object = this.m_SyncDevice;
                synchronized (object) {
                    this.m_InternalSectors.remove(o_InternalSector);
                }
                DMXUniverse o_DMXUniverse = o_InternalSector.getDMXUniverse();
                if (o_DMXUniverse != null) {
                    o_DMXUniverse.removeDMXDeviceInternalSector(o_InternalSector);
                }
                o_InternalSector.close();
            }
        }
        this.m_DMXDeviceType = null;
        Object object = this.m_SyncDevice;
        synchronized (object) {
            this.m_DMXControlDimmer_Substitutes.clear();
            this.m_DMXControlDimmer_Substitutes_ControlTypeIDs.clear();
        }
        if (this.m_PropertyChangeSupport != null) {
            this.refreshToolTipText();
            this.m_PropertyChangeSupport.firePropertyChange(PROP_DMXDEVICE_DMXDEVICETYPE, o_OldDMXDeviceType, this.m_DMXDeviceType);
            this.m_PropertyChangeSupport.firePropertyChange(PROP_DMXDEVICE_CLOSED, o_OldDMXDeviceType, this.m_DMXDeviceType);
            this.clearPropertyChangeListeners();
        }
        LiveLanguage.removeLanguageListener((Object)this);
    }

    public void finalize() throws Throwable {
        super.finalize();
        this.m_PropertyChangeSupport = null;
    }

    public String getID() {
        return this.m_ID;
    }

    public void setID(String p_ID) {
        if (p_ID == null || p_ID.length() <= 0) {
            return;
        }
        this.m_ID = p_ID;
    }

    public void setUsedInTimeline(boolean p_UsedInTimeline) {
        this.m_UsedInTimeline = p_UsedInTimeline;
    }

    public boolean getUsedInTimeline() {
        return this.m_UsedInTimeline;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDMXDeviceType(DMXDeviceType p_DMXDeviceType) {
        DMXControlComponent.DeviceControlLink o_DeviceControlLink;
        InternalChannel o_InternalChannel;
        InternalSector o_InternalSector;
        if (this.m_DMXDeviceType == p_DMXDeviceType) {
            return;
        }
        if (LiveShowDMXStageView.s_SelfReference != null) {
            LiveShowDMXStageView.s_SelfReference.removeSelectedDMXDevice(this);
        }
        DMXDeviceType oldDMXDeviceType = this.m_DMXDeviceType;
        boolean boolChangedDMXDeviceType = false;
        ArrayList<DMXPowerSource> o_SectorDMXPowerSources = new ArrayList<DMXPowerSource>();
        ArrayList<SectorAddress> o_SectorAddresses = new ArrayList<SectorAddress>();
        ArrayList<DMXControlComponent.DeviceControlLink> o_DeviceControlLinks = new ArrayList<DMXControlComponent.DeviceControlLink>();
        if (this.m_DMXDeviceType != null) {
            boolChangedDMXDeviceType = true;
            this.unlinkLabelListConditions();
            this.m_DMXDeviceType.removePropertyChangeListener(this);
            for (int intSector = this.m_InternalSectors.size() - 1; intSector >= 0; --intSector) {
                o_InternalSector = this.getInternalSector(intSector);
                if (o_InternalSector == null) continue;
                for (int intInternalChannel = o_InternalSector.getInternalChannelCount() - 1; intInternalChannel >= 0; --intInternalChannel) {
                    o_InternalChannel = o_InternalSector.getInternalChannel(intInternalChannel);
                    if (o_InternalChannel == null) continue;
                    for (int intLink = 0; intLink < o_InternalChannel.getDeviceControlLinkCount(); ++intLink) {
                        DMXControlComponent.DMXControlType o_DMXControlType;
                        o_DeviceControlLink = o_InternalChannel.getDeviceControlLink(intLink);
                        if (o_DeviceControlLink == null || this.m_DMXDeviceType.containsDMXControlType(o_DMXControlType = o_DeviceControlLink.getDMXControlType()) || o_DeviceControlLinks.contains(o_DeviceControlLink)) continue;
                        o_DeviceControlLinks.add(o_DeviceControlLink);
                    }
                    o_InternalChannel.close(true);
                    o_InternalSector.removeInternalChannel(o_InternalChannel);
                }
                Object intInternalChannel = this.m_SyncDevice;
                synchronized (intInternalChannel) {
                    this.m_InternalSectors.remove(o_InternalSector);
                }
                o_SectorAddresses.add(o_InternalSector.getSectorAddress());
                o_SectorDMXPowerSources.add(o_InternalSector.getDMXPowerSource());
                o_InternalSector.close();
            }
            this.m_DeviceTypename = "";
        }
        this.m_DMXDeviceType = p_DMXDeviceType;
        if (this.m_DMXDeviceType == null) {
            this.refreshToolTipText();
            this.m_PropertyChangeSupport.firePropertyChange(PROP_DMXDEVICE_DMXDEVICETYPE, oldDMXDeviceType, this.m_DMXDeviceType);
            return;
        }
        if (!"TEST".equals(this.m_ID)) {
            this.addDMXDeviceFilter_DMXDeviceType(p_DMXDeviceType);
        }
        this.m_Manufactureer = this.m_DMXDeviceType.getManufactureerName();
        this.m_DeviceTypename = this.m_DMXDeviceType.getTypeName();
        this.m_HasDimmerLinked = false;
        this.m_HasDimmerSubstituteLinked = false;
        this.m_Scale = 100;
        if (this.m_DMXDeviceType != null) {
            for (int intSector = 0; intSector < this.m_DMXDeviceType.getDMXDeviceSectorCount(); ++intSector) {
                DMXDeviceType.DMXDeviceSector o_DMXDeviceSector = this.m_DMXDeviceType.getDMXDeviceSector(intSector);
                if (o_DMXDeviceSector == null) continue;
                o_InternalSector = new InternalSector(this, intSector);
                for (int intChannel = 0; intChannel < o_DMXDeviceSector.getChannelCount(); ++intChannel) {
                    DMXDeviceType.DMXDeviceChannelType o_DMXDeviceChannelType = o_DMXDeviceSector.getDMXDeviceChannelType(intChannel);
                    if (o_DMXDeviceChannelType == null) continue;
                    if (o_DMXDeviceChannelType.getIsDimmerChannel()) {
                        this.m_HasDimmerLinked = true;
                    }
                    if (o_DMXDeviceChannelType.getIsDimmerSubstituteChannel()) {
                        this.m_HasDimmerSubstituteLinked = true;
                    }
                    o_InternalChannel = new InternalChannel(o_InternalSector, intChannel, o_DMXDeviceSector.getDMXDeviceChannelType(intChannel));
                    o_InternalSector.addInternalChannel(o_InternalChannel);
                }
                Object intChannel = this.m_SyncDevice;
                synchronized (intChannel) {
                    this.m_InternalSectors.add(o_InternalSector);
                }
                if (intSector >= 0 && intSector < o_SectorAddresses.size()) {
                    SectorAddress o_SectorAddress = (SectorAddress)o_SectorAddresses.get(o_SectorAddresses.size() - 1 - intSector);
                    o_InternalSector.setDMXAddress(o_SectorAddress.getDMXUniverse(), o_SectorAddress.getDMXStartAddress());
                }
                if (intSector < 0 || intSector >= o_SectorDMXPowerSources.size()) continue;
                DMXPowerSource o_DMXPowerSource = (DMXPowerSource)o_SectorDMXPowerSources.get(o_SectorDMXPowerSources.size() - 1 - intSector);
                o_InternalSector.setDMXPowerSource(o_DMXPowerSource);
            }
            this.m_DMXDeviceType.addPropertyChangeListener(this);
        }
        for (int intLink = o_DeviceControlLinks.size() - 1; intLink >= 0; --intLink) {
            int intInternalChannel;
            int intByte;
            o_DeviceControlLink = (DMXControlComponent.DeviceControlLink)o_DeviceControlLinks.get(intLink);
            if (o_DeviceControlLink == null) continue;
            boolean boolLinkIsConnected = false;
            for (intByte = 0; intByte < o_DeviceControlLink.getByteResolution(); ++intByte) {
                intInternalChannel = o_DeviceControlLink.getDeviceInternalChannel(intByte);
                o_InternalChannel = this.getInternalChannel(o_DeviceControlLink.getDMXDeviceSectorIndex(), intInternalChannel);
                if (o_InternalChannel == null) continue;
                boolLinkIsConnected = true;
            }
            if (!boolLinkIsConnected) {
                o_DeviceControlLink.close();
                continue;
            }
            for (intByte = 0; intByte < o_DeviceControlLink.getByteResolution(); ++intByte) {
                intInternalChannel = o_DeviceControlLink.getDeviceInternalChannel(intByte);
                o_InternalChannel = this.getInternalChannel(o_DeviceControlLink.getDMXDeviceSectorIndex(), intInternalChannel);
                if (o_InternalChannel == null) continue;
                o_InternalChannel.addDeviceControlLink(o_DeviceControlLink, intByte);
            }
        }
        for (int intSector = 0; intSector < this.m_InternalSectors.size(); ++intSector) {
            o_InternalSector = this.getInternalSector(intSector);
            if (o_InternalSector == null) continue;
            for (int intChannel = o_InternalSector.getInternalChannelCount() - 1; intChannel >= 0; --intChannel) {
                o_InternalChannel = o_InternalSector.getInternalChannel(intChannel);
                o_InternalChannel.eventValuesDMXChannel();
                o_InternalChannel.eventValuesDMXInterface();
            }
        }
        this.setDMXControlComponents();
        this.refreshDeviceControlLinks_ValueInternalChannels_EditMode();
        this.refreshDeviceControlLinks_ValueInternalChannels(false);
        this.refreshDeviceControlLinks_ValueInterface();
        this.refreshToolTipText();
        this.m_PropertyChangeSupport.firePropertyChange(PROP_DMXDEVICE_DMXDEVICETYPE, oldDMXDeviceType, this.m_DMXDeviceType);
        this.m_DefaultDMXSceneDeviceValues.setDMXDevice(this);
        this.m_DefaultDMXSceneDeviceValues.saveDMXDeviceDefaultValues(this);
        this.m_DefaultDMXSceneDeviceValues.setFlagMixSource(1);
        this.linkLabelListConditions();
        this.refreshIsOn();
        this.refreshIsOn_EditMode();
    }

    private void addDMXDeviceFilter_DMXDeviceType(DMXDeviceType p_DMXDeviceType) {
        DMXDeviceFilter.createDMXDeviceFilter(p_DMXDeviceType);
    }

    private void removeDMXDeviceFilter_DMXDeviceType(DMXDeviceType p_DMXDeviceType) {
        for (int intDMXDevice = 0; intDMXDevice < DMXDevice.getDMXDeviceCount(); ++intDMXDevice) {
            DMXDevice o_DMXDevice = DMXDevice.getDMXDevice(intDMXDevice);
            if (o_DMXDevice.getDMXDeviceType() != p_DMXDeviceType) continue;
            return;
        }
        DMXDeviceFilter.removeDMXDeviceFilter(p_DMXDeviceType);
    }

    private void setDMXControlComponents() {
        this.m_HasMovableControls = false;
        if (this.m_DMXDeviceType == null) {
            for (int intDMXControl = this.m_DMXControlComponents.size() - 1; intDMXControl >= 0; --intDMXControl) {
                DMXControlComponent o_DMXControlComponent = (DMXControlComponent)this.m_DMXControlComponents.get(intDMXControl);
                if (o_DMXControlComponent == null) continue;
                DMXControlComponent.DeviceSettingsPanel o_DeviceSettingsPanel = o_DMXControlComponent.getDMXDeviceSettingsPanel(this, false);
                if (o_DeviceSettingsPanel != null) {
                    this.m_DMXControlDeviceSettingsPanels.remove(o_DeviceSettingsPanel);
                }
                this.removeDMXControlComponent(intDMXControl);
                o_DMXControlComponent.close();
            }
        } else {
            DMXControlComponent.DeviceSettingsPanel o_DeviceSettingsPanel;
            DMXControlComponent.DMXControlType o_DMXControlType_Type;
            DMXControlComponent o_DMXControlComponent;
            HashMap<String, DMXControlComponent.DeviceSettingsPanel> o_OldDeviceSettingsPanel = new HashMap<String, DMXControlComponent.DeviceSettingsPanel>();
            for (int intDMXControl = this.m_DMXControlComponents.size() - 1; intDMXControl >= 0; --intDMXControl) {
                o_DMXControlComponent = (DMXControlComponent)this.m_DMXControlComponents.get(intDMXControl);
                if (o_DMXControlComponent == null || (o_DMXControlType_Type = o_DMXControlComponent.getDMXControlType()) == null) continue;
                o_DeviceSettingsPanel = o_DMXControlComponent.getDMXDeviceSettingsPanel(this, false);
                if (o_DeviceSettingsPanel != null) {
                    this.m_DMXControlDeviceSettingsPanels.remove(o_DeviceSettingsPanel);
                    if (!o_DeviceSettingsPanel.getIsEqualDefault()) {
                        o_OldDeviceSettingsPanel.put(o_DMXControlType_Type.getID(), o_DeviceSettingsPanel);
                    }
                }
                this.removeDMXControlComponent(intDMXControl);
                o_DMXControlComponent.close();
            }
            int intDMXControlTypeCount = this.m_DMXDeviceType.getDMXControlTypeCount();
            for (int intDMXControl = 0; intDMXControl < intDMXControlTypeCount; ++intDMXControl) {
                DMXFadeDescription.DMXControlTypeFadeDescription o_DMXControlTypeFadeDescription;
                o_DMXControlType_Type = this.m_DMXDeviceType.getDMXControlType(intDMXControl);
                if (o_DMXControlType_Type == null) continue;
                if (DMXControlDescription.MOVABLECONTROLS_IDS.contains(o_DMXControlType_Type.getDMXControlDescription().getID())) {
                    this.m_HasMovableControls = true;
                }
                if ((o_DMXControlComponent = this.getDMXControlComponentByID(o_DMXControlType_Type.getID())) != null) {
                    o_DMXControlTypeFadeDescription = this.m_DMXDeviceType.getDefaultDMXControlTypeFadeDescription(o_DMXControlComponent.getDMXControlType());
                    if (o_DMXControlTypeFadeDescription != null) {
                        o_DMXControlComponent.setDisabledByDefault(o_DMXControlTypeFadeDescription.getDisabled());
                        o_DMXControlComponent.setDisabledAdjustmentByDefault(o_DMXControlTypeFadeDescription.getDisabledAdjustment());
                    }
                    o_DMXControlComponent.setDMXDeviceType(this.m_DMXDeviceType);
                    o_DMXControlComponent.setDMXControlComponentPool(this);
                    continue;
                }
                DMXControlComponent.DMXControlType o_DMXControlType_New = o_DMXControlType_Type.copyWithoutLinks();
                o_DMXControlComponent = DMXControlComponent.loadDMXControlComponent(o_DMXControlType_New);
                if (o_DMXControlComponent == null) {
                    this.m_DMXDeviceType.removeDMXControlType(o_DMXControlType_Type);
                    --intDMXControl;
                    --intDMXControlTypeCount;
                    continue;
                }
                o_DeviceSettingsPanel = (DMXControlComponent.DeviceSettingsPanel)o_OldDeviceSettingsPanel.get(o_DMXControlType_New.getID());
                if (o_DeviceSettingsPanel != null) {
                    o_DMXControlComponent.setDMXDeviceSettingsPanel(this, o_DeviceSettingsPanel);
                }
                if ((o_DeviceSettingsPanel = o_DMXControlComponent.getDMXDeviceSettingsPanel(this, true)) != null) {
                    this.m_DMXControlDeviceSettingsPanels.add(o_DeviceSettingsPanel);
                }
                o_DMXControlType_Type.copyDeviceControlLinksTo(this, o_DMXControlType_New);
                this.addDMXControlComponent(intDMXControl, o_DMXControlComponent);
                o_DMXControlComponent.setDMXControlComponentPool(this);
                o_DMXControlTypeFadeDescription = this.m_DMXDeviceType.getDefaultDMXControlTypeFadeDescription(o_DMXControlComponent.getDMXControlType());
                if (o_DMXControlTypeFadeDescription == null) continue;
                o_DMXControlComponent.setDisabledByDefault(o_DMXControlTypeFadeDescription.getDisabled());
                o_DMXControlComponent.setDisabledAdjustmentByDefault(o_DMXControlTypeFadeDescription.getDisabledAdjustment());
            }
            Collection o_DeviceSettingsPanels = o_OldDeviceSettingsPanel.values();
            Iterator o_IteratorDeviceSettingPanel = o_DeviceSettingsPanels.iterator();
            while (o_IteratorDeviceSettingPanel.hasNext()) {
                o_DeviceSettingsPanel = (DMXControlComponent.DeviceSettingsPanel)o_IteratorDeviceSettingPanel.next();
                if (this.m_DMXControlDeviceSettingsPanels.contains(o_DeviceSettingsPanel)) continue;
                o_IteratorDeviceSettingPanel.remove();
                o_DeviceSettingsPanel.close();
            }
        }
        this.checkDimmable();
        this.refreshDMXDeviceSettings();
    }

    private void addDMXControlComponent(int p_Position, DMXControlComponent p_DMXControlComponent) {
        if (p_DMXControlComponent == null) {
            return;
        }
        this.m_DMXControlComponents.add(p_Position, p_DMXControlComponent);
    }

    private void removeDMXControlComponent(DMXControlComponent p_DMXControlComponent) {
        if (p_DMXControlComponent == null) {
            return;
        }
        this.m_DMXControlComponents.remove(p_DMXControlComponent);
    }

    private void removeDMXControlComponent(int p_Position) {
        if (p_Position < 0 || p_Position >= this.m_DMXControlComponents.size()) {
            return;
        }
        DMXControlComponent o_DMXControlComponent = (DMXControlComponent)this.m_DMXControlComponents.get(p_Position);
        if (o_DMXControlComponent == null) {
            return;
        }
        this.m_DMXControlComponents.remove(o_DMXControlComponent);
    }

    @Override
    public DMXControlComponent getDMXControlComponentByID(String p_ID) {
        if (p_ID == null) {
            return null;
        }
        DMXControlComponent o_DMXControlComponent = this.m_DMXControlComponents.getByDMXControlTypeID(p_ID);
        return o_DMXControlComponent;
    }

    public boolean hasDMXControlComponents_DescriptionID(String p_DMXControlDescriptionID) {
        if (p_DMXControlDescriptionID == null) {
            return false;
        }
        for (int intDMXControlComponent = 0; intDMXControlComponent < this.m_DMXControlComponents.size(); ++intDMXControlComponent) {
            DMXControlComponent.DMXControlType o_DMXControlType;
            DMXControlComponent o_DMXControlComponent = (DMXControlComponent)this.m_DMXControlComponents.get(intDMXControlComponent);
            if (o_DMXControlComponent == null || !p_DMXControlDescriptionID.equals((o_DMXControlType = o_DMXControlComponent.getDMXControlType()).getDMXControlDescription().getID())) continue;
            return true;
        }
        return false;
    }

    public DMXControlComponent getDMXControlComponentByDescriptionFirst(String p_DMXControlDescriptionID) {
        if (p_DMXControlDescriptionID == null) {
            return null;
        }
        for (int intDMXControlComponent = 0; intDMXControlComponent < this.m_DMXControlComponents.size(); ++intDMXControlComponent) {
            DMXControlComponent.DMXControlType o_DMXControlType;
            DMXControlComponent o_DMXControlComponent = (DMXControlComponent)this.m_DMXControlComponents.get(intDMXControlComponent);
            if (o_DMXControlComponent == null || !p_DMXControlDescriptionID.equals((o_DMXControlType = o_DMXControlComponent.getDMXControlType()).getDMXControlDescription().getID())) continue;
            return o_DMXControlComponent;
        }
        return null;
    }

    public ArrayList<DMXControlComponent> getDMXControlComponentsByDescription(String p_DMXControlDescriptionID, ArrayList<DMXControlComponent> p_DMXControlComponents) {
        if (p_DMXControlDescriptionID == null) {
            return null;
        }
        if (p_DMXControlComponents == null) {
            p_DMXControlComponents = new ArrayList();
        }
        p_DMXControlComponents.clear();
        for (int intDMXControlComponent = 0; intDMXControlComponent < this.m_DMXControlComponents.size(); ++intDMXControlComponent) {
            DMXControlComponent.DMXControlType o_DMXControlType;
            DMXControlComponent o_DMXControlComponent = (DMXControlComponent)this.m_DMXControlComponents.get(intDMXControlComponent);
            if (o_DMXControlComponent == null || (o_DMXControlType = o_DMXControlComponent.getDMXControlType()) == null || !p_DMXControlDescriptionID.equals(o_DMXControlType.getDMXControlDescription().getID())) continue;
            p_DMXControlComponents.add(o_DMXControlComponent);
        }
        return p_DMXControlComponents;
    }

    public boolean containsDMXControlComponent(DMXControlComponent p_DMXControlComponent) {
        if (p_DMXControlComponent == null) {
            return false;
        }
        return this.m_DMXControlComponents.contains(p_DMXControlComponent);
    }

    public ArrayList<DMXControlComponent> getDMXControlComponents() {
        return this.m_DMXControlComponents.getElementArrayList();
    }

    @Override
    public DMXControlComponent.DMXControlComponentList getListModelDMXControlComponents() {
        return this.m_DMXControlComponents;
    }

    public DMXControlComponent getDMXControlComponentDimmerSubstituteFirst() {
        return null;
    }

    @Override
    public void linkLabelListConditions() {
        for (int intDMXControlComponent = 0; intDMXControlComponent < this.m_DMXControlComponents.size(); ++intDMXControlComponent) {
            DMXControlComponent o_DMXControlComponent = (DMXControlComponent)this.m_DMXControlComponents.get(intDMXControlComponent);
            if (o_DMXControlComponent == null) continue;
            o_DMXControlComponent.linkLabelListConditions();
        }
    }

    @Override
    public void unlinkLabelListConditions() {
        for (int intDMXControlComponent = 0; intDMXControlComponent < this.m_DMXControlComponents.size(); ++intDMXControlComponent) {
            DMXControlComponent o_DMXControlComponent = (DMXControlComponent)this.m_DMXControlComponents.get(intDMXControlComponent);
            if (o_DMXControlComponent == null) continue;
            o_DMXControlComponent.unlinkLabelListConditions();
        }
    }

    public int getDMXControlComponentCount() {
        return this.m_DMXControlComponents.size();
    }

    public int getDMXControlComponentIndex(DMXControlComponent p_DMXControlComponent) {
        return this.m_DMXControlComponents.indexOf(p_DMXControlComponent);
    }

    public DMXControlComponent getDMXControlComponent(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        if (p_Index >= this.m_DMXControlComponents.size()) {
            return null;
        }
        return (DMXControlComponent)this.m_DMXControlComponents.get(p_Index);
    }

    public int getDMXControlComponentCountByDescription(String p_DMXControlDescriptionID) {
        if (p_DMXControlDescriptionID == null) {
            return 0;
        }
        int intCount = 0;
        for (int intDMXControlComponent = 0; intDMXControlComponent < this.m_DMXControlComponents.size(); ++intDMXControlComponent) {
            DMXControlDescription o_DMXControlDescription;
            DMXControlComponent.DMXControlType o_DMXControlType;
            DMXControlComponent o_DMXControlComponent = (DMXControlComponent)this.m_DMXControlComponents.get(intDMXControlComponent);
            if (o_DMXControlComponent == null || (o_DMXControlType = o_DMXControlComponent.getDMXControlType()) == null || (o_DMXControlDescription = o_DMXControlType.getDMXControlDescription()) == null || !p_DMXControlDescriptionID.equals(o_DMXControlDescription.getID())) continue;
            ++intCount;
        }
        return intCount;
    }

    public ArrayList<DMXControlComponent> getDMXControlComponentsByDescription(DMXControlDescription p_DMXControlDescription, ArrayList<DMXControlComponent> p_DMXControlComponents) {
        if (p_DMXControlComponents == null) {
            p_DMXControlComponents = new ArrayList();
        }
        p_DMXControlComponents.clear();
        for (int intDMXControlComponent = 0; intDMXControlComponent < this.m_DMXControlComponents.size(); ++intDMXControlComponent) {
            DMXControlComponent o_DMXControlComponent = (DMXControlComponent)this.m_DMXControlComponents.get(intDMXControlComponent);
            if (o_DMXControlComponent == null || o_DMXControlComponent.getDMXControlType().getDMXControlDescription() != p_DMXControlDescription) continue;
            p_DMXControlComponents.add(o_DMXControlComponent);
        }
        return p_DMXControlComponents;
    }

    public void callControlFunction(ControlFunctionModel.ControlFunctionType p_ControlFunctionType) {
        ControlObject o_ControlObject;
        if (p_ControlFunctionType == null) {
            return;
        }
        DMXScene.DMXSceneDeviceValues o_DefaultDMXSceneDeviceValues = this.getDefaultDMXSceneDeviceValues();
        this.m_ControlFunctionChangedObjects.clear();
        for (int intDMXControl = this.m_DMXControlComponents.size() - 1; intDMXControl >= 0; --intDMXControl) {
            DMXControlComponent o_DMXControlComponent = (DMXControlComponent)this.m_DMXControlComponents.get(intDMXControl);
            if (o_DMXControlComponent == null || o_DMXControlComponent.getIsDisabledInFunctions()) continue;
            for (int intControl = 0; intControl < o_DMXControlComponent.getControlObjectCount(); ++intControl) {
                o_ControlObject = o_DMXControlComponent.getControlObject(intControl);
                if (o_ControlObject == null) continue;
                block10: for (int intDimension = 0; intDimension < o_ControlObject.getControlDimensionCount(); ++intDimension) {
                    ControlObject.ControlDimension o_ControlDimension = o_ControlObject.getControlDimension(intDimension);
                    if (o_ControlDimension == null) continue;
                    switch (p_ControlFunctionType.getID()) {
                        case "SetNull": {
                            if (!o_DMXControlComponent.getIsLinked(o_ControlDimension) && o_DMXControlComponent.getLinkedDMXDeviceCount() > 0) continue block10;
                            o_ControlDimension.setValue(0.0);
                            if (this.m_ControlFunctionChangedObjects.contains(o_ControlObject)) continue block10;
                            this.m_ControlFunctionChangedObjects.add(o_ControlObject);
                            continue block10;
                        }
                        case "SetDefault": {
                            if (!o_DMXControlComponent.getIsLinked(o_ControlDimension) && o_DMXControlComponent.getLinkedDMXDeviceCount() > 0) continue block10;
                            double doubleValue = o_DefaultDMXSceneDeviceValues.getValueDMXDevice(o_DMXControlComponent.getDMXControlType(), intControl, intDimension);
                            o_ControlDimension.setValue(doubleValue);
                            if (this.m_ControlFunctionChangedObjects.contains(o_ControlObject)) continue block10;
                            this.m_ControlFunctionChangedObjects.add(o_ControlObject);
                            continue block10;
                        }
                        default: {
                            ControlFunctionModel.ControlFunctionDescription o_ControlFunctionDescription;
                            ControlFunctionModel o_ControlFunctionModel = o_ControlDimension.getControlFunctionModel();
                            if (o_ControlFunctionModel == null || (o_ControlFunctionDescription = o_ControlFunctionModel.getControlFunctionDescription(p_ControlFunctionType.getID())) == null) continue block10;
                            o_ControlDimension.setValue(o_ControlFunctionDescription.getValue());
                            if (this.m_ControlFunctionChangedObjects.contains(o_ControlObject)) continue block10;
                            this.m_ControlFunctionChangedObjects.add(o_ControlObject);
                        }
                    }
                }
            }
        }
        for (int intControl = 0; intControl < this.m_ControlFunctionChangedObjects.size(); ++intControl) {
            o_ControlObject = this.m_ControlFunctionChangedObjects.get(intControl);
            o_ControlObject.setValueManuallyIsReady();
        }
    }

    public int getDeviceSettingsPanelCount() {
        return this.m_DMXControlDeviceSettingsPanels.size();
    }

    public DMXControlComponent.DeviceSettingsPanel getDeviceSettingsPanel(int p_Index) {
        if (p_Index < 0 || p_Index >= this.m_DMXControlDeviceSettingsPanels.size()) {
            return null;
        }
        return this.m_DMXControlDeviceSettingsPanels.get(p_Index);
    }

    public DMXControlComponent.DeviceSettingsPanel getDeviceSettingsPanel(DMXControlComponent p_DMXControlComponent) {
        for (int intPanel = 0; intPanel < this.m_DMXControlDeviceSettingsPanels.size(); ++intPanel) {
            DMXControlComponent.DMXControlType o_DMXControlType;
            DMXControlComponent.DMXControlType o_DMXControlType_Own;
            DMXControlComponent.DeviceSettingsPanel o_DeviceSettingsPanel = this.m_DMXControlDeviceSettingsPanels.get(intPanel);
            DMXControlComponent o_DMXControlComponent = o_DeviceSettingsPanel.getDMXControlComponent();
            if (!o_DMXControlComponent.getClassName().equals(p_DMXControlComponent.getClassName()) || (o_DMXControlType_Own = o_DMXControlComponent.getDMXControlType()) == null || (o_DMXControlType = p_DMXControlComponent.getDMXControlType()) == null) continue;
            ArrayList<DMXControlComponent.DeviceControlLink> o_DeviceControlLinks_Own = o_DMXControlType_Own.getDeviceControlLinks();
            ArrayList<DMXControlComponent.DeviceControlLink> o_DeviceControlLinks = o_DMXControlType.getDeviceControlLinks();
            for (int intLink = 0; intLink < o_DeviceControlLinks.size(); ++intLink) {
                DMXControlComponent.DeviceControlLink o_DeviceControlLink = o_DeviceControlLinks.get(intLink);
                if (o_DeviceControlLink == null) continue;
                for (int intByte = 0; intByte < o_DeviceControlLink.getByteResolution(); ++intByte) {
                    int intInternalChannel = o_DeviceControlLink.getDeviceInternalChannel(intByte);
                    if (intInternalChannel < 0) continue;
                    for (int intLinkOwn = 0; intLinkOwn < o_DeviceControlLinks_Own.size(); ++intLinkOwn) {
                        DMXControlComponent.DeviceControlLink o_DeviceControlLink_Own = o_DeviceControlLinks_Own.get(intLinkOwn);
                        if (o_DeviceControlLink_Own == null) continue;
                        for (int intByteOwn = 0; intByteOwn < o_DeviceControlLink_Own.getByteResolution(); ++intByteOwn) {
                            int intInternalChannel_Own = o_DeviceControlLink_Own.getDeviceInternalChannel(intByteOwn);
                            if (intInternalChannel_Own < 0 || intInternalChannel != intInternalChannel_Own) continue;
                            return o_DeviceSettingsPanel;
                        }
                    }
                }
            }
        }
        return null;
    }

    public DMXControlComponent.DeviceSettingsPanel getDeviceSettingsPanel(Class<?> p_Class) {
        for (int intPanel = 0; intPanel < this.m_DMXControlDeviceSettingsPanels.size(); ++intPanel) {
            DMXControlComponent.DeviceSettingsPanel o_DMDeviceSettingsPanel = this.m_DMXControlDeviceSettingsPanels.get(intPanel);
            if (o_DMDeviceSettingsPanel == null || !o_DMDeviceSettingsPanel.getClass().getSimpleName().equals(p_Class.getSimpleName())) continue;
            return o_DMDeviceSettingsPanel;
        }
        return null;
    }

    public void refreshDMXDeviceSettings() {
        for (int intPanel = 0; intPanel < this.m_DMXControlDeviceSettingsPanels.size(); ++intPanel) {
            DMXControlComponent.DeviceSettingsPanel o_DMDeviceSettingsPanel = this.m_DMXControlDeviceSettingsPanels.get(intPanel);
            if (o_DMDeviceSettingsPanel == null) continue;
            o_DMDeviceSettingsPanel.setDMXDeviceSettings();
        }
    }

    public int getInternalSectorCount() {
        return this.m_InternalSectors.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalSector getInternalSector(int p_Index) {
        Object object = this.m_SyncDevice;
        synchronized (object) {
            if (p_Index < 0 || p_Index >= this.m_InternalSectors.size()) {
                return null;
            }
            return this.m_InternalSectors.get(p_Index);
        }
    }

    public InternalChannel getInternalChannel(int p_DMXDeviceSectorIndex, int p_InternalAddress) {
        InternalSector o_InternalSector = this.getInternalSector(p_DMXDeviceSectorIndex);
        if (o_InternalSector == null) {
            return null;
        }
        return o_InternalSector.getInternalChannel(p_InternalAddress);
    }

    public DMXScene.DMXSceneDeviceValues getDefaultDMXSceneDeviceValues() {
        return this.m_DefaultDMXSceneDeviceValues;
    }

    public DMXDeviceType getDMXDeviceType() {
        return this.m_DMXDeviceType;
    }

    private String createName(String p_Name) {
        int intPrefixCount = 0;
        int intMaxPostfix = 0;
        String stringPrefix = p_Name != null && p_Name.length() > 0 ? NameExtension.getPrefix(p_Name) : DEFAULT_DMXDEVICENAME;
        for (int intDevice = 0; intDevice < DMXDevice.getDMXDeviceCount(); ++intDevice) {
            int intPostfix;
            DMXDevice o_DMXDevice = DMXDevice.getDMXDevice(intDevice);
            if (o_DMXDevice == null || (intPostfix = NameExtension.getPostfix_Int(o_DMXDevice.getName(), stringPrefix)) == -2) continue;
            if (intPostfix == -1) {
                intPostfix = ++intPrefixCount;
            }
            if (intPostfix <= intMaxPostfix) continue;
            intMaxPostfix = intPostfix;
        }
        return NameExtension.createName(stringPrefix, ++intMaxPostfix, "000", true);
    }

    @Override
    public String getName() {
        return this.m_Name;
    }

    public void setName(String p_Name) {
        if (p_Name == null || p_Name.length() <= 0) {
            return;
        }
        if (p_Name.equals(this.m_Name)) {
            return;
        }
        String oldName = this.m_Name;
        this.m_Name = p_Name;
        this.refreshToolTipText();
        this.m_PropertyChangeSupport.firePropertyChange(PROP_DMXDEVICE_DEVICENAME, oldName, this.m_Name);
        this.refreshDeviceControlLinks_TypeChanged();
    }

    public String getManufactureerName() {
        return this.m_Manufactureer;
    }

    public String getDeviceTypeName() {
        return this.m_DeviceTypename;
    }

    public String getDeviceDMXModeName() {
        if (this.m_DMXDeviceType == null) {
            return "";
        }
        return this.m_DMXDeviceType.getDMXModeName();
    }

    public String getRDMDeviceUID() {
        return this.m_RDMDeviceUID;
    }

    public String getToolTipText() {
        return this.m_StringBuilderDeviceToolTip.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshToolTipText() {
        Object object = this.m_SyncStringBuilder;
        synchronized (object) {
            LiveShowSceneBridge o_LiveShowSceneBridge;
            DMXDeviceType o_DMXDeviceType = this.m_DMXDeviceType;
            this.m_StringBuilderDeviceToolTip.delete(0, this.m_StringBuilderDeviceToolTip.length());
            this.m_StringBuilderDeviceToolTip.append("<html><center>");
            this.m_StringBuilderDeviceToolTip.append("<b>");
            this.m_StringBuilderDeviceToolTip.append(this.getName());
            this.m_StringBuilderDeviceToolTip.append("</b>");
            this.m_StringBuilderDeviceToolTip.append("<br>");
            if (o_DMXDeviceType != null) {
                if (o_DMXDeviceType.getRemark() != null && o_DMXDeviceType.getRemark().length() > 0) {
                    this.m_StringBuilderDeviceToolTip.append(o_DMXDeviceType.getRemark());
                    this.m_StringBuilderDeviceToolTip.append("<br>");
                }
                this.m_StringBuilderDeviceToolTip.append(o_DMXDeviceType.getManufactureerName());
                this.m_StringBuilderDeviceToolTip.append("<br>");
                this.m_StringBuilderDeviceToolTip.append(o_DMXDeviceType.getTypeName());
                this.m_StringBuilderDeviceToolTip.append("<br>");
                for (int intSector = 0; intSector < this.getInternalSectorCount(); ++intSector) {
                    this.m_StringBuilderDeviceToolTip.append("<br>");
                    InternalSector o_InternalSector = this.getInternalSector(intSector);
                    if (o_InternalSector == null) continue;
                    if (this.getInternalSectorCount() > 1) {
                        this.m_StringBuilderDeviceToolTip.append(DMXDeviceType.SECTORNAME);
                        this.m_StringBuilderDeviceToolTip.append(" ");
                        this.m_StringBuilderDeviceToolTip.append(String.valueOf(intSector + 1));
                        this.m_StringBuilderDeviceToolTip.append(": ");
                    }
                    this.m_StringBuilderDeviceToolTip.append(String.valueOf(o_InternalSector.getInternalChannelCount()));
                    this.m_StringBuilderDeviceToolTip.append(" ");
                    this.m_StringBuilderDeviceToolTip.append(DMXDeviceTableModel.COLUMN_DEVICECHANNELS);
                    this.m_StringBuilderDeviceToolTip.append("<br>");
                    if (o_InternalSector.getDMXUniverse() != null) {
                        this.m_StringBuilderDeviceToolTip.append(o_InternalSector.getDMXUniverse().getName());
                        this.m_StringBuilderDeviceToolTip.append("<br>");
                        this.m_StringBuilderDeviceToolTip.append(DMXDeviceTableModel.COLUMN_DEVICEADDRESS);
                        this.m_StringBuilderDeviceToolTip.append(": ");
                        this.m_StringBuilderDeviceToolTip.append(o_InternalSector.getDMXStartAddressVisible());
                        this.m_StringBuilderDeviceToolTip.append("<br>");
                    }
                    this.m_StringBuilderDeviceToolTip.append(o_DMXDeviceType.getDMXDeviceSector(intSector).getWattage());
                    this.m_StringBuilderDeviceToolTip.append(" ");
                    this.m_StringBuilderDeviceToolTip.append(DMXPowerSource.s_WATTAGEUNIT);
                    DMXPowerSource o_DMXPowerSource = o_InternalSector.getDMXPowerSource();
                    if (o_DMXPowerSource == null) continue;
                    this.m_StringBuilderDeviceToolTip.append(" ");
                    this.m_StringBuilderDeviceToolTip.append(o_DMXPowerSource.getName());
                }
            }
            this.m_StringBuilderDeviceToolTip.append("<br>");
            if (this.getUsedInTimeline() && (o_LiveShowSceneBridge = this.getSceneBridge_Adjusted()) != null) {
                this.m_StringBuilderDeviceToolTip.append("<br>");
                this.m_StringBuilderDeviceToolTip.append("-> ");
                this.m_StringBuilderDeviceToolTip.append(o_LiveShowSceneBridge.getName());
            }
            this.m_StringBuilderDeviceToolTip.append("</center></html>");
        }
    }

    public boolean getActive() {
        return this.m_Active;
    }

    public void setActive(boolean p_Active) {
        if (this.m_Active == p_Active) {
            return;
        }
        this.m_Active = p_Active;
        for (int intSector = 0; intSector < this.m_InternalSectors.size(); ++intSector) {
            InternalSector o_InternalSector = this.getInternalSector(intSector);
            if (o_InternalSector == null) continue;
            o_InternalSector.setActive(this.m_Active);
        }
        this.refreshDeviceControlLinks_ValueInternalChannels(false);
        this.m_PropertyChangeSupport.firePropertyChange(PROP_DMXDEVICE_DEVICEACTIVE, !this.m_Active, this.m_Active);
    }

    public boolean getMute() {
        return this.m_Mute;
    }

    public void setMute(boolean p_Mute) {
        if (this.m_Mute == p_Mute) {
            return;
        }
        this.m_Mute = p_Mute;
        for (int intSector = 0; intSector < this.m_InternalSectors.size(); ++intSector) {
            InternalSector o_InternalSector = this.getInternalSector(intSector);
            if (o_InternalSector == null) continue;
            o_InternalSector.setMute(this.m_Mute);
        }
        this.refreshDeviceControlLinks_ValueInternalChannels(false);
        this.m_PropertyChangeSupport.firePropertyChange(PROP_DMXDEVICE_DEVICEMUTE, !this.m_Mute, this.m_Mute);
    }

    public boolean getSolo() {
        return this.m_Solo;
    }

    public void setSolo(boolean p_Solo) {
        if (this.m_Solo == p_Solo) {
            return;
        }
        this.m_Solo = p_Solo;
        DMXDevice.refreshAllSolo();
        this.m_PropertyChangeSupport.firePropertyChange(PROP_DMXDEVICE_DEVICESOLO, !this.m_Solo, this.m_Solo);
    }

    public void refreshSolo() {
        DMXDevice.checkAllSolo(this);
        for (int intSector = 0; intSector < this.m_InternalSectors.size(); ++intSector) {
            InternalSector o_InternalSector = this.getInternalSector(intSector);
            if (o_InternalSector == null) continue;
            o_InternalSector.setSolo(this.m_Solo);
        }
    }

    public void setScale(int p_ScalePercent) {
        if (this.m_Scale == p_ScalePercent) {
            return;
        }
        if (p_ScalePercent < 0) {
            p_ScalePercent = 0;
        }
        if (p_ScalePercent > 200) {
            p_ScalePercent = 200;
        }
        int oldValue = this.m_Scale;
        this.m_Scale = p_ScalePercent;
        this.sendValuesDMXUniverse(false);
        this.refreshDeviceControlLinks_ValueInternalChannels(false);
        this.m_PropertyChangeSupport.firePropertyChange(PROP_DMXDEVICE_DEVICESCALE, oldValue, this.m_Scale);
    }

    public int getScale() {
        return this.m_Scale;
    }

    public void sendValuesDMXUniverse(boolean p_ManuallySet) {
        for (int intSector = 0; intSector < this.m_InternalSectors.size(); ++intSector) {
            InternalSector o_InternalSector = this.getInternalSector(intSector);
            if (o_InternalSector == null) continue;
            o_InternalSector.sendValuesToDMXChannels(p_ManuallySet);
            o_InternalSector.sendValuesToDMXUniverse();
        }
    }

    public boolean getHasMovableControls() {
        return this.m_HasMovableControls;
    }

    public boolean getHasDimmerLinked() {
        return this.m_HasDimmerLinked;
    }

    public boolean getHasDimmerSubstituteLinked() {
        return this.m_HasDimmerSubstituteLinked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkDimmable() {
        this.m_Dimmable = false;
        this.m_DMXControlDimmer = null;
        this.m_DMXControlDimmer_ControlTypeID = null;
        Object object = this.m_SyncDevice;
        synchronized (object) {
            this.m_DMXControlDimmer_Substitutes.clear();
            this.m_DMXControlDimmer_Substitutes_ControlTypeIDs.clear();
        }
        if (this.m_HasDimmerLinked) {
            this.m_Dimmable = true;
        }
        if (this.m_HasDimmerSubstituteLinked) {
            this.m_Dimmable = true;
        }
        if (this.m_HasDimmerLinked) {
            this.m_DMXControlDimmer = this.getDMXControlComponentByDescriptionFirst("dimmer");
            this.m_DMXControlDimmer_ControlTypeID = this.m_DMXControlDimmer == null ? null : this.m_DMXControlDimmer.getDMXControlTypeID();
        } else if (this.m_HasDimmerSubstituteLinked) {
            object = this.m_SyncDevice;
            synchronized (object) {
                for (int intDMXControlComponent = 0; intDMXControlComponent < this.m_DMXControlComponents.size(); ++intDMXControlComponent) {
                    DMXControlComponent o_DMXControlComponent = (DMXControlComponent)this.m_DMXControlComponents.get(intDMXControlComponent);
                    if (o_DMXControlComponent == null || !o_DMXControlComponent.getIsDimmerSubstitute()) continue;
                    this.m_DMXControlDimmer_Substitutes.add(o_DMXControlComponent);
                    this.m_DMXControlDimmer_Substitutes_ControlTypeIDs.add(o_DMXControlComponent.getDMXControlTypeID());
                }
            }
        }
        return this.m_Dimmable;
    }

    public boolean getIsDimmable() {
        return this.m_Dimmable;
    }

    public DMXControlComponent getDMXControlComponent_Dimmer() {
        return this.m_DMXControlDimmer;
    }

    public boolean isDimmer_DMXControlTypeID(String p_DMXControlTypeID) {
        if (p_DMXControlTypeID == null) {
            return false;
        }
        if (this.m_DMXControlDimmer_ControlTypeID == null) {
            return false;
        }
        return this.m_DMXControlDimmer_ControlTypeID.equals(p_DMXControlTypeID);
    }

    public int getDMXControlComponent_Dimmer_Substitutes_Count() {
        return this.m_DMXControlDimmer_Substitutes.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DMXControlComponent getDMXControlComponent_Dimmer_Substitute(int p_Index) {
        Object object = this.m_SyncDevice;
        synchronized (object) {
            if (p_Index < 0) {
                return null;
            }
            if (p_Index >= this.m_DMXControlDimmer_Substitutes.size()) {
                return null;
            }
            try {
                return this.m_DMXControlDimmer_Substitutes.get(p_Index);
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDimmerSubstitute_DMXControlTypeID(String p_DMXControlTypeID) {
        if (p_DMXControlTypeID == null) {
            return false;
        }
        Object object = this.m_SyncDevice;
        synchronized (object) {
            if (this.m_DMXControlDimmer_Substitutes_ControlTypeIDs.size() <= 0) {
                return false;
            }
            return this.m_DMXControlDimmer_Substitutes_ControlTypeIDs.contains(p_DMXControlTypeID);
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean refreshIsOn() {
        boolean boolIsOn = false;
        boolean boolIsOn_Old = this.m_IsOn;
        double doubleValueDimmer = 0.0;
        if (this.m_DMXControlDimmer != null) {
            doubleValueDimmer = this.getIsOn(this.m_DMXControlDimmer);
            if (doubleValueDimmer > 0.0) {
                boolIsOn = true;
            }
        } else if (this.m_DMXControlDimmer_Substitutes.size() > 0) {
            double doubleValue = 0.0;
            Object object = this.m_SyncDevice;
            synchronized (object) {
                for (int intControl = 0; intControl < this.m_DMXControlDimmer_Substitutes.size(); ++intControl) {
                    DMXControlComponent o_DMXControlComponent = this.m_DMXControlDimmer_Substitutes.get(intControl);
                    doubleValue = this.getIsOn(o_DMXControlComponent);
                    if (!(doubleValue > 0.0)) continue;
                    doubleValueDimmer += doubleValue;
                    boolIsOn = true;
                }
                doubleValueDimmer /= (double)this.m_DMXControlDimmer_Substitutes.size();
            }
        }
        if (this.m_DimmerValue != doubleValueDimmer) {
            this.m_IsOn = boolIsOn;
            this.m_DimmerValue = doubleValueDimmer;
            for (int intSector = 0; intSector < this.m_InternalSectors.size(); ++intSector) {
                InternalSector o_InternalSector = this.getInternalSector(intSector);
                if (o_InternalSector == null) continue;
                s_DMXDeviceTableModel.changedElement(o_InternalSector);
            }
            if (boolIsOn_Old != this.m_IsOn) {
                // empty if block
            }
        }
        return boolIsOn;
    }

    public boolean getDimmerIsOn() {
        return this.m_IsOn;
    }

    public double getDimmerValue() {
        return this.m_DimmerValue;
    }

    public double getIsOn(DMXControlComponent p_DMXControlComponent) {
        if (p_DMXControlComponent == null) {
            return 0.0;
        }
        ArrayList<DMXControlComponent.DeviceControlLink> o_DeviceControlLinks = p_DMXControlComponent.getDMXControlType().getDeviceControlLinks();
        double doubleValue = 0.0;
        for (int intLink = 0; intLink < o_DeviceControlLinks.size(); ++intLink) {
            DMXControlComponent.DeviceControlLink o_DeviceControlLink = o_DeviceControlLinks.get(intLink);
            if (o_DeviceControlLink == null || o_DeviceControlLink.getDMXControlComponent() != p_DMXControlComponent) continue;
            doubleValue += (double)o_DeviceControlLink.getValueInternalChannels_DMXChannels();
        }
        if (o_DeviceControlLinks.size() > 0) {
            doubleValue /= (double)o_DeviceControlLinks.size();
        }
        return doubleValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean refreshIsOn_EditMode() {
        boolean boolIsOn = false;
        boolean boolIsOn_Old = this.m_IsOn_EditMode;
        double doubleValueDimmer = 0.0;
        if (this.m_DMXControlDimmer != null) {
            doubleValueDimmer = this.getIsOn_EditMode(this.m_DMXControlDimmer);
            if (doubleValueDimmer > 0.0) {
                boolIsOn = true;
            }
        } else if (this.m_DMXControlDimmer_Substitutes.size() > 0) {
            double doubleValue = 0.0;
            Object object = this.m_SyncDevice;
            synchronized (object) {
                for (int intControl = 0; intControl < this.m_DMXControlDimmer_Substitutes.size(); ++intControl) {
                    DMXControlComponent o_DMXControlComponent = this.m_DMXControlDimmer_Substitutes.get(intControl);
                    doubleValue = this.getIsOn_EditMode(o_DMXControlComponent);
                    if (!(doubleValue > 0.0)) continue;
                    doubleValueDimmer += doubleValue;
                    boolIsOn = true;
                }
                doubleValueDimmer /= (double)this.m_DMXControlDimmer_Substitutes.size();
            }
        }
        if (this.m_DimmerValue_EditMode != doubleValueDimmer) {
            this.m_IsOn_EditMode = boolIsOn;
            this.m_DimmerValue_EditMode = doubleValueDimmer;
            for (int intSector = 0; intSector < this.m_InternalSectors.size(); ++intSector) {
                InternalSector o_InternalSector = this.getInternalSector(intSector);
                if (o_InternalSector == null) continue;
                s_DMXDeviceTableModel.changedElement(o_InternalSector);
            }
            this.fireDimmerValue();
        }
        return boolIsOn;
    }

    public boolean getDimmerIsOn_EditMode() {
        return this.m_IsOn_EditMode;
    }

    public double getDimmerValue_EditMode() {
        return this.m_DimmerValue_EditMode;
    }

    public double getIsOn_EditMode(DMXControlComponent p_DMXControlComponent) {
        if (p_DMXControlComponent == null) {
            return 0.0;
        }
        ArrayList<DMXControlComponent.DeviceControlLink> o_DeviceControlLinks = p_DMXControlComponent.getDMXControlType().getDeviceControlLinks();
        double doubleValue = 0.0;
        for (int intLink = 0; intLink < o_DeviceControlLinks.size(); ++intLink) {
            DMXControlComponent.DeviceControlLink o_DeviceControlLink = o_DeviceControlLinks.get(intLink);
            if (o_DeviceControlLink == null || o_DeviceControlLink.getDMXControlComponent() != p_DMXControlComponent) continue;
            doubleValue += (double)o_DeviceControlLink.getValueInternalChannels_EditMode();
        }
        if (o_DeviceControlLinks.size() > 0) {
            doubleValue /= (double)o_DeviceControlLinks.size();
        }
        return doubleValue;
    }

    public long getMinValue(String p_DMXControlDescriptionID, int p_Control, int p_Dimension, DMXScene p_DMXScene) {
        if (p_DMXScene == null) {
            return Integer.MIN_VALUE;
        }
        long longMinValue = (long)p_DMXScene.getMinValue(this, p_DMXControlDescriptionID, p_Control, p_Dimension);
        if (longMinValue <= 0L) {
            // empty if block
        }
        return longMinValue;
    }

    public long getMaxValue(String p_DMXControlDescriptionID, int p_Control, int p_Dimension, DMXScene p_DMXScene) {
        if (p_DMXScene == null) {
            return Integer.MIN_VALUE;
        }
        long longMaxValue = (long)p_DMXScene.getMaxValue(this, p_DMXControlDescriptionID, p_Control, p_Dimension);
        if (longMaxValue <= 0L) {
            // empty if block
        }
        return longMaxValue;
    }

    public Image getDeviceImage() {
        DMXDeviceType o_DMXDeviceType = this.m_DMXDeviceType;
        if (o_DMXDeviceType == null) {
            return null;
        }
        return o_DMXDeviceType.getDeviceImage();
    }

    public Icon getDeviceIcon() {
        DMXDeviceType o_DMXDeviceType = this.m_DMXDeviceType;
        if (o_DMXDeviceType == null) {
            return null;
        }
        return o_DMXDeviceType.getDeviceIcon();
    }

    public Point getStageViewPosition() {
        return this.m_StageViewPosition;
    }

    public void setStageViewPosition(int p_StageViewPositionX, int p_StageViewPositionY) {
        if (p_StageViewPositionX == this.m_StageViewPosition.x && p_StageViewPositionY == this.m_StageViewPosition.y) {
            return;
        }
        Point oldValue = new Point();
        oldValue.x = this.m_StageViewPosition.x;
        oldValue.y = this.m_StageViewPosition.y;
        this.m_StageViewPosition.x = p_StageViewPositionX;
        this.m_StageViewPosition.y = p_StageViewPositionY;
        this.m_PropertyChangeSupport.firePropertyChange(PROP_DMXDEVICE_STAGEVIEWPOSITION, oldValue, this.m_StageViewPosition);
    }

    public void setDMXAddress(int p_DMXDeviceSectorIndex, DMXUniverse p_DMXUniverse, int p_DMXStartAddress) {
        InternalSector o_InternalSector = this.getInternalSector(p_DMXDeviceSectorIndex);
        if (o_InternalSector == null) {
            return;
        }
        o_InternalSector.setDMXAddress(p_DMXUniverse, p_DMXStartAddress);
    }

    public void setDMXStartAddress(int p_DMXDeviceSectorIndex, int p_DMXStartAddress) {
        InternalSector o_InternalSector = this.getInternalSector(p_DMXDeviceSectorIndex);
        if (o_InternalSector == null) {
            return;
        }
        o_InternalSector.setDMXAddress(o_InternalSector.getDMXUniverse(), p_DMXStartAddress);
    }

    public int getDMXStartAddress(int p_DMXDeviceSectorIndex) {
        InternalSector o_InternalSector = this.getInternalSector(p_DMXDeviceSectorIndex);
        if (o_InternalSector == null) {
            return 0;
        }
        return o_InternalSector.getDMXStartAddress();
    }

    public DMXUniverse getDMXUniverse(int p_DMXDeviceSectorIndex) {
        InternalSector o_InternalSector = this.getInternalSector(p_DMXDeviceSectorIndex);
        if (o_InternalSector == null) {
            return null;
        }
        return o_InternalSector.getDMXUniverse();
    }

    public void setValidAddress(boolean p_ValidAddress) {
        if (this.m_ValidAddress == p_ValidAddress) {
            return;
        }
        boolean oldValue = this.m_ValidAddress;
        this.m_ValidAddress = p_ValidAddress;
        this.m_PropertyChangeSupport.firePropertyChange(PROP_DMXDEVICE_VALIDADDRESS, oldValue, this.m_ValidAddress);
    }

    public boolean getValidAddress() {
        return this.m_ValidAddress;
    }

    public void setDMXPowerSource(int p_DMXDeviceSectorIndex, DMXPowerSource p_DMXPowerSource) {
        InternalSector o_InternalSector = this.getInternalSector(p_DMXDeviceSectorIndex);
        if (o_InternalSector == null) {
            return;
        }
        o_InternalSector.setDMXPowerSource(p_DMXPowerSource);
    }

    public DMXPowerSource getDMXPowerSource(int p_DMXDeviceSectorIndex) {
        InternalSector o_InternalSector = this.getInternalSector(p_DMXDeviceSectorIndex);
        if (o_InternalSector == null) {
            return null;
        }
        return o_InternalSector.getDMXPowerSource();
    }

    public String getChannelName(int p_DMXDeviceSectorIndex, int p_InternalChannel) {
        DMXDeviceType o_DMXDeviceType = this.m_DMXDeviceType;
        if (o_DMXDeviceType == null) {
            return "";
        }
        return o_DMXDeviceType.getChannelName(p_DMXDeviceSectorIndex, p_InternalChannel);
    }

    public int getChannelCount(int p_DMXDeviceSectorIndex) {
        DMXDeviceType o_DMXDeviceType = this.m_DMXDeviceType;
        if (o_DMXDeviceType == null) {
            return 0;
        }
        if (p_DMXDeviceSectorIndex < 0 || p_DMXDeviceSectorIndex >= o_DMXDeviceType.getDMXDeviceSectorCount()) {
            return 0;
        }
        DMXDeviceType.DMXDeviceSector o_DMXDeviceSector = o_DMXDeviceType.getDMXDeviceSector(p_DMXDeviceSectorIndex);
        return o_DMXDeviceSector.getChannelCount();
    }

    public DMXChannel getDMXChannel(int p_DMXDeviceSectorIndex, int p_InternalChannelNumber) {
        InternalSector o_InternalSector = this.getInternalSector(p_DMXDeviceSectorIndex);
        if (o_InternalSector == null) {
            return null;
        }
        return o_InternalSector.getDMXChannel(p_InternalChannelNumber);
    }

    public int getInternalChannelNumber(int p_DMXDeviceSectorIndex, DMXChannel p_DMXChannel) {
        if (p_DMXChannel == null) {
            return -1;
        }
        InternalSector o_InternalSector = this.getInternalSector(p_DMXDeviceSectorIndex);
        if (o_InternalSector == null) {
            return -1;
        }
        return o_InternalSector.getInternalChannelNumber(p_DMXChannel);
    }

    public void setValuesToDefault() {
        ControlObject o_ControlObject;
        DMXScene.DMXSceneDeviceValues o_DefaultDMXSceneDeviceValues = this.getDefaultDMXSceneDeviceValues();
        this.m_ControlFunctionChangedObjects.clear();
        for (int intDMXControl = this.m_DMXControlComponents.size() - 1; intDMXControl >= 0; --intDMXControl) {
            DMXControlComponent o_DMXControlComponent = (DMXControlComponent)this.m_DMXControlComponents.get(intDMXControl);
            if (o_DMXControlComponent == null || o_DMXControlComponent.getIsDisabledInFunctions()) continue;
            for (int intControl = 0; intControl < o_DMXControlComponent.getControlObjectCount(); ++intControl) {
                o_ControlObject = o_DMXControlComponent.getControlObject(intControl);
                if (o_ControlObject == null) continue;
                for (int intDimension = 0; intDimension < o_ControlObject.getControlDimensionCount(); ++intDimension) {
                    ControlObject.ControlDimension o_ControlDimension = o_ControlObject.getControlDimension(intDimension);
                    if (o_ControlDimension == null || !o_DMXControlComponent.getIsLinked(o_ControlDimension) && o_DMXControlComponent.getLinkedDMXDeviceCount() > 0) continue;
                    double doubleValue = o_DefaultDMXSceneDeviceValues.getValueDMXDevice(o_DMXControlComponent.getDMXControlType(), intControl, intDimension);
                    o_ControlDimension.setValue(doubleValue);
                    if (this.m_ControlFunctionChangedObjects.contains(o_ControlObject)) continue;
                    this.m_ControlFunctionChangedObjects.add(o_ControlObject);
                }
            }
        }
        for (int intControl = 0; intControl < this.m_ControlFunctionChangedObjects.size(); ++intControl) {
            o_ControlObject = this.m_ControlFunctionChangedObjects.get(intControl);
            o_ControlObject.setValueManuallyIsReady();
        }
    }

    public void setValues(int p_DMXDeviceSectorIndex, ArrayList<Integer> p_InternalChannels, ArrayList<Double> p_InternalChannelsNewValues, boolean p_WriteValuesToUniverse, boolean p_ManuallySet, boolean p_EditMode) {
        InternalSector o_InternalSector = this.getInternalSector(p_DMXDeviceSectorIndex);
        if (o_InternalSector == null) {
            return;
        }
        boolean boolChanged = o_InternalSector.setValues(p_InternalChannels, p_InternalChannelsNewValues, p_WriteValuesToUniverse, p_ManuallySet, p_EditMode);
        if (!boolChanged) {
            return;
        }
        this.validateValues(o_InternalSector, p_WriteValuesToUniverse, p_ManuallySet, p_EditMode);
    }

    public void validateValues(InternalSector p_InternalSector, boolean p_WriteValuesToUniverse, boolean p_ManuallySet, boolean p_EditMode) {
        for (int intDMXControlComponent = 0; intDMXControlComponent < this.m_DMXControlComponents.size(); ++intDMXControlComponent) {
            DMXControlComponent o_DMXControlComponent = this.getDMXControlComponent(intDMXControlComponent);
            if (o_DMXControlComponent == null) continue;
            o_DMXControlComponent.validateValuesDevice(p_ManuallySet, p_EditMode);
        }
        for (int intPanel = 0; intPanel < this.getDeviceSettingsPanelCount(); ++intPanel) {
            DMXControlComponent.DeviceSettingsPanel o_DeviceSettingsPanel = this.getDeviceSettingsPanel(intPanel);
            if (o_DeviceSettingsPanel == null) continue;
            o_DeviceSettingsPanel.validateValuesDevice(p_ManuallySet, p_EditMode);
        }
        if (!p_EditMode) {
            p_InternalSector.sendValuesToDMXChannels(p_ManuallySet);
            p_InternalSector.refreshDeviceControlLinks_ValueInternalChannels(p_ManuallySet);
            if (p_WriteValuesToUniverse) {
                p_InternalSector.sendValuesToDMXUniverse();
            }
        } else {
            p_InternalSector.refreshDeviceControlLinks_ValueInternalChannels_EditMode();
        }
    }

    public void refreshValueFactors() {
        for (int intSector = 0; intSector < this.m_InternalSectors.size(); ++intSector) {
            InternalSector o_InternalSector = this.getInternalSector(intSector);
            if (o_InternalSector == null) continue;
            o_InternalSector.refreshValueFactors();
        }
    }

    public boolean checkDeviceAddresses() {
        boolean boolValidAddress = true;
        for (int intSector = 0; intSector < this.m_InternalSectors.size(); ++intSector) {
            InternalSector o_InternalSector = this.getInternalSector(intSector);
            if (o_InternalSector == null || o_InternalSector.checkValidAddress()) continue;
            boolValidAddress = false;
        }
        this.setValidAddress(boolValidAddress);
        return boolValidAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof DMXDeviceType) {
            int intIndex;
            String stringPropertyName = evt.getPropertyName();
            if ("dmxdeviceTypeSector".equals(evt.getPropertyName())) {
                Object object;
                int intSectorIndex;
                InternalSector o_InternalSector;
                intIndex = ((IndexedPropertyChangeEvent)evt).getIndex();
                DMXDeviceType.DMXDeviceSector oldDeviceSector = (DMXDeviceType.DMXDeviceSector)evt.getOldValue();
                DMXDeviceType.DMXDeviceSector newDeviceSector = (DMXDeviceType.DMXDeviceSector)evt.getNewValue();
                if (oldDeviceSector != null && (o_InternalSector = this.getInternalSector(intSectorIndex = oldDeviceSector.getSectorIndex())) != null) {
                    object = this.m_SyncDevice;
                    synchronized (object) {
                        this.m_InternalSectors.remove(o_InternalSector);
                    }
                }
                if (newDeviceSector != null && (o_InternalSector = this.getInternalSector(intSectorIndex = newDeviceSector.getSectorIndex())) == null) {
                    o_InternalSector = new InternalSector(this, intSectorIndex);
                    object = this.m_SyncDevice;
                    synchronized (object) {
                        this.m_InternalSectors.add(o_InternalSector);
                    }
                }
                this.m_PropertyChangeSupport.fireIndexedPropertyChange(PROP_DMXDEVICE_INDEXED_DEVICESECTOR, intIndex, evt.getOldValue(), evt.getNewValue());
            }
            if ("dmxdeviceTypeDeviceChannelType".equals(stringPropertyName)) {
                InternalChannel o_InternalChannel;
                intIndex = ((IndexedPropertyChangeEvent)evt).getIndex();
                DMXDeviceType.DMXDeviceChannelType oldChannelType = (DMXDeviceType.DMXDeviceChannelType)evt.getOldValue();
                DMXDeviceType.DMXDeviceChannelType newChannelType = (DMXDeviceType.DMXDeviceChannelType)evt.getNewValue();
                if (oldChannelType != null) {
                    int intChannelIndex = oldChannelType.getChannelIndex();
                    o_InternalChannel = this.getInternalChannel(oldChannelType.getDMXDeviceSectorType().getSectorIndex(), intChannelIndex);
                    if (o_InternalChannel != null) {
                        o_InternalChannel.setDeviceChannelType(null);
                        InternalSector o_InternalSector = o_InternalChannel.getDMXDeviceInternalSector();
                        if (o_InternalSector != null) {
                            o_InternalChannel.close(false);
                            o_InternalSector.removeInternalChannel(o_InternalChannel);
                        }
                    }
                }
                if (newChannelType != null) {
                    int intChannelIndex = newChannelType.getChannelIndex();
                    o_InternalChannel = this.getInternalChannel(newChannelType.getDMXDeviceSectorType().getSectorIndex(), intChannelIndex);
                    if (o_InternalChannel != null) {
                        o_InternalChannel.setDeviceChannelType(newChannelType);
                    } else {
                        InternalSector o_InternalSector = this.getInternalSector(newChannelType.getDMXDeviceSectorType().getSectorIndex());
                        if (o_InternalSector != null) {
                            o_InternalChannel = new InternalChannel(o_InternalSector, intChannelIndex, newChannelType);
                            o_InternalSector.addInternalChannel(o_InternalChannel);
                        }
                    }
                }
                this.m_PropertyChangeSupport.fireIndexedPropertyChange(PROP_DMXDEVICE_INDEXED_DEVICECHANNELTYPE, intIndex, evt.getOldValue(), evt.getNewValue());
                this.refreshDeviceControlLinks_ValueInternalChannels_EditMode();
                this.refreshDeviceControlLinks_ValueInternalChannels(false);
                this.refreshDeviceControlLinks_ValueInterface();
            } else if ("dmxdevicechanneltypeChannelControlLink".equals(stringPropertyName)) {
                this.refreshDeviceControlLinks_TypeChanged();
            } else if ("dmxdeviceTypeManufactureerName".equals(stringPropertyName)) {
                this.refreshDeviceControlLinks_TypeChanged();
                this.refreshToolTipText();
                this.m_PropertyChangeSupport.firePropertyChange(PROP_DMXDEVICE_TYPEMANUFACTUREER, evt.getOldValue(), evt.getNewValue());
            } else if (PROP_DMXDEVICE_TYPENAME.equals(stringPropertyName)) {
                this.refreshDeviceControlLinks_TypeChanged();
                this.refreshToolTipText();
                this.m_PropertyChangeSupport.firePropertyChange(PROP_DMXDEVICE_TYPENAME, evt.getOldValue(), evt.getNewValue());
            } else if ("dmxdeviceTypeRemark".equals(stringPropertyName)) {
                this.refreshDeviceControlLinks_TypeChanged();
                this.refreshToolTipText();
                this.m_PropertyChangeSupport.firePropertyChange(PROP_DMXDEVICE_TYPEDESCRIPTION, evt.getOldValue(), evt.getNewValue());
            } else if (PROP_DMXDEVICE_TYPEIMAGE.equals(stringPropertyName)) {
                this.refreshDeviceControlLinks_TypeChanged();
                this.refreshToolTipText();
                this.m_PropertyChangeSupport.firePropertyChange(PROP_DMXDEVICE_TYPEIMAGE, evt.getOldValue(), evt.getNewValue());
            } else if (!"dmxdeviceTypeDMXControlType".equals(evt.getPropertyName())) {
                if ("dmxcontrolName".equals(evt.getPropertyName())) {
                    this.refreshDeviceControlLinks_TypeChanged();
                } else if ("controlName".equals(evt.getPropertyName())) {
                    this.refreshDeviceControlLinks_TypeChanged();
                } else if ("controlDimensionName".equals(evt.getPropertyName())) {
                    this.refreshDeviceControlLinks_TypeChanged();
                }
            }
        }
    }

    public void refreshDeviceControlLinks_ValueInternalChannels_EditMode() {
        for (int intSector = 0; intSector < this.m_InternalSectors.size(); ++intSector) {
            InternalSector o_InternalSector = this.getInternalSector(intSector);
            if (o_InternalSector == null) continue;
            o_InternalSector.refreshDeviceControlLinks_ValueInternalChannels_EditMode();
        }
    }

    public void refreshDeviceControlLinks_ValueInternalChannels(boolean p_ManuallySet) {
        for (int intSector = 0; intSector < this.m_InternalSectors.size(); ++intSector) {
            InternalSector o_InternalSector = this.getInternalSector(intSector);
            if (o_InternalSector == null) continue;
            o_InternalSector.refreshDeviceControlLinks_ValueInternalChannels(p_ManuallySet);
        }
    }

    public void refreshDeviceControlLinks_ValueInterface() {
        for (int intSector = 0; intSector < this.m_InternalSectors.size(); ++intSector) {
            InternalSector o_InternalSector = this.getInternalSector(intSector);
            if (o_InternalSector == null) continue;
            o_InternalSector.refreshDeviceControlLinks_ValueInterface();
        }
    }

    public void refreshDeviceControlLinks_TypeChanged() {
        for (int intSector = 0; intSector < this.m_InternalSectors.size(); ++intSector) {
            InternalSector o_InternalSector = this.getInternalSector(intSector);
            if (o_InternalSector == null) continue;
            o_InternalSector.refreshDeviceControlLinks_TypeChanged();
        }
    }

    public void addDeviceControlLink(DMXControlComponent.DeviceControlLink p_DeviceControlLink) {
        if (p_DeviceControlLink == null) {
            return;
        }
        for (int intByte = 0; intByte < p_DeviceControlLink.getByteResolution(); ++intByte) {
            int intInternalChannel = p_DeviceControlLink.getDeviceInternalChannel(intByte);
            InternalChannel o_InternalChannel = this.getInternalChannel(p_DeviceControlLink.getDMXDeviceSectorIndex(), intInternalChannel);
            if (o_InternalChannel == null) continue;
            o_InternalChannel.addDeviceControlLink(p_DeviceControlLink, intByte);
        }
    }

    public void removeDeviceControlLink(DMXControlComponent.DeviceControlLink p_DeviceControlLink) {
        if (p_DeviceControlLink == null) {
            return;
        }
        for (int intByte = 0; intByte < p_DeviceControlLink.getByteResolution(); ++intByte) {
            int intInternalChannel = p_DeviceControlLink.getDeviceInternalChannel(intByte);
            InternalChannel o_InternalChannel = this.getInternalChannel(p_DeviceControlLink.getDMXDeviceSectorIndex(), intInternalChannel);
            if (o_InternalChannel == null) continue;
            o_InternalChannel.removeDeviceControlLink(p_DeviceControlLink);
        }
    }

    public void addPropertyChangeListener(String p_PropertyName, PropertyChangeListener p_PropertyChangeListener) {
        if (p_PropertyChangeListener == null) {
            return;
        }
        if (p_PropertyName == null) {
            this.m_PropertyChangeSupport.addPropertyChangeListener(p_PropertyChangeListener);
        }
        this.m_PropertyChangeSupport.addPropertyChangeListener(p_PropertyName, p_PropertyChangeListener);
    }

    public void removePropertyChangeListener(String p_PropertyName, PropertyChangeListener p_PropertyChangeListener) {
        this.m_PropertyChangeSupport.removePropertyChangeListener(p_PropertyName, p_PropertyChangeListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
        if (p_PropertyChangeListener == null) {
            return;
        }
        this.m_PropertyChangeSupport.addPropertyChangeListener(p_PropertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
        this.m_PropertyChangeSupport.removePropertyChangeListener(p_PropertyChangeListener);
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.m_PropertyChangeSupport.getPropertyChangeListeners();
    }

    public PropertyChangeListener[] getPropertyChangeListeners(String p_PropertyName) {
        return this.m_PropertyChangeSupport.getPropertyChangeListeners(p_PropertyName);
    }

    public boolean hasListeners(String p_PropertyName) {
        return this.m_PropertyChangeSupport.hasListeners(p_PropertyName);
    }

    public void clearPropertyChangeListeners() {
        if (this.m_PropertyChangeSupport != null) {
            this.m_PropertyChangeSupport.clear();
        }
    }

    public SinglePropertyChangeSupport getPropertyChangeSupport() {
        return this.m_PropertyChangeSupport;
    }

    public String getStringSceneBridgeAdjusted() {
        if (!this.m_UsedInTimeline) {
            return "---";
        }
        if (!this.m_EditMode) {
            LiveShowSceneBridge o_LiveShowSceneBridge = this.getSceneBridge_Adjusted();
            if (o_LiveShowSceneBridge == null) {
                return "-";
            }
            return o_LiveShowSceneBridge.getName();
        }
        LiveShowSceneBridge o_LiveShowSceneBridge = this.getSceneBridge_AdjustedEditMode();
        if (o_LiveShowSceneBridge == null) {
            return "-";
        }
        return o_LiveShowSceneBridge.getName();
    }

    public void setSceneBridge_Adjusted(LiveShowDMXSceneBridge p_LiveShowDMXSceneBridge) {
        if (this.m_SceneBridge_Adjusted == p_LiveShowDMXSceneBridge) {
            return;
        }
        this.m_SceneBridge_AdjustedOld = this.m_SceneBridge_Adjusted;
        this.m_SceneBridge_Adjusted = p_LiveShowDMXSceneBridge;
        this.fireSceneBridgeAdjusted();
    }

    public void fireSceneBridgeAdjusted() {
        if (this.m_RunnableSceneBrideAdjusted == null) {
            this.m_RunnableSceneBrideAdjusted = new Runnable(){

                @Override
                public void run() {
                    DMXDevice.this.refreshToolTipText();
                    DMXDevice.this.m_PropertyChangeSupport.firePropertyChange(DMXDevice.PROP_DMXDEVICE_ADJUSTEDSCENEBRIDGE, DMXDevice.this.m_SceneBridge_AdjustedOld, DMXDevice.this.m_SceneBridge_Adjusted);
                }
            };
        }
        EventQueueHandler.invokeLater(this.m_RunnableSceneBrideAdjusted);
    }

    public void fireDimmerValue() {
        if (this.m_RunnableDimmerValue == null) {
            this.m_RunnableDimmerValue = new Runnable(){

                @Override
                public void run() {
                    DMXDevice.this.m_PropertyChangeSupport.firePropertyChange(DMXDevice.PROP_DMXDEVICE_DIMMERVALUE, false, true);
                }
            };
        }
        EventQueueHandler.invokeLater(this.m_RunnableDimmerValue);
    }

    public LiveShowSceneBridge getSceneBridge_Adjusted() {
        return this.m_SceneBridge_Adjusted;
    }

    public void setSceneBridge_AdjustedEditMode(LiveShowDMXSceneBridge p_LiveShowDMXSceneBridge) {
        if (this.m_SceneBridge_AdjustedEditMode == p_LiveShowDMXSceneBridge) {
            return;
        }
        this.m_SceneBridge_AdjustedEditModeOld = this.m_SceneBridge_AdjustedEditMode;
        this.m_SceneBridge_AdjustedEditMode = p_LiveShowDMXSceneBridge;
        this.fireSceneBridgeAdjustedEditMode();
    }

    public void fireSceneBridgeAdjustedEditMode() {
        if (this.m_RunnableSceneBrideAdjustedEditMode == null) {
            this.m_RunnableSceneBrideAdjustedEditMode = new Runnable(){

                @Override
                public void run() {
                    DMXDevice.this.refreshToolTipText();
                    DMXDevice.this.m_PropertyChangeSupport.firePropertyChange(DMXDevice.PROP_DMXDEVICE_ADJUSTEDSCENEBRIDGE, DMXDevice.this.m_SceneBridge_AdjustedEditModeOld, DMXDevice.this.m_SceneBridge_AdjustedEditMode);
                }
            };
        }
        EventQueueHandler.invokeLater(this.m_RunnableSceneBrideAdjustedEditMode);
    }

    public LiveShowSceneBridge getSceneBridge_AdjustedEditMode() {
        return this.m_SceneBridge_AdjustedEditMode;
    }

    public void setSceneBridge_Actual(LiveShowSceneBridge p_LiveShowSceneBridge) {
        this.m_SceneBridge_Actual = p_LiveShowSceneBridge;
        if (p_LiveShowSceneBridge == null) {
            return;
        }
    }

    @Override
    public String getRemark() {
        return null;
    }

    @Override
    public Icon getIcon() {
        return s_Icon;
    }

    @Override
    public boolean useDMXDevice(DMXDevice p_DMXDevice) {
        return p_DMXDevice == this;
    }

    public static DMXDevice getDMXDevice(String p_ID) {
        DMXDevice o_DMXDevice = null;
        o_DMXDevice = "TEST".equals(p_ID) ? LiveShowDMXSystem.getLiveShowDMXDeviceEditor().getDMXDeviceTest() : s_TreeModel_Device_Channels.getDMXDevice(p_ID);
        return o_DMXDevice;
    }

    public static DMXDevice getSameDMXDevice(DMXDevice p_DMXDevice) {
        if (p_DMXDevice == null) {
            return null;
        }
        DMXDeviceType o_DMXDeviceType = p_DMXDevice.getDMXDeviceType();
        if (o_DMXDeviceType == null) {
            return null;
        }
        for (int intDMXDevice = 0; intDMXDevice < s_TreeModel_Device_Channels.getDMXDeviceCount(); ++intDMXDevice) {
            DMXDevice o_DMXDevice_Exist = s_TreeModel_Device_Channels.getDMXDevice(intDMXDevice);
            if (o_DMXDevice_Exist == null) continue;
            DMXDeviceType o_DMXDeviceType_Exist = o_DMXDevice_Exist.getDMXDeviceType();
            if (o_DMXDevice_Exist == null || !o_DMXDeviceType_Exist.getID().equals(o_DMXDeviceType.getID()) || o_DMXDevice_Exist.getInternalSectorCount() != p_DMXDevice.getInternalSectorCount()) continue;
            boolean boolSame = true;
            for (int intSector = 0; intSector < o_DMXDevice_Exist.getInternalSectorCount(); ++intSector) {
                InternalSector o_InternalSector;
                InternalSector o_InternalSector_Exist = o_DMXDevice_Exist.getInternalSector(intSector);
                if (o_InternalSector_Exist == null || (o_InternalSector = p_DMXDevice.getInternalSector(intSector)) == null) continue;
                DMXUniverse o_DMXUniverse_Exist = o_InternalSector_Exist.getDMXUniverse();
                DMXUniverse o_DMXUniverse = o_InternalSector.getDMXUniverse();
                if (o_DMXUniverse_Exist == null) {
                    boolSame = false;
                    break;
                }
                if (o_DMXUniverse == null) {
                    boolSame = false;
                    break;
                }
                if (!o_DMXUniverse_Exist.getID().equals(o_DMXUniverse.getID())) {
                    boolSame = false;
                    break;
                }
                if (o_InternalSector_Exist.getDMXStartAddress() == o_InternalSector.getDMXStartAddress()) continue;
                boolSame = false;
                break;
            }
            if (!boolSame) continue;
            return o_DMXDevice_Exist;
        }
        return null;
    }

    public static TreeModel_Device_Channels getTreeModel_Device_Channels() {
        return s_TreeModel_Device_Channels;
    }

    public static TreeCellRenderer_Device_Channels getCellRenderer_Device_Channels() {
        return s_CellRenderer_Device_Channels;
    }

    public static TreeModel_DMXControlType_Devices getTreeModel_ControlTypes_Devices() {
        return s_TreeModel_DMXControlType_Devices;
    }

    public static TreeModel_Device_DMXControlTypes getTreeModel_Device_ControlTypess() {
        return s_TreeModel_Devices_DMXControlTypes;
    }

    public static TreeCellRenderer_Device_ControlTypes getCellRenderer_Device_ControlType() {
        return s_CellRenderer_DMXControlType_Devices;
    }

    public static boolean addDMXDevice(DMXDevice p_DMXDevice) {
        if (p_DMXDevice == null) {
            return false;
        }
        if (s_TreeModel_Device_Channels.getDMXDevice(p_DMXDevice.getID()) != null) {
            return true;
        }
        s_TreeModel_Device_Channels.addDMXDevice(p_DMXDevice);
        s_DMXDeviceTableModel.addDMXDevice(p_DMXDevice);
        s_TreeModel_DMXControlType_Devices.addDMXDevice(p_DMXDevice);
        s_TreeModel_Devices_DMXControlTypes.addDMXDevice(p_DMXDevice);
        s_DMXDeviceComboBoxModel.addDMXDevice(p_DMXDevice);
        DMXDevice.checkAllDevicesAddresses();
        DMXPresets.addDMXDevice(p_DMXDevice);
        for (int intInternalSector = 0; intInternalSector < p_DMXDevice.getInternalSectorCount(); ++intInternalSector) {
            DMXUniverse o_DMXUniverse = p_DMXDevice.getDMXUniverse(intInternalSector);
            if (o_DMXUniverse == null) continue;
            DMXUniverseInputPatch.eventDMXDeviceAddressChanged(o_DMXUniverse);
        }
        p_DMXDevice.setValuesToDefault();
        return true;
    }

    public static void removeDMXDevice(DMXDevice p_DMXDevice) {
        if (p_DMXDevice == null) {
            return;
        }
        boolean boolSolo = p_DMXDevice.getSolo();
        s_TreeModel_Device_Channels.removeDMXDevice(p_DMXDevice);
        s_DMXDeviceTableModel.removeDMXDevice(p_DMXDevice);
        s_TreeModel_DMXControlType_Devices.removeDMXDevice(p_DMXDevice);
        s_TreeModel_Devices_DMXControlTypes.removeDMXDevice(p_DMXDevice);
        s_DMXDeviceComboBoxModel.removeDMXDevice(p_DMXDevice);
        if (boolSolo) {
            DMXDevice.checkAllSolo(null);
            DMXDevice.refreshAllSolo();
        }
        EventQueueHandler.invokeLater(new Runnable(){

            @Override
            public void run() {
                DMXDevice.checkAllDevicesAddresses();
            }
        });
        DMXPresets.removeDMXDevice(p_DMXDevice);
        for (int intInternalSector = 0; intInternalSector < p_DMXDevice.getInternalSectorCount(); ++intInternalSector) {
            DMXUniverse o_DMXUniverse = p_DMXDevice.getDMXUniverse(intInternalSector);
            if (o_DMXUniverse == null) continue;
            DMXUniverseInputPatch.eventDMXDeviceAddressChanged(o_DMXUniverse);
        }
    }

    public static int getDMXDeviceCount() {
        return s_TreeModel_Device_Channels.getDMXDeviceCount();
    }

    public static DMXDevice getDMXDevice(int p_Index) {
        return s_TreeModel_Device_Channels.getDMXDevice(p_Index);
    }

    public static void checkAllDevicesAddresses() {
        for (int intDevice = 0; intDevice < DMXDevice.getDMXDeviceCount(); ++intDevice) {
            DMXDevice o_DMXDevice = DMXDevice.getDMXDevice(intDevice);
            DMXDevice.checkDeviceAddresses(o_DMXDevice);
        }
    }

    public static boolean checkDeviceAddresses(DMXDevice p_DMXDevice) {
        if (p_DMXDevice == null) {
            return false;
        }
        return p_DMXDevice.checkDeviceAddresses();
    }

    public static void checkAllSolo(DMXDevice p_DMXDeviceChanged) {
        boolean boolSoloOn = false;
        if (p_DMXDeviceChanged != null && p_DMXDeviceChanged.getSolo()) {
            boolSoloOn = true;
        } else {
            boolSoloOn = false;
            for (int intDevice = 0; intDevice < s_TreeModel_Device_Channels.getDMXDeviceCount(); ++intDevice) {
                DMXDevice o_DMXDevice = s_TreeModel_Device_Channels.getDMXDevice(intDevice);
                if (o_DMXDevice == null || !o_DMXDevice.getSolo()) continue;
                boolSoloOn = true;
                break;
            }
        }
        s_SoloOn = boolSoloOn;
    }

    public static void refreshAllSolo() {
        for (int intDevice = 0; intDevice < s_TreeModel_Device_Channels.getDMXDeviceCount(); ++intDevice) {
            DMXDevice o_DMXDevice = s_TreeModel_Device_Channels.getDMXDevice(intDevice);
            if (o_DMXDevice == null) continue;
            o_DMXDevice.refreshSolo();
            o_DMXDevice.refreshDeviceControlLinks_ValueInternalChannels(false);
        }
    }

    public static void setEditModeOn(boolean p_EditModeOn) {
        for (int intDMXDevice = 0; intDMXDevice < DMXDevice.getDMXDeviceCount(); ++intDMXDevice) {
            DMXDevice o_DMXDevice = DMXDevice.getDMXDevice(intDMXDevice);
            if (o_DMXDevice == null) continue;
            o_DMXDevice.setEditMode(p_EditModeOn);
        }
    }

    public void setEditMode(boolean p_EditMode) {
        this.m_EditMode = p_EditMode;
        if (!this.m_EditMode) {
            this.refreshDeviceControlLinks_ValueInternalChannels(false);
        } else {
            this.refreshDeviceControlLinks_ValueInternalChannels_EditMode();
        }
    }

    public boolean getEditMode() {
        return this.m_EditMode;
    }

    public static DMXDeviceListModel getDMXDeviceListModel() {
        return s_DMXDeviceComboBoxModel;
    }

    public static DMXDeviceListRenderer getDMXDeviceListRenderer() {
        return s_DMXDeviceListRenderer;
    }

    public static DMXDeviceTableModel getTableModel() {
        return s_DMXDeviceTableModel;
    }

    public static class TreeSelectionModel_DMXControl_Device
    extends DefaultTreeSelectionModel
    implements TreeModelListener,
    TreeSelectionListener_DMXControlType_Device {
        private TreeModel_Devices m_DMXDeviceTreeModel;
        private ArrayList<TreeSelectionListener_DMXControlType_Device> m_TreeSelectionListeners;
        private ArrayList<TreePath> m_SelectedPaths;
        private ArrayList<TreePath> m_SelectedChangedPaths;
        private final Object m_SyncListener = new Object();

        public TreeSelectionModel_DMXControl_Device(TreeModel_Devices p_DMXDeviceTreeModel) {
            this.initMembers();
            this.m_DMXDeviceTreeModel = p_DMXDeviceTreeModel;
            this.m_DMXDeviceTreeModel.addTreeModelListener(this);
        }

        private void initMembers() {
            this.m_SelectedPaths = new ArrayList();
            this.m_SelectedChangedPaths = new ArrayList();
            super.setSelectionMode(4);
            this.m_TreeSelectionListeners = new ArrayList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            this.m_DMXDeviceTreeModel.removeTreeModelListener(this);
            Object object = this.m_SyncListener;
            synchronized (object) {
                if (this.m_TreeSelectionListeners != null) {
                    this.m_TreeSelectionListeners.clear();
                }
            }
        }

        @Override
        public void setSelectionMode(int mode) {
            super.setSelectionMode(4);
        }

        public void eventMouse(TreePath p_TreePath, MouseEvent p_MouseEvent) {
            if (p_TreePath == null) {
                return;
            }
            if (p_MouseEvent == null) {
                return;
            }
            int intPathCount = p_TreePath.getPathCount();
            if (intPathCount == 0) {
                return;
            }
            Object o_PathComponent = p_TreePath.getLastPathComponent();
            if (!(o_PathComponent instanceof TreeNode_ControlType_Device)) {
                return;
            }
            TreeNode_ControlType_Device o_TreeNode = (TreeNode_ControlType_Device)o_PathComponent;
            this.toggleSelection(o_TreeNode);
        }

        public void toggleSelection(TreeNode_ControlType_Device p_TreeNode_ControlType_Device) {
            if (p_TreeNode_ControlType_Device == null) {
                return;
            }
            TreePath o_TreePath = this.m_DMXDeviceTreeModel.getTreePathToRoot(p_TreeNode_ControlType_Device);
            if (p_TreeNode_ControlType_Device.getSourceObject() instanceof TreeSource_DMXControlType_Device) {
                if (p_TreeNode_ControlType_Device.getSelectionFlag() == 0) {
                    this.addSelection(o_TreePath);
                } else {
                    p_TreeNode_ControlType_Device.setSelectionFlag(0);
                    this.removeSelection(o_TreePath);
                }
            } else if (p_TreeNode_ControlType_Device.getSourceObject() instanceof TreeSource_DMXControlType || p_TreeNode_ControlType_Device.getSourceObject() instanceof TreeSource_DMXDevice) {
                int intNewSelectionFlag = 0;
                switch (p_TreeNode_ControlType_Device.getSelectionFlag()) {
                    case 0: {
                        intNewSelectionFlag = 1;
                        break;
                    }
                    case 2: {
                        intNewSelectionFlag = 1;
                        break;
                    }
                    case 1: {
                        intNewSelectionFlag = 0;
                    }
                }
                ArrayList<TreeNode_ControlType_Device<?>> o_Children = p_TreeNode_ControlType_Device.getChildren();
                for (int intChild = 0; intChild < o_Children.size(); ++intChild) {
                    TreeNode_ControlType_Device<?> o_ChildNode = o_Children.get(intChild);
                    if (o_ChildNode == null || o_ChildNode.getSelectionFlag() == intNewSelectionFlag) continue;
                    TreePath o_TreePathChild = this.m_DMXDeviceTreeModel.getTreePathToRoot(o_ChildNode);
                    if (intNewSelectionFlag == 0) {
                        this.removeSelection(o_TreePathChild);
                        continue;
                    }
                    this.addSelection(o_TreePathChild);
                }
                p_TreeNode_ControlType_Device.setSelectionFlag(intNewSelectionFlag);
            }
        }

        private void checkDMXControlTypeClassNodeSelection(TreePath p_TreePath) {
            if (p_TreePath == null) {
                return;
            }
            Object o_LastPathComponent = p_TreePath.getLastPathComponent();
            if (!(o_LastPathComponent instanceof TreeNode_ControlType_Device)) {
                return;
            }
            TreeNode_ControlType_Device o_DeviceTreeNode_DMXControl = (TreeNode_ControlType_Device)o_LastPathComponent;
            if (o_DeviceTreeNode_DMXControl == null) {
                return;
            }
            ArrayList<TreeNode_ControlType_Device<?>> o_Children = o_DeviceTreeNode_DMXControl.getChildren();
            boolean boolSelected = false;
            boolean boolNotSelected = false;
            for (int intChild = 0; intChild < o_Children.size(); ++intChild) {
                TreeNode_ControlType_Device<?> o_ChildNode = o_Children.get(intChild);
                if (o_ChildNode == null) continue;
                if (o_ChildNode.getSelectionFlag() == 1) {
                    boolSelected = true;
                    continue;
                }
                boolNotSelected = true;
            }
            if (boolSelected && boolNotSelected) {
                o_DeviceTreeNode_DMXControl.setSelectionFlag(2);
            } else if (boolSelected) {
                o_DeviceTreeNode_DMXControl.setSelectionFlag(1);
            } else if (boolNotSelected) {
                o_DeviceTreeNode_DMXControl.setSelectionFlag(0);
            }
        }

        public void addSelection(TreePath p_TreePath) {
            if (p_TreePath == null) {
                return;
            }
            TreeNode_ControlType_Device o_TreeNode_DMXControl_Device = (TreeNode_ControlType_Device)p_TreePath.getLastPathComponent();
            this.m_SelectedChangedPaths.clear();
            if (o_TreeNode_DMXControl_Device.getSourceObject() instanceof TreeSource_DMXControlType_Device) {
                if (this.m_SelectedPaths.contains(p_TreePath)) {
                    return;
                }
                this.m_SelectedPaths.add(p_TreePath);
                o_TreeNode_DMXControl_Device.setSelectionFlag(1);
                this.m_SelectedChangedPaths.add(p_TreePath);
                this.checkDMXControlTypeClassNodeSelection(p_TreePath.getParentPath());
            } else if (o_TreeNode_DMXControl_Device.getSourceObject() instanceof TreeSource_DMXControlType || o_TreeNode_DMXControl_Device.getSourceObject() instanceof TreeSource_DMXDevice) {
                ArrayList<TreeNode_ControlType_Device<?>> o_Children = o_TreeNode_DMXControl_Device.getChildren();
                for (int intChild = 0; intChild < o_Children.size(); ++intChild) {
                    TreeNode o_ChildNode_DMXControl_Device = o_TreeNode_DMXControl_Device.getChildAt(intChild);
                    if (o_ChildNode_DMXControl_Device == null) continue;
                    ((TreeNode_ControlType_Device)o_ChildNode_DMXControl_Device).setSelectionFlag(1);
                    TreePath o_ChildTreePath = this.m_DMXDeviceTreeModel.getTreePathToRoot((TreeNode_ControlType_Device)o_ChildNode_DMXControl_Device);
                    if (this.m_SelectedPaths.contains(o_ChildTreePath)) continue;
                    this.m_SelectedPaths.add(o_ChildTreePath);
                    this.m_SelectedChangedPaths.add(o_ChildTreePath);
                }
                this.checkDMXControlTypeClassNodeSelection(p_TreePath);
            }
            if (this.m_SelectedChangedPaths.size() > 0) {
                this.notifySelectionChanged(this.m_SelectedChangedPaths, true);
            }
        }

        public void removeSelection(TreePath p_TreePath) {
            if (p_TreePath == null) {
                return;
            }
            TreeNode_ControlType_Device o_TreeNode_DMXControl_Device = (TreeNode_ControlType_Device)p_TreePath.getLastPathComponent();
            this.m_SelectedChangedPaths.clear();
            if (o_TreeNode_DMXControl_Device.getSourceObject() instanceof TreeSource_DMXControlType_Device) {
                if (!this.m_SelectedPaths.contains(p_TreePath)) {
                    return;
                }
                this.m_SelectedPaths.remove(p_TreePath);
                this.m_SelectedChangedPaths.add(p_TreePath);
                o_TreeNode_DMXControl_Device.setSelectionFlag(0);
                this.checkDMXControlTypeClassNodeSelection(p_TreePath.getParentPath());
            } else if (o_TreeNode_DMXControl_Device.getSourceObject() instanceof TreeSource_DMXControlType || o_TreeNode_DMXControl_Device.getSourceObject() instanceof TreeSource_DMXDevice) {
                ArrayList<TreeNode_ControlType_Device<?>> o_Children = o_TreeNode_DMXControl_Device.getChildren();
                for (int intChild = 0; intChild < o_Children.size(); ++intChild) {
                    TreeNode o_ChildNode_DMXControl_Device = o_TreeNode_DMXControl_Device.getChildAt(intChild);
                    if (o_ChildNode_DMXControl_Device == null) continue;
                    ((TreeNode_ControlType_Device)o_ChildNode_DMXControl_Device).setSelectionFlag(0);
                    TreePath o_ChildTreePath = this.m_DMXDeviceTreeModel.getTreePathToRoot((TreeNode_ControlType_Device)o_ChildNode_DMXControl_Device);
                    if (!this.m_SelectedPaths.contains(o_ChildTreePath)) continue;
                    this.m_SelectedPaths.remove(o_ChildTreePath);
                    this.m_SelectedChangedPaths.add(o_ChildTreePath);
                }
                this.checkDMXControlTypeClassNodeSelection(p_TreePath);
            }
            if (this.m_SelectedChangedPaths.size() > 0) {
                this.notifySelectionChanged(this.m_SelectedChangedPaths, false);
            }
        }

        @Override
        public void clearSelection() {
            for (int intPath = this.m_SelectedPaths.size() - 1; intPath >= 0; --intPath) {
                TreePath o_TreePath = this.m_SelectedPaths.get(intPath);
                this.removeSelection(o_TreePath);
            }
            this.m_SelectedPaths.clear();
        }

        public void clearSelection(DMXDevice p_DMXDevice) {
            if (p_DMXDevice == null) {
                return;
            }
            for (int intPath = this.m_SelectedPaths.size() - 1; intPath >= 0; --intPath) {
                TreeSource_DMXControlType_Device o_TreeSource_DMXControlTypeDevice;
                Object o_TreeSource;
                TreeNode_ControlType_Device o_DMXDeviceTreeNode_DMXControl;
                TreePath o_TreePath = this.m_SelectedPaths.get(intPath);
                if (o_TreePath == null || (o_DMXDeviceTreeNode_DMXControl = (TreeNode_ControlType_Device)o_TreePath.getLastPathComponent()) == null || (o_TreeSource = o_DMXDeviceTreeNode_DMXControl.getSourceObject()) == null || !(o_TreeSource instanceof TreeSource_DMXControlType_Device) || (o_TreeSource_DMXControlTypeDevice = (TreeSource_DMXControlType_Device)o_TreeSource).getDMXDevice() != p_DMXDevice) continue;
                this.removeSelection(o_TreePath);
            }
        }

        public ArrayList<TreePath> getSelection() {
            return this.m_SelectedPaths;
        }

        @Override
        public void setSelectionPath(TreePath path) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifySelectionChanged(ArrayList<TreePath> p_SelectedPaths, boolean p_Added) {
            ArrayList<TreeSelectionListener_DMXControlType_Device> o_DMXTreeSelectionListener_DMXControls;
            Object object = this.m_SyncListener;
            synchronized (object) {
                o_DMXTreeSelectionListener_DMXControls = new ArrayList<TreeSelectionListener_DMXControlType_Device>(this.m_TreeSelectionListeners.size());
                o_DMXTreeSelectionListener_DMXControls.addAll(this.m_TreeSelectionListeners);
            }
            for (int intListener = 0; intListener < o_DMXTreeSelectionListener_DMXControls.size(); ++intListener) {
                TreeSelectionListener_DMXControlType_Device o_TreeSelectionListener = (TreeSelectionListener_DMXControlType_Device)o_DMXTreeSelectionListener_DMXControls.get(intListener);
                o_TreeSelectionListener.eventSelectionChanged(p_SelectedPaths, p_Added);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addTreeSelectionListener(TreeSelectionListener_DMXControlType_Device p_TreeSelectionListener) {
            if (p_TreeSelectionListener == null) {
                return;
            }
            Object object = this.m_SyncListener;
            synchronized (object) {
                if (this.m_TreeSelectionListeners.contains(p_TreeSelectionListener)) {
                    return;
                }
                this.m_TreeSelectionListeners.add(p_TreeSelectionListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeTreeSelectionListener(TreeSelectionListener_DMXControlType_Device p_TreeSelectionListener) {
            if (p_TreeSelectionListener == null) {
                return;
            }
            Object object = this.m_SyncListener;
            synchronized (object) {
                if (!this.m_TreeSelectionListeners.contains(p_TreeSelectionListener)) {
                    return;
                }
                this.m_TreeSelectionListeners.remove(p_TreeSelectionListener);
            }
        }

        @Override
        public void treeNodesChanged(TreeModelEvent e) {
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e) {
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
            this.clearSelection();
        }

        @Override
        public void treeStructureChanged(TreeModelEvent e) {
        }

        @Override
        public void eventSelectionChanged(ArrayList<TreePath> p_SelectedPaths, boolean p_Added) {
            if (p_SelectedPaths == null) {
                return;
            }
            ArrayList<TreePath> o_SelectedPaths = new ArrayList<TreePath>(p_SelectedPaths.size());
            o_SelectedPaths.addAll(p_SelectedPaths);
            for (int intPath = 0; intPath < o_SelectedPaths.size(); ++intPath) {
                TreeSource_DMXControlType_Device o_TreeSource_DMXControlType_Device;
                TreeNode_ControlType_Device o_TreeNode_Select;
                TreeNode_ControlType_Device o_TreeNode_ControlType_Device;
                TreePath o_TreePath = (TreePath)o_SelectedPaths.get(intPath);
                if (o_TreePath == null || (o_TreeNode_ControlType_Device = (TreeNode_ControlType_Device)o_TreePath.getLastPathComponent()) == null || !(o_TreeNode_ControlType_Device.getSourceObject() instanceof TreeSource_DMXControlType_Device) || (o_TreeNode_Select = this.m_DMXDeviceTreeModel.getTreeNode((o_TreeSource_DMXControlType_Device = (TreeSource_DMXControlType_Device)o_TreeNode_ControlType_Device.getSourceObject()).getDMXDevice(), o_TreeSource_DMXControlType_Device.getDMXControlType())) == null) continue;
                TreePath o_TreePath_Select = this.m_DMXDeviceTreeModel.getTreePathToRoot(o_TreeNode_Select);
                if (p_Added) {
                    this.addSelection(o_TreePath_Select);
                    continue;
                }
                this.removeSelection(o_TreePath_Select);
            }
        }
    }

    public static interface TreeSelectionListener_DMXControlType_Device {
        public void eventSelectionChanged(ArrayList<TreePath> var1, boolean var2);
    }

    public static class TreeCellRenderer_Device_ControlTypes
    extends JPanel
    implements TreeCellRenderer {
        public static int LABELNAME_WIDTH = 80;
        private JCheckBox_MultiSelection jCheckBox_Selection;
        private JLabelBackground jLabelIcon;
        private JLabel jLabelControlName;
        private JLabel jLabelDeviceName;
        private JLabel jLabelSectorName;
        private ArrayList<Integer> m_SectorList;

        public TreeCellRenderer_Device_ControlTypes() {
            this.initMembers();
            this.initComponents();
        }

        private void initMembers() {
            this.m_SectorList = new ArrayList();
        }

        private void initComponents() {
            this.setLayout(new GridBagLayout());
            this.setOpaque(false);
            this.setPreferredSize(new Dimension(48 + 3 * LABELNAME_WIDTH, 26));
            this.jCheckBox_Selection = new JCheckBox_MultiSelection();
            GridBagConstraints o_GridBagConstraints = new GridBagConstraints();
            o_GridBagConstraints.gridx = 0;
            o_GridBagConstraints.gridy = 0;
            this.add((Component)this.jCheckBox_Selection, o_GridBagConstraints);
            this.jLabelControlName = new JLabel();
            this.jLabelControlName.setMinimumSize(new Dimension(LABELNAME_WIDTH - 10, 25));
            this.jLabelControlName.setPreferredSize(new Dimension(LABELNAME_WIDTH - 10, 25));
            o_GridBagConstraints.gridx = 1;
            o_GridBagConstraints.gridy = 0;
            o_GridBagConstraints.weightx = 1.0;
            o_GridBagConstraints.weighty = 1.0;
            o_GridBagConstraints.fill = 1;
            o_GridBagConstraints.insets = new Insets(1, 1, 1, 1);
            this.add((Component)this.jLabelControlName, o_GridBagConstraints);
            this.jLabelControlName.setVisible(true);
            this.jLabelIcon = new JLabelBackground();
            this.jLabelIcon.setBackgroundStyle(3);
            this.jLabelIcon.setBackgroundOpaque(true);
            this.jLabelIcon.setMinimumSize(new Dimension(24, 24));
            this.jLabelIcon.setPreferredSize(new Dimension(24, 24));
            o_GridBagConstraints = new GridBagConstraints();
            o_GridBagConstraints.gridx = 2;
            o_GridBagConstraints.gridy = 0;
            o_GridBagConstraints.fill = 0;
            this.add((Component)this.jLabelIcon, o_GridBagConstraints);
            this.jLabelIcon.setVisible(true);
            this.jLabelDeviceName = new JLabel();
            this.jLabelDeviceName.setMinimumSize(new Dimension(LABELNAME_WIDTH - 10, 25));
            this.jLabelDeviceName.setPreferredSize(new Dimension(LABELNAME_WIDTH - 10, 25));
            o_GridBagConstraints.gridx = 3;
            o_GridBagConstraints.gridy = 0;
            o_GridBagConstraints.weightx = 1.0;
            o_GridBagConstraints.weighty = 1.0;
            o_GridBagConstraints.fill = 1;
            this.add((Component)this.jLabelDeviceName, o_GridBagConstraints);
            this.jLabelDeviceName.setVisible(true);
            this.jLabelSectorName = new JLabel();
            this.jLabelSectorName.setMinimumSize(new Dimension(LABELNAME_WIDTH, 25));
            this.jLabelSectorName.setPreferredSize(new Dimension(LABELNAME_WIDTH, 25));
            o_GridBagConstraints.gridx = 4;
            o_GridBagConstraints.gridy = 0;
            o_GridBagConstraints.weightx = 1.0;
            o_GridBagConstraints.weighty = 1.0;
            o_GridBagConstraints.fill = 1;
            this.add((Component)this.jLabelSectorName, o_GridBagConstraints);
            this.jLabelSectorName.setVisible(true);
            this.setVisible(true);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (!(value instanceof TreeNode_ControlType_Device)) {
                return this;
            }
            TreeNode_ControlType_Device o_DMXDeviceTreeNode_DMXControl = (TreeNode_ControlType_Device)value;
            Object o_SourceObject = o_DMXDeviceTreeNode_DMXControl.getSourceObject();
            Color o_Background = tree.getBackground();
            Color o_Foreground = UIManager.getColor("Tree.textForeground");
            Color o_Test = UIManager.getColor("Tree.foreground");
            if (selected) {
                if (tree.hasFocus()) {
                    o_Foreground = UIManager.getColor("Tree.selectionForeground");
                    o_Background = UIManager.getColor("Tree.selectionBackground");
                } else {
                    o_Foreground = UIManager.getColor("Tree.selectionInactiveForeground");
                    o_Background = UIManager.getColor("Tree.selectionInactiveBackground");
                }
            }
            this.jLabelIcon.setForeground(o_Foreground);
            this.jLabelIcon.setBackground(o_Background);
            this.jLabelControlName.setForeground(o_Foreground);
            this.jLabelControlName.setBackground(o_Background);
            this.jLabelSectorName.setForeground(o_Foreground);
            this.jLabelSectorName.setBackground(o_Background);
            this.jLabelDeviceName.setForeground(o_Foreground);
            this.jLabelDeviceName.setBackground(o_Background);
            if (o_SourceObject == null) {
                this.jCheckBox_Selection.setVisible(false);
                this.jLabelControlName.setVisible(true);
                this.jLabelIcon.setVisible(false);
                this.jLabelDeviceName.setVisible(false);
                this.jLabelSectorName.setVisible(false);
                this.jLabelControlName.setText("Fade");
                this.jLabelIcon.setBackgroundImage(null);
                this.jLabelIcon.setVisible(false);
                this.jLabelDeviceName.setText("");
                this.jLabelSectorName.setText("");
                this.jLabelIcon.setIcon(null);
            } else if (o_SourceObject instanceof TreeSource_DMXDevice) {
                TreeSource_DMXDevice o_TreeSource_DMXDevice = (TreeSource_DMXDevice)o_SourceObject;
                DMXDevice o_DMXDevice = o_TreeSource_DMXDevice.getDMXDevice();
                this.jCheckBox_Selection.setVisible(true);
                this.jLabelControlName.setVisible(false);
                this.jLabelIcon.setVisible(true);
                this.jLabelDeviceName.setVisible(true);
                this.jLabelSectorName.setVisible(true);
                this.jLabelIcon.setBackgroundImage(o_DMXDevice.getDeviceImage());
                this.jCheckBox_Selection.setSelection(o_DMXDeviceTreeNode_DMXControl.getSelectionFlag());
                this.jLabelControlName.setText("");
                this.jLabelDeviceName.setText(o_TreeSource_DMXDevice.getDMXDeviceName());
                this.jLabelSectorName.setText("");
            } else if (o_SourceObject instanceof TreeSource_DMXControlType) {
                this.jCheckBox_Selection.setVisible(true);
                this.jLabelControlName.setVisible(true);
                this.jLabelIcon.setVisible(false);
                this.jLabelDeviceName.setVisible(false);
                this.jLabelSectorName.setVisible(false);
                this.jLabelIcon.setBackgroundImage(null);
                this.jCheckBox_Selection.setSelection(o_DMXDeviceTreeNode_DMXControl.getSelectionFlag());
                TreeSource_DMXControlType o_TreeSource_DMXControlType = (TreeSource_DMXControlType)o_SourceObject;
                this.jLabelControlName.setText(o_TreeSource_DMXControlType.getDMXControlDescriptionName());
                this.jLabelDeviceName.setText("");
                this.jLabelSectorName.setText("");
            } else if (o_SourceObject instanceof TreeSource_DMXControlType_Device) {
                TreeSource_DMXControlType_Device o_TreeSource_DMXControlTypeDevice = (TreeSource_DMXControlType_Device)o_SourceObject;
                DMXControlComponent.DMXControlType o_DMXControlType = o_TreeSource_DMXControlTypeDevice.getDMXControlType();
                DMXDevice o_DMXDevice = o_TreeSource_DMXControlTypeDevice.getDMXDevice();
                this.jCheckBox_Selection.setVisible(true);
                this.jLabelControlName.setVisible(true);
                this.jLabelIcon.setVisible(true);
                this.jLabelDeviceName.setVisible(true);
                this.jLabelSectorName.setVisible(true);
                this.jCheckBox_Selection.setSelection(o_DMXDeviceTreeNode_DMXControl.getSelectionFlag());
                this.jLabelIcon.setBackgroundImage(o_DMXDevice.getDeviceImage());
                this.jLabelIcon.setVisible(true);
                this.jLabelControlName.setText(o_DMXControlType.getName());
                this.jLabelDeviceName.setText(o_DMXDevice.getName());
                this.m_SectorList.clear();
                StringBuilder stringSectors = new StringBuilder();
                stringSectors.append(DMXDeviceType.SECTORNAME);
                ArrayList<DMXControlComponent.DeviceControlLink> o_DeviceControlLinks = o_DMXControlType.getDeviceControlLinks();
                for (int intLink = 0; intLink < o_DeviceControlLinks.size(); ++intLink) {
                    int intSectorIndex;
                    DMXControlComponent.DeviceControlLink o_DeviceControlLink = o_DeviceControlLinks.get(intLink);
                    if (o_DeviceControlLink == null || this.m_SectorList.contains(intSectorIndex = o_DeviceControlLink.getDMXDeviceSectorIndex())) continue;
                    this.m_SectorList.add(intSectorIndex);
                    stringSectors.append(" ");
                    stringSectors.append(intSectorIndex + 1);
                }
                this.jLabelSectorName.setText(stringSectors.toString());
            }
            return this;
        }
    }

    public static class TreeModel_Device_DMXControlTypes
    implements TreeModel_Devices,
    PropertyChangeListener {
        public static final String PROP_DMXDEVICETREEMODEL_DEVICEADDED = "dmxdevicetreemodelDMXDeviceAdded";
        public static final String PROP_DMXDEVICETREEMODEL_DEVICEREMOVED = "dmxdevicetreemodelDMXDeviceRemoved";
        protected TreeNode_ControlType_Device m_Root;
        protected ArrayList<TreeModelListener> m_TreeModelListeners;
        protected ArrayList<DMXDevice> m_DMXDevices;
        protected SinglePropertyChangeSupport m_PropertyChangeSupport;
        private final Object m_SyncListeners = new Object();

        public TreeModel_Device_DMXControlTypes() {
            this.initMembers();
            this.m_Root = new TreeNode_ControlType_Device<Object>(null, this);
            this.m_TreeModelListeners = new ArrayList();
        }

        private void initMembers() {
            this.m_PropertyChangeSupport = new SinglePropertyChangeSupport(this);
            this.m_DMXDevices = new ArrayList();
        }

        public void addDMXDevice(DMXDevice p_DMXDevice) {
            if (p_DMXDevice == null) {
                return;
            }
            if (this.m_DMXDevices.contains(p_DMXDevice)) {
                return;
            }
            DMXDeviceType o_DMXDeviceType = p_DMXDevice.getDMXDeviceType();
            if (o_DMXDeviceType == null) {
                return;
            }
            this.m_DMXDevices.add(p_DMXDevice);
            p_DMXDevice.addPropertyChangeListener(this);
            TreeNode_ControlType_Device o_RootNode = (TreeNode_ControlType_Device)this.getRoot();
            TreeSource_DMXDevice o_TreeSource_DMXDevice = new TreeSource_DMXDevice(p_DMXDevice);
            TreeNode_ControlType_Device<TreeSource_DMXDevice> o_DMXDeviceNode = new TreeNode_ControlType_Device<TreeSource_DMXDevice>(o_TreeSource_DMXDevice, this);
            this.addChild(o_RootNode, o_DMXDeviceNode);
            for (int intDMXControlType = 0; intDMXControlType < o_DMXDeviceType.getDMXControlTypeCount(); ++intDMXControlType) {
                DMXControlComponent.DMXControlType o_DMXControlType = o_DMXDeviceType.getDMXControlType(intDMXControlType);
                TreeSource_DMXControlType_Device o_TreeSource_DMXControlTypeDevice = new TreeSource_DMXControlType_Device(o_DMXControlType, p_DMXDevice);
                TreeNode_ControlType_Device<TreeSource_DMXControlType_Device> o_TreeSource_DMXControlTypeDevice_Node = new TreeNode_ControlType_Device<TreeSource_DMXControlType_Device>(o_TreeSource_DMXControlTypeDevice, this);
                this.addChild(o_DMXDeviceNode, o_TreeSource_DMXControlTypeDevice_Node);
            }
            this.m_PropertyChangeSupport.firePropertyChange(PROP_DMXDEVICETREEMODEL_DEVICEADDED, null, p_DMXDevice);
        }

        public void removeDMXDevice(DMXDevice p_DMXDevice) {
            if (p_DMXDevice == null) {
                return;
            }
            if (!this.m_DMXDevices.contains(p_DMXDevice)) {
                return;
            }
            this.m_DMXDevices.remove(p_DMXDevice);
            DMXDeviceType o_DMXDeviceType = p_DMXDevice.getDMXDeviceType();
            if (o_DMXDeviceType == null) {
                return;
            }
            p_DMXDevice.removePropertyChangeListener(this);
            TreeNode_ControlType_Device o_RootNode = (TreeNode_ControlType_Device)this.getRoot();
            TreeNode_ControlType_Device<TreeSource_DMXDevice> o_TreeNode_DMXDevice = this.getTreenodeDMXDevice(p_DMXDevice);
            if (o_TreeNode_DMXDevice == null) {
                return;
            }
            ArrayList<TreeNode_ControlType_Device<?>> o_TreeNodes_DMXControlType = o_TreeNode_DMXDevice.getChildren();
            for (int intNode = o_TreeNodes_DMXControlType.size() - 1; intNode >= 0; --intNode) {
                TreeNode_ControlType_Device<?> o_TreeNode_DMXControlType = o_TreeNodes_DMXControlType.get(intNode);
                this.removeChild(o_TreeNode_DMXDevice, o_TreeNode_DMXControlType);
            }
            this.m_PropertyChangeSupport.firePropertyChange(PROP_DMXDEVICETREEMODEL_DEVICEREMOVED, p_DMXDevice, null);
        }

        public TreeNode_ControlType_Device<TreeSource_DMXDevice> getTreenodeDMXDevice(DMXDevice p_DMXDevice) {
            if (p_DMXDevice == null) {
                return null;
            }
            ArrayList<TreeNode_ControlType_Device<?>> o_TreeNodes_DMXDevice = this.m_Root.getChildren();
            for (int intNode = 0; intNode < o_TreeNodes_DMXDevice.size(); ++intNode) {
                DMXDevice o_DMXDevice;
                TreeSource_DMXDevice o_TreeSource_DMXDevice;
                TreeNode_ControlType_Device<TreeSource_DMXDevice> o_TreeNode_DMXDevice = o_TreeNodes_DMXDevice.get(intNode);
                if (o_TreeNode_DMXDevice == null || (o_TreeSource_DMXDevice = (TreeSource_DMXDevice)o_TreeNode_DMXDevice.getSourceObject()) == null || (o_DMXDevice = o_TreeSource_DMXDevice.getDMXDevice()) == null || !o_DMXDevice.getID().equals(p_DMXDevice.getID())) continue;
                return o_TreeNode_DMXDevice;
            }
            return null;
        }

        public TreeNode_ControlType_Device<TreeSource_DMXControlType_Device> getDMXControlTypeDeviceNode(DMXControlComponent.DMXControlType p_DMXControlType, TreeNode_ControlType_Device<?> p_TreeNodeDMXDevice) {
            ArrayList<TreeNode_ControlType_Device<?>> o_TreeNodes_DMXControlDevice = p_TreeNodeDMXDevice.getChildren();
            for (int intNode = 0; intNode < o_TreeNodes_DMXControlDevice.size(); ++intNode) {
                TreeSource_DMXControlType_Device o_TreeSource_DMXControlType_Device;
                TreeNode_ControlType_Device<TreeSource_DMXControlType_Device> o_TreeNode_DMXControlType = o_TreeNodes_DMXControlDevice.get(intNode);
                if (o_TreeNode_DMXControlType == null || (o_TreeSource_DMXControlType_Device = (TreeSource_DMXControlType_Device)o_TreeNode_DMXControlType.getSourceObject()) == null || o_TreeSource_DMXControlType_Device.getDMXControlType() != p_DMXControlType) continue;
                return o_TreeNode_DMXControlType;
            }
            return null;
        }

        @Override
        public Object getRoot() {
            return this.m_Root;
        }

        public void addChild(TreeNode_ControlType_Device p_Parent, TreeNode_ControlType_Device p_Child) {
            if (p_Parent == null) {
                return;
            }
            if (p_Child == null) {
                return;
            }
            if (p_Parent.getSourceObject() == null) {
                p_Parent.addChild_SortedDevice(p_Child);
            } else {
                p_Parent.addChild(p_Child);
            }
            Object[] o_ParentPathToRoot = (TreeNode_ControlType_Device[])this.getPathToRoot(p_Parent);
            int[] o_Indexs = new int[1];
            Object[] o_Childs = new Object[1];
            o_Indexs[0] = p_Parent.getIndex(p_Child);
            o_Childs[0] = p_Child;
            if (o_Indexs[0] != -1) {
                if (p_Child.getSourceObject() instanceof TreeSource_DMXControlType_Device) {
                    TreeSource_DMXControlType_Device o_TreeSource_DMXControlTypeDevice = (TreeSource_DMXControlType_Device)p_Child.getSourceObject();
                    o_TreeSource_DMXControlTypeDevice.getDMXDevice().addPropertyChangeListener(p_Child);
                }
                this.fireTreeNodesInserted(this, o_ParentPathToRoot, o_Indexs, o_Childs);
            }
        }

        public void removeChild(TreeNode_ControlType_Device p_Parent, TreeNode_ControlType_Device p_Child) {
            if (p_Parent == null) {
                return;
            }
            if (p_Child == null) {
                return;
            }
            int[] o_Indexs = new int[1];
            Object[] o_Childs = new Object[1];
            o_Indexs[0] = p_Parent.getIndex(p_Child);
            o_Childs[0] = p_Child;
            if (o_Indexs[0] != -1) {
                if (p_Child.getSourceObject() instanceof TreeSource_DMXControlType_Device) {
                    TreeSource_DMXControlType_Device o_TreeSource_DMXControlTypeDevice = (TreeSource_DMXControlType_Device)p_Child.getSourceObject();
                    o_TreeSource_DMXControlTypeDevice.getDMXDevice().removePropertyChangeListener(p_Child);
                }
                Object[] o_ParentPathToRoot = (TreeNode_ControlType_Device[])this.getPathToRoot(p_Parent);
                p_Parent.removeChild(p_Child);
                this.fireTreeNodesRemoved(this, o_ParentPathToRoot, o_Indexs, o_Childs);
                this.invokeTreeNodeChanged(p_Parent);
            }
            if (p_Parent != this.getRoot() && p_Parent.getChildCount() <= 0) {
                this.removeChild((TreeNode_ControlType_Device)p_Parent.getParent(), p_Parent);
            }
        }

        @Override
        public TreeNode_ControlType_Device getChild(Object parent, int index) {
            if (parent instanceof TreeNode_ControlType_Device) {
                return ((TreeNode_ControlType_Device)parent).getChildAt(index);
            }
            return null;
        }

        @Override
        public int getChildCount(Object parent) {
            if (parent instanceof TreeNode_ControlType_Device) {
                return ((TreeNode_ControlType_Device)parent).getChildCount();
            }
            return 0;
        }

        @Override
        public boolean isLeaf(Object node) {
            if (node instanceof TreeNode_ControlType_Device) {
                return ((TreeNode_ControlType_Device)node).isLeaf();
            }
            return true;
        }

        @Override
        public void valueForPathChanged(TreePath path, Object newValue) {
        }

        @Override
        public int getIndexOfChild(Object parent, Object child) {
            if (parent instanceof TreeNode_ControlType_Device) {
                return ((TreeNode_ControlType_Device)parent).getIndex((TreeNode_ControlType_Device)child);
            }
            return 0;
        }

        public ArrayList<TreeNode_ControlType_Device> getArrayListPathToRoot(TreeNode_ControlType_Device p_HardwareNode) {
            ArrayList<TreeNode_ControlType_Device> o_ArrayListPathToRoot = new ArrayList<TreeNode_ControlType_Device>();
            for (TreeNode o_TreeNode = p_HardwareNode; o_TreeNode != null; o_TreeNode = o_TreeNode.getParent()) {
                o_ArrayListPathToRoot.add(0, (TreeNode_ControlType_Device)o_TreeNode);
            }
            return o_ArrayListPathToRoot;
        }

        public Object[] getPathToRoot(TreeNode_ControlType_Device p_Node) {
            ArrayList<TreeNode_ControlType_Device> o_ArrayListPathToRoot = this.getArrayListPathToRoot(p_Node);
            Object[] o_PathToRoot = new TreeNode_ControlType_Device[o_ArrayListPathToRoot.size()];
            for (int intNode = 0; intNode < o_ArrayListPathToRoot.size(); ++intNode) {
                o_PathToRoot[intNode] = o_ArrayListPathToRoot.get(intNode);
            }
            return o_PathToRoot;
        }

        @Override
        public TreePath getTreePathToRoot(TreeNode_ControlType_Device p_Node) {
            if (p_Node == null) {
                return null;
            }
            return new TreePath(this.getPathToRoot(p_Node));
        }

        public TreeNode_ControlType_Device getTreeNode(TreeNode_ControlType_Device p_ParentNode, Object p_SourceObject) {
            if (p_ParentNode == null) {
                p_ParentNode = (TreeNode_ControlType_Device)this.getRoot();
            }
            ArrayList<TreeNode_ControlType_Device<?>> o_Children = p_ParentNode.getChildren();
            for (int intChild = 0; intChild < o_Children.size(); ++intChild) {
                TreeNode o_ChildNode = p_ParentNode.getChildAt(intChild);
                if (o_ChildNode == null || ((TreeNode_ControlType_Device)o_ChildNode).getSourceObject() != p_SourceObject) continue;
                return o_ChildNode;
            }
            return null;
        }

        @Override
        public TreeNode_ControlType_Device getTreeNode(DMXDevice p_DMXDevice, DMXControlComponent.DMXControlType p_DMXControlType) {
            int intChildNode;
            if (p_DMXDevice == null) {
                return null;
            }
            if (p_DMXControlType == null) {
                return null;
            }
            TreeNode_ControlType_Device<?> o_TreeNode_ControlType_Device = null;
            TreeNode_ControlType_Device o_Root = this.m_Root;
            if (o_Root == null) {
                return null;
            }
            ArrayList<TreeNode_ControlType_Device<?>> o_ChildNodes = o_Root.getChildren();
            for (intChildNode = 0; intChildNode < o_ChildNodes.size(); ++intChildNode) {
                TreeSource_DMXDevice o_TreeSource_DMXDevice;
                o_TreeNode_ControlType_Device = o_ChildNodes.get(intChildNode);
                if (o_TreeNode_ControlType_Device == null || (o_TreeSource_DMXDevice = (TreeSource_DMXDevice)o_TreeNode_ControlType_Device.getSourceObject()) == null) continue;
                if (o_TreeSource_DMXDevice.getDMXDevice() == p_DMXDevice) break;
                o_TreeNode_ControlType_Device = null;
            }
            if (o_TreeNode_ControlType_Device == null) {
                return null;
            }
            o_ChildNodes = o_TreeNode_ControlType_Device.getChildren();
            o_TreeNode_ControlType_Device = null;
            for (intChildNode = 0; intChildNode < o_ChildNodes.size(); ++intChildNode) {
                TreeSource_DMXControlType_Device o_TreeSource_DMXControlType_Device;
                o_TreeNode_ControlType_Device = o_ChildNodes.get(intChildNode);
                if (o_TreeNode_ControlType_Device == null || (o_TreeSource_DMXControlType_Device = (TreeSource_DMXControlType_Device)o_TreeNode_ControlType_Device.getSourceObject()) == null) continue;
                if (o_TreeSource_DMXControlType_Device.getDMXControlType() == p_DMXControlType) break;
                o_TreeNode_ControlType_Device = null;
            }
            return o_TreeNode_ControlType_Device;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addTreeModelListener(TreeModelListener p_TreeModelListener) {
            if (p_TreeModelListener == null) {
                return;
            }
            Object object = this.m_SyncListeners;
            synchronized (object) {
                if (this.m_TreeModelListeners.contains(p_TreeModelListener)) {
                    return;
                }
                this.m_TreeModelListeners.add(p_TreeModelListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeTreeModelListener(TreeModelListener p_TreeModelListener) {
            Object object = this.m_SyncListeners;
            synchronized (object) {
                if (p_TreeModelListener == null) {
                    return;
                }
                this.m_TreeModelListeners.remove(p_TreeModelListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void fireTreeNodesInserted(Object source, Object[] path, int[] childIndices, Object[] children) {
            ArrayList<TreeModelListener> o_Listeners;
            Object object = this.m_SyncListeners;
            synchronized (object) {
                o_Listeners = new ArrayList<TreeModelListener>(this.m_TreeModelListeners.size());
                o_Listeners.addAll(this.m_TreeModelListeners);
            }
            TreeModelEvent e = null;
            for (int i = 0; i < o_Listeners.size(); ++i) {
                if (e == null) {
                    e = new TreeModelEvent(source, path, childIndices, children);
                }
                ((TreeModelListener)o_Listeners.get(i)).treeNodesInserted(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void fireTreeNodesRemoved(Object source, Object[] path, int[] childIndices, Object[] children) {
            ArrayList<TreeModelListener> o_Listeners;
            Object object = this.m_SyncListeners;
            synchronized (object) {
                o_Listeners = new ArrayList<TreeModelListener>(this.m_TreeModelListeners.size());
                o_Listeners.addAll(this.m_TreeModelListeners);
            }
            TreeModelEvent e = null;
            for (int i = 0; i < o_Listeners.size(); ++i) {
                if (e == null) {
                    e = new TreeModelEvent(source, path, childIndices, children);
                }
                ((TreeModelListener)o_Listeners.get(i)).treeNodesRemoved(e);
            }
        }

        private void invokeTreeNodeChanged(TreeNode_ControlType_Device p_ChangedTreeNode) {
            if (p_ChangedTreeNode == null) {
                return;
            }
            TreeNode o_ParentNode = p_ChangedTreeNode.getParent();
            if (o_ParentNode == null) {
                if (p_ChangedTreeNode == this.getRoot()) {
                    this.fireTreeNodesChanged(this, this.getPathToRoot(p_ChangedTreeNode), null, null);
                }
            } else {
                int[] o_Indexs = new int[]{((TreeNode_ControlType_Device)o_ParentNode).getIndex(p_ChangedTreeNode)};
                if (o_Indexs[0] != -1) {
                    Object[] o_Childs = new Object[]{p_ChangedTreeNode};
                    this.fireTreeNodesChanged(this, this.getPathToRoot((TreeNode_ControlType_Device)o_ParentNode), o_Indexs, o_Childs);
                }
            }
        }

        @Override
        public void fireTreeNodeChanged(TreeNode p_ChangedTreeNode) {
            if (p_ChangedTreeNode == null) {
                return;
            }
            this.invokeTreeNodeChanged((TreeNode_ControlType_Device)p_ChangedTreeNode);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireTreeNodesChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
            ArrayList<TreeModelListener> o_Listeners;
            Object object = this.m_SyncListeners;
            synchronized (object) {
                o_Listeners = new ArrayList<TreeModelListener>(this.m_TreeModelListeners.size());
                o_Listeners.addAll(this.m_TreeModelListeners);
            }
            TreeModelEvent e = null;
            for (int i = 0; i < o_Listeners.size(); ++i) {
                if (e == null) {
                    e = new TreeModelEvent(source, path, childIndices, children);
                }
                ((TreeModelListener)o_Listeners.get(i)).treeNodesChanged(e);
            }
        }

        public void fireTreeStructureChanged() {
            if (this.m_Root == null) {
                return;
            }
            int[] o_Indexs = new int[1];
            Object[] o_Childs = new Object[1];
            o_Indexs[0] = 0;
            o_Childs[0] = this.m_Root;
            this.fireTreeStructureChanged(this, this.getPathToRoot(this.m_Root), o_Indexs, o_Childs);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireTreeStructureChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
            ArrayList<TreeModelListener> o_Listeners;
            Object object = this.m_SyncListeners;
            synchronized (object) {
                o_Listeners = new ArrayList<TreeModelListener>(this.m_TreeModelListeners.size());
                o_Listeners.addAll(this.m_TreeModelListeners);
            }
            TreeModelEvent e = null;
            for (int i = 0; i < o_Listeners.size(); ++i) {
                if (e == null) {
                    e = new TreeModelEvent(source, path, childIndices, children);
                }
                ((TreeModelListener)o_Listeners.get(i)).treeStructureChanged(e);
            }
        }

        public int getDMXDeviceCount() {
            return this.m_DMXDevices.size();
        }

        public ArrayList<DMXDevice> getDMXDevices() {
            return this.m_DMXDevices;
        }

        public DMXDevice getDMXDevice(int p_Index) {
            if (p_Index < 0 || p_Index >= this.m_DMXDevices.size()) {
                return null;
            }
            return this.m_DMXDevices.get(p_Index);
        }

        public void addPropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
            if (p_PropertyChangeListener == null) {
                return;
            }
            this.m_PropertyChangeSupport.addPropertyChangeListener(p_PropertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
            this.m_PropertyChangeSupport.removePropertyChangeListener(p_PropertyChangeListener);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() instanceof DMXDevice) {
                if (DMXDevice.PROP_DMXDEVICE_DMXDEVICETYPE.equals(evt.getPropertyName())) {
                    TreeNode_ControlType_Device<TreeSource_DMXControlType_Device> o_TreeSource_DMXControlTypeDevice_Node;
                    DMXControlComponent.DMXControlType o_DMXControlType;
                    int intDMXControlType;
                    DMXDevice o_DMXDevice = (DMXDevice)evt.getSource();
                    TreeNode_ControlType_Device<TreeSource_DMXDevice> o_TreeNode_DMXDevice = this.getTreenodeDMXDevice(o_DMXDevice);
                    if (o_TreeNode_DMXDevice == null) {
                        return;
                    }
                    DMXDeviceType o_DMXDeviceType = (DMXDeviceType)evt.getOldValue();
                    for (intDMXControlType = o_DMXDeviceType.getDMXControlTypeCount() - 1; intDMXControlType >= 0; --intDMXControlType) {
                        o_DMXControlType = o_DMXDeviceType.getDMXControlType(intDMXControlType);
                        if (o_DMXControlType == null) continue;
                        o_TreeSource_DMXControlTypeDevice_Node = this.getDMXControlTypeDeviceNode(o_DMXControlType, o_TreeNode_DMXDevice);
                        this.removeChild(o_TreeNode_DMXDevice, o_TreeSource_DMXControlTypeDevice_Node);
                    }
                    if (this.getTreenodeDMXDevice(o_DMXDevice) == null) {
                        this.addChild(this.m_Root, o_TreeNode_DMXDevice);
                    }
                    o_DMXDeviceType = (DMXDeviceType)evt.getNewValue();
                    for (intDMXControlType = 0; intDMXControlType < o_DMXDeviceType.getDMXControlTypeCount(); ++intDMXControlType) {
                        o_DMXControlType = o_DMXDeviceType.getDMXControlType(intDMXControlType);
                        TreeSource_DMXControlType_Device o_TreeSource_DMXControlType_Device = new TreeSource_DMXControlType_Device(o_DMXControlType, o_DMXDevice);
                        o_TreeSource_DMXControlTypeDevice_Node = new TreeNode_ControlType_Device<TreeSource_DMXControlType_Device>(o_TreeSource_DMXControlType_Device, this);
                        this.addChild(o_TreeNode_DMXDevice, o_TreeSource_DMXControlTypeDevice_Node);
                    }
                } else if (DMXDevice.PROP_DMXDEVICE_DEVICENAME.equals(evt.getPropertyName())) {
                    DMXDevice o_DMXDevice = (DMXDevice)evt.getSource();
                    this.m_Root.resort(o_DMXDevice);
                    this.fireTreeStructureChanged();
                }
            }
        }
    }

    public static class TreeModel_DMXControlType_Devices
    implements TreeModel_Devices,
    PropertyChangeListener {
        public static final String PROP_DMXDEVICETREEMODEL_DEVICEADDED = "dmxdevicetreemodelDMXDeviceAdded";
        public static final String PROP_DMXDEVICETREEMODEL_DEVICEREMOVED = "dmxdevicetreemodelDMXDeviceRemoved";
        protected TreeNode_ControlType_Device m_Root;
        protected ArrayList<TreeModelListener> m_TreeModelListeners;
        protected ArrayList<DMXDevice> m_DMXDevices;
        protected SinglePropertyChangeSupport m_PropertyChangeSupport;
        private final Object m_SyncListeners = new Object();

        public TreeModel_DMXControlType_Devices() {
            this.initMembers();
            this.m_Root = new TreeNode_ControlType_Device<Object>(null, this);
            this.m_TreeModelListeners = new ArrayList();
        }

        private void initMembers() {
            this.m_PropertyChangeSupport = new SinglePropertyChangeSupport(this);
            this.m_DMXDevices = new ArrayList();
        }

        public void addDMXDevice(DMXDevice p_DMXDevice) {
            if (p_DMXDevice == null) {
                return;
            }
            if (this.m_DMXDevices.contains(p_DMXDevice)) {
                return;
            }
            DMXDeviceType o_DMXDeviceType = p_DMXDevice.getDMXDeviceType();
            if (o_DMXDeviceType == null) {
                return;
            }
            this.m_DMXDevices.add(p_DMXDevice);
            p_DMXDevice.addPropertyChangeListener(this);
            TreeNode_ControlType_Device o_RootNode = (TreeNode_ControlType_Device)this.getRoot();
            for (int intDMXControlType = 0; intDMXControlType < o_DMXDeviceType.getDMXControlTypeCount(); ++intDMXControlType) {
                DMXControlComponent.DMXControlType o_DMXControlType = o_DMXDeviceType.getDMXControlType(intDMXControlType);
                if (o_DMXControlType == null) continue;
                TreeNode_ControlType_Device<TreeSource_DMXControlType> o_TreeNodeDMXControlType = this.getDMXControlTypeNode(o_DMXControlType.getDMXControlDescription().getID());
                if (o_TreeNodeDMXControlType == null) {
                    TreeSource_DMXControlType o_TreeSource_DMXControlType = new TreeSource_DMXControlType(o_DMXControlType);
                    o_TreeNodeDMXControlType = new TreeNode_ControlType_Device<TreeSource_DMXControlType>(o_TreeSource_DMXControlType, this);
                    this.addChild(o_RootNode, o_TreeNodeDMXControlType);
                }
                TreeSource_DMXControlType_Device o_TreeSource_DMXControlTypeDevice = new TreeSource_DMXControlType_Device(o_DMXControlType, p_DMXDevice);
                TreeNode_ControlType_Device<TreeSource_DMXControlType_Device> o_TreeNode_DMXControlTypeDevice = new TreeNode_ControlType_Device<TreeSource_DMXControlType_Device>(o_TreeSource_DMXControlTypeDevice, this);
                this.addChild(o_TreeNodeDMXControlType, o_TreeNode_DMXControlTypeDevice);
            }
            this.m_PropertyChangeSupport.firePropertyChange(PROP_DMXDEVICETREEMODEL_DEVICEADDED, null, p_DMXDevice);
        }

        public void removeDMXDevice(DMXDevice p_DMXDevice) {
            if (p_DMXDevice == null) {
                return;
            }
            if (!this.m_DMXDevices.contains(p_DMXDevice)) {
                return;
            }
            DMXDeviceType o_DMXDeviceType = p_DMXDevice.getDMXDeviceType();
            if (o_DMXDeviceType == null) {
                return;
            }
            this.m_DMXDevices.remove(p_DMXDevice);
            p_DMXDevice.removePropertyChangeListener(this);
            TreeNode_ControlType_Device o_RootNode = (TreeNode_ControlType_Device)this.getRoot();
            for (int intDMXControlType = o_DMXDeviceType.getDMXControlTypeCount() - 1; intDMXControlType >= 0; --intDMXControlType) {
                TreeNode_ControlType_Device<TreeSource_DMXControlType_Device> o_TreeNode_DMXControlTypeDevice;
                TreeNode_ControlType_Device<TreeSource_DMXControlType> o_TreeNodeDMXControlType;
                DMXControlComponent.DMXControlType o_DMXControlType = o_DMXDeviceType.getDMXControlType(intDMXControlType);
                if (o_DMXControlType == null || (o_TreeNodeDMXControlType = this.getDMXControlTypeNode(o_DMXControlType.getDMXControlDescription().getID())) == null || (o_TreeNode_DMXControlTypeDevice = this.getDMXControlTypeDeviceNode(o_TreeNodeDMXControlType, o_DMXControlType, p_DMXDevice)) == null) continue;
                if (o_TreeNode_DMXControlTypeDevice.getSelectionFlag() != 0) {
                    // empty if block
                }
                this.removeChild(o_TreeNodeDMXControlType, o_TreeNode_DMXControlTypeDevice);
            }
            this.m_PropertyChangeSupport.firePropertyChange(PROP_DMXDEVICETREEMODEL_DEVICEREMOVED, p_DMXDevice, null);
        }

        public TreeNode_ControlType_Device<TreeSource_DMXControlType> getDMXControlTypeNode(String p_DMXControlTypeClassName) {
            ArrayList<TreeNode_ControlType_Device<?>> o_TreeNodes_DMXControlTypes = this.m_Root.getChildren();
            for (int intNode = 0; intNode < o_TreeNodes_DMXControlTypes.size(); ++intNode) {
                TreeSource_DMXControlType o_TreeSource_DMXControlType;
                TreeNode_ControlType_Device<TreeSource_DMXControlType> o_TreeNode_DMXControlType = o_TreeNodes_DMXControlTypes.get(intNode);
                if (o_TreeNode_DMXControlType == null || !(o_TreeSource_DMXControlType = (TreeSource_DMXControlType)o_TreeNode_DMXControlType.getSourceObject()).getDMXControlDescriptionID().equals(p_DMXControlTypeClassName)) continue;
                return o_TreeNode_DMXControlType;
            }
            return null;
        }

        public TreeNode_ControlType_Device<TreeSource_DMXControlType_Device> getDMXControlTypeDeviceNode(TreeNode_ControlType_Device p_DMXDeviceTypeClassNode, DMXControlComponent.DMXControlType p_DMXControlType, DMXDevice p_DMXDevice) {
            ArrayList<TreeNode_ControlType_Device<?>> o_TreeNodes_DMXDevices = p_DMXDeviceTypeClassNode.getChildren();
            for (int intNode = 0; intNode < o_TreeNodes_DMXDevices.size(); ++intNode) {
                TreeSource_DMXControlType_Device o_TreeSource_DMXControlType_Device;
                TreeNode_ControlType_Device<TreeSource_DMXControlType_Device> o_TreeSource_DMXControlTypeDeviceNode = o_TreeNodes_DMXDevices.get(intNode);
                if (o_TreeSource_DMXControlTypeDeviceNode == null || (o_TreeSource_DMXControlType_Device = (TreeSource_DMXControlType_Device)o_TreeSource_DMXControlTypeDeviceNode.getSourceObject()) == null || o_TreeSource_DMXControlType_Device.getDMXControlType() != p_DMXControlType || o_TreeSource_DMXControlType_Device.getDMXDevice() != p_DMXDevice) continue;
                return o_TreeSource_DMXControlTypeDeviceNode;
            }
            return null;
        }

        @Override
        public Object getRoot() {
            return this.m_Root;
        }

        public void addChild(TreeNode_ControlType_Device p_Parent, TreeNode_ControlType_Device p_Child) {
            if (p_Parent == null) {
                return;
            }
            if (p_Child == null) {
                return;
            }
            if (p_Parent.getSourceObject() instanceof TreeSource_DMXControlType) {
                p_Parent.addChild_SortedDevice(p_Child);
            } else {
                p_Parent.addChild(p_Child);
            }
            Object[] o_ParentPathToRoot = (TreeNode_ControlType_Device[])this.getPathToRoot(p_Parent);
            int[] o_Indexs = new int[1];
            Object[] o_Childs = new Object[1];
            o_Indexs[0] = p_Parent.getIndex(p_Child);
            o_Childs[0] = p_Child;
            if (o_Indexs[0] != -1) {
                if (p_Child.getSourceObject() instanceof TreeSource_DMXControlType_Device) {
                    TreeSource_DMXControlType_Device o_TreeSource_DMXControlTypeDevice = (TreeSource_DMXControlType_Device)p_Child.getSourceObject();
                    o_TreeSource_DMXControlTypeDevice.getDMXDevice().addPropertyChangeListener(p_Child);
                }
                this.fireTreeNodesInserted(this, o_ParentPathToRoot, o_Indexs, o_Childs);
            }
        }

        public void removeChild(TreeNode_ControlType_Device p_Parent, TreeNode_ControlType_Device p_Child) {
            if (p_Parent == null) {
                return;
            }
            if (p_Child == null) {
                return;
            }
            int[] o_Indexs = new int[1];
            Object[] o_Childs = new Object[1];
            o_Indexs[0] = p_Parent.getIndex(p_Child);
            o_Childs[0] = p_Child;
            if (o_Indexs[0] != -1) {
                if (p_Child.getSourceObject() instanceof TreeSource_DMXControlType_Device) {
                    TreeSource_DMXControlType_Device o_TreeSource_DMXControlTypeDevice = (TreeSource_DMXControlType_Device)p_Child.getSourceObject();
                    o_TreeSource_DMXControlTypeDevice.getDMXDevice().removePropertyChangeListener(p_Child);
                }
                Object[] o_ParentPathToRoot = (TreeNode_ControlType_Device[])this.getPathToRoot(p_Parent);
                p_Parent.removeChild(p_Child);
                this.fireTreeNodesRemoved(this, o_ParentPathToRoot, o_Indexs, o_Childs);
                this.invokeTreeNodeChanged(p_Parent);
            }
            if (p_Parent != this.getRoot() && p_Parent.getChildCount() <= 0) {
                this.removeChild((TreeNode_ControlType_Device)p_Parent.getParent(), p_Parent);
            }
        }

        @Override
        public TreeNode_ControlType_Device getChild(Object parent, int index) {
            if (parent instanceof TreeNode_ControlType_Device) {
                return ((TreeNode_ControlType_Device)parent).getChildAt(index);
            }
            return null;
        }

        @Override
        public int getChildCount(Object parent) {
            if (parent instanceof TreeNode_ControlType_Device) {
                return ((TreeNode_ControlType_Device)parent).getChildCount();
            }
            return 0;
        }

        @Override
        public boolean isLeaf(Object node) {
            if (node instanceof TreeNode_ControlType_Device) {
                return ((TreeNode_ControlType_Device)node).isLeaf();
            }
            return true;
        }

        @Override
        public void valueForPathChanged(TreePath path, Object newValue) {
        }

        @Override
        public int getIndexOfChild(Object parent, Object child) {
            if (parent instanceof TreeNode_ControlType_Device) {
                return ((TreeNode_ControlType_Device)parent).getIndex((TreeNode_ControlType_Device)child);
            }
            return 0;
        }

        public ArrayList<TreeNode_ControlType_Device> getArrayListPathToRoot(TreeNode_ControlType_Device p_HardwareNode) {
            ArrayList<TreeNode_ControlType_Device> o_ArrayListPathToRoot = new ArrayList<TreeNode_ControlType_Device>();
            for (TreeNode o_TreeNode = p_HardwareNode; o_TreeNode != null; o_TreeNode = o_TreeNode.getParent()) {
                o_ArrayListPathToRoot.add(0, (TreeNode_ControlType_Device)o_TreeNode);
            }
            return o_ArrayListPathToRoot;
        }

        public Object[] getPathToRoot(TreeNode_ControlType_Device p_Node) {
            ArrayList<TreeNode_ControlType_Device> o_ArrayListPathToRoot = this.getArrayListPathToRoot(p_Node);
            Object[] o_PathToRoot = new TreeNode_ControlType_Device[o_ArrayListPathToRoot.size()];
            for (int intNode = 0; intNode < o_ArrayListPathToRoot.size(); ++intNode) {
                o_PathToRoot[intNode] = o_ArrayListPathToRoot.get(intNode);
            }
            return o_PathToRoot;
        }

        @Override
        public TreePath getTreePathToRoot(TreeNode_ControlType_Device p_Node) {
            if (p_Node == null) {
                return null;
            }
            return new TreePath(this.getPathToRoot(p_Node));
        }

        public TreeNode_ControlType_Device getTreeNode(TreeNode_ControlType_Device p_ParentNode, Object p_SourceObject) {
            if (p_ParentNode == null) {
                p_ParentNode = (TreeNode_ControlType_Device)this.getRoot();
            }
            ArrayList<TreeNode_ControlType_Device<?>> o_Children = p_ParentNode.getChildren();
            for (int intChild = 0; intChild < o_Children.size(); ++intChild) {
                TreeNode o_ChildNode = p_ParentNode.getChildAt(intChild);
                if (o_ChildNode == null || ((TreeNode_ControlType_Device)o_ChildNode).getSourceObject() != p_SourceObject) continue;
                return o_ChildNode;
            }
            return null;
        }

        @Override
        public TreeNode_ControlType_Device getTreeNode(DMXDevice p_DMXDevice, DMXControlComponent.DMXControlType p_DMXControlType) {
            int intChildNode;
            if (p_DMXDevice == null) {
                return null;
            }
            if (p_DMXControlType == null) {
                return null;
            }
            TreeNode_ControlType_Device<?> o_TreeNode_ControlType_Device = null;
            TreeNode_ControlType_Device o_Root = this.m_Root;
            if (o_Root == null) {
                return null;
            }
            ArrayList<TreeNode_ControlType_Device<?>> o_ChildNodes = o_Root.getChildren();
            for (intChildNode = 0; intChildNode < o_ChildNodes.size(); ++intChildNode) {
                TreeSource_DMXControlType o_TreeSource_DMXControlType;
                o_TreeNode_ControlType_Device = o_ChildNodes.get(intChildNode);
                if (o_TreeNode_ControlType_Device == null || (o_TreeSource_DMXControlType = (TreeSource_DMXControlType)o_TreeNode_ControlType_Device.getSourceObject()) == null) continue;
                if (o_TreeSource_DMXControlType.getDMXControlDescriptionID().equals(p_DMXControlType.getDMXControlDescription().getID())) break;
                o_TreeNode_ControlType_Device = null;
            }
            if (o_TreeNode_ControlType_Device == null) {
                return null;
            }
            o_ChildNodes = o_TreeNode_ControlType_Device.getChildren();
            o_TreeNode_ControlType_Device = null;
            for (intChildNode = 0; intChildNode < o_ChildNodes.size(); ++intChildNode) {
                TreeSource_DMXControlType_Device o_TreeSource_DMXControlType_Device;
                o_TreeNode_ControlType_Device = o_ChildNodes.get(intChildNode);
                if (o_TreeNode_ControlType_Device == null || (o_TreeSource_DMXControlType_Device = (TreeSource_DMXControlType_Device)o_TreeNode_ControlType_Device.getSourceObject()) == null) continue;
                if (o_TreeSource_DMXControlType_Device.getDMXDevice() == p_DMXDevice && o_TreeSource_DMXControlType_Device.getDMXControlType() == p_DMXControlType) break;
                o_TreeNode_ControlType_Device = null;
            }
            return o_TreeNode_ControlType_Device;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addTreeModelListener(TreeModelListener p_TreeModelListener) {
            if (p_TreeModelListener == null) {
                return;
            }
            Object object = this.m_SyncListeners;
            synchronized (object) {
                if (this.m_TreeModelListeners.contains(p_TreeModelListener)) {
                    return;
                }
                this.m_TreeModelListeners.add(p_TreeModelListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeTreeModelListener(TreeModelListener p_TreeModelListener) {
            Object object = this.m_SyncListeners;
            synchronized (object) {
                if (p_TreeModelListener == null) {
                    return;
                }
                this.m_TreeModelListeners.remove(p_TreeModelListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void fireTreeNodesInserted(Object source, Object[] path, int[] childIndices, Object[] children) {
            ArrayList<TreeModelListener> o_Listeners;
            Object object = this.m_SyncListeners;
            synchronized (object) {
                o_Listeners = new ArrayList<TreeModelListener>(this.m_TreeModelListeners.size());
                o_Listeners.addAll(this.m_TreeModelListeners);
            }
            TreeModelEvent e = null;
            for (int i = 0; i < o_Listeners.size(); ++i) {
                if (e == null) {
                    e = new TreeModelEvent(source, path, childIndices, children);
                }
                ((TreeModelListener)o_Listeners.get(i)).treeNodesInserted(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void fireTreeNodesRemoved(Object source, Object[] path, int[] childIndices, Object[] children) {
            ArrayList<TreeModelListener> o_Listeners;
            Object object = this.m_SyncListeners;
            synchronized (object) {
                o_Listeners = new ArrayList<TreeModelListener>(this.m_TreeModelListeners.size());
                o_Listeners.addAll(this.m_TreeModelListeners);
            }
            TreeModelEvent e = null;
            for (int i = 0; i < o_Listeners.size(); ++i) {
                if (e == null) {
                    e = new TreeModelEvent(source, path, childIndices, children);
                }
                ((TreeModelListener)o_Listeners.get(i)).treeNodesRemoved(e);
            }
        }

        private void invokeTreeNodeChanged(TreeNode_ControlType_Device p_ChangedTreeNode) {
            if (p_ChangedTreeNode == null) {
                return;
            }
            TreeNode o_ParentNode = p_ChangedTreeNode.getParent();
            if (o_ParentNode == null) {
                if (p_ChangedTreeNode == this.getRoot()) {
                    this.fireTreeNodesChanged(this, this.getPathToRoot(p_ChangedTreeNode), null, null);
                }
            } else {
                int[] o_Indexs = new int[]{((TreeNode_ControlType_Device)o_ParentNode).getIndex(p_ChangedTreeNode)};
                if (o_Indexs[0] != -1) {
                    Object[] o_Childs = new Object[]{p_ChangedTreeNode};
                    this.fireTreeNodesChanged(this, this.getPathToRoot((TreeNode_ControlType_Device)o_ParentNode), o_Indexs, o_Childs);
                }
            }
        }

        @Override
        public void fireTreeNodeChanged(TreeNode p_ChangedTreeNode) {
            if (p_ChangedTreeNode == null) {
                return;
            }
            this.invokeTreeNodeChanged((TreeNode_ControlType_Device)p_ChangedTreeNode);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireTreeNodesChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
            ArrayList<TreeModelListener> o_Listeners;
            Object object = this.m_SyncListeners;
            synchronized (object) {
                o_Listeners = new ArrayList<TreeModelListener>(this.m_TreeModelListeners.size());
                o_Listeners.addAll(this.m_TreeModelListeners);
            }
            TreeModelEvent e = null;
            for (int i = 0; i < o_Listeners.size(); ++i) {
                if (e == null) {
                    e = new TreeModelEvent(source, path, childIndices, children);
                }
                ((TreeModelListener)o_Listeners.get(i)).treeNodesChanged(e);
            }
        }

        public void fireTreeStructureChanged() {
            if (this.m_Root == null) {
                return;
            }
            int[] o_Indexs = new int[1];
            Object[] o_Childs = new Object[1];
            o_Indexs[0] = 0;
            o_Childs[0] = this.m_Root;
            this.fireTreeStructureChanged(this, this.getPathToRoot(this.m_Root), o_Indexs, o_Childs);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireTreeStructureChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
            ArrayList<TreeModelListener> o_Listeners;
            Object object = this.m_SyncListeners;
            synchronized (object) {
                o_Listeners = new ArrayList<TreeModelListener>(this.m_TreeModelListeners.size());
                o_Listeners.addAll(this.m_TreeModelListeners);
            }
            TreeModelEvent e = null;
            for (int i = 0; i < o_Listeners.size(); ++i) {
                if (e == null) {
                    e = new TreeModelEvent(source, path, childIndices, children);
                }
                ((TreeModelListener)o_Listeners.get(i)).treeStructureChanged(e);
            }
        }

        public int getDMXDeviceCount() {
            return this.m_DMXDevices.size();
        }

        public ArrayList<DMXDevice> getDMXDevices() {
            return this.m_DMXDevices;
        }

        public DMXDevice getDMXDevice(int p_Index) {
            if (p_Index < 0 || p_Index >= this.m_DMXDevices.size()) {
                return null;
            }
            return this.m_DMXDevices.get(p_Index);
        }

        public void addPropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
            if (p_PropertyChangeListener == null) {
                return;
            }
            this.m_PropertyChangeSupport.addPropertyChangeListener(p_PropertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
            this.m_PropertyChangeSupport.removePropertyChangeListener(p_PropertyChangeListener);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() instanceof DMXDevice) {
                if (DMXDevice.PROP_DMXDEVICE_DMXDEVICETYPE.equals(evt.getPropertyName())) {
                    TreeNode_ControlType_Device<TreeSource_DMXControlType_Device> o_TreeNode_DMXControlTypeDevice;
                    TreeNode_ControlType_Device<TreeSource_DMXControlType> o_TreeNode_DMXControlType;
                    DMXControlComponent.DMXControlType o_DMXControlType;
                    int intDMXControlType;
                    DMXDevice o_DMXDevice = (DMXDevice)evt.getSource();
                    DMXDeviceType o_DMXDeviceType = (DMXDeviceType)evt.getOldValue();
                    for (intDMXControlType = o_DMXDeviceType.getDMXControlTypeCount() - 1; intDMXControlType >= 0; --intDMXControlType) {
                        o_DMXControlType = o_DMXDeviceType.getDMXControlType(intDMXControlType);
                        if (o_DMXControlType == null || (o_TreeNode_DMXControlType = this.getDMXControlTypeNode(o_DMXControlType.getDMXControlDescription().getID())) == null || (o_TreeNode_DMXControlTypeDevice = this.getDMXControlTypeDeviceNode(o_TreeNode_DMXControlType, o_DMXControlType, o_DMXDevice)) == null) continue;
                        this.removeChild(o_TreeNode_DMXControlType, o_TreeNode_DMXControlTypeDevice);
                    }
                    o_DMXDeviceType = (DMXDeviceType)evt.getNewValue();
                    if (o_DMXDeviceType == null) {
                        return;
                    }
                    for (intDMXControlType = 0; intDMXControlType < o_DMXDeviceType.getDMXControlTypeCount(); ++intDMXControlType) {
                        o_DMXControlType = o_DMXDeviceType.getDMXControlType(intDMXControlType);
                        o_TreeNode_DMXControlType = this.getDMXControlTypeNode(o_DMXControlType.getDMXControlDescription().getID());
                        if (o_TreeNode_DMXControlType == null) {
                            o_TreeNode_DMXControlType = new TreeNode_ControlType_Device<TreeSource_DMXControlType>(new TreeSource_DMXControlType(o_DMXControlType), this);
                            this.addChild((TreeNode_ControlType_Device)this.getRoot(), o_TreeNode_DMXControlType);
                        }
                        if ((o_TreeNode_DMXControlTypeDevice = this.getDMXControlTypeDeviceNode(o_TreeNode_DMXControlType, o_DMXControlType, o_DMXDevice)) != null) continue;
                        o_TreeNode_DMXControlTypeDevice = new TreeNode_ControlType_Device<TreeSource_DMXControlType_Device>(new TreeSource_DMXControlType_Device(o_DMXControlType, o_DMXDevice), this);
                        this.addChild(o_TreeNode_DMXControlType, o_TreeNode_DMXControlTypeDevice);
                    }
                } else if (DMXDevice.PROP_DMXDEVICE_DEVICENAME.equals(evt.getPropertyName())) {
                    TreeNode_ControlType_Device<TreeSource_DMXControlType> o_TreeNode_DMXControlType;
                    DMXDevice o_DMXDevice = (DMXDevice)evt.getSource();
                    DMXDeviceType o_DMXDeviceType = o_DMXDevice.getDMXDeviceType();
                    if (o_DMXDeviceType == null) {
                        return;
                    }
                    ArrayList<TreeNode_ControlType_Device<TreeSource_DMXControlType>> o_TreeNode_ControlTypes = new ArrayList<TreeNode_ControlType_Device<TreeSource_DMXControlType>>();
                    for (int intDMXControlType = 0; intDMXControlType < o_DMXDeviceType.getDMXControlTypeCount(); ++intDMXControlType) {
                        DMXControlComponent.DMXControlType o_DMXControlType = o_DMXDeviceType.getDMXControlType(intDMXControlType);
                        if (o_DMXControlType == null || (o_TreeNode_DMXControlType = this.getDMXControlTypeNode(o_DMXControlType.getDMXControlDescription().getID())) == null || o_TreeNode_ControlTypes.contains(o_TreeNode_DMXControlType)) continue;
                        o_TreeNode_ControlTypes.add(o_TreeNode_DMXControlType);
                    }
                    for (int intNode = 0; intNode < o_TreeNode_ControlTypes.size(); ++intNode) {
                        o_TreeNode_DMXControlType = (TreeNode_ControlType_Device<TreeSource_DMXControlType>)o_TreeNode_ControlTypes.get(intNode);
                        if (o_TreeNode_DMXControlType == null) continue;
                        o_TreeNode_DMXControlType.resort(o_DMXDevice);
                    }
                    this.fireTreeStructureChanged();
                }
            }
        }
    }

    public static class TreeNode_ControlType_Device<T extends TreeSource>
    implements TreeNode,
    PropertyChangeListener {
        protected TreeNode_ControlType_Device<?> m_Parent;
        protected ArrayList<TreeNode_ControlType_Device<?>> m_ArrayListChilds = new ArrayList();
        protected T m_SourceObject;
        protected TreeModel_Devices m_DMXDeviceTreeModel;
        protected int m_SelectionFlag;

        public TreeNode_ControlType_Device(T p_SourceObject, TreeModel_Devices p_TreeModel) {
            this.m_SourceObject = p_SourceObject;
            this.m_DMXDeviceTreeModel = p_TreeModel;
            this.m_SelectionFlag = 0;
        }

        public void addChild(TreeNode_ControlType_Device<?> p_Child) {
            if (p_Child == null) {
                return;
            }
            if (this.m_ArrayListChilds.contains(p_Child)) {
                return;
            }
            this.m_ArrayListChilds.add(p_Child);
            p_Child.setParent(this);
        }

        public void addChild_SortedDevice(TreeNode_ControlType_Device<?> p_Child) {
            if (p_Child == null) {
                return;
            }
            if (this.m_ArrayListChilds.contains(p_Child)) {
                return;
            }
            Object o_TreeSourceNew = null;
            int intIndex = 0;
            o_TreeSourceNew = p_Child.getSourceObject();
            if (o_TreeSourceNew instanceof TreeSource_DMXControlType_Device) {
                String stringDeviceNameNew = ((TreeSource_DMXControlType_Device)o_TreeSourceNew).getDMXDevice().getName();
                for (intIndex = 0; intIndex < this.m_ArrayListChilds.size(); ++intIndex) {
                    Object o_TreeSourceOld = this.m_ArrayListChilds.get(intIndex).getSourceObject();
                    if (o_TreeSourceOld == null) continue;
                    String stringDeviceNameOld = ((TreeSource_DMXControlType_Device)o_TreeSourceOld).getDMXDevice().getName();
                    if (stringDeviceNameOld.compareToIgnoreCase(stringDeviceNameNew) <= 0) {
                        boolean intTest = false;
                        continue;
                    }
                    break;
                }
            } else if (o_TreeSourceNew instanceof TreeSource_DMXDevice) {
                String stringDeviceNameOld;
                Object o_TreeSourceOld;
                String stringDeviceNameNew = ((TreeSource_DMXDevice)o_TreeSourceNew).getDMXDevice().getName();
                for (intIndex = 0; intIndex < this.m_ArrayListChilds.size() && ((o_TreeSourceOld = this.m_ArrayListChilds.get(intIndex).getSourceObject()) == null || (stringDeviceNameOld = ((TreeSource_DMXDevice)o_TreeSourceOld).getDMXDevice().getName()).compareToIgnoreCase(stringDeviceNameNew) <= 0); ++intIndex) {
                }
            } else {
                intIndex = this.m_ArrayListChilds.size();
            }
            this.m_ArrayListChilds.add(intIndex, p_Child);
            p_Child.setParent(this);
        }

        public void resort(DMXDevice p_DMXDevice) {
            DMXDevice o_DMXDevice;
            Object o_TreeSource;
            TreeNode_ControlType_Device<?> o_TreeNode_ControlType_Device;
            int intChild;
            if (p_DMXDevice == null) {
                return;
            }
            int intIndexOld = -1;
            int intIndexNew = -1;
            String stringDeviceNameNew = p_DMXDevice.getName();
            if (this.m_ArrayListChilds == null || this.m_ArrayListChilds.size() == 0) {
                return;
            }
            for (intChild = 0; intChild < this.m_ArrayListChilds.size(); ++intChild) {
                o_TreeNode_ControlType_Device = this.m_ArrayListChilds.get(intChild);
                if (o_TreeNode_ControlType_Device == null) continue;
                o_TreeSource = o_TreeNode_ControlType_Device.getSourceObject();
                if (o_TreeSource instanceof TreeSource_DMXDevice) {
                    o_DMXDevice = ((TreeSource_DMXDevice)o_TreeSource).getDMXDevice();
                    if (o_DMXDevice != p_DMXDevice) continue;
                    break;
                }
                if (o_TreeSource instanceof TreeSource_DMXControlType_Device) {
                    o_DMXDevice = ((TreeSource_DMXControlType_Device)o_TreeSource).getDMXDevice();
                    if (o_DMXDevice != p_DMXDevice) continue;
                    break;
                }
                return;
            }
            if ((intIndexOld = intChild) >= this.m_ArrayListChilds.size()) {
                return;
            }
            for (intChild = 0; intChild < this.m_ArrayListChilds.size(); ++intChild) {
                String stringDeviceNameOld;
                o_TreeNode_ControlType_Device = this.m_ArrayListChilds.get(intChild);
                if (o_TreeNode_ControlType_Device == null) continue;
                o_TreeSource = o_TreeNode_ControlType_Device.getSourceObject();
                if (o_TreeSource instanceof TreeSource_DMXDevice) {
                    o_DMXDevice = ((TreeSource_DMXDevice)o_TreeSource).getDMXDevice();
                    stringDeviceNameOld = o_DMXDevice.getName();
                    if (stringDeviceNameOld.compareToIgnoreCase(stringDeviceNameNew) <= 0) {
                        intIndexNew = intChild;
                        continue;
                    }
                    intIndexNew = intChild;
                    break;
                }
                if (!(o_TreeSource instanceof TreeSource_DMXControlType_Device) || (o_DMXDevice = ((TreeSource_DMXControlType_Device)o_TreeSource).getDMXDevice()) == null) continue;
                stringDeviceNameOld = o_DMXDevice.getName();
                if (stringDeviceNameOld.compareToIgnoreCase(stringDeviceNameNew) <= 0) {
                    intIndexNew = intChild;
                    continue;
                }
                intIndexNew = intChild;
                break;
            }
            if (intIndexOld == (intIndexNew = intChild)) {
                return;
            }
            o_TreeNode_ControlType_Device = this.m_ArrayListChilds.get(intIndexOld);
            if (intIndexNew > intIndexOld) {
                --intIndexNew;
            }
            this.m_ArrayListChilds.remove(intIndexOld);
            this.m_ArrayListChilds.add(intIndexNew, o_TreeNode_ControlType_Device);
        }

        public void removeChild(TreeNode_ControlType_Device<?> p_Child) {
            if (p_Child == null) {
                return;
            }
            if (this.m_ArrayListChilds.remove(p_Child)) {
                p_Child.setParent(null);
            }
        }

        @Override
        public TreeNode_ControlType_Device<?> getChildAt(int childIndex) {
            if (this.m_ArrayListChilds == null) {
                return null;
            }
            if (childIndex < 0) {
                return null;
            }
            if (childIndex >= this.m_ArrayListChilds.size()) {
                return null;
            }
            return this.m_ArrayListChilds.get(childIndex);
        }

        @Override
        public int getChildCount() {
            if (this.m_ArrayListChilds == null) {
                return 0;
            }
            return this.m_ArrayListChilds.size();
        }

        @Override
        public TreeNode_ControlType_Device<?> getParent() {
            return this.m_Parent;
        }

        public void setParent(TreeNode_ControlType_Device<?> p_Parent) {
            this.m_Parent = p_Parent;
        }

        @Override
        public int getIndex(TreeNode node) {
            if (node == null) {
                return -1;
            }
            return this.m_ArrayListChilds.indexOf(node);
        }

        @Override
        public boolean getAllowsChildren() {
            return true;
        }

        @Override
        public boolean isLeaf() {
            if (this.m_ArrayListChilds == null) {
                return true;
            }
            return this.m_ArrayListChilds.size() <= 0;
        }

        public Enumeration<TreeNode_ControlType_Device<?>> children() {
            return Collections.enumeration(this.m_ArrayListChilds);
        }

        public ArrayList<TreeNode_ControlType_Device<?>> getChildren() {
            return this.m_ArrayListChilds;
        }

        public T getSourceObject() {
            return this.m_SourceObject;
        }

        public void setSourceObject(T p_SourceObject) {
            this.m_SourceObject = p_SourceObject;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String stringPropertyName = evt.getPropertyName();
            if (stringPropertyName == null) {
                stringPropertyName = "";
            }
            boolean boolChanged = false;
            if (evt.getSource() instanceof DMXUniverse) {
                boolChanged = true;
            } else if (evt.getSource() instanceof DMXDevice) {
                if (DMXDevice.PROP_DMXDEVICE_DEVICENAME.equals(stringPropertyName)) {
                    boolChanged = true;
                }
                if (DMXDevice.PROP_INDEXED_DMXDEVICE_UNIVERSE.equals(stringPropertyName)) {
                    boolChanged = true;
                }
                if (DMXDevice.PROP_INDEXED_DMXDEVICE_UNIVERSENAME.equals(stringPropertyName)) {
                    boolChanged = true;
                }
            }
            if (boolChanged) {
                this.m_DMXDeviceTreeModel.fireTreeNodeChanged(this);
            }
        }

        public int getSelectionFlag() {
            return this.m_SelectionFlag;
        }

        public void setSelectionFlag(int p_SelectionFlag) {
            if (p_SelectionFlag < 0 || p_SelectionFlag > 2) {
                return;
            }
            if (this.m_SelectionFlag == p_SelectionFlag) {
                return;
            }
            this.m_SelectionFlag = p_SelectionFlag;
            this.m_DMXDeviceTreeModel.fireTreeNodeChanged(this);
        }
    }

    public static class TreeSource_DMXControlType_Device
    extends TreeSource {
        private DMXControlComponent.DMXControlType m_DMXControlType;
        private DMXDevice m_DMXDevice;

        public TreeSource_DMXControlType_Device(DMXControlComponent.DMXControlType p_DMXControlType, DMXDevice p_DMXDevice) {
            this.m_DMXControlType = p_DMXControlType;
            this.m_DMXDevice = p_DMXDevice;
        }

        public DMXControlComponent.DMXControlType getDMXControlType() {
            return this.m_DMXControlType;
        }

        public DMXDevice getDMXDevice() {
            return this.m_DMXDevice;
        }
    }

    public static class TreeSource_DMXDevice
    extends TreeSource {
        private DMXDevice m_DMXDevice;
        private String m_DMXDeviceID;

        public TreeSource_DMXDevice(DMXDevice p_DMXDevice) {
            this.m_DMXDevice = p_DMXDevice;
            this.m_DMXDeviceID = p_DMXDevice.getID();
        }

        public DMXDevice getDMXDevice() {
            return this.m_DMXDevice;
        }

        public String getDMXDeviceName() {
            return this.m_DMXDevice.getName();
        }
    }

    public static class TreeSource_DMXControlType
    extends TreeSource {
        private String m_DMXControlDescriptionID;
        private String m_DMXControlDescriptionName;

        public TreeSource_DMXControlType(DMXControlComponent.DMXControlType p_DMXControlType) {
            this.m_DMXControlDescriptionID = p_DMXControlType.getDMXControlDescription().getID();
            this.m_DMXControlDescriptionName = p_DMXControlType.getDMXControlDescription().getName();
        }

        public String getDMXControlDescriptionID() {
            return this.m_DMXControlDescriptionID;
        }

        public String getDMXControlDescriptionName() {
            return this.m_DMXControlDescriptionName;
        }
    }

    public static class TreeSource {
        protected boolean m_IsFadeDefault;

        public TreeSource() {
            this.initMembers();
        }

        private void initMembers() {
            this.m_IsFadeDefault = true;
        }

        public void setIsFadeDefault(boolean p_IsFadeDefault) {
            this.m_IsFadeDefault = p_IsFadeDefault;
        }

        public boolean getIsFadeDefault() {
            return this.m_IsFadeDefault;
        }
    }

    public static class DMXDeviceTreeSelectionModel_Channel
    extends DefaultTreeSelectionModel {
        private DMXControlComponent.ControlDimensionType m_ControlDimensionType;
        private int m_ControlByteIndex;
        private TreeModel_Device_Channels m_DMXDeviceTreeModel;
        private DoUndo m_DoUndo;

        public DMXDeviceTreeSelectionModel_Channel(TreeModel_Device_Channels p_DMXDeviceTreeModel) {
            this.initMembers();
            this.m_DMXDeviceTreeModel = p_DMXDeviceTreeModel;
        }

        private void initMembers() {
            this.m_ControlDimensionType = null;
            this.m_ControlByteIndex = -1;
            super.setSelectionMode(4);
            this.m_DoUndo = new DoUndo();
        }

        @Override
        public void setSelectionMode(int mode) {
            super.setSelectionMode(4);
        }

        @Override
        public void clearSelection() {
            super.clearSelection();
        }

        public void refreshSelection() {
            super.clearSelection();
            this.checkALLDevicesSelected();
            if (this.m_ControlDimensionType == null || this.m_ControlByteIndex < 0) {
                return;
            }
            int intDeviceControlLinkCount = this.m_ControlDimensionType.getDeviceControlLinkCount();
            for (int intLink = 0; intLink < intDeviceControlLinkCount; ++intLink) {
                int intInternalChannel;
                DMXDeviceType.DMXDeviceSector o_DMXDeviceSector;
                DMXDeviceType o_DMXDeviceType;
                DMXDevice o_DMXDevice;
                DMXControlComponent.DeviceControlLink o_DeviceControlLink = this.m_ControlDimensionType.getDeviceControlLink(intLink);
                if (o_DeviceControlLink == null || (o_DMXDevice = o_DeviceControlLink.getDMXDevice()) == null || (o_DMXDeviceType = o_DMXDevice.getDMXDeviceType()) == null || (o_DMXDeviceSector = o_DMXDeviceType.getDMXDeviceSector(o_DeviceControlLink.getDMXDeviceSectorIndex())) == null || (intInternalChannel = o_DeviceControlLink.getDeviceInternalChannel(this.m_ControlByteIndex)) < 0) continue;
                DMXDeviceType.DMXDeviceChannelType o_DMXDeviceChannelType = o_DMXDeviceSector.getDMXDeviceChannelType(intInternalChannel);
                this.addSelectedDMXDeviceChannelType(o_DMXDevice, o_DMXDeviceSector, o_DMXDeviceChannelType);
            }
        }

        public boolean setSelectionFlag(DMXDevice p_DMXDevice, int p_SelectionFlag) {
            TreeNode_Device_Channel o_DMXDeviceTreeNode = this.m_DMXDeviceTreeModel.getTreeNodeDMXDevice(p_DMXDevice);
            if (o_DMXDeviceTreeNode != null) {
                o_DMXDeviceTreeNode.setSelectionFlag(p_SelectionFlag);
                return true;
            }
            return false;
        }

        public boolean addSelectedDMXDeviceChannelType(DMXDevice p_DMXDevice, DMXDeviceType.DMXDeviceSector p_DMXDeviceSector, DMXDeviceType.DMXDeviceChannelType p_DMXDeviceChannelType) {
            if (p_DMXDeviceChannelType == null) {
                return false;
            }
            if (this.m_ControlDimensionType == null) {
                return false;
            }
            TreePath o_TreePath = this.m_DMXDeviceTreeModel.getTreePathToRoot(p_DMXDevice, p_DMXDeviceSector, p_DMXDeviceChannelType);
            if (o_TreePath == null) {
                return false;
            }
            super.addSelectionPath(o_TreePath);
            return true;
        }

        public boolean removeSelectedDMXDeviceChannelType(DMXDevice p_DMXDevice, DMXDeviceType.DMXDeviceSector p_DMXDeviceSector, DMXDeviceType.DMXDeviceChannelType p_DMXDeviceChannelType) {
            if (p_DMXDeviceChannelType == null) {
                return false;
            }
            if (this.m_ControlDimensionType == null) {
                return false;
            }
            TreePath o_TreePath = this.m_DMXDeviceTreeModel.getTreePathToRoot(p_DMXDevice, p_DMXDeviceSector, p_DMXDeviceChannelType);
            if (o_TreePath == null) {
                return false;
            }
            super.removeSelectionPath(o_TreePath);
            return true;
        }

        private void checkALLDevicesSelected() {
            for (int intDevice = 0; intDevice < s_DMXDeviceTableModel.size(); ++intDevice) {
                DMXDevice o_DMXDevice = s_DMXDeviceTableModel.getDMXDevice(intDevice);
                this.checkAllSelected(o_DMXDevice);
            }
        }

        private boolean checkAllSelected(DMXDevice p_DMXDevice) {
            if (p_DMXDevice == null) {
                return false;
            }
            boolean boolAllFound = true;
            boolean boolSomeFound = false;
            DMXDeviceType o_DMXDeviceType = p_DMXDevice.getDMXDeviceType();
            if (this.m_ControlDimensionType == null) {
                return false;
            }
            DMXControlComponent.DMXControlType o_DMXControlType_Mixer = this.m_ControlDimensionType.getDMXControlType();
            int intDMXControlTypeCount = o_DMXDeviceType.getDMXControlTypeCount();
            for (int intDMXControlType = 0; intDMXControlType < intDMXControlTypeCount; ++intDMXControlType) {
                DMXControlComponent.DMXControlType o_DMXControlType_DMXDevice = o_DMXDeviceType.getDMXControlType(intDMXControlType);
                if (o_DMXControlType_DMXDevice == null || !o_DMXControlType_DMXDevice.getDMXControlDescription().getID().equals(o_DMXControlType_Mixer.getDMXControlDescription().getID())) continue;
                ArrayList<DMXControlComponent.DeviceControlLink> o_DeviceControlLinks_DMXDevice = o_DMXControlType_DMXDevice.getDeviceControlLinks();
                for (int intLink = 0; intLink < o_DeviceControlLinks_DMXDevice.size(); ++intLink) {
                    DMXControlComponent.DeviceControlLink o_DeviceControlLink_DMXDeviceType = o_DeviceControlLinks_DMXDevice.get(intLink);
                    if (o_DeviceControlLink_DMXDeviceType == null) continue;
                    int intByteResolution = o_DeviceControlLink_DMXDeviceType.getByteResolution();
                    for (int intByte = 0; intByte < intByteResolution; ++intByte) {
                        int intInternalChannelIndex = o_DeviceControlLink_DMXDeviceType.getDeviceInternalChannel(intByte);
                        if (intInternalChannelIndex < 0) continue;
                        DMXControlComponent.DeviceControlLink o_DeviceControlLink_Mixer = o_DMXControlType_Mixer.getDeviceControlLink(p_DMXDevice, o_DeviceControlLink_DMXDeviceType.getDMXDeviceSectorIndex(), intInternalChannelIndex, o_DeviceControlLink_DMXDeviceType.getControlTypeIndex(), o_DeviceControlLink_DMXDeviceType.getControlDimensionTypeIndex(), intByte);
                        if (o_DeviceControlLink_Mixer == null) {
                            boolAllFound = false;
                            continue;
                        }
                        boolSomeFound = true;
                    }
                }
            }
            if (!boolSomeFound) {
                this.setSelectionFlag(p_DMXDevice, 0);
            } else if (boolAllFound) {
                this.setSelectionFlag(p_DMXDevice, 1);
            } else {
                this.setSelectionFlag(p_DMXDevice, 2);
            }
            return true;
        }

        public void eventMouse(TreePath p_TreePath, MouseEvent p_MouseEvent) {
            if (p_TreePath == null) {
                return;
            }
            if (p_MouseEvent == null) {
                return;
            }
            int intPathCount = p_TreePath.getPathCount();
            if (intPathCount == 0) {
                return;
            }
            Object o_PathComponent = p_TreePath.getLastPathComponent();
            if (!(o_PathComponent instanceof TreeNode_Device_Channel)) {
                return;
            }
            TreeNode_Device_Channel o_TreeNode = (TreeNode_Device_Channel)o_PathComponent;
            if (o_TreeNode.getSourceObject() instanceof DMXDevice) {
                if (this.m_ControlDimensionType == null) {
                    return;
                }
                if (this.m_DMXDeviceTreeModel.isEditorModel()) {
                    return;
                }
                boolean boolAdd = o_TreeNode.getSelectionFlag() == 0;
                DMXDevice o_DMXDevice = (DMXDevice)o_TreeNode.getSourceObject();
                DMXControlComponent.DMXControlType o_DMXControlType_Mixer = this.m_ControlDimensionType.getDMXControlType();
                DMXDeviceType o_DMXDeviceType = o_DMXDevice.getDMXDeviceType();
                int intDMXControlTypeCount = o_DMXDeviceType.getDMXControlTypeCount();
                for (int intDMXControlType = 0; intDMXControlType < intDMXControlTypeCount; ++intDMXControlType) {
                    ArrayList<DMXControlComponent.DeviceControlLink> o_DeviceControlLinks_DMXDeviceType;
                    DMXControlComponent.DMXControlType o_DMXControlType_DMXDevice = o_DMXDeviceType.getDMXControlType(intDMXControlType);
                    if (o_DMXControlType_DMXDevice == null || !o_DMXControlType_DMXDevice.getDMXControlDescription().getID().equals(o_DMXControlType_Mixer.getDMXControlDescription().getID()) || (o_DeviceControlLinks_DMXDeviceType = o_DMXControlType_DMXDevice.getDeviceControlLinks()) == null) continue;
                    for (int intLink = 0; intLink < o_DeviceControlLinks_DMXDeviceType.size(); ++intLink) {
                        DMXControlComponent.DeviceControlLink o_DeviceControlLink_DMXDeviceType = o_DeviceControlLinks_DMXDeviceType.get(intLink);
                        if (o_DeviceControlLink_DMXDeviceType == null) continue;
                        int intControlTypeIndex = o_DeviceControlLink_DMXDeviceType.getControlTypeIndex();
                        int intDMXDeviceSectorIndex = o_DeviceControlLink_DMXDeviceType.getDMXDeviceSectorIndex();
                        int intControlDimensionIndex = o_DeviceControlLink_DMXDeviceType.getControlDimensionTypeIndex();
                        int intByteResolution = o_DeviceControlLink_DMXDeviceType.getByteResolution();
                        DMXControlComponent.ControlType o_ControlType_Mixer = o_DMXControlType_Mixer.getControlType(intControlTypeIndex);
                        DMXControlComponent.ControlDimensionType o_ControlDimensionType_Mixer = o_ControlType_Mixer.getControlDimensionType(intControlDimensionIndex);
                        for (int intByte = 0; intByte < intByteResolution; ++intByte) {
                            DMXControlComponent.ControlDimensionType o_ControlDimensionTypeFinal;
                            int intChannelIndexFinal;
                            int intByteIndexFinal;
                            int intSectorIndexFinal;
                            DMXDevice o_DMXDeviceFinal;
                            int intInternalChannelIndex = o_DeviceControlLink_DMXDeviceType.getDeviceInternalChannel(intByte);
                            if (intInternalChannelIndex < 0) continue;
                            DMXControlComponent.DeviceControlLink o_DeviceControlLink_Mixer = o_ControlDimensionType_Mixer.findDeviceControlLink(o_DMXDevice, intDMXDeviceSectorIndex, intByte, intInternalChannelIndex);
                            if (!boolAdd) {
                                if (o_DeviceControlLink_Mixer == null || !o_ControlDimensionType_Mixer.removeDeviceControlLink(o_DMXDevice, intDMXDeviceSectorIndex, intByte, intInternalChannelIndex)) continue;
                                o_DMXDeviceFinal = o_DMXDevice;
                                intSectorIndexFinal = intDMXDeviceSectorIndex;
                                intByteIndexFinal = intByte;
                                intChannelIndexFinal = intInternalChannelIndex;
                                o_ControlDimensionTypeFinal = o_ControlDimensionType_Mixer;
                                this.m_DoUndo.addUndo(new Runnable(){

                                    @Override
                                    public void run() {
                                        o_ControlDimensionTypeFinal.addDeviceControlLink(o_DMXDeviceFinal, intSectorIndexFinal, intByteIndexFinal, intChannelIndexFinal);
                                    }
                                });
                                continue;
                            }
                            if (o_ControlDimensionType_Mixer.addDeviceControlLink(o_DMXDevice, intDMXDeviceSectorIndex, intByte, intInternalChannelIndex) == null) continue;
                            o_DMXDeviceFinal = o_DMXDevice;
                            intSectorIndexFinal = intDMXDeviceSectorIndex;
                            intByteIndexFinal = intByte;
                            intChannelIndexFinal = intInternalChannelIndex;
                            o_ControlDimensionTypeFinal = o_ControlDimensionType_Mixer;
                            this.m_DoUndo.addUndo(new Runnable(){

                                @Override
                                public void run() {
                                    o_ControlDimensionTypeFinal.removeDeviceControlLink(o_DMXDeviceFinal, intSectorIndexFinal, intByteIndexFinal, intChannelIndexFinal);
                                }
                            });
                        }
                    }
                    this.refreshSelection();
                }
            } else if (!(o_TreeNode.getSourceObject() instanceof DMXDeviceType.DMXDeviceSector) && o_TreeNode.getSourceObject() instanceof DMXDeviceType.DMXDeviceChannelType) {
                TreeNode_Device_Channel o_TreeNodeDMXDevice = (TreeNode_Device_Channel)p_TreePath.getPathComponent(intPathCount - 3);
                TreeNode_Device_Channel o_TreeNodeDMXDeviceSector = (TreeNode_Device_Channel)p_TreePath.getPathComponent(intPathCount - 2);
                DMXDevice o_DMXDevice = (DMXDevice)o_TreeNodeDMXDevice.getSourceObject();
                DMXDeviceType.DMXDeviceSector o_DMDeviceSector = (DMXDeviceType.DMXDeviceSector)o_TreeNodeDMXDeviceSector.getSourceObject();
                DMXDeviceType.DMXDeviceChannelType o_DMXDeviceChannelType = (DMXDeviceType.DMXDeviceChannelType)o_TreeNode.getSourceObject();
                this.toggleSelection(this.m_ControlDimensionType, this.m_ControlByteIndex, o_DMXDevice, o_DMDeviceSector, o_DMXDeviceChannelType);
            }
        }

        public void toggleSelection(final DMXControlComponent.ControlDimensionType p_ControlDimensionType, int p_ControlByteIndex, DMXDevice p_DMXDevice, DMXDeviceType.DMXDeviceSector p_DMXDeviceSector, DMXDeviceType.DMXDeviceChannelType p_DMXDeviceChannelType) {
            if (p_ControlDimensionType == null || p_DMXDevice == null || p_DMXDeviceSector == null || p_DMXDeviceChannelType == null) {
                return;
            }
            boolean boolFound = false;
            DMXControlComponent.DeviceControlLink o_DeviceControlLink = p_ControlDimensionType.findDeviceControlLink(p_DMXDevice, p_DMXDeviceSector.getSectorIndex(), p_ControlByteIndex, p_DMXDeviceChannelType.getChannelIndex());
            if (o_DeviceControlLink == null) {
                if (p_ControlDimensionType.addDeviceControlLink(p_DMXDevice, p_DMXDeviceSector.getSectorIndex(), p_ControlByteIndex, p_DMXDeviceChannelType.getChannelIndex()) != null) {
                    final DMXDevice o_DMXDevice = p_DMXDevice;
                    final int intSectorIndex = p_DMXDeviceSector.getSectorIndex();
                    final int intByteIndex = p_ControlByteIndex;
                    final int intChannelIndex = p_DMXDeviceChannelType.getChannelIndex();
                    this.m_DoUndo.addUndo(new Runnable(){

                        @Override
                        public void run() {
                            p_ControlDimensionType.removeDeviceControlLink(o_DMXDevice, intSectorIndex, intByteIndex, intChannelIndex);
                        }
                    });
                    this.refreshSelection();
                }
            } else if (p_ControlDimensionType.removeDeviceControlLink(p_DMXDevice, p_DMXDeviceSector.getSectorIndex(), p_ControlByteIndex, p_DMXDeviceChannelType.getChannelIndex())) {
                final DMXDevice o_DMXDevice = p_DMXDevice;
                final int intSectorIndex = p_DMXDeviceSector.getSectorIndex();
                final int intByteIndex = p_ControlByteIndex;
                final int intChannelIndex = p_DMXDeviceChannelType.getChannelIndex();
                this.m_DoUndo.addUndo(new Runnable(){

                    @Override
                    public void run() {
                        p_ControlDimensionType.addDeviceControlLink(o_DMXDevice, intSectorIndex, intByteIndex, intChannelIndex);
                    }
                });
                this.refreshSelection();
            }
        }

        public void setControlDimensionType(DMXControlComponent.ControlDimensionType p_ControlDimensionType, int p_ByteIndex) {
            if (p_ControlDimensionType == null) {
                this.clearSelection();
                this.m_ControlDimensionType = null;
                this.m_ControlByteIndex = -1;
                return;
            }
            this.m_ControlDimensionType = p_ControlDimensionType;
            this.m_ControlByteIndex = p_ByteIndex;
            this.refreshSelection();
        }

        public DMXControlComponent.ControlDimensionType getControlDimensionType() {
            return this.m_ControlDimensionType;
        }

        @Override
        public void setSelectionPath(TreePath path) {
        }

        public void cancel() {
            this.m_DoUndo.undo();
            this.refreshSelection();
        }

        public void save() {
            this.m_DoUndo.clear();
            this.refreshSelection();
        }

        public class DoUndo {
            ArrayList<Runnable> m_Undos;

            public DoUndo() {
                this.initMembers();
            }

            private void initMembers() {
                this.m_Undos = new ArrayList();
            }

            public void addUndo(Runnable p_Runnable) {
                if (p_Runnable == null) {
                    return;
                }
                this.m_Undos.add(p_Runnable);
            }

            public void clear() {
                this.m_Undos.clear();
            }

            public void undo() {
                for (int intUndo = this.m_Undos.size() - 1; intUndo >= 0; --intUndo) {
                    Runnable o_Runnable = this.m_Undos.get(intUndo);
                    if (o_Runnable == null) continue;
                    o_Runnable.run();
                    this.m_Undos.remove(intUndo);
                }
            }
        }
    }

    public static class TreeCellRenderer_Device_Channels
    extends JPanel
    implements TreeCellRenderer {
        private JCheckBox_MultiSelection jCheckBox_Selection;
        private JLabelBackground jLabelIcon;
        private JLabel jLabelNode;
        private StringBuilder m_StringBuilder;

        public TreeCellRenderer_Device_Channels() {
            this.initMembers();
            this.initComponents();
        }

        private void initMembers() {
            this.m_StringBuilder = new StringBuilder();
        }

        private void initComponents() {
            this.setLayout(new GridBagLayout());
            this.setOpaque(false);
            this.setPreferredSize(new Dimension(300, 24));
            this.jCheckBox_Selection = new JCheckBox_MultiSelection();
            GridBagConstraints o_GridBagConstraints = new GridBagConstraints();
            o_GridBagConstraints.gridx = 0;
            o_GridBagConstraints.gridy = 0;
            this.add((Component)this.jCheckBox_Selection, o_GridBagConstraints);
            this.jLabelIcon = new JLabelBackground();
            this.jLabelIcon.setBackgroundOpaque(true);
            this.jLabelIcon.setBackgroundStyle(3);
            this.jLabelIcon.setMinimumSize(new Dimension(24, 24));
            this.jLabelIcon.setPreferredSize(new Dimension(24, 24));
            o_GridBagConstraints = new GridBagConstraints();
            o_GridBagConstraints.gridx = 1;
            o_GridBagConstraints.gridy = 0;
            o_GridBagConstraints.fill = 0;
            this.add((Component)this.jLabelIcon, o_GridBagConstraints);
            this.jLabelIcon.setVisible(true);
            this.jLabelNode = new JLabel();
            this.jLabelNode.setOpaque(true);
            this.jLabelNode.setMinimumSize(new Dimension(150, 25));
            this.jLabelNode.setPreferredSize(new Dimension(150, 25));
            o_GridBagConstraints = new GridBagConstraints();
            o_GridBagConstraints.gridx = 2;
            o_GridBagConstraints.gridy = 0;
            o_GridBagConstraints.weightx = 1.0;
            o_GridBagConstraints.weighty = 1.0;
            o_GridBagConstraints.fill = 1;
            this.add((Component)this.jLabelNode, o_GridBagConstraints);
            this.jLabelNode.setVisible(true);
            this.setVisible(true);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Color o_Background = tree.getBackground();
            Color o_Foreground = UIManager.getColor("Tree.textForeground");
            if (selected) {
                if (tree.hasFocus()) {
                    o_Foreground = UIManager.getColor("Tree.selectionForeground");
                    o_Background = UIManager.getColor("Tree.selectionBackground");
                } else {
                    o_Foreground = UIManager.getColor("Tree.selectionInactiveForeground");
                    o_Background = UIManager.getColor("Tree.selectionInactiveBackground");
                }
            }
            this.jLabelIcon.setForeground(o_Foreground);
            this.jLabelIcon.setBackground(o_Background);
            this.jLabelNode.setForeground(o_Foreground);
            this.jLabelNode.setBackground(o_Background);
            if (!(value instanceof TreeNode_Device_Channel)) {
                return this;
            }
            TreeNode_Device_Channel o_DMXDeviceTreeNode_Channel = (TreeNode_Device_Channel)value;
            Object o_SourceObject = ((TreeNode_Device_Channel)value).getSourceObject();
            TreeModel_Device_Channels o_DMXDeviceTreeModel_Channel = (TreeModel_Device_Channels)tree.getModel();
            boolean boolIsEditorModel = o_DMXDeviceTreeModel_Channel.m_IsEditorModel;
            this.m_StringBuilder.delete(0, this.m_StringBuilder.length());
            this.jLabelIcon.setIcon(null);
            if (o_SourceObject == null) {
                this.jLabelIcon.setVisible(false);
                this.jCheckBox_Selection.setVisible(false);
                this.jLabelNode.setText("-");
                this.jLabelIcon.setBackgroundImage(null);
                this.jLabelNode.setBackground(DMXHardwareInterface.COLOR_CONNECTIONSTATUS_NOHARDWARE);
            } else if (o_SourceObject instanceof DMXDevice) {
                if (!boolIsEditorModel) {
                    this.jCheckBox_Selection.setVisible(true);
                } else {
                    this.jCheckBox_Selection.setVisible(false);
                }
                this.jCheckBox_Selection.setSelection(o_DMXDeviceTreeNode_Channel.getSelectionFlag());
                DMXDevice o_DMXDevice = (DMXDevice)o_SourceObject;
                Image o_Image = o_DMXDevice.getDeviceImage();
                this.jLabelIcon.setBackgroundImage(o_Image);
                if (o_Image == null) {
                    this.jLabelIcon.setVisible(false);
                } else {
                    this.jLabelIcon.setVisible(true);
                }
                this.m_StringBuilder.append(o_DMXDevice.getName());
                this.jLabelNode.setText(this.m_StringBuilder.toString());
            } else if (o_SourceObject instanceof DMXDeviceType.DMXDeviceSector) {
                InternalSector o_InternalSector;
                DMXDevice o_DMXDevice;
                DMXUniverse o_DMXUniverse = null;
                DMXDeviceType.DMXDeviceSector o_DMXDeviceSector = (DMXDeviceType.DMXDeviceSector)o_SourceObject;
                TreeNode o_DMXDeviceTreeNode = o_DMXDeviceTreeNode_Channel.getParent();
                if (o_DMXDeviceTreeNode != null && (o_DMXDevice = (DMXDevice)((TreeNode_Device_Channel)o_DMXDeviceTreeNode).getSourceObject()) != null && (o_InternalSector = o_DMXDevice.getInternalSector(o_DMXDeviceSector.getSectorIndex())) != null) {
                    o_DMXUniverse = o_InternalSector.getDMXUniverse();
                }
                this.jLabelIcon.setBackgroundImage(null);
                this.jLabelIcon.setVisible(false);
                this.jCheckBox_Selection.setVisible(false);
                this.m_StringBuilder.append(DMXDeviceType.SECTORNAME);
                this.m_StringBuilder.append(" ");
                this.m_StringBuilder.append(o_DMXDeviceSector.getSectorIndex() + 1);
                if (o_DMXUniverse != null) {
                    this.m_StringBuilder.append(" -> ");
                    this.m_StringBuilder.append(o_DMXUniverse.getName());
                    switch (o_DMXUniverse.getConnectionStatus_Output()) {
                        case 2: {
                            this.jLabelNode.setBackground(DMXHardwareInterface.COLOR_CONNECTIONSTATUS_NOTCONNECTED);
                            break;
                        }
                        case 3: {
                            this.jLabelNode.setBackground(DMXHardwareInterface.COLOR_CONNECTIONSTATUS_PROGRESS);
                            break;
                        }
                        case 4: {
                            this.jLabelNode.setBackground(DMXHardwareInterface.COLOR_CONNECTIONSTATUS_CONNECTED);
                            break;
                        }
                        case 5: {
                            this.jLabelNode.setBackground(DMXHardwareInterface.COLOR_CONNECTIONSTATUS_CHECKED);
                            break;
                        }
                        case 6: {
                            this.jLabelNode.setBackground(DMXHardwareInterface.COLOR_CONNECTIONSTATUS_SOMECHECKED);
                            break;
                        }
                        default: {
                            this.jLabelNode.setBackground(DMXHardwareInterface.COLOR_CONNECTIONSTATUS_NOHARDWARE);
                        }
                    }
                }
                this.jLabelNode.setText(this.m_StringBuilder.toString());
            } else if (o_SourceObject instanceof DMXDeviceType.DMXDeviceChannelType) {
                DMXDeviceType.DMXDeviceChannelType o_DMXDeviceChannelType = (DMXDeviceType.DMXDeviceChannelType)o_SourceObject;
                this.jLabelIcon.setBackgroundImage(null);
                this.jLabelIcon.setVisible(false);
                this.jCheckBox_Selection.setVisible(true);
                if (selected) {
                    this.jCheckBox_Selection.setSelection(1);
                } else {
                    this.jCheckBox_Selection.setSelection(0);
                }
                this.jCheckBox_Selection.setEnabled(true);
                this.m_StringBuilder.append(CHANNEL);
                this.m_StringBuilder.append("_");
                this.m_StringBuilder.append(o_DMXDeviceChannelType.getChannelIndex() + 1);
                this.m_StringBuilder.append(": ");
                this.m_StringBuilder.append(o_DMXDeviceChannelType.getChannelName());
                this.jLabelNode.setText(this.m_StringBuilder.toString());
            }
            return this;
        }
    }

    public static class TreeModel_Device_Channels
    implements TreeModel {
        public static final String PROP_DMXDEVICETREEMODEL_DEVICEADDED = "dmxdevicetreemodelDMXDeviceAdded";
        public static final String PROP_DMXDEVICETREEMODEL_DEVICEREMOVED = "dmxdevicetreemodelDMXDeviceRemoved";
        protected TreeNode_Device_Channel m_Root;
        protected ArrayList<TreeModelListener> m_TreeModelListeners;
        protected ArrayList<DMXDevice> m_DMXDevices;
        protected HashMap<String, DMXDevice> m_HashMapDMXDevices;
        protected SinglePropertyChangeSupport m_PropertyChangeSupport;
        protected boolean m_IsEditorModel;
        protected final Object m_SyncDMXDevices = new Object();
        private final Object m_SyncListeners = new Object();

        public TreeModel_Device_Channels(boolean p_IsEditorModel) {
            this.initMembers();
            this.m_IsEditorModel = p_IsEditorModel;
            this.m_Root = new TreeNode_Device_Channel<Object>(null, this);
            this.m_TreeModelListeners = new ArrayList();
        }

        private void initMembers() {
            this.m_PropertyChangeSupport = new SinglePropertyChangeSupport(this);
            this.m_DMXDevices = new ArrayList();
            this.m_HashMapDMXDevices = new HashMap();
        }

        public boolean isEditorModel() {
            return this.m_IsEditorModel;
        }

        public void addDMXDevice(DMXDevice p_DMXDevice) {
            DMXDeviceType o_DMXDeviceType;
            if (p_DMXDevice == null) {
                return;
            }
            TreeNode_Device_Channel o_RootNode = (TreeNode_Device_Channel)this.getRoot();
            TreeNode_Device_Channel<DMXDevice> o_DMXDeviceNode = this.getTreeNode(o_RootNode, p_DMXDevice);
            if (o_DMXDeviceNode == null) {
                o_DMXDeviceNode = new TreeNode_Device_Channel<DMXDevice>(p_DMXDevice, this);
                this.addChild(o_RootNode, o_DMXDeviceNode);
                this.resortDMXDevice(p_DMXDevice);
                this.m_HashMapDMXDevices.put(p_DMXDevice.getID(), p_DMXDevice);
                p_DMXDevice.addPropertyChangeListener(o_DMXDeviceNode);
            }
            if ((o_DMXDeviceType = p_DMXDevice.getDMXDeviceType()) != null) {
                for (int intSector = 0; intSector < o_DMXDeviceType.getDMXDeviceSectorCount(); ++intSector) {
                    DMXDeviceType.DMXDeviceSector o_DMXDeviceSectorType = o_DMXDeviceType.getDMXDeviceSector(intSector);
                    TreeNode_Device_Channel<DMXDeviceType.DMXDeviceSector> o_DMXDeviceSectorNode = this.getTreeNode(o_DMXDeviceNode, o_DMXDeviceSectorType);
                    if (o_DMXDeviceSectorNode == null) {
                        o_DMXDeviceSectorNode = new TreeNode_Device_Channel<DMXDeviceType.DMXDeviceSector>(o_DMXDeviceSectorType, this);
                        this.addChild(o_DMXDeviceNode, o_DMXDeviceSectorNode);
                        o_DMXDeviceSectorType.addPropertyChangeListener(o_DMXDeviceSectorNode);
                    }
                    for (int intChannel = 0; intChannel < o_DMXDeviceSectorType.getChannelCount(); ++intChannel) {
                        DMXDeviceType.DMXDeviceChannelType o_DMXDeviceChannelType = o_DMXDeviceSectorType.getDMXDeviceChannelType(intChannel);
                        TreeNode_Device_Channel<DMXDeviceType.DMXDeviceChannelType> o_DMXDeviceChannelNode = this.getTreeNode(o_DMXDeviceSectorNode, o_DMXDeviceChannelType);
                        if (o_DMXDeviceChannelNode != null) continue;
                        o_DMXDeviceChannelNode = new TreeNode_Device_Channel<DMXDeviceType.DMXDeviceChannelType>(o_DMXDeviceChannelType, this);
                        this.addChild(o_DMXDeviceSectorNode, o_DMXDeviceChannelNode);
                        o_DMXDeviceChannelType.addPropertyChangeListener(o_DMXDeviceChannelNode);
                    }
                }
            }
            this.m_PropertyChangeSupport.firePropertyChange(PROP_DMXDEVICETREEMODEL_DEVICEADDED, null, p_DMXDevice);
            DMXDevice.firePropertyChangeDMXDeviceList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeDMXDevice(DMXDevice p_DMXDevice) {
            if (p_DMXDevice == null) {
                return;
            }
            TreeNode_Device_Channel o_Root = (TreeNode_Device_Channel)this.getRoot();
            TreeNode_Device_Channel o_DMXDeviceNode = this.getTreeNode(o_Root, p_DMXDevice);
            if (o_DMXDeviceNode == null) {
                return;
            }
            DMXDeviceType o_DMXDeviceType = p_DMXDevice.getDMXDeviceType();
            if (o_DMXDeviceType != null) {
                for (int intSector = o_DMXDeviceType.getDMXDeviceSectorCount() - 1; intSector >= 0; --intSector) {
                    TreeNode_Device_Channel o_DMXDeviceSectorNode;
                    DMXDeviceType.DMXDeviceSector o_DMXDeviceSector = o_DMXDeviceType.getDMXDeviceSector(intSector);
                    if (o_DMXDeviceSector == null || (o_DMXDeviceSectorNode = this.getTreeNode(o_DMXDeviceNode, o_DMXDeviceSector)) == null) continue;
                    for (int intChannel = o_DMXDeviceSector.getChannelCount() - 1; intChannel >= 0; --intChannel) {
                        TreeNode_Device_Channel o_DMXDeviceChannelNode;
                        DMXDeviceType.DMXDeviceChannelType o_DMXDeviceChannelType = o_DMXDeviceSector.getDMXDeviceChannelType(intChannel);
                        if (o_DMXDeviceChannelType == null || (o_DMXDeviceChannelNode = this.getTreeNode(o_DMXDeviceSectorNode, o_DMXDeviceChannelType)) == null) continue;
                        o_DMXDeviceChannelType.removePropertyChangeListener(o_DMXDeviceChannelNode);
                        this.removeChild(o_DMXDeviceSectorNode, o_DMXDeviceChannelNode);
                    }
                    o_DMXDeviceSector.removePropertyChangeListener(o_DMXDeviceSectorNode);
                    p_DMXDevice.removePropertyChangeListener(o_DMXDeviceSectorNode);
                    this.removeChild(o_DMXDeviceNode, o_DMXDeviceSectorNode);
                }
            }
            p_DMXDevice.removePropertyChangeListener(o_DMXDeviceNode);
            this.removeChild(o_Root, o_DMXDeviceNode);
            Object object = this.m_SyncDMXDevices;
            synchronized (object) {
                this.m_DMXDevices.remove(p_DMXDevice);
                this.m_HashMapDMXDevices.remove(p_DMXDevice.getID());
            }
            this.m_PropertyChangeSupport.firePropertyChange(PROP_DMXDEVICETREEMODEL_DEVICEREMOVED, p_DMXDevice, null);
            DMXDevice.firePropertyChangeDMXDeviceList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void resortDMXDevice(DMXDevice p_DMXDevice) {
            Object object = this.m_SyncDMXDevices;
            synchronized (object) {
                DMXDevice o_DMXDevice;
                int intDevice;
                int intIndexOld = this.m_DMXDevices.indexOf(p_DMXDevice);
                for (intDevice = 0; intDevice < this.m_DMXDevices.size() && ((o_DMXDevice = this.m_DMXDevices.get(intDevice)) == null || o_DMXDevice.getName().compareToIgnoreCase(p_DMXDevice.getName()) < 0); ++intDevice) {
                }
                if (intIndexOld < 0) {
                    this.m_DMXDevices.add(intDevice, p_DMXDevice);
                } else {
                    if (intIndexOld == intDevice) {
                        DMXDevice.firePropertyChangeDMXDeviceList();
                        return;
                    }
                    this.m_DMXDevices.add(intDevice, p_DMXDevice);
                    if (intIndexOld >= intDevice) {
                        ++intIndexOld;
                    }
                    this.m_DMXDevices.remove(intIndexOld);
                    DMXDevice.firePropertyChangeDMXDeviceList();
                }
            }
        }

        @Override
        public Object getRoot() {
            return this.m_Root;
        }

        public void addChild(TreeNode_Device_Channel parent, TreeNode_Device_Channel p_Child) {
            if (parent == null) {
                return;
            }
            if (p_Child == null) {
                return;
            }
            parent.addChild(p_Child);
            Object[] o_ParentPathToRoot = (TreeNode_Device_Channel[])this.getPathToRoot(parent);
            int[] o_Indexs = new int[1];
            Object[] o_Childs = new Object[1];
            o_Indexs[0] = parent.getIndex(p_Child);
            o_Childs[0] = p_Child;
            if (o_Indexs[0] != -1) {
                this.fireTreeNodesInserted(this, o_ParentPathToRoot, o_Indexs, o_Childs);
            }
        }

        public void removeChild(TreeNode_Device_Channel p_ParentTreeNode, TreeNode_Device_Channel p_ChildTreeNode) {
            if (p_ParentTreeNode == null) {
                return;
            }
            if (p_ChildTreeNode == null) {
                return;
            }
            int[] o_Indexs = new int[1];
            Object[] o_Childs = new Object[1];
            o_Indexs[0] = p_ParentTreeNode.getIndex(p_ChildTreeNode);
            o_Childs[0] = p_ChildTreeNode;
            if (o_Indexs[0] != -1) {
                Object[] o_ParentPathToRoot = (TreeNode_Device_Channel[])this.getPathToRoot(p_ParentTreeNode);
                p_ParentTreeNode.removeChild(p_ChildTreeNode);
                this.fireTreeNodesRemoved(this, o_ParentPathToRoot, o_Indexs, o_Childs);
                this.invokeTreeNodeChanged(p_ParentTreeNode);
            }
        }

        @Override
        public TreeNode_Device_Channel getChild(Object parent, int index) {
            if (parent instanceof TreeNode_Device_Channel) {
                return ((TreeNode_Device_Channel)parent).getChildAt(index);
            }
            return null;
        }

        @Override
        public int getChildCount(Object parent) {
            if (parent instanceof TreeNode_Device_Channel) {
                return ((TreeNode_Device_Channel)parent).getChildCount();
            }
            return 0;
        }

        @Override
        public boolean isLeaf(Object node) {
            if (node instanceof TreeNode_Device_Channel) {
                return ((TreeNode_Device_Channel)node).isLeaf();
            }
            return true;
        }

        @Override
        public void valueForPathChanged(TreePath path, Object newValue) {
        }

        @Override
        public int getIndexOfChild(Object parent, Object child) {
            if (parent instanceof TreeNode_Device_Channel) {
                return ((TreeNode_Device_Channel)parent).getIndex((TreeNode_Device_Channel)child);
            }
            return 0;
        }

        public ArrayList<TreeNode_Device_Channel> getArrayListPathToRoot(TreeNode_Device_Channel p_TreeNode) {
            ArrayList<TreeNode_Device_Channel> o_ArrayListPathToRoot = new ArrayList<TreeNode_Device_Channel>();
            for (TreeNode o_TreeNode = p_TreeNode; o_TreeNode != null; o_TreeNode = o_TreeNode.getParent()) {
                o_ArrayListPathToRoot.add(0, (TreeNode_Device_Channel)o_TreeNode);
            }
            return o_ArrayListPathToRoot;
        }

        public Object[] getPathToRoot(TreeNode_Device_Channel p_DeviceNode) {
            ArrayList<TreeNode_Device_Channel> o_ArrayListPathToRoot = this.getArrayListPathToRoot(p_DeviceNode);
            Object[] o_PathToRoot = new TreeNode_Device_Channel[o_ArrayListPathToRoot.size()];
            for (int intNode = 0; intNode < o_ArrayListPathToRoot.size(); ++intNode) {
                o_PathToRoot[intNode] = o_ArrayListPathToRoot.get(intNode);
            }
            return o_PathToRoot;
        }

        public TreePath getTreePathToRoot(TreeNode_Device_Channel p_DeviceNode) {
            return new TreePath(this.getPathToRoot(p_DeviceNode));
        }

        public TreePath getTreePathToRoot(DMXDevice p_DMXDevice) {
            if (p_DMXDevice == null) {
                return null;
            }
            TreeNode_Device_Channel o_DMXDeviceTreeNode = this.getTreeNodeDMXDevice(p_DMXDevice);
            return new TreePath(this.getPathToRoot(o_DMXDeviceTreeNode));
        }

        public TreePath getTreePathToRoot(DMXDevice p_DMXDevice, DMXDeviceType.DMXDeviceSector p_DMXDeviceSector) {
            if (p_DMXDeviceSector == null) {
                return null;
            }
            TreeNode_Device_Channel o_DMXDeviceChannelTypeTreeNode = this.getTreeNodeDMXDeviceSector(p_DMXDevice, p_DMXDeviceSector);
            return new TreePath(this.getPathToRoot(o_DMXDeviceChannelTypeTreeNode));
        }

        public TreePath getTreePathToRoot(DMXDevice p_DMXDevice, DMXDeviceType.DMXDeviceSector p_DMXDeviceSector, DMXDeviceType.DMXDeviceChannelType p_DMXDeviceChannelType) {
            if (p_DMXDeviceChannelType == null) {
                return null;
            }
            TreeNode_Device_Channel o_DMXDeviceChannelTypeTreeNode = this.getTreeNodeDMXDeviceChannelDecription(p_DMXDevice, p_DMXDeviceSector, p_DMXDeviceChannelType);
            return new TreePath(this.getPathToRoot(o_DMXDeviceChannelTypeTreeNode));
        }

        public TreeNode_Device_Channel getTreeNode(TreeNode_Device_Channel p_ParentNode, Object p_SourceObject) {
            if (p_ParentNode == null) {
                p_ParentNode = (TreeNode_Device_Channel)this.getRoot();
            }
            ArrayList<TreeNode_Device_Channel<?>> o_Children = p_ParentNode.getChildren();
            for (int intChild = 0; intChild < o_Children.size(); ++intChild) {
                TreeNode o_ChildNode = p_ParentNode.getChildAt(intChild);
                if (o_ChildNode == null || ((TreeNode_Device_Channel)o_ChildNode).getSourceObject() != p_SourceObject) continue;
                return o_ChildNode;
            }
            return null;
        }

        public TreeNode_Device_Channel getTreeNodeDMXDevice(DMXDevice p_DMXDevice) {
            if (p_DMXDevice == null) {
                return null;
            }
            TreeNode_Device_Channel o_Root = (TreeNode_Device_Channel)this.getRoot();
            return this.getTreeNode(o_Root, p_DMXDevice);
        }

        public TreeNode_Device_Channel getTreeNodeDMXDeviceSector(DMXDevice p_DMXDevice, DMXDeviceType.DMXDeviceSector p_DMXDeviceSector) {
            if (p_DMXDevice == null || p_DMXDeviceSector == null) {
                return null;
            }
            TreeNode_Device_Channel o_DMXDeviceTreeNode = this.getTreeNodeDMXDevice(p_DMXDevice);
            if (o_DMXDeviceTreeNode == null) {
                return null;
            }
            return this.getTreeNode(o_DMXDeviceTreeNode, p_DMXDeviceSector);
        }

        public TreeNode_Device_Channel getTreeNodeDMXDeviceChannelDecription(DMXDevice p_DMXDevice, DMXDeviceType.DMXDeviceSector p_DMXDeviceSector, DMXDeviceType.DMXDeviceChannelType p_DMXDeviceChannelType) {
            if (p_DMXDevice == null || p_DMXDeviceChannelType == null) {
                return null;
            }
            TreeNode_Device_Channel o_DMXDeviceTreeNode = this.getTreeNodeDMXDevice(p_DMXDevice);
            if (o_DMXDeviceTreeNode == null) {
                return null;
            }
            TreeNode_Device_Channel o_DMXDeviceSectorTreeNode = this.getTreeNodeDMXDeviceSector(p_DMXDevice, p_DMXDeviceSector);
            return this.getTreeNode(o_DMXDeviceSectorTreeNode, p_DMXDeviceChannelType);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addTreeModelListener(TreeModelListener p_TreeModelListener) {
            if (p_TreeModelListener == null) {
                return;
            }
            Object object = this.m_SyncListeners;
            synchronized (object) {
                if (this.m_TreeModelListeners.contains(p_TreeModelListener)) {
                    return;
                }
                this.m_TreeModelListeners.add(p_TreeModelListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeTreeModelListener(TreeModelListener p_TreeModelListener) {
            Object object = this.m_SyncListeners;
            synchronized (object) {
                if (p_TreeModelListener == null) {
                    return;
                }
                this.m_TreeModelListeners.remove(p_TreeModelListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void fireTreeNodesInserted(Object source, Object[] path, int[] childIndices, Object[] children) {
            ArrayList<TreeModelListener> o_Listeners;
            Object object = this.m_SyncListeners;
            synchronized (object) {
                o_Listeners = new ArrayList<TreeModelListener>(this.m_TreeModelListeners.size());
                o_Listeners.addAll(this.m_TreeModelListeners);
            }
            TreeModelEvent e = null;
            for (int i = 0; i < o_Listeners.size(); ++i) {
                if (e == null) {
                    e = new TreeModelEvent(source, path, childIndices, children);
                }
                ((TreeModelListener)o_Listeners.get(i)).treeNodesInserted(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void fireTreeNodesRemoved(Object source, Object[] path, int[] childIndices, Object[] children) {
            ArrayList<TreeModelListener> o_Listeners;
            Object object = this.m_SyncListeners;
            synchronized (object) {
                o_Listeners = new ArrayList<TreeModelListener>(this.m_TreeModelListeners.size());
                o_Listeners.addAll(this.m_TreeModelListeners);
            }
            TreeModelEvent e = null;
            for (int i = 0; i < o_Listeners.size(); ++i) {
                if (e == null) {
                    e = new TreeModelEvent(source, path, childIndices, children);
                }
                ((TreeModelListener)o_Listeners.get(i)).treeNodesRemoved(e);
            }
        }

        private void invokeTreeNodeChanged(TreeNode_Device_Channel p_ChangedTreeNode) {
            if (p_ChangedTreeNode == null) {
                return;
            }
            TreeNode o_ParentNode = p_ChangedTreeNode.getParent();
            if (o_ParentNode == null) {
                if (p_ChangedTreeNode == this.getRoot()) {
                    this.fireTreeNodesChanged(this, this.getPathToRoot(p_ChangedTreeNode), null, null);
                }
            } else {
                int[] o_Indexs = new int[]{((TreeNode_Device_Channel)o_ParentNode).getIndex(p_ChangedTreeNode)};
                if (o_Indexs[0] != -1) {
                    Object[] o_Childs = new Object[]{p_ChangedTreeNode};
                    this.fireTreeNodesChanged(this, this.getPathToRoot((TreeNode_Device_Channel)o_ParentNode), o_Indexs, o_Childs);
                }
            }
        }

        public void fireTreeNodeChanged(TreeNode p_ChangedTreeNode) {
            if (p_ChangedTreeNode == null) {
                return;
            }
            this.invokeTreeNodeChanged((TreeNode_Device_Channel)p_ChangedTreeNode);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireTreeNodesChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
            ArrayList<TreeModelListener> o_Listeners;
            Object object = this.m_SyncListeners;
            synchronized (object) {
                o_Listeners = new ArrayList<TreeModelListener>(this.m_TreeModelListeners.size());
                o_Listeners.addAll(this.m_TreeModelListeners);
            }
            TreeModelEvent e = null;
            for (int i = 0; i < o_Listeners.size(); ++i) {
                if (e == null) {
                    e = new TreeModelEvent(source, path, childIndices, children);
                }
                ((TreeModelListener)o_Listeners.get(i)).treeNodesChanged(e);
            }
        }

        public void fireTreeStructureChanged() {
            if (this.m_Root == null) {
                return;
            }
            int[] o_Indexs = new int[1];
            Object[] o_Childs = new Object[1];
            o_Indexs[0] = 0;
            o_Childs[0] = this.m_Root;
            this.fireTreeStructureChanged(this, this.getPathToRoot(this.m_Root), o_Indexs, o_Childs);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireTreeStructureChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
            ArrayList<TreeModelListener> o_Listeners;
            Object object = this.m_SyncListeners;
            synchronized (object) {
                o_Listeners = new ArrayList<TreeModelListener>(this.m_TreeModelListeners.size());
                o_Listeners.addAll(this.m_TreeModelListeners);
            }
            TreeModelEvent e = null;
            for (int i = 0; i < o_Listeners.size(); ++i) {
                if (e == null) {
                    e = new TreeModelEvent(source, path, childIndices, children);
                }
                ((TreeModelListener)o_Listeners.get(i)).treeStructureChanged(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getDMXDeviceCount() {
            Object object = this.m_SyncDMXDevices;
            synchronized (object) {
                return this.m_DMXDevices.size();
            }
        }

        public ArrayList<DMXDevice> getDMXDevices() {
            return this.m_DMXDevices;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DMXDevice getDMXDevice(int p_Index) {
            Object object = this.m_SyncDMXDevices;
            synchronized (object) {
                if (p_Index < 0 || p_Index >= this.m_DMXDevices.size()) {
                    return null;
                }
                return this.m_DMXDevices.get(p_Index);
            }
        }

        public DMXDevice getDMXDevice(String p_ID) {
            if (p_ID == null) {
                return null;
            }
            return this.m_HashMapDMXDevices.get(p_ID);
        }

        public void addPropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
            if (p_PropertyChangeListener == null) {
                return;
            }
            this.m_PropertyChangeSupport.addPropertyChangeListener(p_PropertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
            this.m_PropertyChangeSupport.removePropertyChangeListener(p_PropertyChangeListener);
        }

        public PropertyChangeListener[] getPropertyChangeListeners() {
            return this.m_PropertyChangeSupport.getPropertyChangeListeners();
        }

        public PropertyChangeListener[] getPropertyChangeListeners(String p_PropertyName) {
            return this.m_PropertyChangeSupport.getPropertyChangeListeners(p_PropertyName);
        }

        public boolean hasListeners(String p_PropertyName) {
            return this.m_PropertyChangeSupport.hasListeners(p_PropertyName);
        }
    }

    public static interface TreeModel_Devices
    extends TreeModel {
        public void fireTreeNodeChanged(TreeNode var1);

        public TreePath getTreePathToRoot(TreeNode_ControlType_Device var1);

        public TreeNode_ControlType_Device getTreeNode(DMXDevice var1, DMXControlComponent.DMXControlType var2);
    }

    public static class TreeNode_Device_Channel<T>
    implements TreeNode,
    PropertyChangeListener {
        protected TreeNode_Device_Channel<?> m_Parent;
        protected ArrayList<TreeNode_Device_Channel<?>> m_ArrayListChilds = new ArrayList();
        protected T m_SourceObject;
        protected TreeModel_Device_Channels m_TreeModel_DeviceChannels;
        protected int m_SelectionFlag;

        public TreeNode_Device_Channel(T p_SourceObject, TreeModel_Device_Channels p_TreeModel) {
            this.m_SourceObject = p_SourceObject;
            this.m_TreeModel_DeviceChannels = p_TreeModel;
            this.m_SelectionFlag = 0;
        }

        public void addChild(TreeNode_Device_Channel<?> p_Child) {
            if (p_Child == null) {
                return;
            }
            if (this.m_ArrayListChilds.contains(p_Child)) {
                return;
            }
            this.m_ArrayListChilds.add(p_Child);
            p_Child.setParent(this);
        }

        public void removeChild(TreeNode_Device_Channel<?> p_Child) {
            if (p_Child == null) {
                return;
            }
            if (this.m_ArrayListChilds.remove(p_Child)) {
                p_Child.setParent(null);
            }
        }

        @Override
        public TreeNode_Device_Channel<?> getChildAt(int childIndex) {
            if (this.m_ArrayListChilds == null) {
                return null;
            }
            if (childIndex < 0) {
                return null;
            }
            if (childIndex >= this.m_ArrayListChilds.size()) {
                return null;
            }
            return this.m_ArrayListChilds.get(childIndex);
        }

        @Override
        public int getChildCount() {
            if (this.m_ArrayListChilds == null) {
                return 0;
            }
            return this.m_ArrayListChilds.size();
        }

        @Override
        public TreeNode_Device_Channel<?> getParent() {
            return this.m_Parent;
        }

        public void setParent(TreeNode_Device_Channel<?> p_Parent) {
            this.m_Parent = p_Parent;
        }

        @Override
        public int getIndex(TreeNode node) {
            if (node == null) {
                return -1;
            }
            return this.m_ArrayListChilds.indexOf(node);
        }

        @Override
        public boolean getAllowsChildren() {
            return true;
        }

        @Override
        public boolean isLeaf() {
            if (this.m_ArrayListChilds == null) {
                return true;
            }
            return this.m_ArrayListChilds.size() <= 0;
        }

        public Enumeration<TreeNode_Device_Channel<?>> children() {
            return Collections.enumeration(this.m_ArrayListChilds);
        }

        public ArrayList<TreeNode_Device_Channel<?>> getChildren() {
            return this.m_ArrayListChilds;
        }

        public T getSourceObject() {
            return this.m_SourceObject;
        }

        public void setSourceObject(T p_SourceObject) {
            this.m_SourceObject = p_SourceObject;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String stringPropertyName = evt.getPropertyName();
            if (stringPropertyName == null) {
                stringPropertyName = "";
            }
            boolean boolChanged = false;
            if (evt.getSource() instanceof DMXUniverse) {
                boolChanged = true;
            } else if (evt.getSource() instanceof DMXDevice) {
                DMXDeviceType.DMXDeviceChannelType o_DMXDeviceChannelType;
                if (DMXDevice.PROP_DMXDEVICE_DEVICENAME.equals(stringPropertyName)) {
                    boolChanged = true;
                } else if (DMXDevice.PROP_INDEXED_DMXDEVICE_UNIVERSENAME.equals(stringPropertyName)) {
                    boolChanged = true;
                } else if (DMXDevice.PROP_DMXDEVICE_DMXDEVICETYPE.equals(stringPropertyName)) {
                    TreeNode_Device_Channel<Object> o_ChildChannel;
                    DMXDeviceType.DMXDeviceSector o_DMXDeviceSector;
                    TreeNode_Device_Channel<Object> o_ChildSector;
                    int intSector;
                    ArrayList<TreeNode_Device_Channel<?>> o_ChildrenSector = this.getChildren();
                    for (intSector = o_ChildrenSector.size() - 1; intSector >= 0; --intSector) {
                        o_ChildSector = o_ChildrenSector.get(intSector);
                        if (o_ChildSector == null) continue;
                        o_DMXDeviceSector = (DMXDeviceType.DMXDeviceSector)o_ChildSector.getSourceObject();
                        ArrayList<TreeNode_Device_Channel<?>> o_ChildrenChannel = o_ChildSector.getChildren();
                        int intChildrenCount = o_ChildrenChannel.size();
                        for (int intChannel = intChildrenCount - 1; intChannel >= 0; --intChannel) {
                            o_ChildChannel = o_ChildrenChannel.get(intChannel);
                            if (o_ChildChannel == null) continue;
                            o_DMXDeviceChannelType = (DMXDeviceType.DMXDeviceChannelType)o_ChildChannel.getSourceObject();
                            o_DMXDeviceChannelType.removePropertyChangeListener(o_ChildChannel);
                            this.m_TreeModel_DeviceChannels.removeChild(o_ChildSector, o_ChildrenChannel.get(intChannel));
                        }
                        o_DMXDeviceSector.removePropertyChangeListener(o_ChildSector);
                        this.m_TreeModel_DeviceChannels.removeChild(this, o_ChildSector);
                    }
                    DMXDeviceType o_DMXDeviceType = (DMXDeviceType)evt.getNewValue();
                    if (o_DMXDeviceType != null) {
                        for (intSector = 0; intSector < o_DMXDeviceType.getDMXDeviceSectorCount(); ++intSector) {
                            o_DMXDeviceSector = o_DMXDeviceType.getDMXDeviceSector(intSector);
                            o_ChildSector = new TreeNode_Device_Channel<DMXDeviceType.DMXDeviceSector>(o_DMXDeviceSector, this.m_TreeModel_DeviceChannels);
                            this.m_TreeModel_DeviceChannels.addChild(this, o_ChildSector);
                            o_DMXDeviceSector.addPropertyChangeListener(o_ChildSector);
                            for (int intChannel = 0; intChannel < o_DMXDeviceSector.getChannelCount(); ++intChannel) {
                                o_DMXDeviceChannelType = o_DMXDeviceSector.getDMXDeviceChannelType(intChannel);
                                if (o_DMXDeviceChannelType == null) continue;
                                o_ChildChannel = new TreeNode_Device_Channel<DMXDeviceType.DMXDeviceChannelType>(o_DMXDeviceChannelType, this.m_TreeModel_DeviceChannels);
                                this.m_TreeModel_DeviceChannels.addChild(o_ChildSector, o_ChildChannel);
                                o_DMXDeviceChannelType.addPropertyChangeListener(o_ChildChannel);
                            }
                        }
                    }
                    boolChanged = true;
                }
                if (DMXDevice.PROP_DMXDEVICE_INDEXED_DEVICESECTOR.equals(stringPropertyName)) {
                    TreeNode_Device_Channel<Object> o_ChildChannel;
                    TreeNode_Device_Channel<DMXDeviceType.DMXDeviceSector> o_ChildSector;
                    DMXDeviceType.DMXDeviceSector o_DMXDeviceSector;
                    if (evt.getOldValue() != null) {
                        o_DMXDeviceSector = (DMXDeviceType.DMXDeviceSector)evt.getOldValue();
                        o_ChildSector = this.m_TreeModel_DeviceChannels.getTreeNode(this, o_DMXDeviceSector);
                        ArrayList<TreeNode_Device_Channel<?>> o_Children = o_ChildSector.getChildren();
                        int intChildrenCount = o_Children.size();
                        for (int intChannel = intChildrenCount - 1; intChannel >= 0; --intChannel) {
                            o_ChildChannel = o_Children.get(intChannel);
                            if (o_ChildChannel == null) continue;
                            o_DMXDeviceChannelType = (DMXDeviceType.DMXDeviceChannelType)o_ChildChannel.getSourceObject();
                            o_DMXDeviceChannelType.removePropertyChangeListener(o_ChildChannel);
                            this.m_TreeModel_DeviceChannels.removeChild(o_ChildSector, o_Children.get(intChannel));
                        }
                        o_DMXDeviceSector.removePropertyChangeListener(o_ChildSector);
                        this.m_TreeModel_DeviceChannels.removeChild(this, o_ChildSector);
                    }
                    if (evt.getNewValue() != null) {
                        o_DMXDeviceSector = (DMXDeviceType.DMXDeviceSector)evt.getNewValue();
                        o_ChildSector = new TreeNode_Device_Channel<DMXDeviceType.DMXDeviceSector>(o_DMXDeviceSector, this.m_TreeModel_DeviceChannels);
                        this.m_TreeModel_DeviceChannels.addChild(this, o_ChildSector);
                        for (int intChannel = 0; intChannel < o_DMXDeviceSector.getChannelCount(); ++intChannel) {
                            o_DMXDeviceChannelType = o_DMXDeviceSector.getDMXDeviceChannelType(intChannel);
                            if (o_DMXDeviceChannelType == null) continue;
                            o_ChildChannel = new TreeNode_Device_Channel<DMXDeviceType.DMXDeviceChannelType>(o_DMXDeviceChannelType, this.m_TreeModel_DeviceChannels);
                            this.m_TreeModel_DeviceChannels.addChild(o_ChildSector, o_ChildChannel);
                            o_DMXDeviceChannelType.addPropertyChangeListener(o_ChildChannel);
                        }
                        o_DMXDeviceSector.addPropertyChangeListener(o_ChildSector);
                    }
                    boolChanged = true;
                }
            } else if (!(evt.getSource() instanceof DMXDeviceType)) {
                if (evt.getSource() instanceof DMXDeviceType.DMXDeviceSector) {
                    if ("dmxdeviceTypeDeviceChannelType".equals(stringPropertyName)) {
                        TreeNode_Device_Channel<DMXDeviceType.DMXDeviceChannelType> o_Child;
                        DMXDeviceType.DMXDeviceChannelType o_DMXDeviceChannelType;
                        if (evt.getOldValue() != null) {
                            o_DMXDeviceChannelType = (DMXDeviceType.DMXDeviceChannelType)evt.getOldValue();
                            o_Child = this.m_TreeModel_DeviceChannels.getTreeNode(this, o_DMXDeviceChannelType);
                            o_DMXDeviceChannelType.removePropertyChangeListener(o_Child);
                            this.m_TreeModel_DeviceChannels.removeChild(this, o_Child);
                        }
                        if (evt.getNewValue() != null) {
                            o_DMXDeviceChannelType = (DMXDeviceType.DMXDeviceChannelType)evt.getNewValue();
                            o_Child = new TreeNode_Device_Channel<DMXDeviceType.DMXDeviceChannelType>(o_DMXDeviceChannelType, this.m_TreeModel_DeviceChannels);
                            this.m_TreeModel_DeviceChannels.addChild(this, o_Child);
                            o_DMXDeviceChannelType.addPropertyChangeListener(o_Child);
                        }
                        boolChanged = true;
                    }
                } else if (evt.getSource() instanceof DMXDeviceType.DMXDeviceChannelType && "dmxdevicechanneltypeChannelName".equals(evt.getPropertyName())) {
                    boolChanged = true;
                }
            }
            if (boolChanged) {
                this.m_TreeModel_DeviceChannels.fireTreeNodeChanged(this);
            }
        }

        public int getSelectionFlag() {
            return this.m_SelectionFlag;
        }

        public void setSelectionFlag(int p_SelectionFlag) {
            if (p_SelectionFlag < 0 || p_SelectionFlag > 2) {
                return;
            }
            if (p_SelectionFlag == this.m_SelectionFlag) {
                return;
            }
            if (this.m_SelectionFlag == p_SelectionFlag) {
                return;
            }
            this.m_SelectionFlag = p_SelectionFlag;
            this.m_TreeModel_DeviceChannels.fireTreeNodeChanged(this);
        }
    }

    public static class DMXDeviceTableModel
    extends TableAndListModel<InternalSector>
    implements PropertyChangeListener,
    TableAndListModel.TableBehaviorListener {
        public static final int COLUMNCOUNT = 13;
        public static final int COLUMNINDEX_DEVICEACTIVE = 0;
        public static final int COLUMNINDEX_DEVICENAME = 1;
        public static final int COLUMNINDEX_DEVICEISON = 2;
        public static final int COLUMNINDEX_DEVICEADJUSTEDSCENEBRIDGE = 3;
        public static final int COLUMNINDEX_DEVICESOLO = 4;
        public static final int COLUMNINDEX_DEVICEMUTE = 5;
        public static final int COLUMNINDEX_DEVICEUNIVERSE = 6;
        public static final int COLUMNINDEX_DEVICEADDRESS = 7;
        public static final int COLUMNINDEX_DEVICECHANNELS = 8;
        public static final int COLUMNINDEX_DEVICEMANUFACTURER = 9;
        public static final int COLUMNINDEX_DEVICETYPE = 10;
        public static final int COLUMNINDEX_DEVICEPOWERSOURCE = 11;
        public static final int COLUMNINDEX_DEVICEWATTAGE = 12;
        @LiveLanguageString
        public static String COLUMN_DEVICEON = "On";
        @LiveLanguageString
        public static String COLUMN_DEVICENAME = "Name";
        @LiveLanguageString
        public static String COLUMN_DEVICEMANUFACTURER = "Manufacturer";
        @LiveLanguageString
        public static String COLUMN_DEVICETYPE = "DeviceType";
        @LiveLanguageString
        public static String COLUMN_DEVICECHANNELS = "Channels";
        @LiveLanguageString
        public static String COLUMN_DEVICEUNIVERSE = "Universe";
        @LiveLanguageString
        public static String COLUMN_DEVICEADDRESS = "Address";
        @LiveLanguageString
        public static String COLUMN_DEVICEADJUSTEDSCENEBRIDGE = " ->";
        @LiveLanguageString
        public static String COLUMN_DEVICEPOWERSOURCE = "PowerSource";
        @LiveLanguageString
        public static String COLUMN_DEVICEWATTAGE = "Wattage";
        @LiveLanguageString
        public static String COLUMN_DEVICESOLO = "Solo";
        @LiveLanguageString
        public static String COLUMN_DEVICEMUTE = "Mute";
        @LiveLanguageString
        public static String COLUMN_DEVICEACTIVE = "Active";
        public static boolean s_LanguageLoaded = false;
        @LiveLanguageString
        public static String STRINGVALUE_TRUE = "On";
        @LiveLanguageString
        public static String STRINGVALUE_FALSE = "Off";
        private final Object m_SyncSectors = new Object();
        private DMXDeviceTableModel m_SelfReference;
        private StringBuilder m_StringBuilderValue;
        private final Object m_SyncStringBuilder = new Object();
        private int m_ExcludedRow_MouseEvent = -1;
        private int m_ExcludedRow_MouseColumn = -1;

        public DMXDeviceTableModel() {
            super(false);
            this.m_SelfReference = this;
            this.initMembers();
            LiveLanguage.addLanguageListener((Object)this, null);
        }

        private void initMembers() {
            this.m_StringBuilderValue = new StringBuilder();
        }

        public void finishJTable(JTable p_JTable) {
            TableAndListModel.TableCellEditorRenderer_Integer o_TableCellEditorRenderer_Integer;
            TableAndListModel.TableCellEditorRenderer_String o_TableCellEditorRenderer_String;
            if (p_JTable == null) {
                return;
            }
            TableRowSorter<DMXDeviceTableModel> o_TableRowSorter = new TableRowSorter<DMXDeviceTableModel>(this);
            o_TableRowSorter.setComparator(2, TableAndListModel.getStringComparator_Normal());
            o_TableRowSorter.setComparator(1, TableAndListModel.getStringComparator_Normal());
            o_TableRowSorter.setComparator(10, TableAndListModel.getStringComparator_Normal());
            o_TableRowSorter.setComparator(6, new Comparator_DMXUniverse());
            o_TableRowSorter.setComparator(7, TableAndListModel.getStringComparator_Integer());
            o_TableRowSorter.setComparator(8, TableAndListModel.getStringComparator_Integer());
            o_TableRowSorter.setComparator(3, TableAndListModel.getStringComparator_Normal());
            o_TableRowSorter.setComparator(11, new Comparator_DMXPowerSource());
            o_TableRowSorter.setComparator(12, TableAndListModel.getStringComparator_Normal());
            DMXDeviceFilter.DMXDeviceRowFilter o_TableRowFilter = new DMXDeviceFilter.DMXDeviceRowFilter(DMXDevice.getTableModel());
            o_TableRowSorter.setRowFilter(o_TableRowFilter);
            super.finishJTable(p_JTable, o_TableRowSorter, o_TableRowFilter);
            TableAndListModel.TableBehavior o_TableBehavior = new TableAndListModel.TableBehavior(p_JTable, this);
            TableColumn o_TableColumn = p_JTable.getColumnModel().getColumn(0);
            if (o_TableColumn != null) {
                o_TableColumn.setPreferredWidth(20);
                o_TableColumn.setMinWidth(20);
                o_TableColumn.setMaxWidth(20);
                o_TableColumn.setResizable(false);
                CellRendererActive o_CellRendererActive = new CellRendererActive();
                o_TableColumn.setCellEditor(o_CellRendererActive);
                o_TableColumn.setCellRenderer(o_CellRendererActive);
                o_CellRendererActive.setToolTipText_Automatic(0);
                o_CellRendererActive.setToolTipText(COLUMN_DEVICEACTIVE);
                o_CellRendererActive.setToolTipTextAt(true, true);
            }
            o_TableBehavior.addMouseExcludedColumn(0, false);
            o_TableColumn = p_JTable.getColumnModel().getColumn(2);
            if (o_TableColumn != null) {
                o_TableColumn.setPreferredWidth(40);
                CellRendererIsOn o_CellRendererIsOn = new CellRendererIsOn();
                o_CellRendererIsOn.setToolTipText_Automatic(1);
                o_CellRendererIsOn.setToolTipTextAt(false, true);
                o_TableColumn.setCellEditor(o_CellRendererIsOn);
                o_TableColumn.setCellRenderer(o_CellRendererIsOn);
            }
            if ((o_TableColumn = p_JTable.getColumnModel().getColumn(1)) != null) {
                o_TableColumn.setPreferredWidth(100);
                o_TableCellEditorRenderer_String = new TableAndListModel.TableCellEditorRenderer_String();
                o_TableCellEditorRenderer_String.setToolTipText_Automatic(1);
                o_TableCellEditorRenderer_String.setToolTipTextAt(false, true);
                o_TableColumn.setCellEditor(o_TableCellEditorRenderer_String);
                o_TableColumn.setCellRenderer(o_TableCellEditorRenderer_String);
            }
            if ((o_TableColumn = p_JTable.getColumnModel().getColumn(3)) != null) {
                o_TableColumn.setPreferredWidth(80);
                o_TableCellEditorRenderer_String = new TableAndListModel.TableCellEditorRenderer_String();
                o_TableCellEditorRenderer_String.setToolTipText_Automatic(1);
                o_TableCellEditorRenderer_String.setToolTipTextAt(false, true);
                o_TableColumn.setCellEditor(o_TableCellEditorRenderer_String);
                o_TableColumn.setCellRenderer(o_TableCellEditorRenderer_String);
            }
            if ((o_TableColumn = p_JTable.getColumnModel().getColumn(4)) != null) {
                o_TableColumn.setPreferredWidth(20);
                o_TableColumn.setMinWidth(20);
                o_TableColumn.setMaxWidth(20);
                o_TableColumn.setResizable(false);
                CellRendererSolo o_CellRendererSolo = new CellRendererSolo();
                o_TableColumn.setCellEditor(o_CellRendererSolo);
                o_TableColumn.setCellRenderer(o_CellRendererSolo);
                o_CellRendererSolo.setToolTipText_Automatic(0);
                o_CellRendererSolo.setToolTipText(COLUMN_DEVICESOLO);
                o_CellRendererSolo.setToolTipTextAt(true, true);
            }
            o_TableBehavior.addMouseExcludedColumn(4, false);
            o_TableColumn = p_JTable.getColumnModel().getColumn(5);
            if (o_TableColumn != null) {
                o_TableColumn.setPreferredWidth(20);
                o_TableColumn.setMinWidth(20);
                o_TableColumn.setMaxWidth(20);
                o_TableColumn.setResizable(false);
                CellRendererMute o_CellRendererMute = new CellRendererMute();
                o_TableColumn.setCellEditor(o_CellRendererMute);
                o_TableColumn.setCellRenderer(o_CellRendererMute);
                o_CellRendererMute.setToolTipText_Automatic(0);
                o_CellRendererMute.setToolTipText(COLUMN_DEVICEMUTE);
                o_CellRendererMute.setToolTipTextAt(true, true);
            }
            o_TableBehavior.addMouseExcludedColumn(5, false);
            o_TableColumn = p_JTable.getColumnModel().getColumn(6);
            if (o_TableColumn != null) {
                o_TableColumn.setPreferredWidth(120);
                CellRendererDMXUniverse o_CellRendererDMXUniverse = new CellRendererDMXUniverse();
                o_CellRendererDMXUniverse.setComboBoxModel(DMXUniverse.getListModel().createListModelWrapper());
                o_CellRendererDMXUniverse.setListCellRenderer(DMXUniverse.getCellRenderer());
                o_CellRendererDMXUniverse.setClickCountToStart(2);
                o_TableColumn.setCellEditor(o_CellRendererDMXUniverse);
                o_TableColumn.setCellRenderer(o_CellRendererDMXUniverse);
                o_CellRendererDMXUniverse.setToolTipText_Automatic(2);
                o_CellRendererDMXUniverse.setToolTipTextAt(false, true);
            }
            if ((o_TableColumn = p_JTable.getColumnModel().getColumn(7)) != null) {
                o_TableColumn.setPreferredWidth(40);
                CellRendererAddress o_CellRendererAddress = new CellRendererAddress();
                o_CellRendererAddress.setToolTipText_Automatic(0);
                o_CellRendererAddress.setToolTipText(COLUMN_DEVICEADDRESS);
                o_CellRendererAddress.setToolTipTextAt(false, true);
                o_TableColumn.setCellEditor(o_CellRendererAddress);
                o_TableColumn.setCellRenderer(o_CellRendererAddress);
            }
            if ((o_TableColumn = p_JTable.getColumnModel().getColumn(8)) != null) {
                o_TableColumn.setPreferredWidth(40);
                o_TableCellEditorRenderer_Integer = new TableAndListModel.TableCellEditorRenderer_Integer();
                o_TableCellEditorRenderer_Integer.setAllowNegativeNumbers(false);
                o_TableCellEditorRenderer_Integer.setToolTipText_Automatic(0);
                o_TableCellEditorRenderer_Integer.setToolTipText(COLUMN_DEVICECHANNELS);
                o_TableCellEditorRenderer_Integer.setToolTipTextAt(false, true);
                o_TableColumn.setCellEditor(o_TableCellEditorRenderer_Integer);
                o_TableColumn.setCellRenderer(o_TableCellEditorRenderer_Integer);
            }
            if ((o_TableColumn = p_JTable.getColumnModel().getColumn(9)) != null) {
                o_TableColumn.setPreferredWidth(80);
                o_TableCellEditorRenderer_String = new TableAndListModel.TableCellEditorRenderer_String();
                o_TableCellEditorRenderer_String.setToolTipText_Automatic(1);
                o_TableCellEditorRenderer_String.setToolTipTextAt(false, true);
                o_TableColumn.setCellEditor(o_TableCellEditorRenderer_String);
                o_TableColumn.setCellRenderer(o_TableCellEditorRenderer_String);
            }
            if ((o_TableColumn = p_JTable.getColumnModel().getColumn(10)) != null) {
                o_TableColumn.setPreferredWidth(80);
                o_TableCellEditorRenderer_String = new TableAndListModel.TableCellEditorRenderer_String();
                o_TableCellEditorRenderer_String.setToolTipText_Automatic(1);
                o_TableCellEditorRenderer_String.setToolTipTextAt(false, true);
                o_TableColumn.setCellEditor(o_TableCellEditorRenderer_String);
                o_TableColumn.setCellRenderer(o_TableCellEditorRenderer_String);
            }
            if ((o_TableColumn = p_JTable.getColumnModel().getColumn(11)) != null) {
                o_TableColumn.setPreferredWidth(200);
                TableAndListModel.TableCellEditorRenderer_ComboBox<DMXPowerSource> o_TableCellEditorRenderer_ComboBox = new TableAndListModel.TableCellEditorRenderer_ComboBox<DMXPowerSource>();
                o_TableCellEditorRenderer_ComboBox.setComboBoxModel(DMXPowerSource.getListModel().createListModelWrapper());
                o_TableCellEditorRenderer_ComboBox.setListCellRenderer(DMXPowerSource.getListCellRenderer());
                o_TableCellEditorRenderer_ComboBox.setClickCountToStart(2);
                o_TableCellEditorRenderer_ComboBox.setToolTipText_Automatic(2);
                o_TableCellEditorRenderer_ComboBox.setToolTipTextAt(false, true);
                o_TableColumn.setCellEditor(o_TableCellEditorRenderer_ComboBox);
                o_TableColumn.setCellRenderer(o_TableCellEditorRenderer_ComboBox);
            }
            if ((o_TableColumn = p_JTable.getColumnModel().getColumn(12)) != null) {
                o_TableColumn.setPreferredWidth(60);
                o_TableCellEditorRenderer_Integer = new TableAndListModel.TableCellEditorRenderer_Integer();
                o_TableCellEditorRenderer_Integer.setAllowNegativeNumbers(false);
                o_TableCellEditorRenderer_Integer.setToolTipText_Automatic(0);
                o_TableCellEditorRenderer_Integer.setToolTipText(COLUMN_DEVICEWATTAGE);
                o_TableCellEditorRenderer_Integer.setToolTipTextAt(false, true);
                o_TableColumn.setCellEditor(o_TableCellEditorRenderer_Integer);
                o_TableColumn.setCellRenderer(o_TableCellEditorRenderer_Integer);
            }
        }

        @Override
        public void excludedMouseEvent(MouseEvent p_MouseEvent, JTable p_JTable, int p_RowModel, int p_ColumnModel, Object p_Value) {
            DMXDevice o_DMXDevice = this.getDMXDevice(p_RowModel);
            if (o_DMXDevice == null) {
                return;
            }
            if (p_MouseEvent.getID() == 501 && p_MouseEvent.getButton() == 1) {
                this.m_ExcludedRow_MouseEvent = p_RowModel;
                this.m_ExcludedRow_MouseColumn = p_ColumnModel;
            } else if (p_MouseEvent.getID() == 502 && p_MouseEvent.getButton() == 1) {
                if (this.m_ExcludedRow_MouseEvent != p_RowModel || this.m_ExcludedRow_MouseColumn != p_ColumnModel) {
                    return;
                }
                switch (p_ColumnModel) {
                    case 4: {
                        if (!o_DMXDevice.getIsDimmable()) {
                            return;
                        }
                        if (o_DMXDevice.getSolo()) {
                            o_DMXDevice.setSolo(false);
                            break;
                        }
                        o_DMXDevice.setSolo(true);
                        break;
                    }
                    case 5: {
                        if (!o_DMXDevice.getIsDimmable()) {
                            return;
                        }
                        if (o_DMXDevice.getMute()) {
                            o_DMXDevice.setMute(false);
                            break;
                        }
                        o_DMXDevice.setMute(true);
                        break;
                    }
                    case 0: {
                        if (o_DMXDevice.getActive()) {
                            o_DMXDevice.setActive(false);
                            break;
                        }
                        o_DMXDevice.setActive(true);
                    }
                }
            }
        }

        public void addDMXDevice(DMXDevice p_DMXDevice) {
            if (p_DMXDevice == null) {
                return;
            }
            for (int intSector = 0; intSector < p_DMXDevice.getInternalSectorCount(); ++intSector) {
                InternalSector o_InternalSector = p_DMXDevice.getInternalSector(intSector);
                this.addDMXDeviceSector(o_InternalSector);
            }
            p_DMXDevice.addPropertyChangeListener(this);
        }

        public void removeDMXDevice(DMXDevice p_DMXDevice) {
            if (p_DMXDevice == null) {
                return;
            }
            for (int intSector = p_DMXDevice.getInternalSectorCount() - 1; intSector >= 0; --intSector) {
                InternalSector o_InternalSector = p_DMXDevice.getInternalSector(intSector);
                this.removeDMXDeviceSector(o_InternalSector);
            }
            p_DMXDevice.removePropertyChangeListener(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addDMXDeviceSector(InternalSector p_DMXDeviceSector) {
            if (p_DMXDeviceSector == null) {
                return;
            }
            Object object = this.m_SyncSectors;
            synchronized (object) {
                this.add(p_DMXDeviceSector);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeDMXDeviceSector(InternalSector p_DMXDeviceSector) {
            if (p_DMXDeviceSector == null) {
                return;
            }
            Object object = this.m_SyncSectors;
            synchronized (object) {
                this.remove(p_DMXDeviceSector);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getRowOfDMXDevice(InternalSector p_DMXDeviceSector) {
            Object object = this.m_SyncSectors;
            synchronized (object) {
                return super.getRowOf(p_DMXDeviceSector);
            }
        }

        public void addSelectedDMXDevice(JTable p_JTable, DMXDevice p_DMXDevice) {
            if (p_JTable == null) {
                return;
            }
            if (p_DMXDevice == null) {
                return;
            }
            for (int intSector = p_DMXDevice.getInternalSectorCount() - 1; intSector >= 0; --intSector) {
                InternalSector o_InternalSector = p_DMXDevice.getInternalSector(intSector);
                this.addSelectedElement(p_JTable, o_InternalSector);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeSelectedDMXDevice(JTable p_JTable, DMXDevice p_DMXDevice) {
            if (p_JTable == null) {
                return;
            }
            if (p_DMXDevice == null) {
                return;
            }
            Object object = this.m_SyncSectors;
            synchronized (object) {
                for (int intSector = p_DMXDevice.getInternalSectorCount() - 1; intSector >= 0; --intSector) {
                    InternalSector o_InternalSector = p_DMXDevice.getInternalSector(intSector);
                    this.removeSelectedElement(p_JTable, o_InternalSector);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DMXDevice getDMXDevice(int p_Index) {
            InternalSector o_InternalSector;
            if (p_Index < 0) {
                return null;
            }
            Object object = this.m_SyncSectors;
            synchronized (object) {
                if (p_Index >= this.size()) {
                    return null;
                }
                o_InternalSector = (InternalSector)this.get(p_Index);
                if (o_InternalSector == null) {
                    return null;
                }
            }
            return o_InternalSector.getDMXDevice();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public InternalSector getDMXDeviceInternalSector(int p_Index) {
            InternalSector o_InternalSector;
            if (p_Index < 0) {
                return null;
            }
            Object object = this.m_SyncSectors;
            synchronized (object) {
                if (p_Index >= this.size()) {
                    return null;
                }
                o_InternalSector = (InternalSector)this.get(p_Index);
            }
            return o_InternalSector;
        }

        @Override
        public int getColumnCount() {
            return 13;
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 2: {
                    return COLUMN_DEVICEON;
                }
                case 1: {
                    return COLUMN_DEVICENAME;
                }
                case 9: {
                    return COLUMN_DEVICEMANUFACTURER;
                }
                case 10: {
                    return COLUMN_DEVICETYPE;
                }
                case 6: {
                    return COLUMN_DEVICEUNIVERSE;
                }
                case 7: {
                    return COLUMN_DEVICEADDRESS;
                }
                case 8: {
                    return COLUMN_DEVICECHANNELS;
                }
                case 11: {
                    return COLUMN_DEVICEPOWERSOURCE;
                }
                case 3: {
                    return COLUMN_DEVICEADJUSTEDSCENEBRIDGE;
                }
                case 12: {
                    return COLUMN_DEVICEWATTAGE + " " + DMXPowerSource.s_WATTAGEUNIT;
                }
                case 4: {
                    return COLUMN_DEVICESOLO;
                }
                case 5: {
                    return COLUMN_DEVICEMUTE;
                }
                case 0: {
                    return COLUMN_DEVICEACTIVE;
                }
            }
            return "";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getValue(InternalSector o_InternalSector, int columnIndex) {
            this.m_StringBuilderValue.delete(0, this.m_StringBuilderValue.length());
            Object object = this.m_SyncSectors;
            synchronized (object) {
                if (o_InternalSector == null) {
                    return this.m_StringBuilderValue;
                }
            }
            DMXDevice o_DMXDevice = o_InternalSector.getDMXDevice();
            if (o_DMXDevice == null) {
                return this.m_StringBuilderValue.toString();
            }
            DMXDeviceType o_DMXDeviceType = o_DMXDevice.getDMXDeviceType();
            DMXDeviceType.DMXDeviceSector o_DMXDeviceSector = o_DMXDeviceType != null ? o_DMXDeviceType.getDMXDeviceSector(o_InternalSector.getDMXDeviceSectorIndex()) : null;
            switch (columnIndex) {
                case 2: {
                    double doubleValue;
                    boolean boolIsOn;
                    boolean boolDimmer = false;
                    this.m_StringBuilderValue.append("");
                    if (o_DMXDevice.getDMXControlComponent_Dimmer() != null) {
                        boolDimmer = true;
                    } else if (o_DMXDevice.getDMXControlComponent_Dimmer_Substitutes_Count() > 0) {
                        boolDimmer = true;
                    }
                    if (!boolDimmer) {
                        this.m_StringBuilderValue.append("-");
                        break;
                    }
                    if (!LiveShowDMXVIP.EDITMODEON) {
                        boolIsOn = o_DMXDevice.getDimmerIsOn();
                        doubleValue = o_DMXDevice.getDimmerValue();
                    } else {
                        boolIsOn = o_DMXDevice.getDimmerIsOn_EditMode();
                        doubleValue = o_DMXDevice.getDimmerValue_EditMode();
                    }
                    if (boolIsOn) {
                        this.m_StringBuilderValue.append((int)(doubleValue / 65535.0 * 100.0 + 0.5));
                        break;
                    }
                    this.m_StringBuilderValue.append("");
                    break;
                }
                case 1: {
                    this.m_StringBuilderValue.append(o_DMXDevice.getName());
                    if (o_DMXDevice.getInternalSectorCount() <= 1) break;
                    this.m_StringBuilderValue.append(" (");
                    this.m_StringBuilderValue.append(DMXDeviceType.SECTORNAME);
                    this.m_StringBuilderValue.append(" ");
                    this.m_StringBuilderValue.append(o_InternalSector.getDMXDeviceSectorIndex() + 1);
                    this.m_StringBuilderValue.append(")");
                    break;
                }
                case 9: {
                    if (o_DMXDeviceType == null) break;
                    this.m_StringBuilderValue.append(o_DMXDevice.getDMXDeviceType().getManufactureerName());
                    break;
                }
                case 10: {
                    if (o_DMXDeviceType == null) break;
                    this.m_StringBuilderValue.append(o_DMXDevice.getDMXDeviceType().getTypeName());
                    break;
                }
                case 6: {
                    DMXUniverse o_DMXUniverse = o_InternalSector.getDMXUniverse();
                    return o_DMXUniverse;
                }
                case 7: {
                    this.m_StringBuilderValue.append(o_InternalSector.getDMXStartAddress() + 1);
                    break;
                }
                case 8: {
                    this.m_StringBuilderValue.append(o_InternalSector.getInternalChannelCount());
                    break;
                }
                case 11: {
                    DMXPowerSource o_DMXPowerSource = o_InternalSector.getDMXPowerSource();
                    return o_DMXPowerSource;
                }
                case 12: {
                    if (o_DMXDeviceSector == null) break;
                    this.m_StringBuilderValue.append(o_DMXDeviceSector.getWattage());
                    break;
                }
                case 3: {
                    this.m_StringBuilderValue.append(o_DMXDevice.getStringSceneBridgeAdjusted());
                    break;
                }
                case 4: {
                    this.m_StringBuilderValue.append(o_DMXDevice.getSolo());
                    break;
                }
                case 5: {
                    this.m_StringBuilderValue.append(o_DMXDevice.getMute());
                    break;
                }
                case 0: {
                    this.m_StringBuilderValue.append(o_DMXDevice.getActive());
                }
            }
            return this.m_StringBuilderValue.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isCellEditable(int row, int col) {
            InternalSector o_InternalSector;
            Object object = this.m_SyncSectors;
            synchronized (object) {
                if (row < 0 || row >= this.size()) {
                    return false;
                }
                o_InternalSector = (InternalSector)this.get(row);
                if (o_InternalSector == null) {
                    return false;
                }
            }
            DMXDevice o_DMXDevice = o_InternalSector.getDMXDevice();
            if (o_DMXDevice == null) {
                return false;
            }
            switch (col) {
                case 2: {
                    return o_DMXDevice.getDMXControlComponent_Dimmer() != null || o_DMXDevice.getDMXControlComponent_Dimmer_Substitutes_Count() == 1;
                }
                case 1: {
                    return true;
                }
                case 9: {
                    return false;
                }
                case 10: {
                    return false;
                }
                case 6: {
                    return true;
                }
                case 7: {
                    return true;
                }
                case 8: {
                    return false;
                }
                case 11: {
                    return true;
                }
                case 12: {
                    return false;
                }
                case 3: {
                    return false;
                }
                case 4: {
                    return false;
                }
                case 5: {
                    return false;
                }
                case 0: {
                    return false;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setValue(InternalSector o_InternalSector, Object value, int col) {
            Object object = this.m_SyncSectors;
            synchronized (object) {
                if (o_InternalSector == null) {
                    return;
                }
            }
            DMXDevice o_DMXDevice = o_InternalSector.getDMXDevice();
            if (o_DMXDevice == null) {
                return;
            }
            switch (col) {
                case 2: {
                    String stringValue = (String)value;
                    Integer o_Integer = DocumentFilter_Integer.getValue(stringValue);
                    if (o_Integer == null) break;
                    int intValuePercent = o_Integer;
                    DMXControlComponent o_DMXControlComponentDimmer = o_DMXDevice.getDMXControlComponent_Dimmer();
                    if (o_DMXControlComponentDimmer != null) {
                        this.setValuePercentDMXComponent(o_DMXControlComponentDimmer, intValuePercent);
                        break;
                    }
                    for (int intDimmerSub = 0; intDimmerSub < o_DMXDevice.getDMXControlComponent_Dimmer_Substitutes_Count(); ++intDimmerSub) {
                        o_DMXControlComponentDimmer = o_DMXDevice.getDMXControlComponent_Dimmer_Substitute(intDimmerSub);
                        this.setValuePercentDMXComponent(o_DMXControlComponentDimmer, intValuePercent);
                    }
                    break;
                }
                case 1: {
                    String stringValue = (String)value;
                    o_DMXDevice.setName(stringValue);
                    break;
                }
                case 9: {
                    break;
                }
                case 10: {
                    break;
                }
                case 6: {
                    o_InternalSector.setDMXAddress((DMXUniverse)value, o_InternalSector.getDMXStartAddress());
                    break;
                }
                case 7: {
                    try {
                        String stringValue = (String)value;
                        int intAddress = Integer.valueOf(stringValue) - 1;
                        o_InternalSector.setDMXAddress(o_InternalSector.getDMXUniverse(), intAddress);
                    }
                    catch (Exception intAddress) {}
                    break;
                }
                case 8: {
                    break;
                }
                case 11: {
                    try {
                        DMXPowerSource o_DMXPowerSource = (DMXPowerSource)value;
                        o_InternalSector.setDMXPowerSource(o_DMXPowerSource);
                    }
                    catch (Exception exception) {}
                    break;
                }
                case 12: {
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    break;
                }
            }
            this.changedElement(o_InternalSector);
        }

        public void setValuePercentDMXComponent(DMXControlComponent p_DMXControlComponent, int p_ValuePercent) {
            if (p_DMXControlComponent == null) {
                return;
            }
            if (p_DMXControlComponent != null) {
                for (int intControl = 0; intControl < p_DMXControlComponent.getControlObjectCount(); ++intControl) {
                    ControlObject o_ControlObject = p_DMXControlComponent.getControlObject(intControl);
                    if (o_ControlObject == null) continue;
                    for (int intDimension = 0; intDimension < o_ControlObject.getControlDimensionCount(); ++intDimension) {
                        ControlObject.ControlDimension o_ControlDimension = o_ControlObject.getControlDimension(intDimension);
                        if (o_ControlDimension == null) continue;
                        o_ControlDimension.setValuePercent(p_ValuePercent, Integer.valueOf(2));
                    }
                    o_ControlObject.setValueManuallyIsReady();
                }
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            block22: {
                if (!(evt.getSource() instanceof DMXDevice)) break block22;
                DMXDevice o_DMXDevice = (DMXDevice)evt.getSource();
                if (DMXDevice.PROP_DMXDEVICE_DMXDEVICETYPE.equals(evt.getPropertyName())) {
                    InternalSector o_InternalSector;
                    int intSector;
                    for (intSector = this.size() - 1; intSector >= 0; --intSector) {
                        o_InternalSector = (InternalSector)this.get(intSector);
                        if (o_InternalSector == null || o_InternalSector.getDMXDevice() != o_DMXDevice) continue;
                        this.removeDMXDeviceSector(o_InternalSector);
                    }
                    for (intSector = 0; intSector < o_DMXDevice.getInternalSectorCount(); ++intSector) {
                        o_InternalSector = o_DMXDevice.getInternalSector(intSector);
                        this.addDMXDeviceSector(o_InternalSector);
                    }
                } else {
                    for (int intSector = 0; intSector < o_DMXDevice.getInternalSectorCount(); ++intSector) {
                        InternalSector o_InternalSector = o_DMXDevice.getInternalSector(intSector);
                        if (o_InternalSector == null) continue;
                        if (DMXDevice.PROP_DMXDEVICE_DEVICENAME.equals(evt.getPropertyName())) {
                            this.changedElement(o_InternalSector);
                        } else if (DMXDevice.PROP_INDEXED_DMXDEVICE_UNIVERSE.equals(evt.getPropertyName())) {
                            this.changedElement(o_InternalSector);
                        } else if (DMXDevice.PROP_INDEXED_DMXDEVICE_UNIVERSENAME.equals(evt.getPropertyName())) {
                            this.changedElement(o_InternalSector);
                        } else if (DMXDevice.PROP_INDEXED_DMXDEVICE_STARTADDRESS.equals(evt.getPropertyName())) {
                            this.changedElement(o_InternalSector);
                        } else if (DMXDevice.PROP_DMXDEVICE_VALIDADDRESS.equals(evt.getPropertyName())) {
                            this.changedElement(o_InternalSector);
                        } else if (DMXDevice.PROP_INDEXED_DMXDEVICE_DMXPOWERSOURCE.equals(evt.getPropertyName())) {
                            this.changedElement(o_InternalSector);
                        } else if (DMXDevice.PROP_DMXDEVICE_ADJUSTEDSCENEBRIDGE.equals(evt.getPropertyName())) {
                            this.changedElement(o_InternalSector);
                        } else if (DMXDevice.PROP_DMXDEVICE_DIMMERVALUE.equals(evt.getPropertyName())) {
                            this.changedElement(o_InternalSector);
                        }
                        if (DMXDevice.PROP_DMXDEVICE_DEVICESOLO.equals(evt.getPropertyName())) {
                            this.changedElement(o_InternalSector);
                        }
                        if (DMXDevice.PROP_DMXDEVICE_DEVICEMUTE.equals(evt.getPropertyName())) {
                            this.changedElement(o_InternalSector);
                        }
                        if (!DMXDevice.PROP_DMXDEVICE_DEVICEACTIVE.equals(evt.getPropertyName())) continue;
                        this.changedElement(o_InternalSector);
                    }
                }
            }
        }

        public static class CellRendererActive
        extends TableAndListModel.TableCellEditorRenderer_String {
            public static Border s_BorderActivated = new LineBorder(Color.GREEN);
            public static Border s_BorderDeactivated = new LineBorder(Color.RED);
            public static final Border SELECTED_BORDER = new LineBorder(Color.BLUE);

            public CellRendererActive() {
                this.initMembers();
            }

            private void initMembers() {
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                DMXDevice o_DMXDevice;
                JLabel o_JComponent = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                try {
                    int intIndex = table.convertRowIndexToModel(row);
                    DMXDeviceTableModel o_DMXDeviceTableModel = (DMXDeviceTableModel)table.getModel();
                    o_DMXDevice = o_DMXDeviceTableModel.getDMXDevice(intIndex);
                }
                catch (Exception e) {
                    o_DMXDevice = null;
                }
                o_JComponent.setText("");
                if (o_DMXDevice != null) {
                    if (o_DMXDevice.getActive()) {
                        o_JComponent.setBackground(Color.GREEN);
                        o_JComponent.setOpaque(true);
                    } else {
                        o_JComponent.setOpaque(true);
                        o_JComponent.setBackground(Color.RED);
                    }
                }
                o_JComponent.setFont(table.getFont());
                Border border = null;
                border = isSelected ? SELECTED_BORDER : (o_DMXDevice.getActive() ? s_BorderActivated : s_BorderDeactivated);
                o_JComponent.setBorder(border);
                return o_JComponent;
            }
        }

        public static class CellRendererMute
        extends TableAndListModel.TableCellEditorRenderer_String {
            public static Border s_Border = new LineBorder(Color.PINK);
            public static final Border SELECTED_BORDER = new LineBorder(Color.BLUE);

            public CellRendererMute() {
                this.initMembers();
            }

            private void initMembers() {
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                DMXDevice o_DMXDevice;
                JLabel o_JComponent = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                try {
                    int intIndex = table.convertRowIndexToModel(row);
                    DMXDeviceTableModel o_DMXDeviceTableModel = (DMXDeviceTableModel)table.getModel();
                    o_DMXDevice = o_DMXDeviceTableModel.getDMXDevice(intIndex);
                }
                catch (Exception e) {
                    o_DMXDevice = null;
                }
                o_JComponent.setText("");
                if (o_DMXDevice != null) {
                    if (o_DMXDevice.getIsDimmable() && o_DMXDevice.getMute()) {
                        o_JComponent.setBackground(Color.PINK);
                        o_JComponent.setOpaque(true);
                    } else {
                        o_JComponent.setOpaque(false);
                        o_JComponent.setBackground(Color.DARK_GRAY);
                    }
                }
                o_JComponent.setFont(table.getFont());
                Border border = null;
                border = isSelected ? SELECTED_BORDER : s_Border;
                o_JComponent.setBorder(border);
                return o_JComponent;
            }
        }

        public static class CellRendererSolo
        extends TableAndListModel.TableCellEditorRenderer_String {
            public static Border s_Border = new LineBorder(Color.YELLOW);
            public static final Border SELECTED_BORDER = new LineBorder(Color.BLUE);

            public CellRendererSolo() {
                this.initMembers();
            }

            private void initMembers() {
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                DMXDevice o_DMXDevice;
                JLabel o_JComponent = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                try {
                    int intIndex = table.convertRowIndexToModel(row);
                    DMXDeviceTableModel o_DMXDeviceTableModel = (DMXDeviceTableModel)table.getModel();
                    o_DMXDevice = o_DMXDeviceTableModel.getDMXDevice(intIndex);
                }
                catch (Exception e) {
                    o_DMXDevice = null;
                }
                o_JComponent.setText("");
                if (o_DMXDevice != null) {
                    if (o_DMXDevice.getIsDimmable() && o_DMXDevice.getSolo()) {
                        o_JComponent.setBackground(Color.YELLOW);
                        o_JComponent.setOpaque(true);
                    } else {
                        o_JComponent.setOpaque(false);
                        o_JComponent.setBackground(Color.DARK_GRAY);
                    }
                }
                o_JComponent.setFont(table.getFont());
                Border border = null;
                border = isSelected ? SELECTED_BORDER : s_Border;
                o_JComponent.setBorder(border);
                return o_JComponent;
            }
        }

        public static class CellRendererAddress
        extends TableAndListModel.TableCellEditorRenderer_Integer {
            private static Border s_InvalidBorder = new LineBorder(Color.RED);

            public CellRendererAddress() {
                this.setAllowNegativeNumbers(false);
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                InternalSector o_DMXDeviceInternalSector;
                JComponent o_Component = (JComponent)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                DMXDeviceTableModel o_DMXDeviceTableModel = (DMXDeviceTableModel)table.getModel();
                try {
                    int intIndex = table.convertRowIndexToModel(row);
                    o_DMXDeviceInternalSector = o_DMXDeviceTableModel.getDMXDeviceInternalSector(intIndex);
                }
                catch (Exception e) {
                    o_DMXDeviceInternalSector = null;
                }
                boolean boolValidAddress = o_DMXDeviceInternalSector == null ? false : o_DMXDeviceInternalSector.getValidAddress();
                if (!boolValidAddress) {
                    o_Component.setBorder(s_InvalidBorder);
                } else {
                    o_Component.setBorder(null);
                }
                return o_Component;
            }
        }

        public static class CellRendererDMXUniverse
        extends TableAndListModel.TableCellEditorRenderer_ComboBox<DMXUniverse> {
            private static Border s_InvalidBorder = new LineBorder(Color.RED);
            public static final Border SELECTED_BORDER = new LineBorder(Color.BLUE);

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                InternalSector o_DMXDeviceInternalSector;
                JComponent o_Component = (JComponent)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                DMXDeviceTableModel o_DMXDeviceTableModel = (DMXDeviceTableModel)table.getModel();
                try {
                    int intIndex = table.convertRowIndexToModel(row);
                    o_DMXDeviceInternalSector = o_DMXDeviceTableModel.getDMXDeviceInternalSector(intIndex);
                }
                catch (Exception e) {
                    o_DMXDeviceInternalSector = null;
                }
                boolean boolValidAddress = o_DMXDeviceInternalSector == null ? false : o_DMXDeviceInternalSector.getValidAddress();
                if (!boolValidAddress) {
                    o_Component.setBorder(s_InvalidBorder);
                } else if (isSelected) {
                    o_Component.setBorder(SELECTED_BORDER);
                } else {
                    o_Component.setBorder(null);
                }
                return o_Component;
            }
        }

        public static class CellRendererIsOn
        extends TableAndListModel.TableCellEditorRenderer_Integer {
            private static Border s_DimmerBorder = null;
            private static Border s_DimmerSubstituteBorder = new LineBorder(Color.ORANGE, 2);
            private static Border s_NoDimmerBorder = new LineBorder(Color.RED, 2);

            public CellRendererIsOn() {
                this.setAllowNegativeNumbers(false);
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                InternalSector o_DMXDeviceInternalSector;
                JComponent o_JComponent = (JComponent)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                DMXDevice o_DMXDevice = null;
                DMXDeviceTableModel o_DMXDeviceTableModel = (DMXDeviceTableModel)table.getModel();
                try {
                    int intIndex = table.convertRowIndexToModel(row);
                    o_DMXDeviceInternalSector = o_DMXDeviceTableModel.getDMXDeviceInternalSector(intIndex);
                }
                catch (Exception e) {
                    o_DMXDeviceInternalSector = null;
                }
                o_DMXDevice = o_DMXDeviceInternalSector == null ? null : o_DMXDeviceInternalSector.getDMXDevice();
                o_JComponent.setFont(table.getFont());
                if (o_DMXDevice != null) {
                    if (o_DMXDevice.getDMXControlComponent_Dimmer() != null) {
                        o_JComponent.setBorder(s_DimmerBorder);
                    } else if (o_DMXDevice.getDMXControlComponent_Dimmer_Substitutes_Count() > 0) {
                        o_JComponent.setBorder(s_DimmerSubstituteBorder);
                    } else {
                        o_JComponent.setBorder(s_NoDimmerBorder);
                    }
                } else {
                    o_JComponent.setBorder(s_NoDimmerBorder);
                }
                return o_JComponent;
            }
        }

        class Comparator_DMXPowerSource
        implements Comparator<DMXPowerSource> {
            Comparator_DMXPowerSource() {
            }

            @Override
            public int compare(DMXPowerSource o1, DMXPowerSource o2) {
                if (o1 == null || o2 == null) {
                    return 0;
                }
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        }

        class Comparator_DMXUniverse
        implements Comparator<DMXUniverse> {
            Comparator_DMXUniverse() {
            }

            @Override
            public int compare(DMXUniverse o1, DMXUniverse o2) {
                if (o1 == null || o2 == null) {
                    return 0;
                }
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        }
    }

    public static class DMXDeviceListRenderer
    extends DefaultListCellRenderer {
        public static Dimension s_DimensionIcon = new Dimension(20, 20);

        public DMXDeviceListRenderer() {
            this.initMembers();
            this.initComponents();
        }

        private void initMembers() {
        }

        private void initComponents() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (list != null) {
                Color o_Background = null;
                Color o_Foreground = null;
                o_Background = list.getBackground();
                o_Foreground = list.getForeground();
                if (isSelected) {
                    if (list.hasFocus()) {
                        o_Background = UIManager.getColor("List.selectionBackground");
                        o_Foreground = UIManager.getColor("List.selectionForeground");
                    } else {
                        o_Background = UIManager.getColor("List.selectionInactiveBackground");
                        o_Foreground = UIManager.getColor("List.selectionInactiveForeground");
                    }
                }
                this.setForeground(o_Foreground);
                this.setBackground(o_Background);
            }
            if (value == null || !(value instanceof DMXDevice)) {
                this.setIcon(null);
                this.setText("");
                this.setToolTipText(null);
            } else {
                DMXDevice o_DMXDevice = (DMXDevice)value;
                this.setIcon(s_Icon);
                this.setText(o_DMXDevice.getName());
                this.setToolTipText(o_DMXDevice.getToolTipText());
            }
            return this;
        }
    }

    public static class DMXDeviceListModel
    extends TableAndListModel.ListModel<DMXDevice>
    implements PropertyChangeListener {
        private final Object m_SyncObject = new Object();

        public DMXDeviceListModel() {
            super(false);
            super.setGetSortStringMethod(DMXDevice.class, "getName", true);
            super.setGetNameMethod(DMXDevice.class, "getName");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addDMXDevice(DMXDevice p_DMXDevice) {
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (!this.add(p_DMXDevice)) {
                    return;
                }
            }
            p_DMXDevice.addPropertyChangeListener(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeDMXDevice(DMXDevice p_DMXDevice) {
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (!this.remove(p_DMXDevice)) {
                    return;
                }
            }
            p_DMXDevice.removePropertyChangeListener(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean moveUp(DMXDevice p_DMXDevice) {
            Object object = this.m_SyncObject;
            synchronized (object) {
                int intIndex = this.indexOf(p_DMXDevice);
                if (intIndex <= 0) {
                    return false;
                }
                super.remove(p_DMXDevice);
                super.add(intIndex - 1, p_DMXDevice);
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean moveDown(DMXDevice p_DMXDevice) {
            Object object = this.m_SyncObject;
            synchronized (object) {
                int intIndex = this.indexOf(p_DMXDevice);
                if (intIndex < 0) {
                    return false;
                }
                if (intIndex >= this.size() - 1) {
                    return false;
                }
                super.remove(p_DMXDevice);
                super.add(intIndex + 1, p_DMXDevice);
            }
            return true;
        }

        public ArrayList<DMXDevice> getDMXDevices() {
            ArrayList<DMXDevice> o_DMXDevices = this.getElementArrayList_Safe();
            return o_DMXDevices;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() instanceof DMXDevice) {
                DMXDevice o_DMXDevice = (DMXDevice)evt.getSource();
                if (DMXDevice.PROP_DMXDEVICE_ADJUSTEDSCENEBRIDGE.equals(evt.getPropertyName())) {
                    return;
                }
                if (DMXDevice.PROP_DMXDEVICE_DIMMERVALUE.equals(evt.getPropertyName())) {
                    return;
                }
                this.changedElement(o_DMXDevice);
            }
        }
    }

    public static class InternalChannel
    implements PropertyChangeListener {
        private int m_Value;
        private int m_ValueValidated;
        private int m_ValueEditMode;
        private int m_ValueValidatedEditMode;
        private int m_ValueControlDimension;
        private boolean m_ValueControlDimensionChanged;
        private HashMap<DMXControlComponent.DeviceControlLink, Double> m_MasterValueFactors;
        private double m_ValueFactor;
        private boolean m_ValueFactorChanged;
        private int m_ValueDMXChannel;
        private int m_ValueDMXInterface;
        private int m_ValueInterfaceValidatedReverse;
        private int m_ValueDMXInterface_Input;
        private int m_ValueDMXInterface_InputOld;
        private DMXDevice m_DMXDevice;
        private InternalSector m_DMXDeviceInternalSector;
        private int m_InternalAddress;
        private int m_DMXChannelRedirectedAddress;
        private DMXDeviceType.DMXDeviceChannelType m_DMXDeviceChannelType;
        private ArrayList<DMXControlComponent.DeviceControlLink> m_DeviceControlLinks;
        private ArrayList<Integer> m_DeviceControlLinksByte;
        private boolean m_Active;
        private boolean m_Mute;
        private boolean m_Solo;
        private boolean m_SendValues;

        public InternalChannel(InternalSector p_InternalSector, int p_InternalAddress, DMXDeviceType.DMXDeviceChannelType p_DMXDeviceChannelType) {
            this.initMembers();
            this.m_DMXDeviceInternalSector = p_InternalSector;
            this.m_DMXDevice = this.m_DMXDeviceInternalSector.getDMXDevice();
            this.m_DMXChannelRedirectedAddress = this.m_InternalAddress = p_InternalAddress;
            this.m_DMXDeviceChannelType = p_DMXDeviceChannelType;
            DMXChannel o_DMXChannel = this.m_DMXDevice.getDMXChannel(this.m_DMXDeviceInternalSector.getDMXDeviceSectorIndex(), this.m_DMXChannelRedirectedAddress);
            if (o_DMXChannel != null) {
                o_DMXChannel.addDMXDeviceInternalChannel(this);
                o_DMXChannel.addPropertyChangeListener(this);
                this.eventValuesDMXChannel();
                this.eventValuesDMXInterface();
                if (this.m_DMXDeviceInternalSector != null) {
                    this.m_DMXDeviceInternalSector.refreshDeviceControlLinks_ValueInternalChannels_EditMode();
                    this.m_DMXDeviceInternalSector.refreshDeviceControlLinks_ValueInternalChannels(false);
                    this.m_DMXDeviceInternalSector.refreshDeviceControlLinks_ValueInterface();
                }
            }
        }

        private void initMembers() {
            this.m_Value = 0;
            this.m_ValueValidated = 0;
            this.m_ValueDMXInterface = 0;
            this.m_ValueInterfaceValidatedReverse = 0;
            this.m_ValueDMXInterface_InputOld = this.m_ValueDMXInterface_Input = 0;
            this.m_ValueEditMode = 0;
            this.m_ValueValidatedEditMode = 0;
            this.m_ValueControlDimension = 0;
            this.m_ValueControlDimensionChanged = false;
            this.m_MasterValueFactors = new HashMap();
            this.m_ValueFactor = 1.0;
            this.m_ValueFactorChanged = false;
            this.m_ValueDMXChannel = 0;
            this.m_DeviceControlLinks = new ArrayList();
            this.m_DeviceControlLinksByte = new ArrayList();
            this.m_Active = true;
            this.m_Mute = false;
            this.m_Solo = false;
            this.m_SendValues = true;
        }

        public void close(boolean p_KeepDeviceControlLinks) {
            DMXChannel o_DMXChannel = this.m_DMXDevice.getDMXChannel(this.m_DMXDeviceInternalSector.getDMXDeviceSectorIndex(), this.m_DMXChannelRedirectedAddress);
            DMXDeviceType o_DMXDeviceType = this.m_DMXDevice.getDMXDeviceType();
            for (int intLink = this.m_DeviceControlLinks.size() - 1; intLink >= 0; --intLink) {
                DMXControlComponent.DeviceControlLink o_DeviceControlLink = this.m_DeviceControlLinks.get(intLink);
                if (o_DeviceControlLink == null) {
                    this.m_DeviceControlLinks.remove(intLink);
                    continue;
                }
                if (p_KeepDeviceControlLinks) continue;
                DMXControlComponent.DMXControlType o_DMXControlType = o_DeviceControlLink.getDMXControlType();
                if (o_DMXDeviceType.containsDMXControlType(o_DMXControlType)) {
                    this.m_DeviceControlLinks.remove(o_DeviceControlLink);
                    continue;
                }
                o_DeviceControlLink.close();
            }
            if (o_DMXChannel != null) {
                o_DMXChannel.removeDMXDeviceInternalChannel(this, false);
                o_DMXChannel.removePropertyChangeListener(this);
            }
            this.m_MasterValueFactors.clear();
        }

        public DMXDevice getDMXDevice() {
            return this.m_DMXDevice;
        }

        public InternalSector getDMXDeviceInternalSector() {
            return this.m_DMXDeviceInternalSector;
        }

        public int getInternalAddress() {
            return this.m_InternalAddress;
        }

        public DMXChannel getDMXChannel() {
            if (this.m_DMXDevice == null) {
                return null;
            }
            return this.m_DMXDevice.getDMXChannel(this.m_DMXDeviceInternalSector.getDMXDeviceSectorIndex(), this.m_DMXChannelRedirectedAddress);
        }

        public DMXDeviceType.DMXDeviceChannelType getDMXDeviceChannelType() {
            return this.m_DMXDeviceChannelType;
        }

        public void setActive(boolean p_Active) {
            if (this.m_Active == p_Active) {
                return;
            }
            this.setSoloMuteActive(this.m_Solo, this.m_Mute, p_Active);
        }

        public void setMute(boolean p_Mute) {
            if (this.m_Mute == p_Mute) {
                return;
            }
            this.setSoloMuteActive(this.m_Solo, p_Mute, this.m_Active);
        }

        public void setSolo(boolean p_Solo) {
            this.setSoloMuteActive(p_Solo, this.m_Mute, this.m_Active);
        }

        private void setSoloMuteActive(boolean p_Solo, boolean p_Mute, boolean p_Active) {
            DMXChannel o_DMXChannel = null;
            boolean boolValuesNull = false;
            if (this.m_DMXDevice != null) {
                o_DMXChannel = this.m_DMXDevice.getDMXChannel(this.m_DMXDeviceInternalSector.getDMXDeviceSectorIndex(), this.m_DMXChannelRedirectedAddress);
            }
            if (!p_Active) {
                boolValuesNull = true;
                this.m_Active = p_Active;
            } else {
                this.m_Active = p_Active;
                this.m_Mute = p_Mute;
                this.m_Solo = p_Solo;
                boolValuesNull = this.m_Mute ? true : !this.m_Solo && s_SoloOn;
            }
            if (o_DMXChannel != null && this.m_DMXDeviceChannelType != null) {
                if (boolValuesNull && (!this.m_DMXDeviceChannelType.hasDisabledInFunctionsDMXControl() && !this.m_DMXDeviceChannelType.hasDisabledDMXControl() || !this.m_Active)) {
                    this.m_SendValues = false;
                    if (!this.m_Active) {
                        o_DMXChannel.setValueChannel(0, 0);
                    } else if (this.m_DMXDevice != null && (this.m_DMXDevice.getHasDimmerLinked() || this.m_DMXDevice.getHasDimmerSubstituteLinked())) {
                        if (this.m_DMXDeviceChannelType.hasDisabledAdjustmentDMXControl()) {
                            o_DMXChannel.setValueChannel(0, 0);
                        } else if (this.m_DMXDeviceChannelType != null && (this.m_DMXDeviceChannelType.getIsDimmerChannel() || this.m_DMXDeviceChannelType.getIsDimmerSubstituteChannel())) {
                            o_DMXChannel.setValueChannel(0, 0);
                        }
                    }
                } else {
                    this.m_SendValues = true;
                    int intValueValidated = this.m_Value;
                    if (this.m_DMXDeviceChannelType.getIsDimmerChannel() || this.m_DMXDeviceChannelType.getIsDimmerSubstituteChannel()) {
                        // empty if block
                    }
                    o_DMXChannel.setValueChannel(this.m_Value, intValueValidated);
                }
            }
        }

        public boolean getActive() {
            return this.m_Active;
        }

        public boolean getMute() {
            return this.m_Mute;
        }

        public boolean getSolo() {
            return this.m_Solo;
        }

        public boolean addDeviceControlLink(DMXControlComponent.DeviceControlLink p_DeviceControlLink, int p_Byte) {
            if (p_DeviceControlLink == null) {
                return false;
            }
            boolean boolAdded = true;
            int intIndex = this.m_DeviceControlLinks.indexOf(p_DeviceControlLink);
            if (intIndex >= 0) {
                this.m_DeviceControlLinksByte.set(intIndex, p_Byte);
                return true;
            }
            boolAdded = this.m_DeviceControlLinks.add(p_DeviceControlLink);
            if (boolAdded) {
                this.m_DeviceControlLinksByte.add(p_Byte);
            }
            return boolAdded;
        }

        public boolean removeDeviceControlLink(DMXControlComponent.DeviceControlLink p_DeviceControlLink) {
            if (p_DeviceControlLink == null) {
                return false;
            }
            if (!this.m_DeviceControlLinks.contains(p_DeviceControlLink)) {
                return false;
            }
            int intIndex = this.m_DeviceControlLinks.indexOf(p_DeviceControlLink);
            boolean boolRemoved = false;
            boolRemoved = this.m_DeviceControlLinks.remove(p_DeviceControlLink);
            if (boolRemoved) {
                this.m_DeviceControlLinksByte.remove(intIndex);
            }
            return boolRemoved;
        }

        public int getDeviceControlLinkCount() {
            return this.m_DeviceControlLinks.size();
        }

        public DMXControlComponent.DeviceControlLink getDeviceControlLink(int p_Index) {
            if (p_Index < 0 || p_Index >= this.m_DeviceControlLinks.size()) {
                return null;
            }
            return this.m_DeviceControlLinks.get(p_Index);
        }

        public void changedStartAddress(DMXUniverse p_OldDMXUniverse, int p_OldDMXStartAddress, DMXUniverse p_DMXUniverse, int p_DMXStartAddress) {
            DMXChannel o_DMXChannel;
            if (p_OldDMXUniverse != null && (o_DMXChannel = p_OldDMXUniverse.getDMXChannel(p_OldDMXStartAddress + this.m_DMXChannelRedirectedAddress)) != null && this.m_DMXDevice.getDMXDeviceType() != null) {
                o_DMXChannel.removeDMXDeviceInternalChannel(this, false);
                o_DMXChannel.removePropertyChangeListener(this);
                this.eventValuesDMXChannel();
            }
            if (p_DMXUniverse != null && (o_DMXChannel = p_DMXUniverse.getDMXChannel(p_DMXStartAddress + this.m_DMXChannelRedirectedAddress)) != null && this.m_DMXDevice.getDMXDeviceType() != null) {
                o_DMXChannel.addDMXDeviceInternalChannel(this);
                o_DMXChannel.addPropertyChangeListener(this);
                this.eventValuesDMXChannel();
                this.eventValuesDMXInterface();
            }
        }

        public void redirectInternalAddress(int p_RedirectedInternalAddress) {
            if (p_RedirectedInternalAddress < 0 || p_RedirectedInternalAddress >= this.m_DMXDeviceInternalSector.getInternalChannelCount()) {
                p_RedirectedInternalAddress = this.m_InternalAddress;
            }
            if (this.m_DMXChannelRedirectedAddress == p_RedirectedInternalAddress) {
                return;
            }
            DMXChannel o_DMXChannel = this.m_DMXDevice.getDMXChannel(this.m_DMXDeviceInternalSector.getDMXDeviceSectorIndex(), this.m_DMXChannelRedirectedAddress);
            if (o_DMXChannel != null) {
                o_DMXChannel.removePropertyChangeListener(this);
                o_DMXChannel.removeDMXDeviceInternalChannel(this, true);
            }
            this.m_DMXChannelRedirectedAddress = p_RedirectedInternalAddress;
            o_DMXChannel = this.m_DMXDevice.getDMXChannel(this.m_DMXDeviceInternalSector.getDMXDeviceSectorIndex(), this.m_DMXChannelRedirectedAddress);
            if (o_DMXChannel != null) {
                o_DMXChannel.addDMXDeviceInternalChannel(this);
                o_DMXChannel.addPropertyChangeListener(this);
            }
        }

        public boolean setValue_EditMode(int p_Value, boolean p_IsScene) {
            if (p_Value < 0) {
                return false;
            }
            if (p_Value > 255) {
                p_Value = 255;
            }
            boolean boolChanged = false;
            boolean boolDimmerFound = false;
            if (this.m_ValueEditMode != p_Value) {
                this.m_ValueEditMode = p_Value;
                this.m_ValueValidatedEditMode = this.m_Value;
                boolChanged = true;
                if (this.m_DMXDeviceChannelType != null && (this.m_DMXDeviceChannelType.getIsDimmerChannel() || this.m_DMXDeviceChannelType.getIsDimmerSubstituteChannel())) {
                    this.m_DMXDevice.refreshIsOn_EditMode();
                }
            }
            return boolChanged;
        }

        public int getValue_EditMode() {
            return this.m_ValueEditMode;
        }

        public void refreshDeviceControlLinks_ValueChannel_EditMode() {
            for (int intLink = 0; intLink < this.m_DeviceControlLinks.size(); ++intLink) {
                DMXControlComponent.DeviceControlLink o_DeviceControlLink = this.m_DeviceControlLinks.get(intLink);
                if (o_DeviceControlLink == null) continue;
                o_DeviceControlLink.refreshValuesInternalChannels_EditMode();
            }
        }

        public void setValue_Validated_EditMode(int p_ValueValidated) {
            if (p_ValueValidated < 0) {
                p_ValueValidated = 0;
            }
            if (p_ValueValidated > 255) {
                p_ValueValidated = 255;
            }
            this.m_ValueValidatedEditMode = p_ValueValidated;
        }

        public int getValue_Validated_EditMode() {
            return this.m_ValueValidatedEditMode;
        }

        public boolean setValue(int p_Value, boolean p_ManuallySet) {
            if (p_Value < 0) {
                return false;
            }
            if (p_Value > 255) {
                p_Value = 255;
            }
            boolean boolChanged = false;
            if (this.m_Value != p_Value) {
                this.m_ValueValidated = this.m_Value = p_Value;
                boolChanged = true;
            }
            return boolChanged;
        }

        public int getValue() {
            return this.m_Value;
        }

        public void refreshDeviceControlLinks_ValueChannel(boolean p_ManuallySet) {
            for (int intLink = 0; intLink < this.m_DeviceControlLinks.size(); ++intLink) {
                DMXControlComponent.DeviceControlLink o_DeviceControlLink = this.m_DeviceControlLinks.get(intLink);
                if (o_DeviceControlLink == null) continue;
                o_DeviceControlLink.refreshValuesInternalChannels(p_ManuallySet);
            }
        }

        public void setValue_Validated(int p_ValueValidated) {
            if (p_ValueValidated < 0) {
                p_ValueValidated = 0;
            }
            if (p_ValueValidated > 255) {
                p_ValueValidated = 255;
            }
            this.m_ValueValidated = p_ValueValidated;
        }

        public int getValue_Validated() {
            return this.m_ValueValidated;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void sendValueToDMXChannel() {
            DMXControlComponent.DMXControlType o_DMXControlType;
            DMXControlComponent.DeviceControlLink o_DeviceControlLink_Type;
            DMXChannel o_DMXChannel;
            if (!this.m_SendValues) {
                if (!this.m_Active) {
                    return;
                }
                if (this.m_Mute) {
                    if (this.m_DMXDeviceChannelType == null) return;
                    if (this.m_DMXDeviceChannelType.hasDisabledAdjustmentDMXControl()) {
                        return;
                    }
                    if ((this.m_DMXDevice == null || !this.m_DMXDevice.getHasDimmerLinked()) && !this.m_DMXDevice.getHasDimmerSubstituteLinked()) return;
                    if (this.m_DMXDeviceChannelType.getIsDimmerChannel() || this.m_DMXDeviceChannelType.getIsDimmerSubstituteChannel()) {
                        return;
                    }
                }
                if (!this.m_Solo && s_SoloOn) {
                    if (this.m_DMXDeviceChannelType == null) return;
                    if (this.m_DMXDeviceChannelType.hasDisabledAdjustmentDMXControl()) {
                        return;
                    }
                    if ((this.m_DMXDevice == null || !this.m_DMXDevice.getHasDimmerLinked()) && !this.m_DMXDevice.getHasDimmerSubstituteLinked()) return;
                    if (this.m_DMXDeviceChannelType.getIsDimmerChannel() || this.m_DMXDeviceChannelType.getIsDimmerSubstituteChannel()) {
                        return;
                    }
                }
            }
            if ((o_DMXChannel = this.m_DMXDevice.getDMXChannel(this.m_DMXDeviceInternalSector.getDMXDeviceSectorIndex(), this.m_DMXChannelRedirectedAddress)) == null) return;
            DMXControlComponent.DeviceControlLink o_DeviceControlLink_Component = null;
            DMXControlComponent o_DMXControlComponent = null;
            CorrectionModel o_CorrectionModel = null;
            double doubleValueNormed = 0.0;
            double doubleInputValueNormed = 0.0;
            int intValueValidated = this.m_ValueValidated;
            if (this.m_DMXDeviceChannelType != null && (this.m_DMXDeviceChannelType.getIsDimmerChannel() || this.m_DMXDeviceChannelType.getIsDimmerSubstituteChannel())) {
                intValueValidated = (int)((double)this.m_ValueValidated * (double)this.m_DMXDevice.getScale() / 100.0);
            }
            if (this.m_DMXDeviceChannelType.getChannelControlLinkCount() > 0 && (o_DeviceControlLink_Type = this.m_DMXDeviceChannelType.getChannelControlLink(0).getDeviceControlLink()) != null && (o_DMXControlType = o_DeviceControlLink_Type.getDMXControlType()) != null && (DMXControl_Dimmer.class.getName().equals(o_DMXControlType.getClassName()) || DMXControl_FreeDimmer.class.getName().equals(o_DMXControlType.getClassName()))) {
                for (int intDeviceLink = 0; intDeviceLink < this.m_DeviceControlLinks.size(); ++intDeviceLink) {
                    o_DeviceControlLink_Component = this.m_DeviceControlLinks.get(intDeviceLink);
                    if (o_DeviceControlLink_Component == null || (o_DMXControlComponent = o_DeviceControlLink_Component.getDMXControlComponent()) == null || !this.m_DMXDevice.containsDMXControlComponent(o_DMXControlComponent)) continue;
                    DMXControl_Dimmer_DeviceSettings o_DMXControl_Dimmer_DeviceSettings = (DMXControl_Dimmer_DeviceSettings)o_DMXControlComponent.getDMXDeviceSettingsPanel(this.m_DMXDevice, false);
                    o_CorrectionModel = o_DMXControl_Dimmer_DeviceSettings.getCorrectionModel();
                    break;
                }
            }
            if (o_CorrectionModel != null && o_DeviceControlLink_Component != null && o_DeviceControlLink_Component.getValueLinkedMaximum() > 0) {
                doubleInputValueNormed = this.m_DMXDeviceChannelType != null && (this.m_DMXDeviceChannelType.getIsDimmerChannel() || this.m_DMXDeviceChannelType.getIsDimmerSubstituteChannel()) ? (double)o_DeviceControlLink_Component.getValueInternalChannels() * (double)this.m_DMXDevice.getScale() / 100.0 / (double)o_DeviceControlLink_Component.getValueLinkedMaximum() : (double)o_DeviceControlLink_Component.getValueInternalChannels() / (double)o_DeviceControlLink_Component.getValueLinkedMaximum();
                doubleValueNormed = o_CorrectionModel.getNormedValue(doubleInputValueNormed);
                intValueValidated = o_DeviceControlLink_Component.getValueByte((int)((double)o_DeviceControlLink_Component.getValueLinkedMaximum() * doubleValueNormed), this.m_DMXDeviceChannelType.getChannelControlLink(0).getByteIndex());
            }
            o_DMXChannel.setValueChannel(this.m_Value, intValueValidated);
        }

        public void setValueByte_ControlDimension(int p_Value) {
            if (p_Value < 0) {
                p_Value = 0;
            }
            if (p_Value > 255) {
                p_Value = 255;
            }
            if (this.m_ValueControlDimension == p_Value) {
                return;
            }
            this.m_ValueControlDimension = p_Value;
            this.m_ValueControlDimensionChanged = true;
        }

        public int getValueByte_ControlDimension() {
            return this.m_ValueControlDimension;
        }

        public void addMasterDeviceControlLink(DMXControlComponent.DeviceControlLink p_DeviceControlLink) {
            if (this.m_MasterValueFactors.containsKey(p_DeviceControlLink)) {
                return;
            }
            Double o_Double = 1.0;
            p_DeviceControlLink.getValueInternalChannels();
            this.m_MasterValueFactors.put(p_DeviceControlLink, o_Double);
        }

        public void setValueByte_MasterFactor(DMXControlComponent.DeviceControlLink p_DeviceControlLink, double p_ValueFactor) {
            if (p_DeviceControlLink == null) {
                return;
            }
            if (p_ValueFactor < 0.0) {
                p_ValueFactor = 0.0;
            }
            if (p_ValueFactor > 1.0) {
                p_ValueFactor = 1.0;
            }
            double doubleValueFactor = 1.0;
            this.m_MasterValueFactors.put(p_DeviceControlLink, p_ValueFactor);
            for (Double doubleMasterValue : this.m_MasterValueFactors.values()) {
                doubleValueFactor *= doubleMasterValue.doubleValue();
            }
            if (doubleValueFactor == this.m_ValueFactor) {
                return;
            }
            this.m_ValueFactor = doubleValueFactor;
            this.m_ValueFactorChanged = true;
        }

        public boolean refreshValue_MasterFactor() {
            boolean boolChanged = false;
            if (!this.m_ValueFactorChanged) {
                return false;
            }
            DMXChannel o_DMXChannel = this.getDMXChannel();
            if (o_DMXChannel != null) {
                boolChanged = o_DMXChannel.setValueFactor(this.m_ValueFactor);
            }
            this.m_ValueFactorChanged = false;
            return boolChanged;
        }

        public double getValueByte_MasterFactor() {
            return this.m_ValueFactor;
        }

        public boolean eventValuesDMXChannel() {
            boolean boolChanged = false;
            DMXChannel o_DMXChannel = this.getDMXChannel();
            if (o_DMXChannel != null && this.m_ValueDMXChannel != o_DMXChannel.getValueNew()) {
                this.m_ValueDMXChannel = o_DMXChannel.getValueNew();
                boolChanged = true;
                if (this.m_DMXDeviceChannelType != null && (this.m_DMXDeviceChannelType.getIsDimmerChannel() || this.m_DMXDeviceChannelType.getIsDimmerSubstituteChannel())) {
                    this.m_DMXDevice.refreshIsOn();
                }
            }
            return boolChanged;
        }

        public int getValueDMXChannel() {
            return this.m_ValueDMXChannel;
        }

        public void eventValuesDMXInterface() {
            DMXChannel o_DMXChannel = this.getDMXChannel();
            this.m_ValueInterfaceValidatedReverse = o_DMXChannel != null ? (this.m_ValueDMXInterface = o_DMXChannel.getValueInterface()) : (this.m_ValueDMXInterface = 0);
        }

        public int getValueDMXInterface() {
            return this.m_ValueDMXInterface;
        }

        public void eventValuesDMXInterface_Input(int p_ValueOld, int p_ValueNew) {
            DMXChannel o_DMXChannel = this.getDMXChannel();
            if (o_DMXChannel != null) {
                this.m_ValueDMXInterface_InputOld = p_ValueOld;
                this.m_ValueDMXInterface_Input = o_DMXChannel.getValueInterface_Input();
            } else {
                this.m_ValueDMXInterface_Input = 0;
                this.m_ValueDMXInterface_InputOld = 0;
            }
            boolean intTest = false;
        }

        public int getValueDMXInterface_Input() {
            return this.m_ValueDMXInterface_Input;
        }

        public int getValueDMXInterface_InputOld() {
            return this.m_ValueDMXInterface_InputOld;
        }

        public void refreshDeviceControlLinks_ValueInterface() {
            for (int intLink = 0; intLink < this.m_DeviceControlLinks.size(); ++intLink) {
                DMXControlComponent.DeviceControlLink o_DeviceControlLink = this.m_DeviceControlLinks.get(intLink);
                if (o_DeviceControlLink == null) continue;
                o_DeviceControlLink.refreshValueDMXInterface();
            }
        }

        public void refreshDeviceControlLinks_ValuesReaden() {
            for (int intLink = 0; intLink < this.m_DeviceControlLinks.size(); ++intLink) {
                DMXControlComponent.DeviceControlLink o_DeviceControlLink = this.m_DeviceControlLinks.get(intLink);
                if (o_DeviceControlLink == null) continue;
                if (o_DeviceControlLink.getIsMainMixerLink() || o_DeviceControlLink.getMixerPanelOwner() == 3 || o_DeviceControlLink.getMixerPanelOwner() == 2 || o_DeviceControlLink.getMixerPanelOwner() == 1) {
                    o_DeviceControlLink.refreshValueDMXInterface();
                    continue;
                }
                o_DeviceControlLink.refreshValueDMXReaden();
            }
        }

        public void refreshDeviceControlLinks_ValuesReadenInput() {
            if (this.m_ValueDMXInterface_Input != this.m_ValueDMXInterface_InputOld) {
                for (int intLink = 0; intLink < this.m_DeviceControlLinks.size(); ++intLink) {
                    DMXControlComponent.DeviceControlLink o_DeviceControlLink = this.m_DeviceControlLinks.get(intLink);
                    if (o_DeviceControlLink == null) continue;
                    if (o_DeviceControlLink.getIsMainMixerLink() || o_DeviceControlLink.getMixerPanelOwner() == 3 || o_DeviceControlLink.getMixerPanelOwner() == 2 || o_DeviceControlLink.getMixerPanelOwner() == 1) {
                        o_DeviceControlLink.refreshValueDMXInterface();
                        continue;
                    }
                    o_DeviceControlLink.refreshValueDMXReadenInput();
                }
            }
            this.m_ValueDMXInterface_InputOld = this.m_ValueDMXInterface_Input;
        }

        public int getValueDMXInterface_ValidatedReversed() {
            return this.m_ValueInterfaceValidatedReverse;
        }

        public void setValueDMXInterface_ValidatedReverse(int p_ValueValidatedReverse) {
            this.m_ValueInterfaceValidatedReverse = p_ValueValidatedReverse;
        }

        public void refreshTypeChangedDeviceControlLinks() {
            for (int intLink = 0; intLink < this.m_DeviceControlLinks.size(); ++intLink) {
                DMXControlComponent.DeviceControlLink o_DeviceControlLink = this.m_DeviceControlLinks.get(intLink);
                if (o_DeviceControlLink == null) continue;
                o_DeviceControlLink.eventDeviceTypeChanged();
            }
        }

        public void setDeviceChannelType(DMXDeviceType.DMXDeviceChannelType p_DMXDeviceChannelType) {
            DMXChannel o_DMXChannel = this.m_DMXDevice.getDMXChannel(this.m_DMXDeviceInternalSector.getDMXDeviceSectorIndex(), this.m_DMXChannelRedirectedAddress);
            if (this.m_DMXDeviceChannelType != null && o_DMXChannel != null) {
                o_DMXChannel.removePropertyChangeListener(this);
                o_DMXChannel.removeDMXDeviceInternalChannel(this, false);
                for (int intLink = this.m_DeviceControlLinks.size() - 1; intLink >= 0; --intLink) {
                    DMXControlComponent.DeviceControlLink o_DeviceControlLink = this.m_DeviceControlLinks.get(intLink);
                    if (o_DeviceControlLink == null) continue;
                    o_DeviceControlLink.removeDeviceInternalChannel(this.m_DeviceControlLinksByte.get(intLink));
                    o_DeviceControlLink.refreshValueDMXInterface();
                }
            }
            this.m_DMXDeviceChannelType = p_DMXDeviceChannelType;
            if (this.m_DMXDeviceChannelType != null && o_DMXChannel != null) {
                o_DMXChannel.addDMXDeviceInternalChannel(this);
                o_DMXChannel.addPropertyChangeListener(this);
                this.eventValuesDMXInterface();
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() instanceof DMXChannel) {
                if ("dmxchannelValueInterface".equals(evt.getPropertyName())) {
                    this.eventValuesDMXInterface();
                } else if ("dmxchannelValueInterfaceInput".equals(evt.getPropertyName())) {
                    this.eventValuesDMXInterface_Input((Integer)evt.getOldValue(), (Integer)evt.getNewValue());
                } else if ("dmxchannelValueNew".equals(evt.getPropertyName())) {
                    this.eventValuesDMXChannel();
                }
            }
        }
    }

    public static class SectorAddress {
        private int m_DMXDeviceSectorIndex;
        private DMXUniverse m_DMXUniverse;
        private int m_DMXStartaddress;

        public SectorAddress(int p_SectorIndex) {
            this.initMembers();
            this.m_DMXDeviceSectorIndex = p_SectorIndex;
        }

        private void initMembers() {
            this.m_DMXUniverse = null;
            this.m_DMXStartaddress = 1;
        }

        public void setDMXDeviceSectorIndex(int p_DMXDeviceSectorIndex) {
            this.m_DMXDeviceSectorIndex = p_DMXDeviceSectorIndex;
        }

        public int getDMXDeviceSectorIndex() {
            return this.m_DMXDeviceSectorIndex;
        }

        public void setDMXStartAddress(int p_StartAddress) {
            this.m_DMXStartaddress = p_StartAddress + 1;
        }

        public int getDMXStartAddress() {
            return this.m_DMXStartaddress - 1;
        }

        public void setDMXStartAddressVisible(int p_StartAddressVisible) {
            this.m_DMXStartaddress = p_StartAddressVisible;
        }

        public int getDMXStartAddressVisible() {
            return this.m_DMXStartaddress;
        }

        public void setDMXUniverse(DMXUniverse p_DMXUniverse) {
            this.m_DMXUniverse = p_DMXUniverse;
        }

        public DMXUniverse getDMXUniverse() {
            return this.m_DMXUniverse;
        }

        public void clear() {
            this.m_DMXUniverse = null;
            this.m_DMXStartaddress = 0;
        }
    }

    public static class InternalSector
    implements Externalizable,
    PropertyChangeListener {
        private DMXDevice m_DMXDevice;
        private int m_DMXDeviceSectorIndex;
        private SectorAddress m_SectorAddress;
        private ArrayList<InternalChannel> m_InternalChannels;
        private DMXPowerSource m_DMXPowerSource;
        private boolean m_Active;
        private boolean m_Mute;
        private boolean m_Solo;
        private boolean m_ValidAddress;
        private boolean m_AdjustingPowerSource = false;

        public InternalSector(DMXDevice p_DMXDevice, int p_DMXDeviceSectorIndex) {
            this.initMembers();
            this.m_DMXDevice = p_DMXDevice;
            this.m_DMXDeviceSectorIndex = p_DMXDeviceSectorIndex;
            this.m_SectorAddress = new SectorAddress(this.m_DMXDeviceSectorIndex);
        }

        private void initMembers() {
            this.m_InternalChannels = new ArrayList();
            this.m_Active = true;
            this.m_Mute = false;
            this.m_Solo = false;
            this.m_ValidAddress = false;
            this.m_DMXPowerSource = null;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.m_SectorAddress.getDMXStartAddress());
            String stringUniverseID = null;
            if (this.m_SectorAddress.getDMXUniverse() != null) {
                stringUniverseID = this.m_SectorAddress.getDMXUniverse().getID();
            }
            if (stringUniverseID == null) {
                stringUniverseID = "";
            }
            out.writeUTF(stringUniverseID);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int intDMXStartAddress = in.readInt();
            String stringUniverseID = in.readUTF();
            DMXUniverse o_DMXUniverse = DMXUniverse.getDMXUniverse(stringUniverseID);
            this.setDMXAddress(o_DMXUniverse, intDMXStartAddress);
        }

        public long getDiskSpaceEstimated() {
            long longBytesCount = 0L;
            longBytesCount += 4L;
            String stringUniverseID = null;
            if (this.m_SectorAddress.getDMXUniverse() != null) {
                stringUniverseID = this.m_SectorAddress.getDMXUniverse().getID();
            }
            if (stringUniverseID == null) {
                stringUniverseID = "";
            }
            return longBytesCount += (long)(stringUniverseID.length() * 2);
        }

        public void close() {
            if (this.m_SectorAddress != null && this.m_SectorAddress.getDMXUniverse() != null) {
                this.m_SectorAddress.getDMXUniverse().removePropertyChangeListener(this);
                this.m_SectorAddress.getDMXUniverse().removeDMXDeviceInternalSector(this);
            }
            for (int intChannel = 0; intChannel < this.m_InternalChannels.size(); ++intChannel) {
                InternalChannel o_InternalChannel = this.m_InternalChannels.get(intChannel);
                if (o_InternalChannel == null) continue;
                o_InternalChannel.changedStartAddress(this.m_SectorAddress.getDMXUniverse(), this.m_SectorAddress.getDMXStartAddress(), null, 0);
                o_InternalChannel.close(false);
            }
            if (this.m_DMXPowerSource != null) {
                this.m_DMXPowerSource.removeDMXDeviceInternalSector(this);
            }
        }

        public DMXDevice getDMXDevice() {
            return this.m_DMXDevice;
        }

        public DMXDeviceType getDMXDeviceType() {
            if (this.m_DMXDevice == null) {
                return null;
            }
            return this.m_DMXDevice.getDMXDeviceType();
        }

        public int getDMXDeviceSectorIndex() {
            return this.m_DMXDeviceSectorIndex;
        }

        public void setDMXAddress(DMXUniverse p_DMXUniverse, int p_DMXStartAddress) {
            InternalChannel o_InternalChannel;
            int intChannel;
            if (p_DMXStartAddress < 0 || p_DMXStartAddress >= 512) {
                return;
            }
            boolean boolUniverseChanged = false;
            boolean boolAddressChanged = false;
            if (this.m_SectorAddress.getDMXUniverse() != p_DMXUniverse) {
                boolUniverseChanged = true;
            }
            if (this.m_SectorAddress.getDMXStartAddress() != p_DMXStartAddress) {
                boolAddressChanged = true;
            }
            if (!boolAddressChanged && !boolUniverseChanged) {
                if (this.m_SectorAddress.getDMXUniverse() == null) {
                    // empty if block
                }
                return;
            }
            DMXUniverse oldDMXUniverse = this.m_SectorAddress.getDMXUniverse();
            int oldDMXStartAddress = this.m_SectorAddress.getDMXStartAddress();
            this.m_SectorAddress.setDMXUniverse(p_DMXUniverse);
            this.m_SectorAddress.setDMXStartAddress(p_DMXStartAddress);
            for (intChannel = 0; intChannel < this.m_InternalChannels.size(); ++intChannel) {
                o_InternalChannel = this.m_InternalChannels.get(intChannel);
                if (o_InternalChannel == null) continue;
                o_InternalChannel.changedStartAddress(oldDMXUniverse, oldDMXStartAddress, this.m_SectorAddress.getDMXUniverse(), this.m_SectorAddress.getDMXStartAddress());
            }
            if (boolUniverseChanged) {
                if (oldDMXUniverse != null) {
                    oldDMXUniverse.removePropertyChangeListener(this);
                    oldDMXUniverse.removeDMXDeviceInternalSector(this);
                }
                if (this.m_SectorAddress.getDMXUniverse() != null) {
                    this.m_SectorAddress.getDMXUniverse().addDMXDeviceInternalSector(this);
                    this.m_SectorAddress.getDMXUniverse().addPropertyChangeListener(this);
                }
            }
            for (intChannel = 0; intChannel < this.m_InternalChannels.size(); ++intChannel) {
                o_InternalChannel = this.m_InternalChannels.get(intChannel);
                if (o_InternalChannel == null) continue;
                o_InternalChannel.eventValuesDMXChannel();
                o_InternalChannel.eventValuesDMXInterface();
            }
            if (oldDMXUniverse != null) {
                DMXUniverseInputPatch.eventDMXDeviceAddressChanged(oldDMXUniverse);
            }
            if (this.m_SectorAddress.getDMXUniverse() != null && oldDMXUniverse != this.m_SectorAddress.getDMXUniverse()) {
                DMXUniverseInputPatch.eventDMXDeviceAddressChanged(this.m_SectorAddress.getDMXUniverse());
            }
            this.m_DMXDevice.refreshToolTipText();
            SinglePropertyChangeSupport o_PropertyChangeSupport = this.m_DMXDevice.getPropertyChangeSupport();
            if (boolUniverseChanged) {
                o_PropertyChangeSupport.fireIndexedPropertyChange(DMXDevice.PROP_INDEXED_DMXDEVICE_UNIVERSE, this.m_DMXDeviceSectorIndex, oldDMXUniverse, this.m_SectorAddress.getDMXUniverse());
            }
            if (boolAddressChanged) {
                o_PropertyChangeSupport.fireIndexedPropertyChange(DMXDevice.PROP_INDEXED_DMXDEVICE_STARTADDRESS, this.m_DMXDeviceSectorIndex, oldDMXStartAddress, this.m_SectorAddress.getDMXStartAddress());
            }
            this.refreshDeviceControlLinks_ValueInternalChannels_EditMode();
            this.refreshDeviceControlLinks_ValueInternalChannels(false);
            this.refreshDeviceControlLinks_ValueInterface();
            DMXDevice.checkAllDevicesAddresses();
            this.sendValuesToDMXChannels(false);
            this.sendValuesToDMXUniverse();
        }

        public DMXUniverse getDMXUniverse() {
            return this.m_SectorAddress.getDMXUniverse();
        }

        public int getDMXStartAddress() {
            return this.m_SectorAddress.getDMXStartAddress();
        }

        public int getDMXStartAddressVisible() {
            return this.m_SectorAddress.getDMXStartAddress() + 1;
        }

        public SectorAddress getSectorAddress() {
            return this.m_SectorAddress;
        }

        public boolean checkValidAddress() {
            this.m_ValidAddress = this.m_SectorAddress.getDMXUniverse() == null ? false : this.m_SectorAddress.getDMXUniverse().checkAddressValid(this, this.getDMXStartAddress());
            return this.m_ValidAddress;
        }

        public boolean getValidAddress() {
            return this.m_ValidAddress;
        }

        public void setDMXPowerSource(DMXPowerSource p_DMXPowerSource) {
            int intRow;
            if (this.m_AdjustingPowerSource) {
                return;
            }
            if (this.m_DMXPowerSource == p_DMXPowerSource) {
                return;
            }
            this.m_AdjustingPowerSource = true;
            DMXPowerSource oldValue = this.m_DMXPowerSource;
            if (this.m_DMXPowerSource != null) {
                this.m_DMXPowerSource.removeDMXDeviceInternalSector(this);
                this.m_DMXPowerSource.removePropertyChangeListener(this);
            }
            this.m_DMXPowerSource = p_DMXPowerSource;
            if (this.m_DMXPowerSource != null) {
                this.m_DMXPowerSource.addDMXDeviceInternalSector(this);
                this.m_DMXPowerSource.addPropertyChangeListener(this);
                this.m_DMXPowerSource.refreshDMXDeviceInternalSectors();
            }
            if ((intRow = s_DMXDeviceTableModel.getRowOfDMXDevice(this)) >= 0) {
                this.m_DMXDevice.refreshToolTipText();
                s_DMXDeviceTableModel.changedElement(this);
                this.m_DMXDevice.getPropertyChangeSupport().fireIndexedPropertyChange(DMXDevice.PROP_INDEXED_DMXDEVICE_DMXPOWERSOURCE, intRow, oldValue, this.m_DMXPowerSource);
            }
            this.m_AdjustingPowerSource = false;
        }

        public DMXPowerSource getDMXPowerSource() {
            return this.m_DMXPowerSource;
        }

        public int getWattage() {
            DMXDeviceType o_DMXDeviceType = this.getDMXDeviceType();
            if (o_DMXDeviceType == null) {
                return 0;
            }
            DMXDeviceType.DMXDeviceSector o_DMXDeviceSector = o_DMXDeviceType.getDMXDeviceSector(this.m_DMXDeviceSectorIndex);
            if (o_DMXDeviceSector == null) {
                return 0;
            }
            return o_DMXDeviceSector.getWattage();
        }

        public DMXChannel getDMXChannel(int p_InternalChannelNumber) {
            if (this.m_SectorAddress.getDMXUniverse() == null) {
                return null;
            }
            return this.m_SectorAddress.getDMXUniverse().getDMXChannel(this.m_SectorAddress.getDMXStartAddress() + p_InternalChannelNumber);
        }

        public int getInternalChannelNumber(DMXChannel p_DMXChannel) {
            if (p_DMXChannel == null) {
                return -1;
            }
            for (int intInternalChannel = 0; intInternalChannel < this.m_InternalChannels.size(); ++intInternalChannel) {
                DMXChannel o_DMXChannel;
                InternalChannel o_InternalChannel = this.m_InternalChannels.get(intInternalChannel);
                if (o_InternalChannel == null || (o_DMXChannel = o_InternalChannel.getDMXChannel()) != p_DMXChannel) continue;
                return intInternalChannel;
            }
            return -1;
        }

        public void addInternalChannel(InternalChannel p_InternalChannel) {
            if (p_InternalChannel == null) {
                return;
            }
            if (this.m_InternalChannels.contains(p_InternalChannel)) {
                return;
            }
            this.m_InternalChannels.add(p_InternalChannel);
        }

        public void removeInternalChannel(InternalChannel p_InternalChannel) {
            if (p_InternalChannel == null) {
                return;
            }
            if (!this.m_InternalChannels.contains(p_InternalChannel)) {
                return;
            }
            this.m_InternalChannels.remove(p_InternalChannel);
        }

        public int getInternalChannelCount() {
            return this.m_InternalChannels.size();
        }

        public InternalChannel getInternalChannel(int p_InternalChannelAddress) {
            if (p_InternalChannelAddress < 0 || p_InternalChannelAddress >= this.m_InternalChannels.size()) {
                return null;
            }
            return this.m_InternalChannels.get(p_InternalChannelAddress);
        }

        public boolean setValues(ArrayList<Integer> p_InternalChannels, ArrayList<Double> p_InternalChannelsNewValues, boolean p_WriteValuesToUniverse, boolean p_ManuallySet, boolean p_EditMode) {
            if (this.m_DMXDevice == null) {
                return false;
            }
            boolean boolChanged = false;
            int intValue = 0;
            DMXDeviceType o_DMXDeviceType = this.m_DMXDevice.getDMXDeviceType();
            if (o_DMXDeviceType == null) {
                return false;
            }
            DMXDeviceType.DMXDeviceSector o_DMXDeviceSector = o_DMXDeviceType.getDMXDeviceSector(this.m_DMXDeviceSectorIndex);
            if (o_DMXDeviceSector == null) {
                return false;
            }
            for (int intChannelChanged = 0; intChannelChanged < p_InternalChannels.size(); ++intChannelChanged) {
                DMXDeviceType.DMXDeviceChannelType o_DMXDeviceChannelType;
                int intInternalChannel = p_InternalChannels.get(intChannelChanged);
                InternalChannel o_InternalChannel = this.getInternalChannel(intInternalChannel);
                if (o_InternalChannel == null || (o_DMXDeviceChannelType = o_DMXDeviceSector.getDMXDeviceChannelType(intInternalChannel)) == null || intChannelChanged >= p_InternalChannelsNewValues.size()) continue;
                intValue = (int)(p_InternalChannelsNewValues.get(intChannelChanged) + 0.5);
                if (!p_EditMode) {
                    if (!o_InternalChannel.setValue(intValue, p_ManuallySet)) continue;
                    boolChanged = true;
                    continue;
                }
                if (!o_InternalChannel.setValue_EditMode(intValue, p_ManuallySet)) continue;
                boolChanged = true;
            }
            return boolChanged;
        }

        public void sendValuesToDMXChannels(boolean p_IsManuallySet) {
            for (int intChannel = 0; intChannel < this.m_InternalChannels.size(); ++intChannel) {
                InternalChannel o_InternalChannel = this.m_InternalChannels.get(intChannel);
                if (o_InternalChannel == null) continue;
                o_InternalChannel.sendValueToDMXChannel();
            }
        }

        public void sendValuesToDMXUniverse() {
            if (this.m_SectorAddress.getDMXUniverse() != null && this.m_Active) {
                this.m_SectorAddress.getDMXUniverse().callDMXOutput_WriteChannels();
            }
        }

        public void sendValuesToDMXControls() {
            for (int intChannel = 0; intChannel < this.m_InternalChannels.size(); ++intChannel) {
                InternalChannel o_InternalChannel = this.m_InternalChannels.get(intChannel);
                if (o_InternalChannel == null) continue;
                o_InternalChannel.eventValuesDMXChannel();
            }
        }

        public void refreshValueFactors() {
            boolean boolChanged = false;
            for (int intChannel = 0; intChannel < this.m_InternalChannels.size(); ++intChannel) {
                InternalChannel o_InternalChannel = this.m_InternalChannels.get(intChannel);
                if (o_InternalChannel == null || !o_InternalChannel.refreshValue_MasterFactor()) continue;
                boolChanged = true;
            }
            if (this.m_SectorAddress.getDMXUniverse() != null && boolChanged) {
                this.m_SectorAddress.getDMXUniverse().callDMXOutput_WriteChannels();
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            SinglePropertyChangeSupport o_PropertyChangeSupport;
            if (evt.getSource() instanceof DMXUniverse) {
                if ("universeName".equals(evt.getPropertyName())) {
                    if (this.m_DMXDevice != null) {
                        SinglePropertyChangeSupport o_PropertyChangeSupport2 = this.m_DMXDevice.getPropertyChangeSupport();
                        this.m_DMXDevice.refreshToolTipText();
                        o_PropertyChangeSupport2.fireIndexedPropertyChange(DMXDevice.PROP_INDEXED_DMXDEVICE_UNIVERSENAME, this.m_DMXDeviceSectorIndex, evt.getOldValue(), evt.getNewValue());
                    }
                } else if ("valuesHardwareInterface_Written".equals(evt.getPropertyName())) {
                    this.refreshDeviceControlLinks_ValueInterface();
                } else if ("valuesHardwareInterface_Readen".equals(evt.getPropertyName())) {
                    this.refreshDeviceControlLinks_ValuesReaden();
                } else if ("valuesHardwareInterface_ReadenInput".equals(evt.getPropertyName())) {
                    this.refreshDeviceControlLinks_ValuesReadenInput();
                } else if ("universeHardwarePluggedIn".equals(evt.getPropertyName())) {
                    SinglePropertyChangeSupport o_PropertyChangeSupport3 = this.m_DMXDevice.getPropertyChangeSupport();
                    o_PropertyChangeSupport3.fireIndexedPropertyChange(DMXDevice.PROP_INDEXED_DMXDEVICE_UNIVERSE, this.m_DMXDeviceSectorIndex, evt.getOldValue(), evt.getNewValue());
                }
            } else if (evt.getSource() instanceof DMXPowerSource && this.m_DMXDevice != null && (o_PropertyChangeSupport = this.m_DMXDevice.getPropertyChangeSupport()) != null) {
                this.m_DMXDevice.refreshToolTipText();
                o_PropertyChangeSupport.fireIndexedPropertyChange(DMXDevice.PROP_INDEXED_DMXDEVICE_DMXPOWERSOURCE, this.m_DMXDeviceSectorIndex, evt.getOldValue(), evt.getNewValue());
            }
        }

        public void setActive(boolean p_Active) {
            this.setSoloMuteActive(this.m_Solo, this.m_Mute, p_Active);
        }

        public void setMute(boolean p_Mute) {
            this.setSoloMuteActive(this.m_Solo, p_Mute, this.m_Active);
        }

        public void setSolo(boolean p_Solo) {
            this.setSoloMuteActive(p_Solo, this.m_Mute, this.m_Active);
        }

        public void setSoloMuteActive(boolean p_Solo, boolean p_Mute, boolean p_Active) {
            boolean boolNullValues = false;
            this.m_Solo = p_Solo;
            this.m_Mute = p_Mute;
            this.m_Active = p_Active;
            if (!this.m_Active || this.m_Mute || !this.m_Solo && s_SoloOn) {
                boolNullValues = true;
            }
            for (int intInternalChannel = 0; intInternalChannel < this.m_InternalChannels.size(); ++intInternalChannel) {
                InternalChannel o_InternalChannel = this.m_InternalChannels.get(intInternalChannel);
                if (o_InternalChannel == null) continue;
                o_InternalChannel.setActive(this.m_Active);
                o_InternalChannel.setMute(this.m_Mute);
                o_InternalChannel.setSolo(this.m_Solo);
                if (boolNullValues) continue;
                o_InternalChannel.sendValueToDMXChannel();
            }
            if (this.m_SectorAddress.getDMXUniverse() != null) {
                this.m_SectorAddress.getDMXUniverse().callDMXOutput_WriteChannels();
            }
            this.refreshDeviceControlLinks_ValueInternalChannels(false);
        }

        public void refreshDeviceControlLinks_ValueInternalChannels_EditMode() {
            for (int intChannel = 0; intChannel < this.m_InternalChannels.size(); ++intChannel) {
                InternalChannel o_InternalChannel = this.m_InternalChannels.get(intChannel);
                if (o_InternalChannel == null) continue;
                o_InternalChannel.refreshDeviceControlLinks_ValueChannel_EditMode();
            }
        }

        public void refreshDeviceControlLinks_ValueInternalChannels(boolean p_ManuallaySet) {
            for (int intChannel = 0; intChannel < this.m_InternalChannels.size(); ++intChannel) {
                InternalChannel o_InternalChannel = this.m_InternalChannels.get(intChannel);
                if (o_InternalChannel == null) continue;
                o_InternalChannel.refreshDeviceControlLinks_ValueChannel(p_ManuallaySet);
            }
        }

        public void refreshDeviceControlLinks_ValueInterface() {
            for (int intPanel = 0; intPanel < this.m_DMXDevice.getDeviceSettingsPanelCount(); ++intPanel) {
                DMXControlComponent.DeviceSettingsPanel o_DeviceSettingsPanel = this.m_DMXDevice.getDeviceSettingsPanel(intPanel);
                if (o_DeviceSettingsPanel == null) continue;
                o_DeviceSettingsPanel.validateReverseValuesInterface(false);
            }
            for (int intChannel = 0; intChannel < this.m_InternalChannels.size(); ++intChannel) {
                InternalChannel o_InternalChannel = this.m_InternalChannels.get(intChannel);
                if (o_InternalChannel == null) continue;
                o_InternalChannel.refreshDeviceControlLinks_ValueInterface();
            }
        }

        public void refreshDeviceControlLinks_ValuesReaden() {
            for (int intPanel = 0; intPanel < this.m_DMXDevice.getDeviceSettingsPanelCount(); ++intPanel) {
                DMXControlComponent.DeviceSettingsPanel o_DeviceSettingsPanel = this.m_DMXDevice.getDeviceSettingsPanel(intPanel);
                if (o_DeviceSettingsPanel == null) continue;
                o_DeviceSettingsPanel.validateReverseValuesInterface(false);
            }
            for (int intChannel = 0; intChannel < this.m_InternalChannels.size(); ++intChannel) {
                InternalChannel o_InternalChannel = this.m_InternalChannels.get(intChannel);
                if (o_InternalChannel == null) continue;
                o_InternalChannel.refreshDeviceControlLinks_ValuesReaden();
            }
        }

        public void refreshDeviceControlLinks_ValuesReadenInput() {
            for (int intChannel = 0; intChannel < this.m_InternalChannels.size(); ++intChannel) {
                InternalChannel o_InternalChannel = this.m_InternalChannels.get(intChannel);
                if (o_InternalChannel == null) continue;
                o_InternalChannel.refreshDeviceControlLinks_ValuesReadenInput();
            }
        }

        public void refreshDeviceControlLinks_TypeChanged() {
            for (int intChannel = 0; intChannel < this.m_InternalChannels.size(); ++intChannel) {
                InternalChannel o_InternalChannel = this.m_InternalChannels.get(intChannel);
                if (o_InternalChannel == null) continue;
                o_InternalChannel.refreshTypeChangedDeviceControlLinks();
            }
        }
    }
}

