/*
 * Decompiled with CFR 0.152.
 */
package DMX512;

import DMX512.DMXChannel;
import DMX512.DMXUniverse;
import DMXDevicePackage.DMXDevice;
import DMXMixer.DMXControlComponent;
import DMXMixer.DMXControlDescription;
import DMXScenePackage.DMXScene;
import DMXVirtualPackage.LiveShowDMXVIP;
import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LanguageTools.LiveLanguagePackage.LiveLanguageString;
import LiveShowObjectPackage.SinglePropertyChangeSupport;
import LiveShowPlayPackage.PlayRemoteActions;
import StartPackage.LiveShowDMXSystem;
import SwingModelPackage.TableAndListModel;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.table.DefaultTableCellRenderer;

public class DMXUniverseInputPatch
implements PropertyChangeListener,
Externalizable {
    public static final int SOFTWAREVERSION = 2;
    public static final String FILESUFFIX = ".uip";
    public static final int INPUTMODE_REMOTE = 0;
    public static final int INPUTMODE_ALLVALUES = 2;
    public static final int INPUTMODE_CHANGEDVALUES = 4;
    public static final int INPUTMODE_CHANGEDVALUESCAUGHT = 8;
    public static final int OUTPUTMODE_ALLDMXDEVICES = 0;
    public static final int OUTPUTMODE_SELECTEDDMXDEVICES = 4;
    public static final int OUTPUTMODE_SELECTEDDMXDEVICES_PATCHED = 16;
    public static final String PROP_DMXUNIVERSECONNECTION = "prop_dmxUniverseConnection";
    public static ArrayList<DMXUniverseInputPatch> s_DMXUniverseInputPatches = new ArrayList();
    public static final Object s_SyncDMXUniverseInputPatch = new Object();
    public static ArrayList<DMXDevice> s_SelectedMDXDevices = new ArrayList();
    public static DMXControlDescription.DMXControlDescriptionListModel s_DMXControlDescriptionList = new DMXControlDescription.DMXControlDescriptionListModel();
    private DMXUniverse m_DMXUniverseInput;
    private boolean m_InputConnected;
    private DMXUniverse m_DMXUniverseOutput;
    private int m_InputMode;
    private int m_OutputMode;
    private int[] m_ValuesHardware_InputOld;
    private boolean[] m_ValuesHardware_Snapped;
    private ArrayList<String> m_Limitation_DescriptionIDs;
    private InputPatchTableModel m_InputMatchTableModel = new InputPatchTableModel();
    private SinglePropertyChangeSupport m_SinglePropertyChangeSupport;
    private final Object m_SyncObject = new Object();
    private ArrayList<DMXUniverse> m_TempDMXUniversesOutput = new ArrayList();
    public static ArrayList<InputPatch> s_InputPatchPool;
    public static final Object s_SyncInputPatchPool;
    public static InputPatchTableModel s_EmptyInputPatchTableModel;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDMXUniverseInputPatch(DMXUniverseInputPatch p_DMXUniverseInputPatch) {
        if (p_DMXUniverseInputPatch == null) {
            return;
        }
        Object object = s_SyncDMXUniverseInputPatch;
        synchronized (object) {
            if (s_DMXUniverseInputPatches.contains(p_DMXUniverseInputPatch)) {
                return;
            }
            s_DMXUniverseInputPatches.add(p_DMXUniverseInputPatch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeDMXUniverseInputPatch(DMXUniverseInputPatch p_DMXUniverseInputPatch) {
        if (p_DMXUniverseInputPatch == null) {
            return;
        }
        Object object = s_SyncDMXUniverseInputPatch;
        synchronized (object) {
            s_DMXUniverseInputPatches.remove(p_DMXUniverseInputPatch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getDMXUniverseInputPatchCount() {
        Object object = s_SyncDMXUniverseInputPatch;
        synchronized (object) {
            return s_DMXUniverseInputPatches.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DMXUniverseInputPatch getDMXUniverseInputPatch(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        Object object = s_SyncDMXUniverseInputPatch;
        synchronized (object) {
            if (p_Index >= s_DMXUniverseInputPatches.size()) {
                return null;
            }
            return s_DMXUniverseInputPatches.get(p_Index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void eventDMXDeviceAddressChanged(DMXUniverse p_DMXUniverseOutput) {
        if (p_DMXUniverseOutput == null) {
            return;
        }
        Object object = s_SyncDMXUniverseInputPatch;
        synchronized (object) {
            for (int intDMXUniverseInputPatch = 0; intDMXUniverseInputPatch < s_DMXUniverseInputPatches.size(); ++intDMXUniverseInputPatch) {
                DMXUniverseInputPatch o_DMXUniverseInputPatch = s_DMXUniverseInputPatches.get(intDMXUniverseInputPatch);
                if (o_DMXUniverseInputPatch == null || o_DMXUniverseInputPatch.getDMXUniverseOutput() != p_DMXUniverseOutput) continue;
                o_DMXUniverseInputPatch.calculateChannelPatch();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addSelectedDMXDevice(DMXDevice p_DMXDevice) {
        if (p_DMXDevice == null) {
            return;
        }
        Object object = s_SyncDMXUniverseInputPatch;
        synchronized (object) {
            if (s_SelectedMDXDevices.contains(p_DMXDevice)) {
                return;
            }
            s_SelectedMDXDevices.add(p_DMXDevice);
            for (int intPatch = 0; intPatch < s_DMXUniverseInputPatches.size(); ++intPatch) {
                s_DMXUniverseInputPatches.get(intPatch).eventSelectedDMXDevice();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeSelectedDMXDevice(DMXDevice p_DMXDevice) {
        if (p_DMXDevice == null) {
            return;
        }
        Object object = s_SyncDMXUniverseInputPatch;
        synchronized (object) {
            s_SelectedMDXDevices.remove(p_DMXDevice);
            for (int intPatch = 0; intPatch < s_DMXUniverseInputPatches.size(); ++intPatch) {
                s_DMXUniverseInputPatches.get(intPatch).eventSelectedDMXDevice();
            }
        }
    }

    public static int getSelectedDMXDeviceCount() {
        return s_SelectedMDXDevices.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DMXDevice getSelectedDMXDevice(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        Object object = s_SyncDMXUniverseInputPatch;
        synchronized (object) {
            if (p_Index >= s_SelectedMDXDevices.size()) {
                return null;
            }
            return s_SelectedMDXDevices.get(p_Index);
        }
    }

    public DMXUniverseInputPatch(DMXUniverse p_DMXUniverse) {
        this.initMembers();
        DMXUniverseInputPatch.addDMXUniverseInputPatch(this);
        this.m_DMXUniverseInput = p_DMXUniverse;
        this.setDMXUniverseOutput(p_DMXUniverse);
        PlayRemoteActions.addPropertyChangeListener(this);
        this.calculateChannelPatch();
    }

    private void initMembers() {
        this.m_SinglePropertyChangeSupport = new SinglePropertyChangeSupport(this);
        this.m_InputConnected = false;
        this.m_DMXUniverseOutput = null;
        this.m_ValuesHardware_InputOld = new int[512];
        this.m_ValuesHardware_Snapped = new boolean[512];
        this.m_Limitation_DescriptionIDs = new ArrayList();
        this.m_InputMode = 0;
        this.m_OutputMode = 0;
        this.resetValuesInputOld();
        this.resetSnapped();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.clearPropertyChangeSupport_DMXDevice();
        PlayRemoteActions.removePropertyChangeListener(this);
        DMXUniverseInputPatch.removeDMXUniverseInputPatch(this);
        Object object = this.m_SyncObject;
        synchronized (object) {
            this.m_InputMatchTableModel.clearInputPatches();
            this.m_DMXUniverseInput = null;
            this.m_DMXUniverseOutput = null;
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(2);
        out.writeUTF(this.m_DMXUniverseInput.getID());
        if (this.m_DMXUniverseOutput == null) {
            out.writeUTF("null");
        } else {
            out.writeUTF(this.m_DMXUniverseOutput.getID());
        }
        out.writeInt(this.m_InputMode);
        out.writeInt(this.m_OutputMode);
        out.writeInt(this.m_Limitation_DescriptionIDs.size());
        for (int intLimitation = 0; intLimitation < this.m_Limitation_DescriptionIDs.size(); ++intLimitation) {
            String stringLimitationID = this.m_Limitation_DescriptionIDs.get(intLimitation);
            out.writeUTF(stringLimitationID);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        DMXUniverse o_DMXUniverse;
        String stringDMXUniverseOutputID;
        int intSoftwareVersion = in.readInt();
        String stringDMXUniverseInputID = in.readUTF();
        this.m_InputConnected = false;
        if (this.m_DMXUniverseInput != null && this.m_DMXUniverseInput.getDMXHardwarePlugin_Input() != null) {
            this.m_InputConnected = true;
        }
        this.m_DMXUniverseOutput = "null".equals(stringDMXUniverseOutputID = in.readUTF()) ? null : (o_DMXUniverse = DMXUniverse.getDMXUniverse(stringDMXUniverseOutputID));
        if (this.m_DMXUniverseOutput != null) {
            this.m_DMXUniverseOutput.addDMXUniverseInputPatch(this);
        }
        this.m_InputMode = in.readInt();
        this.m_OutputMode = in.readInt();
        int intLimitationCount = in.readInt();
        for (int intLimitation = 0; intLimitation < intLimitationCount; ++intLimitation) {
            String stringLimitationID = in.readUTF();
            this.m_Limitation_DescriptionIDs.add(stringLimitationID);
        }
        this.calculateChannelPatch();
        this.resetSnapped();
        this.resetValuesInputOld();
    }

    public void eventDMXInputConnected(boolean p_InputConnected) {
        if (this.m_InputConnected == p_InputConnected) {
            return;
        }
        this.m_InputConnected = p_InputConnected;
        this.calculateChannelPatch();
        this.resetValuesInputOld();
        this.resetSnapped();
        this.m_SinglePropertyChangeSupport.firePropertyChange(PROP_DMXUNIVERSECONNECTION, null, this);
    }

    public boolean isDMXInputConnected() {
        return this.m_InputConnected;
    }

    public void eventAllDMXDevicesLoaded() {
        this.calculateChannelPatch();
    }

    public void setInputMode(int p_InputMode) {
        if (this.m_InputMode == p_InputMode) {
            return;
        }
        switch (p_InputMode) {
            case 0: {
                this.m_InputMode = p_InputMode;
                this.calculateChannelPatch();
                break;
            }
            case 2: {
                this.m_InputMode = p_InputMode;
                this.calculateChannelPatch();
                break;
            }
            case 4: {
                this.m_InputMode = p_InputMode;
                this.calculateChannelPatch();
                break;
            }
            case 8: {
                this.m_InputMode = p_InputMode;
                this.calculateChannelPatch();
                this.resetSnapped();
                break;
            }
            default: {
                return;
            }
        }
    }

    public int getInputMode() {
        return this.m_InputMode;
    }

    private void resetSnapped() {
        for (int intValue = 0; intValue < 512; ++intValue) {
            this.m_ValuesHardware_Snapped[intValue] = false;
        }
    }

    public void resetValuesInputOld() {
        for (int intChannel = 0; intChannel < this.m_ValuesHardware_InputOld.length; ++intChannel) {
            this.m_ValuesHardware_InputOld[intChannel] = -1;
        }
    }

    public DMXUniverse getDMXUniverseInput() {
        return this.m_DMXUniverseInput;
    }

    public void setOutputMode(int p_OutputMode) {
        if (this.m_OutputMode == p_OutputMode) {
            return;
        }
        switch (p_OutputMode) {
            case 0: {
                this.m_OutputMode = p_OutputMode;
                if (this.m_InputMode == 0) break;
                this.calculateChannelPatch();
                this.resetSnapped();
                break;
            }
            case 4: {
                this.m_OutputMode = p_OutputMode;
                if (this.m_InputMode == 0) break;
                this.calculateChannelPatch();
                this.resetSnapped();
                break;
            }
            case 16: {
                this.m_OutputMode = p_OutputMode;
                if (this.m_InputMode == 0) break;
                this.calculateChannelPatch();
                this.resetSnapped();
                break;
            }
            default: {
                return;
            }
        }
    }

    public int getOutputMode() {
        return this.m_OutputMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setDMXUniverseOutput(DMXUniverse p_DMXUniverse) {
        DMXUniverse o_DMXUniverseOutput;
        if (this.m_DMXUniverseOutput == p_DMXUniverse) {
            return false;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            o_DMXUniverseOutput = this.m_DMXUniverseOutput;
        }
        if (o_DMXUniverseOutput != null) {
            this.resetValuesInputOld();
            this.resetSnapped();
            o_DMXUniverseOutput.removeDMXUniverseInputPatch(this);
        }
        object = this.m_SyncObject;
        synchronized (object) {
            o_DMXUniverseOutput = this.m_DMXUniverseOutput = p_DMXUniverse;
        }
        if (o_DMXUniverseOutput != null) {
            o_DMXUniverseOutput.addDMXUniverseInputPatch(this);
        }
        if (this.m_InputMode != 0) {
            this.calculateChannelPatch();
            this.resetSnapped();
        }
        return true;
    }

    public DMXUniverse getDMXUniverseOutput() {
        return this.m_DMXUniverseOutput;
    }

    public void eventSelectedDMXDevice() {
        switch (this.m_OutputMode) {
            case 0: {
                break;
            }
            case 16: {
                if (this.m_InputMode == 0) break;
                this.calculateChannelPatch();
                this.resetSnapped();
                break;
            }
            case 4: {
                if (this.m_InputMode == 0) break;
                this.calculateChannelPatch();
                this.resetSnapped();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLimitation(String p_RestrictedDescriptionID) {
        if (p_RestrictedDescriptionID == null) {
            return;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            if (this.m_Limitation_DescriptionIDs.contains(p_RestrictedDescriptionID)) {
                return;
            }
            this.m_Limitation_DescriptionIDs.add(p_RestrictedDescriptionID);
            if (this.m_InputMode != 0) {
                this.calculateChannelPatch();
                this.resetSnapped();
                this.resetValuesInputOld();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLimitation(String p_RestrictedDescriptionID) {
        if (p_RestrictedDescriptionID == null) {
            return;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            if (this.m_Limitation_DescriptionIDs.remove(p_RestrictedDescriptionID) && this.m_InputMode != 0) {
                this.calculateChannelPatch();
                this.resetSnapped();
                this.resetValuesInputOld();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearLimitations() {
        Object object = this.m_SyncObject;
        synchronized (object) {
            if (this.m_Limitation_DescriptionIDs.size() <= 0) {
                return;
            }
            this.m_Limitation_DescriptionIDs.clear();
            if (this.m_InputMode != 0) {
                this.calculateChannelPatch();
                this.resetSnapped();
                this.resetValuesInputOld();
            }
        }
    }

    public int getLimitationCount() {
        return this.m_Limitation_DescriptionIDs.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLimitationID(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            if (p_Index >= this.m_Limitation_DescriptionIDs.size()) {
                return null;
            }
            return this.m_Limitation_DescriptionIDs.get(p_Index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLimitationName(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            if (p_Index >= this.m_Limitation_DescriptionIDs.size()) {
                return null;
            }
            DMXControlDescription o_DMXControlDescription = DMXControlDescription.getDMXControlDescription(this.m_Limitation_DescriptionIDs.get(p_Index));
            if (o_DMXControlDescription == null) {
                return null;
            }
            return o_DMXControlDescription.getName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DMXControlDescription getLimitationDMXControlDescription(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            if (p_Index >= this.m_Limitation_DescriptionIDs.size()) {
                return null;
            }
            DMXControlDescription o_DMXControlDescription = DMXControlDescription.getDMXControlDescription(this.m_Limitation_DescriptionIDs.get(p_Index));
            return o_DMXControlDescription;
        }
    }

    public int getDMXDeviceCount() {
        switch (this.m_OutputMode) {
            case 0: {
                return DMXDevice.getDMXDeviceCount();
            }
            case 4: {
                return s_SelectedMDXDevices.size();
            }
            case 16: {
                return s_SelectedMDXDevices.size();
            }
        }
        return 0;
    }

    public DMXDevice getDMXDevice(int p_Index) {
        switch (this.m_OutputMode) {
            case 0: {
                return DMXDevice.getDMXDevice(p_Index);
            }
            case 4: {
                return DMXUniverseInputPatch.getSelectedDMXDevice(p_Index);
            }
            case 16: {
                return DMXUniverseInputPatch.getSelectedDMXDevice(p_Index);
            }
        }
        return null;
    }

    public void clearPropertyChangeSupport_DMXDevice() {
        for (int intDMXDevice = 0; intDMXDevice < DMXDevice.getDMXDeviceCount(); ++intDMXDevice) {
            DMXDevice o_DMXDevice = DMXDevice.getDMXDevice(intDMXDevice);
            if (o_DMXDevice == null) continue;
            o_DMXDevice.removePropertyChangeListener("dmxdeviceDeviceName", this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void calculateChannelPatch() {
        int intPosition = 0;
        boolean boolHasDMXUniverseInput = false;
        ArrayList<DMXControlComponent> o_DMXControlComponents = new ArrayList<DMXControlComponent>();
        Object object = this.m_SyncObject;
        synchronized (object) {
            if (this.m_DMXUniverseInput == null) {
                return;
            }
            this.m_InputMatchTableModel.clearInputPatches();
            this.clearPropertyChangeSupport_DMXDevice();
            if (!this.m_InputConnected) {
                return;
            }
            if (this.m_InputMode == 0) {
                int intRemoteActionCount = PlayRemoteActions.getRemoteActionCount();
                for (int intRemoteAction = 0; intRemoteAction < intRemoteActionCount; ++intRemoteAction) {
                    int intChannel;
                    DMXUniverse o_DMXUniverse;
                    PlayRemoteActions.RemoteAction o_RemoteAction = PlayRemoteActions.getRemoteAction(intRemoteAction);
                    if (o_RemoteAction == null || (o_DMXUniverse = (DMXUniverse)o_RemoteAction.getDMXRemoteActionTrigger()) == null || o_DMXUniverse != this.m_DMXUniverseInput || (intChannel = o_RemoteAction.getDMXChannel()) < 0) continue;
                    InputPatch o_InputPatch = DMXUniverseInputPatch.poolGetInputMatch();
                    o_InputPatch.setDMXUniverseInputPatch(this);
                    o_InputPatch.setDMXInputChannel(intChannel);
                    o_InputPatch.setRemoteAction(o_RemoteAction);
                    this.m_InputMatchTableModel.addInputPatch(o_InputPatch);
                    o_RemoteAction.getActionName();
                }
                return;
            }
            intPosition = 0;
            for (int intDMXDevice = 0; intDMXDevice < this.getDMXDeviceCount(); ++intDMXDevice) {
                InputPatch o_InputPatch;
                int intDMXAddressInput;
                DMXChannel o_DMXChannelOutput;
                DMXDevice.InternalChannel o_InternalChannel;
                DMXControlComponent.DeviceControlLink o_DeviceControlLink;
                DMXControlComponent.ControlDimensionType o_ControlDimensionType;
                DMXControlComponent.ControlType o_ControlType;
                DMXControlComponent o_DMXControlComponent;
                DMXDevice o_DMXDevice = this.getDMXDevice(intDMXDevice);
                if (o_DMXDevice == null) continue;
                o_DMXDevice.removePropertyChangeListener(this);
                if (this.m_OutputMode != 16) {
                    boolHasDMXUniverseInput = false;
                    for (int intInternalSector = 0; intInternalSector < o_DMXDevice.getInternalSectorCount(); ++intInternalSector) {
                        if (o_DMXDevice.getDMXUniverse(intInternalSector) != this.m_DMXUniverseOutput) continue;
                        boolHasDMXUniverseInput = true;
                    }
                    if (!boolHasDMXUniverseInput) continue;
                }
                if (this.m_Limitation_DescriptionIDs.size() <= 0) {
                    for (int intDMXCOntrolComponent = 0; intDMXCOntrolComponent < o_DMXDevice.getDMXControlComponentCount(); ++intDMXCOntrolComponent) {
                        o_DMXControlComponent = o_DMXDevice.getDMXControlComponent(intDMXCOntrolComponent);
                        if (o_DMXControlComponent == null) continue;
                        for (int intControlType = 0; intControlType < o_DMXControlComponent.getControlTypeCount(); ++intControlType) {
                            o_ControlType = o_DMXControlComponent.getControlType(intControlType);
                            if (o_ControlType == null) continue;
                            for (int intControlDimensionType = 0; intControlDimensionType < o_ControlType.getControlDimensionTypeCount(); ++intControlDimensionType) {
                                o_ControlDimensionType = o_ControlType.getControlDimensionType(intControlDimensionType);
                                if (o_ControlDimensionType == null || (o_DeviceControlLink = o_ControlDimensionType.getDeviceControlLink(o_DMXDevice)) == null || this.m_OutputMode != 16 && o_DMXDevice.getDMXUniverse(o_DeviceControlLink.getDMXDeviceSectorIndex()) != this.m_DMXUniverseOutput) continue;
                                for (int intByte = 0; intByte < o_DeviceControlLink.getByteResolution(); ++intByte) {
                                    o_DeviceControlLink.getDeviceInternalChannel(intByte);
                                    if (o_DeviceControlLink == null || (o_InternalChannel = o_DMXDevice.getInternalChannel(0, o_DeviceControlLink.getDeviceInternalChannel(intByte))) == null || (o_DMXChannelOutput = o_InternalChannel.getDMXChannel()) == null) continue;
                                    intDMXAddressInput = this.m_OutputMode == 16 ? intPosition : o_DMXChannelOutput.getDMXAddress();
                                    o_InputPatch = DMXUniverseInputPatch.poolGetInputMatch();
                                    o_InputPatch.setDMXUniverseInputPatch(this);
                                    o_InputPatch.setDMXInputChannel(intDMXAddressInput);
                                    o_InputPatch.setDMXChannel_Output(o_DMXChannelOutput);
                                    o_InputPatch.setDMXDevice(o_DMXDevice);
                                    o_DMXDevice.addPropertyChangeListener("dmxdeviceDeviceName", this);
                                    if (intByte == 1) {
                                        o_InputPatch.setFunctionName(o_ControlDimensionType.getName() + " " + LiveShowDMXSystem.BYTE_1_LOWHBYTE);
                                    } else {
                                        o_InputPatch.setFunctionName(o_ControlDimensionType.getName());
                                    }
                                    this.m_InputMatchTableModel.addInputPatch(o_InputPatch);
                                    ++intPosition;
                                }
                            }
                        }
                    }
                    continue;
                }
                for (int intRestriction = 0; intRestriction < this.m_Limitation_DescriptionIDs.size(); ++intRestriction) {
                    o_DMXControlComponents = o_DMXDevice.getDMXControlComponentsByDescription(this.m_Limitation_DescriptionIDs.get(intRestriction), o_DMXControlComponents);
                    for (int intDMXControlComponent = 0; intDMXControlComponent < o_DMXControlComponents.size(); ++intDMXControlComponent) {
                        o_DMXControlComponent = o_DMXControlComponents.get(intDMXControlComponent);
                        if (o_DMXControlComponent == null) continue;
                        for (int intControlType = 0; intControlType < o_DMXControlComponent.getControlTypeCount(); ++intControlType) {
                            o_ControlType = o_DMXControlComponent.getControlType(intControlType);
                            if (o_ControlType == null) continue;
                            for (int intControlDimensionType = 0; intControlDimensionType < o_ControlType.getControlDimensionTypeCount(); ++intControlDimensionType) {
                                o_ControlDimensionType = o_ControlType.getControlDimensionType(intControlDimensionType);
                                if (o_ControlDimensionType == null || (o_DeviceControlLink = o_ControlDimensionType.getDeviceControlLink(o_DMXDevice)) == null || this.m_OutputMode != 16 && o_DMXDevice.getDMXUniverse(o_DeviceControlLink.getDMXDeviceSectorIndex()) != this.m_DMXUniverseOutput) continue;
                                for (int intByte = 0; intByte < o_DeviceControlLink.getByteResolution(); ++intByte) {
                                    o_DeviceControlLink.getDeviceInternalChannel(intByte);
                                    if (o_DeviceControlLink == null || (o_InternalChannel = o_DMXDevice.getInternalChannel(0, o_DeviceControlLink.getDeviceInternalChannel(intByte))) == null || (o_DMXChannelOutput = o_InternalChannel.getDMXChannel()) == null) continue;
                                    intDMXAddressInput = this.m_OutputMode == 16 ? intPosition : o_DMXChannelOutput.getDMXAddress();
                                    o_InputPatch = DMXUniverseInputPatch.poolGetInputMatch();
                                    o_InputPatch.setDMXUniverseInputPatch(this);
                                    o_InputPatch.setDMXInputChannel(intDMXAddressInput);
                                    o_InputPatch.setDMXChannel_Output(o_DMXChannelOutput);
                                    o_InputPatch.setDMXDevice(o_DMXDevice);
                                    o_DMXDevice.addPropertyChangeListener("dmxdeviceDeviceName", this);
                                    if (intByte == 1) {
                                        o_InputPatch.setFunctionName(o_ControlDimensionType.getName() + " " + LiveShowDMXSystem.BYTE_1_LOWHBYTE);
                                    } else {
                                        o_InputPatch.setFunctionName(o_ControlDimensionType.getName());
                                    }
                                    this.m_InputMatchTableModel.addInputPatch(o_InputPatch);
                                    ++intPosition;
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eventDMXInput(int[] p_ArrayValuesHardware) {
        DMXUniverse o_DMXUniverseInput;
        if (p_ArrayValuesHardware == null) {
            return;
        }
        boolean boolChangedRemote = false;
        boolean boolForceChangeValueToInut = false;
        boolean boolChangedInput = false;
        int intFirstChangedChannel = -1;
        Object object = this.m_SyncObject;
        synchronized (object) {
            o_DMXUniverseInput = this.m_DMXUniverseInput;
            this.m_TempDMXUniversesOutput.clear();
        }
        if (o_DMXUniverseInput == null) {
            return;
        }
        LiveShowDMXVIP o_LiveShowDMXVIP = LiveShowDMXSystem.getLiveShowDMXVIP();
        for (int intChannelInput = 0; intChannelInput < p_ArrayValuesHardware.length && intChannelInput < o_DMXUniverseInput.getDMXChannelCount(); ++intChannelInput) {
            DMXChannel o_DMXChannelOutput;
            int intValueInterfaceInput = p_ArrayValuesHardware[intChannelInput];
            int intValueInterfaceInputOld = this.m_ValuesHardware_InputOld[intChannelInput];
            this.m_ValuesHardware_InputOld[intChannelInput] = intValueInterfaceInput;
            if (this.m_InputMode == 0) {
                if (intValueInterfaceInput == intValueInterfaceInputOld) continue;
                boolChangedRemote = true;
                if (intFirstChangedChannel >= 0) continue;
                intFirstChangedChannel = intChannelInput;
                continue;
            }
            InputPatch o_InputPatch = this.m_InputMatchTableModel.getInputPatch_InputAddress(intChannelInput);
            if (o_InputPatch == null || (o_DMXChannelOutput = o_InputPatch.getDMXChannel_Output()) == null) continue;
            int intValueChannelOutputOriginal = o_DMXChannelOutput.getValueOriginal();
            if (o_LiveShowDMXVIP == null || o_LiveShowDMXVIP.getLiveShowSceneBridge_Actual() != null && o_LiveShowDMXVIP.isRunning() || intValueInterfaceInputOld < 0) continue;
            switch (this.m_InputMode) {
                case 2: {
                    this.m_ValuesHardware_Snapped[intChannelInput] = true;
                    boolForceChangeValueToInut = true;
                    break;
                }
                case 4: {
                    this.m_ValuesHardware_Snapped[intChannelInput] = intValueInterfaceInput != intValueInterfaceInputOld;
                    boolForceChangeValueToInut = false;
                    break;
                }
                case 8: {
                    if (intValueInterfaceInput != intValueInterfaceInputOld && !this.m_ValuesHardware_Snapped[intChannelInput]) {
                        if (intValueInterfaceInput > intValueInterfaceInputOld) {
                            if (intValueInterfaceInput >= intValueChannelOutputOriginal && Math.abs(intValueInterfaceInputOld - intValueChannelOutputOriginal) < 10) {
                                this.m_ValuesHardware_Snapped[intChannelInput] = true;
                            }
                        } else if (intValueInterfaceInput <= intValueChannelOutputOriginal && Math.abs(intValueInterfaceInputOld - intValueChannelOutputOriginal) < 10) {
                            this.m_ValuesHardware_Snapped[intChannelInput] = true;
                        }
                    }
                    boolForceChangeValueToInut = false;
                    break;
                }
                default: {
                    return;
                }
            }
            if (!this.m_ValuesHardware_Snapped[intChannelInput]) {
                o_DMXChannelOutput.setValueInterface_Input(intValueChannelOutputOriginal, false);
                continue;
            }
            if (!o_DMXChannelOutput.setValueInterface_Input(intValueInterfaceInput, boolForceChangeValueToInut)) continue;
            boolChangedInput = true;
            DMXUniverse o_DMXUniverse = o_DMXChannelOutput.getDMXUniverse();
            if (this.m_TempDMXUniversesOutput.contains(o_DMXUniverse)) continue;
            this.m_TempDMXUniversesOutput.add(o_DMXUniverse);
        }
        if (boolChangedRemote) {
            PlayRemoteActions.DMXEvent(o_DMXUniverseInput, intFirstChangedChannel, p_ArrayValuesHardware);
        }
        if (boolChangedInput) {
            for (int intDMXUniverse = 0; intDMXUniverse < this.m_TempDMXUniversesOutput.size(); ++intDMXUniverse) {
                DMXUniverse o_DMXUniverseOutput = this.m_TempDMXUniversesOutput.get(intDMXUniverse);
                o_DMXUniverseOutput.m_PropertyChangeSupport.firePropertyChange("valuesHardwareInterface_ReadenInput", null, null);
            }
            DMXScene.s_DMXSceneValueContainer_Mixer.writeDMXSceneLight();
        }
    }

    public void eventChannelWritten(DMXUniverse p_DMXUniverseOutput, DMXChannel p_DMXChannelOutput) {
        if (!this.m_InputConnected) {
            return;
        }
        if (p_DMXUniverseOutput == null) {
            return;
        }
        if (p_DMXChannelOutput == null) {
            return;
        }
        InputPatch o_InputPatch = this.m_InputMatchTableModel.getInputPatch_DMXChannel(p_DMXChannelOutput);
        if (o_InputPatch == null) {
            return;
        }
        Integer intAddressInput = o_InputPatch.getDMXInputChannel();
        if (intAddressInput < 0) {
            return;
        }
        if (p_DMXChannelOutput.getValueInterface_Input() != p_DMXChannelOutput.getValueOriginal()) {
            this.m_ValuesHardware_Snapped[intAddressInput.intValue()] = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        InputPatchTableModel o_InputPatchTableModel;
        Object object = this.m_SyncObject;
        synchronized (object) {
            o_InputPatchTableModel = this.getInputPatchTableModel();
            if (o_InputPatchTableModel == null) {
                return;
            }
        }
        if (evt.getSource() instanceof DMXDevice) {
            if ("dmxdeviceDeviceName".equals(evt.getPropertyName())) {
                DMXDevice o_DMXDevice = (DMXDevice)evt.getSource();
                for (int intInputPatch = 0; intInputPatch < o_InputPatchTableModel.size(); ++intInputPatch) {
                    InputPatch o_InputPatch = o_InputPatchTableModel.getInputPatch(intInputPatch);
                    if (o_InputPatch == null || o_InputPatch.getDMXDevice() != o_DMXDevice) continue;
                    o_InputPatchTableModel.changedInputPatch(o_InputPatch);
                }
            }
        } else if (evt.getSource() == PlayRemoteActions.class) {
            if ("propRemoteSource".equals(evt.getPropertyName())) {
                PlayRemoteActions.RemoteAction o_RemoteAction = (PlayRemoteActions.RemoteAction)evt.getNewValue();
                if (o_RemoteAction == null) {
                    return;
                }
                for (int intInputPatch = 0; intInputPatch < o_InputPatchTableModel.size(); ++intInputPatch) {
                    InputPatch o_InputPatch = o_InputPatchTableModel.getInputPatch(intInputPatch);
                    if (o_InputPatch == null || o_InputPatch.getRemoteAction() != o_RemoteAction) continue;
                    o_InputPatchTableModel.changedInputPatch(o_InputPatch);
                }
            } else if ("propDmxEvent".equals(evt.getPropertyName()) && this.getInputMode() == 0) {
                this.calculateChannelPatch();
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
        if (p_PropertyChangeListener == null) {
            return;
        }
        this.m_SinglePropertyChangeSupport.addPropertyChangeListener(p_PropertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
        if (p_PropertyChangeListener == null) {
            return;
        }
        this.m_SinglePropertyChangeSupport.removePropertyChangeListener(p_PropertyChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputPatch poolGetInputMatch() {
        Object object = s_SyncInputPatchPool;
        synchronized (object) {
            InputPatch o_InputPatch;
            if (s_InputPatchPool.size() > 0) {
                o_InputPatch = s_InputPatchPool.get(s_InputPatchPool.size() - 1);
                s_InputPatchPool.remove(s_InputPatchPool.size() - 1);
            } else {
                o_InputPatch = new InputPatch();
            }
            o_InputPatch.clear();
            return o_InputPatch;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void poolAddInputMatch(InputPatch p_InputPatch) {
        if (p_InputPatch == null) {
            return;
        }
        Object object = s_SyncInputPatchPool;
        synchronized (object) {
            if (s_InputPatchPool.contains(p_InputPatch)) {
                return;
            }
            p_InputPatch.clear();
            s_InputPatchPool.add(p_InputPatch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void poolAddInputMatch(ArrayList<InputPatch> p_InputPatches) {
        if (p_InputPatches == null) {
            return;
        }
        Object object = s_SyncInputPatchPool;
        synchronized (object) {
            for (int intInputPatch = 0; intInputPatch < p_InputPatches.size(); ++intInputPatch) {
                InputPatch o_InputPatch = p_InputPatches.get(intInputPatch);
                if (o_InputPatch == null) continue;
                o_InputPatch.clear();
            }
            s_InputPatchPool.addAll(p_InputPatches);
        }
    }

    public InputPatchTableModel getInputPatchTableModel() {
        return this.m_InputMatchTableModel;
    }

    static {
        s_DMXControlDescriptionList.addDMXControlDescription(DMXControlDescription.getDMXControlDescription("dimmer"));
        s_DMXControlDescriptionList.addDMXControlDescription(DMXControlDescription.getDMXControlDescription("rgbcmy"));
        s_DMXControlDescriptionList.addDMXControlDescription(DMXControlDescription.getDMXControlDescription("colorwhite"));
        s_DMXControlDescriptionList.addDMXControlDescription(DMXControlDescription.getDMXControlDescription("colorwhitecold"));
        s_DMXControlDescriptionList.addDMXControlDescription(DMXControlDescription.getDMXControlDescription("colorwhitewarm"));
        s_DMXControlDescriptionList.addDMXControlDescription(DMXControlDescription.getDMXControlDescription("coloramber"));
        s_DMXControlDescriptionList.addDMXControlDescription(DMXControlDescription.getDMXControlDescription("coloruv"));
        s_DMXControlDescriptionList.addDMXControlDescription(DMXControlDescription.getDMXControlDescription("colorlime"));
        s_DMXControlDescriptionList.addDMXControlDescription(DMXControlDescription.getDMXControlDescription("colorlightblue"));
        s_DMXControlDescriptionList.addDMXControlDescription(DMXControlDescription.getDMXControlDescription("colorpink"));
        s_DMXControlDescriptionList.addDMXControlDescription(DMXControlDescription.getDMXControlDescription("colorpurple"));
        s_DMXControlDescriptionList.addDMXControlDescription(DMXControlDescription.getDMXControlDescription("colorcyan"));
        s_DMXControlDescriptionList.addDMXControlDescription(DMXControlDescription.getDMXControlDescription("colormagenta"));
        s_DMXControlDescriptionList.addDMXControlDescription(DMXControlDescription.getDMXControlDescription("coloryellow"));
        s_DMXControlDescriptionList.addDMXControlDescription(DMXControlDescription.getDMXControlDescription("colortemperature"));
        s_DMXControlDescriptionList.addDMXControlDescription(DMXControlDescription.getDMXControlDescription("color1"));
        s_DMXControlDescriptionList.addDMXControlDescription(DMXControlDescription.getDMXControlDescription("color2"));
        s_DMXControlDescriptionList.addDMXControlDescription(DMXControlDescription.getDMXControlDescription("gobo1"));
        s_DMXControlDescriptionList.addDMXControlDescription(DMXControlDescription.getDMXControlDescription("gobo2"));
        s_DMXControlDescriptionList.addDMXControlDescription(DMXControlDescription.getDMXControlDescription("pantilt"));
        s_DMXControlDescriptionList.addDMXControlDescription(DMXControlDescription.getDMXControlDescription("iris"));
        s_DMXControlDescriptionList.addDMXControlDescription(DMXControlDescription.getDMXControlDescription("zoom"));
        s_DMXControlDescriptionList.addDMXControlDescription(DMXControlDescription.getDMXControlDescription("focus"));
        s_DMXControlDescriptionList.addDMXControlDescription(DMXControlDescription.getDMXControlDescription("duration"));
        s_DMXControlDescriptionList.addDMXControlDescription(DMXControlDescription.getDMXControlDescription("intensity"));
        s_DMXControlDescriptionList.addDMXControlDescription(DMXControlDescription.getDMXControlDescription("deflection"));
        s_InputPatchPool = new ArrayList();
        s_SyncInputPatchPool = new Object();
        s_EmptyInputPatchTableModel = new InputPatchTableModel();
    }

    public static class InputPatchTableModel
    extends TableAndListModel<InputPatch> {
        public static final int COLUMNCOUNT = 3;
        public static final int COLUMNINDEX_DMXINPUTCHANNEL = 0;
        public static final int COLUMNINDEX_NAME = 1;
        public static final int COLUMNINDEX_FUNCTIONNAME = 2;
        @LiveLanguageString
        public static String COLUMN_DMXINPUTCHANNEL = "DMX";
        @LiveLanguageString
        public static String COLUMN_NAME = "Name";
        @LiveLanguageString
        public static String COLUMN_FUNCTIONNAME = "Function";
        private DefaultTableCellRenderer m_DefaultTableCellRenderer = new DefaultTableCellRenderer();
        private HashMap<Integer, InputPatch> m_Patch_InputAddress_DMXChannel;
        private HashMap<DMXChannel, InputPatch> m_Patch_DMXChannel_InputAddress;
        private final Object m_SyncObject = new Object();

        public InputPatchTableModel() {
            super(false);
            this.initMembers();
            LiveLanguage.addLanguageListener((Object)this, null);
        }

        private void initMembers() {
            this.m_DefaultTableCellRenderer = new DefaultTableCellRenderer();
            this.m_DefaultTableCellRenderer.setBackground(Color.BLACK);
            this.m_DefaultTableCellRenderer.setForeground(Color.WHITE);
            this.m_Patch_DMXChannel_InputAddress = new HashMap();
            this.m_Patch_InputAddress_DMXChannel = new HashMap();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addInputPatch(InputPatch p_InputPatch) {
            if (p_InputPatch == null) {
                return;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (!this.add(p_InputPatch)) {
                    return;
                }
                if (p_InputPatch.getDMXChannel_Output() != null) {
                    this.m_Patch_DMXChannel_InputAddress.put(p_InputPatch.getDMXChannel_Output(), p_InputPatch);
                    this.m_Patch_InputAddress_DMXChannel.put(p_InputPatch.getDMXInputChannel(), p_InputPatch);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeInputPatch(InputPatch p_InputPatch) {
            if (p_InputPatch == null) {
                return;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (!this.remove(p_InputPatch)) {
                    return;
                }
                if (p_InputPatch.getDMXChannel_Output() != null) {
                    this.m_Patch_DMXChannel_InputAddress.remove(p_InputPatch.getDMXChannel_Output());
                    this.m_Patch_InputAddress_DMXChannel.remove(p_InputPatch.getDMXInputChannel());
                }
                DMXUniverseInputPatch.poolAddInputMatch(p_InputPatch);
                p_InputPatch.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clearInputPatches() {
            Object object = this.m_SyncObject;
            synchronized (object) {
                int intRowCount = this.size();
                if (intRowCount <= 0) {
                    return;
                }
                DMXUniverseInputPatch.poolAddInputMatch(this.getElementArrayList());
                this.clear();
                this.m_Patch_DMXChannel_InputAddress.clear();
                this.m_Patch_InputAddress_DMXChannel.clear();
            }
        }

        public InputPatch getInputPatch_InputAddress(Integer p_InputAddress) {
            if (p_InputAddress == null) {
                return null;
            }
            return this.m_Patch_InputAddress_DMXChannel.get(p_InputAddress);
        }

        public InputPatch getInputPatch_DMXChannel(DMXChannel p_DMXChannel) {
            if (p_DMXChannel == null) {
                return null;
            }
            return this.m_Patch_DMXChannel_InputAddress.get(p_DMXChannel);
        }

        public InputPatch getInputPatch(int p_Index) {
            if (p_Index < 0) {
                return null;
            }
            return (InputPatch)this.get(p_Index);
        }

        public void changedInputPatch(InputPatch p_InputPatch) {
            if (p_InputPatch == null) {
                return;
            }
            this.changedElement(p_InputPatch);
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getValue(InputPatch p_InputPatch, int p_ColumnIndex) {
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (p_InputPatch == null) {
                    return "";
                }
            }
            switch (p_ColumnIndex) {
                case 0: {
                    if (p_InputPatch.getDMXInputChannel() < 0) {
                        return "";
                    }
                    int intChannel = p_InputPatch.getDMXInputChannel() + 1;
                    return String.valueOf(String.valueOf(intChannel));
                }
                case 1: {
                    return p_InputPatch.getName();
                }
                case 2: {
                    return p_InputPatch.getFunctionName();
                }
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return COLUMN_DMXINPUTCHANNEL;
                }
                case 1: {
                    return COLUMN_NAME;
                }
                case 2: {
                    return COLUMN_FUNCTIONNAME;
                }
            }
            return "";
        }

        @Override
        public void setValue(InputPatch p_InputPatch, Object value, int p_ColumnIndex) {
            if (p_InputPatch == null) {
                return;
            }
        }

        public DefaultTableCellRenderer getDefaultTableCellRenderer(int p_Column) {
            return this.m_DefaultTableCellRenderer;
        }
    }

    public static class InputPatch {
        private DMXUniverseInputPatch m_DMXUniverseInputPatch;
        private int m_DMXInputChannel;
        private DMXChannel m_DMXChannel;
        private DMXDevice m_DMXDevice;
        private PlayRemoteActions.RemoteAction m_RemoteAction;
        private String m_FunctionName;
        private final Object m_SyncObject = new Object();

        public InputPatch() {
            this.initMembers();
        }

        private void initMembers() {
            this.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            Object object = this.m_SyncObject;
            synchronized (object) {
                this.m_DMXInputChannel = -1;
                this.m_DMXChannel = null;
                if (this.m_DMXDevice != null) {
                    // empty if block
                }
                this.m_DMXDevice = null;
                if (this.m_RemoteAction != null) {
                    // empty if block
                }
                this.m_RemoteAction = null;
                this.m_DMXUniverseInputPatch = null;
                this.m_FunctionName = "";
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setDMXUniverseInputPatch(DMXUniverseInputPatch p_DMXUniverseInputPatch) {
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (p_DMXUniverseInputPatch == this.m_DMXUniverseInputPatch) {
                    return;
                }
                this.m_DMXUniverseInputPatch = p_DMXUniverseInputPatch;
            }
        }

        public int getDMXInputChannel() {
            return this.m_DMXInputChannel;
        }

        public void setDMXInputChannel(int p_Channel) {
            this.m_DMXInputChannel = p_Channel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setDMXChannel_Output(DMXChannel p_DMXChannel) {
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (p_DMXChannel == this.m_DMXChannel) {
                    return;
                }
                this.m_DMXChannel = p_DMXChannel;
            }
        }

        public DMXChannel getDMXChannel_Output() {
            return this.m_DMXChannel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setDMXDevice(DMXDevice p_DMXDevice) {
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (p_DMXDevice == this.m_DMXDevice) {
                    return;
                }
                if (this.m_DMXDevice != null) {
                    // empty if block
                }
                this.m_DMXDevice = p_DMXDevice;
                if (this.m_DMXDevice != null) {
                    // empty if block
                }
            }
        }

        public DMXDevice getDMXDevice() {
            return this.m_DMXDevice;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setRemoteAction(PlayRemoteActions.RemoteAction p_RemoteAction) {
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (p_RemoteAction == this.m_RemoteAction) {
                    return;
                }
                this.m_RemoteAction = p_RemoteAction;
                if (this.m_RemoteAction != null) {
                    this.m_FunctionName = p_RemoteAction.getActionName();
                }
            }
        }

        public PlayRemoteActions.RemoteAction getRemoteAction() {
            return this.m_RemoteAction;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getName() {
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (this.m_DMXDevice != null) {
                    return this.m_DMXDevice.getName();
                }
                if (this.m_RemoteAction != null) {
                    return this.m_RemoteAction.getSourceName();
                }
            }
            return "";
        }

        public String getFunctionName() {
            return this.m_FunctionName;
        }

        public void setFunctionName(String p_FunctionName) {
            if (p_FunctionName == null) {
                p_FunctionName = "";
            }
            this.m_FunctionName = p_FunctionName;
        }
    }
}

