/*
 * Decompiled with CFR 0.152.
 */
package DMX512;

import DMX512.DMXChannel;
import DMX512.DMXUniverseInputPatch;
import DMXDevicePackage.DMXDevice;
import DMXDevicePackage.DMXDeviceFilter;
import DMXDevicePackage.DMXDeviceType;
import DMXGraphics.LiveShowDMXStageView;
import DMXHardwarePackage.DMXHardware;
import DMXHardwarePackage.DMXHardwareInterface;
import DMXHardwarePackage.DMXHardwarePluginFeedbackInterface;
import DMXHardwarePackage.DMXHardwarePluginInterface;
import DMXScenePackage.DMXScene;
import GUID.LiveGUID;
import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LanguageTools.LiveLanguagePackage.LiveLanguageString;
import LiveShowObjectPackage.LiveShowProjectDescription;
import LiveShowObjectPackage.SinglePropertyChangeSupport;
import LiveShowPlayPackage.PlayRemoteActions;
import LiveShowVirtualPackage.LiveShow_ImportDescription;
import StartPackage.LiveShowDMXSystem;
import SwingModelPackage.TableAndListModel;
import SynchronizationPackage.EventQueueHandler;
import Text.NameExtension;
import ToolsGraphics.JLabelBackground;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Externalizable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JList;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

public class DMXUniverse
implements PropertyChangeListener,
Externalizable,
DMXDeviceFilter.FilterInterface,
DMXHardwarePluginFeedbackInterface,
PlayRemoteActions.RemoteActionTrigger {
    public static final int SOFTWAREVERSION = 2;
    public static final String FILESUFFIX = ".lsu";
    public static final String PROP_UNIVERSENAME = "universeName";
    public static final String PROP_UNIVERSEADDED = "universeAdded";
    public static final String PROP_UNIVERSEREMOVED = "universeRemoved";
    public static final String PROP_UNIVERSEREMARK = "universeRemark";
    public static final String PROP_UNIVERSECONNECTIONSTATUS_OUPUT = "universeConnectionStatus_Output";
    public static final String PROP_UNIVERSECONNECTIONSTATUS_INPUT = "universeConnectionStatus_Input";
    public static final String PROP_HARDWAREPLUGGEDIN = "universeHardwarePluggedIn";
    public static final String PROP_VALUESHARDWAREINTERFACE_WRITTEN = "valuesHardwareInterface_Written";
    public static final String PROP_VALUESHARDWAREINTERFACE_READEN = "valuesHardwareInterface_Readen";
    public static final String PROP_VALUESHARDWAREINTERFACE_READENINPUT = "valuesHardwareInterface_ReadenInput";
    public static Icon s_Icon = new ImageIcon(DMXUniverse.class.getResource("/IconsPackage/DMX_XLRPlug.png"));
    public static File s_FileLastDMXUniverse;
    private DMXUniverseIO m_DMXUniverseIO;
    private Thread m_DMXUniverseIOThread;
    private DMXUniverseInputPatch m_DMXUniverseInputPatch;
    private ArrayList<DMXUniverseInputPatch> m_DMXUniverseInputPatch_Outputs;
    private final Object m_SyncDMXUniverseInputPatch = new Object();
    @LiveLanguageString
    public static String DEFAULT_UNIVERSENAME;
    @LiveLanguageString
    public static String DEFAULT_UNIVERSEDESCRIPTION;
    public static boolean s_LanguageLoaded;
    public static final TableAndListModel.ListModel<DMXUniverse> s_DMXUniverseListModel;
    protected static DMXUniverseCellRenderer s_DMXUniverseCellRenderer;
    protected String m_ID;
    private String m_Name;
    private String m_Remark;
    private StringBuilder m_StringBuilder;
    private final Object m_SyncStringBuilder;
    protected SinglePropertyChangeSupport m_PropertyChangeSupport;
    private DMXHardwarePluginInterface m_DMXHdwPluginInterface_Output;
    private int m_ConnectionStatus_Output;
    private DMXHardwarePluginInterface m_DMXHdwPluginInterface_Input;
    private int m_ConnectionStatus_Input;
    private ArrayList<DMXDevice.InternalSector> m_DMXDeviceInternalSectors;
    private ArrayList<DMXDevice> m_DMXDevices;
    private ArrayList<DMXChannel> m_DMXChannelsUsed;
    private ArrayList<DMXChannel> m_DMXChannels;
    private int[] m_NewValues;
    private final Object m_SyncChannelUsed;
    private final Object m_SyncHardwarePlugin;
    private boolean m_DebugOn;
    private boolean[] m_FreeAddresses;
    boolean m_Closed;
    public static ArrayList<LiveShowDMXStageView.LiveShowDMXStageViewListener> s_DMXStageViewListeners;
    public static final Object s_SyncStageViewListener;
    public static boolean s_DMXUniversesAreLoading;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addStageViewListener(LiveShowDMXStageView.LiveShowDMXStageViewListener p_LiveShowDMXStageViewListener) {
        if (p_LiveShowDMXStageViewListener == null) {
            return;
        }
        Object object = s_SyncStageViewListener;
        synchronized (object) {
            if (s_DMXStageViewListeners.contains(p_LiveShowDMXStageViewListener)) {
                return;
            }
            s_DMXStageViewListeners.add(p_LiveShowDMXStageViewListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeStageViewListener(LiveShowDMXStageView.LiveShowDMXStageViewListener p_LiveShowDMXStageViewListener) {
        if (p_LiveShowDMXStageViewListener == null) {
            return;
        }
        Object object = s_SyncStageViewListener;
        synchronized (object) {
            s_DMXStageViewListeners.remove(p_LiveShowDMXStageViewListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fireDMXStageView_UniverseAdded(DMXUniverse p_DMXUniverse) {
        ArrayList<LiveShowDMXStageView.LiveShowDMXStageViewListener> o_DMXStageViewListeners;
        Object object = s_SyncStageViewListener;
        synchronized (object) {
            o_DMXStageViewListeners = new ArrayList<LiveShowDMXStageView.LiveShowDMXStageViewListener>(s_DMXStageViewListeners.size());
            o_DMXStageViewListeners.addAll(s_DMXStageViewListeners);
        }
        for (int intListener = 0; intListener < o_DMXStageViewListeners.size(); ++intListener) {
            LiveShowDMXStageView.LiveShowDMXStageViewListener o_DMXStageViewListener = (LiveShowDMXStageView.LiveShowDMXStageViewListener)o_DMXStageViewListeners.get(intListener);
            o_DMXStageViewListener.eventDMXUniverseAdded(p_DMXUniverse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fireDMXStageView_UniverseRemoved(DMXUniverse p_DMXUniverse) {
        ArrayList<LiveShowDMXStageView.LiveShowDMXStageViewListener> o_DMXStageViewListeners;
        Object object = s_SyncStageViewListener;
        synchronized (object) {
            o_DMXStageViewListeners = new ArrayList<LiveShowDMXStageView.LiveShowDMXStageViewListener>(s_DMXStageViewListeners.size());
            o_DMXStageViewListeners.addAll(s_DMXStageViewListeners);
        }
        for (int intListener = 0; intListener < o_DMXStageViewListeners.size(); ++intListener) {
            LiveShowDMXStageView.LiveShowDMXStageViewListener o_DMXStageViewListener = (LiveShowDMXStageView.LiveShowDMXStageViewListener)o_DMXStageViewListeners.get(intListener);
            o_DMXStageViewListener.eventDMXUniverseRemoved(p_DMXUniverse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fireDMXStageView_UniverseChanged(DMXUniverse p_DMXUniverse) {
        ArrayList<LiveShowDMXStageView.LiveShowDMXStageViewListener> o_DMXStageViewListeners;
        Object object = s_SyncStageViewListener;
        synchronized (object) {
            o_DMXStageViewListeners = new ArrayList<LiveShowDMXStageView.LiveShowDMXStageViewListener>(s_DMXStageViewListeners.size());
            o_DMXStageViewListeners.addAll(s_DMXStageViewListeners);
        }
        for (int intListener = 0; intListener < o_DMXStageViewListeners.size(); ++intListener) {
            LiveShowDMXStageView.LiveShowDMXStageViewListener o_DMXStageViewListener = (LiveShowDMXStageView.LiveShowDMXStageViewListener)o_DMXStageViewListeners.get(intListener);
            o_DMXStageViewListener.eventDMXUniverseChanged(p_DMXUniverse);
        }
    }

    public DMXUniverse() {
        s_DMXUniverseListModel.add(null);
        this.m_SyncStringBuilder = new Object();
        this.m_SyncChannelUsed = new Object();
        this.m_SyncHardwarePlugin = new Object();
        this.initMembers();
        this.m_Name = this.createName(null);
        DMXDeviceFilter.createDMXDeviceFilter(this);
    }

    public DMXUniverse(String p_UniverseName) {
        s_DMXUniverseListModel.add(null);
        this.m_SyncStringBuilder = new Object();
        this.m_SyncChannelUsed = new Object();
        this.m_SyncHardwarePlugin = new Object();
        this.initMembers();
        this.m_Name = this.createName(p_UniverseName);
        this.readResolve();
        DMXUniverse.addDMXUniverse(this);
        DMXDeviceFilter.createDMXDeviceFilter(this);
    }

    private void initMembers() {
        this.m_ID = LiveGUID.getUID();
        this.m_PropertyChangeSupport = new SinglePropertyChangeSupport(this);
        this.m_DMXHdwPluginInterface_Output = null;
        this.m_DMXHdwPluginInterface_Input = null;
        this.m_DMXUniverseInputPatch_Outputs = new ArrayList();
        this.m_DebugOn = false;
        LiveLanguage.addLanguageListener((Object)this, null);
        this.m_Remark = DEFAULT_UNIVERSEDESCRIPTION;
        this.m_StringBuilder = new StringBuilder();
        this.m_FreeAddresses = new boolean[512];
        this.m_Closed = false;
        this.m_NewValues = new int[512];
        for (int intChannel = 0; intChannel < 512; ++intChannel) {
            this.m_NewValues[intChannel] = 0;
        }
        this.m_DMXChannels = new ArrayList();
        this.m_DMXChannelsUsed = new ArrayList();
        this.m_DMXDeviceInternalSectors = new ArrayList();
        this.m_DMXDevices = new ArrayList();
        this.m_ConnectionStatus_Output = 0;
        this.m_ConnectionStatus_Input = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object readResolve() {
        DMXHardwarePluginInterface o_DMXHardwarePluginInterface;
        for (int intChannel = 0; intChannel < 512; ++intChannel) {
            DMXChannel o_DMXChannel = new DMXChannel(this, intChannel);
            this.m_DMXChannels.add(o_DMXChannel);
        }
        this.m_DMXUniverseInputPatch = new DMXUniverseInputPatch(this);
        this.m_DMXUniverseInputPatch.setDMXUniverseOutput(this);
        this.setConnectionStatus_Output(0, "DMXUniverse readResolve()");
        this.setConnectionStatus_Input(0, "DMXUniverse readResolve()");
        this.m_DMXUniverseIO = new DMXUniverseIO(this);
        Object object = this.m_SyncHardwarePlugin;
        synchronized (object) {
            o_DMXHardwarePluginInterface = this.m_DMXHdwPluginInterface_Output;
        }
        if (o_DMXHardwarePluginInterface != null) {
            if (o_DMXHardwarePluginInterface.getDMXPluggedInUniverse() == null) {
                o_DMXHardwarePluginInterface.requestDMXPlugConnection((DMXHardwarePluginFeedbackInterface)this);
            } else {
                o_DMXHardwarePluginInterface = null;
            }
        }
        object = this.m_SyncHardwarePlugin;
        synchronized (object) {
            this.m_DMXHdwPluginInterface_Output = o_DMXHardwarePluginInterface;
        }
        object = this.m_SyncHardwarePlugin;
        synchronized (object) {
            o_DMXHardwarePluginInterface = this.m_DMXHdwPluginInterface_Input;
        }
        if (o_DMXHardwarePluginInterface != null) {
            if (o_DMXHardwarePluginInterface.getDMXPluggedInUniverse() == null) {
                o_DMXHardwarePluginInterface.requestDMXPlugConnection((DMXHardwarePluginFeedbackInterface)this);
            } else {
                o_DMXHardwarePluginInterface = null;
            }
        }
        object = this.m_SyncHardwarePlugin;
        synchronized (object) {
            this.m_DMXHdwPluginInterface_Input = o_DMXHardwarePluginInterface;
        }
        PlayRemoteActions.addRemoteActionTrigger_DMX(this);
        this.m_DMXUniverseIOThread = new Thread((Runnable)this.m_DMXUniverseIO, "Thread_DMXUniverseIO");
        try {
            this.m_DMXUniverseIOThread.setPriority(7);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_DMXUniverseIOThread.start();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(2);
        out.writeUTF(this.m_ID);
        out.writeUTF(this.m_Name);
        out.writeUTF(this.m_Remark);
        Object object = this.m_SyncHardwarePlugin;
        synchronized (object) {
            if (this.m_DMXHdwPluginInterface_Output != null && this.m_DMXHdwPluginInterface_Output.getDMXHardwareInterface() != null) {
                out.writeUTF(this.m_DMXHdwPluginInterface_Output.getDMXHardwareInterface().getID());
                out.writeInt(this.m_DMXHdwPluginInterface_Output.getPluginIndex());
            } else {
                out.writeUTF("unknown");
                out.writeInt(0);
            }
            if (this.m_DMXHdwPluginInterface_Input != null && this.m_DMXHdwPluginInterface_Input.getDMXHardwareInterface() != null) {
                out.writeUTF(this.m_DMXHdwPluginInterface_Input.getDMXHardwareInterface().getID());
                out.writeInt(this.m_DMXHdwPluginInterface_Input.getPluginIndex());
            } else {
                out.writeUTF("unknown");
                out.writeInt(0);
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int intSoftwareVersion = in.readInt();
        this.m_ID = in.readUTF();
        this.m_Name = in.readUTF();
        this.m_Remark = in.readUTF();
        String stringHardwareID_Input = null;
        int intHardwarePluginIndex_Input = -1;
        String stringHardwareID_Output = in.readUTF();
        int intHardwarePluginIndex_Output = in.readInt();
        if (intSoftwareVersion > 1) {
            stringHardwareID_Input = in.readUTF();
            intHardwarePluginIndex_Input = in.readInt();
        }
        if (DMXUniverse.getDMXUniverse(this.m_ID) != null) {
            return;
        }
        DMXHardwareInterface o_DMXHardwareInterface = DMXHardware.getTreeModel().getDMXHardwareInterface(stringHardwareID_Output);
        if (o_DMXHardwareInterface != null) {
            this.m_DMXHdwPluginInterface_Output = o_DMXHardwareInterface.getDMXHardwarePlugin_Output(intHardwarePluginIndex_Output);
            if (this.m_DMXHdwPluginInterface_Output == null || this.m_DMXHdwPluginInterface_Output.getDMXPluginType() != 0) {
                this.m_DMXHdwPluginInterface_Output = null;
            }
        } else {
            this.m_DMXHdwPluginInterface_Output = null;
        }
        if ((o_DMXHardwareInterface = DMXHardware.getTreeModel().getDMXHardwareInterface(stringHardwareID_Input)) != null) {
            this.m_DMXHdwPluginInterface_Input = o_DMXHardwareInterface.getDMXHardwarePlugin_Input(intHardwarePluginIndex_Input);
            if (this.m_DMXHdwPluginInterface_Input == null || this.m_DMXHdwPluginInterface_Input.getDMXPluginType() != 1) {
                this.m_DMXHdwPluginInterface_Input = null;
            }
        } else {
            this.m_DMXHdwPluginInterface_Input = null;
        }
        this.readResolve();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDiskSpaceEstimated() {
        DMXHardwarePluginInterface o_DMXHardwarePluginInterface;
        long longBytesCount = 0L;
        longBytesCount += 4L;
        longBytesCount += (long)(this.m_ID.length() * 2);
        longBytesCount += (long)(this.m_Name.length() * 2);
        longBytesCount += (long)(this.m_Remark.length() * 2);
        Object object = this.m_SyncHardwarePlugin;
        synchronized (object) {
            o_DMXHardwarePluginInterface = this.m_DMXHdwPluginInterface_Output;
        }
        if (o_DMXHardwarePluginInterface != null) {
            longBytesCount += (long)(o_DMXHardwarePluginInterface.getDMXHardwareInterface().getID().length() * 2);
            longBytesCount += 4L;
        } else {
            longBytesCount += (long)("unknown".length() * 2);
            longBytesCount += 4L;
        }
        object = this.m_SyncHardwarePlugin;
        synchronized (object) {
            o_DMXHardwarePluginInterface = this.m_DMXHdwPluginInterface_Input;
        }
        if (o_DMXHardwarePluginInterface != null) {
            longBytesCount += (long)(o_DMXHardwarePluginInterface.getDMXHardwareInterface().getID().length() * 2);
            longBytesCount += 4L;
        } else {
            longBytesCount += (long)("unknown".length() * 2);
            longBytesCount += 4L;
        }
        return longBytesCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        DMXHardwarePluginInterface o_DMXHardwarePluginInterface;
        DMXDeviceFilter.removeDMXDeviceFilter(this);
        this.m_DMXUniverseInputPatch.close();
        PlayRemoteActions.removeRemoteActionTrigger_DMX(this);
        this.m_Closed = true;
        LiveLanguage.removeLanguageListener((Object)this);
        if (this.m_DMXUniverseIO != null) {
            this.m_DMXUniverseIO.close();
        }
        if (this.m_PropertyChangeSupport != null) {
            this.m_PropertyChangeSupport.clear();
        }
        Object object = this.m_SyncHardwarePlugin;
        synchronized (object) {
            o_DMXHardwarePluginInterface = this.m_DMXHdwPluginInterface_Output;
        }
        if (o_DMXHardwarePluginInterface != null) {
            o_DMXHardwarePluginInterface.requestDMXPlugConnection(null);
        }
        object = this.m_SyncHardwarePlugin;
        synchronized (object) {
            this.m_DMXHdwPluginInterface_Output = null;
        }
        object = this.m_SyncHardwarePlugin;
        synchronized (object) {
            o_DMXHardwarePluginInterface = this.m_DMXHdwPluginInterface_Input;
        }
        if (o_DMXHardwarePluginInterface != null) {
            o_DMXHardwarePluginInterface.requestDMXPlugConnection(null);
        }
        object = this.m_SyncHardwarePlugin;
        synchronized (object) {
            this.m_DMXHdwPluginInterface_Input = null;
        }
        if (this.m_DMXDeviceInternalSectors != null) {
            for (int intDeviceSector = this.m_DMXDeviceInternalSectors.size() - 1; intDeviceSector >= 0; --intDeviceSector) {
                DMXDevice.InternalSector o_DMXDeviceInternalSector = this.m_DMXDeviceInternalSectors.get(intDeviceSector);
                if (o_DMXDeviceInternalSector == null) continue;
                o_DMXDeviceInternalSector.setDMXAddress(null, 0);
            }
            this.m_DMXDeviceInternalSectors.clear();
        }
        this.m_DMXDevices.clear();
        if (this.m_DMXChannels != null) {
            int intDMXChannelCount = this.m_DMXChannels.size();
            for (int intChannel = intDMXChannelCount - 1; intChannel >= 0; --intChannel) {
                DMXChannel o_DMXChannel = this.m_DMXChannels.get(intChannel);
                this.m_DMXChannels.remove(intChannel);
                if (o_DMXChannel == null) continue;
                o_DMXChannel.removePropertyChangeListener(this);
                o_DMXChannel.close();
            }
        }
        LiveLanguage.removeLanguageListener((Object)this);
    }

    public void finalize() throws Throwable {
        super.finalize();
        this.m_PropertyChangeSupport = null;
    }

    public boolean getClosed() {
        return this.m_Closed;
    }

    public void setDebugOn(boolean p_DebugOn) {
        this.m_DebugOn = p_DebugOn;
    }

    public void addPropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
        this.m_PropertyChangeSupport.addPropertyChangeListener(p_PropertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
        this.m_PropertyChangeSupport.removePropertyChangeListener(p_PropertyChangeListener);
    }

    public void addPropertyChangeListener(String p_PropertyName, PropertyChangeListener p_PropertyChangeListener) {
        this.m_PropertyChangeSupport.addPropertyChangeListener(p_PropertyName, p_PropertyChangeListener);
    }

    public void removePropertyChangeListener(String p_PropertyName, PropertyChangeListener p_PropertyChangeListener) {
        this.m_PropertyChangeSupport.removePropertyChangeListener(p_PropertyName, p_PropertyChangeListener);
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.m_PropertyChangeSupport.getPropertyChangeListeners();
    }

    public PropertyChangeListener[] getPropertyChangeListeners(String p_PropertyName) {
        return this.m_PropertyChangeSupport.getPropertyChangeListeners(p_PropertyName);
    }

    public boolean hasListeners(String p_PropertyName) {
        return this.m_PropertyChangeSupport.hasListeners(p_PropertyName);
    }

    @Override
    public String getID() {
        return this.m_ID;
    }

    private String createName(String p_Name) {
        int intPrefixCount = 0;
        int intMaxPostfix = 0;
        String stringPrefix = p_Name != null && p_Name.length() > 0 ? NameExtension.getPrefix(p_Name) : DEFAULT_UNIVERSENAME;
        for (int intUniverse = 0; intUniverse < DMXUniverse.getDMXUniverseCount(); ++intUniverse) {
            int intPostfix;
            DMXUniverse o_DMXUniverse = DMXUniverse.getDMXUniverse(intUniverse);
            if (o_DMXUniverse == null || (intPostfix = NameExtension.getPostfix_Int(o_DMXUniverse.getName(), stringPrefix)) == -2) continue;
            if (intPostfix == -1) {
                intPostfix = ++intPrefixCount;
            }
            if (intPostfix <= intMaxPostfix) continue;
            intMaxPostfix = intPostfix;
        }
        return NameExtension.createName(stringPrefix, ++intMaxPostfix, "000", true);
    }

    @Override
    public String getName() {
        return this.m_Name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(String p_Name) {
        DMXHardwarePluginInterface o_DMXHardwarePluginInterface;
        if (p_Name == null) {
            return;
        }
        String oldValue = this.m_Name;
        this.m_Name = p_Name;
        this.m_PropertyChangeSupport.firePropertyChange(PROP_UNIVERSENAME, oldValue, this.m_Name);
        Object object = this.m_SyncHardwarePlugin;
        synchronized (object) {
            o_DMXHardwarePluginInterface = this.m_DMXHdwPluginInterface_Output;
        }
        if (o_DMXHardwarePluginInterface != null) {
            o_DMXHardwarePluginInterface.propertyChanged((DMXHardwarePluginFeedbackInterface)this);
        }
        object = this.m_SyncHardwarePlugin;
        synchronized (object) {
            o_DMXHardwarePluginInterface = this.m_DMXHdwPluginInterface_Input;
        }
        if (o_DMXHardwarePluginInterface != null) {
            o_DMXHardwarePluginInterface.propertyChanged((DMXHardwarePluginFeedbackInterface)this);
        }
        PlayRemoteActions.DMXChanged(this);
        DMXUniverse.fireDMXStageView_UniverseChanged(this);
    }

    @Override
    public String getRemark() {
        return this.m_Remark;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRemark(String p_Remark) {
        DMXHardwarePluginInterface o_DMXHardwarePluginInterface;
        if (p_Remark == null) {
            return;
        }
        String oldValue = this.m_Remark;
        this.m_Remark = p_Remark;
        this.m_PropertyChangeSupport.firePropertyChange(PROP_UNIVERSEREMARK, oldValue, this.m_Remark);
        Object object = this.m_SyncHardwarePlugin;
        synchronized (object) {
            o_DMXHardwarePluginInterface = this.m_DMXHdwPluginInterface_Output;
        }
        if (o_DMXHardwarePluginInterface != null) {
            o_DMXHardwarePluginInterface.propertyChanged((DMXHardwarePluginFeedbackInterface)this);
        }
        object = this.m_SyncHardwarePlugin;
        synchronized (object) {
            o_DMXHardwarePluginInterface = this.m_DMXHdwPluginInterface_Input;
        }
        if (o_DMXHardwarePluginInterface != null) {
            o_DMXHardwarePluginInterface.propertyChanged((DMXHardwarePluginFeedbackInterface)this);
        }
        DMXUniverse.fireDMXStageView_UniverseChanged(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getToolTipText() {
        Object object = this.m_SyncStringBuilder;
        synchronized (object) {
            DMXHardwareInterface o_DMXHardwareInterface;
            this.m_StringBuilder.delete(0, this.m_StringBuilder.length());
            this.m_StringBuilder.append("<html>");
            this.m_StringBuilder.append("<b>");
            this.m_StringBuilder.append(this.getName());
            this.m_StringBuilder.append("<br>");
            this.m_StringBuilder.append("Output: ");
            if (this.m_DMXHdwPluginInterface_Output != null) {
                o_DMXHardwareInterface = this.m_DMXHdwPluginInterface_Output.getDMXHardwareInterface();
                if (o_DMXHardwareInterface != null) {
                    this.m_StringBuilder.append(o_DMXHardwareInterface.getInterfaceName().replaceAll("\\<.*?\\>", ""));
                } else {
                    this.m_StringBuilder.append("---");
                }
            } else {
                this.m_StringBuilder.append("---");
            }
            this.m_StringBuilder.append("<br>");
            this.m_StringBuilder.append("Input: ");
            if (this.m_DMXHdwPluginInterface_Input != null) {
                o_DMXHardwareInterface = this.m_DMXHdwPluginInterface_Input.getDMXHardwareInterface();
                if (o_DMXHardwareInterface != null) {
                    this.m_StringBuilder.append(o_DMXHardwareInterface.getInterfaceName().replaceAll("\\<.*?\\>", ""));
                } else {
                    this.m_StringBuilder.append("---");
                }
            } else {
                this.m_StringBuilder.append("---");
            }
            this.m_StringBuilder.append("<br>");
            this.m_StringBuilder.append("</b>");
            this.m_StringBuilder.append(this.m_Remark);
            this.m_StringBuilder.append("</html>");
            return this.m_StringBuilder.toString();
        }
    }

    public DMXUniverseIO getDMXUniverseIO() {
        return this.m_DMXUniverseIO;
    }

    public DMXUniverseInputPatch getDMXUniverseInputPatch() {
        return this.m_DMXUniverseInputPatch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDMXUniverseInputPatch(DMXUniverseInputPatch p_DMXUniverseInputPatch) {
        if (p_DMXUniverseInputPatch == null) {
            return;
        }
        Object object = this.m_SyncDMXUniverseInputPatch;
        synchronized (object) {
            if (this.m_DMXUniverseInputPatch_Outputs.contains(p_DMXUniverseInputPatch)) {
                return;
            }
            this.m_DMXUniverseInputPatch_Outputs.add(p_DMXUniverseInputPatch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDMXUniverseInputPatch(DMXUniverseInputPatch p_DMXUniverseInputPatch) {
        if (p_DMXUniverseInputPatch == null) {
            return;
        }
        Object object = this.m_SyncDMXUniverseInputPatch;
        synchronized (object) {
            this.m_DMXUniverseInputPatch_Outputs.remove(p_DMXUniverseInputPatch);
        }
    }

    public int getDMXUniverseInputPatch_OutputCount() {
        return this.m_DMXUniverseInputPatch_Outputs.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DMXUniverseInputPatch getDMXUniverseInputPatch_Output(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        Object object = this.m_SyncDMXUniverseInputPatch;
        synchronized (object) {
            if (p_Index >= this.m_DMXUniverseInputPatch_Outputs.size()) {
                return null;
            }
            return this.m_DMXUniverseInputPatch_Outputs.get(p_Index);
        }
    }

    public DMXHardwarePluginInterface getDMXHardwarePlugin_Output() {
        return this.m_DMXHdwPluginInterface_Output;
    }

    public void setConnectionStatus_Output(int p_Status, String p_Remark) {
        int oldValue = this.m_ConnectionStatus_Output;
        this.m_ConnectionStatus_Output = p_Status;
        this.m_PropertyChangeSupport.firePropertyChange(PROP_UNIVERSECONNECTIONSTATUS_OUPUT, oldValue, this.m_ConnectionStatus_Output);
        DMXUniverseIO o_DMXUniverseIO = this.m_DMXUniverseIO;
        if (o_DMXUniverseIO != null) {
            o_DMXUniverseIO.resetHardwareValues(this.m_DMXHdwPluginInterface_Output);
        }
        if (this.m_DebugOn) {
            System.out.println(this.getClass().getSimpleName() + " " + this.getName() + " Connection Status Output: " + this.m_ConnectionStatus_Output + "  " + p_Remark);
        }
    }

    public int getConnectionStatus_Output() {
        return this.m_ConnectionStatus_Output;
    }

    public DMXHardwarePluginInterface getDMXHardwarePlugin_Input() {
        return this.m_DMXHdwPluginInterface_Input;
    }

    public void setConnectionStatus_Input(int p_Status, String p_Remark) {
        int oldValue = this.m_ConnectionStatus_Input;
        this.m_ConnectionStatus_Input = p_Status;
        if (this.m_DMXHdwPluginInterface_Input == null || this.m_ConnectionStatus_Input == 5 || this.m_ConnectionStatus_Input == 6) {
            // empty if block
        }
        this.m_PropertyChangeSupport.firePropertyChange(PROP_UNIVERSECONNECTIONSTATUS_INPUT, oldValue, this.m_ConnectionStatus_Input);
        DMXUniverseIO o_DMXUniverseIO = this.m_DMXUniverseIO;
        if (o_DMXUniverseIO != null) {
            o_DMXUniverseIO.resetHardwareValues(this.m_DMXHdwPluginInterface_Input);
        }
        if (this.m_DebugOn) {
            System.out.println(this.getClass().getSimpleName() + " " + this.getName() + " Connection Status Input: " + this.m_ConnectionStatus_Input + "  " + p_Remark);
        }
        DMXUniverse.fireDMXStageView_UniverseChanged(this);
    }

    public int getConnectionStatus_Input() {
        return this.m_ConnectionStatus_Input;
    }

    public ArrayList<DMXChannel> getDMXChannels() {
        return this.m_DMXChannels;
    }

    public int getDMXChannelCount() {
        return this.m_DMXChannels.size();
    }

    public int getDMXChannelFirstAddress() {
        return 0;
    }

    public int getDMXChannelLastAddress() {
        return 511;
    }

    public DMXChannel getDMXChannel(int p_Address) {
        if (p_Address < 0 || p_Address >= this.m_DMXChannels.size()) {
            return null;
        }
        return this.m_DMXChannels.get(p_Address);
    }

    public int[] getNewValues() {
        return this.m_NewValues;
    }

    public boolean addDMXDeviceInternalSector(DMXDevice.InternalSector p_DMXDeviceInternalSector) {
        if (p_DMXDeviceInternalSector == null) {
            return false;
        }
        if (this.m_DMXDeviceInternalSectors.contains(p_DMXDeviceInternalSector)) {
            return true;
        }
        boolean boolAdded = false;
        boolAdded = this.m_DMXDeviceInternalSectors.add(p_DMXDeviceInternalSector);
        DMXDevice o_DMXDevice = p_DMXDeviceInternalSector.getDMXDevice();
        if (!this.m_DMXDevices.contains(o_DMXDevice)) {
            this.m_DMXDevices.add(o_DMXDevice);
        }
        DMXUniverseInputPatch.eventDMXDeviceAddressChanged(p_DMXDeviceInternalSector.getDMXUniverse());
        return boolAdded;
    }

    public boolean removeDMXDeviceInternalSector(DMXDevice.InternalSector p_DMXDeviceInternalSector) {
        if (p_DMXDeviceInternalSector == null) {
            return false;
        }
        boolean boolRemoved = false;
        boolean boolContainsDMXDevice = false;
        boolRemoved = this.m_DMXDeviceInternalSectors.remove(p_DMXDeviceInternalSector);
        DMXDevice o_DMXDevice = p_DMXDeviceInternalSector.getDMXDevice();
        if (o_DMXDevice != null) {
            for (int intSector = 0; intSector < o_DMXDevice.getInternalSectorCount(); ++intSector) {
                if (!this.m_DMXDeviceInternalSectors.contains(o_DMXDevice.getInternalSector(intSector))) continue;
                boolContainsDMXDevice = true;
                break;
            }
            if (!boolContainsDMXDevice) {
                this.m_DMXDevices.remove(o_DMXDevice);
            }
        }
        DMXUniverseInputPatch.eventDMXDeviceAddressChanged(p_DMXDeviceInternalSector.getDMXUniverse());
        return boolRemoved;
    }

    public int getDMXDeviceInternalSectorCount() {
        return this.m_DMXDeviceInternalSectors.size();
    }

    public DMXDevice.InternalSector getDMXDeviceInternalSector(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        if (p_Index >= this.m_DMXDeviceInternalSectors.size()) {
            return null;
        }
        return this.m_DMXDeviceInternalSectors.get(p_Index);
    }

    public void refreshFreeAddresses() {
        for (int intAddress = 0; intAddress < 512; ++intAddress) {
            this.m_FreeAddresses[intAddress] = true;
        }
        for (int intDevice = 0; intDevice < this.m_DMXDeviceInternalSectors.size(); ++intDevice) {
            DMXDevice.InternalSector o_DMXDeviceInternalSector = this.m_DMXDeviceInternalSectors.get(intDevice);
            if (o_DMXDeviceInternalSector == null) continue;
            int intStartAddress = o_DMXDeviceInternalSector.getDMXStartAddress();
            int intChannelCount = o_DMXDeviceInternalSector.getInternalChannelCount();
            for (int intAddress = intStartAddress; intAddress < intStartAddress + intChannelCount; ++intAddress) {
                this.m_FreeAddresses[intAddress] = false;
            }
        }
    }

    public boolean checkAddressValid(DMXDevice.InternalSector p_DMXDeviceInternalSector, int p_StartAddress) {
        if (p_DMXDeviceInternalSector == null) {
            return true;
        }
        int intStartAddress = p_StartAddress;
        int intChannelCount = p_DMXDeviceInternalSector.getInternalChannelCount();
        for (int intChannel = intStartAddress; intChannel < intStartAddress + intChannelCount; ++intChannel) {
            ArrayList<DMXDevice.InternalChannel> o_DMXDeviceInternalChannels;
            if (intChannel < 0) {
                return false;
            }
            if (intChannel >= this.m_DMXChannels.size()) {
                return false;
            }
            DMXChannel o_DMXChannel = this.m_DMXChannels.get(intChannel);
            if (o_DMXChannel == null || (o_DMXDeviceInternalChannels = o_DMXChannel.getDMXDeviceInternalChannels()).size() <= 0) continue;
            for (int intInternalChannel = 0; intInternalChannel < o_DMXDeviceInternalChannels.size(); ++intInternalChannel) {
                if (o_DMXDeviceInternalChannels.get(intInternalChannel).getDMXDeviceInternalSector() == p_DMXDeviceInternalSector) continue;
                return false;
            }
        }
        return true;
    }

    public boolean checkAddressValid(DMXDeviceType p_DMXDeviceType, int p_DMXDeviceSectorIndex, int p_StartAddressInternal) {
        if (p_DMXDeviceType == null) {
            return true;
        }
        int intStartAddress = p_StartAddressInternal;
        DMXDeviceType.DMXDeviceSector o_DMXDeviceSector = p_DMXDeviceType.getDMXDeviceSector(p_DMXDeviceSectorIndex);
        if (o_DMXDeviceSector == null) {
            return false;
        }
        int intChannelCount = o_DMXDeviceSector.getChannelCount();
        for (int intChannel = intStartAddress; intChannel < intStartAddress + intChannelCount; ++intChannel) {
            if (intChannel < 0) {
                return false;
            }
            if (intChannel >= this.m_DMXChannels.size()) {
                return false;
            }
            DMXChannel o_DMXChannel = this.m_DMXChannels.get(intChannel);
            if (o_DMXChannel == null || o_DMXChannel.getDMXDeviceInternalChannelCount() <= 0) continue;
            return false;
        }
        return true;
    }

    public int findAddressValid(DMXDeviceType p_DMXDeviceType, int p_DMXSectorIndex) {
        if (p_DMXDeviceType == null) {
            return 0;
        }
        DMXDeviceType.DMXDeviceSector o_DMXDeviceSector = p_DMXDeviceType.getDMXDeviceSector(p_DMXSectorIndex);
        if (o_DMXDeviceSector == null) {
            return 0;
        }
        int intChannelCount = o_DMXDeviceSector.getChannelCount();
        for (int intStartAddress = 0; intStartAddress < this.m_DMXChannels.size() - intChannelCount; ++intStartAddress) {
            DMXChannel o_DMXChannel = this.m_DMXChannels.get(intStartAddress);
            if (o_DMXChannel == null || o_DMXChannel.getDMXDeviceInternalChannelCount() > 0) continue;
            int intFreeAddressCount = 0;
            while (intFreeAddressCount < intChannelCount) {
                o_DMXChannel = this.m_DMXChannels.get(intStartAddress + intFreeAddressCount);
                if (o_DMXChannel == null) continue;
                if (o_DMXChannel.getDMXDeviceInternalChannelCount() > 0) break;
                ++intFreeAddressCount;
            }
            if (intFreeAddressCount != intChannelCount) continue;
            return intStartAddress;
        }
        return -1;
    }

    public int findAddressValid(int p_ChannelNeeded) {
        if (p_ChannelNeeded <= 0) {
            return 0;
        }
        for (int intStartAddress = 0; intStartAddress < this.m_DMXChannels.size() - p_ChannelNeeded; ++intStartAddress) {
            DMXChannel o_DMXChannel = this.m_DMXChannels.get(intStartAddress);
            if (o_DMXChannel == null || o_DMXChannel.getDMXDeviceInternalChannelCount() > 0) continue;
            int intFreeAddressCount = 0;
            while (intFreeAddressCount < p_ChannelNeeded) {
                o_DMXChannel = this.m_DMXChannels.get(intStartAddress + intFreeAddressCount);
                if (o_DMXChannel == null) continue;
                if (o_DMXChannel.getDMXDeviceInternalChannelCount() > 0) break;
                ++intFreeAddressCount;
            }
            if (intFreeAddressCount != p_ChannelNeeded) continue;
            return intStartAddress;
        }
        return -1;
    }

    public boolean addDMXChannelUsed(DMXChannel p_DMXChannel) {
        if (p_DMXChannel == null) {
            return false;
        }
        this.m_DMXUniverseIO.doAddChannelUsed(p_DMXChannel);
        return true;
    }

    public void finishAddDMXChannelUsed(DMXChannel p_DMXChannel) {
        int intChannel;
        if (p_DMXChannel == null) {
            return;
        }
        if (!this.m_DMXChannels.contains(p_DMXChannel)) {
            return;
        }
        if (this.m_DMXChannelsUsed.contains(p_DMXChannel)) {
            return;
        }
        for (intChannel = 0; intChannel < this.m_DMXChannelsUsed.size() && this.m_DMXChannelsUsed.get(intChannel).getDMXAddress() <= p_DMXChannel.getDMXAddress(); ++intChannel) {
        }
        this.m_DMXChannelsUsed.add(intChannel, p_DMXChannel);
    }

    public void removeDMXChannelUsed(DMXChannel p_DMXChannel) {
        if (p_DMXChannel == null) {
            return;
        }
        if (!this.m_DMXChannels.contains(p_DMXChannel)) {
            return;
        }
        this.m_DMXUniverseIO.doRemoveChannelUsed(p_DMXChannel);
    }

    public int getDMXChannelUsedCount() {
        return this.m_DMXChannelsUsed.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DMXChannel getDMXChannelUsed(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        DMXChannel o_DMXChannel = null;
        Object object = this.m_SyncChannelUsed;
        synchronized (object) {
            if (p_Index >= this.m_DMXChannelsUsed.size()) {
                return null;
            }
            o_DMXChannel = this.m_DMXChannelsUsed.get(p_Index);
        }
        return o_DMXChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pluginDMXHardware_Output(DMXHardwarePluginInterface p_DMXHardwarePluginInterface_Output) {
        DMXHardwarePluginInterface o_DMXHardwarePluginInterface;
        if (p_DMXHardwarePluginInterface_Output != null && p_DMXHardwarePluginInterface_Output.getDMXPluginType() != 0) {
            return;
        }
        if (this.m_DMXHdwPluginInterface_Output == p_DMXHardwarePluginInterface_Output) {
            return;
        }
        Object object = this.m_SyncHardwarePlugin;
        synchronized (object) {
            o_DMXHardwarePluginInterface = this.m_DMXHdwPluginInterface_Output;
        }
        if (o_DMXHardwarePluginInterface != null) {
            o_DMXHardwarePluginInterface.requestDMXPlugConnection(null);
        }
        if (p_DMXHardwarePluginInterface_Output != null) {
            p_DMXHardwarePluginInterface_Output.requestDMXPlugConnection((DMXHardwarePluginFeedbackInterface)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pluginDMXHardware_Input(DMXHardwarePluginInterface p_DMXHardwarePluginInterface_Input) {
        DMXHardwarePluginInterface o_DMXHardwarePluginInterface;
        if (p_DMXHardwarePluginInterface_Input != null && p_DMXHardwarePluginInterface_Input.getDMXPluginType() != 1) {
            return;
        }
        if (this.m_DMXHdwPluginInterface_Input == p_DMXHardwarePluginInterface_Input) {
            return;
        }
        Object object = this.m_SyncHardwarePlugin;
        synchronized (object) {
            o_DMXHardwarePluginInterface = this.m_DMXHdwPluginInterface_Input;
        }
        if (o_DMXHardwarePluginInterface != null) {
            o_DMXHardwarePluginInterface.requestDMXPlugConnection(null);
        }
        if (p_DMXHardwarePluginInterface_Input != null) {
            p_DMXHardwarePluginInterface_Input.requestDMXPlugConnection((DMXHardwarePluginFeedbackInterface)this);
        }
    }

    public void callDMXOutput_ReadChannels() {
        this.m_DMXUniverseIO.doReadValues();
    }

    public void callDMXOutput_WriteChannels() {
        this.m_DMXUniverseIO.doWriteValues();
    }

    public void eventPluginConnectionStatus(DMXHardwareInterface p_DMXHardwareInterface, DMXHardwarePluginInterface p_DMXHardwarePluginInterface, int p_ConnectionStatus, String p_Remark) {
        if (this.m_DMXHdwPluginInterface_Output != null && this.m_DMXHdwPluginInterface_Output == p_DMXHardwarePluginInterface) {
            this.setConnectionStatus_Output(p_ConnectionStatus, p_Remark);
        }
        if (this.m_DMXHdwPluginInterface_Input != null && this.m_DMXHdwPluginInterface_Input == p_DMXHardwarePluginInterface) {
            this.setConnectionStatus_Input(p_ConnectionStatus, p_Remark);
        }
    }

    public void eventPluginWriteValues(DMXHardwareInterface p_DMXHardwareInterface, DMXHardwarePluginInterface p_DMXHardwarePluginInterface, int[] p_AllInterfaceValues) {
        this.m_DMXUniverseIO.sendAnswerWriteValues(p_DMXHardwareInterface, p_DMXHardwarePluginInterface, p_AllInterfaceValues);
    }

    public void eventPluginReadValues(DMXHardwareInterface p_DMXHardwareInterface, DMXHardwarePluginInterface p_DMXHardwarePluginInterface, int[] p_AllInterfaceValues) {
        this.m_DMXUniverseIO.sendAnswerReadValues(p_DMXHardwareInterface, p_DMXHardwarePluginInterface, p_AllInterfaceValues);
    }

    public void eventPluginException(DMXHardwareInterface p_DMXHardwareInterface, DMXHardwarePluginInterface p_DMXHardwarePluginInterface, int p_ExceptionType, String p_ExceptionString) {
        this.m_DMXUniverseIO.sendAnswerException(p_DMXHardwareInterface, p_DMXHardwarePluginInterface, p_ExceptionType, p_ExceptionString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eventPlugin(DMXHardwareInterface p_DMXHardwareInterface, DMXHardwarePluginInterface p_DMXHardwarePluginInterface, DMXHardwarePluginFeedbackInterface p_DMXUniverseFeedbackInterface) {
        DMXHardwarePluginInterface o_OldValue = null;
        DMXHardwarePluginInterface o_NewValue = null;
        Object object = this.m_SyncHardwarePlugin;
        synchronized (object) {
            if (p_DMXUniverseFeedbackInterface == null) {
                if (this.m_DMXHdwPluginInterface_Output == p_DMXHardwarePluginInterface) {
                    o_OldValue = this.m_DMXHdwPluginInterface_Output;
                    this.setConnectionStatus_Output(0, "");
                    this.m_DMXHdwPluginInterface_Output = null;
                } else if (this.m_DMXHdwPluginInterface_Input == p_DMXHardwarePluginInterface) {
                    o_OldValue = this.m_DMXHdwPluginInterface_Input;
                    this.setConnectionStatus_Input(0, "");
                    this.m_DMXHdwPluginInterface_Input = null;
                    this.m_DMXUniverseInputPatch.eventDMXInputConnected(false);
                }
            } else if (p_DMXHardwarePluginInterface.getDMXPluginType() == 0) {
                DMXHardware o_DMXHardware = DMXHardware.getTreeModel().getDMXHardware(p_DMXHardwareInterface);
                if (o_DMXHardware != null) {
                    this.m_DMXHdwPluginInterface_Output = p_DMXHardwarePluginInterface;
                    this.setConnectionStatus_Output(this.m_DMXHdwPluginInterface_Output.getConnectionStatus(), "");
                    DMXHardwareInterface o_DMXHardwareInterface = this.m_DMXHdwPluginInterface_Output.getDMXHardwareInterface();
                    if (o_DMXHardwareInterface == null) {
                        this.setConnectionStatus_Output(0, "");
                    }
                } else {
                    this.setConnectionStatus_Output(0, "");
                    this.m_DMXHdwPluginInterface_Output = null;
                }
                o_NewValue = this.m_DMXHdwPluginInterface_Output;
            } else if (p_DMXHardwarePluginInterface.getDMXPluginType() == 1) {
                DMXHardware o_DMXHardware = DMXHardware.getTreeModel().getDMXHardware(p_DMXHardwareInterface);
                if (o_DMXHardware != null) {
                    this.m_DMXHdwPluginInterface_Input = p_DMXHardwarePluginInterface;
                    this.setConnectionStatus_Input(this.m_DMXHdwPluginInterface_Input.getConnectionStatus(), "");
                    DMXHardwareInterface o_DMXHardwareInterface = this.m_DMXHdwPluginInterface_Input.getDMXHardwareInterface();
                    if (o_DMXHardwareInterface == null) {
                        this.setConnectionStatus_Input(0, "");
                    }
                    this.m_DMXUniverseInputPatch.eventDMXInputConnected(true);
                } else {
                    this.setConnectionStatus_Input(0, "");
                    this.m_DMXHdwPluginInterface_Input = null;
                    this.m_DMXUniverseInputPatch.eventDMXInputConnected(false);
                }
                o_NewValue = this.m_DMXHdwPluginInterface_Input;
            }
        }
        this.m_PropertyChangeSupport.firePropertyChange(PROP_HARDWAREPLUGGEDIN, o_OldValue, o_NewValue);
    }

    public void eventPluginChanged(DMXHardwareInterface p_DMXHardwareInterface, DMXHardwarePluginInterface p_DMXHardwarePluginInterface) {
        if (p_DMXHardwarePluginInterface == null) {
            return;
        }
        int intPluginType = p_DMXHardwarePluginInterface.getDMXPluginType();
        if (this.m_DMXHdwPluginInterface_Output == p_DMXHardwarePluginInterface) {
            if (intPluginType == 0) {
                return;
            }
            this.pluginDMXHardware_Output(null);
            if (intPluginType == 1 && this.m_DMXHdwPluginInterface_Input == null) {
                this.pluginDMXHardware_Input(p_DMXHardwarePluginInterface);
            }
        }
        if (this.m_DMXHdwPluginInterface_Input == p_DMXHardwarePluginInterface) {
            if (intPluginType == 1) {
                return;
            }
            this.pluginDMXHardware_Input(null);
            if (intPluginType == 0 && this.m_DMXHdwPluginInterface_Output == null) {
                this.pluginDMXHardware_Output(p_DMXHardwarePluginInterface);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof DMXChannel) {
            DMXChannel o_DMXChannel = (DMXChannel)evt.getSource();
            if (evt.getPropertyName().equals("dmxchannelValueNewRevised")) {
                int intChannelAddress = o_DMXChannel.getDMXAddress();
                if (intChannelAddress < 0 || intChannelAddress >= 512) {
                    return;
                }
                this.m_NewValues[intChannelAddress] = o_DMXChannel.getValueRevised();
            }
        }
    }

    @Override
    public Icon getIcon() {
        return s_Icon;
    }

    public int getDMXDeviceCount() {
        return this.m_DMXDevices.size();
    }

    public DMXDevice getDMXDevice(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        if (p_Index >= this.m_DMXDevices.size()) {
            return null;
        }
        return this.m_DMXDevices.get(p_Index);
    }

    @Override
    public boolean useDMXDevice(DMXDevice p_DMXDevice) {
        if (p_DMXDevice == null) {
            return false;
        }
        return this.m_DMXDevices.contains(p_DMXDevice);
    }

    public void eventPluginWriteMIDIMessage(DMXHardwareInterface p_DMXHardwareInterface, DMXHardwarePluginInterface p_DMXHardwarePluginInterface, byte[] p_MIDIMessage) {
    }

    public void eventPluginReadMIDIMessage(DMXHardwareInterface p_DMXHardwareInterface, DMXHardwarePluginInterface p_DMXHardwarePluginInterface, byte[] p_MIDIMessage) {
    }

    public static void addDMXUniverse(DMXUniverse p_DMXUniverse) {
        if (p_DMXUniverse == null) {
            return;
        }
        if (s_DMXUniverseListModel.add(p_DMXUniverse)) {
            DMXUniverse.fireDMXStageView_UniverseAdded(p_DMXUniverse);
        }
    }

    public static void removeDMXUniverse(DMXUniverse p_DMXUniverse) {
        if (p_DMXUniverse == null) {
            return;
        }
        if (s_DMXUniverseListModel.remove(p_DMXUniverse)) {
            DMXUniverse.fireDMXStageView_UniverseRemoved(p_DMXUniverse);
        }
        p_DMXUniverse.close();
    }

    public static ArrayList<DMXUniverse> getDMXUniverses() {
        ArrayList<DMXUniverse> o_Universes = s_DMXUniverseListModel.getElementArrayList_Safe();
        return o_Universes;
    }

    public static int getDMXUniverseCount() {
        return s_DMXUniverseListModel.size();
    }

    public static DMXUniverse getDMXUniverse(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        if (p_Index >= s_DMXUniverseListModel.size()) {
            return null;
        }
        return s_DMXUniverseListModel.get(p_Index);
    }

    public static DMXUniverse getDMXUniverse(String p_ID) {
        if (p_ID == null) {
            return null;
        }
        if (p_ID.length() <= 0) {
            return null;
        }
        for (int intUniverse = 1; intUniverse < s_DMXUniverseListModel.size(); ++intUniverse) {
            DMXUniverse o_DMXUniverse = s_DMXUniverseListModel.get(intUniverse);
            if (o_DMXUniverse == null || !o_DMXUniverse.getID().equals(p_ID)) continue;
            return o_DMXUniverse;
        }
        return null;
    }

    public static boolean saveDMXUniverses(LiveShowProjectDescription p_LiveShowProjectDescription, ArrayList<DMXDevice> p_DMXDevices) {
        if (p_LiveShowProjectDescription == null) {
            return false;
        }
        ObjectOutput o_ObjectOutput = null;
        FileOutputStream o_FileOutputStream = null;
        String stringFileName = p_LiveShowProjectDescription.getProjectPathName() + FILESUFFIX;
        try {
            int intDevice;
            DMXDevice o_DMXDevice;
            DMXUniverse o_DMXUniverse;
            File o_File = new File(stringFileName);
            if (o_File.exists()) {
                try {
                    o_File.delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            o_File.createNewFile();
            o_FileOutputStream = new FileOutputStream(o_File);
            o_ObjectOutput = new ObjectOutputStream(o_FileOutputStream);
            o_ObjectOutput.writeInt(2);
            if (p_DMXDevices == null) {
                int intDMXUniverseCount = DMXUniverse.getDMXUniverseCount();
                o_ObjectOutput.writeInt(intDMXUniverseCount);
                for (int intUniverse = 1; intUniverse < intDMXUniverseCount; ++intUniverse) {
                    o_DMXUniverse = DMXUniverse.getDMXUniverse(intUniverse);
                    if (o_DMXUniverse == null) continue;
                    o_DMXUniverse.writeExternal(o_ObjectOutput);
                }
            } else {
                ArrayList<DMXUniverse> o_ArrayListDMXUniverses = new ArrayList<DMXUniverse>();
                for (int intDMXDevice = 0; intDMXDevice < p_DMXDevices.size(); ++intDMXDevice) {
                    o_DMXDevice = p_DMXDevices.get(intDMXDevice);
                    for (int intSector = 0; intSector < o_DMXDevice.getInternalSectorCount(); ++intSector) {
                        o_DMXUniverse = o_DMXDevice.getDMXUniverse(intSector);
                        if (o_DMXUniverse == null || o_ArrayListDMXUniverses.contains(o_DMXUniverse)) continue;
                        o_ArrayListDMXUniverses.add(o_DMXUniverse);
                    }
                }
                int intDMXUniverseCount = o_ArrayListDMXUniverses.size() + 1;
                o_ObjectOutput.writeInt(intDMXUniverseCount);
                for (int intUniverse = 0; intUniverse < o_ArrayListDMXUniverses.size(); ++intUniverse) {
                    o_DMXUniverse = (DMXUniverse)o_ArrayListDMXUniverses.get(intUniverse);
                    if (o_DMXUniverse == null) continue;
                    o_DMXUniverse.writeExternal(o_ObjectOutput);
                }
            }
            DMXDeviceType.saveProjectDMXDeviceTypes(p_LiveShowProjectDescription, p_DMXDevices);
            if (p_DMXDevices == null) {
                int intDeviceCount = DMXDevice.getDMXDeviceCount();
                o_ObjectOutput.writeInt(intDeviceCount);
                for (intDevice = 0; intDevice < intDeviceCount; ++intDevice) {
                    o_DMXDevice = DMXDevice.getDMXDevice(intDevice);
                    o_DMXDevice.writeExternal(o_ObjectOutput);
                }
            } else {
                int intDeviceCount = p_DMXDevices.size();
                o_ObjectOutput.writeInt(intDeviceCount);
                for (intDevice = 0; intDevice < p_DMXDevices.size(); ++intDevice) {
                    o_DMXDevice = p_DMXDevices.get(intDevice);
                    o_DMXDevice.writeExternal(o_ObjectOutput);
                }
            }
            o_ObjectOutput.close();
            o_FileOutputStream.close();
        }
        catch (Exception e) {
            try {
                if (o_ObjectOutput != null) {
                    o_ObjectOutput.close();
                }
                if (o_FileOutputStream != null) {
                    o_FileOutputStream.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
        DMXUniverse.saveDMXUniversePatches(p_LiveShowProjectDescription);
        return true;
    }

    public static boolean deleteDMXUniverses(LiveShowProjectDescription p_LiveShowProjectDescription) {
        if (p_LiveShowProjectDescription == null) {
            return false;
        }
        boolean boolSuccess = false;
        String stringFileName = p_LiveShowProjectDescription.getProjectPathName() + FILESUFFIX;
        File o_File = new File(stringFileName);
        if (o_File.exists()) {
            try {
                boolSuccess = o_File.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        DMXDeviceType.deleteProjectDMXDeviceTypes(p_LiveShowProjectDescription);
        return boolSuccess;
    }

    public static boolean loadDMXUniverses(LiveShowProjectDescription p_LiveShowProjectDescription, LiveShow_ImportDescription p_LiveShow_ImportDescription) {
        if (p_LiveShowProjectDescription == null) {
            return false;
        }
        String stringFileName = p_LiveShowProjectDescription.getProjectPathName() + FILESUFFIX;
        boolean boolSucces = p_LiveShowProjectDescription == null || p_LiveShow_ImportDescription.getLoadNewProject() ? DMXUniverse.loadDMXUniverses(stringFileName, false, null) : DMXUniverse.loadDMXUniverses(stringFileName, true, p_LiveShow_ImportDescription);
        return boolSucces;
    }

    public static boolean loadDMXUniverses(String p_FileName, boolean p_IsImport, LiveShow_ImportDescription p_LiveShow_ImportDescription) {
        DMXUniverse o_DMXUniverse;
        ArrayList<DMXUniverse> o_DMXUniverses;
        String stringRareFileName;
        if (p_FileName == null) {
            return false;
        }
        try {
            String stringFileNamePostfix = p_FileName.substring(p_FileName.length() - 4, p_FileName.length());
            if (!stringFileNamePostfix.equals(FILESUFFIX)) {
                return false;
            }
            stringRareFileName = p_FileName.substring(0, p_FileName.length() - 4);
        }
        catch (Exception e) {
            return false;
        }
        FileInputStream o_FileInputStream = null;
        ObjectInput o_ObjectInput = null;
        s_DMXUniversesAreLoading = true;
        try {
            File o_File = new File(p_FileName);
            o_FileInputStream = new FileInputStream(o_File);
            o_ObjectInput = new ObjectInputStream(o_FileInputStream);
            int intSoftwareVersion = o_ObjectInput.readInt();
            int intUniverseCount = o_ObjectInput.readInt();
            o_DMXUniverses = new ArrayList<DMXUniverse>();
            for (int intUniverse = 1; intUniverse < intUniverseCount; ++intUniverse) {
                o_DMXUniverse = new DMXUniverse();
                o_DMXUniverse.readExternal(o_ObjectInput);
                if (DMXUniverse.getDMXUniverse(o_DMXUniverse.getID()) != null) {
                    o_DMXUniverse.close();
                    continue;
                }
                LiveShowDMXSystem.addDMXUniverse(o_DMXUniverse);
                if (o_DMXUniverse.getClosed()) continue;
                if (p_IsImport) {
                    o_DMXUniverse.setName(LiveShow_ImportDescription.createImportedName(o_DMXUniverse.getName()));
                }
                o_DMXUniverses.add(o_DMXUniverse);
            }
            DMXDeviceType.importDMXDeviceTypes(stringRareFileName + ".lsd", false);
            int intDMXDeviceCount = o_ObjectInput.readInt();
            for (int intDMXDevice = 0; intDMXDevice < intDMXDeviceCount; ++intDMXDevice) {
                DMXDevice o_DMXDevice = new DMXDevice();
                o_DMXDevice.readExternal(o_ObjectInput);
                if (o_DMXDevice.getDMXDeviceType() == null) {
                    o_DMXDevice.close();
                    continue;
                }
                DMXDevice o_DMXDevice_Exist = DMXDevice.getDMXDevice(o_DMXDevice.getID());
                if (o_DMXDevice_Exist != null) {
                    o_DMXDevice.close();
                    continue;
                }
                if (p_IsImport) {
                    o_DMXDevice_Exist = DMXDevice.getSameDMXDevice(o_DMXDevice);
                    if (o_DMXDevice_Exist != null) {
                        p_LiveShow_ImportDescription.addDMXDeviceIDReplacement(o_DMXDevice.getID(), o_DMXDevice_Exist.getID());
                        o_DMXDevice.close();
                        continue;
                    }
                    o_DMXDevice.setName(LiveShow_ImportDescription.createImportedName(o_DMXDevice.getName()));
                }
                if (o_DMXDevice.getDMXDeviceType() == null || DMXDevice.getDMXDevice(o_DMXDevice.getID()) != null) continue;
                LiveShowDMXSystem.getLiveShowDMXStageView().addDMXDevice(o_DMXDevice);
            }
            o_ObjectInput.close();
            o_FileInputStream.close();
        }
        catch (Exception e) {
            s_DMXUniversesAreLoading = false;
            try {
                if (o_ObjectInput != null) {
                    o_ObjectInput.close();
                }
                if (o_FileInputStream != null) {
                    o_FileInputStream.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
        s_DMXUniversesAreLoading = false;
        for (int intDMXUniverse = 0; intDMXUniverse < DMXUniverse.getDMXUniverseCount(); ++intDMXUniverse) {
            o_DMXUniverse = DMXUniverse.getDMXUniverse(intDMXUniverse);
            if (o_DMXUniverse == null) continue;
            o_DMXUniverse.eventAllDevicesLoaded();
        }
        if (o_DMXUniverses.size() > 0) {
            o_DMXUniverses.clear();
            DMXDevice.checkAllDevicesAddresses();
            String stringFileNameDMXUniversePatch = stringRareFileName + ".uip";
            DMXUniverse.loadDMXUniversePatches(stringFileNameDMXUniversePatch, p_IsImport, p_LiveShow_ImportDescription);
            return true;
        }
        DMXDevice.checkAllDevicesAddresses();
        return false;
    }

    public void eventAllDevicesLoaded() {
        if (this.m_DMXUniverseInputPatch != null) {
            this.m_DMXUniverseInputPatch.eventAllDMXDevicesLoaded();
            if (this.m_DMXHdwPluginInterface_Input != null) {
                this.m_DMXUniverseInputPatch.eventDMXInputConnected(true);
            } else {
                this.m_DMXUniverseInputPatch.eventDMXInputConnected(false);
            }
        }
    }

    public static boolean saveDMXUniversePatches(LiveShowProjectDescription p_LiveShowProjectDescription) {
        DMXUniverseInputPatch o_DMXUniverseInputPatch;
        DMXUniverse o_DMXUniverse;
        if (p_LiveShowProjectDescription == null) {
            return false;
        }
        ArrayList<DMXUniverseInputPatch> o_DMXUniverseInputPatches = new ArrayList<DMXUniverseInputPatch>();
        for (int intDMXUniverse = 0; intDMXUniverse < DMXUniverse.getDMXUniverseCount(); ++intDMXUniverse) {
            o_DMXUniverse = DMXUniverse.getDMXUniverse(intDMXUniverse);
            if (o_DMXUniverse == null || (o_DMXUniverseInputPatch = o_DMXUniverse.getDMXUniverseInputPatch()) == null) continue;
            o_DMXUniverseInputPatches.add(o_DMXUniverseInputPatch);
        }
        ObjectOutput o_ObjectOutput = null;
        FileOutputStream o_FileOutputStream = null;
        String stringFileName = p_LiveShowProjectDescription.getProjectPathName() + ".uip";
        try {
            File o_File = new File(stringFileName);
            if (o_File.exists()) {
                try {
                    o_File.delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            o_File.createNewFile();
            o_FileOutputStream = new FileOutputStream(o_File);
            o_ObjectOutput = new ObjectOutputStream(o_FileOutputStream);
            o_ObjectOutput.writeInt(2);
            o_ObjectOutput.writeInt(o_DMXUniverseInputPatches.size());
            for (int intDMXUniversePatch = 0; intDMXUniversePatch < o_DMXUniverseInputPatches.size(); ++intDMXUniversePatch) {
                o_DMXUniverseInputPatch = (DMXUniverseInputPatch)o_DMXUniverseInputPatches.get(intDMXUniversePatch);
                o_DMXUniverse = o_DMXUniverseInputPatch.getDMXUniverseInput();
                o_ObjectOutput.writeUTF(o_DMXUniverse.getID());
                o_DMXUniverseInputPatch.writeExternal(o_ObjectOutput);
            }
            o_ObjectOutput.close();
            o_FileOutputStream.close();
        }
        catch (Exception e) {
            try {
                if (o_ObjectOutput != null) {
                    o_ObjectOutput.close();
                }
                if (o_FileOutputStream != null) {
                    o_FileOutputStream.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
        return true;
    }

    private static void loadDMXUniversePatches(String p_FileName, boolean p_IsImport, LiveShow_ImportDescription p_LiveShow_ImportDescription) {
        if (p_FileName == null) {
            return;
        }
        FileInputStream o_FileInputStream = null;
        ObjectInput o_ObjectInput = null;
        try {
            File o_File = new File(p_FileName);
            if (!o_File.exists()) {
                return;
            }
            o_FileInputStream = new FileInputStream(o_File);
            o_ObjectInput = new ObjectInputStream(o_FileInputStream);
            int intSoftwareVersion = o_ObjectInput.readInt();
            int intDMXUniversePatchCount = o_ObjectInput.readInt();
            for (int intDMXUniversePatch = 0; intDMXUniversePatch < intDMXUniversePatchCount; ++intDMXUniversePatch) {
                String stringDMXUniverseID = o_ObjectInput.readUTF();
                DMXUniverse o_DMXUniverse = DMXUniverse.getDMXUniverse(stringDMXUniverseID);
                DMXUniverseInputPatch o_DMXUniverseInputPatch = o_DMXUniverse == null ? new DMXUniverseInputPatch(null) : o_DMXUniverse.getDMXUniverseInputPatch();
                o_DMXUniverseInputPatch.readExternal(o_ObjectInput);
            }
            o_ObjectInput.close();
            o_FileInputStream.close();
        }
        catch (Exception e) {
            try {
                o_ObjectInput.close();
                o_FileInputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static DMXUniverseCellRenderer getCellRenderer() {
        return s_DMXUniverseCellRenderer;
    }

    public static TableAndListModel.ListModel<DMXUniverse> getListModel() {
        return s_DMXUniverseListModel;
    }

    static {
        DEFAULT_UNIVERSENAME = "Universe";
        DEFAULT_UNIVERSEDESCRIPTION = "";
        s_LanguageLoaded = false;
        s_DMXUniverseListModel = new TableAndListModel.ListModel(true, true);
        s_DMXUniverseCellRenderer = new DMXUniverseCellRenderer();
        s_DMXStageViewListeners = new ArrayList();
        s_SyncStageViewListener = new Object();
        s_DMXUniversesAreLoading = false;
    }

    public static class DMXUniverseCellRenderer
    extends DefaultListCellRenderer {
        protected static final Border SAFE_NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);
        protected static final Border DEFAULT_NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);
        protected static final Border SELECTED_BORDER = new LineBorder(Color.BLUE, 1, true);
        protected static Dimension s_PreferredDimension_NULL = new Dimension(0, 0);
        protected Dimension m_PreferredDimension = new Dimension(40, 28);
        protected JLabelBackground m_JLabelBackground = new JLabelBackground();
        protected Color m_Color_Input;
        protected Color m_Color_Output;
        protected boolean m_ShowNUll;

        public DMXUniverseCellRenderer() {
            this.m_JLabelBackground.setBackgroundStyle(1);
            this.m_JLabelBackground.setBackgroundGradientAngle(90);
            this.m_Color_Input = Color.WHITE;
            this.m_Color_Output = Color.WHITE;
            this.m_JLabelBackground.setBackgroundGradientColorFrom(this.m_Color_Input);
            this.m_JLabelBackground.setBackgroundGradientColorTo(this.m_Color_Output);
            this.m_JLabelBackground.setBackgroundOpaque(true);
            this.m_ShowNUll = true;
        }

        public void setShowNULL(boolean p_ShowNull) {
            this.m_ShowNUll = p_ShowNull;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setComponentOrientation(list.getComponentOrientation());
            boolean boolInputConnected = false;
            boolean boolOutputConnected = false;
            Color o_Background = null;
            Color o_Foreground = null;
            o_Background = list.getBackground();
            o_Foreground = list.getForeground();
            if (isSelected) {
                if (list.hasFocus()) {
                    o_Background = UIManager.getColor("List.selectionBackground");
                    o_Foreground = UIManager.getColor("List.selectionForeground");
                } else {
                    o_Background = UIManager.getColor("List.selectionInactiveBackground");
                    o_Foreground = UIManager.getColor("List.selectionInactiveForeground");
                }
            }
            this.setForeground(o_Foreground);
            this.setBackground(o_Background);
            this.m_JLabelBackground.setForeground(o_Foreground);
            this.m_JLabelBackground.setBackground(o_Background);
            if (value instanceof Icon) {
                this.m_JLabelBackground.setIcon((Icon)value);
                this.m_JLabelBackground.setText("");
            } else {
                String stringUniverseToolTip;
                String stringUniverseName;
                this.m_JLabelBackground.setIcon(null);
                if (value == null || !(value instanceof DMXUniverse)) {
                    stringUniverseName = "---";
                    stringUniverseToolTip = null;
                    if (!this.m_ShowNUll) {
                        this.m_JLabelBackground.setPreferredSize(s_PreferredDimension_NULL);
                        this.m_JLabelBackground.setIcon(null);
                        this.m_JLabelBackground.setBorder(null);
                        this.m_JLabelBackground.setEnabled(false);
                        return this.m_JLabelBackground;
                    }
                    this.m_JLabelBackground.setPreferredSize(this.m_PreferredDimension);
                    this.m_Color_Input = Color.BLACK;
                    this.m_Color_Output = Color.BLACK;
                } else {
                    this.m_JLabelBackground.setIcon(s_Icon);
                    if (s_Icon != null && s_Icon.getIconHeight() < this.m_PreferredDimension.height) {
                        this.m_JLabelBackground.setPreferredSize(this.m_PreferredDimension);
                    }
                    DMXUniverse o_DMXUniverse = (DMXUniverse)value;
                    stringUniverseName = o_DMXUniverse.getName();
                    stringUniverseToolTip = o_DMXUniverse.getToolTipText();
                    if (o_DMXUniverse.getDMXHardwarePlugin_Output() != null) {
                        boolOutputConnected = true;
                        switch (o_DMXUniverse.getConnectionStatus_Output()) {
                            case 0: {
                                this.m_Color_Output = DMXHardwareInterface.COLOR_CONNECTIONSTATUS_NOHARDWARE;
                                this.setBackground(DMXHardwareInterface.COLOR_CONNECTIONSTATUS_NOHARDWARE);
                                break;
                            }
                            case 1: {
                                this.m_Color_Output = DMXHardwareInterface.COLOR_CONNECTIONSTATUS_NOTCONFIGURED;
                                this.setBackground(DMXHardwareInterface.COLOR_CONNECTIONSTATUS_NOTCONFIGURED);
                                break;
                            }
                            case 2: {
                                this.m_Color_Output = DMXHardwareInterface.COLOR_CONNECTIONSTATUS_NOTCONNECTED;
                                this.setBackground(DMXHardwareInterface.COLOR_CONNECTIONSTATUS_NOTCONNECTED);
                                break;
                            }
                            case 3: {
                                this.m_Color_Output = DMXHardwareInterface.COLOR_CONNECTIONSTATUS_PROGRESS;
                                this.setBackground(DMXHardwareInterface.COLOR_CONNECTIONSTATUS_PROGRESS);
                                break;
                            }
                            case 4: {
                                this.m_Color_Output = DMXHardwareInterface.COLOR_CONNECTIONSTATUS_CONNECTED;
                                this.setBackground(DMXHardwareInterface.COLOR_CONNECTIONSTATUS_CONNECTED);
                                break;
                            }
                            case 5: {
                                this.m_Color_Output = DMXHardwareInterface.COLOR_CONNECTIONSTATUS_CHECKED;
                                this.setBackground(DMXHardwareInterface.COLOR_CONNECTIONSTATUS_CHECKED);
                                break;
                            }
                            case 6: {
                                this.m_Color_Output = DMXHardwareInterface.COLOR_CONNECTIONSTATUS_SOMECHECKED;
                                this.setBackground(DMXHardwareInterface.COLOR_CONNECTIONSTATUS_SOMECHECKED);
                                break;
                            }
                            default: {
                                this.m_Color_Output = Color.BLACK;
                                this.setBackground(Color.BLACK);
                                break;
                            }
                        }
                    } else {
                        this.m_Color_Output = Color.BLACK;
                        this.setBackground(DMXHardwareInterface.COLOR_CONNECTIONSTATUS_NOHARDWARE);
                    }
                    if (o_DMXUniverse.getDMXHardwarePlugin_Input() != null) {
                        boolInputConnected = true;
                        switch (o_DMXUniverse.getConnectionStatus_Input()) {
                            case 0: {
                                this.m_Color_Input = DMXHardwareInterface.COLOR_CONNECTIONSTATUS_NOHARDWARE;
                                this.setBackground(DMXHardwareInterface.COLOR_CONNECTIONSTATUS_NOHARDWARE);
                                break;
                            }
                            case 1: {
                                this.m_Color_Input = DMXHardwareInterface.COLOR_CONNECTIONSTATUS_NOTCONFIGURED;
                                this.setBackground(DMXHardwareInterface.COLOR_CONNECTIONSTATUS_NOTCONFIGURED);
                                break;
                            }
                            case 2: {
                                this.m_Color_Input = DMXHardwareInterface.COLOR_CONNECTIONSTATUS_NOTCONNECTED;
                                this.setBackground(DMXHardwareInterface.COLOR_CONNECTIONSTATUS_NOTCONNECTED);
                                break;
                            }
                            case 3: {
                                this.m_Color_Input = DMXHardwareInterface.COLOR_CONNECTIONSTATUS_PROGRESS;
                                this.setBackground(DMXHardwareInterface.COLOR_CONNECTIONSTATUS_PROGRESS);
                                break;
                            }
                            case 4: {
                                this.m_Color_Input = DMXHardwareInterface.COLOR_CONNECTIONSTATUS_CONNECTED;
                                this.setBackground(DMXHardwareInterface.COLOR_CONNECTIONSTATUS_CONNECTED);
                                break;
                            }
                            case 5: {
                                this.m_Color_Input = DMXHardwareInterface.COLOR_CONNECTIONSTATUS_CHECKED;
                                this.setBackground(DMXHardwareInterface.COLOR_CONNECTIONSTATUS_CHECKED);
                                break;
                            }
                            case 6: {
                                this.m_Color_Input = DMXHardwareInterface.COLOR_CONNECTIONSTATUS_SOMECHECKED;
                                this.setBackground(DMXHardwareInterface.COLOR_CONNECTIONSTATUS_SOMECHECKED);
                                break;
                            }
                            default: {
                                this.m_Color_Input = Color.BLACK;
                                this.setBackground(Color.BLACK);
                                break;
                            }
                        }
                    } else {
                        this.m_Color_Input = Color.BLACK;
                        this.setBackground(DMXHardwareInterface.COLOR_CONNECTIONSTATUS_NOHARDWARE);
                    }
                }
                this.m_JLabelBackground.setBackgroundGradientColorFrom(this.m_Color_Input);
                this.m_JLabelBackground.setBackgroundGradientColorTo(this.m_Color_Output);
                if (!boolOutputConnected || boolInputConnected) {
                    // empty if block
                }
                this.m_JLabelBackground.setText(stringUniverseName);
                this.m_JLabelBackground.setToolTipText(stringUniverseToolTip);
            }
            this.m_JLabelBackground.setEnabled(list.isEnabled());
            this.m_JLabelBackground.setFont(list.getFont());
            Border border = null;
            if (isSelected) {
                border = SELECTED_BORDER;
            }
            if (border == null) {
                border = this.getNoFocusBorder();
            }
            this.m_JLabelBackground.setBorder(border);
            return this.m_JLabelBackground;
        }

        private Border getNoFocusBorder() {
            Border border = null;
            if (System.getSecurityManager() != null) {
                if (border != null) {
                    return border;
                }
                return SAFE_NO_FOCUS_BORDER;
            }
            if (border != null && (noFocusBorder == null || noFocusBorder == DEFAULT_NO_FOCUS_BORDER)) {
                return border;
            }
            return noFocusBorder;
        }
    }

    public class DMXUniverseIO
    implements Runnable {
        private DMXUniverse m_DMXUniverse;
        private boolean m_ThreadExit;
        private final Object m_SyncAnswer = new Object();
        private final Object m_Sync_HardwareActions = new Object();
        private ArrayList<DMXChannel> m_DMXChannelsUsed_ToAdd;
        private boolean m_MustWriteMaxChannel;
        private ArrayList<Integer> m_ArrayListActions;
        private int[] m_ValuesHardware_Output;
        private int[] m_ValuesHardware_Input;

        public DMXUniverseIO(DMXUniverse p_DMXUniverse) {
            this.initMembers();
            this.m_DMXUniverse = p_DMXUniverse;
        }

        private void initMembers() {
            this.m_ThreadExit = false;
            this.m_ArrayListActions = new ArrayList();
            this.m_DMXChannelsUsed_ToAdd = new ArrayList();
            this.m_DMXUniverse = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            DMXHardwarePluginInterface o_DMXHardwarePluginInterface;
            this.m_ThreadExit = true;
            Object object = this.m_Sync_HardwareActions;
            synchronized (object) {
                this.m_Sync_HardwareActions.notifyAll();
            }
            try {
                if (Thread.currentThread() != DMXUniverse.this.m_DMXUniverseIOThread && DMXUniverse.this.m_DMXUniverseIOThread != null) {
                    DMXUniverse.this.m_DMXUniverseIOThread.join(2000L);
                }
            }
            catch (InterruptedException e_InterruptedException) {
                System.out.println("DMXUniverse close() error " + e_InterruptedException.getMessage());
            }
            Object object2 = DMXUniverse.this.m_SyncHardwarePlugin;
            synchronized (object2) {
                o_DMXHardwarePluginInterface = DMXUniverse.this.m_DMXHdwPluginInterface_Output;
            }
            if (o_DMXHardwarePluginInterface != null) {
                o_DMXHardwarePluginInterface.requestDMXPlugConnection(null);
            }
            this.m_DMXUniverse = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doReadValues() {
            Object object = this.m_Sync_HardwareActions;
            synchronized (object) {
                if (this.m_ArrayListActions.contains(3)) {
                    return;
                }
                this.m_ArrayListActions.add(3);
                this.m_Sync_HardwareActions.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doWriteValues() {
            Object object = this.m_Sync_HardwareActions;
            synchronized (object) {
                if (this.m_ArrayListActions.contains(6)) {
                    return;
                }
                this.m_ArrayListActions.add(6);
                this.m_Sync_HardwareActions.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doAddChannelUsed(DMXChannel p_DMXChannel) {
            if (p_DMXChannel == null) {
                return;
            }
            Object object = DMXUniverse.this.m_SyncChannelUsed;
            synchronized (object) {
                this.m_DMXChannelsUsed_ToAdd.add(p_DMXChannel);
            }
            this.m_MustWriteMaxChannel = true;
            this.doWriteValues();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doRemoveChannelUsed(DMXChannel p_DMXChannel) {
            if (p_DMXChannel == null) {
                return;
            }
            Object object = DMXUniverse.this.m_SyncChannelUsed;
            synchronized (object) {
                if (p_DMXChannel.getDMXDeviceInternalChannelCount() > 0) {
                    return;
                }
            }
            this.m_MustWriteMaxChannel = true;
            this.doWriteValues();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ArrayList<Integer> o_ArrayListChangedDMXChannels = new ArrayList<Integer>(512);
            DMXHardwareInterface o_DMXHardwareInterface = null;
            DMXHardwarePluginInterface o_DMXHdwPluginInterface_Output = null;
            DMXHardwarePluginInterface o_DMXHdwPluginInterface_Input = null;
            while (!this.m_ThreadExit) {
                boolean boolConnected_Input;
                boolean boolConnected_Output;
                int intAction = 0;
                o_ArrayListChangedDMXChannels.clear();
                Object object = this.m_Sync_HardwareActions;
                synchronized (object) {
                    if (this.m_ArrayListActions.size() <= 0) {
                        try {
                            this.m_Sync_HardwareActions.wait();
                            continue;
                        }
                        catch (InterruptedException e_InterruptedException) {
                            System.out.println("DMXUniverseIO run() wait error " + e_InterruptedException.getMessage());
                        }
                    }
                    intAction = this.m_ArrayListActions.get(0);
                    this.m_ArrayListActions.remove(0);
                }
                object = DMXUniverse.this.m_SyncHardwarePlugin;
                synchronized (object) {
                    boolConnected_Output = false;
                    boolConnected_Input = false;
                    o_DMXHdwPluginInterface_Output = DMXUniverse.this.m_DMXHdwPluginInterface_Output;
                    if (o_DMXHdwPluginInterface_Output != null && (o_DMXHardwareInterface = o_DMXHdwPluginInterface_Output.getDMXHardwareInterface()) != null && (o_DMXHdwPluginInterface_Output.getConnectionStatus() == 5 || o_DMXHdwPluginInterface_Output.getConnectionStatus() == 6)) {
                        boolConnected_Output = true;
                    }
                    this.m_ValuesHardware_Output = boolConnected_Output && o_DMXHdwPluginInterface_Output != null ? o_DMXHdwPluginInterface_Output.getDMXPluginValues() : DMXUniverse.this.m_NewValues;
                    o_DMXHdwPluginInterface_Input = DMXUniverse.this.m_DMXHdwPluginInterface_Input;
                    if (o_DMXHdwPluginInterface_Input != null && (o_DMXHardwareInterface = o_DMXHdwPluginInterface_Input.getDMXHardwareInterface()) != null && (o_DMXHdwPluginInterface_Input.getConnectionStatus() == 5 || o_DMXHdwPluginInterface_Input.getConnectionStatus() == 6)) {
                        boolConnected_Input = true;
                    }
                    this.m_ValuesHardware_Input = boolConnected_Input && o_DMXHdwPluginInterface_Input != null ? o_DMXHdwPluginInterface_Input.getDMXPluginValues() : DMXUniverse.this.m_NewValues;
                }
                switch (intAction) {
                    case 0: {
                        break;
                    }
                    case 3: {
                        DMXChannel o_DMXChannel;
                        intAction = 0;
                        for (int intAddress = 0; intAddress < DMXUniverse.this.m_DMXChannels.size(); ++intAddress) {
                            o_DMXChannel = (DMXChannel)DMXUniverse.this.m_DMXChannels.get(intAddress);
                            if (o_DMXChannel == null) continue;
                            o_ArrayListChangedDMXChannels.add(intAddress);
                        }
                        if (o_ArrayListChangedDMXChannels.size() <= 0) break;
                        intAction = 3;
                        if (!boolConnected_Input || o_DMXHdwPluginInterface_Input == null || o_DMXHdwPluginInterface_Input.getDMXPluginType() != 1) break;
                        o_DMXHdwPluginInterface_Input.requestReadValues(o_ArrayListChangedDMXChannels);
                        break;
                    }
                    case 4: {
                        intAction = 0;
                        this.fetchHardwareValues_Read(o_DMXHdwPluginInterface_Input);
                        break;
                    }
                    case 5: {
                        intAction = 0;
                        this.fetchHardwareValues_Read(o_DMXHdwPluginInterface_Output);
                        break;
                    }
                    case 6: {
                        DMXChannel o_DMXChannel;
                        intAction = 0;
                        Object object2 = DMXUniverse.this.m_SyncChannelUsed;
                        synchronized (object2) {
                            for (int intChannel = 0; intChannel < DMXUniverse.this.m_DMXChannelsUsed.size(); ++intChannel) {
                                o_DMXChannel = (DMXChannel)DMXUniverse.this.m_DMXChannelsUsed.get(intChannel);
                                if (o_DMXChannel == null) continue;
                                int intAddress = o_DMXChannel.getDMXAddress();
                                if (boolConnected_Output && this.m_ValuesHardware_Output != null && intAddress < this.m_ValuesHardware_Output.length && DMXUniverse.this.m_NewValues[intAddress] != this.m_ValuesHardware_Output[intAddress] || !boolConnected_Output && DMXUniverse.this.m_NewValues[intAddress] != o_DMXChannel.getValueInterface()) {
                                    o_ArrayListChangedDMXChannels.add(intAddress);
                                    for (int intPatch = 0; intPatch < DMXUniverse.this.getDMXUniverseInputPatch_OutputCount(); ++intPatch) {
                                        DMXUniverseInputPatch o_DMXUniverseInputPatch_Output = DMXUniverse.this.getDMXUniverseInputPatch_Output(intPatch);
                                        if (o_DMXUniverseInputPatch_Output == null) continue;
                                        o_DMXUniverseInputPatch_Output.eventChannelWritten(this.m_DMXUniverse, o_DMXChannel);
                                    }
                                }
                                if (o_DMXChannel.getDMXDeviceInternalChannelCount() > 0) continue;
                                DMXUniverse.this.m_DMXChannelsUsed.remove(o_DMXChannel);
                                this.m_MustWriteMaxChannel = true;
                                --intChannel;
                            }
                            if (this.m_DMXChannelsUsed_ToAdd.size() > 0) {
                                for (int intDMXChannel = 0; intDMXChannel < this.m_DMXChannelsUsed_ToAdd.size(); ++intDMXChannel) {
                                    DMXChannel o_DMXChannelToAdd = this.m_DMXChannelsUsed_ToAdd.get(intDMXChannel);
                                    DMXUniverse.this.finishAddDMXChannelUsed(o_DMXChannelToAdd);
                                }
                                this.m_DMXChannelsUsed_ToAdd.clear();
                                this.m_MustWriteMaxChannel = true;
                            }
                        }
                        if (this.m_MustWriteMaxChannel && boolConnected_Output) {
                            DMXChannel o_DMXChannelLast;
                            if (DMXUniverse.this.m_DMXChannelsUsed.size() > 0 && (o_DMXChannelLast = (DMXChannel)DMXUniverse.this.m_DMXChannelsUsed.get(DMXUniverse.this.m_DMXChannelsUsed.size() - 1)) != null) {
                                int intMaxAddress = o_DMXChannelLast.getDMXAddress();
                                if (o_ArrayListChangedDMXChannels.size() <= 0 || intMaxAddress != (Integer)o_ArrayListChangedDMXChannels.get(o_ArrayListChangedDMXChannels.size() - 1)) {
                                    o_ArrayListChangedDMXChannels.add(intMaxAddress);
                                }
                            }
                            this.m_MustWriteMaxChannel = false;
                        }
                        if (o_ArrayListChangedDMXChannels.size() <= 0) break;
                        intAction = 6;
                        if (!boolConnected_Output || o_DMXHdwPluginInterface_Output == null || o_DMXHdwPluginInterface_Output.getDMXPluginType() != 0) break;
                        o_DMXHdwPluginInterface_Output.requestWriteValues(o_ArrayListChangedDMXChannels, DMXUniverse.this.m_NewValues);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sendAnswerReadValues(DMXHardwareInterface p_DMXHardwareInterface, DMXHardwarePluginInterface p_DMXHardwarePluginInterface, int[] p_AllInterfaceValues) {
            Object object = this.m_Sync_HardwareActions;
            synchronized (object) {
                if (p_DMXHardwarePluginInterface == DMXUniverse.this.m_DMXHdwPluginInterface_Input) {
                    if (this.m_ArrayListActions.contains(4)) {
                        return;
                    }
                    this.m_ArrayListActions.add(4);
                    this.m_Sync_HardwareActions.notifyAll();
                } else if (p_DMXHardwarePluginInterface == DMXUniverse.this.m_DMXHdwPluginInterface_Output) {
                    if (this.m_ArrayListActions.contains(5)) {
                        return;
                    }
                    this.m_ArrayListActions.add(5);
                    this.m_Sync_HardwareActions.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sendAnswerWriteValues(DMXHardwareInterface p_DMXHardwareInterface, DMXHardwarePluginInterface p_DMXHardwarePluginInterface, int[] p_AllInterfaceValues) {
            Object object = this.m_Sync_HardwareActions;
            synchronized (object) {
                this.fetchHardwareValues_Write(p_DMXHardwarePluginInterface);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sendAnswerException(DMXHardwareInterface p_DMXHardwareInterface, DMXHardwarePluginInterface p_DMXHardwarePluginInterface, int p_ExceptionType, final String p_ExceptionString) {
            if (!DMXUniverse.this.m_DebugOn) {
                return;
            }
            Object object = this.m_SyncAnswer;
            synchronized (object) {
                EventQueueHandler.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (DMXUniverse.this.m_DebugOn) {
                            System.err.println(p_ExceptionString);
                        }
                    }
                });
            }
        }

        private void fetchHardwareValues_Write(DMXHardwarePluginInterface p_DMXHardwarePluginInterface) {
            if (p_DMXHardwarePluginInterface != DMXUniverse.this.m_DMXHdwPluginInterface_Output) {
                return;
            }
            int[] o_ArrayValueHardware = this.m_ValuesHardware_Output;
            if (o_ArrayValueHardware == null) {
                return;
            }
            if (DMXUniverse.this.m_DMXChannels == null) {
                return;
            }
            int intValueInterface = 0;
            boolean boolChanged = false;
            for (int intChannel = 0; intChannel < o_ArrayValueHardware.length && intChannel < DMXUniverse.this.m_DMXChannels.size(); ++intChannel) {
                DMXChannel o_DMXChannel = (DMXChannel)DMXUniverse.this.m_DMXChannels.get(intChannel);
                if (o_DMXChannel == null || !o_DMXChannel.setValueInterface(intValueInterface = o_ArrayValueHardware[intChannel])) continue;
                boolChanged = true;
            }
            if (boolChanged) {
                DMXUniverse.this.m_PropertyChangeSupport.firePropertyChange(DMXUniverse.PROP_VALUESHARDWAREINTERFACE_WRITTEN, null, null);
            }
        }

        private void fetchHardwareValues_Read(DMXHardwarePluginInterface p_DMXHardwarePluginInterface) {
            int[] o_ArrayValueHardware = null;
            int intValueInterface = 0;
            boolean boolChangedOutput = false;
            DMXUniverse o_DMXUniverse = this.m_DMXUniverse;
            if (o_DMXUniverse == null) {
                return;
            }
            if (p_DMXHardwarePluginInterface == DMXUniverse.this.m_DMXHdwPluginInterface_Output) {
                o_ArrayValueHardware = this.m_ValuesHardware_Output;
            } else if (p_DMXHardwarePluginInterface == DMXUniverse.this.m_DMXHdwPluginInterface_Input) {
                o_ArrayValueHardware = this.m_ValuesHardware_Input;
            } else {
                return;
            }
            if (o_ArrayValueHardware == null) {
                return;
            }
            if (DMXUniverse.this.m_DMXChannels == null) {
                return;
            }
            if (p_DMXHardwarePluginInterface == DMXUniverse.this.m_DMXHdwPluginInterface_Output) {
                for (int intChannel = 0; intChannel < o_ArrayValueHardware.length && intChannel < DMXUniverse.this.m_DMXChannels.size(); ++intChannel) {
                    DMXChannel o_DMXChannel = (DMXChannel)DMXUniverse.this.m_DMXChannels.get(intChannel);
                    if (o_DMXChannel == null || !o_DMXChannel.setValueInterface(intValueInterface = o_ArrayValueHardware[intChannel])) continue;
                    boolChangedOutput = true;
                }
                if (boolChangedOutput) {
                    DMXUniverse.this.m_PropertyChangeSupport.firePropertyChange(DMXUniverse.PROP_VALUESHARDWAREINTERFACE_READEN, null, null);
                    DMXScene.s_DMXSceneValueContainer_Mixer.writeDMXSceneLight();
                }
            } else {
                DMXUniverseInputPatch o_DMXUniverseInputPatch = o_DMXUniverse.getDMXUniverseInputPatch();
                if (o_DMXUniverseInputPatch == null) {
                    return;
                }
                o_DMXUniverseInputPatch.eventDMXInput(o_ArrayValueHardware);
            }
        }

        public void resetHardwareValues(DMXHardwarePluginInterface p_DMXHardwarePluginInterface) {
            if (DMXUniverse.this.m_DMXChannels == null) {
                return;
            }
            this.m_MustWriteMaxChannel = true;
            boolean boolChanged = false;
            int intConnectionStatus = p_DMXHardwarePluginInterface == null ? 0 : (p_DMXHardwarePluginInterface == DMXUniverse.this.m_DMXHdwPluginInterface_Output ? DMXUniverse.this.getConnectionStatus_Output() : (p_DMXHardwarePluginInterface == DMXUniverse.this.m_DMXHdwPluginInterface_Input ? DMXUniverse.this.getConnectionStatus_Input() : 0));
            if (intConnectionStatus != 5 && intConnectionStatus != 6) {
                for (int intChannel = 0; intChannel < DMXUniverse.this.m_DMXChannels.size(); ++intChannel) {
                    try {
                        if (intChannel >= DMXUniverse.this.m_DMXChannels.size()) break;
                        DMXChannel o_DMXChannel = (DMXChannel)DMXUniverse.this.m_DMXChannels.get(intChannel);
                        if (o_DMXChannel == null || !o_DMXChannel.setValueInterface(0)) continue;
                        boolChanged = true;
                        continue;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (boolChanged) {
                    DMXUniverse.this.m_PropertyChangeSupport.firePropertyChange(DMXUniverse.PROP_VALUESHARDWAREINTERFACE_WRITTEN, null, null);
                }
            } else if (intConnectionStatus == 5 || intConnectionStatus == 6) {
                if (p_DMXHardwarePluginInterface == DMXUniverse.this.m_DMXHdwPluginInterface_Output) {
                    this.doWriteValues();
                } else if (p_DMXHardwarePluginInterface == DMXUniverse.this.m_DMXHdwPluginInterface_Input) {
                    this.sendAnswerReadValues(DMXUniverse.this.m_DMXHdwPluginInterface_Input.getDMXHardwareInterface(), DMXUniverse.this.m_DMXHdwPluginInterface_Input, DMXUniverse.this.m_DMXHdwPluginInterface_Input.getDMXPluginValues());
                }
            }
        }
    }
}

