/*
 * Decompiled with CFR 0.152.
 */
package DMX512;

import DMX512.DMXUniverse;
import DMXDevicePackage.DMXDevice;
import LiveShowObjectPackage.SinglePropertyChangeSupport;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;

public class DMXChannel {
    public static final String PROP_DMXCHANNEL_VALUENEW = "dmxchannelValueNew";
    public static final String PROP_DMXCHANNEL_VALUEORIGINAL = "dmxchannelValueOriginal";
    public static final String PROP_DMXCHANNEL_VALUENEWREVISED = "dmxchannelValueNewRevised";
    public static final String PROP_DMXCHANNEL_VALUEINTERFACE = "dmxchannelValueInterface";
    public static final String PROP_DMXCHANNEL_VALUEINTERFACE_INPUT = "dmxchannelValueInterfaceInput";
    public static final String PROP_DMXCHANNEL_VALUEFACTOR = "dmxchannelValueFactor";
    private DMXUniverse m_DMXUniverse;
    private int m_DMXAddress;
    private int m_ValueOriginal;
    private int m_ValueNew;
    private int m_ValueMinimum;
    private int m_ValueMaximum;
    private int m_ValueRevised;
    private double m_ValueFactor;
    private int m_ValueInterface;
    private int m_ValueInterface_Input;
    private int m_UsedCount;
    private SinglePropertyChangeSupport m_PropertyChangeSupport;
    private final Object m_SyncChannelListener = new Object();
    private ArrayList<DMXDevice.InternalChannel> m_DMXDeviceInternalChannels;

    public DMXChannel(DMXUniverse p_DMXUniverse, int p_Address) {
        this.initMembers();
        this.m_DMXAddress = p_Address;
        this.m_DMXUniverse = p_DMXUniverse;
        this.addPropertyChangeListener(p_DMXUniverse);
    }

    private void initMembers() {
        this.m_PropertyChangeSupport = new SinglePropertyChangeSupport(this);
        this.m_ValueOriginal = 0;
        this.m_ValueInterface = this.m_ValueNew = 0;
        this.m_ValueInterface_Input = this.m_ValueNew;
        this.m_ValueRevised = this.m_ValueNew;
        this.m_ValueMinimum = 0;
        this.m_ValueMaximum = 255;
        this.m_ValueFactor = 1.0;
        this.m_UsedCount = 0;
        this.m_DMXDeviceInternalChannels = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.m_SyncChannelListener;
        synchronized (object) {
            if (this.m_PropertyChangeSupport != null) {
                this.m_PropertyChangeSupport.clear();
            }
        }
        if (this.m_DMXUniverse != null) {
            this.removePropertyChangeListener(this.m_DMXUniverse);
            this.m_DMXUniverse = null;
        }
    }

    public void finalize() throws Throwable {
        super.finalize();
        this.m_PropertyChangeSupport = null;
    }

    public DMXUniverse getDMXUniverse() {
        return this.m_DMXUniverse;
    }

    public int getDMXAddress() {
        return this.m_DMXAddress;
    }

    public boolean setValue(int p_Value, int p_ValueMinimum, int p_ValueMaximum, double p_ValueFactor) {
        int intOldValue;
        boolean boolChanged = false;
        if (p_Value < 0) {
            p_Value = 0;
        }
        if (p_Value > 255) {
            p_Value = 255;
        }
        if (p_ValueMinimum < 0) {
            p_ValueMinimum = 0;
        }
        if (p_ValueMinimum > 255) {
            p_ValueMinimum = 255;
        }
        if (this.m_ValueMinimum != p_ValueMinimum) {
            intOldValue = this.m_ValueMinimum;
            this.m_ValueMinimum = p_ValueMinimum;
            boolChanged = true;
        }
        if (p_ValueMaximum < 0) {
            p_ValueMaximum = 0;
        }
        if (p_ValueMaximum > 255) {
            p_ValueMaximum = 255;
        }
        if (this.m_ValueMaximum != p_ValueMaximum) {
            intOldValue = this.m_ValueMaximum;
            this.m_ValueMaximum = p_ValueMaximum;
            boolChanged = true;
        }
        if (p_Value < 0) {
            p_Value = 0;
        }
        if (p_Value > 255) {
            p_Value = 255;
        }
        if (this.m_ValueNew != p_Value) {
            intOldValue = this.m_ValueNew;
            this.m_ValueNew = p_Value;
            this.firePropertyChange(PROP_DMXCHANNEL_VALUENEW, intOldValue, this.m_ValueNew);
            boolChanged = true;
        }
        if (p_ValueFactor < 0.0) {
            p_ValueFactor = 0.0;
        }
        if (p_ValueFactor > 1.0) {
            p_ValueFactor = 1.0;
        }
        if (this.m_ValueFactor != p_ValueFactor) {
            double doubleOldValueFactor = this.m_ValueFactor;
            this.m_ValueFactor = p_ValueFactor;
            if (this.m_PropertyChangeSupport != null) {
                this.m_PropertyChangeSupport.firePropertyChange(PROP_DMXCHANNEL_VALUEFACTOR, doubleOldValueFactor, this.m_ValueFactor);
            }
            boolChanged = true;
        }
        if (!boolChanged) {
            return false;
        }
        int intValueRevised = this.m_ValueNew;
        if ((intValueRevised = (int)((double)intValueRevised * this.m_ValueFactor + 0.5)) < this.m_ValueMinimum) {
            intValueRevised = this.m_ValueMinimum;
        }
        if (intValueRevised > this.m_ValueMaximum) {
            intValueRevised = this.m_ValueMaximum;
        }
        if (this.m_ValueRevised == intValueRevised) {
            return false;
        }
        intOldValue = this.m_ValueRevised;
        this.m_ValueRevised = intValueRevised;
        if (intOldValue != this.m_ValueRevised && this.m_PropertyChangeSupport != null) {
            this.m_PropertyChangeSupport.firePropertyChange(PROP_DMXCHANNEL_VALUENEWREVISED, intOldValue, this.m_ValueRevised);
        }
        return true;
    }

    public boolean setValueChannel(int p_ValueOriginal, int p_ValueValidated) {
        this.m_ValueOriginal = p_ValueOriginal;
        return this.setValue(p_ValueValidated, this.m_ValueMinimum, this.m_ValueMaximum, this.m_ValueFactor);
    }

    public int getValueOriginal() {
        return this.m_ValueOriginal;
    }

    public int getValueNew() {
        return this.m_ValueNew;
    }

    public int getValueRevised() {
        return this.m_ValueRevised;
    }

    public boolean setValueMinimum(int p_ValueMinimum) {
        return this.setValue(this.m_ValueNew, p_ValueMinimum, this.m_ValueMaximum, this.m_ValueFactor);
    }

    public int getValueMinimum() {
        return this.m_ValueMinimum;
    }

    public boolean setValueMaximum(int p_ValueMaximum) {
        return this.setValue(this.m_ValueNew, this.m_ValueMinimum, p_ValueMaximum, this.m_ValueFactor);
    }

    public int getValueMaximum() {
        return this.m_ValueMinimum;
    }

    public boolean setValueFactor(double p_Factor) {
        return this.setValue(this.m_ValueNew, this.m_ValueMinimum, this.m_ValueMaximum, p_Factor);
    }

    public double getValueFactor() {
        return this.m_ValueFactor;
    }

    public boolean setValueInterface(int p_Value) {
        if (p_Value < 0) {
            p_Value = 0;
        }
        if (p_Value > 255) {
            p_Value = 255;
        }
        if (p_Value == this.m_ValueInterface) {
            return false;
        }
        int intOldValue = this.m_ValueInterface;
        this.m_ValueInterface = p_Value;
        this.firePropertyChange(PROP_DMXCHANNEL_VALUEINTERFACE, intOldValue, this.m_ValueInterface);
        return true;
    }

    public int getValueInterface() {
        return this.m_ValueInterface;
    }

    public boolean setValueInterface_Input(int p_Value, boolean p_ForceChange) {
        int intOldValue;
        if (p_Value < 0) {
            p_Value = 0;
        }
        if (p_Value > 255) {
            p_Value = 255;
        }
        if (!p_ForceChange) {
            if (p_Value == this.m_ValueInterface_Input) {
                return false;
            }
            intOldValue = this.m_ValueInterface_Input;
            this.m_ValueInterface_Input = p_Value;
        } else {
            this.m_ValueInterface_Input = p_Value;
            if (this.m_ValueOriginal == this.m_ValueInterface_Input) {
                return false;
            }
            intOldValue = this.m_ValueOriginal;
        }
        this.firePropertyChange(PROP_DMXCHANNEL_VALUEINTERFACE_INPUT, intOldValue, this.m_ValueInterface_Input);
        return true;
    }

    public int getValueInterface_Input() {
        return this.m_ValueInterface_Input;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
        Object object = this.m_SyncChannelListener;
        synchronized (object) {
            if (this.m_PropertyChangeSupport != null) {
                this.m_PropertyChangeSupport.addPropertyChangeListener(p_PropertyChangeListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(String p_PropertyName, PropertyChangeListener p_PropertyChangeListener) {
        Object object = this.m_SyncChannelListener;
        synchronized (object) {
            if (this.m_PropertyChangeSupport != null) {
                this.m_PropertyChangeSupport.addPropertyChangeListener(p_PropertyName, p_PropertyChangeListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
        Object object = this.m_SyncChannelListener;
        synchronized (object) {
            if (this.m_PropertyChangeSupport != null) {
                this.m_PropertyChangeSupport.removePropertyChangeListener(p_PropertyChangeListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(String p_PropertyName, PropertyChangeListener p_PropertyChangeListener) {
        Object object = this.m_SyncChannelListener;
        synchronized (object) {
            if (this.m_PropertyChangeSupport != null) {
                this.m_PropertyChangeSupport.removePropertyChangeListener(p_PropertyName, p_PropertyChangeListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void firePropertyChange(String p_PropertyName, int p_OldValue, int p_NewValue) {
        SinglePropertyChangeSupport o_PropertyChangeSupport;
        Object object = this.m_SyncChannelListener;
        synchronized (object) {
            if (this.m_PropertyChangeSupport == null) {
                return;
            }
            o_PropertyChangeSupport = this.m_PropertyChangeSupport;
        }
        if (o_PropertyChangeSupport != null) {
            o_PropertyChangeSupport.firePropertyChange(p_PropertyName, p_OldValue, p_NewValue);
        }
    }

    public void addDMXDeviceInternalChannel(DMXDevice.InternalChannel p_InternalChannel) {
        if (p_InternalChannel == null) {
            return;
        }
        if (this.m_DMXDeviceInternalChannels == null) {
            return;
        }
        if (this.m_DMXDeviceInternalChannels.contains(p_InternalChannel)) {
            return;
        }
        this.m_DMXDeviceInternalChannels.add(p_InternalChannel);
        if (this.m_DMXUniverse != null) {
            this.m_DMXUniverse.addDMXChannelUsed(this);
        }
    }

    public void removeDMXDeviceInternalChannel(DMXDevice.InternalChannel p_InternalChannel, boolean p_KeepValues) {
        if (p_InternalChannel == null) {
            return;
        }
        if (this.m_DMXDeviceInternalChannels == null) {
            return;
        }
        if (!this.m_DMXDeviceInternalChannels.contains(p_InternalChannel)) {
            return;
        }
        this.m_DMXDeviceInternalChannels.remove(p_InternalChannel);
        if (this.m_DMXDeviceInternalChannels.size() <= 0) {
            if (!p_KeepValues) {
                this.setValueChannel(0, 0);
                this.setValueFactor(1.0);
            }
            if (this.m_DMXUniverse != null) {
                this.m_DMXUniverse.removeDMXChannelUsed(this);
            }
        }
    }

    public ArrayList<DMXDevice.InternalChannel> getDMXDeviceInternalChannels() {
        return this.m_DMXDeviceInternalChannels;
    }

    public int getDMXDeviceInternalChannelCount() {
        return this.m_DMXDeviceInternalChannels.size();
    }
}

