/*
 * Decompiled with CFR 0.152.
 */
package ToolPackage;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicScrollBarUI;

public class SwingUI {

    public static class MyScrollBarUI
    extends BasicScrollBarUI {
        public static Color COLOR_TRACK = Color.BLACK;
        public static Color COLOR_THUMB = Color.DARK_GRAY;
        public static Color COLOR_THUMBBORDER = Color.LIGHT_GRAY;
        public static Color COLOR_BUTTON = Color.LIGHT_GRAY;

        public static ComponentUI createUI(JComponent c) {
            return new MyScrollBarUI();
        }

        @Override
        public void update(Graphics g, JComponent c) {
            if (c.isOpaque()) {
                g.setColor(c.getBackground());
                g.fillRect(0, 0, c.getWidth(), c.getHeight());
            }
            this.paint(g, c);
        }

        @Override
        public void paint(Graphics g, JComponent c) {
            this.paintTrack(g, c, this.getTrackBounds());
            Rectangle thumbBounds = this.getThumbBounds();
            if (thumbBounds.intersects(g.getClipBounds())) {
                this.paintThumb(g, c, thumbBounds);
            }
        }

        @Override
        protected void paintTrack(Graphics g, JComponent c, Rectangle trackBounds) {
            g.setColor(COLOR_TRACK);
            g.fillRect(trackBounds.x, trackBounds.y, trackBounds.width, trackBounds.height);
        }

        @Override
        protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
            g.setColor(COLOR_THUMB);
            g.fillRect(thumbBounds.x, thumbBounds.y, thumbBounds.width, thumbBounds.height);
            g.setColor(COLOR_THUMBBORDER);
            g.drawRect(thumbBounds.x, thumbBounds.y, thumbBounds.width - 1, thumbBounds.height - 1);
        }

        @Override
        protected JButton createDecreaseButton(int orientation) {
            return new BasicArrowButton(orientation, COLOR_TRACK, COLOR_TRACK, COLOR_BUTTON, COLOR_BUTTON);
        }

        @Override
        protected JButton createIncreaseButton(int orientation) {
            return new BasicArrowButton(orientation, COLOR_TRACK, COLOR_TRACK, COLOR_BUTTON, COLOR_BUTTON);
        }
    }
}

