/*
 * Decompiled with CFR 0.152.
 */
package DMXHardwarePackage;

import ACN_Direct_1_31_Package.ACN_Direct_Data_Bytes;
import ACN_Direct_1_31_Package.ACN_Direct_ProtocolConfiguration_ACN_1_31;
import ArtNetPackage.ArtNet_Op_ArtDMX;
import ArtNetPackage.ProtocolConfiguration_ArtNet;
import DMXHardwarePackage.DMXHardwareInterface;
import DMXHardwarePackage.DMXHardwarePluginFeedbackInterface;
import DMXHardwarePackage.DMXHardwarePluginInterface;
import DMXHardwarePackage.LAN_Device;
import DMXHardwarePackage.LAN_Device_ArtNet;
import DMXHardwarePackage.LAN_Interface;
import DMXHardwarePackage.LAN_Interface_Configuration;
import DMXHardwarePackage.LAN_NetworkInterface;
import DMXHardwarePackage.LAN_PlugIn;
import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LanguageTools.LiveLanguagePackage.LiveLanguageString;
import NetworkTools.NetworkTool;
import ProtocolPackage.Protocols;
import SwingModelPackage.TableAndListModel;
import ToolPackage.JLabelBackground;
import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableRowSorter;

public class LAN_Universe
implements DMXHardwarePluginInterface,
Protocols.ProtocolPlugInInterface,
Protocols.ProtocolReaderInterface,
Externalizable,
PropertyChangeListener {
    public static final int SOFTWAREVERSION = 1;
    private LAN_Interface m_LAN_Interface;
    private DMXHardwarePluginFeedbackInterface m_DMXHardwarePluginFeedbackInterface;
    public static final String PROP_CONNECTIONSTATUS = "prop_connectionstatus";
    public static final String PROP_DMXHARDWAREFEEDBACKINTERFACE = "prop_feedbackinterface";
    private int m_LANUniverseNumber;
    private int m_PlugInType;
    private String m_Key;
    private String m_ToolTipText;
    private int[] m_DMXValues;
    private final Object m_SyncWrite = new Object();
    private ArrayList<LAN_PlugIn> m_LAN_PlugIns;
    private PropertyChangeSupport m_PropertyChangeSupport;
    private final Object m_SyncPlugIn = new Object();
    private HashMap<LAN_NetworkInterface, ACN_Direct_ProtocolConfiguration_ACN_1_31> m_Protocols_SACN;
    private int m_ConnectionStatus;
    private int m_PlugInCount_ArtNet;
    private int m_PlugInCount_sACN;
    private int m_PlugInInputCount_sACN;
    private int m_PlugInOutputCount_sACN;
    private int m_ArtNetSenderSequenceNumber;

    public LAN_Universe(LAN_Interface p_LAN_Interface) {
        this.m_LAN_Interface = p_LAN_Interface;
        this.initMembers();
        LiveLanguage.addLanguageListener(this, LAN_Interface_Configuration.class.getSimpleName());
    }

    public LAN_Universe(LAN_Interface p_LAN_Interface, int p_LANUniverseNumber, int p_PlugInType) {
        this.m_LAN_Interface = p_LAN_Interface;
        this.initMembers();
        this.m_LANUniverseNumber = p_LANUniverseNumber;
        this.m_PlugInType = p_PlugInType;
        this.m_Key = LAN_Universe.calculateKey(this.m_LANUniverseNumber, p_PlugInType);
        for (int intNetwork = 0; intNetwork < this.m_LAN_Interface.getLAN_NetworkInterfaceCount(); ++intNetwork) {
            this.addLAN_NetworkInterface(this.m_LAN_Interface.getLAN_NetworkInterface(intNetwork));
        }
    }

    private void initMembers() {
        this.m_Key = "";
        this.m_LANUniverseNumber = 0;
        this.m_Protocols_SACN = new HashMap();
        this.m_PlugInType = -1;
        this.m_LAN_PlugIns = new ArrayList();
        this.m_ToolTipText = null;
        this.m_PlugInCount_ArtNet = 0;
        this.m_PlugInCount_sACN = 0;
        this.m_PlugInInputCount_sACN = 0;
        this.m_PlugInOutputCount_sACN = 0;
        this.m_PropertyChangeSupport = new PropertyChangeSupport(this);
        this.m_ConnectionStatus = 2;
        this.m_DMXValues = new int[this.m_LAN_Interface.getAddressCount()];
        for (int intValue = 0; intValue < this.m_DMXValues.length; ++intValue) {
            this.m_DMXValues[intValue] = 0;
        }
        this.m_ArtNetSenderSequenceNumber = 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        LAN_Interface o_LAN_Interface;
        Object object = this.m_SyncPlugIn;
        synchronized (object) {
            o_LAN_Interface = this.m_LAN_Interface;
            if (o_LAN_Interface == null) {
                return;
            }
        }
        o_LAN_Interface.requestDMXPlugConnection(this, null);
        this.setDMXHardwarePluginFeedbackInterface(null);
        o_LAN_Interface.removeLAN_Universe(this);
        this.m_LAN_Interface = null;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(1);
        out.writeInt(this.m_LANUniverseNumber);
        out.writeInt(this.m_PlugInType);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int intSoftwareVersion = in.readInt();
        this.m_LANUniverseNumber = in.readInt();
        this.m_PlugInType = in.readInt();
        this.m_Key = LAN_Universe.calculateKey(this.m_LANUniverseNumber, this.m_PlugInType);
        for (int intNetwork = 0; intNetwork < this.m_LAN_Interface.getLAN_NetworkInterfaceCount(); ++intNetwork) {
            this.addLAN_NetworkInterface(this.m_LAN_Interface.getLAN_NetworkInterface(intNetwork));
        }
    }

    public static String calculateKey(int p_LANUniverseNumber, int p_PlugInType) {
        StringBuilder o_StringBuilder = new StringBuilder();
        switch (p_PlugInType) {
            case 1: {
                o_StringBuilder.append("Input");
                break;
            }
            case 0: {
                o_StringBuilder.append("Output");
                break;
            }
            default: {
                o_StringBuilder.append("");
            }
        }
        o_StringBuilder.append("_");
        o_StringBuilder.append(p_LANUniverseNumber);
        return o_StringBuilder.toString();
    }

    public boolean connect() {
        return true;
    }

    public boolean disconnect() {
        return true;
    }

    @Override
    public int getUniverseNumber() {
        return this.m_LANUniverseNumber;
    }

    public String getID() {
        return this.m_Key;
    }

    public String getName() {
        return this.m_Key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLAN_PlugIn(LAN_PlugIn p_LAN_PlugIn) {
        if (p_LAN_PlugIn == null) {
            return;
        }
        Object object = this.m_SyncPlugIn;
        synchronized (object) {
            LAN_Device o_LAN_Device = p_LAN_PlugIn.getLAN_Device();
            if (this.m_LAN_PlugIns.contains(p_LAN_PlugIn)) {
                return;
            }
            this.m_LAN_PlugIns.add(p_LAN_PlugIn);
            if (p_LAN_PlugIn.getProtocolType() == 3) {
                ++this.m_PlugInCount_sACN;
                if (p_LAN_PlugIn.getPlugInType() == 0) {
                    ++this.m_PlugInOutputCount_sACN;
                } else if (p_LAN_PlugIn.getPlugInType() == 1) {
                    ++this.m_PlugInInputCount_sACN;
                }
            } else if (p_LAN_PlugIn.getProtocolType() == 1) {
                ++this.m_PlugInCount_ArtNet;
            }
        }
        this.checkSACNLANProtocols();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLAN_PlugIn(LAN_PlugIn p_LAN_PlugIn) {
        if (p_LAN_PlugIn == null) {
            return;
        }
        boolean boolDelete = false;
        Object object = this.m_SyncPlugIn;
        synchronized (object) {
            if (!this.m_LAN_PlugIns.remove(p_LAN_PlugIn)) {
                return;
            }
            if (this.m_LAN_PlugIns.size() <= 0) {
                boolDelete = true;
            }
            if (p_LAN_PlugIn.getProtocolType() == 3) {
                --this.m_PlugInCount_sACN;
                if (this.m_PlugInCount_sACN < 0) {
                    this.m_PlugInCount_sACN = 0;
                }
                if (p_LAN_PlugIn.getPlugInType() == 0) {
                    --this.m_PlugInOutputCount_sACN;
                    if (this.m_PlugInOutputCount_sACN < 0) {
                        this.m_PlugInOutputCount_sACN = 0;
                    }
                } else if (p_LAN_PlugIn.getPlugInType() == 1) {
                    --this.m_PlugInInputCount_sACN;
                    if (this.m_PlugInInputCount_sACN < 0) {
                        this.m_PlugInInputCount_sACN = 0;
                    }
                }
            }
            if (p_LAN_PlugIn.getProtocolType() == 1) {
                --this.m_PlugInCount_ArtNet;
                if (this.m_PlugInCount_ArtNet < 0) {
                    this.m_PlugInCount_ArtNet = 0;
                }
            }
        }
        this.checkSACNLANProtocols();
        if (boolDelete) {
            this.checkDeleteLAN_Universe();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changedProtocol_LAN_Plugin(LAN_PlugIn p_LAN_PlugIn, int p_OldProtocolType, int p_NewProtocolType) {
        if (p_LAN_PlugIn == null) {
            return;
        }
        Object object = this.m_SyncPlugIn;
        synchronized (object) {
            if (!this.m_LAN_PlugIns.contains(p_LAN_PlugIn)) {
                return;
            }
            if (p_OldProtocolType == 3) {
                --this.m_PlugInCount_sACN;
                if (this.m_PlugInCount_sACN < 0) {
                    this.m_PlugInCount_sACN = 0;
                }
                if (p_LAN_PlugIn.getPlugInType() == 0) {
                    --this.m_PlugInOutputCount_sACN;
                    if (this.m_PlugInOutputCount_sACN < 0) {
                        this.m_PlugInOutputCount_sACN = 0;
                    }
                } else if (p_LAN_PlugIn.getPlugInType() == 1) {
                    --this.m_PlugInInputCount_sACN;
                    if (this.m_PlugInInputCount_sACN < 0) {
                        this.m_PlugInInputCount_sACN = 0;
                    }
                }
            } else if (p_OldProtocolType == 1) {
                --this.m_PlugInCount_ArtNet;
                if (this.m_PlugInCount_ArtNet < 0) {
                    this.m_PlugInCount_ArtNet = 0;
                }
            }
            if (p_LAN_PlugIn.getProtocolType() == 3) {
                ++this.m_PlugInCount_sACN;
                if (p_LAN_PlugIn.getPlugInType() == 0) {
                    ++this.m_PlugInOutputCount_sACN;
                } else if (p_LAN_PlugIn.getPlugInType() == 1) {
                    ++this.m_PlugInInputCount_sACN;
                }
            } else if (p_LAN_PlugIn.getProtocolType() == 1) {
                ++this.m_PlugInCount_ArtNet;
            }
        }
        this.checkSACNLANProtocols();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLAN_PlugInCount() {
        Object object = this.m_SyncPlugIn;
        synchronized (object) {
            return this.m_LAN_PlugIns.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LAN_PlugIn getLAN_PlugIn(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        Object object = this.m_SyncPlugIn;
        synchronized (object) {
            if (p_Index >= this.m_LAN_PlugIns.size()) {
                return null;
            }
            return this.m_LAN_PlugIns.get(p_Index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LAN_PlugIn getLAN_PlugIn_ArtNet(String p_IPAddress) {
        if (p_IPAddress == null) {
            return null;
        }
        Object object = this.m_SyncPlugIn;
        synchronized (object) {
            for (int intPlugIn = 0; intPlugIn < this.m_LAN_PlugIns.size(); ++intPlugIn) {
                LAN_Device_ArtNet o_LAN_Device_ArtNet;
                LAN_PlugIn o_LAN_PlugIn = this.m_LAN_PlugIns.get(intPlugIn);
                LAN_Device o_LAN_Device = o_LAN_PlugIn.getLAN_Device();
                if (o_LAN_Device == null || !(o_LAN_Device instanceof LAN_Device_ArtNet) || !p_IPAddress.equals((o_LAN_Device_ArtNet = (LAN_Device_ArtNet)o_LAN_Device).getRemoteIP())) continue;
                return o_LAN_PlugIn;
            }
        }
        return null;
    }

    public void addLAN_NetworkInterface(LAN_NetworkInterface p_LAN_NetworkInterface) {
        if (p_LAN_NetworkInterface == null) {
            return;
        }
        if (!p_LAN_NetworkInterface.getSelected()) {
            return;
        }
        p_LAN_NetworkInterface.addPropertyChangeListener(this);
        this.checkSACNLANProtocols();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLAN_NetworkInterface(LAN_NetworkInterface p_LAN_NetworkInterface) {
        if (p_LAN_NetworkInterface == null) {
            return;
        }
        Object object = this.m_SyncPlugIn;
        synchronized (object) {
            p_LAN_NetworkInterface.removePropertyChangeListener(this);
            Protocols.ProtocolConfiguration o_ProtocolConfiguration = this.m_Protocols_SACN.get(p_LAN_NetworkInterface);
            if (o_ProtocolConfiguration != null) {
                this.m_Protocols_SACN.remove(p_LAN_NetworkInterface);
            }
        }
        this.checkConnectionStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkSACNLANProtocols() {
        Object object = this.m_SyncPlugIn;
        synchronized (object) {
            LAN_Interface o_LAN_Interface = this.m_LAN_Interface;
            if (o_LAN_Interface == null) {
                return;
            }
            for (int intNetwork = 0; intNetwork < o_LAN_Interface.getLAN_NetworkInterfaceCount(); ++intNetwork) {
                LAN_NetworkInterface o_LAN_NetworkInterface = o_LAN_Interface.getLAN_NetworkInterface(intNetwork);
                if (o_LAN_NetworkInterface == null || !o_LAN_NetworkInterface.getSelected()) continue;
                ACN_Direct_ProtocolConfiguration_ACN_1_31 o_ProtocolConfiguration_ACN_1_31 = this.m_Protocols_SACN.get(o_LAN_NetworkInterface);
                if (this.m_PlugInCount_sACN > 0) {
                    if (o_ProtocolConfiguration_ACN_1_31 == null) {
                        o_ProtocolConfiguration_ACN_1_31 = new ACN_Direct_ProtocolConfiguration_ACN_1_31(o_LAN_Interface);
                        o_ProtocolConfiguration_ACN_1_31.setACNInterpreter(o_LAN_Interface.getACNInterpreter());
                        this.m_Protocols_SACN.put(o_LAN_NetworkInterface, o_ProtocolConfiguration_ACN_1_31);
                    }
                    boolean boolInetAddressesEqual = true;
                    if (!NetworkTool.isEqual(o_ProtocolConfiguration_ACN_1_31.getLocalInetAddress(), o_LAN_NetworkInterface.getInetAddress(0))) {
                        boolInetAddressesEqual = false;
                    }
                    if (boolInetAddressesEqual) continue;
                    o_ProtocolConfiguration_ACN_1_31.disconnect();
                    if (o_LAN_NetworkInterface.getInetAddress(0) == null) continue;
                    o_ProtocolConfiguration_ACN_1_31.setDMXUniverseNumber(this.m_LANUniverseNumber);
                    o_ProtocolConfiguration_ACN_1_31.connect(o_LAN_NetworkInterface.getInetAddress(0), Protocols.ACN_1_31_PORT);
                    continue;
                }
                this.m_Protocols_SACN.remove(o_LAN_NetworkInterface);
                if (o_ProtocolConfiguration_ACN_1_31 == null) continue;
                o_ProtocolConfiguration_ACN_1_31.close();
            }
        }
        this.checkConnectionStatus();
    }

    private void checkDeleteLAN_Universe() {
        if (this.m_LAN_PlugIns.size() <= 0 && this.m_DMXHardwarePluginFeedbackInterface == null) {
            this.close();
        }
    }

    @Override
    public void interpreteACN(ACN_Direct_Data_Bytes p_ACN_Direct_Data_Bytes, InetAddress p_RemoteInetAddressUDP) {
        if (p_ACN_Direct_Data_Bytes == null) {
            return;
        }
        LAN_Interface o_LAN_Interface = this.m_LAN_Interface;
        if (o_LAN_Interface == null) {
            return;
        }
        p_ACN_Direct_Data_Bytes.getDMP_Layer_DMXData(this.m_DMXValues, this.m_DMXValues.length);
        o_LAN_Interface.fireReadValuesSucces(this, this.m_DMXValues);
    }

    @Override
    public void interpreteArtDMX(ArtNet_Op_ArtDMX p_ArtNet_Op_ArtDMX, InetAddress p_RemoteInetAddressUDP) {
        if (p_ArtNet_Op_ArtDMX == null) {
            return;
        }
        LAN_Interface o_LAN_Interface = this.m_LAN_Interface;
        if (o_LAN_Interface == null) {
            return;
        }
        p_ArtNet_Op_ArtDMX.getDMXData(this.m_DMXValues, p_ArtNet_Op_ArtDMX.getLength());
        o_LAN_Interface.fireReadValuesSucces(this, this.m_DMXValues);
    }

    public int[] getDMXValueArray() {
        return this.m_DMXValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeValuesToSACN(ArrayList<Integer> p_ChangedAddresses, int[] p_AllValues) {
        LAN_Interface o_LAN_Interface;
        boolean boolSended = false;
        Object object = this.m_SyncPlugIn;
        synchronized (object) {
            o_LAN_Interface = this.m_LAN_Interface;
        }
        if (o_LAN_Interface == null) {
            return false;
        }
        if (this.m_PlugInOutputCount_sACN <= 0) {
            return false;
        }
        for (int intNetwork = 0; intNetwork < o_LAN_Interface.getLAN_NetworkInterfaceCount(); ++intNetwork) {
            ACN_Direct_ProtocolConfiguration_ACN_1_31 o_ProtocolConfiguration;
            LAN_NetworkInterface o_LAN_NetworkInterface = o_LAN_Interface.getLAN_NetworkInterface(intNetwork);
            if (o_LAN_NetworkInterface == null || !o_LAN_NetworkInterface.getSelected() || (o_ProtocolConfiguration = this.m_Protocols_SACN.get(o_LAN_NetworkInterface)) == null || !o_ProtocolConfiguration.writeValues(this, null, 0, p_ChangedAddresses, p_AllValues)) continue;
            boolSended = true;
        }
        return boolSended;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeValuesToArtNet(ArrayList<Integer> p_ChangedAddresses, int[] p_AllValues) {
        LAN_Interface o_LAN_Interface;
        if (p_AllValues == null) {
            return false;
        }
        Object object = this.m_SyncPlugIn;
        synchronized (object) {
            o_LAN_Interface = this.m_LAN_Interface;
        }
        if (o_LAN_Interface == null) {
            return false;
        }
        boolean boolSended = false;
        for (int intPlugIn = 0; intPlugIn < this.getLAN_PlugInCount(); ++intPlugIn) {
            LAN_Device o_LAN_Device;
            LAN_PlugIn o_LAN_PlugIn = this.getLAN_PlugIn(intPlugIn);
            if (o_LAN_PlugIn == null || o_LAN_PlugIn.getPlugInType() != 0 || o_LAN_PlugIn.getProtocolType() != 1 || (o_LAN_Device = o_LAN_PlugIn.getLAN_Device()) == null || !(o_LAN_Device instanceof LAN_Device_ArtNet)) continue;
            ProtocolConfiguration_ArtNet o_ProtocolConfiguration = ((LAN_Device_ArtNet)o_LAN_Device).getProtocolConfigurationDetected();
            InetAddress o_RemoteInetAddress = ((LAN_Device_ArtNet)o_LAN_Device).getRemoteInetAddress();
            if (o_ProtocolConfiguration == null || !o_ProtocolConfiguration.writeValues(this, o_RemoteInetAddress, this.m_ArtNetSenderSequenceNumber, p_ChangedAddresses, p_AllValues)) continue;
            boolSended = true;
        }
        if (boolSended) {
            ++this.m_ArtNetSenderSequenceNumber;
            if (this.m_ArtNetSenderSequenceNumber > 255) {
                this.m_ArtNetSenderSequenceNumber = 1;
            }
        }
        return boolSended;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setDMXPluginType(int p_DMXPluginType) {
        DMXHardwarePluginFeedbackInterface o_DMXHardwarePluginFeedbackInterface;
        if (p_DMXPluginType != -1 && p_DMXPluginType != 1 && p_DMXPluginType != 0) {
            return false;
        }
        if (p_DMXPluginType < 0) {
            p_DMXPluginType = 0;
        }
        if (this.m_PlugInType == p_DMXPluginType) {
            return true;
        }
        Object object = this.m_SyncPlugIn;
        synchronized (object) {
            this.m_PlugInType = p_DMXPluginType;
            o_DMXHardwarePluginFeedbackInterface = this.m_DMXHardwarePluginFeedbackInterface;
        }
        if (o_DMXHardwarePluginFeedbackInterface != null) {
            o_DMXHardwarePluginFeedbackInterface.eventPluginChanged(this.m_LAN_Interface, this);
        }
        return true;
    }

    public DMXHardwarePluginFeedbackInterface getDMXHardwarePluginFeedbackInterface() {
        return this.m_DMXHardwarePluginFeedbackInterface;
    }

    @Override
    public int getPluginIndex() {
        return this.getUniverseNumber();
    }

    @Override
    public DMXHardwareInterface getDMXHardwareInterface() {
        return this.m_LAN_Interface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkConnectionStatus() {
        LAN_Interface o_LAN_Interface;
        int intConnectionStatus_ACN_1_31 = 2;
        Object object = this.m_SyncPlugIn;
        synchronized (object) {
            o_LAN_Interface = this.m_LAN_Interface;
            if (o_LAN_Interface == null) {
                return;
            }
            for (int intNetwork = 0; intNetwork < o_LAN_Interface.getLAN_NetworkInterfaceCount(); ++intNetwork) {
                ACN_Direct_ProtocolConfiguration_ACN_1_31 o_ProtocolConfiguration_SACN;
                LAN_NetworkInterface o_LAN_NetworkInterface = o_LAN_Interface.getLAN_NetworkInterface(intNetwork);
                if (o_LAN_NetworkInterface == null || !o_LAN_NetworkInterface.getSelected() || (o_ProtocolConfiguration_SACN = this.m_Protocols_SACN.get(o_LAN_NetworkInterface)) == null || o_ProtocolConfiguration_SACN.getConnectionStatus() != 5) continue;
                intConnectionStatus_ACN_1_31 = 5;
            }
        }
        int oldValue = this.m_ConnectionStatus;
        boolean boolSomeChecked = false;
        boolean boolSomeNotChecked = false;
        if (this.getLAN_PlugInCount() <= 0) {
            int intConnectionStatus = 2;
        } else {
            for (int intPlugIn = 0; intPlugIn < this.getLAN_PlugInCount(); ++intPlugIn) {
                int intConnectionStatus;
                LAN_PlugIn o_LAN_PlugIn = this.getLAN_PlugIn(intPlugIn);
                if (o_LAN_PlugIn == null) continue;
                if (o_LAN_PlugIn.getProtocolType() == 3) {
                    o_LAN_PlugIn.setConnectionStatus(intConnectionStatus_ACN_1_31);
                }
                if ((intConnectionStatus = o_LAN_PlugIn.getConnectionStatus()) == 5) {
                    boolSomeChecked = true;
                    continue;
                }
                boolSomeNotChecked = true;
            }
        }
        this.m_ConnectionStatus = !boolSomeChecked ? 2 : (!boolSomeNotChecked ? 5 : 6);
        this.refreshToolTipText();
        if (oldValue != this.m_ConnectionStatus) {
            this.m_PropertyChangeSupport.firePropertyChange(PROP_CONNECTIONSTATUS, oldValue, this.m_ConnectionStatus);
            DMXHardwarePluginFeedbackInterface o_DMXHardwarePluginFeedbackInterface = this.m_DMXHardwarePluginFeedbackInterface;
            if (o_DMXHardwarePluginFeedbackInterface != null) {
                o_DMXHardwarePluginFeedbackInterface.eventPluginConnectionStatus(o_LAN_Interface, this, this.m_ConnectionStatus, "");
            }
            o_LAN_Interface.fireHardwareInterfaceConnectionStatus(this, this.m_ConnectionStatus, "");
        }
        o_LAN_Interface.checkConnectionStatus();
    }

    @Override
    public int getConnectionStatus() {
        return this.m_ConnectionStatus;
    }

    @Override
    public String getDMXPluginInfo() {
        return this.m_Key;
    }

    @Override
    public int getDMXPluginType() {
        return this.m_PlugInType;
    }

    @Override
    public boolean changeDMXPluginType(int p_DMXPlugInType) {
        if (this.m_PlugInType == p_DMXPlugInType) {
            return false;
        }
        this.m_PlugInType = p_DMXPlugInType;
        return true;
    }

    @Override
    public boolean requestDMXPlugConnection(DMXHardwarePluginFeedbackInterface p_DMXUniverseFeedbackInterface) {
        block9: {
            block8: {
                DMXHardwarePluginFeedbackInterface o_DMXUniverseFeedbackInterface;
                DMXHardwarePluginFeedbackInterface oldValue = o_DMXUniverseFeedbackInterface = this.getDMXPluggedInUniverse();
                LAN_Interface o_LAN_Interface = this.m_LAN_Interface;
                if (o_LAN_Interface == null) {
                    return true;
                }
                if (o_DMXUniverseFeedbackInterface == p_DMXUniverseFeedbackInterface) {
                    return true;
                }
                if (o_DMXUniverseFeedbackInterface != null) {
                    o_DMXUniverseFeedbackInterface.eventPlugin(o_LAN_Interface, this, null);
                }
                this.setDMXHardwarePluginFeedbackInterface(p_DMXUniverseFeedbackInterface);
                if (p_DMXUniverseFeedbackInterface != null) {
                    p_DMXUniverseFeedbackInterface.eventPlugin(o_LAN_Interface, this, p_DMXUniverseFeedbackInterface);
                }
                o_LAN_Interface.firePlugStatus(this, oldValue, p_DMXUniverseFeedbackInterface);
                this.m_PropertyChangeSupport.firePropertyChange(PROP_DMXHARDWAREFEEDBACKINTERFACE, oldValue, this.m_DMXHardwarePluginFeedbackInterface);
                if (p_DMXUniverseFeedbackInterface == null) break block8;
                switch (this.m_PlugInType) {
                    case 0: {
                        break block9;
                    }
                    case 1: {
                        o_LAN_Interface.fireReadValuesSucces(this, this.m_DMXValues);
                        break block9;
                    }
                    default: {
                        return false;
                    }
                }
            }
            this.checkDeleteLAN_Universe();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDMXHardwarePluginFeedbackInterface(DMXHardwarePluginFeedbackInterface p_DMXHardwarePluginFeedbackInterface) {
        Object object = this.m_SyncWrite;
        synchronized (object) {
            this.m_DMXHardwarePluginFeedbackInterface = p_DMXHardwarePluginFeedbackInterface;
            if (p_DMXHardwarePluginFeedbackInterface == null) {
                for (int intValue = 0; intValue < this.m_DMXValues.length; ++intValue) {
                    this.m_DMXValues[intValue] = 0;
                }
            }
        }
    }

    @Override
    public DMXHardwarePluginFeedbackInterface getDMXPluggedInUniverse() {
        return this.m_DMXHardwarePluginFeedbackInterface;
    }

    @Override
    public int[] getDMXPluginValues() {
        return this.m_DMXValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChanged(DMXHardwarePluginFeedbackInterface p_DMXHardwarePluginFeedbackInterface) {
        LAN_Interface o_LAN_Interface;
        this.setDMXHardwarePluginFeedbackInterface(p_DMXHardwarePluginFeedbackInterface);
        Object object = this.m_SyncPlugIn;
        synchronized (object) {
            o_LAN_Interface = this.m_LAN_Interface;
        }
        if (o_LAN_Interface != null) {
            o_LAN_Interface.fireHardwareInterfacePluginChanged(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean requestWriteValues(ArrayList<Integer> p_ChangedAddresses, int[] p_AllValues) {
        LAN_Interface o_LAN_Interface = this.m_LAN_Interface;
        if (o_LAN_Interface == null) {
            return false;
        }
        boolean boolSended = false;
        Object object = this.m_SyncWrite;
        synchronized (object) {
            if (this.writeValuesToSACN(p_ChangedAddresses, p_AllValues)) {
                boolSended = true;
            }
            if (this.writeValuesToArtNet(p_ChangedAddresses, p_AllValues)) {
                boolSended = true;
            }
            if (boolSended) {
                System.arraycopy(p_AllValues, 0, this.m_DMXValues, 0, p_AllValues.length);
            }
        }
        if (boolSended) {
            o_LAN_Interface.fireWriteValuesSuccess(this, this.m_DMXValues);
        } else {
            o_LAN_Interface.fireWriteValuesFailed(this, 900, "Values not sended");
        }
        return boolSended;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean refreshWriteValues_Output() {
        boolean boolSended = false;
        if (this.m_PlugInType == 1) {
            return false;
        }
        if (this.m_LAN_PlugIns.size() <= 0) {
            return false;
        }
        if (this.m_DMXHardwarePluginFeedbackInterface == null) {
            return false;
        }
        Object object = this.m_SyncWrite;
        synchronized (object) {
            if (this.writeValuesToSACN(null, this.m_DMXValues)) {
                boolSended = true;
            }
            if (this.writeValuesToArtNet(null, this.m_DMXValues)) {
                boolSended = true;
            }
        }
        return boolSended;
    }

    @Override
    public boolean requestReadValues(ArrayList<Integer> p_Addresses) {
        LAN_Interface o_LAN_Interface = this.m_LAN_Interface;
        if (o_LAN_Interface == null) {
            return false;
        }
        return o_LAN_Interface.requestReadValues(this, p_Addresses);
    }

    @Override
    public boolean requestWriteMIDIMessage(byte[] p_MIDIBytes) {
        return false;
    }

    public void addPropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
        if (p_PropertyChangeListener == null) {
            return;
        }
        if (this.m_PropertyChangeSupport != null) {
            this.m_PropertyChangeSupport.addPropertyChangeListener(p_PropertyChangeListener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
        if (this.m_PropertyChangeSupport != null) {
            this.m_PropertyChangeSupport.removePropertyChangeListener(p_PropertyChangeListener);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof LAN_NetworkInterface) {
            LAN_NetworkInterface o_LAN_NetworkInterface = (LAN_NetworkInterface)evt.getSource();
            switch (evt.getPropertyName()) {
                case "propAddressSize": {
                    this.checkSACNLANProtocols();
                    break;
                }
            }
        }
        if (evt.getSource() instanceof LAN_PlugIn) {
            this.refreshToolTipText();
        }
    }

    public void refreshToolTipText() {
        if (this.getLAN_PlugInCount() <= 0) {
            this.m_ToolTipText = null;
        } else {
            StringBuilder o_StringBuilder = new StringBuilder();
            o_StringBuilder.append("<html>");
            o_StringBuilder.append(this.getName());
            o_StringBuilder.append("<br>");
            for (int intPlugIn = 0; intPlugIn < this.getLAN_PlugInCount(); ++intPlugIn) {
                LAN_Device o_LAN_Device;
                LAN_PlugIn o_LAN_PlugIn = this.getLAN_PlugIn(intPlugIn);
                if (o_LAN_PlugIn == null || (o_LAN_Device = o_LAN_PlugIn.getLAN_Device()) == null) continue;
                if (o_LAN_PlugIn.getConnectionStatus() == 5) {
                    o_StringBuilder.append("<font color = rgb(0,200,0)>");
                } else {
                    o_StringBuilder.append("<font color = rgb(200,0,0)>");
                }
                if (o_LAN_Device instanceof LAN_Device_ArtNet) {
                    int intBindIndex = o_LAN_Device.getBindIndex(o_LAN_PlugIn);
                    LAN_Device_ArtNet.BindIndexStructure o_BindIndexStructure = ((LAN_Device_ArtNet)o_LAN_Device).getBindIndexStructure(intBindIndex);
                    if (o_BindIndexStructure == null) continue;
                    o_StringBuilder.append(o_LAN_Device.getName());
                    o_StringBuilder.append(" ");
                    o_StringBuilder.append(o_BindIndexStructure.getShortName());
                    o_StringBuilder.append(": ");
                } else {
                    o_StringBuilder.append(o_LAN_Device.getName());
                    o_StringBuilder.append(": ");
                }
                o_StringBuilder.append(o_LAN_PlugIn.getName());
                o_StringBuilder.append(" ");
                o_StringBuilder.append(Protocols.getProtocolName(o_LAN_PlugIn.getProtocolType()));
                o_StringBuilder.append("<br>");
            }
            o_StringBuilder.append("</html>");
            this.m_ToolTipText = o_StringBuilder.toString();
        }
    }

    public String getToolTipText() {
        return this.m_ToolTipText;
    }

    public static class TableCellRenderer_LAN_UniverseName
    extends DefaultTableCellRenderer {
        protected static Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
        protected static Border selectedBorder = new LineBorder(Color.BLUE, 2);
        private JLabelBackground m_JLabelBackground;

        public TableCellRenderer_LAN_UniverseName() {
            this.initComponents();
        }

        private void initComponents() {
            this.m_JLabelBackground = new JLabelBackground();
            this.m_JLabelBackground.setBackgroundStyle(1);
            this.m_JLabelBackground.setBackgroundGradientAngle(90);
            this.m_JLabelBackground.setBackgroundGradientColorFrom(Color.BLACK);
            this.m_JLabelBackground.setBackgroundGradientColorTo(Color.BLACK);
            this.m_JLabelBackground.setBackgroundOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (table == null) {
                return this.m_JLabelBackground;
            }
            Color o_Background = table.getBackground();
            Color o_Foreground = table.getForeground();
            if (isSelected) {
                if (table.hasFocus()) {
                    o_Background = UIManager.getColor("Table.selectionBackground");
                    o_Foreground = UIManager.getColor("Table.selectionForeground");
                } else {
                    o_Background = UIManager.getColor("Table.selectionInactiveBackground");
                    o_Foreground = UIManager.getColor("Table.selectionInactiveForeground");
                }
            }
            this.setBackground(o_Background);
            this.setForeground(o_Foreground);
            int intRowModel = table.convertRowIndexToModel(row);
            LAN_UniverseTableModel o_LAN_UniverseTableModel = (LAN_UniverseTableModel)table.getModel();
            LAN_Universe o_LAN_Universe = o_LAN_UniverseTableModel.getLAN_Universe(intRowModel);
            if (o_LAN_Universe == null) {
                return this.m_JLabelBackground;
            }
            Color o_ColorStatus = table.getBackground();
            switch (o_LAN_Universe.getConnectionStatus()) {
                case 5: {
                    o_ColorStatus = DMXHardwareInterface.COLOR_CONNECTIONSTATUS_CHECKED;
                    break;
                }
                case 6: {
                    o_ColorStatus = DMXHardwareInterface.COLOR_CONNECTIONSTATUS_SOMECHECKED;
                    break;
                }
                default: {
                    o_ColorStatus = DMXHardwareInterface.COLOR_CONNECTIONSTATUS_NOTCONNECTED;
                }
            }
            switch (o_LAN_Universe.getDMXPluginType()) {
                case 0: {
                    this.m_JLabelBackground.setBackgroundGradientColorFrom(table.getBackground());
                    this.m_JLabelBackground.setBackgroundGradientColorTo(o_ColorStatus);
                    break;
                }
                case 1: {
                    this.m_JLabelBackground.setBackgroundGradientColorFrom(o_ColorStatus);
                    this.m_JLabelBackground.setBackgroundGradientColorTo(table.getBackground());
                }
            }
            this.m_JLabelBackground.setFont(table.getFont());
            Border border = null;
            border = isSelected ? selectedBorder : noFocusBorder;
            this.m_JLabelBackground.setBorder(border);
            this.setValue(value);
            this.m_JLabelBackground.setToolTipText(o_LAN_Universe.getToolTipText());
            return this.m_JLabelBackground;
        }

        @Override
        protected void setValue(Object value) {
            this.m_JLabelBackground.setText(value == null ? "" : value.toString());
        }
    }

    public static class LAN_UniverseTableModel
    extends TableAndListModel<LAN_Universe>
    implements PropertyChangeListener {
        public static final int COLUMNCOUNT = 1;
        public static final int COLUMNINDEX_UNIVERSENAME = 0;
        @LiveLanguageString
        public static String COLUMN_UNIVERSENAME = "Name";
        private HashMap<String, LAN_Universe> m_HAshMapLAN_Universes;
        private DefaultTableCellRenderer m_Renderer_Name;
        private final Object m_SyncObject = new Object();

        public LAN_UniverseTableModel() {
            super(false);
            this.initMembers();
            LiveLanguage.addLanguageListener(this, "LAN_Interface");
        }

        private void initMembers() {
            this.m_HAshMapLAN_Universes = new HashMap();
            this.m_Renderer_Name = new TableCellRenderer_LAN_UniverseName();
        }

        public void finishJTable(JTable p_JTable) {
            if (p_JTable == null) {
                return;
            }
            TableRowSorter<LAN_UniverseTableModel> o_TableRowSorter = new TableRowSorter<LAN_UniverseTableModel>(this);
            o_TableRowSorter.setComparator(0, new StringComparator_Normal());
            super.finishJTable(p_JTable, o_TableRowSorter, null);
            p_JTable.getColumnModel().getColumn(0).setCellRenderer(this.m_Renderer_Name);
            if (o_TableRowSorter != null) {
                o_TableRowSorter.toggleSortOrder(0);
            }
        }

        @Override
        public boolean contains(String p_ID) {
            if (p_ID == null) {
                return false;
            }
            LAN_Universe o_LAN_Universe = this.getLAN_Universe(p_ID);
            return o_LAN_Universe != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LAN_Universe getLAN_Universe(String p_ID) {
            Object object = this.m_SyncObject;
            synchronized (object) {
                return this.m_HAshMapLAN_Universes.get(p_ID);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addLAN_Universe(LAN_Universe p_LAN_Universe) {
            if (p_LAN_Universe == null) {
                return;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (this.add(p_LAN_Universe)) {
                    this.m_HAshMapLAN_Universes.put(p_LAN_Universe.getID(), p_LAN_Universe);
                    p_LAN_Universe.addPropertyChangeListener(this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeLAN_Universe(LAN_Universe p_LAN_Universe) {
            if (p_LAN_Universe == null) {
                return;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (this.remove(p_LAN_Universe)) {
                    p_LAN_Universe.removePropertyChangeListener(this);
                    this.m_HAshMapLAN_Universes.remove(p_LAN_Universe.getID());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addSelectedLAN_Universe(JTable p_JTable, LAN_Universe p_LAN_Universe) {
            if (p_JTable == null) {
                return;
            }
            if (p_LAN_Universe == null) {
                return;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                this.addSelectedElement(p_JTable, p_LAN_Universe);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeSelectedLAN_Universe(JTable p_JTable, LAN_Universe p_LAN_Universe) {
            if (p_JTable == null) {
                return;
            }
            if (p_LAN_Universe == null) {
                return;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                this.removeSelectedElement(p_JTable, p_LAN_Universe);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LAN_Universe getLAN_Universe(int p_Index) {
            if (p_Index < 0) {
                return null;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                return (LAN_Universe)this.get(p_Index);
            }
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return COLUMN_UNIVERSENAME;
                }
            }
            return "";
        }

        public DefaultTableCellRenderer getDefaultTableCellRenderer(int p_Column) {
            switch (p_Column) {
                case 0: {
                    return this.m_Renderer_Name;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getValue(LAN_Universe p_LAN_Universe, int columnIndex) {
            StringBuilder o_StringBuilder = new StringBuilder();
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (p_LAN_Universe == null) {
                    return o_StringBuilder.toString();
                }
                switch (columnIndex) {
                    case 0: {
                        o_StringBuilder.append(p_LAN_Universe.getName());
                        DMXHardwarePluginFeedbackInterface o_DMXHardwarePluginFeedbackInterface = p_LAN_Universe.getDMXHardwarePluginFeedbackInterface();
                        if (o_DMXHardwarePluginFeedbackInterface == null) break;
                        if (p_LAN_Universe.getDMXPluginType() == 1) {
                            o_StringBuilder.append(" -> ");
                        } else {
                            o_StringBuilder.append(" <- ");
                        }
                        o_StringBuilder.append(o_DMXHardwarePluginFeedbackInterface.getName());
                    }
                }
                return o_StringBuilder.toString();
            }
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            LAN_Universe o_LAN_Universe = this.getLAN_Universe(row);
            if (o_LAN_Universe == null) {
                return false;
            }
            switch (col) {
                case 0: {
                    return false;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setValue(LAN_Universe p_LAN_Universe, Object value, int col) {
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (p_LAN_Universe == null) {
                    return;
                }
            }
            switch (col) {
                default: 
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() instanceof LAN_Universe) {
                LAN_Universe o_LAN_Universe = (LAN_Universe)evt.getSource();
                if (LAN_Universe.PROP_CONNECTIONSTATUS.equals(evt.getPropertyName())) {
                    this.changedElement(o_LAN_Universe);
                }
                if (LAN_Universe.PROP_DMXHARDWAREFEEDBACKINTERFACE.equals(evt.getPropertyName())) {
                    this.changedElement(o_LAN_Universe);
                }
            }
        }

        public static class StringComparator_NumericInteger
        implements Comparator<String> {
            @Override
            public int compare(String o1, String o2) {
                Integer int2;
                Integer int1;
                if (o1 == null || o2 == null) {
                    return 0;
                }
                try {
                    int1 = Integer.valueOf(o1);
                    int2 = Integer.valueOf(o2);
                }
                catch (Exception e) {
                    return 0;
                }
                return int1.compareTo(int2);
            }
        }

        public static class StringComparator_Normal
        implements Comparator<String> {
            @Override
            public int compare(String o1, String o2) {
                if (o1 == null || o2 == null) {
                    return 0;
                }
                return o1.compareToIgnoreCase(o2);
            }
        }
    }
}

