/*
 * Decompiled with CFR 0.152.
 */
package DMXHardwarePackage;

import ArtNetPackage.ArtNet_Op_ArtAddress;
import ArtNetPackage.ArtNet_Op_ArtIPProg;
import DMXHardwarePackage.LAN_Device;
import DMXHardwarePackage.LAN_Device_ArtNet;
import DMXHardwarePackage.LAN_Device_Configuration_BindPanel;
import DMXHardwarePackage.LAN_Device_Configuration_PlugInPanel;
import DMXHardwarePackage.LAN_Interface;
import DMXHardwarePackage.LAN_Interface_Configuration;
import DMXHardwarePackage.LAN_PlugIn;
import LanguageTools.LiveLanguagePackage.LiveLanguage;
import ProtocolPackage.Protocols;
import ToolPackage.PopUpToolTip;
import ToolsGraphics.JLabel_ResizeFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;

public class LAN_Device_Configuration
extends JDialog
implements PropertyChangeListener {
    public static Border s_BorderIPProg_Normal = new LineBorder(Color.RED, 1);
    public static Border s_BorderIPProg_Pressed = new LineBorder(Color.GREEN, 1);
    private LAN_Device m_LAN_Device;
    private HashMap<Integer, LAN_Device_Configuration_BindPanel> m_BindPanels;
    private final Object m_SyncBindPanel = new Object();
    private ArrayList<LAN_Device_ArtNet> m_LAN_Devices_ArtNet;
    public static int IP_WRONG = 0;
    public static int IP_OK = 1;
    public static int IP_USEDSEVERAL = 2;
    private int m_IPOk;
    private boolean m_SubNetMaskOk;
    private Runnable m_Runnable_RefreshGUI;
    private JButton jButton_ArtIPProg;
    private JButton jButton_Cancel;
    private JButton jButton_Save;
    private JCheckBox jCheckBox_DHCP;
    private JLabel jLabel_Firmware;
    private JLabel jLabel_FirmwareContent;
    private JLabel jLabel_IP4;
    private JLabel jLabel_LongName;
    private JLabel jLabel_LongName_Remark;
    private JLabel jLabel_Name;
    private JLabel jLabel_Name_Remark;
    private JLabel_ResizeFrame jLabel_ResizeFrame1;
    private JLabel jLabel_SubNetMask;
    private JPanel jPanel_IP;
    private JPanel jPanel_Name;
    private JPanel jPanel_PlugIns;
    private JScrollPane jScrollPane_PlugIns;
    private JTextField jTextField_IP4;
    private JTextField jTextField_LongName;
    private JTextField jTextField_Name;
    private JTextField jTextField_SubNetMask;

    public LAN_Device_Configuration(Frame parent, boolean modal) {
        super(parent, modal);
        this.initMembers();
        this.initComponents();
        this.initComponentsFurther();
        this.setIconImage(new ImageIcon(this.getClass().getResource("/Image/Interface.png")).getImage());
        LiveLanguage.addLanguageListener(this, LAN_Interface_Configuration.class.getSimpleName());
    }

    private void initMembers() {
        this.m_LAN_Device = null;
        this.m_BindPanels = new HashMap();
        this.m_LAN_Devices_ArtNet = new ArrayList();
        this.m_Runnable_RefreshGUI = new Runnable(){

            @Override
            public void run() {
                LAN_Device_Configuration.this.refreshGUI();
            }
        };
    }

    private void initComponents() {
        this.jPanel_Name = new JPanel();
        this.jLabel_Name = new JLabel();
        this.jTextField_Name = new JTextField();
        this.jLabel_LongName = new JLabel();
        this.jTextField_LongName = new JTextField();
        this.jLabel_Name_Remark = new JLabel();
        this.jLabel_LongName_Remark = new JLabel();
        this.jLabel_Firmware = new JLabel();
        this.jLabel_FirmwareContent = new JLabel();
        this.jPanel_IP = new JPanel();
        this.jLabel_IP4 = new JLabel();
        this.jTextField_IP4 = new JTextField();
        this.jButton_ArtIPProg = new JButton();
        this.jTextField_SubNetMask = new JTextField();
        this.jLabel_SubNetMask = new JLabel();
        this.jCheckBox_DHCP = new JCheckBox();
        this.jScrollPane_PlugIns = new JScrollPane();
        this.jPanel_PlugIns = new JPanel();
        this.jButton_Cancel = new JButton();
        this.jButton_Save = new JButton();
        this.jLabel_ResizeFrame1 = new JLabel_ResizeFrame();
        this.setMinimumSize(new Dimension(250, 200));
        this.setPreferredSize(new Dimension(600, 500));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                LAN_Device_Configuration.this.closeDialog(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.jPanel_Name.setLayout(new GridBagLayout());
        this.jLabel_Name.setHorizontalAlignment(4);
        this.jLabel_Name.setText("Name:");
        this.jLabel_Name.setToolTipText("");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Name.add((Component)this.jLabel_Name, gridBagConstraints);
        this.jTextField_Name.setHorizontalAlignment(0);
        this.jTextField_Name.setText("jTextField1");
        this.jTextField_Name.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                LAN_Device_Configuration.this.jTextField_NameFocusLost(evt);
            }
        });
        this.jTextField_Name.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                LAN_Device_Configuration.this.jTextField_NameKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Name.add((Component)this.jTextField_Name, gridBagConstraints);
        this.jLabel_LongName.setHorizontalAlignment(4);
        this.jLabel_LongName.setText("Longname:");
        this.jLabel_LongName.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Name.add((Component)this.jLabel_LongName, gridBagConstraints);
        this.jTextField_LongName.setHorizontalAlignment(0);
        this.jTextField_LongName.setText("jTextField1");
        this.jTextField_LongName.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                LAN_Device_Configuration.this.jTextField_LongNameFocusLost(evt);
            }
        });
        this.jTextField_LongName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                LAN_Device_Configuration.this.jTextField_LongNameKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Name.add((Component)this.jTextField_LongName, gridBagConstraints);
        this.jLabel_Name_Remark.setHorizontalAlignment(2);
        this.jLabel_Name_Remark.setText("(max. 7 Character)");
        this.jLabel_Name_Remark.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Name.add((Component)this.jLabel_Name_Remark, gridBagConstraints);
        this.jLabel_LongName_Remark.setHorizontalAlignment(2);
        this.jLabel_LongName_Remark.setText("(max. 63 Character)");
        this.jLabel_LongName_Remark.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Name.add((Component)this.jLabel_LongName_Remark, gridBagConstraints);
        this.jLabel_Firmware.setHorizontalAlignment(4);
        this.jLabel_Firmware.setText("Firmware:");
        this.jLabel_Firmware.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Name.add((Component)this.jLabel_Firmware, gridBagConstraints);
        this.jLabel_FirmwareContent.setHorizontalAlignment(0);
        this.jLabel_FirmwareContent.setText("Firmware");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 10, 3, 3);
        this.jPanel_Name.add((Component)this.jLabel_FirmwareContent, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.jPanel_Name, gridBagConstraints);
        this.jPanel_IP.setLayout(new GridBagLayout());
        this.jLabel_IP4.setHorizontalAlignment(4);
        this.jLabel_IP4.setText("IP4 Address:");
        this.jLabel_IP4.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_IP.add((Component)this.jLabel_IP4, gridBagConstraints);
        this.jTextField_IP4.setHorizontalAlignment(0);
        this.jTextField_IP4.setText("jTextField1");
        this.jTextField_IP4.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                LAN_Device_Configuration.this.jTextField_IP4FocusLost(evt);
            }
        });
        this.jTextField_IP4.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                LAN_Device_Configuration.this.jTextField_IP4KeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_IP.add((Component)this.jTextField_IP4, gridBagConstraints);
        this.jButton_ArtIPProg.setBackground(new Color(255, 204, 204));
        this.jButton_ArtIPProg.setForeground(new Color(255, 255, 255));
        this.jButton_ArtIPProg.setText(" Change IP/SubNet");
        this.jButton_ArtIPProg.setToolTipText("");
        this.jButton_ArtIPProg.setBorder(BorderFactory.createLineBorder(Color.red));
        this.jButton_ArtIPProg.setContentAreaFilled(false);
        this.jButton_ArtIPProg.setMaximumSize(new Dimension(110, 17));
        this.jButton_ArtIPProg.setMinimumSize(new Dimension(110, 17));
        this.jButton_ArtIPProg.setPreferredSize(new Dimension(110, 17));
        this.jButton_ArtIPProg.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                LAN_Device_Configuration.this.jButton_ArtIPProgMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                LAN_Device_Configuration.this.jButton_ArtIPProgMouseReleased(evt);
            }
        });
        this.jButton_ArtIPProg.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LAN_Device_Configuration.this.jButton_ArtIPProgActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_IP.add((Component)this.jButton_ArtIPProg, gridBagConstraints);
        this.jTextField_SubNetMask.setHorizontalAlignment(0);
        this.jTextField_SubNetMask.setText("jTextField1");
        this.jTextField_SubNetMask.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                LAN_Device_Configuration.this.jTextField_SubNetMaskFocusLost(evt);
            }
        });
        this.jTextField_SubNetMask.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                LAN_Device_Configuration.this.jTextField_SubNetMaskKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_IP.add((Component)this.jTextField_SubNetMask, gridBagConstraints);
        this.jLabel_SubNetMask.setHorizontalAlignment(4);
        this.jLabel_SubNetMask.setText("SubNetMask");
        this.jLabel_SubNetMask.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_IP.add((Component)this.jLabel_SubNetMask, gridBagConstraints);
        this.jCheckBox_DHCP.setText(" DHCP");
        this.jCheckBox_DHCP.setToolTipText("");
        this.jCheckBox_DHCP.setHorizontalTextPosition(0);
        this.jCheckBox_DHCP.setVerticalTextPosition(3);
        this.jCheckBox_DHCP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LAN_Device_Configuration.this.jCheckBox_DHCPActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_IP.add((Component)this.jCheckBox_DHCP, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.jPanel_IP, gridBagConstraints);
        this.jScrollPane_PlugIns.setMinimumSize(new Dimension(100, 100));
        this.jScrollPane_PlugIns.setPreferredSize(new Dimension(100, 100));
        this.jPanel_PlugIns.setLayout(new GridBagLayout());
        this.jScrollPane_PlugIns.setViewportView(this.jPanel_PlugIns);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jScrollPane_PlugIns, gridBagConstraints);
        this.jButton_Cancel.setIcon(new ImageIcon(this.getClass().getResource("/Image/Edit_Cancel.png")));
        this.jButton_Cancel.setToolTipText("Remove selected sACN device");
        this.jButton_Cancel.setBorderPainted(false);
        this.jButton_Cancel.setContentAreaFilled(false);
        this.jButton_Cancel.setMargin(new Insets(0, 0, 0, 0));
        this.jButton_Cancel.setMaximumSize(new Dimension(34, 34));
        this.jButton_Cancel.setMinimumSize(new Dimension(34, 34));
        this.jButton_Cancel.setPreferredSize(new Dimension(34, 34));
        this.jButton_Cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LAN_Device_Configuration.this.jButton_CancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jButton_Cancel, gridBagConstraints);
        this.jButton_Save.setIcon(new ImageIcon(this.getClass().getResource("/Image/Edit_OK.png")));
        this.jButton_Save.setToolTipText("Remove selected sACN device");
        this.jButton_Save.setBorderPainted(false);
        this.jButton_Save.setContentAreaFilled(false);
        this.jButton_Save.setMargin(new Insets(0, 0, 0, 0));
        this.jButton_Save.setMaximumSize(new Dimension(34, 34));
        this.jButton_Save.setMinimumSize(new Dimension(34, 34));
        this.jButton_Save.setPreferredSize(new Dimension(34, 34));
        this.jButton_Save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LAN_Device_Configuration.this.jButton_SaveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 15, 3, 3);
        this.getContentPane().add((Component)this.jButton_Save, gridBagConstraints);
        this.jLabel_ResizeFrame1.setText("jLabel_ResizeFrame1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 13;
        this.getContentPane().add((Component)this.jLabel_ResizeFrame1, gridBagConstraints);
        this.pack();
    }

    private void initComponentsFurther() {
        this.setAlwaysOnTop(true);
        this.jLabel_ResizeFrame1.setContainer(this);
        this.jButton_Save.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_Cancel.setComponentPopupMenu(PopUpToolTip.getSelfReference());
    }

    private void closeDialog(WindowEvent evt) {
        this.setLAN_Device(null);
        this.setVisible(false);
    }

    private void jButton_SaveActionPerformed(ActionEvent evt) {
        LAN_Device o_LAN_Device = this.m_LAN_Device;
        if (o_LAN_Device == null) {
            return;
        }
        if (o_LAN_Device instanceof LAN_Device_ArtNet) {
            this.saveLAN_Device_ArtNet();
        } else {
            this.saveLAN_Device_sACN();
        }
        this.setLAN_Device(null);
        this.setVisible(false);
    }

    private void jButton_CancelActionPerformed(ActionEvent evt) {
        this.setLAN_Device(null);
        this.setVisible(false);
    }

    private void jTextField_IP4FocusLost(FocusEvent evt) {
        this.refreshIPSubNetMask(this.checkIP(this.jTextField_IP4.getText()), this.checkSubNetMask(this.jTextField_SubNetMask.getText()));
    }

    private void jTextField_IP4KeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.refreshIPSubNetMask(this.checkIP(this.jTextField_IP4.getText()), this.checkSubNetMask(this.jTextField_SubNetMask.getText()));
        }
    }

    private void jTextField_SubNetMaskFocusLost(FocusEvent evt) {
        this.refreshIPSubNetMask(this.checkIP(this.jTextField_IP4.getText()), this.checkSubNetMask(this.jTextField_SubNetMask.getText()));
    }

    private void jTextField_SubNetMaskKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.refreshIPSubNetMask(this.checkIP(this.jTextField_IP4.getText()), this.checkSubNetMask(this.jTextField_SubNetMask.getText()));
        }
    }

    private void jButton_ArtIPProgActionPerformed(ActionEvent evt) {
        this.saveNetworkSettings();
    }

    private void jTextField_NameFocusLost(FocusEvent evt) {
        this.checkNames();
    }

    private void jTextField_NameKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.checkNames();
        }
    }

    private void jTextField_LongNameFocusLost(FocusEvent evt) {
        this.checkNames();
    }

    private void jTextField_LongNameKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.checkNames();
        }
    }

    private void jCheckBox_DHCPActionPerformed(ActionEvent evt) {
    }

    private void jButton_ArtIPProgMousePressed(MouseEvent evt) {
        if (this.jButton_ArtIPProg.isEnabled()) {
            this.jButton_ArtIPProg.setBorder(s_BorderIPProg_Pressed);
        }
    }

    private void jButton_ArtIPProgMouseReleased(MouseEvent evt) {
        this.jButton_ArtIPProg.setBorder(s_BorderIPProg_Normal);
    }

    public void checkNames() {
        LAN_Device_ArtNet o_LAN_Device_ArtNet = null;
        LAN_Device o_LAN_Device = this.m_LAN_Device;
        if (o_LAN_Device != null && o_LAN_Device instanceof LAN_Device_ArtNet) {
            o_LAN_Device_ArtNet = (LAN_Device_ArtNet)o_LAN_Device;
        }
        if (o_LAN_Device_ArtNet != null) {
            String stringName = this.jTextField_Name.getText();
            if (stringName.length() > 17) {
                stringName = stringName.substring(0, 17);
                this.jTextField_Name.setText(stringName);
            }
            if ((stringName = this.jTextField_LongName.getText()).length() > 63) {
                stringName = stringName.substring(0, 63);
                this.jTextField_LongName.setText(stringName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLAN_Device(LAN_Device p_LAN_Device) {
        LAN_Device_Configuration_BindPanel o_BindPanel;
        int intBindIndex;
        if (this.m_LAN_Device != null) {
            this.m_LAN_Device.removePropertyChangeListener(this);
            Object object = this.m_SyncBindPanel;
            synchronized (object) {
                Iterator<Integer> o_Iterator = this.m_BindPanels.keySet().iterator();
                while (o_Iterator.hasNext()) {
                    intBindIndex = o_Iterator.next();
                    o_BindPanel = this.m_BindPanels.get(intBindIndex);
                    o_Iterator.remove();
                    if (o_BindPanel == null) continue;
                    this.jPanel_PlugIns.remove(o_BindPanel);
                    o_BindPanel.close();
                }
            }
        }
        this.m_LAN_Device = p_LAN_Device;
        if (this.m_LAN_Device != null) {
            this.m_LAN_Device.addPropertyChangeListener(this);
            int intPlgInCount = this.m_LAN_Device.getLAN_PlugInCount();
            for (int intPlugIn = 0; intPlugIn < intPlgInCount; ++intPlugIn) {
                LAN_PlugIn o_LAN_PlugIn = this.m_LAN_Device.getLAN_PlugIn(intPlugIn);
                if (o_LAN_PlugIn == null) continue;
                intBindIndex = this.m_LAN_Device.getBindIndex(o_LAN_PlugIn);
                Object object = this.m_SyncBindPanel;
                synchronized (object) {
                    o_BindPanel = this.m_BindPanels.get(intBindIndex);
                    if (o_BindPanel == null) {
                        o_BindPanel = new LAN_Device_Configuration_BindPanel();
                        this.m_BindPanels.put(intBindIndex, o_BindPanel);
                        this.jPanel_PlugIns.add((Component)o_BindPanel, o_BindPanel.getGridBagConstraints());
                        o_BindPanel.setVisible(true);
                    }
                }
                o_BindPanel.setLAN_Device(this.m_LAN_Device, intBindIndex);
                o_BindPanel.addLAN_PlugIn(o_LAN_PlugIn);
            }
        }
        EventQueue.invokeLater(this.m_Runnable_RefreshGUI);
        LAN_Device o_LAN_Device = this.m_LAN_Device;
        if (o_LAN_Device == null) {
            return;
        }
        if (!(o_LAN_Device instanceof LAN_Device_ArtNet)) {
            return;
        }
        LAN_Device_ArtNet o_LAN_Device_ArtNet = (LAN_Device_ArtNet)o_LAN_Device;
        LAN_Interface o_LAN_Interface = o_LAN_Device.getLAN_Interface();
        if (o_LAN_Interface == null) {
            return;
        }
        if (!o_LAN_Device_ArtNet.getIPProgrammable()) {
            ArtNet_Op_ArtIPProg o_ArtNet_Op_ArtIPProg = o_LAN_Device_ArtNet.getArtNet_Op_ArtIPProg();
            o_ArtNet_Op_ArtIPProg.setCommand_Enquiry();
            o_ArtNet_Op_ArtIPProg.setIP4Address(o_LAN_Device_ArtNet.getRemoteInetAddress());
            o_ArtNet_Op_ArtIPProg.setSubNetMask(o_LAN_Device_ArtNet.getRemoteSubNetMask());
            o_LAN_Interface.sendArtNet_OP(o_ArtNet_Op_ArtIPProg, o_LAN_Device_ArtNet.getRemoteInetAddress(), o_LAN_Device_ArtNet.getProtocolConfigurationDetected());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshGUI() {
        LAN_Device o_LAN_Device = this.m_LAN_Device;
        if (o_LAN_Device == null) {
            this.setTitle("");
            this.jTextField_Name.setText("");
            this.jTextField_LongName.setText("");
            this.jTextField_IP4.setText("");
            this.jLabel_FirmwareContent.setText("");
            return;
        }
        this.setTitle(Protocols.getProtocolName(o_LAN_Device.getProtocolType()) + ": " + o_LAN_Device.getName());
        StringBuilder o_StringBuilder = new StringBuilder();
        LAN_Device_ArtNet o_LAN_Device_ArtNet = o_LAN_Device instanceof LAN_Device_ArtNet ? (LAN_Device_ArtNet)o_LAN_Device : null;
        this.jTextField_Name.setText(o_LAN_Device.getName());
        this.jTextField_LongName.setText(o_LAN_Device.getLongName());
        if (o_LAN_Device_ArtNet == null) {
            this.jTextField_Name.setEnabled(true);
            this.jTextField_LongName.setEnabled(true);
            this.jLabel_Name_Remark.setVisible(false);
            this.jLabel_LongName_Remark.setVisible(false);
            this.jLabel_Firmware.setVisible(false);
            this.jLabel_FirmwareContent.setVisible(false);
        } else {
            this.jTextField_Name.setEnabled(false);
            this.jTextField_LongName.setEnabled(false);
            this.jLabel_Name_Remark.setVisible(false);
            this.jLabel_LongName_Remark.setVisible(false);
            this.jLabel_Firmware.setVisible(true);
            this.jLabel_FirmwareContent.setVisible(true);
            o_StringBuilder.delete(0, o_StringBuilder.length());
            o_StringBuilder.append(o_LAN_Device_ArtNet.getFirmwareHigh() & 0xFF);
            o_StringBuilder.append(".");
            o_StringBuilder.append(o_LAN_Device_ArtNet.getFirmwareLow() & 0xFF);
            this.jLabel_FirmwareContent.setText(o_StringBuilder.toString());
        }
        if (o_LAN_Device_ArtNet == null) {
            this.refreshIPSubNetMask(null, null);
        } else {
            this.refreshIPSubNetMask(this.checkIP(o_LAN_Device_ArtNet.getRemoteIP()), this.checkSubNetMask(o_LAN_Device_ArtNet.getRemoteSubNetMask()));
        }
        int intHeight = 0;
        Object object = this.m_SyncBindPanel;
        synchronized (object) {
            GridBagLayout o_GridBagLayout = (GridBagLayout)this.jPanel_PlugIns.getLayout();
            for (int intBindIndex : this.m_BindPanels.keySet()) {
                LAN_Device_Configuration_BindPanel o_BindPanel = this.m_BindPanels.get(intBindIndex);
                if (o_BindPanel == null) continue;
                intHeight = (int)((double)intHeight + o_BindPanel.getMinimumSize().getHeight());
                o_GridBagLayout.setConstraints(o_BindPanel, o_BindPanel.getGridBagConstraints());
            }
        }
        this.jPanel_PlugIns.revalidate();
        this.jPanel_PlugIns.repaint();
        this.revalidate();
        this.repaint();
    }

    public void refreshIPSubNetMask(byte[] p_IPAddress, byte[] p_SubNetMask) {
        int intByte;
        LAN_Device_ArtNet o_LAN_Device_ArtNet = null;
        LAN_Device o_LAN_Device = this.m_LAN_Device;
        if (o_LAN_Device != null && o_LAN_Device instanceof LAN_Device_ArtNet) {
            o_LAN_Device_ArtNet = (LAN_Device_ArtNet)o_LAN_Device;
        }
        if (o_LAN_Device_ArtNet == null) {
            this.jLabel_IP4.setVisible(false);
            this.jTextField_IP4.setVisible(false);
            this.jLabel_SubNetMask.setVisible(false);
            this.jTextField_SubNetMask.setVisible(false);
            this.jButton_ArtIPProg.setVisible(false);
            this.jCheckBox_DHCP.setVisible(false);
        } else {
            this.jLabel_IP4.setVisible(true);
            this.jTextField_IP4.setVisible(true);
            this.jLabel_SubNetMask.setVisible(true);
            this.jTextField_SubNetMask.setVisible(true);
            this.jButton_ArtIPProg.setVisible(true);
        }
        StringBuilder o_StringBuilder = new StringBuilder();
        if (p_IPAddress == null || p_IPAddress.length != 4) {
            this.jTextField_IP4.setText("");
        } else {
            o_StringBuilder.delete(0, o_StringBuilder.length());
            for (intByte = 0; intByte < 4; ++intByte) {
                o_StringBuilder.append(p_IPAddress[intByte] & 0xFF);
                if (intByte == 3) continue;
                o_StringBuilder.append(".");
            }
            this.jTextField_IP4.setText(o_StringBuilder.toString());
        }
        if (this.m_IPOk == IP_WRONG) {
            this.jTextField_IP4.setForeground(Color.RED);
        } else if (this.m_IPOk == IP_USEDSEVERAL) {
            this.jTextField_IP4.setForeground(Color.ORANGE);
        } else {
            this.jTextField_IP4.setForeground(Color.WHITE);
        }
        if (o_LAN_Device_ArtNet != null && o_LAN_Device_ArtNet.getIPProgrammable()) {
            if (o_LAN_Device_ArtNet.getRemoteDHCP_Capable()) {
                this.jCheckBox_DHCP.setVisible(true);
                this.jCheckBox_DHCP.setEnabled(true);
                if (o_LAN_Device_ArtNet.getRemoteDHCP()) {
                    this.jCheckBox_DHCP.setSelected(true);
                } else {
                    this.jCheckBox_DHCP.setSelected(false);
                }
            } else {
                this.jCheckBox_DHCP.setVisible(false);
                this.jCheckBox_DHCP.setEnabled(false);
            }
            this.jTextField_IP4.setEnabled(true);
            this.jTextField_SubNetMask.setEnabled(true);
            if (p_SubNetMask == null || p_SubNetMask.length != 4) {
                this.jTextField_SubNetMask.setText("");
            } else {
                o_StringBuilder.delete(0, o_StringBuilder.length());
                for (intByte = 0; intByte < 4; ++intByte) {
                    o_StringBuilder.append(p_SubNetMask[intByte] & 0xFF);
                    if (intByte == 3) continue;
                    o_StringBuilder.append(".");
                }
                this.jTextField_SubNetMask.setText(o_StringBuilder.toString());
            }
            if (!this.m_SubNetMaskOk) {
                this.jTextField_SubNetMask.setForeground(Color.RED);
            } else {
                this.jTextField_SubNetMask.setForeground(Color.WHITE);
            }
        } else {
            this.jCheckBox_DHCP.setVisible(false);
            this.jCheckBox_DHCP.setEnabled(false);
            this.jTextField_IP4.setEnabled(false);
            this.jTextField_SubNetMask.setEnabled(false);
            this.jTextField_SubNetMask.setForeground(Color.WHITE);
            this.jTextField_SubNetMask.setText("?");
        }
        if (o_LAN_Device_ArtNet != null && o_LAN_Device_ArtNet.getIPProgrammable() && this.m_IPOk == IP_OK && this.m_SubNetMaskOk) {
            this.jButton_ArtIPProg.setEnabled(true);
        } else {
            this.jButton_ArtIPProg.setEnabled(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveLAN_Device_sACN() {
        LAN_Device_Configuration_BindPanel o_BindPanel;
        LAN_Device o_LAN_Device = this.m_LAN_Device;
        if (o_LAN_Device == null) {
            return;
        }
        String stringName = this.jTextField_Name.getText().trim();
        String stringDescription = this.jTextField_LongName.getText().trim();
        Object object = this.m_SyncBindPanel;
        synchronized (object) {
            for (int intBindIndex : this.m_BindPanels.keySet()) {
                o_BindPanel = this.m_BindPanels.get(intBindIndex);
                if (o_BindPanel == null) continue;
                o_BindPanel.prepareSave_sACN();
            }
        }
        o_LAN_Device.setName(stringName);
        o_LAN_Device.setLongName(stringDescription);
        object = this.m_SyncBindPanel;
        synchronized (object) {
            for (int intBindIndex : this.m_BindPanels.keySet()) {
                o_BindPanel = this.m_BindPanels.get(intBindIndex);
                if (o_BindPanel == null) continue;
                Iterator<LAN_PlugIn> o_Iterator_LAN_PlugIn = o_BindPanel.getIterator_LAN_PlugIn();
                while (o_Iterator_LAN_PlugIn.hasNext()) {
                    LAN_Device_Configuration_PlugInPanel o_PlugInPanel;
                    LAN_PlugIn o_LAN_PlugIn = o_Iterator_LAN_PlugIn.next();
                    if (o_LAN_PlugIn == null || (o_PlugInPanel = o_BindPanel.getPlugInPanel(o_LAN_PlugIn)) == null) continue;
                    o_LAN_PlugIn.setName(o_PlugInPanel.getNew_Name());
                    o_LAN_PlugIn.setLanUniverseNumber(o_PlugInPanel.getNew_UniverseNumber());
                    o_LAN_PlugIn.setPlugInType(o_PlugInPanel.getNew_PlugInType());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveLAN_Device_ArtNet() {
        LAN_Device_Configuration_BindPanel o_BindPanel;
        String stringLongName;
        LAN_Device_ArtNet o_LAN_Device_ArtNet = null;
        ArrayList<LAN_Device_Configuration_PlugInPanel> o_ChangedPlugInPanels = new ArrayList<LAN_Device_Configuration_PlugInPanel>();
        LAN_Device o_LAN_Device = this.m_LAN_Device;
        if (o_LAN_Device == null) {
            return;
        }
        if (o_LAN_Device instanceof LAN_Device_ArtNet) {
            o_LAN_Device_ArtNet = (LAN_Device_ArtNet)o_LAN_Device;
        }
        if (o_LAN_Device_ArtNet == null) {
            return;
        }
        LAN_Interface o_LAN_Interface = o_LAN_Device_ArtNet.getLAN_Interface();
        if (o_LAN_Interface == null) {
            return;
        }
        String stringName = this.jTextField_Name.getText().trim();
        if (stringName.length() > 17) {
            stringName = stringName.substring(0, 17);
        }
        if ((stringLongName = this.jTextField_LongName.getText().trim()).length() > 63) {
            stringLongName = stringLongName.substring(0, 63);
        }
        InetAddress o_InetAddress_Remote = o_LAN_Device_ArtNet.getRemoteInetAddress();
        String stringIP = o_InetAddress_Remote.getHostAddress();
        Object object = this.m_SyncBindPanel;
        synchronized (object) {
            for (int intBindIndex : this.m_BindPanels.keySet()) {
                o_BindPanel = this.m_BindPanels.get(intBindIndex);
                if (o_BindPanel == null) continue;
                o_BindPanel.prepareSave_ArtNet();
            }
        }
        ArtNet_Op_ArtAddress o_ArtNet_Op_ArtAddress = o_LAN_Device_ArtNet.getArtNet_Op_ArtAddress();
        object = this.m_SyncBindPanel;
        synchronized (object) {
            Iterator<Integer> o_Iterator = this.m_BindPanels.keySet().iterator();
            while (o_Iterator.hasNext()) {
                LAN_Device_Configuration_PlugInPanel o_PlugInPanel;
                LAN_PlugIn o_LAN_PlugIn;
                int intBindIndex;
                o_ChangedPlugInPanels.clear();
                intBindIndex = o_Iterator.next();
                LAN_Device_ArtNet.BindIndexStructure o_BindIndexStructure = o_LAN_Device_ArtNet.getBindIndexStructure(intBindIndex);
                if (o_BindIndexStructure == null || (o_BindPanel = this.m_BindPanels.get(intBindIndex)) == null) continue;
                o_ArtNet_Op_ArtAddress.setBindIndex((byte)(intBindIndex & 0xFF));
                Byte byteToSend = o_BindPanel.getNew_NetSwitch();
                byteToSend = byteToSend.byteValue() != o_BindIndexStructure.getUniverseNetSwitch() ? Byte.valueOf((byte)(byteToSend | 0x80)) : Byte.valueOf((byte)127);
                o_ArtNet_Op_ArtAddress.setNetSwitch(byteToSend);
                byteToSend = o_BindPanel.getNew_SubNet();
                byteToSend = byteToSend.byteValue() != o_BindIndexStructure.getUniverseSubSwitch() ? Byte.valueOf((byte)(byteToSend | 0x80)) : Byte.valueOf((byte)127);
                o_ArtNet_Op_ArtAddress.setSubSwitch(byteToSend);
                for (int intByte = 0; intByte < 4; ++intByte) {
                    o_ArtNet_Op_ArtAddress.setSWIn(intByte, (byte)127);
                    o_ArtNet_Op_ArtAddress.setSWOut(intByte, (byte)127);
                }
                o_ArtNet_Op_ArtAddress.setName(o_BindPanel.getNew_ShortName());
                o_ArtNet_Op_ArtAddress.setLongName(o_BindPanel.getNew_LongName());
                Iterator<LAN_PlugIn> o_Iterator_PlugIn = o_BindPanel.getIterator_LAN_PlugIn();
                while (o_Iterator_PlugIn.hasNext()) {
                    boolean boolPortTypeChanged = false;
                    o_LAN_PlugIn = o_Iterator_PlugIn.next();
                    if (o_LAN_PlugIn == null || (o_PlugInPanel = o_BindPanel.getPlugInPanel(o_LAN_PlugIn)) == null) continue;
                    int intByteIndex = o_PlugInPanel.getPortIndex();
                    if (o_PlugInPanel.getNew_PlugInType() == 0) {
                        byteToSend = o_PlugInPanel.getNew_SWOut();
                        byteToSend = (byte)(byteToSend | 0xFFFFFF80);
                        if (intByteIndex >= 0 && intByteIndex < 4) {
                            byteToSend = (byte)(byteToSend | 0xFFFFFF80);
                            o_ArtNet_Op_ArtAddress.setSWOut(intByteIndex, byteToSend);
                            boolPortTypeChanged = true;
                        }
                    } else if (o_PlugInPanel.getNew_PlugInType() == 1) {
                        byteToSend = o_PlugInPanel.getNew_SWIn();
                        byteToSend = (byte)(byteToSend | 0xFFFFFF80);
                        if (intByteIndex >= 0 && intByteIndex < 4) {
                            o_ArtNet_Op_ArtAddress.setSWIn(intByteIndex, byteToSend);
                            boolPortTypeChanged = true;
                        }
                    }
                    if (o_LAN_PlugIn.getProtocolType() == o_PlugInPanel.getNew_ProtocolType() && o_LAN_PlugIn.getMergeMode() == o_PlugInPanel.getNew_MergeMode()) continue;
                    o_ChangedPlugInPanels.add(o_PlugInPanel);
                }
                o_ArtNet_Op_ArtAddress.setSWVideo((byte)0);
                o_ArtNet_Op_ArtAddress.setCommand((byte)0);
                o_LAN_Interface.sendArtNet_OP(o_ArtNet_Op_ArtAddress, o_LAN_Device_ArtNet.getRemoteInetAddress(), o_LAN_Device_ArtNet.getProtocolConfigurationDetected());
                boolean boolSend = false;
                if (o_ChangedPlugInPanels.size() <= 0) continue;
                o_ArtNet_Op_ArtAddress.setNetSwitch((byte)127);
                o_ArtNet_Op_ArtAddress.setSubSwitch((byte)127);
                for (int intPlugInPanel = 0; intPlugInPanel < o_ChangedPlugInPanels.size(); ++intPlugInPanel) {
                    for (int intByte = 0; intByte < 4; ++intByte) {
                        o_ArtNet_Op_ArtAddress.setSWIn(intByte, (byte)127);
                        o_ArtNet_Op_ArtAddress.setSWOut(intByte, (byte)127);
                    }
                    o_PlugInPanel = (LAN_Device_Configuration_PlugInPanel)o_ChangedPlugInPanels.get(intPlugInPanel);
                    if (o_PlugInPanel == null || (o_LAN_PlugIn = o_PlugInPanel.getLAN_PlugIn()) == null || o_LAN_PlugIn.getPlugInType() != 0) continue;
                    if (o_PlugInPanel.getNew_ProtocolType() != o_LAN_PlugIn.getProtocolType()) {
                        byteToSend = o_PlugInPanel.getNew_ProtocolType() == 3 ? Byte.valueOf((byte)(0x70 | o_LAN_PlugIn.getPortIndex() & 0xF)) : Byte.valueOf((byte)(0x60 | o_LAN_PlugIn.getPortIndex() & 0xF));
                        o_ArtNet_Op_ArtAddress.setCommand(byteToSend);
                        o_LAN_Interface.sendArtNet_OP(o_ArtNet_Op_ArtAddress, o_LAN_Device_ArtNet.getRemoteInetAddress(), o_LAN_Device_ArtNet.getProtocolConfigurationDetected());
                    }
                    if (o_PlugInPanel.getNew_MergeMode() == o_LAN_PlugIn.getMergeMode()) continue;
                    byteToSend = o_PlugInPanel.getNew_MergeMode() == 0 ? Byte.valueOf((byte)(1 | o_LAN_PlugIn.getPortIndex() & 0xF)) : (o_PlugInPanel.getNew_MergeMode() == 2 ? Byte.valueOf((byte)(0x10 | o_LAN_PlugIn.getPortIndex() & 0xF)) : Byte.valueOf((byte)(0x50 | o_LAN_PlugIn.getPortIndex() & 0xF)));
                    o_ArtNet_Op_ArtAddress.setCommand(byteToSend);
                    o_LAN_Interface.sendArtNet_OP(o_ArtNet_Op_ArtAddress, o_LAN_Device_ArtNet.getRemoteInetAddress(), o_LAN_Device_ArtNet.getProtocolConfigurationDetected());
                }
            }
        }
        o_LAN_Device_ArtNet.setName(stringName);
        o_LAN_Device_ArtNet.setLongName(stringLongName);
    }

    public void saveNetworkSettings() {
        LAN_Device o_LAN_Device = this.m_LAN_Device;
        if (o_LAN_Device == null) {
            return;
        }
        if (!(o_LAN_Device instanceof LAN_Device_ArtNet)) {
            return;
        }
        LAN_Device_ArtNet o_LAN_Device_ArtNet = (LAN_Device_ArtNet)o_LAN_Device;
        if (o_LAN_Device_ArtNet.getIPProgrammable()) {
            byte[] o_IPAddress = this.checkIP(this.jTextField_IP4.getText());
            if (o_IPAddress == null) {
                return;
            }
            byte[] o_SubNetMask = this.checkSubNetMask(this.jTextField_SubNetMask.getText());
            if (o_SubNetMask == null) {
                return;
            }
            ArtNet_Op_ArtIPProg o_ArtNet_Op_ArtIPProg = o_LAN_Device_ArtNet.getArtNet_Op_ArtIPProg();
            if (o_LAN_Device_ArtNet.getRemoteDHCP_Capable() && this.jCheckBox_DHCP.isSelected()) {
                o_ArtNet_Op_ArtIPProg.setCommand_DHCP();
            } else {
                if (this.m_IPOk == IP_WRONG || this.m_IPOk == IP_USEDSEVERAL || !this.m_SubNetMaskOk) {
                    return;
                }
                o_ArtNet_Op_ArtIPProg.setCommand_IPSubNet();
            }
            o_ArtNet_Op_ArtIPProg.setIP4Address(o_IPAddress);
            o_ArtNet_Op_ArtIPProg.setSubNetMask(o_SubNetMask);
            LAN_Interface o_LAN_Interface = o_LAN_Device_ArtNet.getLAN_Interface();
            if (o_LAN_Interface != null) {
                o_LAN_Interface.sendArtNet_OP(o_ArtNet_Op_ArtIPProg, o_LAN_Device_ArtNet.getRemoteInetAddress(), o_LAN_Device_ArtNet.getProtocolConfigurationDetected());
            }
        }
    }

    private byte[] checkIP(String p_IP4Address) {
        InetAddress o_InetAddress;
        LAN_Device_ArtNet o_LAN_Device_ArtNet = null;
        boolean boolIPConflict = false;
        LAN_Device o_LAN_Device = this.m_LAN_Device;
        if (o_LAN_Device != null && o_LAN_Device instanceof LAN_Device_ArtNet) {
            o_LAN_Device_ArtNet = (LAN_Device_ArtNet)o_LAN_Device;
        }
        if (o_LAN_Device_ArtNet == null) {
            this.m_IPOk = IP_WRONG;
            return null;
        }
        try {
            o_InetAddress = Inet4Address.getByName(p_IP4Address);
            p_IP4Address = o_InetAddress.getHostAddress();
        }
        catch (Exception e) {
            o_InetAddress = o_LAN_Device_ArtNet.getRemoteInetAddress();
            p_IP4Address = o_InetAddress.getHostAddress();
        }
        this.checkIPConflict(p_IP4Address);
        return o_InetAddress.getAddress();
    }

    public boolean checkIPConflict(String p_IP4Address) {
        if (p_IP4Address == null) {
            return false;
        }
        LAN_Device_ArtNet o_LAN_Device_ArtNet = null;
        boolean boolIPConflict = false;
        LAN_Device o_LAN_Device = this.m_LAN_Device;
        if (o_LAN_Device == null) {
            this.m_IPOk = IP_WRONG;
            return false;
        }
        int intIPOK = IP_OK;
        if (!(o_LAN_Device instanceof LAN_Device_ArtNet)) {
            return false;
        }
        o_LAN_Device_ArtNet = (LAN_Device_ArtNet)o_LAN_Device;
        LAN_Interface o_LAN_Interface = o_LAN_Device_ArtNet.getLAN_Interface();
        if (o_LAN_Interface != null) {
            o_LAN_Interface.getLAN_Devices_ArtNet_ByIP(p_IP4Address, this.m_LAN_Devices_ArtNet);
            if (this.m_LAN_Devices_ArtNet.size() == 1) {
                if (this.m_LAN_Devices_ArtNet.get(0) != o_LAN_Device_ArtNet) {
                    intIPOK = IP_USEDSEVERAL;
                }
            } else if (this.m_LAN_Devices_ArtNet.size() > 0) {
                intIPOK = IP_USEDSEVERAL;
            }
        }
        this.m_IPOk = intIPOK;
        return boolIPConflict;
    }

    public byte[] checkSubNetMask(String p_SubNetMask) {
        byte[] o_ByteParts = new byte[4];
        String[] o_StringParts = p_SubNetMask == null ? null : p_SubNetMask.split("[.]");
        for (int intPos = 0; intPos < 4; ++intPos) {
            int intPart;
            if (o_StringParts == null || intPos >= o_StringParts.length) {
                intPart = 0;
            } else {
                try {
                    intPart = Integer.valueOf(o_StringParts[intPos]);
                    if (intPart > 255) {
                        intPart = 255;
                    } else if (intPart < 0) {
                        intPart = 0;
                    }
                }
                catch (Exception e) {
                    intPart = 0;
                }
            }
            o_ByteParts[intPos] = (byte)(intPart & 0xFF);
        }
        return this.checkSubNetMask(o_ByteParts);
    }

    public byte[] checkSubNetMask(byte[] p_SubNetMask) {
        boolean boolWas0 = false;
        boolean boolValid = true;
        LAN_Device_ArtNet o_LAN_Device_ArtNet = null;
        byte[] o_SubNetMask = new byte[4];
        LAN_Device o_LAN_Device = this.m_LAN_Device;
        if (o_LAN_Device != null && o_LAN_Device instanceof LAN_Device_ArtNet) {
            o_LAN_Device_ArtNet = (LAN_Device_ArtNet)o_LAN_Device;
        }
        if (o_LAN_Device_ArtNet == null) {
            this.m_SubNetMaskOk = false;
            return null;
        }
        for (int intPos = 0; intPos < 4; ++intPos) {
            int bytePart = p_SubNetMask == null || intPos >= p_SubNetMask.length ? 0 : p_SubNetMask[intPos];
            if ((bytePart & 0xFF) > 0) {
                if (boolWas0) {
                    boolValid = false;
                }
            } else if (bytePart == 0) {
                if (intPos == 0) {
                    boolValid = false;
                }
                boolWas0 = true;
            }
            o_SubNetMask[intPos] = bytePart;
        }
        this.m_SubNetMaskOk = boolValid;
        return o_SubNetMask;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this.m_LAN_Device) {
            if ("prop_deviceclose".equals(evt.getPropertyName())) {
                this.setLAN_Device(null);
                this.setVisible(false);
                return;
            }
            if ("prop_deviceartnetbindindexstructure".equals(evt.getPropertyName())) {
                this.setLAN_Device(this.m_LAN_Device);
                return;
            }
            EventQueue.invokeLater(this.m_Runnable_RefreshGUI);
        }
    }
}

