/*
 * Decompiled with CFR 0.152.
 */
package DMXHardwarePackage;

import ArtNetPackage.ArtNet;
import ArtNetPackage.ArtNet_Op;
import ArtNetPackage.ArtNet_Op_ArtDMX;
import ArtNetPackage.ArtNet_Op_ArtIPProgReply;
import ArtNetPackage.ArtNet_Op_ArtPoll;
import ArtNetPackage.ArtNet_Op_ArtPollReply;
import ArtNetPackage.ProtocolConfiguration_ArtNet;
import DMXHardwarePackage.LAN_Device;
import DMXHardwarePackage.LAN_Device_ArtNet;
import DMXHardwarePackage.LAN_Interface;
import ProtocolTools.RefreshTimer;
import java.net.InetAddress;

public class ArtNetInterpreter
implements ProtocolConfiguration_ArtNet.ArtNetInterpreter {
    private RefreshTimer m_RefreshTimer_ArtNetPoll;
    private ArtNet_Op_ArtPoll m_ArtNet_Op_ArtPoll;
    private LAN_Interface m_LAN_Interface;
    private static final Object m_SyncReceived = new Object();

    public ArtNetInterpreter(LAN_Interface p_LAN_Interface) {
        this.m_LAN_Interface = p_LAN_Interface;
        this.initMembers();
    }

    private void initMembers() {
        this.m_ArtNet_Op_ArtPoll = ArtNet_Op_ArtPoll.getFromPool();
    }

    public void close() {
        this.stopArtNetPoll();
        this.m_ArtNet_Op_ArtPoll.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void eventReceivedArtNet_OP(ProtocolConfiguration_ArtNet p_ProtocolConfiguration_ArtNet, ArtNet_Op p_ArtNet_Op, InetAddress p_RemoteInetAddress) {
        if (p_ArtNet_Op == null) {
            return;
        }
        LAN_Interface o_LAN_Interface = this.m_LAN_Interface;
        Object object = m_SyncReceived;
        synchronized (object) {
            switch (p_ArtNet_Op.getOpCode()) {
                case 8192: {
                    p_ArtNet_Op.close();
                    break;
                }
                case 8448: {
                    if (!(p_ArtNet_Op instanceof ArtNet_Op_ArtPollReply)) {
                        return;
                    }
                    ArtNet_Op_ArtPollReply o_ArtNet_Op_ArtPollReply = (ArtNet_Op_ArtPollReply)p_ArtNet_Op;
                    LAN_Device_ArtNet.interpreteArtPollReply(p_ProtocolConfiguration_ArtNet, o_ArtNet_Op_ArtPollReply, this.m_LAN_Interface, p_RemoteInetAddress);
                    break;
                }
                case 20480: {
                    if (!(p_ArtNet_Op instanceof ArtNet_Op_ArtDMX)) {
                        return;
                    }
                    ArtNet_Op_ArtDMX o_ArtNet_Op_ArtDMX = (ArtNet_Op_ArtDMX)p_ArtNet_Op;
                    LAN_Device_ArtNet.interpreteArtDMX(p_ProtocolConfiguration_ArtNet, o_ArtNet_Op_ArtDMX, this.m_LAN_Interface, p_RemoteInetAddress);
                    break;
                }
                case 63744: {
                    if (!(p_ArtNet_Op instanceof ArtNet_Op_ArtIPProgReply)) {
                        return;
                    }
                    ArtNet_Op_ArtIPProgReply o_ArtNet_Op_ArtIPProgReply = (ArtNet_Op_ArtIPProgReply)p_ArtNet_Op;
                    LAN_Device_ArtNet.interpreteArtIPProgReply(p_ProtocolConfiguration_ArtNet, o_ArtNet_Op_ArtIPProgReply, o_LAN_Interface, p_RemoteInetAddress);
                    break;
                }
                default: {
                    p_ArtNet_Op.close();
                    return;
                }
            }
        }
    }

    @Override
    public void sendArtNet_OP(ArtNet_Op p_ArtNet_Op, InetAddress p_RemoteAddress, ProtocolConfiguration_ArtNet p_ProtocolConfiguration_ArtNet) {
        LAN_Interface o_LAN_Interface = this.m_LAN_Interface;
        if (o_LAN_Interface == null) {
            return;
        }
        o_LAN_Interface.sendArtNet_OP(p_ArtNet_Op, p_RemoteAddress, p_ProtocolConfiguration_ArtNet);
    }

    @Override
    public void sendArtNet_OP_Broadcast(ArtNet_Op p_ArtNet_Op) {
        LAN_Interface o_LAN_Interface = this.m_LAN_Interface;
        if (o_LAN_Interface == null) {
            return;
        }
        o_LAN_Interface.sendArtNet_OP_Broadcast(p_ArtNet_Op);
    }

    public void startArtNetPoll() {
        if (this.m_RefreshTimer_ArtNetPoll == null) {
            this.m_RefreshTimer_ArtNetPoll = new RefreshTimer(ArtNet.ArtNetRefreshTime);
            this.m_RefreshTimer_ArtNetPoll.addRefreshTimerListener(new RefreshTimer.RefreshTimer_Listener(){

                @Override
                public void eventRefreshTimer(RefreshTimer p_RefreshTimer) {
                    ArtNetInterpreter.this.cyclePollEnded();
                    ArtNetInterpreter.this.cyclePollStarted();
                    ArtNetInterpreter.this.sendArtNet_OP_Broadcast(ArtNetInterpreter.this.m_ArtNet_Op_ArtPoll);
                }
            });
        }
        if (!this.m_RefreshTimer_ArtNetPoll.isRunning()) {
            this.sendArtNet_OP_Broadcast(this.m_ArtNet_Op_ArtPoll);
            this.m_RefreshTimer_ArtNetPoll.start();
        }
    }

    public void stopArtNetPoll() {
        if (this.m_RefreshTimer_ArtNetPoll != null) {
            this.m_RefreshTimer_ArtNetPoll.stop();
        }
    }

    public void cyclePollStarted() {
        LAN_Interface o_LAN_Interface = this.m_LAN_Interface;
        if (o_LAN_Interface == null) {
            return;
        }
        for (int intDevice = 0; intDevice < o_LAN_Interface.getLAN_DeviceCount(); ++intDevice) {
            LAN_Device o_LAN_Device = o_LAN_Interface.getLAN_Device(intDevice);
            if (o_LAN_Device == null || !(o_LAN_Device instanceof LAN_Device_ArtNet)) continue;
            ((LAN_Device_ArtNet)o_LAN_Device).cyclePollStarted();
        }
    }

    public void cyclePollEnded() {
        LAN_Interface o_LAN_Interface = this.m_LAN_Interface;
        if (o_LAN_Interface == null) {
            return;
        }
        for (int intDevice = 0; intDevice < o_LAN_Interface.getLAN_DeviceCount(); ++intDevice) {
            LAN_Device o_LAN_Device = o_LAN_Interface.getLAN_Device(intDevice);
            if (o_LAN_Device == null || !(o_LAN_Device instanceof LAN_Device_ArtNet)) continue;
            ((LAN_Device_ArtNet)o_LAN_Device).cyclePollEnded();
        }
    }
}

