/*
 * Decompiled with CFR 0.152.
 */
package SocketMessagePackage;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class LiveDBMessageStreamPackage
implements Externalizable {
    private String m_StreamID;
    private boolean m_EndOfStream;
    private boolean m_Error;
    private boolean m_Canceled;
    private long m_DataPosition;
    private int m_DataLengthValid;
    private byte[] m_DataBytes;
    static final long serialVersionUID = -8939528430616505476L;

    public LiveDBMessageStreamPackage() {
        this.initMembers();
    }

    public LiveDBMessageStreamPackage(String p_StreamID, long p_OldDataPosition, int p_PackageSize) {
        this.initMembers();
        this.m_StreamID = p_StreamID;
        this.m_DataPosition = p_OldDataPosition;
        if (p_PackageSize < 0) {
            p_PackageSize = 102400;
        }
        this.m_DataBytes = new byte[p_PackageSize];
    }

    private void initMembers() {
        this.m_EndOfStream = false;
        this.m_Error = false;
        this.m_Canceled = false;
        this.m_DataLengthValid = 0;
        this.m_DataPosition = 0L;
    }

    public int readStream(InputStream p_InputStream) {
        this.m_DataLengthValid = 0;
        if (p_InputStream == null) {
            this.m_Error = true;
            this.m_EndOfStream = true;
            return this.m_DataLengthValid;
        }
        while (this.m_DataLengthValid < this.m_DataBytes.length && !this.m_EndOfStream && !this.m_Error) {
            int intSize;
            try {
                intSize = p_InputStream.read(this.m_DataBytes, this.m_DataLengthValid, this.m_DataBytes.length - this.m_DataLengthValid);
                if (intSize < 0) {
                    this.m_EndOfStream = true;
                    try {
                        p_InputStream.close();
                    }
                    catch (Exception exception) {}
                    continue;
                }
                this.m_DataLengthValid += intSize;
            }
            catch (Exception e) {
                this.m_Error = true;
                intSize = 0;
            }
        }
        this.m_DataPosition += (long)this.m_DataLengthValid;
        return this.m_DataLengthValid;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int intSize = this.m_StreamID.length();
        out.writeInt(intSize);
        out.writeChars(this.m_StreamID);
        out.writeBoolean(this.m_EndOfStream);
        out.writeBoolean(this.m_Canceled);
        out.writeBoolean(this.m_Error);
        out.writeLong(this.m_DataPosition);
        out.writeInt(this.m_DataLengthValid);
        for (int intByte = 0; intByte < this.m_DataLengthValid; ++intByte) {
            out.writeByte(this.m_DataBytes[intByte]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int intSize = in.readInt();
        char[] charID = new char[intSize];
        for (int intChar = 0; intChar < intSize; ++intChar) {
            charID[intChar] = in.readChar();
        }
        this.m_StreamID = new String(charID);
        this.m_EndOfStream = in.readBoolean();
        this.m_Canceled = in.readBoolean();
        this.m_Error = in.readBoolean();
        this.m_DataPosition = in.readLong();
        this.m_DataLengthValid = in.readInt();
        this.m_DataBytes = new byte[this.m_DataLengthValid];
        for (int intByte = 0; intByte < this.m_DataLengthValid; ++intByte) {
            this.m_DataBytes[intByte] = in.readByte();
        }
    }

    public String getStreamID() {
        return this.m_StreamID;
    }

    public void setCanceled(boolean p_Canceled) {
        this.m_Canceled = p_Canceled;
    }

    public boolean getCanceled() {
        return this.m_Canceled;
    }

    public void setError(boolean p_Error) {
        this.m_Error = p_Error;
    }

    public boolean getError() {
        return this.m_Error;
    }

    public void setEndOfStream(boolean p_EndOfStream) {
        this.m_EndOfStream = p_EndOfStream;
    }

    public boolean getEndOfStream() {
        return this.m_EndOfStream;
    }

    public long getDataPosition() {
        return this.m_DataPosition;
    }

    public int getDataLengthValid() {
        return this.m_DataLengthValid;
    }

    public void setDataLengthValid(int p_ValidDataBytesCount) {
        this.m_DataLengthValid = p_ValidDataBytesCount;
    }

    public byte[] getDataBytes() {
        return this.m_DataBytes;
    }

    public void setDataBytes(byte[] p_DataBytes) {
        if (p_DataBytes == null) {
            this.m_DataBytes = new byte[0];
            return;
        }
        int intBytesCount = p_DataBytes.length;
        this.m_DataBytes = new byte[intBytesCount];
        for (int intByte = 0; intByte < intBytesCount; ++intByte) {
            this.m_DataBytes[intByte] = p_DataBytes[intByte];
        }
    }
}

