/*
 * Decompiled with CFR 0.152.
 */
package ImageToolsPackage;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class ImageTools {
    public static void writeImage(ObjectOutput p_ObjectOutput, Image p_Image) throws IOException {
        int[] arrayImage = null;
        int intWidth = 0;
        int intHeight = 0;
        if (p_Image != null) {
            intWidth = p_Image.getWidth(null);
            intHeight = p_Image.getHeight(null);
            try {
                arrayImage = ImageTools.getArrayFromImage(p_Image, intWidth, intHeight);
            }
            catch (InterruptedException error) {
                throw new IOException(error.getMessage(), error.getCause());
            }
        }
        p_ObjectOutput.writeInt(intWidth);
        p_ObjectOutput.writeInt(intHeight);
        p_ObjectOutput.writeObject(arrayImage);
    }

    public static Image readImage(ObjectInput p_ObjectInput) throws IOException, ClassNotFoundException {
        int intWidth = p_ObjectInput.readInt();
        int intHeight = p_ObjectInput.readInt();
        int[] arrayImage = (int[])p_ObjectInput.readObject();
        Image o_Image = ImageTools.getImageFromArray(arrayImage, intWidth, intHeight);
        return o_Image;
    }

    public static int[] getArrayFromImage(Image img, int width, int height) throws InterruptedException {
        if (img == null) {
            return null;
        }
        int[] pixels = new int[width * height];
        PixelGrabber pg = new PixelGrabber(img, 0, 0, width, height, pixels, 0, width);
        pg.grabPixels();
        return pixels;
    }

    public static Image getImageFromArray(int[] pixels, int width, int height) {
        if (pixels == null) {
            return null;
        }
        MemoryImageSource mis = new MemoryImageSource(width, height, pixels, 0, width);
        Toolkit tk = Toolkit.getDefaultToolkit();
        return tk.createImage(mis);
    }
}

