/*
 * Decompiled with CFR 0.152.
 */
package ProtocolTools;

import java.util.ArrayList;

public class RefreshTimer
implements Runnable {
    private int m_Milliseconds;
    private boolean m_Stop;
    private Thread m_ThreadTimer;
    private final Object m_SyncTimer = new Object();
    private ArrayList<RefreshTimer_Listener> m_RefreshTimer_Listeners;
    private RefreshTimer m_SelfReference;
    private final Object m_SyncListeners = new Object();

    public RefreshTimer(int p_Milliseconds) {
        this.initMembers();
        this.m_SelfReference = this;
        this.m_Milliseconds = p_Milliseconds;
    }

    private void initMembers() {
        this.m_RefreshTimer_Listeners = new ArrayList();
        this.m_Stop = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.m_SyncListeners;
        synchronized (object) {
            this.m_RefreshTimer_Listeners.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (this.m_Milliseconds < 0) {
            return;
        }
        Object object = this.m_SyncTimer;
        synchronized (object) {
            if (this.m_ThreadTimer == null) {
                this.m_Stop = false;
                this.m_ThreadTimer = new Thread(this);
                this.m_ThreadTimer.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.m_Stop) {
            return;
        }
        Object object = this.m_SyncTimer;
        synchronized (object) {
            this.m_Stop = true;
            this.m_SyncTimer.notifyAll();
            this.m_ThreadTimer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        Object object = this.m_SyncTimer;
        synchronized (object) {
            if (this.m_ThreadTimer != null && !this.m_Stop) {
                return true;
            }
        }
        return false;
    }

    public void setRefreshTime(int p_Milliseconds) {
        this.stop();
        this.m_Milliseconds = p_Milliseconds;
    }

    public long getSystemTimeMilliseconds() {
        long longNanoSeconds = System.nanoTime();
        return longNanoSeconds / 1000000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.m_Stop) {
            Object object = this.m_SyncTimer;
            synchronized (object) {
                try {
                    long longWaitStart;
                    for (long longWaitTime = (long)this.m_Milliseconds; longWaitTime > 0L && !this.m_Stop; longWaitTime -= System.nanoTime() / 1000000L - longWaitStart) {
                        longWaitStart = System.nanoTime() / 1000000L;
                        this.m_SyncTimer.wait(longWaitTime);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.m_Stop) {
                    break;
                }
                this.notifyTimer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRefreshTimerListener(RefreshTimer_Listener p_RefreshTimer_Listener) {
        if (p_RefreshTimer_Listener == null) {
            return;
        }
        Object object = this.m_SyncListeners;
        synchronized (object) {
            if (this.m_RefreshTimer_Listeners.contains(p_RefreshTimer_Listener)) {
                return;
            }
            this.m_RefreshTimer_Listeners.add(p_RefreshTimer_Listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRefreshTimerListener(RefreshTimer_Listener p_RefreshTimer_Listener) {
        if (p_RefreshTimer_Listener == null) {
            return;
        }
        Object object = this.m_SyncListeners;
        synchronized (object) {
            if (!this.m_RefreshTimer_Listeners.contains(p_RefreshTimer_Listener)) {
                return;
            }
            this.m_RefreshTimer_Listeners.remove(p_RefreshTimer_Listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyTimer() {
        ArrayList<RefreshTimer_Listener> o_RefreshTimer_Listeners;
        Object object = this.m_SyncListeners;
        synchronized (object) {
            if (this.m_RefreshTimer_Listeners == null) {
                return;
            }
            if (this.m_RefreshTimer_Listeners.size() <= 0) {
                return;
            }
            o_RefreshTimer_Listeners = new ArrayList<RefreshTimer_Listener>(this.m_RefreshTimer_Listeners.size());
            o_RefreshTimer_Listeners.addAll(this.m_RefreshTimer_Listeners);
        }
        for (int intListener = 0; intListener < o_RefreshTimer_Listeners.size(); ++intListener) {
            RefreshTimer_Listener o_RefreshTimer_Listener = (RefreshTimer_Listener)o_RefreshTimer_Listeners.get(intListener);
            o_RefreshTimer_Listener.eventRefreshTimer(this.m_SelfReference);
        }
        o_RefreshTimer_Listeners.clear();
    }

    public static interface RefreshTimer_Listener {
        public void eventRefreshTimer(RefreshTimer var1);
    }
}

