/*
 * Decompiled with CFR 0.152.
 */
package ProtocolTools;

import java.util.ArrayList;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import javax.swing.text.JTextComponent;

public class DocumentFilter_Integer
extends DocumentFilter {
    private ArrayList<EventIntegerListener> m_EventIntegerListeners;
    private Object m_DocumentParent;

    public DocumentFilter_Integer(AbstractDocument p_Document) {
        this.initMembers();
        if (p_Document != null) {
            this.m_DocumentParent = p_Document;
            p_Document.setDocumentFilter(this);
        }
    }

    public DocumentFilter_Integer(JTextComponent p_TextComponent) {
        this.initMembers();
        AbstractDocument o_AbstractDocument = p_TextComponent == null ? null : (AbstractDocument)p_TextComponent.getDocument();
        if (o_AbstractDocument != null) {
            this.m_DocumentParent = p_TextComponent;
            o_AbstractDocument.setDocumentFilter(this);
        }
    }

    private void initMembers() {
        this.m_EventIntegerListeners = new ArrayList();
    }

    public void close() {
        this.m_EventIntegerListeners.clear();
    }

    @Override
    public void insertString(DocumentFilter.FilterBypass p_FilterBypass, int p_Offset, String p_String, AttributeSet p_AttributeSet) throws BadLocationException {
        try {
            String stringDocument;
            AbstractDocument o_Document = (AbstractDocument)p_FilterBypass.getDocument();
            if (o_Document == null) {
                return;
            }
            int intDocumentLength = o_Document.getLength();
            if (intDocumentLength <= 0) {
                stringDocument = p_String;
            } else {
                stringDocument = o_Document.getText(0, o_Document.getLength());
                stringDocument = stringDocument.substring(0, p_Offset) + p_String + stringDocument.substring(p_Offset, stringDocument.length());
            }
            if (!this.checkString(stringDocument)) {
                return;
            }
            super.insertString(p_FilterBypass, p_Offset, p_String, p_AttributeSet);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void replace(DocumentFilter.FilterBypass p_FilterBypass, int p_Offset, int p_Length, String p_String, AttributeSet p_AttributeSet) throws BadLocationException {
        try {
            String stringDocument;
            AbstractDocument o_Document = (AbstractDocument)p_FilterBypass.getDocument();
            if (o_Document == null) {
                return;
            }
            int intDocumentLenght = o_Document.getLength();
            stringDocument = intDocumentLenght <= 0 ? p_String : (p_Offset + p_Length <= (stringDocument = o_Document.getText(0, intDocumentLenght)).length() ? stringDocument.substring(0, p_Offset) + p_String + stringDocument.substring(p_Offset + p_Length) : stringDocument.substring(0, p_Offset) + p_String);
            if (p_Length > intDocumentLenght) {
                return;
            }
            if (!this.checkString(stringDocument)) {
                return;
            }
            super.replace(p_FilterBypass, p_Offset, p_Length, p_String, p_AttributeSet);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void remove(DocumentFilter.FilterBypass p_FilterBypass, int p_Offset, int p_Length) throws BadLocationException {
        try {
            AbstractDocument o_Document = (AbstractDocument)p_FilterBypass.getDocument();
            if (o_Document == null) {
                return;
            }
            int intDocumentLenght = o_Document.getLength();
            String stringDocument = o_Document.getText(0, intDocumentLenght);
            stringDocument = p_Offset + p_Length <= stringDocument.length() ? stringDocument.substring(0, p_Offset) + stringDocument.substring(p_Offset + p_Length) : stringDocument.substring(0, p_Offset);
            if (p_Length > intDocumentLenght) {
                return;
            }
            if (!this.checkString(stringDocument)) {
                return;
            }
            super.remove(p_FilterBypass, p_Offset, p_Length);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean checkString(String p_String) {
        try {
            int intValue = Integer.parseInt(p_String);
            for (int intListener = 0; intListener < this.m_EventIntegerListeners.size(); ++intListener) {
                EventIntegerListener o_EventIntegerListener = this.m_EventIntegerListeners.get(intListener);
                if (o_EventIntegerListener.checkInteger(intValue, this.m_DocumentParent)) continue;
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public void addEventIntegerListener(EventIntegerListener p_EventIntegerListener) {
        if (p_EventIntegerListener == null) {
            return;
        }
        if (this.m_EventIntegerListeners.contains(p_EventIntegerListener)) {
            return;
        }
        this.m_EventIntegerListeners.add(p_EventIntegerListener);
    }

    public void removeEventIntegerListener(EventIntegerListener p_EventIntegerListener) {
        if (p_EventIntegerListener == null) {
            return;
        }
        if (!this.m_EventIntegerListeners.contains(p_EventIntegerListener)) {
            return;
        }
        this.m_EventIntegerListeners.remove(p_EventIntegerListener);
    }

    public static interface EventIntegerListener {
        public boolean checkInteger(int var1, Object var2);
    }
}

