/*
 * Decompiled with CFR 0.152.
 */
package ArtNetPackage;

import ArtNetPackage.ArtNet;
import ArtNetPackage.ArtNetReceiver;
import ArtNetPackage.ArtNetSender;
import ArtNetPackage.ArtNet_Op;
import ArtNetPackage.ArtNet_Op_ArtDMX;
import ArtNetPackage.ArtNet_Op_ArtPoll;
import NetworkTools.NetworkTool;
import NetworkTools.UDP_Transport_Broadcast;
import ProtocolPackage.Protocols;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;

public class ProtocolConfiguration_ArtNet
extends Protocols.ProtocolConfiguration
implements Protocols.ProtocolSenderInterface {
    public static final int SOFTWAREVERSION = 1;
    public static int SocketSOTimeout = 1000;
    private boolean m_Enabled_ArtNet;
    private InterfaceAddress m_InterfaceAddress;
    private InetAddress m_InetAddress_ArtNet;
    private InetAddress m_InetAddress_ArtNetBroadcast;
    private UDP_Transport_Broadcast m_UDP_Transport_ArtNet;
    private ArtNetSender m_SenderArtNet;
    private ArtNetReceiver m_ReceiverArtNet;
    private int m_ConnectionStatus_ArtNet;
    private ArtNetInterpreter m_ArtNetInterpreter;
    private boolean m_Detected;
    private final Object m_SyncInterpreter = new Object();
    private ArtNet_Op_ArtPoll m_ArtNet_Op_ArtPoll;

    public ProtocolConfiguration_ArtNet(Protocols.ProtocolLANInterface p_ProtocolLANInterface) {
        super(1, p_ProtocolLANInterface);
        this.initMembers();
    }

    private void initMembers() {
        this.m_Detected = true;
        this.m_ConnectionStatus_ArtNet = 2;
        this.m_Enabled_ArtNet = true;
        this.m_InterfaceAddress = null;
        this.m_InetAddress_ArtNet = null;
        this.m_InetAddress_ArtNetBroadcast = null;
        this.m_ArtNet_Op_ArtPoll = ArtNet_Op_ArtPoll.getFromPool();
    }

    @Override
    public void close() {
        if (this.m_ProtocolLANInterface != null) {
            this.m_ProtocolLANInterface.removeProblemInetAddress(this.m_InetAddress_ArtNet);
        }
        this.disconnect();
        this.m_ArtNetInterpreter = null;
    }

    public void setArtNetInterpreter(ArtNetInterpreter p_ArtNetInterpreter) {
        this.m_ArtNetInterpreter = p_ArtNetInterpreter;
    }

    public static void setTimeout_Milliseconds(int p_Milliseconds) {
        if (p_Milliseconds < 0) {
            return;
        }
        ArtNet.ArtNetRefreshTime = p_Milliseconds;
    }

    public static int getTimeout_Milliseconds() {
        return ArtNet.ArtNetRefreshTime;
    }

    @Override
    public byte[] getLocalUUID() {
        Protocols.ProtocolLANInterface o_ProtocolLANInterface = this.m_ProtocolLANInterface;
        if (o_ProtocolLANInterface == null) {
            return null;
        }
        return o_ProtocolLANInterface.getLocalUUID();
    }

    public void setDetected(boolean p_Detected) {
        this.m_Detected = p_Detected;
    }

    public boolean getDetected() {
        return this.m_Detected;
    }

    public int setInetAddress_ArtNet(NetworkInterface p_NetworkInterface, InterfaceAddress p_InterfaceAddress) {
        this.m_InterfaceAddress = p_InterfaceAddress;
        if (p_NetworkInterface == null || p_InterfaceAddress == null) {
            return 2;
        }
        if (NetworkTool.isEqual((InetAddress)p_InterfaceAddress.getAddress(), (InetAddress)this.m_InetAddress_ArtNet) && NetworkTool.isEqual((InetAddress)p_InterfaceAddress.getBroadcast(), (InetAddress)this.m_InetAddress_ArtNetBroadcast)) {
            return 2;
        }
        return this.connectArtNet(p_NetworkInterface, p_InterfaceAddress);
    }

    public int connectArtNet(NetworkInterface p_NetworkInterface, InterfaceAddress p_InterfaceAddress_ArtNet) {
        this.disconnectArtNet();
        if (p_InterfaceAddress_ArtNet == null) {
            return 2;
        }
        this.m_InetAddress_ArtNet = p_InterfaceAddress_ArtNet.getAddress();
        this.m_InetAddress_ArtNetBroadcast = p_InterfaceAddress_ArtNet.getBroadcast();
        this.m_UDP_Transport_ArtNet = new UDP_Transport_Broadcast();
        boolean boolSuccess = this.m_UDP_Transport_ArtNet.bind(p_NetworkInterface, this.m_InterfaceAddress, this.m_InetAddress_ArtNet, this.m_InetAddress_ArtNetBroadcast, Integer.valueOf(Protocols.ARTNET_PORT));
        if (boolSuccess) {
            this.m_UDP_Transport_ArtNet.setSOTimeout(SocketSOTimeout);
        }
        if (boolSuccess) {
            this.m_ConnectionStatus_ArtNet = 5;
            this.m_ReceiverArtNet = new ArtNetReceiver(this);
            this.m_ReceiverArtNet.setUDP_Transport(this.m_UDP_Transport_ArtNet);
            this.m_SenderArtNet = new ArtNetSender(this);
            this.m_SenderArtNet.setUDP_Transport(this.m_UDP_Transport_ArtNet);
            this.m_SenderArtNet.setActive(true);
            this.m_ReceiverArtNet.setActive(true);
            this.m_ConnectionStatus_ArtNet = 5;
            if (this.m_ReceiverArtNet.getUDP_Transport_Broadcast() != null) {
                this.m_ReceiverArtNet.getUDP_Transport_Broadcast().startReceive();
            }
            if (this.m_ProtocolLANInterface != null) {
                this.m_ProtocolLANInterface.removeProblemInetAddress(this.m_InetAddress_ArtNet);
            }
        } else {
            if (this.m_ProtocolLANInterface != null) {
                this.m_ProtocolLANInterface.addProblemInetAddress(this.m_InetAddress_ArtNet);
            }
            this.m_ConnectionStatus_ArtNet = 2;
        }
        return this.m_ConnectionStatus_ArtNet;
    }

    public void disconnectArtNet() {
        UDP_Transport_Broadcast o_UDP_Transport = this.m_UDP_Transport_ArtNet;
        ArtNetReceiver o_ArtNetReceiver = this.m_ReceiverArtNet;
        ArtNetSender o_ArtNetSender = this.m_SenderArtNet;
        this.m_ConnectionStatus_ArtNet = 2;
        this.m_UDP_Transport_ArtNet = null;
        this.m_ReceiverArtNet = null;
        this.m_SenderArtNet = null;
        if (o_UDP_Transport != null) {
            o_UDP_Transport.close();
        }
        if (o_ArtNetReceiver != null) {
            o_ArtNetReceiver.close();
        }
        if (o_ArtNetSender != null) {
            o_ArtNetSender.close();
        }
    }

    @Override
    public boolean disconnect() {
        this.disconnectArtNet();
        return true;
    }

    public InterfaceAddress getInterfaceAddress_ArtNet() {
        return this.m_InterfaceAddress;
    }

    public InetAddress getInetAddress_ArtNet() {
        return this.m_InetAddress_ArtNet;
    }

    public InetAddress getInetAddress_ArtNetBroadcast() {
        return this.m_InetAddress_ArtNetBroadcast;
    }

    @Override
    public InetAddress getLocalInetAddress() {
        return this.m_InetAddress_ArtNet;
    }

    @Override
    public int getConnectionStatus() {
        return this.m_ConnectionStatus_ArtNet;
    }

    public void sendArtNet_OP_Broadcast(ArtNet_Op p_ArtNet_Op) {
        if (p_ArtNet_Op == null) {
            return;
        }
        if (this.m_Enabled_ArtNet) {
            ArtNetSender o_ArtNetSender = this.m_SenderArtNet;
            if (o_ArtNetSender != null) {
                o_ArtNetSender.send(p_ArtNet_Op, this.m_InetAddress_ArtNetBroadcast, Protocols.ARTNET_PORT);
            } else {
                boolean bl = false;
            }
        }
    }

    public void sendArtNet_OP(ArtNet_Op p_ArtNet_Op, InetAddress p_RemoteAddress) {
        ArtNetSender o_ArtNetSender;
        if (p_ArtNet_Op == null) {
            return;
        }
        if (this.m_Enabled_ArtNet && (o_ArtNetSender = this.m_SenderArtNet) != null) {
            o_ArtNetSender.send(p_ArtNet_Op, p_RemoteAddress, Protocols.ARTNET_PORT);
        }
    }

    @Override
    public boolean writeValues(Protocols.ProtocolPlugInInterface p_ProtocolPlugInInterface, InetAddress p_RemoteInetAddress, int p_SequenceNumber, ArrayList<Integer> p_ChangedAddresses, int[] p_AllValues) {
        if (p_ProtocolPlugInInterface == null) {
            return false;
        }
        int intUniverseNumber = p_ProtocolPlugInInterface.getUniverseNumber();
        if (intUniverseNumber < 0) {
            return false;
        }
        ArtNetSender o_ArtNetSender = this.m_SenderArtNet;
        if (o_ArtNetSender != null) {
            ArtNet_Op_ArtDMX o_ArtNet_Op_ArtDMX = ArtNet_Op_ArtDMX.getFromPool();
            o_ArtNet_Op_ArtDMX.setPhysical((byte)0);
            o_ArtNet_Op_ArtDMX.setSequence((byte)(p_SequenceNumber & 0xFF));
            o_ArtNet_Op_ArtDMX.setUniverseNumber(intUniverseNumber);
            o_ArtNet_Op_ArtDMX.setLength(p_AllValues.length);
            o_ArtNet_Op_ArtDMX.setDMXData(p_AllValues);
            this.sendArtNet_OP(o_ArtNet_Op_ArtDMX, p_RemoteInetAddress);
            o_ArtNet_Op_ArtDMX.close();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eventReceivedArtNet_OP(ArtNet_Op p_ArtNet_Op, InetAddress p_RemoteInetAddress) {
        if (p_ArtNet_Op == null) {
            return;
        }
        if (!this.m_Enabled_ArtNet) {
            p_ArtNet_Op.close();
            return;
        }
        Object object = this.m_SyncInterpreter;
        synchronized (object) {
            ArtNetInterpreter o_ArtNetInterpreter = this.m_ArtNetInterpreter;
            if (o_ArtNetInterpreter != null) {
                o_ArtNetInterpreter.eventReceivedArtNet_OP(this, p_ArtNet_Op, p_RemoteInetAddress);
            }
        }
    }

    public static interface ArtNetInterpreter {
        public void eventReceivedArtNet_OP(ProtocolConfiguration_ArtNet var1, ArtNet_Op var2, InetAddress var3);

        public void sendArtNet_OP_Broadcast(ArtNet_Op var1);

        public void sendArtNet_OP(ArtNet_Op var1, InetAddress var2, ProtocolConfiguration_ArtNet var3);
    }
}

