/*
 * Decompiled with CFR 0.152.
 */
package ArtNetPackage;

import ArtNetPackage.ArtNet;
import ArtNetPackage.ArtNetData_Bytes;
import ArtNetPackage.ArtNet_Header;
import ArtNetPackage.ArtNet_Op;
import ProtocolPackage.Protocols;
import java.net.InetAddress;
import java.util.ArrayList;

public class ArtNet_Op_ArtPollReply
extends ArtNet_Op {
    public static int OP_SIZE = 229;
    public static final int OP_CODE = 8448;
    public static byte[] s_LiveShow_ShortNameBytes = "liveShowSoftware".getBytes(ArtNet.s_ArtNetCharset);
    public static byte[] s_LiveShow_LongNameBytes = "liveShowSoftware Controller".getBytes(ArtNet.s_ArtNetCharset);
    public static byte[] s_Filler = new byte[26];
    public static final Object s_SyncPool = new Object();
    public static ArrayList<ArtNet_Op_ArtPollReply> s_Pool = new ArrayList();
    private byte[] m_IPAddressBytes;
    private int m_Port;
    private byte m_FirmwareHigh;
    private byte m_FirmwareLow;
    private int m_Firmware;
    private byte m_Universe_Net;
    private byte m_Universe_SubSwitch;
    private byte m_PortCountHigh = 0;
    private byte m_PortCountLow = 0;
    private byte[] m_PortTypes;
    private byte[] m_SwIns;
    private byte[] m_SwOuts;
    private byte[] m_GoodInputs;
    private byte[] m_GoodOutputs;
    private byte m_OEM_High;
    private byte m_OEM_Low;
    private byte m_UEBAVersion = 0;
    private byte m_Status1 = 0;
    private byte m_Status2 = 0;
    private byte m_Status3 = 0;
    private byte[] m_GoodOutputsStatus;
    private byte m_Style;
    private byte m_EstaHigh = 0;
    private byte m_EstaLow = 0;
    private byte[] m_ShortName_Bytes;
    private String m_ShortName;
    private String m_LongName;
    private byte[] m_LongName_Bytes;
    private String m_NodeReport;
    private byte[] m_NodeReport_Bytes;
    private int m_DMXPortCount;
    private byte m_swVideo = 0;
    private byte m_swMacro = 0;
    private byte m_swRemote = 0;
    private byte[] m_MacAddress;
    private byte[] m_BindIP;
    private byte m_BindIndex;
    private byte[] m_Filler = new byte[21];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArtNet_Op_ArtPollReply getFromPool() {
        ArtNet_Op_ArtPollReply o_ArtNet_Op_ArtPollReply;
        Object object = s_SyncPool;
        synchronized (object) {
            if (s_Pool.size() > 0) {
                o_ArtNet_Op_ArtPollReply = s_Pool.get(s_Pool.size() - 1);
                s_Pool.remove(s_Pool.size() - 1);
                o_ArtNet_Op_ArtPollReply.refresh();
            } else {
                o_ArtNet_Op_ArtPollReply = new ArtNet_Op_ArtPollReply();
            }
        }
        return o_ArtNet_Op_ArtPollReply;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArtNet_Op_ArtPollReply getFromPool(ArtNet_Header p_ArtNet_Header, ArtNetData_Bytes p_ArtNetData_Bytes) {
        ArtNet_Op_ArtPollReply o_ArtNet_Op_ArtPollReply;
        Object object = s_SyncPool;
        synchronized (object) {
            if (s_Pool.size() > 0) {
                o_ArtNet_Op_ArtPollReply = s_Pool.get(s_Pool.size() - 1);
                s_Pool.remove(s_Pool.size() - 1);
                o_ArtNet_Op_ArtPollReply.refresh(p_ArtNet_Header, p_ArtNetData_Bytes);
            } else {
                o_ArtNet_Op_ArtPollReply = new ArtNet_Op_ArtPollReply(p_ArtNet_Header, p_ArtNetData_Bytes);
            }
        }
        return o_ArtNet_Op_ArtPollReply;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addToPool(ArtNet_Op_ArtPollReply p_ArtNet_Op_ArtPollReply) {
        if (p_ArtNet_Op_ArtPollReply == null) {
            return;
        }
        Object object = s_SyncPool;
        synchronized (object) {
            s_Pool.add(p_ArtNet_Op_ArtPollReply);
        }
    }

    private void initMembers() {
        int intByte;
        this.m_Port = Protocols.ARTNET_PORT;
        this.m_FirmwareHigh = 0;
        this.m_FirmwareLow = 0;
        this.m_ShortName = "";
        this.m_LongName = "";
        this.m_NodeReport = "";
        if (this.m_ShortName_Bytes == null) {
            this.m_ShortName_Bytes = new byte[18];
        }
        for (intByte = 0; intByte < 18; ++intByte) {
            this.m_ShortName_Bytes[intByte] = 0;
        }
        if (this.m_LongName_Bytes == null) {
            this.m_LongName_Bytes = new byte[64];
        }
        if (this.m_NodeReport_Bytes == null) {
            this.m_NodeReport_Bytes = new byte[64];
        }
        for (intByte = 0; intByte < 64; ++intByte) {
            this.m_LongName_Bytes[intByte] = 0;
            this.m_NodeReport_Bytes[intByte] = 0;
        }
        if (this.m_MacAddress == null) {
            this.m_MacAddress = new byte[6];
        }
        for (intByte = 0; intByte < 6; ++intByte) {
            this.m_MacAddress[intByte] = 0;
        }
        if (this.m_IPAddressBytes == null) {
            this.m_IPAddressBytes = new byte[4];
        }
        if (this.m_BindIP == null) {
            this.m_BindIP = new byte[4];
        }
        if (this.m_PortTypes == null) {
            this.m_PortTypes = new byte[4];
        }
        if (this.m_SwOuts == null) {
            this.m_SwOuts = new byte[4];
        }
        if (this.m_SwIns == null) {
            this.m_SwIns = new byte[4];
        }
        if (this.m_GoodOutputs == null) {
            this.m_GoodOutputs = new byte[4];
        }
        if (this.m_GoodInputs == null) {
            this.m_GoodInputs = new byte[4];
        }
        if (this.m_GoodOutputsStatus == null) {
            this.m_GoodOutputsStatus = new byte[4];
        }
        for (intByte = 0; intByte < 4; ++intByte) {
            this.m_IPAddressBytes[intByte] = 0;
            this.m_BindIP[intByte] = 0;
            this.m_PortTypes[intByte] = 0;
            this.m_SwOuts[intByte] = 0;
            this.m_SwIns[intByte] = 0;
            this.m_GoodOutputs[intByte] = 0;
            this.m_GoodInputs[intByte] = 0;
            this.m_GoodOutputsStatus[intByte] = 0;
        }
        this.m_Status1 = 0;
        this.m_Status2 = 0;
        this.m_Status3 = 0;
    }

    @Override
    public void close() {
        if (this.m_Closed) {
            return;
        }
        super.close();
        ArtNet_Op_ArtPollReply.addToPool(this);
    }

    public void setMacAddress(String p_MacAddress) {
        if (p_MacAddress == null) {
            return;
        }
        if (p_MacAddress.equals(this.m_MacAddress)) {
            return;
        }
        String[] macAddressParts = p_MacAddress.split(":");
        byte[] byteMacAddress = new byte[6];
        for (int i = 0; i < 6; ++i) {
            Integer hex = Integer.parseInt(macAddressParts[i], 16);
            byteMacAddress[i] = hex.byteValue();
        }
        if (byteMacAddress.equals(this.m_MacAddress)) {
            return;
        }
        System.arraycopy(byteMacAddress, 0, this.m_MacAddress, 0, 6);
        this.m_Changed = true;
    }

    public String getMacAddress() {
        if (this.m_MacAddress == null) {
            return null;
        }
        if (this.m_MacAddress.length != 6) {
            return null;
        }
        StringBuilder o_StringBuilder = new StringBuilder();
        for (int i = 0; i < this.m_MacAddress.length; ++i) {
            o_StringBuilder.append(String.format("%02X%s", this.m_MacAddress[i], i < this.m_MacAddress.length - 1 ? "-" : ""));
        }
        return o_StringBuilder.toString();
    }

    public void setShortName(String p_ShortName) {
        if (p_ShortName == null) {
            p_ShortName = "";
        }
        if (p_ShortName.equals(this.m_ShortName)) {
            return;
        }
        this.m_ShortName = p_ShortName;
        this.m_Changed = true;
    }

    public String getShortName() {
        return this.m_ShortName;
    }

    public void setLongName(String p_LongName) {
        if (p_LongName == null) {
            p_LongName = "";
        }
        if (p_LongName.equals(this.m_LongName)) {
            return;
        }
        this.m_LongName = p_LongName;
        this.m_Changed = true;
    }

    public String getLongName() {
        return this.m_LongName;
    }

    public void setRemoteInetAddress(InetAddress p_InetAddress) {
        if (p_InetAddress == null) {
            return;
        }
        String stringIP = p_InetAddress.getHostAddress();
        String[] stringIPParts = stringIP.split("\\.");
        Byte[] ipAddressBytes = new Byte[4];
        for (int i = 0; i < 4; ++i) {
            Integer integer = Integer.parseInt(stringIPParts[i]);
            ipAddressBytes[i] = integer.byteValue();
        }
        if (ipAddressBytes.equals(this.m_IPAddressBytes)) {
            return;
        }
        System.arraycopy(ipAddressBytes, 0, this.m_IPAddressBytes, 0, 4);
        this.m_Changed = true;
    }

    public InetAddress getRemoteInetAddress() {
        String stringIP = "";
        InetAddress o_InetAddress = null;
        for (int intIndex = 0; intIndex < this.m_IPAddressBytes.length; ++intIndex) {
            int intByte = 0xFF & this.m_IPAddressBytes[intIndex];
            stringIP = stringIP + "." + intByte;
        }
        try {
            o_InetAddress = InetAddress.getByAddress(this.m_IPAddressBytes);
        }
        catch (Exception e) {
            try {
                o_InetAddress = InetAddress.getByName(stringIP);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return o_InetAddress;
    }

    public void setRemotePort(int p_RemotePort) {
        if (this.m_Port == p_RemotePort) {
            return;
        }
        this.m_Port = p_RemotePort;
        this.m_Changed = true;
    }

    public int getRemotePort() {
        return this.m_Port;
    }

    public byte getFirmwareHigh() {
        return this.m_FirmwareHigh;
    }

    public byte getFirmwareLow() {
        return this.m_FirmwareLow;
    }

    public void setStatus1(byte p_Status1) {
        if (this.m_Status1 == p_Status1) {
            return;
        }
        this.m_Status1 = p_Status1;
        this.m_Changed = true;
    }

    public byte getStatus1() {
        return this.m_Status1;
    }

    public void setStatus2(byte p_Status2) {
        if (this.m_Status2 == p_Status2) {
            return;
        }
        this.m_Status2 = p_Status2;
        this.m_Changed = true;
    }

    public byte getStatus2() {
        return this.m_Status2;
    }

    public byte getUniverseNet() {
        return this.m_Universe_Net;
    }

    public byte getUniverseSubSwitch() {
        return this.m_Universe_SubSwitch;
    }

    public void setPlugInCount(int p_PluginCount) {
        if (p_PluginCount < 0) {
            p_PluginCount = 0;
        }
        this.m_PortCountLow = (byte)(p_PluginCount & 0xFF);
        this.m_PortCountLow = (byte)((p_PluginCount & 0xFF00) >> 8);
    }

    public int getPlugInCount() {
        int intPluginCount = 0;
        intPluginCount += this.m_PortCountLow & 0xFF;
        return intPluginCount += (this.m_PortCountHigh & 0xFF) << 8;
    }

    public InetAddress getBindInetAddress() {
        String stringIP = "";
        InetAddress o_InetAddress = null;
        for (int intIndex = 0; intIndex < this.m_BindIP.length; ++intIndex) {
            int intByte = 0xFF & this.m_BindIP[intIndex];
            stringIP = stringIP + "." + intByte;
        }
        try {
            o_InetAddress = InetAddress.getByAddress(this.m_BindIP);
        }
        catch (Exception e) {
            try {
                o_InetAddress = InetAddress.getByName(stringIP);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return o_InetAddress;
    }

    public int getBindIndex() {
        return this.m_BindIndex & 0xFF;
    }

    public byte[] getPortTypes() {
        return this.m_PortTypes;
    }

    public byte[] getSwOuts() {
        return this.m_SwOuts;
    }

    public byte[] getSwIns() {
        return this.m_SwIns;
    }

    public byte[] getGoodOutputs() {
        return this.m_GoodOutputs;
    }

    public byte[] getGoodInputs() {
        return this.m_GoodInputs;
    }

    public byte[] getGoodOutputsStatus() {
        return this.m_GoodOutputsStatus;
    }

    public ArtNet_Op_ArtPollReply(ArtNet_Header p_ArtNet_Header, ArtNetData_Bytes p_ArtNetData_Bytes) {
        super(8448, p_ArtNetData_Bytes);
        this.initMembers();
        this.m_ArtNet_Header = p_ArtNet_Header;
        if (this.m_ArtNet_Header != null) {
            this.m_ArtNet_Header.setArtNet_Op(this);
        }
        this.m_Valid = this.received(p_ArtNetData_Bytes);
    }

    public void refresh(ArtNet_Header p_ArtNet_Header, ArtNetData_Bytes p_ArtNetData_Bytes) {
        super.refresh(8448, p_ArtNetData_Bytes);
        this.initMembers();
        this.m_ArtNet_Header = p_ArtNet_Header;
        if (this.m_ArtNet_Header != null) {
            this.m_ArtNet_Header.setArtNet_Op(this);
        }
        this.m_Valid = this.received(p_ArtNetData_Bytes);
    }

    public boolean received(ArtNetData_Bytes p_ArtNetData_Bytes) {
        if (p_ArtNetData_Bytes == null) {
            this.m_Valid = false;
            return false;
        }
        int intOffset = 10;
        try {
            p_ArtNetData_Bytes.getByteData(intOffset, this.m_IPAddressBytes, 0, 4);
            this.m_Port = p_ArtNetData_Bytes.getInt16(intOffset += 4);
            this.m_FirmwareHigh = p_ArtNetData_Bytes.getByte(intOffset += 2);
            this.m_FirmwareLow = p_ArtNetData_Bytes.getByte(++intOffset);
            this.m_Universe_Net = p_ArtNetData_Bytes.getByte(++intOffset);
            this.m_Universe_SubSwitch = p_ArtNetData_Bytes.getByte(++intOffset);
            this.m_OEM_High = p_ArtNetData_Bytes.getByte(++intOffset);
            this.m_OEM_Low = p_ArtNetData_Bytes.getByte(++intOffset);
            this.m_UEBAVersion = p_ArtNetData_Bytes.getByte(++intOffset);
            this.m_Status1 = p_ArtNetData_Bytes.getByte(++intOffset);
            this.m_EstaLow = p_ArtNetData_Bytes.getByte(++intOffset);
            this.m_EstaHigh = p_ArtNetData_Bytes.getByte(++intOffset);
            this.m_ShortName = p_ArtNetData_Bytes.getString(++intOffset, 18);
            this.m_LongName = p_ArtNetData_Bytes.getString(intOffset += 18, 64);
            this.m_NodeReport = p_ArtNetData_Bytes.getString(intOffset += 64, 64);
            this.m_PortCountHigh = p_ArtNetData_Bytes.getByte(intOffset += 64);
            this.m_PortCountLow = p_ArtNetData_Bytes.getByte(++intOffset);
            p_ArtNetData_Bytes.getByteData(++intOffset, this.m_PortTypes, 0, 4);
            p_ArtNetData_Bytes.getByteData(intOffset += 4, this.m_GoodInputs, 0, 4);
            p_ArtNetData_Bytes.getByteData(intOffset += 4, this.m_GoodOutputs, 0, 4);
            p_ArtNetData_Bytes.getByteData(intOffset += 4, this.m_SwIns, 0, 4);
            p_ArtNetData_Bytes.getByteData(intOffset += 4, this.m_SwOuts, 0, 4);
            this.m_swVideo = p_ArtNetData_Bytes.getByte(intOffset += 4);
            this.m_swMacro = p_ArtNetData_Bytes.getByte(++intOffset);
            this.m_swRemote = p_ArtNetData_Bytes.getByte(++intOffset);
            byte byteSpare = p_ArtNetData_Bytes.getByte(++intOffset);
            byteSpare = p_ArtNetData_Bytes.getByte(++intOffset);
            byteSpare = p_ArtNetData_Bytes.getByte(++intOffset);
            this.m_Style = p_ArtNetData_Bytes.getByte(++intOffset);
            p_ArtNetData_Bytes.getByteData(++intOffset, this.m_MacAddress, 0, 6);
            p_ArtNetData_Bytes.getByteData(intOffset += 6, this.m_BindIP, 0, 4);
            this.m_BindIndex = p_ArtNetData_Bytes.getByte(intOffset += 4);
            this.m_Status2 = p_ArtNetData_Bytes.getByte(++intOffset);
            p_ArtNetData_Bytes.getByteData(++intOffset, this.m_GoodOutputsStatus, 0, 4);
            this.m_Status3 = p_ArtNetData_Bytes.getByte(intOffset += 4);
            p_ArtNetData_Bytes.getByteData(++intOffset, this.m_Filler, 0, 21);
            intOffset += 21;
            this.m_Valid = true;
        }
        catch (Exception e) {
            this.m_Valid = false;
        }
        return this.m_Valid;
    }

    public ArtNet_Op_ArtPollReply() {
        super(8448, 10 + OP_SIZE);
        this.initMembers();
        this.m_ArtNet_Header = ArtNet_Header.getFromPool(this);
    }

    public void refresh() {
        super.refresh(8448, 10 + OP_SIZE);
        this.initMembers();
        this.m_ArtNet_Header = ArtNet_Header.getFromPool(this);
    }

    @Override
    public byte[] getSendDataBytes() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ArtNet_Header getArtNet_Header() {
        return this.m_ArtNet_Header;
    }
}

