/*
 * Decompiled with CFR 0.152.
 */
package ArtNetPackage;

import ArtNetPackage.ArtNet;
import ArtNetPackage.ArtNetData_Bytes;
import ArtNetPackage.ArtNet_Op;
import ArtNetPackage.ProtocolConfiguration_ArtNet;
import NetworkTools.UDP_Transport_Broadcast;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;

public class ArtNetReceiver
implements UDP_Transport_Broadcast.UDPTransportListener {
    protected UDP_Transport_Broadcast m_UDP_Transport;
    protected ProtocolConfiguration_ArtNet m_ProtocolConfiguration_ArtNet;
    protected String m_UsedProtocol;
    protected boolean m_IsActive;
    protected final Object m_SyncUDPTransport = new Object();

    public ArtNetReceiver(ProtocolConfiguration_ArtNet p_ArtNetReceiverInterface) {
        this.initMembers();
        this.m_ProtocolConfiguration_ArtNet = p_ArtNetReceiverInterface;
    }

    private void initMembers() {
        this.m_UDP_Transport = null;
    }

    public void close() {
        this.setUDP_Transport(null);
        this.m_IsActive = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUDP_Transport(UDP_Transport_Broadcast p_UDP_Transport) {
        UDP_Transport_Broadcast o_UDP_Transport;
        Object object = this.m_SyncUDPTransport;
        synchronized (object) {
            o_UDP_Transport = this.m_UDP_Transport;
        }
        if (o_UDP_Transport != null) {
            o_UDP_Transport.removeUDPTransportListener((UDP_Transport_Broadcast.UDPTransportListener)this);
        }
        object = this.m_SyncUDPTransport;
        synchronized (object) {
            o_UDP_Transport = this.m_UDP_Transport = p_UDP_Transport;
        }
        if (o_UDP_Transport != null) {
            o_UDP_Transport.addUDPTransportListener((UDP_Transport_Broadcast.UDPTransportListener)this);
        }
    }

    public UDP_Transport_Broadcast getUDP_Transport_Broadcast() {
        return this.m_UDP_Transport;
    }

    public void setActive(boolean p_Active) {
        this.m_IsActive = p_Active;
    }

    public boolean isActive() {
        return this.m_IsActive;
    }

    public void changeProtocol(String p_Protocol) {
        this.m_UsedProtocol = p_Protocol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int eventDataReceived(DatagramPacket p_DatagramPacket) {
        int intOffset = 0;
        ArtNetData_Bytes o_ArtNetData_Bytes = null;
        o_ArtNetData_Bytes = ArtNetData_Bytes.getPoolArtNetData_Bytes(p_DatagramPacket.getLength());
        Object object = this.m_SyncUDPTransport;
        synchronized (object) {
            intOffset = this.eventDataReceived(o_ArtNetData_Bytes, p_DatagramPacket.getData(), intOffset, p_DatagramPacket.getLength());
        }
        if (o_ArtNetData_Bytes.isReceived()) {
            this.computeArtNetDataPackage(o_ArtNetData_Bytes, p_DatagramPacket.getAddress());
        }
        return intOffset;
    }

    public int eventDataReceived(ArtNetData_Bytes p_ArtNetData_Bytes, byte[] p_Data, int p_Offset, int p_Length) {
        int intNewOffset = p_Offset;
        if (p_ArtNetData_Bytes == null) {
            return intNewOffset;
        }
        intNewOffset = p_ArtNetData_Bytes.eventDataReceived(p_Data, intNewOffset, p_Length);
        return intNewOffset;
    }

    public void computeArtNetDataPackage(ArtNetData_Bytes p_ArtNetData_Bytes, InetAddress p_RemoteInetAddress) {
        if (p_ArtNetData_Bytes == null) {
            return;
        }
        ProtocolConfiguration_ArtNet o_ProtocolConfiguration_ArtNet = this.m_ProtocolConfiguration_ArtNet;
        if (o_ProtocolConfiguration_ArtNet == null) {
            return;
        }
        ArtNet_Op o_ArtNet_Op = null;
        o_ArtNet_Op = ArtNet.eventReceived(p_ArtNetData_Bytes);
        if (o_ArtNet_Op == null) {
            return;
        }
        o_ProtocolConfiguration_ArtNet.eventReceivedArtNet_OP(o_ArtNet_Op, p_RemoteInetAddress);
    }

    public void eventDataReceived(UDP_Transport_Broadcast p_UDP_Transport, DatagramPacket p_DatagramPacket, InetSocketAddress p_ReceiverInetSocketAddress) {
        if (!this.m_IsActive) {
            return;
        }
        this.eventDataReceived(p_DatagramPacket);
    }

    public void eventClosed(UDP_Transport_Broadcast p_UDP_Transport) {
        if (this.m_UDP_Transport == p_UDP_Transport) {
            this.setUDP_Transport(null);
        }
    }

    public void eventBound(UDP_Transport_Broadcast p_UDP_Transport) {
    }

    public void eventError(UDP_Transport_Broadcast p_UDP_Transport, Exception p_Exception) {
    }
}

