/*
 * Decompiled with CFR 0.152.
 */
package ACN_Direct_1_31_Package;

import java.util.ArrayList;

public class ACN_Direct_Data_Bytes {
    public static ArrayList<ACN_Direct_Data_Bytes> s_Pool = new ArrayList();
    public static final int MAX_ACN_1_31_PACKAGESIZE = 638;
    public static final Object s_SyncPool = new Object();
    public static int s_MaxPoolSize = 100;
    public static byte[] s_Empty_ByteArray = new byte[638];
    public static int s_Size_RootLayer_Header;
    public static int s_Size_RootLayer_Body;
    public static int s_Size_FramingLayer;
    public static int s_Size_DMPLayer_Header;
    protected byte[] m_Data;
    protected int m_ReceiveOffset;
    protected int m_ReceiveDataStartIndex;
    protected boolean m_IsFilled;
    protected boolean m_Closed;
    private byte[] m_PackageArray;
    public static final byte DMX512A_STARTCODE = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void poolAddEmpty(ACN_Direct_Data_Bytes p_ACN_ByteData) {
        if (p_ACN_ByteData == null) {
            return;
        }
        Object object = s_SyncPool;
        synchronized (object) {
            if (s_Pool.size() >= s_MaxPoolSize) {
                return;
            }
            s_Pool.add(p_ACN_ByteData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ACN_Direct_Data_Bytes poolGet() {
        ACN_Direct_Data_Bytes o_ACN_Direct_Data_Bytes;
        Object object = s_SyncPool;
        synchronized (object) {
            if (s_Pool.size() > 0) {
                o_ACN_Direct_Data_Bytes = s_Pool.get(s_Pool.size() - 1);
                o_ACN_Direct_Data_Bytes.refresh();
                s_Pool.remove(s_Pool.size() - 1);
            } else {
                o_ACN_Direct_Data_Bytes = new ACN_Direct_Data_Bytes();
            }
        }
        return o_ACN_Direct_Data_Bytes;
    }

    public ACN_Direct_Data_Bytes() {
        this.initMembers();
    }

    private void initMembers() {
        this.m_Data = new byte[638];
        System.arraycopy(s_Empty_ByteArray, 0, this.m_Data, 0, 638);
        this.m_ReceiveOffset = 0;
        this.m_ReceiveDataStartIndex = 0;
        this.m_IsFilled = false;
        this.m_Closed = false;
    }

    public void refresh() {
        System.arraycopy(s_Empty_ByteArray, 0, this.m_Data, 0, 638);
        this.m_ReceiveOffset = 0;
        this.m_ReceiveDataStartIndex = 0;
        this.m_IsFilled = false;
        this.m_Closed = false;
    }

    public void close() {
        if (this.m_Closed) {
            return;
        }
        this.m_Closed = true;
        ACN_Direct_Data_Bytes.poolAddEmpty(this);
    }

    public boolean isFilled() {
        return this.m_IsFilled;
    }

    public int eventDataReceived(byte[] p_Data, int p_Offset) {
        this.m_ReceiveDataStartIndex = p_Offset;
        try {
            if (!this.receiveRoot_Layer_Header(p_Data)) {
                return this.m_ReceiveDataStartIndex;
            }
            if (!this.checkRoot_Layer_ACNPacketIdentifier()) {
                return -1;
            }
            if (!this.receiveRoot_Layer_Body(p_Data)) {
                return this.m_ReceiveDataStartIndex;
            }
            if (!this.receiveFraming_Layer(p_Data)) {
                return this.m_ReceiveDataStartIndex;
            }
            if (!this.checkFraming_Layer_Vector()) {
                return -1;
            }
            if (!this.receiveDMP_Layer_Header(p_Data)) {
                return this.m_ReceiveDataStartIndex;
            }
            if (!this.checkDMP_Layer_AddressDataType()) {
                return -1;
            }
            if (!this.checkDMP_Layer_AddressIncrement()) {
                return -1;
            }
            if (!this.checkDMP_Layer_FirstPropertyAddress()) {
                return -1;
            }
            if (!this.receiveDMP_Layer_Values(p_Data)) {
                return this.m_ReceiveDataStartIndex;
            }
        }
        catch (Exception e) {
            return -1;
        }
        if (this.m_IsFilled) {
            return this.m_ReceiveDataStartIndex;
        }
        return this.m_ReceiveDataStartIndex;
    }

    private boolean receiveRoot_Layer_Header(byte[] p_Data) throws Exception {
        if (this.m_ReceiveOffset >= s_Size_RootLayer_Header) {
            return true;
        }
        if (p_Data == null) {
            return false;
        }
        int intBytesToCopy = s_Size_RootLayer_Header - this.m_ReceiveOffset;
        if (p_Data.length - this.m_ReceiveDataStartIndex < intBytesToCopy) {
            intBytesToCopy = p_Data.length - this.m_ReceiveDataStartIndex;
        }
        System.arraycopy(p_Data, this.m_ReceiveDataStartIndex, this.m_Data, this.m_ReceiveOffset, intBytesToCopy);
        this.m_ReceiveOffset += intBytesToCopy;
        this.m_ReceiveDataStartIndex += intBytesToCopy;
        return this.m_ReceiveOffset >= s_Size_RootLayer_Header;
    }

    private boolean receiveRoot_Layer_Body(byte[] p_Data) throws Exception {
        if (this.m_ReceiveOffset >= s_Size_RootLayer_Header + s_Size_RootLayer_Body) {
            return true;
        }
        if (p_Data == null) {
            return false;
        }
        int intBytesToCopy = s_Size_RootLayer_Header + s_Size_RootLayer_Body - this.m_ReceiveOffset;
        if (p_Data.length - this.m_ReceiveDataStartIndex < intBytesToCopy) {
            intBytesToCopy = p_Data.length - this.m_ReceiveDataStartIndex;
        }
        System.arraycopy(p_Data, this.m_ReceiveDataStartIndex, this.m_Data, this.m_ReceiveOffset, intBytesToCopy);
        this.m_ReceiveOffset += intBytesToCopy;
        this.m_ReceiveDataStartIndex += intBytesToCopy;
        return this.m_ReceiveOffset >= s_Size_RootLayer_Header + s_Size_RootLayer_Body;
    }

    private boolean receiveFraming_Layer(byte[] p_Data) throws Exception {
        if (this.m_ReceiveOffset >= s_Size_RootLayer_Header + s_Size_RootLayer_Body + s_Size_FramingLayer) {
            return true;
        }
        if (p_Data == null) {
            return false;
        }
        int intBytesToCopy = s_Size_RootLayer_Header + s_Size_RootLayer_Body + s_Size_FramingLayer - this.m_ReceiveOffset;
        if (p_Data.length - this.m_ReceiveDataStartIndex < intBytesToCopy) {
            intBytesToCopy = p_Data.length - this.m_ReceiveDataStartIndex;
        }
        System.arraycopy(p_Data, this.m_ReceiveDataStartIndex, this.m_Data, this.m_ReceiveOffset, intBytesToCopy);
        this.m_ReceiveOffset += intBytesToCopy;
        this.m_ReceiveDataStartIndex += intBytesToCopy;
        return this.m_ReceiveOffset >= s_Size_RootLayer_Header + s_Size_RootLayer_Body + s_Size_FramingLayer;
    }

    private boolean receiveDMP_Layer_Header(byte[] p_Data) throws Exception {
        if (this.m_ReceiveOffset >= s_Size_RootLayer_Header + s_Size_RootLayer_Body + s_Size_FramingLayer + s_Size_DMPLayer_Header) {
            return true;
        }
        if (p_Data == null) {
            return false;
        }
        int intBytesToCopy = s_Size_RootLayer_Header + s_Size_RootLayer_Body + s_Size_FramingLayer + s_Size_DMPLayer_Header - this.m_ReceiveOffset;
        if (p_Data.length - this.m_ReceiveDataStartIndex < intBytesToCopy) {
            intBytesToCopy = p_Data.length - this.m_ReceiveDataStartIndex;
        }
        System.arraycopy(p_Data, this.m_ReceiveDataStartIndex, this.m_Data, this.m_ReceiveOffset, intBytesToCopy);
        this.m_ReceiveDataStartIndex += intBytesToCopy;
        this.m_ReceiveOffset += intBytesToCopy;
        return this.m_ReceiveOffset >= s_Size_RootLayer_Header + s_Size_RootLayer_Body + s_Size_FramingLayer + s_Size_DMPLayer_Header;
    }

    private boolean receiveDMP_Layer_Values(byte[] p_Data) throws Exception {
        int intDMP_PDU_Length = this.get_FlagsLength(115);
        if (this.m_ReceiveOffset >= s_Size_RootLayer_Header + s_Size_RootLayer_Body + s_Size_FramingLayer + intDMP_PDU_Length) {
            return true;
        }
        if (p_Data == null) {
            return false;
        }
        int intBytesToCopy = s_Size_RootLayer_Header + s_Size_RootLayer_Body + s_Size_FramingLayer + intDMP_PDU_Length - this.m_ReceiveOffset;
        if (p_Data.length - this.m_ReceiveDataStartIndex < intBytesToCopy) {
            intBytesToCopy = p_Data.length - this.m_ReceiveDataStartIndex;
        }
        System.arraycopy(p_Data, this.m_ReceiveDataStartIndex, this.m_Data, this.m_ReceiveOffset, intBytesToCopy);
        this.m_ReceiveDataStartIndex += intBytesToCopy;
        this.m_ReceiveOffset += intBytesToCopy;
        if (this.m_ReceiveOffset >= s_Size_RootLayer_Header + s_Size_RootLayer_Body + s_Size_FramingLayer + intDMP_PDU_Length) {
            this.m_IsFilled = true;
            return true;
        }
        return false;
    }

    public void getDMP_Layer_DMXData(int[] p_DMXValues, int p_Length) {
        if (p_DMXValues == null) {
            return;
        }
        if (p_Length > p_DMXValues.length) {
            p_Length = p_DMXValues.length;
        }
        if (p_Length <= 0) {
            return;
        }
        int intValueCount = this.get_Integer(123);
        if (p_Length > intValueCount) {
            p_Length = intValueCount;
        }
        if ((this.m_Data[125] & 0xFF) != 0) {
            return;
        }
        this.replace_IntegerArray(p_DMXValues, 0, 126, p_Length);
    }

    public void fill_FlagsLength(int p_Length, int p_Offset) {
        if (p_Offset > this.m_Data.length - 2) {
            return;
        }
        for (int intByte = 1; intByte >= 0; --intByte) {
            this.m_Data[intByte + p_Offset] = (byte)(p_Length & 0xFF);
            p_Length >>= 8;
        }
        this.m_Data[p_Offset] = (byte)(0xF & this.m_Data[p_Offset]);
        this.m_Data[p_Offset] = (byte)(0x70 | this.m_Data[p_Offset]);
    }

    public int get_FlagsLength(int p_Offset) {
        if (p_Offset > this.m_Data.length - 2) {
            return -1;
        }
        int intResult = 0;
        intResult = this.m_Data[p_Offset] & 0xF;
        intResult <<= 8;
        return intResult += this.m_Data[p_Offset + 1] & 0xFF;
    }

    public void fill_Integer(int p_Integer, int p_Offset) {
        if (p_Integer < 0) {
            p_Integer = 0;
        }
        if (p_Offset > this.m_Data.length - 2) {
            return;
        }
        for (int intByte = 1; intByte >= 0; --intByte) {
            this.m_Data[intByte + p_Offset] = (byte)(p_Integer & 0xFF);
            p_Integer >>= 8;
        }
    }

    public int get_Integer(int p_Offset) {
        if (p_Offset > this.m_Data.length - 2) {
            return -1;
        }
        int intResult = 0;
        intResult = this.m_Data[p_Offset] & 0xFF;
        intResult <<= 8;
        return intResult += this.m_Data[p_Offset + 1] & 0xFF;
    }

    public void fill_String(String p_String, int p_Offset, int p_Length) {
        byte[] o_StringArray = null;
        int intLength = 0;
        if (p_String == null) {
            p_String = "";
        }
        try {
            o_StringArray = p_String.getBytes("UTF-8");
            intLength = o_StringArray.length;
        }
        catch (Exception e) {
            intLength = 0;
            o_StringArray = new byte[]{};
        }
        if (intLength > this.m_Data.length - p_Offset) {
            intLength = this.m_Data.length - p_Offset;
        }
        if (p_Length > this.m_Data.length - p_Offset) {
            p_Length = this.m_Data.length - p_Offset;
        }
        if (intLength >= p_Length) {
            intLength = p_Length - 1;
        }
        System.arraycopy(o_StringArray, 0, this.m_Data, p_Offset, intLength);
        for (int intByte = p_Offset + intLength; intByte < p_Offset + p_Length; ++intByte) {
            this.m_Data[intByte] = 0;
        }
    }

    public String getString(int p_Offset) {
        int intByteIndex;
        if (p_Offset >= this.m_Data.length) {
            return null;
        }
        String stringResult = "";
        int intLength = -1;
        for (intByteIndex = p_Offset; intByteIndex < this.m_Data.length && this.m_Data[intByteIndex] != 0; ++intByteIndex) {
        }
        if (intByteIndex >= this.m_Data.length) {
            return null;
        }
        intLength = intByteIndex - p_Offset;
        if (intLength <= 0) {
            return "";
        }
        try {
            stringResult = new String(this.m_Data, p_Offset, intLength, "UTF-8");
        }
        catch (Exception e) {
            return null;
        }
        return stringResult;
    }

    public int fillIntegerArray(int[] p_IntegerArray, int p_StartIndex, int p_Length, int p_Offset) {
        if (p_IntegerArray == null) {
            return -1;
        }
        if (p_Offset >= this.m_Data.length) {
            return -1;
        }
        if (p_Length < 0) {
            return -1;
        }
        int intValueCount = p_Length;
        if (p_StartIndex + p_Length > p_IntegerArray.length) {
            intValueCount = p_IntegerArray.length - p_StartIndex;
        }
        if (intValueCount > this.m_Data.length - p_Offset) {
            intValueCount = this.m_Data.length - p_Offset;
        }
        if (intValueCount <= 0) {
            return 0;
        }
        for (int intValue = 0; intValue < intValueCount; ++intValue) {
            this.m_Data[p_Offset + intValue] = (byte)(p_IntegerArray[p_StartIndex + intValue] & 0xFF);
        }
        return intValueCount;
    }

    public void fillRoot_Layer_PreambleSize() {
        this.m_Data[0] = 0;
        this.m_Data[1] = 16;
    }

    public void fillRoot_Layer_PostambleSize() {
        this.m_Data[2] = 0;
        this.m_Data[3] = 0;
    }

    public void fillRoot_Layer_ACNPacketIdentifier() {
        this.m_Data[4] = 65;
        this.m_Data[5] = 83;
        this.m_Data[6] = 67;
        this.m_Data[7] = 45;
        this.m_Data[8] = 69;
        this.m_Data[9] = 49;
        this.m_Data[10] = 46;
        this.m_Data[11] = 49;
        this.m_Data[12] = 55;
        this.m_Data[13] = 0;
        this.m_Data[14] = 0;
        this.m_Data[15] = 0;
    }

    public boolean checkRoot_Layer_ACNPacketIdentifier() {
        if ((this.m_Data[4] & 0xFF) != 65) {
            return false;
        }
        if ((this.m_Data[5] & 0xFF) != 83) {
            return false;
        }
        if ((this.m_Data[6] & 0xFF) != 67) {
            return false;
        }
        if ((this.m_Data[7] & 0xFF) != 45) {
            return false;
        }
        if ((this.m_Data[8] & 0xFF) != 69) {
            return false;
        }
        if ((this.m_Data[9] & 0xFF) != 49) {
            return false;
        }
        if ((this.m_Data[10] & 0xFF) != 46) {
            return false;
        }
        if ((this.m_Data[11] & 0xFF) != 49) {
            return false;
        }
        if ((this.m_Data[12] & 0xFF) != 55) {
            return false;
        }
        if ((this.m_Data[13] & 0xFF) != 0) {
            return false;
        }
        if ((this.m_Data[14] & 0xFF) != 0) {
            return false;
        }
        return (this.m_Data[15] & 0xFF) == 0;
    }

    public void fillRoot_Layer_FlagsLength(int p_Length) {
        this.fill_FlagsLength(p_Length, 16);
    }

    public int getRoot_Layer_FlagsLength() {
        return this.get_FlagsLength(16);
    }

    public void fillRoot_Layer_Vector() {
        this.m_Data[18] = 0;
        this.m_Data[19] = 0;
        this.m_Data[20] = 0;
        this.m_Data[21] = 4;
    }

    public boolean checkRoot_Layer_Vector() {
        if ((this.m_Data[18] & 0xFF) != 0) {
            return false;
        }
        if ((this.m_Data[19] & 0xFF) != 0) {
            return false;
        }
        if ((this.m_Data[20] & 0xFF) != 0) {
            return false;
        }
        return (this.m_Data[21] & 0xFF) == 4;
    }

    public void fillRoot_Layer_CID(String p_CID) {
        this.fill_String(p_CID, 22, 16);
    }

    public void fillRoot_Layer_CID(byte[] p_CIDBytes) {
        if (p_CIDBytes == null) {
            for (int intByteIndex = 22; intByteIndex < 38; ++intByteIndex) {
                this.m_Data[intByteIndex] = 0;
            }
            return;
        }
        int intLength = p_CIDBytes.length;
        if (intLength > 16) {
            intLength = 16;
        }
        System.arraycopy(p_CIDBytes, 0, this.m_Data, 22, intLength);
        for (int intByteIndex = 22 + intLength; intByteIndex < 38; ++intByteIndex) {
            this.m_Data[intByteIndex] = 0;
        }
    }

    public byte[] getRoot_Layer_CID(byte[] p_CIDBytes) {
        if (p_CIDBytes == null || p_CIDBytes.length != 16) {
            p_CIDBytes = new byte[16];
        }
        System.arraycopy(this.m_Data, 22, p_CIDBytes, 0, 16);
        return p_CIDBytes;
    }

    public void fillFraming_Layer_FlagsLength(int p_Length) {
        this.fill_FlagsLength(p_Length, 38);
    }

    public int getFraming_Layer_FlagsLength() {
        return this.get_FlagsLength(38);
    }

    public void fillFraming_Layer_Vector() {
        this.m_Data[40] = 0;
        this.m_Data[41] = 0;
        this.m_Data[42] = 0;
        this.m_Data[43] = 2;
    }

    public boolean checkFraming_Layer_Vector() {
        if ((this.m_Data[40] & 0xFF) != 0) {
            return false;
        }
        if ((this.m_Data[41] & 0xFF) != 0) {
            return false;
        }
        if ((this.m_Data[42] & 0xFF) != 0) {
            return false;
        }
        return (this.m_Data[43] & 0xFF) == 2;
    }

    public void fillFraming_Layer_SourceName(String p_String) {
        this.fill_String(p_String, 44, 64);
    }

    public String getFraming_Layer_SourceName() {
        return this.getString(44);
    }

    public void fillFraming_Layer_Priority(Integer p_Priority) {
        if (p_Priority == null) {
            p_Priority = 100;
        }
        if (p_Priority < 0) {
            p_Priority = 0;
        }
        if (p_Priority > 200) {
            p_Priority = 200;
        }
        this.m_Data[108] = (byte)(p_Priority & 0xFF);
    }

    public int getFraming_Layer_Priority() {
        return this.m_Data[108] & 0xFF;
    }

    public void fillFRaming_Layer_Reserved() {
        this.m_Data[109] = 0;
        this.m_Data[110] = 0;
    }

    public void fillFraming_Layer_SequenceNumber(int p_SequenceNumber) {
        if (p_SequenceNumber < 0) {
            p_SequenceNumber = 0;
        }
        if (p_SequenceNumber > 255) {
            p_SequenceNumber = 255;
        }
        this.m_Data[111] = (byte)(p_SequenceNumber & 0xFF);
    }

    public int getFraming_Layer_SequenceNumbery() {
        return this.m_Data[111] & 0xFF;
    }

    public void fillFraming_Layer_Options(byte p_Options) {
        this.m_Data[112] = p_Options;
    }

    public byte getFraming_Layer_Options() {
        return this.m_Data[112];
    }

    public void fillFraming_Layer_UniverseNumber(int p_UniverseNumber) {
        if (p_UniverseNumber < 1) {
            p_UniverseNumber = 0;
        }
        if (p_UniverseNumber > 65535) {
            p_UniverseNumber = 0;
        }
        this.fill_Integer(p_UniverseNumber, 113);
    }

    public int getFraming_Layer_UniverseNumber() {
        return this.get_Integer(113);
    }

    public void fillDMP_Layer_FlagsLength(int p_Length) {
        this.fill_FlagsLength(p_Length, 115);
    }

    public int getDMP_Layer_FlagsLength() {
        return this.get_FlagsLength(115);
    }

    public void fillDMP_Layer_Vector() {
        this.m_Data[117] = 2;
    }

    public boolean checkDMP_Layer_Vector() {
        return (this.m_Data[117] & 0xFF) == 2;
    }

    public void fillDMP_Layer_AddressDataType() {
        this.m_Data[118] = -95;
    }

    public boolean checkDMP_Layer_AddressDataType() {
        return (this.m_Data[118] & 0xFF) == 161;
    }

    public void fillDMP_Layer_FirstPropertyAddress() {
        this.m_Data[119] = 0;
        this.m_Data[120] = 0;
    }

    public boolean checkDMP_Layer_FirstPropertyAddress() {
        if ((this.m_Data[119] & 0xFF) != 0) {
            return false;
        }
        return (this.m_Data[120] & 0xFF) == 0;
    }

    public void fillDMP_Layer_AddressIncrement() {
        this.m_Data[121] = 0;
        this.m_Data[122] = 1;
    }

    public boolean checkDMP_Layer_AddressIncrement() {
        if ((this.m_Data[121] & 0xFF) != 0) {
            return false;
        }
        return (this.m_Data[122] & 0xFF) == 1;
    }

    public void fillDMP_Layer_PropertyValueCount(int p_ValueCount) {
        this.fill_Integer(p_ValueCount, 123);
    }

    public int getDMP_Layer_PropertyValueCount() {
        return this.get_Integer(123);
    }

    public int fillDMP_Layer_DMXValues(int[] p_Values, int p_Length) {
        int intValueCount;
        if (p_Values == null) {
            intValueCount = 0;
        } else {
            if (p_Values.length <= 0) {
                intValueCount = 0;
            }
            intValueCount = p_Values.length > 512 ? 512 : p_Values.length;
        }
        if (p_Length < 0) {
            p_Length = 0;
        }
        if (p_Length > intValueCount) {
            p_Length = intValueCount;
        }
        this.m_Data[125] = 0;
        if (p_Length <= 0) {
            return 0;
        }
        intValueCount = this.fillIntegerArray(p_Values, 0, p_Length, 126);
        if (intValueCount < 0) {
            return 0;
        }
        return intValueCount;
    }

    public boolean replace_IntegerArray(int[] p_DestIntegerArray, int p_DestOffset, int p_Offset, int p_Length) {
        if (p_DestIntegerArray == null) {
            return false;
        }
        int intBytesToCopy = p_Length;
        if (intBytesToCopy > this.m_Data.length - p_Offset) {
            intBytesToCopy = this.m_Data.length - p_Offset;
        }
        if (p_DestOffset >= p_DestIntegerArray.length) {
            return false;
        }
        if (intBytesToCopy > p_DestIntegerArray.length - p_DestOffset) {
            intBytesToCopy = p_DestIntegerArray.length - p_DestOffset;
        }
        if (intBytesToCopy <= 0) {
            return false;
        }
        for (int intByte = 0; intByte < intBytesToCopy; ++intByte) {
            p_DestIntegerArray[intByte + p_DestOffset] = this.m_Data[p_Offset + intByte] & 0xFF;
        }
        return true;
    }

    public boolean fill_Send_DMXValues(int p_SequenceNumber, byte[] p_CID, String p_SourceName, int p_UniverseNumber, int[] p_Values, int p_Length) {
        this.fillRoot_Layer_ACNPacketIdentifier();
        this.fillRoot_Layer_CID(p_CID);
        this.fillRoot_Layer_PostambleSize();
        this.fillRoot_Layer_PreambleSize();
        this.fillRoot_Layer_Vector();
        this.fillFRaming_Layer_Reserved();
        this.fillFraming_Layer_Options((byte)0);
        this.fillFraming_Layer_Priority(null);
        this.fillFraming_Layer_SequenceNumber(p_SequenceNumber);
        this.fillFraming_Layer_SourceName(p_SourceName);
        this.fillFraming_Layer_UniverseNumber(p_UniverseNumber);
        this.fillFraming_Layer_Vector();
        this.fillDMP_Layer_AddressDataType();
        this.fillDMP_Layer_AddressIncrement();
        this.fillDMP_Layer_FirstPropertyAddress();
        this.fillDMP_Layer_Vector();
        int intValuesFilled = this.fillDMP_Layer_DMXValues(p_Values, p_Length);
        if (intValuesFilled < 0) {
            return false;
        }
        int intLength = intValuesFilled + 1;
        this.fillDMP_Layer_PropertyValueCount(intLength);
        this.fillDMP_Layer_FlagsLength(intLength += 10);
        this.fillFraming_Layer_FlagsLength(intLength += 77);
        this.fillRoot_Layer_FlagsLength(intLength += 22);
        this.m_IsFilled = true;
        return true;
    }

    public boolean fill_Send_TerminateTransfer(int p_SequenceNumber, byte[] p_CID, String p_SourceName, int p_UniverseNumber) {
        this.fillRoot_Layer_ACNPacketIdentifier();
        this.fillRoot_Layer_CID(p_CID);
        this.fillRoot_Layer_PostambleSize();
        this.fillRoot_Layer_PreambleSize();
        this.fillRoot_Layer_Vector();
        this.fillFRaming_Layer_Reserved();
        this.fillFraming_Layer_Options((byte)64);
        this.fillFraming_Layer_Priority(null);
        this.fillFraming_Layer_SequenceNumber(p_SequenceNumber);
        this.fillFraming_Layer_SourceName(p_SourceName);
        this.fillFraming_Layer_UniverseNumber(p_UniverseNumber);
        this.fillFraming_Layer_Vector();
        this.fillDMP_Layer_AddressDataType();
        this.fillDMP_Layer_AddressIncrement();
        this.fillDMP_Layer_FirstPropertyAddress();
        this.fillDMP_Layer_Vector();
        int intValuesFilled = this.fillDMP_Layer_DMXValues(null, 0);
        if (intValuesFilled < 0) {
            return false;
        }
        int intLength = intValuesFilled + 1;
        this.fillDMP_Layer_PropertyValueCount(intLength);
        this.fillDMP_Layer_FlagsLength(intLength += 10);
        this.fillFraming_Layer_FlagsLength(intLength += 77);
        this.fillRoot_Layer_FlagsLength(intLength += 22);
        this.m_IsFilled = true;
        return true;
    }

    public int getPackageLength() {
        if (!this.m_IsFilled) {
            return -1;
        }
        int intLength = this.getRoot_Layer_FlagsLength() + 16;
        return intLength;
    }

    public byte[] createPackageArray() {
        int intSize = this.getPackageLength();
        if (intSize == 638) {
            this.m_PackageArray = this.m_Data;
        } else if (this.m_PackageArray == null || this.m_PackageArray.length != intSize) {
            this.m_PackageArray = new byte[intSize];
            System.arraycopy(this.m_Data, 0, this.m_PackageArray, 0, intSize);
        }
        return this.m_PackageArray;
    }

    static {
        for (int intByte = 0; intByte < 638; ++intByte) {
            ACN_Direct_Data_Bytes.s_Empty_ByteArray[intByte] = 0;
        }
        s_Size_RootLayer_Header = 16;
        s_Size_RootLayer_Body = 22;
        s_Size_FramingLayer = 77;
        s_Size_DMPLayer_Header = 10;
    }
}

